﻿#ifndef LIBRETRO_CORE_OPTIONS_INTL_H__
#define LIBRETRO_CORE_OPTIONS_INTL_H__

#if defined(_MSC_VER) && (_MSC_VER >= 1500 && _MSC_VER < 1900)
/* https://support.microsoft.com/en-us/kb/980263 */
#pragma execution_character_set("utf-8")
#pragma warning(disable:4566)
#endif

#include <libretro.h>

#include "libretro_options.h"

/*
 ********************************
 * VERSION: 1.3
 ********************************
 *
 * - 1.3: Move translations to libretro_core_options_intl.h
 *        - libretro_core_options_intl.h includes BOM and utf-8
 *          fix for MSVC 2010-2013
 *        - Added HAVE_NO_LANGEXTRA flag to disable translations
 *          on platforms/compilers without BOM support
 * - 1.2: Use core options v1 interface when
 *        RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION is >= 1
 *        (previously required RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION == 1)
 * - 1.1: Support generation of core options v0 retro_core_option_value
 *        arrays containing options with a single value
 * - 1.0: First commit
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 ********************************
 * Core Option Definitions
 ********************************
*/
/* RETRO_LANGUAGE_AR */

#define CATEGORY_VIDEO_LABEL_AR "فيديو"
#define CATEGORY_VIDEO_INFO_0_AR NULL
#define CATEGORY_OSD_LABEL_AR "العرض على الشاشة"
#define CATEGORY_OSD_INFO_0_AR NULL
#define CATEGORY_INPUT_LABEL_AR "الإدخال"
#define CATEGORY_INPUT_INFO_0_AR NULL
#define CATEGORY_MEMCARDS_LABEL_AR "بطاقة الذاكرة"
#define CATEGORY_MEMCARDS_INFO_0_AR NULL
#define CATEGORY_PGXP_LABEL_AR NULL
#define CATEGORY_PGXP_INFO_0_AR NULL
#define CATEGORY_HACKS_LABEL_AR NULL
#define CATEGORY_HACKS_INFO_0_AR NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_AR NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_AR NULL
#define OPTION_VAL_1X_NATIVE_AR "1x (أصلي)"
#define OPTION_VAL_2X_AR NULL
#define OPTION_VAL_4X_AR NULL
#define OPTION_VAL_8X_AR NULL
#define OPTION_VAL_16X_AR NULL
#define BEETLE_OPT_DEPTH_LABEL_AR NULL
#define BEETLE_OPT_DEPTH_INFO_0_AR NULL
#define OPTION_VAL_16BPP_NATIVE_AR NULL
#define OPTION_VAL_32BPP_AR NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_AR NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_AR NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_AR NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_AR NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_AR NULL
#define BEETLE_OPT_FILTER_LABEL_AR NULL
#define BEETLE_OPT_FILTER_INFO_0_AR NULL
#define OPTION_VAL_NEAREST_AR "أقرب"
#define OPTION_VAL_SABR_AR NULL
#define OPTION_VAL_XBR_AR NULL
#define OPTION_VAL_BILINEAR_AR "ثنائي"
#define OPTION_VAL_3_POINT_AR NULL
#define OPTION_VAL_JINC2_AR NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_AR NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_AR NULL
#define OPTION_VAL_OPAQUE_AR NULL
#define OPTION_VAL_ALL_AR NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_AR NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_AR NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_AR NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_AR NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_AR NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_AR NULL
#define BEETLE_OPT_MSAA_LABEL_AR NULL
#define BEETLE_OPT_MSAA_INFO_0_AR NULL
#define OPTION_VAL_1X_AR NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_AR NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_AR NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_AR NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_AR NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_AR NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_AR NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_AR NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_AR NULL
#define BEETLE_OPT_WIREFRAME_LABEL_AR NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_AR NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_AR NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_AR NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_AR NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_AR NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_AR NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_AR NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_AR NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_AR NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_AR NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_AR NULL
#define OPTION_VAL_ENABLED_ANALOG_AR NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_AR NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_AR NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_AR NULL
#define OPTION_VAL_L1_R1_SELECT_AR NULL
#define OPTION_VAL_L1_R1_START_AR NULL
#define OPTION_VAL_L1_R1_L3_AR NULL
#define OPTION_VAL_L1_R1_R3_AR NULL
#define OPTION_VAL_L2_R2_SELECT_AR NULL
#define OPTION_VAL_L2_R2_START_AR NULL
#define OPTION_VAL_L2_R2_L3_AR NULL
#define OPTION_VAL_L2_R2_R3_AR NULL
#define OPTION_VAL_L3_R3_AR NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_AR NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_AR NULL
#define OPTION_VAL_0_AR NULL
#define OPTION_VAL_1_AR NULL
#define OPTION_VAL_2_AR NULL
#define OPTION_VAL_3_AR NULL
#define OPTION_VAL_4_AR NULL
#define OPTION_VAL_5_AR NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_AR NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_AR NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_AR NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_AR NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_AR NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_AR NULL
#define OPTION_VAL_LIGHTGUN_AR NULL
#define OPTION_VAL_TOUCHSCREEN_AR NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_AR NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_AR NULL
#define OPTION_VAL_CROSS_AR NULL
#define OPTION_VAL_DOT_AR NULL
#define OPTION_VAL_OFF_AR NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_AR NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_AR NULL
#define OPTION_VAL_RED_AR "أحمر"
#define OPTION_VAL_BLUE_AR "أزرق"
#define OPTION_VAL_GREEN_AR "أخضر"
#define OPTION_VAL_ORANGE_AR NULL
#define OPTION_VAL_YELLOW_AR "أصفر"
#define OPTION_VAL_CYAN_AR NULL
#define OPTION_VAL_PINK_AR NULL
#define OPTION_VAL_PURPLE_AR NULL
#define OPTION_VAL_BLACK_AR NULL
#define OPTION_VAL_WHITE_AR NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_AR NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_AR NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_AR NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_AR NULL
#define OPTION_VAL_5_O28_AR NULL
#define OPTION_VAL_10_AR NULL
#define OPTION_VAL_15_AR NULL
#define OPTION_VAL_20_AR NULL
#define OPTION_VAL_25_AR NULL
#define OPTION_VAL_30_AR NULL
#define OPTION_VAL_35_AR NULL
#define OPTION_VAL_40_AR NULL
#define OPTION_VAL_45_AR NULL
#define OPTION_VAL_50_AR NULL
#define OPTION_VAL_55_AR NULL
#define OPTION_VAL_60_AR NULL
#define OPTION_VAL_65_AR NULL
#define OPTION_VAL_70_AR NULL
#define OPTION_VAL_75_AR NULL
#define OPTION_VAL_80_AR NULL
#define OPTION_VAL_85_AR NULL
#define OPTION_VAL_90_AR NULL
#define OPTION_VAL_95_AR NULL
#define OPTION_VAL_100_AR NULL
#define OPTION_VAL_105_AR NULL
#define OPTION_VAL_110_AR NULL
#define OPTION_VAL_115_AR NULL
#define OPTION_VAL_120_AR NULL
#define OPTION_VAL_125_AR NULL
#define OPTION_VAL_130_AR NULL
#define OPTION_VAL_135_AR NULL
#define OPTION_VAL_140_AR NULL
#define OPTION_VAL_145_AR NULL
#define OPTION_VAL_150_AR NULL
#define OPTION_VAL_155_AR NULL
#define OPTION_VAL_160_AR NULL
#define OPTION_VAL_165_AR NULL
#define OPTION_VAL_170_AR NULL
#define OPTION_VAL_175_AR NULL
#define OPTION_VAL_180_AR NULL
#define OPTION_VAL_185_AR NULL
#define OPTION_VAL_190_AR NULL
#define OPTION_VAL_195_AR NULL
#define OPTION_VAL_200_AR NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_AR NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_AR NULL
#define OPTION_VAL_LINEAR_AR "خطي"
#define OPTION_VAL_QUADRATIC_AR NULL
#define OPTION_VAL_CUBIC_AR NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_AR NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_AR NULL
#define OPTION_VAL_0_O30_AR NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_AR NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_AR NULL
#define OPTION_VAL_LIBRETRO_AR NULL
#define OPTION_VAL_MEDNAFEN_AR NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_AR NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_AR NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_AR NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_AR NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_AR NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_AR NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_AR NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_AR NULL
#define OPTION_VAL_1_O35_AR NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_AR NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_AR NULL
#define OPTION_VAL_MEMORY_ONLY_AR NULL
#define OPTION_VAL_MEMORY_CPU_AR NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_AR NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_AR NULL
#define OPTION_VAL_0PX_AR NULL
#define OPTION_VAL_1PX_AR NULL
#define OPTION_VAL_2PX_AR NULL
#define OPTION_VAL_3PX_AR NULL
#define OPTION_VAL_4PX_AR NULL
#define OPTION_VAL_5PX_AR NULL
#define OPTION_VAL_6PX_AR NULL
#define OPTION_VAL_7PX_AR NULL
#define OPTION_VAL_8PX_AR NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_AR NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_AR NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_AR NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_AR NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_AR NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_AR NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_AR NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_AR NULL
#define OPTION_VAL_DEFAULT_AR NULL
#define OPTION_VAL_AGGRESSIVE_AR NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_AR NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_AR NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_AR NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_AR NULL
#define OPTION_VAL_16_9_AR NULL
#define OPTION_VAL_16_10_AR NULL
#define OPTION_VAL_18_9_AR NULL
#define OPTION_VAL_19_9_AR NULL
#define OPTION_VAL_20_9_AR NULL
#define OPTION_VAL_21_9_AR NULL
#define OPTION_VAL_32_9_AR NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_AR NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_AR NULL
#define OPTION_VAL_100_NATIVE_AR NULL
#define OPTION_VAL_210_AR NULL
#define OPTION_VAL_220_AR NULL
#define OPTION_VAL_230_AR NULL
#define OPTION_VAL_240_AR NULL
#define OPTION_VAL_250_AR NULL
#define OPTION_VAL_260_AR NULL
#define OPTION_VAL_270_AR NULL
#define OPTION_VAL_280_AR NULL
#define OPTION_VAL_290_AR NULL
#define OPTION_VAL_300_AR NULL
#define OPTION_VAL_310_AR NULL
#define OPTION_VAL_320_AR NULL
#define OPTION_VAL_330_AR NULL
#define OPTION_VAL_340_AR NULL
#define OPTION_VAL_350_AR NULL
#define OPTION_VAL_360_AR NULL
#define OPTION_VAL_370_AR NULL
#define OPTION_VAL_380_AR NULL
#define OPTION_VAL_390_AR NULL
#define OPTION_VAL_400_AR NULL
#define OPTION_VAL_410_AR NULL
#define OPTION_VAL_420_AR NULL
#define OPTION_VAL_430_AR NULL
#define OPTION_VAL_440_AR NULL
#define OPTION_VAL_450_AR NULL
#define OPTION_VAL_460_AR NULL
#define OPTION_VAL_470_AR NULL
#define OPTION_VAL_480_AR NULL
#define OPTION_VAL_490_AR NULL
#define OPTION_VAL_500_AR NULL
#define OPTION_VAL_510_AR NULL
#define OPTION_VAL_520_AR NULL
#define OPTION_VAL_530_AR NULL
#define OPTION_VAL_540_AR NULL
#define OPTION_VAL_550_AR NULL
#define OPTION_VAL_560_AR NULL
#define OPTION_VAL_570_AR NULL
#define OPTION_VAL_580_AR NULL
#define OPTION_VAL_590_AR NULL
#define OPTION_VAL_600_AR NULL
#define OPTION_VAL_610_AR NULL
#define OPTION_VAL_620_AR NULL
#define OPTION_VAL_630_AR NULL
#define OPTION_VAL_640_AR NULL
#define OPTION_VAL_650_AR NULL
#define OPTION_VAL_660_AR NULL
#define OPTION_VAL_670_AR NULL
#define OPTION_VAL_680_AR NULL
#define OPTION_VAL_690_AR NULL
#define OPTION_VAL_700_AR NULL
#define OPTION_VAL_710_AR NULL
#define OPTION_VAL_720_AR NULL
#define OPTION_VAL_730_AR NULL
#define OPTION_VAL_740_AR NULL
#define OPTION_VAL_750_AR NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_AR NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_AR NULL
#define OPTION_VAL_32X_AR NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_AR NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_AR NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_AR NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_AR NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_AR NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_AR NULL
#define OPTION_VAL_PSXONPSP_AR NULL
#define OPTION_VAL_PS1_ROM_AR NULL
#define BEETLE_OPT_RENDERER_LABEL_AR NULL
#define BEETLE_OPT_RENDERER_INFO_0_AR NULL
#define OPTION_VAL_HARDWARE_AR NULL
#define OPTION_VAL_HARDWARE_GL_AR NULL
#define OPTION_VAL_HARDWARE_VK_AR NULL
#define OPTION_VAL_SOFTWARE_AR NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_AR NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_AR NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_AR NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_AR NULL
#define OPTION_VAL_DISABLED_AR NULL
#define OPTION_VAL_EXECUTE_AR NULL
#define OPTION_VAL_EXECUTE_ONE_AR NULL
#define OPTION_VAL_RUN_INTERPRETER_AR NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_AR NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_AR NULL
#define OPTION_VAL_FULL_AR NULL
#define OPTION_VAL_DMA_AR NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_AR NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_AR NULL
#define OPTION_VAL_128_AR NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_AR NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_AR NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_AR NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_AR NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_AR NULL
#define OPTION_VAL_FORCE_INTERLACED_AR NULL
#define OPTION_VAL_AUTO_TOGGLE_AR NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_AR NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_AR NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_AR NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_AR NULL
#define OPTION_VAL_CORRECTED_AR NULL
#define OPTION_VAL_UNCORRECTED_AR NULL
#define OPTION_VAL_4_3_AR NULL
#define OPTION_VAL_NTSC_AR NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_AR NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_AR NULL
#define OPTION_VAL_DISABLED_O58_AR "لاشيء"
#define OPTION_VAL_STATIC_AR NULL
#define OPTION_VAL_SMART_AR NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_AR NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_AR NULL
#define OPTION_VAL_9PX_AR NULL
#define OPTION_VAL_10PX_AR NULL
#define OPTION_VAL_11PX_AR NULL
#define OPTION_VAL_12PX_AR NULL
#define OPTION_VAL_13PX_AR NULL
#define OPTION_VAL_14PX_AR NULL
#define OPTION_VAL_15PX_AR NULL
#define OPTION_VAL_16PX_AR NULL
#define OPTION_VAL_17PX_AR NULL
#define OPTION_VAL_18PX_AR NULL
#define OPTION_VAL_19PX_AR NULL
#define OPTION_VAL_20PX_AR NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_AR NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_AR NULL
#define OPTION_VAL_12PX_O60_AR NULL
#define OPTION_VAL_11PX_O60_AR NULL
#define OPTION_VAL_10PX_O60_AR NULL
#define OPTION_VAL_9PX_O60_AR NULL
#define OPTION_VAL_8PX_O60_AR NULL
#define OPTION_VAL_7PX_O60_AR NULL
#define OPTION_VAL_6PX_O60_AR NULL
#define OPTION_VAL_5PX_O60_AR NULL
#define OPTION_VAL_4PX_O60_AR NULL
#define OPTION_VAL_3PX_O60_AR NULL
#define OPTION_VAL_2PX_O60_AR NULL
#define OPTION_VAL_1PX_O60_AR NULL
#define OPTION_VAL_1PX_O60_0_AR NULL
#define OPTION_VAL_2PX_O60_0_AR NULL
#define OPTION_VAL_3PX_O60_0_AR NULL
#define OPTION_VAL_4PX_O60_0_AR NULL
#define OPTION_VAL_5PX_O60_0_AR NULL
#define OPTION_VAL_6PX_O60_0_AR NULL
#define OPTION_VAL_7PX_O60_0_AR NULL
#define OPTION_VAL_8PX_O60_0_AR NULL
#define OPTION_VAL_9PX_O60_0_AR NULL
#define OPTION_VAL_10PX_O60_0_AR NULL
#define OPTION_VAL_11PX_O60_0_AR NULL
#define OPTION_VAL_12PX_O60_0_AR NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_AR NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_AR NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_AR NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_AR NULL
#define OPTION_VAL_0_O62_AR NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_AR NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_AR NULL
#define OPTION_VAL_239_AR NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_AR NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_AR NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_AR NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_AR NULL
#define OPTION_VAL_287_AR NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_AR NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_AR NULL
#define OPTION_VAL_SYNC_AR NULL
#define OPTION_VAL_ASYNC_AR NULL
#define OPTION_VAL_PRECACHE_AR NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_AR NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_AR NULL
#define OPTION_VAL_2X_NATIVE_AR NULL
#define OPTION_VAL_6X_AR NULL
#define OPTION_VAL_10X_AR NULL
#define OPTION_VAL_12X_AR NULL
#define OPTION_VAL_14X_AR NULL

struct retro_core_option_v2_category option_cats_ar[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_AR,
      CATEGORY_VIDEO_INFO_0_AR
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_AR,
      CATEGORY_OSD_INFO_0_AR
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AR,
      CATEGORY_INPUT_INFO_0_AR
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_AR,
      CATEGORY_MEMCARDS_INFO_0_AR
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_AR,
      CATEGORY_PGXP_INFO_0_AR
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AR,
      CATEGORY_HACKS_INFO_0_AR
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ar[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_AR,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_AR,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_AR },
         { "2x",         OPTION_VAL_2X_AR },
         { "4x",         OPTION_VAL_4X_AR },
         { "8x",         OPTION_VAL_8X_AR },
         { "16x",        OPTION_VAL_16X_AR },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_AR,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_AR,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_AR },
         { "32bpp",         OPTION_VAL_32BPP_AR },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_AR,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_AR,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_AR },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_AR },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_AR,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_AR,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_AR,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_AR,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_AR },
         { "SABR",     OPTION_VAL_SABR_AR },
         { "xBR",      OPTION_VAL_XBR_AR },
         { "bilinear", OPTION_VAL_BILINEAR_AR },
         { "3-point",  OPTION_VAL_3_POINT_AR },
         { "JINC2",    OPTION_VAL_JINC2_AR },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_AR,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_AR },
         { "all", OPTION_VAL_ALL_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_AR,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_AR },
         { "all", OPTION_VAL_ALL_AR },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_AR,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_AR,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_AR,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_AR,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_AR },
         { "2x",  OPTION_VAL_2X_AR },
         { "4x",  OPTION_VAL_4X_AR },
         { "8x",  OPTION_VAL_8X_AR },
         { "16x", OPTION_VAL_16X_AR },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_AR,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_AR,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_AR,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_AR,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_AR,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_AR,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_AR,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_AR,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_AR,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_AR,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_AR,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_AR,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_AR,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_AR,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_AR },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_AR },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_AR },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_AR },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_AR },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_AR },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_AR },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_AR },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_AR },
         { "l3+r3",                    OPTION_VAL_L3_R3_AR },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_AR,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_AR,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_AR },
         { "1", OPTION_VAL_1_AR },
         { "2", OPTION_VAL_2_AR },
         { "3", OPTION_VAL_3_AR },
         { "4", OPTION_VAL_4_AR },
         { "5", OPTION_VAL_5_AR },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_AR,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_AR,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_AR,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_AR,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_AR },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_AR },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_AR,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_AR,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_AR },
         { "dot",   OPTION_VAL_DOT_AR },
         { "off",   OPTION_VAL_OFF_AR },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_AR,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_AR,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_AR },
         { "blue", OPTION_VAL_BLUE_AR },
         { "green", OPTION_VAL_GREEN_AR },
         { "orange", OPTION_VAL_ORANGE_AR },
         { "yellow", OPTION_VAL_YELLOW_AR },
         { "cyan", OPTION_VAL_CYAN_AR },
         { "pink", OPTION_VAL_PINK_AR },
         { "purple", OPTION_VAL_PURPLE_AR },
         { "black", OPTION_VAL_BLACK_AR },
         { "white", OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_AR,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_AR,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_AR },
         { "red", OPTION_VAL_RED_AR },
         { "green", OPTION_VAL_GREEN_AR },
         { "orange", OPTION_VAL_ORANGE_AR },
         { "yellow", OPTION_VAL_YELLOW_AR },
         { "cyan", OPTION_VAL_CYAN_AR },
         { "pink", OPTION_VAL_PINK_AR },
         { "purple", OPTION_VAL_PURPLE_AR },
         { "black", OPTION_VAL_BLACK_AR },
         { "white", OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_AR,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_AR,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_AR },
         { "10%",  OPTION_VAL_10_AR },
         { "15%",  OPTION_VAL_15_AR },
         { "20%",  OPTION_VAL_20_AR },
         { "25%",  OPTION_VAL_25_AR },
         { "30%",  OPTION_VAL_30_AR },
         { "35%",  OPTION_VAL_35_AR },
         { "40%",  OPTION_VAL_40_AR },
         { "45%",  OPTION_VAL_45_AR },
         { "50%",  OPTION_VAL_50_AR },
         { "55%",  OPTION_VAL_55_AR },
         { "60%",  OPTION_VAL_60_AR },
         { "65%",  OPTION_VAL_65_AR },
         { "70%",  OPTION_VAL_70_AR },
         { "75%",  OPTION_VAL_75_AR },
         { "80%",  OPTION_VAL_80_AR },
         { "85%",  OPTION_VAL_85_AR },
         { "90%",  OPTION_VAL_90_AR },
         { "95%",  OPTION_VAL_95_AR },
         { "100%", OPTION_VAL_100_AR },
         { "105%", OPTION_VAL_105_AR },
         { "110%", OPTION_VAL_110_AR },
         { "115%", OPTION_VAL_115_AR },
         { "120%", OPTION_VAL_120_AR },
         { "125%", OPTION_VAL_125_AR },
         { "130%", OPTION_VAL_130_AR },
         { "135%", OPTION_VAL_135_AR },
         { "140%", OPTION_VAL_140_AR },
         { "145%", OPTION_VAL_145_AR },
         { "150%", OPTION_VAL_150_AR },
         { "155%", OPTION_VAL_155_AR },
         { "160%", OPTION_VAL_160_AR },
         { "165%", OPTION_VAL_165_AR },
         { "170%", OPTION_VAL_170_AR },
         { "175%", OPTION_VAL_175_AR },
         { "180%", OPTION_VAL_180_AR },
         { "185%", OPTION_VAL_185_AR },
         { "190%", OPTION_VAL_190_AR },
         { "195%", OPTION_VAL_195_AR },
         { "200%", OPTION_VAL_200_AR },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_AR,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_AR,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_AR },
         { "quadratic", OPTION_VAL_QUADRATIC_AR },
         { "cubic",     OPTION_VAL_CUBIC_AR },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_AR,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_AR,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_AR },
         { "5%",  OPTION_VAL_5_O28_AR },
         { "10%", OPTION_VAL_10_AR },
         { "15%", OPTION_VAL_15_AR },
         { "20%", OPTION_VAL_20_AR },
         { "25%", OPTION_VAL_25_AR },
         { "30%", OPTION_VAL_30_AR },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_AR,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_AR,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_AR },
         { "mednafen", OPTION_VAL_MEDNAFEN_AR },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_AR,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_AR,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_AR,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_AR,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_AR,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_AR,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_AR,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_AR,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_AR },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_AR,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_AR,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_AR },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_AR,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_AR,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_AR },
         { "1px", OPTION_VAL_1PX_AR },
         { "2px", OPTION_VAL_2PX_AR },
         { "3px", OPTION_VAL_3PX_AR },
         { "4px", OPTION_VAL_4PX_AR },
         { "5px", OPTION_VAL_5PX_AR },
         { "6px", OPTION_VAL_6PX_AR },
         { "7px", OPTION_VAL_7PX_AR },
         { "8px", OPTION_VAL_8PX_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_AR,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_AR,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_AR,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_AR,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_AR,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_AR,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_AR,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_AR },
         { "aggressive", OPTION_VAL_AGGRESSIVE_AR },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_AR,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_AR,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_AR },
         { "16:10", OPTION_VAL_16_10_AR },
         { "18:9",  OPTION_VAL_18_9_AR },
         { "19:9",  OPTION_VAL_19_9_AR },
         { "20:9",  OPTION_VAL_20_9_AR },
         { "21:9",  OPTION_VAL_21_9_AR }, // 64:27
         { "32:9",  OPTION_VAL_32_9_AR },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_AR,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_AR },
         { "60%",           OPTION_VAL_60_AR },
         { "70%",           OPTION_VAL_70_AR },
         { "80%",           OPTION_VAL_80_AR },
         { "90%",           OPTION_VAL_90_AR },
         { "100%(native)", OPTION_VAL_100_NATIVE_AR },
         { "110%",          OPTION_VAL_110_AR },
         { "120%",          OPTION_VAL_120_AR },
         { "130%",          OPTION_VAL_130_AR },
         { "140%",          OPTION_VAL_140_AR },
         { "150%",          OPTION_VAL_150_AR },
         { "160%",          OPTION_VAL_160_AR },
         { "170%",          OPTION_VAL_170_AR },
         { "180%",          OPTION_VAL_180_AR },
         { "190%",          OPTION_VAL_190_AR },
         { "200%",          OPTION_VAL_200_AR },
         { "210%",          OPTION_VAL_210_AR },
         { "220%",          OPTION_VAL_220_AR },
         { "230%",          OPTION_VAL_230_AR },
         { "240%",          OPTION_VAL_240_AR },
         { "250%",          OPTION_VAL_250_AR },
         { "260%",          OPTION_VAL_260_AR },
         { "270%",          OPTION_VAL_270_AR },
         { "280%",          OPTION_VAL_280_AR },
         { "290%",          OPTION_VAL_290_AR },
         { "300%",          OPTION_VAL_300_AR },
         { "310%",          OPTION_VAL_310_AR },
         { "320%",          OPTION_VAL_320_AR },
         { "330%",          OPTION_VAL_330_AR },
         { "340%",          OPTION_VAL_340_AR },
         { "350%",          OPTION_VAL_350_AR },
         { "360%",          OPTION_VAL_360_AR },
         { "370%",          OPTION_VAL_370_AR },
         { "380%",          OPTION_VAL_380_AR },
         { "390%",          OPTION_VAL_390_AR },
         { "400%",          OPTION_VAL_400_AR },
         { "410%",          OPTION_VAL_410_AR },
         { "420%",          OPTION_VAL_420_AR },
         { "430%",          OPTION_VAL_430_AR },
         { "440%",          OPTION_VAL_440_AR },
         { "450%",          OPTION_VAL_450_AR },
         { "460%",          OPTION_VAL_460_AR },
         { "470%",          OPTION_VAL_470_AR },
         { "480%",          OPTION_VAL_480_AR },
         { "490%",          OPTION_VAL_490_AR },
         { "500%",          OPTION_VAL_500_AR },
         { "510%",          OPTION_VAL_510_AR },
         { "520%",          OPTION_VAL_520_AR },
         { "530%",          OPTION_VAL_530_AR },
         { "540%",          OPTION_VAL_540_AR },
         { "550%",          OPTION_VAL_550_AR },
         { "560%",          OPTION_VAL_560_AR },
         { "570%",          OPTION_VAL_570_AR },
         { "580%",          OPTION_VAL_580_AR },
         { "590%",          OPTION_VAL_590_AR },
         { "600%",          OPTION_VAL_600_AR },
         { "610%",          OPTION_VAL_610_AR },
         { "620%",          OPTION_VAL_620_AR },
         { "630%",          OPTION_VAL_630_AR },
         { "640%",          OPTION_VAL_640_AR },
         { "650%",          OPTION_VAL_650_AR },
         { "660%",          OPTION_VAL_660_AR },
         { "670%",          OPTION_VAL_670_AR },
         { "680%",          OPTION_VAL_680_AR },
         { "690%",          OPTION_VAL_690_AR },
         { "700%",          OPTION_VAL_700_AR },
         { "710%",          OPTION_VAL_710_AR },
         { "720%",          OPTION_VAL_720_AR },
         { "730%",          OPTION_VAL_730_AR },
         { "740%",          OPTION_VAL_740_AR },
         { "750%",          OPTION_VAL_750_AR },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_AR,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_AR },
         { "2x",         OPTION_VAL_2X_AR },
         { "4x",         OPTION_VAL_4X_AR },
         { "8x",         OPTION_VAL_8X_AR },
         { "16x",        OPTION_VAL_16X_AR },
         { "32x",        OPTION_VAL_32X_AR },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_AR,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_AR,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_AR,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_AR },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_AR },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_AR,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_AR,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_AR },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_AR },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_AR },
#endif
         { "software",    OPTION_VAL_SOFTWARE_AR },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_AR,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_AR,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_AR,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_AR,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_AR },
         { "execute",  OPTION_VAL_EXECUTE_AR },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_AR },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_AR,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_AR,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_AR },
         { "dma",  OPTION_VAL_DMA_AR },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_AR,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_AR },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_AR,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_AR },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_AR,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_AR,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_AR },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_AR },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_AR },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_AR,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_AR,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_AR,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_AR },
         { "uncorrected", OPTION_VAL_UNCORRECTED_AR },
         { "4:3",  OPTION_VAL_4_3_AR },
         { "ntsc", OPTION_VAL_NTSC_AR },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_AR,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_AR },
         { "static",  OPTION_VAL_STATIC_AR },
         { "smart", OPTION_VAL_SMART_AR },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_AR,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_AR },
         { "2px",      OPTION_VAL_2PX_AR },
         { "3px",      OPTION_VAL_3PX_AR },
         { "4px",      OPTION_VAL_4PX_AR },
         { "5px",      OPTION_VAL_5PX_AR },
         { "6px",      OPTION_VAL_6PX_AR },
         { "7px",      OPTION_VAL_7PX_AR },
         { "8px",      OPTION_VAL_8PX_AR },
         { "9px",      OPTION_VAL_9PX_AR },
         { "10px",     OPTION_VAL_10PX_AR },
         { "11px",     OPTION_VAL_11PX_AR },
         { "12px",     OPTION_VAL_12PX_AR },
         { "13px",     OPTION_VAL_13PX_AR },
         { "14px",     OPTION_VAL_14PX_AR },
         { "15px",     OPTION_VAL_15PX_AR },
         { "16px",     OPTION_VAL_16PX_AR },
         { "17px",     OPTION_VAL_17PX_AR },
         { "18px",     OPTION_VAL_18PX_AR },
         { "19px",     OPTION_VAL_19PX_AR },
         { "20px",     OPTION_VAL_20PX_AR },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_AR,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_AR,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_AR },
         { "-11px",    OPTION_VAL_11PX_O60_AR },
         { "-10px",    OPTION_VAL_10PX_O60_AR },
         { "-9px",     OPTION_VAL_9PX_O60_AR },
         { "-8px",     OPTION_VAL_8PX_O60_AR },
         { "-7px",     OPTION_VAL_7PX_O60_AR },
         { "-6px",     OPTION_VAL_6PX_O60_AR },
         { "-5px",     OPTION_VAL_5PX_O60_AR },
         { "-4px",     OPTION_VAL_4PX_O60_AR },
         { "-3px",     OPTION_VAL_3PX_O60_AR },
         { "-2px",     OPTION_VAL_2PX_O60_AR },
         { "-1px",     OPTION_VAL_1PX_O60_AR },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_AR },
         { "+2px",     OPTION_VAL_2PX_O60_0_AR },
         { "+3px",     OPTION_VAL_3PX_O60_0_AR },
         { "+4px",     OPTION_VAL_4PX_O60_0_AR },
         { "+5px",     OPTION_VAL_5PX_O60_0_AR },
         { "+6px",     OPTION_VAL_6PX_O60_0_AR },
         { "+7px",     OPTION_VAL_7PX_O60_0_AR },
         { "+8px",     OPTION_VAL_8PX_O60_0_AR },
         { "+9px",     OPTION_VAL_9PX_O60_0_AR },
         { "+10px",    OPTION_VAL_10PX_O60_0_AR },
         { "+11px",    OPTION_VAL_11PX_O60_0_AR },
         { "+12px",    OPTION_VAL_12PX_O60_0_AR },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_AR,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_AR,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_AR,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_AR,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_AR },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_AR,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_AR,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_AR },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_AR,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_AR,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_AR },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_AR,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_AR,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_AR },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_AR,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_AR,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_AR },
         { "async",    OPTION_VAL_ASYNC_AR },
         { "precache", OPTION_VAL_PRECACHE_AR },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_AR,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_AR,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_AR },
         { "4x",          OPTION_VAL_4X_AR },
         { "6x",          OPTION_VAL_6X_AR },
         { "8x",          OPTION_VAL_8X_AR },
         { "10x",         OPTION_VAL_10X_AR },
         { "12x",         OPTION_VAL_12X_AR },
         { "14x",         OPTION_VAL_14X_AR },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ar = {
   option_cats_ar,
   option_defs_ar
};

/* RETRO_LANGUAGE_AST */

#define CATEGORY_VIDEO_LABEL_AST "Videu"
#define CATEGORY_VIDEO_INFO_0_AST NULL
#define CATEGORY_OSD_LABEL_AST NULL
#define CATEGORY_OSD_INFO_0_AST NULL
#define CATEGORY_INPUT_LABEL_AST "Entrada"
#define CATEGORY_INPUT_INFO_0_AST NULL
#define CATEGORY_MEMCARDS_LABEL_AST "Tarxeta de memoria"
#define CATEGORY_MEMCARDS_INFO_0_AST NULL
#define CATEGORY_PGXP_LABEL_AST NULL
#define CATEGORY_PGXP_INFO_0_AST NULL
#define CATEGORY_HACKS_LABEL_AST "Hacks de la emulación"
#define CATEGORY_HACKS_INFO_0_AST NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_AST NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_AST NULL
#define OPTION_VAL_1X_NATIVE_AST NULL
#define OPTION_VAL_2X_AST "x2"
#define OPTION_VAL_4X_AST "x4"
#define OPTION_VAL_8X_AST "x8"
#define OPTION_VAL_16X_AST "x16"
#define BEETLE_OPT_DEPTH_LABEL_AST NULL
#define BEETLE_OPT_DEPTH_INFO_0_AST NULL
#define OPTION_VAL_16BPP_NATIVE_AST NULL
#define OPTION_VAL_32BPP_AST NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_AST NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_AST NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_AST "Resolución interna"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_AST NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_AST NULL
#define BEETLE_OPT_FILTER_LABEL_AST NULL
#define BEETLE_OPT_FILTER_INFO_0_AST NULL
#define OPTION_VAL_NEAREST_AST NULL
#define OPTION_VAL_SABR_AST NULL
#define OPTION_VAL_XBR_AST NULL
#define OPTION_VAL_BILINEAR_AST "Billinial"
#define OPTION_VAL_3_POINT_AST NULL
#define OPTION_VAL_JINC2_AST NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_AST NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_AST NULL
#define OPTION_VAL_OPAQUE_AST NULL
#define OPTION_VAL_ALL_AST NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_AST NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_AST NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_AST NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_AST NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_AST NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_AST NULL
#define BEETLE_OPT_MSAA_LABEL_AST NULL
#define BEETLE_OPT_MSAA_INFO_0_AST NULL
#define OPTION_VAL_1X_AST "x1"
#define BEETLE_OPT_MDEC_YUV_LABEL_AST NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_AST NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_AST NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_AST NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_AST NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_AST NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_AST NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_AST NULL
#define BEETLE_OPT_WIREFRAME_LABEL_AST NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_AST NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_AST NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_AST NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_AST NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_AST NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_AST NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_AST NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_AST NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_AST NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_AST NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_AST NULL
#define OPTION_VAL_ENABLED_ANALOG_AST NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_AST NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_AST NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_AST NULL
#define OPTION_VAL_L1_R1_SELECT_AST NULL
#define OPTION_VAL_L1_R1_START_AST NULL
#define OPTION_VAL_L1_R1_L3_AST NULL
#define OPTION_VAL_L1_R1_R3_AST NULL
#define OPTION_VAL_L2_R2_SELECT_AST NULL
#define OPTION_VAL_L2_R2_START_AST NULL
#define OPTION_VAL_L2_R2_L3_AST NULL
#define OPTION_VAL_L2_R2_R3_AST NULL
#define OPTION_VAL_L3_R3_AST NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_AST NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_AST NULL
#define OPTION_VAL_0_AST NULL
#define OPTION_VAL_1_AST NULL
#define OPTION_VAL_2_AST NULL
#define OPTION_VAL_3_AST NULL
#define OPTION_VAL_4_AST NULL
#define OPTION_VAL_5_AST NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_AST NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_AST NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_AST NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_AST NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_AST NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_AST NULL
#define OPTION_VAL_LIGHTGUN_AST NULL
#define OPTION_VAL_TOUCHSCREEN_AST "Pantalla táctil"
#define BEETLE_OPT_GUN_CURSOR_LABEL_AST NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_AST NULL
#define OPTION_VAL_CROSS_AST NULL
#define OPTION_VAL_DOT_AST NULL
#define OPTION_VAL_OFF_AST NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_AST NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_AST NULL
#define OPTION_VAL_RED_AST "Coloráu"
#define OPTION_VAL_BLUE_AST "Azul"
#define OPTION_VAL_GREEN_AST "Verde"
#define OPTION_VAL_ORANGE_AST "Naranxa"
#define OPTION_VAL_YELLOW_AST "Mariellu"
#define OPTION_VAL_CYAN_AST "Cianu"
#define OPTION_VAL_PINK_AST "Rosa"
#define OPTION_VAL_PURPLE_AST "Moráu"
#define OPTION_VAL_BLACK_AST "Prietu"
#define OPTION_VAL_WHITE_AST "Blancu"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_AST NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_AST NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_AST "Sensibilidá del mur"
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_AST NULL
#define OPTION_VAL_5_O28_AST NULL
#define OPTION_VAL_10_AST NULL
#define OPTION_VAL_15_AST NULL
#define OPTION_VAL_20_AST NULL
#define OPTION_VAL_25_AST NULL
#define OPTION_VAL_30_AST NULL
#define OPTION_VAL_35_AST NULL
#define OPTION_VAL_40_AST NULL
#define OPTION_VAL_45_AST NULL
#define OPTION_VAL_50_AST NULL
#define OPTION_VAL_55_AST NULL
#define OPTION_VAL_60_AST NULL
#define OPTION_VAL_65_AST NULL
#define OPTION_VAL_70_AST NULL
#define OPTION_VAL_75_AST NULL
#define OPTION_VAL_80_AST NULL
#define OPTION_VAL_85_AST NULL
#define OPTION_VAL_90_AST NULL
#define OPTION_VAL_95_AST NULL
#define OPTION_VAL_100_AST "100% (Por defeutu)"
#define OPTION_VAL_105_AST NULL
#define OPTION_VAL_110_AST NULL
#define OPTION_VAL_115_AST NULL
#define OPTION_VAL_120_AST NULL
#define OPTION_VAL_125_AST NULL
#define OPTION_VAL_130_AST NULL
#define OPTION_VAL_135_AST NULL
#define OPTION_VAL_140_AST NULL
#define OPTION_VAL_145_AST NULL
#define OPTION_VAL_150_AST NULL
#define OPTION_VAL_155_AST NULL
#define OPTION_VAL_160_AST NULL
#define OPTION_VAL_165_AST NULL
#define OPTION_VAL_170_AST NULL
#define OPTION_VAL_175_AST NULL
#define OPTION_VAL_180_AST NULL
#define OPTION_VAL_185_AST NULL
#define OPTION_VAL_190_AST NULL
#define OPTION_VAL_195_AST NULL
#define OPTION_VAL_200_AST NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_AST NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_AST NULL
#define OPTION_VAL_LINEAR_AST NULL
#define OPTION_VAL_QUADRATIC_AST NULL
#define OPTION_VAL_CUBIC_AST NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_AST NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_AST NULL
#define OPTION_VAL_0_O30_AST NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_AST NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_AST NULL
#define OPTION_VAL_LIBRETRO_AST NULL
#define OPTION_VAL_MEDNAFEN_AST NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_AST NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_AST NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_AST NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_AST NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_AST NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_AST NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_AST NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_AST NULL
#define OPTION_VAL_1_O35_AST NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_AST NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_AST NULL
#define OPTION_VAL_MEMORY_ONLY_AST NULL
#define OPTION_VAL_MEMORY_CPU_AST NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_AST NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_AST NULL
#define OPTION_VAL_0PX_AST NULL
#define OPTION_VAL_1PX_AST NULL
#define OPTION_VAL_2PX_AST NULL
#define OPTION_VAL_3PX_AST NULL
#define OPTION_VAL_4PX_AST NULL
#define OPTION_VAL_5PX_AST NULL
#define OPTION_VAL_6PX_AST NULL
#define OPTION_VAL_7PX_AST NULL
#define OPTION_VAL_8PX_AST NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_AST NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_AST NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_AST NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_AST NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_AST NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_AST NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_AST NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_AST NULL
#define OPTION_VAL_DEFAULT_AST NULL
#define OPTION_VAL_AGGRESSIVE_AST NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_AST NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_AST NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_AST NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_AST NULL
#define OPTION_VAL_16_9_AST NULL
#define OPTION_VAL_16_10_AST NULL
#define OPTION_VAL_18_9_AST NULL
#define OPTION_VAL_19_9_AST NULL
#define OPTION_VAL_20_9_AST NULL
#define OPTION_VAL_21_9_AST NULL
#define OPTION_VAL_32_9_AST NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_AST NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_AST NULL
#define OPTION_VAL_100_NATIVE_AST NULL
#define OPTION_VAL_210_AST NULL
#define OPTION_VAL_220_AST NULL
#define OPTION_VAL_230_AST NULL
#define OPTION_VAL_240_AST NULL
#define OPTION_VAL_250_AST NULL
#define OPTION_VAL_260_AST NULL
#define OPTION_VAL_270_AST NULL
#define OPTION_VAL_280_AST NULL
#define OPTION_VAL_290_AST NULL
#define OPTION_VAL_300_AST NULL
#define OPTION_VAL_310_AST NULL
#define OPTION_VAL_320_AST NULL
#define OPTION_VAL_330_AST NULL
#define OPTION_VAL_340_AST NULL
#define OPTION_VAL_350_AST NULL
#define OPTION_VAL_360_AST NULL
#define OPTION_VAL_370_AST NULL
#define OPTION_VAL_380_AST NULL
#define OPTION_VAL_390_AST NULL
#define OPTION_VAL_400_AST NULL
#define OPTION_VAL_410_AST NULL
#define OPTION_VAL_420_AST NULL
#define OPTION_VAL_430_AST NULL
#define OPTION_VAL_440_AST NULL
#define OPTION_VAL_450_AST NULL
#define OPTION_VAL_460_AST NULL
#define OPTION_VAL_470_AST NULL
#define OPTION_VAL_480_AST NULL
#define OPTION_VAL_490_AST NULL
#define OPTION_VAL_500_AST NULL
#define OPTION_VAL_510_AST NULL
#define OPTION_VAL_520_AST NULL
#define OPTION_VAL_530_AST NULL
#define OPTION_VAL_540_AST NULL
#define OPTION_VAL_550_AST NULL
#define OPTION_VAL_560_AST NULL
#define OPTION_VAL_570_AST NULL
#define OPTION_VAL_580_AST NULL
#define OPTION_VAL_590_AST NULL
#define OPTION_VAL_600_AST NULL
#define OPTION_VAL_610_AST NULL
#define OPTION_VAL_620_AST NULL
#define OPTION_VAL_630_AST NULL
#define OPTION_VAL_640_AST NULL
#define OPTION_VAL_650_AST NULL
#define OPTION_VAL_660_AST NULL
#define OPTION_VAL_670_AST NULL
#define OPTION_VAL_680_AST NULL
#define OPTION_VAL_690_AST NULL
#define OPTION_VAL_700_AST NULL
#define OPTION_VAL_710_AST NULL
#define OPTION_VAL_720_AST NULL
#define OPTION_VAL_730_AST NULL
#define OPTION_VAL_740_AST NULL
#define OPTION_VAL_750_AST NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_AST NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_AST NULL
#define OPTION_VAL_32X_AST "x32"
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_AST NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_AST NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_AST NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_AST "Salta l'animación d'arrique de la BIOS de PlayStation que suel apaecer al cargar conteníu. Nota: l'activación d'esta opción produz problemes de compatibilidá con dalgunos de xuegos (xuegos PAL con proteición anticopia, Saga Frontier, etc.)."
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_AST NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_AST NULL
#define OPTION_VAL_PSXONPSP_AST "BIOS de PS1 de la PSP"
#define OPTION_VAL_PS1_ROM_AST "BIOS de PS1 de la PS3"
#define BEETLE_OPT_RENDERER_LABEL_AST NULL
#define BEETLE_OPT_RENDERER_INFO_0_AST NULL
#define OPTION_VAL_HARDWARE_AST NULL
#define OPTION_VAL_HARDWARE_GL_AST NULL
#define OPTION_VAL_HARDWARE_VK_AST NULL
#define OPTION_VAL_SOFTWARE_AST NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_AST NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_AST NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_AST NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_AST NULL
#define OPTION_VAL_DISABLED_AST NULL
#define OPTION_VAL_EXECUTE_AST NULL
#define OPTION_VAL_EXECUTE_ONE_AST NULL
#define OPTION_VAL_RUN_INTERPRETER_AST NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_AST NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_AST NULL
#define OPTION_VAL_FULL_AST NULL
#define OPTION_VAL_DMA_AST NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_AST NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_AST NULL
#define OPTION_VAL_128_AST NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_AST NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_AST NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_AST NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_AST NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_AST NULL
#define OPTION_VAL_FORCE_INTERLACED_AST NULL
#define OPTION_VAL_AUTO_TOGGLE_AST NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_AST NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_AST NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_AST "Proporción d'aspeutu del nucleu"
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_AST NULL
#define OPTION_VAL_CORRECTED_AST NULL
#define OPTION_VAL_UNCORRECTED_AST NULL
#define OPTION_VAL_4_3_AST NULL
#define OPTION_VAL_NTSC_AST NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_AST NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_AST NULL
#define OPTION_VAL_DISABLED_O58_AST NULL
#define OPTION_VAL_STATIC_AST NULL
#define OPTION_VAL_SMART_AST NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_AST NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_AST NULL
#define OPTION_VAL_9PX_AST NULL
#define OPTION_VAL_10PX_AST NULL
#define OPTION_VAL_11PX_AST NULL
#define OPTION_VAL_12PX_AST NULL
#define OPTION_VAL_13PX_AST NULL
#define OPTION_VAL_14PX_AST NULL
#define OPTION_VAL_15PX_AST NULL
#define OPTION_VAL_16PX_AST NULL
#define OPTION_VAL_17PX_AST NULL
#define OPTION_VAL_18PX_AST NULL
#define OPTION_VAL_19PX_AST NULL
#define OPTION_VAL_20PX_AST NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_AST NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_AST NULL
#define OPTION_VAL_12PX_O60_AST NULL
#define OPTION_VAL_11PX_O60_AST NULL
#define OPTION_VAL_10PX_O60_AST NULL
#define OPTION_VAL_9PX_O60_AST NULL
#define OPTION_VAL_8PX_O60_AST NULL
#define OPTION_VAL_7PX_O60_AST NULL
#define OPTION_VAL_6PX_O60_AST NULL
#define OPTION_VAL_5PX_O60_AST NULL
#define OPTION_VAL_4PX_O60_AST NULL
#define OPTION_VAL_3PX_O60_AST NULL
#define OPTION_VAL_2PX_O60_AST NULL
#define OPTION_VAL_1PX_O60_AST NULL
#define OPTION_VAL_1PX_O60_0_AST NULL
#define OPTION_VAL_2PX_O60_0_AST NULL
#define OPTION_VAL_3PX_O60_0_AST NULL
#define OPTION_VAL_4PX_O60_0_AST NULL
#define OPTION_VAL_5PX_O60_0_AST NULL
#define OPTION_VAL_6PX_O60_0_AST NULL
#define OPTION_VAL_7PX_O60_0_AST NULL
#define OPTION_VAL_8PX_O60_0_AST NULL
#define OPTION_VAL_9PX_O60_0_AST NULL
#define OPTION_VAL_10PX_O60_0_AST NULL
#define OPTION_VAL_11PX_O60_0_AST NULL
#define OPTION_VAL_12PX_O60_0_AST NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_AST NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_AST NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_AST NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_AST NULL
#define OPTION_VAL_0_O62_AST NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_AST NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_AST NULL
#define OPTION_VAL_239_AST "239 (Por defeutu)"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_AST NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_AST NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_AST NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_AST NULL
#define OPTION_VAL_287_AST "287 (Por defeutu)"
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_AST "Métodu d'accesu a los CDs (ríquese reaniciar)"
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_AST NULL
#define OPTION_VAL_SYNC_AST "Síncronu"
#define OPTION_VAL_ASYNC_AST "Asíncronu"
#define OPTION_VAL_PRECACHE_AST NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_AST NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_AST NULL
#define OPTION_VAL_2X_NATIVE_AST NULL
#define OPTION_VAL_6X_AST "x6"
#define OPTION_VAL_10X_AST "x10"
#define OPTION_VAL_12X_AST "x12"
#define OPTION_VAL_14X_AST "x14"

struct retro_core_option_v2_category option_cats_ast[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_AST,
      CATEGORY_VIDEO_INFO_0_AST
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_AST,
      CATEGORY_OSD_INFO_0_AST
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AST,
      CATEGORY_INPUT_INFO_0_AST
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_AST,
      CATEGORY_MEMCARDS_INFO_0_AST
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_AST,
      CATEGORY_PGXP_INFO_0_AST
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AST,
      CATEGORY_HACKS_INFO_0_AST
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ast[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_AST,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_AST,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_AST },
         { "2x",         OPTION_VAL_2X_AST },
         { "4x",         OPTION_VAL_4X_AST },
         { "8x",         OPTION_VAL_8X_AST },
         { "16x",        OPTION_VAL_16X_AST },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_AST,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_AST,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_AST },
         { "32bpp",         OPTION_VAL_32BPP_AST },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_AST,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_AST,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_AST },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_AST },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_AST,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_AST,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_AST,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_AST,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_AST },
         { "SABR",     OPTION_VAL_SABR_AST },
         { "xBR",      OPTION_VAL_XBR_AST },
         { "bilinear", OPTION_VAL_BILINEAR_AST },
         { "3-point",  OPTION_VAL_3_POINT_AST },
         { "JINC2",    OPTION_VAL_JINC2_AST },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_AST,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_AST },
         { "all", OPTION_VAL_ALL_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_AST,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_AST },
         { "all", OPTION_VAL_ALL_AST },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_AST,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_AST,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_AST,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_AST,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_AST },
         { "2x",  OPTION_VAL_2X_AST },
         { "4x",  OPTION_VAL_4X_AST },
         { "8x",  OPTION_VAL_8X_AST },
         { "16x", OPTION_VAL_16X_AST },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_AST,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_AST,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_AST,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_AST,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_AST,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_AST,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_AST,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_AST,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_AST,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_AST,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_AST,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_AST,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_AST,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_AST,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_AST },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_AST },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_AST },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_AST },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_AST },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_AST },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_AST },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_AST },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_AST },
         { "l3+r3",                    OPTION_VAL_L3_R3_AST },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_AST,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_AST,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_AST },
         { "1", OPTION_VAL_1_AST },
         { "2", OPTION_VAL_2_AST },
         { "3", OPTION_VAL_3_AST },
         { "4", OPTION_VAL_4_AST },
         { "5", OPTION_VAL_5_AST },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_AST,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_AST,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_AST,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_AST,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_AST },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_AST },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_AST,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_AST,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_AST },
         { "dot",   OPTION_VAL_DOT_AST },
         { "off",   OPTION_VAL_OFF_AST },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_AST,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_AST,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_AST },
         { "blue", OPTION_VAL_BLUE_AST },
         { "green", OPTION_VAL_GREEN_AST },
         { "orange", OPTION_VAL_ORANGE_AST },
         { "yellow", OPTION_VAL_YELLOW_AST },
         { "cyan", OPTION_VAL_CYAN_AST },
         { "pink", OPTION_VAL_PINK_AST },
         { "purple", OPTION_VAL_PURPLE_AST },
         { "black", OPTION_VAL_BLACK_AST },
         { "white", OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_AST,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_AST,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_AST },
         { "red", OPTION_VAL_RED_AST },
         { "green", OPTION_VAL_GREEN_AST },
         { "orange", OPTION_VAL_ORANGE_AST },
         { "yellow", OPTION_VAL_YELLOW_AST },
         { "cyan", OPTION_VAL_CYAN_AST },
         { "pink", OPTION_VAL_PINK_AST },
         { "purple", OPTION_VAL_PURPLE_AST },
         { "black", OPTION_VAL_BLACK_AST },
         { "white", OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_AST,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_AST,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_AST },
         { "10%",  OPTION_VAL_10_AST },
         { "15%",  OPTION_VAL_15_AST },
         { "20%",  OPTION_VAL_20_AST },
         { "25%",  OPTION_VAL_25_AST },
         { "30%",  OPTION_VAL_30_AST },
         { "35%",  OPTION_VAL_35_AST },
         { "40%",  OPTION_VAL_40_AST },
         { "45%",  OPTION_VAL_45_AST },
         { "50%",  OPTION_VAL_50_AST },
         { "55%",  OPTION_VAL_55_AST },
         { "60%",  OPTION_VAL_60_AST },
         { "65%",  OPTION_VAL_65_AST },
         { "70%",  OPTION_VAL_70_AST },
         { "75%",  OPTION_VAL_75_AST },
         { "80%",  OPTION_VAL_80_AST },
         { "85%",  OPTION_VAL_85_AST },
         { "90%",  OPTION_VAL_90_AST },
         { "95%",  OPTION_VAL_95_AST },
         { "100%", OPTION_VAL_100_AST },
         { "105%", OPTION_VAL_105_AST },
         { "110%", OPTION_VAL_110_AST },
         { "115%", OPTION_VAL_115_AST },
         { "120%", OPTION_VAL_120_AST },
         { "125%", OPTION_VAL_125_AST },
         { "130%", OPTION_VAL_130_AST },
         { "135%", OPTION_VAL_135_AST },
         { "140%", OPTION_VAL_140_AST },
         { "145%", OPTION_VAL_145_AST },
         { "150%", OPTION_VAL_150_AST },
         { "155%", OPTION_VAL_155_AST },
         { "160%", OPTION_VAL_160_AST },
         { "165%", OPTION_VAL_165_AST },
         { "170%", OPTION_VAL_170_AST },
         { "175%", OPTION_VAL_175_AST },
         { "180%", OPTION_VAL_180_AST },
         { "185%", OPTION_VAL_185_AST },
         { "190%", OPTION_VAL_190_AST },
         { "195%", OPTION_VAL_195_AST },
         { "200%", OPTION_VAL_200_AST },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_AST,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_AST,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_AST },
         { "quadratic", OPTION_VAL_QUADRATIC_AST },
         { "cubic",     OPTION_VAL_CUBIC_AST },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_AST,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_AST,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_AST },
         { "5%",  OPTION_VAL_5_O28_AST },
         { "10%", OPTION_VAL_10_AST },
         { "15%", OPTION_VAL_15_AST },
         { "20%", OPTION_VAL_20_AST },
         { "25%", OPTION_VAL_25_AST },
         { "30%", OPTION_VAL_30_AST },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_AST,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_AST,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_AST },
         { "mednafen", OPTION_VAL_MEDNAFEN_AST },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_AST,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_AST,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_AST,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_AST,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_AST,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_AST,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_AST,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_AST,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_AST },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_AST,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_AST,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_AST },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_AST,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_AST,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_AST },
         { "1px", OPTION_VAL_1PX_AST },
         { "2px", OPTION_VAL_2PX_AST },
         { "3px", OPTION_VAL_3PX_AST },
         { "4px", OPTION_VAL_4PX_AST },
         { "5px", OPTION_VAL_5PX_AST },
         { "6px", OPTION_VAL_6PX_AST },
         { "7px", OPTION_VAL_7PX_AST },
         { "8px", OPTION_VAL_8PX_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_AST,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_AST,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_AST,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_AST,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_AST,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_AST,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_AST,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_AST },
         { "aggressive", OPTION_VAL_AGGRESSIVE_AST },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_AST,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_AST,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_AST },
         { "16:10", OPTION_VAL_16_10_AST },
         { "18:9",  OPTION_VAL_18_9_AST },
         { "19:9",  OPTION_VAL_19_9_AST },
         { "20:9",  OPTION_VAL_20_9_AST },
         { "21:9",  OPTION_VAL_21_9_AST }, // 64:27
         { "32:9",  OPTION_VAL_32_9_AST },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_AST,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_AST },
         { "60%",           OPTION_VAL_60_AST },
         { "70%",           OPTION_VAL_70_AST },
         { "80%",           OPTION_VAL_80_AST },
         { "90%",           OPTION_VAL_90_AST },
         { "100%(native)", OPTION_VAL_100_NATIVE_AST },
         { "110%",          OPTION_VAL_110_AST },
         { "120%",          OPTION_VAL_120_AST },
         { "130%",          OPTION_VAL_130_AST },
         { "140%",          OPTION_VAL_140_AST },
         { "150%",          OPTION_VAL_150_AST },
         { "160%",          OPTION_VAL_160_AST },
         { "170%",          OPTION_VAL_170_AST },
         { "180%",          OPTION_VAL_180_AST },
         { "190%",          OPTION_VAL_190_AST },
         { "200%",          OPTION_VAL_200_AST },
         { "210%",          OPTION_VAL_210_AST },
         { "220%",          OPTION_VAL_220_AST },
         { "230%",          OPTION_VAL_230_AST },
         { "240%",          OPTION_VAL_240_AST },
         { "250%",          OPTION_VAL_250_AST },
         { "260%",          OPTION_VAL_260_AST },
         { "270%",          OPTION_VAL_270_AST },
         { "280%",          OPTION_VAL_280_AST },
         { "290%",          OPTION_VAL_290_AST },
         { "300%",          OPTION_VAL_300_AST },
         { "310%",          OPTION_VAL_310_AST },
         { "320%",          OPTION_VAL_320_AST },
         { "330%",          OPTION_VAL_330_AST },
         { "340%",          OPTION_VAL_340_AST },
         { "350%",          OPTION_VAL_350_AST },
         { "360%",          OPTION_VAL_360_AST },
         { "370%",          OPTION_VAL_370_AST },
         { "380%",          OPTION_VAL_380_AST },
         { "390%",          OPTION_VAL_390_AST },
         { "400%",          OPTION_VAL_400_AST },
         { "410%",          OPTION_VAL_410_AST },
         { "420%",          OPTION_VAL_420_AST },
         { "430%",          OPTION_VAL_430_AST },
         { "440%",          OPTION_VAL_440_AST },
         { "450%",          OPTION_VAL_450_AST },
         { "460%",          OPTION_VAL_460_AST },
         { "470%",          OPTION_VAL_470_AST },
         { "480%",          OPTION_VAL_480_AST },
         { "490%",          OPTION_VAL_490_AST },
         { "500%",          OPTION_VAL_500_AST },
         { "510%",          OPTION_VAL_510_AST },
         { "520%",          OPTION_VAL_520_AST },
         { "530%",          OPTION_VAL_530_AST },
         { "540%",          OPTION_VAL_540_AST },
         { "550%",          OPTION_VAL_550_AST },
         { "560%",          OPTION_VAL_560_AST },
         { "570%",          OPTION_VAL_570_AST },
         { "580%",          OPTION_VAL_580_AST },
         { "590%",          OPTION_VAL_590_AST },
         { "600%",          OPTION_VAL_600_AST },
         { "610%",          OPTION_VAL_610_AST },
         { "620%",          OPTION_VAL_620_AST },
         { "630%",          OPTION_VAL_630_AST },
         { "640%",          OPTION_VAL_640_AST },
         { "650%",          OPTION_VAL_650_AST },
         { "660%",          OPTION_VAL_660_AST },
         { "670%",          OPTION_VAL_670_AST },
         { "680%",          OPTION_VAL_680_AST },
         { "690%",          OPTION_VAL_690_AST },
         { "700%",          OPTION_VAL_700_AST },
         { "710%",          OPTION_VAL_710_AST },
         { "720%",          OPTION_VAL_720_AST },
         { "730%",          OPTION_VAL_730_AST },
         { "740%",          OPTION_VAL_740_AST },
         { "750%",          OPTION_VAL_750_AST },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_AST,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_AST },
         { "2x",         OPTION_VAL_2X_AST },
         { "4x",         OPTION_VAL_4X_AST },
         { "8x",         OPTION_VAL_8X_AST },
         { "16x",        OPTION_VAL_16X_AST },
         { "32x",        OPTION_VAL_32X_AST },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_AST,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_AST,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_AST,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_AST },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_AST },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_AST,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_AST,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_AST },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_AST },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_AST },
#endif
         { "software",    OPTION_VAL_SOFTWARE_AST },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_AST,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_AST,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_AST,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_AST,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_AST },
         { "execute",  OPTION_VAL_EXECUTE_AST },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_AST },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_AST,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_AST,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_AST },
         { "dma",  OPTION_VAL_DMA_AST },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_AST,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_AST },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_AST,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_AST },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_AST,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_AST,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_AST },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_AST },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_AST },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_AST,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_AST,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_AST,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_AST },
         { "uncorrected", OPTION_VAL_UNCORRECTED_AST },
         { "4:3",  OPTION_VAL_4_3_AST },
         { "ntsc", OPTION_VAL_NTSC_AST },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_AST,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_AST },
         { "static",  OPTION_VAL_STATIC_AST },
         { "smart", OPTION_VAL_SMART_AST },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_AST,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_AST },
         { "2px",      OPTION_VAL_2PX_AST },
         { "3px",      OPTION_VAL_3PX_AST },
         { "4px",      OPTION_VAL_4PX_AST },
         { "5px",      OPTION_VAL_5PX_AST },
         { "6px",      OPTION_VAL_6PX_AST },
         { "7px",      OPTION_VAL_7PX_AST },
         { "8px",      OPTION_VAL_8PX_AST },
         { "9px",      OPTION_VAL_9PX_AST },
         { "10px",     OPTION_VAL_10PX_AST },
         { "11px",     OPTION_VAL_11PX_AST },
         { "12px",     OPTION_VAL_12PX_AST },
         { "13px",     OPTION_VAL_13PX_AST },
         { "14px",     OPTION_VAL_14PX_AST },
         { "15px",     OPTION_VAL_15PX_AST },
         { "16px",     OPTION_VAL_16PX_AST },
         { "17px",     OPTION_VAL_17PX_AST },
         { "18px",     OPTION_VAL_18PX_AST },
         { "19px",     OPTION_VAL_19PX_AST },
         { "20px",     OPTION_VAL_20PX_AST },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_AST,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_AST,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_AST },
         { "-11px",    OPTION_VAL_11PX_O60_AST },
         { "-10px",    OPTION_VAL_10PX_O60_AST },
         { "-9px",     OPTION_VAL_9PX_O60_AST },
         { "-8px",     OPTION_VAL_8PX_O60_AST },
         { "-7px",     OPTION_VAL_7PX_O60_AST },
         { "-6px",     OPTION_VAL_6PX_O60_AST },
         { "-5px",     OPTION_VAL_5PX_O60_AST },
         { "-4px",     OPTION_VAL_4PX_O60_AST },
         { "-3px",     OPTION_VAL_3PX_O60_AST },
         { "-2px",     OPTION_VAL_2PX_O60_AST },
         { "-1px",     OPTION_VAL_1PX_O60_AST },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_AST },
         { "+2px",     OPTION_VAL_2PX_O60_0_AST },
         { "+3px",     OPTION_VAL_3PX_O60_0_AST },
         { "+4px",     OPTION_VAL_4PX_O60_0_AST },
         { "+5px",     OPTION_VAL_5PX_O60_0_AST },
         { "+6px",     OPTION_VAL_6PX_O60_0_AST },
         { "+7px",     OPTION_VAL_7PX_O60_0_AST },
         { "+8px",     OPTION_VAL_8PX_O60_0_AST },
         { "+9px",     OPTION_VAL_9PX_O60_0_AST },
         { "+10px",    OPTION_VAL_10PX_O60_0_AST },
         { "+11px",    OPTION_VAL_11PX_O60_0_AST },
         { "+12px",    OPTION_VAL_12PX_O60_0_AST },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_AST,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_AST,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_AST,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_AST,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_AST },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_AST,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_AST,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_AST },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_AST,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_AST,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_AST },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_AST,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_AST,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_AST },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_AST,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_AST,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_AST },
         { "async",    OPTION_VAL_ASYNC_AST },
         { "precache", OPTION_VAL_PRECACHE_AST },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_AST,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_AST,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_AST },
         { "4x",          OPTION_VAL_4X_AST },
         { "6x",          OPTION_VAL_6X_AST },
         { "8x",          OPTION_VAL_8X_AST },
         { "10x",         OPTION_VAL_10X_AST },
         { "12x",         OPTION_VAL_12X_AST },
         { "14x",         OPTION_VAL_14X_AST },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ast = {
   option_cats_ast,
   option_defs_ast
};

/* RETRO_LANGUAGE_BE */

#define CATEGORY_VIDEO_LABEL_BE "Відэа"
#define CATEGORY_VIDEO_INFO_0_BE NULL
#define CATEGORY_OSD_LABEL_BE "Адлюстраванне на экране"
#define CATEGORY_OSD_INFO_0_BE NULL
#define CATEGORY_INPUT_LABEL_BE "Увод"
#define CATEGORY_INPUT_INFO_0_BE NULL
#define CATEGORY_MEMCARDS_LABEL_BE NULL
#define CATEGORY_MEMCARDS_INFO_0_BE NULL
#define CATEGORY_PGXP_LABEL_BE NULL
#define CATEGORY_PGXP_INFO_0_BE NULL
#define CATEGORY_HACKS_LABEL_BE NULL
#define CATEGORY_HACKS_INFO_0_BE NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_BE NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_BE NULL
#define OPTION_VAL_1X_NATIVE_BE NULL
#define OPTION_VAL_2X_BE NULL
#define OPTION_VAL_4X_BE NULL
#define OPTION_VAL_8X_BE NULL
#define OPTION_VAL_16X_BE NULL
#define BEETLE_OPT_DEPTH_LABEL_BE NULL
#define BEETLE_OPT_DEPTH_INFO_0_BE NULL
#define OPTION_VAL_16BPP_NATIVE_BE NULL
#define OPTION_VAL_32BPP_BE NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_BE NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_BE NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_BE NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_BE NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_BE NULL
#define BEETLE_OPT_FILTER_LABEL_BE NULL
#define BEETLE_OPT_FILTER_INFO_0_BE NULL
#define OPTION_VAL_NEAREST_BE NULL
#define OPTION_VAL_SABR_BE NULL
#define OPTION_VAL_XBR_BE NULL
#define OPTION_VAL_BILINEAR_BE "Білінейны"
#define OPTION_VAL_3_POINT_BE NULL
#define OPTION_VAL_JINC2_BE NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_BE NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_BE NULL
#define OPTION_VAL_OPAQUE_BE NULL
#define OPTION_VAL_ALL_BE NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_BE NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_BE NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_BE NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_BE NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_BE NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_BE NULL
#define BEETLE_OPT_MSAA_LABEL_BE NULL
#define BEETLE_OPT_MSAA_INFO_0_BE NULL
#define OPTION_VAL_1X_BE NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_BE NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_BE NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_BE NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_BE NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_BE NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_BE NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_BE NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_BE NULL
#define BEETLE_OPT_WIREFRAME_LABEL_BE NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_BE NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_BE NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_BE NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_BE NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_BE NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_BE NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_BE NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_BE NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_BE NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_BE NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_BE NULL
#define OPTION_VAL_ENABLED_ANALOG_BE NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_BE NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_BE NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_BE NULL
#define OPTION_VAL_L1_R1_SELECT_BE NULL
#define OPTION_VAL_L1_R1_START_BE NULL
#define OPTION_VAL_L1_R1_L3_BE NULL
#define OPTION_VAL_L1_R1_R3_BE NULL
#define OPTION_VAL_L2_R2_SELECT_BE NULL
#define OPTION_VAL_L2_R2_START_BE NULL
#define OPTION_VAL_L2_R2_L3_BE NULL
#define OPTION_VAL_L2_R2_R3_BE NULL
#define OPTION_VAL_L3_R3_BE NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_BE NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_BE NULL
#define OPTION_VAL_0_BE NULL
#define OPTION_VAL_1_BE NULL
#define OPTION_VAL_2_BE NULL
#define OPTION_VAL_3_BE NULL
#define OPTION_VAL_4_BE NULL
#define OPTION_VAL_5_BE NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_BE NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_BE NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_BE NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_BE NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_BE NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_BE NULL
#define OPTION_VAL_LIGHTGUN_BE NULL
#define OPTION_VAL_TOUCHSCREEN_BE NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_BE NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_BE NULL
#define OPTION_VAL_CROSS_BE NULL
#define OPTION_VAL_DOT_BE NULL
#define OPTION_VAL_OFF_BE NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_BE NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_BE NULL
#define OPTION_VAL_RED_BE "Чырвоная"
#define OPTION_VAL_BLUE_BE "Блакітная"
#define OPTION_VAL_GREEN_BE "Зялёная"
#define OPTION_VAL_ORANGE_BE NULL
#define OPTION_VAL_YELLOW_BE "Жоўтая"
#define OPTION_VAL_CYAN_BE NULL
#define OPTION_VAL_PINK_BE NULL
#define OPTION_VAL_PURPLE_BE NULL
#define OPTION_VAL_BLACK_BE NULL
#define OPTION_VAL_WHITE_BE NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_BE NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_BE NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_BE NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_BE NULL
#define OPTION_VAL_5_O28_BE NULL
#define OPTION_VAL_10_BE NULL
#define OPTION_VAL_15_BE NULL
#define OPTION_VAL_20_BE NULL
#define OPTION_VAL_25_BE NULL
#define OPTION_VAL_30_BE NULL
#define OPTION_VAL_35_BE NULL
#define OPTION_VAL_40_BE NULL
#define OPTION_VAL_45_BE NULL
#define OPTION_VAL_50_BE NULL
#define OPTION_VAL_55_BE NULL
#define OPTION_VAL_60_BE NULL
#define OPTION_VAL_65_BE NULL
#define OPTION_VAL_70_BE NULL
#define OPTION_VAL_75_BE NULL
#define OPTION_VAL_80_BE NULL
#define OPTION_VAL_85_BE NULL
#define OPTION_VAL_90_BE NULL
#define OPTION_VAL_95_BE NULL
#define OPTION_VAL_100_BE NULL
#define OPTION_VAL_105_BE NULL
#define OPTION_VAL_110_BE NULL
#define OPTION_VAL_115_BE NULL
#define OPTION_VAL_120_BE NULL
#define OPTION_VAL_125_BE NULL
#define OPTION_VAL_130_BE NULL
#define OPTION_VAL_135_BE NULL
#define OPTION_VAL_140_BE NULL
#define OPTION_VAL_145_BE NULL
#define OPTION_VAL_150_BE NULL
#define OPTION_VAL_155_BE NULL
#define OPTION_VAL_160_BE NULL
#define OPTION_VAL_165_BE NULL
#define OPTION_VAL_170_BE NULL
#define OPTION_VAL_175_BE NULL
#define OPTION_VAL_180_BE NULL
#define OPTION_VAL_185_BE NULL
#define OPTION_VAL_190_BE NULL
#define OPTION_VAL_195_BE NULL
#define OPTION_VAL_200_BE NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_BE NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_BE NULL
#define OPTION_VAL_LINEAR_BE NULL
#define OPTION_VAL_QUADRATIC_BE NULL
#define OPTION_VAL_CUBIC_BE NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_BE NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_BE NULL
#define OPTION_VAL_0_O30_BE NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_BE NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_BE NULL
#define OPTION_VAL_LIBRETRO_BE NULL
#define OPTION_VAL_MEDNAFEN_BE NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_BE NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_BE NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_BE NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_BE NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_BE NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_BE NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_BE NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_BE NULL
#define OPTION_VAL_1_O35_BE NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_BE NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_BE NULL
#define OPTION_VAL_MEMORY_ONLY_BE NULL
#define OPTION_VAL_MEMORY_CPU_BE NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_BE NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_BE NULL
#define OPTION_VAL_0PX_BE NULL
#define OPTION_VAL_1PX_BE NULL
#define OPTION_VAL_2PX_BE NULL
#define OPTION_VAL_3PX_BE NULL
#define OPTION_VAL_4PX_BE NULL
#define OPTION_VAL_5PX_BE NULL
#define OPTION_VAL_6PX_BE NULL
#define OPTION_VAL_7PX_BE NULL
#define OPTION_VAL_8PX_BE NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_BE NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_BE NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_BE NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_BE NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_BE NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_BE NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_BE NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_BE NULL
#define OPTION_VAL_DEFAULT_BE NULL
#define OPTION_VAL_AGGRESSIVE_BE NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_BE NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_BE NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_BE NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_BE NULL
#define OPTION_VAL_16_9_BE NULL
#define OPTION_VAL_16_10_BE NULL
#define OPTION_VAL_18_9_BE NULL
#define OPTION_VAL_19_9_BE NULL
#define OPTION_VAL_20_9_BE NULL
#define OPTION_VAL_21_9_BE NULL
#define OPTION_VAL_32_9_BE NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_BE NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_BE NULL
#define OPTION_VAL_100_NATIVE_BE NULL
#define OPTION_VAL_210_BE NULL
#define OPTION_VAL_220_BE NULL
#define OPTION_VAL_230_BE NULL
#define OPTION_VAL_240_BE NULL
#define OPTION_VAL_250_BE NULL
#define OPTION_VAL_260_BE NULL
#define OPTION_VAL_270_BE NULL
#define OPTION_VAL_280_BE NULL
#define OPTION_VAL_290_BE NULL
#define OPTION_VAL_300_BE NULL
#define OPTION_VAL_310_BE NULL
#define OPTION_VAL_320_BE NULL
#define OPTION_VAL_330_BE NULL
#define OPTION_VAL_340_BE NULL
#define OPTION_VAL_350_BE NULL
#define OPTION_VAL_360_BE NULL
#define OPTION_VAL_370_BE NULL
#define OPTION_VAL_380_BE NULL
#define OPTION_VAL_390_BE NULL
#define OPTION_VAL_400_BE NULL
#define OPTION_VAL_410_BE NULL
#define OPTION_VAL_420_BE NULL
#define OPTION_VAL_430_BE NULL
#define OPTION_VAL_440_BE NULL
#define OPTION_VAL_450_BE NULL
#define OPTION_VAL_460_BE NULL
#define OPTION_VAL_470_BE NULL
#define OPTION_VAL_480_BE NULL
#define OPTION_VAL_490_BE NULL
#define OPTION_VAL_500_BE NULL
#define OPTION_VAL_510_BE NULL
#define OPTION_VAL_520_BE NULL
#define OPTION_VAL_530_BE NULL
#define OPTION_VAL_540_BE NULL
#define OPTION_VAL_550_BE NULL
#define OPTION_VAL_560_BE NULL
#define OPTION_VAL_570_BE NULL
#define OPTION_VAL_580_BE NULL
#define OPTION_VAL_590_BE NULL
#define OPTION_VAL_600_BE NULL
#define OPTION_VAL_610_BE NULL
#define OPTION_VAL_620_BE NULL
#define OPTION_VAL_630_BE NULL
#define OPTION_VAL_640_BE NULL
#define OPTION_VAL_650_BE NULL
#define OPTION_VAL_660_BE NULL
#define OPTION_VAL_670_BE NULL
#define OPTION_VAL_680_BE NULL
#define OPTION_VAL_690_BE NULL
#define OPTION_VAL_700_BE NULL
#define OPTION_VAL_710_BE NULL
#define OPTION_VAL_720_BE NULL
#define OPTION_VAL_730_BE NULL
#define OPTION_VAL_740_BE NULL
#define OPTION_VAL_750_BE NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_BE NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_BE NULL
#define OPTION_VAL_32X_BE NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_BE NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_BE NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_BE NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_BE NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_BE NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_BE NULL
#define OPTION_VAL_PSXONPSP_BE NULL
#define OPTION_VAL_PS1_ROM_BE NULL
#define BEETLE_OPT_RENDERER_LABEL_BE NULL
#define BEETLE_OPT_RENDERER_INFO_0_BE NULL
#define OPTION_VAL_HARDWARE_BE NULL
#define OPTION_VAL_HARDWARE_GL_BE NULL
#define OPTION_VAL_HARDWARE_VK_BE NULL
#define OPTION_VAL_SOFTWARE_BE NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_BE NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_BE NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_BE NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_BE NULL
#define OPTION_VAL_DISABLED_BE NULL
#define OPTION_VAL_EXECUTE_BE NULL
#define OPTION_VAL_EXECUTE_ONE_BE NULL
#define OPTION_VAL_RUN_INTERPRETER_BE NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_BE NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_BE NULL
#define OPTION_VAL_FULL_BE NULL
#define OPTION_VAL_DMA_BE NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_BE NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_BE NULL
#define OPTION_VAL_128_BE NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_BE NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_BE NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_BE NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_BE NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_BE NULL
#define OPTION_VAL_FORCE_INTERLACED_BE NULL
#define OPTION_VAL_AUTO_TOGGLE_BE NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_BE NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_BE NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_BE NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_BE NULL
#define OPTION_VAL_CORRECTED_BE NULL
#define OPTION_VAL_UNCORRECTED_BE NULL
#define OPTION_VAL_4_3_BE NULL
#define OPTION_VAL_NTSC_BE NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_BE NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_BE NULL
#define OPTION_VAL_DISABLED_O58_BE NULL
#define OPTION_VAL_STATIC_BE NULL
#define OPTION_VAL_SMART_BE NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_BE NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_BE NULL
#define OPTION_VAL_9PX_BE NULL
#define OPTION_VAL_10PX_BE NULL
#define OPTION_VAL_11PX_BE NULL
#define OPTION_VAL_12PX_BE NULL
#define OPTION_VAL_13PX_BE NULL
#define OPTION_VAL_14PX_BE NULL
#define OPTION_VAL_15PX_BE NULL
#define OPTION_VAL_16PX_BE NULL
#define OPTION_VAL_17PX_BE NULL
#define OPTION_VAL_18PX_BE NULL
#define OPTION_VAL_19PX_BE NULL
#define OPTION_VAL_20PX_BE NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_BE NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_BE NULL
#define OPTION_VAL_12PX_O60_BE NULL
#define OPTION_VAL_11PX_O60_BE NULL
#define OPTION_VAL_10PX_O60_BE NULL
#define OPTION_VAL_9PX_O60_BE NULL
#define OPTION_VAL_8PX_O60_BE NULL
#define OPTION_VAL_7PX_O60_BE NULL
#define OPTION_VAL_6PX_O60_BE NULL
#define OPTION_VAL_5PX_O60_BE NULL
#define OPTION_VAL_4PX_O60_BE NULL
#define OPTION_VAL_3PX_O60_BE NULL
#define OPTION_VAL_2PX_O60_BE NULL
#define OPTION_VAL_1PX_O60_BE NULL
#define OPTION_VAL_1PX_O60_0_BE NULL
#define OPTION_VAL_2PX_O60_0_BE NULL
#define OPTION_VAL_3PX_O60_0_BE NULL
#define OPTION_VAL_4PX_O60_0_BE NULL
#define OPTION_VAL_5PX_O60_0_BE NULL
#define OPTION_VAL_6PX_O60_0_BE NULL
#define OPTION_VAL_7PX_O60_0_BE NULL
#define OPTION_VAL_8PX_O60_0_BE NULL
#define OPTION_VAL_9PX_O60_0_BE NULL
#define OPTION_VAL_10PX_O60_0_BE NULL
#define OPTION_VAL_11PX_O60_0_BE NULL
#define OPTION_VAL_12PX_O60_0_BE NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_BE NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_BE NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_BE NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_BE NULL
#define OPTION_VAL_0_O62_BE NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_BE NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_BE NULL
#define OPTION_VAL_239_BE NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_BE NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_BE NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_BE NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_BE NULL
#define OPTION_VAL_287_BE NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_BE NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_BE NULL
#define OPTION_VAL_SYNC_BE NULL
#define OPTION_VAL_ASYNC_BE NULL
#define OPTION_VAL_PRECACHE_BE NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_BE NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_BE NULL
#define OPTION_VAL_2X_NATIVE_BE NULL
#define OPTION_VAL_6X_BE NULL
#define OPTION_VAL_10X_BE NULL
#define OPTION_VAL_12X_BE NULL
#define OPTION_VAL_14X_BE NULL

struct retro_core_option_v2_category option_cats_be[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_BE,
      CATEGORY_VIDEO_INFO_0_BE
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_BE,
      CATEGORY_OSD_INFO_0_BE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_BE,
      CATEGORY_INPUT_INFO_0_BE
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_BE,
      CATEGORY_MEMCARDS_INFO_0_BE
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_BE,
      CATEGORY_PGXP_INFO_0_BE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_BE,
      CATEGORY_HACKS_INFO_0_BE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_be[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_BE,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_BE,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_BE },
         { "2x",         OPTION_VAL_2X_BE },
         { "4x",         OPTION_VAL_4X_BE },
         { "8x",         OPTION_VAL_8X_BE },
         { "16x",        OPTION_VAL_16X_BE },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_BE,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_BE,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_BE },
         { "32bpp",         OPTION_VAL_32BPP_BE },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_BE,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_BE,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_BE },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_BE },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_BE,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_BE,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_BE,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_BE,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_BE },
         { "SABR",     OPTION_VAL_SABR_BE },
         { "xBR",      OPTION_VAL_XBR_BE },
         { "bilinear", OPTION_VAL_BILINEAR_BE },
         { "3-point",  OPTION_VAL_3_POINT_BE },
         { "JINC2",    OPTION_VAL_JINC2_BE },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_BE,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_BE },
         { "all", OPTION_VAL_ALL_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_BE,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_BE },
         { "all", OPTION_VAL_ALL_BE },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_BE,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_BE,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_BE,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_BE,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_BE },
         { "2x",  OPTION_VAL_2X_BE },
         { "4x",  OPTION_VAL_4X_BE },
         { "8x",  OPTION_VAL_8X_BE },
         { "16x", OPTION_VAL_16X_BE },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_BE,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_BE,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_BE,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_BE,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_BE,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_BE,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_BE,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_BE,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_BE,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_BE,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_BE,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_BE,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_BE,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_BE,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_BE },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_BE },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_BE },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_BE },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_BE },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_BE },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_BE },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_BE },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_BE },
         { "l3+r3",                    OPTION_VAL_L3_R3_BE },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_BE,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_BE,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_BE },
         { "1", OPTION_VAL_1_BE },
         { "2", OPTION_VAL_2_BE },
         { "3", OPTION_VAL_3_BE },
         { "4", OPTION_VAL_4_BE },
         { "5", OPTION_VAL_5_BE },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_BE,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_BE,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_BE,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_BE,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_BE },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_BE },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_BE,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_BE,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_BE },
         { "dot",   OPTION_VAL_DOT_BE },
         { "off",   OPTION_VAL_OFF_BE },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_BE,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_BE,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_BE },
         { "blue", OPTION_VAL_BLUE_BE },
         { "green", OPTION_VAL_GREEN_BE },
         { "orange", OPTION_VAL_ORANGE_BE },
         { "yellow", OPTION_VAL_YELLOW_BE },
         { "cyan", OPTION_VAL_CYAN_BE },
         { "pink", OPTION_VAL_PINK_BE },
         { "purple", OPTION_VAL_PURPLE_BE },
         { "black", OPTION_VAL_BLACK_BE },
         { "white", OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_BE,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_BE,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_BE },
         { "red", OPTION_VAL_RED_BE },
         { "green", OPTION_VAL_GREEN_BE },
         { "orange", OPTION_VAL_ORANGE_BE },
         { "yellow", OPTION_VAL_YELLOW_BE },
         { "cyan", OPTION_VAL_CYAN_BE },
         { "pink", OPTION_VAL_PINK_BE },
         { "purple", OPTION_VAL_PURPLE_BE },
         { "black", OPTION_VAL_BLACK_BE },
         { "white", OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_BE,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_BE,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_BE },
         { "10%",  OPTION_VAL_10_BE },
         { "15%",  OPTION_VAL_15_BE },
         { "20%",  OPTION_VAL_20_BE },
         { "25%",  OPTION_VAL_25_BE },
         { "30%",  OPTION_VAL_30_BE },
         { "35%",  OPTION_VAL_35_BE },
         { "40%",  OPTION_VAL_40_BE },
         { "45%",  OPTION_VAL_45_BE },
         { "50%",  OPTION_VAL_50_BE },
         { "55%",  OPTION_VAL_55_BE },
         { "60%",  OPTION_VAL_60_BE },
         { "65%",  OPTION_VAL_65_BE },
         { "70%",  OPTION_VAL_70_BE },
         { "75%",  OPTION_VAL_75_BE },
         { "80%",  OPTION_VAL_80_BE },
         { "85%",  OPTION_VAL_85_BE },
         { "90%",  OPTION_VAL_90_BE },
         { "95%",  OPTION_VAL_95_BE },
         { "100%", OPTION_VAL_100_BE },
         { "105%", OPTION_VAL_105_BE },
         { "110%", OPTION_VAL_110_BE },
         { "115%", OPTION_VAL_115_BE },
         { "120%", OPTION_VAL_120_BE },
         { "125%", OPTION_VAL_125_BE },
         { "130%", OPTION_VAL_130_BE },
         { "135%", OPTION_VAL_135_BE },
         { "140%", OPTION_VAL_140_BE },
         { "145%", OPTION_VAL_145_BE },
         { "150%", OPTION_VAL_150_BE },
         { "155%", OPTION_VAL_155_BE },
         { "160%", OPTION_VAL_160_BE },
         { "165%", OPTION_VAL_165_BE },
         { "170%", OPTION_VAL_170_BE },
         { "175%", OPTION_VAL_175_BE },
         { "180%", OPTION_VAL_180_BE },
         { "185%", OPTION_VAL_185_BE },
         { "190%", OPTION_VAL_190_BE },
         { "195%", OPTION_VAL_195_BE },
         { "200%", OPTION_VAL_200_BE },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_BE,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_BE,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_BE },
         { "quadratic", OPTION_VAL_QUADRATIC_BE },
         { "cubic",     OPTION_VAL_CUBIC_BE },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_BE,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_BE,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_BE },
         { "5%",  OPTION_VAL_5_O28_BE },
         { "10%", OPTION_VAL_10_BE },
         { "15%", OPTION_VAL_15_BE },
         { "20%", OPTION_VAL_20_BE },
         { "25%", OPTION_VAL_25_BE },
         { "30%", OPTION_VAL_30_BE },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_BE,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_BE,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_BE },
         { "mednafen", OPTION_VAL_MEDNAFEN_BE },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_BE,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_BE,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_BE,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_BE,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_BE,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_BE,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_BE,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_BE,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_BE },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_BE,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_BE,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_BE },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_BE,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_BE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_BE },
         { "1px", OPTION_VAL_1PX_BE },
         { "2px", OPTION_VAL_2PX_BE },
         { "3px", OPTION_VAL_3PX_BE },
         { "4px", OPTION_VAL_4PX_BE },
         { "5px", OPTION_VAL_5PX_BE },
         { "6px", OPTION_VAL_6PX_BE },
         { "7px", OPTION_VAL_7PX_BE },
         { "8px", OPTION_VAL_8PX_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_BE,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_BE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_BE,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_BE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_BE,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_BE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_BE,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_BE },
         { "aggressive", OPTION_VAL_AGGRESSIVE_BE },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_BE,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_BE,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_BE },
         { "16:10", OPTION_VAL_16_10_BE },
         { "18:9",  OPTION_VAL_18_9_BE },
         { "19:9",  OPTION_VAL_19_9_BE },
         { "20:9",  OPTION_VAL_20_9_BE },
         { "21:9",  OPTION_VAL_21_9_BE }, // 64:27
         { "32:9",  OPTION_VAL_32_9_BE },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_BE,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_BE },
         { "60%",           OPTION_VAL_60_BE },
         { "70%",           OPTION_VAL_70_BE },
         { "80%",           OPTION_VAL_80_BE },
         { "90%",           OPTION_VAL_90_BE },
         { "100%(native)", OPTION_VAL_100_NATIVE_BE },
         { "110%",          OPTION_VAL_110_BE },
         { "120%",          OPTION_VAL_120_BE },
         { "130%",          OPTION_VAL_130_BE },
         { "140%",          OPTION_VAL_140_BE },
         { "150%",          OPTION_VAL_150_BE },
         { "160%",          OPTION_VAL_160_BE },
         { "170%",          OPTION_VAL_170_BE },
         { "180%",          OPTION_VAL_180_BE },
         { "190%",          OPTION_VAL_190_BE },
         { "200%",          OPTION_VAL_200_BE },
         { "210%",          OPTION_VAL_210_BE },
         { "220%",          OPTION_VAL_220_BE },
         { "230%",          OPTION_VAL_230_BE },
         { "240%",          OPTION_VAL_240_BE },
         { "250%",          OPTION_VAL_250_BE },
         { "260%",          OPTION_VAL_260_BE },
         { "270%",          OPTION_VAL_270_BE },
         { "280%",          OPTION_VAL_280_BE },
         { "290%",          OPTION_VAL_290_BE },
         { "300%",          OPTION_VAL_300_BE },
         { "310%",          OPTION_VAL_310_BE },
         { "320%",          OPTION_VAL_320_BE },
         { "330%",          OPTION_VAL_330_BE },
         { "340%",          OPTION_VAL_340_BE },
         { "350%",          OPTION_VAL_350_BE },
         { "360%",          OPTION_VAL_360_BE },
         { "370%",          OPTION_VAL_370_BE },
         { "380%",          OPTION_VAL_380_BE },
         { "390%",          OPTION_VAL_390_BE },
         { "400%",          OPTION_VAL_400_BE },
         { "410%",          OPTION_VAL_410_BE },
         { "420%",          OPTION_VAL_420_BE },
         { "430%",          OPTION_VAL_430_BE },
         { "440%",          OPTION_VAL_440_BE },
         { "450%",          OPTION_VAL_450_BE },
         { "460%",          OPTION_VAL_460_BE },
         { "470%",          OPTION_VAL_470_BE },
         { "480%",          OPTION_VAL_480_BE },
         { "490%",          OPTION_VAL_490_BE },
         { "500%",          OPTION_VAL_500_BE },
         { "510%",          OPTION_VAL_510_BE },
         { "520%",          OPTION_VAL_520_BE },
         { "530%",          OPTION_VAL_530_BE },
         { "540%",          OPTION_VAL_540_BE },
         { "550%",          OPTION_VAL_550_BE },
         { "560%",          OPTION_VAL_560_BE },
         { "570%",          OPTION_VAL_570_BE },
         { "580%",          OPTION_VAL_580_BE },
         { "590%",          OPTION_VAL_590_BE },
         { "600%",          OPTION_VAL_600_BE },
         { "610%",          OPTION_VAL_610_BE },
         { "620%",          OPTION_VAL_620_BE },
         { "630%",          OPTION_VAL_630_BE },
         { "640%",          OPTION_VAL_640_BE },
         { "650%",          OPTION_VAL_650_BE },
         { "660%",          OPTION_VAL_660_BE },
         { "670%",          OPTION_VAL_670_BE },
         { "680%",          OPTION_VAL_680_BE },
         { "690%",          OPTION_VAL_690_BE },
         { "700%",          OPTION_VAL_700_BE },
         { "710%",          OPTION_VAL_710_BE },
         { "720%",          OPTION_VAL_720_BE },
         { "730%",          OPTION_VAL_730_BE },
         { "740%",          OPTION_VAL_740_BE },
         { "750%",          OPTION_VAL_750_BE },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_BE,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_BE },
         { "2x",         OPTION_VAL_2X_BE },
         { "4x",         OPTION_VAL_4X_BE },
         { "8x",         OPTION_VAL_8X_BE },
         { "16x",        OPTION_VAL_16X_BE },
         { "32x",        OPTION_VAL_32X_BE },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_BE,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_BE,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_BE,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_BE },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_BE },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_BE,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_BE,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_BE },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_BE },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_BE },
#endif
         { "software",    OPTION_VAL_SOFTWARE_BE },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_BE,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_BE,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_BE,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_BE,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_BE },
         { "execute",  OPTION_VAL_EXECUTE_BE },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_BE },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_BE,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_BE,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_BE },
         { "dma",  OPTION_VAL_DMA_BE },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_BE,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_BE },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_BE,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_BE },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_BE,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_BE,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_BE },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_BE },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_BE },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_BE,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_BE,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_BE,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_BE },
         { "uncorrected", OPTION_VAL_UNCORRECTED_BE },
         { "4:3",  OPTION_VAL_4_3_BE },
         { "ntsc", OPTION_VAL_NTSC_BE },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_BE,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_BE },
         { "static",  OPTION_VAL_STATIC_BE },
         { "smart", OPTION_VAL_SMART_BE },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_BE,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_BE },
         { "2px",      OPTION_VAL_2PX_BE },
         { "3px",      OPTION_VAL_3PX_BE },
         { "4px",      OPTION_VAL_4PX_BE },
         { "5px",      OPTION_VAL_5PX_BE },
         { "6px",      OPTION_VAL_6PX_BE },
         { "7px",      OPTION_VAL_7PX_BE },
         { "8px",      OPTION_VAL_8PX_BE },
         { "9px",      OPTION_VAL_9PX_BE },
         { "10px",     OPTION_VAL_10PX_BE },
         { "11px",     OPTION_VAL_11PX_BE },
         { "12px",     OPTION_VAL_12PX_BE },
         { "13px",     OPTION_VAL_13PX_BE },
         { "14px",     OPTION_VAL_14PX_BE },
         { "15px",     OPTION_VAL_15PX_BE },
         { "16px",     OPTION_VAL_16PX_BE },
         { "17px",     OPTION_VAL_17PX_BE },
         { "18px",     OPTION_VAL_18PX_BE },
         { "19px",     OPTION_VAL_19PX_BE },
         { "20px",     OPTION_VAL_20PX_BE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_BE,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_BE,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_BE },
         { "-11px",    OPTION_VAL_11PX_O60_BE },
         { "-10px",    OPTION_VAL_10PX_O60_BE },
         { "-9px",     OPTION_VAL_9PX_O60_BE },
         { "-8px",     OPTION_VAL_8PX_O60_BE },
         { "-7px",     OPTION_VAL_7PX_O60_BE },
         { "-6px",     OPTION_VAL_6PX_O60_BE },
         { "-5px",     OPTION_VAL_5PX_O60_BE },
         { "-4px",     OPTION_VAL_4PX_O60_BE },
         { "-3px",     OPTION_VAL_3PX_O60_BE },
         { "-2px",     OPTION_VAL_2PX_O60_BE },
         { "-1px",     OPTION_VAL_1PX_O60_BE },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_BE },
         { "+2px",     OPTION_VAL_2PX_O60_0_BE },
         { "+3px",     OPTION_VAL_3PX_O60_0_BE },
         { "+4px",     OPTION_VAL_4PX_O60_0_BE },
         { "+5px",     OPTION_VAL_5PX_O60_0_BE },
         { "+6px",     OPTION_VAL_6PX_O60_0_BE },
         { "+7px",     OPTION_VAL_7PX_O60_0_BE },
         { "+8px",     OPTION_VAL_8PX_O60_0_BE },
         { "+9px",     OPTION_VAL_9PX_O60_0_BE },
         { "+10px",    OPTION_VAL_10PX_O60_0_BE },
         { "+11px",    OPTION_VAL_11PX_O60_0_BE },
         { "+12px",    OPTION_VAL_12PX_O60_0_BE },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_BE,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_BE,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_BE,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_BE,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_BE },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_BE,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_BE,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_BE },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_BE,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_BE,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_BE },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_BE,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_BE,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_BE },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_BE,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_BE,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_BE },
         { "async",    OPTION_VAL_ASYNC_BE },
         { "precache", OPTION_VAL_PRECACHE_BE },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_BE,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_BE,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_BE },
         { "4x",          OPTION_VAL_4X_BE },
         { "6x",          OPTION_VAL_6X_BE },
         { "8x",          OPTION_VAL_8X_BE },
         { "10x",         OPTION_VAL_10X_BE },
         { "12x",         OPTION_VAL_12X_BE },
         { "14x",         OPTION_VAL_14X_BE },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_be = {
   option_cats_be,
   option_defs_be
};

/* RETRO_LANGUAGE_BG */

#define CATEGORY_VIDEO_LABEL_BG NULL
#define CATEGORY_VIDEO_INFO_0_BG NULL
#define CATEGORY_OSD_LABEL_BG NULL
#define CATEGORY_OSD_INFO_0_BG NULL
#define CATEGORY_INPUT_LABEL_BG NULL
#define CATEGORY_INPUT_INFO_0_BG NULL
#define CATEGORY_MEMCARDS_LABEL_BG NULL
#define CATEGORY_MEMCARDS_INFO_0_BG NULL
#define CATEGORY_PGXP_LABEL_BG NULL
#define CATEGORY_PGXP_INFO_0_BG NULL
#define CATEGORY_HACKS_LABEL_BG NULL
#define CATEGORY_HACKS_INFO_0_BG NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_BG NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_BG NULL
#define OPTION_VAL_1X_NATIVE_BG NULL
#define OPTION_VAL_2X_BG NULL
#define OPTION_VAL_4X_BG NULL
#define OPTION_VAL_8X_BG NULL
#define OPTION_VAL_16X_BG NULL
#define BEETLE_OPT_DEPTH_LABEL_BG NULL
#define BEETLE_OPT_DEPTH_INFO_0_BG NULL
#define OPTION_VAL_16BPP_NATIVE_BG NULL
#define OPTION_VAL_32BPP_BG NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_BG NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_BG NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_BG NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_BG NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_BG NULL
#define BEETLE_OPT_FILTER_LABEL_BG NULL
#define BEETLE_OPT_FILTER_INFO_0_BG NULL
#define OPTION_VAL_NEAREST_BG NULL
#define OPTION_VAL_SABR_BG NULL
#define OPTION_VAL_XBR_BG NULL
#define OPTION_VAL_BILINEAR_BG NULL
#define OPTION_VAL_3_POINT_BG NULL
#define OPTION_VAL_JINC2_BG NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_BG NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_BG NULL
#define OPTION_VAL_OPAQUE_BG NULL
#define OPTION_VAL_ALL_BG NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_BG NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_BG NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_BG NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_BG NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_BG NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_BG NULL
#define BEETLE_OPT_MSAA_LABEL_BG NULL
#define BEETLE_OPT_MSAA_INFO_0_BG NULL
#define OPTION_VAL_1X_BG NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_BG NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_BG NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_BG NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_BG NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_BG NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_BG NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_BG NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_BG NULL
#define BEETLE_OPT_WIREFRAME_LABEL_BG NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_BG NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_BG NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_BG NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_BG NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_BG NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_BG NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_BG NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_BG NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_BG NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_BG NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_BG NULL
#define OPTION_VAL_ENABLED_ANALOG_BG NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_BG NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_BG NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_BG NULL
#define OPTION_VAL_L1_R1_SELECT_BG NULL
#define OPTION_VAL_L1_R1_START_BG NULL
#define OPTION_VAL_L1_R1_L3_BG NULL
#define OPTION_VAL_L1_R1_R3_BG NULL
#define OPTION_VAL_L2_R2_SELECT_BG NULL
#define OPTION_VAL_L2_R2_START_BG NULL
#define OPTION_VAL_L2_R2_L3_BG NULL
#define OPTION_VAL_L2_R2_R3_BG NULL
#define OPTION_VAL_L3_R3_BG NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_BG NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_BG NULL
#define OPTION_VAL_0_BG NULL
#define OPTION_VAL_1_BG NULL
#define OPTION_VAL_2_BG NULL
#define OPTION_VAL_3_BG NULL
#define OPTION_VAL_4_BG NULL
#define OPTION_VAL_5_BG NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_BG NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_BG NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_BG NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_BG NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_BG NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_BG NULL
#define OPTION_VAL_LIGHTGUN_BG NULL
#define OPTION_VAL_TOUCHSCREEN_BG NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_BG NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_BG NULL
#define OPTION_VAL_CROSS_BG NULL
#define OPTION_VAL_DOT_BG NULL
#define OPTION_VAL_OFF_BG NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_BG NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_BG NULL
#define OPTION_VAL_RED_BG NULL
#define OPTION_VAL_BLUE_BG NULL
#define OPTION_VAL_GREEN_BG NULL
#define OPTION_VAL_ORANGE_BG NULL
#define OPTION_VAL_YELLOW_BG NULL
#define OPTION_VAL_CYAN_BG NULL
#define OPTION_VAL_PINK_BG NULL
#define OPTION_VAL_PURPLE_BG NULL
#define OPTION_VAL_BLACK_BG NULL
#define OPTION_VAL_WHITE_BG NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_BG NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_BG NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_BG NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_BG NULL
#define OPTION_VAL_5_O28_BG NULL
#define OPTION_VAL_10_BG NULL
#define OPTION_VAL_15_BG NULL
#define OPTION_VAL_20_BG NULL
#define OPTION_VAL_25_BG NULL
#define OPTION_VAL_30_BG NULL
#define OPTION_VAL_35_BG NULL
#define OPTION_VAL_40_BG NULL
#define OPTION_VAL_45_BG NULL
#define OPTION_VAL_50_BG NULL
#define OPTION_VAL_55_BG NULL
#define OPTION_VAL_60_BG NULL
#define OPTION_VAL_65_BG NULL
#define OPTION_VAL_70_BG NULL
#define OPTION_VAL_75_BG NULL
#define OPTION_VAL_80_BG NULL
#define OPTION_VAL_85_BG NULL
#define OPTION_VAL_90_BG NULL
#define OPTION_VAL_95_BG NULL
#define OPTION_VAL_100_BG NULL
#define OPTION_VAL_105_BG NULL
#define OPTION_VAL_110_BG NULL
#define OPTION_VAL_115_BG NULL
#define OPTION_VAL_120_BG NULL
#define OPTION_VAL_125_BG NULL
#define OPTION_VAL_130_BG NULL
#define OPTION_VAL_135_BG NULL
#define OPTION_VAL_140_BG NULL
#define OPTION_VAL_145_BG NULL
#define OPTION_VAL_150_BG NULL
#define OPTION_VAL_155_BG NULL
#define OPTION_VAL_160_BG NULL
#define OPTION_VAL_165_BG NULL
#define OPTION_VAL_170_BG NULL
#define OPTION_VAL_175_BG NULL
#define OPTION_VAL_180_BG NULL
#define OPTION_VAL_185_BG NULL
#define OPTION_VAL_190_BG NULL
#define OPTION_VAL_195_BG NULL
#define OPTION_VAL_200_BG NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_BG NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_BG NULL
#define OPTION_VAL_LINEAR_BG NULL
#define OPTION_VAL_QUADRATIC_BG NULL
#define OPTION_VAL_CUBIC_BG NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_BG NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_BG NULL
#define OPTION_VAL_0_O30_BG NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_BG NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_BG NULL
#define OPTION_VAL_LIBRETRO_BG NULL
#define OPTION_VAL_MEDNAFEN_BG NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_BG NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_BG NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_BG NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_BG NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_BG NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_BG NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_BG NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_BG NULL
#define OPTION_VAL_1_O35_BG NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_BG NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_BG NULL
#define OPTION_VAL_MEMORY_ONLY_BG NULL
#define OPTION_VAL_MEMORY_CPU_BG NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_BG NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_BG NULL
#define OPTION_VAL_0PX_BG NULL
#define OPTION_VAL_1PX_BG NULL
#define OPTION_VAL_2PX_BG NULL
#define OPTION_VAL_3PX_BG NULL
#define OPTION_VAL_4PX_BG NULL
#define OPTION_VAL_5PX_BG NULL
#define OPTION_VAL_6PX_BG NULL
#define OPTION_VAL_7PX_BG NULL
#define OPTION_VAL_8PX_BG NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_BG NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_BG NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_BG NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_BG NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_BG NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_BG NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_BG NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_BG NULL
#define OPTION_VAL_DEFAULT_BG NULL
#define OPTION_VAL_AGGRESSIVE_BG NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_BG NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_BG NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_BG NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_BG NULL
#define OPTION_VAL_16_9_BG NULL
#define OPTION_VAL_16_10_BG NULL
#define OPTION_VAL_18_9_BG NULL
#define OPTION_VAL_19_9_BG NULL
#define OPTION_VAL_20_9_BG NULL
#define OPTION_VAL_21_9_BG NULL
#define OPTION_VAL_32_9_BG NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_BG NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_BG NULL
#define OPTION_VAL_100_NATIVE_BG NULL
#define OPTION_VAL_210_BG NULL
#define OPTION_VAL_220_BG NULL
#define OPTION_VAL_230_BG NULL
#define OPTION_VAL_240_BG NULL
#define OPTION_VAL_250_BG NULL
#define OPTION_VAL_260_BG NULL
#define OPTION_VAL_270_BG NULL
#define OPTION_VAL_280_BG NULL
#define OPTION_VAL_290_BG NULL
#define OPTION_VAL_300_BG NULL
#define OPTION_VAL_310_BG NULL
#define OPTION_VAL_320_BG NULL
#define OPTION_VAL_330_BG NULL
#define OPTION_VAL_340_BG NULL
#define OPTION_VAL_350_BG NULL
#define OPTION_VAL_360_BG NULL
#define OPTION_VAL_370_BG NULL
#define OPTION_VAL_380_BG NULL
#define OPTION_VAL_390_BG NULL
#define OPTION_VAL_400_BG NULL
#define OPTION_VAL_410_BG NULL
#define OPTION_VAL_420_BG NULL
#define OPTION_VAL_430_BG NULL
#define OPTION_VAL_440_BG NULL
#define OPTION_VAL_450_BG NULL
#define OPTION_VAL_460_BG NULL
#define OPTION_VAL_470_BG NULL
#define OPTION_VAL_480_BG NULL
#define OPTION_VAL_490_BG NULL
#define OPTION_VAL_500_BG NULL
#define OPTION_VAL_510_BG NULL
#define OPTION_VAL_520_BG NULL
#define OPTION_VAL_530_BG NULL
#define OPTION_VAL_540_BG NULL
#define OPTION_VAL_550_BG NULL
#define OPTION_VAL_560_BG NULL
#define OPTION_VAL_570_BG NULL
#define OPTION_VAL_580_BG NULL
#define OPTION_VAL_590_BG NULL
#define OPTION_VAL_600_BG NULL
#define OPTION_VAL_610_BG NULL
#define OPTION_VAL_620_BG NULL
#define OPTION_VAL_630_BG NULL
#define OPTION_VAL_640_BG NULL
#define OPTION_VAL_650_BG NULL
#define OPTION_VAL_660_BG NULL
#define OPTION_VAL_670_BG NULL
#define OPTION_VAL_680_BG NULL
#define OPTION_VAL_690_BG NULL
#define OPTION_VAL_700_BG NULL
#define OPTION_VAL_710_BG NULL
#define OPTION_VAL_720_BG NULL
#define OPTION_VAL_730_BG NULL
#define OPTION_VAL_740_BG NULL
#define OPTION_VAL_750_BG NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_BG NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_BG NULL
#define OPTION_VAL_32X_BG NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_BG NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_BG NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_BG NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_BG NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_BG NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_BG NULL
#define OPTION_VAL_PSXONPSP_BG NULL
#define OPTION_VAL_PS1_ROM_BG NULL
#define BEETLE_OPT_RENDERER_LABEL_BG NULL
#define BEETLE_OPT_RENDERER_INFO_0_BG NULL
#define OPTION_VAL_HARDWARE_BG NULL
#define OPTION_VAL_HARDWARE_GL_BG NULL
#define OPTION_VAL_HARDWARE_VK_BG NULL
#define OPTION_VAL_SOFTWARE_BG NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_BG NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_BG NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_BG NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_BG NULL
#define OPTION_VAL_DISABLED_BG NULL
#define OPTION_VAL_EXECUTE_BG NULL
#define OPTION_VAL_EXECUTE_ONE_BG NULL
#define OPTION_VAL_RUN_INTERPRETER_BG NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_BG NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_BG NULL
#define OPTION_VAL_FULL_BG NULL
#define OPTION_VAL_DMA_BG NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_BG NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_BG NULL
#define OPTION_VAL_128_BG NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_BG NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_BG NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_BG NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_BG NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_BG NULL
#define OPTION_VAL_FORCE_INTERLACED_BG NULL
#define OPTION_VAL_AUTO_TOGGLE_BG NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_BG NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_BG NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_BG NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_BG NULL
#define OPTION_VAL_CORRECTED_BG NULL
#define OPTION_VAL_UNCORRECTED_BG NULL
#define OPTION_VAL_4_3_BG NULL
#define OPTION_VAL_NTSC_BG NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_BG NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_BG NULL
#define OPTION_VAL_DISABLED_O58_BG NULL
#define OPTION_VAL_STATIC_BG NULL
#define OPTION_VAL_SMART_BG NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_BG NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_BG NULL
#define OPTION_VAL_9PX_BG NULL
#define OPTION_VAL_10PX_BG NULL
#define OPTION_VAL_11PX_BG NULL
#define OPTION_VAL_12PX_BG NULL
#define OPTION_VAL_13PX_BG NULL
#define OPTION_VAL_14PX_BG NULL
#define OPTION_VAL_15PX_BG NULL
#define OPTION_VAL_16PX_BG NULL
#define OPTION_VAL_17PX_BG NULL
#define OPTION_VAL_18PX_BG NULL
#define OPTION_VAL_19PX_BG NULL
#define OPTION_VAL_20PX_BG NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_BG NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_BG NULL
#define OPTION_VAL_12PX_O60_BG NULL
#define OPTION_VAL_11PX_O60_BG NULL
#define OPTION_VAL_10PX_O60_BG NULL
#define OPTION_VAL_9PX_O60_BG NULL
#define OPTION_VAL_8PX_O60_BG NULL
#define OPTION_VAL_7PX_O60_BG NULL
#define OPTION_VAL_6PX_O60_BG NULL
#define OPTION_VAL_5PX_O60_BG NULL
#define OPTION_VAL_4PX_O60_BG NULL
#define OPTION_VAL_3PX_O60_BG NULL
#define OPTION_VAL_2PX_O60_BG NULL
#define OPTION_VAL_1PX_O60_BG NULL
#define OPTION_VAL_1PX_O60_0_BG NULL
#define OPTION_VAL_2PX_O60_0_BG NULL
#define OPTION_VAL_3PX_O60_0_BG NULL
#define OPTION_VAL_4PX_O60_0_BG NULL
#define OPTION_VAL_5PX_O60_0_BG NULL
#define OPTION_VAL_6PX_O60_0_BG NULL
#define OPTION_VAL_7PX_O60_0_BG NULL
#define OPTION_VAL_8PX_O60_0_BG NULL
#define OPTION_VAL_9PX_O60_0_BG NULL
#define OPTION_VAL_10PX_O60_0_BG NULL
#define OPTION_VAL_11PX_O60_0_BG NULL
#define OPTION_VAL_12PX_O60_0_BG NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_BG NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_BG NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_BG NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_BG NULL
#define OPTION_VAL_0_O62_BG NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_BG NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_BG NULL
#define OPTION_VAL_239_BG NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_BG NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_BG NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_BG NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_BG NULL
#define OPTION_VAL_287_BG NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_BG NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_BG NULL
#define OPTION_VAL_SYNC_BG NULL
#define OPTION_VAL_ASYNC_BG NULL
#define OPTION_VAL_PRECACHE_BG NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_BG NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_BG NULL
#define OPTION_VAL_2X_NATIVE_BG NULL
#define OPTION_VAL_6X_BG NULL
#define OPTION_VAL_10X_BG NULL
#define OPTION_VAL_12X_BG NULL
#define OPTION_VAL_14X_BG NULL

struct retro_core_option_v2_category option_cats_bg[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_BG,
      CATEGORY_VIDEO_INFO_0_BG
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_BG,
      CATEGORY_OSD_INFO_0_BG
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_BG,
      CATEGORY_INPUT_INFO_0_BG
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_BG,
      CATEGORY_MEMCARDS_INFO_0_BG
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_BG,
      CATEGORY_PGXP_INFO_0_BG
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_BG,
      CATEGORY_HACKS_INFO_0_BG
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_bg[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_BG,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_BG,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_BG },
         { "2x",         OPTION_VAL_2X_BG },
         { "4x",         OPTION_VAL_4X_BG },
         { "8x",         OPTION_VAL_8X_BG },
         { "16x",        OPTION_VAL_16X_BG },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_BG,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_BG,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_BG },
         { "32bpp",         OPTION_VAL_32BPP_BG },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_BG,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_BG,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_BG },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_BG },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_BG,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_BG,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_BG,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_BG,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_BG },
         { "SABR",     OPTION_VAL_SABR_BG },
         { "xBR",      OPTION_VAL_XBR_BG },
         { "bilinear", OPTION_VAL_BILINEAR_BG },
         { "3-point",  OPTION_VAL_3_POINT_BG },
         { "JINC2",    OPTION_VAL_JINC2_BG },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_BG,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_BG },
         { "all", OPTION_VAL_ALL_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_BG,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_BG },
         { "all", OPTION_VAL_ALL_BG },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_BG,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_BG,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_BG,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_BG,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_BG },
         { "2x",  OPTION_VAL_2X_BG },
         { "4x",  OPTION_VAL_4X_BG },
         { "8x",  OPTION_VAL_8X_BG },
         { "16x", OPTION_VAL_16X_BG },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_BG,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_BG,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_BG,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_BG,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_BG,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_BG,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_BG,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_BG,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_BG,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_BG,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_BG,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_BG,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_BG,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_BG,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_BG },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_BG },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_BG },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_BG },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_BG },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_BG },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_BG },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_BG },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_BG },
         { "l3+r3",                    OPTION_VAL_L3_R3_BG },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_BG,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_BG,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_BG },
         { "1", OPTION_VAL_1_BG },
         { "2", OPTION_VAL_2_BG },
         { "3", OPTION_VAL_3_BG },
         { "4", OPTION_VAL_4_BG },
         { "5", OPTION_VAL_5_BG },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_BG,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_BG,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_BG,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_BG,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_BG },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_BG },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_BG,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_BG,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_BG },
         { "dot",   OPTION_VAL_DOT_BG },
         { "off",   OPTION_VAL_OFF_BG },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_BG,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_BG,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_BG },
         { "blue", OPTION_VAL_BLUE_BG },
         { "green", OPTION_VAL_GREEN_BG },
         { "orange", OPTION_VAL_ORANGE_BG },
         { "yellow", OPTION_VAL_YELLOW_BG },
         { "cyan", OPTION_VAL_CYAN_BG },
         { "pink", OPTION_VAL_PINK_BG },
         { "purple", OPTION_VAL_PURPLE_BG },
         { "black", OPTION_VAL_BLACK_BG },
         { "white", OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_BG,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_BG,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_BG },
         { "red", OPTION_VAL_RED_BG },
         { "green", OPTION_VAL_GREEN_BG },
         { "orange", OPTION_VAL_ORANGE_BG },
         { "yellow", OPTION_VAL_YELLOW_BG },
         { "cyan", OPTION_VAL_CYAN_BG },
         { "pink", OPTION_VAL_PINK_BG },
         { "purple", OPTION_VAL_PURPLE_BG },
         { "black", OPTION_VAL_BLACK_BG },
         { "white", OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_BG,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_BG,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_BG },
         { "10%",  OPTION_VAL_10_BG },
         { "15%",  OPTION_VAL_15_BG },
         { "20%",  OPTION_VAL_20_BG },
         { "25%",  OPTION_VAL_25_BG },
         { "30%",  OPTION_VAL_30_BG },
         { "35%",  OPTION_VAL_35_BG },
         { "40%",  OPTION_VAL_40_BG },
         { "45%",  OPTION_VAL_45_BG },
         { "50%",  OPTION_VAL_50_BG },
         { "55%",  OPTION_VAL_55_BG },
         { "60%",  OPTION_VAL_60_BG },
         { "65%",  OPTION_VAL_65_BG },
         { "70%",  OPTION_VAL_70_BG },
         { "75%",  OPTION_VAL_75_BG },
         { "80%",  OPTION_VAL_80_BG },
         { "85%",  OPTION_VAL_85_BG },
         { "90%",  OPTION_VAL_90_BG },
         { "95%",  OPTION_VAL_95_BG },
         { "100%", OPTION_VAL_100_BG },
         { "105%", OPTION_VAL_105_BG },
         { "110%", OPTION_VAL_110_BG },
         { "115%", OPTION_VAL_115_BG },
         { "120%", OPTION_VAL_120_BG },
         { "125%", OPTION_VAL_125_BG },
         { "130%", OPTION_VAL_130_BG },
         { "135%", OPTION_VAL_135_BG },
         { "140%", OPTION_VAL_140_BG },
         { "145%", OPTION_VAL_145_BG },
         { "150%", OPTION_VAL_150_BG },
         { "155%", OPTION_VAL_155_BG },
         { "160%", OPTION_VAL_160_BG },
         { "165%", OPTION_VAL_165_BG },
         { "170%", OPTION_VAL_170_BG },
         { "175%", OPTION_VAL_175_BG },
         { "180%", OPTION_VAL_180_BG },
         { "185%", OPTION_VAL_185_BG },
         { "190%", OPTION_VAL_190_BG },
         { "195%", OPTION_VAL_195_BG },
         { "200%", OPTION_VAL_200_BG },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_BG,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_BG,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_BG },
         { "quadratic", OPTION_VAL_QUADRATIC_BG },
         { "cubic",     OPTION_VAL_CUBIC_BG },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_BG,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_BG,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_BG },
         { "5%",  OPTION_VAL_5_O28_BG },
         { "10%", OPTION_VAL_10_BG },
         { "15%", OPTION_VAL_15_BG },
         { "20%", OPTION_VAL_20_BG },
         { "25%", OPTION_VAL_25_BG },
         { "30%", OPTION_VAL_30_BG },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_BG,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_BG,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_BG },
         { "mednafen", OPTION_VAL_MEDNAFEN_BG },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_BG,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_BG,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_BG,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_BG,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_BG,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_BG,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_BG,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_BG,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_BG },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_BG,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_BG,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_BG },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_BG,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_BG,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_BG },
         { "1px", OPTION_VAL_1PX_BG },
         { "2px", OPTION_VAL_2PX_BG },
         { "3px", OPTION_VAL_3PX_BG },
         { "4px", OPTION_VAL_4PX_BG },
         { "5px", OPTION_VAL_5PX_BG },
         { "6px", OPTION_VAL_6PX_BG },
         { "7px", OPTION_VAL_7PX_BG },
         { "8px", OPTION_VAL_8PX_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_BG,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_BG,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_BG,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_BG,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_BG,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_BG,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_BG,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_BG },
         { "aggressive", OPTION_VAL_AGGRESSIVE_BG },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_BG,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_BG,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_BG },
         { "16:10", OPTION_VAL_16_10_BG },
         { "18:9",  OPTION_VAL_18_9_BG },
         { "19:9",  OPTION_VAL_19_9_BG },
         { "20:9",  OPTION_VAL_20_9_BG },
         { "21:9",  OPTION_VAL_21_9_BG }, // 64:27
         { "32:9",  OPTION_VAL_32_9_BG },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_BG,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_BG },
         { "60%",           OPTION_VAL_60_BG },
         { "70%",           OPTION_VAL_70_BG },
         { "80%",           OPTION_VAL_80_BG },
         { "90%",           OPTION_VAL_90_BG },
         { "100%(native)", OPTION_VAL_100_NATIVE_BG },
         { "110%",          OPTION_VAL_110_BG },
         { "120%",          OPTION_VAL_120_BG },
         { "130%",          OPTION_VAL_130_BG },
         { "140%",          OPTION_VAL_140_BG },
         { "150%",          OPTION_VAL_150_BG },
         { "160%",          OPTION_VAL_160_BG },
         { "170%",          OPTION_VAL_170_BG },
         { "180%",          OPTION_VAL_180_BG },
         { "190%",          OPTION_VAL_190_BG },
         { "200%",          OPTION_VAL_200_BG },
         { "210%",          OPTION_VAL_210_BG },
         { "220%",          OPTION_VAL_220_BG },
         { "230%",          OPTION_VAL_230_BG },
         { "240%",          OPTION_VAL_240_BG },
         { "250%",          OPTION_VAL_250_BG },
         { "260%",          OPTION_VAL_260_BG },
         { "270%",          OPTION_VAL_270_BG },
         { "280%",          OPTION_VAL_280_BG },
         { "290%",          OPTION_VAL_290_BG },
         { "300%",          OPTION_VAL_300_BG },
         { "310%",          OPTION_VAL_310_BG },
         { "320%",          OPTION_VAL_320_BG },
         { "330%",          OPTION_VAL_330_BG },
         { "340%",          OPTION_VAL_340_BG },
         { "350%",          OPTION_VAL_350_BG },
         { "360%",          OPTION_VAL_360_BG },
         { "370%",          OPTION_VAL_370_BG },
         { "380%",          OPTION_VAL_380_BG },
         { "390%",          OPTION_VAL_390_BG },
         { "400%",          OPTION_VAL_400_BG },
         { "410%",          OPTION_VAL_410_BG },
         { "420%",          OPTION_VAL_420_BG },
         { "430%",          OPTION_VAL_430_BG },
         { "440%",          OPTION_VAL_440_BG },
         { "450%",          OPTION_VAL_450_BG },
         { "460%",          OPTION_VAL_460_BG },
         { "470%",          OPTION_VAL_470_BG },
         { "480%",          OPTION_VAL_480_BG },
         { "490%",          OPTION_VAL_490_BG },
         { "500%",          OPTION_VAL_500_BG },
         { "510%",          OPTION_VAL_510_BG },
         { "520%",          OPTION_VAL_520_BG },
         { "530%",          OPTION_VAL_530_BG },
         { "540%",          OPTION_VAL_540_BG },
         { "550%",          OPTION_VAL_550_BG },
         { "560%",          OPTION_VAL_560_BG },
         { "570%",          OPTION_VAL_570_BG },
         { "580%",          OPTION_VAL_580_BG },
         { "590%",          OPTION_VAL_590_BG },
         { "600%",          OPTION_VAL_600_BG },
         { "610%",          OPTION_VAL_610_BG },
         { "620%",          OPTION_VAL_620_BG },
         { "630%",          OPTION_VAL_630_BG },
         { "640%",          OPTION_VAL_640_BG },
         { "650%",          OPTION_VAL_650_BG },
         { "660%",          OPTION_VAL_660_BG },
         { "670%",          OPTION_VAL_670_BG },
         { "680%",          OPTION_VAL_680_BG },
         { "690%",          OPTION_VAL_690_BG },
         { "700%",          OPTION_VAL_700_BG },
         { "710%",          OPTION_VAL_710_BG },
         { "720%",          OPTION_VAL_720_BG },
         { "730%",          OPTION_VAL_730_BG },
         { "740%",          OPTION_VAL_740_BG },
         { "750%",          OPTION_VAL_750_BG },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_BG,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_BG },
         { "2x",         OPTION_VAL_2X_BG },
         { "4x",         OPTION_VAL_4X_BG },
         { "8x",         OPTION_VAL_8X_BG },
         { "16x",        OPTION_VAL_16X_BG },
         { "32x",        OPTION_VAL_32X_BG },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_BG,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_BG,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_BG,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_BG },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_BG },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_BG,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_BG,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_BG },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_BG },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_BG },
#endif
         { "software",    OPTION_VAL_SOFTWARE_BG },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_BG,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_BG,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_BG,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_BG,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_BG },
         { "execute",  OPTION_VAL_EXECUTE_BG },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_BG },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_BG,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_BG,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_BG },
         { "dma",  OPTION_VAL_DMA_BG },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_BG,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_BG },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_BG,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_BG },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_BG,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_BG,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_BG },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_BG },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_BG },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_BG,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_BG,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_BG,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_BG },
         { "uncorrected", OPTION_VAL_UNCORRECTED_BG },
         { "4:3",  OPTION_VAL_4_3_BG },
         { "ntsc", OPTION_VAL_NTSC_BG },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_BG,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_BG },
         { "static",  OPTION_VAL_STATIC_BG },
         { "smart", OPTION_VAL_SMART_BG },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_BG,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_BG },
         { "2px",      OPTION_VAL_2PX_BG },
         { "3px",      OPTION_VAL_3PX_BG },
         { "4px",      OPTION_VAL_4PX_BG },
         { "5px",      OPTION_VAL_5PX_BG },
         { "6px",      OPTION_VAL_6PX_BG },
         { "7px",      OPTION_VAL_7PX_BG },
         { "8px",      OPTION_VAL_8PX_BG },
         { "9px",      OPTION_VAL_9PX_BG },
         { "10px",     OPTION_VAL_10PX_BG },
         { "11px",     OPTION_VAL_11PX_BG },
         { "12px",     OPTION_VAL_12PX_BG },
         { "13px",     OPTION_VAL_13PX_BG },
         { "14px",     OPTION_VAL_14PX_BG },
         { "15px",     OPTION_VAL_15PX_BG },
         { "16px",     OPTION_VAL_16PX_BG },
         { "17px",     OPTION_VAL_17PX_BG },
         { "18px",     OPTION_VAL_18PX_BG },
         { "19px",     OPTION_VAL_19PX_BG },
         { "20px",     OPTION_VAL_20PX_BG },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_BG,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_BG,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_BG },
         { "-11px",    OPTION_VAL_11PX_O60_BG },
         { "-10px",    OPTION_VAL_10PX_O60_BG },
         { "-9px",     OPTION_VAL_9PX_O60_BG },
         { "-8px",     OPTION_VAL_8PX_O60_BG },
         { "-7px",     OPTION_VAL_7PX_O60_BG },
         { "-6px",     OPTION_VAL_6PX_O60_BG },
         { "-5px",     OPTION_VAL_5PX_O60_BG },
         { "-4px",     OPTION_VAL_4PX_O60_BG },
         { "-3px",     OPTION_VAL_3PX_O60_BG },
         { "-2px",     OPTION_VAL_2PX_O60_BG },
         { "-1px",     OPTION_VAL_1PX_O60_BG },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_BG },
         { "+2px",     OPTION_VAL_2PX_O60_0_BG },
         { "+3px",     OPTION_VAL_3PX_O60_0_BG },
         { "+4px",     OPTION_VAL_4PX_O60_0_BG },
         { "+5px",     OPTION_VAL_5PX_O60_0_BG },
         { "+6px",     OPTION_VAL_6PX_O60_0_BG },
         { "+7px",     OPTION_VAL_7PX_O60_0_BG },
         { "+8px",     OPTION_VAL_8PX_O60_0_BG },
         { "+9px",     OPTION_VAL_9PX_O60_0_BG },
         { "+10px",    OPTION_VAL_10PX_O60_0_BG },
         { "+11px",    OPTION_VAL_11PX_O60_0_BG },
         { "+12px",    OPTION_VAL_12PX_O60_0_BG },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_BG,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_BG,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_BG,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_BG,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_BG },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_BG,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_BG,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_BG },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_BG,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_BG,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_BG },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_BG,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_BG,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_BG },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_BG,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_BG,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_BG },
         { "async",    OPTION_VAL_ASYNC_BG },
         { "precache", OPTION_VAL_PRECACHE_BG },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_BG,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_BG,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_BG },
         { "4x",          OPTION_VAL_4X_BG },
         { "6x",          OPTION_VAL_6X_BG },
         { "8x",          OPTION_VAL_8X_BG },
         { "10x",         OPTION_VAL_10X_BG },
         { "12x",         OPTION_VAL_12X_BG },
         { "14x",         OPTION_VAL_14X_BG },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_bg = {
   option_cats_bg,
   option_defs_bg
};

/* RETRO_LANGUAGE_CA */

#define CATEGORY_VIDEO_LABEL_CA "Vídeo"
#define CATEGORY_VIDEO_INFO_0_CA NULL
#define CATEGORY_OSD_LABEL_CA "Visualitzacions en Pantalla"
#define CATEGORY_OSD_INFO_0_CA NULL
#define CATEGORY_INPUT_LABEL_CA "Dispositius de joc"
#define CATEGORY_INPUT_INFO_0_CA NULL
#define CATEGORY_MEMCARDS_LABEL_CA NULL
#define CATEGORY_MEMCARDS_INFO_0_CA NULL
#define CATEGORY_PGXP_LABEL_CA NULL
#define CATEGORY_PGXP_INFO_0_CA NULL
#define CATEGORY_HACKS_LABEL_CA NULL
#define CATEGORY_HACKS_INFO_0_CA NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CA NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CA NULL
#define OPTION_VAL_1X_NATIVE_CA NULL
#define OPTION_VAL_2X_CA NULL
#define OPTION_VAL_4X_CA NULL
#define OPTION_VAL_8X_CA NULL
#define OPTION_VAL_16X_CA NULL
#define BEETLE_OPT_DEPTH_LABEL_CA NULL
#define BEETLE_OPT_DEPTH_INFO_0_CA NULL
#define OPTION_VAL_16BPP_NATIVE_CA NULL
#define OPTION_VAL_32BPP_CA NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_CA NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_CA NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_CA "Resolució Interna"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CA NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CA NULL
#define BEETLE_OPT_FILTER_LABEL_CA NULL
#define BEETLE_OPT_FILTER_INFO_0_CA NULL
#define OPTION_VAL_NEAREST_CA NULL
#define OPTION_VAL_SABR_CA NULL
#define OPTION_VAL_XBR_CA NULL
#define OPTION_VAL_BILINEAR_CA "Bilineal"
#define OPTION_VAL_3_POINT_CA NULL
#define OPTION_VAL_JINC2_CA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CA NULL
#define OPTION_VAL_OPAQUE_CA NULL
#define OPTION_VAL_ALL_CA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CA NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CA NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CA NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_CA NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_CA NULL
#define BEETLE_OPT_MSAA_LABEL_CA NULL
#define BEETLE_OPT_MSAA_INFO_0_CA NULL
#define OPTION_VAL_1X_CA NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_CA NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_CA NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_CA NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_CA NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_CA NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_CA NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_CA NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CA NULL
#define BEETLE_OPT_WIREFRAME_LABEL_CA NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_CA NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_CA NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_CA NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CA NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CA NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_CA NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_CA NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CA NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_CA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CA NULL
#define OPTION_VAL_ENABLED_ANALOG_CA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CA NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_CA NULL
#define OPTION_VAL_L1_R1_SELECT_CA NULL
#define OPTION_VAL_L1_R1_START_CA NULL
#define OPTION_VAL_L1_R1_L3_CA NULL
#define OPTION_VAL_L1_R1_R3_CA NULL
#define OPTION_VAL_L2_R2_SELECT_CA NULL
#define OPTION_VAL_L2_R2_START_CA NULL
#define OPTION_VAL_L2_R2_L3_CA NULL
#define OPTION_VAL_L2_R2_R3_CA NULL
#define OPTION_VAL_L3_R3_CA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CA NULL
#define OPTION_VAL_0_CA NULL
#define OPTION_VAL_1_CA NULL
#define OPTION_VAL_2_CA NULL
#define OPTION_VAL_3_CA NULL
#define OPTION_VAL_4_CA NULL
#define OPTION_VAL_5_CA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CA NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_CA NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CA NULL
#define OPTION_VAL_LIGHTGUN_CA NULL
#define OPTION_VAL_TOUCHSCREEN_CA NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_CA NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_CA NULL
#define OPTION_VAL_CROSS_CA NULL
#define OPTION_VAL_DOT_CA NULL
#define OPTION_VAL_OFF_CA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CA NULL
#define OPTION_VAL_RED_CA NULL
#define OPTION_VAL_BLUE_CA NULL
#define OPTION_VAL_GREEN_CA NULL
#define OPTION_VAL_ORANGE_CA NULL
#define OPTION_VAL_YELLOW_CA NULL
#define OPTION_VAL_CYAN_CA NULL
#define OPTION_VAL_PINK_CA NULL
#define OPTION_VAL_PURPLE_CA NULL
#define OPTION_VAL_BLACK_CA NULL
#define OPTION_VAL_WHITE_CA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CA NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CA NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CA NULL
#define OPTION_VAL_5_O28_CA NULL
#define OPTION_VAL_10_CA NULL
#define OPTION_VAL_15_CA NULL
#define OPTION_VAL_20_CA NULL
#define OPTION_VAL_25_CA NULL
#define OPTION_VAL_30_CA NULL
#define OPTION_VAL_35_CA NULL
#define OPTION_VAL_40_CA NULL
#define OPTION_VAL_45_CA NULL
#define OPTION_VAL_50_CA NULL
#define OPTION_VAL_55_CA NULL
#define OPTION_VAL_60_CA NULL
#define OPTION_VAL_65_CA NULL
#define OPTION_VAL_70_CA NULL
#define OPTION_VAL_75_CA NULL
#define OPTION_VAL_80_CA NULL
#define OPTION_VAL_85_CA NULL
#define OPTION_VAL_90_CA NULL
#define OPTION_VAL_95_CA NULL
#define OPTION_VAL_100_CA NULL
#define OPTION_VAL_105_CA NULL
#define OPTION_VAL_110_CA NULL
#define OPTION_VAL_115_CA NULL
#define OPTION_VAL_120_CA NULL
#define OPTION_VAL_125_CA NULL
#define OPTION_VAL_130_CA NULL
#define OPTION_VAL_135_CA NULL
#define OPTION_VAL_140_CA NULL
#define OPTION_VAL_145_CA NULL
#define OPTION_VAL_150_CA NULL
#define OPTION_VAL_155_CA NULL
#define OPTION_VAL_160_CA NULL
#define OPTION_VAL_165_CA NULL
#define OPTION_VAL_170_CA NULL
#define OPTION_VAL_175_CA NULL
#define OPTION_VAL_180_CA NULL
#define OPTION_VAL_185_CA NULL
#define OPTION_VAL_190_CA NULL
#define OPTION_VAL_195_CA NULL
#define OPTION_VAL_200_CA NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_CA NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CA NULL
#define OPTION_VAL_LINEAR_CA NULL
#define OPTION_VAL_QUADRATIC_CA NULL
#define OPTION_VAL_CUBIC_CA NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_CA NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CA NULL
#define OPTION_VAL_0_O30_CA NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CA NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CA NULL
#define OPTION_VAL_LIBRETRO_CA NULL
#define OPTION_VAL_MEDNAFEN_CA NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CA NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CA NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CA NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CA NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CA NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CA NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CA NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CA NULL
#define OPTION_VAL_1_O35_CA NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_CA NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_CA NULL
#define OPTION_VAL_MEMORY_ONLY_CA NULL
#define OPTION_VAL_MEMORY_CPU_CA NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_CA NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_CA NULL
#define OPTION_VAL_0PX_CA NULL
#define OPTION_VAL_1PX_CA NULL
#define OPTION_VAL_2PX_CA NULL
#define OPTION_VAL_3PX_CA NULL
#define OPTION_VAL_4PX_CA NULL
#define OPTION_VAL_5PX_CA NULL
#define OPTION_VAL_6PX_CA NULL
#define OPTION_VAL_7PX_CA NULL
#define OPTION_VAL_8PX_CA NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_CA NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_CA NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_CA NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_CA NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_CA NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_CA NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_CA NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_CA NULL
#define OPTION_VAL_DEFAULT_CA NULL
#define OPTION_VAL_AGGRESSIVE_CA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_CA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CA NULL
#define OPTION_VAL_16_9_CA NULL
#define OPTION_VAL_16_10_CA NULL
#define OPTION_VAL_18_9_CA NULL
#define OPTION_VAL_19_9_CA NULL
#define OPTION_VAL_20_9_CA NULL
#define OPTION_VAL_21_9_CA NULL
#define OPTION_VAL_32_9_CA NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CA NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CA NULL
#define OPTION_VAL_100_NATIVE_CA NULL
#define OPTION_VAL_210_CA NULL
#define OPTION_VAL_220_CA NULL
#define OPTION_VAL_230_CA NULL
#define OPTION_VAL_240_CA NULL
#define OPTION_VAL_250_CA NULL
#define OPTION_VAL_260_CA NULL
#define OPTION_VAL_270_CA NULL
#define OPTION_VAL_280_CA NULL
#define OPTION_VAL_290_CA NULL
#define OPTION_VAL_300_CA NULL
#define OPTION_VAL_310_CA NULL
#define OPTION_VAL_320_CA NULL
#define OPTION_VAL_330_CA NULL
#define OPTION_VAL_340_CA NULL
#define OPTION_VAL_350_CA NULL
#define OPTION_VAL_360_CA NULL
#define OPTION_VAL_370_CA NULL
#define OPTION_VAL_380_CA NULL
#define OPTION_VAL_390_CA NULL
#define OPTION_VAL_400_CA NULL
#define OPTION_VAL_410_CA NULL
#define OPTION_VAL_420_CA NULL
#define OPTION_VAL_430_CA NULL
#define OPTION_VAL_440_CA NULL
#define OPTION_VAL_450_CA NULL
#define OPTION_VAL_460_CA NULL
#define OPTION_VAL_470_CA NULL
#define OPTION_VAL_480_CA NULL
#define OPTION_VAL_490_CA NULL
#define OPTION_VAL_500_CA NULL
#define OPTION_VAL_510_CA NULL
#define OPTION_VAL_520_CA NULL
#define OPTION_VAL_530_CA NULL
#define OPTION_VAL_540_CA NULL
#define OPTION_VAL_550_CA NULL
#define OPTION_VAL_560_CA NULL
#define OPTION_VAL_570_CA NULL
#define OPTION_VAL_580_CA NULL
#define OPTION_VAL_590_CA NULL
#define OPTION_VAL_600_CA NULL
#define OPTION_VAL_610_CA NULL
#define OPTION_VAL_620_CA NULL
#define OPTION_VAL_630_CA NULL
#define OPTION_VAL_640_CA NULL
#define OPTION_VAL_650_CA NULL
#define OPTION_VAL_660_CA NULL
#define OPTION_VAL_670_CA NULL
#define OPTION_VAL_680_CA NULL
#define OPTION_VAL_690_CA NULL
#define OPTION_VAL_700_CA NULL
#define OPTION_VAL_710_CA NULL
#define OPTION_VAL_720_CA NULL
#define OPTION_VAL_730_CA NULL
#define OPTION_VAL_740_CA NULL
#define OPTION_VAL_750_CA NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_CA NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CA NULL
#define OPTION_VAL_32X_CA NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_CA NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CA NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_CA NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_CA NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_CA NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CA NULL
#define OPTION_VAL_PSXONPSP_CA NULL
#define OPTION_VAL_PS1_ROM_CA NULL
#define BEETLE_OPT_RENDERER_LABEL_CA NULL
#define BEETLE_OPT_RENDERER_INFO_0_CA NULL
#define OPTION_VAL_HARDWARE_CA NULL
#define OPTION_VAL_HARDWARE_GL_CA NULL
#define OPTION_VAL_HARDWARE_VK_CA NULL
#define OPTION_VAL_SOFTWARE_CA NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CA NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CA NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_CA NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_CA NULL
#define OPTION_VAL_DISABLED_CA NULL
#define OPTION_VAL_EXECUTE_CA NULL
#define OPTION_VAL_EXECUTE_ONE_CA NULL
#define OPTION_VAL_RUN_INTERPRETER_CA NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CA NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CA NULL
#define OPTION_VAL_FULL_CA NULL
#define OPTION_VAL_DMA_CA NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CA NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CA NULL
#define OPTION_VAL_128_CA NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CA NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CA NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_CA NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CA NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_CA NULL
#define OPTION_VAL_FORCE_INTERLACED_CA NULL
#define OPTION_VAL_AUTO_TOGGLE_CA NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CA NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CA NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_CA NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_CA NULL
#define OPTION_VAL_CORRECTED_CA NULL
#define OPTION_VAL_UNCORRECTED_CA NULL
#define OPTION_VAL_4_3_CA NULL
#define OPTION_VAL_NTSC_CA NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_CA NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_CA NULL
#define OPTION_VAL_DISABLED_O58_CA "Cap"
#define OPTION_VAL_STATIC_CA NULL
#define OPTION_VAL_SMART_CA NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_CA NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_CA NULL
#define OPTION_VAL_9PX_CA NULL
#define OPTION_VAL_10PX_CA NULL
#define OPTION_VAL_11PX_CA NULL
#define OPTION_VAL_12PX_CA NULL
#define OPTION_VAL_13PX_CA NULL
#define OPTION_VAL_14PX_CA NULL
#define OPTION_VAL_15PX_CA NULL
#define OPTION_VAL_16PX_CA NULL
#define OPTION_VAL_17PX_CA NULL
#define OPTION_VAL_18PX_CA NULL
#define OPTION_VAL_19PX_CA NULL
#define OPTION_VAL_20PX_CA NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_CA NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_CA NULL
#define OPTION_VAL_12PX_O60_CA NULL
#define OPTION_VAL_11PX_O60_CA NULL
#define OPTION_VAL_10PX_O60_CA NULL
#define OPTION_VAL_9PX_O60_CA NULL
#define OPTION_VAL_8PX_O60_CA NULL
#define OPTION_VAL_7PX_O60_CA NULL
#define OPTION_VAL_6PX_O60_CA NULL
#define OPTION_VAL_5PX_O60_CA NULL
#define OPTION_VAL_4PX_O60_CA NULL
#define OPTION_VAL_3PX_O60_CA NULL
#define OPTION_VAL_2PX_O60_CA NULL
#define OPTION_VAL_1PX_O60_CA NULL
#define OPTION_VAL_1PX_O60_0_CA NULL
#define OPTION_VAL_2PX_O60_0_CA NULL
#define OPTION_VAL_3PX_O60_0_CA NULL
#define OPTION_VAL_4PX_O60_0_CA NULL
#define OPTION_VAL_5PX_O60_0_CA NULL
#define OPTION_VAL_6PX_O60_0_CA NULL
#define OPTION_VAL_7PX_O60_0_CA NULL
#define OPTION_VAL_8PX_O60_0_CA NULL
#define OPTION_VAL_9PX_O60_0_CA NULL
#define OPTION_VAL_10PX_O60_0_CA NULL
#define OPTION_VAL_11PX_O60_0_CA NULL
#define OPTION_VAL_12PX_O60_0_CA NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CA NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_CA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CA NULL
#define OPTION_VAL_0_O62_CA NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_CA NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_CA NULL
#define OPTION_VAL_239_CA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CA NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CA NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CA NULL
#define OPTION_VAL_287_CA NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CA NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CA NULL
#define OPTION_VAL_SYNC_CA NULL
#define OPTION_VAL_ASYNC_CA NULL
#define OPTION_VAL_PRECACHE_CA NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_CA NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_CA NULL
#define OPTION_VAL_2X_NATIVE_CA NULL
#define OPTION_VAL_6X_CA NULL
#define OPTION_VAL_10X_CA NULL
#define OPTION_VAL_12X_CA NULL
#define OPTION_VAL_14X_CA NULL

struct retro_core_option_v2_category option_cats_ca[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CA,
      CATEGORY_VIDEO_INFO_0_CA
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_CA,
      CATEGORY_OSD_INFO_0_CA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CA,
      CATEGORY_INPUT_INFO_0_CA
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_CA,
      CATEGORY_MEMCARDS_INFO_0_CA
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_CA,
      CATEGORY_PGXP_INFO_0_CA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CA,
      CATEGORY_HACKS_INFO_0_CA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ca[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CA,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CA,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CA },
         { "2x",         OPTION_VAL_2X_CA },
         { "4x",         OPTION_VAL_4X_CA },
         { "8x",         OPTION_VAL_8X_CA },
         { "16x",        OPTION_VAL_16X_CA },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_CA,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_CA,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_CA },
         { "32bpp",         OPTION_VAL_32BPP_CA },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_CA,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_CA,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_CA },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_CA },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CA,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CA,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_CA,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_CA,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_CA },
         { "SABR",     OPTION_VAL_SABR_CA },
         { "xBR",      OPTION_VAL_XBR_CA },
         { "bilinear", OPTION_VAL_BILINEAR_CA },
         { "3-point",  OPTION_VAL_3_POINT_CA },
         { "JINC2",    OPTION_VAL_JINC2_CA },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CA,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CA },
         { "all", OPTION_VAL_ALL_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CA,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CA },
         { "all", OPTION_VAL_ALL_CA },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CA,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_CA,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_CA,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_CA,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_CA },
         { "2x",  OPTION_VAL_2X_CA },
         { "4x",  OPTION_VAL_4X_CA },
         { "8x",  OPTION_VAL_8X_CA },
         { "16x", OPTION_VAL_16X_CA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_CA,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_CA,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_CA,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_CA,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_CA,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_CA,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CA,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CA,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_CA,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_CA,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CA,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_CA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CA,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_CA },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_CA },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_CA },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_CA },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_CA },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_CA },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_CA },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_CA },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_CA },
         { "l3+r3",                    OPTION_VAL_L3_R3_CA },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CA,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_CA },
         { "1", OPTION_VAL_1_CA },
         { "2", OPTION_VAL_2_CA },
         { "3", OPTION_VAL_3_CA },
         { "4", OPTION_VAL_4_CA },
         { "5", OPTION_VAL_5_CA },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CA,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CA,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_CA,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CA },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_CA,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_CA,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_CA },
         { "dot",   OPTION_VAL_DOT_CA },
         { "off",   OPTION_VAL_OFF_CA },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CA,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CA,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_CA },
         { "blue", OPTION_VAL_BLUE_CA },
         { "green", OPTION_VAL_GREEN_CA },
         { "orange", OPTION_VAL_ORANGE_CA },
         { "yellow", OPTION_VAL_YELLOW_CA },
         { "cyan", OPTION_VAL_CYAN_CA },
         { "pink", OPTION_VAL_PINK_CA },
         { "purple", OPTION_VAL_PURPLE_CA },
         { "black", OPTION_VAL_BLACK_CA },
         { "white", OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CA,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CA,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_CA },
         { "red", OPTION_VAL_RED_CA },
         { "green", OPTION_VAL_GREEN_CA },
         { "orange", OPTION_VAL_ORANGE_CA },
         { "yellow", OPTION_VAL_YELLOW_CA },
         { "cyan", OPTION_VAL_CYAN_CA },
         { "pink", OPTION_VAL_PINK_CA },
         { "purple", OPTION_VAL_PURPLE_CA },
         { "black", OPTION_VAL_BLACK_CA },
         { "white", OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CA,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CA,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_CA },
         { "10%",  OPTION_VAL_10_CA },
         { "15%",  OPTION_VAL_15_CA },
         { "20%",  OPTION_VAL_20_CA },
         { "25%",  OPTION_VAL_25_CA },
         { "30%",  OPTION_VAL_30_CA },
         { "35%",  OPTION_VAL_35_CA },
         { "40%",  OPTION_VAL_40_CA },
         { "45%",  OPTION_VAL_45_CA },
         { "50%",  OPTION_VAL_50_CA },
         { "55%",  OPTION_VAL_55_CA },
         { "60%",  OPTION_VAL_60_CA },
         { "65%",  OPTION_VAL_65_CA },
         { "70%",  OPTION_VAL_70_CA },
         { "75%",  OPTION_VAL_75_CA },
         { "80%",  OPTION_VAL_80_CA },
         { "85%",  OPTION_VAL_85_CA },
         { "90%",  OPTION_VAL_90_CA },
         { "95%",  OPTION_VAL_95_CA },
         { "100%", OPTION_VAL_100_CA },
         { "105%", OPTION_VAL_105_CA },
         { "110%", OPTION_VAL_110_CA },
         { "115%", OPTION_VAL_115_CA },
         { "120%", OPTION_VAL_120_CA },
         { "125%", OPTION_VAL_125_CA },
         { "130%", OPTION_VAL_130_CA },
         { "135%", OPTION_VAL_135_CA },
         { "140%", OPTION_VAL_140_CA },
         { "145%", OPTION_VAL_145_CA },
         { "150%", OPTION_VAL_150_CA },
         { "155%", OPTION_VAL_155_CA },
         { "160%", OPTION_VAL_160_CA },
         { "165%", OPTION_VAL_165_CA },
         { "170%", OPTION_VAL_170_CA },
         { "175%", OPTION_VAL_175_CA },
         { "180%", OPTION_VAL_180_CA },
         { "185%", OPTION_VAL_185_CA },
         { "190%", OPTION_VAL_190_CA },
         { "195%", OPTION_VAL_195_CA },
         { "200%", OPTION_VAL_200_CA },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_CA,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CA,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_CA },
         { "quadratic", OPTION_VAL_QUADRATIC_CA },
         { "cubic",     OPTION_VAL_CUBIC_CA },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_CA,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CA,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_CA },
         { "5%",  OPTION_VAL_5_O28_CA },
         { "10%", OPTION_VAL_10_CA },
         { "15%", OPTION_VAL_15_CA },
         { "20%", OPTION_VAL_20_CA },
         { "25%", OPTION_VAL_25_CA },
         { "30%", OPTION_VAL_30_CA },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CA,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CA,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_CA },
         { "mednafen", OPTION_VAL_MEDNAFEN_CA },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CA,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CA,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CA,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CA,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CA,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CA,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CA,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CA,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_CA },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_CA,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_CA,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_CA },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_CA,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_CA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_CA },
         { "1px", OPTION_VAL_1PX_CA },
         { "2px", OPTION_VAL_2PX_CA },
         { "3px", OPTION_VAL_3PX_CA },
         { "4px", OPTION_VAL_4PX_CA },
         { "5px", OPTION_VAL_5PX_CA },
         { "6px", OPTION_VAL_6PX_CA },
         { "7px", OPTION_VAL_7PX_CA },
         { "8px", OPTION_VAL_8PX_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_CA,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_CA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_CA,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_CA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_CA,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_CA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_CA,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_CA },
         { "aggressive", OPTION_VAL_AGGRESSIVE_CA },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_CA,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CA,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_CA },
         { "16:10", OPTION_VAL_16_10_CA },
         { "18:9",  OPTION_VAL_18_9_CA },
         { "19:9",  OPTION_VAL_19_9_CA },
         { "20:9",  OPTION_VAL_20_9_CA },
         { "21:9",  OPTION_VAL_21_9_CA }, // 64:27
         { "32:9",  OPTION_VAL_32_9_CA },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CA,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_CA },
         { "60%",           OPTION_VAL_60_CA },
         { "70%",           OPTION_VAL_70_CA },
         { "80%",           OPTION_VAL_80_CA },
         { "90%",           OPTION_VAL_90_CA },
         { "100%(native)", OPTION_VAL_100_NATIVE_CA },
         { "110%",          OPTION_VAL_110_CA },
         { "120%",          OPTION_VAL_120_CA },
         { "130%",          OPTION_VAL_130_CA },
         { "140%",          OPTION_VAL_140_CA },
         { "150%",          OPTION_VAL_150_CA },
         { "160%",          OPTION_VAL_160_CA },
         { "170%",          OPTION_VAL_170_CA },
         { "180%",          OPTION_VAL_180_CA },
         { "190%",          OPTION_VAL_190_CA },
         { "200%",          OPTION_VAL_200_CA },
         { "210%",          OPTION_VAL_210_CA },
         { "220%",          OPTION_VAL_220_CA },
         { "230%",          OPTION_VAL_230_CA },
         { "240%",          OPTION_VAL_240_CA },
         { "250%",          OPTION_VAL_250_CA },
         { "260%",          OPTION_VAL_260_CA },
         { "270%",          OPTION_VAL_270_CA },
         { "280%",          OPTION_VAL_280_CA },
         { "290%",          OPTION_VAL_290_CA },
         { "300%",          OPTION_VAL_300_CA },
         { "310%",          OPTION_VAL_310_CA },
         { "320%",          OPTION_VAL_320_CA },
         { "330%",          OPTION_VAL_330_CA },
         { "340%",          OPTION_VAL_340_CA },
         { "350%",          OPTION_VAL_350_CA },
         { "360%",          OPTION_VAL_360_CA },
         { "370%",          OPTION_VAL_370_CA },
         { "380%",          OPTION_VAL_380_CA },
         { "390%",          OPTION_VAL_390_CA },
         { "400%",          OPTION_VAL_400_CA },
         { "410%",          OPTION_VAL_410_CA },
         { "420%",          OPTION_VAL_420_CA },
         { "430%",          OPTION_VAL_430_CA },
         { "440%",          OPTION_VAL_440_CA },
         { "450%",          OPTION_VAL_450_CA },
         { "460%",          OPTION_VAL_460_CA },
         { "470%",          OPTION_VAL_470_CA },
         { "480%",          OPTION_VAL_480_CA },
         { "490%",          OPTION_VAL_490_CA },
         { "500%",          OPTION_VAL_500_CA },
         { "510%",          OPTION_VAL_510_CA },
         { "520%",          OPTION_VAL_520_CA },
         { "530%",          OPTION_VAL_530_CA },
         { "540%",          OPTION_VAL_540_CA },
         { "550%",          OPTION_VAL_550_CA },
         { "560%",          OPTION_VAL_560_CA },
         { "570%",          OPTION_VAL_570_CA },
         { "580%",          OPTION_VAL_580_CA },
         { "590%",          OPTION_VAL_590_CA },
         { "600%",          OPTION_VAL_600_CA },
         { "610%",          OPTION_VAL_610_CA },
         { "620%",          OPTION_VAL_620_CA },
         { "630%",          OPTION_VAL_630_CA },
         { "640%",          OPTION_VAL_640_CA },
         { "650%",          OPTION_VAL_650_CA },
         { "660%",          OPTION_VAL_660_CA },
         { "670%",          OPTION_VAL_670_CA },
         { "680%",          OPTION_VAL_680_CA },
         { "690%",          OPTION_VAL_690_CA },
         { "700%",          OPTION_VAL_700_CA },
         { "710%",          OPTION_VAL_710_CA },
         { "720%",          OPTION_VAL_720_CA },
         { "730%",          OPTION_VAL_730_CA },
         { "740%",          OPTION_VAL_740_CA },
         { "750%",          OPTION_VAL_750_CA },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_CA,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CA },
         { "2x",         OPTION_VAL_2X_CA },
         { "4x",         OPTION_VAL_4X_CA },
         { "8x",         OPTION_VAL_8X_CA },
         { "16x",        OPTION_VAL_16X_CA },
         { "32x",        OPTION_VAL_32X_CA },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_CA,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_CA,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_CA,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_CA },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_CA },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_CA,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_CA,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_CA },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_CA },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_CA },
#endif
         { "software",    OPTION_VAL_SOFTWARE_CA },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CA,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CA,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_CA,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_CA,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_CA },
         { "execute",  OPTION_VAL_EXECUTE_CA },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_CA },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CA,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CA,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_CA },
         { "dma",  OPTION_VAL_DMA_CA },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CA,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_CA },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CA,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_CA },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_CA,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CA,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_CA },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_CA },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_CA },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CA,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_CA,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_CA,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_CA },
         { "uncorrected", OPTION_VAL_UNCORRECTED_CA },
         { "4:3",  OPTION_VAL_4_3_CA },
         { "ntsc", OPTION_VAL_NTSC_CA },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_CA,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_CA },
         { "static",  OPTION_VAL_STATIC_CA },
         { "smart", OPTION_VAL_SMART_CA },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_CA,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_CA },
         { "2px",      OPTION_VAL_2PX_CA },
         { "3px",      OPTION_VAL_3PX_CA },
         { "4px",      OPTION_VAL_4PX_CA },
         { "5px",      OPTION_VAL_5PX_CA },
         { "6px",      OPTION_VAL_6PX_CA },
         { "7px",      OPTION_VAL_7PX_CA },
         { "8px",      OPTION_VAL_8PX_CA },
         { "9px",      OPTION_VAL_9PX_CA },
         { "10px",     OPTION_VAL_10PX_CA },
         { "11px",     OPTION_VAL_11PX_CA },
         { "12px",     OPTION_VAL_12PX_CA },
         { "13px",     OPTION_VAL_13PX_CA },
         { "14px",     OPTION_VAL_14PX_CA },
         { "15px",     OPTION_VAL_15PX_CA },
         { "16px",     OPTION_VAL_16PX_CA },
         { "17px",     OPTION_VAL_17PX_CA },
         { "18px",     OPTION_VAL_18PX_CA },
         { "19px",     OPTION_VAL_19PX_CA },
         { "20px",     OPTION_VAL_20PX_CA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_CA,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_CA,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_CA },
         { "-11px",    OPTION_VAL_11PX_O60_CA },
         { "-10px",    OPTION_VAL_10PX_O60_CA },
         { "-9px",     OPTION_VAL_9PX_O60_CA },
         { "-8px",     OPTION_VAL_8PX_O60_CA },
         { "-7px",     OPTION_VAL_7PX_O60_CA },
         { "-6px",     OPTION_VAL_6PX_O60_CA },
         { "-5px",     OPTION_VAL_5PX_O60_CA },
         { "-4px",     OPTION_VAL_4PX_O60_CA },
         { "-3px",     OPTION_VAL_3PX_O60_CA },
         { "-2px",     OPTION_VAL_2PX_O60_CA },
         { "-1px",     OPTION_VAL_1PX_O60_CA },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_CA },
         { "+2px",     OPTION_VAL_2PX_O60_0_CA },
         { "+3px",     OPTION_VAL_3PX_O60_0_CA },
         { "+4px",     OPTION_VAL_4PX_O60_0_CA },
         { "+5px",     OPTION_VAL_5PX_O60_0_CA },
         { "+6px",     OPTION_VAL_6PX_O60_0_CA },
         { "+7px",     OPTION_VAL_7PX_O60_0_CA },
         { "+8px",     OPTION_VAL_8PX_O60_0_CA },
         { "+9px",     OPTION_VAL_9PX_O60_0_CA },
         { "+10px",    OPTION_VAL_10PX_O60_0_CA },
         { "+11px",    OPTION_VAL_11PX_O60_0_CA },
         { "+12px",    OPTION_VAL_12PX_O60_0_CA },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CA,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CA,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_CA,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CA },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_CA,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_CA,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_CA },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CA,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CA },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CA,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CA,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_CA },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CA,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CA,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_CA },
         { "async",    OPTION_VAL_ASYNC_CA },
         { "precache", OPTION_VAL_PRECACHE_CA },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_CA,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_CA,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_CA },
         { "4x",          OPTION_VAL_4X_CA },
         { "6x",          OPTION_VAL_6X_CA },
         { "8x",          OPTION_VAL_8X_CA },
         { "10x",         OPTION_VAL_10X_CA },
         { "12x",         OPTION_VAL_12X_CA },
         { "14x",         OPTION_VAL_14X_CA },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ca = {
   option_cats_ca,
   option_defs_ca
};

/* RETRO_LANGUAGE_CHS */

#define CATEGORY_VIDEO_LABEL_CHS "视频"
#define CATEGORY_VIDEO_INFO_0_CHS "更改长宽比、显示裁剪、视频过滤和帧跳过设置。"
#define CATEGORY_OSD_LABEL_CHS "屏显"
#define CATEGORY_OSD_INFO_0_CHS NULL
#define CATEGORY_INPUT_LABEL_CHS "输入"
#define CATEGORY_INPUT_INFO_0_CHS NULL
#define CATEGORY_MEMCARDS_LABEL_CHS "内存卡"
#define CATEGORY_MEMCARDS_INFO_0_CHS NULL
#define CATEGORY_PGXP_LABEL_CHS "PGXP (几何变换管道)"
#define CATEGORY_PGXP_INFO_0_CHS "这些选项控制增强，可以改进图形与原始控制台相比。PGXP可以消除弹形图和 Z-战斗问题。"
#define CATEGORY_HACKS_LABEL_CHS "模拟修改"
#define CATEGORY_HACKS_INFO_0_CHS NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CHS "内部GPU分辨率"
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CHS NULL
#define OPTION_VAL_1X_NATIVE_CHS "1x (原始)"
#define OPTION_VAL_2X_CHS "2 倍"
#define OPTION_VAL_4X_CHS "4 倍"
#define OPTION_VAL_8X_CHS "8 倍"
#define OPTION_VAL_16X_CHS "16 倍"
#define BEETLE_OPT_DEPTH_LABEL_CHS "内部色深度"
#define BEETLE_OPT_DEPTH_INFO_0_CHS NULL
#define OPTION_VAL_16BPP_NATIVE_CHS "16位像素(原始)"
#define OPTION_VAL_32BPP_CHS "32位像素"
#define BEETLE_OPT_DITHER_MODE_LABEL_CHS "抖动模式"
#define BEETLE_OPT_DITHER_MODE_INFO_0_CHS NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_CHS "内部分辨率"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CHS "纹理紫外线偏移"
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CHS NULL
#define BEETLE_OPT_FILTER_LABEL_CHS "纹理过滤"
#define BEETLE_OPT_FILTER_INFO_0_CHS NULL
#define OPTION_VAL_NEAREST_CHS "最近的"
#define OPTION_VAL_SABR_CHS NULL
#define OPTION_VAL_XBR_CHS NULL
#define OPTION_VAL_BILINEAR_CHS "双线性"
#define OPTION_VAL_3_POINT_CHS "3 点"
#define OPTION_VAL_JINC2_CHS NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CHS "从过滤中排除素材"
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CHS NULL
#define OPTION_VAL_OPAQUE_CHS "仅不透明度"
#define OPTION_VAL_ALL_CHS "不透明和半透明度"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CHS "排除筛选中的 2D 多边形"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CHS "不要将纹理过滤器应用到2D多边形。检测到2D多边形带有激发性，可能会有眼镜。 与自适应平滑或其他后处理过滤器一起使用以获取最佳效果。"
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CHS "自适应平滑化"
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CHS NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_CHS "超大(从样本到原生分辨率)"
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_CHS NULL
#define BEETLE_OPT_MSAA_LABEL_CHS "多重采样抗锯齿轮模式"
#define BEETLE_OPT_MSAA_INFO_0_CHS NULL
#define OPTION_VAL_1X_CHS NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_CHS NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_CHS NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_CHS NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_CHS NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_CHS NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_CHS NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_CHS NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CHS NULL
#define BEETLE_OPT_WIREFRAME_LABEL_CHS NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_CHS NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_CHS NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_CHS NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CHS NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CHS NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_CHS NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_CHS NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CHS NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CHS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_CHS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CHS NULL
#define OPTION_VAL_ENABLED_ANALOG_CHS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CHS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CHS NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_CHS NULL
#define OPTION_VAL_L1_R1_SELECT_CHS NULL
#define OPTION_VAL_L1_R1_START_CHS NULL
#define OPTION_VAL_L1_R1_L3_CHS NULL
#define OPTION_VAL_L1_R1_R3_CHS NULL
#define OPTION_VAL_L2_R2_SELECT_CHS NULL
#define OPTION_VAL_L2_R2_START_CHS NULL
#define OPTION_VAL_L2_R2_L3_CHS NULL
#define OPTION_VAL_L2_R2_R3_CHS NULL
#define OPTION_VAL_L3_R3_CHS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CHS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CHS NULL
#define OPTION_VAL_0_CHS NULL
#define OPTION_VAL_1_CHS NULL
#define OPTION_VAL_2_CHS NULL
#define OPTION_VAL_3_CHS NULL
#define OPTION_VAL_4_CHS NULL
#define OPTION_VAL_5_CHS NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CHS NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CHS NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CHS NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CHS NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_CHS NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CHS NULL
#define OPTION_VAL_LIGHTGUN_CHS NULL
#define OPTION_VAL_TOUCHSCREEN_CHS NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_CHS NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_CHS NULL
#define OPTION_VAL_CROSS_CHS "叉"
#define OPTION_VAL_DOT_CHS "点"
#define OPTION_VAL_OFF_CHS "无光标"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CHS NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CHS NULL
#define OPTION_VAL_RED_CHS "红色"
#define OPTION_VAL_BLUE_CHS "蓝色"
#define OPTION_VAL_GREEN_CHS "绿色"
#define OPTION_VAL_ORANGE_CHS "奥朗日"
#define OPTION_VAL_YELLOW_CHS "黄色"
#define OPTION_VAL_CYAN_CHS "青色"
#define OPTION_VAL_PINK_CHS "粉"
#define OPTION_VAL_PURPLE_CHS "紫色"
#define OPTION_VAL_BLACK_CHS "浓体 (Black)"
#define OPTION_VAL_WHITE_CHS "白色"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CHS NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CHS NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CHS "鼠标灵敏度"
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CHS NULL
#define OPTION_VAL_5_O28_CHS NULL
#define OPTION_VAL_10_CHS NULL
#define OPTION_VAL_15_CHS NULL
#define OPTION_VAL_20_CHS NULL
#define OPTION_VAL_25_CHS NULL
#define OPTION_VAL_30_CHS NULL
#define OPTION_VAL_35_CHS NULL
#define OPTION_VAL_40_CHS NULL
#define OPTION_VAL_45_CHS NULL
#define OPTION_VAL_50_CHS NULL
#define OPTION_VAL_55_CHS NULL
#define OPTION_VAL_60_CHS NULL
#define OPTION_VAL_65_CHS NULL
#define OPTION_VAL_70_CHS NULL
#define OPTION_VAL_75_CHS NULL
#define OPTION_VAL_80_CHS NULL
#define OPTION_VAL_85_CHS NULL
#define OPTION_VAL_90_CHS NULL
#define OPTION_VAL_95_CHS NULL
#define OPTION_VAL_100_CHS NULL
#define OPTION_VAL_105_CHS NULL
#define OPTION_VAL_110_CHS NULL
#define OPTION_VAL_115_CHS NULL
#define OPTION_VAL_120_CHS NULL
#define OPTION_VAL_125_CHS NULL
#define OPTION_VAL_130_CHS NULL
#define OPTION_VAL_135_CHS NULL
#define OPTION_VAL_140_CHS NULL
#define OPTION_VAL_145_CHS NULL
#define OPTION_VAL_150_CHS NULL
#define OPTION_VAL_155_CHS NULL
#define OPTION_VAL_160_CHS NULL
#define OPTION_VAL_165_CHS NULL
#define OPTION_VAL_170_CHS NULL
#define OPTION_VAL_175_CHS NULL
#define OPTION_VAL_180_CHS NULL
#define OPTION_VAL_185_CHS NULL
#define OPTION_VAL_190_CHS NULL
#define OPTION_VAL_195_CHS NULL
#define OPTION_VAL_200_CHS NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_CHS NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CHS NULL
#define OPTION_VAL_LINEAR_CHS "线性"
#define OPTION_VAL_QUADRATIC_CHS "平方"
#define OPTION_VAL_CUBIC_CHS "立方"
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_CHS NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CHS NULL
#define OPTION_VAL_0_O30_CHS NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CHS "内存卡 0 操作(需要重启)"
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CHS "选择用于内存卡0的保存数据格式。“Mednafen”可以用于兼容独立版Mednafen。 当和 Beetle PSX使用时，Libretro (.srm) 和 Mednafen (.mcr) 保存具有内部相同的格式，可以通过重命名相互转换。"
#define OPTION_VAL_LIBRETRO_CHS NULL
#define OPTION_VAL_MEDNAFEN_CHS NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CHS "启用内存卡 1 (需要重启)"
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CHS NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CHS "共享内存卡(需要重启)"
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CHS "如果启用，所有游戏都将保存并从相同的内存卡文件中加载。 当禁用时，将为已加载的每个内容生成单独的内存卡文件。 注意：如果“内存卡0方法”设置为“Libret”，只有正确的内存卡会受到影响。"
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CHS "内存卡左边索引"
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CHS NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CHS NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CHS NULL
#define OPTION_VAL_1_O35_CHS NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_CHS NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_CHS NULL
#define OPTION_VAL_MEMORY_ONLY_CHS NULL
#define OPTION_VAL_MEMORY_CPU_CHS NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_CHS NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_CHS NULL
#define OPTION_VAL_0PX_CHS NULL
#define OPTION_VAL_1PX_CHS NULL
#define OPTION_VAL_2PX_CHS NULL
#define OPTION_VAL_3PX_CHS NULL
#define OPTION_VAL_4PX_CHS NULL
#define OPTION_VAL_5PX_CHS NULL
#define OPTION_VAL_6PX_CHS NULL
#define OPTION_VAL_7PX_CHS NULL
#define OPTION_VAL_8PX_CHS NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_CHS NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_CHS NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_CHS NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_CHS NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_CHS NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_CHS NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_CHS NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_CHS NULL
#define OPTION_VAL_DEFAULT_CHS "默认"
#define OPTION_VAL_AGGRESSIVE_CHS "激进"
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_CHS NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CHS NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CHS NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CHS NULL
#define OPTION_VAL_16_9_CHS NULL
#define OPTION_VAL_16_10_CHS NULL
#define OPTION_VAL_18_9_CHS NULL
#define OPTION_VAL_19_9_CHS NULL
#define OPTION_VAL_20_9_CHS NULL
#define OPTION_VAL_21_9_CHS NULL
#define OPTION_VAL_32_9_CHS NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CHS NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CHS NULL
#define OPTION_VAL_100_NATIVE_CHS NULL
#define OPTION_VAL_210_CHS NULL
#define OPTION_VAL_220_CHS NULL
#define OPTION_VAL_230_CHS NULL
#define OPTION_VAL_240_CHS NULL
#define OPTION_VAL_250_CHS NULL
#define OPTION_VAL_260_CHS NULL
#define OPTION_VAL_270_CHS NULL
#define OPTION_VAL_280_CHS NULL
#define OPTION_VAL_290_CHS NULL
#define OPTION_VAL_300_CHS NULL
#define OPTION_VAL_310_CHS NULL
#define OPTION_VAL_320_CHS NULL
#define OPTION_VAL_330_CHS NULL
#define OPTION_VAL_340_CHS NULL
#define OPTION_VAL_350_CHS NULL
#define OPTION_VAL_360_CHS NULL
#define OPTION_VAL_370_CHS NULL
#define OPTION_VAL_380_CHS NULL
#define OPTION_VAL_390_CHS NULL
#define OPTION_VAL_400_CHS NULL
#define OPTION_VAL_410_CHS NULL
#define OPTION_VAL_420_CHS NULL
#define OPTION_VAL_430_CHS NULL
#define OPTION_VAL_440_CHS NULL
#define OPTION_VAL_450_CHS NULL
#define OPTION_VAL_460_CHS NULL
#define OPTION_VAL_470_CHS NULL
#define OPTION_VAL_480_CHS NULL
#define OPTION_VAL_490_CHS NULL
#define OPTION_VAL_500_CHS NULL
#define OPTION_VAL_510_CHS NULL
#define OPTION_VAL_520_CHS NULL
#define OPTION_VAL_530_CHS NULL
#define OPTION_VAL_540_CHS NULL
#define OPTION_VAL_550_CHS NULL
#define OPTION_VAL_560_CHS NULL
#define OPTION_VAL_570_CHS NULL
#define OPTION_VAL_580_CHS NULL
#define OPTION_VAL_590_CHS NULL
#define OPTION_VAL_600_CHS NULL
#define OPTION_VAL_610_CHS NULL
#define OPTION_VAL_620_CHS NULL
#define OPTION_VAL_630_CHS NULL
#define OPTION_VAL_640_CHS NULL
#define OPTION_VAL_650_CHS NULL
#define OPTION_VAL_660_CHS NULL
#define OPTION_VAL_670_CHS NULL
#define OPTION_VAL_680_CHS NULL
#define OPTION_VAL_690_CHS NULL
#define OPTION_VAL_700_CHS NULL
#define OPTION_VAL_710_CHS NULL
#define OPTION_VAL_720_CHS NULL
#define OPTION_VAL_730_CHS NULL
#define OPTION_VAL_740_CHS NULL
#define OPTION_VAL_750_CHS NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_CHS NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CHS NULL
#define OPTION_VAL_32X_CHS NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_CHS NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CHS NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_CHS NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_CHS NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_CHS NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CHS NULL
#define OPTION_VAL_PSXONPSP_CHS NULL
#define OPTION_VAL_PS1_ROM_CHS NULL
#define BEETLE_OPT_RENDERER_LABEL_CHS NULL
#define BEETLE_OPT_RENDERER_INFO_0_CHS NULL
#define OPTION_VAL_HARDWARE_CHS NULL
#define OPTION_VAL_HARDWARE_GL_CHS NULL
#define OPTION_VAL_HARDWARE_VK_CHS NULL
#define OPTION_VAL_SOFTWARE_CHS "软件"
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CHS NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CHS NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_CHS NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_CHS NULL
#define OPTION_VAL_DISABLED_CHS NULL
#define OPTION_VAL_EXECUTE_CHS NULL
#define OPTION_VAL_EXECUTE_ONE_CHS NULL
#define OPTION_VAL_RUN_INTERPRETER_CHS NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CHS NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CHS NULL
#define OPTION_VAL_FULL_CHS "全双工"
#define OPTION_VAL_DMA_CHS NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CHS NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CHS NULL
#define OPTION_VAL_128_CHS NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CHS NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CHS NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_CHS NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CHS NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_CHS NULL
#define OPTION_VAL_FORCE_INTERLACED_CHS NULL
#define OPTION_VAL_AUTO_TOGGLE_CHS NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CHS NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CHS NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_CHS NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_CHS NULL
#define OPTION_VAL_CORRECTED_CHS NULL
#define OPTION_VAL_UNCORRECTED_CHS NULL
#define OPTION_VAL_4_3_CHS NULL
#define OPTION_VAL_NTSC_CHS NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_CHS NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_CHS NULL
#define OPTION_VAL_DISABLED_O58_CHS "无"
#define OPTION_VAL_STATIC_CHS "静态"
#define OPTION_VAL_SMART_CHS NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_CHS NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_CHS NULL
#define OPTION_VAL_9PX_CHS NULL
#define OPTION_VAL_10PX_CHS NULL
#define OPTION_VAL_11PX_CHS NULL
#define OPTION_VAL_12PX_CHS NULL
#define OPTION_VAL_13PX_CHS NULL
#define OPTION_VAL_14PX_CHS NULL
#define OPTION_VAL_15PX_CHS NULL
#define OPTION_VAL_16PX_CHS NULL
#define OPTION_VAL_17PX_CHS NULL
#define OPTION_VAL_18PX_CHS NULL
#define OPTION_VAL_19PX_CHS NULL
#define OPTION_VAL_20PX_CHS NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_CHS NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_CHS NULL
#define OPTION_VAL_12PX_O60_CHS NULL
#define OPTION_VAL_11PX_O60_CHS NULL
#define OPTION_VAL_10PX_O60_CHS NULL
#define OPTION_VAL_9PX_O60_CHS NULL
#define OPTION_VAL_8PX_O60_CHS NULL
#define OPTION_VAL_7PX_O60_CHS NULL
#define OPTION_VAL_6PX_O60_CHS NULL
#define OPTION_VAL_5PX_O60_CHS NULL
#define OPTION_VAL_4PX_O60_CHS NULL
#define OPTION_VAL_3PX_O60_CHS NULL
#define OPTION_VAL_2PX_O60_CHS NULL
#define OPTION_VAL_1PX_O60_CHS NULL
#define OPTION_VAL_1PX_O60_0_CHS NULL
#define OPTION_VAL_2PX_O60_0_CHS NULL
#define OPTION_VAL_3PX_O60_0_CHS NULL
#define OPTION_VAL_4PX_O60_0_CHS NULL
#define OPTION_VAL_5PX_O60_0_CHS NULL
#define OPTION_VAL_6PX_O60_0_CHS NULL
#define OPTION_VAL_7PX_O60_0_CHS NULL
#define OPTION_VAL_8PX_O60_0_CHS NULL
#define OPTION_VAL_9PX_O60_0_CHS NULL
#define OPTION_VAL_10PX_O60_0_CHS NULL
#define OPTION_VAL_11PX_O60_0_CHS NULL
#define OPTION_VAL_12PX_O60_0_CHS NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CHS NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CHS NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_CHS NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CHS NULL
#define OPTION_VAL_0_O62_CHS NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_CHS NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_CHS NULL
#define OPTION_VAL_239_CHS "239 (默认)"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CHS NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CHS NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CHS NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CHS NULL
#define OPTION_VAL_287_CHS "287 (默认)"
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CHS NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CHS NULL
#define OPTION_VAL_SYNC_CHS NULL
#define OPTION_VAL_ASYNC_CHS NULL
#define OPTION_VAL_PRECACHE_CHS NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_CHS NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_CHS NULL
#define OPTION_VAL_2X_NATIVE_CHS NULL
#define OPTION_VAL_6X_CHS NULL
#define OPTION_VAL_10X_CHS NULL
#define OPTION_VAL_12X_CHS NULL
#define OPTION_VAL_14X_CHS NULL

struct retro_core_option_v2_category option_cats_chs[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHS,
      CATEGORY_VIDEO_INFO_0_CHS
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_CHS,
      CATEGORY_OSD_INFO_0_CHS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHS,
      CATEGORY_INPUT_INFO_0_CHS
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_CHS,
      CATEGORY_MEMCARDS_INFO_0_CHS
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_CHS,
      CATEGORY_PGXP_INFO_0_CHS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHS,
      CATEGORY_HACKS_INFO_0_CHS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_chs[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CHS,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CHS,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CHS },
         { "2x",         OPTION_VAL_2X_CHS },
         { "4x",         OPTION_VAL_4X_CHS },
         { "8x",         OPTION_VAL_8X_CHS },
         { "16x",        OPTION_VAL_16X_CHS },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_CHS,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_CHS,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_CHS },
         { "32bpp",         OPTION_VAL_32BPP_CHS },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_CHS,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_CHS },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_CHS },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CHS,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CHS,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_CHS,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_CHS },
         { "SABR",     OPTION_VAL_SABR_CHS },
         { "xBR",      OPTION_VAL_XBR_CHS },
         { "bilinear", OPTION_VAL_BILINEAR_CHS },
         { "3-point",  OPTION_VAL_3_POINT_CHS },
         { "JINC2",    OPTION_VAL_JINC2_CHS },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CHS,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CHS },
         { "all", OPTION_VAL_ALL_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CHS,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CHS },
         { "all", OPTION_VAL_ALL_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CHS,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_CHS,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_CHS,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_CHS,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_CHS },
         { "2x",  OPTION_VAL_2X_CHS },
         { "4x",  OPTION_VAL_4X_CHS },
         { "8x",  OPTION_VAL_8X_CHS },
         { "16x", OPTION_VAL_16X_CHS },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_CHS,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_CHS,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_CHS,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_CHS,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_CHS,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_CHS,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CHS,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CHS,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_CHS,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_CHS,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CHS,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_CHS,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CHS,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CHS,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_CHS },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_CHS },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_CHS },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_CHS },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_CHS },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_CHS },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_CHS },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_CHS },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_CHS },
         { "l3+r3",                    OPTION_VAL_L3_R3_CHS },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CHS,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CHS,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_CHS },
         { "1", OPTION_VAL_1_CHS },
         { "2", OPTION_VAL_2_CHS },
         { "3", OPTION_VAL_3_CHS },
         { "4", OPTION_VAL_4_CHS },
         { "5", OPTION_VAL_5_CHS },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CHS,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CHS,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_CHS,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CHS },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CHS },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_CHS,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_CHS,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_CHS },
         { "dot",   OPTION_VAL_DOT_CHS },
         { "off",   OPTION_VAL_OFF_CHS },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CHS,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CHS,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_CHS },
         { "blue", OPTION_VAL_BLUE_CHS },
         { "green", OPTION_VAL_GREEN_CHS },
         { "orange", OPTION_VAL_ORANGE_CHS },
         { "yellow", OPTION_VAL_YELLOW_CHS },
         { "cyan", OPTION_VAL_CYAN_CHS },
         { "pink", OPTION_VAL_PINK_CHS },
         { "purple", OPTION_VAL_PURPLE_CHS },
         { "black", OPTION_VAL_BLACK_CHS },
         { "white", OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CHS,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CHS,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_CHS },
         { "red", OPTION_VAL_RED_CHS },
         { "green", OPTION_VAL_GREEN_CHS },
         { "orange", OPTION_VAL_ORANGE_CHS },
         { "yellow", OPTION_VAL_YELLOW_CHS },
         { "cyan", OPTION_VAL_CYAN_CHS },
         { "pink", OPTION_VAL_PINK_CHS },
         { "purple", OPTION_VAL_PURPLE_CHS },
         { "black", OPTION_VAL_BLACK_CHS },
         { "white", OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CHS,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CHS,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_CHS },
         { "10%",  OPTION_VAL_10_CHS },
         { "15%",  OPTION_VAL_15_CHS },
         { "20%",  OPTION_VAL_20_CHS },
         { "25%",  OPTION_VAL_25_CHS },
         { "30%",  OPTION_VAL_30_CHS },
         { "35%",  OPTION_VAL_35_CHS },
         { "40%",  OPTION_VAL_40_CHS },
         { "45%",  OPTION_VAL_45_CHS },
         { "50%",  OPTION_VAL_50_CHS },
         { "55%",  OPTION_VAL_55_CHS },
         { "60%",  OPTION_VAL_60_CHS },
         { "65%",  OPTION_VAL_65_CHS },
         { "70%",  OPTION_VAL_70_CHS },
         { "75%",  OPTION_VAL_75_CHS },
         { "80%",  OPTION_VAL_80_CHS },
         { "85%",  OPTION_VAL_85_CHS },
         { "90%",  OPTION_VAL_90_CHS },
         { "95%",  OPTION_VAL_95_CHS },
         { "100%", OPTION_VAL_100_CHS },
         { "105%", OPTION_VAL_105_CHS },
         { "110%", OPTION_VAL_110_CHS },
         { "115%", OPTION_VAL_115_CHS },
         { "120%", OPTION_VAL_120_CHS },
         { "125%", OPTION_VAL_125_CHS },
         { "130%", OPTION_VAL_130_CHS },
         { "135%", OPTION_VAL_135_CHS },
         { "140%", OPTION_VAL_140_CHS },
         { "145%", OPTION_VAL_145_CHS },
         { "150%", OPTION_VAL_150_CHS },
         { "155%", OPTION_VAL_155_CHS },
         { "160%", OPTION_VAL_160_CHS },
         { "165%", OPTION_VAL_165_CHS },
         { "170%", OPTION_VAL_170_CHS },
         { "175%", OPTION_VAL_175_CHS },
         { "180%", OPTION_VAL_180_CHS },
         { "185%", OPTION_VAL_185_CHS },
         { "190%", OPTION_VAL_190_CHS },
         { "195%", OPTION_VAL_195_CHS },
         { "200%", OPTION_VAL_200_CHS },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_CHS,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_CHS },
         { "quadratic", OPTION_VAL_QUADRATIC_CHS },
         { "cubic",     OPTION_VAL_CUBIC_CHS },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_CHS,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_CHS },
         { "5%",  OPTION_VAL_5_O28_CHS },
         { "10%", OPTION_VAL_10_CHS },
         { "15%", OPTION_VAL_15_CHS },
         { "20%", OPTION_VAL_20_CHS },
         { "25%", OPTION_VAL_25_CHS },
         { "30%", OPTION_VAL_30_CHS },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CHS,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CHS,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_CHS },
         { "mednafen", OPTION_VAL_MEDNAFEN_CHS },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CHS,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CHS,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CHS,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CHS,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CHS,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CHS,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CHS,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CHS,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_CHS },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_CHS,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_CHS,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_CHS },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_CHS,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_CHS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_CHS },
         { "1px", OPTION_VAL_1PX_CHS },
         { "2px", OPTION_VAL_2PX_CHS },
         { "3px", OPTION_VAL_3PX_CHS },
         { "4px", OPTION_VAL_4PX_CHS },
         { "5px", OPTION_VAL_5PX_CHS },
         { "6px", OPTION_VAL_6PX_CHS },
         { "7px", OPTION_VAL_7PX_CHS },
         { "8px", OPTION_VAL_8PX_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_CHS,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_CHS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_CHS,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_CHS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_CHS,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_CHS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_CHS,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_CHS },
         { "aggressive", OPTION_VAL_AGGRESSIVE_CHS },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_CHS,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CHS,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_CHS },
         { "16:10", OPTION_VAL_16_10_CHS },
         { "18:9",  OPTION_VAL_18_9_CHS },
         { "19:9",  OPTION_VAL_19_9_CHS },
         { "20:9",  OPTION_VAL_20_9_CHS },
         { "21:9",  OPTION_VAL_21_9_CHS }, // 64:27
         { "32:9",  OPTION_VAL_32_9_CHS },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CHS,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_CHS },
         { "60%",           OPTION_VAL_60_CHS },
         { "70%",           OPTION_VAL_70_CHS },
         { "80%",           OPTION_VAL_80_CHS },
         { "90%",           OPTION_VAL_90_CHS },
         { "100%(native)", OPTION_VAL_100_NATIVE_CHS },
         { "110%",          OPTION_VAL_110_CHS },
         { "120%",          OPTION_VAL_120_CHS },
         { "130%",          OPTION_VAL_130_CHS },
         { "140%",          OPTION_VAL_140_CHS },
         { "150%",          OPTION_VAL_150_CHS },
         { "160%",          OPTION_VAL_160_CHS },
         { "170%",          OPTION_VAL_170_CHS },
         { "180%",          OPTION_VAL_180_CHS },
         { "190%",          OPTION_VAL_190_CHS },
         { "200%",          OPTION_VAL_200_CHS },
         { "210%",          OPTION_VAL_210_CHS },
         { "220%",          OPTION_VAL_220_CHS },
         { "230%",          OPTION_VAL_230_CHS },
         { "240%",          OPTION_VAL_240_CHS },
         { "250%",          OPTION_VAL_250_CHS },
         { "260%",          OPTION_VAL_260_CHS },
         { "270%",          OPTION_VAL_270_CHS },
         { "280%",          OPTION_VAL_280_CHS },
         { "290%",          OPTION_VAL_290_CHS },
         { "300%",          OPTION_VAL_300_CHS },
         { "310%",          OPTION_VAL_310_CHS },
         { "320%",          OPTION_VAL_320_CHS },
         { "330%",          OPTION_VAL_330_CHS },
         { "340%",          OPTION_VAL_340_CHS },
         { "350%",          OPTION_VAL_350_CHS },
         { "360%",          OPTION_VAL_360_CHS },
         { "370%",          OPTION_VAL_370_CHS },
         { "380%",          OPTION_VAL_380_CHS },
         { "390%",          OPTION_VAL_390_CHS },
         { "400%",          OPTION_VAL_400_CHS },
         { "410%",          OPTION_VAL_410_CHS },
         { "420%",          OPTION_VAL_420_CHS },
         { "430%",          OPTION_VAL_430_CHS },
         { "440%",          OPTION_VAL_440_CHS },
         { "450%",          OPTION_VAL_450_CHS },
         { "460%",          OPTION_VAL_460_CHS },
         { "470%",          OPTION_VAL_470_CHS },
         { "480%",          OPTION_VAL_480_CHS },
         { "490%",          OPTION_VAL_490_CHS },
         { "500%",          OPTION_VAL_500_CHS },
         { "510%",          OPTION_VAL_510_CHS },
         { "520%",          OPTION_VAL_520_CHS },
         { "530%",          OPTION_VAL_530_CHS },
         { "540%",          OPTION_VAL_540_CHS },
         { "550%",          OPTION_VAL_550_CHS },
         { "560%",          OPTION_VAL_560_CHS },
         { "570%",          OPTION_VAL_570_CHS },
         { "580%",          OPTION_VAL_580_CHS },
         { "590%",          OPTION_VAL_590_CHS },
         { "600%",          OPTION_VAL_600_CHS },
         { "610%",          OPTION_VAL_610_CHS },
         { "620%",          OPTION_VAL_620_CHS },
         { "630%",          OPTION_VAL_630_CHS },
         { "640%",          OPTION_VAL_640_CHS },
         { "650%",          OPTION_VAL_650_CHS },
         { "660%",          OPTION_VAL_660_CHS },
         { "670%",          OPTION_VAL_670_CHS },
         { "680%",          OPTION_VAL_680_CHS },
         { "690%",          OPTION_VAL_690_CHS },
         { "700%",          OPTION_VAL_700_CHS },
         { "710%",          OPTION_VAL_710_CHS },
         { "720%",          OPTION_VAL_720_CHS },
         { "730%",          OPTION_VAL_730_CHS },
         { "740%",          OPTION_VAL_740_CHS },
         { "750%",          OPTION_VAL_750_CHS },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_CHS,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CHS },
         { "2x",         OPTION_VAL_2X_CHS },
         { "4x",         OPTION_VAL_4X_CHS },
         { "8x",         OPTION_VAL_8X_CHS },
         { "16x",        OPTION_VAL_16X_CHS },
         { "32x",        OPTION_VAL_32X_CHS },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_CHS,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_CHS,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_CHS,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_CHS },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_CHS,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_CHS },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_CHS },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_CHS },
#endif
         { "software",    OPTION_VAL_SOFTWARE_CHS },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CHS,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CHS,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_CHS,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_CHS },
         { "execute",  OPTION_VAL_EXECUTE_CHS },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_CHS },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CHS,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_CHS },
         { "dma",  OPTION_VAL_DMA_CHS },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CHS,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_CHS },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CHS,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_CHS },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_CHS,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_CHS },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_CHS },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_CHS },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CHS,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_CHS,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_CHS,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_CHS },
         { "uncorrected", OPTION_VAL_UNCORRECTED_CHS },
         { "4:3",  OPTION_VAL_4_3_CHS },
         { "ntsc", OPTION_VAL_NTSC_CHS },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_CHS,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_CHS },
         { "static",  OPTION_VAL_STATIC_CHS },
         { "smart", OPTION_VAL_SMART_CHS },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_CHS,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_CHS },
         { "2px",      OPTION_VAL_2PX_CHS },
         { "3px",      OPTION_VAL_3PX_CHS },
         { "4px",      OPTION_VAL_4PX_CHS },
         { "5px",      OPTION_VAL_5PX_CHS },
         { "6px",      OPTION_VAL_6PX_CHS },
         { "7px",      OPTION_VAL_7PX_CHS },
         { "8px",      OPTION_VAL_8PX_CHS },
         { "9px",      OPTION_VAL_9PX_CHS },
         { "10px",     OPTION_VAL_10PX_CHS },
         { "11px",     OPTION_VAL_11PX_CHS },
         { "12px",     OPTION_VAL_12PX_CHS },
         { "13px",     OPTION_VAL_13PX_CHS },
         { "14px",     OPTION_VAL_14PX_CHS },
         { "15px",     OPTION_VAL_15PX_CHS },
         { "16px",     OPTION_VAL_16PX_CHS },
         { "17px",     OPTION_VAL_17PX_CHS },
         { "18px",     OPTION_VAL_18PX_CHS },
         { "19px",     OPTION_VAL_19PX_CHS },
         { "20px",     OPTION_VAL_20PX_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_CHS,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_CHS,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_CHS },
         { "-11px",    OPTION_VAL_11PX_O60_CHS },
         { "-10px",    OPTION_VAL_10PX_O60_CHS },
         { "-9px",     OPTION_VAL_9PX_O60_CHS },
         { "-8px",     OPTION_VAL_8PX_O60_CHS },
         { "-7px",     OPTION_VAL_7PX_O60_CHS },
         { "-6px",     OPTION_VAL_6PX_O60_CHS },
         { "-5px",     OPTION_VAL_5PX_O60_CHS },
         { "-4px",     OPTION_VAL_4PX_O60_CHS },
         { "-3px",     OPTION_VAL_3PX_O60_CHS },
         { "-2px",     OPTION_VAL_2PX_O60_CHS },
         { "-1px",     OPTION_VAL_1PX_O60_CHS },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_CHS },
         { "+2px",     OPTION_VAL_2PX_O60_0_CHS },
         { "+3px",     OPTION_VAL_3PX_O60_0_CHS },
         { "+4px",     OPTION_VAL_4PX_O60_0_CHS },
         { "+5px",     OPTION_VAL_5PX_O60_0_CHS },
         { "+6px",     OPTION_VAL_6PX_O60_0_CHS },
         { "+7px",     OPTION_VAL_7PX_O60_0_CHS },
         { "+8px",     OPTION_VAL_8PX_O60_0_CHS },
         { "+9px",     OPTION_VAL_9PX_O60_0_CHS },
         { "+10px",    OPTION_VAL_10PX_O60_0_CHS },
         { "+11px",    OPTION_VAL_11PX_O60_0_CHS },
         { "+12px",    OPTION_VAL_12PX_O60_0_CHS },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CHS,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CHS,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_CHS,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CHS },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_CHS,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_CHS },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CHS,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CHS,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CHS },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CHS,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CHS,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_CHS },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CHS,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_CHS },
         { "async",    OPTION_VAL_ASYNC_CHS },
         { "precache", OPTION_VAL_PRECACHE_CHS },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_CHS,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_CHS,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_CHS },
         { "4x",          OPTION_VAL_4X_CHS },
         { "6x",          OPTION_VAL_6X_CHS },
         { "8x",          OPTION_VAL_8X_CHS },
         { "10x",         OPTION_VAL_10X_CHS },
         { "12x",         OPTION_VAL_12X_CHS },
         { "14x",         OPTION_VAL_14X_CHS },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_chs = {
   option_cats_chs,
   option_defs_chs
};

/* RETRO_LANGUAGE_CHT */

#define CATEGORY_VIDEO_LABEL_CHT "顯示"
#define CATEGORY_VIDEO_INFO_0_CHT "變更長寬比、畫面裁剪、影像濾鏡和跳幀的設定。"
#define CATEGORY_OSD_LABEL_CHT "螢幕選單"
#define CATEGORY_OSD_INFO_0_CHT "變更螢幕上顯示資訊的設定。"
#define CATEGORY_INPUT_LABEL_CHT "輸入"
#define CATEGORY_INPUT_INFO_0_CHT "變更轉接插座、光線槍、滑鼠和類比搖桿的設定。"
#define CATEGORY_MEMCARDS_LABEL_CHT "記憶卡"
#define CATEGORY_MEMCARDS_INFO_0_CHT "變更系統的虛擬記憶卡設定。"
#define CATEGORY_PGXP_LABEL_CHT "精密幾何轉換管線 (PGXP)"
#define CATEGORY_PGXP_INFO_0_CHT "變更改進圖形功能的設定, PGXP可消除扭曲紋理和高度軸衝突問題。"
#define CATEGORY_HACKS_LABEL_CHT "進階"
#define CATEGORY_HACKS_INFO_0_CHT "變更模擬器進階破解的設定。"
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CHT "內部解析度 (GPU)"
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CHT "設定內部三維模型解析度(倍率), 越高倍率GPU效能需求越高, 可提高三維模型解析度, 此選項不影響二維圖形。"
#define OPTION_VAL_1X_NATIVE_CHT "1倍 (原廠)"
#define OPTION_VAL_2X_CHT "2倍"
#define OPTION_VAL_4X_CHT "4倍"
#define OPTION_VAL_8X_CHT "8倍"
#define OPTION_VAL_16X_CHT "16倍"
#define BEETLE_OPT_DEPTH_LABEL_CHT "內部色彩深度"
#define BEETLE_OPT_DEPTH_INFO_0_CHT "設定內部色彩深度。\n設定<每像素16位元>時為主機原廠設定值, 建議開啟「抖動色彩效果」增加漸層色顯示效果, 設定<每像素32位元>時請關閉「抖動色彩效果」。"
#define OPTION_VAL_16BPP_NATIVE_CHT "每像素16位元 (原廠)"
#define OPTION_VAL_32BPP_CHT "每像素32位元"
#define BEETLE_OPT_DITHER_MODE_LABEL_CHT "抖動色彩效果"
#define BEETLE_OPT_DITHER_MODE_INFO_0_CHT "設定抖動色彩效果, 選項「內部色彩深度」使用32位元時請關閉此選項, 設定<1倍>時使用主機原廠設定值, 用於色深不足增加漸層色顯示效果, 設定<內部解析度>時依設定的倍率縮放抖動像素, 用於減少顆粒感但倍率過大時會降低漸層色效果。\n注意: 「渲染器」為<Vulkan>預設16位元, <關閉>此選項為32位元。"
#define OPTION_VAL_INTERNAL_RESOLUTION_CHT "內部解析度"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CHT NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CHT NULL
#define BEETLE_OPT_FILTER_LABEL_CHT "材質過濾"
#define BEETLE_OPT_FILTER_INFO_0_CHT "選擇材質過濾方法。'最接近'模擬原始硬體。'雙線性'以及'3-Point'為平滑過濾，他會透過模糊畫面來減少像素感。'SABR'，'xBR'以及'JINC2'為升級濾鏡，透過更高的效能需求來提升材質還原度/清晰度。只支援硬體渲染。"
#define OPTION_VAL_NEAREST_CHT "最接近"
#define OPTION_VAL_SABR_CHT NULL
#define OPTION_VAL_XBR_CHT NULL
#define OPTION_VAL_BILINEAR_CHT "雙線性插值"
#define OPTION_VAL_3_POINT_CHT NULL
#define OPTION_VAL_JINC2_CHT NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CHT NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CHT NULL
#define OPTION_VAL_OPAQUE_CHT "僅限不透明"
#define OPTION_VAL_ALL_CHT "不透明與半透明"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CHT NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CHT "請勿在2D多邊形使用材質過濾。2D多邊形使用啟發法來偵測並可能造成小故障。搭配適應平滑法或其他後期處理濾鏡來達到最佳效果。"
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CHT NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CHT NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_CHT "超級取樣 (降採樣至原生解析度)"
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_CHT NULL
#define BEETLE_OPT_MSAA_LABEL_CHT "多重取樣反鋸齒"
#define BEETLE_OPT_MSAA_INFO_0_CHT "選擇渲染內容的MSAA等級。改善3D物件的視覺效果。只支援Vulkan渲染器。"
#define OPTION_VAL_1X_CHT "1倍"
#define BEETLE_OPT_MDEC_YUV_LABEL_CHT NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_CHT NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_CHT NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_CHT NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_CHT NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_CHT NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_CHT NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CHT NULL
#define BEETLE_OPT_WIREFRAME_LABEL_CHT NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_CHT NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_CHT NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_CHT NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CHT NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CHT NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_CHT NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_CHT NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CHT "類比自動校正"
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CHT NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_CHT NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CHT NULL
#define OPTION_VAL_ENABLED_ANALOG_CHT NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CHT NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CHT NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_CHT NULL
#define OPTION_VAL_L1_R1_SELECT_CHT NULL
#define OPTION_VAL_L1_R1_START_CHT NULL
#define OPTION_VAL_L1_R1_L3_CHT NULL
#define OPTION_VAL_L1_R1_R3_CHT NULL
#define OPTION_VAL_L2_R2_SELECT_CHT NULL
#define OPTION_VAL_L2_R2_START_CHT NULL
#define OPTION_VAL_L2_R2_L3_CHT NULL
#define OPTION_VAL_L2_R2_R3_CHT NULL
#define OPTION_VAL_L3_R3_CHT NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CHT NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CHT NULL
#define OPTION_VAL_0_CHT NULL
#define OPTION_VAL_1_CHT NULL
#define OPTION_VAL_2_CHT NULL
#define OPTION_VAL_3_CHT NULL
#define OPTION_VAL_4_CHT NULL
#define OPTION_VAL_5_CHT NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CHT "連接埠 1 四手把轉接器"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CHT "開啟連接埠1轉接插座可對應四位玩家。"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CHT "連接埠 2 四手把轉接器"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CHT "開啟連接埠2轉接插座可對應四位玩家。"
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_CHT "光線槍輸入模式"
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CHT NULL
#define OPTION_VAL_LIGHTGUN_CHT "光線槍"
#define OPTION_VAL_TOUCHSCREEN_CHT "觸控螢幕"
#define BEETLE_OPT_GUN_CURSOR_LABEL_CHT "光線槍準心"
#define BEETLE_OPT_GUN_CURSOR_INFO_0_CHT NULL
#define OPTION_VAL_CROSS_CHT "十字"
#define OPTION_VAL_DOT_CHT "圓點"
#define OPTION_VAL_OFF_CHT "無"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CHT "連接埠 1: 光線槍準心顏色"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CHT "設定連接埠1光線槍準心顏色。"
#define OPTION_VAL_RED_CHT "紅色"
#define OPTION_VAL_BLUE_CHT "藍色"
#define OPTION_VAL_GREEN_CHT "綠色"
#define OPTION_VAL_ORANGE_CHT "橙色"
#define OPTION_VAL_YELLOW_CHT "黃色"
#define OPTION_VAL_CYAN_CHT "青色"
#define OPTION_VAL_PINK_CHT "粉紅"
#define OPTION_VAL_PURPLE_CHT "紫色"
#define OPTION_VAL_BLACK_CHT "黑色"
#define OPTION_VAL_WHITE_CHT "白色"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CHT "連接埠 2: 光線槍準心顏色"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CHT "設定連接埠2光線槍準心顏色。"
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CHT "滑鼠靈敏度"
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CHT NULL
#define OPTION_VAL_5_O28_CHT NULL
#define OPTION_VAL_10_CHT NULL
#define OPTION_VAL_15_CHT NULL
#define OPTION_VAL_20_CHT NULL
#define OPTION_VAL_25_CHT NULL
#define OPTION_VAL_30_CHT NULL
#define OPTION_VAL_35_CHT NULL
#define OPTION_VAL_40_CHT NULL
#define OPTION_VAL_45_CHT NULL
#define OPTION_VAL_50_CHT NULL
#define OPTION_VAL_55_CHT NULL
#define OPTION_VAL_60_CHT NULL
#define OPTION_VAL_65_CHT NULL
#define OPTION_VAL_70_CHT NULL
#define OPTION_VAL_75_CHT NULL
#define OPTION_VAL_80_CHT NULL
#define OPTION_VAL_85_CHT NULL
#define OPTION_VAL_90_CHT NULL
#define OPTION_VAL_95_CHT NULL
#define OPTION_VAL_100_CHT "100% (預設)"
#define OPTION_VAL_105_CHT NULL
#define OPTION_VAL_110_CHT NULL
#define OPTION_VAL_115_CHT NULL
#define OPTION_VAL_120_CHT NULL
#define OPTION_VAL_125_CHT NULL
#define OPTION_VAL_130_CHT NULL
#define OPTION_VAL_135_CHT NULL
#define OPTION_VAL_140_CHT NULL
#define OPTION_VAL_145_CHT NULL
#define OPTION_VAL_150_CHT NULL
#define OPTION_VAL_155_CHT NULL
#define OPTION_VAL_160_CHT NULL
#define OPTION_VAL_165_CHT NULL
#define OPTION_VAL_170_CHT NULL
#define OPTION_VAL_175_CHT NULL
#define OPTION_VAL_180_CHT NULL
#define OPTION_VAL_185_CHT NULL
#define OPTION_VAL_190_CHT NULL
#define OPTION_VAL_195_CHT NULL
#define OPTION_VAL_200_CHT NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_CHT "扭轉控制器靈敏度 (neGcon)"
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CHT NULL
#define OPTION_VAL_LINEAR_CHT "線性"
#define OPTION_VAL_QUADRATIC_CHT NULL
#define OPTION_VAL_CUBIC_CHT NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_CHT "扭轉控制器作用區 (neGcon)"
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CHT NULL
#define OPTION_VAL_0_O30_CHT NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CHT "記憶卡1模式 (需要重新啟動)"
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CHT "設定記憶卡1檔案儲存格式, <MCR格式>兼容Mednafen模擬器, SRM和MCR格式可透過重新命名直接轉換。"
#define OPTION_VAL_LIBRETRO_CHT "SRM格式 (Libretro模擬器)"
#define OPTION_VAL_MEDNAFEN_CHT "MCR格式 (Mednafen模擬器)"
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CHT "記憶卡2模式 (需要重新啟動)"
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CHT "開啟時主機載入記憶卡2檔案編號, 僅限「記憶卡1模式」設定<MCR格式>時有效。\n注意: 部分遊戲要關閉才能執行, 例如Codename Tenka (代號天下)。"
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CHT "共用記憶卡 (需要重新啟動)"
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CHT "開啟時用相同記憶卡檔案儲存存檔, 關閉時依執行名稱建立記憶卡檔案。\n注意: 「記憶卡1模式」設定<SRM格式>時, 僅限記憶卡2檔案共用。"
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CHT "記憶卡1檔案編號"
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CHT "變更記憶卡1檔案使用編號, 僅限「記憶卡1模式」設定<MCR格式>時有效, 預設<0>為檔案使用編號。"
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CHT "記憶卡2檔案編號"
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CHT "變更記憶卡2檔案使用編號, 僅限開啟「記憶卡2模式」時有效, 預設<1>為檔案使用編號。"
#define OPTION_VAL_1_O35_CHT NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_CHT NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_CHT NULL
#define OPTION_VAL_MEMORY_ONLY_CHT "記憶體"
#define OPTION_VAL_MEMORY_CPU_CHT "記憶體 + 中央處理器 (錯誤)"
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_CHT NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_CHT NULL
#define OPTION_VAL_0PX_CHT "0像素"
#define OPTION_VAL_1PX_CHT "1像素"
#define OPTION_VAL_2PX_CHT "2像素"
#define OPTION_VAL_3PX_CHT "3像素"
#define OPTION_VAL_4PX_CHT "4像素"
#define OPTION_VAL_5PX_CHT "5像素"
#define OPTION_VAL_6PX_CHT "6像素"
#define OPTION_VAL_7PX_CHT "7像素"
#define OPTION_VAL_8PX_CHT "8像素"
#define BEETLE_OPT_PGXP_NCLIP_LABEL_CHT NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_CHT NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_CHT NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_CHT NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_CHT NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_CHT NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_CHT NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_CHT NULL
#define OPTION_VAL_DEFAULT_CHT "預設"
#define OPTION_VAL_AGGRESSIVE_CHT "強制"
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_CHT "寬螢幕模式 (破解)"
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CHT NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CHT "寬螢幕模式比例"
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CHT NULL
#define OPTION_VAL_16_9_CHT NULL
#define OPTION_VAL_16_10_CHT NULL
#define OPTION_VAL_18_9_CHT NULL
#define OPTION_VAL_19_9_CHT NULL
#define OPTION_VAL_20_9_CHT NULL
#define OPTION_VAL_21_9_CHT NULL
#define OPTION_VAL_32_9_CHT NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CHT NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CHT NULL
#define OPTION_VAL_100_NATIVE_CHT "100% (原廠)"
#define OPTION_VAL_210_CHT NULL
#define OPTION_VAL_220_CHT NULL
#define OPTION_VAL_230_CHT NULL
#define OPTION_VAL_240_CHT NULL
#define OPTION_VAL_250_CHT NULL
#define OPTION_VAL_260_CHT NULL
#define OPTION_VAL_270_CHT NULL
#define OPTION_VAL_280_CHT NULL
#define OPTION_VAL_290_CHT NULL
#define OPTION_VAL_300_CHT NULL
#define OPTION_VAL_310_CHT NULL
#define OPTION_VAL_320_CHT NULL
#define OPTION_VAL_330_CHT NULL
#define OPTION_VAL_340_CHT NULL
#define OPTION_VAL_350_CHT NULL
#define OPTION_VAL_360_CHT NULL
#define OPTION_VAL_370_CHT NULL
#define OPTION_VAL_380_CHT NULL
#define OPTION_VAL_390_CHT NULL
#define OPTION_VAL_400_CHT NULL
#define OPTION_VAL_410_CHT NULL
#define OPTION_VAL_420_CHT NULL
#define OPTION_VAL_430_CHT NULL
#define OPTION_VAL_440_CHT NULL
#define OPTION_VAL_450_CHT NULL
#define OPTION_VAL_460_CHT NULL
#define OPTION_VAL_470_CHT NULL
#define OPTION_VAL_480_CHT NULL
#define OPTION_VAL_490_CHT NULL
#define OPTION_VAL_500_CHT NULL
#define OPTION_VAL_510_CHT NULL
#define OPTION_VAL_520_CHT NULL
#define OPTION_VAL_530_CHT NULL
#define OPTION_VAL_540_CHT NULL
#define OPTION_VAL_550_CHT NULL
#define OPTION_VAL_560_CHT NULL
#define OPTION_VAL_570_CHT NULL
#define OPTION_VAL_580_CHT NULL
#define OPTION_VAL_590_CHT NULL
#define OPTION_VAL_600_CHT NULL
#define OPTION_VAL_610_CHT NULL
#define OPTION_VAL_620_CHT NULL
#define OPTION_VAL_630_CHT NULL
#define OPTION_VAL_640_CHT NULL
#define OPTION_VAL_650_CHT NULL
#define OPTION_VAL_660_CHT NULL
#define OPTION_VAL_670_CHT NULL
#define OPTION_VAL_680_CHT NULL
#define OPTION_VAL_690_CHT NULL
#define OPTION_VAL_700_CHT NULL
#define OPTION_VAL_710_CHT NULL
#define OPTION_VAL_720_CHT NULL
#define OPTION_VAL_730_CHT NULL
#define OPTION_VAL_740_CHT NULL
#define OPTION_VAL_750_CHT NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_CHT NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CHT NULL
#define OPTION_VAL_32X_CHT "32倍"
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_CHT NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CHT NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_CHT "跳過BIOS"
#define BEETLE_OPT_SKIP_BIOS_INFO_0_CHT NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_CHT NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CHT NULL
#define OPTION_VAL_PSXONPSP_CHT "PSP內建 (psxonpsp660.bin)"
#define OPTION_VAL_PS1_ROM_CHT "PS3內建 (ps1_rom.bin)"
#define BEETLE_OPT_RENDERER_LABEL_CHT "渲染器 (需要重新啟動)"
#define BEETLE_OPT_RENDERER_INFO_0_CHT NULL
#define OPTION_VAL_HARDWARE_CHT "自動 (硬體)"
#define OPTION_VAL_HARDWARE_GL_CHT "OpenGL (硬體)"
#define OPTION_VAL_HARDWARE_VK_CHT "Vulkan (硬體)"
#define OPTION_VAL_SOFTWARE_CHT "軟體渲染"
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CHT NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CHT NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_CHT NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_CHT NULL
#define OPTION_VAL_DISABLED_CHT NULL
#define OPTION_VAL_EXECUTE_CHT "最高效能"
#define OPTION_VAL_EXECUTE_ONE_CHT NULL
#define OPTION_VAL_RUN_INTERPRETER_CHT NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CHT NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CHT NULL
#define OPTION_VAL_FULL_CHT "全部"
#define OPTION_VAL_DMA_CHT NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CHT NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CHT NULL
#define OPTION_VAL_128_CHT "128 (預設)"
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CHT NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CHT NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_CHT NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CHT NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_CHT NULL
#define OPTION_VAL_FORCE_INTERLACED_CHT NULL
#define OPTION_VAL_AUTO_TOGGLE_CHT "允許自動切換"
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CHT NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CHT NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_CHT NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_CHT NULL
#define OPTION_VAL_CORRECTED_CHT NULL
#define OPTION_VAL_UNCORRECTED_CHT "未調整"
#define OPTION_VAL_4_3_CHT NULL
#define OPTION_VAL_NTSC_CHT NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_CHT "裁剪過度掃描"
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_CHT NULL
#define OPTION_VAL_DISABLED_O58_CHT "無"
#define OPTION_VAL_STATIC_CHT "靜態"
#define OPTION_VAL_SMART_CHT "動態 (預設)"
#define BEETLE_OPT_IMAGE_CROP_LABEL_CHT NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_CHT NULL
#define OPTION_VAL_9PX_CHT "9像素"
#define OPTION_VAL_10PX_CHT "10像素"
#define OPTION_VAL_11PX_CHT "11像素"
#define OPTION_VAL_12PX_CHT "12像素"
#define OPTION_VAL_13PX_CHT "13像素"
#define OPTION_VAL_14PX_CHT "14像素"
#define OPTION_VAL_15PX_CHT "15像素"
#define OPTION_VAL_16PX_CHT "16像素"
#define OPTION_VAL_17PX_CHT "17像素"
#define OPTION_VAL_18PX_CHT "18像素"
#define OPTION_VAL_19PX_CHT "19像素"
#define OPTION_VAL_20PX_CHT "20像素"
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_CHT NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_CHT NULL
#define OPTION_VAL_12PX_O60_CHT NULL
#define OPTION_VAL_11PX_O60_CHT NULL
#define OPTION_VAL_10PX_O60_CHT NULL
#define OPTION_VAL_9PX_O60_CHT NULL
#define OPTION_VAL_8PX_O60_CHT NULL
#define OPTION_VAL_7PX_O60_CHT NULL
#define OPTION_VAL_6PX_O60_CHT NULL
#define OPTION_VAL_5PX_O60_CHT NULL
#define OPTION_VAL_4PX_O60_CHT NULL
#define OPTION_VAL_3PX_O60_CHT NULL
#define OPTION_VAL_2PX_O60_CHT NULL
#define OPTION_VAL_1PX_O60_CHT NULL
#define OPTION_VAL_1PX_O60_0_CHT NULL
#define OPTION_VAL_2PX_O60_0_CHT NULL
#define OPTION_VAL_3PX_O60_0_CHT NULL
#define OPTION_VAL_4PX_O60_0_CHT NULL
#define OPTION_VAL_5PX_O60_0_CHT NULL
#define OPTION_VAL_6PX_O60_0_CHT NULL
#define OPTION_VAL_7PX_O60_0_CHT NULL
#define OPTION_VAL_8PX_O60_0_CHT NULL
#define OPTION_VAL_9PX_O60_0_CHT NULL
#define OPTION_VAL_10PX_O60_0_CHT NULL
#define OPTION_VAL_11PX_O60_0_CHT NULL
#define OPTION_VAL_12PX_O60_0_CHT NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CHT NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CHT NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_CHT NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CHT NULL
#define OPTION_VAL_0_O62_CHT NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_CHT NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_CHT NULL
#define OPTION_VAL_239_CHT "239 (預設)"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CHT NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CHT NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CHT NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CHT NULL
#define OPTION_VAL_287_CHT "287 (預設)"
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CHT NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CHT NULL
#define OPTION_VAL_SYNC_CHT NULL
#define OPTION_VAL_ASYNC_CHT NULL
#define OPTION_VAL_PRECACHE_CHT NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_CHT NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_CHT NULL
#define OPTION_VAL_2X_NATIVE_CHT "2倍 (原廠)"
#define OPTION_VAL_6X_CHT "6倍"
#define OPTION_VAL_10X_CHT "10倍"
#define OPTION_VAL_12X_CHT "12倍"
#define OPTION_VAL_14X_CHT "14倍"

struct retro_core_option_v2_category option_cats_cht[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHT,
      CATEGORY_VIDEO_INFO_0_CHT
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_CHT,
      CATEGORY_OSD_INFO_0_CHT
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHT,
      CATEGORY_INPUT_INFO_0_CHT
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_CHT,
      CATEGORY_MEMCARDS_INFO_0_CHT
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_CHT,
      CATEGORY_PGXP_INFO_0_CHT
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHT,
      CATEGORY_HACKS_INFO_0_CHT
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cht[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CHT,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CHT,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CHT },
         { "2x",         OPTION_VAL_2X_CHT },
         { "4x",         OPTION_VAL_4X_CHT },
         { "8x",         OPTION_VAL_8X_CHT },
         { "16x",        OPTION_VAL_16X_CHT },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_CHT,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_CHT,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_CHT },
         { "32bpp",         OPTION_VAL_32BPP_CHT },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_CHT,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_CHT },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_CHT },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CHT,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CHT,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_CHT,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_CHT },
         { "SABR",     OPTION_VAL_SABR_CHT },
         { "xBR",      OPTION_VAL_XBR_CHT },
         { "bilinear", OPTION_VAL_BILINEAR_CHT },
         { "3-point",  OPTION_VAL_3_POINT_CHT },
         { "JINC2",    OPTION_VAL_JINC2_CHT },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CHT,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CHT },
         { "all", OPTION_VAL_ALL_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CHT,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CHT },
         { "all", OPTION_VAL_ALL_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CHT,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_CHT,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_CHT,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_CHT,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_CHT },
         { "2x",  OPTION_VAL_2X_CHT },
         { "4x",  OPTION_VAL_4X_CHT },
         { "8x",  OPTION_VAL_8X_CHT },
         { "16x", OPTION_VAL_16X_CHT },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_CHT,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_CHT,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_CHT,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_CHT,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_CHT,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_CHT,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CHT,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CHT,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_CHT,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_CHT,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CHT,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_CHT,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CHT,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CHT,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_CHT },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_CHT },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_CHT },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_CHT },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_CHT },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_CHT },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_CHT },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_CHT },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_CHT },
         { "l3+r3",                    OPTION_VAL_L3_R3_CHT },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CHT,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CHT,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_CHT },
         { "1", OPTION_VAL_1_CHT },
         { "2", OPTION_VAL_2_CHT },
         { "3", OPTION_VAL_3_CHT },
         { "4", OPTION_VAL_4_CHT },
         { "5", OPTION_VAL_5_CHT },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CHT,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CHT,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_CHT,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CHT },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CHT },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_CHT,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_CHT,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_CHT },
         { "dot",   OPTION_VAL_DOT_CHT },
         { "off",   OPTION_VAL_OFF_CHT },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CHT,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CHT,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_CHT },
         { "blue", OPTION_VAL_BLUE_CHT },
         { "green", OPTION_VAL_GREEN_CHT },
         { "orange", OPTION_VAL_ORANGE_CHT },
         { "yellow", OPTION_VAL_YELLOW_CHT },
         { "cyan", OPTION_VAL_CYAN_CHT },
         { "pink", OPTION_VAL_PINK_CHT },
         { "purple", OPTION_VAL_PURPLE_CHT },
         { "black", OPTION_VAL_BLACK_CHT },
         { "white", OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CHT,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CHT,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_CHT },
         { "red", OPTION_VAL_RED_CHT },
         { "green", OPTION_VAL_GREEN_CHT },
         { "orange", OPTION_VAL_ORANGE_CHT },
         { "yellow", OPTION_VAL_YELLOW_CHT },
         { "cyan", OPTION_VAL_CYAN_CHT },
         { "pink", OPTION_VAL_PINK_CHT },
         { "purple", OPTION_VAL_PURPLE_CHT },
         { "black", OPTION_VAL_BLACK_CHT },
         { "white", OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CHT,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CHT,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_CHT },
         { "10%",  OPTION_VAL_10_CHT },
         { "15%",  OPTION_VAL_15_CHT },
         { "20%",  OPTION_VAL_20_CHT },
         { "25%",  OPTION_VAL_25_CHT },
         { "30%",  OPTION_VAL_30_CHT },
         { "35%",  OPTION_VAL_35_CHT },
         { "40%",  OPTION_VAL_40_CHT },
         { "45%",  OPTION_VAL_45_CHT },
         { "50%",  OPTION_VAL_50_CHT },
         { "55%",  OPTION_VAL_55_CHT },
         { "60%",  OPTION_VAL_60_CHT },
         { "65%",  OPTION_VAL_65_CHT },
         { "70%",  OPTION_VAL_70_CHT },
         { "75%",  OPTION_VAL_75_CHT },
         { "80%",  OPTION_VAL_80_CHT },
         { "85%",  OPTION_VAL_85_CHT },
         { "90%",  OPTION_VAL_90_CHT },
         { "95%",  OPTION_VAL_95_CHT },
         { "100%", OPTION_VAL_100_CHT },
         { "105%", OPTION_VAL_105_CHT },
         { "110%", OPTION_VAL_110_CHT },
         { "115%", OPTION_VAL_115_CHT },
         { "120%", OPTION_VAL_120_CHT },
         { "125%", OPTION_VAL_125_CHT },
         { "130%", OPTION_VAL_130_CHT },
         { "135%", OPTION_VAL_135_CHT },
         { "140%", OPTION_VAL_140_CHT },
         { "145%", OPTION_VAL_145_CHT },
         { "150%", OPTION_VAL_150_CHT },
         { "155%", OPTION_VAL_155_CHT },
         { "160%", OPTION_VAL_160_CHT },
         { "165%", OPTION_VAL_165_CHT },
         { "170%", OPTION_VAL_170_CHT },
         { "175%", OPTION_VAL_175_CHT },
         { "180%", OPTION_VAL_180_CHT },
         { "185%", OPTION_VAL_185_CHT },
         { "190%", OPTION_VAL_190_CHT },
         { "195%", OPTION_VAL_195_CHT },
         { "200%", OPTION_VAL_200_CHT },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_CHT,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_CHT },
         { "quadratic", OPTION_VAL_QUADRATIC_CHT },
         { "cubic",     OPTION_VAL_CUBIC_CHT },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_CHT,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_CHT },
         { "5%",  OPTION_VAL_5_O28_CHT },
         { "10%", OPTION_VAL_10_CHT },
         { "15%", OPTION_VAL_15_CHT },
         { "20%", OPTION_VAL_20_CHT },
         { "25%", OPTION_VAL_25_CHT },
         { "30%", OPTION_VAL_30_CHT },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CHT,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CHT,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_CHT },
         { "mednafen", OPTION_VAL_MEDNAFEN_CHT },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CHT,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CHT,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CHT,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CHT,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CHT,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CHT,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CHT,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CHT,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_CHT },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_CHT,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_CHT,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_CHT },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_CHT,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_CHT,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_CHT },
         { "1px", OPTION_VAL_1PX_CHT },
         { "2px", OPTION_VAL_2PX_CHT },
         { "3px", OPTION_VAL_3PX_CHT },
         { "4px", OPTION_VAL_4PX_CHT },
         { "5px", OPTION_VAL_5PX_CHT },
         { "6px", OPTION_VAL_6PX_CHT },
         { "7px", OPTION_VAL_7PX_CHT },
         { "8px", OPTION_VAL_8PX_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_CHT,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_CHT,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_CHT,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_CHT,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_CHT,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_CHT,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_CHT,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_CHT },
         { "aggressive", OPTION_VAL_AGGRESSIVE_CHT },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_CHT,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CHT,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_CHT },
         { "16:10", OPTION_VAL_16_10_CHT },
         { "18:9",  OPTION_VAL_18_9_CHT },
         { "19:9",  OPTION_VAL_19_9_CHT },
         { "20:9",  OPTION_VAL_20_9_CHT },
         { "21:9",  OPTION_VAL_21_9_CHT }, // 64:27
         { "32:9",  OPTION_VAL_32_9_CHT },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CHT,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_CHT },
         { "60%",           OPTION_VAL_60_CHT },
         { "70%",           OPTION_VAL_70_CHT },
         { "80%",           OPTION_VAL_80_CHT },
         { "90%",           OPTION_VAL_90_CHT },
         { "100%(native)", OPTION_VAL_100_NATIVE_CHT },
         { "110%",          OPTION_VAL_110_CHT },
         { "120%",          OPTION_VAL_120_CHT },
         { "130%",          OPTION_VAL_130_CHT },
         { "140%",          OPTION_VAL_140_CHT },
         { "150%",          OPTION_VAL_150_CHT },
         { "160%",          OPTION_VAL_160_CHT },
         { "170%",          OPTION_VAL_170_CHT },
         { "180%",          OPTION_VAL_180_CHT },
         { "190%",          OPTION_VAL_190_CHT },
         { "200%",          OPTION_VAL_200_CHT },
         { "210%",          OPTION_VAL_210_CHT },
         { "220%",          OPTION_VAL_220_CHT },
         { "230%",          OPTION_VAL_230_CHT },
         { "240%",          OPTION_VAL_240_CHT },
         { "250%",          OPTION_VAL_250_CHT },
         { "260%",          OPTION_VAL_260_CHT },
         { "270%",          OPTION_VAL_270_CHT },
         { "280%",          OPTION_VAL_280_CHT },
         { "290%",          OPTION_VAL_290_CHT },
         { "300%",          OPTION_VAL_300_CHT },
         { "310%",          OPTION_VAL_310_CHT },
         { "320%",          OPTION_VAL_320_CHT },
         { "330%",          OPTION_VAL_330_CHT },
         { "340%",          OPTION_VAL_340_CHT },
         { "350%",          OPTION_VAL_350_CHT },
         { "360%",          OPTION_VAL_360_CHT },
         { "370%",          OPTION_VAL_370_CHT },
         { "380%",          OPTION_VAL_380_CHT },
         { "390%",          OPTION_VAL_390_CHT },
         { "400%",          OPTION_VAL_400_CHT },
         { "410%",          OPTION_VAL_410_CHT },
         { "420%",          OPTION_VAL_420_CHT },
         { "430%",          OPTION_VAL_430_CHT },
         { "440%",          OPTION_VAL_440_CHT },
         { "450%",          OPTION_VAL_450_CHT },
         { "460%",          OPTION_VAL_460_CHT },
         { "470%",          OPTION_VAL_470_CHT },
         { "480%",          OPTION_VAL_480_CHT },
         { "490%",          OPTION_VAL_490_CHT },
         { "500%",          OPTION_VAL_500_CHT },
         { "510%",          OPTION_VAL_510_CHT },
         { "520%",          OPTION_VAL_520_CHT },
         { "530%",          OPTION_VAL_530_CHT },
         { "540%",          OPTION_VAL_540_CHT },
         { "550%",          OPTION_VAL_550_CHT },
         { "560%",          OPTION_VAL_560_CHT },
         { "570%",          OPTION_VAL_570_CHT },
         { "580%",          OPTION_VAL_580_CHT },
         { "590%",          OPTION_VAL_590_CHT },
         { "600%",          OPTION_VAL_600_CHT },
         { "610%",          OPTION_VAL_610_CHT },
         { "620%",          OPTION_VAL_620_CHT },
         { "630%",          OPTION_VAL_630_CHT },
         { "640%",          OPTION_VAL_640_CHT },
         { "650%",          OPTION_VAL_650_CHT },
         { "660%",          OPTION_VAL_660_CHT },
         { "670%",          OPTION_VAL_670_CHT },
         { "680%",          OPTION_VAL_680_CHT },
         { "690%",          OPTION_VAL_690_CHT },
         { "700%",          OPTION_VAL_700_CHT },
         { "710%",          OPTION_VAL_710_CHT },
         { "720%",          OPTION_VAL_720_CHT },
         { "730%",          OPTION_VAL_730_CHT },
         { "740%",          OPTION_VAL_740_CHT },
         { "750%",          OPTION_VAL_750_CHT },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_CHT,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CHT },
         { "2x",         OPTION_VAL_2X_CHT },
         { "4x",         OPTION_VAL_4X_CHT },
         { "8x",         OPTION_VAL_8X_CHT },
         { "16x",        OPTION_VAL_16X_CHT },
         { "32x",        OPTION_VAL_32X_CHT },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_CHT,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_CHT,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_CHT,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_CHT },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_CHT,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_CHT },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_CHT },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_CHT },
#endif
         { "software",    OPTION_VAL_SOFTWARE_CHT },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CHT,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CHT,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_CHT,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_CHT },
         { "execute",  OPTION_VAL_EXECUTE_CHT },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_CHT },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CHT,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_CHT },
         { "dma",  OPTION_VAL_DMA_CHT },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CHT,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_CHT },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CHT,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_CHT },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_CHT,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_CHT },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_CHT },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_CHT },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CHT,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_CHT,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_CHT,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_CHT },
         { "uncorrected", OPTION_VAL_UNCORRECTED_CHT },
         { "4:3",  OPTION_VAL_4_3_CHT },
         { "ntsc", OPTION_VAL_NTSC_CHT },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_CHT,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_CHT },
         { "static",  OPTION_VAL_STATIC_CHT },
         { "smart", OPTION_VAL_SMART_CHT },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_CHT,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_CHT },
         { "2px",      OPTION_VAL_2PX_CHT },
         { "3px",      OPTION_VAL_3PX_CHT },
         { "4px",      OPTION_VAL_4PX_CHT },
         { "5px",      OPTION_VAL_5PX_CHT },
         { "6px",      OPTION_VAL_6PX_CHT },
         { "7px",      OPTION_VAL_7PX_CHT },
         { "8px",      OPTION_VAL_8PX_CHT },
         { "9px",      OPTION_VAL_9PX_CHT },
         { "10px",     OPTION_VAL_10PX_CHT },
         { "11px",     OPTION_VAL_11PX_CHT },
         { "12px",     OPTION_VAL_12PX_CHT },
         { "13px",     OPTION_VAL_13PX_CHT },
         { "14px",     OPTION_VAL_14PX_CHT },
         { "15px",     OPTION_VAL_15PX_CHT },
         { "16px",     OPTION_VAL_16PX_CHT },
         { "17px",     OPTION_VAL_17PX_CHT },
         { "18px",     OPTION_VAL_18PX_CHT },
         { "19px",     OPTION_VAL_19PX_CHT },
         { "20px",     OPTION_VAL_20PX_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_CHT,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_CHT,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_CHT },
         { "-11px",    OPTION_VAL_11PX_O60_CHT },
         { "-10px",    OPTION_VAL_10PX_O60_CHT },
         { "-9px",     OPTION_VAL_9PX_O60_CHT },
         { "-8px",     OPTION_VAL_8PX_O60_CHT },
         { "-7px",     OPTION_VAL_7PX_O60_CHT },
         { "-6px",     OPTION_VAL_6PX_O60_CHT },
         { "-5px",     OPTION_VAL_5PX_O60_CHT },
         { "-4px",     OPTION_VAL_4PX_O60_CHT },
         { "-3px",     OPTION_VAL_3PX_O60_CHT },
         { "-2px",     OPTION_VAL_2PX_O60_CHT },
         { "-1px",     OPTION_VAL_1PX_O60_CHT },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_CHT },
         { "+2px",     OPTION_VAL_2PX_O60_0_CHT },
         { "+3px",     OPTION_VAL_3PX_O60_0_CHT },
         { "+4px",     OPTION_VAL_4PX_O60_0_CHT },
         { "+5px",     OPTION_VAL_5PX_O60_0_CHT },
         { "+6px",     OPTION_VAL_6PX_O60_0_CHT },
         { "+7px",     OPTION_VAL_7PX_O60_0_CHT },
         { "+8px",     OPTION_VAL_8PX_O60_0_CHT },
         { "+9px",     OPTION_VAL_9PX_O60_0_CHT },
         { "+10px",    OPTION_VAL_10PX_O60_0_CHT },
         { "+11px",    OPTION_VAL_11PX_O60_0_CHT },
         { "+12px",    OPTION_VAL_12PX_O60_0_CHT },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CHT,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CHT,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_CHT,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CHT },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_CHT,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_CHT },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CHT,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CHT,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CHT },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CHT,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CHT,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_CHT },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CHT,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_CHT },
         { "async",    OPTION_VAL_ASYNC_CHT },
         { "precache", OPTION_VAL_PRECACHE_CHT },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_CHT,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_CHT,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_CHT },
         { "4x",          OPTION_VAL_4X_CHT },
         { "6x",          OPTION_VAL_6X_CHT },
         { "8x",          OPTION_VAL_8X_CHT },
         { "10x",         OPTION_VAL_10X_CHT },
         { "12x",         OPTION_VAL_12X_CHT },
         { "14x",         OPTION_VAL_14X_CHT },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cht = {
   option_cats_cht,
   option_defs_cht
};

/* RETRO_LANGUAGE_CS */

#define CATEGORY_VIDEO_LABEL_CS NULL
#define CATEGORY_VIDEO_INFO_0_CS "Změňte poměr stran, oříznutí displeje, filtr videa a nastavení přeskakování snímků."
#define CATEGORY_OSD_LABEL_CS "Zobrazení na obrazovce"
#define CATEGORY_OSD_INFO_0_CS "Změna oznámení zobrazovaných na obrazovce."
#define CATEGORY_INPUT_LABEL_CS "Vstup"
#define CATEGORY_INPUT_INFO_0_CS "Změna nastavení světelné pistole, myši a neGconu."
#define CATEGORY_MEMCARDS_LABEL_CS "Paměťová karta"
#define CATEGORY_MEMCARDS_INFO_0_CS "Změna nastavení týkajících se virtuálních paměťových karet používaných systémem."
#define CATEGORY_PGXP_LABEL_CS "PGXP (Přesná transformace geometrie)"
#define CATEGORY_PGXP_INFO_0_CS "Tyto možnosti ovládají vylepšení, která mohou zlepšit grafiku ve srovnání s původní konzolí. PGXP dokáže odstranit deformace textur a problémy Z-fightingu."
#define CATEGORY_HACKS_LABEL_CS "Emulace hacků"
#define CATEGORY_HACKS_INFO_0_CS "Změna nastavení přetaktování procesoru a přesnosti emulace ovlivňující výkon a kompatibilitu na nízké úrovni."
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CS "Interní rozlišení GPU"
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CS "Zvolte interní násobič rozlišení. Rozlišení vyšší než \"1x (Nativní)\" zlepšuje věrnost 3D modelů na úkor zvýšených nároků na výkon. Na 2D prvky toto nastavení obecně nemá vliv."
#define OPTION_VAL_1X_NATIVE_CS "1x (Nativní)"
#define OPTION_VAL_2X_CS NULL
#define OPTION_VAL_4X_CS NULL
#define OPTION_VAL_8X_CS NULL
#define OPTION_VAL_16X_CS NULL
#define BEETLE_OPT_DEPTH_LABEL_CS "Vnitřní hloubka barev"
#define BEETLE_OPT_DEPTH_INFO_0_CS "Zvolte interní barevnou hloubku. Vyšší barevná hloubka může snížit efekt barevného proužkování bez použití ditheringu. 16 bpp emuluje původní hardware, ale pokud není povolen dithering, může se projevit viditelné proužkování. Při nastavení této možnosti na 32 bpp se doporučuje vypnout možnost 'Vzor Ditheringu'."
#define OPTION_VAL_16BPP_NATIVE_CS "16 bpp (nativní)"
#define OPTION_VAL_32BPP_CS NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_CS "Vzor Ditheringu"
#define BEETLE_OPT_DITHER_MODE_INFO_0_CS "Zvolte konfiguraci vzoru ditheringu. \"1x (Nativní)\" napodobuje nativní dithering s nízkým rozlišením, který se používal v původním hardwaru k vyhlazení artefaktů barevných pásů viditelných při nativní barevné hloubce. 'Interní rozlišení' škáluje granularitu ditheringu na nakonfigurované interní rozlišení pro čistší výsledky. Doporučuje se vypnout při barevné hloubce 32 bpp. Poznámka: V systému Vulkan zapnutí této funkce vynutí snížení vzorkování na nativní barevnou hloubku, zatímco vypnutí automaticky povolí výstup s vyšší barevnou hloubkou."
#define OPTION_VAL_INTERNAL_RESOLUTION_CS "Vnitřní rozlišení"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CS "Odsazení UV textur"
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CS "Vzorové textury pro 3D polygony s posunem pro vyšší než 1x interní rozlišení. Snižuje počet švů textur, ale může způsobit nechtěné grafické závady."
#define BEETLE_OPT_FILTER_LABEL_CS "Filtrování textur"
#define BEETLE_OPT_FILTER_INFO_0_CS "Zvolte metodu filtrování textur. 'Nejbližší' emuluje původní hardware. 'Bilineární' a '3-bodový' jsou vyhlazovací filtry, které snižují pixelaci rozmazáním. 'SABR', 'xBR' a 'JINC2' jsou filtry pro zvýšení rozlišení, které mohou zlepšit věrnost/ostrost textur na úkor zvýšených nároků na výkon. Podporovány pouze hardwarovými vykreslovači."
#define OPTION_VAL_NEAREST_CS "Nejbližší"
#define OPTION_VAL_SABR_CS NULL
#define OPTION_VAL_XBR_CS NULL
#define OPTION_VAL_BILINEAR_CS "Bilineární"
#define OPTION_VAL_3_POINT_CS NULL
#define OPTION_VAL_JINC2_CS NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CS "Vyloučit sprity z filtrování"
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CS "Na sprity se nepoužije filtrování textur. Zabraňuje vzniku švů v různých hrách s pozadím vykresleným 2D sprity. Pro dosažení nejlepšího účinku použijte společně s adaptivním vyhlazováním nebo jiným filtrem následného zpracování."
#define OPTION_VAL_OPAQUE_CS "Pouze neprůhledné"
#define OPTION_VAL_ALL_CS "Neprůhledné a poloprůhledné provedení"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CS "Vyloučení 2D polygonů z filtrování"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CS "Na 2D polygony nepoužívejte filtrování textur. 2D polygony jsou detekovány pomocí heuristiky a může docházet k chybám. Pro dosažení nejlepšího účinku použijte společně s adaptivním vyhlazováním nebo jiným filtrem následného zpracování."
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CS "Adaptivní vyhlazování"
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CS "Vyhlazení 2D grafiky a prvků uživatelského rozhraní bez rozmazání 3D vykreslených objektů. Podporováno pouze vykreslovačem Vulkan."
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_CS "Supersampling (převzorkování na nativní rozlišení)"
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_CS "Snížení vykreslovaného obsahu z interního rozlišení se zvýšeným rozlišením na nativní rozlišení. Kombinace tohoto postupu s vyššími násobiči interního rozlišení umožňuje zobrazovat hry s 3D objekty s vyhlazováním v nativním nízkém rozlišení. Nejlepších výsledků dosahuje při použití u titulů, které kombinují 2D a 3D prvky (např. 3D postavy na předem vykresleném pozadí), a dobře funguje ve spojení s CRT shadery. Podporováno pouze vykreslovačem Vulkan. Poznámka: Při zapnutí této možnosti se doporučuje vypnout možnost 'Vzor Ditheringu'."
#define BEETLE_OPT_MSAA_LABEL_CS "Vícenásobný Anti Aliasing"
#define BEETLE_OPT_MSAA_INFO_0_CS "Zvolte úroveň MSAA pro vykreslovaný obsah. Zlepšuje vzhled 3D objektů. Podporováno pouze vykreslovačem Vulkan."
#define OPTION_VAL_1X_CS NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_CS "MDEC YUV Chroma Filtr"
#define BEETLE_OPT_MDEC_YUV_INFO_0_CS "Zlepšení kvality přehrávání FMV omezením artefaktů 'makroblockingu' (čtverečky/roztřepené hrany). Podporováno pouze vykreslovačem Vulkan."
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_CS "Sledování Textur"
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_CS "Předpoklad pro výpis a výměnu textur.  Ve většině her pravděpodobně dojde k pádu."
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_CS "Skladiště Textur"
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_CS "Výpis použitých textur do souboru <cd>-texture-dump/"
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_CS "Nahrazení Textur"
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CS "Nahrazení textur pomocí HD verzí z <cd>-texture-replacements/"
#define BEETLE_OPT_WIREFRAME_LABEL_CS "Režim Wireframe (Ladění)"
#define BEETLE_OPT_WIREFRAME_INFO_0_CS "Vykreslujte 3D modely ve formě obrysů bez textur a stínování. Podporováno pouze hardwarovým rendererem OpenGL. Poznámka: Tato funkce slouží k ladění a měla by být normálně vypnuta."
#define BEETLE_OPT_FRAME_DUPING_LABEL_CS "Duplikace Snímků (Zrychlení)"
#define BEETLE_OPT_FRAME_DUPING_INFO_0_CS "Pokud je tato funkce povolena a podporována frontendem libretro, přináší malé zvýšení výkonu tím, že frontend opakuje předchozí snímek, pokud jádro nemá nic nového k zobrazení."
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CS "Interní Zobrazení FPS"
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CS "Zobrazení interní snímkové frekvence, při které emulovaný systém PlayStation vykresluje obsah. Poznámka: Vyžaduje, aby byla ve frontendu libretro povolena oznámení na obrazovce."
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_CS "Zobrazení Plné Paměti VRAM (Ladění)"
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_CS "Vizualizace celé paměti VRAM emulované konzole. Podporováno pouze hardwarovými vykreslovači OpenGL a Vulkan. Poznámka: Tato funkce slouží k ladění a měla by být normálně vypnuta."
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CS "Analogová Vlastní Kalibrace"
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CS "Pokud je vstupní zařízení nastaveno na DualShock, Analogový ovladač, Analogový joystick nebo neGcon, tato možnost umožňuje dynamickou kalibraci analogových vstupů. Maximální registrované hodnoty vstupů jsou sledovány v reálném čase a použity ke škálování analogových souřadnic předávaných emulátoru. Tato funkce by měla být použita u her, jako je Mega Man Legends 2, které očekávají větší hodnoty, než jaké poskytují moderní ovladače. Pro dosažení nejlepších výsledků by se analogové páčky měly otáčet v plném rozsahu, aby se kalibrační algoritmus vyladil při každém načtení obsahu."
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_CS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CS NULL
#define OPTION_VAL_ENABLED_ANALOG_CS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CS "Kombinace analogového režimu DualShock"
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CS NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_CS NULL
#define OPTION_VAL_L1_R1_SELECT_CS NULL
#define OPTION_VAL_L1_R1_START_CS NULL
#define OPTION_VAL_L1_R1_L3_CS NULL
#define OPTION_VAL_L1_R1_R3_CS NULL
#define OPTION_VAL_L2_R2_SELECT_CS NULL
#define OPTION_VAL_L2_R2_START_CS NULL
#define OPTION_VAL_L2_R2_L3_CS NULL
#define OPTION_VAL_L2_R2_R3_CS NULL
#define OPTION_VAL_L3_R3_CS NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CS "Zpoždění podržení analogového režimu DualShock"
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CS NULL
#define OPTION_VAL_0_CS "0 sekundové zpoždění"
#define OPTION_VAL_1_CS "1 sekundové zpoždění"
#define OPTION_VAL_2_CS "2 sekundové zpoždění"
#define OPTION_VAL_3_CS "3 sekundové zpoždění"
#define OPTION_VAL_4_CS "4 sekundové zpoždění"
#define OPTION_VAL_5_CS "5 sekundové zpoždění"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CS "Port 1: Povolení Multitapu"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CS "Povolit funkci multitap na portu 1."
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CS "Port 2: Povolení Multitapu"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CS "Povolit funkci multitap na portu 2."
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_CS "Režim Vstupu Zbraně"
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CS "Pokud je typ zařízení nastaven na 'Guncon/G-Con 45' nebo 'Justifier', vyberte, zda se má používat vstup ovládaný myší 'Light Gun' nebo 'Dotyková Obrazovka'."
#define OPTION_VAL_LIGHTGUN_CS NULL
#define OPTION_VAL_TOUCHSCREEN_CS "Dotyková Obrazovka"
#define BEETLE_OPT_GUN_CURSOR_LABEL_CS "Kurzor Zbraně"
#define BEETLE_OPT_GUN_CURSOR_INFO_0_CS "Zvolte kurzor zbraně, který se má zobrazit na obrazovce při použití typů vstupních zařízení 'Guncon/G-Con 45' a 'Justifier'. Pokud je tato volba vypnuta, je zaměřovací kříž vždy skrytý."
#define OPTION_VAL_CROSS_CS "Kříž"
#define OPTION_VAL_DOT_CS "Tečka"
#define OPTION_VAL_OFF_CS "Žádný Kurzor"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CS "Port 1: Barva Kříže Zbraně"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CS "Vyberte barvu světelného kříže pro port 1."
#define OPTION_VAL_RED_CS "Červený"
#define OPTION_VAL_BLUE_CS "Modrý"
#define OPTION_VAL_GREEN_CS "Zelený"
#define OPTION_VAL_ORANGE_CS "Oranžová"
#define OPTION_VAL_YELLOW_CS "Žlutá"
#define OPTION_VAL_CYAN_CS "Azurová"
#define OPTION_VAL_PINK_CS "Růžová"
#define OPTION_VAL_PURPLE_CS "Fialová"
#define OPTION_VAL_BLACK_CS "Černá"
#define OPTION_VAL_WHITE_CS "Bílá"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CS "Port 2: Barva Kříže Zbraně"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CS "Vyberte barvu světelného kříže pro port 2."
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CS "Citlivost Myši"
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CS "Zvolte odezvu typu vstupního zařízení 'Myš'."
#define OPTION_VAL_5_O28_CS NULL
#define OPTION_VAL_10_CS NULL
#define OPTION_VAL_15_CS NULL
#define OPTION_VAL_20_CS NULL
#define OPTION_VAL_25_CS NULL
#define OPTION_VAL_30_CS NULL
#define OPTION_VAL_35_CS NULL
#define OPTION_VAL_40_CS NULL
#define OPTION_VAL_45_CS NULL
#define OPTION_VAL_50_CS NULL
#define OPTION_VAL_55_CS NULL
#define OPTION_VAL_60_CS NULL
#define OPTION_VAL_65_CS NULL
#define OPTION_VAL_70_CS NULL
#define OPTION_VAL_75_CS NULL
#define OPTION_VAL_80_CS NULL
#define OPTION_VAL_85_CS NULL
#define OPTION_VAL_90_CS NULL
#define OPTION_VAL_95_CS NULL
#define OPTION_VAL_100_CS "100% (výchozí)"
#define OPTION_VAL_105_CS NULL
#define OPTION_VAL_110_CS NULL
#define OPTION_VAL_115_CS NULL
#define OPTION_VAL_120_CS NULL
#define OPTION_VAL_125_CS NULL
#define OPTION_VAL_130_CS NULL
#define OPTION_VAL_135_CS NULL
#define OPTION_VAL_140_CS NULL
#define OPTION_VAL_145_CS NULL
#define OPTION_VAL_150_CS NULL
#define OPTION_VAL_155_CS NULL
#define OPTION_VAL_160_CS NULL
#define OPTION_VAL_165_CS NULL
#define OPTION_VAL_170_CS NULL
#define OPTION_VAL_175_CS NULL
#define OPTION_VAL_180_CS NULL
#define OPTION_VAL_185_CS NULL
#define OPTION_VAL_190_CS NULL
#define OPTION_VAL_195_CS NULL
#define OPTION_VAL_200_CS NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_CS NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CS "Zvolte typ odezvy levé analogové páčky zařízení RetroPad při simulaci akce 'twist' emulovaných vstupních zařízení 'neGcon'. Posun analogové páčky lze mapovat na úhel natočení neGconu buď lineárně, kvadraticky, nebo kubicky. 'Kvadratický' umožňuje větší přesnost než 'Lineární' při provádění malých pohybů. 'Kubický' dále zvyšuje přesnost malých pohybů, ale 'přehání' větší pohyby. Poznámka: 'Lineární' se doporučuje pouze při použití periferních zařízení závodních kol. Běžné ovladače implementují analogový vstup zásadně odlišným způsobem než mechanismus 'twist' neGconu, takže lineární mapování příliš zesiluje malé pohyby a zhoršuje jemné ovládání. Ve většině případů poskytuje 'Kvadratické' nejbližší přiblížení skutečnému hardwaru."
#define OPTION_VAL_LINEAR_CS "Lineární"
#define OPTION_VAL_QUADRATIC_CS "Kvadratická"
#define OPTION_VAL_CUBIC_CS "Kubická"
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_CS "mrtvá Zóna neGcon Twist"
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CS "Při simulaci akce 'twist' u emulovaných vstupních zařízení 'neGcon' vyberte zónu nečinnosti levé analogové páčky zařízení RetroPad. Slouží k eliminaci driftu ovladače. Poznámka: Většina titulů kompatibilních s neGcon poskytuje ve hře možnosti nastavení hodnoty deadzone 'twist'. Aby nedocházelo ke ztrátě přesnosti, měla by být herní deadzone *vždy* nastavena na nulu. Jakékoli požadované úpravy by se měly provádět *pouze* prostřednictvím této základní volby. To je důležité zejména tehdy, když je 'neGcon Twist Response' nastavena na 'Kvadratický' nebo 'Kubický'."
#define OPTION_VAL_0_O30_CS NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CS "Metoda Paměťové Karty 0 (Vyžadován Restart)"
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CS "Zvolte formát ukládání dat použitý pro paměťovou kartu 0. Pro kompatibilitu se samostatnou verzí programu Mednafen lze použít 'Mednafen'. Při použití s Beetle PSX mají uložená data Libretro (.srm) a Mednafen (.mcr) interně identické formáty a lze je mezi sebou převádět pomocí přejmenování."
#define OPTION_VAL_LIBRETRO_CS NULL
#define OPTION_VAL_MEDNAFEN_CS NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CS "Povolit Paměťovou Kartu 1 (Vyžadován Restart)"
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CS "Emulujte druhou paměťovou kartu ve slotu 1. Pokud je funkce vypnuta, mohou hry přistupovat pouze k paměťové kartě ve slotu 0. Poznámka: Některé hry vyžadují pro správnou funkci tuto možnost vypnutou (např. Codename Tenka). Poznámka: Paměťová karta 1 používá ukládací formát Mednafen (.mcr)."
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CS "Sdílené Paměťové Karty (Nutný Restart)"
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CS "Pokud je tato funkce povolena, budou se všechny hry ukládat a načítat ze stejných souborů paměťové karty. Pokud je vypnuto, budou pro každou položku načteného obsahu vytvářeny samostatné soubory paměťové karty. Poznámka: pokud je položka 'Metoda paměťové karty 0' nastavena na hodnotu 'Libretro', bude ovlivněna pouze pravá paměťová karta."
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CS "Levý Index Paměťové Karty"
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CS "Vyměňte paměťovou kartu, která je aktuálně vložena v levém slotu. Tato možnost bude fungovat pouze v případě, že je metoda Paměťová Karta 0 nastavena na Mednafen. Výchozí karta má index 0."
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CS "Pravý Index Paměťové Karty"
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CS "Vyměňte paměťovou kartu, která je aktuálně vložena v pravém slotu. Tato možnost bude fungovat pouze v případě, že je povolena Paměťová Karta 1. Výchozí karta má index 1."
#define OPTION_VAL_1_O35_CS "1 (Výchozí)"
#define BEETLE_OPT_PGXP_MODE_LABEL_CS "Provozní Režim PGXP"
#define BEETLE_OPT_PGXP_MODE_INFO_0_CS "Umožňuje vykreslovat 3D objekty se subpixelovou přesností, čímž se minimalizuje zkreslení a chvění 3D objektů na původním hardwaru v důsledku použití souřadnic vrcholů s pevným bodem. Režim 'Pouze Paměť' má minimální problémy s kompatibilitou a doporučuje se pro obecné použití. Režim 'Paměť + CPU (Chyby)' může ještě více snížit jitter, ale má vysoké nároky na výkon a může způsobit různé chyby geometrie."
#define OPTION_VAL_MEMORY_ONLY_CS "Pouze Paměť"
#define OPTION_VAL_MEMORY_CPU_CS "Paměť + CPU (Chyby)"
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_CS "PGXP 2D Tolerance Geometrie"
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_CS "Skrytí zjevnějších chyb při operacích PGXP: hodnota určuje toleranci, v níž budou hodnoty PGXP zachovány v případě geometrií bez správných informací o hloubce."
#define OPTION_VAL_0PX_CS NULL
#define OPTION_VAL_1PX_CS NULL
#define OPTION_VAL_2PX_CS NULL
#define OPTION_VAL_3PX_CS NULL
#define OPTION_VAL_4PX_CS NULL
#define OPTION_VAL_5PX_CS NULL
#define OPTION_VAL_6PX_CS NULL
#define OPTION_VAL_7PX_CS NULL
#define OPTION_VAL_8PX_CS NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_CS "PGXP Primitivní Culling"
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_CS "Použijte implementaci NCLIP společnosti PGXP. Zlepšuje vzhled zmenšením děr v geometriích se souřadnicemi PGXP. Je známo, že za různých okolností způsobuje zablokování některých her."
#define BEETLE_OPT_PGXP_VERTEX_LABEL_CS NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_CS "Ukládání pozic vrcholů s podporou PGXP do mezipaměti pro opakované použití při kreslení polygonů. Může potenciálně zlepšit zarovnání objektů a omezit viditelné švy při vykreslování textur, ale falešně pozitivní dotazy na mezipaměť mohou způsobit grafické závady. V současné době se doporučuje ponechat tuto možnost vypnutou. Tato volba se použije pouze tehdy, když je povolen operační režim PGXP. Podporováno pouze hardwarovými vykreslovači."
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_CS "PGXP Perspektivní Správné Texturování"
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_CS "Nahrazení nativního afinního mapování textur pro PSX perspektivně správným mapováním textur. Eliminuje zkreslení a deformaci textur v závislosti na poloze a výsledkem jsou správně zarovnané textury. Tato volba se použije pouze tehdy, když je povolen provozní režim PGXP. Podporováno pouze hardwarovými vykreslovači."
#define BEETLE_OPT_LINE_RENDER_LABEL_CS NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_CS "Zvolte metodu hackování mezi linkami. Některé hry (např. Doom, Hexen, Soul Blade atd.) kreslí vodorovné čáry roztažením trojúhelníků o výšce jednoho pixelu přes obrazovku, které jsou na původním hardwaru rasterizovány jako řada pixelů. Tento hack detekuje tyto malé trojúhelníky a podle potřeby je převádí na čtyřúhelníky, což umožňuje jejich správné zobrazení na hardwarových rendererech a při zvýšení interního rozlišení. U některých titulů (např. Dark Forces, Duke Nukem) je vyžadována funkce 'Agresivní', ale jinak může způsobovat grafické závady. Pokud si nejste jisti, ponechte hodnotu 'Výchozí'."
#define OPTION_VAL_DEFAULT_CS "Výchozí"
#define OPTION_VAL_AGGRESSIVE_CS "Agresivní"
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_CS "Hack Režim Celé Obrazovky"
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CS "Vykresluje 3D obsah anamorfně a výstupem emulovaného framebufferu s širokoúhlým poměrem stran. Nejlepších výsledků dosahuje u plně 3D her. 2D prvky budou horizontálně roztaženy a mohou být špatně zarovnány."
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CS "Poměr Stran Hacku v Širokoúhlem Režimu"
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CS "Zvolte poměr stran, který má být použit v Hack Režimu Celé Obrazovky."
#define OPTION_VAL_16_9_CS NULL
#define OPTION_VAL_16_10_CS NULL
#define OPTION_VAL_18_9_CS NULL
#define OPTION_VAL_19_9_CS NULL
#define OPTION_VAL_20_9_CS NULL
#define OPTION_VAL_21_9_CS NULL
#define OPTION_VAL_32_9_CS NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CS "Škálování Frekvence CPU (Přetaktování)"
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CS "Přetaktování (nebo podtaktování) emulovaného procesoru PSX. Přetaktování může eliminovat zpomalení a zlepšit snímkovou frekvenci v některých hrách na úkor zvýšených nároků na výkon. Upozorňujeme, že některé hry mají interní omezovač snímkové frekvence a přetaktování pro ně nemusí být přínosem. V některých titulech může přetaktování způsobit, že se některé efekty animují rychleji, než je zamýšleno."
#define OPTION_VAL_100_NATIVE_CS "100% (Nativní)"
#define OPTION_VAL_210_CS NULL
#define OPTION_VAL_220_CS NULL
#define OPTION_VAL_230_CS NULL
#define OPTION_VAL_240_CS NULL
#define OPTION_VAL_250_CS NULL
#define OPTION_VAL_260_CS NULL
#define OPTION_VAL_270_CS NULL
#define OPTION_VAL_280_CS NULL
#define OPTION_VAL_290_CS NULL
#define OPTION_VAL_300_CS NULL
#define OPTION_VAL_310_CS NULL
#define OPTION_VAL_320_CS NULL
#define OPTION_VAL_330_CS NULL
#define OPTION_VAL_340_CS NULL
#define OPTION_VAL_350_CS NULL
#define OPTION_VAL_360_CS NULL
#define OPTION_VAL_370_CS NULL
#define OPTION_VAL_380_CS NULL
#define OPTION_VAL_390_CS NULL
#define OPTION_VAL_400_CS NULL
#define OPTION_VAL_410_CS NULL
#define OPTION_VAL_420_CS NULL
#define OPTION_VAL_430_CS NULL
#define OPTION_VAL_440_CS NULL
#define OPTION_VAL_450_CS NULL
#define OPTION_VAL_460_CS NULL
#define OPTION_VAL_470_CS NULL
#define OPTION_VAL_480_CS NULL
#define OPTION_VAL_490_CS NULL
#define OPTION_VAL_500_CS NULL
#define OPTION_VAL_510_CS NULL
#define OPTION_VAL_520_CS NULL
#define OPTION_VAL_530_CS NULL
#define OPTION_VAL_540_CS NULL
#define OPTION_VAL_550_CS NULL
#define OPTION_VAL_560_CS NULL
#define OPTION_VAL_570_CS NULL
#define OPTION_VAL_580_CS NULL
#define OPTION_VAL_590_CS NULL
#define OPTION_VAL_600_CS NULL
#define OPTION_VAL_610_CS NULL
#define OPTION_VAL_620_CS NULL
#define OPTION_VAL_630_CS NULL
#define OPTION_VAL_640_CS NULL
#define OPTION_VAL_650_CS NULL
#define OPTION_VAL_660_CS NULL
#define OPTION_VAL_670_CS NULL
#define OPTION_VAL_680_CS NULL
#define OPTION_VAL_690_CS NULL
#define OPTION_VAL_700_CS NULL
#define OPTION_VAL_710_CS NULL
#define OPTION_VAL_720_CS NULL
#define OPTION_VAL_730_CS NULL
#define OPTION_VAL_740_CS NULL
#define OPTION_VAL_750_CS NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_CS "Přetaktování GPU Rasterizer"
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CS "Povolení přetaktování 2D rasterizéru obsaženého v grafickém procesoru emulované konzole PSX. Nezlepšuje 3D vykreslování a obecně má malý vliv."
#define OPTION_VAL_32X_CS NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_CS "Přetaktování GTE"
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CS "Snižte všechny emulované operace GTE (koprocesor CPU pro 3D grafiku) na konstantní latenci jednoho cyklu. U her, které GTE hojně využívají, to může výrazně zlepšit stabilitu snímkové frekvence a času snímků."
#define BEETLE_OPT_SKIP_BIOS_LABEL_CS "Přeskočit BIOS"
#define BEETLE_OPT_SKIP_BIOS_INFO_0_CS "Přeskočení zaváděcí animace systému PlayStation BIOS, která se obvykle zobrazuje při načítání obsahu. Poznámka: Povolení této funkce způsobuje problémy s kompatibilitou u řady her (hry chráněné proti kopírování PAL, Saga Frontier atd.)."
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_CS "Přepsání BIOS (Nutný Restart)"
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CS "Přepíše standardní systém BIOS specifický pro danou oblast systémem bez regionálního nastavení, pokud je nalezen."
#define OPTION_VAL_PSXONPSP_CS NULL
#define OPTION_VAL_PS1_ROM_CS NULL
#define BEETLE_OPT_RENDERER_LABEL_CS "Vykreslovač (Vyžadován Restart)"
#define BEETLE_OPT_RENDERER_INFO_0_CS "Softwarový renderer je nejpřesnější, ale má vysoké nároky na výkon při zvýšeném rozlišení interního GPU. Hardwarové vykreslovače jsou sice méně přesné, ale při zvýšeném interním rozlišení zvyšují výkon oproti softwarovému vykreslovači a umožňují různá grafická vylepšení. 'Hardware (Auto)' automaticky vybere vykreslovač Vulkan nebo OpenGL v závislosti na aktuálním frontendovém video ovladači libretro. Pokud poskytnutý video ovladač není kompatibilní s Vulkan nebo OpenGL 3.3, jádro se vrátí k softwarovému vykreslovači."
#define OPTION_VAL_HARDWARE_CS NULL
#define OPTION_VAL_HARDWARE_GL_CS NULL
#define OPTION_VAL_HARDWARE_VK_CS NULL
#define OPTION_VAL_SOFTWARE_CS NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CS NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CS "Umožňuje přesnou emulaci efektů framebufferu (např. motion blur, FF7 battle swirl) při použití hardwarových rendererů spuštěním kopie softwarového rendereru v nativním rozlišení na pozadí. Jsou-li tyto operace zakázány, jsou vynechány (OpenGL) nebo vykreslovány na GPU (Vulkan). Zakázání může zvýšit výkon, ale může způsobit závažné grafické chyby. Pokud si nejste jisti, ponechte povoleno."
#define BEETLE_OPT_CPU_DYNAREC_LABEL_CS NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_CS "Dynamická překompilace instrukce procesoru na nativní instrukce. Mnohem rychlejší než interpret, ale časování CPU je méně přesné a může obsahovat chyby."
#define OPTION_VAL_DISABLED_CS "Zakázáno (Beetle Interpreter)"
#define OPTION_VAL_EXECUTE_CS "Maximální Výkon"
#define OPTION_VAL_EXECUTE_ONE_CS "Kontrola Časování Cyklu"
#define OPTION_VAL_RUN_INTERPRETER_CS "Interpret Lightrec"
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CS "Zrušení Kódu Dynarec"
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CS "Některé hry vyžadují 'Plné' zneplatnění, jiné pouze 'DMA'."
#define OPTION_VAL_FULL_CS "Plné"
#define OPTION_VAL_DMA_CS "Pouze DMA (Mírně Rychlejší)"
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CS "Cykly událostí Dynarec DMA/GPU/MDEC/Timer"
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CS "Maximální počet cyklů spuštěných CPU před kontrolou aktualizace GPU/DMA/MDEC/Timer, vyšší číslo bude rychlejší, má mnohem menší vliv na interpreter beetle než dynarec."
#define OPTION_VAL_128_CS "128 (Výchozí)"
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CS "Vzorky Dynarec SPU"
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CS "Maximální počet vzorků SPU, které mají být spuštěny před kontrolou aktualizace SPU, vyšší číslo bude rychlejší, ale v některých hrách s jiným číslem než 1 bude způsobovat závady zvuku."
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_CS "Nahlášené-Jádro Časování FPS"
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CS "Zvolte časování FPS, které bude jádro hlásit frontendu. Automatické přepínání umožní jádru přepínat mezi hlášením progresivní a prokládané rychlosti, ale může způsobit opětovné spuštění ovladače videa/audia ve frontendu."
#define OPTION_VAL_FORCE_PROGRESSIVE_CS "Progresivní Hodnota"
#define OPTION_VAL_FORCE_INTERLACED_CS "Vynutit Prokládanou Hodnotu"
#define OPTION_VAL_AUTO_TOGGLE_CS "Povolit Automatické Přepínání"
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CS "Přepsání Časování Videa v Systému PAL (Evropský)"
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CS "Kvůli odlišným normám se hry pro PAL často jeví jako zpomalené ve srovnání s americkými nebo japonskými verzemi pro NTSC. Tuto možnost lze použít k potlačení časování PAL, abyste se pokusili spustit tyto hry se snímkovou frekvencí NTSC. Tato volba nemá žádný účinek při spouštění obsahu NTSC."
#define BEETLE_OPT_ASPECT_RATIO_LABEL_CS "Poměr Stran Jádra"
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_CS "Zvolte poměr stran jádra. Toto nastavení je ignorováno, pokud jsou povoleny možnosti Widescreen Mode Hack nebo Display Full VRAM."
#define OPTION_VAL_CORRECTED_CS "Opraveno"
#define OPTION_VAL_UNCORRECTED_CS "Neopraveno"
#define OPTION_VAL_4_3_CS "Vunutit 4:3"
#define OPTION_VAL_NTSC_CS "Vynutit NTSC"
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_CS "Overscan Oříznutí"
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_CS "'Žádný' zachovává výplň (sloupcové rámečky na obou stranách obrazu pro NTSC, na všech stranách pro PAL), aby se napodobily stejné černé pruhy generované na analogovém video výstupu skutečným hardwarem PSX. 'Statické' odstraní pouze horizontální polstrování, 'Dynamické' odstraní veškeré polstrování."
#define OPTION_VAL_DISABLED_O58_CS "Žádné"
#define OPTION_VAL_STATIC_CS "Statické"
#define OPTION_VAL_SMART_CS "Dynamické (Výchozí)"
#define BEETLE_OPT_IMAGE_CROP_LABEL_CS "Dodatečné Oříznutí"
#define BEETLE_OPT_IMAGE_CROP_INFO_0_CS "Pokud je povolena možnost 'Oříznout Horizontální Přesah', tato možnost dále zmenší šířku oříznutého obrazu o zadaný počet pixelů."
#define OPTION_VAL_9PX_CS NULL
#define OPTION_VAL_10PX_CS NULL
#define OPTION_VAL_11PX_CS NULL
#define OPTION_VAL_12PX_CS NULL
#define OPTION_VAL_13PX_CS NULL
#define OPTION_VAL_14PX_CS NULL
#define OPTION_VAL_15PX_CS NULL
#define OPTION_VAL_16PX_CS NULL
#define OPTION_VAL_17PX_CS NULL
#define OPTION_VAL_18PX_CS NULL
#define OPTION_VAL_19PX_CS NULL
#define OPTION_VAL_20PX_CS NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_CS "Posun Oříznutého Snímku"
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_CS "Pokud je povolena možnost 'Oříznout Horizontální Přesah', umožní to výsledný oříznutý obraz posunout horizontálně doprava (kladně) nebo doleva (záporně) o zadaný počet pixelů. Lze použít k opravě problémů se zarovnáním. Podporováno pouze softwarovým vykreslovačem."
#define OPTION_VAL_12PX_O60_CS NULL
#define OPTION_VAL_11PX_O60_CS NULL
#define OPTION_VAL_10PX_O60_CS NULL
#define OPTION_VAL_9PX_O60_CS NULL
#define OPTION_VAL_8PX_O60_CS NULL
#define OPTION_VAL_7PX_O60_CS NULL
#define OPTION_VAL_6PX_O60_CS NULL
#define OPTION_VAL_5PX_O60_CS NULL
#define OPTION_VAL_4PX_O60_CS NULL
#define OPTION_VAL_3PX_O60_CS NULL
#define OPTION_VAL_2PX_O60_CS NULL
#define OPTION_VAL_1PX_O60_CS NULL
#define OPTION_VAL_1PX_O60_0_CS NULL
#define OPTION_VAL_2PX_O60_0_CS NULL
#define OPTION_VAL_3PX_O60_0_CS NULL
#define OPTION_VAL_4PX_O60_0_CS NULL
#define OPTION_VAL_5PX_O60_0_CS NULL
#define OPTION_VAL_6PX_O60_0_CS NULL
#define OPTION_VAL_7PX_O60_0_CS NULL
#define OPTION_VAL_8PX_O60_0_CS NULL
#define OPTION_VAL_9PX_O60_0_CS NULL
#define OPTION_VAL_10PX_O60_0_CS NULL
#define OPTION_VAL_11PX_O60_0_CS NULL
#define OPTION_VAL_12PX_O60_0_CS NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CS "Horizontální Posun Obrazu (Cykly GPU)"
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CS "Zvolte počet cyklů GPU, o které se má obraz posunout. Kladné hodnoty posunou obraz doprava, záporné hodnoty doleva. Podporováno pouze hardwarovými vykreslovači."
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_CS "Počáteční Skenovací Řádek - NTSC"
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CS "Při spuštění obsahu NTSC vyberte první zobrazený řádek skenování. Hodnoty větší než nula sníží výšku výstupních obrázků oříznutím pixelů od nejvyššího okraje. Lze použít k potlačení letterboxingu."
#define OPTION_VAL_0_O62_CS NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_CS "Poslední Skenovací Řádek - NTSC"
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_CS "Při spuštění obsahu NTSC vyberte poslední zobrazený řádek skenování. Hodnoty menší než 239 sníží výšku výstupních obrázků oříznutím pixelů od nejspodnějšího okraje. Lze použít k potlačení letterboxingu."
#define OPTION_VAL_239_CS "239 (Výchozí)"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CS "Počáteční Skenovací Řádek - PAL"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CS "Při spouštění obsahu v systému PAL vyberte první zobrazený řádek skenování. Hodnoty větší než nula sníží výšku výstupních obrazů oříznutím pixelů od nejvyššího okraje. Lze použít k potlačení letterboxingu."
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CS "Poslední Skenovací Řádek - PAL"
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CS "Při spuštění obsahu PAL vyberte poslední zobrazený řádek skenování. Hodnoty nižší než 287 sníží výšku výstupních obrazů oříznutím pixelů od nejspodnějšího okraje. Lze použít k potlačení letterboxingu."
#define OPTION_VAL_287_CS "287 (Výchozí)"
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CS "Metoda Přístupu CD (Vyžadován Restart)"
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CS "Zvolte metodu používanou ke čtení dat z obrazů disku s obsahem. 'Synchronní' napodobuje původní hardware. 'Asynchronní' může snížit zadrhávání na zařízeních s pomalým úložištěm. 'Pre-Cache' načte celý obraz disku do paměti při spuštění obsahu, což může zlepšit časy načítání ve hře za cenu počátečního zpoždění při spuštění. Funkce 'Pre-Cache' může způsobovat problémy na systémech s malou pamětí RAM a v případě fyzických médií se vrátí k funkci 'Synchronní'."
#define OPTION_VAL_SYNC_CS "Synchronní"
#define OPTION_VAL_ASYNC_CS "Asynchronní"
#define OPTION_VAL_PRECACHE_CS NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_CS "Rychlost Načítání CD"
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_CS "Zvolte násobitel rychlosti přístupu k disku. Hodnoty vyšší než '2x (Native)' mohou výrazně zkrátit dobu načítání ve hře, ale mohou způsobit chyby v časování. Některé hry nemusí při překročení určité hodnoty fungovat správně."
#define OPTION_VAL_2X_NATIVE_CS "2x (Nativní)"
#define OPTION_VAL_6X_CS NULL
#define OPTION_VAL_10X_CS NULL
#define OPTION_VAL_12X_CS NULL
#define OPTION_VAL_14X_CS NULL

struct retro_core_option_v2_category option_cats_cs[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CS,
      CATEGORY_VIDEO_INFO_0_CS
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_CS,
      CATEGORY_OSD_INFO_0_CS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CS,
      CATEGORY_INPUT_INFO_0_CS
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_CS,
      CATEGORY_MEMCARDS_INFO_0_CS
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_CS,
      CATEGORY_PGXP_INFO_0_CS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CS,
      CATEGORY_HACKS_INFO_0_CS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cs[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CS,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CS,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CS },
         { "2x",         OPTION_VAL_2X_CS },
         { "4x",         OPTION_VAL_4X_CS },
         { "8x",         OPTION_VAL_8X_CS },
         { "16x",        OPTION_VAL_16X_CS },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_CS,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_CS,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_CS },
         { "32bpp",         OPTION_VAL_32BPP_CS },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_CS,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_CS,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_CS },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_CS },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CS,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CS,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_CS,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_CS,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_CS },
         { "SABR",     OPTION_VAL_SABR_CS },
         { "xBR",      OPTION_VAL_XBR_CS },
         { "bilinear", OPTION_VAL_BILINEAR_CS },
         { "3-point",  OPTION_VAL_3_POINT_CS },
         { "JINC2",    OPTION_VAL_JINC2_CS },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CS,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CS },
         { "all", OPTION_VAL_ALL_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CS,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CS },
         { "all", OPTION_VAL_ALL_CS },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CS,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_CS,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_CS,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_CS,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_CS },
         { "2x",  OPTION_VAL_2X_CS },
         { "4x",  OPTION_VAL_4X_CS },
         { "8x",  OPTION_VAL_8X_CS },
         { "16x", OPTION_VAL_16X_CS },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_CS,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_CS,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_CS,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_CS,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_CS,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_CS,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CS,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CS,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_CS,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_CS,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CS,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_CS,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CS,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CS,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_CS },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_CS },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_CS },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_CS },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_CS },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_CS },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_CS },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_CS },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_CS },
         { "l3+r3",                    OPTION_VAL_L3_R3_CS },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CS,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CS,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_CS },
         { "1", OPTION_VAL_1_CS },
         { "2", OPTION_VAL_2_CS },
         { "3", OPTION_VAL_3_CS },
         { "4", OPTION_VAL_4_CS },
         { "5", OPTION_VAL_5_CS },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CS,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CS,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_CS,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CS,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CS },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CS },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_CS,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_CS,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_CS },
         { "dot",   OPTION_VAL_DOT_CS },
         { "off",   OPTION_VAL_OFF_CS },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CS,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CS,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_CS },
         { "blue", OPTION_VAL_BLUE_CS },
         { "green", OPTION_VAL_GREEN_CS },
         { "orange", OPTION_VAL_ORANGE_CS },
         { "yellow", OPTION_VAL_YELLOW_CS },
         { "cyan", OPTION_VAL_CYAN_CS },
         { "pink", OPTION_VAL_PINK_CS },
         { "purple", OPTION_VAL_PURPLE_CS },
         { "black", OPTION_VAL_BLACK_CS },
         { "white", OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CS,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CS,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_CS },
         { "red", OPTION_VAL_RED_CS },
         { "green", OPTION_VAL_GREEN_CS },
         { "orange", OPTION_VAL_ORANGE_CS },
         { "yellow", OPTION_VAL_YELLOW_CS },
         { "cyan", OPTION_VAL_CYAN_CS },
         { "pink", OPTION_VAL_PINK_CS },
         { "purple", OPTION_VAL_PURPLE_CS },
         { "black", OPTION_VAL_BLACK_CS },
         { "white", OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CS,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CS,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_CS },
         { "10%",  OPTION_VAL_10_CS },
         { "15%",  OPTION_VAL_15_CS },
         { "20%",  OPTION_VAL_20_CS },
         { "25%",  OPTION_VAL_25_CS },
         { "30%",  OPTION_VAL_30_CS },
         { "35%",  OPTION_VAL_35_CS },
         { "40%",  OPTION_VAL_40_CS },
         { "45%",  OPTION_VAL_45_CS },
         { "50%",  OPTION_VAL_50_CS },
         { "55%",  OPTION_VAL_55_CS },
         { "60%",  OPTION_VAL_60_CS },
         { "65%",  OPTION_VAL_65_CS },
         { "70%",  OPTION_VAL_70_CS },
         { "75%",  OPTION_VAL_75_CS },
         { "80%",  OPTION_VAL_80_CS },
         { "85%",  OPTION_VAL_85_CS },
         { "90%",  OPTION_VAL_90_CS },
         { "95%",  OPTION_VAL_95_CS },
         { "100%", OPTION_VAL_100_CS },
         { "105%", OPTION_VAL_105_CS },
         { "110%", OPTION_VAL_110_CS },
         { "115%", OPTION_VAL_115_CS },
         { "120%", OPTION_VAL_120_CS },
         { "125%", OPTION_VAL_125_CS },
         { "130%", OPTION_VAL_130_CS },
         { "135%", OPTION_VAL_135_CS },
         { "140%", OPTION_VAL_140_CS },
         { "145%", OPTION_VAL_145_CS },
         { "150%", OPTION_VAL_150_CS },
         { "155%", OPTION_VAL_155_CS },
         { "160%", OPTION_VAL_160_CS },
         { "165%", OPTION_VAL_165_CS },
         { "170%", OPTION_VAL_170_CS },
         { "175%", OPTION_VAL_175_CS },
         { "180%", OPTION_VAL_180_CS },
         { "185%", OPTION_VAL_185_CS },
         { "190%", OPTION_VAL_190_CS },
         { "195%", OPTION_VAL_195_CS },
         { "200%", OPTION_VAL_200_CS },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_CS,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CS,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_CS },
         { "quadratic", OPTION_VAL_QUADRATIC_CS },
         { "cubic",     OPTION_VAL_CUBIC_CS },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_CS,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CS,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_CS },
         { "5%",  OPTION_VAL_5_O28_CS },
         { "10%", OPTION_VAL_10_CS },
         { "15%", OPTION_VAL_15_CS },
         { "20%", OPTION_VAL_20_CS },
         { "25%", OPTION_VAL_25_CS },
         { "30%", OPTION_VAL_30_CS },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CS,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CS,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_CS },
         { "mednafen", OPTION_VAL_MEDNAFEN_CS },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CS,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CS,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CS,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CS,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CS,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CS,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CS,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CS,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_CS },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_CS,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_CS,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_CS },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_CS,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_CS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_CS },
         { "1px", OPTION_VAL_1PX_CS },
         { "2px", OPTION_VAL_2PX_CS },
         { "3px", OPTION_VAL_3PX_CS },
         { "4px", OPTION_VAL_4PX_CS },
         { "5px", OPTION_VAL_5PX_CS },
         { "6px", OPTION_VAL_6PX_CS },
         { "7px", OPTION_VAL_7PX_CS },
         { "8px", OPTION_VAL_8PX_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_CS,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_CS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_CS,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_CS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_CS,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_CS,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_CS,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_CS },
         { "aggressive", OPTION_VAL_AGGRESSIVE_CS },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_CS,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CS,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_CS },
         { "16:10", OPTION_VAL_16_10_CS },
         { "18:9",  OPTION_VAL_18_9_CS },
         { "19:9",  OPTION_VAL_19_9_CS },
         { "20:9",  OPTION_VAL_20_9_CS },
         { "21:9",  OPTION_VAL_21_9_CS }, // 64:27
         { "32:9",  OPTION_VAL_32_9_CS },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CS,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_CS },
         { "60%",           OPTION_VAL_60_CS },
         { "70%",           OPTION_VAL_70_CS },
         { "80%",           OPTION_VAL_80_CS },
         { "90%",           OPTION_VAL_90_CS },
         { "100%(native)", OPTION_VAL_100_NATIVE_CS },
         { "110%",          OPTION_VAL_110_CS },
         { "120%",          OPTION_VAL_120_CS },
         { "130%",          OPTION_VAL_130_CS },
         { "140%",          OPTION_VAL_140_CS },
         { "150%",          OPTION_VAL_150_CS },
         { "160%",          OPTION_VAL_160_CS },
         { "170%",          OPTION_VAL_170_CS },
         { "180%",          OPTION_VAL_180_CS },
         { "190%",          OPTION_VAL_190_CS },
         { "200%",          OPTION_VAL_200_CS },
         { "210%",          OPTION_VAL_210_CS },
         { "220%",          OPTION_VAL_220_CS },
         { "230%",          OPTION_VAL_230_CS },
         { "240%",          OPTION_VAL_240_CS },
         { "250%",          OPTION_VAL_250_CS },
         { "260%",          OPTION_VAL_260_CS },
         { "270%",          OPTION_VAL_270_CS },
         { "280%",          OPTION_VAL_280_CS },
         { "290%",          OPTION_VAL_290_CS },
         { "300%",          OPTION_VAL_300_CS },
         { "310%",          OPTION_VAL_310_CS },
         { "320%",          OPTION_VAL_320_CS },
         { "330%",          OPTION_VAL_330_CS },
         { "340%",          OPTION_VAL_340_CS },
         { "350%",          OPTION_VAL_350_CS },
         { "360%",          OPTION_VAL_360_CS },
         { "370%",          OPTION_VAL_370_CS },
         { "380%",          OPTION_VAL_380_CS },
         { "390%",          OPTION_VAL_390_CS },
         { "400%",          OPTION_VAL_400_CS },
         { "410%",          OPTION_VAL_410_CS },
         { "420%",          OPTION_VAL_420_CS },
         { "430%",          OPTION_VAL_430_CS },
         { "440%",          OPTION_VAL_440_CS },
         { "450%",          OPTION_VAL_450_CS },
         { "460%",          OPTION_VAL_460_CS },
         { "470%",          OPTION_VAL_470_CS },
         { "480%",          OPTION_VAL_480_CS },
         { "490%",          OPTION_VAL_490_CS },
         { "500%",          OPTION_VAL_500_CS },
         { "510%",          OPTION_VAL_510_CS },
         { "520%",          OPTION_VAL_520_CS },
         { "530%",          OPTION_VAL_530_CS },
         { "540%",          OPTION_VAL_540_CS },
         { "550%",          OPTION_VAL_550_CS },
         { "560%",          OPTION_VAL_560_CS },
         { "570%",          OPTION_VAL_570_CS },
         { "580%",          OPTION_VAL_580_CS },
         { "590%",          OPTION_VAL_590_CS },
         { "600%",          OPTION_VAL_600_CS },
         { "610%",          OPTION_VAL_610_CS },
         { "620%",          OPTION_VAL_620_CS },
         { "630%",          OPTION_VAL_630_CS },
         { "640%",          OPTION_VAL_640_CS },
         { "650%",          OPTION_VAL_650_CS },
         { "660%",          OPTION_VAL_660_CS },
         { "670%",          OPTION_VAL_670_CS },
         { "680%",          OPTION_VAL_680_CS },
         { "690%",          OPTION_VAL_690_CS },
         { "700%",          OPTION_VAL_700_CS },
         { "710%",          OPTION_VAL_710_CS },
         { "720%",          OPTION_VAL_720_CS },
         { "730%",          OPTION_VAL_730_CS },
         { "740%",          OPTION_VAL_740_CS },
         { "750%",          OPTION_VAL_750_CS },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_CS,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CS },
         { "2x",         OPTION_VAL_2X_CS },
         { "4x",         OPTION_VAL_4X_CS },
         { "8x",         OPTION_VAL_8X_CS },
         { "16x",        OPTION_VAL_16X_CS },
         { "32x",        OPTION_VAL_32X_CS },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_CS,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_CS,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_CS,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_CS },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_CS },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_CS,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_CS,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_CS },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_CS },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_CS },
#endif
         { "software",    OPTION_VAL_SOFTWARE_CS },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CS,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CS,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_CS,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_CS,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_CS },
         { "execute",  OPTION_VAL_EXECUTE_CS },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_CS },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CS,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CS,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_CS },
         { "dma",  OPTION_VAL_DMA_CS },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CS,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_CS },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CS,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_CS },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_CS,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CS,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_CS },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_CS },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_CS },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CS,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_CS,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_CS,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_CS },
         { "uncorrected", OPTION_VAL_UNCORRECTED_CS },
         { "4:3",  OPTION_VAL_4_3_CS },
         { "ntsc", OPTION_VAL_NTSC_CS },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_CS,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_CS },
         { "static",  OPTION_VAL_STATIC_CS },
         { "smart", OPTION_VAL_SMART_CS },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_CS,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_CS },
         { "2px",      OPTION_VAL_2PX_CS },
         { "3px",      OPTION_VAL_3PX_CS },
         { "4px",      OPTION_VAL_4PX_CS },
         { "5px",      OPTION_VAL_5PX_CS },
         { "6px",      OPTION_VAL_6PX_CS },
         { "7px",      OPTION_VAL_7PX_CS },
         { "8px",      OPTION_VAL_8PX_CS },
         { "9px",      OPTION_VAL_9PX_CS },
         { "10px",     OPTION_VAL_10PX_CS },
         { "11px",     OPTION_VAL_11PX_CS },
         { "12px",     OPTION_VAL_12PX_CS },
         { "13px",     OPTION_VAL_13PX_CS },
         { "14px",     OPTION_VAL_14PX_CS },
         { "15px",     OPTION_VAL_15PX_CS },
         { "16px",     OPTION_VAL_16PX_CS },
         { "17px",     OPTION_VAL_17PX_CS },
         { "18px",     OPTION_VAL_18PX_CS },
         { "19px",     OPTION_VAL_19PX_CS },
         { "20px",     OPTION_VAL_20PX_CS },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_CS,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_CS,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_CS },
         { "-11px",    OPTION_VAL_11PX_O60_CS },
         { "-10px",    OPTION_VAL_10PX_O60_CS },
         { "-9px",     OPTION_VAL_9PX_O60_CS },
         { "-8px",     OPTION_VAL_8PX_O60_CS },
         { "-7px",     OPTION_VAL_7PX_O60_CS },
         { "-6px",     OPTION_VAL_6PX_O60_CS },
         { "-5px",     OPTION_VAL_5PX_O60_CS },
         { "-4px",     OPTION_VAL_4PX_O60_CS },
         { "-3px",     OPTION_VAL_3PX_O60_CS },
         { "-2px",     OPTION_VAL_2PX_O60_CS },
         { "-1px",     OPTION_VAL_1PX_O60_CS },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_CS },
         { "+2px",     OPTION_VAL_2PX_O60_0_CS },
         { "+3px",     OPTION_VAL_3PX_O60_0_CS },
         { "+4px",     OPTION_VAL_4PX_O60_0_CS },
         { "+5px",     OPTION_VAL_5PX_O60_0_CS },
         { "+6px",     OPTION_VAL_6PX_O60_0_CS },
         { "+7px",     OPTION_VAL_7PX_O60_0_CS },
         { "+8px",     OPTION_VAL_8PX_O60_0_CS },
         { "+9px",     OPTION_VAL_9PX_O60_0_CS },
         { "+10px",    OPTION_VAL_10PX_O60_0_CS },
         { "+11px",    OPTION_VAL_11PX_O60_0_CS },
         { "+12px",    OPTION_VAL_12PX_O60_0_CS },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CS,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CS,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_CS,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CS,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CS },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_CS,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_CS,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_CS },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CS,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CS,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CS },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CS,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CS,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_CS },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CS,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CS,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_CS },
         { "async",    OPTION_VAL_ASYNC_CS },
         { "precache", OPTION_VAL_PRECACHE_CS },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_CS,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_CS,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_CS },
         { "4x",          OPTION_VAL_4X_CS },
         { "6x",          OPTION_VAL_6X_CS },
         { "8x",          OPTION_VAL_8X_CS },
         { "10x",         OPTION_VAL_10X_CS },
         { "12x",         OPTION_VAL_12X_CS },
         { "14x",         OPTION_VAL_14X_CS },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cs = {
   option_cats_cs,
   option_defs_cs
};

/* RETRO_LANGUAGE_CY */

#define CATEGORY_VIDEO_LABEL_CY NULL
#define CATEGORY_VIDEO_INFO_0_CY NULL
#define CATEGORY_OSD_LABEL_CY NULL
#define CATEGORY_OSD_INFO_0_CY NULL
#define CATEGORY_INPUT_LABEL_CY "Mewnbwn"
#define CATEGORY_INPUT_INFO_0_CY NULL
#define CATEGORY_MEMCARDS_LABEL_CY NULL
#define CATEGORY_MEMCARDS_INFO_0_CY NULL
#define CATEGORY_PGXP_LABEL_CY NULL
#define CATEGORY_PGXP_INFO_0_CY NULL
#define CATEGORY_HACKS_LABEL_CY NULL
#define CATEGORY_HACKS_INFO_0_CY NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CY NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CY NULL
#define OPTION_VAL_1X_NATIVE_CY NULL
#define OPTION_VAL_2X_CY NULL
#define OPTION_VAL_4X_CY NULL
#define OPTION_VAL_8X_CY NULL
#define OPTION_VAL_16X_CY NULL
#define BEETLE_OPT_DEPTH_LABEL_CY NULL
#define BEETLE_OPT_DEPTH_INFO_0_CY NULL
#define OPTION_VAL_16BPP_NATIVE_CY NULL
#define OPTION_VAL_32BPP_CY NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_CY NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_CY NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_CY NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CY NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CY NULL
#define BEETLE_OPT_FILTER_LABEL_CY NULL
#define BEETLE_OPT_FILTER_INFO_0_CY NULL
#define OPTION_VAL_NEAREST_CY NULL
#define OPTION_VAL_SABR_CY NULL
#define OPTION_VAL_XBR_CY NULL
#define OPTION_VAL_BILINEAR_CY NULL
#define OPTION_VAL_3_POINT_CY NULL
#define OPTION_VAL_JINC2_CY NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CY NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CY NULL
#define OPTION_VAL_OPAQUE_CY NULL
#define OPTION_VAL_ALL_CY NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CY NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CY NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CY NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CY NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_CY NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_CY NULL
#define BEETLE_OPT_MSAA_LABEL_CY NULL
#define BEETLE_OPT_MSAA_INFO_0_CY NULL
#define OPTION_VAL_1X_CY NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_CY NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_CY NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_CY NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_CY NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_CY NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_CY NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_CY NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CY NULL
#define BEETLE_OPT_WIREFRAME_LABEL_CY NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_CY NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_CY NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_CY NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CY NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CY NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_CY NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_CY NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CY NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CY NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_CY NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CY NULL
#define OPTION_VAL_ENABLED_ANALOG_CY NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CY NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CY NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_CY NULL
#define OPTION_VAL_L1_R1_SELECT_CY NULL
#define OPTION_VAL_L1_R1_START_CY NULL
#define OPTION_VAL_L1_R1_L3_CY NULL
#define OPTION_VAL_L1_R1_R3_CY NULL
#define OPTION_VAL_L2_R2_SELECT_CY NULL
#define OPTION_VAL_L2_R2_START_CY NULL
#define OPTION_VAL_L2_R2_L3_CY NULL
#define OPTION_VAL_L2_R2_R3_CY NULL
#define OPTION_VAL_L3_R3_CY NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CY NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CY NULL
#define OPTION_VAL_0_CY NULL
#define OPTION_VAL_1_CY NULL
#define OPTION_VAL_2_CY NULL
#define OPTION_VAL_3_CY NULL
#define OPTION_VAL_4_CY NULL
#define OPTION_VAL_5_CY NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CY NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CY NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CY NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CY NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_CY NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CY NULL
#define OPTION_VAL_LIGHTGUN_CY NULL
#define OPTION_VAL_TOUCHSCREEN_CY NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_CY NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_CY NULL
#define OPTION_VAL_CROSS_CY NULL
#define OPTION_VAL_DOT_CY NULL
#define OPTION_VAL_OFF_CY NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CY NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CY NULL
#define OPTION_VAL_RED_CY "Coch"
#define OPTION_VAL_BLUE_CY NULL
#define OPTION_VAL_GREEN_CY NULL
#define OPTION_VAL_ORANGE_CY NULL
#define OPTION_VAL_YELLOW_CY NULL
#define OPTION_VAL_CYAN_CY NULL
#define OPTION_VAL_PINK_CY NULL
#define OPTION_VAL_PURPLE_CY NULL
#define OPTION_VAL_BLACK_CY NULL
#define OPTION_VAL_WHITE_CY NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CY NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CY NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CY NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CY NULL
#define OPTION_VAL_5_O28_CY NULL
#define OPTION_VAL_10_CY NULL
#define OPTION_VAL_15_CY NULL
#define OPTION_VAL_20_CY NULL
#define OPTION_VAL_25_CY NULL
#define OPTION_VAL_30_CY NULL
#define OPTION_VAL_35_CY NULL
#define OPTION_VAL_40_CY NULL
#define OPTION_VAL_45_CY NULL
#define OPTION_VAL_50_CY NULL
#define OPTION_VAL_55_CY NULL
#define OPTION_VAL_60_CY NULL
#define OPTION_VAL_65_CY NULL
#define OPTION_VAL_70_CY NULL
#define OPTION_VAL_75_CY NULL
#define OPTION_VAL_80_CY NULL
#define OPTION_VAL_85_CY NULL
#define OPTION_VAL_90_CY NULL
#define OPTION_VAL_95_CY NULL
#define OPTION_VAL_100_CY NULL
#define OPTION_VAL_105_CY NULL
#define OPTION_VAL_110_CY NULL
#define OPTION_VAL_115_CY NULL
#define OPTION_VAL_120_CY NULL
#define OPTION_VAL_125_CY NULL
#define OPTION_VAL_130_CY NULL
#define OPTION_VAL_135_CY NULL
#define OPTION_VAL_140_CY NULL
#define OPTION_VAL_145_CY NULL
#define OPTION_VAL_150_CY NULL
#define OPTION_VAL_155_CY NULL
#define OPTION_VAL_160_CY NULL
#define OPTION_VAL_165_CY NULL
#define OPTION_VAL_170_CY NULL
#define OPTION_VAL_175_CY NULL
#define OPTION_VAL_180_CY NULL
#define OPTION_VAL_185_CY NULL
#define OPTION_VAL_190_CY NULL
#define OPTION_VAL_195_CY NULL
#define OPTION_VAL_200_CY NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_CY NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CY NULL
#define OPTION_VAL_LINEAR_CY NULL
#define OPTION_VAL_QUADRATIC_CY NULL
#define OPTION_VAL_CUBIC_CY NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_CY NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CY NULL
#define OPTION_VAL_0_O30_CY NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CY NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CY NULL
#define OPTION_VAL_LIBRETRO_CY NULL
#define OPTION_VAL_MEDNAFEN_CY NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CY NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CY NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CY NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CY NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CY NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CY NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CY NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CY NULL
#define OPTION_VAL_1_O35_CY NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_CY NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_CY NULL
#define OPTION_VAL_MEMORY_ONLY_CY NULL
#define OPTION_VAL_MEMORY_CPU_CY NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_CY NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_CY NULL
#define OPTION_VAL_0PX_CY NULL
#define OPTION_VAL_1PX_CY NULL
#define OPTION_VAL_2PX_CY NULL
#define OPTION_VAL_3PX_CY NULL
#define OPTION_VAL_4PX_CY NULL
#define OPTION_VAL_5PX_CY NULL
#define OPTION_VAL_6PX_CY NULL
#define OPTION_VAL_7PX_CY NULL
#define OPTION_VAL_8PX_CY NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_CY NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_CY NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_CY NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_CY NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_CY NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_CY NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_CY NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_CY NULL
#define OPTION_VAL_DEFAULT_CY NULL
#define OPTION_VAL_AGGRESSIVE_CY NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_CY NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CY NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CY NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CY NULL
#define OPTION_VAL_16_9_CY NULL
#define OPTION_VAL_16_10_CY NULL
#define OPTION_VAL_18_9_CY NULL
#define OPTION_VAL_19_9_CY NULL
#define OPTION_VAL_20_9_CY NULL
#define OPTION_VAL_21_9_CY NULL
#define OPTION_VAL_32_9_CY NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CY NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CY NULL
#define OPTION_VAL_100_NATIVE_CY NULL
#define OPTION_VAL_210_CY NULL
#define OPTION_VAL_220_CY NULL
#define OPTION_VAL_230_CY NULL
#define OPTION_VAL_240_CY NULL
#define OPTION_VAL_250_CY NULL
#define OPTION_VAL_260_CY NULL
#define OPTION_VAL_270_CY NULL
#define OPTION_VAL_280_CY NULL
#define OPTION_VAL_290_CY NULL
#define OPTION_VAL_300_CY NULL
#define OPTION_VAL_310_CY NULL
#define OPTION_VAL_320_CY NULL
#define OPTION_VAL_330_CY NULL
#define OPTION_VAL_340_CY NULL
#define OPTION_VAL_350_CY NULL
#define OPTION_VAL_360_CY NULL
#define OPTION_VAL_370_CY NULL
#define OPTION_VAL_380_CY NULL
#define OPTION_VAL_390_CY NULL
#define OPTION_VAL_400_CY NULL
#define OPTION_VAL_410_CY NULL
#define OPTION_VAL_420_CY NULL
#define OPTION_VAL_430_CY NULL
#define OPTION_VAL_440_CY NULL
#define OPTION_VAL_450_CY NULL
#define OPTION_VAL_460_CY NULL
#define OPTION_VAL_470_CY NULL
#define OPTION_VAL_480_CY NULL
#define OPTION_VAL_490_CY NULL
#define OPTION_VAL_500_CY NULL
#define OPTION_VAL_510_CY NULL
#define OPTION_VAL_520_CY NULL
#define OPTION_VAL_530_CY NULL
#define OPTION_VAL_540_CY NULL
#define OPTION_VAL_550_CY NULL
#define OPTION_VAL_560_CY NULL
#define OPTION_VAL_570_CY NULL
#define OPTION_VAL_580_CY NULL
#define OPTION_VAL_590_CY NULL
#define OPTION_VAL_600_CY NULL
#define OPTION_VAL_610_CY NULL
#define OPTION_VAL_620_CY NULL
#define OPTION_VAL_630_CY NULL
#define OPTION_VAL_640_CY NULL
#define OPTION_VAL_650_CY NULL
#define OPTION_VAL_660_CY NULL
#define OPTION_VAL_670_CY NULL
#define OPTION_VAL_680_CY NULL
#define OPTION_VAL_690_CY NULL
#define OPTION_VAL_700_CY NULL
#define OPTION_VAL_710_CY NULL
#define OPTION_VAL_720_CY NULL
#define OPTION_VAL_730_CY NULL
#define OPTION_VAL_740_CY NULL
#define OPTION_VAL_750_CY NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_CY NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CY NULL
#define OPTION_VAL_32X_CY NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_CY NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CY NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_CY NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_CY NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_CY NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CY NULL
#define OPTION_VAL_PSXONPSP_CY NULL
#define OPTION_VAL_PS1_ROM_CY NULL
#define BEETLE_OPT_RENDERER_LABEL_CY NULL
#define BEETLE_OPT_RENDERER_INFO_0_CY NULL
#define OPTION_VAL_HARDWARE_CY NULL
#define OPTION_VAL_HARDWARE_GL_CY NULL
#define OPTION_VAL_HARDWARE_VK_CY NULL
#define OPTION_VAL_SOFTWARE_CY NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CY NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CY NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_CY NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_CY NULL
#define OPTION_VAL_DISABLED_CY NULL
#define OPTION_VAL_EXECUTE_CY NULL
#define OPTION_VAL_EXECUTE_ONE_CY NULL
#define OPTION_VAL_RUN_INTERPRETER_CY NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CY NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CY NULL
#define OPTION_VAL_FULL_CY NULL
#define OPTION_VAL_DMA_CY NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CY NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CY NULL
#define OPTION_VAL_128_CY NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CY NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CY NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_CY NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CY NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_CY NULL
#define OPTION_VAL_FORCE_INTERLACED_CY NULL
#define OPTION_VAL_AUTO_TOGGLE_CY NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CY NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CY NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_CY NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_CY NULL
#define OPTION_VAL_CORRECTED_CY NULL
#define OPTION_VAL_UNCORRECTED_CY NULL
#define OPTION_VAL_4_3_CY NULL
#define OPTION_VAL_NTSC_CY NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_CY NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_CY NULL
#define OPTION_VAL_DISABLED_O58_CY "Dim"
#define OPTION_VAL_STATIC_CY NULL
#define OPTION_VAL_SMART_CY NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_CY NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_CY NULL
#define OPTION_VAL_9PX_CY NULL
#define OPTION_VAL_10PX_CY NULL
#define OPTION_VAL_11PX_CY NULL
#define OPTION_VAL_12PX_CY NULL
#define OPTION_VAL_13PX_CY NULL
#define OPTION_VAL_14PX_CY NULL
#define OPTION_VAL_15PX_CY NULL
#define OPTION_VAL_16PX_CY NULL
#define OPTION_VAL_17PX_CY NULL
#define OPTION_VAL_18PX_CY NULL
#define OPTION_VAL_19PX_CY NULL
#define OPTION_VAL_20PX_CY NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_CY NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_CY NULL
#define OPTION_VAL_12PX_O60_CY NULL
#define OPTION_VAL_11PX_O60_CY NULL
#define OPTION_VAL_10PX_O60_CY NULL
#define OPTION_VAL_9PX_O60_CY NULL
#define OPTION_VAL_8PX_O60_CY NULL
#define OPTION_VAL_7PX_O60_CY NULL
#define OPTION_VAL_6PX_O60_CY NULL
#define OPTION_VAL_5PX_O60_CY NULL
#define OPTION_VAL_4PX_O60_CY NULL
#define OPTION_VAL_3PX_O60_CY NULL
#define OPTION_VAL_2PX_O60_CY NULL
#define OPTION_VAL_1PX_O60_CY NULL
#define OPTION_VAL_1PX_O60_0_CY NULL
#define OPTION_VAL_2PX_O60_0_CY NULL
#define OPTION_VAL_3PX_O60_0_CY NULL
#define OPTION_VAL_4PX_O60_0_CY NULL
#define OPTION_VAL_5PX_O60_0_CY NULL
#define OPTION_VAL_6PX_O60_0_CY NULL
#define OPTION_VAL_7PX_O60_0_CY NULL
#define OPTION_VAL_8PX_O60_0_CY NULL
#define OPTION_VAL_9PX_O60_0_CY NULL
#define OPTION_VAL_10PX_O60_0_CY NULL
#define OPTION_VAL_11PX_O60_0_CY NULL
#define OPTION_VAL_12PX_O60_0_CY NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CY NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CY NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_CY NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CY NULL
#define OPTION_VAL_0_O62_CY NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_CY NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_CY NULL
#define OPTION_VAL_239_CY NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CY NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CY NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CY NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CY NULL
#define OPTION_VAL_287_CY NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CY NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CY NULL
#define OPTION_VAL_SYNC_CY NULL
#define OPTION_VAL_ASYNC_CY NULL
#define OPTION_VAL_PRECACHE_CY NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_CY NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_CY NULL
#define OPTION_VAL_2X_NATIVE_CY NULL
#define OPTION_VAL_6X_CY NULL
#define OPTION_VAL_10X_CY NULL
#define OPTION_VAL_12X_CY NULL
#define OPTION_VAL_14X_CY NULL

struct retro_core_option_v2_category option_cats_cy[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_CY,
      CATEGORY_VIDEO_INFO_0_CY
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_CY,
      CATEGORY_OSD_INFO_0_CY
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CY,
      CATEGORY_INPUT_INFO_0_CY
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_CY,
      CATEGORY_MEMCARDS_INFO_0_CY
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_CY,
      CATEGORY_PGXP_INFO_0_CY
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CY,
      CATEGORY_HACKS_INFO_0_CY
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cy[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_CY,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_CY,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CY },
         { "2x",         OPTION_VAL_2X_CY },
         { "4x",         OPTION_VAL_4X_CY },
         { "8x",         OPTION_VAL_8X_CY },
         { "16x",        OPTION_VAL_16X_CY },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_CY,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_CY,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_CY },
         { "32bpp",         OPTION_VAL_32BPP_CY },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_CY,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_CY,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_CY },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_CY },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_CY,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_CY,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_CY,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_CY,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_CY },
         { "SABR",     OPTION_VAL_SABR_CY },
         { "xBR",      OPTION_VAL_XBR_CY },
         { "bilinear", OPTION_VAL_BILINEAR_CY },
         { "3-point",  OPTION_VAL_3_POINT_CY },
         { "JINC2",    OPTION_VAL_JINC2_CY },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_CY,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CY },
         { "all", OPTION_VAL_ALL_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_CY,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_CY },
         { "all", OPTION_VAL_ALL_CY },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_CY,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_CY,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_CY,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_CY,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_CY },
         { "2x",  OPTION_VAL_2X_CY },
         { "4x",  OPTION_VAL_4X_CY },
         { "8x",  OPTION_VAL_8X_CY },
         { "16x", OPTION_VAL_16X_CY },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_CY,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_CY,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_CY,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_CY,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_CY,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_CY,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_CY,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_CY,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_CY,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_CY,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_CY,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_CY,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_CY,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_CY,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_CY },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_CY },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_CY },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_CY },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_CY },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_CY },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_CY },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_CY },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_CY },
         { "l3+r3",                    OPTION_VAL_L3_R3_CY },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_CY,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_CY,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_CY },
         { "1", OPTION_VAL_1_CY },
         { "2", OPTION_VAL_2_CY },
         { "3", OPTION_VAL_3_CY },
         { "4", OPTION_VAL_4_CY },
         { "5", OPTION_VAL_5_CY },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_CY,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_CY,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_CY,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_CY,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_CY },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_CY },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_CY,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_CY,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_CY },
         { "dot",   OPTION_VAL_DOT_CY },
         { "off",   OPTION_VAL_OFF_CY },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_CY,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_CY,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_CY },
         { "blue", OPTION_VAL_BLUE_CY },
         { "green", OPTION_VAL_GREEN_CY },
         { "orange", OPTION_VAL_ORANGE_CY },
         { "yellow", OPTION_VAL_YELLOW_CY },
         { "cyan", OPTION_VAL_CYAN_CY },
         { "pink", OPTION_VAL_PINK_CY },
         { "purple", OPTION_VAL_PURPLE_CY },
         { "black", OPTION_VAL_BLACK_CY },
         { "white", OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_CY,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_CY,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_CY },
         { "red", OPTION_VAL_RED_CY },
         { "green", OPTION_VAL_GREEN_CY },
         { "orange", OPTION_VAL_ORANGE_CY },
         { "yellow", OPTION_VAL_YELLOW_CY },
         { "cyan", OPTION_VAL_CYAN_CY },
         { "pink", OPTION_VAL_PINK_CY },
         { "purple", OPTION_VAL_PURPLE_CY },
         { "black", OPTION_VAL_BLACK_CY },
         { "white", OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_CY,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_CY,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_CY },
         { "10%",  OPTION_VAL_10_CY },
         { "15%",  OPTION_VAL_15_CY },
         { "20%",  OPTION_VAL_20_CY },
         { "25%",  OPTION_VAL_25_CY },
         { "30%",  OPTION_VAL_30_CY },
         { "35%",  OPTION_VAL_35_CY },
         { "40%",  OPTION_VAL_40_CY },
         { "45%",  OPTION_VAL_45_CY },
         { "50%",  OPTION_VAL_50_CY },
         { "55%",  OPTION_VAL_55_CY },
         { "60%",  OPTION_VAL_60_CY },
         { "65%",  OPTION_VAL_65_CY },
         { "70%",  OPTION_VAL_70_CY },
         { "75%",  OPTION_VAL_75_CY },
         { "80%",  OPTION_VAL_80_CY },
         { "85%",  OPTION_VAL_85_CY },
         { "90%",  OPTION_VAL_90_CY },
         { "95%",  OPTION_VAL_95_CY },
         { "100%", OPTION_VAL_100_CY },
         { "105%", OPTION_VAL_105_CY },
         { "110%", OPTION_VAL_110_CY },
         { "115%", OPTION_VAL_115_CY },
         { "120%", OPTION_VAL_120_CY },
         { "125%", OPTION_VAL_125_CY },
         { "130%", OPTION_VAL_130_CY },
         { "135%", OPTION_VAL_135_CY },
         { "140%", OPTION_VAL_140_CY },
         { "145%", OPTION_VAL_145_CY },
         { "150%", OPTION_VAL_150_CY },
         { "155%", OPTION_VAL_155_CY },
         { "160%", OPTION_VAL_160_CY },
         { "165%", OPTION_VAL_165_CY },
         { "170%", OPTION_VAL_170_CY },
         { "175%", OPTION_VAL_175_CY },
         { "180%", OPTION_VAL_180_CY },
         { "185%", OPTION_VAL_185_CY },
         { "190%", OPTION_VAL_190_CY },
         { "195%", OPTION_VAL_195_CY },
         { "200%", OPTION_VAL_200_CY },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_CY,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_CY,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_CY },
         { "quadratic", OPTION_VAL_QUADRATIC_CY },
         { "cubic",     OPTION_VAL_CUBIC_CY },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_CY,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_CY,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_CY },
         { "5%",  OPTION_VAL_5_O28_CY },
         { "10%", OPTION_VAL_10_CY },
         { "15%", OPTION_VAL_15_CY },
         { "20%", OPTION_VAL_20_CY },
         { "25%", OPTION_VAL_25_CY },
         { "30%", OPTION_VAL_30_CY },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_CY,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_CY,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_CY },
         { "mednafen", OPTION_VAL_MEDNAFEN_CY },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_CY,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_CY,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_CY,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_CY,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_CY,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_CY,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_CY,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_CY,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_CY },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_CY,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_CY,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_CY },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_CY,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_CY,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_CY },
         { "1px", OPTION_VAL_1PX_CY },
         { "2px", OPTION_VAL_2PX_CY },
         { "3px", OPTION_VAL_3PX_CY },
         { "4px", OPTION_VAL_4PX_CY },
         { "5px", OPTION_VAL_5PX_CY },
         { "6px", OPTION_VAL_6PX_CY },
         { "7px", OPTION_VAL_7PX_CY },
         { "8px", OPTION_VAL_8PX_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_CY,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_CY,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_CY,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_CY,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_CY,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_CY,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_CY,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_CY },
         { "aggressive", OPTION_VAL_AGGRESSIVE_CY },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_CY,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_CY,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_CY },
         { "16:10", OPTION_VAL_16_10_CY },
         { "18:9",  OPTION_VAL_18_9_CY },
         { "19:9",  OPTION_VAL_19_9_CY },
         { "20:9",  OPTION_VAL_20_9_CY },
         { "21:9",  OPTION_VAL_21_9_CY }, // 64:27
         { "32:9",  OPTION_VAL_32_9_CY },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_CY,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_CY },
         { "60%",           OPTION_VAL_60_CY },
         { "70%",           OPTION_VAL_70_CY },
         { "80%",           OPTION_VAL_80_CY },
         { "90%",           OPTION_VAL_90_CY },
         { "100%(native)", OPTION_VAL_100_NATIVE_CY },
         { "110%",          OPTION_VAL_110_CY },
         { "120%",          OPTION_VAL_120_CY },
         { "130%",          OPTION_VAL_130_CY },
         { "140%",          OPTION_VAL_140_CY },
         { "150%",          OPTION_VAL_150_CY },
         { "160%",          OPTION_VAL_160_CY },
         { "170%",          OPTION_VAL_170_CY },
         { "180%",          OPTION_VAL_180_CY },
         { "190%",          OPTION_VAL_190_CY },
         { "200%",          OPTION_VAL_200_CY },
         { "210%",          OPTION_VAL_210_CY },
         { "220%",          OPTION_VAL_220_CY },
         { "230%",          OPTION_VAL_230_CY },
         { "240%",          OPTION_VAL_240_CY },
         { "250%",          OPTION_VAL_250_CY },
         { "260%",          OPTION_VAL_260_CY },
         { "270%",          OPTION_VAL_270_CY },
         { "280%",          OPTION_VAL_280_CY },
         { "290%",          OPTION_VAL_290_CY },
         { "300%",          OPTION_VAL_300_CY },
         { "310%",          OPTION_VAL_310_CY },
         { "320%",          OPTION_VAL_320_CY },
         { "330%",          OPTION_VAL_330_CY },
         { "340%",          OPTION_VAL_340_CY },
         { "350%",          OPTION_VAL_350_CY },
         { "360%",          OPTION_VAL_360_CY },
         { "370%",          OPTION_VAL_370_CY },
         { "380%",          OPTION_VAL_380_CY },
         { "390%",          OPTION_VAL_390_CY },
         { "400%",          OPTION_VAL_400_CY },
         { "410%",          OPTION_VAL_410_CY },
         { "420%",          OPTION_VAL_420_CY },
         { "430%",          OPTION_VAL_430_CY },
         { "440%",          OPTION_VAL_440_CY },
         { "450%",          OPTION_VAL_450_CY },
         { "460%",          OPTION_VAL_460_CY },
         { "470%",          OPTION_VAL_470_CY },
         { "480%",          OPTION_VAL_480_CY },
         { "490%",          OPTION_VAL_490_CY },
         { "500%",          OPTION_VAL_500_CY },
         { "510%",          OPTION_VAL_510_CY },
         { "520%",          OPTION_VAL_520_CY },
         { "530%",          OPTION_VAL_530_CY },
         { "540%",          OPTION_VAL_540_CY },
         { "550%",          OPTION_VAL_550_CY },
         { "560%",          OPTION_VAL_560_CY },
         { "570%",          OPTION_VAL_570_CY },
         { "580%",          OPTION_VAL_580_CY },
         { "590%",          OPTION_VAL_590_CY },
         { "600%",          OPTION_VAL_600_CY },
         { "610%",          OPTION_VAL_610_CY },
         { "620%",          OPTION_VAL_620_CY },
         { "630%",          OPTION_VAL_630_CY },
         { "640%",          OPTION_VAL_640_CY },
         { "650%",          OPTION_VAL_650_CY },
         { "660%",          OPTION_VAL_660_CY },
         { "670%",          OPTION_VAL_670_CY },
         { "680%",          OPTION_VAL_680_CY },
         { "690%",          OPTION_VAL_690_CY },
         { "700%",          OPTION_VAL_700_CY },
         { "710%",          OPTION_VAL_710_CY },
         { "720%",          OPTION_VAL_720_CY },
         { "730%",          OPTION_VAL_730_CY },
         { "740%",          OPTION_VAL_740_CY },
         { "750%",          OPTION_VAL_750_CY },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_CY,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_CY },
         { "2x",         OPTION_VAL_2X_CY },
         { "4x",         OPTION_VAL_4X_CY },
         { "8x",         OPTION_VAL_8X_CY },
         { "16x",        OPTION_VAL_16X_CY },
         { "32x",        OPTION_VAL_32X_CY },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_CY,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_CY,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_CY,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_CY },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_CY },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_CY,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_CY,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_CY },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_CY },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_CY },
#endif
         { "software",    OPTION_VAL_SOFTWARE_CY },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_CY,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_CY,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_CY,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_CY,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_CY },
         { "execute",  OPTION_VAL_EXECUTE_CY },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_CY },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_CY,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_CY,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_CY },
         { "dma",  OPTION_VAL_DMA_CY },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_CY,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_CY },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_CY,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_CY },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_CY,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_CY,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_CY },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_CY },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_CY },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_CY,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_CY,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_CY,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_CY },
         { "uncorrected", OPTION_VAL_UNCORRECTED_CY },
         { "4:3",  OPTION_VAL_4_3_CY },
         { "ntsc", OPTION_VAL_NTSC_CY },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_CY,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_CY },
         { "static",  OPTION_VAL_STATIC_CY },
         { "smart", OPTION_VAL_SMART_CY },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_CY,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_CY },
         { "2px",      OPTION_VAL_2PX_CY },
         { "3px",      OPTION_VAL_3PX_CY },
         { "4px",      OPTION_VAL_4PX_CY },
         { "5px",      OPTION_VAL_5PX_CY },
         { "6px",      OPTION_VAL_6PX_CY },
         { "7px",      OPTION_VAL_7PX_CY },
         { "8px",      OPTION_VAL_8PX_CY },
         { "9px",      OPTION_VAL_9PX_CY },
         { "10px",     OPTION_VAL_10PX_CY },
         { "11px",     OPTION_VAL_11PX_CY },
         { "12px",     OPTION_VAL_12PX_CY },
         { "13px",     OPTION_VAL_13PX_CY },
         { "14px",     OPTION_VAL_14PX_CY },
         { "15px",     OPTION_VAL_15PX_CY },
         { "16px",     OPTION_VAL_16PX_CY },
         { "17px",     OPTION_VAL_17PX_CY },
         { "18px",     OPTION_VAL_18PX_CY },
         { "19px",     OPTION_VAL_19PX_CY },
         { "20px",     OPTION_VAL_20PX_CY },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_CY,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_CY,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_CY },
         { "-11px",    OPTION_VAL_11PX_O60_CY },
         { "-10px",    OPTION_VAL_10PX_O60_CY },
         { "-9px",     OPTION_VAL_9PX_O60_CY },
         { "-8px",     OPTION_VAL_8PX_O60_CY },
         { "-7px",     OPTION_VAL_7PX_O60_CY },
         { "-6px",     OPTION_VAL_6PX_O60_CY },
         { "-5px",     OPTION_VAL_5PX_O60_CY },
         { "-4px",     OPTION_VAL_4PX_O60_CY },
         { "-3px",     OPTION_VAL_3PX_O60_CY },
         { "-2px",     OPTION_VAL_2PX_O60_CY },
         { "-1px",     OPTION_VAL_1PX_O60_CY },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_CY },
         { "+2px",     OPTION_VAL_2PX_O60_0_CY },
         { "+3px",     OPTION_VAL_3PX_O60_0_CY },
         { "+4px",     OPTION_VAL_4PX_O60_0_CY },
         { "+5px",     OPTION_VAL_5PX_O60_0_CY },
         { "+6px",     OPTION_VAL_6PX_O60_0_CY },
         { "+7px",     OPTION_VAL_7PX_O60_0_CY },
         { "+8px",     OPTION_VAL_8PX_O60_0_CY },
         { "+9px",     OPTION_VAL_9PX_O60_0_CY },
         { "+10px",    OPTION_VAL_10PX_O60_0_CY },
         { "+11px",    OPTION_VAL_11PX_O60_0_CY },
         { "+12px",    OPTION_VAL_12PX_O60_0_CY },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_CY,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_CY,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_CY,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_CY,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CY },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_CY,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_CY,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_CY },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_CY,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_CY,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_CY },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_CY,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_CY,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_CY },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_CY,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_CY,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_CY },
         { "async",    OPTION_VAL_ASYNC_CY },
         { "precache", OPTION_VAL_PRECACHE_CY },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_CY,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_CY,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_CY },
         { "4x",          OPTION_VAL_4X_CY },
         { "6x",          OPTION_VAL_6X_CY },
         { "8x",          OPTION_VAL_8X_CY },
         { "10x",         OPTION_VAL_10X_CY },
         { "12x",         OPTION_VAL_12X_CY },
         { "14x",         OPTION_VAL_14X_CY },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cy = {
   option_cats_cy,
   option_defs_cy
};

/* RETRO_LANGUAGE_DA */

#define CATEGORY_VIDEO_LABEL_DA NULL
#define CATEGORY_VIDEO_INFO_0_DA NULL
#define CATEGORY_OSD_LABEL_DA NULL
#define CATEGORY_OSD_INFO_0_DA NULL
#define CATEGORY_INPUT_LABEL_DA NULL
#define CATEGORY_INPUT_INFO_0_DA NULL
#define CATEGORY_MEMCARDS_LABEL_DA NULL
#define CATEGORY_MEMCARDS_INFO_0_DA NULL
#define CATEGORY_PGXP_LABEL_DA NULL
#define CATEGORY_PGXP_INFO_0_DA NULL
#define CATEGORY_HACKS_LABEL_DA NULL
#define CATEGORY_HACKS_INFO_0_DA NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_DA NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_DA NULL
#define OPTION_VAL_1X_NATIVE_DA NULL
#define OPTION_VAL_2X_DA NULL
#define OPTION_VAL_4X_DA NULL
#define OPTION_VAL_8X_DA NULL
#define OPTION_VAL_16X_DA NULL
#define BEETLE_OPT_DEPTH_LABEL_DA NULL
#define BEETLE_OPT_DEPTH_INFO_0_DA NULL
#define OPTION_VAL_16BPP_NATIVE_DA NULL
#define OPTION_VAL_32BPP_DA NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_DA NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_DA NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_DA NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_DA NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_DA NULL
#define BEETLE_OPT_FILTER_LABEL_DA NULL
#define BEETLE_OPT_FILTER_INFO_0_DA NULL
#define OPTION_VAL_NEAREST_DA NULL
#define OPTION_VAL_SABR_DA NULL
#define OPTION_VAL_XBR_DA NULL
#define OPTION_VAL_BILINEAR_DA NULL
#define OPTION_VAL_3_POINT_DA NULL
#define OPTION_VAL_JINC2_DA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_DA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_DA NULL
#define OPTION_VAL_OPAQUE_DA NULL
#define OPTION_VAL_ALL_DA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_DA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_DA NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_DA NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_DA NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_DA NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_DA NULL
#define BEETLE_OPT_MSAA_LABEL_DA NULL
#define BEETLE_OPT_MSAA_INFO_0_DA NULL
#define OPTION_VAL_1X_DA NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_DA NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_DA NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_DA NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_DA NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_DA NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_DA NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_DA NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_DA NULL
#define BEETLE_OPT_WIREFRAME_LABEL_DA NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_DA NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_DA NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_DA NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_DA NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_DA NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_DA NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_DA NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_DA NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_DA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_DA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_DA NULL
#define OPTION_VAL_ENABLED_ANALOG_DA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_DA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_DA NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_DA NULL
#define OPTION_VAL_L1_R1_SELECT_DA NULL
#define OPTION_VAL_L1_R1_START_DA NULL
#define OPTION_VAL_L1_R1_L3_DA NULL
#define OPTION_VAL_L1_R1_R3_DA NULL
#define OPTION_VAL_L2_R2_SELECT_DA NULL
#define OPTION_VAL_L2_R2_START_DA NULL
#define OPTION_VAL_L2_R2_L3_DA NULL
#define OPTION_VAL_L2_R2_R3_DA NULL
#define OPTION_VAL_L3_R3_DA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_DA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_DA NULL
#define OPTION_VAL_0_DA NULL
#define OPTION_VAL_1_DA NULL
#define OPTION_VAL_2_DA NULL
#define OPTION_VAL_3_DA NULL
#define OPTION_VAL_4_DA NULL
#define OPTION_VAL_5_DA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_DA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_DA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_DA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_DA NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_DA NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_DA NULL
#define OPTION_VAL_LIGHTGUN_DA NULL
#define OPTION_VAL_TOUCHSCREEN_DA NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_DA NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_DA NULL
#define OPTION_VAL_CROSS_DA NULL
#define OPTION_VAL_DOT_DA NULL
#define OPTION_VAL_OFF_DA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_DA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_DA NULL
#define OPTION_VAL_RED_DA NULL
#define OPTION_VAL_BLUE_DA NULL
#define OPTION_VAL_GREEN_DA NULL
#define OPTION_VAL_ORANGE_DA NULL
#define OPTION_VAL_YELLOW_DA NULL
#define OPTION_VAL_CYAN_DA NULL
#define OPTION_VAL_PINK_DA NULL
#define OPTION_VAL_PURPLE_DA NULL
#define OPTION_VAL_BLACK_DA NULL
#define OPTION_VAL_WHITE_DA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_DA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_DA NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_DA NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_DA NULL
#define OPTION_VAL_5_O28_DA NULL
#define OPTION_VAL_10_DA NULL
#define OPTION_VAL_15_DA NULL
#define OPTION_VAL_20_DA NULL
#define OPTION_VAL_25_DA NULL
#define OPTION_VAL_30_DA NULL
#define OPTION_VAL_35_DA NULL
#define OPTION_VAL_40_DA NULL
#define OPTION_VAL_45_DA NULL
#define OPTION_VAL_50_DA NULL
#define OPTION_VAL_55_DA NULL
#define OPTION_VAL_60_DA NULL
#define OPTION_VAL_65_DA NULL
#define OPTION_VAL_70_DA NULL
#define OPTION_VAL_75_DA NULL
#define OPTION_VAL_80_DA NULL
#define OPTION_VAL_85_DA NULL
#define OPTION_VAL_90_DA NULL
#define OPTION_VAL_95_DA NULL
#define OPTION_VAL_100_DA NULL
#define OPTION_VAL_105_DA NULL
#define OPTION_VAL_110_DA NULL
#define OPTION_VAL_115_DA NULL
#define OPTION_VAL_120_DA NULL
#define OPTION_VAL_125_DA NULL
#define OPTION_VAL_130_DA NULL
#define OPTION_VAL_135_DA NULL
#define OPTION_VAL_140_DA NULL
#define OPTION_VAL_145_DA NULL
#define OPTION_VAL_150_DA NULL
#define OPTION_VAL_155_DA NULL
#define OPTION_VAL_160_DA NULL
#define OPTION_VAL_165_DA NULL
#define OPTION_VAL_170_DA NULL
#define OPTION_VAL_175_DA NULL
#define OPTION_VAL_180_DA NULL
#define OPTION_VAL_185_DA NULL
#define OPTION_VAL_190_DA NULL
#define OPTION_VAL_195_DA NULL
#define OPTION_VAL_200_DA NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_DA NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_DA NULL
#define OPTION_VAL_LINEAR_DA NULL
#define OPTION_VAL_QUADRATIC_DA NULL
#define OPTION_VAL_CUBIC_DA NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_DA NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_DA NULL
#define OPTION_VAL_0_O30_DA NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_DA NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_DA NULL
#define OPTION_VAL_LIBRETRO_DA NULL
#define OPTION_VAL_MEDNAFEN_DA NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_DA NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_DA NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_DA NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_DA NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_DA NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_DA NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_DA NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_DA NULL
#define OPTION_VAL_1_O35_DA NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_DA NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_DA NULL
#define OPTION_VAL_MEMORY_ONLY_DA NULL
#define OPTION_VAL_MEMORY_CPU_DA NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_DA NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_DA NULL
#define OPTION_VAL_0PX_DA NULL
#define OPTION_VAL_1PX_DA NULL
#define OPTION_VAL_2PX_DA NULL
#define OPTION_VAL_3PX_DA NULL
#define OPTION_VAL_4PX_DA NULL
#define OPTION_VAL_5PX_DA NULL
#define OPTION_VAL_6PX_DA NULL
#define OPTION_VAL_7PX_DA NULL
#define OPTION_VAL_8PX_DA NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_DA NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_DA NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_DA NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_DA NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_DA NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_DA NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_DA NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_DA NULL
#define OPTION_VAL_DEFAULT_DA NULL
#define OPTION_VAL_AGGRESSIVE_DA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_DA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_DA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_DA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_DA NULL
#define OPTION_VAL_16_9_DA NULL
#define OPTION_VAL_16_10_DA NULL
#define OPTION_VAL_18_9_DA NULL
#define OPTION_VAL_19_9_DA NULL
#define OPTION_VAL_20_9_DA NULL
#define OPTION_VAL_21_9_DA NULL
#define OPTION_VAL_32_9_DA NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_DA NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_DA NULL
#define OPTION_VAL_100_NATIVE_DA NULL
#define OPTION_VAL_210_DA NULL
#define OPTION_VAL_220_DA NULL
#define OPTION_VAL_230_DA NULL
#define OPTION_VAL_240_DA NULL
#define OPTION_VAL_250_DA NULL
#define OPTION_VAL_260_DA NULL
#define OPTION_VAL_270_DA NULL
#define OPTION_VAL_280_DA NULL
#define OPTION_VAL_290_DA NULL
#define OPTION_VAL_300_DA NULL
#define OPTION_VAL_310_DA NULL
#define OPTION_VAL_320_DA NULL
#define OPTION_VAL_330_DA NULL
#define OPTION_VAL_340_DA NULL
#define OPTION_VAL_350_DA NULL
#define OPTION_VAL_360_DA NULL
#define OPTION_VAL_370_DA NULL
#define OPTION_VAL_380_DA NULL
#define OPTION_VAL_390_DA NULL
#define OPTION_VAL_400_DA NULL
#define OPTION_VAL_410_DA NULL
#define OPTION_VAL_420_DA NULL
#define OPTION_VAL_430_DA NULL
#define OPTION_VAL_440_DA NULL
#define OPTION_VAL_450_DA NULL
#define OPTION_VAL_460_DA NULL
#define OPTION_VAL_470_DA NULL
#define OPTION_VAL_480_DA NULL
#define OPTION_VAL_490_DA NULL
#define OPTION_VAL_500_DA NULL
#define OPTION_VAL_510_DA NULL
#define OPTION_VAL_520_DA NULL
#define OPTION_VAL_530_DA NULL
#define OPTION_VAL_540_DA NULL
#define OPTION_VAL_550_DA NULL
#define OPTION_VAL_560_DA NULL
#define OPTION_VAL_570_DA NULL
#define OPTION_VAL_580_DA NULL
#define OPTION_VAL_590_DA NULL
#define OPTION_VAL_600_DA NULL
#define OPTION_VAL_610_DA NULL
#define OPTION_VAL_620_DA NULL
#define OPTION_VAL_630_DA NULL
#define OPTION_VAL_640_DA NULL
#define OPTION_VAL_650_DA NULL
#define OPTION_VAL_660_DA NULL
#define OPTION_VAL_670_DA NULL
#define OPTION_VAL_680_DA NULL
#define OPTION_VAL_690_DA NULL
#define OPTION_VAL_700_DA NULL
#define OPTION_VAL_710_DA NULL
#define OPTION_VAL_720_DA NULL
#define OPTION_VAL_730_DA NULL
#define OPTION_VAL_740_DA NULL
#define OPTION_VAL_750_DA NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_DA NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_DA NULL
#define OPTION_VAL_32X_DA NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_DA NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_DA NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_DA NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_DA NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_DA NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_DA NULL
#define OPTION_VAL_PSXONPSP_DA NULL
#define OPTION_VAL_PS1_ROM_DA NULL
#define BEETLE_OPT_RENDERER_LABEL_DA NULL
#define BEETLE_OPT_RENDERER_INFO_0_DA NULL
#define OPTION_VAL_HARDWARE_DA NULL
#define OPTION_VAL_HARDWARE_GL_DA NULL
#define OPTION_VAL_HARDWARE_VK_DA NULL
#define OPTION_VAL_SOFTWARE_DA NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_DA NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_DA NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_DA NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_DA NULL
#define OPTION_VAL_DISABLED_DA NULL
#define OPTION_VAL_EXECUTE_DA NULL
#define OPTION_VAL_EXECUTE_ONE_DA NULL
#define OPTION_VAL_RUN_INTERPRETER_DA NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_DA NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_DA NULL
#define OPTION_VAL_FULL_DA NULL
#define OPTION_VAL_DMA_DA NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_DA NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_DA NULL
#define OPTION_VAL_128_DA NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_DA NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_DA NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_DA NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_DA NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_DA NULL
#define OPTION_VAL_FORCE_INTERLACED_DA NULL
#define OPTION_VAL_AUTO_TOGGLE_DA NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_DA NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_DA NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_DA NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_DA NULL
#define OPTION_VAL_CORRECTED_DA NULL
#define OPTION_VAL_UNCORRECTED_DA NULL
#define OPTION_VAL_4_3_DA NULL
#define OPTION_VAL_NTSC_DA NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_DA NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_DA NULL
#define OPTION_VAL_DISABLED_O58_DA NULL
#define OPTION_VAL_STATIC_DA NULL
#define OPTION_VAL_SMART_DA NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_DA NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_DA NULL
#define OPTION_VAL_9PX_DA NULL
#define OPTION_VAL_10PX_DA NULL
#define OPTION_VAL_11PX_DA NULL
#define OPTION_VAL_12PX_DA NULL
#define OPTION_VAL_13PX_DA NULL
#define OPTION_VAL_14PX_DA NULL
#define OPTION_VAL_15PX_DA NULL
#define OPTION_VAL_16PX_DA NULL
#define OPTION_VAL_17PX_DA NULL
#define OPTION_VAL_18PX_DA NULL
#define OPTION_VAL_19PX_DA NULL
#define OPTION_VAL_20PX_DA NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_DA NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_DA NULL
#define OPTION_VAL_12PX_O60_DA NULL
#define OPTION_VAL_11PX_O60_DA NULL
#define OPTION_VAL_10PX_O60_DA NULL
#define OPTION_VAL_9PX_O60_DA NULL
#define OPTION_VAL_8PX_O60_DA NULL
#define OPTION_VAL_7PX_O60_DA NULL
#define OPTION_VAL_6PX_O60_DA NULL
#define OPTION_VAL_5PX_O60_DA NULL
#define OPTION_VAL_4PX_O60_DA NULL
#define OPTION_VAL_3PX_O60_DA NULL
#define OPTION_VAL_2PX_O60_DA NULL
#define OPTION_VAL_1PX_O60_DA NULL
#define OPTION_VAL_1PX_O60_0_DA NULL
#define OPTION_VAL_2PX_O60_0_DA NULL
#define OPTION_VAL_3PX_O60_0_DA NULL
#define OPTION_VAL_4PX_O60_0_DA NULL
#define OPTION_VAL_5PX_O60_0_DA NULL
#define OPTION_VAL_6PX_O60_0_DA NULL
#define OPTION_VAL_7PX_O60_0_DA NULL
#define OPTION_VAL_8PX_O60_0_DA NULL
#define OPTION_VAL_9PX_O60_0_DA NULL
#define OPTION_VAL_10PX_O60_0_DA NULL
#define OPTION_VAL_11PX_O60_0_DA NULL
#define OPTION_VAL_12PX_O60_0_DA NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_DA NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_DA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_DA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_DA NULL
#define OPTION_VAL_0_O62_DA NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_DA NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_DA NULL
#define OPTION_VAL_239_DA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_DA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_DA NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_DA NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_DA NULL
#define OPTION_VAL_287_DA NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_DA NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_DA NULL
#define OPTION_VAL_SYNC_DA NULL
#define OPTION_VAL_ASYNC_DA NULL
#define OPTION_VAL_PRECACHE_DA NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_DA NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_DA NULL
#define OPTION_VAL_2X_NATIVE_DA NULL
#define OPTION_VAL_6X_DA NULL
#define OPTION_VAL_10X_DA NULL
#define OPTION_VAL_12X_DA NULL
#define OPTION_VAL_14X_DA NULL

struct retro_core_option_v2_category option_cats_da[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_DA,
      CATEGORY_VIDEO_INFO_0_DA
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_DA,
      CATEGORY_OSD_INFO_0_DA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DA,
      CATEGORY_INPUT_INFO_0_DA
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_DA,
      CATEGORY_MEMCARDS_INFO_0_DA
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_DA,
      CATEGORY_PGXP_INFO_0_DA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DA,
      CATEGORY_HACKS_INFO_0_DA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_da[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_DA,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_DA,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_DA },
         { "2x",         OPTION_VAL_2X_DA },
         { "4x",         OPTION_VAL_4X_DA },
         { "8x",         OPTION_VAL_8X_DA },
         { "16x",        OPTION_VAL_16X_DA },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_DA,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_DA,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_DA },
         { "32bpp",         OPTION_VAL_32BPP_DA },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_DA,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_DA,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_DA },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_DA },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_DA,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_DA,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_DA,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_DA,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_DA },
         { "SABR",     OPTION_VAL_SABR_DA },
         { "xBR",      OPTION_VAL_XBR_DA },
         { "bilinear", OPTION_VAL_BILINEAR_DA },
         { "3-point",  OPTION_VAL_3_POINT_DA },
         { "JINC2",    OPTION_VAL_JINC2_DA },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_DA,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_DA },
         { "all", OPTION_VAL_ALL_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_DA,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_DA },
         { "all", OPTION_VAL_ALL_DA },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_DA,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_DA,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_DA,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_DA,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_DA },
         { "2x",  OPTION_VAL_2X_DA },
         { "4x",  OPTION_VAL_4X_DA },
         { "8x",  OPTION_VAL_8X_DA },
         { "16x", OPTION_VAL_16X_DA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_DA,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_DA,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_DA,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_DA,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_DA,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_DA,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_DA,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_DA,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_DA,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_DA,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_DA,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_DA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_DA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_DA,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_DA },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_DA },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_DA },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_DA },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_DA },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_DA },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_DA },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_DA },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_DA },
         { "l3+r3",                    OPTION_VAL_L3_R3_DA },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_DA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_DA,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_DA },
         { "1", OPTION_VAL_1_DA },
         { "2", OPTION_VAL_2_DA },
         { "3", OPTION_VAL_3_DA },
         { "4", OPTION_VAL_4_DA },
         { "5", OPTION_VAL_5_DA },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_DA,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_DA,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_DA,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_DA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_DA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_DA },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_DA,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_DA,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_DA },
         { "dot",   OPTION_VAL_DOT_DA },
         { "off",   OPTION_VAL_OFF_DA },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_DA,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_DA,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_DA },
         { "blue", OPTION_VAL_BLUE_DA },
         { "green", OPTION_VAL_GREEN_DA },
         { "orange", OPTION_VAL_ORANGE_DA },
         { "yellow", OPTION_VAL_YELLOW_DA },
         { "cyan", OPTION_VAL_CYAN_DA },
         { "pink", OPTION_VAL_PINK_DA },
         { "purple", OPTION_VAL_PURPLE_DA },
         { "black", OPTION_VAL_BLACK_DA },
         { "white", OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_DA,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_DA,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_DA },
         { "red", OPTION_VAL_RED_DA },
         { "green", OPTION_VAL_GREEN_DA },
         { "orange", OPTION_VAL_ORANGE_DA },
         { "yellow", OPTION_VAL_YELLOW_DA },
         { "cyan", OPTION_VAL_CYAN_DA },
         { "pink", OPTION_VAL_PINK_DA },
         { "purple", OPTION_VAL_PURPLE_DA },
         { "black", OPTION_VAL_BLACK_DA },
         { "white", OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_DA,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_DA,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_DA },
         { "10%",  OPTION_VAL_10_DA },
         { "15%",  OPTION_VAL_15_DA },
         { "20%",  OPTION_VAL_20_DA },
         { "25%",  OPTION_VAL_25_DA },
         { "30%",  OPTION_VAL_30_DA },
         { "35%",  OPTION_VAL_35_DA },
         { "40%",  OPTION_VAL_40_DA },
         { "45%",  OPTION_VAL_45_DA },
         { "50%",  OPTION_VAL_50_DA },
         { "55%",  OPTION_VAL_55_DA },
         { "60%",  OPTION_VAL_60_DA },
         { "65%",  OPTION_VAL_65_DA },
         { "70%",  OPTION_VAL_70_DA },
         { "75%",  OPTION_VAL_75_DA },
         { "80%",  OPTION_VAL_80_DA },
         { "85%",  OPTION_VAL_85_DA },
         { "90%",  OPTION_VAL_90_DA },
         { "95%",  OPTION_VAL_95_DA },
         { "100%", OPTION_VAL_100_DA },
         { "105%", OPTION_VAL_105_DA },
         { "110%", OPTION_VAL_110_DA },
         { "115%", OPTION_VAL_115_DA },
         { "120%", OPTION_VAL_120_DA },
         { "125%", OPTION_VAL_125_DA },
         { "130%", OPTION_VAL_130_DA },
         { "135%", OPTION_VAL_135_DA },
         { "140%", OPTION_VAL_140_DA },
         { "145%", OPTION_VAL_145_DA },
         { "150%", OPTION_VAL_150_DA },
         { "155%", OPTION_VAL_155_DA },
         { "160%", OPTION_VAL_160_DA },
         { "165%", OPTION_VAL_165_DA },
         { "170%", OPTION_VAL_170_DA },
         { "175%", OPTION_VAL_175_DA },
         { "180%", OPTION_VAL_180_DA },
         { "185%", OPTION_VAL_185_DA },
         { "190%", OPTION_VAL_190_DA },
         { "195%", OPTION_VAL_195_DA },
         { "200%", OPTION_VAL_200_DA },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_DA,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_DA,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_DA },
         { "quadratic", OPTION_VAL_QUADRATIC_DA },
         { "cubic",     OPTION_VAL_CUBIC_DA },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_DA,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_DA,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_DA },
         { "5%",  OPTION_VAL_5_O28_DA },
         { "10%", OPTION_VAL_10_DA },
         { "15%", OPTION_VAL_15_DA },
         { "20%", OPTION_VAL_20_DA },
         { "25%", OPTION_VAL_25_DA },
         { "30%", OPTION_VAL_30_DA },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_DA,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_DA,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_DA },
         { "mednafen", OPTION_VAL_MEDNAFEN_DA },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_DA,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_DA,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_DA,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_DA,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_DA,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_DA,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_DA,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_DA,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_DA },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_DA,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_DA,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_DA },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_DA,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_DA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_DA },
         { "1px", OPTION_VAL_1PX_DA },
         { "2px", OPTION_VAL_2PX_DA },
         { "3px", OPTION_VAL_3PX_DA },
         { "4px", OPTION_VAL_4PX_DA },
         { "5px", OPTION_VAL_5PX_DA },
         { "6px", OPTION_VAL_6PX_DA },
         { "7px", OPTION_VAL_7PX_DA },
         { "8px", OPTION_VAL_8PX_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_DA,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_DA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_DA,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_DA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_DA,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_DA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_DA,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_DA },
         { "aggressive", OPTION_VAL_AGGRESSIVE_DA },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_DA,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_DA,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_DA },
         { "16:10", OPTION_VAL_16_10_DA },
         { "18:9",  OPTION_VAL_18_9_DA },
         { "19:9",  OPTION_VAL_19_9_DA },
         { "20:9",  OPTION_VAL_20_9_DA },
         { "21:9",  OPTION_VAL_21_9_DA }, // 64:27
         { "32:9",  OPTION_VAL_32_9_DA },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_DA,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_DA },
         { "60%",           OPTION_VAL_60_DA },
         { "70%",           OPTION_VAL_70_DA },
         { "80%",           OPTION_VAL_80_DA },
         { "90%",           OPTION_VAL_90_DA },
         { "100%(native)", OPTION_VAL_100_NATIVE_DA },
         { "110%",          OPTION_VAL_110_DA },
         { "120%",          OPTION_VAL_120_DA },
         { "130%",          OPTION_VAL_130_DA },
         { "140%",          OPTION_VAL_140_DA },
         { "150%",          OPTION_VAL_150_DA },
         { "160%",          OPTION_VAL_160_DA },
         { "170%",          OPTION_VAL_170_DA },
         { "180%",          OPTION_VAL_180_DA },
         { "190%",          OPTION_VAL_190_DA },
         { "200%",          OPTION_VAL_200_DA },
         { "210%",          OPTION_VAL_210_DA },
         { "220%",          OPTION_VAL_220_DA },
         { "230%",          OPTION_VAL_230_DA },
         { "240%",          OPTION_VAL_240_DA },
         { "250%",          OPTION_VAL_250_DA },
         { "260%",          OPTION_VAL_260_DA },
         { "270%",          OPTION_VAL_270_DA },
         { "280%",          OPTION_VAL_280_DA },
         { "290%",          OPTION_VAL_290_DA },
         { "300%",          OPTION_VAL_300_DA },
         { "310%",          OPTION_VAL_310_DA },
         { "320%",          OPTION_VAL_320_DA },
         { "330%",          OPTION_VAL_330_DA },
         { "340%",          OPTION_VAL_340_DA },
         { "350%",          OPTION_VAL_350_DA },
         { "360%",          OPTION_VAL_360_DA },
         { "370%",          OPTION_VAL_370_DA },
         { "380%",          OPTION_VAL_380_DA },
         { "390%",          OPTION_VAL_390_DA },
         { "400%",          OPTION_VAL_400_DA },
         { "410%",          OPTION_VAL_410_DA },
         { "420%",          OPTION_VAL_420_DA },
         { "430%",          OPTION_VAL_430_DA },
         { "440%",          OPTION_VAL_440_DA },
         { "450%",          OPTION_VAL_450_DA },
         { "460%",          OPTION_VAL_460_DA },
         { "470%",          OPTION_VAL_470_DA },
         { "480%",          OPTION_VAL_480_DA },
         { "490%",          OPTION_VAL_490_DA },
         { "500%",          OPTION_VAL_500_DA },
         { "510%",          OPTION_VAL_510_DA },
         { "520%",          OPTION_VAL_520_DA },
         { "530%",          OPTION_VAL_530_DA },
         { "540%",          OPTION_VAL_540_DA },
         { "550%",          OPTION_VAL_550_DA },
         { "560%",          OPTION_VAL_560_DA },
         { "570%",          OPTION_VAL_570_DA },
         { "580%",          OPTION_VAL_580_DA },
         { "590%",          OPTION_VAL_590_DA },
         { "600%",          OPTION_VAL_600_DA },
         { "610%",          OPTION_VAL_610_DA },
         { "620%",          OPTION_VAL_620_DA },
         { "630%",          OPTION_VAL_630_DA },
         { "640%",          OPTION_VAL_640_DA },
         { "650%",          OPTION_VAL_650_DA },
         { "660%",          OPTION_VAL_660_DA },
         { "670%",          OPTION_VAL_670_DA },
         { "680%",          OPTION_VAL_680_DA },
         { "690%",          OPTION_VAL_690_DA },
         { "700%",          OPTION_VAL_700_DA },
         { "710%",          OPTION_VAL_710_DA },
         { "720%",          OPTION_VAL_720_DA },
         { "730%",          OPTION_VAL_730_DA },
         { "740%",          OPTION_VAL_740_DA },
         { "750%",          OPTION_VAL_750_DA },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_DA,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_DA },
         { "2x",         OPTION_VAL_2X_DA },
         { "4x",         OPTION_VAL_4X_DA },
         { "8x",         OPTION_VAL_8X_DA },
         { "16x",        OPTION_VAL_16X_DA },
         { "32x",        OPTION_VAL_32X_DA },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_DA,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_DA,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_DA,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_DA },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_DA },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_DA,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_DA,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_DA },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_DA },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_DA },
#endif
         { "software",    OPTION_VAL_SOFTWARE_DA },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_DA,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_DA,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_DA,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_DA,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_DA },
         { "execute",  OPTION_VAL_EXECUTE_DA },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_DA },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_DA,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_DA,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_DA },
         { "dma",  OPTION_VAL_DMA_DA },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_DA,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_DA },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_DA,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_DA },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_DA,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_DA,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_DA },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_DA },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_DA },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_DA,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_DA,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_DA,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_DA },
         { "uncorrected", OPTION_VAL_UNCORRECTED_DA },
         { "4:3",  OPTION_VAL_4_3_DA },
         { "ntsc", OPTION_VAL_NTSC_DA },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_DA,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_DA },
         { "static",  OPTION_VAL_STATIC_DA },
         { "smart", OPTION_VAL_SMART_DA },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_DA,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_DA },
         { "2px",      OPTION_VAL_2PX_DA },
         { "3px",      OPTION_VAL_3PX_DA },
         { "4px",      OPTION_VAL_4PX_DA },
         { "5px",      OPTION_VAL_5PX_DA },
         { "6px",      OPTION_VAL_6PX_DA },
         { "7px",      OPTION_VAL_7PX_DA },
         { "8px",      OPTION_VAL_8PX_DA },
         { "9px",      OPTION_VAL_9PX_DA },
         { "10px",     OPTION_VAL_10PX_DA },
         { "11px",     OPTION_VAL_11PX_DA },
         { "12px",     OPTION_VAL_12PX_DA },
         { "13px",     OPTION_VAL_13PX_DA },
         { "14px",     OPTION_VAL_14PX_DA },
         { "15px",     OPTION_VAL_15PX_DA },
         { "16px",     OPTION_VAL_16PX_DA },
         { "17px",     OPTION_VAL_17PX_DA },
         { "18px",     OPTION_VAL_18PX_DA },
         { "19px",     OPTION_VAL_19PX_DA },
         { "20px",     OPTION_VAL_20PX_DA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_DA,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_DA,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_DA },
         { "-11px",    OPTION_VAL_11PX_O60_DA },
         { "-10px",    OPTION_VAL_10PX_O60_DA },
         { "-9px",     OPTION_VAL_9PX_O60_DA },
         { "-8px",     OPTION_VAL_8PX_O60_DA },
         { "-7px",     OPTION_VAL_7PX_O60_DA },
         { "-6px",     OPTION_VAL_6PX_O60_DA },
         { "-5px",     OPTION_VAL_5PX_O60_DA },
         { "-4px",     OPTION_VAL_4PX_O60_DA },
         { "-3px",     OPTION_VAL_3PX_O60_DA },
         { "-2px",     OPTION_VAL_2PX_O60_DA },
         { "-1px",     OPTION_VAL_1PX_O60_DA },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_DA },
         { "+2px",     OPTION_VAL_2PX_O60_0_DA },
         { "+3px",     OPTION_VAL_3PX_O60_0_DA },
         { "+4px",     OPTION_VAL_4PX_O60_0_DA },
         { "+5px",     OPTION_VAL_5PX_O60_0_DA },
         { "+6px",     OPTION_VAL_6PX_O60_0_DA },
         { "+7px",     OPTION_VAL_7PX_O60_0_DA },
         { "+8px",     OPTION_VAL_8PX_O60_0_DA },
         { "+9px",     OPTION_VAL_9PX_O60_0_DA },
         { "+10px",    OPTION_VAL_10PX_O60_0_DA },
         { "+11px",    OPTION_VAL_11PX_O60_0_DA },
         { "+12px",    OPTION_VAL_12PX_O60_0_DA },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_DA,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_DA,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_DA,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_DA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_DA },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_DA,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_DA,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_DA },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_DA,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_DA,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_DA },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_DA,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_DA,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_DA },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_DA,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_DA,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_DA },
         { "async",    OPTION_VAL_ASYNC_DA },
         { "precache", OPTION_VAL_PRECACHE_DA },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_DA,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_DA,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_DA },
         { "4x",          OPTION_VAL_4X_DA },
         { "6x",          OPTION_VAL_6X_DA },
         { "8x",          OPTION_VAL_8X_DA },
         { "10x",         OPTION_VAL_10X_DA },
         { "12x",         OPTION_VAL_12X_DA },
         { "14x",         OPTION_VAL_14X_DA },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_da = {
   option_cats_da,
   option_defs_da
};

/* RETRO_LANGUAGE_DE */

#define CATEGORY_VIDEO_LABEL_DE NULL
#define CATEGORY_VIDEO_INFO_0_DE "Einstellungen für Seitenverhältnis, Bildausschnitt, Videofilter und Frameskipping ändern."
#define CATEGORY_OSD_LABEL_DE "Bildschirmanzeige"
#define CATEGORY_OSD_INFO_0_DE "Bildschirm-Benachrichtigungen ändern."
#define CATEGORY_INPUT_LABEL_DE "Eingabe"
#define CATEGORY_INPUT_INFO_0_DE "Einstellungen für Lightgun, Maus und neGcon ändern."
#define CATEGORY_MEMCARDS_LABEL_DE NULL
#define CATEGORY_MEMCARDS_INFO_0_DE "Einstellungen bezüglich der virtuellen Memory Card(s) des Systems ändern."
#define CATEGORY_PGXP_LABEL_DE NULL
#define CATEGORY_PGXP_INFO_0_DE "Diese Optionen steuern Erweiterungen, die die Grafik im Vergleich zur Originalkonsole verbessern können. PGXP kann verzerrte Texturen und Z-Fighting-Probleme beseitigen."
#define CATEGORY_HACKS_LABEL_DE "Emulations-Hacks"
#define CATEGORY_HACKS_INFO_0_DE "Parameter für Prozessorübertaktung und Emulationsgenauigkeit, die sich auf die Low-Level-Leistung und Kompatibilität auswirken, ändern."
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_DE "Interne GPU-Auflösung"
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_DE "Internen Auflösungsmultiplikator wählen. Auflösungen höher als \"1× (Nativ)\" verbessern die Wiedergabetreue von 3D-Modellen auf Kosten von höheren Leistungsanforderungen. 2D-Elemente sind von dieser Einstellung in der Regel nicht betroffen."
#define OPTION_VAL_1X_NATIVE_DE "1x (Nativ)"
#define OPTION_VAL_2X_DE NULL
#define OPTION_VAL_4X_DE NULL
#define OPTION_VAL_8X_DE NULL
#define OPTION_VAL_16X_DE NULL
#define BEETLE_OPT_DEPTH_LABEL_DE "Interne Farbtiefe"
#define BEETLE_OPT_DEPTH_INFO_0_DE "Interne Farbtiefe auswählen. Eine höhere Farbtiefe kann Farbbandeffekte ohne die Verwendung von Dithering reduzieren. 16 bpp emuliert die Originalhardware, kann aber bei deaktiviertem Dithering sichtbare Streifenbildung verursachen. Bei 32 bpp wird empfohlen, „Dithering-Muster“ zu deaktivieren."
#define OPTION_VAL_16BPP_NATIVE_DE "16 bpp (Nativ)"
#define OPTION_VAL_32BPP_DE NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_DE "Dithering-Muster"
#define BEETLE_OPT_DITHER_MODE_INFO_0_DE "Konfiguration des Dithering-Musters wählen. „1x (Nativ)“ emuliert natives, niedrigaufgelöstes Dithering, wie es von der Originalhardware zum Glätten von Farbband-Artefakten bei nativer Farbtiefe verwendet wird. „Interne Auflösung“ skaliert die Dithering-Granularität auf die ausgewählte interne Auflösung für sauberere Ergebnisse. Bei 32 bpp Farbtiefe wird empfohlen, diese Option zu deaktivieren. Hinweis: Bei Vulkan erzwingt die Aktivierung dieser Option ein Downsampling auf die native Farbtiefe, während die Deaktivierung die Ausgabe mit einer höheren Farbtiefe automatisch aktiviert."
#define OPTION_VAL_INTERNAL_RESOLUTION_DE "Interne Auflösung"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_DE "Texturen-UV-Versatz"
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_DE "Texturen für 3D-Polygone bei höherer interner Auflösung mit einem Versatz abtasten. Verringert Texturnähte, kann aber unbeabsichtigte grafische Glitches verursachen."
#define BEETLE_OPT_FILTER_LABEL_DE "Texturfilterung"
#define BEETLE_OPT_FILTER_INFO_0_DE "Texturfiltermethode wählen. \"Nächste\" emuliert die ursprüngliche Hardware. \"Bilinear\" und \"3-Punkt\" sind Glättungsfilter, die die Pixelierung durch Unschärfe reduzieren. \"SABR\", \"xBR\" und \"JINC2\" sind Hochskalierungsfilter, die die Texturtreue/-schärfe auf Kosten erhöhter Leistungsanforderungen verbessern können. Sie werden nur von den Hardware-Renderern unterstützt."
#define OPTION_VAL_NEAREST_DE "Nächste"
#define OPTION_VAL_SABR_DE NULL
#define OPTION_VAL_XBR_DE NULL
#define OPTION_VAL_BILINEAR_DE NULL
#define OPTION_VAL_3_POINT_DE "3-Punkt"
#define OPTION_VAL_JINC2_DE NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_DE "Sprites von der Filterung ausschließen"
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_DE "Keine Texturfilterung auf Sprites anwenden. Verhindert Nahtstellen in verschiedenen Spielen mit 2D-Sprite-gerenderten Hintergründen. Zusammen mit \"Adaptive Glättung\" oder einem anderen Nachbearbeitungsfilter verwenden, um die beste Wirkung zu erzielen."
#define OPTION_VAL_OPAQUE_DE "Nur undurchsichtig"
#define OPTION_VAL_ALL_DE "Undurchsichtig und Halbtransparent"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_DE "2D-Polygone von der Filterung ausschließen"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_DE "Keine Texturfilterung auf 2D-Polygone anwenden. 2D-Polygone werden mit einer Heuristik erkannt und es kann zu Glitches kommen. Texturfilterung zusammen mit \"Adaptive Glättung\" oder einem anderen Nachbearbeitungsfilter verwenden, um eine optimale Wirkung zu erzielen."
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_DE "Adaptive Glättung"
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_DE "2D-Grafiken und UI-Elemente glätten, ohne 3D-Objekte zu verwischen. Wird nur vom Vulkan-Renderer unterstützt."
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_DE "Supersampling (Downsampling zur nativen Auflösung)"
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_DE "Heruntertakten gerenderter Inhalte von hochskalierter interner Auflösung bis hin zur nativen Auflösung. Die Kombination mit einer höheren internen Auflösung ermöglicht die Darstellung von Spielen mit geglätteten 3D-Objekten mit niedriger nativer Auflösung. Erzeugt beste Ergebnisse bei Titeln, die 2D- und 3D-Elemente mischen (z. 3D-Zeichen auf vorgerenderten Hintergründen) und funktioniert gut in Verbindung mit CRT-Shadern. Nur vom Vulkan Renderer unterstützt. Hinweis: 'Dithering-Muster' wird empfohlen, wenn diese Option aktiviert wird."
#define BEETLE_OPT_MSAA_LABEL_DE "Multisampled-Antialiasing"
#define BEETLE_OPT_MSAA_INFO_0_DE "MSAA-Stufe für gerenderte Inhalte wählen. Verbessert das Aussehen von 3D-Objekten. Wird nur vom Vulkan-Renderer unterstützt."
#define OPTION_VAL_1X_DE NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_DE "MDEC YUV Chromafilter"
#define BEETLE_OPT_MDEC_YUV_INFO_0_DE "Die Qualität der FMV-Wiedergabe durch Reduzierung von „Macroblocking“-Artefakten (Quadrate/gezackte Kanten) verbessern. Wird nur vom Vulkan-Renderer unterstützt."
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_DE "Texturenverfolgung"
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_DE "Voraussetzung für Dumping und Ersetzen von Texturen. Wird wahrscheinlich in den meisten Spielen abstürzen."
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_DE "Texturen dumpen"
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_DE "Verwendete Texturen nach <cd>-texture-dump/ ausgeben"
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_DE "Texturen ersetzen"
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_DE "Texturen durch HD-Versionen aus <cd>-texture-replacements/ ersetzen"
#define BEETLE_OPT_WIREFRAME_LABEL_DE "Wireframe-Modus (Debugging)"
#define BEETLE_OPT_WIREFRAME_INFO_0_DE "3D-Modelle in Umrissform ohne Texturen oder Schattierungen rendern. Wird nur vom OpenGL-Hardware-Renderer unterstützt. Hinweis: Diese Funktion ist für Debugging-Zwecke gedacht und sollte normalerweise deaktiviert werden."
#define BEETLE_OPT_FRAME_DUPING_LABEL_DE "Frameduping (Beschleunigung)"
#define BEETLE_OPT_FRAME_DUPING_INFO_0_DE "Wenn aktiviert und vom Libretro-Frontend unterstützt, sorgt dies für eine kleine Leistungssteigerung, indem das Frontend angewiesen wird, den vorherigen Frame zu wiederholen, wenn der Core nichts Neues anzuzeigen hat."
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_DE "Interne FPS anzeigen"
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_DE "Die interne Bildrate anzeigen, mit der das emulierte PlayStation-System Inhalte rendert. Hinweis: Benötigt, dass Bildschirm-Benachrichtigungen im Libretro-Frontend aktiviert sind."
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_DE "Vollständigen VRAM anzeigen (Debugging)"
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_DE "Den gesamten VRAM der emulierten Konsole visualisieren. Wird nur von den OpenGL- und Vulkan-Hardware-Renderern unterstützt. Hinweis: Diese Funktion ist für Debugging-Zwecke gedacht und sollte normalerweise deaktiviert werden."
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_DE "Analogeingaben-Selbstkalibrierung"
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_DE "Wenn das Eingabegerät auf DualShock, Analog-Controller, Analog-Joystick oder neGcon eingestellt ist, aktiviert diese Option die dynamische Kalibrierung der analogen Eingaben. Die maximalen registrierten Eingangswerte werden in Echtzeit überwacht und zur Skalierung der an den Emulator übergebenen analogen Koordinaten verwendet. Diese Option sollte für Spiele wie Mega Man Legends 2 verwendet werden, die größere Werte erwarten, als moderne Controller liefern. Um optimale Ergebnisse zu erzielen, sollten die Analogsticks jedes Mal, wenn Inhalte geladen werden, voll gedreht werden, um den Kalibrierungsalgorithmus einzustellen."
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_DE "DualShock-Analogmodusumschalter"
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_DE "Wenn der Typ des Eingabegeräts DualShock ist, kann mit dieser Option der emulierte DualShock wie die Originalhardware zwischen DIGITAL- und ANALOG-Modus umgeschaltet werden. Der Modus kann auch über die ausgewählte Tastenkombination umgeschaltet werden."
#define OPTION_VAL_ENABLED_ANALOG_DE "Standardanalog"
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_DE "DualShock Analogmodus-Combo"
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_DE "Bitte die Tastenkombination wählen, mit der zwischen DIGITAL- und ANALOG-Modus für den emulierten DualShock umgeschaltet werden soll."
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_DE NULL
#define OPTION_VAL_L1_R1_SELECT_DE NULL
#define OPTION_VAL_L1_R1_START_DE NULL
#define OPTION_VAL_L1_R1_L3_DE NULL
#define OPTION_VAL_L1_R1_R3_DE NULL
#define OPTION_VAL_L2_R2_SELECT_DE NULL
#define OPTION_VAL_L2_R2_START_DE NULL
#define OPTION_VAL_L2_R2_L3_DE NULL
#define OPTION_VAL_L2_R2_R3_DE NULL
#define OPTION_VAL_L3_R3_DE NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_DE "DualShock Analogmodus-Combo Halteverzögerung"
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_DE "Legt die Haltezeit für die Analogmodus-Kombinationstasten fest."
#define OPTION_VAL_0_DE "0 Sekunden Verzögerung"
#define OPTION_VAL_1_DE "1 Sekunde Verzögerung"
#define OPTION_VAL_2_DE "2 Sekunden Verzögerung"
#define OPTION_VAL_3_DE "3 Sekunden Verzögerung"
#define OPTION_VAL_4_DE "4 Sekunden Verzögerung"
#define OPTION_VAL_5_DE "5 Sekunden Verzögerung"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_DE "Port 1: Multitap aktivieren"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_DE "Multitap-Funktionalität auf Port 1 aktivieren."
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_DE "Port 2: Multitap aktivieren"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_DE "Multitap-Funktionalität auf Port 2 aktivieren."
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_DE "Waffeneingabemodus"
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_DE "Wählt, ob eine von der Maus gesteuerte 'Pistole' oder 'Touchscreen-Eingabe' verwendet werden soll, wenn der Gerätetyp auf 'Guncon/G-Con 45' oder 'Justifier' gesetzt ist."
#define OPTION_VAL_LIGHTGUN_DE "Lightgun"
#define OPTION_VAL_TOUCHSCREEN_DE NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_DE "Waffencursor"
#define BEETLE_OPT_GUN_CURSOR_INFO_0_DE "Das Fadenkreuz wählen, das auf dem Bildschirm angezeigt wird, wenn als Eingabegerät \"Guncon/G-Con 45\" oder \"Justifier\" verwendet wird. Wenn deaktiviert, bleibt das Fadenkreuz immer ausgeblendet."
#define OPTION_VAL_CROSS_DE "Kreuz"
#define OPTION_VAL_DOT_DE "Punkt"
#define OPTION_VAL_OFF_DE "Kein Cursor"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_DE "Port 1: Fadenkreuzfarbe"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_DE "Für Port 1 die Fadenkreuzfarbe der Lightgun wählen."
#define OPTION_VAL_RED_DE "Rot"
#define OPTION_VAL_BLUE_DE "Blau"
#define OPTION_VAL_GREEN_DE "Grün"
#define OPTION_VAL_ORANGE_DE NULL
#define OPTION_VAL_YELLOW_DE "Gelb"
#define OPTION_VAL_CYAN_DE NULL
#define OPTION_VAL_PINK_DE NULL
#define OPTION_VAL_PURPLE_DE "Lila"
#define OPTION_VAL_BLACK_DE "Schwarz"
#define OPTION_VAL_WHITE_DE "Weiß"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_DE "Port 2: Fadenkreuzfarbe"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_DE "Für Port 2 die Fadenkreuzfarbe der Lightgun wählen."
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_DE "Mausempfindlichkeit"
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_DE "Wählt die Empfindlichkeit des 'Maus' Eingabegerätetyps."
#define OPTION_VAL_5_O28_DE "5 %"
#define OPTION_VAL_10_DE "10 %"
#define OPTION_VAL_15_DE "15 %"
#define OPTION_VAL_20_DE "20 %"
#define OPTION_VAL_25_DE "25 %"
#define OPTION_VAL_30_DE "30 %"
#define OPTION_VAL_35_DE "35 %"
#define OPTION_VAL_40_DE "40 %"
#define OPTION_VAL_45_DE "45 %"
#define OPTION_VAL_50_DE "50 %"
#define OPTION_VAL_55_DE "55 %"
#define OPTION_VAL_60_DE "60 %"
#define OPTION_VAL_65_DE "65 %"
#define OPTION_VAL_70_DE "70 %"
#define OPTION_VAL_75_DE "75 %"
#define OPTION_VAL_80_DE "80 %"
#define OPTION_VAL_85_DE "85 %"
#define OPTION_VAL_90_DE "90 %"
#define OPTION_VAL_95_DE "95 %"
#define OPTION_VAL_100_DE "100 % (Standard)"
#define OPTION_VAL_105_DE "105 %"
#define OPTION_VAL_110_DE "110 %"
#define OPTION_VAL_115_DE "115 %"
#define OPTION_VAL_120_DE "120 %"
#define OPTION_VAL_125_DE "125 %"
#define OPTION_VAL_130_DE "130 %"
#define OPTION_VAL_135_DE "135 %"
#define OPTION_VAL_140_DE "140 %"
#define OPTION_VAL_145_DE "145 %"
#define OPTION_VAL_150_DE "150 %"
#define OPTION_VAL_155_DE "155 %"
#define OPTION_VAL_160_DE "160 %"
#define OPTION_VAL_165_DE "165 %"
#define OPTION_VAL_170_DE "170 %"
#define OPTION_VAL_175_DE "175 %"
#define OPTION_VAL_180_DE "180 %"
#define OPTION_VAL_185_DE "185 %"
#define OPTION_VAL_190_DE "190 %"
#define OPTION_VAL_195_DE "195 %"
#define OPTION_VAL_200_DE "200 %"
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_DE "neGcon verdrehen Rückmeldung"
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_DE "Wählen Sie den Rückmeldungstyp des analogen Sticks des RetroPads aus, wenn Sie die 'verdrehen' Aktion von emulierten 'neGcon' Eingabegeräten simulieren. Analogstick-Verschiebung kann entweder linear, quadratisch oder kubisch auf neGcon Rotationswinkel zugeordnet werden. 'Quadratisch' erlaubt eine höhere Präzision als 'Linear' bei kleinen Bewegungen. 'Kubisch' erhöht die kleine Bewegungsgenauigkeit, aber 'übertreibt' größere Bewegungen. Hinweis: 'Linear' wird nur empfohlen, wenn Sie Rennrad-Peripherie verwenden. Konventionelle Controller implementieren den Analogeingang in einer Weise, die sich grundlegend von dem neGcon 'verdrehen' Mechanismus unterscheidet, so dass die lineare Zuordnung kleine Bewegungen übersteigt, wodurch die Feinkontrolle beeinträchtigt wird. In den meisten Fällen bietet 'Quadratisch' die engste Annäherung der realen Hardware."
#define OPTION_VAL_LINEAR_DE NULL
#define OPTION_VAL_QUADRATIC_DE "Quadratisch"
#define OPTION_VAL_CUBIC_DE "Kubisch"
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_DE "neGcon verdrehen Totzone"
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_DE "Wählt die Totzone des linken analogen Sticks des RetroPads bei der Simulation der 'verdrehen' Aktion von emulierten 'neGcon' Eingabegeräten. Wird verwendet, um den Controller-Drift-Effekt zu beseitigen. Hinweis: Die meisten neGcon-kompatiblen Titel bieten in-game Optionen, um einen 'verdrehten' Totzone Wert zu setzen. Um einen Verlust der Genauigkeit zu vermeiden, sollte die Totzone im Spiel *immer* auf Null gesetzt werden. Alle erforderlichen Anpassungen sollten *nur* über diese Kernoption angewendet werden. Dies ist besonders wichtig, wenn 'neGcon verdehen Rückmeldung' auf 'Quadratisch' oder 'Kubisch' gesetzt wird."
#define OPTION_VAL_0_O30_DE "0 %"
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_DE "Methode Speicherkarte 0 (Neustart erforderlich)"
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_DE "Das Speicherformat für die Speicherkarte 0 auswählen. „Mednafen“ kann zur Kompatibilität mit der Stand-alone-Version von Mednafen verwendet werden. Bei Beetle PSX, Libretro (.srm) und Mednafen (.mcr) haben Speicherstände intern identische Formate und können über Umbenennen untereinander konvertiert werden."
#define OPTION_VAL_LIBRETRO_DE NULL
#define OPTION_VAL_MEDNAFEN_DE NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_DE "Speicherkarte 1 aktivieren (Neustart erforderlich)"
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_DE "Eine zweite Speicherkarte in Slot 1 emulieren. Wenn deaktiviert, können Spiele nur auf die Speicherkarte im Slot 0 zugreifen. Hinweis: Bei einigen Spielen muss diese Option für den korrekten Betrieb deaktiviert werden (z. B. Codename Tenka). Hinweis: Memory Card 1 verwendet das Mednafen (.mcr) Speicherformat."
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_DE "Gemeinsame Speicherkarten (Neustart erforderlich)"
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_DE "Wenn aktiviert, werden alle Spiele in dieselben Speicherkartendateien gespeichert und von diesen geladen. Wenn deaktiviert, werden separate Speicherkartendateien für jedes Element geladener Inhalte generiert. Hinweis: Wenn „Methode Speicherkarte 0“ auf „Libretro“ gesetzt wird, ist nur die rechte Speicherkarte betroffen."
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_DE "Index linker Speicherkarte"
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_DE "Die Speicherkarte wechseln, die derzeit im linken Steckplatz geladen wird. Diese Option funktioniert nur, wenn „Methode Speicherkarte 0“ auf „Mednafen“ gesetzt ist. Die Standardkarte ist Index 0."
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_DE "Index rechter Speicherkarte"
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_DE "Die Speicherkarte wechseln, die derzeit im rechten Steckplatz geladen wird. Diese Option funktioniert nur, wenn Speicherkarte 1 aktiviert ist. Die Standardkarte ist Index 1."
#define OPTION_VAL_1_O35_DE "1 (Standard)"
#define BEETLE_OPT_PGXP_MODE_LABEL_DE "PGXP-Betriebsart"
#define BEETLE_OPT_PGXP_MODE_INFO_0_DE "Ermöglicht die Darstellung von 3D-Objekten mit Unterpixelgenauigkeit, minimiert Verzerrung und Ruckler von 3D-Objekten, die auf Originalhardware durch die Verwendung von fixen Punktvertex Koordinaten gesehen werden. Der Modus 'Nur Speicher' hat minimale Kompatibilitätsprobleme und wird für den allgemeinen Gebrauch empfohlen. 'Speicher und CPU (fehlerbehaftet)' Modus kann Ruckler noch weiter reduzieren, hat aber hohe Leistungsanforderungen und kann zu verschiedenen Geometriefehlern führen."
#define OPTION_VAL_MEMORY_ONLY_DE "Nur Speicher"
#define OPTION_VAL_MEMORY_CPU_DE "Speicher und CPU (fehlerbehaftet)"
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_DE "PGXP 2D-Geometrietoleranz"
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_DE "Versteckt weitere eklatante Fehler in PGXP-Operationen: Der Wert legt fest, in welcher Toleranz PGXP-Werte im Falle von Geometrien ohne korrekte Tiefeninformationen beibehalten werden."
#define OPTION_VAL_0PX_DE "0 px"
#define OPTION_VAL_1PX_DE "1 px"
#define OPTION_VAL_2PX_DE "2 px"
#define OPTION_VAL_3PX_DE "3 px"
#define OPTION_VAL_4PX_DE "4 px"
#define OPTION_VAL_5PX_DE "5 px"
#define OPTION_VAL_6PX_DE "6 px"
#define OPTION_VAL_7PX_DE "7 px"
#define OPTION_VAL_8PX_DE "8 px"
#define BEETLE_OPT_PGXP_NCLIP_LABEL_DE "PGXP Primitive Keulung"
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_DE "PGXP-NCLIP-Implementierung verwenden. Verbessert die Darstellung durch Reduzierung von Lücken in Geometrien mit PGXP-Koordinaten. Kann dazu führen, dass sich einige Spiele unter Umständen aufhängen."
#define BEETLE_OPT_PGXP_VERTEX_LABEL_DE "PGXP-Vertex-Cache"
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_DE "Cache-PGXP-erweiterte Vertex-Positionen zur Wiederverwendung über Polygon-Zeichnungen hinweg. Kann möglicherweise die Objektorientierung verbessern und die sichtbaren Nähte beim Rendern von Texturen reduzieren, aber falsche Positiven, wenn der Cache abfragt wird, können zu grafischen Fehlern führen. Es wird derzeit empfohlen, diese Option deaktiviert zu lassen. Diese Option wird nur angewendet, wenn der PGXP-Operationsmodus aktiviert ist. Unterstützt nur von Hardware-Renderern."
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_DE "PGXP-Perspektivische Texturkorrektur"
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_DE "Ersetzt die native PSX affine Texturzuordnung durch eine perspektivisch korrekte Texturzuordnung. Eliminiert positionabhängige Verzerrung und Verformung von Texturen, was zu richtig ausgerichteten Texturen führt. Diese Option wird nur angewendet, wenn der PGXP-Operationsmodus aktiviert ist. Unterstützt nur von Hardware-Rendern."
#define BEETLE_OPT_LINE_RENDER_LABEL_DE "Zeile zu Quadrat Hack"
#define BEETLE_OPT_LINE_RENDER_INFO_0_DE "Wählt die Zeile-zu-Quadrat-Hack-Methode. Einige Spiele (z.B. Doom, Hexen, Soul Blade, etc.) zeichnen horizontale Linien, indem Sie 1-Pixel hohe Dreiecke über den Bildschirm strecken, die als Reihe von Pixeln auf Originalhardware gerastert werden. Dieser Hack erkennt diese kleinen Dreiecke und wandelt sie nach Bedarf in Quadrate um, so dass sie korrekt auf den Hardware-Renderern und in hochskalierten internen Auflösungen angezeigt werden können. 'Aggressiv' ist für einige Titel erforderlich (z.B. Dark Forces, Duke Nukem), kann aber anderweitig grafische Fehler verursachen. Falls unsicher auf 'Standard' lassen."
#define OPTION_VAL_DEFAULT_DE "Standard"
#define OPTION_VAL_AGGRESSIVE_DE "Aggressiv"
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_DE "Breitbildmodus-Hack"
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_DE "3D-Inhalte anamorph ausgeben und den emulierten Bildspeicher in einem Breitbild-Seitenverhältnis ausgeben. Erstellt beste Ergebnisse mit vollwertigen 3D-Spielen. 2D-Elemente werden horizontal gestreckt und können falsch ausgerichtet werden."
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_DE "Seitenverhältnis für Breitbildmodus-Hack"
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_DE "Wählt das Seitenverhältnis für den Breitbildmodus-Hack aus."
#define OPTION_VAL_16_9_DE NULL
#define OPTION_VAL_16_10_DE NULL
#define OPTION_VAL_18_9_DE NULL
#define OPTION_VAL_19_9_DE NULL
#define OPTION_VAL_20_9_DE NULL
#define OPTION_VAL_21_9_DE NULL
#define OPTION_VAL_32_9_DE NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_DE "CPU-Frequenzskalierung (Übertaktung)"
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_DE "Emulierte PSX-CPU übertakten (oder untertakten). Durch die Übertaktung können Slowdowns beseitigt und die Bildrate in bestimmten Spielen verbessert werden, allerdings auf Kosten von höheren Leistungsansprüchen. Zu beachten ist, dass einige Spiele eine interne Bildratenbegrenzung haben und möglicherweise nicht von einer Übertaktung profitieren. Bei einigen Spielen kann die Übertaktung dazu führen, dass bestimmte Effekte schneller als vorgesehen animiert werden."
#define OPTION_VAL_100_NATIVE_DE "100 % (Nativ)"
#define OPTION_VAL_210_DE "210 %"
#define OPTION_VAL_220_DE "220 %"
#define OPTION_VAL_230_DE "230 %"
#define OPTION_VAL_240_DE "240 %"
#define OPTION_VAL_250_DE "250 %"
#define OPTION_VAL_260_DE "260 %"
#define OPTION_VAL_270_DE "270 %"
#define OPTION_VAL_280_DE "280 %"
#define OPTION_VAL_290_DE "290 %"
#define OPTION_VAL_300_DE "300 %"
#define OPTION_VAL_310_DE "310 %"
#define OPTION_VAL_320_DE "320 %"
#define OPTION_VAL_330_DE "330 %"
#define OPTION_VAL_340_DE "340 %"
#define OPTION_VAL_350_DE "350 %"
#define OPTION_VAL_360_DE "360 %"
#define OPTION_VAL_370_DE "370 %"
#define OPTION_VAL_380_DE "380 %"
#define OPTION_VAL_390_DE "390 %"
#define OPTION_VAL_400_DE "400 %"
#define OPTION_VAL_410_DE "410 %"
#define OPTION_VAL_420_DE "420 %"
#define OPTION_VAL_430_DE "430 %"
#define OPTION_VAL_440_DE "440 %"
#define OPTION_VAL_450_DE "450 %"
#define OPTION_VAL_460_DE "460 %"
#define OPTION_VAL_470_DE "470 %"
#define OPTION_VAL_480_DE "480 %"
#define OPTION_VAL_490_DE "490 %"
#define OPTION_VAL_500_DE "500 %"
#define OPTION_VAL_510_DE "510 %"
#define OPTION_VAL_520_DE "520 %"
#define OPTION_VAL_530_DE "530 %"
#define OPTION_VAL_540_DE "540 %"
#define OPTION_VAL_550_DE "550 %"
#define OPTION_VAL_560_DE "560 %"
#define OPTION_VAL_570_DE "570 %"
#define OPTION_VAL_580_DE "580 %"
#define OPTION_VAL_590_DE "590 %"
#define OPTION_VAL_600_DE "600 %"
#define OPTION_VAL_610_DE "610 %"
#define OPTION_VAL_620_DE "620 %"
#define OPTION_VAL_630_DE "630 %"
#define OPTION_VAL_640_DE "640 %"
#define OPTION_VAL_650_DE "650 %"
#define OPTION_VAL_660_DE "660 %"
#define OPTION_VAL_670_DE "670 %"
#define OPTION_VAL_680_DE "680 %"
#define OPTION_VAL_690_DE "690 %"
#define OPTION_VAL_700_DE "700 %"
#define OPTION_VAL_710_DE "710 %"
#define OPTION_VAL_720_DE "720 %"
#define OPTION_VAL_730_DE "730 %"
#define OPTION_VAL_740_DE "740 %"
#define OPTION_VAL_750_DE "750 %"
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_DE "GPU-Rasterübertaktung"
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_DE "Aktiviert Übertaktung des 2D-Rasters, welcher in der GPU-Emulation der PSX enthalten ist. Verbessert nicht die 3D-Darstellung und hat im Allgemeinen wenig Effekt."
#define OPTION_VAL_32X_DE NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_DE "GTE-Übertaktung"
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_DE "Verringert alle emulierten GTE (CPU-Koprozessor für 3D-Grafiken) Operationen zu einer konstanten 1-Zyklus-Latenz. Bei Spielen, die die GTE stark nutzen, kann dies die Bildrate und die Bildstabilität erheblich verbessern."
#define BEETLE_OPT_SKIP_BIOS_LABEL_DE "BIOS überspringen"
#define BEETLE_OPT_SKIP_BIOS_INFO_0_DE "Die PlayStation BIOS-Boot-Animation, die normalerweise beim Laden von Inhalten angezeigt wird, überspringen. Hinweis: Diese Funktion führt zu Kompatibilitätsproblemen bei einer Reihe von Spielen (PAL-kopiergeschützte Spiele, Saga Frontier usw.)."
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_DE "BIOS überschreiben (Neustart erforderlich)"
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_DE "Das standardmäßige regionsspezifische BIOS mit einem regionsfreien BIOS überschreiben, sofern vorhanden."
#define OPTION_VAL_PSXONPSP_DE NULL
#define OPTION_VAL_PS1_ROM_DE NULL
#define BEETLE_OPT_RENDERER_LABEL_DE "Renderer (Neustart erforderlich)"
#define BEETLE_OPT_RENDERER_INFO_0_DE "Der Software-Renderer ist der genaueste, hat aber hohe Leistungsanforderungen, wenn er bei erhöhten internen GPU-Auflösungen ausgeführt wird. Die Hardware-Renderer verbessern die Leistung gegenüber dem Software-Renderer bei hoheren internen Auflösungen und ermöglichen verschiedene grafische Verbesserungen. „Hardware (Automatisch)“ wählt automatisch die Renderer Vulkan oder OpenGL aus, abhängig vom aktuellen Grafiktreiber. Wenn der mitgelieferte Videotreiber nicht mit Vulkan oder OpenGL 3.3 kompatibel ist, greift der Core auf den Software-Renderer zurück."
#define OPTION_VAL_HARDWARE_DE "Hardware (Automatisch)"
#define OPTION_VAL_HARDWARE_GL_DE NULL
#define OPTION_VAL_HARDWARE_VK_DE NULL
#define OPTION_VAL_SOFTWARE_DE NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_DE "Software-Framebuffer"
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_DE "Aktiviere genaue Emulation von Bildspeicher-Effekten (z. Motion Blur, FF7 Battle swirl), wenn Sie Hardware-Renderer verwenden, indem Sie eine Kopie des Software-Renderer mit nativer Auflösung im Hintergrund ausführen. Falls deaktiviert, werden diese Operationen (OpenGL) ausgelassen oder auf der GPU (Vulkan) gerendert. Das Deaktivieren kann die Leistung verbessern, kann aber schwerwiegende graphische Fehler verursachen. Aktiviert lassen wenn unsicher."
#define BEETLE_OPT_CPU_DYNAREC_LABEL_DE "CPU-Dynarec"
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_DE "CPU-Anweisungen dynamisch neu zu native Anweisungen kompilieren. Viel schneller als Interpreter, aber das CPU-Timing ist weniger genau und kann Fehler enthalten."
#define OPTION_VAL_DISABLED_DE "Deaktiviert (Beetle-Interpreter)"
#define OPTION_VAL_EXECUTE_DE "Max. Leistung"
#define OPTION_VAL_EXECUTE_ONE_DE "Zykluszeitprüfung"
#define OPTION_VAL_RUN_INTERPRETER_DE "Lightrec-Interpreter"
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_DE "Dynarec-Code-Invalidierung"
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_DE "Einige Spiele erfordern „volle“ Invalidierung, andere benötigen „Nur DMA“."
#define OPTION_VAL_FULL_DE "Voll"
#define OPTION_VAL_DMA_DE "Nur DMA (etwas schneller)"
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_DE "Dynarec DMA/GPU/MDEC/Timer Event Zyklen"
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_DE "Maximale Zyklen, die von der CPU ausgeführt werden, bevor ein GPU/DMA/MDEC/Timer Update überprüft wird. Eine höhere Zahl wird schneller sein, hat viel weniger Auswirkungen auf den beetle interpreter als dynarec."
#define OPTION_VAL_128_DE "128 (Standard)"
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_DE "Dynarec SPU-Samples"
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_DE "Maximal laufende SPU-Samples bevor ein SPU-Update geprüft wird; eine höhere Zahl ist schneller, wird aber bei einigen Spielen Soundfehler mit etwas anderem als „1“ verursachen."
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_DE "Von Core gemeldetes FPS-Timing"
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_DE "Das FPS-Timing auswählen, das der Core an das Frontend melden soll. Automatisches Umschalten ermöglicht dem Core im Wechsel progressive und „interlaced“ Frequenzen zu melden, was aber dazu führen kann, dass der Video-/Audiotreiber des Frontends neu initialisiert wird."
#define OPTION_VAL_FORCE_PROGRESSIVE_DE "Progressive Frequenz"
#define OPTION_VAL_FORCE_INTERLACED_DE "„Interlaced“ Frequenz erzwingen"
#define OPTION_VAL_AUTO_TOGGLE_DE "Automatisches Umschalten erlauben"
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_DE "PAL (europäisch) Videotiming übersteuern"
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_DE "Aufgrund unterschiedlicher Standards scheinen PAL-Spiele im Vergleich zu den amerikanischen oder japanischen NTSC-Releases verlangsamt. Diese Option kann genutzt werden, um PAL-Timings zu übersteuern und zu versuchen, diese Spiele mit der NTSC-Bildwiederholrate auszuführen. Diese Option hat keine Auswirkung beim Ausführen von NTSC-Inhalten."
#define BEETLE_OPT_ASPECT_RATIO_LABEL_DE "Core-Seitenverhältnis"
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_DE "Das Core-seitige Seitenverhältnis auswählen. Diese Einstellung wird ignoriert, wenn die Optionen „Breitbildmodus-Hack“ oder „Vollständigen VRAM anzeigen“ aktiviert sind."
#define OPTION_VAL_CORRECTED_DE "Korrigiert"
#define OPTION_VAL_UNCORRECTED_DE "Unkorrigiert"
#define OPTION_VAL_4_3_DE "4:3 erzwingen"
#define OPTION_VAL_NTSC_DE "NTSC erzwingen"
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_DE "Overscan zuschneiden"
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_DE "'Nein' behält Fülldaten (schwarze Balken auf beiden Seiten des Bildes für NTSC, auf allen Seiten für PAL), um die gleichen schwarzen Balken zu emulieren, die in analoger Videoausgabe durch echte PSX-Hardware erzeugt werden. 'Statisch' entfernt nur horizontale Fülldaten, 'Dynamisch' entfernt alle Fülldaten."
#define OPTION_VAL_DISABLED_O58_DE "Kein"
#define OPTION_VAL_STATIC_DE "Statisch"
#define OPTION_VAL_SMART_DE "Dynamisch (Standard)"
#define BEETLE_OPT_IMAGE_CROP_LABEL_DE "Zusätzliches Zuschneiden"
#define BEETLE_OPT_IMAGE_CROP_INFO_0_DE "Wenn 'Horizontaler Overscan' aktiviert ist, verringert diese Option die Breite des zugeschnittenen Bildes um die angegebene Anzahl Pixel."
#define OPTION_VAL_9PX_DE "9 px"
#define OPTION_VAL_10PX_DE "10 px"
#define OPTION_VAL_11PX_DE "11 px"
#define OPTION_VAL_12PX_DE "12 px"
#define OPTION_VAL_13PX_DE "13 px"
#define OPTION_VAL_14PX_DE "14 px"
#define OPTION_VAL_15PX_DE "15 px"
#define OPTION_VAL_16PX_DE "16 px"
#define OPTION_VAL_17PX_DE "17 px"
#define OPTION_VAL_18PX_DE "18 px"
#define OPTION_VAL_19PX_DE "19 px"
#define OPTION_VAL_20PX_DE "20 px"
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_DE "Versatz zugeschnittenes Bild"
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_DE "Wenn 'Horizontaler Overscan' aktiviert ist, kann das resultierende zugeschnittene Bild horizontal nach rechts (positiv) oder links (negativ) durch die angegebene Anzahl Pixel versetzt werden. Kann zur Korrektur von Ausrichtungsproblemen verwendet werden. Wird nur vom Software-Renderer unterstützt."
#define OPTION_VAL_12PX_O60_DE "-12 px"
#define OPTION_VAL_11PX_O60_DE "-11 px"
#define OPTION_VAL_10PX_O60_DE "-10 px"
#define OPTION_VAL_9PX_O60_DE "-9 px"
#define OPTION_VAL_8PX_O60_DE "-8 px"
#define OPTION_VAL_7PX_O60_DE "-7 px"
#define OPTION_VAL_6PX_O60_DE "-6 px"
#define OPTION_VAL_5PX_O60_DE "-5 px"
#define OPTION_VAL_4PX_O60_DE "-4 px"
#define OPTION_VAL_3PX_O60_DE "-3 px"
#define OPTION_VAL_2PX_O60_DE "-2 px"
#define OPTION_VAL_1PX_O60_DE "-1 px"
#define OPTION_VAL_1PX_O60_0_DE "+1 px"
#define OPTION_VAL_2PX_O60_0_DE "+2 px"
#define OPTION_VAL_3PX_O60_0_DE "+3 px"
#define OPTION_VAL_4PX_O60_0_DE "+4 px"
#define OPTION_VAL_5PX_O60_0_DE "+5 px"
#define OPTION_VAL_6PX_O60_0_DE "+6 px"
#define OPTION_VAL_7PX_O60_0_DE "+7 px"
#define OPTION_VAL_8PX_O60_0_DE "+8 px"
#define OPTION_VAL_9PX_O60_0_DE "+9 px"
#define OPTION_VAL_10PX_O60_0_DE "+10 px"
#define OPTION_VAL_11PX_O60_0_DE "+11 px"
#define OPTION_VAL_12PX_O60_0_DE "+12 px"
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_DE "Horizontaler Bildversatz (GPU-Zyklen)"
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_DE "Wählt die Anzahl der GPU-Zyklen, um die das Bild versetzt werden soll. Positive Werte verschieben das Bild nach rechts, negative Werte verschieben das Bild nach links. Nur unterstützt von Hardware-Renderern."
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_DE "Erste Abtastzeile - NTSC"
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_DE "Wählt die erste angezeigte Scanline beim Ausführen von NTSC-Inhalten. Werte größer als Null verringern die Höhe der Ausgabebilder durch Zuschneiden von Pixeln von der obersten Kante. Kann verwendet werden, um schwarze Balken entgegenzuwirken."
#define OPTION_VAL_0_O62_DE "0 (Standard)"
#define BEETLE_OPT_LAST_SCANLINE_LABEL_DE "Letzte Abtastzeile - NTSC"
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_DE "Wählen Sie die letzte angezeigte Scanline beim Ausführen von NTSC-Inhalten. Werte kleiner als 239 reduzieren die Höhe der Ausgabebilder durch Zuschneiden von Pixeln von der unteren Kante. Kann verwendet werden, um schwarze Balken entgegenzuwirken."
#define OPTION_VAL_239_DE "239 (Standard)"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_DE "Erste Abtastzeile - PAL"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_DE "Wählen Sie die erste angezeigte Scanline beim Ausführen von PAL-Inhalten. Werte größer als Null verringern die Höhe der Ausgabebilder durch Zuschneiden von Pixeln von der obersten Kante. Kann verwendet werden, um schwarze Balken entgegenzuwirken."
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_DE "Letzte Abtastzeile - PAL"
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_DE "Wählen Sie die letzte angezeigte Scanline beim Ausführen von PAL-Inhalten. Werte unter 287 verringern die Höhe der Ausgabebilder durch Zuschneiden von Pixeln von der unteren Kante. Kann verwendet werden, um schwarze Balken entgegenzuwirken."
#define OPTION_VAL_287_DE "287 (Standard)"
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_DE "CD-Zugriffsmethode (Neustart erforderlich)"
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_DE "Methode auswählen, mit der Daten von CD-Abbildern gelesen werden. „Synchron“ ahmt die Originalhardware nach. „Asynchron“ kann das Stottern auf Geräten mit langsamem Speicher verringern. „Vorab laden“ lädt beim Starten von Inhalten das gesamte CD-Abbildes in den Speicher, was die Ladezeiten im Spiel auf Kosten einer anfänglichen Verzögerung beim Starten verbessern kann. „Vorab laden“ kann auf Systemen mit wenig Arbeitsspeicher zu Problemen führen, und wird bei physischen Medien auf „Synchron“ zurückgreifen."
#define OPTION_VAL_SYNC_DE "Synchron"
#define OPTION_VAL_ASYNC_DE "Asynchron"
#define OPTION_VAL_PRECACHE_DE "Vorab laden"
#define BEETLE_OPT_CD_FASTLOAD_LABEL_DE "CD-Ladegeschwindigkeit"
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_DE "CD-Geschwindigkeit einstellen. Werte über „2× (Nativ)“ können die Ladezeiten im Spiel erheblich verkürzen, aber zu Timingfehlern führen. Einige Spiele funktionieren möglicherweise ab einem bestimmten Wert nicht mehr richtig."
#define OPTION_VAL_2X_NATIVE_DE "2x (Nativ)"
#define OPTION_VAL_6X_DE "6 x"
#define OPTION_VAL_10X_DE NULL
#define OPTION_VAL_12X_DE NULL
#define OPTION_VAL_14X_DE NULL

struct retro_core_option_v2_category option_cats_de[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_DE,
      CATEGORY_VIDEO_INFO_0_DE
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_DE,
      CATEGORY_OSD_INFO_0_DE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DE,
      CATEGORY_INPUT_INFO_0_DE
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_DE,
      CATEGORY_MEMCARDS_INFO_0_DE
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_DE,
      CATEGORY_PGXP_INFO_0_DE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DE,
      CATEGORY_HACKS_INFO_0_DE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_de[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_DE,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_DE,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_DE },
         { "2x",         OPTION_VAL_2X_DE },
         { "4x",         OPTION_VAL_4X_DE },
         { "8x",         OPTION_VAL_8X_DE },
         { "16x",        OPTION_VAL_16X_DE },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_DE,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_DE,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_DE },
         { "32bpp",         OPTION_VAL_32BPP_DE },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_DE,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_DE,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_DE },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_DE },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_DE,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_DE,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_DE,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_DE,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_DE },
         { "SABR",     OPTION_VAL_SABR_DE },
         { "xBR",      OPTION_VAL_XBR_DE },
         { "bilinear", OPTION_VAL_BILINEAR_DE },
         { "3-point",  OPTION_VAL_3_POINT_DE },
         { "JINC2",    OPTION_VAL_JINC2_DE },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_DE,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_DE },
         { "all", OPTION_VAL_ALL_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_DE,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_DE },
         { "all", OPTION_VAL_ALL_DE },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_DE,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_DE,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_DE,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_DE,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_DE },
         { "2x",  OPTION_VAL_2X_DE },
         { "4x",  OPTION_VAL_4X_DE },
         { "8x",  OPTION_VAL_8X_DE },
         { "16x", OPTION_VAL_16X_DE },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_DE,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_DE,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_DE,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_DE,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_DE,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_DE,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_DE,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_DE,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_DE,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_DE,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_DE,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_DE,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_DE,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_DE,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_DE },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_DE },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_DE },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_DE },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_DE },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_DE },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_DE },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_DE },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_DE },
         { "l3+r3",                    OPTION_VAL_L3_R3_DE },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_DE,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_DE,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_DE },
         { "1", OPTION_VAL_1_DE },
         { "2", OPTION_VAL_2_DE },
         { "3", OPTION_VAL_3_DE },
         { "4", OPTION_VAL_4_DE },
         { "5", OPTION_VAL_5_DE },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_DE,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_DE,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_DE,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_DE,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_DE },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_DE },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_DE,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_DE,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_DE },
         { "dot",   OPTION_VAL_DOT_DE },
         { "off",   OPTION_VAL_OFF_DE },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_DE,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_DE,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_DE },
         { "blue", OPTION_VAL_BLUE_DE },
         { "green", OPTION_VAL_GREEN_DE },
         { "orange", OPTION_VAL_ORANGE_DE },
         { "yellow", OPTION_VAL_YELLOW_DE },
         { "cyan", OPTION_VAL_CYAN_DE },
         { "pink", OPTION_VAL_PINK_DE },
         { "purple", OPTION_VAL_PURPLE_DE },
         { "black", OPTION_VAL_BLACK_DE },
         { "white", OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_DE,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_DE,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_DE },
         { "red", OPTION_VAL_RED_DE },
         { "green", OPTION_VAL_GREEN_DE },
         { "orange", OPTION_VAL_ORANGE_DE },
         { "yellow", OPTION_VAL_YELLOW_DE },
         { "cyan", OPTION_VAL_CYAN_DE },
         { "pink", OPTION_VAL_PINK_DE },
         { "purple", OPTION_VAL_PURPLE_DE },
         { "black", OPTION_VAL_BLACK_DE },
         { "white", OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_DE,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_DE,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_DE },
         { "10%",  OPTION_VAL_10_DE },
         { "15%",  OPTION_VAL_15_DE },
         { "20%",  OPTION_VAL_20_DE },
         { "25%",  OPTION_VAL_25_DE },
         { "30%",  OPTION_VAL_30_DE },
         { "35%",  OPTION_VAL_35_DE },
         { "40%",  OPTION_VAL_40_DE },
         { "45%",  OPTION_VAL_45_DE },
         { "50%",  OPTION_VAL_50_DE },
         { "55%",  OPTION_VAL_55_DE },
         { "60%",  OPTION_VAL_60_DE },
         { "65%",  OPTION_VAL_65_DE },
         { "70%",  OPTION_VAL_70_DE },
         { "75%",  OPTION_VAL_75_DE },
         { "80%",  OPTION_VAL_80_DE },
         { "85%",  OPTION_VAL_85_DE },
         { "90%",  OPTION_VAL_90_DE },
         { "95%",  OPTION_VAL_95_DE },
         { "100%", OPTION_VAL_100_DE },
         { "105%", OPTION_VAL_105_DE },
         { "110%", OPTION_VAL_110_DE },
         { "115%", OPTION_VAL_115_DE },
         { "120%", OPTION_VAL_120_DE },
         { "125%", OPTION_VAL_125_DE },
         { "130%", OPTION_VAL_130_DE },
         { "135%", OPTION_VAL_135_DE },
         { "140%", OPTION_VAL_140_DE },
         { "145%", OPTION_VAL_145_DE },
         { "150%", OPTION_VAL_150_DE },
         { "155%", OPTION_VAL_155_DE },
         { "160%", OPTION_VAL_160_DE },
         { "165%", OPTION_VAL_165_DE },
         { "170%", OPTION_VAL_170_DE },
         { "175%", OPTION_VAL_175_DE },
         { "180%", OPTION_VAL_180_DE },
         { "185%", OPTION_VAL_185_DE },
         { "190%", OPTION_VAL_190_DE },
         { "195%", OPTION_VAL_195_DE },
         { "200%", OPTION_VAL_200_DE },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_DE,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_DE,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_DE },
         { "quadratic", OPTION_VAL_QUADRATIC_DE },
         { "cubic",     OPTION_VAL_CUBIC_DE },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_DE,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_DE,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_DE },
         { "5%",  OPTION_VAL_5_O28_DE },
         { "10%", OPTION_VAL_10_DE },
         { "15%", OPTION_VAL_15_DE },
         { "20%", OPTION_VAL_20_DE },
         { "25%", OPTION_VAL_25_DE },
         { "30%", OPTION_VAL_30_DE },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_DE,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_DE,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_DE },
         { "mednafen", OPTION_VAL_MEDNAFEN_DE },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_DE,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_DE,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_DE,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_DE,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_DE,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_DE,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_DE,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_DE,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_DE },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_DE,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_DE,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_DE },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_DE,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_DE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_DE },
         { "1px", OPTION_VAL_1PX_DE },
         { "2px", OPTION_VAL_2PX_DE },
         { "3px", OPTION_VAL_3PX_DE },
         { "4px", OPTION_VAL_4PX_DE },
         { "5px", OPTION_VAL_5PX_DE },
         { "6px", OPTION_VAL_6PX_DE },
         { "7px", OPTION_VAL_7PX_DE },
         { "8px", OPTION_VAL_8PX_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_DE,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_DE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_DE,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_DE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_DE,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_DE,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_DE,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_DE },
         { "aggressive", OPTION_VAL_AGGRESSIVE_DE },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_DE,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_DE,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_DE },
         { "16:10", OPTION_VAL_16_10_DE },
         { "18:9",  OPTION_VAL_18_9_DE },
         { "19:9",  OPTION_VAL_19_9_DE },
         { "20:9",  OPTION_VAL_20_9_DE },
         { "21:9",  OPTION_VAL_21_9_DE }, // 64:27
         { "32:9",  OPTION_VAL_32_9_DE },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_DE,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_DE },
         { "60%",           OPTION_VAL_60_DE },
         { "70%",           OPTION_VAL_70_DE },
         { "80%",           OPTION_VAL_80_DE },
         { "90%",           OPTION_VAL_90_DE },
         { "100%(native)", OPTION_VAL_100_NATIVE_DE },
         { "110%",          OPTION_VAL_110_DE },
         { "120%",          OPTION_VAL_120_DE },
         { "130%",          OPTION_VAL_130_DE },
         { "140%",          OPTION_VAL_140_DE },
         { "150%",          OPTION_VAL_150_DE },
         { "160%",          OPTION_VAL_160_DE },
         { "170%",          OPTION_VAL_170_DE },
         { "180%",          OPTION_VAL_180_DE },
         { "190%",          OPTION_VAL_190_DE },
         { "200%",          OPTION_VAL_200_DE },
         { "210%",          OPTION_VAL_210_DE },
         { "220%",          OPTION_VAL_220_DE },
         { "230%",          OPTION_VAL_230_DE },
         { "240%",          OPTION_VAL_240_DE },
         { "250%",          OPTION_VAL_250_DE },
         { "260%",          OPTION_VAL_260_DE },
         { "270%",          OPTION_VAL_270_DE },
         { "280%",          OPTION_VAL_280_DE },
         { "290%",          OPTION_VAL_290_DE },
         { "300%",          OPTION_VAL_300_DE },
         { "310%",          OPTION_VAL_310_DE },
         { "320%",          OPTION_VAL_320_DE },
         { "330%",          OPTION_VAL_330_DE },
         { "340%",          OPTION_VAL_340_DE },
         { "350%",          OPTION_VAL_350_DE },
         { "360%",          OPTION_VAL_360_DE },
         { "370%",          OPTION_VAL_370_DE },
         { "380%",          OPTION_VAL_380_DE },
         { "390%",          OPTION_VAL_390_DE },
         { "400%",          OPTION_VAL_400_DE },
         { "410%",          OPTION_VAL_410_DE },
         { "420%",          OPTION_VAL_420_DE },
         { "430%",          OPTION_VAL_430_DE },
         { "440%",          OPTION_VAL_440_DE },
         { "450%",          OPTION_VAL_450_DE },
         { "460%",          OPTION_VAL_460_DE },
         { "470%",          OPTION_VAL_470_DE },
         { "480%",          OPTION_VAL_480_DE },
         { "490%",          OPTION_VAL_490_DE },
         { "500%",          OPTION_VAL_500_DE },
         { "510%",          OPTION_VAL_510_DE },
         { "520%",          OPTION_VAL_520_DE },
         { "530%",          OPTION_VAL_530_DE },
         { "540%",          OPTION_VAL_540_DE },
         { "550%",          OPTION_VAL_550_DE },
         { "560%",          OPTION_VAL_560_DE },
         { "570%",          OPTION_VAL_570_DE },
         { "580%",          OPTION_VAL_580_DE },
         { "590%",          OPTION_VAL_590_DE },
         { "600%",          OPTION_VAL_600_DE },
         { "610%",          OPTION_VAL_610_DE },
         { "620%",          OPTION_VAL_620_DE },
         { "630%",          OPTION_VAL_630_DE },
         { "640%",          OPTION_VAL_640_DE },
         { "650%",          OPTION_VAL_650_DE },
         { "660%",          OPTION_VAL_660_DE },
         { "670%",          OPTION_VAL_670_DE },
         { "680%",          OPTION_VAL_680_DE },
         { "690%",          OPTION_VAL_690_DE },
         { "700%",          OPTION_VAL_700_DE },
         { "710%",          OPTION_VAL_710_DE },
         { "720%",          OPTION_VAL_720_DE },
         { "730%",          OPTION_VAL_730_DE },
         { "740%",          OPTION_VAL_740_DE },
         { "750%",          OPTION_VAL_750_DE },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_DE,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_DE },
         { "2x",         OPTION_VAL_2X_DE },
         { "4x",         OPTION_VAL_4X_DE },
         { "8x",         OPTION_VAL_8X_DE },
         { "16x",        OPTION_VAL_16X_DE },
         { "32x",        OPTION_VAL_32X_DE },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_DE,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_DE,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_DE,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_DE },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_DE },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_DE,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_DE,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_DE },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_DE },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_DE },
#endif
         { "software",    OPTION_VAL_SOFTWARE_DE },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_DE,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_DE,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_DE,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_DE,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_DE },
         { "execute",  OPTION_VAL_EXECUTE_DE },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_DE },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_DE,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_DE,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_DE },
         { "dma",  OPTION_VAL_DMA_DE },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_DE,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_DE },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_DE,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_DE },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_DE,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_DE,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_DE },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_DE },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_DE },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_DE,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_DE,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_DE,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_DE },
         { "uncorrected", OPTION_VAL_UNCORRECTED_DE },
         { "4:3",  OPTION_VAL_4_3_DE },
         { "ntsc", OPTION_VAL_NTSC_DE },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_DE,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_DE },
         { "static",  OPTION_VAL_STATIC_DE },
         { "smart", OPTION_VAL_SMART_DE },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_DE,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_DE },
         { "2px",      OPTION_VAL_2PX_DE },
         { "3px",      OPTION_VAL_3PX_DE },
         { "4px",      OPTION_VAL_4PX_DE },
         { "5px",      OPTION_VAL_5PX_DE },
         { "6px",      OPTION_VAL_6PX_DE },
         { "7px",      OPTION_VAL_7PX_DE },
         { "8px",      OPTION_VAL_8PX_DE },
         { "9px",      OPTION_VAL_9PX_DE },
         { "10px",     OPTION_VAL_10PX_DE },
         { "11px",     OPTION_VAL_11PX_DE },
         { "12px",     OPTION_VAL_12PX_DE },
         { "13px",     OPTION_VAL_13PX_DE },
         { "14px",     OPTION_VAL_14PX_DE },
         { "15px",     OPTION_VAL_15PX_DE },
         { "16px",     OPTION_VAL_16PX_DE },
         { "17px",     OPTION_VAL_17PX_DE },
         { "18px",     OPTION_VAL_18PX_DE },
         { "19px",     OPTION_VAL_19PX_DE },
         { "20px",     OPTION_VAL_20PX_DE },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_DE,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_DE,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_DE },
         { "-11px",    OPTION_VAL_11PX_O60_DE },
         { "-10px",    OPTION_VAL_10PX_O60_DE },
         { "-9px",     OPTION_VAL_9PX_O60_DE },
         { "-8px",     OPTION_VAL_8PX_O60_DE },
         { "-7px",     OPTION_VAL_7PX_O60_DE },
         { "-6px",     OPTION_VAL_6PX_O60_DE },
         { "-5px",     OPTION_VAL_5PX_O60_DE },
         { "-4px",     OPTION_VAL_4PX_O60_DE },
         { "-3px",     OPTION_VAL_3PX_O60_DE },
         { "-2px",     OPTION_VAL_2PX_O60_DE },
         { "-1px",     OPTION_VAL_1PX_O60_DE },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_DE },
         { "+2px",     OPTION_VAL_2PX_O60_0_DE },
         { "+3px",     OPTION_VAL_3PX_O60_0_DE },
         { "+4px",     OPTION_VAL_4PX_O60_0_DE },
         { "+5px",     OPTION_VAL_5PX_O60_0_DE },
         { "+6px",     OPTION_VAL_6PX_O60_0_DE },
         { "+7px",     OPTION_VAL_7PX_O60_0_DE },
         { "+8px",     OPTION_VAL_8PX_O60_0_DE },
         { "+9px",     OPTION_VAL_9PX_O60_0_DE },
         { "+10px",    OPTION_VAL_10PX_O60_0_DE },
         { "+11px",    OPTION_VAL_11PX_O60_0_DE },
         { "+12px",    OPTION_VAL_12PX_O60_0_DE },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_DE,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_DE,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_DE,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_DE,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_DE },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_DE,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_DE,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_DE },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_DE,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_DE,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_DE },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_DE,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_DE,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_DE },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_DE,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_DE,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_DE },
         { "async",    OPTION_VAL_ASYNC_DE },
         { "precache", OPTION_VAL_PRECACHE_DE },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_DE,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_DE,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_DE },
         { "4x",          OPTION_VAL_4X_DE },
         { "6x",          OPTION_VAL_6X_DE },
         { "8x",          OPTION_VAL_8X_DE },
         { "10x",         OPTION_VAL_10X_DE },
         { "12x",         OPTION_VAL_12X_DE },
         { "14x",         OPTION_VAL_14X_DE },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_de = {
   option_cats_de,
   option_defs_de
};

/* RETRO_LANGUAGE_EL */

#define CATEGORY_VIDEO_LABEL_EL "Οδηγός Βίντεο"
#define CATEGORY_VIDEO_INFO_0_EL NULL
#define CATEGORY_OSD_LABEL_EL "Οθόνη Απεικόνισης"
#define CATEGORY_OSD_INFO_0_EL NULL
#define CATEGORY_INPUT_LABEL_EL "Οδηγός Εισαγωγής"
#define CATEGORY_INPUT_INFO_0_EL NULL
#define CATEGORY_MEMCARDS_LABEL_EL NULL
#define CATEGORY_MEMCARDS_INFO_0_EL NULL
#define CATEGORY_PGXP_LABEL_EL NULL
#define CATEGORY_PGXP_INFO_0_EL NULL
#define CATEGORY_HACKS_LABEL_EL NULL
#define CATEGORY_HACKS_INFO_0_EL NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_EL NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_EL NULL
#define OPTION_VAL_1X_NATIVE_EL NULL
#define OPTION_VAL_2X_EL NULL
#define OPTION_VAL_4X_EL NULL
#define OPTION_VAL_8X_EL NULL
#define OPTION_VAL_16X_EL NULL
#define BEETLE_OPT_DEPTH_LABEL_EL NULL
#define BEETLE_OPT_DEPTH_INFO_0_EL NULL
#define OPTION_VAL_16BPP_NATIVE_EL NULL
#define OPTION_VAL_32BPP_EL NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_EL NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_EL NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_EL NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_EL NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_EL NULL
#define BEETLE_OPT_FILTER_LABEL_EL NULL
#define BEETLE_OPT_FILTER_INFO_0_EL NULL
#define OPTION_VAL_NEAREST_EL "Κοντινότερο"
#define OPTION_VAL_SABR_EL NULL
#define OPTION_VAL_XBR_EL NULL
#define OPTION_VAL_BILINEAR_EL NULL
#define OPTION_VAL_3_POINT_EL NULL
#define OPTION_VAL_JINC2_EL NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_EL NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_EL NULL
#define OPTION_VAL_OPAQUE_EL NULL
#define OPTION_VAL_ALL_EL NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_EL NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_EL NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_EL NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_EL NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_EL NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_EL NULL
#define BEETLE_OPT_MSAA_LABEL_EL NULL
#define BEETLE_OPT_MSAA_INFO_0_EL NULL
#define OPTION_VAL_1X_EL NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_EL NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_EL NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_EL NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_EL NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_EL NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_EL NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_EL NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_EL NULL
#define BEETLE_OPT_WIREFRAME_LABEL_EL NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_EL NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_EL NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_EL NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_EL NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_EL NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_EL NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_EL NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_EL NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_EL NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_EL NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_EL NULL
#define OPTION_VAL_ENABLED_ANALOG_EL NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_EL NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_EL NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_EL NULL
#define OPTION_VAL_L1_R1_SELECT_EL NULL
#define OPTION_VAL_L1_R1_START_EL NULL
#define OPTION_VAL_L1_R1_L3_EL NULL
#define OPTION_VAL_L1_R1_R3_EL NULL
#define OPTION_VAL_L2_R2_SELECT_EL NULL
#define OPTION_VAL_L2_R2_START_EL NULL
#define OPTION_VAL_L2_R2_L3_EL NULL
#define OPTION_VAL_L2_R2_R3_EL NULL
#define OPTION_VAL_L3_R3_EL NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_EL NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_EL NULL
#define OPTION_VAL_0_EL NULL
#define OPTION_VAL_1_EL NULL
#define OPTION_VAL_2_EL NULL
#define OPTION_VAL_3_EL NULL
#define OPTION_VAL_4_EL NULL
#define OPTION_VAL_5_EL NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_EL NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_EL NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_EL NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_EL NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_EL NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_EL NULL
#define OPTION_VAL_LIGHTGUN_EL NULL
#define OPTION_VAL_TOUCHSCREEN_EL NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_EL NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_EL NULL
#define OPTION_VAL_CROSS_EL NULL
#define OPTION_VAL_DOT_EL NULL
#define OPTION_VAL_OFF_EL NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_EL NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_EL NULL
#define OPTION_VAL_RED_EL "Κόκκινο"
#define OPTION_VAL_BLUE_EL "Μπλε"
#define OPTION_VAL_GREEN_EL "Πράσινο"
#define OPTION_VAL_ORANGE_EL NULL
#define OPTION_VAL_YELLOW_EL "Κίτρινο"
#define OPTION_VAL_CYAN_EL NULL
#define OPTION_VAL_PINK_EL NULL
#define OPTION_VAL_PURPLE_EL NULL
#define OPTION_VAL_BLACK_EL NULL
#define OPTION_VAL_WHITE_EL NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_EL NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_EL NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_EL "Ευαισθησία Ποντικιού"
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_EL NULL
#define OPTION_VAL_5_O28_EL NULL
#define OPTION_VAL_10_EL NULL
#define OPTION_VAL_15_EL NULL
#define OPTION_VAL_20_EL NULL
#define OPTION_VAL_25_EL NULL
#define OPTION_VAL_30_EL NULL
#define OPTION_VAL_35_EL NULL
#define OPTION_VAL_40_EL NULL
#define OPTION_VAL_45_EL NULL
#define OPTION_VAL_50_EL NULL
#define OPTION_VAL_55_EL NULL
#define OPTION_VAL_60_EL NULL
#define OPTION_VAL_65_EL NULL
#define OPTION_VAL_70_EL NULL
#define OPTION_VAL_75_EL NULL
#define OPTION_VAL_80_EL "το 80%"
#define OPTION_VAL_85_EL NULL
#define OPTION_VAL_90_EL NULL
#define OPTION_VAL_95_EL NULL
#define OPTION_VAL_100_EL NULL
#define OPTION_VAL_105_EL NULL
#define OPTION_VAL_110_EL NULL
#define OPTION_VAL_115_EL NULL
#define OPTION_VAL_120_EL NULL
#define OPTION_VAL_125_EL NULL
#define OPTION_VAL_130_EL NULL
#define OPTION_VAL_135_EL NULL
#define OPTION_VAL_140_EL NULL
#define OPTION_VAL_145_EL NULL
#define OPTION_VAL_150_EL NULL
#define OPTION_VAL_155_EL NULL
#define OPTION_VAL_160_EL NULL
#define OPTION_VAL_165_EL NULL
#define OPTION_VAL_170_EL NULL
#define OPTION_VAL_175_EL NULL
#define OPTION_VAL_180_EL NULL
#define OPTION_VAL_185_EL NULL
#define OPTION_VAL_190_EL NULL
#define OPTION_VAL_195_EL NULL
#define OPTION_VAL_200_EL NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_EL NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_EL NULL
#define OPTION_VAL_LINEAR_EL "Γραμμικός"
#define OPTION_VAL_QUADRATIC_EL NULL
#define OPTION_VAL_CUBIC_EL NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_EL NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_EL NULL
#define OPTION_VAL_0_O30_EL NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_EL NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_EL NULL
#define OPTION_VAL_LIBRETRO_EL NULL
#define OPTION_VAL_MEDNAFEN_EL NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_EL NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_EL NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_EL NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_EL NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_EL NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_EL NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_EL NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_EL NULL
#define OPTION_VAL_1_O35_EL NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_EL NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_EL NULL
#define OPTION_VAL_MEMORY_ONLY_EL NULL
#define OPTION_VAL_MEMORY_CPU_EL NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_EL NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_EL NULL
#define OPTION_VAL_0PX_EL NULL
#define OPTION_VAL_1PX_EL NULL
#define OPTION_VAL_2PX_EL NULL
#define OPTION_VAL_3PX_EL NULL
#define OPTION_VAL_4PX_EL NULL
#define OPTION_VAL_5PX_EL NULL
#define OPTION_VAL_6PX_EL NULL
#define OPTION_VAL_7PX_EL NULL
#define OPTION_VAL_8PX_EL NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_EL NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_EL NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_EL NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_EL NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_EL NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_EL NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_EL NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_EL NULL
#define OPTION_VAL_DEFAULT_EL "Προκαθορισμένο"
#define OPTION_VAL_AGGRESSIVE_EL NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_EL NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_EL NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_EL NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_EL NULL
#define OPTION_VAL_16_9_EL NULL
#define OPTION_VAL_16_10_EL NULL
#define OPTION_VAL_18_9_EL NULL
#define OPTION_VAL_19_9_EL NULL
#define OPTION_VAL_20_9_EL NULL
#define OPTION_VAL_21_9_EL NULL
#define OPTION_VAL_32_9_EL NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_EL NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_EL NULL
#define OPTION_VAL_100_NATIVE_EL NULL
#define OPTION_VAL_210_EL NULL
#define OPTION_VAL_220_EL NULL
#define OPTION_VAL_230_EL NULL
#define OPTION_VAL_240_EL NULL
#define OPTION_VAL_250_EL NULL
#define OPTION_VAL_260_EL NULL
#define OPTION_VAL_270_EL NULL
#define OPTION_VAL_280_EL NULL
#define OPTION_VAL_290_EL NULL
#define OPTION_VAL_300_EL NULL
#define OPTION_VAL_310_EL NULL
#define OPTION_VAL_320_EL NULL
#define OPTION_VAL_330_EL NULL
#define OPTION_VAL_340_EL NULL
#define OPTION_VAL_350_EL NULL
#define OPTION_VAL_360_EL NULL
#define OPTION_VAL_370_EL NULL
#define OPTION_VAL_380_EL NULL
#define OPTION_VAL_390_EL NULL
#define OPTION_VAL_400_EL NULL
#define OPTION_VAL_410_EL NULL
#define OPTION_VAL_420_EL NULL
#define OPTION_VAL_430_EL NULL
#define OPTION_VAL_440_EL NULL
#define OPTION_VAL_450_EL NULL
#define OPTION_VAL_460_EL NULL
#define OPTION_VAL_470_EL NULL
#define OPTION_VAL_480_EL NULL
#define OPTION_VAL_490_EL NULL
#define OPTION_VAL_500_EL NULL
#define OPTION_VAL_510_EL NULL
#define OPTION_VAL_520_EL NULL
#define OPTION_VAL_530_EL NULL
#define OPTION_VAL_540_EL NULL
#define OPTION_VAL_550_EL NULL
#define OPTION_VAL_560_EL NULL
#define OPTION_VAL_570_EL NULL
#define OPTION_VAL_580_EL NULL
#define OPTION_VAL_590_EL NULL
#define OPTION_VAL_600_EL NULL
#define OPTION_VAL_610_EL NULL
#define OPTION_VAL_620_EL NULL
#define OPTION_VAL_630_EL NULL
#define OPTION_VAL_640_EL NULL
#define OPTION_VAL_650_EL NULL
#define OPTION_VAL_660_EL NULL
#define OPTION_VAL_670_EL NULL
#define OPTION_VAL_680_EL NULL
#define OPTION_VAL_690_EL NULL
#define OPTION_VAL_700_EL NULL
#define OPTION_VAL_710_EL NULL
#define OPTION_VAL_720_EL NULL
#define OPTION_VAL_730_EL NULL
#define OPTION_VAL_740_EL NULL
#define OPTION_VAL_750_EL NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_EL NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_EL NULL
#define OPTION_VAL_32X_EL NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_EL NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_EL NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_EL NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_EL NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_EL NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_EL NULL
#define OPTION_VAL_PSXONPSP_EL NULL
#define OPTION_VAL_PS1_ROM_EL NULL
#define BEETLE_OPT_RENDERER_LABEL_EL NULL
#define BEETLE_OPT_RENDERER_INFO_0_EL NULL
#define OPTION_VAL_HARDWARE_EL NULL
#define OPTION_VAL_HARDWARE_GL_EL NULL
#define OPTION_VAL_HARDWARE_VK_EL NULL
#define OPTION_VAL_SOFTWARE_EL NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_EL NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_EL NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_EL NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_EL NULL
#define OPTION_VAL_DISABLED_EL NULL
#define OPTION_VAL_EXECUTE_EL NULL
#define OPTION_VAL_EXECUTE_ONE_EL NULL
#define OPTION_VAL_RUN_INTERPRETER_EL NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_EL NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_EL NULL
#define OPTION_VAL_FULL_EL NULL
#define OPTION_VAL_DMA_EL NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_EL NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_EL NULL
#define OPTION_VAL_128_EL NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_EL NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_EL NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_EL NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_EL NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_EL NULL
#define OPTION_VAL_FORCE_INTERLACED_EL NULL
#define OPTION_VAL_AUTO_TOGGLE_EL NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_EL NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_EL NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_EL NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_EL NULL
#define OPTION_VAL_CORRECTED_EL NULL
#define OPTION_VAL_UNCORRECTED_EL NULL
#define OPTION_VAL_4_3_EL NULL
#define OPTION_VAL_NTSC_EL NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_EL NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_EL NULL
#define OPTION_VAL_DISABLED_O58_EL "Κανείς"
#define OPTION_VAL_STATIC_EL NULL
#define OPTION_VAL_SMART_EL NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_EL NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_EL NULL
#define OPTION_VAL_9PX_EL NULL
#define OPTION_VAL_10PX_EL NULL
#define OPTION_VAL_11PX_EL NULL
#define OPTION_VAL_12PX_EL NULL
#define OPTION_VAL_13PX_EL NULL
#define OPTION_VAL_14PX_EL NULL
#define OPTION_VAL_15PX_EL NULL
#define OPTION_VAL_16PX_EL NULL
#define OPTION_VAL_17PX_EL NULL
#define OPTION_VAL_18PX_EL NULL
#define OPTION_VAL_19PX_EL NULL
#define OPTION_VAL_20PX_EL NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_EL NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_EL NULL
#define OPTION_VAL_12PX_O60_EL NULL
#define OPTION_VAL_11PX_O60_EL NULL
#define OPTION_VAL_10PX_O60_EL NULL
#define OPTION_VAL_9PX_O60_EL NULL
#define OPTION_VAL_8PX_O60_EL NULL
#define OPTION_VAL_7PX_O60_EL NULL
#define OPTION_VAL_6PX_O60_EL NULL
#define OPTION_VAL_5PX_O60_EL NULL
#define OPTION_VAL_4PX_O60_EL NULL
#define OPTION_VAL_3PX_O60_EL NULL
#define OPTION_VAL_2PX_O60_EL NULL
#define OPTION_VAL_1PX_O60_EL NULL
#define OPTION_VAL_1PX_O60_0_EL NULL
#define OPTION_VAL_2PX_O60_0_EL NULL
#define OPTION_VAL_3PX_O60_0_EL NULL
#define OPTION_VAL_4PX_O60_0_EL NULL
#define OPTION_VAL_5PX_O60_0_EL NULL
#define OPTION_VAL_6PX_O60_0_EL NULL
#define OPTION_VAL_7PX_O60_0_EL NULL
#define OPTION_VAL_8PX_O60_0_EL NULL
#define OPTION_VAL_9PX_O60_0_EL NULL
#define OPTION_VAL_10PX_O60_0_EL NULL
#define OPTION_VAL_11PX_O60_0_EL NULL
#define OPTION_VAL_12PX_O60_0_EL NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_EL NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_EL NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_EL NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_EL NULL
#define OPTION_VAL_0_O62_EL NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_EL NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_EL NULL
#define OPTION_VAL_239_EL "239 (Προεπιλογή)"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_EL NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_EL NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_EL NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_EL NULL
#define OPTION_VAL_287_EL "287 (Προεπιλογή)"
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_EL NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_EL NULL
#define OPTION_VAL_SYNC_EL NULL
#define OPTION_VAL_ASYNC_EL NULL
#define OPTION_VAL_PRECACHE_EL NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_EL NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_EL NULL
#define OPTION_VAL_2X_NATIVE_EL NULL
#define OPTION_VAL_6X_EL NULL
#define OPTION_VAL_10X_EL NULL
#define OPTION_VAL_12X_EL NULL
#define OPTION_VAL_14X_EL NULL

struct retro_core_option_v2_category option_cats_el[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_EL,
      CATEGORY_VIDEO_INFO_0_EL
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_EL,
      CATEGORY_OSD_INFO_0_EL
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EL,
      CATEGORY_INPUT_INFO_0_EL
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_EL,
      CATEGORY_MEMCARDS_INFO_0_EL
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_EL,
      CATEGORY_PGXP_INFO_0_EL
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EL,
      CATEGORY_HACKS_INFO_0_EL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_el[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_EL,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_EL,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_EL },
         { "2x",         OPTION_VAL_2X_EL },
         { "4x",         OPTION_VAL_4X_EL },
         { "8x",         OPTION_VAL_8X_EL },
         { "16x",        OPTION_VAL_16X_EL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_EL,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_EL,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_EL },
         { "32bpp",         OPTION_VAL_32BPP_EL },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_EL,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_EL,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_EL },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_EL },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_EL,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_EL,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_EL,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_EL,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_EL },
         { "SABR",     OPTION_VAL_SABR_EL },
         { "xBR",      OPTION_VAL_XBR_EL },
         { "bilinear", OPTION_VAL_BILINEAR_EL },
         { "3-point",  OPTION_VAL_3_POINT_EL },
         { "JINC2",    OPTION_VAL_JINC2_EL },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_EL,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_EL },
         { "all", OPTION_VAL_ALL_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_EL,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_EL },
         { "all", OPTION_VAL_ALL_EL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_EL,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_EL,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_EL,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_EL,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_EL },
         { "2x",  OPTION_VAL_2X_EL },
         { "4x",  OPTION_VAL_4X_EL },
         { "8x",  OPTION_VAL_8X_EL },
         { "16x", OPTION_VAL_16X_EL },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_EL,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_EL,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_EL,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_EL,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_EL,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_EL,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_EL,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_EL,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_EL,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_EL,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_EL,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_EL,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_EL,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_EL,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_EL },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_EL },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_EL },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_EL },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_EL },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_EL },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_EL },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_EL },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_EL },
         { "l3+r3",                    OPTION_VAL_L3_R3_EL },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_EL,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_EL,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_EL },
         { "1", OPTION_VAL_1_EL },
         { "2", OPTION_VAL_2_EL },
         { "3", OPTION_VAL_3_EL },
         { "4", OPTION_VAL_4_EL },
         { "5", OPTION_VAL_5_EL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_EL,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_EL,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_EL,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_EL,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EL },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EL },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_EL,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_EL,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_EL },
         { "dot",   OPTION_VAL_DOT_EL },
         { "off",   OPTION_VAL_OFF_EL },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_EL,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_EL,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_EL },
         { "blue", OPTION_VAL_BLUE_EL },
         { "green", OPTION_VAL_GREEN_EL },
         { "orange", OPTION_VAL_ORANGE_EL },
         { "yellow", OPTION_VAL_YELLOW_EL },
         { "cyan", OPTION_VAL_CYAN_EL },
         { "pink", OPTION_VAL_PINK_EL },
         { "purple", OPTION_VAL_PURPLE_EL },
         { "black", OPTION_VAL_BLACK_EL },
         { "white", OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_EL,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_EL,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_EL },
         { "red", OPTION_VAL_RED_EL },
         { "green", OPTION_VAL_GREEN_EL },
         { "orange", OPTION_VAL_ORANGE_EL },
         { "yellow", OPTION_VAL_YELLOW_EL },
         { "cyan", OPTION_VAL_CYAN_EL },
         { "pink", OPTION_VAL_PINK_EL },
         { "purple", OPTION_VAL_PURPLE_EL },
         { "black", OPTION_VAL_BLACK_EL },
         { "white", OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_EL,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_EL,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_EL },
         { "10%",  OPTION_VAL_10_EL },
         { "15%",  OPTION_VAL_15_EL },
         { "20%",  OPTION_VAL_20_EL },
         { "25%",  OPTION_VAL_25_EL },
         { "30%",  OPTION_VAL_30_EL },
         { "35%",  OPTION_VAL_35_EL },
         { "40%",  OPTION_VAL_40_EL },
         { "45%",  OPTION_VAL_45_EL },
         { "50%",  OPTION_VAL_50_EL },
         { "55%",  OPTION_VAL_55_EL },
         { "60%",  OPTION_VAL_60_EL },
         { "65%",  OPTION_VAL_65_EL },
         { "70%",  OPTION_VAL_70_EL },
         { "75%",  OPTION_VAL_75_EL },
         { "80%",  OPTION_VAL_80_EL },
         { "85%",  OPTION_VAL_85_EL },
         { "90%",  OPTION_VAL_90_EL },
         { "95%",  OPTION_VAL_95_EL },
         { "100%", OPTION_VAL_100_EL },
         { "105%", OPTION_VAL_105_EL },
         { "110%", OPTION_VAL_110_EL },
         { "115%", OPTION_VAL_115_EL },
         { "120%", OPTION_VAL_120_EL },
         { "125%", OPTION_VAL_125_EL },
         { "130%", OPTION_VAL_130_EL },
         { "135%", OPTION_VAL_135_EL },
         { "140%", OPTION_VAL_140_EL },
         { "145%", OPTION_VAL_145_EL },
         { "150%", OPTION_VAL_150_EL },
         { "155%", OPTION_VAL_155_EL },
         { "160%", OPTION_VAL_160_EL },
         { "165%", OPTION_VAL_165_EL },
         { "170%", OPTION_VAL_170_EL },
         { "175%", OPTION_VAL_175_EL },
         { "180%", OPTION_VAL_180_EL },
         { "185%", OPTION_VAL_185_EL },
         { "190%", OPTION_VAL_190_EL },
         { "195%", OPTION_VAL_195_EL },
         { "200%", OPTION_VAL_200_EL },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_EL,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_EL,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_EL },
         { "quadratic", OPTION_VAL_QUADRATIC_EL },
         { "cubic",     OPTION_VAL_CUBIC_EL },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_EL,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_EL,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_EL },
         { "5%",  OPTION_VAL_5_O28_EL },
         { "10%", OPTION_VAL_10_EL },
         { "15%", OPTION_VAL_15_EL },
         { "20%", OPTION_VAL_20_EL },
         { "25%", OPTION_VAL_25_EL },
         { "30%", OPTION_VAL_30_EL },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_EL,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_EL,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_EL },
         { "mednafen", OPTION_VAL_MEDNAFEN_EL },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_EL,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_EL,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_EL,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_EL,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_EL,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_EL,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_EL,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_EL,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_EL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_EL,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_EL,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_EL },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_EL,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_EL,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_EL },
         { "1px", OPTION_VAL_1PX_EL },
         { "2px", OPTION_VAL_2PX_EL },
         { "3px", OPTION_VAL_3PX_EL },
         { "4px", OPTION_VAL_4PX_EL },
         { "5px", OPTION_VAL_5PX_EL },
         { "6px", OPTION_VAL_6PX_EL },
         { "7px", OPTION_VAL_7PX_EL },
         { "8px", OPTION_VAL_8PX_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_EL,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_EL,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_EL,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_EL,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_EL,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_EL,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_EL,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_EL },
         { "aggressive", OPTION_VAL_AGGRESSIVE_EL },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_EL,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_EL,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_EL },
         { "16:10", OPTION_VAL_16_10_EL },
         { "18:9",  OPTION_VAL_18_9_EL },
         { "19:9",  OPTION_VAL_19_9_EL },
         { "20:9",  OPTION_VAL_20_9_EL },
         { "21:9",  OPTION_VAL_21_9_EL }, // 64:27
         { "32:9",  OPTION_VAL_32_9_EL },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_EL,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_EL },
         { "60%",           OPTION_VAL_60_EL },
         { "70%",           OPTION_VAL_70_EL },
         { "80%",           OPTION_VAL_80_EL },
         { "90%",           OPTION_VAL_90_EL },
         { "100%(native)", OPTION_VAL_100_NATIVE_EL },
         { "110%",          OPTION_VAL_110_EL },
         { "120%",          OPTION_VAL_120_EL },
         { "130%",          OPTION_VAL_130_EL },
         { "140%",          OPTION_VAL_140_EL },
         { "150%",          OPTION_VAL_150_EL },
         { "160%",          OPTION_VAL_160_EL },
         { "170%",          OPTION_VAL_170_EL },
         { "180%",          OPTION_VAL_180_EL },
         { "190%",          OPTION_VAL_190_EL },
         { "200%",          OPTION_VAL_200_EL },
         { "210%",          OPTION_VAL_210_EL },
         { "220%",          OPTION_VAL_220_EL },
         { "230%",          OPTION_VAL_230_EL },
         { "240%",          OPTION_VAL_240_EL },
         { "250%",          OPTION_VAL_250_EL },
         { "260%",          OPTION_VAL_260_EL },
         { "270%",          OPTION_VAL_270_EL },
         { "280%",          OPTION_VAL_280_EL },
         { "290%",          OPTION_VAL_290_EL },
         { "300%",          OPTION_VAL_300_EL },
         { "310%",          OPTION_VAL_310_EL },
         { "320%",          OPTION_VAL_320_EL },
         { "330%",          OPTION_VAL_330_EL },
         { "340%",          OPTION_VAL_340_EL },
         { "350%",          OPTION_VAL_350_EL },
         { "360%",          OPTION_VAL_360_EL },
         { "370%",          OPTION_VAL_370_EL },
         { "380%",          OPTION_VAL_380_EL },
         { "390%",          OPTION_VAL_390_EL },
         { "400%",          OPTION_VAL_400_EL },
         { "410%",          OPTION_VAL_410_EL },
         { "420%",          OPTION_VAL_420_EL },
         { "430%",          OPTION_VAL_430_EL },
         { "440%",          OPTION_VAL_440_EL },
         { "450%",          OPTION_VAL_450_EL },
         { "460%",          OPTION_VAL_460_EL },
         { "470%",          OPTION_VAL_470_EL },
         { "480%",          OPTION_VAL_480_EL },
         { "490%",          OPTION_VAL_490_EL },
         { "500%",          OPTION_VAL_500_EL },
         { "510%",          OPTION_VAL_510_EL },
         { "520%",          OPTION_VAL_520_EL },
         { "530%",          OPTION_VAL_530_EL },
         { "540%",          OPTION_VAL_540_EL },
         { "550%",          OPTION_VAL_550_EL },
         { "560%",          OPTION_VAL_560_EL },
         { "570%",          OPTION_VAL_570_EL },
         { "580%",          OPTION_VAL_580_EL },
         { "590%",          OPTION_VAL_590_EL },
         { "600%",          OPTION_VAL_600_EL },
         { "610%",          OPTION_VAL_610_EL },
         { "620%",          OPTION_VAL_620_EL },
         { "630%",          OPTION_VAL_630_EL },
         { "640%",          OPTION_VAL_640_EL },
         { "650%",          OPTION_VAL_650_EL },
         { "660%",          OPTION_VAL_660_EL },
         { "670%",          OPTION_VAL_670_EL },
         { "680%",          OPTION_VAL_680_EL },
         { "690%",          OPTION_VAL_690_EL },
         { "700%",          OPTION_VAL_700_EL },
         { "710%",          OPTION_VAL_710_EL },
         { "720%",          OPTION_VAL_720_EL },
         { "730%",          OPTION_VAL_730_EL },
         { "740%",          OPTION_VAL_740_EL },
         { "750%",          OPTION_VAL_750_EL },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_EL,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_EL },
         { "2x",         OPTION_VAL_2X_EL },
         { "4x",         OPTION_VAL_4X_EL },
         { "8x",         OPTION_VAL_8X_EL },
         { "16x",        OPTION_VAL_16X_EL },
         { "32x",        OPTION_VAL_32X_EL },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_EL,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_EL,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_EL,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_EL },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_EL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_EL,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_EL,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_EL },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_EL },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_EL },
#endif
         { "software",    OPTION_VAL_SOFTWARE_EL },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_EL,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_EL,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_EL,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_EL,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_EL },
         { "execute",  OPTION_VAL_EXECUTE_EL },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_EL },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_EL,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_EL,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_EL },
         { "dma",  OPTION_VAL_DMA_EL },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_EL,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_EL },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_EL,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_EL },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_EL,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_EL,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_EL },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_EL },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_EL },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_EL,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_EL,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_EL,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_EL },
         { "uncorrected", OPTION_VAL_UNCORRECTED_EL },
         { "4:3",  OPTION_VAL_4_3_EL },
         { "ntsc", OPTION_VAL_NTSC_EL },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_EL,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_EL },
         { "static",  OPTION_VAL_STATIC_EL },
         { "smart", OPTION_VAL_SMART_EL },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_EL,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_EL },
         { "2px",      OPTION_VAL_2PX_EL },
         { "3px",      OPTION_VAL_3PX_EL },
         { "4px",      OPTION_VAL_4PX_EL },
         { "5px",      OPTION_VAL_5PX_EL },
         { "6px",      OPTION_VAL_6PX_EL },
         { "7px",      OPTION_VAL_7PX_EL },
         { "8px",      OPTION_VAL_8PX_EL },
         { "9px",      OPTION_VAL_9PX_EL },
         { "10px",     OPTION_VAL_10PX_EL },
         { "11px",     OPTION_VAL_11PX_EL },
         { "12px",     OPTION_VAL_12PX_EL },
         { "13px",     OPTION_VAL_13PX_EL },
         { "14px",     OPTION_VAL_14PX_EL },
         { "15px",     OPTION_VAL_15PX_EL },
         { "16px",     OPTION_VAL_16PX_EL },
         { "17px",     OPTION_VAL_17PX_EL },
         { "18px",     OPTION_VAL_18PX_EL },
         { "19px",     OPTION_VAL_19PX_EL },
         { "20px",     OPTION_VAL_20PX_EL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_EL,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_EL,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_EL },
         { "-11px",    OPTION_VAL_11PX_O60_EL },
         { "-10px",    OPTION_VAL_10PX_O60_EL },
         { "-9px",     OPTION_VAL_9PX_O60_EL },
         { "-8px",     OPTION_VAL_8PX_O60_EL },
         { "-7px",     OPTION_VAL_7PX_O60_EL },
         { "-6px",     OPTION_VAL_6PX_O60_EL },
         { "-5px",     OPTION_VAL_5PX_O60_EL },
         { "-4px",     OPTION_VAL_4PX_O60_EL },
         { "-3px",     OPTION_VAL_3PX_O60_EL },
         { "-2px",     OPTION_VAL_2PX_O60_EL },
         { "-1px",     OPTION_VAL_1PX_O60_EL },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_EL },
         { "+2px",     OPTION_VAL_2PX_O60_0_EL },
         { "+3px",     OPTION_VAL_3PX_O60_0_EL },
         { "+4px",     OPTION_VAL_4PX_O60_0_EL },
         { "+5px",     OPTION_VAL_5PX_O60_0_EL },
         { "+6px",     OPTION_VAL_6PX_O60_0_EL },
         { "+7px",     OPTION_VAL_7PX_O60_0_EL },
         { "+8px",     OPTION_VAL_8PX_O60_0_EL },
         { "+9px",     OPTION_VAL_9PX_O60_0_EL },
         { "+10px",    OPTION_VAL_10PX_O60_0_EL },
         { "+11px",    OPTION_VAL_11PX_O60_0_EL },
         { "+12px",    OPTION_VAL_12PX_O60_0_EL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_EL,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_EL,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_EL,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_EL,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_EL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_EL,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_EL,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_EL },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_EL,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_EL,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_EL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_EL,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_EL,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_EL },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_EL,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_EL,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_EL },
         { "async",    OPTION_VAL_ASYNC_EL },
         { "precache", OPTION_VAL_PRECACHE_EL },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_EL,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_EL,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_EL },
         { "4x",          OPTION_VAL_4X_EL },
         { "6x",          OPTION_VAL_6X_EL },
         { "8x",          OPTION_VAL_8X_EL },
         { "10x",         OPTION_VAL_10X_EL },
         { "12x",         OPTION_VAL_12X_EL },
         { "14x",         OPTION_VAL_14X_EL },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_el = {
   option_cats_el,
   option_defs_el
};

/* RETRO_LANGUAGE_EN */

#define CATEGORY_VIDEO_LABEL_EN NULL
#define CATEGORY_VIDEO_INFO_0_EN NULL
#define CATEGORY_OSD_LABEL_EN NULL
#define CATEGORY_OSD_INFO_0_EN NULL
#define CATEGORY_INPUT_LABEL_EN NULL
#define CATEGORY_INPUT_INFO_0_EN NULL
#define CATEGORY_MEMCARDS_LABEL_EN NULL
#define CATEGORY_MEMCARDS_INFO_0_EN NULL
#define CATEGORY_PGXP_LABEL_EN NULL
#define CATEGORY_PGXP_INFO_0_EN NULL
#define CATEGORY_HACKS_LABEL_EN NULL
#define CATEGORY_HACKS_INFO_0_EN "Change processor over-clocking and emulation accuracy settings affecting low-level performance and compatibility."
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_EN NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_EN NULL
#define OPTION_VAL_1X_NATIVE_EN NULL
#define OPTION_VAL_2X_EN NULL
#define OPTION_VAL_4X_EN NULL
#define OPTION_VAL_8X_EN NULL
#define OPTION_VAL_16X_EN NULL
#define BEETLE_OPT_DEPTH_LABEL_EN "Internal Colour Depth"
#define BEETLE_OPT_DEPTH_INFO_0_EN "Choose internal colour depth. Higher colour depth can reduce colour banding effects without the use of dithering. 16 bpp emulates original hardware but may have visible banding if dithering is not enabled. 'Dithering Pattern' is recommended to be disabled when this option is set to 32 bpp."
#define OPTION_VAL_16BPP_NATIVE_EN NULL
#define OPTION_VAL_32BPP_EN NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_EN NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_EN "Choose dithering pattern configuration. '1x (Native)' emulates native low resolution dithering used by original hardware to smooth out colour banding artefacts visible at native colour depth. 'Internal Resolution' scales dithering granularity to the configured internal resolution for cleaner results. Recommended to be disabled when running at 32 bpp colour depth. Note: On Vulkan, enabling this will force downsampling to native colour depth, while disabling will automatically enable output at higher colour depth."
#define OPTION_VAL_INTERNAL_RESOLUTION_EN NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_EN NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_EN NULL
#define BEETLE_OPT_FILTER_LABEL_EN NULL
#define BEETLE_OPT_FILTER_INFO_0_EN "Choose the texture filtering method. 'Nearest' emulates the original hardware. 'Bilinear' and '3-Point' are smoothing filters, which reduce pixelation with blurring. 'SABR', 'xBR', and 'JINC2' are upscaling filters that may improve texture fidelity/sharpness at the expense of increased performance requirements. This is only supported by the hardware renderers."
#define OPTION_VAL_NEAREST_EN NULL
#define OPTION_VAL_SABR_EN NULL
#define OPTION_VAL_XBR_EN NULL
#define OPTION_VAL_BILINEAR_EN NULL
#define OPTION_VAL_3_POINT_EN NULL
#define OPTION_VAL_JINC2_EN NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_EN NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_EN "Do not apply texture filtering to sprites. That prevents seams in various games with 2D sprite-rendered backgrounds. Use together with Adaptive Smoothing or another post-processing filter for best effect."
#define OPTION_VAL_OPAQUE_EN NULL
#define OPTION_VAL_ALL_EN NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_EN NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_EN NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_EN NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_EN NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_EN "Super-sampling (Downsample to Native Resolution)"
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_EN NULL
#define BEETLE_OPT_MSAA_LABEL_EN NULL
#define BEETLE_OPT_MSAA_INFO_0_EN NULL
#define OPTION_VAL_1X_EN NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_EN NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_EN "Improve the quality of FMV playback by reducing 'macro-blocking' artefacts (squares/jagged edges). Only supported by the Vulkan renderer."
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_EN NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_EN NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_EN NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_EN NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_EN NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_EN NULL
#define BEETLE_OPT_WIREFRAME_LABEL_EN NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_EN NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_EN "Frame Duping (Speed-up)"
#define BEETLE_OPT_FRAME_DUPING_INFO_0_EN "When enabled and supported by the libretro frontend, this provides a small performance increase by directing the front-end to repeat the previous frame if the core has nothing new to display."
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_EN NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_EN "Display the internal frame rate at which the emulated PlayStation system is rendering content. Note: Requires on-screen notifications to be enabled in the libretro front-end."
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_EN NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_EN "Visualise the entire emulated console's VRAM. Only supported by the OpenGL and Vulkan hardware renderers. Note: This is for debugging purposes, and should normally be disabled."
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_EN "Analogue Self-Calibration"
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_EN "When the input device is set to DualShock, Analogue Controller, Analogue Joystick, or neGcon, this option enables dynamic calibration of analogue inputs. Maximum registered input values are monitored in real time and used to scale analogue coordinates passed to the emulator. This should be used for games such as Mega Man Legends 2 that expect larger values than what modern controllers provide. For best results, analogue sticks should be rotated at full extent to tune the calibration algorithm each time content is loaded."
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_EN NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_EN NULL
#define OPTION_VAL_ENABLED_ANALOG_EN NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_EN NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_EN NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_EN NULL
#define OPTION_VAL_L1_R1_SELECT_EN NULL
#define OPTION_VAL_L1_R1_START_EN NULL
#define OPTION_VAL_L1_R1_L3_EN NULL
#define OPTION_VAL_L1_R1_R3_EN NULL
#define OPTION_VAL_L2_R2_SELECT_EN NULL
#define OPTION_VAL_L2_R2_START_EN NULL
#define OPTION_VAL_L2_R2_L3_EN NULL
#define OPTION_VAL_L2_R2_R3_EN NULL
#define OPTION_VAL_L3_R3_EN NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_EN NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_EN NULL
#define OPTION_VAL_0_EN NULL
#define OPTION_VAL_1_EN NULL
#define OPTION_VAL_2_EN NULL
#define OPTION_VAL_3_EN NULL
#define OPTION_VAL_4_EN NULL
#define OPTION_VAL_5_EN NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_EN "Port 1: Multi-tap Enable"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_EN "Enable multi-tap functionality on port 1."
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_EN "Port 2: Multi-tap Enable"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_EN "Enable multi-tap functionality on port 2."
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_EN NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_EN "Choose whether to use a mouse-controlled 'Light Gun' or a 'Touchscreen' input when device type is set to 'Gun-con/G-Con 45' or 'Justifier'."
#define OPTION_VAL_LIGHTGUN_EN NULL
#define OPTION_VAL_TOUCHSCREEN_EN NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_EN NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_EN "Choose the gun cursor to be displayed on screen while using the 'Gun-con/G-Con 45' and 'Justifier' input device types. When disabled, cross-hairs are always hidden."
#define OPTION_VAL_CROSS_EN NULL
#define OPTION_VAL_DOT_EN NULL
#define OPTION_VAL_OFF_EN NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_EN "Port 1: Gun Cross-hair Colour"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_EN "Choose the light gun cross-hair colour for port 1."
#define OPTION_VAL_RED_EN NULL
#define OPTION_VAL_BLUE_EN NULL
#define OPTION_VAL_GREEN_EN NULL
#define OPTION_VAL_ORANGE_EN NULL
#define OPTION_VAL_YELLOW_EN NULL
#define OPTION_VAL_CYAN_EN NULL
#define OPTION_VAL_PINK_EN NULL
#define OPTION_VAL_PURPLE_EN NULL
#define OPTION_VAL_BLACK_EN NULL
#define OPTION_VAL_WHITE_EN NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_EN "Port 2: Gun Cross-hair Colour"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_EN "Choose the light gun cross-hair colour for port 2."
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_EN NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_EN NULL
#define OPTION_VAL_5_O28_EN NULL
#define OPTION_VAL_10_EN NULL
#define OPTION_VAL_15_EN NULL
#define OPTION_VAL_20_EN NULL
#define OPTION_VAL_25_EN NULL
#define OPTION_VAL_30_EN NULL
#define OPTION_VAL_35_EN NULL
#define OPTION_VAL_40_EN NULL
#define OPTION_VAL_45_EN NULL
#define OPTION_VAL_50_EN NULL
#define OPTION_VAL_55_EN NULL
#define OPTION_VAL_60_EN NULL
#define OPTION_VAL_65_EN NULL
#define OPTION_VAL_70_EN NULL
#define OPTION_VAL_75_EN NULL
#define OPTION_VAL_80_EN NULL
#define OPTION_VAL_85_EN NULL
#define OPTION_VAL_90_EN NULL
#define OPTION_VAL_95_EN NULL
#define OPTION_VAL_100_EN NULL
#define OPTION_VAL_105_EN NULL
#define OPTION_VAL_110_EN NULL
#define OPTION_VAL_115_EN NULL
#define OPTION_VAL_120_EN NULL
#define OPTION_VAL_125_EN NULL
#define OPTION_VAL_130_EN NULL
#define OPTION_VAL_135_EN NULL
#define OPTION_VAL_140_EN NULL
#define OPTION_VAL_145_EN NULL
#define OPTION_VAL_150_EN NULL
#define OPTION_VAL_155_EN NULL
#define OPTION_VAL_160_EN NULL
#define OPTION_VAL_165_EN NULL
#define OPTION_VAL_170_EN NULL
#define OPTION_VAL_175_EN NULL
#define OPTION_VAL_180_EN NULL
#define OPTION_VAL_185_EN NULL
#define OPTION_VAL_190_EN NULL
#define OPTION_VAL_195_EN NULL
#define OPTION_VAL_200_EN NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_EN NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_EN "Choose the response type of the RetroPad left analogue stick when simulating the 'twist' action of emulated 'neGcon' input devices. Analogue stick displacement may be mapped to neGcon rotation angle either linearly, quadratically or cubically. 'Quadratic' allows for greater precision than 'Linear' when making small movements. 'Cubic' further increases small movement precision, but 'exaggerates' larger movements. Note: 'Linear' is only recommended when using racing wheel peripherals. Conventional controllers implement analogue input in a manner fundamentally different from the neGcon 'twist' mechanism, such that linear mapping over-amplifies small movements, impairing fine control. In most cases, 'Quadratic' provides the closest approximation of real hardware."
#define OPTION_VAL_LINEAR_EN NULL
#define OPTION_VAL_QUADRATIC_EN NULL
#define OPTION_VAL_CUBIC_EN NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_EN "neGcon Twist Dead-zone"
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_EN "Choose the dead-zone of the RetroPad left analogue stick when simulating the 'twist' action of emulated 'neGcon' input devices. Used to eliminate controller drift. Note: Most neGcon-compatible titles provide in-game options for setting a 'twist' dead-zone value. To avoid loss of precision, the in-game dead-zone should *always* be set to zero. Any required adjustments should *only* be applied with this core option. This is particularly important when 'neGcon Twist Response' is set to 'Quadratic' or 'Cubic'."
#define OPTION_VAL_0_O30_EN NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_EN NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_EN "Choose the save data format used for memory card 0. 'Mednafen' may be used for compatibility with the stand-alone version of Mednafen. When used with Beetle PSX, Libretro (.srm) and Mednafen (.mcr) saves have internally identical formats and can be converted between one another with renaming."
#define OPTION_VAL_LIBRETRO_EN NULL
#define OPTION_VAL_MEDNAFEN_EN NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_EN NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_EN NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_EN NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_EN NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_EN NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_EN NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_EN NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_EN NULL
#define OPTION_VAL_1_O35_EN NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_EN NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_EN "Allows 3D objects to be rendered with sub-pixel precision, minimising distortion and jitter of 3D objects seen on original hardware due to the usage of fixed point vertex coordinates. 'Memory Only' mode has minimal compatibility issues and is recommended for general use. 'Memory + CPU (Buggy)' mode can reduce jitter even further but has high performance requirements and may cause various geometry errors."
#define OPTION_VAL_MEMORY_ONLY_EN NULL
#define OPTION_VAL_MEMORY_CPU_EN NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_EN NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_EN NULL
#define OPTION_VAL_0PX_EN NULL
#define OPTION_VAL_1PX_EN NULL
#define OPTION_VAL_2PX_EN NULL
#define OPTION_VAL_3PX_EN NULL
#define OPTION_VAL_4PX_EN NULL
#define OPTION_VAL_5PX_EN NULL
#define OPTION_VAL_6PX_EN NULL
#define OPTION_VAL_7PX_EN NULL
#define OPTION_VAL_8PX_EN NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_EN NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_EN NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_EN NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_EN NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_EN NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_EN "Replace native PS1 affine texture mapping with perspective correct texture mapping. Eliminates position-dependent distortion and warping of textures, resulting in properly aligned textures. This option is applied only when PGXP Operation Mode is enabled. Only supported by the hardware renderers."
#define BEETLE_OPT_LINE_RENDER_LABEL_EN NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_EN NULL
#define OPTION_VAL_DEFAULT_EN NULL
#define OPTION_VAL_AGGRESSIVE_EN NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_EN NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_EN "Render 3D content in an anamorphic format and output the emulated frame-buffer at a widescreen aspect ratio. Produces the best results with fully 3D games. 2D elements will be horizontally stretched and may be misaligned."
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_EN NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_EN NULL
#define OPTION_VAL_16_9_EN NULL
#define OPTION_VAL_16_10_EN NULL
#define OPTION_VAL_18_9_EN NULL
#define OPTION_VAL_19_9_EN NULL
#define OPTION_VAL_20_9_EN NULL
#define OPTION_VAL_21_9_EN NULL
#define OPTION_VAL_32_9_EN NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_EN "CPU Frequency Scaling (Over-clock)"
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_EN "Over-clock (or under-clock) the emulated PS1 CPU. Overclocking can eliminate slowdown and improve frame rates in certain games at the expense of increased performance requirements. Note that some games have an internal frame rate limiter and may not benefit from overclocking. May cause certain effects to animate faster than intended in some titles when overclocked."
#define OPTION_VAL_100_NATIVE_EN NULL
#define OPTION_VAL_210_EN NULL
#define OPTION_VAL_220_EN NULL
#define OPTION_VAL_230_EN NULL
#define OPTION_VAL_240_EN NULL
#define OPTION_VAL_250_EN NULL
#define OPTION_VAL_260_EN NULL
#define OPTION_VAL_270_EN NULL
#define OPTION_VAL_280_EN NULL
#define OPTION_VAL_290_EN NULL
#define OPTION_VAL_300_EN NULL
#define OPTION_VAL_310_EN NULL
#define OPTION_VAL_320_EN NULL
#define OPTION_VAL_330_EN NULL
#define OPTION_VAL_340_EN NULL
#define OPTION_VAL_350_EN NULL
#define OPTION_VAL_360_EN NULL
#define OPTION_VAL_370_EN NULL
#define OPTION_VAL_380_EN NULL
#define OPTION_VAL_390_EN NULL
#define OPTION_VAL_400_EN NULL
#define OPTION_VAL_410_EN NULL
#define OPTION_VAL_420_EN NULL
#define OPTION_VAL_430_EN NULL
#define OPTION_VAL_440_EN NULL
#define OPTION_VAL_450_EN NULL
#define OPTION_VAL_460_EN NULL
#define OPTION_VAL_470_EN NULL
#define OPTION_VAL_480_EN NULL
#define OPTION_VAL_490_EN NULL
#define OPTION_VAL_500_EN NULL
#define OPTION_VAL_510_EN NULL
#define OPTION_VAL_520_EN NULL
#define OPTION_VAL_530_EN NULL
#define OPTION_VAL_540_EN NULL
#define OPTION_VAL_550_EN NULL
#define OPTION_VAL_560_EN NULL
#define OPTION_VAL_570_EN NULL
#define OPTION_VAL_580_EN NULL
#define OPTION_VAL_590_EN NULL
#define OPTION_VAL_600_EN NULL
#define OPTION_VAL_610_EN NULL
#define OPTION_VAL_620_EN NULL
#define OPTION_VAL_630_EN NULL
#define OPTION_VAL_640_EN NULL
#define OPTION_VAL_650_EN NULL
#define OPTION_VAL_660_EN NULL
#define OPTION_VAL_670_EN NULL
#define OPTION_VAL_680_EN NULL
#define OPTION_VAL_690_EN NULL
#define OPTION_VAL_700_EN NULL
#define OPTION_VAL_710_EN NULL
#define OPTION_VAL_720_EN NULL
#define OPTION_VAL_730_EN NULL
#define OPTION_VAL_740_EN NULL
#define OPTION_VAL_750_EN NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_EN "GPU Rasteriser Over-clock"
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_EN "Enable over-clocking of the 2D rasteriser contained within the emulated PS1's GPU. Does not improve 3D rendering, and in general has little effect."
#define OPTION_VAL_32X_EN NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_EN "GTE Over-clock"
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_EN NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_EN NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_EN NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_EN NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_EN NULL
#define OPTION_VAL_PSXONPSP_EN NULL
#define OPTION_VAL_PS1_ROM_EN NULL
#define BEETLE_OPT_RENDERER_LABEL_EN NULL
#define BEETLE_OPT_RENDERER_INFO_0_EN "The software renderer is the most accurate but has steep performance requirements when running at increased internal GPU resolutions. The hardware renderers, while less accurate, improve performance over the software renderer at increased internal resolutions and enable various graphical enhancements. 'Hardware (Auto)' automatically selects the Vulkan or OpenGL renderer, depending upon the current libretro front-end video driver. If the provided video driver is not Vulkan or OpenGL 3.3-compatible, then the core will fall back to the software renderer."
#define OPTION_VAL_HARDWARE_EN NULL
#define OPTION_VAL_HARDWARE_GL_EN NULL
#define OPTION_VAL_HARDWARE_VK_EN NULL
#define OPTION_VAL_SOFTWARE_EN NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_EN "Software Frame-buffer"
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_EN "Enable accurate emulation of frame-buffer effects (e.g. motion blur, FF7 battle swirl) when using hardware renderers by running a copy of the software renderer at native resolution in the background. If disabled, these operations are omitted (OpenGL) or rendered on the GPU (Vulkan). Disabling can improve performance but may cause severe graphical errors. Leave enabled if unsure."
#define BEETLE_OPT_CPU_DYNAREC_LABEL_EN "CPU Dyna-rec"
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_EN "Dynamically recompile CPU instructions to native instructions. Much faster than the interpreter, but CPU timing is less accurate, and may have bugs."
#define OPTION_VAL_DISABLED_EN NULL
#define OPTION_VAL_EXECUTE_EN "Maximum Performance"
#define OPTION_VAL_EXECUTE_ONE_EN NULL
#define OPTION_VAL_RUN_INTERPRETER_EN "Light-rec Interpreter"
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_EN "Dyna-rec Code Invalidation"
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_EN NULL
#define OPTION_VAL_FULL_EN NULL
#define OPTION_VAL_DMA_EN NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_EN NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_EN NULL
#define OPTION_VAL_128_EN NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_EN NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_EN NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_EN NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_EN "Choose the FPS timing that the core will report to the front-end. Automatic Toggling will allow the core to switch between reporting progressive and interlaced rates, but may cause front-end video/audio driver re-initialisations."
#define OPTION_VAL_FORCE_PROGRESSIVE_EN NULL
#define OPTION_VAL_FORCE_INTERLACED_EN NULL
#define OPTION_VAL_AUTO_TOGGLE_EN NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_EN NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_EN "Due to different standards, PAL games often appear slowed down compared to the American or Japanese NTSC releases. This option can be used to override PAL timings in order to attempt to run these games with the NTSC frame-rate. This option has no effect when running NTSC content."
#define BEETLE_OPT_ASPECT_RATIO_LABEL_EN NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_EN NULL
#define OPTION_VAL_CORRECTED_EN NULL
#define OPTION_VAL_UNCORRECTED_EN NULL
#define OPTION_VAL_4_3_EN NULL
#define OPTION_VAL_NTSC_EN NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_EN NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_EN "'None' retains padding (pillar-boxes on either side of the image for NTSC, on all sides for PAL) to emulate the same black bars generated in analogue video output by real PS1 hardware. 'Static' only removes horizontal padding, 'Dynamic' removes all padding."
#define OPTION_VAL_DISABLED_O58_EN NULL
#define OPTION_VAL_STATIC_EN NULL
#define OPTION_VAL_SMART_EN NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_EN NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_EN NULL
#define OPTION_VAL_9PX_EN NULL
#define OPTION_VAL_10PX_EN NULL
#define OPTION_VAL_11PX_EN NULL
#define OPTION_VAL_12PX_EN NULL
#define OPTION_VAL_13PX_EN NULL
#define OPTION_VAL_14PX_EN NULL
#define OPTION_VAL_15PX_EN NULL
#define OPTION_VAL_16PX_EN NULL
#define OPTION_VAL_17PX_EN NULL
#define OPTION_VAL_18PX_EN NULL
#define OPTION_VAL_19PX_EN NULL
#define OPTION_VAL_20PX_EN NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_EN NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_EN NULL
#define OPTION_VAL_12PX_O60_EN NULL
#define OPTION_VAL_11PX_O60_EN NULL
#define OPTION_VAL_10PX_O60_EN NULL
#define OPTION_VAL_9PX_O60_EN NULL
#define OPTION_VAL_8PX_O60_EN NULL
#define OPTION_VAL_7PX_O60_EN NULL
#define OPTION_VAL_6PX_O60_EN NULL
#define OPTION_VAL_5PX_O60_EN NULL
#define OPTION_VAL_4PX_O60_EN NULL
#define OPTION_VAL_3PX_O60_EN NULL
#define OPTION_VAL_2PX_O60_EN NULL
#define OPTION_VAL_1PX_O60_EN NULL
#define OPTION_VAL_1PX_O60_0_EN NULL
#define OPTION_VAL_2PX_O60_0_EN NULL
#define OPTION_VAL_3PX_O60_0_EN NULL
#define OPTION_VAL_4PX_O60_0_EN NULL
#define OPTION_VAL_5PX_O60_0_EN NULL
#define OPTION_VAL_6PX_O60_0_EN NULL
#define OPTION_VAL_7PX_O60_0_EN NULL
#define OPTION_VAL_8PX_O60_0_EN NULL
#define OPTION_VAL_9PX_O60_0_EN NULL
#define OPTION_VAL_10PX_O60_0_EN NULL
#define OPTION_VAL_11PX_O60_0_EN NULL
#define OPTION_VAL_12PX_O60_0_EN NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_EN NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_EN NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_EN NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_EN "Choose the first displayed scan line when running NTSC content. Values greater than zero will reduce the height of output images by cropping pixels from the topmost edge. May be used to counteract letter-boxing."
#define OPTION_VAL_0_O62_EN NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_EN NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_EN "Choose the last displayed scan line when running NTSC content. Values less than 239 will reduce the height of output images by cropping pixels from the bottommost edge. May be used to counteract letter-boxing."
#define OPTION_VAL_239_EN NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_EN NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_EN "Choose the first displayed scan line when running PAL content. Values greater than zero will reduce the height of output images by cropping pixels from the topmost edge. May be used to counteract letter-boxing."
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_EN NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_EN "Choose the last displayed scan line when running PAL content. Values below 287 will reduce the height of output images by cropping pixels from the bottommost edge. May be used to counteract letter-boxing."
#define OPTION_VAL_287_EN NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_EN NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_EN "Choose the method used to read data from content disk images. 'Synchronous' mimics original hardware. 'Asynchronous' can reduce stuttering on devices with slow storage. 'Pre-Cache' loads the entire disk image into memory when launching content, which may improve in-game loading times at the cost of an initial delay at start-up. 'Pre-Cache' may cause issues on systems with low RAM, and will fall back to 'Synchronous' for physical media."
#define OPTION_VAL_SYNC_EN NULL
#define OPTION_VAL_ASYNC_EN NULL
#define OPTION_VAL_PRECACHE_EN NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_EN NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_EN NULL
#define OPTION_VAL_2X_NATIVE_EN NULL
#define OPTION_VAL_6X_EN NULL
#define OPTION_VAL_10X_EN NULL
#define OPTION_VAL_12X_EN NULL
#define OPTION_VAL_14X_EN NULL

struct retro_core_option_v2_category option_cats_en[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_EN,
      CATEGORY_VIDEO_INFO_0_EN
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_EN,
      CATEGORY_OSD_INFO_0_EN
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EN,
      CATEGORY_INPUT_INFO_0_EN
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_EN,
      CATEGORY_MEMCARDS_INFO_0_EN
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_EN,
      CATEGORY_PGXP_INFO_0_EN
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EN,
      CATEGORY_HACKS_INFO_0_EN
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_en[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_EN,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_EN,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_EN },
         { "2x",         OPTION_VAL_2X_EN },
         { "4x",         OPTION_VAL_4X_EN },
         { "8x",         OPTION_VAL_8X_EN },
         { "16x",        OPTION_VAL_16X_EN },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_EN,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_EN,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_EN },
         { "32bpp",         OPTION_VAL_32BPP_EN },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_EN,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_EN,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_EN },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_EN },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_EN,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_EN,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_EN,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_EN,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_EN },
         { "SABR",     OPTION_VAL_SABR_EN },
         { "xBR",      OPTION_VAL_XBR_EN },
         { "bilinear", OPTION_VAL_BILINEAR_EN },
         { "3-point",  OPTION_VAL_3_POINT_EN },
         { "JINC2",    OPTION_VAL_JINC2_EN },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_EN,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_EN },
         { "all", OPTION_VAL_ALL_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_EN,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_EN },
         { "all", OPTION_VAL_ALL_EN },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_EN,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_EN,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_EN,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_EN,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_EN },
         { "2x",  OPTION_VAL_2X_EN },
         { "4x",  OPTION_VAL_4X_EN },
         { "8x",  OPTION_VAL_8X_EN },
         { "16x", OPTION_VAL_16X_EN },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_EN,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_EN,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_EN,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_EN,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_EN,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_EN,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_EN,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_EN,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_EN,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_EN,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_EN,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_EN,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_EN,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_EN,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_EN },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_EN },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_EN },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_EN },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_EN },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_EN },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_EN },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_EN },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_EN },
         { "l3+r3",                    OPTION_VAL_L3_R3_EN },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_EN,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_EN,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_EN },
         { "1", OPTION_VAL_1_EN },
         { "2", OPTION_VAL_2_EN },
         { "3", OPTION_VAL_3_EN },
         { "4", OPTION_VAL_4_EN },
         { "5", OPTION_VAL_5_EN },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_EN,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_EN,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_EN,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_EN,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EN },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EN },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_EN,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_EN,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_EN },
         { "dot",   OPTION_VAL_DOT_EN },
         { "off",   OPTION_VAL_OFF_EN },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_EN,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_EN,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_EN },
         { "blue", OPTION_VAL_BLUE_EN },
         { "green", OPTION_VAL_GREEN_EN },
         { "orange", OPTION_VAL_ORANGE_EN },
         { "yellow", OPTION_VAL_YELLOW_EN },
         { "cyan", OPTION_VAL_CYAN_EN },
         { "pink", OPTION_VAL_PINK_EN },
         { "purple", OPTION_VAL_PURPLE_EN },
         { "black", OPTION_VAL_BLACK_EN },
         { "white", OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_EN,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_EN,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_EN },
         { "red", OPTION_VAL_RED_EN },
         { "green", OPTION_VAL_GREEN_EN },
         { "orange", OPTION_VAL_ORANGE_EN },
         { "yellow", OPTION_VAL_YELLOW_EN },
         { "cyan", OPTION_VAL_CYAN_EN },
         { "pink", OPTION_VAL_PINK_EN },
         { "purple", OPTION_VAL_PURPLE_EN },
         { "black", OPTION_VAL_BLACK_EN },
         { "white", OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_EN,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_EN,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_EN },
         { "10%",  OPTION_VAL_10_EN },
         { "15%",  OPTION_VAL_15_EN },
         { "20%",  OPTION_VAL_20_EN },
         { "25%",  OPTION_VAL_25_EN },
         { "30%",  OPTION_VAL_30_EN },
         { "35%",  OPTION_VAL_35_EN },
         { "40%",  OPTION_VAL_40_EN },
         { "45%",  OPTION_VAL_45_EN },
         { "50%",  OPTION_VAL_50_EN },
         { "55%",  OPTION_VAL_55_EN },
         { "60%",  OPTION_VAL_60_EN },
         { "65%",  OPTION_VAL_65_EN },
         { "70%",  OPTION_VAL_70_EN },
         { "75%",  OPTION_VAL_75_EN },
         { "80%",  OPTION_VAL_80_EN },
         { "85%",  OPTION_VAL_85_EN },
         { "90%",  OPTION_VAL_90_EN },
         { "95%",  OPTION_VAL_95_EN },
         { "100%", OPTION_VAL_100_EN },
         { "105%", OPTION_VAL_105_EN },
         { "110%", OPTION_VAL_110_EN },
         { "115%", OPTION_VAL_115_EN },
         { "120%", OPTION_VAL_120_EN },
         { "125%", OPTION_VAL_125_EN },
         { "130%", OPTION_VAL_130_EN },
         { "135%", OPTION_VAL_135_EN },
         { "140%", OPTION_VAL_140_EN },
         { "145%", OPTION_VAL_145_EN },
         { "150%", OPTION_VAL_150_EN },
         { "155%", OPTION_VAL_155_EN },
         { "160%", OPTION_VAL_160_EN },
         { "165%", OPTION_VAL_165_EN },
         { "170%", OPTION_VAL_170_EN },
         { "175%", OPTION_VAL_175_EN },
         { "180%", OPTION_VAL_180_EN },
         { "185%", OPTION_VAL_185_EN },
         { "190%", OPTION_VAL_190_EN },
         { "195%", OPTION_VAL_195_EN },
         { "200%", OPTION_VAL_200_EN },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_EN,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_EN,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_EN },
         { "quadratic", OPTION_VAL_QUADRATIC_EN },
         { "cubic",     OPTION_VAL_CUBIC_EN },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_EN,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_EN,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_EN },
         { "5%",  OPTION_VAL_5_O28_EN },
         { "10%", OPTION_VAL_10_EN },
         { "15%", OPTION_VAL_15_EN },
         { "20%", OPTION_VAL_20_EN },
         { "25%", OPTION_VAL_25_EN },
         { "30%", OPTION_VAL_30_EN },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_EN,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_EN,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_EN },
         { "mednafen", OPTION_VAL_MEDNAFEN_EN },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_EN,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_EN,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_EN,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_EN,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_EN,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_EN,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_EN,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_EN,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_EN },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_EN,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_EN,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_EN },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_EN,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_EN,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_EN },
         { "1px", OPTION_VAL_1PX_EN },
         { "2px", OPTION_VAL_2PX_EN },
         { "3px", OPTION_VAL_3PX_EN },
         { "4px", OPTION_VAL_4PX_EN },
         { "5px", OPTION_VAL_5PX_EN },
         { "6px", OPTION_VAL_6PX_EN },
         { "7px", OPTION_VAL_7PX_EN },
         { "8px", OPTION_VAL_8PX_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_EN,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_EN,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_EN,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_EN,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_EN,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_EN,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_EN,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_EN },
         { "aggressive", OPTION_VAL_AGGRESSIVE_EN },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_EN,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_EN,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_EN },
         { "16:10", OPTION_VAL_16_10_EN },
         { "18:9",  OPTION_VAL_18_9_EN },
         { "19:9",  OPTION_VAL_19_9_EN },
         { "20:9",  OPTION_VAL_20_9_EN },
         { "21:9",  OPTION_VAL_21_9_EN }, // 64:27
         { "32:9",  OPTION_VAL_32_9_EN },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_EN,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_EN },
         { "60%",           OPTION_VAL_60_EN },
         { "70%",           OPTION_VAL_70_EN },
         { "80%",           OPTION_VAL_80_EN },
         { "90%",           OPTION_VAL_90_EN },
         { "100%(native)", OPTION_VAL_100_NATIVE_EN },
         { "110%",          OPTION_VAL_110_EN },
         { "120%",          OPTION_VAL_120_EN },
         { "130%",          OPTION_VAL_130_EN },
         { "140%",          OPTION_VAL_140_EN },
         { "150%",          OPTION_VAL_150_EN },
         { "160%",          OPTION_VAL_160_EN },
         { "170%",          OPTION_VAL_170_EN },
         { "180%",          OPTION_VAL_180_EN },
         { "190%",          OPTION_VAL_190_EN },
         { "200%",          OPTION_VAL_200_EN },
         { "210%",          OPTION_VAL_210_EN },
         { "220%",          OPTION_VAL_220_EN },
         { "230%",          OPTION_VAL_230_EN },
         { "240%",          OPTION_VAL_240_EN },
         { "250%",          OPTION_VAL_250_EN },
         { "260%",          OPTION_VAL_260_EN },
         { "270%",          OPTION_VAL_270_EN },
         { "280%",          OPTION_VAL_280_EN },
         { "290%",          OPTION_VAL_290_EN },
         { "300%",          OPTION_VAL_300_EN },
         { "310%",          OPTION_VAL_310_EN },
         { "320%",          OPTION_VAL_320_EN },
         { "330%",          OPTION_VAL_330_EN },
         { "340%",          OPTION_VAL_340_EN },
         { "350%",          OPTION_VAL_350_EN },
         { "360%",          OPTION_VAL_360_EN },
         { "370%",          OPTION_VAL_370_EN },
         { "380%",          OPTION_VAL_380_EN },
         { "390%",          OPTION_VAL_390_EN },
         { "400%",          OPTION_VAL_400_EN },
         { "410%",          OPTION_VAL_410_EN },
         { "420%",          OPTION_VAL_420_EN },
         { "430%",          OPTION_VAL_430_EN },
         { "440%",          OPTION_VAL_440_EN },
         { "450%",          OPTION_VAL_450_EN },
         { "460%",          OPTION_VAL_460_EN },
         { "470%",          OPTION_VAL_470_EN },
         { "480%",          OPTION_VAL_480_EN },
         { "490%",          OPTION_VAL_490_EN },
         { "500%",          OPTION_VAL_500_EN },
         { "510%",          OPTION_VAL_510_EN },
         { "520%",          OPTION_VAL_520_EN },
         { "530%",          OPTION_VAL_530_EN },
         { "540%",          OPTION_VAL_540_EN },
         { "550%",          OPTION_VAL_550_EN },
         { "560%",          OPTION_VAL_560_EN },
         { "570%",          OPTION_VAL_570_EN },
         { "580%",          OPTION_VAL_580_EN },
         { "590%",          OPTION_VAL_590_EN },
         { "600%",          OPTION_VAL_600_EN },
         { "610%",          OPTION_VAL_610_EN },
         { "620%",          OPTION_VAL_620_EN },
         { "630%",          OPTION_VAL_630_EN },
         { "640%",          OPTION_VAL_640_EN },
         { "650%",          OPTION_VAL_650_EN },
         { "660%",          OPTION_VAL_660_EN },
         { "670%",          OPTION_VAL_670_EN },
         { "680%",          OPTION_VAL_680_EN },
         { "690%",          OPTION_VAL_690_EN },
         { "700%",          OPTION_VAL_700_EN },
         { "710%",          OPTION_VAL_710_EN },
         { "720%",          OPTION_VAL_720_EN },
         { "730%",          OPTION_VAL_730_EN },
         { "740%",          OPTION_VAL_740_EN },
         { "750%",          OPTION_VAL_750_EN },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_EN,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_EN },
         { "2x",         OPTION_VAL_2X_EN },
         { "4x",         OPTION_VAL_4X_EN },
         { "8x",         OPTION_VAL_8X_EN },
         { "16x",        OPTION_VAL_16X_EN },
         { "32x",        OPTION_VAL_32X_EN },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_EN,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_EN,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_EN,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_EN },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_EN },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_EN,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_EN,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_EN },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_EN },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_EN },
#endif
         { "software",    OPTION_VAL_SOFTWARE_EN },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_EN,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_EN,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_EN,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_EN,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_EN },
         { "execute",  OPTION_VAL_EXECUTE_EN },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_EN },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_EN,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_EN,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_EN },
         { "dma",  OPTION_VAL_DMA_EN },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_EN,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_EN },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_EN,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_EN },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_EN,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_EN,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_EN },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_EN },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_EN },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_EN,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_EN,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_EN,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_EN },
         { "uncorrected", OPTION_VAL_UNCORRECTED_EN },
         { "4:3",  OPTION_VAL_4_3_EN },
         { "ntsc", OPTION_VAL_NTSC_EN },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_EN,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_EN },
         { "static",  OPTION_VAL_STATIC_EN },
         { "smart", OPTION_VAL_SMART_EN },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_EN,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_EN },
         { "2px",      OPTION_VAL_2PX_EN },
         { "3px",      OPTION_VAL_3PX_EN },
         { "4px",      OPTION_VAL_4PX_EN },
         { "5px",      OPTION_VAL_5PX_EN },
         { "6px",      OPTION_VAL_6PX_EN },
         { "7px",      OPTION_VAL_7PX_EN },
         { "8px",      OPTION_VAL_8PX_EN },
         { "9px",      OPTION_VAL_9PX_EN },
         { "10px",     OPTION_VAL_10PX_EN },
         { "11px",     OPTION_VAL_11PX_EN },
         { "12px",     OPTION_VAL_12PX_EN },
         { "13px",     OPTION_VAL_13PX_EN },
         { "14px",     OPTION_VAL_14PX_EN },
         { "15px",     OPTION_VAL_15PX_EN },
         { "16px",     OPTION_VAL_16PX_EN },
         { "17px",     OPTION_VAL_17PX_EN },
         { "18px",     OPTION_VAL_18PX_EN },
         { "19px",     OPTION_VAL_19PX_EN },
         { "20px",     OPTION_VAL_20PX_EN },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_EN,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_EN,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_EN },
         { "-11px",    OPTION_VAL_11PX_O60_EN },
         { "-10px",    OPTION_VAL_10PX_O60_EN },
         { "-9px",     OPTION_VAL_9PX_O60_EN },
         { "-8px",     OPTION_VAL_8PX_O60_EN },
         { "-7px",     OPTION_VAL_7PX_O60_EN },
         { "-6px",     OPTION_VAL_6PX_O60_EN },
         { "-5px",     OPTION_VAL_5PX_O60_EN },
         { "-4px",     OPTION_VAL_4PX_O60_EN },
         { "-3px",     OPTION_VAL_3PX_O60_EN },
         { "-2px",     OPTION_VAL_2PX_O60_EN },
         { "-1px",     OPTION_VAL_1PX_O60_EN },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_EN },
         { "+2px",     OPTION_VAL_2PX_O60_0_EN },
         { "+3px",     OPTION_VAL_3PX_O60_0_EN },
         { "+4px",     OPTION_VAL_4PX_O60_0_EN },
         { "+5px",     OPTION_VAL_5PX_O60_0_EN },
         { "+6px",     OPTION_VAL_6PX_O60_0_EN },
         { "+7px",     OPTION_VAL_7PX_O60_0_EN },
         { "+8px",     OPTION_VAL_8PX_O60_0_EN },
         { "+9px",     OPTION_VAL_9PX_O60_0_EN },
         { "+10px",    OPTION_VAL_10PX_O60_0_EN },
         { "+11px",    OPTION_VAL_11PX_O60_0_EN },
         { "+12px",    OPTION_VAL_12PX_O60_0_EN },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_EN,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_EN,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_EN,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_EN,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_EN },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_EN,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_EN,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_EN },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_EN,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_EN,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_EN },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_EN,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_EN,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_EN },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_EN,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_EN,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_EN },
         { "async",    OPTION_VAL_ASYNC_EN },
         { "precache", OPTION_VAL_PRECACHE_EN },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_EN,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_EN,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_EN },
         { "4x",          OPTION_VAL_4X_EN },
         { "6x",          OPTION_VAL_6X_EN },
         { "8x",          OPTION_VAL_8X_EN },
         { "10x",         OPTION_VAL_10X_EN },
         { "12x",         OPTION_VAL_12X_EN },
         { "14x",         OPTION_VAL_14X_EN },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_en = {
   option_cats_en,
   option_defs_en
};

/* RETRO_LANGUAGE_EO */

#define CATEGORY_VIDEO_LABEL_EO "Video Driver"
#define CATEGORY_VIDEO_INFO_0_EO NULL
#define CATEGORY_OSD_LABEL_EO NULL
#define CATEGORY_OSD_INFO_0_EO NULL
#define CATEGORY_INPUT_LABEL_EO "Input Driver"
#define CATEGORY_INPUT_INFO_0_EO NULL
#define CATEGORY_MEMCARDS_LABEL_EO NULL
#define CATEGORY_MEMCARDS_INFO_0_EO NULL
#define CATEGORY_PGXP_LABEL_EO NULL
#define CATEGORY_PGXP_INFO_0_EO NULL
#define CATEGORY_HACKS_LABEL_EO NULL
#define CATEGORY_HACKS_INFO_0_EO NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_EO NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_EO NULL
#define OPTION_VAL_1X_NATIVE_EO NULL
#define OPTION_VAL_2X_EO NULL
#define OPTION_VAL_4X_EO NULL
#define OPTION_VAL_8X_EO NULL
#define OPTION_VAL_16X_EO NULL
#define BEETLE_OPT_DEPTH_LABEL_EO NULL
#define BEETLE_OPT_DEPTH_INFO_0_EO NULL
#define OPTION_VAL_16BPP_NATIVE_EO NULL
#define OPTION_VAL_32BPP_EO NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_EO NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_EO NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_EO "Interna Rezolucio"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_EO NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_EO NULL
#define BEETLE_OPT_FILTER_LABEL_EO NULL
#define BEETLE_OPT_FILTER_INFO_0_EO NULL
#define OPTION_VAL_NEAREST_EO NULL
#define OPTION_VAL_SABR_EO NULL
#define OPTION_VAL_XBR_EO NULL
#define OPTION_VAL_BILINEAR_EO NULL
#define OPTION_VAL_3_POINT_EO NULL
#define OPTION_VAL_JINC2_EO NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_EO NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_EO NULL
#define OPTION_VAL_OPAQUE_EO NULL
#define OPTION_VAL_ALL_EO NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_EO NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_EO NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_EO NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_EO NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_EO NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_EO NULL
#define BEETLE_OPT_MSAA_LABEL_EO NULL
#define BEETLE_OPT_MSAA_INFO_0_EO NULL
#define OPTION_VAL_1X_EO NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_EO NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_EO NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_EO NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_EO NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_EO NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_EO NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_EO NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_EO NULL
#define BEETLE_OPT_WIREFRAME_LABEL_EO NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_EO NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_EO NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_EO NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_EO NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_EO NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_EO NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_EO NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_EO NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_EO NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_EO NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_EO NULL
#define OPTION_VAL_ENABLED_ANALOG_EO NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_EO NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_EO NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_EO NULL
#define OPTION_VAL_L1_R1_SELECT_EO NULL
#define OPTION_VAL_L1_R1_START_EO NULL
#define OPTION_VAL_L1_R1_L3_EO NULL
#define OPTION_VAL_L1_R1_R3_EO NULL
#define OPTION_VAL_L2_R2_SELECT_EO NULL
#define OPTION_VAL_L2_R2_START_EO NULL
#define OPTION_VAL_L2_R2_L3_EO NULL
#define OPTION_VAL_L2_R2_R3_EO NULL
#define OPTION_VAL_L3_R3_EO NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_EO NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_EO NULL
#define OPTION_VAL_0_EO NULL
#define OPTION_VAL_1_EO NULL
#define OPTION_VAL_2_EO NULL
#define OPTION_VAL_3_EO NULL
#define OPTION_VAL_4_EO NULL
#define OPTION_VAL_5_EO NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_EO NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_EO NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_EO NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_EO NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_EO NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_EO NULL
#define OPTION_VAL_LIGHTGUN_EO NULL
#define OPTION_VAL_TOUCHSCREEN_EO NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_EO NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_EO NULL
#define OPTION_VAL_CROSS_EO NULL
#define OPTION_VAL_DOT_EO NULL
#define OPTION_VAL_OFF_EO NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_EO NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_EO NULL
#define OPTION_VAL_RED_EO NULL
#define OPTION_VAL_BLUE_EO NULL
#define OPTION_VAL_GREEN_EO NULL
#define OPTION_VAL_ORANGE_EO NULL
#define OPTION_VAL_YELLOW_EO NULL
#define OPTION_VAL_CYAN_EO NULL
#define OPTION_VAL_PINK_EO NULL
#define OPTION_VAL_PURPLE_EO NULL
#define OPTION_VAL_BLACK_EO NULL
#define OPTION_VAL_WHITE_EO NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_EO NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_EO NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_EO NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_EO NULL
#define OPTION_VAL_5_O28_EO NULL
#define OPTION_VAL_10_EO NULL
#define OPTION_VAL_15_EO NULL
#define OPTION_VAL_20_EO NULL
#define OPTION_VAL_25_EO NULL
#define OPTION_VAL_30_EO NULL
#define OPTION_VAL_35_EO NULL
#define OPTION_VAL_40_EO NULL
#define OPTION_VAL_45_EO NULL
#define OPTION_VAL_50_EO NULL
#define OPTION_VAL_55_EO NULL
#define OPTION_VAL_60_EO NULL
#define OPTION_VAL_65_EO NULL
#define OPTION_VAL_70_EO NULL
#define OPTION_VAL_75_EO NULL
#define OPTION_VAL_80_EO NULL
#define OPTION_VAL_85_EO NULL
#define OPTION_VAL_90_EO NULL
#define OPTION_VAL_95_EO NULL
#define OPTION_VAL_100_EO NULL
#define OPTION_VAL_105_EO NULL
#define OPTION_VAL_110_EO NULL
#define OPTION_VAL_115_EO NULL
#define OPTION_VAL_120_EO NULL
#define OPTION_VAL_125_EO NULL
#define OPTION_VAL_130_EO NULL
#define OPTION_VAL_135_EO NULL
#define OPTION_VAL_140_EO NULL
#define OPTION_VAL_145_EO NULL
#define OPTION_VAL_150_EO NULL
#define OPTION_VAL_155_EO NULL
#define OPTION_VAL_160_EO NULL
#define OPTION_VAL_165_EO NULL
#define OPTION_VAL_170_EO NULL
#define OPTION_VAL_175_EO NULL
#define OPTION_VAL_180_EO NULL
#define OPTION_VAL_185_EO NULL
#define OPTION_VAL_190_EO NULL
#define OPTION_VAL_195_EO NULL
#define OPTION_VAL_200_EO NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_EO NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_EO NULL
#define OPTION_VAL_LINEAR_EO NULL
#define OPTION_VAL_QUADRATIC_EO NULL
#define OPTION_VAL_CUBIC_EO NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_EO NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_EO NULL
#define OPTION_VAL_0_O30_EO NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_EO NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_EO NULL
#define OPTION_VAL_LIBRETRO_EO NULL
#define OPTION_VAL_MEDNAFEN_EO NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_EO NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_EO NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_EO NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_EO NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_EO NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_EO NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_EO NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_EO NULL
#define OPTION_VAL_1_O35_EO NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_EO NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_EO NULL
#define OPTION_VAL_MEMORY_ONLY_EO NULL
#define OPTION_VAL_MEMORY_CPU_EO NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_EO NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_EO NULL
#define OPTION_VAL_0PX_EO NULL
#define OPTION_VAL_1PX_EO NULL
#define OPTION_VAL_2PX_EO NULL
#define OPTION_VAL_3PX_EO NULL
#define OPTION_VAL_4PX_EO NULL
#define OPTION_VAL_5PX_EO NULL
#define OPTION_VAL_6PX_EO NULL
#define OPTION_VAL_7PX_EO NULL
#define OPTION_VAL_8PX_EO NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_EO NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_EO NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_EO NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_EO NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_EO NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_EO NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_EO NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_EO NULL
#define OPTION_VAL_DEFAULT_EO NULL
#define OPTION_VAL_AGGRESSIVE_EO NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_EO NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_EO NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_EO NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_EO NULL
#define OPTION_VAL_16_9_EO NULL
#define OPTION_VAL_16_10_EO NULL
#define OPTION_VAL_18_9_EO NULL
#define OPTION_VAL_19_9_EO NULL
#define OPTION_VAL_20_9_EO NULL
#define OPTION_VAL_21_9_EO NULL
#define OPTION_VAL_32_9_EO NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_EO NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_EO NULL
#define OPTION_VAL_100_NATIVE_EO NULL
#define OPTION_VAL_210_EO NULL
#define OPTION_VAL_220_EO NULL
#define OPTION_VAL_230_EO NULL
#define OPTION_VAL_240_EO NULL
#define OPTION_VAL_250_EO NULL
#define OPTION_VAL_260_EO NULL
#define OPTION_VAL_270_EO NULL
#define OPTION_VAL_280_EO NULL
#define OPTION_VAL_290_EO NULL
#define OPTION_VAL_300_EO NULL
#define OPTION_VAL_310_EO NULL
#define OPTION_VAL_320_EO NULL
#define OPTION_VAL_330_EO NULL
#define OPTION_VAL_340_EO NULL
#define OPTION_VAL_350_EO NULL
#define OPTION_VAL_360_EO NULL
#define OPTION_VAL_370_EO NULL
#define OPTION_VAL_380_EO NULL
#define OPTION_VAL_390_EO NULL
#define OPTION_VAL_400_EO NULL
#define OPTION_VAL_410_EO NULL
#define OPTION_VAL_420_EO NULL
#define OPTION_VAL_430_EO NULL
#define OPTION_VAL_440_EO NULL
#define OPTION_VAL_450_EO NULL
#define OPTION_VAL_460_EO NULL
#define OPTION_VAL_470_EO NULL
#define OPTION_VAL_480_EO NULL
#define OPTION_VAL_490_EO NULL
#define OPTION_VAL_500_EO NULL
#define OPTION_VAL_510_EO NULL
#define OPTION_VAL_520_EO NULL
#define OPTION_VAL_530_EO NULL
#define OPTION_VAL_540_EO NULL
#define OPTION_VAL_550_EO NULL
#define OPTION_VAL_560_EO NULL
#define OPTION_VAL_570_EO NULL
#define OPTION_VAL_580_EO NULL
#define OPTION_VAL_590_EO NULL
#define OPTION_VAL_600_EO NULL
#define OPTION_VAL_610_EO NULL
#define OPTION_VAL_620_EO NULL
#define OPTION_VAL_630_EO NULL
#define OPTION_VAL_640_EO NULL
#define OPTION_VAL_650_EO NULL
#define OPTION_VAL_660_EO NULL
#define OPTION_VAL_670_EO NULL
#define OPTION_VAL_680_EO NULL
#define OPTION_VAL_690_EO NULL
#define OPTION_VAL_700_EO NULL
#define OPTION_VAL_710_EO NULL
#define OPTION_VAL_720_EO NULL
#define OPTION_VAL_730_EO NULL
#define OPTION_VAL_740_EO NULL
#define OPTION_VAL_750_EO NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_EO NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_EO NULL
#define OPTION_VAL_32X_EO NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_EO NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_EO NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_EO NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_EO NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_EO NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_EO NULL
#define OPTION_VAL_PSXONPSP_EO NULL
#define OPTION_VAL_PS1_ROM_EO NULL
#define BEETLE_OPT_RENDERER_LABEL_EO NULL
#define BEETLE_OPT_RENDERER_INFO_0_EO NULL
#define OPTION_VAL_HARDWARE_EO NULL
#define OPTION_VAL_HARDWARE_GL_EO NULL
#define OPTION_VAL_HARDWARE_VK_EO NULL
#define OPTION_VAL_SOFTWARE_EO NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_EO NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_EO NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_EO NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_EO NULL
#define OPTION_VAL_DISABLED_EO NULL
#define OPTION_VAL_EXECUTE_EO NULL
#define OPTION_VAL_EXECUTE_ONE_EO NULL
#define OPTION_VAL_RUN_INTERPRETER_EO NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_EO NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_EO NULL
#define OPTION_VAL_FULL_EO NULL
#define OPTION_VAL_DMA_EO NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_EO NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_EO NULL
#define OPTION_VAL_128_EO NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_EO NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_EO NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_EO NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_EO NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_EO NULL
#define OPTION_VAL_FORCE_INTERLACED_EO NULL
#define OPTION_VAL_AUTO_TOGGLE_EO NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_EO NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_EO NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_EO NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_EO NULL
#define OPTION_VAL_CORRECTED_EO NULL
#define OPTION_VAL_UNCORRECTED_EO NULL
#define OPTION_VAL_4_3_EO NULL
#define OPTION_VAL_NTSC_EO NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_EO NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_EO NULL
#define OPTION_VAL_DISABLED_O58_EO NULL
#define OPTION_VAL_STATIC_EO NULL
#define OPTION_VAL_SMART_EO NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_EO NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_EO NULL
#define OPTION_VAL_9PX_EO NULL
#define OPTION_VAL_10PX_EO NULL
#define OPTION_VAL_11PX_EO NULL
#define OPTION_VAL_12PX_EO NULL
#define OPTION_VAL_13PX_EO NULL
#define OPTION_VAL_14PX_EO NULL
#define OPTION_VAL_15PX_EO NULL
#define OPTION_VAL_16PX_EO NULL
#define OPTION_VAL_17PX_EO NULL
#define OPTION_VAL_18PX_EO NULL
#define OPTION_VAL_19PX_EO NULL
#define OPTION_VAL_20PX_EO NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_EO NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_EO NULL
#define OPTION_VAL_12PX_O60_EO NULL
#define OPTION_VAL_11PX_O60_EO NULL
#define OPTION_VAL_10PX_O60_EO NULL
#define OPTION_VAL_9PX_O60_EO NULL
#define OPTION_VAL_8PX_O60_EO NULL
#define OPTION_VAL_7PX_O60_EO NULL
#define OPTION_VAL_6PX_O60_EO NULL
#define OPTION_VAL_5PX_O60_EO NULL
#define OPTION_VAL_4PX_O60_EO NULL
#define OPTION_VAL_3PX_O60_EO NULL
#define OPTION_VAL_2PX_O60_EO NULL
#define OPTION_VAL_1PX_O60_EO NULL
#define OPTION_VAL_1PX_O60_0_EO NULL
#define OPTION_VAL_2PX_O60_0_EO NULL
#define OPTION_VAL_3PX_O60_0_EO NULL
#define OPTION_VAL_4PX_O60_0_EO NULL
#define OPTION_VAL_5PX_O60_0_EO NULL
#define OPTION_VAL_6PX_O60_0_EO NULL
#define OPTION_VAL_7PX_O60_0_EO NULL
#define OPTION_VAL_8PX_O60_0_EO NULL
#define OPTION_VAL_9PX_O60_0_EO NULL
#define OPTION_VAL_10PX_O60_0_EO NULL
#define OPTION_VAL_11PX_O60_0_EO NULL
#define OPTION_VAL_12PX_O60_0_EO NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_EO NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_EO NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_EO NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_EO NULL
#define OPTION_VAL_0_O62_EO NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_EO NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_EO NULL
#define OPTION_VAL_239_EO NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_EO NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_EO NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_EO NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_EO NULL
#define OPTION_VAL_287_EO NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_EO NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_EO NULL
#define OPTION_VAL_SYNC_EO NULL
#define OPTION_VAL_ASYNC_EO NULL
#define OPTION_VAL_PRECACHE_EO NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_EO NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_EO NULL
#define OPTION_VAL_2X_NATIVE_EO NULL
#define OPTION_VAL_6X_EO NULL
#define OPTION_VAL_10X_EO NULL
#define OPTION_VAL_12X_EO NULL
#define OPTION_VAL_14X_EO NULL

struct retro_core_option_v2_category option_cats_eo[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_EO,
      CATEGORY_VIDEO_INFO_0_EO
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_EO,
      CATEGORY_OSD_INFO_0_EO
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EO,
      CATEGORY_INPUT_INFO_0_EO
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_EO,
      CATEGORY_MEMCARDS_INFO_0_EO
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_EO,
      CATEGORY_PGXP_INFO_0_EO
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EO,
      CATEGORY_HACKS_INFO_0_EO
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_eo[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_EO,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_EO,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_EO },
         { "2x",         OPTION_VAL_2X_EO },
         { "4x",         OPTION_VAL_4X_EO },
         { "8x",         OPTION_VAL_8X_EO },
         { "16x",        OPTION_VAL_16X_EO },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_EO,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_EO,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_EO },
         { "32bpp",         OPTION_VAL_32BPP_EO },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_EO,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_EO,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_EO },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_EO },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_EO,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_EO,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_EO,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_EO,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_EO },
         { "SABR",     OPTION_VAL_SABR_EO },
         { "xBR",      OPTION_VAL_XBR_EO },
         { "bilinear", OPTION_VAL_BILINEAR_EO },
         { "3-point",  OPTION_VAL_3_POINT_EO },
         { "JINC2",    OPTION_VAL_JINC2_EO },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_EO,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_EO },
         { "all", OPTION_VAL_ALL_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_EO,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_EO },
         { "all", OPTION_VAL_ALL_EO },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_EO,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_EO,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_EO,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_EO,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_EO },
         { "2x",  OPTION_VAL_2X_EO },
         { "4x",  OPTION_VAL_4X_EO },
         { "8x",  OPTION_VAL_8X_EO },
         { "16x", OPTION_VAL_16X_EO },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_EO,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_EO,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_EO,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_EO,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_EO,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_EO,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_EO,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_EO,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_EO,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_EO,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_EO,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_EO,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_EO,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_EO,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_EO },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_EO },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_EO },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_EO },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_EO },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_EO },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_EO },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_EO },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_EO },
         { "l3+r3",                    OPTION_VAL_L3_R3_EO },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_EO,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_EO,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_EO },
         { "1", OPTION_VAL_1_EO },
         { "2", OPTION_VAL_2_EO },
         { "3", OPTION_VAL_3_EO },
         { "4", OPTION_VAL_4_EO },
         { "5", OPTION_VAL_5_EO },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_EO,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_EO,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_EO,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_EO,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_EO },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_EO },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_EO,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_EO,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_EO },
         { "dot",   OPTION_VAL_DOT_EO },
         { "off",   OPTION_VAL_OFF_EO },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_EO,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_EO,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_EO },
         { "blue", OPTION_VAL_BLUE_EO },
         { "green", OPTION_VAL_GREEN_EO },
         { "orange", OPTION_VAL_ORANGE_EO },
         { "yellow", OPTION_VAL_YELLOW_EO },
         { "cyan", OPTION_VAL_CYAN_EO },
         { "pink", OPTION_VAL_PINK_EO },
         { "purple", OPTION_VAL_PURPLE_EO },
         { "black", OPTION_VAL_BLACK_EO },
         { "white", OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_EO,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_EO,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_EO },
         { "red", OPTION_VAL_RED_EO },
         { "green", OPTION_VAL_GREEN_EO },
         { "orange", OPTION_VAL_ORANGE_EO },
         { "yellow", OPTION_VAL_YELLOW_EO },
         { "cyan", OPTION_VAL_CYAN_EO },
         { "pink", OPTION_VAL_PINK_EO },
         { "purple", OPTION_VAL_PURPLE_EO },
         { "black", OPTION_VAL_BLACK_EO },
         { "white", OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_EO,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_EO,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_EO },
         { "10%",  OPTION_VAL_10_EO },
         { "15%",  OPTION_VAL_15_EO },
         { "20%",  OPTION_VAL_20_EO },
         { "25%",  OPTION_VAL_25_EO },
         { "30%",  OPTION_VAL_30_EO },
         { "35%",  OPTION_VAL_35_EO },
         { "40%",  OPTION_VAL_40_EO },
         { "45%",  OPTION_VAL_45_EO },
         { "50%",  OPTION_VAL_50_EO },
         { "55%",  OPTION_VAL_55_EO },
         { "60%",  OPTION_VAL_60_EO },
         { "65%",  OPTION_VAL_65_EO },
         { "70%",  OPTION_VAL_70_EO },
         { "75%",  OPTION_VAL_75_EO },
         { "80%",  OPTION_VAL_80_EO },
         { "85%",  OPTION_VAL_85_EO },
         { "90%",  OPTION_VAL_90_EO },
         { "95%",  OPTION_VAL_95_EO },
         { "100%", OPTION_VAL_100_EO },
         { "105%", OPTION_VAL_105_EO },
         { "110%", OPTION_VAL_110_EO },
         { "115%", OPTION_VAL_115_EO },
         { "120%", OPTION_VAL_120_EO },
         { "125%", OPTION_VAL_125_EO },
         { "130%", OPTION_VAL_130_EO },
         { "135%", OPTION_VAL_135_EO },
         { "140%", OPTION_VAL_140_EO },
         { "145%", OPTION_VAL_145_EO },
         { "150%", OPTION_VAL_150_EO },
         { "155%", OPTION_VAL_155_EO },
         { "160%", OPTION_VAL_160_EO },
         { "165%", OPTION_VAL_165_EO },
         { "170%", OPTION_VAL_170_EO },
         { "175%", OPTION_VAL_175_EO },
         { "180%", OPTION_VAL_180_EO },
         { "185%", OPTION_VAL_185_EO },
         { "190%", OPTION_VAL_190_EO },
         { "195%", OPTION_VAL_195_EO },
         { "200%", OPTION_VAL_200_EO },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_EO,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_EO,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_EO },
         { "quadratic", OPTION_VAL_QUADRATIC_EO },
         { "cubic",     OPTION_VAL_CUBIC_EO },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_EO,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_EO,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_EO },
         { "5%",  OPTION_VAL_5_O28_EO },
         { "10%", OPTION_VAL_10_EO },
         { "15%", OPTION_VAL_15_EO },
         { "20%", OPTION_VAL_20_EO },
         { "25%", OPTION_VAL_25_EO },
         { "30%", OPTION_VAL_30_EO },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_EO,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_EO,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_EO },
         { "mednafen", OPTION_VAL_MEDNAFEN_EO },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_EO,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_EO,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_EO,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_EO,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_EO,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_EO,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_EO,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_EO,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_EO },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_EO,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_EO,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_EO },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_EO,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_EO,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_EO },
         { "1px", OPTION_VAL_1PX_EO },
         { "2px", OPTION_VAL_2PX_EO },
         { "3px", OPTION_VAL_3PX_EO },
         { "4px", OPTION_VAL_4PX_EO },
         { "5px", OPTION_VAL_5PX_EO },
         { "6px", OPTION_VAL_6PX_EO },
         { "7px", OPTION_VAL_7PX_EO },
         { "8px", OPTION_VAL_8PX_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_EO,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_EO,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_EO,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_EO,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_EO,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_EO,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_EO,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_EO },
         { "aggressive", OPTION_VAL_AGGRESSIVE_EO },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_EO,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_EO,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_EO },
         { "16:10", OPTION_VAL_16_10_EO },
         { "18:9",  OPTION_VAL_18_9_EO },
         { "19:9",  OPTION_VAL_19_9_EO },
         { "20:9",  OPTION_VAL_20_9_EO },
         { "21:9",  OPTION_VAL_21_9_EO }, // 64:27
         { "32:9",  OPTION_VAL_32_9_EO },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_EO,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_EO },
         { "60%",           OPTION_VAL_60_EO },
         { "70%",           OPTION_VAL_70_EO },
         { "80%",           OPTION_VAL_80_EO },
         { "90%",           OPTION_VAL_90_EO },
         { "100%(native)", OPTION_VAL_100_NATIVE_EO },
         { "110%",          OPTION_VAL_110_EO },
         { "120%",          OPTION_VAL_120_EO },
         { "130%",          OPTION_VAL_130_EO },
         { "140%",          OPTION_VAL_140_EO },
         { "150%",          OPTION_VAL_150_EO },
         { "160%",          OPTION_VAL_160_EO },
         { "170%",          OPTION_VAL_170_EO },
         { "180%",          OPTION_VAL_180_EO },
         { "190%",          OPTION_VAL_190_EO },
         { "200%",          OPTION_VAL_200_EO },
         { "210%",          OPTION_VAL_210_EO },
         { "220%",          OPTION_VAL_220_EO },
         { "230%",          OPTION_VAL_230_EO },
         { "240%",          OPTION_VAL_240_EO },
         { "250%",          OPTION_VAL_250_EO },
         { "260%",          OPTION_VAL_260_EO },
         { "270%",          OPTION_VAL_270_EO },
         { "280%",          OPTION_VAL_280_EO },
         { "290%",          OPTION_VAL_290_EO },
         { "300%",          OPTION_VAL_300_EO },
         { "310%",          OPTION_VAL_310_EO },
         { "320%",          OPTION_VAL_320_EO },
         { "330%",          OPTION_VAL_330_EO },
         { "340%",          OPTION_VAL_340_EO },
         { "350%",          OPTION_VAL_350_EO },
         { "360%",          OPTION_VAL_360_EO },
         { "370%",          OPTION_VAL_370_EO },
         { "380%",          OPTION_VAL_380_EO },
         { "390%",          OPTION_VAL_390_EO },
         { "400%",          OPTION_VAL_400_EO },
         { "410%",          OPTION_VAL_410_EO },
         { "420%",          OPTION_VAL_420_EO },
         { "430%",          OPTION_VAL_430_EO },
         { "440%",          OPTION_VAL_440_EO },
         { "450%",          OPTION_VAL_450_EO },
         { "460%",          OPTION_VAL_460_EO },
         { "470%",          OPTION_VAL_470_EO },
         { "480%",          OPTION_VAL_480_EO },
         { "490%",          OPTION_VAL_490_EO },
         { "500%",          OPTION_VAL_500_EO },
         { "510%",          OPTION_VAL_510_EO },
         { "520%",          OPTION_VAL_520_EO },
         { "530%",          OPTION_VAL_530_EO },
         { "540%",          OPTION_VAL_540_EO },
         { "550%",          OPTION_VAL_550_EO },
         { "560%",          OPTION_VAL_560_EO },
         { "570%",          OPTION_VAL_570_EO },
         { "580%",          OPTION_VAL_580_EO },
         { "590%",          OPTION_VAL_590_EO },
         { "600%",          OPTION_VAL_600_EO },
         { "610%",          OPTION_VAL_610_EO },
         { "620%",          OPTION_VAL_620_EO },
         { "630%",          OPTION_VAL_630_EO },
         { "640%",          OPTION_VAL_640_EO },
         { "650%",          OPTION_VAL_650_EO },
         { "660%",          OPTION_VAL_660_EO },
         { "670%",          OPTION_VAL_670_EO },
         { "680%",          OPTION_VAL_680_EO },
         { "690%",          OPTION_VAL_690_EO },
         { "700%",          OPTION_VAL_700_EO },
         { "710%",          OPTION_VAL_710_EO },
         { "720%",          OPTION_VAL_720_EO },
         { "730%",          OPTION_VAL_730_EO },
         { "740%",          OPTION_VAL_740_EO },
         { "750%",          OPTION_VAL_750_EO },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_EO,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_EO },
         { "2x",         OPTION_VAL_2X_EO },
         { "4x",         OPTION_VAL_4X_EO },
         { "8x",         OPTION_VAL_8X_EO },
         { "16x",        OPTION_VAL_16X_EO },
         { "32x",        OPTION_VAL_32X_EO },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_EO,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_EO,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_EO,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_EO },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_EO },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_EO,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_EO,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_EO },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_EO },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_EO },
#endif
         { "software",    OPTION_VAL_SOFTWARE_EO },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_EO,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_EO,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_EO,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_EO,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_EO },
         { "execute",  OPTION_VAL_EXECUTE_EO },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_EO },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_EO,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_EO,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_EO },
         { "dma",  OPTION_VAL_DMA_EO },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_EO,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_EO },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_EO,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_EO },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_EO,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_EO,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_EO },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_EO },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_EO },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_EO,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_EO,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_EO,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_EO },
         { "uncorrected", OPTION_VAL_UNCORRECTED_EO },
         { "4:3",  OPTION_VAL_4_3_EO },
         { "ntsc", OPTION_VAL_NTSC_EO },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_EO,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_EO },
         { "static",  OPTION_VAL_STATIC_EO },
         { "smart", OPTION_VAL_SMART_EO },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_EO,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_EO },
         { "2px",      OPTION_VAL_2PX_EO },
         { "3px",      OPTION_VAL_3PX_EO },
         { "4px",      OPTION_VAL_4PX_EO },
         { "5px",      OPTION_VAL_5PX_EO },
         { "6px",      OPTION_VAL_6PX_EO },
         { "7px",      OPTION_VAL_7PX_EO },
         { "8px",      OPTION_VAL_8PX_EO },
         { "9px",      OPTION_VAL_9PX_EO },
         { "10px",     OPTION_VAL_10PX_EO },
         { "11px",     OPTION_VAL_11PX_EO },
         { "12px",     OPTION_VAL_12PX_EO },
         { "13px",     OPTION_VAL_13PX_EO },
         { "14px",     OPTION_VAL_14PX_EO },
         { "15px",     OPTION_VAL_15PX_EO },
         { "16px",     OPTION_VAL_16PX_EO },
         { "17px",     OPTION_VAL_17PX_EO },
         { "18px",     OPTION_VAL_18PX_EO },
         { "19px",     OPTION_VAL_19PX_EO },
         { "20px",     OPTION_VAL_20PX_EO },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_EO,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_EO,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_EO },
         { "-11px",    OPTION_VAL_11PX_O60_EO },
         { "-10px",    OPTION_VAL_10PX_O60_EO },
         { "-9px",     OPTION_VAL_9PX_O60_EO },
         { "-8px",     OPTION_VAL_8PX_O60_EO },
         { "-7px",     OPTION_VAL_7PX_O60_EO },
         { "-6px",     OPTION_VAL_6PX_O60_EO },
         { "-5px",     OPTION_VAL_5PX_O60_EO },
         { "-4px",     OPTION_VAL_4PX_O60_EO },
         { "-3px",     OPTION_VAL_3PX_O60_EO },
         { "-2px",     OPTION_VAL_2PX_O60_EO },
         { "-1px",     OPTION_VAL_1PX_O60_EO },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_EO },
         { "+2px",     OPTION_VAL_2PX_O60_0_EO },
         { "+3px",     OPTION_VAL_3PX_O60_0_EO },
         { "+4px",     OPTION_VAL_4PX_O60_0_EO },
         { "+5px",     OPTION_VAL_5PX_O60_0_EO },
         { "+6px",     OPTION_VAL_6PX_O60_0_EO },
         { "+7px",     OPTION_VAL_7PX_O60_0_EO },
         { "+8px",     OPTION_VAL_8PX_O60_0_EO },
         { "+9px",     OPTION_VAL_9PX_O60_0_EO },
         { "+10px",    OPTION_VAL_10PX_O60_0_EO },
         { "+11px",    OPTION_VAL_11PX_O60_0_EO },
         { "+12px",    OPTION_VAL_12PX_O60_0_EO },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_EO,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_EO,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_EO,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_EO,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_EO },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_EO,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_EO,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_EO },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_EO,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_EO,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_EO },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_EO,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_EO,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_EO },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_EO,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_EO,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_EO },
         { "async",    OPTION_VAL_ASYNC_EO },
         { "precache", OPTION_VAL_PRECACHE_EO },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_EO,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_EO,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_EO },
         { "4x",          OPTION_VAL_4X_EO },
         { "6x",          OPTION_VAL_6X_EO },
         { "8x",          OPTION_VAL_8X_EO },
         { "10x",         OPTION_VAL_10X_EO },
         { "12x",         OPTION_VAL_12X_EO },
         { "14x",         OPTION_VAL_14X_EO },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_eo = {
   option_cats_eo,
   option_defs_eo
};

/* RETRO_LANGUAGE_ES */

#define CATEGORY_VIDEO_LABEL_ES "Vídeo"
#define CATEGORY_VIDEO_INFO_0_ES "Cambia las opciones de relación de aspecto, recorte de imagen, filtros de vídeo y omisión de fotogramas."
#define CATEGORY_OSD_LABEL_ES "Presentación en pantalla"
#define CATEGORY_OSD_INFO_0_ES "Cambia las notificaciones que se mostrarán en pantalla."
#define CATEGORY_INPUT_LABEL_ES "Entrada"
#define CATEGORY_INPUT_INFO_0_ES "Cambia los ajustes de las pistolas de luz, el ratón y el neGcon."
#define CATEGORY_MEMCARDS_LABEL_ES "Memory Cards"
#define CATEGORY_MEMCARDS_INFO_0_ES "Cambia la configuración de las Memory Card virtuales que utilizará el sistema."
#define CATEGORY_PGXP_LABEL_ES "PGXP (Proceso de transformación precisa de geometría)"
#define CATEGORY_PGXP_INFO_0_ES "Estas opciones permiten mejorar los gráficos por encima de lo que puede mostrar la consola real, eliminando las distorsiones de texturas y el «Z-fighting» (distorsión entre polígonos)."
#define CATEGORY_HACKS_LABEL_ES "Arreglos de emulación"
#define CATEGORY_HACKS_INFO_0_ES "Cambia las opciones de velocidad del procesador y de precisión de la emulación que afectan al rendimiento a bajo nivel y a la compatibilidad."
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_ES "Resolución interna de la GPU"
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_ES "Selecciona el multiplicador de la resolución interna. Toda resolución superior a «1x (Nativa)» mejorará la fidelidad de los modelos 3D a costa de aumentar los requisitos de rendimiento. Los elementos 2D no suelen verse afectados."
#define OPTION_VAL_1X_NATIVE_ES "1x (nativa)"
#define OPTION_VAL_2X_ES NULL
#define OPTION_VAL_4X_ES NULL
#define OPTION_VAL_8X_ES NULL
#define OPTION_VAL_16X_ES NULL
#define BEETLE_OPT_DEPTH_LABEL_ES "Profundidad interna de colores"
#define BEETLE_OPT_DEPTH_INFO_0_ES "Selecciona la profundidad interna de colores. Una mayor profundidad puede reducir el efecto de bandas de color sin tener que recurrir al efecto de tramado. 16 bpp simula el hardware original, pero puede generar bandas de color si la opción de tramado no está activada. Se recomienda desactivar la opción «Tramado» al seleccionar 32 bpp en esta opción."
#define OPTION_VAL_16BPP_NATIVE_ES "16 bpp (nativa)"
#define OPTION_VAL_32BPP_ES NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_ES "Tramado"
#define BEETLE_OPT_DITHER_MODE_INFO_0_ES "Selecciona la configuración del tramado. «1x (Nativo)» simula el tramado nativo a baja resolución que utilizaba el hardware original para suavizar los defectos de bandas de color visibles en la profundidad de colores nativa. «Resolución interna» cambia la escala del tramado a la resolución interna configurada para producir un resultado más limpio. Se recomienda desactivar esta opción al utilizar una profundidad de colores de 32 bpp. Nota: Activar esta opción en Vulkan desactivará la reducción de colores a la profundidad nativa y activará una profundidad interna superior."
#define OPTION_VAL_INTERNAL_RESOLUTION_ES "Resolución interna"
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_ES "Compensación de UV de texturas"
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_ES "Muestrea las texturas de los polígonos 3D con una compensación para resoluciones superiores a la nativa. Reduce los salientes en las texturas, pero puede producir fallos gráficos accidentales."
#define BEETLE_OPT_FILTER_LABEL_ES "Filtrado de texturas"
#define BEETLE_OPT_FILTER_INFO_0_ES "Selecciona el método de filtrado de texturas. «Más cercano» simula el hardware original. «Bilineal» y «De tres puntos» son filtros de suavizado que reducen la pixelación difuminando la imagen. «SABR», «xBR» y «JINC2» son filtros de escalado que podrían mejorar la fidelidad/definición de las texturas a costa de aumentar los requisitos de rendimiento. Solo funciona con los renderizadores por hardware."
#define OPTION_VAL_NEAREST_ES "Más cercano"
#define OPTION_VAL_SABR_ES NULL
#define OPTION_VAL_XBR_ES NULL
#define OPTION_VAL_BILINEAR_ES "Bilineal"
#define OPTION_VAL_3_POINT_ES "De tres puntos"
#define OPTION_VAL_JINC2_ES NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_ES "No filtrar sprites"
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_ES "No aplicará el filtrado de texturas a los sprites. Evita los bordes en varios juegos con fondos renderizados en 2D. Se recomienda activar también la opción de Suavizado adaptativo u otro efecto de posprocesado para conseguir el mejor efecto."
#define OPTION_VAL_OPAQUE_ES "Solo sprites opacos"
#define OPTION_VAL_ALL_ES "Sprites opacos y semitransparentes"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_ES "No filtrar polígonos 2D"
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_ES "No aplicará el filtrado de texturas a los polígonos en 2D. Estos son detectados mediante un proceso heurístico, por lo que puede haber fallos visuales. Se recomienda activar también la opción «Suavizado adaptativo» u otro efecto de posprocesado para conseguir el mejor efecto."
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_ES "Suavizado adaptativo"
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_ES "Suaviza los gráficos y elementos de interfaz en 2D sin difuminar los objetos renderizados en 3D. Solo funciona con el renderizador Vulkan."
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_ES "Supermuestreo (reducción a resolución nativa)"
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_ES "Reduce el contenido renderizado de una resolución interna superior a la nativa. Al combinar este efecto con multiplicadores para aumentar la resolución interna, los juegos pueden mostrarse con objetos 3D con bordes suavizados en la resolución nativa. Genera los mejores resultados en aquellos títulos que combinan elementos 2D y 3D (p. ej.: personajes 3D sobre fondos prerenderizados) y acompañado de shaders de simulación de CRT. Solo funciona con el renderizador Vulkan. Nota: Se recomienda desactivar el tramado al utilizar esta opción."
#define BEETLE_OPT_MSAA_LABEL_ES "Suavizado de bordes MSAA"
#define BEETLE_OPT_MSAA_INFO_0_ES "Ajusta el MSAA que se aplicará al contenido renderizado. Mejora el aspecto de los objetos 3D. Solo funciona con el renderizador Vulkan."
#define OPTION_VAL_1X_ES NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_ES "Filtro cromático YUV para MDEC"
#define BEETLE_OPT_MDEC_YUV_INFO_0_ES "Mejora la calidad de la reproducción de secuencias FMV reduciendo los artefactos de los «macrobloques» (cuadrados y bordes de sierra). Solo funciona con el renderizador Vulkan."
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_ES "Rastreo de texturas"
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_ES "Necesario para el volcado y sustitución de texturas. Probablemente provocará que la mayoría de juegos se queden colgados."
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_ES "Volcar texturas"
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_ES "Vuelca las texturas que se utilicen a <cd>-texture-dump/"
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_ES "Sustituir texturas"
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_ES "Sustituye las texturas con las versiones en alta definición que se encuentren en <cd>-texture-replacements/"
#define BEETLE_OPT_WIREFRAME_LABEL_ES "Modo de mallas (depuración)"
#define BEETLE_OPT_WIREFRAME_INFO_0_ES "Renderiza solo las mallas de los objetos 3D, sin mostrar sus texturas o sombreado. Solo funciona con el renderizador por hardware de OpenGL. Nota: Esta opción solo se utiliza para depuración y debería mantenerse desactivada por norma general."
#define BEETLE_OPT_FRAME_DUPING_LABEL_ES "Duplicado de fotogramas (mayor velocidad)"
#define BEETLE_OPT_FRAME_DUPING_INFO_0_ES "Al activar esta opción (y si es compatible con el front-end de libretro), aumenta levemente el rendimiento al indicar al front-end que repita el fotograma anterior si el núcleo no muestra nada nuevo."
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_ES "Mostrar FPS internos"
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_ES "Muestra la velocidad de fotogramas interna con la que el sistema PlayStation emulado renderiza el contenido. Nota: Es necesario activar las notificaciones en pantalla en el front-end libretro."
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_ES "Mostrar la VRAM completa (depuración)"
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_ES "Visualiza toda la VRAM emulada. Solo funciona con los renderizadores por hardware de OpenGL y Vulkan. Nota: Esta opción solo se utiliza para depuración y debería mantenerse desactivada por norma general."
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_ES "Autocalibrar controles analógicos"
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_ES "Cuando el dispositivo de entrada esté configurado como DualShock, mando analógico, joystick analógico o neGcon, esta opción permitirá calibrar de forma dinámica las entradas analógicas. Se controlarán en tiempo real los valores de entrada máximos registrados para escalar las coordenadas analógicas que se transmitan al emulador. Esto sirve para juegos como Mega Man Legends 2, que esperan unos valores superiores a los que pueden transmitir los mandos modernos. Se recomienda que los sticks analógicos sean girados en toda su extensión nada más cargar un contenido para que el algoritmo de calibración funcione lo mejor posible."
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_ES "Alternar modo analógico del DualShock"
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_ES "Cuando el tipo de dispositivo de entrada sea DualShock, esta opción permite que el DualShock emulado pueda alternar entre los modos digital y analógico, como hace el hardware original. También se puede alternar el modo analógico con la combinación de botones seleccionada."
#define OPTION_VAL_ENABLED_ANALOG_ES "Analógico (predeterminado)"
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_ES "Combinación de botones del modo analógico del DualShock"
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_ES "Selecciona la combinación de botones con la que se alternarán los modos digital y analógico del DualShock emulado."
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_ES NULL
#define OPTION_VAL_L1_R1_SELECT_ES NULL
#define OPTION_VAL_L1_R1_START_ES NULL
#define OPTION_VAL_L1_R1_L3_ES NULL
#define OPTION_VAL_L1_R1_R3_ES NULL
#define OPTION_VAL_L2_R2_SELECT_ES NULL
#define OPTION_VAL_L2_R2_START_ES NULL
#define OPTION_VAL_L2_R2_L3_ES NULL
#define OPTION_VAL_L2_R2_R3_ES NULL
#define OPTION_VAL_L3_R3_ES NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_ES "Tiempo de espera para la combinación del modo analógico"
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_ES "Establece el tiempo que se deben mantener pulsados los botones de la combinación del modo analógico."
#define OPTION_VAL_0_ES "Espera de 0 segundos"
#define OPTION_VAL_1_ES "Espera de 1 segundo"
#define OPTION_VAL_2_ES "Espera de 2 segundos"
#define OPTION_VAL_3_ES "Espera de 3 segundos"
#define OPTION_VAL_4_ES "Espera de 4 segundos"
#define OPTION_VAL_5_ES "Espera de 5 segundos"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_ES "Puerto 1: activar Multitap"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_ES "Activa el sistema de Multitap en el puerto 1."
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_ES "Puerto 2: activar Multitap"
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_ES "Activa el sistema de Multitap en el puerto 2."
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_ES "Modo de entrada de pistolas de luz"
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_ES "Selecciona si se debe usar una entrada de ratón o de pantalla táctil cuando el tipo de dispositivo esté configurado como «Guncon/G-Con 45» o «Justifier»."
#define OPTION_VAL_LIGHTGUN_ES "Pistola de luz"
#define OPTION_VAL_TOUCHSCREEN_ES "Pantalla táctil"
#define BEETLE_OPT_GUN_CURSOR_LABEL_ES "Cursor del arma"
#define BEETLE_OPT_GUN_CURSOR_INFO_0_ES "Selecciona el cursor que aparecerá en pantalla al usar los tipos de dispositivo de entrada «Guncon/G-Con 45» o «Justifier». Al desactivar esta opción se ocultará el punto de mira."
#define OPTION_VAL_CROSS_ES "Cruz"
#define OPTION_VAL_DOT_ES "Punto"
#define OPTION_VAL_OFF_ES "Sin cursor"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_ES "Puerto 1: color de la mira de la pistola"
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_ES "Selecciona el color del punto de mira de la pistola de luz conectada en el puerto 1."
#define OPTION_VAL_RED_ES "Rojo"
#define OPTION_VAL_BLUE_ES "Azul"
#define OPTION_VAL_GREEN_ES "Verde"
#define OPTION_VAL_ORANGE_ES "Naranja"
#define OPTION_VAL_YELLOW_ES "Amarillo"
#define OPTION_VAL_CYAN_ES "Cian"
#define OPTION_VAL_PINK_ES "Rosa"
#define OPTION_VAL_PURPLE_ES "Violeta"
#define OPTION_VAL_BLACK_ES "Negro"
#define OPTION_VAL_WHITE_ES "Blanco"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_ES "Puerto 2: color de la mira de la pistola"
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_ES "Selecciona el color del punto de mira de la pistola de luz conectada en el puerto 2."
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_ES "Sensibilidad del ratón"
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_ES "Ajusta la respuesta del dispositivo de entrada «Mouse (ratón)»."
#define OPTION_VAL_5_O28_ES "5 %"
#define OPTION_VAL_10_ES "10 %"
#define OPTION_VAL_15_ES "15 %"
#define OPTION_VAL_20_ES "20 %"
#define OPTION_VAL_25_ES "25 %"
#define OPTION_VAL_30_ES "30 %"
#define OPTION_VAL_35_ES "35 %"
#define OPTION_VAL_40_ES "40 %"
#define OPTION_VAL_45_ES "45 %"
#define OPTION_VAL_50_ES "50 %"
#define OPTION_VAL_55_ES "55 %"
#define OPTION_VAL_60_ES "60 %"
#define OPTION_VAL_65_ES "65 %"
#define OPTION_VAL_70_ES "70 %"
#define OPTION_VAL_75_ES "75 %"
#define OPTION_VAL_80_ES "80 %"
#define OPTION_VAL_85_ES "85 %"
#define OPTION_VAL_90_ES "90 %"
#define OPTION_VAL_95_ES "95 %"
#define OPTION_VAL_100_ES "100 % (por defecto)"
#define OPTION_VAL_105_ES "105 %"
#define OPTION_VAL_110_ES "110 %"
#define OPTION_VAL_115_ES "115 %"
#define OPTION_VAL_120_ES "120 %"
#define OPTION_VAL_125_ES "125 %"
#define OPTION_VAL_130_ES "130 %"
#define OPTION_VAL_135_ES "135 %"
#define OPTION_VAL_140_ES "140 %"
#define OPTION_VAL_145_ES "145 %"
#define OPTION_VAL_150_ES "150 %"
#define OPTION_VAL_155_ES "155 %"
#define OPTION_VAL_160_ES "160 %"
#define OPTION_VAL_165_ES "165 %"
#define OPTION_VAL_170_ES "170 %"
#define OPTION_VAL_175_ES "175 %"
#define OPTION_VAL_180_ES "180 %"
#define OPTION_VAL_185_ES "185 %"
#define OPTION_VAL_190_ES "190 %"
#define OPTION_VAL_195_ES "195 %"
#define OPTION_VAL_200_ES "200 %"
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_ES "Respuesta al torcer el neGcon"
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_ES "Selecciona el tipo de respuesta del stick analógico izquierdo del RetroPad al simular la acción de torcer un dispositivo de entrada neGcon emulado. El desplazamiento del stick analógico puede ser asignado a la rotación del neGcon de forma lineal, cuadrática o cúbica. «Cuadrática» da una mayor precisión que «Lineal» en movimientos más sutiles. «Cúbica» aumenta más la precisión de los movimientos más sutiles, pero exagera los más largos. Nota: solo se recomienda usar «Lineal» con periféricos tipo volante de carreras. Los mandos convencionales gestionan la entrada analógica de una forma muy distinta al mecanismo de rotación del neGcon de tal forma que la asignación lineal sobreamplifica los movimientos sutiles, lo que afecta al control preciso. En la mayoría de casos, la opción «Cuadrática» produce la mejor aproximación posible al hardware real."
#define OPTION_VAL_LINEAR_ES "Lineal"
#define OPTION_VAL_QUADRATIC_ES "Cuadrática"
#define OPTION_VAL_CUBIC_ES "Cúbica"
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_ES "Zona muerta al torcer el neGcon"
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_ES "Ajusta la zona muerta del stick analógico izquierdo del RetroPad al simular la acción de torcer un dispositivo de entrada neGcon emulado. Sirve para evitar que el mando registre movimientos no realizados. Nota: la mayoría de juegos compatibles con neGcon incluyen opciones dentro del juego para ajustar un valor de zona muerta al torcerlo. Este valor debe configurarse como cero o neutral en todo momento para que no haya una pérdida de precisión. Cualquier ajuste que sea necesario solo debe aplicarse mediante esta opción del núcleo, sobre todo si «Respuesta al torcer el neGcon» está configurada como «Cuadrática» o «Cúbica»."
#define OPTION_VAL_0_O30_ES "0 %"
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_ES "Método de la Memory Card 0 (es necesario reiniciar)"
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_ES "Selecciona el formato de datos guardados que se utilizará en la Memory Card 0. «Mednafen» puede mejorar la compatibilidad con la versión independiente de Mednafen. Al utilizar los archivos guardados con Beetle PSX, los archivos de libretro (.srm) y Mednafen (.mcr) son idénticos internamente, así que pueden intercambiarse entre sí modificando sus nombres."
#define OPTION_VAL_LIBRETRO_ES NULL
#define OPTION_VAL_MEDNAFEN_ES NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_ES "Activar Memory Card 1 (es necesario reiniciar)"
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_ES "Emula una segunda Memory Card en la ranura 1. Al desactivar esta opción, los juegos solo podrán acceder a la Memory Card de la ranura 0. Nota: algunos juegos necesitan que esta opción esté desactivada para funcionar correctamente (p. ej.: Codename Tenka). Nota: la Memory Card 1 utiliza el formato de guardado Mednafen (.mcr)."
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_ES "Memory Card compartidas (es necesario reiniciar)"
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_ES "Al activar esta opción, todos los juegos utilizarán los mismos archivos de Memory Card para guardar y cargar partidas. Al desactivarla se utilizarán archivos de Memory Card independientes por cada elemento del contenido cargado. Nota: si la opción «Método de la Memory Card 0» está configurada como «Libretro», esta opción solo afectará a la Memory Card de la ranura 1."
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_ES "Índice de la Memory Card izquierda"
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_ES "Cambia la Memory Card que está cargada en la ranura izquierda. Esta opción solo funcionará si la opción «Método de la Memory Card 0» está configurada como «Mednafen». La Memory Card predeterminada es el índice 0."
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_ES "Índice de la Memory Card derecha"
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_ES "Cambia la Memory Card que está cargada en la ranura derecha. Esta opción solo funcionará si la opción «Activar Memory Card 1» está activada. La Memory Card predeterminada es el índice 1."
#define OPTION_VAL_1_O35_ES "1 (valor predeterminado)"
#define BEETLE_OPT_PGXP_MODE_LABEL_ES "Modo de operación del PGXP"
#define BEETLE_OPT_PGXP_MODE_INFO_0_ES "Renderiza los objetos 3D con una precisión subpíxel, utilizando coordenadas de vértices de coma fija para minimizar la distorsión y temblores en objetos 3D que tenía el hardware original. «Solo en memoria» apenas da problemas de compatibilidad y se recomienda su uso general. «Memoria + CPU (inestable)» puede reducir aún más los temblores, pero tiene unos requisitos de rendimiento elevados y puede provocar fallos en la geometría."
#define OPTION_VAL_MEMORY_ONLY_ES "Solo en memoria"
#define OPTION_VAL_MEMORY_CPU_ES "Memoria + CPU (inestable)"
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_ES "Tolerancia a la geometría 2D del PGXP"
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_ES "Oculta los errores más evidentes de las operaciones del PGXP: este valor especifica la tolerancia con la que se conservarán los valores del PGXP en aquellas geometrías que no dispongan de la información de profundidad necesaria."
#define OPTION_VAL_0PX_ES "0 px"
#define OPTION_VAL_1PX_ES "1 px"
#define OPTION_VAL_2PX_ES "2 px"
#define OPTION_VAL_3PX_ES "3 px"
#define OPTION_VAL_4PX_ES "4 px"
#define OPTION_VAL_5PX_ES "5 px"
#define OPTION_VAL_6PX_ES "6 px"
#define OPTION_VAL_7PX_ES "7 px"
#define OPTION_VAL_8PX_ES "8 px"
#define BEETLE_OPT_PGXP_NCLIP_LABEL_ES "Selección de primitivos del PGXP"
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_ES "Utiliza la implementación de NCLIP del PGXP. Mejora el aspecto visual tapando los agujeros de aquellas geometrías que tengan coordenadas PGXP. Provoca cuelgues en ciertos juegos y circunstancias."
#define BEETLE_OPT_PGXP_VERTEX_LABEL_ES "Caché de vértices del PGXP"
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_ES "Cachea las posiciones de vértices mejoradas por el PGXP sean cacheadas para reutilizarlas al dibujar polígonos. Puede mejorar la alineación de los objetos y reducir los bordes, pero los falsos positivos a la hora de recurrir a la caché pueden producir defectos visuales. Actualmente se recomienda desactivar esta opción. Solo se aplicará cuando se active el modo de operación del PGXP. Solo funciona con los renderizadores por hardware."
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_ES "Texturizado fiel a la perspectiva del PGXP"
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_ES "Sustituye el mapeado de texturas afín nativo de PSX con un mapeado de texturas fiel a la perspectiva. Elimina las distorsiones posicionales y la deformación de texturas, produciendo texturas correctamente alineadas. Solo se aplicará cuando se active el modo de operación del PGXP. Solo funciona con los renderizadores por hardware."
#define BEETLE_OPT_LINE_RENDER_LABEL_ES "Arreglo para el efecto «Line-to-Quad»"
#define BEETLE_OPT_LINE_RENDER_INFO_0_ES "Selecciona el método de ejecución del hack para convertir líneas a rectángulos. Ciertos juegos (Doom, Hexen, Soul Blade, etcétera) dibujan líneas horizontales estirando triángulos de un píxel de altura a lo largo de la pantalla, que luego son rasterizados como una hilera de píxeles en el hardware original. Este hack detecta esos triángulos y los convierte en rectángulos según sea necesario, permitiendo que se muestren correctamente en los renderizadores por hardware y en resoluciones internas superiores a la nativa. La opción «Agresivo» es necesaria en ciertos títulos (p. ej.: Dark Forces, Duke Nukem) pero puede producir defectos visuales en otros. En caso de duda, seleccionar «Predeterminado»."
#define OPTION_VAL_DEFAULT_ES "Predeterminado"
#define OPTION_VAL_AGGRESSIVE_ES "Agresivo"
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_ES "Modificación para pantallas panorámicas"
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_ES "Renderiza los contenidos 3D en formato anamórfico y hace que el framebuffer emulado tenga una relación de aspecto panorámica. Produce los mejores resultados con juegos hechos completamente en 3D. Los elementos 2D se estirarán horizontalmente y podrían dejar de estar alineados."
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_ES "Relación de aspecto de la modificación para pantallas panorámicas"
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_ES "Selecciona la relación de aspecto usada por la modificación para pantallas panorámicas."
#define OPTION_VAL_16_9_ES NULL
#define OPTION_VAL_16_10_ES NULL
#define OPTION_VAL_18_9_ES NULL
#define OPTION_VAL_19_9_ES NULL
#define OPTION_VAL_20_9_ES NULL
#define OPTION_VAL_21_9_ES NULL
#define OPTION_VAL_32_9_ES NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_ES "Escalado de frecuencia de la CPU (velocidad)"
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_ES "Aumenta (o disminuye) la velocidad del reloj emulado de la CPU de PSX. Una velocidad superior puede eliminar las ralentizaciones y mejorar la velocidad de fotogramas en ciertos juegos a costa de aumentar los requisitos de rendimiento. Ten en cuenta que ciertos juegos incluyen un limitador de fotogramas interno y no ganarán beneficio alguno al aumentar la velocidad. Puede provocar que ciertos efectos vayan más rápido de lo normal en ciertos juegos."
#define OPTION_VAL_100_NATIVE_ES "100% (nativo)"
#define OPTION_VAL_210_ES "210 %"
#define OPTION_VAL_220_ES "220 %"
#define OPTION_VAL_230_ES "230 %"
#define OPTION_VAL_240_ES "240 %"
#define OPTION_VAL_250_ES "250 %"
#define OPTION_VAL_260_ES "260 %"
#define OPTION_VAL_270_ES "270 %"
#define OPTION_VAL_280_ES "280 %"
#define OPTION_VAL_290_ES "290 %"
#define OPTION_VAL_300_ES "300 %"
#define OPTION_VAL_310_ES "310 %"
#define OPTION_VAL_320_ES "320 %"
#define OPTION_VAL_330_ES "330 %"
#define OPTION_VAL_340_ES "340 %"
#define OPTION_VAL_350_ES "350 %"
#define OPTION_VAL_360_ES "360 %"
#define OPTION_VAL_370_ES "370 %"
#define OPTION_VAL_380_ES "380 %"
#define OPTION_VAL_390_ES "390 %"
#define OPTION_VAL_400_ES "400 %"
#define OPTION_VAL_410_ES "410 %"
#define OPTION_VAL_420_ES "420 %"
#define OPTION_VAL_430_ES "430 %"
#define OPTION_VAL_440_ES "440 %"
#define OPTION_VAL_450_ES "450 %"
#define OPTION_VAL_460_ES "460 %"
#define OPTION_VAL_470_ES "470 %"
#define OPTION_VAL_480_ES "480 %"
#define OPTION_VAL_490_ES "490 %"
#define OPTION_VAL_500_ES "500 %"
#define OPTION_VAL_510_ES "510 %"
#define OPTION_VAL_520_ES "520 %"
#define OPTION_VAL_530_ES "530 %"
#define OPTION_VAL_540_ES "540 %"
#define OPTION_VAL_550_ES "550 %"
#define OPTION_VAL_560_ES "560 %"
#define OPTION_VAL_570_ES "570 %"
#define OPTION_VAL_580_ES "580 %"
#define OPTION_VAL_590_ES "590 %"
#define OPTION_VAL_600_ES "600 %"
#define OPTION_VAL_610_ES "610 %"
#define OPTION_VAL_620_ES "620 %"
#define OPTION_VAL_630_ES "630 %"
#define OPTION_VAL_640_ES "640 %"
#define OPTION_VAL_650_ES "650 %"
#define OPTION_VAL_660_ES "660 %"
#define OPTION_VAL_670_ES "670 %"
#define OPTION_VAL_680_ES "680 %"
#define OPTION_VAL_690_ES "690 %"
#define OPTION_VAL_700_ES "700 %"
#define OPTION_VAL_710_ES "710 %"
#define OPTION_VAL_720_ES "720 %"
#define OPTION_VAL_730_ES "730 %"
#define OPTION_VAL_740_ES "740 %"
#define OPTION_VAL_750_ES "750 %"
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_ES "Acelerar el rasterizador de la GPU"
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_ES "Aumenta la velocidad del rasterizador 2D incluido en la GPU emulada de PSX. No mejora el renderizado 3D y su efecto suele ser limitado."
#define OPTION_VAL_32X_ES NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_ES "Acelerar el procesador GTE"
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_ES "Frena todas las operaciones emuladas del GTE (el coprocesador de la CPU para gráficos 3D) a una latencia constante de un ciclo. Aquellos juegos que utilicen en gran medida el GTE podrían mejorar su velocidad de fotogramas y la estabilidad en la duración de los mismos."
#define BEETLE_OPT_SKIP_BIOS_LABEL_ES "Omitir BIOS"
#define BEETLE_OPT_SKIP_BIOS_INFO_0_ES "Omite la animación de arranque de la BIOS de PlayStation que suele aparecer al cargar un contenido. Nota: Esta opción puede generar problemas de compatibilidad en varios juegos (juegos PAL con protección anticopia, Saga Frontier, etc.)."
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_ES "Omitir la BIOS (es necesario reiniciar)"
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_ES "Reemplaza la BIOS correspondiente a la región del contenido con una de región libre (si está disponible)."
#define OPTION_VAL_PSXONPSP_ES "BIOS de PS1 usada en PSP"
#define OPTION_VAL_PS1_ROM_ES "BIOS de PS1 usada en PS3"
#define BEETLE_OPT_RENDERER_LABEL_ES "Renderizador (es necesario reiniciar)"
#define BEETLE_OPT_RENDERER_INFO_0_ES "El renderizador por software es el más preciso, pero sus requisitos son muy elevados si se ejecuta a una resolución interna superior a la de la GPU. Los renderizadores por hardware son menos precisos, pero tienen un mejor rendimiento al usar resoluciones internas superiores y permiten varias mejoras gráficas. «Hardware (Automático)» seleccionará automáticamente el renderizador Vulkan u OpenGL según el controlador de vídeo actual del front-end de libretro. Si el controlador no es compatible con Vulkan o con OpenGL 3.3, se utilizará el renderizador por software como reserva del núcleo."
#define OPTION_VAL_HARDWARE_ES "Hardware (automático)"
#define OPTION_VAL_HARDWARE_GL_ES NULL
#define OPTION_VAL_HARDWARE_VK_ES NULL
#define OPTION_VAL_SOFTWARE_ES NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_ES "Framebuffer por software"
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_ES "Permite emular con precisión los efectos del framebuffer (p. ej.: desenfoque de movimiento, la espiral de batallas de FF7) al utilizar los renderizadores por hardware ejecutando una copia del renderizador por software a resolución nativa en un segundo plano. Al desactivar esta opción se omitirán estas operaciones (OpenGL) o se renderizarán en la GPU (Vulkan). Desactivar esta opción puede mejorar el rendimiento a costa de generar errores gráficos graves. En caso de duda, deja esta opción activada."
#define BEETLE_OPT_CPU_DYNAREC_LABEL_ES "Dynarec de CPU"
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_ES "Recompila de forma dinámica las instrucciones de la CPU a instrucciones nativas. Es más rápido que el intérprete, pero los intervalos de la CPU son menos precisos y puede provocar fallos."
#define OPTION_VAL_DISABLED_ES "Desactivada (intérprete Beetle)"
#define OPTION_VAL_EXECUTE_ES "Máximo rendimiento"
#define OPTION_VAL_EXECUTE_ONE_ES "Con control de los intervalos entre ciclos"
#define OPTION_VAL_RUN_INTERPRETER_ES "Intérprete lightrec"
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_ES "Invalidación de código del dynarec"
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_ES "Algunos juegos necesitan una invalidación completa y otros solo necesitan invalidar la DMA."
#define OPTION_VAL_FULL_ES "Completa"
#define OPTION_VAL_DMA_ES "Solo DMA (algo más rápida)"
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_ES "Ciclos de eventos de DMA/GPU/MDEC/Timer del dynarec"
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_ES "Indica el número máximo de ciclos ejecutados por la CPU antes de comprobar la DMA, la GPU, el MDEC o el temporizador (timer). Un valor superior será más rápido. Tiene menos repercusión en el intérprete Beetle que en el dynarec."
#define OPTION_VAL_128_ES "128 (valor predeterminado)"
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_ES "Muestras de la SPU mediante dynarec"
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_ES "Indica el número máximo de muestras de la SPU que se ejecutarán antes de comprobar las actualizaciones de la SPU. Un valor superior será más rápido, pero un valor que no sea 1 provocará fallos de sonido en algunos juegos."
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_ES "Barrido de señal según núcleo"
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_ES "Ajusta el barrido de señal que indicará el núcleo al front-end. «Cambiar automáticamente» permite que el núcleo cambie entre los barridos progresivo y entrelazado, pero pueden provocar reinicios en los controladores de vídeo y audio del front-end."
#define OPTION_VAL_FORCE_PROGRESSIVE_ES "Tasa progresiva"
#define OPTION_VAL_FORCE_INTERLACED_ES "Forzar barrido entrelazado"
#define OPTION_VAL_AUTO_TOGGLE_ES "Cambiar automáticamente"
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_ES "Anular sincronía de vídeo PAL (europea)"
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_ES "Debido a la diferencia entre estándares, los juegos PAL suelen parecer más lentos que sus versiones NTSC, tanto estadounidenses como japonesas. Esta opción puede anular la velocidad de vídeo PAL para intentar ejecutar dichos juegos con la velocidad de fotogramas NTSC. Esta opción no produce efecto alguno en contenidos NTSC."
#define BEETLE_OPT_ASPECT_RATIO_LABEL_ES "Relación de aspecto del núcleo"
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_ES "Selecciona la relación de aspecto del núcleo. Este ajuste será ignorado si se activan las opciones «Modificación para pantallas panorámicas» o «Mostrar la VRAM completa»."
#define OPTION_VAL_CORRECTED_ES "Corregida"
#define OPTION_VAL_UNCORRECTED_ES "Sin corregir"
#define OPTION_VAL_4_3_ES "Forzar 4:3"
#define OPTION_VAL_NTSC_ES "Forzar NTSC"
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_ES "Recortar sobrebarrido horizontal"
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_ES "«Ninguno» conserva los bordes (columnas negras a ambos lados en el caso de imágenes NTSC, bordes por los cuatro costados en imágenes PAL) para simular las barras negras que produce el hardware real de PSX en una señal de vídeo analógica. «Estático» se limita a eliminar los bordes horizontales, mientras que «Dinámico» elimina todos los bordes."
#define OPTION_VAL_DISABLED_O58_ES "No compartir"
#define OPTION_VAL_STATIC_ES "Estático"
#define OPTION_VAL_SMART_ES "Dinámico (por defecto)"
#define BEETLE_OPT_IMAGE_CROP_LABEL_ES "Recorte adicional"
#define BEETLE_OPT_IMAGE_CROP_INFO_0_ES "Al activar la opción «Recortar sobrebarrido horizontal», esta opción permite reducir el ancho de la imagen recortada usando un valor concreto en píxeles. Solo funciona con el renderizador por software."
#define OPTION_VAL_9PX_ES "9 px"
#define OPTION_VAL_10PX_ES "10 px"
#define OPTION_VAL_11PX_ES "11 px"
#define OPTION_VAL_12PX_ES "12 px"
#define OPTION_VAL_13PX_ES "13 px"
#define OPTION_VAL_14PX_ES "14 px"
#define OPTION_VAL_15PX_ES "15 px"
#define OPTION_VAL_16PX_ES "16 px"
#define OPTION_VAL_17PX_ES "17 px"
#define OPTION_VAL_18PX_ES "18 px"
#define OPTION_VAL_19PX_ES "19 px"
#define OPTION_VAL_20PX_ES "20 px"
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_ES "Desplazar imagen recortada"
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_ES "Al activar la opción «Recortar sobrebarrido horizontal», esta opción permite desplazar horizontalmente la imagen recortada hacia la derecha (valores positivos) o hacia la izquierda (valores negativos) usando un valor concreto en píxeles. Utilizar para corregir problemas de alineación. Solo funciona con el renderizador por software."
#define OPTION_VAL_12PX_O60_ES "-12 px"
#define OPTION_VAL_11PX_O60_ES "-11 px"
#define OPTION_VAL_10PX_O60_ES "-10 px"
#define OPTION_VAL_9PX_O60_ES "-9 px"
#define OPTION_VAL_8PX_O60_ES "-8 px"
#define OPTION_VAL_7PX_O60_ES "-7 px"
#define OPTION_VAL_6PX_O60_ES "-6 px"
#define OPTION_VAL_5PX_O60_ES "-5 px"
#define OPTION_VAL_4PX_O60_ES "-4 px"
#define OPTION_VAL_3PX_O60_ES "-3 px"
#define OPTION_VAL_2PX_O60_ES "-2 px"
#define OPTION_VAL_1PX_O60_ES "-1 px"
#define OPTION_VAL_1PX_O60_0_ES "+1 px"
#define OPTION_VAL_2PX_O60_0_ES "+2 px"
#define OPTION_VAL_3PX_O60_0_ES "+3 px"
#define OPTION_VAL_4PX_O60_0_ES "+4 px"
#define OPTION_VAL_5PX_O60_0_ES "+5 px"
#define OPTION_VAL_6PX_O60_0_ES "+6 px"
#define OPTION_VAL_7PX_O60_0_ES "+7 px"
#define OPTION_VAL_8PX_O60_0_ES "+8 px"
#define OPTION_VAL_9PX_O60_0_ES "+9 px"
#define OPTION_VAL_10PX_O60_0_ES "+10 px"
#define OPTION_VAL_11PX_O60_0_ES "+11 px"
#define OPTION_VAL_12PX_O60_0_ES "+12 px"
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_ES "Desplazar imagen horizontal (ciclos de GPU)"
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_ES "Especifica el número de ciclos de GPU con los que desplazar la imagen. Los valores positivos mueven la imagen hacia la derecha y los negativos hacia la izquierda. Solo funciona con los renderizadores por hardware."
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_ES "Línea de barrido inicial en formato NTSC"
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_ES "Selecciona la primera línea de barrido que se mostrará al ejecutar contenidos NTSC. Un valor superior a cero reducirá la altura de las imágenes generadas recortando los píxeles de la parte superior. Puede servir para evitar el efecto «letterboxing»."
#define OPTION_VAL_0_O62_ES "0 (valor predeterminado)"
#define BEETLE_OPT_LAST_SCANLINE_LABEL_ES "Línea de barrido final en formato NTSC"
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_ES "Selecciona la última línea de barrido que se mostrará al ejecutar contenidos NTSC. Un valor inferior a 239 reducirá la altura de las imágenes generadas recortando los píxeles de la parte inferior. Puede servir para evitar el efecto «letterboxing»."
#define OPTION_VAL_239_ES "239 (por defecto)"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_ES "Línea de barrido inicial en formato PAL"
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_ES "Selecciona la primera línea de barrido que se mostrará al ejecutar contenidos PAL. Un valor superior a cero reducirá la altura de las imágenes generadas recortando los píxeles de la parte superior. Puede servir para evitar el efecto «letterboxing»."
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_ES "Línea de barrido final en formato PAL"
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_ES "Selecciona la última línea de barrido que se mostrará al ejecutar contenidos PAL. Un valor inferior a 287 reducirá la altura de las imágenes generadas recortando los píxeles de la parte inferior. Puede servir para evitar el efecto «letterboxing»."
#define OPTION_VAL_287_ES "287 (por defecto)"
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_ES "Método de acceso al CD (es necesario reiniciar)"
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_ES "Selecciona el método utilizado para leer datos de las imágenes de disco del contenido. «Sincrónico» simula el hardware original, «Asincrónico» puede reducir los tirones en aquellos dispositivos que tengan un almacenamiento lento y «Precacheado» carga la imagen de disco entera en memoria al ejecutar el contenido, lo que puede mejorar los tiempos de carga del juego a costa de retrasar el arranque inicial. «Precacheado» puede producir problemas en sistemas con poca RAM."
#define OPTION_VAL_SYNC_ES "Sincrónico"
#define OPTION_VAL_ASYNC_ES "Asincrónico"
#define OPTION_VAL_PRECACHE_ES "Precacheado"
#define BEETLE_OPT_CD_FASTLOAD_LABEL_ES "Velocidad de lectura del CD"
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_ES "Selecciona el multiplicador de velocidad de acceso al disco. Un valor superior a «2x (nativa)» puede reducir en gran medida los tiempos de carga de los juegos, pero produciendo errores de sincronía. Algunos juegos podrían no funcionar correctamente si este valor es superior a cierta cifra."
#define OPTION_VAL_2X_NATIVE_ES "2x (nativa)"
#define OPTION_VAL_6X_ES NULL
#define OPTION_VAL_10X_ES NULL
#define OPTION_VAL_12X_ES NULL
#define OPTION_VAL_14X_ES NULL

struct retro_core_option_v2_category option_cats_es[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_ES,
      CATEGORY_VIDEO_INFO_0_ES
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_ES,
      CATEGORY_OSD_INFO_0_ES
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_ES,
      CATEGORY_INPUT_INFO_0_ES
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_ES,
      CATEGORY_MEMCARDS_INFO_0_ES
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_ES,
      CATEGORY_PGXP_INFO_0_ES
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_ES,
      CATEGORY_HACKS_INFO_0_ES
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_es[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_ES,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_ES,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_ES },
         { "2x",         OPTION_VAL_2X_ES },
         { "4x",         OPTION_VAL_4X_ES },
         { "8x",         OPTION_VAL_8X_ES },
         { "16x",        OPTION_VAL_16X_ES },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_ES,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_ES,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_ES },
         { "32bpp",         OPTION_VAL_32BPP_ES },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_ES,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_ES,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_ES },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_ES },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_ES,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_ES,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_ES,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_ES,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_ES },
         { "SABR",     OPTION_VAL_SABR_ES },
         { "xBR",      OPTION_VAL_XBR_ES },
         { "bilinear", OPTION_VAL_BILINEAR_ES },
         { "3-point",  OPTION_VAL_3_POINT_ES },
         { "JINC2",    OPTION_VAL_JINC2_ES },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_ES,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_ES },
         { "all", OPTION_VAL_ALL_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_ES,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_ES },
         { "all", OPTION_VAL_ALL_ES },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_ES,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_ES,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_ES,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_ES,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_ES },
         { "2x",  OPTION_VAL_2X_ES },
         { "4x",  OPTION_VAL_4X_ES },
         { "8x",  OPTION_VAL_8X_ES },
         { "16x", OPTION_VAL_16X_ES },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_ES,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_ES,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_ES,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_ES,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_ES,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_ES,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_ES,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_ES,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_ES,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_ES,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_ES,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_ES,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_ES,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_ES,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_ES },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_ES },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_ES },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_ES },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_ES },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_ES },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_ES },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_ES },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_ES },
         { "l3+r3",                    OPTION_VAL_L3_R3_ES },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_ES,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_ES,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_ES },
         { "1", OPTION_VAL_1_ES },
         { "2", OPTION_VAL_2_ES },
         { "3", OPTION_VAL_3_ES },
         { "4", OPTION_VAL_4_ES },
         { "5", OPTION_VAL_5_ES },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_ES,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_ES,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_ES,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_ES,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_ES,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_ES },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_ES },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_ES,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_ES,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_ES },
         { "dot",   OPTION_VAL_DOT_ES },
         { "off",   OPTION_VAL_OFF_ES },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_ES,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_ES,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_ES },
         { "blue", OPTION_VAL_BLUE_ES },
         { "green", OPTION_VAL_GREEN_ES },
         { "orange", OPTION_VAL_ORANGE_ES },
         { "yellow", OPTION_VAL_YELLOW_ES },
         { "cyan", OPTION_VAL_CYAN_ES },
         { "pink", OPTION_VAL_PINK_ES },
         { "purple", OPTION_VAL_PURPLE_ES },
         { "black", OPTION_VAL_BLACK_ES },
         { "white", OPTION_VAL_WHITE_ES },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_ES,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_ES,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_ES },
         { "red", OPTION_VAL_RED_ES },
         { "green", OPTION_VAL_GREEN_ES },
         { "orange", OPTION_VAL_ORANGE_ES },
         { "yellow", OPTION_VAL_YELLOW_ES },
         { "cyan", OPTION_VAL_CYAN_ES },
         { "pink", OPTION_VAL_PINK_ES },
         { "purple", OPTION_VAL_PURPLE_ES },
         { "black", OPTION_VAL_BLACK_ES },
         { "white", OPTION_VAL_WHITE_ES },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_ES,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_ES,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_ES },
         { "10%",  OPTION_VAL_10_ES },
         { "15%",  OPTION_VAL_15_ES },
         { "20%",  OPTION_VAL_20_ES },
         { "25%",  OPTION_VAL_25_ES },
         { "30%",  OPTION_VAL_30_ES },
         { "35%",  OPTION_VAL_35_ES },
         { "40%",  OPTION_VAL_40_ES },
         { "45%",  OPTION_VAL_45_ES },
         { "50%",  OPTION_VAL_50_ES },
         { "55%",  OPTION_VAL_55_ES },
         { "60%",  OPTION_VAL_60_ES },
         { "65%",  OPTION_VAL_65_ES },
         { "70%",  OPTION_VAL_70_ES },
         { "75%",  OPTION_VAL_75_ES },
         { "80%",  OPTION_VAL_80_ES },
         { "85%",  OPTION_VAL_85_ES },
         { "90%",  OPTION_VAL_90_ES },
         { "95%",  OPTION_VAL_95_ES },
         { "100%", OPTION_VAL_100_ES },
         { "105%", OPTION_VAL_105_ES },
         { "110%", OPTION_VAL_110_ES },
         { "115%", OPTION_VAL_115_ES },
         { "120%", OPTION_VAL_120_ES },
         { "125%", OPTION_VAL_125_ES },
         { "130%", OPTION_VAL_130_ES },
         { "135%", OPTION_VAL_135_ES },
         { "140%", OPTION_VAL_140_ES },
         { "145%", OPTION_VAL_145_ES },
         { "150%", OPTION_VAL_150_ES },
         { "155%", OPTION_VAL_155_ES },
         { "160%", OPTION_VAL_160_ES },
         { "165%", OPTION_VAL_165_ES },
         { "170%", OPTION_VAL_170_ES },
         { "175%", OPTION_VAL_175_ES },
         { "180%", OPTION_VAL_180_ES },
         { "185%", OPTION_VAL_185_ES },
         { "190%", OPTION_VAL_190_ES },
         { "195%", OPTION_VAL_195_ES },
         { "200%", OPTION_VAL_200_ES },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_ES,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_ES,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_ES },
         { "quadratic", OPTION_VAL_QUADRATIC_ES },
         { "cubic",     OPTION_VAL_CUBIC_ES },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_ES,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_ES,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_ES },
         { "5%",  OPTION_VAL_5_O28_ES },
         { "10%", OPTION_VAL_10_ES },
         { "15%", OPTION_VAL_15_ES },
         { "20%", OPTION_VAL_20_ES },
         { "25%", OPTION_VAL_25_ES },
         { "30%", OPTION_VAL_30_ES },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_ES,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_ES,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_ES },
         { "mednafen", OPTION_VAL_MEDNAFEN_ES },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_ES,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_ES,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_ES,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_ES,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_ES,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_ES,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_ES,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_ES,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_ES },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_ES,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_ES,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_ES },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_ES,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_ES,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_ES },
         { "1px", OPTION_VAL_1PX_ES },
         { "2px", OPTION_VAL_2PX_ES },
         { "3px", OPTION_VAL_3PX_ES },
         { "4px", OPTION_VAL_4PX_ES },
         { "5px", OPTION_VAL_5PX_ES },
         { "6px", OPTION_VAL_6PX_ES },
         { "7px", OPTION_VAL_7PX_ES },
         { "8px", OPTION_VAL_8PX_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_ES,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_ES,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_ES,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_ES,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_ES,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_ES,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_ES,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_ES },
         { "aggressive", OPTION_VAL_AGGRESSIVE_ES },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_ES,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_ES,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_ES },
         { "16:10", OPTION_VAL_16_10_ES },
         { "18:9",  OPTION_VAL_18_9_ES },
         { "19:9",  OPTION_VAL_19_9_ES },
         { "20:9",  OPTION_VAL_20_9_ES },
         { "21:9",  OPTION_VAL_21_9_ES }, // 64:27
         { "32:9",  OPTION_VAL_32_9_ES },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_ES,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_ES },
         { "60%",           OPTION_VAL_60_ES },
         { "70%",           OPTION_VAL_70_ES },
         { "80%",           OPTION_VAL_80_ES },
         { "90%",           OPTION_VAL_90_ES },
         { "100%(native)", OPTION_VAL_100_NATIVE_ES },
         { "110%",          OPTION_VAL_110_ES },
         { "120%",          OPTION_VAL_120_ES },
         { "130%",          OPTION_VAL_130_ES },
         { "140%",          OPTION_VAL_140_ES },
         { "150%",          OPTION_VAL_150_ES },
         { "160%",          OPTION_VAL_160_ES },
         { "170%",          OPTION_VAL_170_ES },
         { "180%",          OPTION_VAL_180_ES },
         { "190%",          OPTION_VAL_190_ES },
         { "200%",          OPTION_VAL_200_ES },
         { "210%",          OPTION_VAL_210_ES },
         { "220%",          OPTION_VAL_220_ES },
         { "230%",          OPTION_VAL_230_ES },
         { "240%",          OPTION_VAL_240_ES },
         { "250%",          OPTION_VAL_250_ES },
         { "260%",          OPTION_VAL_260_ES },
         { "270%",          OPTION_VAL_270_ES },
         { "280%",          OPTION_VAL_280_ES },
         { "290%",          OPTION_VAL_290_ES },
         { "300%",          OPTION_VAL_300_ES },
         { "310%",          OPTION_VAL_310_ES },
         { "320%",          OPTION_VAL_320_ES },
         { "330%",          OPTION_VAL_330_ES },
         { "340%",          OPTION_VAL_340_ES },
         { "350%",          OPTION_VAL_350_ES },
         { "360%",          OPTION_VAL_360_ES },
         { "370%",          OPTION_VAL_370_ES },
         { "380%",          OPTION_VAL_380_ES },
         { "390%",          OPTION_VAL_390_ES },
         { "400%",          OPTION_VAL_400_ES },
         { "410%",          OPTION_VAL_410_ES },
         { "420%",          OPTION_VAL_420_ES },
         { "430%",          OPTION_VAL_430_ES },
         { "440%",          OPTION_VAL_440_ES },
         { "450%",          OPTION_VAL_450_ES },
         { "460%",          OPTION_VAL_460_ES },
         { "470%",          OPTION_VAL_470_ES },
         { "480%",          OPTION_VAL_480_ES },
         { "490%",          OPTION_VAL_490_ES },
         { "500%",          OPTION_VAL_500_ES },
         { "510%",          OPTION_VAL_510_ES },
         { "520%",          OPTION_VAL_520_ES },
         { "530%",          OPTION_VAL_530_ES },
         { "540%",          OPTION_VAL_540_ES },
         { "550%",          OPTION_VAL_550_ES },
         { "560%",          OPTION_VAL_560_ES },
         { "570%",          OPTION_VAL_570_ES },
         { "580%",          OPTION_VAL_580_ES },
         { "590%",          OPTION_VAL_590_ES },
         { "600%",          OPTION_VAL_600_ES },
         { "610%",          OPTION_VAL_610_ES },
         { "620%",          OPTION_VAL_620_ES },
         { "630%",          OPTION_VAL_630_ES },
         { "640%",          OPTION_VAL_640_ES },
         { "650%",          OPTION_VAL_650_ES },
         { "660%",          OPTION_VAL_660_ES },
         { "670%",          OPTION_VAL_670_ES },
         { "680%",          OPTION_VAL_680_ES },
         { "690%",          OPTION_VAL_690_ES },
         { "700%",          OPTION_VAL_700_ES },
         { "710%",          OPTION_VAL_710_ES },
         { "720%",          OPTION_VAL_720_ES },
         { "730%",          OPTION_VAL_730_ES },
         { "740%",          OPTION_VAL_740_ES },
         { "750%",          OPTION_VAL_750_ES },
         { NULL, NULL },
      },
      "100%(native)"
   },
   {
      BEETLE_OPT(gpu_overclock),
      BEETLE_OPT_GPU_OVERCLOCK_LABEL_ES,
      NULL,
      BEETLE_OPT_GPU_OVERCLOCK_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_ES },
         { "2x",         OPTION_VAL_2X_ES },
         { "4x",         OPTION_VAL_4X_ES },
         { "8x",         OPTION_VAL_8X_ES },
         { "16x",        OPTION_VAL_16X_ES },
         { "32x",        OPTION_VAL_32X_ES },
         { NULL, NULL },
      },
      "1x(native)"
   },
   {
      BEETLE_OPT(gte_overclock),
      BEETLE_OPT_GTE_OVERCLOCK_LABEL_ES,
      NULL,
      BEETLE_OPT_GTE_OVERCLOCK_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(skip_bios),
      BEETLE_OPT_SKIP_BIOS_LABEL_ES,
      NULL,
      BEETLE_OPT_SKIP_BIOS_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(override_bios),
      BEETLE_OPT_OVERRIDE_BIOS_LABEL_ES,
      NULL,
      BEETLE_OPT_OVERRIDE_BIOS_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "psxonpsp",  OPTION_VAL_PSXONPSP_ES },
         { "ps1_rom",  OPTION_VAL_PS1_ROM_ES },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(renderer),
      BEETLE_OPT_RENDERER_LABEL_ES,
      NULL,
      BEETLE_OPT_RENDERER_INFO_0_ES,
      NULL,
      NULL,
      {
         { "hardware",    OPTION_VAL_HARDWARE_ES },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
         { "hardware_gl", OPTION_VAL_HARDWARE_GL_ES },
#endif
#if defined(HAVE_VULKAN)
         { "hardware_vk", OPTION_VAL_HARDWARE_VK_ES },
#endif
         { "software",    OPTION_VAL_SOFTWARE_ES },
         { NULL, NULL },
      },
      "hardware"
   },
   {
      BEETLE_OPT(renderer_software_fb),
      BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_ES,
      NULL,
      BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_ES,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_LIGHTREC)
   {
      BEETLE_OPT(cpu_dynarec),
      BEETLE_OPT_CPU_DYNAREC_LABEL_ES,
      NULL,
      BEETLE_OPT_CPU_DYNAREC_INFO_0_ES,
      NULL,
      NULL,
      {
         { "disabled", OPTION_VAL_DISABLED_ES },
         { "execute",  OPTION_VAL_EXECUTE_ES },
         { "execute_one",  OPTION_VAL_EXECUTE_ONE_ES },
         { "run_interpreter", OPTION_VAL_RUN_INTERPRETER_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(dynarec_invalidate),
      BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_ES,
      NULL,
      BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_ES,
      NULL,
      NULL,
      {
         { "full", OPTION_VAL_FULL_ES },
         { "dma",  OPTION_VAL_DMA_ES },
         { NULL, NULL },
      },
      "full"
   },
   {
      BEETLE_OPT(dynarec_eventcycles),
      BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_ES,
      NULL,
      BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "128",  OPTION_VAL_128_ES },
         { "256",  NULL },
         { "384",  NULL },
         { "512",  NULL },
         { "640",  NULL },
         { "768",  NULL },
         { "896",  NULL },
         { "1024",  NULL },
         { "1152",  NULL },
         { "1280",  NULL },
         { "1408",  NULL },
         { "1536",  NULL },
         { "1664",  NULL },
         { "1792",  NULL },
         { "1920",  NULL },
         { "2048",  NULL },
         { NULL, NULL },
      },
      "128"
   },
   {
      BEETLE_OPT(dynarec_spu_samples),
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_ES,
      NULL,
      BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_ES,
      NULL,
      "hacks",
      {
         { "1",  OPTION_VAL_1_O35_ES },
         { "4",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "1"
   },
#endif
   {
      BEETLE_OPT(core_timing_fps),
      BEETLE_OPT_CORE_TIMING_FPS_LABEL_ES,
      NULL,
      BEETLE_OPT_CORE_TIMING_FPS_INFO_0_ES,
      NULL,
      NULL,
      {
         { "force_progressive", OPTION_VAL_FORCE_PROGRESSIVE_ES },
         { "force_interlaced",  OPTION_VAL_FORCE_INTERLACED_ES },
         { "auto_toggle", OPTION_VAL_AUTO_TOGGLE_ES },
      },
      "force_progressive"
   },
   {
      BEETLE_OPT(pal_video_timing_override),
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_ES,
      NULL,
      BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(aspect_ratio),
      BEETLE_OPT_ASPECT_RATIO_LABEL_ES,
      NULL,
      BEETLE_OPT_ASPECT_RATIO_INFO_0_ES,
      NULL,
      "video",
      {
         { "corrected", OPTION_VAL_CORRECTED_ES },
         { "uncorrected", OPTION_VAL_UNCORRECTED_ES },
         { "4:3",  OPTION_VAL_4_3_ES },
         { "ntsc", OPTION_VAL_NTSC_ES },
      },
      "corrected"
   },
   {
      BEETLE_OPT(crop_overscan),
      BEETLE_OPT_CROP_OVERSCAN_LABEL_ES,
      NULL,
      BEETLE_OPT_CROP_OVERSCAN_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled",  OPTION_VAL_DISABLED_O58_ES },
         { "static",  OPTION_VAL_STATIC_ES },
         { "smart", OPTION_VAL_SMART_ES },
         { NULL, NULL },
      },
      "smart"
   },
   {
      BEETLE_OPT(image_crop),
      BEETLE_OPT_IMAGE_CROP_LABEL_ES,
      NULL,
      BEETLE_OPT_IMAGE_CROP_INFO_0_ES,
      NULL,
      "video",
      {
         { "disabled", "0" },
         { "1px",      OPTION_VAL_1PX_ES },
         { "2px",      OPTION_VAL_2PX_ES },
         { "3px",      OPTION_VAL_3PX_ES },
         { "4px",      OPTION_VAL_4PX_ES },
         { "5px",      OPTION_VAL_5PX_ES },
         { "6px",      OPTION_VAL_6PX_ES },
         { "7px",      OPTION_VAL_7PX_ES },
         { "8px",      OPTION_VAL_8PX_ES },
         { "9px",      OPTION_VAL_9PX_ES },
         { "10px",     OPTION_VAL_10PX_ES },
         { "11px",     OPTION_VAL_11PX_ES },
         { "12px",     OPTION_VAL_12PX_ES },
         { "13px",     OPTION_VAL_13PX_ES },
         { "14px",     OPTION_VAL_14PX_ES },
         { "15px",     OPTION_VAL_15PX_ES },
         { "16px",     OPTION_VAL_16PX_ES },
         { "17px",     OPTION_VAL_17PX_ES },
         { "18px",     OPTION_VAL_18PX_ES },
         { "19px",     OPTION_VAL_19PX_ES },
         { "20px",     OPTION_VAL_20PX_ES },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(image_offset),
      BEETLE_OPT_IMAGE_OFFSET_LABEL_ES,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_INFO_0_ES,
      NULL,
      "video",
      {
         { "-12px",    OPTION_VAL_12PX_O60_ES },
         { "-11px",    OPTION_VAL_11PX_O60_ES },
         { "-10px",    OPTION_VAL_10PX_O60_ES },
         { "-9px",     OPTION_VAL_9PX_O60_ES },
         { "-8px",     OPTION_VAL_8PX_O60_ES },
         { "-7px",     OPTION_VAL_7PX_O60_ES },
         { "-6px",     OPTION_VAL_6PX_O60_ES },
         { "-5px",     OPTION_VAL_5PX_O60_ES },
         { "-4px",     OPTION_VAL_4PX_O60_ES },
         { "-3px",     OPTION_VAL_3PX_O60_ES },
         { "-2px",     OPTION_VAL_2PX_O60_ES },
         { "-1px",     OPTION_VAL_1PX_O60_ES },
         { "disabled", "0" },
         { "+1px",     OPTION_VAL_1PX_O60_0_ES },
         { "+2px",     OPTION_VAL_2PX_O60_0_ES },
         { "+3px",     OPTION_VAL_3PX_O60_0_ES },
         { "+4px",     OPTION_VAL_4PX_O60_0_ES },
         { "+5px",     OPTION_VAL_5PX_O60_0_ES },
         { "+6px",     OPTION_VAL_6PX_O60_0_ES },
         { "+7px",     OPTION_VAL_7PX_O60_0_ES },
         { "+8px",     OPTION_VAL_8PX_O60_0_ES },
         { "+9px",     OPTION_VAL_9PX_O60_0_ES },
         { "+10px",    OPTION_VAL_10PX_O60_0_ES },
         { "+11px",    OPTION_VAL_11PX_O60_0_ES },
         { "+12px",    OPTION_VAL_12PX_O60_0_ES },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(image_offset_cycles),
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_ES,
      NULL,
      BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_ES,
      NULL,
      "video",
      {
         { "-40",      NULL },
         { "-39",      NULL },
         { "-38",      NULL },
         { "-37",      NULL },
         { "-36",      NULL },
         { "-35",      NULL },
         { "-34",      NULL },
         { "-33",      NULL },
         { "-32",      NULL },
         { "-31",      NULL },
         { "-30",      NULL },
         { "-29",      NULL },
         { "-28",      NULL },
         { "-27",      NULL },
         { "-26",      NULL },
         { "-25",      NULL },
         { "-24",      NULL },
         { "-23",      NULL },
         { "-22",      NULL },
         { "-21",      NULL },
         { "-20",      NULL },
         { "-19",      NULL },
         { "-18",      NULL },
         { "-17",      NULL },
         { "-16",      NULL },
         { "-15",      NULL },
         { "-14",      NULL },
         { "-13",      NULL },
         { "-12",      NULL },
         { "-11",      NULL },
         { "-10",      NULL },
         { "-9",       NULL },
         { "-8",       NULL },
         { "-7",       NULL },
         { "-6",       NULL },
         { "-5",       NULL },
         { "-4",       NULL },
         { "-3",       NULL },
         { "-2",       NULL },
         { "-1",       NULL },
         { "0",        "0" },
         { "+1",       NULL },
         { "+2",       NULL },
         { "+3",       NULL },
         { "+4",       NULL },
         { "+5",       NULL },
         { "+6",       NULL },
         { "+7",       NULL },
         { "+8",       NULL },
         { "+9",       NULL },
         { "+10",      NULL },
         { "+11",      NULL },
         { "+12",      NULL },
         { "+13",      NULL },
         { "+14",      NULL },
         { "+15",      NULL },
         { "+16",      NULL },
         { "+17",      NULL },
         { "+18",      NULL },
         { "+19",      NULL },
         { "+20",      NULL },
         { "+21",      NULL },
         { "+22",      NULL },
         { "+23",      NULL },
         { "+24",      NULL },
         { "+25",      NULL },
         { "+26",      NULL },
         { "+27",      NULL },
         { "+28",      NULL },
         { "+29",      NULL },
         { "+30",      NULL },
         { "+31",      NULL },
         { "+32",      NULL },
         { "+33",      NULL },
         { "+34",      NULL },
         { "+35",      NULL },
         { "+36",      NULL },
         { "+37",      NULL },
         { "+38",      NULL },
         { "+39",      NULL },
         { "+40",      NULL },
         { NULL, NULL},
      },
      "0"
   },
#endif
   {
      BEETLE_OPT(initial_scanline),
      BEETLE_OPT_INITIAL_SCANLINE_LABEL_ES,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_INFO_0_ES,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_ES },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline),
      BEETLE_OPT_LAST_SCANLINE_LABEL_ES,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_INFO_0_ES,
      NULL,
      "video",
      {
         { "210", NULL },
         { "211", NULL },
         { "212", NULL },
         { "213", NULL },
         { "214", NULL },
         { "215", NULL },
         { "216", NULL },
         { "217", NULL },
         { "218", NULL },
         { "219", NULL },
         { "220", NULL },
         { "221", NULL },
         { "222", NULL },
         { "223", NULL },
         { "224", NULL },
         { "225", NULL },
         { "226", NULL },
         { "227", NULL },
         { "228", NULL },
         { "229", NULL },
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", OPTION_VAL_239_ES },
         { NULL, NULL },
      },
      "239"
   },
   {
      BEETLE_OPT(initial_scanline_pal),
      BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_ES,
      NULL,
      BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_ES,
      NULL,
      "video",
      {
         { "0",  OPTION_VAL_0_O62_ES },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10", NULL },
         { "11", NULL },
         { "12", NULL },
         { "13", NULL },
         { "14", NULL },
         { "15", NULL },
         { "16", NULL },
         { "17", NULL },
         { "18", NULL },
         { "19", NULL },
         { "20", NULL },
         { "21", NULL },
         { "22", NULL },
         { "23", NULL },
         { "24", NULL },
         { "25", NULL },
         { "26", NULL },
         { "27", NULL },
         { "28", NULL },
         { "29", NULL },
         { "30", NULL },
         { "31", NULL },
         { "32", NULL },
         { "33", NULL },
         { "34", NULL },
         { "35", NULL },
         { "36", NULL },
         { "37", NULL },
         { "38", NULL },
         { "39", NULL },
         { "40", NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(last_scanline_pal),
      BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_ES,
      NULL,
      BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_ES,
      NULL,
      "video",
      {
         { "230", NULL },
         { "231", NULL },
         { "232", NULL },
         { "233", NULL },
         { "234", NULL },
         { "235", NULL },
         { "236", NULL },
         { "237", NULL },
         { "238", NULL },
         { "239", NULL },
         { "240", NULL },
         { "241", NULL },
         { "242", NULL },
         { "243", NULL },
         { "244", NULL },
         { "245", NULL },
         { "246", NULL },
         { "247", NULL },
         { "248", NULL },
         { "249", NULL },
         { "250", NULL },
         { "251", NULL },
         { "252", NULL },
         { "253", NULL },
         { "254", NULL },
         { "255", NULL },
         { "256", NULL },
         { "257", NULL },
         { "258", NULL },
         { "259", NULL },
         { "260", NULL },
         { "261", NULL },
         { "262", NULL },
         { "263", NULL },
         { "264", NULL },
         { "265", NULL },
         { "266", NULL },
         { "267", NULL },
         { "268", NULL },
         { "269", NULL },
         { "270", NULL },
         { "271", NULL },
         { "272", NULL },
         { "273", NULL },
         { "274", NULL },
         { "275", NULL },
         { "276", NULL },
         { "277", NULL },
         { "278", NULL },
         { "279", NULL },
         { "280", NULL },
         { "281", NULL },
         { "282", NULL },
         { "283", NULL },
         { "284", NULL },
         { "285", NULL },
         { "286", NULL },
         { "287", OPTION_VAL_287_ES },
         { NULL, NULL },
      },
      "287"
   },
#ifndef EMSCRIPTEN
   {
      BEETLE_OPT(cd_access_method),
      BEETLE_OPT_CD_ACCESS_METHOD_LABEL_ES,
      NULL,
      BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_ES,
      NULL,
      NULL,
      {
         { "sync",     OPTION_VAL_SYNC_ES },
         { "async",    OPTION_VAL_ASYNC_ES },
         { "precache", OPTION_VAL_PRECACHE_ES },
         { NULL, NULL },
      },
      "sync"
   },
#endif
   {
      BEETLE_OPT(cd_fastload),
      BEETLE_OPT_CD_FASTLOAD_LABEL_ES,
      NULL,
      BEETLE_OPT_CD_FASTLOAD_INFO_0_ES,
      NULL,
      NULL,
      {
         { "2x(native)", OPTION_VAL_2X_NATIVE_ES },
         { "4x",          OPTION_VAL_4X_ES },
         { "6x",          OPTION_VAL_6X_ES },
         { "8x",          OPTION_VAL_8X_ES },
         { "10x",         OPTION_VAL_10X_ES },
         { "12x",         OPTION_VAL_12X_ES },
         { "14x",         OPTION_VAL_14X_ES },
         { NULL, NULL },
      },
      "2x(native)"
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_es = {
   option_cats_es,
   option_defs_es
};

/* RETRO_LANGUAGE_FA */

#define CATEGORY_VIDEO_LABEL_FA "ویدیو"
#define CATEGORY_VIDEO_INFO_0_FA NULL
#define CATEGORY_OSD_LABEL_FA NULL
#define CATEGORY_OSD_INFO_0_FA NULL
#define CATEGORY_INPUT_LABEL_FA "داده"
#define CATEGORY_INPUT_INFO_0_FA NULL
#define CATEGORY_MEMCARDS_LABEL_FA NULL
#define CATEGORY_MEMCARDS_INFO_0_FA NULL
#define CATEGORY_PGXP_LABEL_FA NULL
#define CATEGORY_PGXP_INFO_0_FA NULL
#define CATEGORY_HACKS_LABEL_FA NULL
#define CATEGORY_HACKS_INFO_0_FA NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_FA NULL
#define BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_FA NULL
#define OPTION_VAL_1X_NATIVE_FA NULL
#define OPTION_VAL_2X_FA NULL
#define OPTION_VAL_4X_FA NULL
#define OPTION_VAL_8X_FA NULL
#define OPTION_VAL_16X_FA NULL
#define BEETLE_OPT_DEPTH_LABEL_FA NULL
#define BEETLE_OPT_DEPTH_INFO_0_FA NULL
#define OPTION_VAL_16BPP_NATIVE_FA NULL
#define OPTION_VAL_32BPP_FA NULL
#define BEETLE_OPT_DITHER_MODE_LABEL_FA NULL
#define BEETLE_OPT_DITHER_MODE_INFO_0_FA NULL
#define OPTION_VAL_INTERNAL_RESOLUTION_FA NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_LABEL_FA NULL
#define BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_FA NULL
#define BEETLE_OPT_FILTER_LABEL_FA NULL
#define BEETLE_OPT_FILTER_INFO_0_FA NULL
#define OPTION_VAL_NEAREST_FA NULL
#define OPTION_VAL_SABR_FA NULL
#define OPTION_VAL_XBR_FA NULL
#define OPTION_VAL_BILINEAR_FA NULL
#define OPTION_VAL_3_POINT_FA NULL
#define OPTION_VAL_JINC2_FA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_FA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_FA NULL
#define OPTION_VAL_OPAQUE_FA NULL
#define OPTION_VAL_ALL_FA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_FA NULL
#define BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_FA NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_FA NULL
#define BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_FA NULL
#define BEETLE_OPT_SUPER_SAMPLING_LABEL_FA NULL
#define BEETLE_OPT_SUPER_SAMPLING_INFO_0_FA NULL
#define BEETLE_OPT_MSAA_LABEL_FA NULL
#define BEETLE_OPT_MSAA_INFO_0_FA NULL
#define OPTION_VAL_1X_FA NULL
#define BEETLE_OPT_MDEC_YUV_LABEL_FA NULL
#define BEETLE_OPT_MDEC_YUV_INFO_0_FA NULL
#define BEETLE_OPT_TRACK_TEXTURES_LABEL_FA NULL
#define BEETLE_OPT_TRACK_TEXTURES_INFO_0_FA NULL
#define BEETLE_OPT_DUMP_TEXTURES_LABEL_FA NULL
#define BEETLE_OPT_DUMP_TEXTURES_INFO_0_FA NULL
#define BEETLE_OPT_REPLACE_TEXTURES_LABEL_FA NULL
#define BEETLE_OPT_REPLACE_TEXTURES_INFO_0_FA NULL
#define BEETLE_OPT_WIREFRAME_LABEL_FA NULL
#define BEETLE_OPT_WIREFRAME_INFO_0_FA NULL
#define BEETLE_OPT_FRAME_DUPING_LABEL_FA NULL
#define BEETLE_OPT_FRAME_DUPING_INFO_0_FA NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_FA NULL
#define BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_FA NULL
#define BEETLE_OPT_DISPLAY_VRAM_LABEL_FA NULL
#define BEETLE_OPT_DISPLAY_VRAM_INFO_0_FA NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_LABEL_FA NULL
#define BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_FA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_LABEL_FA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_INFO_0_FA NULL
#define OPTION_VAL_ENABLED_ANALOG_FA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_FA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_FA NULL
#define OPTION_VAL_L1_L2_R1_R2_START_SELECT_FA NULL
#define OPTION_VAL_L1_R1_SELECT_FA NULL
#define OPTION_VAL_L1_R1_START_FA NULL
#define OPTION_VAL_L1_R1_L3_FA NULL
#define OPTION_VAL_L1_R1_R3_FA NULL
#define OPTION_VAL_L2_R2_SELECT_FA NULL
#define OPTION_VAL_L2_R2_START_FA NULL
#define OPTION_VAL_L2_R2_L3_FA NULL
#define OPTION_VAL_L2_R2_R3_FA NULL
#define OPTION_VAL_L3_R3_FA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_FA NULL
#define BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_FA NULL
#define OPTION_VAL_0_FA NULL
#define OPTION_VAL_1_FA NULL
#define OPTION_VAL_2_FA NULL
#define OPTION_VAL_3_FA NULL
#define OPTION_VAL_4_FA NULL
#define OPTION_VAL_5_FA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_FA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_FA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_FA NULL
#define BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_FA NULL
#define BEETLE_OPT_GUN_INPUT_MODE_LABEL_FA NULL
#define BEETLE_OPT_GUN_INPUT_MODE_INFO_0_FA NULL
#define OPTION_VAL_LIGHTGUN_FA NULL
#define OPTION_VAL_TOUCHSCREEN_FA NULL
#define BEETLE_OPT_GUN_CURSOR_LABEL_FA NULL
#define BEETLE_OPT_GUN_CURSOR_INFO_0_FA NULL
#define OPTION_VAL_CROSS_FA NULL
#define OPTION_VAL_DOT_FA NULL
#define OPTION_VAL_OFF_FA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_FA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_FA NULL
#define OPTION_VAL_RED_FA NULL
#define OPTION_VAL_BLUE_FA NULL
#define OPTION_VAL_GREEN_FA NULL
#define OPTION_VAL_ORANGE_FA NULL
#define OPTION_VAL_YELLOW_FA NULL
#define OPTION_VAL_CYAN_FA NULL
#define OPTION_VAL_PINK_FA NULL
#define OPTION_VAL_PURPLE_FA NULL
#define OPTION_VAL_BLACK_FA NULL
#define OPTION_VAL_WHITE_FA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_FA NULL
#define BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_FA NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_FA NULL
#define BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_FA NULL
#define OPTION_VAL_5_O28_FA NULL
#define OPTION_VAL_10_FA NULL
#define OPTION_VAL_15_FA NULL
#define OPTION_VAL_20_FA NULL
#define OPTION_VAL_25_FA NULL
#define OPTION_VAL_30_FA NULL
#define OPTION_VAL_35_FA NULL
#define OPTION_VAL_40_FA NULL
#define OPTION_VAL_45_FA NULL
#define OPTION_VAL_50_FA NULL
#define OPTION_VAL_55_FA NULL
#define OPTION_VAL_60_FA NULL
#define OPTION_VAL_65_FA NULL
#define OPTION_VAL_70_FA NULL
#define OPTION_VAL_75_FA NULL
#define OPTION_VAL_80_FA NULL
#define OPTION_VAL_85_FA NULL
#define OPTION_VAL_90_FA NULL
#define OPTION_VAL_95_FA NULL
#define OPTION_VAL_100_FA NULL
#define OPTION_VAL_105_FA NULL
#define OPTION_VAL_110_FA NULL
#define OPTION_VAL_115_FA NULL
#define OPTION_VAL_120_FA NULL
#define OPTION_VAL_125_FA NULL
#define OPTION_VAL_130_FA NULL
#define OPTION_VAL_135_FA NULL
#define OPTION_VAL_140_FA NULL
#define OPTION_VAL_145_FA NULL
#define OPTION_VAL_150_FA NULL
#define OPTION_VAL_155_FA NULL
#define OPTION_VAL_160_FA NULL
#define OPTION_VAL_165_FA NULL
#define OPTION_VAL_170_FA NULL
#define OPTION_VAL_175_FA NULL
#define OPTION_VAL_180_FA NULL
#define OPTION_VAL_185_FA NULL
#define OPTION_VAL_190_FA NULL
#define OPTION_VAL_195_FA NULL
#define OPTION_VAL_200_FA NULL
#define BEETLE_OPT_NEGCON_RESPONSE_LABEL_FA NULL
#define BEETLE_OPT_NEGCON_RESPONSE_INFO_0_FA NULL
#define OPTION_VAL_LINEAR_FA NULL
#define OPTION_VAL_QUADRATIC_FA NULL
#define OPTION_VAL_CUBIC_FA NULL
#define BEETLE_OPT_NEGCON_DEADZONE_LABEL_FA NULL
#define BEETLE_OPT_NEGCON_DEADZONE_INFO_0_FA NULL
#define OPTION_VAL_0_O30_FA NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_FA NULL
#define BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_FA NULL
#define OPTION_VAL_LIBRETRO_FA NULL
#define OPTION_VAL_MEDNAFEN_FA NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_LABEL_FA NULL
#define BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_FA NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_FA NULL
#define BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_FA NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_FA NULL
#define BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_FA NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_FA NULL
#define BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_FA NULL
#define OPTION_VAL_1_O35_FA NULL
#define BEETLE_OPT_PGXP_MODE_LABEL_FA NULL
#define BEETLE_OPT_PGXP_MODE_INFO_0_FA NULL
#define OPTION_VAL_MEMORY_ONLY_FA NULL
#define OPTION_VAL_MEMORY_CPU_FA NULL
#define BEETLE_OPT_PGXP_2D_TOL_LABEL_FA NULL
#define BEETLE_OPT_PGXP_2D_TOL_INFO_0_FA NULL
#define OPTION_VAL_0PX_FA NULL
#define OPTION_VAL_1PX_FA NULL
#define OPTION_VAL_2PX_FA NULL
#define OPTION_VAL_3PX_FA NULL
#define OPTION_VAL_4PX_FA NULL
#define OPTION_VAL_5PX_FA NULL
#define OPTION_VAL_6PX_FA NULL
#define OPTION_VAL_7PX_FA NULL
#define OPTION_VAL_8PX_FA NULL
#define BEETLE_OPT_PGXP_NCLIP_LABEL_FA NULL
#define BEETLE_OPT_PGXP_NCLIP_INFO_0_FA NULL
#define BEETLE_OPT_PGXP_VERTEX_LABEL_FA NULL
#define BEETLE_OPT_PGXP_VERTEX_INFO_0_FA NULL
#define BEETLE_OPT_PGXP_TEXTURE_LABEL_FA NULL
#define BEETLE_OPT_PGXP_TEXTURE_INFO_0_FA NULL
#define BEETLE_OPT_LINE_RENDER_LABEL_FA NULL
#define BEETLE_OPT_LINE_RENDER_INFO_0_FA NULL
#define OPTION_VAL_DEFAULT_FA NULL
#define OPTION_VAL_AGGRESSIVE_FA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_LABEL_FA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_INFO_0_FA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_FA NULL
#define BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_FA NULL
#define OPTION_VAL_16_9_FA NULL
#define OPTION_VAL_16_10_FA NULL
#define OPTION_VAL_18_9_FA NULL
#define OPTION_VAL_19_9_FA NULL
#define OPTION_VAL_20_9_FA NULL
#define OPTION_VAL_21_9_FA NULL
#define OPTION_VAL_32_9_FA NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_LABEL_FA NULL
#define BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_FA NULL
#define OPTION_VAL_100_NATIVE_FA NULL
#define OPTION_VAL_210_FA NULL
#define OPTION_VAL_220_FA NULL
#define OPTION_VAL_230_FA NULL
#define OPTION_VAL_240_FA NULL
#define OPTION_VAL_250_FA NULL
#define OPTION_VAL_260_FA NULL
#define OPTION_VAL_270_FA NULL
#define OPTION_VAL_280_FA NULL
#define OPTION_VAL_290_FA NULL
#define OPTION_VAL_300_FA NULL
#define OPTION_VAL_310_FA NULL
#define OPTION_VAL_320_FA NULL
#define OPTION_VAL_330_FA NULL
#define OPTION_VAL_340_FA NULL
#define OPTION_VAL_350_FA NULL
#define OPTION_VAL_360_FA NULL
#define OPTION_VAL_370_FA NULL
#define OPTION_VAL_380_FA NULL
#define OPTION_VAL_390_FA NULL
#define OPTION_VAL_400_FA NULL
#define OPTION_VAL_410_FA NULL
#define OPTION_VAL_420_FA NULL
#define OPTION_VAL_430_FA NULL
#define OPTION_VAL_440_FA NULL
#define OPTION_VAL_450_FA NULL
#define OPTION_VAL_460_FA NULL
#define OPTION_VAL_470_FA NULL
#define OPTION_VAL_480_FA NULL
#define OPTION_VAL_490_FA NULL
#define OPTION_VAL_500_FA NULL
#define OPTION_VAL_510_FA NULL
#define OPTION_VAL_520_FA NULL
#define OPTION_VAL_530_FA NULL
#define OPTION_VAL_540_FA NULL
#define OPTION_VAL_550_FA NULL
#define OPTION_VAL_560_FA NULL
#define OPTION_VAL_570_FA NULL
#define OPTION_VAL_580_FA NULL
#define OPTION_VAL_590_FA NULL
#define OPTION_VAL_600_FA NULL
#define OPTION_VAL_610_FA NULL
#define OPTION_VAL_620_FA NULL
#define OPTION_VAL_630_FA NULL
#define OPTION_VAL_640_FA NULL
#define OPTION_VAL_650_FA NULL
#define OPTION_VAL_660_FA NULL
#define OPTION_VAL_670_FA NULL
#define OPTION_VAL_680_FA NULL
#define OPTION_VAL_690_FA NULL
#define OPTION_VAL_700_FA NULL
#define OPTION_VAL_710_FA NULL
#define OPTION_VAL_720_FA NULL
#define OPTION_VAL_730_FA NULL
#define OPTION_VAL_740_FA NULL
#define OPTION_VAL_750_FA NULL
#define BEETLE_OPT_GPU_OVERCLOCK_LABEL_FA NULL
#define BEETLE_OPT_GPU_OVERCLOCK_INFO_0_FA NULL
#define OPTION_VAL_32X_FA NULL
#define BEETLE_OPT_GTE_OVERCLOCK_LABEL_FA NULL
#define BEETLE_OPT_GTE_OVERCLOCK_INFO_0_FA NULL
#define BEETLE_OPT_SKIP_BIOS_LABEL_FA NULL
#define BEETLE_OPT_SKIP_BIOS_INFO_0_FA NULL
#define BEETLE_OPT_OVERRIDE_BIOS_LABEL_FA NULL
#define BEETLE_OPT_OVERRIDE_BIOS_INFO_0_FA NULL
#define OPTION_VAL_PSXONPSP_FA NULL
#define OPTION_VAL_PS1_ROM_FA NULL
#define BEETLE_OPT_RENDERER_LABEL_FA NULL
#define BEETLE_OPT_RENDERER_INFO_0_FA NULL
#define OPTION_VAL_HARDWARE_FA NULL
#define OPTION_VAL_HARDWARE_GL_FA NULL
#define OPTION_VAL_HARDWARE_VK_FA NULL
#define OPTION_VAL_SOFTWARE_FA NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_LABEL_FA NULL
#define BEETLE_OPT_RENDERER_SOFTWARE_FB_INFO_0_FA NULL
#define BEETLE_OPT_CPU_DYNAREC_LABEL_FA NULL
#define BEETLE_OPT_CPU_DYNAREC_INFO_0_FA NULL
#define OPTION_VAL_DISABLED_FA NULL
#define OPTION_VAL_EXECUTE_FA NULL
#define OPTION_VAL_EXECUTE_ONE_FA NULL
#define OPTION_VAL_RUN_INTERPRETER_FA NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_LABEL_FA NULL
#define BEETLE_OPT_DYNAREC_INVALIDATE_INFO_0_FA NULL
#define OPTION_VAL_FULL_FA NULL
#define OPTION_VAL_DMA_FA NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_LABEL_FA NULL
#define BEETLE_OPT_DYNAREC_EVENTCYCLES_INFO_0_FA NULL
#define OPTION_VAL_128_FA NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_LABEL_FA NULL
#define BEETLE_OPT_DYNAREC_SPU_SAMPLES_INFO_0_FA NULL
#define BEETLE_OPT_CORE_TIMING_FPS_LABEL_FA NULL
#define BEETLE_OPT_CORE_TIMING_FPS_INFO_0_FA NULL
#define OPTION_VAL_FORCE_PROGRESSIVE_FA NULL
#define OPTION_VAL_FORCE_INTERLACED_FA NULL
#define OPTION_VAL_AUTO_TOGGLE_FA NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_LABEL_FA NULL
#define BEETLE_OPT_PAL_VIDEO_TIMING_OVERRIDE_INFO_0_FA NULL
#define BEETLE_OPT_ASPECT_RATIO_LABEL_FA NULL
#define BEETLE_OPT_ASPECT_RATIO_INFO_0_FA NULL
#define OPTION_VAL_CORRECTED_FA NULL
#define OPTION_VAL_UNCORRECTED_FA NULL
#define OPTION_VAL_4_3_FA NULL
#define OPTION_VAL_NTSC_FA NULL
#define BEETLE_OPT_CROP_OVERSCAN_LABEL_FA NULL
#define BEETLE_OPT_CROP_OVERSCAN_INFO_0_FA NULL
#define OPTION_VAL_DISABLED_O58_FA "هیچکدام"
#define OPTION_VAL_STATIC_FA NULL
#define OPTION_VAL_SMART_FA NULL
#define BEETLE_OPT_IMAGE_CROP_LABEL_FA NULL
#define BEETLE_OPT_IMAGE_CROP_INFO_0_FA NULL
#define OPTION_VAL_9PX_FA NULL
#define OPTION_VAL_10PX_FA NULL
#define OPTION_VAL_11PX_FA NULL
#define OPTION_VAL_12PX_FA NULL
#define OPTION_VAL_13PX_FA NULL
#define OPTION_VAL_14PX_FA NULL
#define OPTION_VAL_15PX_FA NULL
#define OPTION_VAL_16PX_FA NULL
#define OPTION_VAL_17PX_FA NULL
#define OPTION_VAL_18PX_FA NULL
#define OPTION_VAL_19PX_FA NULL
#define OPTION_VAL_20PX_FA NULL
#define BEETLE_OPT_IMAGE_OFFSET_LABEL_FA NULL
#define BEETLE_OPT_IMAGE_OFFSET_INFO_0_FA NULL
#define OPTION_VAL_12PX_O60_FA NULL
#define OPTION_VAL_11PX_O60_FA NULL
#define OPTION_VAL_10PX_O60_FA NULL
#define OPTION_VAL_9PX_O60_FA NULL
#define OPTION_VAL_8PX_O60_FA NULL
#define OPTION_VAL_7PX_O60_FA NULL
#define OPTION_VAL_6PX_O60_FA NULL
#define OPTION_VAL_5PX_O60_FA NULL
#define OPTION_VAL_4PX_O60_FA NULL
#define OPTION_VAL_3PX_O60_FA NULL
#define OPTION_VAL_2PX_O60_FA NULL
#define OPTION_VAL_1PX_O60_FA NULL
#define OPTION_VAL_1PX_O60_0_FA NULL
#define OPTION_VAL_2PX_O60_0_FA NULL
#define OPTION_VAL_3PX_O60_0_FA NULL
#define OPTION_VAL_4PX_O60_0_FA NULL
#define OPTION_VAL_5PX_O60_0_FA NULL
#define OPTION_VAL_6PX_O60_0_FA NULL
#define OPTION_VAL_7PX_O60_0_FA NULL
#define OPTION_VAL_8PX_O60_0_FA NULL
#define OPTION_VAL_9PX_O60_0_FA NULL
#define OPTION_VAL_10PX_O60_0_FA NULL
#define OPTION_VAL_11PX_O60_0_FA NULL
#define OPTION_VAL_12PX_O60_0_FA NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_LABEL_FA NULL
#define BEETLE_OPT_IMAGE_OFFSET_CYCLES_INFO_0_FA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_LABEL_FA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_INFO_0_FA NULL
#define OPTION_VAL_0_O62_FA NULL
#define BEETLE_OPT_LAST_SCANLINE_LABEL_FA NULL
#define BEETLE_OPT_LAST_SCANLINE_INFO_0_FA NULL
#define OPTION_VAL_239_FA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_LABEL_FA NULL
#define BEETLE_OPT_INITIAL_SCANLINE_PAL_INFO_0_FA NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_LABEL_FA NULL
#define BEETLE_OPT_LAST_SCANLINE_PAL_INFO_0_FA NULL
#define OPTION_VAL_287_FA NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_LABEL_FA NULL
#define BEETLE_OPT_CD_ACCESS_METHOD_INFO_0_FA NULL
#define OPTION_VAL_SYNC_FA NULL
#define OPTION_VAL_ASYNC_FA NULL
#define OPTION_VAL_PRECACHE_FA NULL
#define BEETLE_OPT_CD_FASTLOAD_LABEL_FA NULL
#define BEETLE_OPT_CD_FASTLOAD_INFO_0_FA NULL
#define OPTION_VAL_2X_NATIVE_FA NULL
#define OPTION_VAL_6X_FA NULL
#define OPTION_VAL_10X_FA NULL
#define OPTION_VAL_12X_FA NULL
#define OPTION_VAL_14X_FA NULL

struct retro_core_option_v2_category option_cats_fa[] = {
   {
      "video",
      CATEGORY_VIDEO_LABEL_FA,
      CATEGORY_VIDEO_INFO_0_FA
   },
   {
      "osd",
      CATEGORY_OSD_LABEL_FA,
      CATEGORY_OSD_INFO_0_FA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_FA,
      CATEGORY_INPUT_INFO_0_FA
   },
   {
      "memcards",
      CATEGORY_MEMCARDS_LABEL_FA,
      CATEGORY_MEMCARDS_INFO_0_FA
   },
   {
      "pgxp",
      CATEGORY_PGXP_LABEL_FA,
      CATEGORY_PGXP_INFO_0_FA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_FA,
      CATEGORY_HACKS_INFO_0_FA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_fa[] = {
   {
      BEETLE_OPT(internal_resolution),
      BEETLE_OPT_INTERNAL_RESOLUTION_LABEL_FA,
      NULL,
      BEETLE_OPT_INTERNAL_RESOLUTION_INFO_0_FA,
      NULL,
      "video",
      {
         { "1x(native)", OPTION_VAL_1X_NATIVE_FA },
         { "2x",         OPTION_VAL_2X_FA },
         { "4x",         OPTION_VAL_4X_FA },
         { "8x",         OPTION_VAL_8X_FA },
         { "16x",        OPTION_VAL_16X_FA },
         { NULL, NULL },
      },
      "1x(native)"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(depth),
      BEETLE_OPT_DEPTH_LABEL_FA,
      NULL,
      BEETLE_OPT_DEPTH_INFO_0_FA,
      NULL,
      "video",
      {
         { "16bpp(native)", OPTION_VAL_16BPP_NATIVE_FA },
         { "32bpp",         OPTION_VAL_32BPP_FA },
         { NULL, NULL },
      },
      "16bpp(native)"
   },
   // Sort of, it's more like 15-bit high color and 24-bit true color for visible output. The alpha channel is used for mask bit. Vulkan renderer uses ABGR1555_555 for 31 bits internal? FMVs are always 24-bit on all renderers like original hardware (BGR888, no alpha)
#endif
   {
      BEETLE_OPT(dither_mode),
      BEETLE_OPT_DITHER_MODE_LABEL_FA,
      NULL,
      BEETLE_OPT_DITHER_MODE_INFO_0_FA,
      NULL,
      "video",
      {
         { "1x(native)",          OPTION_VAL_1X_NATIVE_FA },
         { "internal resolution", OPTION_VAL_INTERNAL_RESOLUTION_FA },
         { "disabled",            NULL },
         { NULL, NULL },
      },
      "1x(native)"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(scaled_uv_offset),
      BEETLE_OPT_SCALED_UV_OFFSET_LABEL_FA,
      NULL,
      BEETLE_OPT_SCALED_UV_OFFSET_INFO_0_FA,
      NULL,
      "video",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(filter),
      BEETLE_OPT_FILTER_LABEL_FA,
      NULL,
      BEETLE_OPT_FILTER_INFO_0_FA,
      NULL,
      "video",
      {
         { "nearest",  OPTION_VAL_NEAREST_FA },
         { "SABR",     OPTION_VAL_SABR_FA },
         { "xBR",      OPTION_VAL_XBR_FA },
         { "bilinear", OPTION_VAL_BILINEAR_FA },
         { "3-point",  OPTION_VAL_3_POINT_FA },
         { "JINC2",    OPTION_VAL_JINC2_FA },
         { NULL, NULL },
      },
      "nearest"
   },
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(filter_exclude_sprite),
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_LABEL_FA,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_SPRITE_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_FA },
         { "all", OPTION_VAL_ALL_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(filter_exclude_2d_polygon),
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_LABEL_FA,
      NULL,
      BEETLE_OPT_FILTER_EXCLUDE_2D_POLYGON_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "opaque", OPTION_VAL_OPAQUE_FA },
         { "all", OPTION_VAL_ALL_FA },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#endif
#ifdef HAVE_VULKAN
   {
      BEETLE_OPT(adaptive_smoothing),
      BEETLE_OPT_ADAPTIVE_SMOOTHING_LABEL_FA,
      NULL,
      BEETLE_OPT_ADAPTIVE_SMOOTHING_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(super_sampling),
      BEETLE_OPT_SUPER_SAMPLING_LABEL_FA,
      NULL,
      BEETLE_OPT_SUPER_SAMPLING_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(msaa),
      BEETLE_OPT_MSAA_LABEL_FA,
      NULL,
      BEETLE_OPT_MSAA_INFO_0_FA,
      NULL,
      "video",
      {
         { "1x",  OPTION_VAL_1X_FA },
         { "2x",  OPTION_VAL_2X_FA },
         { "4x",  OPTION_VAL_4X_FA },
         { "8x",  OPTION_VAL_8X_FA },
         { "16x", OPTION_VAL_16X_FA },
         { NULL, NULL },
      },
      "1x"
   },
   {
      BEETLE_OPT(mdec_yuv),
      BEETLE_OPT_MDEC_YUV_LABEL_FA,
      NULL,
      BEETLE_OPT_MDEC_YUV_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(track_textures),
      BEETLE_OPT_TRACK_TEXTURES_LABEL_FA,
      NULL,
      BEETLE_OPT_TRACK_TEXTURES_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#ifdef TEXTURE_DUMPING_ENABLED
   {
      BEETLE_OPT(dump_textures),
      BEETLE_OPT_DUMP_TEXTURES_LABEL_FA,
      NULL,
      BEETLE_OPT_DUMP_TEXTURES_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(replace_textures),
      BEETLE_OPT_REPLACE_TEXTURES_LABEL_FA,
      NULL,
      BEETLE_OPT_REPLACE_TEXTURES_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES)
   {
      BEETLE_OPT(wireframe),
      BEETLE_OPT_WIREFRAME_LABEL_FA,
      NULL,
      BEETLE_OPT_WIREFRAME_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(frame_duping),
      BEETLE_OPT_FRAME_DUPING_LABEL_FA,
      NULL,
      BEETLE_OPT_FRAME_DUPING_INFO_0_FA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(display_internal_fps),
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_LABEL_FA,
      NULL,
      BEETLE_OPT_DISPLAY_INTERNAL_FPS_INFO_0_FA,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(display_vram),
      BEETLE_OPT_DISPLAY_VRAM_LABEL_FA,
      NULL,
      BEETLE_OPT_DISPLAY_VRAM_INFO_0_FA,
      NULL,
      "osd",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(analog_calibration),
      BEETLE_OPT_ANALOG_CALIBRATION_LABEL_FA,
      NULL,
      BEETLE_OPT_ANALOG_CALIBRATION_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle),
      BEETLE_OPT_ANALOG_TOGGLE_LABEL_FA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { "enabled-analog", OPTION_VAL_ENABLED_ANALOG_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(analog_toggle_combo),
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_LABEL_FA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_COMBO_INFO_0_FA,
      NULL,
      "input",
      {
         { "l1+l2+r1+r2+start+select", OPTION_VAL_L1_L2_R1_R2_START_SELECT_FA },
         { "l1+r1+select",             OPTION_VAL_L1_R1_SELECT_FA },
         { "l1+r1+start",              OPTION_VAL_L1_R1_START_FA },
         { "l1+r1+l3",                 OPTION_VAL_L1_R1_L3_FA },
         { "l1+r1+r3",                 OPTION_VAL_L1_R1_R3_FA },
         { "l2+r2+select",             OPTION_VAL_L2_R2_SELECT_FA },
         { "l2+r2+start",              OPTION_VAL_L2_R2_START_FA },
         { "l2+r2+l3",                 OPTION_VAL_L2_R2_L3_FA },
         { "l2+r2+r3",                 OPTION_VAL_L2_R2_R3_FA },
         { "l3+r3",                    OPTION_VAL_L3_R3_FA },
         { NULL, NULL },
      },
      "l1+r1+select"
   },
   {
      BEETLE_OPT(analog_toggle_hold),
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_LABEL_FA,
      NULL,
      BEETLE_OPT_ANALOG_TOGGLE_HOLD_INFO_0_FA,
      NULL,
      "input",
      {
         { "0", OPTION_VAL_0_FA },
         { "1", OPTION_VAL_1_FA },
         { "2", OPTION_VAL_2_FA },
         { "3", OPTION_VAL_3_FA },
         { "4", OPTION_VAL_4_FA },
         { "5", OPTION_VAL_5_FA },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(enable_multitap_port1),
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_LABEL_FA,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT1_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(enable_multitap_port2),
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_LABEL_FA,
      NULL,
      BEETLE_OPT_ENABLE_MULTITAP_PORT2_INFO_0_FA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(gun_input_mode),
      BEETLE_OPT_GUN_INPUT_MODE_LABEL_FA,
      NULL,
      BEETLE_OPT_GUN_INPUT_MODE_INFO_0_FA,
      NULL,
      "input",
      {
         { "lightgun",    OPTION_VAL_LIGHTGUN_FA },
         { "touchscreen", OPTION_VAL_TOUCHSCREEN_FA },
         { NULL, NULL },
      },
      "lightgun"
   },
   // Shouldn't the gun_input_mode just be Mouse vs. Touchscreen?
   {
      BEETLE_OPT(gun_cursor),
      BEETLE_OPT_GUN_CURSOR_LABEL_FA,
      NULL,
      BEETLE_OPT_GUN_CURSOR_INFO_0_FA,
      NULL,
      "input",
      {
         { "cross", OPTION_VAL_CROSS_FA },
         { "dot",   OPTION_VAL_DOT_FA },
         { "off",   OPTION_VAL_OFF_FA },
         { NULL, NULL },
      },
      "cross"
   },
   {
      BEETLE_OPT(crosshair_color_p1),
      BEETLE_OPT_CROSSHAIR_COLOR_P1_LABEL_FA,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P1_INFO_0_FA,
      NULL,
      "input",
      {
         { "red", OPTION_VAL_RED_FA },
         { "blue", OPTION_VAL_BLUE_FA },
         { "green", OPTION_VAL_GREEN_FA },
         { "orange", OPTION_VAL_ORANGE_FA },
         { "yellow", OPTION_VAL_YELLOW_FA },
         { "cyan", OPTION_VAL_CYAN_FA },
         { "pink", OPTION_VAL_PINK_FA },
         { "purple", OPTION_VAL_PURPLE_FA },
         { "black", OPTION_VAL_BLACK_FA },
         { "white", OPTION_VAL_WHITE_FA },
         { NULL, NULL },
      },
      "red"
   },
   {
      BEETLE_OPT(crosshair_color_p2),
      BEETLE_OPT_CROSSHAIR_COLOR_P2_LABEL_FA,
      NULL,
      BEETLE_OPT_CROSSHAIR_COLOR_P2_INFO_0_FA,
      NULL,
      "input",
      {
         { "blue", OPTION_VAL_BLUE_FA },
         { "red", OPTION_VAL_RED_FA },
         { "green", OPTION_VAL_GREEN_FA },
         { "orange", OPTION_VAL_ORANGE_FA },
         { "yellow", OPTION_VAL_YELLOW_FA },
         { "cyan", OPTION_VAL_CYAN_FA },
         { "pink", OPTION_VAL_PINK_FA },
         { "purple", OPTION_VAL_PURPLE_FA },
         { "black", OPTION_VAL_BLACK_FA },
         { "white", OPTION_VAL_WHITE_FA },
         { NULL, NULL },
      },
      "blue"
   },
   {
      BEETLE_OPT(mouse_sensitivity),
      BEETLE_OPT_MOUSE_SENSITIVITY_LABEL_FA,
      NULL,
      BEETLE_OPT_MOUSE_SENSITIVITY_INFO_0_FA,
      NULL,
      "input",
      {
         { "5%",   OPTION_VAL_5_O28_FA },
         { "10%",  OPTION_VAL_10_FA },
         { "15%",  OPTION_VAL_15_FA },
         { "20%",  OPTION_VAL_20_FA },
         { "25%",  OPTION_VAL_25_FA },
         { "30%",  OPTION_VAL_30_FA },
         { "35%",  OPTION_VAL_35_FA },
         { "40%",  OPTION_VAL_40_FA },
         { "45%",  OPTION_VAL_45_FA },
         { "50%",  OPTION_VAL_50_FA },
         { "55%",  OPTION_VAL_55_FA },
         { "60%",  OPTION_VAL_60_FA },
         { "65%",  OPTION_VAL_65_FA },
         { "70%",  OPTION_VAL_70_FA },
         { "75%",  OPTION_VAL_75_FA },
         { "80%",  OPTION_VAL_80_FA },
         { "85%",  OPTION_VAL_85_FA },
         { "90%",  OPTION_VAL_90_FA },
         { "95%",  OPTION_VAL_95_FA },
         { "100%", OPTION_VAL_100_FA },
         { "105%", OPTION_VAL_105_FA },
         { "110%", OPTION_VAL_110_FA },
         { "115%", OPTION_VAL_115_FA },
         { "120%", OPTION_VAL_120_FA },
         { "125%", OPTION_VAL_125_FA },
         { "130%", OPTION_VAL_130_FA },
         { "135%", OPTION_VAL_135_FA },
         { "140%", OPTION_VAL_140_FA },
         { "145%", OPTION_VAL_145_FA },
         { "150%", OPTION_VAL_150_FA },
         { "155%", OPTION_VAL_155_FA },
         { "160%", OPTION_VAL_160_FA },
         { "165%", OPTION_VAL_165_FA },
         { "170%", OPTION_VAL_170_FA },
         { "175%", OPTION_VAL_175_FA },
         { "180%", OPTION_VAL_180_FA },
         { "185%", OPTION_VAL_185_FA },
         { "190%", OPTION_VAL_190_FA },
         { "195%", OPTION_VAL_195_FA },
         { "200%", OPTION_VAL_200_FA },
         { NULL, NULL },
      },
      "100%"
   },
   {
      BEETLE_OPT(negcon_response),
      BEETLE_OPT_NEGCON_RESPONSE_LABEL_FA,
      NULL,
      BEETLE_OPT_NEGCON_RESPONSE_INFO_0_FA,
      NULL,
      "input",
      {
         { "linear",    OPTION_VAL_LINEAR_FA },
         { "quadratic", OPTION_VAL_QUADRATIC_FA },
         { "cubic",     OPTION_VAL_CUBIC_FA },
         { NULL, NULL },
      },
      "linear"
   },
   {
      BEETLE_OPT(negcon_deadzone),
      BEETLE_OPT_NEGCON_DEADZONE_LABEL_FA,
      NULL,
      BEETLE_OPT_NEGCON_DEADZONE_INFO_0_FA,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_O30_FA },
         { "5%",  OPTION_VAL_5_O28_FA },
         { "10%", OPTION_VAL_10_FA },
         { "15%", OPTION_VAL_15_FA },
         { "20%", OPTION_VAL_20_FA },
         { "25%", OPTION_VAL_25_FA },
         { "30%", OPTION_VAL_30_FA },
         { NULL, NULL },
      },
      "0%"
   },
   {
      BEETLE_OPT(use_mednafen_memcard0_method),
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_LABEL_FA,
      NULL,
      BEETLE_OPT_USE_MEDNAFEN_MEMCARD0_METHOD_INFO_0_FA,
      NULL,
      "memcards",
      {
         { "libretro", OPTION_VAL_LIBRETRO_FA },
         { "mednafen", OPTION_VAL_MEDNAFEN_FA },
         { NULL, NULL },
      },
      "libretro"
   },
   {
      BEETLE_OPT(enable_memcard1),
      BEETLE_OPT_ENABLE_MEMCARD1_LABEL_FA,
      NULL,
      BEETLE_OPT_ENABLE_MEMCARD1_INFO_0_FA,
      NULL,
      "memcards",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL },
      },
      "enabled"
   },
   {
      BEETLE_OPT(shared_memory_cards),
      BEETLE_OPT_SHARED_MEMORY_CARDS_LABEL_FA,
      NULL,
      BEETLE_OPT_SHARED_MEMORY_CARDS_INFO_0_FA,
      NULL,
      "memcards",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(memcard_left_index),
      BEETLE_OPT_MEMCARD_LEFT_INDEX_LABEL_FA,
      NULL,
      BEETLE_OPT_MEMCARD_LEFT_INDEX_INFO_0_FA,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  NULL },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "0"
   },
   {
      BEETLE_OPT(memcard_right_index),
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_LABEL_FA,
      NULL,
      BEETLE_OPT_MEMCARD_RIGHT_INDEX_INFO_0_FA,
      NULL,
      "memcards",
      {
         { "0",  NULL },
         { "1",  OPTION_VAL_1_O35_FA },
         { "2",  NULL },
         { "3",  NULL },
         { "4",  NULL },
         { "5",  NULL },
         { "6",  NULL },
         { "7",  NULL },
         { "8",  NULL },
         { "9",  NULL },
         { "10",  NULL },
         { "11",  NULL },
         { "12",  NULL },
         { "13",  NULL },
         { "14",  NULL },
         { "15",  NULL },
         { "16",  NULL },
         { "17",  NULL },
         { "18",  NULL },
         { "19",  NULL },
         { "20",  NULL },
         { "21",  NULL },
         { "22",  NULL },
         { "23",  NULL },
         { "24",  NULL },
         { "25",  NULL },
         { "26",  NULL },
         { "27",  NULL },
         { "28",  NULL },
         { "29",  NULL },
         { "30",  NULL },
         { "31",  NULL },
         { "32",  NULL },
         { "33",  NULL },
         { "34",  NULL },
         { "35",  NULL },
         { "36",  NULL },
         { "37",  NULL },
         { "38",  NULL },
         { "39",  NULL },
         { "40",  NULL },
         { "41",  NULL },
         { "42",  NULL },
         { "43",  NULL },
         { "44",  NULL },
         { "45",  NULL },
         { "46",  NULL },
         { "47",  NULL },
         { "48",  NULL },
         { "49",  NULL },
         { "50",  NULL },
         { "51",  NULL },
         { "52",  NULL },
         { "53",  NULL },
         { "54",  NULL },
         { "55",  NULL },
         { "56",  NULL },
         { "57",  NULL },
         { "58",  NULL },
         { "59",  NULL },
         { "60",  NULL },
         { "61",  NULL },
         { "62",  NULL },
         { "63",  NULL },
         { NULL, NULL },
      },
      "1"
   },
   {
      BEETLE_OPT(pgxp_mode),
      BEETLE_OPT_PGXP_MODE_LABEL_FA,
      NULL,
      BEETLE_OPT_PGXP_MODE_INFO_0_FA,
      NULL,
      "pgxp",
      {
         { "disabled",     NULL },
         { "memory only",  OPTION_VAL_MEMORY_ONLY_FA },
         { "memory + CPU", OPTION_VAL_MEMORY_CPU_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_2d_tol),
      BEETLE_OPT_PGXP_2D_TOL_LABEL_FA,
      NULL,
      BEETLE_OPT_PGXP_2D_TOL_INFO_0_FA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "0px", OPTION_VAL_0PX_FA },
         { "1px", OPTION_VAL_1PX_FA },
         { "2px", OPTION_VAL_2PX_FA },
         { "3px", OPTION_VAL_3PX_FA },
         { "4px", OPTION_VAL_4PX_FA },
         { "5px", OPTION_VAL_5PX_FA },
         { "6px", OPTION_VAL_6PX_FA },
         { "7px", OPTION_VAL_7PX_FA },
         { "8px", OPTION_VAL_8PX_FA },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_nclip),
      BEETLE_OPT_PGXP_NCLIP_LABEL_FA,
      NULL,
      BEETLE_OPT_PGXP_NCLIP_INFO_0_FA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#if defined(HAVE_OPENGL) || defined(HAVE_OPENGLES) || defined(HAVE_VULKAN)
   {
      BEETLE_OPT(pgxp_vertex),
      BEETLE_OPT_PGXP_VERTEX_LABEL_FA,
      NULL,
      BEETLE_OPT_PGXP_VERTEX_INFO_0_FA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(pgxp_texture),
      BEETLE_OPT_PGXP_TEXTURE_LABEL_FA,
      NULL,
      BEETLE_OPT_PGXP_TEXTURE_INFO_0_FA,
      NULL,
      "pgxp",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
#endif
   {
      BEETLE_OPT(line_render),
      BEETLE_OPT_LINE_RENDER_LABEL_FA,
      NULL,
      BEETLE_OPT_LINE_RENDER_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "default",    OPTION_VAL_DEFAULT_FA },
         { "aggressive", OPTION_VAL_AGGRESSIVE_FA },
         { "disabled",   NULL },
         { NULL, NULL },
      },
      "default"
   },
   {
      BEETLE_OPT(widescreen_hack),
      BEETLE_OPT_WIDESCREEN_HACK_LABEL_FA,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled"
   },
   {
      BEETLE_OPT(widescreen_hack_aspect_ratio),
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_LABEL_FA,
      NULL,
      BEETLE_OPT_WIDESCREEN_HACK_ASPECT_RATIO_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "16:9",  OPTION_VAL_16_9_FA },
         { "16:10", OPTION_VAL_16_10_FA },
         { "18:9",  OPTION_VAL_18_9_FA },
         { "19:9",  OPTION_VAL_19_9_FA },
         { "20:9",  OPTION_VAL_20_9_FA },
         { "21:9",  OPTION_VAL_21_9_FA }, // 64:27
         { "32:9",  OPTION_VAL_32_9_FA },
         { NULL,    NULL },
      },
      "16:9"
   },
   {
      BEETLE_OPT(cpu_freq_scale),
      BEETLE_OPT_CPU_FREQ_SCALE_LABEL_FA,
      NULL,
      BEETLE_OPT_CPU_FREQ_SCALE_INFO_0_FA,
      NULL,
      "hacks",
      {
         { "50%",           OPTION_VAL_50_FA },
         { "60%",           OPTION_VAL_60_FA },
         { "70%",           OPTION_VAL_70_FA },
         { "80%",           OPTION_VAL_80_FA },
         { "90%",           OPTION_VAL_90_FA },
         { "100%(native)", OPTION_VAL_100_NATIVE_FA },
         { "110%",          OPTION_VAL_110_FA },
         { "120%",          OPTION_VAL_120_FA },
         { "130%",          OPTION_VAL_130_FA },
         { "140%",          OPTION_VAL_140_FA },
         { "150%",          OPTION_VAL_150_FA },
         { "160%",          OPTION_VAL_160_FA },
         { "170%",          OPTION_VAL_170_FA },
         { "180%",          OPTION_VAL_180_FA },
         { "190%",          OPTION_VAL_190_FA },
         { "200%",          OPTION_VAL_200_FA },
         { "210%",          OPTION_VAL_210_FA },
         { "220%",          OPTION_VAL_220_FA },
         { "230%",          OPTION_VAL_230_FA },
         { "240%",          OPTION_VAL_240_FA },
         { "250%",          OPTION_VAL_250_FA },
         { "260%",          OPTION_VAL_260_FA },
         { "270%",          OPTION_VAL_270_FA },
         { "280%",          OPTION_VAL_280_FA },
         { "290%",          OPTION_VAL_290_FA },
         { "300%",          OPTION_VAL_300_FA },
         { "310%",          OPTION_VAL_310_FA },
         { "320%",          OPTION_VAL_320_FA },
         { "330%",          OPTION_VAL_330_FA },
         { "340%",          OPTION_VAL_340_FA },
         { "350%",          O