/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 1 "/build/libiio/src/libiio-0.25/iiod/parser.y"

// SPDX-License-Identifier: LGPL-2.1-or-later
/*
 * libiio - Library for interfacing industrial I/O (IIO) devices
 *
 * Copyright (C) 2014 Analog Devices, Inc.
 * Author: Paul Cercueil <paul.cercueil@analog.com>
 */

#include "ops.h"
#include "parser.h"

#include <errno.h>
#include <string.h>

void yyerror(yyscan_t scanner, const char *msg);

#line 89 "/build/libiio/src/build/iiod/parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "parser.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_SPACE = 3,                      /* SPACE  */
  YYSYMBOL_END = 4,                        /* END  */
  YYSYMBOL_VERSION = 5,                    /* VERSION  */
  YYSYMBOL_EXIT = 6,                       /* EXIT  */
  YYSYMBOL_HELP = 7,                       /* HELP  */
  YYSYMBOL_OPEN = 8,                       /* OPEN  */
  YYSYMBOL_CLOSE = 9,                      /* CLOSE  */
  YYSYMBOL_PRINT = 10,                     /* PRINT  */
  YYSYMBOL_ZPRINT = 11,                    /* ZPRINT  */
  YYSYMBOL_READ = 12,                      /* READ  */
  YYSYMBOL_READBUF = 13,                   /* READBUF  */
  YYSYMBOL_WRITEBUF = 14,                  /* WRITEBUF  */
  YYSYMBOL_WRITE = 15,                     /* WRITE  */
  YYSYMBOL_SETTRIG = 16,                   /* SETTRIG  */
  YYSYMBOL_GETTRIG = 17,                   /* GETTRIG  */
  YYSYMBOL_TIMEOUT = 18,                   /* TIMEOUT  */
  YYSYMBOL_DEBUG_ATTR = 19,                /* DEBUG_ATTR  */
  YYSYMBOL_BUFFER_ATTR = 20,               /* BUFFER_ATTR  */
  YYSYMBOL_IN_OUT = 21,                    /* IN_OUT  */
  YYSYMBOL_CYCLIC = 22,                    /* CYCLIC  */
  YYSYMBOL_SET = 23,                       /* SET  */
  YYSYMBOL_BUFFERS_COUNT = 24,             /* BUFFERS_COUNT  */
  YYSYMBOL_WORD = 25,                      /* WORD  */
  YYSYMBOL_DEVICE = 26,                    /* DEVICE  */
  YYSYMBOL_CHANNEL = 27,                   /* CHANNEL  */
  YYSYMBOL_VALUE = 28,                     /* VALUE  */
  YYSYMBOL_YYACCEPT = 29,                  /* $accept  */
  YYSYMBOL_Line = 30                       /* Line  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  35
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   131

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  29
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  2
/* YYNRULES -- Number of rules.  */
#define YYNRULES  34
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  122

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   283


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,    95,    95,    98,   103,   138,   146,   158,   177,   188,
     200,   212,   220,   227,   237,   244,   254,   261,   271,   278,
     288,   299,   314,   325,   337,   348,   360,   371,   383,   394,
     406,   416,   423,   430,   437
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "SPACE", "END",
  "VERSION", "EXIT", "HELP", "OPEN", "CLOSE", "PRINT", "ZPRINT", "READ",
  "READBUF", "WRITEBUF", "WRITE", "SETTRIG", "GETTRIG", "TIMEOUT",
  "DEBUG_ATTR", "BUFFER_ATTR", "IN_OUT", "CYCLIC", "SET", "BUFFERS_COUNT",
  "WORD", "DEVICE", "CHANNEL", "VALUE", "$accept", "Line", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-3)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int8 yypact[] =
{
      -1,    14,    -3,    27,    43,    44,    46,    47,    48,    49,
      51,    52,    53,    54,    55,    56,    57,    58,    62,    -3,
      -3,    -3,    -3,    25,    37,    -3,    -3,    39,    41,    45,
      50,    59,    60,    63,    61,    -3,    65,    66,    -2,    69,
      70,    71,    20,    73,    74,    72,    64,    -3,     0,    -3,
      67,    68,     7,    75,    -3,    -3,    -3,    77,    76,    26,
      30,    78,    79,    80,    86,    88,    91,    92,    32,    93,
      95,    81,    82,    -3,    83,    -3,    84,    -3,    -3,    -3,
      85,    87,    89,    90,    -3,    -3,    94,    34,    98,    99,
      36,    38,    40,    96,   100,   101,    97,    -3,    -3,    -3,
     102,    -3,   103,    -3,   104,    -3,   105,    -3,    -3,   109,
     110,   113,   114,    42,    -3,    -3,    -3,    -3,   106,    -3,
     116,    -3
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_int8 yydefact[] =
{
       0,     0,     2,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    34,
       5,     3,     4,     0,     0,     6,     7,     0,     0,     0,
       0,     0,     0,     0,     0,     1,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    11,     0,    12,
       0,     0,     0,     0,    31,    32,     8,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    14,     0,    16,     0,    13,    20,    21,
       0,     0,     0,     0,    22,    30,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    10,    15,    17,
       0,    18,     0,    24,     0,    26,     0,    23,    33,     0,
       0,     0,     0,     0,     9,    19,    25,    27,     0,    28,
       0,    29
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
      -3,    -3
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,    18
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
       1,    48,    49,     2,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    19,    59,
      60,    61,    17,    53,    54,    62,    65,    66,    67,    72,
      73,    20,    68,    74,    75,    83,    84,    96,    97,   100,
     101,   102,   103,   104,   105,   118,   119,    21,    22,    23,
      24,    36,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    37,     0,    38,     0,    39,    46,     0,
      47,    40,    50,    51,    52,    57,    41,    55,    56,    71,
       0,    76,     0,    77,    78,    42,    43,    45,    44,    58,
      79,    80,    63,    64,    81,    82,     0,    85,    86,   106,
      69,    70,    98,    99,   107,   108,    87,    88,    89,     0,
      91,    90,    92,   114,   115,    94,    93,   116,   117,   109,
     121,     0,    95,     0,     0,     0,     0,   110,   111,   112,
     113,   120
};

static const yytype_int8 yycheck[] =
{
       1,     3,     4,     4,     5,     6,     7,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,     4,    19,
      20,    21,    23,     3,     4,    25,    19,    20,    21,     3,
       4,     4,    25,     3,     4,     3,     4,     3,     4,     3,
       4,     3,     4,     3,     4,     3,     4,     4,     4,     3,
       3,    26,     4,     4,     3,     3,     3,     3,     3,     3,
       3,     3,     0,    26,    -1,    26,    -1,    26,     3,    -1,
       4,    26,     3,     3,     3,     3,    26,     4,     4,     3,
      -1,     3,    -1,     4,     4,    26,    26,    26,    25,    25,
       4,     3,    25,    25,     3,     3,    -1,     4,     3,     3,
      25,    24,     4,     4,     4,     4,    25,    25,    25,    -1,
      25,    27,    25,     4,     4,    25,    27,     4,     4,    22,
       4,    -1,    28,    -1,    -1,    -1,    -1,    25,    25,    25,
      25,    25
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     1,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    23,    30,     4,
       4,     4,     4,     3,     3,     4,     4,     3,     3,     3,
       3,     3,     3,     3,     3,     0,    26,    26,    26,    26,
      26,    26,    26,    26,    25,    26,     3,     4,     3,     4,
       3,     3,     3,     3,     4,     4,     4,     3,    25,    19,
      20,    21,    25,    25,    25,    19,    20,    21,    25,    25,
      24,     3,     3,     4,     3,     4,     3,     4,     4,     4,
       3,     3,     3,     3,     4,     4,     3,    25,    25,    25,
      27,    25,    25,    27,    25,    28,     3,     4,     4,     4,
       3,     4,     3,     4,     3,     4,     3,     4,     4,    22,
      25,    25,    25,    25,     4,     4,     4,     4,     3,     4,
      25,     4
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    29,    30,    30,    30,    30,    30,    30,    30,    30,
      30,    30,    30,    30,    30,    30,    30,    30,    30,    30,
      30,    30,    30,    30,    30,    30,    30,    30,    30,    30,
      30,    30,    30,    30,    30
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     2,     2,     2,     2,     4,    10,
       8,     4,     4,     6,     6,     8,     6,     8,     8,    10,
       6,     6,     6,     8,     8,    10,     8,    10,    10,    12,
       6,     4,     4,     8,     2
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, yyscan_t scanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (scanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, yyscan_t scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep, scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule, yyscan_t scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)], scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule, scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, yyscan_t scanner)
{
  YY_USE (yyvaluep);
  YY_USE (scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  switch (yykind)
    {
    case YYSYMBOL_WORD: /* WORD  */
#line 89 "/build/libiio/src/libiio-0.25/iiod/parser.y"
            { IIO_DEBUG("Freeing token \"%s\"\n", ((*yyvaluep).word)); free(((*yyvaluep).word)); }
#line 911 "/build/libiio/src/build/iiod/parser.c"
        break;

      default:
        break;
    }
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t scanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, scanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* Line: END  */
#line 95 "/build/libiio/src/libiio-0.25/iiod/parser.y"
            {
		YYACCEPT;
	}
#line 1189 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 3: /* Line: EXIT END  */
#line 98 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                   {
		struct parser_pdata *pdata = yyget_extra(scanner);
		pdata->stop = true;
		YYACCEPT;
	}
#line 1199 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 4: /* Line: HELP END  */
#line 103 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                   {
		struct parser_pdata *pdata = yyget_extra(scanner);
		output(pdata, "Available commands:\n\n"
		"\tHELP\n"
		"\t\tPrint this help message\n"
		"\tEXIT\n"
		"\t\tClose the current session\n"
		"\tPRINT\n"
		"\t\tDisplays a XML string corresponding to the current IIO context\n"
		"\tZPRINT\n"
		"\t\tGet a compressed XML string corresponding to the current IIO context\n"
		"\tVERSION\n"
		"\t\tGet the version of libiio in use\n"
		"\tTIMEOUT <timeout_ms>\n"
		"\t\tSet the timeout (in ms) for I/O operations\n"
		"\tOPEN <device> <samples_count> <mask> [CYCLIC]\n"
		"\t\tOpen the specified device with the given mask of channels\n"
		"\tCLOSE <device>\n"
		"\t\tClose the specified device\n"
		"\tREAD <device> DEBUG|BUFFER|[INPUT|OUTPUT <channel>] [<attribute>]\n"
		"\t\tRead the value of an attribute\n"
		"\tWRITE <device> DEBUG|BUFFER|[INPUT|OUTPUT <channel>] [<attribute>] <bytes_count>\n"
		"\t\tSet the value of an attribute\n"
		"\tREADBUF <device> <bytes_count>\n"
		"\t\tRead raw data from the specified device\n"
		"\tWRITEBUF <device> <bytes_count>\n"
		"\t\tWrite raw data to the specified device\n"
		"\tGETTRIG <device>\n"
		"\t\tGet the name of the trigger used by the specified device\n"
		"\tSETTRIG <device> [<trigger>]\n"
		"\t\tSet the trigger to use for the specified device\n"
		"\tSET <device> BUFFERS_COUNT <count>\n"
		"\t\tSet the number of kernel buffers for the specified device\n");
		YYACCEPT;
	}
#line 1239 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 5: /* Line: VERSION END  */
#line 138 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                      {
		struct parser_pdata *pdata = yyget_extra(scanner);
		char buf[128];
		snprintf(buf, sizeof(buf), "%u.%u.%-7.7s\n", LIBIIO_VERSION_MAJOR,
						LIBIIO_VERSION_MINOR, LIBIIO_VERSION_GIT);
		output(pdata, buf);
		YYACCEPT;
	}
#line 1252 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 6: /* Line: PRINT END  */
#line 146 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                    {
		struct parser_pdata *pdata = yyget_extra(scanner);
		const char *xml = iio_context_get_xml(pdata->ctx);
		if (!pdata->verbose) {
			char buf[128];
			snprintf(buf, sizeof(buf), "%lu\n", (unsigned long) strlen(xml));
			output(pdata, buf);
		}
		output(pdata, xml);
		output(pdata, "\n");
		YYACCEPT;
	}
#line 1269 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 7: /* Line: ZPRINT END  */
#line 158 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                     {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (pdata->xml_zstd) {
			if (!pdata->verbose) {
				char buf[128];
				snprintf(buf, sizeof(buf), "%lu\n", (unsigned long)pdata->xml_zstd_len);
				output(pdata, buf);
			}
			if (write_all(pdata, pdata->xml_zstd, pdata->xml_zstd_len) <= 0)
				pdata->stop = true;
			output(pdata, "\n");
			YYACCEPT;
		} else {
			char buf[128];
			snprintf(buf, sizeof(buf), "%d\n", -EINVAL);
			output(pdata, buf);
			YYABORT;
		}
	}
#line 1293 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 8: /* Line: TIMEOUT SPACE WORD END  */
#line 177 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                 {
		char *word = (yyvsp[-1].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		unsigned int timeout = (unsigned int) atoi(word);
		int ret = set_timeout(pdata, timeout);
		free(word);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1309 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 9: /* Line: OPEN SPACE DEVICE SPACE WORD SPACE WORD SPACE CYCLIC END  */
#line 188 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                                   {
		char *nb = (yyvsp[-5].word), *mask = (yyvsp[-3].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		unsigned long samples_count = atol(nb);
		int ret = open_dev(pdata, (yyvsp[-7].dev), samples_count, mask, true);
		free(nb);
		free(mask);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1326 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 10: /* Line: OPEN SPACE DEVICE SPACE WORD SPACE WORD END  */
#line 200 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                      {
		char *nb = (yyvsp[-3].word), *mask = (yyvsp[-1].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		unsigned long samples_count = atol(nb);
		int ret = open_dev(pdata, (yyvsp[-5].dev), samples_count, mask, false);
		free(nb);
		free(mask);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1343 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 11: /* Line: CLOSE SPACE DEVICE END  */
#line 212 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                 {
		struct parser_pdata *pdata = yyget_extra(scanner);
		int ret = close_dev(pdata, (yyvsp[-1].dev));
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1356 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 12: /* Line: READ SPACE DEVICE END  */
#line 220 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (read_dev_attr(pdata, (yyvsp[-1].dev), NULL, IIO_ATTR_TYPE_DEVICE) < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1368 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 13: /* Line: READ SPACE DEVICE SPACE WORD END  */
#line 227 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                           {
		char *attr = (yyvsp[-1].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = read_dev_attr(pdata, (yyvsp[-3].dev), attr, IIO_ATTR_TYPE_DEVICE);
		free(attr);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1383 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 14: /* Line: READ SPACE DEVICE SPACE DEBUG_ATTR END  */
#line 237 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                 {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (read_dev_attr(pdata, (yyvsp[-3].dev), NULL, IIO_ATTR_TYPE_DEBUG) < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1395 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 15: /* Line: READ SPACE DEVICE SPACE DEBUG_ATTR SPACE WORD END  */
#line 244 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                            {
		char *attr = (yyvsp[-1].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = read_dev_attr(pdata, (yyvsp[-5].dev), attr, IIO_ATTR_TYPE_DEBUG);
		free(attr);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1410 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 16: /* Line: READ SPACE DEVICE SPACE BUFFER_ATTR END  */
#line 254 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                  {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (read_dev_attr(pdata, (yyvsp[-3].dev), NULL, IIO_ATTR_TYPE_BUFFER) < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1422 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 17: /* Line: READ SPACE DEVICE SPACE BUFFER_ATTR SPACE WORD END  */
#line 261 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                             {
		char *attr = (yyvsp[-1].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = read_dev_attr(pdata, (yyvsp[-5].dev), attr, IIO_ATTR_TYPE_BUFFER);
		free(attr);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1437 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 18: /* Line: READ SPACE DEVICE SPACE IN_OUT SPACE CHANNEL END  */
#line 271 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                           {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (read_chn_attr(pdata, (yyvsp[-1].chn), NULL) < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1449 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 19: /* Line: READ SPACE DEVICE SPACE IN_OUT SPACE CHANNEL SPACE WORD END  */
#line 278 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                                      {
		char *attr = (yyvsp[-1].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = read_chn_attr(pdata, (yyvsp[-3].chn), attr);
		free(attr);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1464 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 20: /* Line: READBUF SPACE DEVICE SPACE WORD END  */
#line 288 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                              {
		char *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = rw_dev(pdata, (yyvsp[-3].dev), nb, false);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1480 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 21: /* Line: WRITEBUF SPACE DEVICE SPACE WORD END  */
#line 299 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                               {
		char *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = rw_dev(pdata, (yyvsp[-3].dev), nb, true);

		/* Discard additional data */
		yyclearin;

		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1500 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 22: /* Line: WRITE SPACE DEVICE SPACE WORD END  */
#line 314 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                            {
		char *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_dev_attr(pdata, (yyvsp[-3].dev), NULL, nb, IIO_ATTR_TYPE_DEVICE);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1516 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 23: /* Line: WRITE SPACE DEVICE SPACE WORD SPACE WORD END  */
#line 325 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                       {
		char *attr = (yyvsp[-3].word), *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_dev_attr(pdata, (yyvsp[-5].dev), attr, nb, IIO_ATTR_TYPE_DEVICE);
		free(attr);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1533 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 24: /* Line: WRITE SPACE DEVICE SPACE DEBUG_ATTR SPACE WORD END  */
#line 337 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                             {
		char *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_dev_attr(pdata, (yyvsp[-5].dev), NULL, nb, IIO_ATTR_TYPE_DEBUG);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1549 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 25: /* Line: WRITE SPACE DEVICE SPACE DEBUG_ATTR SPACE WORD SPACE WORD END  */
#line 348 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                                        {
		char *attr = (yyvsp[-3].word), *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_dev_attr(pdata, (yyvsp[-7].dev), attr, nb, IIO_ATTR_TYPE_DEBUG);
		free(attr);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1566 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 26: /* Line: WRITE SPACE DEVICE SPACE BUFFER_ATTR SPACE WORD END  */
#line 360 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                              {
		char *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_dev_attr(pdata, (yyvsp[-5].dev), NULL, nb, IIO_ATTR_TYPE_BUFFER);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1582 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 27: /* Line: WRITE SPACE DEVICE SPACE BUFFER_ATTR SPACE WORD SPACE WORD END  */
#line 371 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                                         {
		char *attr = (yyvsp[-3].word), *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_dev_attr(pdata, (yyvsp[-7].dev), attr, nb, IIO_ATTR_TYPE_BUFFER);
		free(attr);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1599 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 28: /* Line: WRITE SPACE DEVICE SPACE IN_OUT SPACE CHANNEL SPACE WORD END  */
#line 383 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                                       {
		char *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_chn_attr(pdata, (yyvsp[-3].chn), NULL, nb);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1615 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 29: /* Line: WRITE SPACE DEVICE SPACE IN_OUT SPACE CHANNEL SPACE WORD SPACE WORD END  */
#line 394 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                                                  {
		char *attr = (yyvsp[-3].word), *len = (yyvsp[-1].word);
		unsigned long nb = atol(len);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = write_chn_attr(pdata, (yyvsp[-5].chn), attr, nb);
		free(attr);
		free(len);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1632 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 30: /* Line: SETTRIG SPACE DEVICE SPACE WORD END  */
#line 406 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                              {
		char *trig = (yyvsp[-1].word);
		struct parser_pdata *pdata = yyget_extra(scanner);
		ssize_t ret = set_trigger(pdata, (yyvsp[-3].dev), trig);
		free(trig);
		if (ret < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1647 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 31: /* Line: SETTRIG SPACE DEVICE END  */
#line 416 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                   {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (set_trigger(pdata, (yyvsp[-1].dev), NULL) < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1659 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 32: /* Line: GETTRIG SPACE DEVICE END  */
#line 423 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                   {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (get_trigger(pdata, (yyvsp[-1].dev)) < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1671 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 33: /* Line: SET SPACE DEVICE SPACE BUFFERS_COUNT SPACE VALUE END  */
#line 430 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                                                               {
		struct parser_pdata *pdata = yyget_extra(scanner);
		if (set_buffers_count(pdata, (yyvsp[-5].dev), (yyvsp[-1].value)) < 0)
			YYABORT;
		else
			YYACCEPT;
	}
#line 1683 "/build/libiio/src/build/iiod/parser.c"
    break;

  case 34: /* Line: error END  */
#line 437 "/build/libiio/src/libiio-0.25/iiod/parser.y"
                    {
		yyclearin;
		yyerrok;
		YYACCEPT;
	}
#line 1693 "/build/libiio/src/build/iiod/parser.c"
    break;


#line 1697 "/build/libiio/src/build/iiod/parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (scanner, YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, scanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (scanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 444 "/build/libiio/src/libiio-0.25/iiod/parser.y"


void yyerror(yyscan_t scanner, const char *msg)
{
	struct parser_pdata *pdata = yyget_extra(scanner);
	if (pdata->verbose) {
		output(pdata, "ERROR: ");
		output(pdata, msg);
		output(pdata, "\n");
	} else {
		char buf[128];
		snprintf(buf, sizeof(buf), "%i\n", -EINVAL);
		output(pdata, buf);
	}
}

ssize_t yy_input(yyscan_t scanner, char *buf, size_t max_size)
{
	struct parser_pdata *pdata = yyget_extra(scanner);
	ssize_t ret;

	ret = read_line(pdata, buf, max_size);
	if (ret < 0)
		return ret;
	if (ret == 0)
		return -EIO;

	if ((size_t) ret == max_size)
		buf[max_size - 1] = '\0';

	return ret;
}
