/* history-file-importer.c generated by valac 0.56.14, the Vala compiler
 * generated from history-file-importer.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2016 Michael Catanzaro <mcatanzaro@gnome.org>
 *
 * This file is part of libgnome-games-support.
 *
 * libgnome-games-support is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * libgnome-games-support is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with libgnome-games-support.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgnome-games-support.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>

enum  {
	GAMES_SCORES_HISTORY_FILE_IMPORTER_0_PROPERTY,
	GAMES_SCORES_HISTORY_FILE_IMPORTER_NUM_PROPERTIES
};
static GParamSpec* games_scores_history_file_importer_properties[GAMES_SCORES_HISTORY_FILE_IMPORTER_NUM_PROPERTIES];
typedef struct _Block7Data Block7Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _GamesScoresHistoryFileImporterPrivate {
	GamesScoresHistoryFileImporterHistoryConvertFunc history_convert;
	gpointer history_convert_target;
	GDestroyNotify history_convert_target_destroy_notify;
};

struct _Block7Data {
	int _ref_count_;
	GamesScoresHistoryFileImporter* self;
	GamesScoresHistoryFileImporterHistoryConvertFunc history_convert;
	gpointer history_convert_target;
};

static gint GamesScoresHistoryFileImporter_private_offset;
static gpointer games_scores_history_file_importer_parent_class = NULL;

static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda16_ (Block7Data* _data7_,
                  const gchar* line,
                  GamesScoresScore** score,
                  GamesScoresCategory** category);
static void ___lambda16__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                           GamesScoresScore** score,
                                                                           GamesScoresCategory** category,
                                                                           gpointer self);
static void games_scores_history_file_importer_real_importOldScores (GamesScoresImporter* base,
                                                              GamesScoresContext* context,
                                                              GFile* new_scores_dir,
                                                              GError** error);
VALA_EXTERN gboolean games_scores_context_add_score_sync (GamesScoresContext* self,
                                              GamesScoresScore* score,
                                              GamesScoresCategory* category,
                                              GError** error);
static void games_scores_history_file_importer_finalize (GObject * obj);
static GType games_scores_history_file_importer_get_type_once (void);

static inline gpointer
games_scores_history_file_importer_get_instance_private (GamesScoresHistoryFileImporter* self)
{
	return G_STRUCT_MEMBER_P (self, GamesScoresHistoryFileImporter_private_offset);
}

GamesScoresHistoryFileImporter*
games_scores_history_file_importer_construct (GType object_type,
                                              GamesScoresHistoryFileImporterHistoryConvertFunc history_convert,
                                              gpointer history_convert_target)
{
	GamesScoresHistoryFileImporter * self = NULL;
	self = (GamesScoresHistoryFileImporter*) games_scores_importer_construct (object_type);
	games_scores_history_file_importer_set_history_convert_func (self, history_convert, history_convert_target);
	return self;
}

GamesScoresHistoryFileImporter*
games_scores_history_file_importer_new (GamesScoresHistoryFileImporterHistoryConvertFunc history_convert,
                                        gpointer history_convert_target)
{
	return games_scores_history_file_importer_construct (GAMES_SCORES_TYPE_HISTORY_FILE_IMPORTER, history_convert, history_convert_target);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GamesScoresHistoryFileImporter* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda16_ (Block7Data* _data7_,
             const gchar* line,
             GamesScoresScore** score,
             GamesScoresCategory** category)
{
	GamesScoresHistoryFileImporter* self;
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	GamesScoresScore* _tmp0_ = NULL;
	GamesScoresCategory* _tmp1_ = NULL;
	self = _data7_->self;
	g_return_if_fail (line != NULL);
	_data7_->history_convert (line, &_tmp0_, &_tmp1_, _data7_->history_convert_target);
	_g_object_unref0 (_vala_score);
	_vala_score = _tmp0_;
	_g_object_unref0 (_vala_category);
	_vala_category = _tmp1_;
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (category) {
		*category = _vala_category;
	} else {
		_g_object_unref0 (_vala_category);
	}
}

static void
___lambda16__games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                      GamesScoresScore** score,
                                                                      GamesScoresCategory** category,
                                                                      gpointer self)
{
	__lambda16_ (self, line, score, category);
}

void
games_scores_history_file_importer_set_history_convert_func (GamesScoresHistoryFileImporter* self,
                                                             GamesScoresHistoryFileImporterHistoryConvertFunc history_convert,
                                                             gpointer history_convert_target)
{
	Block7Data* _data7_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->history_convert = history_convert;
	_data7_->history_convert_target = history_convert_target;
	(self->priv->history_convert_target_destroy_notify == NULL) ? NULL : (self->priv->history_convert_target_destroy_notify (self->priv->history_convert_target), NULL);
	self->priv->history_convert = NULL;
	self->priv->history_convert_target = NULL;
	self->priv->history_convert_target_destroy_notify = NULL;
	self->priv->history_convert = ___lambda16__games_scores_history_file_importer_history_convert_func;
	self->priv->history_convert_target = block7_data_ref (_data7_);
	self->priv->history_convert_target_destroy_notify = block7_data_unref;
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

gint64
games_scores_history_file_importer_parse_date (const gchar* date)
{
	GDateTime* date_time = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gint64 result;
	g_return_val_if_fail (date != NULL, 0LL);
	_tmp0_ = g_date_time_new_from_iso8601 (date, NULL);
	date_time = _tmp0_;
	_tmp1_ = date_time;
	if (_tmp1_ == NULL) {
		g_warning ("history-file-importer.vala:54: Failed to parse date: %s", date);
	}
	_tmp2_ = date_time;
	result = g_date_time_to_unix (_tmp2_);
	_g_date_time_unref0 (date_time);
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
}

static void
games_scores_history_file_importer_real_importOldScores (GamesScoresImporter* base,
                                                         GamesScoresContext* context,
                                                         GFile* new_scores_dir,
                                                         GError** error)
{
	GamesScoresHistoryFileImporter * self;
	gchar* history_filename = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FILE* stream = NULL;
	const gchar* _tmp4_;
	FILE* _tmp5_;
	FILE* _tmp6_;
	const gchar* _tmp7_;
	gchar* line = NULL;
	GFile* history_file = NULL;
	const gchar* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GError* _inner_error0_ = NULL;
	self = (GamesScoresHistoryFileImporter*) base;
	g_return_if_fail (context != NULL);
	g_return_if_fail (new_scores_dir != NULL);
	_tmp0_ = g_file_get_path (new_scores_dir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_build_filename (_tmp1_, "..", "history", NULL, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	history_filename = _tmp3_;
	_tmp4_ = history_filename;
	_tmp5_ = g_fopen (_tmp4_, "r");
	stream = _tmp5_;
	_tmp6_ = stream;
	if (_tmp6_ == NULL) {
		_fclose0 (stream);
		_g_free0 (history_filename);
		return;
	}
	_tmp7_ = history_filename;
	g_debug ("history-file-importer.vala:70: Importing scores from %s", _tmp7_);
	while (TRUE) {
		FILE* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		GamesScoresScore* score = NULL;
		GamesScoresCategory* category = NULL;
		GamesScoresHistoryFileImporterHistoryConvertFunc _tmp11_;
		gpointer _tmp11__target;
		const gchar* _tmp12_;
		GamesScoresScore* _tmp13_ = NULL;
		GamesScoresCategory* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		GamesScoresScore* _tmp16_;
		GamesScoresScore* _tmp20_;
		GamesScoresCategory* _tmp21_;
		_tmp8_ = stream;
		_tmp9_ = g_file_stream_read_line (_tmp8_);
		_g_free0 (line);
		line = _tmp9_;
		_tmp10_ = line;
		if (!(_tmp10_ != NULL)) {
			break;
		}
		_tmp11_ = self->priv->history_convert;
		_tmp11__target = self->priv->history_convert_target;
		_tmp12_ = line;
		_tmp11_ (_tmp12_, &_tmp13_, &_tmp14_, _tmp11__target);
		_g_object_unref0 (score);
		score = _tmp13_;
		_g_object_unref0 (category);
		category = _tmp14_;
		_tmp16_ = score;
		if (_tmp16_ == NULL) {
			_tmp15_ = TRUE;
		} else {
			GamesScoresCategory* _tmp17_;
			_tmp17_ = category;
			_tmp15_ = _tmp17_ == NULL;
		}
		if (_tmp15_) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = history_filename;
			_tmp19_ = line;
			g_warning ("history-file-importer.vala:79: Failed to import from %s score line %s", _tmp18_, _tmp19_);
		}
		_tmp20_ = score;
		_tmp21_ = category;
		games_scores_context_add_score_sync (context, _tmp20_, _tmp21_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (category);
			_g_object_unref0 (score);
			_g_free0 (line);
			_fclose0 (stream);
			_g_free0 (history_filename);
			return;
		}
		_g_object_unref0 (category);
		_g_object_unref0 (score);
	}
	_tmp22_ = history_filename;
	_tmp23_ = g_file_new_for_path (_tmp22_);
	history_file = _tmp23_;
	_tmp24_ = history_file;
	g_file_delete (_tmp24_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (history_file);
		_g_free0 (line);
		_fclose0 (stream);
		_g_free0 (history_filename);
		return;
	}
	_g_object_unref0 (history_file);
	_g_free0 (line);
	_fclose0 (stream);
	_g_free0 (history_filename);
}

static void
games_scores_history_file_importer_class_init (GamesScoresHistoryFileImporterClass * klass,
                                               gpointer klass_data)
{
	games_scores_history_file_importer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesScoresHistoryFileImporter_private_offset);
	((GamesScoresImporterClass *) klass)->importOldScores = (void (*) (GamesScoresImporter*, GamesScoresContext*, GFile*, GError**)) games_scores_history_file_importer_real_importOldScores;
	G_OBJECT_CLASS (klass)->finalize = games_scores_history_file_importer_finalize;
}

static void
games_scores_history_file_importer_instance_init (GamesScoresHistoryFileImporter * self,
                                                  gpointer klass)
{
	self->priv = games_scores_history_file_importer_get_instance_private (self);
}

static void
games_scores_history_file_importer_finalize (GObject * obj)
{
	GamesScoresHistoryFileImporter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_SCORES_TYPE_HISTORY_FILE_IMPORTER, GamesScoresHistoryFileImporter);
	(self->priv->history_convert_target_destroy_notify == NULL) ? NULL : (self->priv->history_convert_target_destroy_notify (self->priv->history_convert_target), NULL);
	self->priv->history_convert = NULL;
	self->priv->history_convert_target = NULL;
	self->priv->history_convert_target_destroy_notify = NULL;
	G_OBJECT_CLASS (games_scores_history_file_importer_parent_class)->finalize (obj);
}

static GType
games_scores_history_file_importer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesScoresHistoryFileImporterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_scores_history_file_importer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesScoresHistoryFileImporter), 0, (GInstanceInitFunc) games_scores_history_file_importer_instance_init, NULL };
	GType games_scores_history_file_importer_type_id;
	games_scores_history_file_importer_type_id = g_type_register_static (GAMES_SCORES_TYPE_IMPORTER, "GamesScoresHistoryFileImporter", &g_define_type_info, 0);
	GamesScoresHistoryFileImporter_private_offset = g_type_add_instance_private (games_scores_history_file_importer_type_id, sizeof (GamesScoresHistoryFileImporterPrivate));
	return games_scores_history_file_importer_type_id;
}

GType
games_scores_history_file_importer_get_type (void)
{
	static volatile gsize games_scores_history_file_importer_type_id__once = 0;
	if (g_once_init_enter (&games_scores_history_file_importer_type_id__once)) {
		GType games_scores_history_file_importer_type_id;
		games_scores_history_file_importer_type_id = games_scores_history_file_importer_get_type_once ();
		g_once_init_leave (&games_scores_history_file_importer_type_id__once, games_scores_history_file_importer_type_id);
	}
	return games_scores_history_file_importer_type_id__once;
}

