// This is an auto-generated file.
// Any changes to this file will be overwritten

// clazy:excludeall=function-args-by-value

namespace Akonadi {
namespace Protocol {

int version()
{
    return 63;
}

void serialize(DataStream &stream, const CommandPtr &cmd)
{
    switch (static_cast<int>(cmd->type() | (cmd->isResponse() ? Command::_ResponseBit : 0))) {
    case Command::Invalid:
        stream << cmdCast<Command>(cmd);
        break;
    case Command::Invalid | Command::_ResponseBit:
        stream << cmdCast<Response>(cmd);
        break;
    case Command::Hello | Command::_ResponseBit:
        stream << cmdCast<HelloResponse>(cmd);
        break;
    case Command::Login:
        stream << cmdCast<LoginCommand>(cmd);
        break;
    case Command::Login | Command::_ResponseBit:
        stream << cmdCast<LoginResponse>(cmd);
        break;
    case Command::Logout:
        stream << cmdCast<LogoutCommand>(cmd);
        break;
    case Command::Logout | Command::_ResponseBit:
        stream << cmdCast<LogoutResponse>(cmd);
        break;
    case Command::Transaction:
        stream << cmdCast<TransactionCommand>(cmd);
        break;
    case Command::Transaction | Command::_ResponseBit:
        stream << cmdCast<TransactionResponse>(cmd);
        break;
    case Command::CreateItem:
        stream << cmdCast<CreateItemCommand>(cmd);
        break;
    case Command::CreateItem | Command::_ResponseBit:
        stream << cmdCast<CreateItemResponse>(cmd);
        break;
    case Command::CopyItems:
        stream << cmdCast<CopyItemsCommand>(cmd);
        break;
    case Command::CopyItems | Command::_ResponseBit:
        stream << cmdCast<CopyItemsResponse>(cmd);
        break;
    case Command::DeleteItems:
        stream << cmdCast<DeleteItemsCommand>(cmd);
        break;
    case Command::DeleteItems | Command::_ResponseBit:
        stream << cmdCast<DeleteItemsResponse>(cmd);
        break;
    case Command::FetchRelations:
        stream << cmdCast<FetchRelationsCommand>(cmd);
        break;
    case Command::FetchRelations | Command::_ResponseBit:
        stream << cmdCast<FetchRelationsResponse>(cmd);
        break;
    case Command::FetchTags:
        stream << cmdCast<FetchTagsCommand>(cmd);
        break;
    case Command::FetchTags | Command::_ResponseBit:
        stream << cmdCast<FetchTagsResponse>(cmd);
        break;
    case Command::FetchItems:
        stream << cmdCast<FetchItemsCommand>(cmd);
        break;
    case Command::FetchItems | Command::_ResponseBit:
        stream << cmdCast<FetchItemsResponse>(cmd);
        break;
    case Command::LinkItems:
        stream << cmdCast<LinkItemsCommand>(cmd);
        break;
    case Command::LinkItems | Command::_ResponseBit:
        stream << cmdCast<LinkItemsResponse>(cmd);
        break;
    case Command::ModifyItems:
        stream << cmdCast<ModifyItemsCommand>(cmd);
        break;
    case Command::ModifyItems | Command::_ResponseBit:
        stream << cmdCast<ModifyItemsResponse>(cmd);
        break;
    case Command::MoveItems:
        stream << cmdCast<MoveItemsCommand>(cmd);
        break;
    case Command::MoveItems | Command::_ResponseBit:
        stream << cmdCast<MoveItemsResponse>(cmd);
        break;
    case Command::CreateCollection:
        stream << cmdCast<CreateCollectionCommand>(cmd);
        break;
    case Command::CreateCollection | Command::_ResponseBit:
        stream << cmdCast<CreateCollectionResponse>(cmd);
        break;
    case Command::CopyCollection:
        stream << cmdCast<CopyCollectionCommand>(cmd);
        break;
    case Command::CopyCollection | Command::_ResponseBit:
        stream << cmdCast<CopyCollectionResponse>(cmd);
        break;
    case Command::DeleteCollection:
        stream << cmdCast<DeleteCollectionCommand>(cmd);
        break;
    case Command::DeleteCollection | Command::_ResponseBit:
        stream << cmdCast<DeleteCollectionResponse>(cmd);
        break;
    case Command::FetchCollectionStats:
        stream << cmdCast<FetchCollectionStatsCommand>(cmd);
        break;
    case Command::FetchCollectionStats | Command::_ResponseBit:
        stream << cmdCast<FetchCollectionStatsResponse>(cmd);
        break;
    case Command::FetchCollections:
        stream << cmdCast<FetchCollectionsCommand>(cmd);
        break;
    case Command::FetchCollections | Command::_ResponseBit:
        stream << cmdCast<FetchCollectionsResponse>(cmd);
        break;
    case Command::ModifyCollection:
        stream << cmdCast<ModifyCollectionCommand>(cmd);
        break;
    case Command::ModifyCollection | Command::_ResponseBit:
        stream << cmdCast<ModifyCollectionResponse>(cmd);
        break;
    case Command::MoveCollection:
        stream << cmdCast<MoveCollectionCommand>(cmd);
        break;
    case Command::MoveCollection | Command::_ResponseBit:
        stream << cmdCast<MoveCollectionResponse>(cmd);
        break;
    case Command::Search:
        stream << cmdCast<SearchCommand>(cmd);
        break;
    case Command::Search | Command::_ResponseBit:
        stream << cmdCast<SearchResponse>(cmd);
        break;
    case Command::SearchResult:
        stream << cmdCast<SearchResultCommand>(cmd);
        break;
    case Command::SearchResult | Command::_ResponseBit:
        stream << cmdCast<SearchResultResponse>(cmd);
        break;
    case Command::StoreSearch:
        stream << cmdCast<StoreSearchCommand>(cmd);
        break;
    case Command::StoreSearch | Command::_ResponseBit:
        stream << cmdCast<StoreSearchResponse>(cmd);
        break;
    case Command::CreateTag:
        stream << cmdCast<CreateTagCommand>(cmd);
        break;
    case Command::CreateTag | Command::_ResponseBit:
        stream << cmdCast<CreateTagResponse>(cmd);
        break;
    case Command::DeleteTag:
        stream << cmdCast<DeleteTagCommand>(cmd);
        break;
    case Command::DeleteTag | Command::_ResponseBit:
        stream << cmdCast<DeleteTagResponse>(cmd);
        break;
    case Command::ModifyTag:
        stream << cmdCast<ModifyTagCommand>(cmd);
        break;
    case Command::ModifyTag | Command::_ResponseBit:
        stream << cmdCast<ModifyTagResponse>(cmd);
        break;
    case Command::ModifyRelation:
        stream << cmdCast<ModifyRelationCommand>(cmd);
        break;
    case Command::ModifyRelation | Command::_ResponseBit:
        stream << cmdCast<ModifyRelationResponse>(cmd);
        break;
    case Command::RemoveRelations:
        stream << cmdCast<RemoveRelationsCommand>(cmd);
        break;
    case Command::RemoveRelations | Command::_ResponseBit:
        stream << cmdCast<RemoveRelationsResponse>(cmd);
        break;
    case Command::SelectResource:
        stream << cmdCast<SelectResourceCommand>(cmd);
        break;
    case Command::SelectResource | Command::_ResponseBit:
        stream << cmdCast<SelectResourceResponse>(cmd);
        break;
    case Command::StreamPayload:
        stream << cmdCast<StreamPayloadCommand>(cmd);
        break;
    case Command::StreamPayload | Command::_ResponseBit:
        stream << cmdCast<StreamPayloadResponse>(cmd);
        break;
    case Command::ItemChangeNotification:
        stream << cmdCast<ItemChangeNotification>(cmd);
        break;
    case Command::CollectionChangeNotification:
        stream << cmdCast<CollectionChangeNotification>(cmd);
        break;
    case Command::TagChangeNotification:
        stream << cmdCast<TagChangeNotification>(cmd);
        break;
    case Command::RelationChangeNotification:
        stream << cmdCast<RelationChangeNotification>(cmd);
        break;
    case Command::CreateSubscription:
        stream << cmdCast<CreateSubscriptionCommand>(cmd);
        break;
    case Command::CreateSubscription | Command::_ResponseBit:
        stream << cmdCast<CreateSubscriptionResponse>(cmd);
        break;
    case Command::ModifySubscription:
        stream << cmdCast<ModifySubscriptionCommand>(cmd);
        break;
    case Command::ModifySubscription | Command::_ResponseBit:
        stream << cmdCast<ModifySubscriptionResponse>(cmd);
        break;
    case Command::SubscriptionChangeNotification:
        stream << cmdCast<SubscriptionChangeNotification>(cmd);
        break;
    case Command::DebugChangeNotification:
        stream << cmdCast<DebugChangeNotification>(cmd);
        break;
    }
}

CommandPtr deserialize(QIODevice *device)
{
    DataStream stream(device);
    stream.waitForData(sizeof(Command::Type));
    Command::Type cmdType;
    if (Q_UNLIKELY(device->peek((char *) &cmdType, sizeof(Command::Type)) != sizeof(Command::Type))) {
        throw ProtocolException("Failed to peek command type");
    }
    CommandPtr cmd;
    if (cmdType & Command::_ResponseBit) {
        cmd = Factory::response(Command::Type(cmdType & ~Command::_ResponseBit));
    } else {
        cmd = Factory::command(cmdType);
    }

    switch (static_cast<int>(cmdType)) {
    case Command::Invalid:
        stream >> cmdCast<Command>(cmd);
        return cmd;
    case Command::Invalid | Command::_ResponseBit:
        stream >> cmdCast<Response>(cmd);
        return cmd;
    case Command::Hello | Command::_ResponseBit:
        stream >> cmdCast<HelloResponse>(cmd);
        return cmd;
    case Command::Login:
        stream >> cmdCast<LoginCommand>(cmd);
        return cmd;
    case Command::Login | Command::_ResponseBit:
        stream >> cmdCast<LoginResponse>(cmd);
        return cmd;
    case Command::Logout:
        stream >> cmdCast<LogoutCommand>(cmd);
        return cmd;
    case Command::Logout | Command::_ResponseBit:
        stream >> cmdCast<LogoutResponse>(cmd);
        return cmd;
    case Command::Transaction:
        stream >> cmdCast<TransactionCommand>(cmd);
        return cmd;
    case Command::Transaction | Command::_ResponseBit:
        stream >> cmdCast<TransactionResponse>(cmd);
        return cmd;
    case Command::CreateItem:
        stream >> cmdCast<CreateItemCommand>(cmd);
        return cmd;
    case Command::CreateItem | Command::_ResponseBit:
        stream >> cmdCast<CreateItemResponse>(cmd);
        return cmd;
    case Command::CopyItems:
        stream >> cmdCast<CopyItemsCommand>(cmd);
        return cmd;
    case Command::CopyItems | Command::_ResponseBit:
        stream >> cmdCast<CopyItemsResponse>(cmd);
        return cmd;
    case Command::DeleteItems:
        stream >> cmdCast<DeleteItemsCommand>(cmd);
        return cmd;
    case Command::DeleteItems | Command::_ResponseBit:
        stream >> cmdCast<DeleteItemsResponse>(cmd);
        return cmd;
    case Command::FetchRelations:
        stream >> cmdCast<FetchRelationsCommand>(cmd);
        return cmd;
    case Command::FetchRelations | Command::_ResponseBit:
        stream >> cmdCast<FetchRelationsResponse>(cmd);
        return cmd;
    case Command::FetchTags:
        stream >> cmdCast<FetchTagsCommand>(cmd);
        return cmd;
    case Command::FetchTags | Command::_ResponseBit:
        stream >> cmdCast<FetchTagsResponse>(cmd);
        return cmd;
    case Command::FetchItems:
        stream >> cmdCast<FetchItemsCommand>(cmd);
        return cmd;
    case Command::FetchItems | Command::_ResponseBit:
        stream >> cmdCast<FetchItemsResponse>(cmd);
        return cmd;
    case Command::LinkItems:
        stream >> cmdCast<LinkItemsCommand>(cmd);
        return cmd;
    case Command::LinkItems | Command::_ResponseBit:
        stream >> cmdCast<LinkItemsResponse>(cmd);
        return cmd;
    case Command::ModifyItems:
        stream >> cmdCast<ModifyItemsCommand>(cmd);
        return cmd;
    case Command::ModifyItems | Command::_ResponseBit:
        stream >> cmdCast<ModifyItemsResponse>(cmd);
        return cmd;
    case Command::MoveItems:
        stream >> cmdCast<MoveItemsCommand>(cmd);
        return cmd;
    case Command::MoveItems | Command::_ResponseBit:
        stream >> cmdCast<MoveItemsResponse>(cmd);
        return cmd;
    case Command::CreateCollection:
        stream >> cmdCast<CreateCollectionCommand>(cmd);
        return cmd;
    case Command::CreateCollection | Command::_ResponseBit:
        stream >> cmdCast<CreateCollectionResponse>(cmd);
        return cmd;
    case Command::CopyCollection:
        stream >> cmdCast<CopyCollectionCommand>(cmd);
        return cmd;
    case Command::CopyCollection | Command::_ResponseBit:
        stream >> cmdCast<CopyCollectionResponse>(cmd);
        return cmd;
    case Command::DeleteCollection:
        stream >> cmdCast<DeleteCollectionCommand>(cmd);
        return cmd;
    case Command::DeleteCollection | Command::_ResponseBit:
        stream >> cmdCast<DeleteCollectionResponse>(cmd);
        return cmd;
    case Command::FetchCollectionStats:
        stream >> cmdCast<FetchCollectionStatsCommand>(cmd);
        return cmd;
    case Command::FetchCollectionStats | Command::_ResponseBit:
        stream >> cmdCast<FetchCollectionStatsResponse>(cmd);
        return cmd;
    case Command::FetchCollections:
        stream >> cmdCast<FetchCollectionsCommand>(cmd);
        return cmd;
    case Command::FetchCollections | Command::_ResponseBit:
        stream >> cmdCast<FetchCollectionsResponse>(cmd);
        return cmd;
    case Command::ModifyCollection:
        stream >> cmdCast<ModifyCollectionCommand>(cmd);
        return cmd;
    case Command::ModifyCollection | Command::_ResponseBit:
        stream >> cmdCast<ModifyCollectionResponse>(cmd);
        return cmd;
    case Command::MoveCollection:
        stream >> cmdCast<MoveCollectionCommand>(cmd);
        return cmd;
    case Command::MoveCollection | Command::_ResponseBit:
        stream >> cmdCast<MoveCollectionResponse>(cmd);
        return cmd;
    case Command::Search:
        stream >> cmdCast<SearchCommand>(cmd);
        return cmd;
    case Command::Search | Command::_ResponseBit:
        stream >> cmdCast<SearchResponse>(cmd);
        return cmd;
    case Command::SearchResult:
        stream >> cmdCast<SearchResultCommand>(cmd);
        return cmd;
    case Command::SearchResult | Command::_ResponseBit:
        stream >> cmdCast<SearchResultResponse>(cmd);
        return cmd;
    case Command::StoreSearch:
        stream >> cmdCast<StoreSearchCommand>(cmd);
        return cmd;
    case Command::StoreSearch | Command::_ResponseBit:
        stream >> cmdCast<StoreSearchResponse>(cmd);
        return cmd;
    case Command::CreateTag:
        stream >> cmdCast<CreateTagCommand>(cmd);
        return cmd;
    case Command::CreateTag | Command::_ResponseBit:
        stream >> cmdCast<CreateTagResponse>(cmd);
        return cmd;
    case Command::DeleteTag:
        stream >> cmdCast<DeleteTagCommand>(cmd);
        return cmd;
    case Command::DeleteTag | Command::_ResponseBit:
        stream >> cmdCast<DeleteTagResponse>(cmd);
        return cmd;
    case Command::ModifyTag:
        stream >> cmdCast<ModifyTagCommand>(cmd);
        return cmd;
    case Command::ModifyTag | Command::_ResponseBit:
        stream >> cmdCast<ModifyTagResponse>(cmd);
        return cmd;
    case Command::ModifyRelation:
        stream >> cmdCast<ModifyRelationCommand>(cmd);
        return cmd;
    case Command::ModifyRelation | Command::_ResponseBit:
        stream >> cmdCast<ModifyRelationResponse>(cmd);
        return cmd;
    case Command::RemoveRelations:
        stream >> cmdCast<RemoveRelationsCommand>(cmd);
        return cmd;
    case Command::RemoveRelations | Command::_ResponseBit:
        stream >> cmdCast<RemoveRelationsResponse>(cmd);
        return cmd;
    case Command::SelectResource:
        stream >> cmdCast<SelectResourceCommand>(cmd);
        return cmd;
    case Command::SelectResource | Command::_ResponseBit:
        stream >> cmdCast<SelectResourceResponse>(cmd);
        return cmd;
    case Command::StreamPayload:
        stream >> cmdCast<StreamPayloadCommand>(cmd);
        return cmd;
    case Command::StreamPayload | Command::_ResponseBit:
        stream >> cmdCast<StreamPayloadResponse>(cmd);
        return cmd;
    case Command::ItemChangeNotification:
        stream >> cmdCast<ItemChangeNotification>(cmd);
        return cmd;
    case Command::CollectionChangeNotification:
        stream >> cmdCast<CollectionChangeNotification>(cmd);
        return cmd;
    case Command::TagChangeNotification:
        stream >> cmdCast<TagChangeNotification>(cmd);
        return cmd;
    case Command::RelationChangeNotification:
        stream >> cmdCast<RelationChangeNotification>(cmd);
        return cmd;
    case Command::CreateSubscription:
        stream >> cmdCast<CreateSubscriptionCommand>(cmd);
        return cmd;
    case Command::CreateSubscription | Command::_ResponseBit:
        stream >> cmdCast<CreateSubscriptionResponse>(cmd);
        return cmd;
    case Command::ModifySubscription:
        stream >> cmdCast<ModifySubscriptionCommand>(cmd);
        return cmd;
    case Command::ModifySubscription | Command::_ResponseBit:
        stream >> cmdCast<ModifySubscriptionResponse>(cmd);
        return cmd;
    case Command::SubscriptionChangeNotification:
        stream >> cmdCast<SubscriptionChangeNotification>(cmd);
        return cmd;
    case Command::DebugChangeNotification:
        stream >> cmdCast<DebugChangeNotification>(cmd);
        return cmd;
    }
    return CommandPtr::create();
}

QString debugString(const Command &cmd)
{
    QString out;
    switch (static_cast<int>(cmd.type() | (cmd.isResponse() ? Command::_ResponseBit : 0))) {
    case Command::Invalid:
        QDebug(&out).noquote() << static_cast<const Command &>(cmd);
        return out;
    case Command::Invalid | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const Response &>(cmd);
        return out;
    case Command::Hello | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const HelloResponse &>(cmd);
        return out;
    case Command::Login:
        QDebug(&out).noquote() << static_cast<const LoginCommand &>(cmd);
        return out;
    case Command::Login | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const LoginResponse &>(cmd);
        return out;
    case Command::Logout:
        QDebug(&out).noquote() << static_cast<const LogoutCommand &>(cmd);
        return out;
    case Command::Logout | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const LogoutResponse &>(cmd);
        return out;
    case Command::Transaction:
        QDebug(&out).noquote() << static_cast<const TransactionCommand &>(cmd);
        return out;
    case Command::Transaction | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const TransactionResponse &>(cmd);
        return out;
    case Command::CreateItem:
        QDebug(&out).noquote() << static_cast<const CreateItemCommand &>(cmd);
        return out;
    case Command::CreateItem | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateItemResponse &>(cmd);
        return out;
    case Command::CopyItems:
        QDebug(&out).noquote() << static_cast<const CopyItemsCommand &>(cmd);
        return out;
    case Command::CopyItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CopyItemsResponse &>(cmd);
        return out;
    case Command::DeleteItems:
        QDebug(&out).noquote() << static_cast<const DeleteItemsCommand &>(cmd);
        return out;
    case Command::DeleteItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const DeleteItemsResponse &>(cmd);
        return out;
    case Command::FetchRelations:
        QDebug(&out).noquote() << static_cast<const FetchRelationsCommand &>(cmd);
        return out;
    case Command::FetchRelations | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchRelationsResponse &>(cmd);
        return out;
    case Command::FetchTags:
        QDebug(&out).noquote() << static_cast<const FetchTagsCommand &>(cmd);
        return out;
    case Command::FetchTags | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchTagsResponse &>(cmd);
        return out;
    case Command::FetchItems:
        QDebug(&out).noquote() << static_cast<const FetchItemsCommand &>(cmd);
        return out;
    case Command::FetchItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchItemsResponse &>(cmd);
        return out;
    case Command::LinkItems:
        QDebug(&out).noquote() << static_cast<const LinkItemsCommand &>(cmd);
        return out;
    case Command::LinkItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const LinkItemsResponse &>(cmd);
        return out;
    case Command::ModifyItems:
        QDebug(&out).noquote() << static_cast<const ModifyItemsCommand &>(cmd);
        return out;
    case Command::ModifyItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyItemsResponse &>(cmd);
        return out;
    case Command::MoveItems:
        QDebug(&out).noquote() << static_cast<const MoveItemsCommand &>(cmd);
        return out;
    case Command::MoveItems | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const MoveItemsResponse &>(cmd);
        return out;
    case Command::CreateCollection:
        QDebug(&out).noquote() << static_cast<const CreateCollectionCommand &>(cmd);
        return out;
    case Command::CreateCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateCollectionResponse &>(cmd);
        return out;
    case Command::CopyCollection:
        QDebug(&out).noquote() << static_cast<const CopyCollectionCommand &>(cmd);
        return out;
    case Command::CopyCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CopyCollectionResponse &>(cmd);
        return out;
    case Command::DeleteCollection:
        QDebug(&out).noquote() << static_cast<const DeleteCollectionCommand &>(cmd);
        return out;
    case Command::DeleteCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const DeleteCollectionResponse &>(cmd);
        return out;
    case Command::FetchCollectionStats:
        QDebug(&out).noquote() << static_cast<const FetchCollectionStatsCommand &>(cmd);
        return out;
    case Command::FetchCollectionStats | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchCollectionStatsResponse &>(cmd);
        return out;
    case Command::FetchCollections:
        QDebug(&out).noquote() << static_cast<const FetchCollectionsCommand &>(cmd);
        return out;
    case Command::FetchCollections | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const FetchCollectionsResponse &>(cmd);
        return out;
    case Command::ModifyCollection:
        QDebug(&out).noquote() << static_cast<const ModifyCollectionCommand &>(cmd);
        return out;
    case Command::ModifyCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyCollectionResponse &>(cmd);
        return out;
    case Command::MoveCollection:
        QDebug(&out).noquote() << static_cast<const MoveCollectionCommand &>(cmd);
        return out;
    case Command::MoveCollection | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const MoveCollectionResponse &>(cmd);
        return out;
    case Command::Search:
        QDebug(&out).noquote() << static_cast<const SearchCommand &>(cmd);
        return out;
    case Command::Search | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const SearchResponse &>(cmd);
        return out;
    case Command::SearchResult:
        QDebug(&out).noquote() << static_cast<const SearchResultCommand &>(cmd);
        return out;
    case Command::SearchResult | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const SearchResultResponse &>(cmd);
        return out;
    case Command::StoreSearch:
        QDebug(&out).noquote() << static_cast<const StoreSearchCommand &>(cmd);
        return out;
    case Command::StoreSearch | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const StoreSearchResponse &>(cmd);
        return out;
    case Command::CreateTag:
        QDebug(&out).noquote() << static_cast<const CreateTagCommand &>(cmd);
        return out;
    case Command::CreateTag | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateTagResponse &>(cmd);
        return out;
    case Command::DeleteTag:
        QDebug(&out).noquote() << static_cast<const DeleteTagCommand &>(cmd);
        return out;
    case Command::DeleteTag | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const DeleteTagResponse &>(cmd);
        return out;
    case Command::ModifyTag:
        QDebug(&out).noquote() << static_cast<const ModifyTagCommand &>(cmd);
        return out;
    case Command::ModifyTag | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyTagResponse &>(cmd);
        return out;
    case Command::ModifyRelation:
        QDebug(&out).noquote() << static_cast<const ModifyRelationCommand &>(cmd);
        return out;
    case Command::ModifyRelation | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifyRelationResponse &>(cmd);
        return out;
    case Command::RemoveRelations:
        QDebug(&out).noquote() << static_cast<const RemoveRelationsCommand &>(cmd);
        return out;
    case Command::RemoveRelations | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const RemoveRelationsResponse &>(cmd);
        return out;
    case Command::SelectResource:
        QDebug(&out).noquote() << static_cast<const SelectResourceCommand &>(cmd);
        return out;
    case Command::SelectResource | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const SelectResourceResponse &>(cmd);
        return out;
    case Command::StreamPayload:
        QDebug(&out).noquote() << static_cast<const StreamPayloadCommand &>(cmd);
        return out;
    case Command::StreamPayload | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const StreamPayloadResponse &>(cmd);
        return out;
    case Command::ItemChangeNotification:
        QDebug(&out).noquote() << static_cast<const ItemChangeNotification &>(cmd);
        return out;
    case Command::CollectionChangeNotification:
        QDebug(&out).noquote() << static_cast<const CollectionChangeNotification &>(cmd);
        return out;
    case Command::TagChangeNotification:
        QDebug(&out).noquote() << static_cast<const TagChangeNotification &>(cmd);
        return out;
    case Command::RelationChangeNotification:
        QDebug(&out).noquote() << static_cast<const RelationChangeNotification &>(cmd);
        return out;
    case Command::CreateSubscription:
        QDebug(&out).noquote() << static_cast<const CreateSubscriptionCommand &>(cmd);
        return out;
    case Command::CreateSubscription | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const CreateSubscriptionResponse &>(cmd);
        return out;
    case Command::ModifySubscription:
        QDebug(&out).noquote() << static_cast<const ModifySubscriptionCommand &>(cmd);
        return out;
    case Command::ModifySubscription | Command::_ResponseBit:
        QDebug(&out).noquote() << static_cast<const ModifySubscriptionResponse &>(cmd);
        return out;
    case Command::SubscriptionChangeNotification:
        QDebug(&out).noquote() << static_cast<const SubscriptionChangeNotification &>(cmd);
        return out;
    case Command::DebugChangeNotification:
        QDebug(&out).noquote() << static_cast<const DebugChangeNotification &>(cmd);
        return out;
    }
    return QString();
}



/************************* Ancestor *************************/

Ancestor::Ancestor()
{
}

Ancestor::Ancestor(qint64 id, const QString &remoteId)
    : mId(id)
    , mRemoteId(remoteId)
{
}

bool Ancestor::operator==(const Ancestor &other) const
{
    return true // simplifies generation
        && mId == other.mId
        && mRemoteId == other.mRemoteId
        && mName == other.mName
        && mAttributes == other.mAttributes
    ;
}

DataStream &operator<<(DataStream &stream, const Ancestor &obj)
{
    stream << obj.mId;
    stream << obj.mRemoteId;
    stream << obj.mName;
    stream << obj.mAttributes;
    return stream;
}

DataStream &operator>>(DataStream &stream, Ancestor &obj)
{
    stream >> obj.mId;
    stream >> obj.mRemoteId;
    stream >> obj.mName;
    stream >> obj.mAttributes;
    return stream;
}

QDebug operator<<(QDebug dbg, const Ancestor &obj)
{
    dbg.noquote()
        << "id:" << obj.mId << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "name:" << obj.mName << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
    return dbg;
}

void Ancestor::toJson(QJsonObject &json) const
{
    json[QStringLiteral("id")] = mId;/* qint64 */
    json[QStringLiteral("remoteId")] = mRemoteId;/* QString*/
    json[QStringLiteral("name")] = mName;/* QString*/
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
}



/************************* PartMetaData *************************/

PartMetaData::PartMetaData()
{
}

PartMetaData::PartMetaData(const QByteArray &name, qint64 size, int version, const PartMetaData::StorageType &storageType)
    : mName(name)
    , mSize(size)
    , mVersion(version)
    , mStorageType(storageType)
{
}

bool PartMetaData::operator==(const PartMetaData &other) const
{
    return true // simplifies generation
        && mName == other.mName
        && mSize == other.mSize
        && mVersion == other.mVersion
        && mStorageType == other.mStorageType
    ;
}

DataStream &operator<<(DataStream &stream, const PartMetaData &obj)
{
    stream << obj.mName;
    stream << obj.mSize;
    stream << obj.mVersion;
    stream << obj.mStorageType;
    return stream;
}

DataStream &operator>>(DataStream &stream, PartMetaData &obj)
{
    stream >> obj.mName;
    stream >> obj.mSize;
    stream >> obj.mVersion;
    stream >> obj.mStorageType;
    return stream;
}

QDebug operator<<(QDebug dbg, const PartMetaData &obj)
{
    dbg.noquote()
        << "name:" << obj.mName << "\n"
        << "size:" << obj.mSize << "\n"
        << "version:" << obj.mVersion << "\n"
        << "storageType:" << obj.mStorageType << "\n"
    ;
    return dbg;
}

void PartMetaData::toJson(QJsonObject &json) const
{
    json[QStringLiteral("name")] = QString::fromUtf8(mName)/* QByteArray */;
    json[QStringLiteral("size")] = mSize;/* qint64 */
    json[QStringLiteral("version")] = mVersion;/* int */
    json[QStringLiteral("storageType")] = mStorageType;/* PartMetaData::StorageType*/
}



/************************* CachePolicy *************************/

CachePolicy::CachePolicy()
{
}

bool CachePolicy::operator==(const CachePolicy &other) const
{
    return true // simplifies generation
        && mLocalParts == other.mLocalParts
        && mCheckInterval == other.mCheckInterval
        && mCacheTimeout == other.mCacheTimeout
        && mInherit == other.mInherit
        && mSyncOnDemand == other.mSyncOnDemand
    ;
}

DataStream &operator<<(DataStream &stream, const CachePolicy &obj)
{
    stream << obj.mLocalParts;
    stream << obj.mCheckInterval;
    stream << obj.mCacheTimeout;
    stream << obj.mInherit;
    stream << obj.mSyncOnDemand;
    return stream;
}

DataStream &operator>>(DataStream &stream, CachePolicy &obj)
{
    stream >> obj.mLocalParts;
    stream >> obj.mCheckInterval;
    stream >> obj.mCacheTimeout;
    stream >> obj.mInherit;
    stream >> obj.mSyncOnDemand;
    return stream;
}

QDebug operator<<(QDebug dbg, const CachePolicy &obj)
{
    dbg.noquote()
        << "localParts:" << obj.mLocalParts << "\n"
        << "checkInterval:" << obj.mCheckInterval << "\n"
        << "cacheTimeout:" << obj.mCacheTimeout << "\n"
        << "inherit:" << obj.mInherit << "\n"
        << "syncOnDemand:" << obj.mSyncOnDemand << "\n"
    ;
    return dbg;
}

void CachePolicy::toJson(QJsonObject &json) const
{
    json[QStringLiteral("localParts")] = QJsonArray::fromStringList(mLocalParts);/* QStringList */
    json[QStringLiteral("checkInterval")] = mCheckInterval;/* int */
    json[QStringLiteral("cacheTimeout")] = mCacheTimeout;/* int */
    json[QStringLiteral("inherit")] = mInherit;/* bool */
    json[QStringLiteral("syncOnDemand")] = mSyncOnDemand;/* bool */
}



/************************* CollectionFetchScope *************************/

CollectionFetchScope::CollectionFetchScope()
{
}

bool CollectionFetchScope::operator==(const CollectionFetchScope &other) const
{
    return true // simplifies generation
        && mResource == other.mResource
        && mContentMimeTypes == other.mContentMimeTypes
        && containerComparator(mAttributes, other.mAttributes)
        && containerComparator(mAncestorAttributes, other.mAncestorAttributes)
        && mListFilter == other.mListFilter
        && mAncestorRetrieval == other.mAncestorRetrieval
        && mIncludeStatistics == other.mIncludeStatistics
        && mFetchIdOnly == other.mFetchIdOnly
        && mAncestorFetchIdOnly == other.mAncestorFetchIdOnly
        && mIgnoreRetrievalErrors == other.mIgnoreRetrievalErrors
    ;
}

DataStream &operator<<(DataStream &stream, const CollectionFetchScope &obj)
{
    stream << obj.mResource;
    stream << obj.mContentMimeTypes;
    stream << obj.mAttributes;
    stream << obj.mAncestorAttributes;
    stream << obj.mListFilter;
    stream << obj.mAncestorRetrieval;
    stream << obj.mIncludeStatistics;
    stream << obj.mFetchIdOnly;
    stream << obj.mAncestorFetchIdOnly;
    stream << obj.mIgnoreRetrievalErrors;
    return stream;
}

DataStream &operator>>(DataStream &stream, CollectionFetchScope &obj)
{
    stream >> obj.mResource;
    stream >> obj.mContentMimeTypes;
    stream >> obj.mAttributes;
    stream >> obj.mAncestorAttributes;
    stream >> obj.mListFilter;
    stream >> obj.mAncestorRetrieval;
    stream >> obj.mIncludeStatistics;
    stream >> obj.mFetchIdOnly;
    stream >> obj.mAncestorFetchIdOnly;
    stream >> obj.mIgnoreRetrievalErrors;
    return stream;
}

QDebug operator<<(QDebug dbg, const CollectionFetchScope &obj)
{
    dbg.noquote()
        << "resource:" << obj.mResource << "\n"
        << "contentMimeTypes:" << obj.mContentMimeTypes << "\n"
        << "attributes: [\n";
    for (const auto &type : std::as_const(obj.mAttributes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "ancestorAttributes: [\n";
    for (const auto &type : std::as_const(obj.mAncestorAttributes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "listFilter:" << obj.mListFilter << "\n"
        << "ancestorRetrieval:" << obj.mAncestorRetrieval << "\n"
        << "includeStatistics:" << obj.mIncludeStatistics << "\n"
        << "fetchIdOnly:" << obj.mFetchIdOnly << "\n"
        << "ancestorFetchIdOnly:" << obj.mAncestorFetchIdOnly << "\n"
        << "ignoreRetrievalErrors:" << obj.mIgnoreRetrievalErrors << "\n"
    ;
    return dbg;
}

void CollectionFetchScope::toJson(QJsonObject &json) const
{
    json[QStringLiteral("resource")] = mResource;/* QString*/
    json[QStringLiteral("contentMimeTypes")] = QJsonArray::fromStringList(mContentMimeTypes);/* QStringList */
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAttributes)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("attributes")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAncestorAttributes)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("ancestorAttributes")] = jsonArray;
    }
    json[QStringLiteral("listFilter")] = mListFilter;/* CollectionFetchScope::ListFilter*/
    json[QStringLiteral("ancestorRetrieval")] = mAncestorRetrieval;/* CollectionFetchScope::AncestorRetrieval*/
    json[QStringLiteral("includeStatistics")] = mIncludeStatistics;/* bool */
    json[QStringLiteral("fetchIdOnly")] = mFetchIdOnly;/* bool */
    json[QStringLiteral("ancestorFetchIdOnly")] = mAncestorFetchIdOnly;/* bool */
    json[QStringLiteral("ignoreRetrievalErrors")] = mIgnoreRetrievalErrors;/* bool */
}



/************************* TagFetchScope *************************/

TagFetchScope::TagFetchScope()
{
}

bool TagFetchScope::operator==(const TagFetchScope &other) const
{
    return true // simplifies generation
        && containerComparator(mAttributes, other.mAttributes)
        && mFetchIdOnly == other.mFetchIdOnly
        && mFetchRemoteID == other.mFetchRemoteID
        && mFetchAllAttributes == other.mFetchAllAttributes
    ;
}

DataStream &operator<<(DataStream &stream, const TagFetchScope &obj)
{
    stream << obj.mAttributes;
    stream << obj.mFetchIdOnly;
    stream << obj.mFetchRemoteID;
    stream << obj.mFetchAllAttributes;
    return stream;
}

DataStream &operator>>(DataStream &stream, TagFetchScope &obj)
{
    stream >> obj.mAttributes;
    stream >> obj.mFetchIdOnly;
    stream >> obj.mFetchRemoteID;
    stream >> obj.mFetchAllAttributes;
    return stream;
}

QDebug operator<<(QDebug dbg, const TagFetchScope &obj)
{
    dbg.noquote()
        << "attributes: [\n";
    for (const auto &type : std::as_const(obj.mAttributes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "fetchIdOnly:" << obj.mFetchIdOnly << "\n"
        << "fetchRemoteID:" << obj.mFetchRemoteID << "\n"
        << "fetchAllAttributes:" << obj.mFetchAllAttributes << "\n"
    ;
    return dbg;
}

void TagFetchScope::toJson(QJsonObject &json) const
{
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAttributes)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("attributes")] = jsonArray;
    }
    json[QStringLiteral("fetchIdOnly")] = mFetchIdOnly;/* bool */
    json[QStringLiteral("fetchRemoteID")] = mFetchRemoteID;/* bool */
    json[QStringLiteral("fetchAllAttributes")] = mFetchAllAttributes;/* bool */
}



/************************* FetchLimit *************************/

FetchLimit::FetchLimit()
{
}

FetchLimit::FetchLimit(int limit, int limitOffset, const Qt::SortOrder &sortOrder)
    : mLimit(limit)
    , mLimitOffset(limitOffset)
    , mSortOrder(sortOrder)
{
}

bool FetchLimit::operator==(const FetchLimit &other) const
{
    return true // simplifies generation
        && mLimit == other.mLimit
        && mLimitOffset == other.mLimitOffset
        && mSortOrder == other.mSortOrder
    ;
}

DataStream &operator<<(DataStream &stream, const FetchLimit &obj)
{
    stream << obj.mLimit;
    stream << obj.mLimitOffset;
    stream << obj.mSortOrder;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchLimit &obj)
{
    stream >> obj.mLimit;
    stream >> obj.mLimitOffset;
    stream >> obj.mSortOrder;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchLimit &obj)
{
    dbg.noquote()
        << "limit:" << obj.mLimit << "\n"
        << "limitOffset:" << obj.mLimitOffset << "\n"
        << "sortOrder:" << obj.mSortOrder << "\n"
    ;
    return dbg;
}

void FetchLimit::toJson(QJsonObject &json) const
{
    json[QStringLiteral("limit")] = mLimit;/* int */
    json[QStringLiteral("limitOffset")] = mLimitOffset;/* int */
    json[QStringLiteral("sortOrder")] = mSortOrder;/* Qt::SortOrder*/
}



/************************* HelloResponse *************************/

HelloResponse::HelloResponse()
    : Response(Command::Hello)
{
}

bool HelloResponse::operator==(const HelloResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mServerName == other.mServerName
        && mMessage == other.mMessage
        && mProtocolVersion == other.mProtocolVersion
        && mGeneration == other.mGeneration
    ;
}

DataStream &operator<<(DataStream &stream, const HelloResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mServerName;
    stream << obj.mMessage;
    stream << obj.mProtocolVersion;
    stream << obj.mGeneration;
    return stream;
}

DataStream &operator>>(DataStream &stream, HelloResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mServerName;
    stream >> obj.mMessage;
    stream >> obj.mProtocolVersion;
    stream >> obj.mGeneration;
    return stream;
}

QDebug operator<<(QDebug dbg, const HelloResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "serverName:" << obj.mServerName << "\n"
        << "message:" << obj.mMessage << "\n"
        << "protocolVersion:" << obj.mProtocolVersion << "\n"
        << "generation:" << obj.mGeneration << "\n"
    ;
    return dbg;
}

void HelloResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("serverName")] = mServerName;/* QString*/
    json[QStringLiteral("message")] = mMessage;/* QString*/
    json[QStringLiteral("protocolVersion")] = mProtocolVersion;/* int */
    json[QStringLiteral("generation")] = static_cast<int>(mGeneration);/* uint */
}



/************************* LoginCommand *************************/

LoginCommand::LoginCommand()
    : Command(Command::Login)
{
}

LoginCommand::LoginCommand(const QByteArray &sessionId)
    : Command(Command::Login)
    , mSessionId(sessionId)
{
}

bool LoginCommand::operator==(const LoginCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mSessionId == other.mSessionId
    ;
}

DataStream &operator<<(DataStream &stream, const LoginCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mSessionId;
    return stream;
}

DataStream &operator>>(DataStream &stream, LoginCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mSessionId;
    return stream;
}

QDebug operator<<(QDebug dbg, const LoginCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "sessionId:" << obj.mSessionId << "\n"
    ;
    return dbg;
}

void LoginCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("sessionId")] = QString::fromUtf8(mSessionId)/* QByteArray */;
}



/************************* LoginResponse *************************/

LoginResponse::LoginResponse()
    : Response(Command::Login)
{
}

bool LoginResponse::operator==(const LoginResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LoginResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LoginResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LoginResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void LoginResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* LogoutCommand *************************/

LogoutCommand::LogoutCommand()
    : Command(Command::Logout)
{
}

bool LogoutCommand::operator==(const LogoutCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LogoutCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LogoutCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LogoutCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
    ;
    return dbg;
}

void LogoutCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
}



/************************* LogoutResponse *************************/

LogoutResponse::LogoutResponse()
    : Response(Command::Logout)
{
}

bool LogoutResponse::operator==(const LogoutResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LogoutResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LogoutResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LogoutResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void LogoutResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* TransactionCommand *************************/

TransactionCommand::TransactionCommand()
    : Command(Command::Transaction)
{
}

TransactionCommand::TransactionCommand(const TransactionCommand::Mode &mode)
    : Command(Command::Transaction)
    , mMode(mode)
{
}

bool TransactionCommand::operator==(const TransactionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mMode == other.mMode
    ;
}

DataStream &operator<<(DataStream &stream, const TransactionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mMode;
    return stream;
}

DataStream &operator>>(DataStream &stream, TransactionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mMode;
    return stream;
}

QDebug operator<<(QDebug dbg, const TransactionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "mode:" << obj.mMode << "\n"
    ;
    return dbg;
}

void TransactionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("mode")] = mMode;/* TransactionCommand::Mode*/
}



/************************* TransactionResponse *************************/

TransactionResponse::TransactionResponse()
    : Response(Command::Transaction)
{
}

bool TransactionResponse::operator==(const TransactionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const TransactionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, TransactionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const TransactionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void TransactionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* CreateItemCommand *************************/

CreateItemCommand::CreateItemCommand()
    : Command(Command::CreateItem)
{
}

bool CreateItemCommand::operator==(const CreateItemCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && containerComparator(mParts, other.mParts)
        && mAttributes == other.mAttributes
        && mRemovedTags == other.mRemovedTags
        && mAddedTags == other.mAddedTags
        && mTags == other.mTags
        && containerComparator(mRemovedFlags, other.mRemovedFlags)
        && containerComparator(mAddedFlags, other.mAddedFlags)
        && containerComparator(mFlags, other.mFlags)
        && mDateTime == other.mDateTime
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mGid == other.mGid
        && mMimeType == other.mMimeType
        && mItemSize == other.mItemSize
        && mMergeModes == other.mMergeModes
        && mFlagsOverwritten == other.mFlagsOverwritten
    ;
}

DataStream &operator<<(DataStream &stream, const CreateItemCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mFlags;
    stream << obj.mFlagsOverwritten;
    stream << obj.mMergeModes;
    stream << obj.mItemSize;
    stream << obj.mMimeType;
    stream << obj.mGid;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mDateTime;
    stream << obj.mCollection;
    stream << obj.mAddedFlags;
    stream << obj.mRemovedFlags;
    stream << obj.mTags;
    stream << obj.mAddedTags;
    stream << obj.mRemovedTags;
    stream << obj.mAttributes;
    stream << obj.mParts;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateItemCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mFlags;
    stream >> obj.mFlagsOverwritten;
    stream >> obj.mMergeModes;
    stream >> obj.mItemSize;
    stream >> obj.mMimeType;
    stream >> obj.mGid;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mDateTime;
    stream >> obj.mCollection;
    stream >> obj.mAddedFlags;
    stream >> obj.mRemovedFlags;
    stream >> obj.mTags;
    stream >> obj.mAddedTags;
    stream >> obj.mRemovedTags;
    stream >> obj.mAttributes;
    stream >> obj.mParts;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateItemCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "flags: [\n";
    for (const auto &type : std::as_const(obj.mFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "flagsOverwritten:" << obj.mFlagsOverwritten << "\n"
        << "mergeModes:" << obj.mMergeModes << "\n"
        << "itemSize:" << obj.mItemSize << "\n"
        << "mimeType:" << obj.mMimeType << "\n"
        << "gid:" << obj.mGid << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "dateTime:" << obj.mDateTime << "\n"
        << "collection:" << obj.mCollection << "\n"
        << "addedFlags: [\n";
    for (const auto &type : std::as_const(obj.mAddedFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "removedFlags: [\n";
    for (const auto &type : std::as_const(obj.mRemovedFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "tags:" << obj.mTags << "\n"
        << "addedTags:" << obj.mAddedTags << "\n"
        << "removedTags:" << obj.mRemovedTags << "\n"
        << "attributes:" << obj.mAttributes << "\n"
        << "parts: [\n";
    for (const auto &type : std::as_const(obj.mParts)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
    ;
    return dbg;
}

void CreateItemCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("flags")] = jsonArray;
    }
    json[QStringLiteral("flagsOverwritten")] = mFlagsOverwritten;/* bool */
    json[QStringLiteral("mergeModes")] = static_cast<int>(mMergeModes);/* CreateItemCommand::MergeModes*/
    json[QStringLiteral("itemSize")] = mItemSize;/* qint64 */
    json[QStringLiteral("mimeType")] = mMimeType;/* QString*/
    json[QStringLiteral("gid")] = mGid;/* QString*/
    json[QStringLiteral("remoteId")] = mRemoteId;/* QString*/
    json[QStringLiteral("remoteRevision")] = mRemoteRevision;/* QString*/
    json[QStringLiteral("dateTime")] = mDateTime.toString()/* QDateTime */;
    {
        QJsonObject jsonObject;
        mCollection.toJson(jsonObject); /* Scope */
        json[QStringLiteral("collection")] = jsonObject;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAddedFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("addedFlags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("removedFlags")] = jsonArray;
    }
    {
        QJsonObject jsonObject;
        mTags.toJson(jsonObject); /* Scope */
        json[QStringLiteral("tags")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mAddedTags.toJson(jsonObject); /* Scope */
        json[QStringLiteral("addedTags")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mRemovedTags.toJson(jsonObject); /* Scope */
        json[QStringLiteral("removedTags")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mParts)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("parts")] = jsonArray;
    }
}



/************************* CreateItemResponse *************************/

CreateItemResponse::CreateItemResponse()
    : Response(Command::CreateItem)
{
}

bool CreateItemResponse::operator==(const CreateItemResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateItemResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateItemResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateItemResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void CreateItemResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* CopyItemsCommand *************************/

CopyItemsCommand::CopyItemsCommand()
    : Command(Command::CopyItems)
{
}

CopyItemsCommand::CopyItemsCommand(const Scope &items, const Scope &destination)
    : Command(Command::CopyItems)
    , mItems(items)
    , mDestination(destination)
{
}

bool CopyItemsCommand::operator==(const CopyItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mDestination == other.mDestination
    ;
}

DataStream &operator<<(DataStream &stream, const CopyItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mDestination;
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mDestination;
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyItemsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "destination:" << obj.mDestination << "\n"
    ;
    return dbg;
}

void CopyItemsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mItems.toJson(jsonObject); /* Scope */
        json[QStringLiteral("items")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mDestination.toJson(jsonObject); /* Scope */
        json[QStringLiteral("destination")] = jsonObject;
    }
}



/************************* CopyItemsResponse *************************/

CopyItemsResponse::CopyItemsResponse()
    : Response(Command::CopyItems)
{
}

bool CopyItemsResponse::operator==(const CopyItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CopyItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyItemsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void CopyItemsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* DeleteItemsCommand *************************/

DeleteItemsCommand::DeleteItemsCommand()
    : Command(Command::DeleteItems)
{
}

DeleteItemsCommand::DeleteItemsCommand(const Scope &items, const Akonadi::Protocol::ScopeContext &scopeContext)
    : Command(Command::DeleteItems)
    , mItems(items)
    , mScopeContext(scopeContext)
{
}

bool DeleteItemsCommand::operator==(const DeleteItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mScopeContext == other.mScopeContext
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mScopeContext;
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mScopeContext;
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteItemsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "scopeContext:" << obj.mScopeContext << "\n"
    ;
    return dbg;
}

void DeleteItemsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mItems.toJson(jsonObject); /* Scope */
        json[QStringLiteral("items")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mScopeContext.toJson(jsonObject); /* Akonadi::Protocol::ScopeContext */
         json[QStringLiteral("scopeContext")] = jsonObject;
    }
}



/************************* DeleteItemsResponse *************************/

DeleteItemsResponse::DeleteItemsResponse()
    : Response(Command::DeleteItems)
{
}

bool DeleteItemsResponse::operator==(const DeleteItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteItemsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void DeleteItemsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* FetchRelationsCommand *************************/

FetchRelationsCommand::FetchRelationsCommand()
    : Command(Command::FetchRelations)
{
}

FetchRelationsCommand::FetchRelationsCommand(qint64 left, qint64 right, const QVector<QByteArray> &types, const QString &resource)
    : Command(Command::FetchRelations)
    , mLeft(left)
    , mRight(right)
    , mTypes(types)
    , mResource(resource)
{
}

FetchRelationsCommand::FetchRelationsCommand(qint64 side, const QVector<QByteArray> &types, const QString &resource)
    : Command(Command::FetchRelations)
    , mSide(side)
    , mTypes(types)
    , mResource(resource)
{
}

bool FetchRelationsCommand::operator==(const FetchRelationsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mLeft == other.mLeft
        && mRight == other.mRight
        && mSide == other.mSide
        && containerComparator(mTypes, other.mTypes)
        && mResource == other.mResource
    ;
}

DataStream &operator<<(DataStream &stream, const FetchRelationsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mLeft;
    stream << obj.mRight;
    stream << obj.mSide;
    stream << obj.mTypes;
    stream << obj.mResource;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchRelationsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mRight;
    stream >> obj.mSide;
    stream >> obj.mTypes;
    stream >> obj.mResource;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchRelationsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "right:" << obj.mRight << "\n"
        << "side:" << obj.mSide << "\n"
        << "types: [\n";
    for (const auto &type : std::as_const(obj.mTypes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "resource:" << obj.mResource << "\n"
    ;
    return dbg;
}

void FetchRelationsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("left")] = mLeft;/* qint64 */
    json[QStringLiteral("right")] = mRight;/* qint64 */
    json[QStringLiteral("side")] = mSide;/* qint64 */
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mTypes)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("types")] = jsonArray;
    }
    json[QStringLiteral("resource")] = mResource;/* QString*/
}



/************************* FetchRelationsResponse *************************/

FetchRelationsResponse::FetchRelationsResponse()
    : Response(Command::FetchRelations)
{
}

FetchRelationsResponse::FetchRelationsResponse(qint64 left, const QByteArray &leftMimeType, qint64 right, const QByteArray &rightMimeType, const QByteArray &type, const QByteArray &remoteId)
    : Response(Command::FetchRelations)
    , mLeft(left)
    , mLeftMimeType(leftMimeType)
    , mRight(right)
    , mRightMimeType(rightMimeType)
    , mType(type)
    , mRemoteId(remoteId)
{
}

bool FetchRelationsResponse::operator==(const FetchRelationsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mLeft == other.mLeft
        && mLeftMimeType == other.mLeftMimeType
        && mRight == other.mRight
        && mRightMimeType == other.mRightMimeType
        && mType == other.mType
        && mRemoteId == other.mRemoteId
    ;
}

DataStream &operator<<(DataStream &stream, const FetchRelationsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mLeft;
    stream << obj.mLeftMimeType;
    stream << obj.mRight;
    stream << obj.mRightMimeType;
    stream << obj.mType;
    stream << obj.mRemoteId;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchRelationsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mLeftMimeType;
    stream >> obj.mRight;
    stream >> obj.mRightMimeType;
    stream >> obj.mType;
    stream >> obj.mRemoteId;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchRelationsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "leftMimeType:" << obj.mLeftMimeType << "\n"
        << "right:" << obj.mRight << "\n"
        << "rightMimeType:" << obj.mRightMimeType << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
    ;
    return dbg;
}

void FetchRelationsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("left")] = mLeft;/* qint64 */
    json[QStringLiteral("leftMimeType")] = QString::fromUtf8(mLeftMimeType)/* QByteArray */;
    json[QStringLiteral("right")] = mRight;/* qint64 */
    json[QStringLiteral("rightMimeType")] = QString::fromUtf8(mRightMimeType)/* QByteArray */;
    json[QStringLiteral("type")] = QString::fromUtf8(mType)/* QByteArray */;
    json[QStringLiteral("remoteId")] = QString::fromUtf8(mRemoteId)/* QByteArray */;
}



/************************* FetchTagsCommand *************************/

FetchTagsCommand::FetchTagsCommand()
    : Command(Command::FetchTags)
{
}

FetchTagsCommand::FetchTagsCommand(const Scope &scope)
    : Command(Command::FetchTags)
    , mScope(scope)
{
}

bool FetchTagsCommand::operator==(const FetchTagsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mScope == other.mScope
        && mFetchScope == other.mFetchScope
    ;
}

DataStream &operator<<(DataStream &stream, const FetchTagsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mScope;
    stream << obj.mFetchScope;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchTagsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mScope;
    stream >> obj.mFetchScope;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchTagsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "scope:" << obj.mScope << "\n"
        << "fetchScope:" << obj.mFetchScope << "\n"
    ;
    return dbg;
}

void FetchTagsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mScope.toJson(jsonObject); /* Scope */
        json[QStringLiteral("scope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mFetchScope.toJson(jsonObject); /* Akonadi::Protocol::TagFetchScope */
         json[QStringLiteral("fetchScope")] = jsonObject;
    }
}



/************************* FetchTagsResponse *************************/

FetchTagsResponse::FetchTagsResponse()
    : Response(Command::FetchTags)
{
}

FetchTagsResponse::FetchTagsResponse(qint64 id)
    : Response(Command::FetchTags)
    , mId(id)
{
}

FetchTagsResponse::FetchTagsResponse(qint64 id, const QByteArray &gid, const QByteArray &type, const QByteArray &remoteId, qint64 parentId, const Akonadi::Protocol::Attributes &attributes)
    : Response(Command::FetchTags)
    , mId(id)
    , mParentId(parentId)
    , mGid(gid)
    , mType(type)
    , mRemoteId(remoteId)
    , mAttributes(attributes)
{
}

bool FetchTagsResponse::operator==(const FetchTagsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mId == other.mId
        && mParentId == other.mParentId
        && mGid == other.mGid
        && mType == other.mType
        && mRemoteId == other.mRemoteId
        && mAttributes == other.mAttributes
    ;
}

DataStream &operator<<(DataStream &stream, const FetchTagsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mId;
    stream << obj.mParentId;
    stream << obj.mGid;
    stream << obj.mType;
    stream << obj.mRemoteId;
    stream << obj.mAttributes;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchTagsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mId;
    stream >> obj.mParentId;
    stream >> obj.mGid;
    stream >> obj.mType;
    stream >> obj.mRemoteId;
    stream >> obj.mAttributes;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchTagsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "id:" << obj.mId << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "gid:" << obj.mGid << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
    return dbg;
}

void FetchTagsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("id")] = mId;/* qint64 */
    json[QStringLiteral("parentId")] = mParentId;/* qint64 */
    json[QStringLiteral("gid")] = QString::fromUtf8(mGid)/* QByteArray */;
    json[QStringLiteral("type")] = QString::fromUtf8(mType)/* QByteArray */;
    json[QStringLiteral("remoteId")] = QString::fromUtf8(mRemoteId)/* QByteArray */;
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
}



/************************* FetchItemsCommand *************************/

FetchItemsCommand::FetchItemsCommand()
    : Command(Command::FetchItems)
{
}

FetchItemsCommand::FetchItemsCommand(const Scope &scope, const Akonadi::Protocol::ScopeContext &scopeContext, const Akonadi::Protocol::ItemFetchScope &itemFetchScope, const Akonadi::Protocol::TagFetchScope &tagFetchScope, const Akonadi::Protocol::FetchLimit &itemsLimit)
    : Command(Command::FetchItems)
    , mScope(scope)
    , mScopeContext(scopeContext)
    , mItemFetchScope(itemFetchScope)
    , mTagFetchScope(tagFetchScope)
    , mItemsLimit(itemsLimit)
{
}

bool FetchItemsCommand::operator==(const FetchItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mScope == other.mScope
        && mScopeContext == other.mScopeContext
        && mItemFetchScope == other.mItemFetchScope
        && mTagFetchScope == other.mTagFetchScope
        && mItemsLimit == other.mItemsLimit
    ;
}

DataStream &operator<<(DataStream &stream, const FetchItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mScope;
    stream << obj.mScopeContext;
    stream << obj.mItemFetchScope;
    stream << obj.mTagFetchScope;
    stream << obj.mItemsLimit;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mScope;
    stream >> obj.mScopeContext;
    stream >> obj.mItemFetchScope;
    stream >> obj.mTagFetchScope;
    stream >> obj.mItemsLimit;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchItemsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "scope:" << obj.mScope << "\n"
        << "scopeContext:" << obj.mScopeContext << "\n"
        << "itemFetchScope:" << obj.mItemFetchScope << "\n"
        << "tagFetchScope:" << obj.mTagFetchScope << "\n"
        << "itemsLimit:" << obj.mItemsLimit << "\n"
    ;
    return dbg;
}

void FetchItemsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mScope.toJson(jsonObject); /* Scope */
        json[QStringLiteral("scope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mScopeContext.toJson(jsonObject); /* Akonadi::Protocol::ScopeContext */
         json[QStringLiteral("scopeContext")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mItemFetchScope.toJson(jsonObject); /* Akonadi::Protocol::ItemFetchScope */
         json[QStringLiteral("itemFetchScope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mTagFetchScope.toJson(jsonObject); /* Akonadi::Protocol::TagFetchScope */
         json[QStringLiteral("tagFetchScope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mItemsLimit.toJson(jsonObject); /* Akonadi::Protocol::FetchLimit */
         json[QStringLiteral("itemsLimit")] = jsonObject;
    }
}



/************************* FetchItemsResponse *************************/

FetchItemsResponse::FetchItemsResponse()
    : Response(Command::FetchItems)
{
}

FetchItemsResponse::FetchItemsResponse(qint64 id)
    : Response(Command::FetchItems)
    , mId(id)
{
}

bool FetchItemsResponse::operator==(const FetchItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mId == other.mId
        && mParentId == other.mParentId
        && mRemoteId == other.mRemoteId
        && mRemoteRevision == other.mRemoteRevision
        && mGid == other.mGid
        && mSize == other.mSize
        && mMimeType == other.mMimeType
        && mMTime == other.mMTime
        && containerComparator(mFlags, other.mFlags)
        && containerComparator(mTags, other.mTags)
        && containerComparator(mVirtualReferences, other.mVirtualReferences)
        && containerComparator(mRelations, other.mRelations)
        && containerComparator(mAncestors, other.mAncestors)
        && containerComparator(mParts, other.mParts)
        && containerComparator(mCachedParts, other.mCachedParts)
        && mRevision == other.mRevision
    ;
}

DataStream &operator<<(DataStream &stream, const FetchItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mId;
    stream << obj.mParentId;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mGid;
    stream << obj.mSize;
    stream << obj.mMimeType;
    stream << obj.mMTime;
    stream << obj.mFlags;
    stream << obj.mTags;
    stream << obj.mVirtualReferences;
    stream << obj.mRelations;
    stream << obj.mAncestors;
    stream << obj.mParts;
    stream << obj.mCachedParts;
    stream << obj.mRevision;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mId;
    stream >> obj.mParentId;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mGid;
    stream >> obj.mSize;
    stream >> obj.mMimeType;
    stream >> obj.mMTime;
    stream >> obj.mFlags;
    stream >> obj.mTags;
    stream >> obj.mVirtualReferences;
    stream >> obj.mRelations;
    stream >> obj.mAncestors;
    stream >> obj.mParts;
    stream >> obj.mCachedParts;
    stream >> obj.mRevision;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchItemsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "id:" << obj.mId << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "gid:" << obj.mGid << "\n"
        << "size:" << obj.mSize << "\n"
        << "mimeType:" << obj.mMimeType << "\n"
        << "mTime:" << obj.mMTime << "\n"
        << "flags: [\n";
    for (const auto &type : std::as_const(obj.mFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "tags: [\n";
    for (const auto &type : std::as_const(obj.mTags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "virtualReferences: [\n";
    for (const auto &type : std::as_const(obj.mVirtualReferences)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "relations: [\n";
    for (const auto &type : std::as_const(obj.mRelations)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "ancestors: [\n";
    for (const auto &type : std::as_const(obj.mAncestors)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "parts: [\n";
    for (const auto &type : std::as_const(obj.mParts)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "cachedParts: [\n";
    for (const auto &type : std::as_const(obj.mCachedParts)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "revision:" << obj.mRevision << "\n"
    ;
    return dbg;
}

void FetchItemsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("id")] = mId;/* qint64 */
    json[QStringLiteral("parentId")] = mParentId;/* qint64 */
    json[QStringLiteral("remoteId")] = mRemoteId;/* QString*/
    json[QStringLiteral("remoteRevision")] = mRemoteRevision;/* QString*/
    json[QStringLiteral("gid")] = mGid;/* QString*/
    json[QStringLiteral("size")] = mSize;/* qint64 */
    json[QStringLiteral("mimeType")] = mMimeType;/* QString*/
    json[QStringLiteral("mTime")] = mMTime.toString()/* QDateTime */;
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("flags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mTags)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::FetchTagsResponse */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("tags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mVirtualReferences)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("virtualReferences")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRelations)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::FetchRelationsResponse */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("relations")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAncestors)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::Ancestor */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("ancestors")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mParts)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::StreamPayloadResponse */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("parts")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mCachedParts)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("cachedParts")] = jsonArray;
    }
    json[QStringLiteral("revision")] = mRevision;/* int */
}



/************************* LinkItemsCommand *************************/

LinkItemsCommand::LinkItemsCommand()
    : Command(Command::LinkItems)
{
}

LinkItemsCommand::LinkItemsCommand(const LinkItemsCommand::Action &action, const Scope &items, const Scope &destination)
    : Command(Command::LinkItems)
    , mItems(items)
    , mDestination(destination)
    , mAction(action)
{
}

bool LinkItemsCommand::operator==(const LinkItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mDestination == other.mDestination
        && mAction == other.mAction
    ;
}

DataStream &operator<<(DataStream &stream, const LinkItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mDestination;
    stream << obj.mAction;
    return stream;
}

DataStream &operator>>(DataStream &stream, LinkItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mDestination;
    stream >> obj.mAction;
    return stream;
}

QDebug operator<<(QDebug dbg, const LinkItemsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "destination:" << obj.mDestination << "\n"
        << "action:" << obj.mAction << "\n"
    ;
    return dbg;
}

void LinkItemsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mItems.toJson(jsonObject); /* Scope */
        json[QStringLiteral("items")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mDestination.toJson(jsonObject); /* Scope */
        json[QStringLiteral("destination")] = jsonObject;
    }
    json[QStringLiteral("action")] = mAction;/* LinkItemsCommand::Action*/
}



/************************* LinkItemsResponse *************************/

LinkItemsResponse::LinkItemsResponse()
    : Response(Command::LinkItems)
{
}

bool LinkItemsResponse::operator==(const LinkItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const LinkItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, LinkItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const LinkItemsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void LinkItemsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* ModifyItemsCommand *************************/

ModifyItemsCommand::ModifyItemsCommand()
    : Command(Command::ModifyItems)
{
}

ModifyItemsCommand::ModifyItemsCommand(const Scope &items)
    : Command(Command::ModifyItems)
    , mItems(items)
{
}

bool ModifyItemsCommand::operator==(const ModifyItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mGid == other.mGid
        && mAttributes == other.mAttributes
        && containerComparator(mParts, other.mParts)
        && containerComparator(mRemovedParts, other.mRemovedParts)
        && mItemSize == other.mItemSize
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mRemovedTags == other.mRemovedTags
        && mAddedTags == other.mAddedTags
        && mTags == other.mTags
        && containerComparator(mRemovedFlags, other.mRemovedFlags)
        && containerComparator(mAddedFlags, other.mAddedFlags)
        && containerComparator(mFlags, other.mFlags)
        && mItems == other.mItems
        && mModifiedParts == other.mModifiedParts
        && mOldRevision == other.mOldRevision
        && mDirty == other.mDirty
        && mInvalidateCache == other.mInvalidateCache
        && mNoResponse == other.mNoResponse
        && mNotify == other.mNotify
    ;
}

void ModifyItemsCommand::setGid(const QString &val)
{
    mGid = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::GID);
}

void ModifyItemsCommand::setAttributes(const Akonadi::Protocol::Attributes &val)
{
    mAttributes = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Attributes);
}

void ModifyItemsCommand::setParts(const QSet<QByteArray> &val)
{
    mParts = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Parts);
}

void ModifyItemsCommand::setRemovedParts(const QSet<QByteArray> &val)
{
    mRemovedParts = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemovedParts);
}

void ModifyItemsCommand::setItemSize(qint64 val)
{
    mItemSize = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Size);
}

void ModifyItemsCommand::setRemoteRevision(const QString &val)
{
    mRemoteRevision = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemoteRevision);
}

void ModifyItemsCommand::setRemoteId(const QString &val)
{
    mRemoteId = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemoteID);
}

void ModifyItemsCommand::setRemovedTags(const Scope &val)
{
    mRemovedTags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemovedTags);
}

void ModifyItemsCommand::setAddedTags(const Scope &val)
{
    mAddedTags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::AddedTags);
}

void ModifyItemsCommand::setTags(const Scope &val)
{
    mTags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Tags);
}

void ModifyItemsCommand::setRemovedFlags(const QSet<QByteArray> &val)
{
    mRemovedFlags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::RemovedFlags);
}

void ModifyItemsCommand::setAddedFlags(const QSet<QByteArray> &val)
{
    mAddedFlags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::AddedFlags);
}

void ModifyItemsCommand::setFlags(const QSet<QByteArray> &val)
{
    mFlags = val;
    mModifiedParts |= ModifyItemsCommand::ModifiedParts(ModifyItemsCommand::Flags);
}

DataStream &operator<<(DataStream &stream, const ModifyItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mNotify;
    stream << obj.mNoResponse;
    stream << obj.mInvalidateCache;
    stream << obj.mDirty;
    stream << obj.mOldRevision;
    stream << obj.mModifiedParts;
    stream << obj.mItems;
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedFlags)) {
        stream << obj.mRemovedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Flags)) {
        stream << obj.mFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedFlags)) {
        stream << obj.mAddedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::GID)) {
        stream << obj.mGid;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Tags)) {
        stream << obj.mTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedTags)) {
        stream << obj.mAddedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedTags)) {
        stream << obj.mRemovedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteID)) {
        stream << obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteRevision)) {
        stream << obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Size)) {
        stream << obj.mItemSize;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedParts)) {
        stream << obj.mRemovedParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Parts)) {
        stream << obj.mParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Attributes)) {
        stream << obj.mAttributes;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mNotify;
    stream >> obj.mNoResponse;
    stream >> obj.mInvalidateCache;
    stream >> obj.mDirty;
    stream >> obj.mOldRevision;
    stream >> obj.mModifiedParts;
    stream >> obj.mItems;
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedFlags)) {
        stream >> obj.mRemovedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Flags)) {
        stream >> obj.mFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedFlags)) {
        stream >> obj.mAddedFlags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::GID)) {
        stream >> obj.mGid;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Tags)) {
        stream >> obj.mTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::AddedTags)) {
        stream >> obj.mAddedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedTags)) {
        stream >> obj.mRemovedTags;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteID)) {
        stream >> obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemoteRevision)) {
        stream >> obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Size)) {
        stream >> obj.mItemSize;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::RemovedParts)) {
        stream >> obj.mRemovedParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Parts)) {
        stream >> obj.mParts;
    }
    if ((obj.mModifiedParts & ModifyItemsCommand::Attributes)) {
        stream >> obj.mAttributes;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyItemsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "notify:" << obj.mNotify << "\n"
        << "noResponse:" << obj.mNoResponse << "\n"
        << "invalidateCache:" << obj.mInvalidateCache << "\n"
        << "dirty:" << obj.mDirty << "\n"
        << "oldRevision:" << obj.mOldRevision << "\n"
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "items:" << obj.mItems << "\n"
        << "removedFlags: [\n";
    for (const auto &type : std::as_const(obj.mRemovedFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "flags: [\n";
    for (const auto &type : std::as_const(obj.mFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "addedFlags: [\n";
    for (const auto &type : std::as_const(obj.mAddedFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "gid:" << obj.mGid << "\n"
        << "tags:" << obj.mTags << "\n"
        << "addedTags:" << obj.mAddedTags << "\n"
        << "removedTags:" << obj.mRemovedTags << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "itemSize:" << obj.mItemSize << "\n"
        << "removedParts: [\n";
    for (const auto &type : std::as_const(obj.mRemovedParts)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "parts: [\n";
    for (const auto &type : std::as_const(obj.mParts)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
    return dbg;
}

void ModifyItemsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("notify")] = mNotify;/* bool */
    json[QStringLiteral("noResponse")] = mNoResponse;/* bool */
    json[QStringLiteral("invalidateCache")] = mInvalidateCache;/* bool */
    json[QStringLiteral("dirty")] = mDirty;/* bool */
    json[QStringLiteral("oldRevision")] = mOldRevision;/* int */
    json[QStringLiteral("modifiedParts")] = static_cast<int>(mModifiedParts);/* ModifyItemsCommand::ModifiedParts*/
    {
        QJsonObject jsonObject;
        mItems.toJson(jsonObject); /* Scope */
        json[QStringLiteral("items")] = jsonObject;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("removedFlags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("flags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAddedFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("addedFlags")] = jsonArray;
    }
    json[QStringLiteral("gid")] = mGid;/* QString*/
    {
        QJsonObject jsonObject;
        mTags.toJson(jsonObject); /* Scope */
        json[QStringLiteral("tags")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mAddedTags.toJson(jsonObject); /* Scope */
        json[QStringLiteral("addedTags")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mRemovedTags.toJson(jsonObject); /* Scope */
        json[QStringLiteral("removedTags")] = jsonObject;
    }
    json[QStringLiteral("remoteId")] = mRemoteId;/* QString*/
    json[QStringLiteral("remoteRevision")] = mRemoteRevision;/* QString*/
    json[QStringLiteral("itemSize")] = mItemSize;/* qint64 */
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedParts)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("removedParts")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mParts)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("parts")] = jsonArray;
    }
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
}



/************************* ModifyItemsResponse *************************/

ModifyItemsResponse::ModifyItemsResponse()
    : Response(Command::ModifyItems)
{
}

ModifyItemsResponse::ModifyItemsResponse(qint64 id, int newRevision)
    : Response(Command::ModifyItems)
    , mId(id)
    , mNewRevision(newRevision)
{
}

bool ModifyItemsResponse::operator==(const ModifyItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mId == other.mId
        && mModificationDateTime == other.mModificationDateTime
        && mNewRevision == other.mNewRevision
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mId;
    stream << obj.mModificationDateTime;
    stream << obj.mNewRevision;
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mId;
    stream >> obj.mModificationDateTime;
    stream >> obj.mNewRevision;
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyItemsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "id:" << obj.mId << "\n"
        << "modificationDateTime:" << obj.mModificationDateTime << "\n"
        << "newRevision:" << obj.mNewRevision << "\n"
    ;
    return dbg;
}

void ModifyItemsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("id")] = mId;/* qint64 */
    json[QStringLiteral("modificationDateTime")] = mModificationDateTime.toString()/* QDateTime */;
    json[QStringLiteral("newRevision")] = mNewRevision;/* int */
}



/************************* MoveItemsCommand *************************/

MoveItemsCommand::MoveItemsCommand()
    : Command(Command::MoveItems)
{
}

MoveItemsCommand::MoveItemsCommand(const Scope &items, const Scope &destination)
    : Command(Command::MoveItems)
    , mItems(items)
    , mDestination(destination)
{
}

MoveItemsCommand::MoveItemsCommand(const Scope &items, const Akonadi::Protocol::ScopeContext &itemsContext, const Scope &destination)
    : Command(Command::MoveItems)
    , mItems(items)
    , mDestination(destination)
    , mItemsContext(itemsContext)
{
}

bool MoveItemsCommand::operator==(const MoveItemsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mItems == other.mItems
        && mDestination == other.mDestination
        && mItemsContext == other.mItemsContext
    ;
}

DataStream &operator<<(DataStream &stream, const MoveItemsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mItems;
    stream << obj.mDestination;
    stream << obj.mItemsContext;
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveItemsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mItems;
    stream >> obj.mDestination;
    stream >> obj.mItemsContext;
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveItemsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "items:" << obj.mItems << "\n"
        << "destination:" << obj.mDestination << "\n"
        << "itemsContext:" << obj.mItemsContext << "\n"
    ;
    return dbg;
}

void MoveItemsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mItems.toJson(jsonObject); /* Scope */
        json[QStringLiteral("items")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mDestination.toJson(jsonObject); /* Scope */
        json[QStringLiteral("destination")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mItemsContext.toJson(jsonObject); /* Akonadi::Protocol::ScopeContext */
         json[QStringLiteral("itemsContext")] = jsonObject;
    }
}



/************************* MoveItemsResponse *************************/

MoveItemsResponse::MoveItemsResponse()
    : Response(Command::MoveItems)
{
}

bool MoveItemsResponse::operator==(const MoveItemsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const MoveItemsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveItemsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveItemsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void MoveItemsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* CreateCollectionCommand *************************/

CreateCollectionCommand::CreateCollectionCommand()
    : Command(Command::CreateCollection)
{
}

bool CreateCollectionCommand::operator==(const CreateCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mParent == other.mParent
        && mName == other.mName
        && mRemoteId == other.mRemoteId
        && mRemoteRevision == other.mRemoteRevision
        && mMimeTypes == other.mMimeTypes
        && mAttributes == other.mAttributes
        && mCachePolicy == other.mCachePolicy
        && mIsVirtual == other.mIsVirtual
        && mEnabled == other.mEnabled
        && mSyncPref == other.mSyncPref
        && mDisplayPref == other.mDisplayPref
        && mIndexPref == other.mIndexPref
    ;
}

DataStream &operator<<(DataStream &stream, const CreateCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mParent;
    stream << obj.mName;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mMimeTypes;
    stream << obj.mAttributes;
    stream << obj.mCachePolicy;
    stream << obj.mIsVirtual;
    stream << obj.mEnabled;
    stream << obj.mSyncPref;
    stream << obj.mDisplayPref;
    stream << obj.mIndexPref;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mParent;
    stream >> obj.mName;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mMimeTypes;
    stream >> obj.mAttributes;
    stream >> obj.mCachePolicy;
    stream >> obj.mIsVirtual;
    stream >> obj.mEnabled;
    stream >> obj.mSyncPref;
    stream >> obj.mDisplayPref;
    stream >> obj.mIndexPref;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateCollectionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "parent:" << obj.mParent << "\n"
        << "name:" << obj.mName << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "attributes:" << obj.mAttributes << "\n"
        << "cachePolicy:" << obj.mCachePolicy << "\n"
        << "isVirtual:" << obj.mIsVirtual << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
    ;
    return dbg;
}

void CreateCollectionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mParent.toJson(jsonObject); /* Scope */
        json[QStringLiteral("parent")] = jsonObject;
    }
    json[QStringLiteral("name")] = mName;/* QString*/
    json[QStringLiteral("remoteId")] = mRemoteId;/* QString*/
    json[QStringLiteral("remoteRevision")] = mRemoteRevision;/* QString*/
    json[QStringLiteral("mimeTypes")] = QJsonArray::fromStringList(mMimeTypes);/* QStringList */
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mCachePolicy.toJson(jsonObject); /* Akonadi::Protocol::CachePolicy */
         json[QStringLiteral("cachePolicy")] = jsonObject;
    }
    json[QStringLiteral("isVirtual")] = mIsVirtual;/* bool */
    json[QStringLiteral("enabled")] = mEnabled;/* bool */
    switch (mSyncPref) {
;    case Tristate::True:
        json[QStringLiteral("syncPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("syncPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("syncPref")] = QStringLiteral("Undefined");
        break;
    }
    switch (mDisplayPref) {
;    case Tristate::True:
        json[QStringLiteral("displayPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("displayPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("displayPref")] = QStringLiteral("Undefined");
        break;
    }
    switch (mIndexPref) {
;    case Tristate::True:
        json[QStringLiteral("indexPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("indexPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("indexPref")] = QStringLiteral("Undefined");
        break;
    }
}



/************************* CreateCollectionResponse *************************/

CreateCollectionResponse::CreateCollectionResponse()
    : Response(Command::CreateCollection)
{
}

bool CreateCollectionResponse::operator==(const CreateCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateCollectionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void CreateCollectionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* CopyCollectionCommand *************************/

CopyCollectionCommand::CopyCollectionCommand()
    : Command(Command::CopyCollection)
{
}

CopyCollectionCommand::CopyCollectionCommand(const Scope &collection, const Scope &destination)
    : Command(Command::CopyCollection)
    , mCollection(collection)
    , mDestination(destination)
{
}

bool CopyCollectionCommand::operator==(const CopyCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && mDestination == other.mDestination
    ;
}

DataStream &operator<<(DataStream &stream, const CopyCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    stream << obj.mDestination;
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    stream >> obj.mDestination;
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyCollectionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
        << "destination:" << obj.mDestination << "\n"
    ;
    return dbg;
}

void CopyCollectionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mCollection.toJson(jsonObject); /* Scope */
        json[QStringLiteral("collection")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mDestination.toJson(jsonObject); /* Scope */
        json[QStringLiteral("destination")] = jsonObject;
    }
}



/************************* CopyCollectionResponse *************************/

CopyCollectionResponse::CopyCollectionResponse()
    : Response(Command::CopyCollection)
{
}

bool CopyCollectionResponse::operator==(const CopyCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CopyCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CopyCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CopyCollectionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void CopyCollectionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* DeleteCollectionCommand *************************/

DeleteCollectionCommand::DeleteCollectionCommand()
    : Command(Command::DeleteCollection)
{
}

DeleteCollectionCommand::DeleteCollectionCommand(const Scope &collection)
    : Command(Command::DeleteCollection)
    , mCollection(collection)
{
}

bool DeleteCollectionCommand::operator==(const DeleteCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteCollectionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
    ;
    return dbg;
}

void DeleteCollectionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mCollection.toJson(jsonObject); /* Scope */
        json[QStringLiteral("collection")] = jsonObject;
    }
}



/************************* DeleteCollectionResponse *************************/

DeleteCollectionResponse::DeleteCollectionResponse()
    : Response(Command::DeleteCollection)
{
}

bool DeleteCollectionResponse::operator==(const DeleteCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteCollectionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void DeleteCollectionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* FetchCollectionStatsCommand *************************/

FetchCollectionStatsCommand::FetchCollectionStatsCommand()
    : Command(Command::FetchCollectionStats)
{
}

FetchCollectionStatsCommand::FetchCollectionStatsCommand(const Scope &collection)
    : Command(Command::FetchCollectionStats)
    , mCollection(collection)
{
}

bool FetchCollectionStatsCommand::operator==(const FetchCollectionStatsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionStatsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionStatsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionStatsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
    ;
    return dbg;
}

void FetchCollectionStatsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mCollection.toJson(jsonObject); /* Scope */
        json[QStringLiteral("collection")] = jsonObject;
    }
}



/************************* FetchCollectionStatsResponse *************************/

FetchCollectionStatsResponse::FetchCollectionStatsResponse()
    : Response(Command::FetchCollectionStats)
{
}

FetchCollectionStatsResponse::FetchCollectionStatsResponse(qint64 count, qint64 unseen, qint64 size)
    : Response(Command::FetchCollectionStats)
    , mCount(count)
    , mUnseen(unseen)
    , mSize(size)
{
}

bool FetchCollectionStatsResponse::operator==(const FetchCollectionStatsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mCount == other.mCount
        && mUnseen == other.mUnseen
        && mSize == other.mSize
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionStatsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mCount;
    stream << obj.mUnseen;
    stream << obj.mSize;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionStatsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mCount;
    stream >> obj.mUnseen;
    stream >> obj.mSize;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionStatsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "count:" << obj.mCount << "\n"
        << "unseen:" << obj.mUnseen << "\n"
        << "size:" << obj.mSize << "\n"
    ;
    return dbg;
}

void FetchCollectionStatsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("count")] = mCount;/* qint64 */
    json[QStringLiteral("unseen")] = mUnseen;/* qint64 */
    json[QStringLiteral("size")] = mSize;/* qint64 */
}



/************************* FetchCollectionsCommand *************************/

FetchCollectionsCommand::FetchCollectionsCommand()
    : Command(Command::FetchCollections)
{
}

FetchCollectionsCommand::FetchCollectionsCommand(const Scope &collections)
    : Command(Command::FetchCollections)
    , mCollections(collections)
{
}

bool FetchCollectionsCommand::operator==(const FetchCollectionsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollections == other.mCollections
        && mResource == other.mResource
        && mMimeTypes == other.mMimeTypes
        && containerComparator(mAncestorsAttributes, other.mAncestorsAttributes)
        && mDepth == other.mDepth
        && mAncestorsDepth == other.mAncestorsDepth
        && mEnabled == other.mEnabled
        && mSyncPref == other.mSyncPref
        && mDisplayPref == other.mDisplayPref
        && mIndexPref == other.mIndexPref
        && mFetchStats == other.mFetchStats
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollections;
    stream << obj.mResource;
    stream << obj.mMimeTypes;
    stream << obj.mAncestorsAttributes;
    stream << obj.mDepth;
    stream << obj.mAncestorsDepth;
    stream << obj.mEnabled;
    stream << obj.mSyncPref;
    stream << obj.mDisplayPref;
    stream << obj.mIndexPref;
    stream << obj.mFetchStats;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollections;
    stream >> obj.mResource;
    stream >> obj.mMimeTypes;
    stream >> obj.mAncestorsAttributes;
    stream >> obj.mDepth;
    stream >> obj.mAncestorsDepth;
    stream >> obj.mEnabled;
    stream >> obj.mSyncPref;
    stream >> obj.mDisplayPref;
    stream >> obj.mIndexPref;
    stream >> obj.mFetchStats;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "collections:" << obj.mCollections << "\n"
        << "resource:" << obj.mResource << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "ancestorsAttributes: [\n";
    for (const auto &type : std::as_const(obj.mAncestorsAttributes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "depth:" << obj.mDepth << "\n"
        << "ancestorsDepth:" << obj.mAncestorsDepth << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
        << "fetchStats:" << obj.mFetchStats << "\n"
    ;
    return dbg;
}

void FetchCollectionsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mCollections.toJson(jsonObject); /* Scope */
        json[QStringLiteral("collections")] = jsonObject;
    }
    json[QStringLiteral("resource")] = mResource;/* QString*/
    json[QStringLiteral("mimeTypes")] = QJsonArray::fromStringList(mMimeTypes);/* QStringList */
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAncestorsAttributes)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("ancestorsAttributes")] = jsonArray;
    }
    json[QStringLiteral("depth")] = mDepth;/* FetchCollectionsCommand::Depth*/
    json[QStringLiteral("ancestorsDepth")] = mAncestorsDepth;/* Akonadi::Protocol::Ancestor::Depth*/
    json[QStringLiteral("enabled")] = mEnabled;/* bool */
    json[QStringLiteral("syncPref")] = mSyncPref;/* bool */
    json[QStringLiteral("displayPref")] = mDisplayPref;/* bool */
    json[QStringLiteral("indexPref")] = mIndexPref;/* bool */
    json[QStringLiteral("fetchStats")] = mFetchStats;/* bool */
}



/************************* FetchCollectionsResponse *************************/

FetchCollectionsResponse::FetchCollectionsResponse()
    : Response(Command::FetchCollections)
{
}

FetchCollectionsResponse::FetchCollectionsResponse(qint64 id)
    : Response(Command::FetchCollections)
    , mId(id)
{
}

bool FetchCollectionsResponse::operator==(const FetchCollectionsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mParentId == other.mParentId
        && mAttributes == other.mAttributes
        && containerComparator(mAncestors, other.mAncestors)
        && containerComparator(mSearchCollections, other.mSearchCollections)
        && mSearchQuery == other.mSearchQuery
        && mResource == other.mResource
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mMimeTypes == other.mMimeTypes
        && mName == other.mName
        && mId == other.mId
        && mStatistics == other.mStatistics
        && mCachePolicy == other.mCachePolicy
        && mEnabled == other.mEnabled
        && mDisplayPref == other.mDisplayPref
        && mSyncPref == other.mSyncPref
        && mIndexPref == other.mIndexPref
        && mIsVirtual == other.mIsVirtual
    ;
}

DataStream &operator<<(DataStream &stream, const FetchCollectionsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mName;
    stream << obj.mIsVirtual;
    stream << obj.mIndexPref;
    stream << obj.mSyncPref;
    stream << obj.mDisplayPref;
    stream << obj.mEnabled;
    stream << obj.mCachePolicy;
    stream << obj.mStatistics;
    stream << obj.mId;
    stream << obj.mParentId;
    stream << obj.mMimeTypes;
    stream << obj.mRemoteId;
    stream << obj.mRemoteRevision;
    stream << obj.mResource;
    stream << obj.mSearchQuery;
    stream << obj.mSearchCollections;
    stream << obj.mAncestors;
    stream << obj.mAttributes;
    return stream;
}

DataStream &operator>>(DataStream &stream, FetchCollectionsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mName;
    stream >> obj.mIsVirtual;
    stream >> obj.mIndexPref;
    stream >> obj.mSyncPref;
    stream >> obj.mDisplayPref;
    stream >> obj.mEnabled;
    stream >> obj.mCachePolicy;
    stream >> obj.mStatistics;
    stream >> obj.mId;
    stream >> obj.mParentId;
    stream >> obj.mMimeTypes;
    stream >> obj.mRemoteId;
    stream >> obj.mRemoteRevision;
    stream >> obj.mResource;
    stream >> obj.mSearchQuery;
    stream >> obj.mSearchCollections;
    stream >> obj.mAncestors;
    stream >> obj.mAttributes;
    return stream;
}

QDebug operator<<(QDebug dbg, const FetchCollectionsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "name:" << obj.mName << "\n"
        << "isVirtual:" << obj.mIsVirtual << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "cachePolicy:" << obj.mCachePolicy << "\n"
        << "statistics:" << obj.mStatistics << "\n"
        << "id:" << obj.mId << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "resource:" << obj.mResource << "\n"
        << "searchQuery:" << obj.mSearchQuery << "\n"
        << "searchCollections: [\n";
    for (const auto &type : std::as_const(obj.mSearchCollections)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "ancestors: [\n";
    for (const auto &type : std::as_const(obj.mAncestors)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
    return dbg;
}

void FetchCollectionsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("name")] = mName;/* QString*/
    json[QStringLiteral("isVirtual")] = mIsVirtual;/* bool */
    switch (mIndexPref) {
;    case Tristate::True:
        json[QStringLiteral("indexPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("indexPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("indexPref")] = QStringLiteral("Undefined");
        break;
    }
    switch (mSyncPref) {
;    case Tristate::True:
        json[QStringLiteral("syncPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("syncPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("syncPref")] = QStringLiteral("Undefined");
        break;
    }
    switch (mDisplayPref) {
;    case Tristate::True:
        json[QStringLiteral("displayPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("displayPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("displayPref")] = QStringLiteral("Undefined");
        break;
    }
    json[QStringLiteral("enabled")] = mEnabled;/* bool */
    {
         QJsonObject jsonObject;
         mCachePolicy.toJson(jsonObject); /* Akonadi::Protocol::CachePolicy */
         json[QStringLiteral("cachePolicy")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mStatistics.toJson(jsonObject); /* Akonadi::Protocol::FetchCollectionStatsResponse */
         json[QStringLiteral("statistics")] = jsonObject;
    }
    json[QStringLiteral("id")] = mId;/* qint64 */
    json[QStringLiteral("parentId")] = mParentId;/* qint64 */
    json[QStringLiteral("mimeTypes")] = QJsonArray::fromStringList(mMimeTypes);/* QStringList */
    json[QStringLiteral("remoteId")] = mRemoteId;/* QString*/
    json[QStringLiteral("remoteRevision")] = mRemoteRevision;/* QString*/
    json[QStringLiteral("resource")] = mResource;/* QString*/
    json[QStringLiteral("searchQuery")] = mSearchQuery;/* QString*/
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mSearchCollections)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("searchCollections")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAncestors)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::Ancestor */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("ancestors")] = jsonArray;
    }
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
}



/************************* ModifyCollectionCommand *************************/

ModifyCollectionCommand::ModifyCollectionCommand()
    : Command(Command::ModifyCollection)
{
}

ModifyCollectionCommand::ModifyCollectionCommand(const Scope &collection)
    : Command(Command::ModifyCollection)
    , mCollection(collection)
{
}

bool ModifyCollectionCommand::operator==(const ModifyCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && mAttributes == other.mAttributes
        && containerComparator(mRemovedAttributes, other.mRemovedAttributes)
        && containerComparator(mPersistentSearchCollections, other.mPersistentSearchCollections)
        && mPersistentSearchQuery == other.mPersistentSearchQuery
        && mRemoteRevision == other.mRemoteRevision
        && mRemoteId == other.mRemoteId
        && mName == other.mName
        && mMimeTypes == other.mMimeTypes
        && mParentId == other.mParentId
        && mCachePolicy == other.mCachePolicy
        && mModifiedParts == other.mModifiedParts
        && mPersistentSearchRecursive == other.mPersistentSearchRecursive
        && mPersistentSearchRemote == other.mPersistentSearchRemote
        && mEnabled == other.mEnabled
        && mSyncPref == other.mSyncPref
        && mDisplayPref == other.mDisplayPref
        && mIndexPref == other.mIndexPref
    ;
}

void ModifyCollectionCommand::setAttributes(const Akonadi::Protocol::Attributes &val)
{
    mAttributes = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::Attributes);
}

void ModifyCollectionCommand::setRemovedAttributes(const QSet<QByteArray> &val)
{
    mRemovedAttributes = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::RemovedAttributes);
}

void ModifyCollectionCommand::setPersistentSearchCollections(const QVector<qint64> &val)
{
    mPersistentSearchCollections = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setPersistentSearchQuery(const QString &val)
{
    mPersistentSearchQuery = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setRemoteRevision(const QString &val)
{
    mRemoteRevision = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::RemoteRevision);
}

void ModifyCollectionCommand::setRemoteId(const QString &val)
{
    mRemoteId = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::RemoteID);
}

void ModifyCollectionCommand::setName(const QString &val)
{
    mName = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::Name);
}

void ModifyCollectionCommand::setMimeTypes(const QStringList &val)
{
    mMimeTypes = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::MimeTypes);
}

void ModifyCollectionCommand::setParentId(qint64 val)
{
    mParentId = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ParentID);
}

void ModifyCollectionCommand::setCachePolicy(const Akonadi::Protocol::CachePolicy &val)
{
    mCachePolicy = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::CachePolicy);
}

void ModifyCollectionCommand::setPersistentSearchRecursive(bool val)
{
    mPersistentSearchRecursive = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setPersistentSearchRemote(bool val)
{
    mPersistentSearchRemote = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::PersistentSearch);
}

void ModifyCollectionCommand::setEnabled(bool val)
{
    mEnabled = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

void ModifyCollectionCommand::setSyncPref(const Tristate &val)
{
    mSyncPref = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

void ModifyCollectionCommand::setDisplayPref(const Tristate &val)
{
    mDisplayPref = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

void ModifyCollectionCommand::setIndexPref(const Tristate &val)
{
    mIndexPref = val;
    mModifiedParts |= ModifyCollectionCommand::ModifiedParts(ModifyCollectionCommand::ListPreferences);
}

DataStream &operator<<(DataStream &stream, const ModifyCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mModifiedParts;
    stream << obj.mCollection;
    if ((obj.mModifiedParts & ModifyCollectionCommand::ParentID)) {
        stream << obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mIndexPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mDisplayPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mSyncPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream << obj.mEnabled;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchRemote;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchRecursive;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::CachePolicy)) {
        stream << obj.mCachePolicy;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::MimeTypes)) {
        stream << obj.mMimeTypes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Name)) {
        stream << obj.mName;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteID)) {
        stream << obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteRevision)) {
        stream << obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchQuery;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream << obj.mPersistentSearchCollections;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemovedAttributes)) {
        stream << obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Attributes)) {
        stream << obj.mAttributes;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mModifiedParts;
    stream >> obj.mCollection;
    if ((obj.mModifiedParts & ModifyCollectionCommand::ParentID)) {
        stream >> obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mIndexPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mDisplayPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mSyncPref;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::ListPreferences)) {
        stream >> obj.mEnabled;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchRemote;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchRecursive;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::CachePolicy)) {
        stream >> obj.mCachePolicy;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::MimeTypes)) {
        stream >> obj.mMimeTypes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Name)) {
        stream >> obj.mName;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteID)) {
        stream >> obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemoteRevision)) {
        stream >> obj.mRemoteRevision;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchQuery;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::PersistentSearch)) {
        stream >> obj.mPersistentSearchCollections;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::RemovedAttributes)) {
        stream >> obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyCollectionCommand::Attributes)) {
        stream >> obj.mAttributes;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyCollectionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "collection:" << obj.mCollection << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "indexPref:" << obj.mIndexPref << "\n"
        << "displayPref:" << obj.mDisplayPref << "\n"
        << "syncPref:" << obj.mSyncPref << "\n"
        << "enabled:" << obj.mEnabled << "\n"
        << "persistentSearchRemote:" << obj.mPersistentSearchRemote << "\n"
        << "persistentSearchRecursive:" << obj.mPersistentSearchRecursive << "\n"
        << "cachePolicy:" << obj.mCachePolicy << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "name:" << obj.mName << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "remoteRevision:" << obj.mRemoteRevision << "\n"
        << "persistentSearchQuery:" << obj.mPersistentSearchQuery << "\n"
        << "persistentSearchCollections: [\n";
    for (const auto &type : std::as_const(obj.mPersistentSearchCollections)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "removedAttributes: [\n";
    for (const auto &type : std::as_const(obj.mRemovedAttributes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
    return dbg;
}

void ModifyCollectionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("modifiedParts")] = static_cast<int>(mModifiedParts);/* ModifyCollectionCommand::ModifiedParts*/
    {
        QJsonObject jsonObject;
        mCollection.toJson(jsonObject); /* Scope */
        json[QStringLiteral("collection")] = jsonObject;
    }
    json[QStringLiteral("parentId")] = mParentId;/* qint64 */
    switch (mIndexPref) {
;    case Tristate::True:
        json[QStringLiteral("indexPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("indexPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("indexPref")] = QStringLiteral("Undefined");
        break;
    }
    switch (mDisplayPref) {
;    case Tristate::True:
        json[QStringLiteral("displayPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("displayPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("displayPref")] = QStringLiteral("Undefined");
        break;
    }
    switch (mSyncPref) {
;    case Tristate::True:
        json[QStringLiteral("syncPref")] = QStringLiteral("True");
        break;
    case Tristate::False:
        json[QStringLiteral("syncPref")] = QStringLiteral("False");
        break;
    case Tristate::Undefined:
        json[QStringLiteral("syncPref")] = QStringLiteral("Undefined");
        break;
    }
    json[QStringLiteral("enabled")] = mEnabled;/* bool */
    json[QStringLiteral("persistentSearchRemote")] = mPersistentSearchRemote;/* bool */
    json[QStringLiteral("persistentSearchRecursive")] = mPersistentSearchRecursive;/* bool */
    {
         QJsonObject jsonObject;
         mCachePolicy.toJson(jsonObject); /* Akonadi::Protocol::CachePolicy */
         json[QStringLiteral("cachePolicy")] = jsonObject;
    }
    json[QStringLiteral("mimeTypes")] = QJsonArray::fromStringList(mMimeTypes);/* QStringList */
    json[QStringLiteral("name")] = mName;/* QString*/
    json[QStringLiteral("remoteId")] = mRemoteId;/* QString*/
    json[QStringLiteral("remoteRevision")] = mRemoteRevision;/* QString*/
    json[QStringLiteral("persistentSearchQuery")] = mPersistentSearchQuery;/* QString*/
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mPersistentSearchCollections)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("persistentSearchCollections")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedAttributes)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("removedAttributes")] = jsonArray;
    }
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
}



/************************* ModifyCollectionResponse *************************/

ModifyCollectionResponse::ModifyCollectionResponse()
    : Response(Command::ModifyCollection)
{
}

bool ModifyCollectionResponse::operator==(const ModifyCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyCollectionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void ModifyCollectionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* MoveCollectionCommand *************************/

MoveCollectionCommand::MoveCollectionCommand()
    : Command(Command::MoveCollection)
{
}

MoveCollectionCommand::MoveCollectionCommand(const Scope &collection, const Scope &destination)
    : Command(Command::MoveCollection)
    , mCollection(collection)
    , mDestination(destination)
{
}

bool MoveCollectionCommand::operator==(const MoveCollectionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mCollection == other.mCollection
        && mDestination == other.mDestination
    ;
}

DataStream &operator<<(DataStream &stream, const MoveCollectionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mCollection;
    stream << obj.mDestination;
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveCollectionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mCollection;
    stream >> obj.mDestination;
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveCollectionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "collection:" << obj.mCollection << "\n"
        << "destination:" << obj.mDestination << "\n"
    ;
    return dbg;
}

void MoveCollectionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mCollection.toJson(jsonObject); /* Scope */
        json[QStringLiteral("collection")] = jsonObject;
    }
    {
        QJsonObject jsonObject;
        mDestination.toJson(jsonObject); /* Scope */
        json[QStringLiteral("destination")] = jsonObject;
    }
}



/************************* MoveCollectionResponse *************************/

MoveCollectionResponse::MoveCollectionResponse()
    : Response(Command::MoveCollection)
{
}

bool MoveCollectionResponse::operator==(const MoveCollectionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const MoveCollectionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, MoveCollectionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const MoveCollectionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void MoveCollectionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* SearchCommand *************************/

SearchCommand::SearchCommand()
    : Command(Command::Search)
{
}

SearchCommand::SearchCommand(const QString &query)
    : Command(Command::Search)
    , mQuery(query)
{
}

bool SearchCommand::operator==(const SearchCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mMimeTypes == other.mMimeTypes
        && containerComparator(mCollections, other.mCollections)
        && mQuery == other.mQuery
        && mItemFetchScope == other.mItemFetchScope
        && mTagFetchScope == other.mTagFetchScope
        && mRecursive == other.mRecursive
        && mRemote == other.mRemote
    ;
}

DataStream &operator<<(DataStream &stream, const SearchCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mMimeTypes;
    stream << obj.mCollections;
    stream << obj.mQuery;
    stream << obj.mItemFetchScope;
    stream << obj.mTagFetchScope;
    stream << obj.mRecursive;
    stream << obj.mRemote;
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mMimeTypes;
    stream >> obj.mCollections;
    stream >> obj.mQuery;
    stream >> obj.mItemFetchScope;
    stream >> obj.mTagFetchScope;
    stream >> obj.mRecursive;
    stream >> obj.mRemote;
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "collections: [\n";
    for (const auto &type : std::as_const(obj.mCollections)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "query:" << obj.mQuery << "\n"
        << "itemFetchScope:" << obj.mItemFetchScope << "\n"
        << "tagFetchScope:" << obj.mTagFetchScope << "\n"
        << "recursive:" << obj.mRecursive << "\n"
        << "remote:" << obj.mRemote << "\n"
    ;
    return dbg;
}

void SearchCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("mimeTypes")] = QJsonArray::fromStringList(mMimeTypes);/* QStringList */
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mCollections)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("collections")] = jsonArray;
    }
    json[QStringLiteral("query")] = mQuery;/* QString*/
    {
         QJsonObject jsonObject;
         mItemFetchScope.toJson(jsonObject); /* Akonadi::Protocol::ItemFetchScope */
         json[QStringLiteral("itemFetchScope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mTagFetchScope.toJson(jsonObject); /* Akonadi::Protocol::TagFetchScope */
         json[QStringLiteral("tagFetchScope")] = jsonObject;
    }
    json[QStringLiteral("recursive")] = mRecursive;/* bool */
    json[QStringLiteral("remote")] = mRemote;/* bool */
}



/************************* SearchResponse *************************/

SearchResponse::SearchResponse()
    : Response(Command::Search)
{
}

bool SearchResponse::operator==(const SearchResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const SearchResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void SearchResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* SearchResultCommand *************************/

SearchResultCommand::SearchResultCommand()
    : Command(Command::SearchResult)
{
}

SearchResultCommand::SearchResultCommand(const QByteArray &searchId, qint64 collectionId, const Scope &result)
    : Command(Command::SearchResult)
    , mSearchId(searchId)
    , mCollectionId(collectionId)
    , mResult(result)
{
}

bool SearchResultCommand::operator==(const SearchResultCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mSearchId == other.mSearchId
        && mCollectionId == other.mCollectionId
        && mResult == other.mResult
    ;
}

DataStream &operator<<(DataStream &stream, const SearchResultCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mSearchId;
    stream << obj.mCollectionId;
    stream << obj.mResult;
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchResultCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mSearchId;
    stream >> obj.mCollectionId;
    stream >> obj.mResult;
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchResultCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "searchId:" << obj.mSearchId << "\n"
        << "collectionId:" << obj.mCollectionId << "\n"
        << "result:" << obj.mResult << "\n"
    ;
    return dbg;
}

void SearchResultCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("searchId")] = QString::fromUtf8(mSearchId)/* QByteArray */;
    json[QStringLiteral("collectionId")] = mCollectionId;/* qint64 */
    {
        QJsonObject jsonObject;
        mResult.toJson(jsonObject); /* Scope */
        json[QStringLiteral("result")] = jsonObject;
    }
}



/************************* SearchResultResponse *************************/

SearchResultResponse::SearchResultResponse()
    : Response(Command::SearchResult)
{
}

bool SearchResultResponse::operator==(const SearchResultResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const SearchResultResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, SearchResultResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const SearchResultResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void SearchResultResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* StoreSearchCommand *************************/

StoreSearchCommand::StoreSearchCommand()
    : Command(Command::StoreSearch)
{
}

bool StoreSearchCommand::operator==(const StoreSearchCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mName == other.mName
        && mQuery == other.mQuery
        && mMimeTypes == other.mMimeTypes
        && containerComparator(mQueryCollections, other.mQueryCollections)
        && mRemote == other.mRemote
        && mRecursive == other.mRecursive
    ;
}

DataStream &operator<<(DataStream &stream, const StoreSearchCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mName;
    stream << obj.mQuery;
    stream << obj.mMimeTypes;
    stream << obj.mQueryCollections;
    stream << obj.mRemote;
    stream << obj.mRecursive;
    return stream;
}

DataStream &operator>>(DataStream &stream, StoreSearchCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mName;
    stream >> obj.mQuery;
    stream >> obj.mMimeTypes;
    stream >> obj.mQueryCollections;
    stream >> obj.mRemote;
    stream >> obj.mRecursive;
    return stream;
}

QDebug operator<<(QDebug dbg, const StoreSearchCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "name:" << obj.mName << "\n"
        << "query:" << obj.mQuery << "\n"
        << "mimeTypes:" << obj.mMimeTypes << "\n"
        << "queryCollections: [\n";
    for (const auto &type : std::as_const(obj.mQueryCollections)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "remote:" << obj.mRemote << "\n"
        << "recursive:" << obj.mRecursive << "\n"
    ;
    return dbg;
}

void StoreSearchCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("name")] = mName;/* QString*/
    json[QStringLiteral("query")] = mQuery;/* QString*/
    json[QStringLiteral("mimeTypes")] = QJsonArray::fromStringList(mMimeTypes);/* QStringList */
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mQueryCollections)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("queryCollections")] = jsonArray;
    }
    json[QStringLiteral("remote")] = mRemote;/* bool */
    json[QStringLiteral("recursive")] = mRecursive;/* bool */
}



/************************* StoreSearchResponse *************************/

StoreSearchResponse::StoreSearchResponse()
    : Response(Command::StoreSearch)
{
}

bool StoreSearchResponse::operator==(const StoreSearchResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const StoreSearchResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, StoreSearchResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const StoreSearchResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void StoreSearchResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* CreateTagCommand *************************/

CreateTagCommand::CreateTagCommand()
    : Command(Command::CreateTag)
{
}

bool CreateTagCommand::operator==(const CreateTagCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mGid == other.mGid
        && mRemoteId == other.mRemoteId
        && mType == other.mType
        && mAttributes == other.mAttributes
        && mParentId == other.mParentId
        && mMerge == other.mMerge
    ;
}

DataStream &operator<<(DataStream &stream, const CreateTagCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mGid;
    stream << obj.mRemoteId;
    stream << obj.mType;
    stream << obj.mAttributes;
    stream << obj.mParentId;
    stream << obj.mMerge;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateTagCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mGid;
    stream >> obj.mRemoteId;
    stream >> obj.mType;
    stream >> obj.mAttributes;
    stream >> obj.mParentId;
    stream >> obj.mMerge;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateTagCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "gid:" << obj.mGid << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "type:" << obj.mType << "\n"
        << "attributes:" << obj.mAttributes << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "merge:" << obj.mMerge << "\n"
    ;
    return dbg;
}

void CreateTagCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("gid")] = QString::fromUtf8(mGid)/* QByteArray */;
    json[QStringLiteral("remoteId")] = QString::fromUtf8(mRemoteId)/* QByteArray */;
    json[QStringLiteral("type")] = QString::fromUtf8(mType)/* QByteArray */;
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
    json[QStringLiteral("parentId")] = mParentId;/* qint64 */
    json[QStringLiteral("merge")] = mMerge;/* bool */
}



/************************* CreateTagResponse *************************/

CreateTagResponse::CreateTagResponse()
    : Response(Command::CreateTag)
{
}

bool CreateTagResponse::operator==(const CreateTagResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateTagResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateTagResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateTagResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void CreateTagResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* DeleteTagCommand *************************/

DeleteTagCommand::DeleteTagCommand()
    : Command(Command::DeleteTag)
{
}

DeleteTagCommand::DeleteTagCommand(const Scope &tag)
    : Command(Command::DeleteTag)
    , mTag(tag)
{
}

bool DeleteTagCommand::operator==(const DeleteTagCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mTag == other.mTag
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteTagCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mTag;
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteTagCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mTag;
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteTagCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "tag:" << obj.mTag << "\n"
    ;
    return dbg;
}

void DeleteTagCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mTag.toJson(jsonObject); /* Scope */
        json[QStringLiteral("tag")] = jsonObject;
    }
}



/************************* DeleteTagResponse *************************/

DeleteTagResponse::DeleteTagResponse()
    : Response(Command::DeleteTag)
{
}

bool DeleteTagResponse::operator==(const DeleteTagResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const DeleteTagResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, DeleteTagResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const DeleteTagResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void DeleteTagResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* ModifyTagCommand *************************/

ModifyTagCommand::ModifyTagCommand()
    : Command(Command::ModifyTag)
{
}

ModifyTagCommand::ModifyTagCommand(qint64 tagId)
    : Command(Command::ModifyTag)
    , mTagId(tagId)
{
}

bool ModifyTagCommand::operator==(const ModifyTagCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mTagId == other.mTagId
        && mParentId == other.mParentId
        && mType == other.mType
        && mRemoteId == other.mRemoteId
        && containerComparator(mRemovedAttributes, other.mRemovedAttributes)
        && mAttributes == other.mAttributes
        && mModifiedParts == other.mModifiedParts
    ;
}

void ModifyTagCommand::setParentId(qint64 val)
{
    mParentId = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::ParentId);
}

void ModifyTagCommand::setType(const QByteArray &val)
{
    mType = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::Type);
}

void ModifyTagCommand::setRemoteId(const QByteArray &val)
{
    mRemoteId = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::RemoteId);
}

void ModifyTagCommand::setRemovedAttributes(const QSet<QByteArray> &val)
{
    mRemovedAttributes = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::RemovedAttributes);
}

void ModifyTagCommand::setAttributes(const Akonadi::Protocol::Attributes &val)
{
    mAttributes = val;
    mModifiedParts |= ModifyTagCommand::ModifiedParts(ModifyTagCommand::Attributes);
}

DataStream &operator<<(DataStream &stream, const ModifyTagCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mTagId;
    stream << obj.mModifiedParts;
    if ((obj.mModifiedParts & ModifyTagCommand::ParentId)) {
        stream << obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Type)) {
        stream << obj.mType;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemoteId)) {
        stream << obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemovedAttributes)) {
        stream << obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Attributes)) {
        stream << obj.mAttributes;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyTagCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mTagId;
    stream >> obj.mModifiedParts;
    if ((obj.mModifiedParts & ModifyTagCommand::ParentId)) {
        stream >> obj.mParentId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Type)) {
        stream >> obj.mType;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemoteId)) {
        stream >> obj.mRemoteId;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::RemovedAttributes)) {
        stream >> obj.mRemovedAttributes;
    }
    if ((obj.mModifiedParts & ModifyTagCommand::Attributes)) {
        stream >> obj.mAttributes;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyTagCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "tagId:" << obj.mTagId << "\n"
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "parentId:" << obj.mParentId << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
        << "removedAttributes: [\n";
    for (const auto &type : std::as_const(obj.mRemovedAttributes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "attributes:" << obj.mAttributes << "\n"
    ;
    return dbg;
}

void ModifyTagCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("tagId")] = mTagId;/* qint64 */
    json[QStringLiteral("modifiedParts")] = static_cast<int>(mModifiedParts);/* ModifyTagCommand::ModifiedParts*/
    json[QStringLiteral("parentId")] = mParentId;/* qint64 */
    json[QStringLiteral("type")] = QString::fromUtf8(mType)/* QByteArray */;
    json[QStringLiteral("remoteId")] = QString::fromUtf8(mRemoteId)/* QByteArray */;
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedAttributes)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("removedAttributes")] = jsonArray;
    }
    {
        QJsonObject jsonObject;
        auto i = mAttributes.constBegin();
        const auto &end = mAttributes.constEnd();
        while (i != end) {
            jsonObject[QString::fromUtf8(i.key())] = QString::fromUtf8(i.value());
            ++i;
        }
        json[QStringLiteral("attributes")] = jsonObject;
    }
}



/************************* ModifyTagResponse *************************/

ModifyTagResponse::ModifyTagResponse()
    : Response(Command::ModifyTag)
{
}

bool ModifyTagResponse::operator==(const ModifyTagResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyTagResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyTagResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyTagResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void ModifyTagResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* ModifyRelationCommand *************************/

ModifyRelationCommand::ModifyRelationCommand()
    : Command(Command::ModifyRelation)
{
}

ModifyRelationCommand::ModifyRelationCommand(qint64 left, qint64 right, const QByteArray &type, const QByteArray &remoteId)
    : Command(Command::ModifyRelation)
    , mLeft(left)
    , mRight(right)
    , mType(type)
    , mRemoteId(remoteId)
{
}

bool ModifyRelationCommand::operator==(const ModifyRelationCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mLeft == other.mLeft
        && mRight == other.mRight
        && mType == other.mType
        && mRemoteId == other.mRemoteId
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyRelationCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mLeft;
    stream << obj.mRight;
    stream << obj.mType;
    stream << obj.mRemoteId;
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyRelationCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mRight;
    stream >> obj.mType;
    stream >> obj.mRemoteId;
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyRelationCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "right:" << obj.mRight << "\n"
        << "type:" << obj.mType << "\n"
        << "remoteId:" << obj.mRemoteId << "\n"
    ;
    return dbg;
}

void ModifyRelationCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("left")] = mLeft;/* qint64 */
    json[QStringLiteral("right")] = mRight;/* qint64 */
    json[QStringLiteral("type")] = QString::fromUtf8(mType)/* QByteArray */;
    json[QStringLiteral("remoteId")] = QString::fromUtf8(mRemoteId)/* QByteArray */;
}



/************************* ModifyRelationResponse *************************/

ModifyRelationResponse::ModifyRelationResponse()
    : Response(Command::ModifyRelation)
{
}

bool ModifyRelationResponse::operator==(const ModifyRelationResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifyRelationResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifyRelationResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifyRelationResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void ModifyRelationResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* RemoveRelationsCommand *************************/

RemoveRelationsCommand::RemoveRelationsCommand()
    : Command(Command::RemoveRelations)
{
}

RemoveRelationsCommand::RemoveRelationsCommand(qint64 left, qint64 right, const QByteArray &type)
    : Command(Command::RemoveRelations)
    , mLeft(left)
    , mRight(right)
    , mType(type)
{
}

bool RemoveRelationsCommand::operator==(const RemoveRelationsCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mLeft == other.mLeft
        && mRight == other.mRight
        && mType == other.mType
    ;
}

DataStream &operator<<(DataStream &stream, const RemoveRelationsCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mLeft;
    stream << obj.mRight;
    stream << obj.mType;
    return stream;
}

DataStream &operator>>(DataStream &stream, RemoveRelationsCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mLeft;
    stream >> obj.mRight;
    stream >> obj.mType;
    return stream;
}

QDebug operator<<(QDebug dbg, const RemoveRelationsCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "left:" << obj.mLeft << "\n"
        << "right:" << obj.mRight << "\n"
        << "type:" << obj.mType << "\n"
    ;
    return dbg;
}

void RemoveRelationsCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("left")] = mLeft;/* qint64 */
    json[QStringLiteral("right")] = mRight;/* qint64 */
    json[QStringLiteral("type")] = QString::fromUtf8(mType)/* QByteArray */;
}



/************************* RemoveRelationsResponse *************************/

RemoveRelationsResponse::RemoveRelationsResponse()
    : Response(Command::RemoveRelations)
{
}

bool RemoveRelationsResponse::operator==(const RemoveRelationsResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const RemoveRelationsResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, RemoveRelationsResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const RemoveRelationsResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void RemoveRelationsResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* SelectResourceCommand *************************/

SelectResourceCommand::SelectResourceCommand()
    : Command(Command::SelectResource)
{
}

SelectResourceCommand::SelectResourceCommand(const QString &resourceId)
    : Command(Command::SelectResource)
    , mResourceId(resourceId)
{
}

bool SelectResourceCommand::operator==(const SelectResourceCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mResourceId == other.mResourceId
    ;
}

DataStream &operator<<(DataStream &stream, const SelectResourceCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mResourceId;
    return stream;
}

DataStream &operator>>(DataStream &stream, SelectResourceCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mResourceId;
    return stream;
}

QDebug operator<<(QDebug dbg, const SelectResourceCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "resourceId:" << obj.mResourceId << "\n"
    ;
    return dbg;
}

void SelectResourceCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("resourceId")] = mResourceId;/* QString*/
}



/************************* SelectResourceResponse *************************/

SelectResourceResponse::SelectResourceResponse()
    : Response(Command::SelectResource)
{
}

bool SelectResourceResponse::operator==(const SelectResourceResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const SelectResourceResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, SelectResourceResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const SelectResourceResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void SelectResourceResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* StreamPayloadCommand *************************/

StreamPayloadCommand::StreamPayloadCommand()
    : Command(Command::StreamPayload)
{
}

StreamPayloadCommand::StreamPayloadCommand(const QByteArray &payloadName, const StreamPayloadCommand::Request &request, const QString &destination)
    : Command(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mDestination(destination)
    , mRequest(request)
{
}

bool StreamPayloadCommand::operator==(const StreamPayloadCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mPayloadName == other.mPayloadName
        && mDestination == other.mDestination
        && mRequest == other.mRequest
    ;
}

DataStream &operator<<(DataStream &stream, const StreamPayloadCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mPayloadName;
    stream << obj.mDestination;
    stream << obj.mRequest;
    return stream;
}

DataStream &operator>>(DataStream &stream, StreamPayloadCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mPayloadName;
    stream >> obj.mDestination;
    stream >> obj.mRequest;
    return stream;
}

QDebug operator<<(QDebug dbg, const StreamPayloadCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "payloadName:" << obj.mPayloadName << "\n"
        << "destination:" << obj.mDestination << "\n"
        << "request:" << obj.mRequest << "\n"
    ;
    return dbg;
}

void StreamPayloadCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("payloadName")] = QString::fromUtf8(mPayloadName)/* QByteArray */;
    json[QStringLiteral("destination")] = mDestination;/* QString*/
    json[QStringLiteral("request")] = mRequest;/* StreamPayloadCommand::Request*/
}



/************************* StreamPayloadResponse *************************/

StreamPayloadResponse::StreamPayloadResponse()
    : Response(Command::StreamPayload)
{
}

StreamPayloadResponse::StreamPayloadResponse(const QByteArray &payloadName, const Akonadi::Protocol::PartMetaData &metaData)
    : Response(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mMetaData(metaData)
{
}

StreamPayloadResponse::StreamPayloadResponse(const QByteArray &payloadName, const QByteArray &data)
    : Response(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mData(data)
{
}

StreamPayloadResponse::StreamPayloadResponse(const QByteArray &payloadName, const Akonadi::Protocol::PartMetaData &metaData, const QByteArray &data)
    : Response(Command::StreamPayload)
    , mPayloadName(payloadName)
    , mData(data)
    , mMetaData(metaData)
{
}

bool StreamPayloadResponse::operator==(const StreamPayloadResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
        && mPayloadName == other.mPayloadName
        && mData == other.mData
        && mMetaData == other.mMetaData
    ;
}

DataStream &operator<<(DataStream &stream, const StreamPayloadResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    stream << obj.mPayloadName;
    stream << obj.mData;
    stream << obj.mMetaData;
    return stream;
}

DataStream &operator>>(DataStream &stream, StreamPayloadResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    stream >> obj.mPayloadName;
    stream >> obj.mData;
    stream >> obj.mMetaData;
    return stream;
}

QDebug operator<<(QDebug dbg, const StreamPayloadResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
        << "payloadName:" << obj.mPayloadName << "\n"
        << "data:" << obj.mData << "\n"
        << "metaData:" << obj.mMetaData << "\n"
    ;
    return dbg;
}

void StreamPayloadResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
    json[QStringLiteral("payloadName")] = QString::fromUtf8(mPayloadName)/* QByteArray */;
    json[QStringLiteral("data")] = QString::fromUtf8(mData)/* QByteArray */;
    {
         QJsonObject jsonObject;
         mMetaData.toJson(jsonObject); /* Akonadi::Protocol::PartMetaData */
         json[QStringLiteral("metaData")] = jsonObject;
    }
}



/************************* ItemChangeNotification *************************/

ItemChangeNotification::ItemChangeNotification()
    : ChangeNotification(Command::ItemChangeNotification)
{
}

bool ItemChangeNotification::operator==(const ItemChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mResource == other.mResource
        && mParentCollection == other.mParentCollection
        && mParentDestCollection == other.mParentDestCollection
        && mDestinationResource == other.mDestinationResource
        && containerComparator(mItemParts, other.mItemParts)
        && containerComparator(mAddedFlags, other.mAddedFlags)
        && containerComparator(mRemovedFlags, other.mRemovedFlags)
        && containerComparator(mAddedTags, other.mAddedTags)
        && containerComparator(mRemovedTags, other.mRemovedTags)
        && containerComparator(mAddedRelations, other.mAddedRelations)
        && containerComparator(mRemovedRelations, other.mRemovedRelations)
        && containerComparator(mItems, other.mItems)
        && mOperation == other.mOperation
        && mMustRetrieve == other.mMustRetrieve
    ;
}

DataStream &operator<<(DataStream &stream, const ItemChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mResource;
    stream << obj.mParentCollection;
    stream << obj.mParentDestCollection;
    stream << obj.mDestinationResource;
    stream << obj.mItemParts;
    stream << obj.mAddedFlags;
    stream << obj.mRemovedFlags;
    stream << obj.mAddedTags;
    stream << obj.mRemovedTags;
    stream << obj.mAddedRelations;
    stream << obj.mRemovedRelations;
    stream << obj.mItems;
    stream << obj.mOperation;
    stream << obj.mMustRetrieve;
    return stream;
}

DataStream &operator>>(DataStream &stream, ItemChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mResource;
    stream >> obj.mParentCollection;
    stream >> obj.mParentDestCollection;
    stream >> obj.mDestinationResource;
    stream >> obj.mItemParts;
    stream >> obj.mAddedFlags;
    stream >> obj.mRemovedFlags;
    stream >> obj.mAddedTags;
    stream >> obj.mRemovedTags;
    stream >> obj.mAddedRelations;
    stream >> obj.mRemovedRelations;
    stream >> obj.mItems;
    stream >> obj.mOperation;
    stream >> obj.mMustRetrieve;
    return stream;
}

QDebug operator<<(QDebug dbg, const ItemChangeNotification &obj)
{
    dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "resource:" << obj.mResource << "\n"
        << "parentCollection:" << obj.mParentCollection << "\n"
        << "parentDestCollection:" << obj.mParentDestCollection << "\n"
        << "destinationResource:" << obj.mDestinationResource << "\n"
        << "itemParts: [\n";
    for (const auto &type : std::as_const(obj.mItemParts)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "addedFlags: [\n";
    for (const auto &type : std::as_const(obj.mAddedFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "removedFlags: [\n";
    for (const auto &type : std::as_const(obj.mRemovedFlags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "addedTags: [\n";
    for (const auto &type : std::as_const(obj.mAddedTags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "removedTags: [\n";
    for (const auto &type : std::as_const(obj.mRemovedTags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "addedRelations: [\n";
    for (const auto &type : std::as_const(obj.mAddedRelations)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "removedRelations: [\n";
    for (const auto &type : std::as_const(obj.mRemovedRelations)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "items: [\n";
    for (const auto &type : std::as_const(obj.mItems)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "operation:" << obj.mOperation << "\n"
        << "mustRetrieve:" << obj.mMustRetrieve << "\n"
    ;
    return dbg;
}

void ItemChangeNotification::toJson(QJsonObject &json) const
{
    static_cast<const ChangeNotification *>(this)->toJson(json);
    json[QStringLiteral("resource")] = QString::fromUtf8(mResource)/* QByteArray */;
    json[QStringLiteral("parentCollection")] = mParentCollection;/* qint64 */
    json[QStringLiteral("parentDestCollection")] = mParentDestCollection;/* qint64 */
    json[QStringLiteral("destinationResource")] = QString::fromUtf8(mDestinationResource)/* QByteArray */;
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mItemParts)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("itemParts")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAddedFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("addedFlags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedFlags)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("removedFlags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAddedTags)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("addedTags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedTags)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("removedTags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mAddedRelations)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::ChangeNotification::Relation */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("addedRelations")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mRemovedRelations)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::ChangeNotification::Relation */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("removedRelations")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mItems)) {
            QJsonObject jsonObject;
            type.toJson(jsonObject); /* Akonadi::Protocol::FetchItemsResponse */
            jsonArray.append(jsonObject);
        }
        json[QStringLiteral("items")] = jsonArray;
    }
    json[QStringLiteral("operation")] = mOperation;/* ItemChangeNotification::Operation*/
    json[QStringLiteral("mustRetrieve")] = mMustRetrieve;/* bool */
}



/************************* CollectionChangeNotification *************************/

CollectionChangeNotification::CollectionChangeNotification()
    : ChangeNotification(Command::CollectionChangeNotification)
{
}

bool CollectionChangeNotification::operator==(const CollectionChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mResource == other.mResource
        && mParentCollection == other.mParentCollection
        && mParentDestCollection == other.mParentDestCollection
        && mDestinationResource == other.mDestinationResource
        && containerComparator(mChangedParts, other.mChangedParts)
        && mOperation == other.mOperation
        && mCollection == other.mCollection
    ;
}

DataStream &operator<<(DataStream &stream, const CollectionChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mResource;
    stream << obj.mParentCollection;
    stream << obj.mParentDestCollection;
    stream << obj.mDestinationResource;
    stream << obj.mChangedParts;
    stream << obj.mOperation;
    stream << obj.mCollection;
    return stream;
}

DataStream &operator>>(DataStream &stream, CollectionChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mResource;
    stream >> obj.mParentCollection;
    stream >> obj.mParentDestCollection;
    stream >> obj.mDestinationResource;
    stream >> obj.mChangedParts;
    stream >> obj.mOperation;
    stream >> obj.mCollection;
    return stream;
}

QDebug operator<<(QDebug dbg, const CollectionChangeNotification &obj)
{
    dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "resource:" << obj.mResource << "\n"
        << "parentCollection:" << obj.mParentCollection << "\n"
        << "parentDestCollection:" << obj.mParentDestCollection << "\n"
        << "destinationResource:" << obj.mDestinationResource << "\n"
        << "changedParts: [\n";
    for (const auto &type : std::as_const(obj.mChangedParts)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "operation:" << obj.mOperation << "\n"
        << "collection:" << obj.mCollection << "\n"
    ;
    return dbg;
}

void CollectionChangeNotification::toJson(QJsonObject &json) const
{
    static_cast<const ChangeNotification *>(this)->toJson(json);
    json[QStringLiteral("resource")] = QString::fromUtf8(mResource)/* QByteArray */;
    json[QStringLiteral("parentCollection")] = mParentCollection;/* qint64 */
    json[QStringLiteral("parentDestCollection")] = mParentDestCollection;/* qint64 */
    json[QStringLiteral("destinationResource")] = QString::fromUtf8(mDestinationResource)/* QByteArray */;
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mChangedParts)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("changedParts")] = jsonArray;
    }
    json[QStringLiteral("operation")] = mOperation;/* CollectionChangeNotification::Operation*/
    {
         QJsonObject jsonObject;
         mCollection.toJson(jsonObject); /* Akonadi::Protocol::FetchCollectionsResponse */
         json[QStringLiteral("collection")] = jsonObject;
    }
}



/************************* TagChangeNotification *************************/

TagChangeNotification::TagChangeNotification()
    : ChangeNotification(Command::TagChangeNotification)
{
}

bool TagChangeNotification::operator==(const TagChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mResource == other.mResource
        && mOperation == other.mOperation
        && mTag == other.mTag
    ;
}

DataStream &operator<<(DataStream &stream, const TagChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mResource;
    stream << obj.mOperation;
    stream << obj.mTag;
    return stream;
}

DataStream &operator>>(DataStream &stream, TagChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mResource;
    stream >> obj.mOperation;
    stream >> obj.mTag;
    return stream;
}

QDebug operator<<(QDebug dbg, const TagChangeNotification &obj)
{
    dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "resource:" << obj.mResource << "\n"
        << "operation:" << obj.mOperation << "\n"
        << "tag:" << obj.mTag << "\n"
    ;
    return dbg;
}

void TagChangeNotification::toJson(QJsonObject &json) const
{
    static_cast<const ChangeNotification *>(this)->toJson(json);
    json[QStringLiteral("resource")] = QString::fromUtf8(mResource)/* QByteArray */;
    json[QStringLiteral("operation")] = mOperation;/* TagChangeNotification::Operation*/
    {
         QJsonObject jsonObject;
         mTag.toJson(jsonObject); /* Akonadi::Protocol::FetchTagsResponse */
         json[QStringLiteral("tag")] = jsonObject;
    }
}



/************************* RelationChangeNotification *************************/

RelationChangeNotification::RelationChangeNotification()
    : ChangeNotification(Command::RelationChangeNotification)
{
}

bool RelationChangeNotification::operator==(const RelationChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mOperation == other.mOperation
        && mRelation == other.mRelation
    ;
}

DataStream &operator<<(DataStream &stream, const RelationChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mOperation;
    stream << obj.mRelation;
    return stream;
}

DataStream &operator>>(DataStream &stream, RelationChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mOperation;
    stream >> obj.mRelation;
    return stream;
}

QDebug operator<<(QDebug dbg, const RelationChangeNotification &obj)
{
    dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "operation:" << obj.mOperation << "\n"
        << "relation:" << obj.mRelation << "\n"
    ;
    return dbg;
}

void RelationChangeNotification::toJson(QJsonObject &json) const
{
    static_cast<const ChangeNotification *>(this)->toJson(json);
    json[QStringLiteral("operation")] = mOperation;/* RelationChangeNotification::Operation*/
    {
         QJsonObject jsonObject;
         mRelation.toJson(jsonObject); /* Akonadi::Protocol::FetchRelationsResponse */
         json[QStringLiteral("relation")] = jsonObject;
    }
}



/************************* CreateSubscriptionCommand *************************/

CreateSubscriptionCommand::CreateSubscriptionCommand()
    : Command(Command::CreateSubscription)
{
}

CreateSubscriptionCommand::CreateSubscriptionCommand(const QByteArray &subscriberName, const QByteArray &session)
    : Command(Command::CreateSubscription)
    , mSubscriberName(subscriberName)
    , mSession(session)
{
}

bool CreateSubscriptionCommand::operator==(const CreateSubscriptionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mSubscriberName == other.mSubscriberName
        && mSession == other.mSession
    ;
}

DataStream &operator<<(DataStream &stream, const CreateSubscriptionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mSubscriberName;
    stream << obj.mSession;
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateSubscriptionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mSubscriberName;
    stream >> obj.mSession;
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateSubscriptionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "subscriberName:" << obj.mSubscriberName << "\n"
        << "session:" << obj.mSession << "\n"
    ;
    return dbg;
}

void CreateSubscriptionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("subscriberName")] = QString::fromUtf8(mSubscriberName)/* QByteArray */;
    json[QStringLiteral("session")] = QString::fromUtf8(mSession)/* QByteArray */;
}



/************************* CreateSubscriptionResponse *************************/

CreateSubscriptionResponse::CreateSubscriptionResponse()
    : Response(Command::CreateSubscription)
{
}

bool CreateSubscriptionResponse::operator==(const CreateSubscriptionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const CreateSubscriptionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, CreateSubscriptionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const CreateSubscriptionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void CreateSubscriptionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* ModifySubscriptionCommand *************************/

ModifySubscriptionCommand::ModifySubscriptionCommand()
    : Command(Command::ModifySubscription)
{
}

bool ModifySubscriptionCommand::operator==(const ModifySubscriptionCommand &other) const
{
    return true // simplifies generation
        && Command::operator==(other)
        && mSubscriberName == other.mSubscriberName
        && containerComparator(mStopIgnoringSessions, other.mStopIgnoringSessions)
        && containerComparator(mStartIgnoringSessions, other.mStartIgnoringSessions)
        && mStopMonitoringMimeTypes == other.mStopMonitoringMimeTypes
        && mStartMonitoringMimeTypes == other.mStartMonitoringMimeTypes
        && containerComparator(mStopMonitoringResources, other.mStopMonitoringResources)
        && containerComparator(mStartMonitoringResources, other.mStartMonitoringResources)
        && containerComparator(mStopMonitoringTypes, other.mStopMonitoringTypes)
        && containerComparator(mStartMonitoringTypes, other.mStartMonitoringTypes)
        && containerComparator(mStopMonitoringTags, other.mStopMonitoringTags)
        && containerComparator(mStartMonitoringTags, other.mStartMonitoringTags)
        && containerComparator(mStopMonitoringItems, other.mStopMonitoringItems)
        && containerComparator(mStartMonitoringItems, other.mStartMonitoringItems)
        && containerComparator(mStopMonitoringCollections, other.mStopMonitoringCollections)
        && containerComparator(mStartMonitoringCollections, other.mStartMonitoringCollections)
        && mModifiedParts == other.mModifiedParts
        && mItemFetchScope == other.mItemFetchScope
        && mCollectionFetchScope == other.mCollectionFetchScope
        && mTagFetchScope == other.mTagFetchScope
        && mAllMonitored == other.mAllMonitored
        && mIsExclusive == other.mIsExclusive
    ;
}

void ModifySubscriptionCommand::stopIgnoringSession(const QByteArray &val)
{
    mStopIgnoringSessions << val;
    auto it = std::find(mStartIgnoringSessions.begin(), mStartIgnoringSessions.end(), val);
    if (it != mStartIgnoringSessions.end()) {
        mStartIgnoringSessions.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Sessions);
}

void ModifySubscriptionCommand::startIgnoringSession(const QByteArray &val)
{
    mStartIgnoringSessions << val;
    auto it = std::find(mStopIgnoringSessions.begin(), mStopIgnoringSessions.end(), val);
    if (it != mStopIgnoringSessions.end()) {
        mStopIgnoringSessions.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Sessions);
}

void ModifySubscriptionCommand::stopMonitoringMimeType(const QString &val)
{
    mStopMonitoringMimeTypes << val;
    auto it = std::find(mStartMonitoringMimeTypes.begin(), mStartMonitoringMimeTypes.end(), val);
    if (it != mStartMonitoringMimeTypes.end()) {
        mStartMonitoringMimeTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::MimeTypes);
}

void ModifySubscriptionCommand::startMonitoringMimeType(const QString &val)
{
    mStartMonitoringMimeTypes << val;
    auto it = std::find(mStopMonitoringMimeTypes.begin(), mStopMonitoringMimeTypes.end(), val);
    if (it != mStopMonitoringMimeTypes.end()) {
        mStopMonitoringMimeTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::MimeTypes);
}

void ModifySubscriptionCommand::stopMonitoringResource(const QByteArray &val)
{
    mStopMonitoringResources << val;
    auto it = std::find(mStartMonitoringResources.begin(), mStartMonitoringResources.end(), val);
    if (it != mStartMonitoringResources.end()) {
        mStartMonitoringResources.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Resources);
}

void ModifySubscriptionCommand::startMonitoringResource(const QByteArray &val)
{
    mStartMonitoringResources << val;
    auto it = std::find(mStopMonitoringResources.begin(), mStopMonitoringResources.end(), val);
    if (it != mStopMonitoringResources.end()) {
        mStopMonitoringResources.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Resources);
}

void ModifySubscriptionCommand::stopMonitoringType(const ModifySubscriptionCommand::ChangeType &val)
{
    mStopMonitoringTypes << val;
    auto it = std::find(mStartMonitoringTypes.begin(), mStartMonitoringTypes.end(), val);
    if (it != mStartMonitoringTypes.end()) {
        mStartMonitoringTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Types);
}

void ModifySubscriptionCommand::startMonitoringType(const ModifySubscriptionCommand::ChangeType &val)
{
    mStartMonitoringTypes << val;
    auto it = std::find(mStopMonitoringTypes.begin(), mStopMonitoringTypes.end(), val);
    if (it != mStopMonitoringTypes.end()) {
        mStopMonitoringTypes.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Types);
}

void ModifySubscriptionCommand::stopMonitoringTag(const qint64 &val)
{
    mStopMonitoringTags << val;
    auto it = std::find(mStartMonitoringTags.begin(), mStartMonitoringTags.end(), val);
    if (it != mStartMonitoringTags.end()) {
        mStartMonitoringTags.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Tags);
}

void ModifySubscriptionCommand::startMonitoringTag(const qint64 &val)
{
    mStartMonitoringTags << val;
    auto it = std::find(mStopMonitoringTags.begin(), mStopMonitoringTags.end(), val);
    if (it != mStopMonitoringTags.end()) {
        mStopMonitoringTags.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Tags);
}

void ModifySubscriptionCommand::stopMonitoringItem(const qint64 &val)
{
    mStopMonitoringItems << val;
    auto it = std::find(mStartMonitoringItems.begin(), mStartMonitoringItems.end(), val);
    if (it != mStartMonitoringItems.end()) {
        mStartMonitoringItems.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Items);
}

void ModifySubscriptionCommand::startMonitoringItem(const qint64 &val)
{
    mStartMonitoringItems << val;
    auto it = std::find(mStopMonitoringItems.begin(), mStopMonitoringItems.end(), val);
    if (it != mStopMonitoringItems.end()) {
        mStopMonitoringItems.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Items);
}

void ModifySubscriptionCommand::stopMonitoringCollection(const qint64 &val)
{
    mStopMonitoringCollections << val;
    auto it = std::find(mStartMonitoringCollections.begin(), mStartMonitoringCollections.end(), val);
    if (it != mStartMonitoringCollections.end()) {
        mStartMonitoringCollections.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Remove | ModifySubscriptionCommand::Collections);
}

void ModifySubscriptionCommand::startMonitoringCollection(const qint64 &val)
{
    mStartMonitoringCollections << val;
    auto it = std::find(mStopMonitoringCollections.begin(), mStopMonitoringCollections.end(), val);
    if (it != mStopMonitoringCollections.end()) {
        mStopMonitoringCollections.erase(it);
    }
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::Add | ModifySubscriptionCommand::Collections);
}

void ModifySubscriptionCommand::setItemFetchScope(const Akonadi::Protocol::ItemFetchScope &val)
{
    mItemFetchScope = val;
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::ItemFetchScope);
}

void ModifySubscriptionCommand::setCollectionFetchScope(const Akonadi::Protocol::CollectionFetchScope &val)
{
    mCollectionFetchScope = val;
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::CollectionFetchScope);
}

void ModifySubscriptionCommand::setTagFetchScope(const Akonadi::Protocol::TagFetchScope &val)
{
    mTagFetchScope = val;
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::TagFetchScope);
}

void ModifySubscriptionCommand::setAllMonitored(bool val)
{
    mAllMonitored = val;
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::AllFlag);
}

void ModifySubscriptionCommand::setIsExclusive(bool val)
{
    mIsExclusive = val;
    mModifiedParts |= ModifySubscriptionCommand::ModifiedParts(ModifySubscriptionCommand::ExclusiveFlag);
}

DataStream &operator<<(DataStream &stream, const ModifySubscriptionCommand &obj)
{
    stream << static_cast<const Command &>(obj);
    stream << obj.mModifiedParts;
    stream << obj.mSubscriberName;
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::ExclusiveFlag)) {
        stream << obj.mIsExclusive;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::AllFlag)) {
        stream << obj.mAllMonitored;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::TagFetchScope)) {
        stream << obj.mTagFetchScope;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::CollectionFetchScope)) {
        stream << obj.mCollectionFetchScope;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::ItemFetchScope)) {
        stream << obj.mItemFetchScope;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream << obj.mStartIgnoringSessions;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream << obj.mStopIgnoringSessions;
    }
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifySubscriptionCommand &obj)
{
    stream >> static_cast<Command &>(obj);
    stream >> obj.mModifiedParts;
    stream >> obj.mSubscriberName;
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::ExclusiveFlag)) {
        stream >> obj.mIsExclusive;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::AllFlag)) {
        stream >> obj.mAllMonitored;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::TagFetchScope)) {
        stream >> obj.mTagFetchScope;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::CollectionFetchScope)) {
        stream >> obj.mCollectionFetchScope;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::ItemFetchScope)) {
        stream >> obj.mItemFetchScope;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Collections) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringCollections;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Items) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringItems;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Tags) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringTags;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Types) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Resources) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringResources;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::MimeTypes) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopMonitoringMimeTypes;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Add)) {
        stream >> obj.mStartIgnoringSessions;
    }
    if ((obj.mModifiedParts & ModifySubscriptionCommand::Sessions) && (obj.mModifiedParts & ModifySubscriptionCommand::Remove)) {
        stream >> obj.mStopIgnoringSessions;
    }
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifySubscriptionCommand &obj)
{
    dbg.noquote() << static_cast<const Command &>(obj)
        << "modifiedParts:" << obj.mModifiedParts << "\n"
        << "subscriberName:" << obj.mSubscriberName << "\n"
        << "startMonitoringTags: [\n";
    for (const auto &type : std::as_const(obj.mStartMonitoringTags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "isExclusive:" << obj.mIsExclusive << "\n"
        << "allMonitored:" << obj.mAllMonitored << "\n"
        << "tagFetchScope:" << obj.mTagFetchScope << "\n"
        << "collectionFetchScope:" << obj.mCollectionFetchScope << "\n"
        << "itemFetchScope:" << obj.mItemFetchScope << "\n"
        << "startMonitoringCollections: [\n";
    for (const auto &type : std::as_const(obj.mStartMonitoringCollections)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "stopMonitoringCollections: [\n";
    for (const auto &type : std::as_const(obj.mStopMonitoringCollections)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "startMonitoringItems: [\n";
    for (const auto &type : std::as_const(obj.mStartMonitoringItems)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "stopMonitoringItems: [\n";
    for (const auto &type : std::as_const(obj.mStopMonitoringItems)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "stopMonitoringTags: [\n";
    for (const auto &type : std::as_const(obj.mStopMonitoringTags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "startMonitoringTypes: [\n";
    for (const auto &type : std::as_const(obj.mStartMonitoringTypes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "stopMonitoringTypes: [\n";
    for (const auto &type : std::as_const(obj.mStopMonitoringTypes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "startMonitoringResources: [\n";
    for (const auto &type : std::as_const(obj.mStartMonitoringResources)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "stopMonitoringResources: [\n";
    for (const auto &type : std::as_const(obj.mStopMonitoringResources)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "startMonitoringMimeTypes:" << obj.mStartMonitoringMimeTypes << "\n"
        << "stopMonitoringMimeTypes:" << obj.mStopMonitoringMimeTypes << "\n"
        << "startIgnoringSessions: [\n";
    for (const auto &type : std::as_const(obj.mStartIgnoringSessions)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "stopIgnoringSessions: [\n";
    for (const auto &type : std::as_const(obj.mStopIgnoringSessions)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
    ;
    return dbg;
}

void ModifySubscriptionCommand::toJson(QJsonObject &json) const
{
    static_cast<const Command *>(this)->toJson(json);
    json[QStringLiteral("modifiedParts")] = static_cast<int>(mModifiedParts);/* ModifySubscriptionCommand::ModifiedParts*/
    json[QStringLiteral("subscriberName")] = QString::fromUtf8(mSubscriberName)/* QByteArray */;
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStartMonitoringTags)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("startMonitoringTags")] = jsonArray;
    }
    json[QStringLiteral("isExclusive")] = mIsExclusive;/* bool */
    json[QStringLiteral("allMonitored")] = mAllMonitored;/* bool */
    {
         QJsonObject jsonObject;
         mTagFetchScope.toJson(jsonObject); /* Akonadi::Protocol::TagFetchScope */
         json[QStringLiteral("tagFetchScope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mCollectionFetchScope.toJson(jsonObject); /* Akonadi::Protocol::CollectionFetchScope */
         json[QStringLiteral("collectionFetchScope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mItemFetchScope.toJson(jsonObject); /* Akonadi::Protocol::ItemFetchScope */
         json[QStringLiteral("itemFetchScope")] = jsonObject;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStartMonitoringCollections)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("startMonitoringCollections")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStopMonitoringCollections)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("stopMonitoringCollections")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStartMonitoringItems)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("startMonitoringItems")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStopMonitoringItems)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("stopMonitoringItems")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStopMonitoringTags)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("stopMonitoringTags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStartMonitoringTypes)) {
            jsonArray.append(type); /* ModifySubscriptionCommand::ChangeType */
        }
        json[QStringLiteral("startMonitoringTypes")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStopMonitoringTypes)) {
            jsonArray.append(type); /* ModifySubscriptionCommand::ChangeType */
        }
        json[QStringLiteral("stopMonitoringTypes")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStartMonitoringResources)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("startMonitoringResources")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStopMonitoringResources)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("stopMonitoringResources")] = jsonArray;
    }
    json[QStringLiteral("startMonitoringMimeTypes")] = QJsonArray::fromStringList(mStartMonitoringMimeTypes);/* QStringList */
    json[QStringLiteral("stopMonitoringMimeTypes")] = QJsonArray::fromStringList(mStopMonitoringMimeTypes);/* QStringList */
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStartIgnoringSessions)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("startIgnoringSessions")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mStopIgnoringSessions)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("stopIgnoringSessions")] = jsonArray;
    }
}



/************************* ModifySubscriptionResponse *************************/

ModifySubscriptionResponse::ModifySubscriptionResponse()
    : Response(Command::ModifySubscription)
{
}

bool ModifySubscriptionResponse::operator==(const ModifySubscriptionResponse &other) const
{
    return true // simplifies generation
        && Response::operator==(other)
    ;
}

DataStream &operator<<(DataStream &stream, const ModifySubscriptionResponse &obj)
{
    stream << static_cast<const Response &>(obj);
    return stream;
}

DataStream &operator>>(DataStream &stream, ModifySubscriptionResponse &obj)
{
    stream >> static_cast<Response &>(obj);
    return stream;
}

QDebug operator<<(QDebug dbg, const ModifySubscriptionResponse &obj)
{
    dbg.noquote() << static_cast<const Response &>(obj)
    ;
    return dbg;
}

void ModifySubscriptionResponse::toJson(QJsonObject &json) const
{
    static_cast<const Response *>(this)->toJson(json);
}



/************************* SubscriptionChangeNotification *************************/

SubscriptionChangeNotification::SubscriptionChangeNotification()
    : ChangeNotification(Command::SubscriptionChangeNotification)
{
}

bool SubscriptionChangeNotification::operator==(const SubscriptionChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && mSubscriber == other.mSubscriber
        && containerComparator(mCollections, other.mCollections)
        && containerComparator(mItems, other.mItems)
        && containerComparator(mTags, other.mTags)
        && containerComparator(mTypes, other.mTypes)
        && containerComparator(mMimeTypes, other.mMimeTypes)
        && containerComparator(mResources, other.mResources)
        && containerComparator(mIgnoredSessions, other.mIgnoredSessions)
        && mOperation == other.mOperation
        && mItemFetchScope == other.mItemFetchScope
        && mTagFetchScope == other.mTagFetchScope
        && mCollectionFetchScope == other.mCollectionFetchScope
        && mAllMonitored == other.mAllMonitored
        && mExclusive == other.mExclusive
    ;
}

DataStream &operator<<(DataStream &stream, const SubscriptionChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mSubscriber;
    stream << obj.mCollections;
    stream << obj.mItems;
    stream << obj.mTags;
    stream << obj.mTypes;
    stream << obj.mMimeTypes;
    stream << obj.mResources;
    stream << obj.mIgnoredSessions;
    stream << obj.mOperation;
    stream << obj.mItemFetchScope;
    stream << obj.mTagFetchScope;
    stream << obj.mCollectionFetchScope;
    stream << obj.mAllMonitored;
    stream << obj.mExclusive;
    return stream;
}

DataStream &operator>>(DataStream &stream, SubscriptionChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mSubscriber;
    stream >> obj.mCollections;
    stream >> obj.mItems;
    stream >> obj.mTags;
    stream >> obj.mTypes;
    stream >> obj.mMimeTypes;
    stream >> obj.mResources;
    stream >> obj.mIgnoredSessions;
    stream >> obj.mOperation;
    stream >> obj.mItemFetchScope;
    stream >> obj.mTagFetchScope;
    stream >> obj.mCollectionFetchScope;
    stream >> obj.mAllMonitored;
    stream >> obj.mExclusive;
    return stream;
}

QDebug operator<<(QDebug dbg, const SubscriptionChangeNotification &obj)
{
    dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "subscriber:" << obj.mSubscriber << "\n"
        << "collections: [\n";
    for (const auto &type : std::as_const(obj.mCollections)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "items: [\n";
    for (const auto &type : std::as_const(obj.mItems)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "tags: [\n";
    for (const auto &type : std::as_const(obj.mTags)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "types: [\n";
    for (const auto &type : std::as_const(obj.mTypes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "mimeTypes: [\n";
    for (const auto &type : std::as_const(obj.mMimeTypes)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "resources: [\n";
    for (const auto &type : std::as_const(obj.mResources)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "ignoredSessions: [\n";
    for (const auto &type : std::as_const(obj.mIgnoredSessions)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "operation:" << obj.mOperation << "\n"
        << "itemFetchScope:" << obj.mItemFetchScope << "\n"
        << "tagFetchScope:" << obj.mTagFetchScope << "\n"
        << "collectionFetchScope:" << obj.mCollectionFetchScope << "\n"
        << "allMonitored:" << obj.mAllMonitored << "\n"
        << "exclusive:" << obj.mExclusive << "\n"
    ;
    return dbg;
}

void SubscriptionChangeNotification::toJson(QJsonObject &json) const
{
    static_cast<const ChangeNotification *>(this)->toJson(json);
    json[QStringLiteral("subscriber")] = QString::fromUtf8(mSubscriber)/* QByteArray */;
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mCollections)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("collections")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mItems)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("items")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mTags)) {
            jsonArray.append(type); /* qint64 */
        }
        json[QStringLiteral("tags")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mTypes)) {
            jsonArray.append(type); /* ModifySubscriptionCommand::ChangeType */
        }
        json[QStringLiteral("types")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mMimeTypes)) {
            jsonArray.append(type); /* QString */
        }
        json[QStringLiteral("mimeTypes")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mResources)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("resources")] = jsonArray;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mIgnoredSessions)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("ignoredSessions")] = jsonArray;
    }
    json[QStringLiteral("operation")] = mOperation;/* SubscriptionChangeNotification::Operation*/
    {
         QJsonObject jsonObject;
         mItemFetchScope.toJson(jsonObject); /* Akonadi::Protocol::ItemFetchScope */
         json[QStringLiteral("itemFetchScope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mTagFetchScope.toJson(jsonObject); /* Akonadi::Protocol::TagFetchScope */
         json[QStringLiteral("tagFetchScope")] = jsonObject;
    }
    {
         QJsonObject jsonObject;
         mCollectionFetchScope.toJson(jsonObject); /* Akonadi::Protocol::CollectionFetchScope */
         json[QStringLiteral("collectionFetchScope")] = jsonObject;
    }
    json[QStringLiteral("allMonitored")] = mAllMonitored;/* bool */
    json[QStringLiteral("exclusive")] = mExclusive;/* bool */
}



/************************* DebugChangeNotification *************************/

DebugChangeNotification::DebugChangeNotification()
    : ChangeNotification(Command::DebugChangeNotification)
{
}

bool DebugChangeNotification::operator==(const DebugChangeNotification &other) const
{
    return true // simplifies generation
        && ChangeNotification::operator==(other)
        && *mNotification == *other.mNotification
        && containerComparator(mListeners, other.mListeners)
        && mTimestamp == other.mTimestamp
    ;
}

DataStream &operator<<(DataStream &stream, const DebugChangeNotification &obj)
{
    stream << static_cast<const ChangeNotification &>(obj);
    stream << obj.mNotification;
    stream << obj.mListeners;
    stream << obj.mTimestamp;
    return stream;
}

DataStream &operator>>(DataStream &stream, DebugChangeNotification &obj)
{
    stream >> static_cast<ChangeNotification &>(obj);
    stream >> obj.mNotification;
    stream >> obj.mListeners;
    stream >> obj.mTimestamp;
    return stream;
}

QDebug operator<<(QDebug dbg, const DebugChangeNotification &obj)
{
    dbg.noquote() << static_cast<const ChangeNotification &>(obj)
        << "notification:" << *obj.mNotification << "\n"
        << "listeners: [\n";
    for (const auto &type : std::as_const(obj.mListeners)) {
        dbg.noquote() << "    " << type << "\n";
    }
    dbg.noquote() << "]\n"
        << "timestamp:" << obj.mTimestamp << "\n"
    ;
    return dbg;
}

void DebugChangeNotification::toJson(QJsonObject &json) const
{
    static_cast<const ChangeNotification *>(this)->toJson(json);
    {
        QJsonObject jsonObject;
        mNotification->toJson(jsonObject);
        json[QStringLiteral("notification")] = jsonObject;
    }
    {
        QJsonArray jsonArray;
        for (const auto &type : std::as_const(mListeners)) {
            jsonArray.append(QString::fromUtf8(type)); /* QByteArray*/
        }
        json[QStringLiteral("listeners")] = jsonArray;
    }
    json[QStringLiteral("timestamp")] = mTimestamp;/* qint64 */
}

} // namespace Protocol
} // namespace Akonadi
