/* Generated by wayland-scanner 1.22.0 */

#ifndef SURFACE_EXTENSION_SERVER_PROTOCOL_H
#define SURFACE_EXTENSION_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_surface_extension The surface_extension protocol
 * @section page_ifaces_surface_extension Interfaces
 * - @subpage page_iface_qt_surface_extension - 
 * - @subpage page_iface_qt_extended_surface - 
 * @section page_copyright_surface_extension Copyright
 * <pre>
 *
 * This file is part of the plugins of the Qt Toolkit.
 * SPDX-FileCopyrightText: 2012 Digia Plc and/or its subsidiary(-ies).
 * Contact: http://www.qt-project.org/legal
 *
 * SPDX-License-Identifier: BSD-3-Clause
 * </pre>
 */
struct qt_extended_surface;
struct qt_surface_extension;
struct wl_surface;

#ifndef QT_SURFACE_EXTENSION_INTERFACE
#define QT_SURFACE_EXTENSION_INTERFACE
/**
 * @page page_iface_qt_surface_extension qt_surface_extension
 * @section page_iface_qt_surface_extension_api API
 * See @ref iface_qt_surface_extension.
 */
/**
 * @defgroup iface_qt_surface_extension The qt_surface_extension interface
 */
extern const struct wl_interface qt_surface_extension_interface;
#endif
#ifndef QT_EXTENDED_SURFACE_INTERFACE
#define QT_EXTENDED_SURFACE_INTERFACE
/**
 * @page page_iface_qt_extended_surface qt_extended_surface
 * @section page_iface_qt_extended_surface_api API
 * See @ref iface_qt_extended_surface.
 */
/**
 * @defgroup iface_qt_extended_surface The qt_extended_surface interface
 */
extern const struct wl_interface qt_extended_surface_interface;
#endif

/**
 * @ingroup iface_qt_surface_extension
 * @struct qt_surface_extension_interface
 */
struct qt_surface_extension_interface {
	/**
	 */
	void (*get_extended_surface)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t id,
				     struct wl_resource *surface);
};


/**
 * @ingroup iface_qt_surface_extension
 */
#define QT_SURFACE_EXTENSION_GET_EXTENDED_SURFACE_SINCE_VERSION 1

#ifndef QT_EXTENDED_SURFACE_ORIENTATION_ENUM
#define QT_EXTENDED_SURFACE_ORIENTATION_ENUM
enum qt_extended_surface_orientation {
	QT_EXTENDED_SURFACE_ORIENTATION_PRIMARYORIENTATION = 0,
	QT_EXTENDED_SURFACE_ORIENTATION_PORTRAITORIENTATION = 1,
	QT_EXTENDED_SURFACE_ORIENTATION_LANDSCAPEORIENTATION = 2,
	QT_EXTENDED_SURFACE_ORIENTATION_INVERTEDPORTRAITORIENTATION = 4,
	QT_EXTENDED_SURFACE_ORIENTATION_INVERTEDLANDSCAPEORIENTATION = 8,
};
#endif /* QT_EXTENDED_SURFACE_ORIENTATION_ENUM */

#ifndef QT_EXTENDED_SURFACE_WINDOWFLAG_ENUM
#define QT_EXTENDED_SURFACE_WINDOWFLAG_ENUM
enum qt_extended_surface_windowflag {
	QT_EXTENDED_SURFACE_WINDOWFLAG_OVERRIDESSYSTEMGESTURES = 1,
	QT_EXTENDED_SURFACE_WINDOWFLAG_STAYSONTOP = 2,
	QT_EXTENDED_SURFACE_WINDOWFLAG_BYPASSWINDOWMANAGER = 4,
};
#endif /* QT_EXTENDED_SURFACE_WINDOWFLAG_ENUM */

/**
 * @ingroup iface_qt_extended_surface
 * @struct qt_extended_surface_interface
 */
struct qt_extended_surface_interface {
	/**
	 */
	void (*update_generic_property)(struct wl_client *client,
					struct wl_resource *resource,
					const char *name,
					struct wl_array *value);
	/**
	 */
	void (*set_content_orientation_mask)(struct wl_client *client,
					     struct wl_resource *resource,
					     int32_t orientation);
	/**
	 */
	void (*set_window_flags)(struct wl_client *client,
				 struct wl_resource *resource,
				 int32_t flags);
	/**
	 */
	void (*raise)(struct wl_client *client,
		      struct wl_resource *resource);
	/**
	 */
	void (*lower)(struct wl_client *client,
		      struct wl_resource *resource);
};

#define QT_EXTENDED_SURFACE_ONSCREEN_VISIBILITY 0
#define QT_EXTENDED_SURFACE_SET_GENERIC_PROPERTY 1
#define QT_EXTENDED_SURFACE_CLOSE 2

/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_ONSCREEN_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_SET_GENERIC_PROPERTY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_CLOSE_SINCE_VERSION 1

/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_UPDATE_GENERIC_PROPERTY_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_SET_CONTENT_ORIENTATION_MASK_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_SET_WINDOW_FLAGS_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_RAISE_SINCE_VERSION 1
/**
 * @ingroup iface_qt_extended_surface
 */
#define QT_EXTENDED_SURFACE_LOWER_SINCE_VERSION 1

/**
 * @ingroup iface_qt_extended_surface
 * Sends an onscreen_visibility event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_extended_surface_send_onscreen_visibility(struct wl_resource *resource_, int32_t visible)
{
	wl_resource_post_event(resource_, QT_EXTENDED_SURFACE_ONSCREEN_VISIBILITY, visible);
}

/**
 * @ingroup iface_qt_extended_surface
 * Sends an set_generic_property event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_extended_surface_send_set_generic_property(struct wl_resource *resource_, const char *name, struct wl_array *value)
{
	wl_resource_post_event(resource_, QT_EXTENDED_SURFACE_SET_GENERIC_PROPERTY, name, value);
}

/**
 * @ingroup iface_qt_extended_surface
 * Sends an close event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_extended_surface_send_close(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, QT_EXTENDED_SURFACE_CLOSE);
}

#ifdef  __cplusplus
}
#endif

#endif
