// This file is generated by kconfig_compiler_kf5 from kamosoSettings.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

#include <QStandardPaths>

class Settings : public KConfigSkeleton
{
  Q_OBJECT
  public:

    static Settings *self();
    ~Settings() override;

    /**
      Set Where the photos are saved.
    */
    static
    void setSaveUrl( const QUrl & v )
    {
      if (v != self()->mSaveUrl && !self()->isSaveUrlImmutable()) {
        self()->mSaveUrl = v;
        Q_EMIT self()->saveUrlChanged();
      }
    }

    Q_PROPERTY(QUrl saveUrl READ saveUrl WRITE setSaveUrl NOTIFY saveUrlChanged)
    Q_PROPERTY(bool isSaveUrlImmutable READ isSaveUrlImmutable CONSTANT)
    /**
      Get Where the photos are saved.
    */
    static
    QUrl saveUrl()
    {
      return self()->mSaveUrl;
    }

    /**
      Is Where the photos are saved. Immutable
    */
    static
    bool isSaveUrlImmutable()
    {
      return self()->isImmutable( QStringLiteral( "saveUrl" ) );
    }

    /**
      Set Where the photos are saved.
    */
    static
    void setSaveVideos( const QUrl & v )
    {
      if (v != self()->mSaveVideos && !self()->isSaveVideosImmutable()) {
        self()->mSaveVideos = v;
        Q_EMIT self()->saveVideosChanged();
      }
    }

    Q_PROPERTY(QUrl saveVideos READ saveVideos WRITE setSaveVideos NOTIFY saveVideosChanged)
    Q_PROPERTY(bool isSaveVideosImmutable READ isSaveVideosImmutable CONSTANT)
    /**
      Get Where the photos are saved.
    */
    static
    QUrl saveVideos()
    {
      return self()->mSaveVideos;
    }

    /**
      Is Where the photos are saved. Immutable
    */
    static
    bool isSaveVideosImmutable()
    {
      return self()->isImmutable( QStringLiteral( "saveVideos" ) );
    }

    /**
      Set Vertically mirror the camera view.
    */
    static
    void setMirrored( bool v )
    {
      if (v != self()->mMirrored && !self()->isMirroredImmutable()) {
        self()->mMirrored = v;
        Q_EMIT self()->mirroredChanged();
      }
    }

    Q_PROPERTY(bool mirrored READ mirrored WRITE setMirrored NOTIFY mirroredChanged)
    Q_PROPERTY(bool isMirroredImmutable READ isMirroredImmutable CONSTANT)
    /**
      Get Vertically mirror the camera view.
    */
    static
    bool mirrored()
    {
      return self()->mMirrored;
    }

    /**
      Is Vertically mirror the camera view. Immutable
    */
    static
    bool isMirroredImmutable()
    {
      return self()->isImmutable( QStringLiteral( "mirrored" ) );
    }

    /**
      Set Points to the last used webcam.
    */
    static
    void setDeviceObjectId( const QString & v )
    {
      if (v != self()->mDeviceObjectId && !self()->isDeviceObjectIdImmutable()) {
        self()->mDeviceObjectId = v;
        Q_EMIT self()->DeviceObjectIdChanged();
      }
    }

    Q_PROPERTY(QString deviceObjectId READ deviceObjectId WRITE setDeviceObjectId NOTIFY DeviceObjectIdChanged)
    Q_PROPERTY(bool isDeviceObjectIdImmutable READ isDeviceObjectIdImmutable CONSTANT)
    /**
      Get Points to the last used webcam.
    */
    static
    QString deviceObjectId()
    {
      return self()->mDeviceObjectId;
    }

    /**
      Is Points to the last used webcam. Immutable
    */
    static
    bool isDeviceObjectIdImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DeviceObjectId" ) );
    }


    enum {
      signalSaveUrlChanged = 1,
      signalSaveVideosChanged = 2,
      signalMirroredChanged = 3,
      signalDeviceObjectIdChanged = 4
    };

  Q_SIGNALS:
    void saveUrlChanged();

    void saveVideosChanged();

    void mirroredChanged();

    void DeviceObjectIdChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    Settings();
    friend class SettingsHelper;


    // General
    QUrl mSaveUrl;
    QUrl mSaveVideos;

    // WebcamSettings
    bool mMirrored;
    QString mDeviceObjectId;

  private:
};

#endif

