// This file is generated by kconfig_compiler_kf6 from kalarmconfig.kcfg.
// All changes you do to this file will be lost.
#ifndef PREFERENCESBASE_H
#define PREFERENCESBASE_H

#include <kalarm_debug.h>

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>
#include <QSet>

#include "lib/timeperiod.h"
#include "lib/locale.h"
#include <QFontDatabase>
#include <KColorScheme>
#include <QFont>
#include <QColor>
#include <qnamespace.h>

class PreferencesBase : public KConfigSkeleton
{
  Q_OBJECT
  public:
    enum Backend { Kresources, Akonadi, FileResources };
    enum MailClient { sendmail, kmail };
    enum DisplayMethod { Display_Window, Display_Notification };
    enum SoundType { Sound_None, Sound_Beep, Sound_File, Sound_Speak };
    enum CmdLogType { Log_Discard, Log_File, Log_Terminal };
    enum RecurType { Recur_None, Recur_Login, Recur_SubDaily, Recur_Daily, Recur_Weekly, Recur_Monthly, Recur_Yearly };
    enum Feb29Type { Feb29_Feb28, Feb29_Mar1, Feb29_None };

    static PreferencesBase *self();
    ~PreferencesBase() override;

    /**
      Set KAlarm version
    */
    static
    void setVersion( const QString & v )
    {
      if (!self()->isVersionImmutable())
        self()->mVersion = v;
    }

    /**
      Get KAlarm version
    */
    static
    QString version()
    {
      return self()->mVersion;
    }

    /**
      Is KAlarm version Immutable
    */
    static
    bool isVersionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Version" ) );
    }

    /**
      Set Data storage backend
    */
    static
    void setBackend( Backend v )
    {
      if (!self()->isBackendImmutable())
        self()->mBackend = v;
    }

    /**
      Get Data storage backend
    */
    static
    Backend backend()
    {
      return static_cast<Backend>(self()->mBackend);
    }

    /**
      Is Data storage backend Immutable
    */
    static
    bool isBackendImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Backend" ) );
    }

    /**
      Set Enable Akonadi plugin
    */
    static
    void setUseAkonadiIfAvailable( bool v )
    {
      if (!self()->isUseAkonadiIfAvailableImmutable())
        self()->mUseAkonadiIfAvailable = v;
    }

    /**
      Get Enable Akonadi plugin
    */
    static
    bool useAkonadiIfAvailable()
    {
      return self()->mUseAkonadiIfAvailable;
    }

    /**
      Is Enable Akonadi plugin Immutable
    */
    static
    bool isUseAkonadiIfAvailableImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseAkonadiIfAvailable" ) );
    }

    /**
      Set Time zone
    */
    static
    void setBase_TimeZone( const QString & v )
    {
      if (v != self()->mBase_TimeZone && !self()->isBase_TimeZoneImmutable()) {
        self()->mBase_TimeZone = v;
        self()->mSettingsChanged.insert(signalBase_TimeZoneChanged);
      }
    }

    /**
      Get Time zone
    */
    static
    QString base_TimeZone()
    {
      return self()->mBase_TimeZone;
    }

    /**
      Is Time zone Immutable
    */
    static
    bool isBase_TimeZoneImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_TimeZone" ) );
    }

    /**
      Set Holiday region
    */
    static
    void setBase_HolidayRegion( const QString & v )
    {
      if (v != self()->mBase_HolidayRegion && !self()->isBase_HolidayRegionImmutable()) {
        self()->mBase_HolidayRegion = v;
        self()->mSettingsChanged.insert(signalBase_HolidayRegionChanged);
      }
    }

    /**
      Get Holiday region
    */
    static
    QString base_HolidayRegion()
    {
      return self()->mBase_HolidayRegion;
    }

    /**
      Is Holiday region Immutable
    */
    static
    bool isBase_HolidayRegionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_HolidayRegion" ) );
    }

    /**
      Set Foreground color
    */
    static
    void setDefaultFgColour( const QColor & v )
    {
      if (!self()->isDefaultFgColourImmutable())
        self()->mDefaultFgColour = v;
    }

    /**
      Get Foreground color
    */
    static
    QColor defaultFgColour()
    {
      return self()->mDefaultFgColour;
    }

    /**
      Is Foreground color Immutable
    */
    static
    bool isDefaultFgColourImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultFgColour" ) );
    }

    /**
      Set Background color
    */
    static
    void setDefaultBgColour( const QColor & v )
    {
      if (!self()->isDefaultBgColourImmutable())
        self()->mDefaultBgColour = v;
    }

    /**
      Get Background color
    */
    static
    QColor defaultBgColour()
    {
      return self()->mDefaultBgColour;
    }

    /**
      Is Background color Immutable
    */
    static
    bool isDefaultBgColourImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultBgColour" ) );
    }

    /**
      Set Enable alarm names
    */
    static
    void setUseAlarmName( bool v )
    {
      if (v != self()->mUseAlarmName && !self()->isUseAlarmNameImmutable()) {
        self()->mUseAlarmName = v;
        self()->mSettingsChanged.insert(signalUseAlarmNameChanged);
      }
    }

    /**
      Get Enable alarm names
    */
    static
    bool useAlarmName()
    {
      return self()->mUseAlarmName;
    }

    /**
      Is Enable alarm names Immutable
    */
    static
    bool isUseAlarmNameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "UseAlarmName" ) );
    }

    /**
      Set Message font
    */
    static
    void setMessageFont( const QFont & v )
    {
      if (v != self()->mMessageFont && !self()->isMessageFontImmutable()) {
        self()->mMessageFont = v;
        self()->mSettingsChanged.insert(signalMessageFontChanged);
      }
    }

    /**
      Get Message font
    */
    static
    QFont messageFont()
    {
      return self()->mMessageFont;
    }

    /**
      Is Message font Immutable
    */
    static
    bool isMessageFontImmutable()
    {
      return self()->isImmutable( QStringLiteral( "MessageFont" ) );
    }

    /**
      Set Show in system tray
    */
    static
    void setShowInSystemTray( bool v )
    {
      if (v != self()->mShowInSystemTray && !self()->isShowInSystemTrayImmutable()) {
        self()->mShowInSystemTray = v;
        self()->mSettingsChanged.insert(signalShowInSystemTrayChanged);
      }
    }

    /**
      Get Show in system tray
    */
    static
    bool showInSystemTray()
    {
      return self()->mShowInSystemTray;
    }

    /**
      Is Show in system tray Immutable
    */
    static
    bool isShowInSystemTrayImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowInSystemTray" ) );
    }

    /**
      Set Auto-hide in system tray if no alarms due within period
    */
    static
    void setBase_AutoHideSystemTray( int v )
    {
      if (v != self()->mBase_AutoHideSystemTray && !self()->isBase_AutoHideSystemTrayImmutable()) {
        self()->mBase_AutoHideSystemTray = v;
        self()->mSettingsChanged.insert(signalAutoHideSystemTrayChanged);
      }
    }

    /**
      Get Auto-hide in system tray if no alarms due within period
    */
    static
    int base_AutoHideSystemTray()
    {
      return self()->mBase_AutoHideSystemTray;
    }

    /**
      Is Auto-hide in system tray if no alarms due within period Immutable
    */
    static
    bool isBase_AutoHideSystemTrayImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_AutoHideSystemTray" ) );
    }

    /**
      Set Desktops without auto-hide in system tray
    */
    static
    void setNoAutoHideSystemTrayDesktops( const QStringList & v )
    {
      if (!self()->isNoAutoHideSystemTrayDesktopsImmutable())
        self()->mNoAutoHideSystemTrayDesktops = v;
    }

    /**
      Get Desktops without auto-hide in system tray
    */
    static
    QStringList noAutoHideSystemTrayDesktops()
    {
      return self()->mNoAutoHideSystemTrayDesktops;
    }

    /**
      Is Desktops without auto-hide in system tray Immutable
    */
    static
    bool isNoAutoHideSystemTrayDesktopsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "NoAutoHideSystemTrayDesktops" ) );
    }

    /**
      Set Start at login
    */
    static
    void setAutoStart( bool v )
    {
      if (!self()->isAutoStartImmutable())
        self()->mAutoStart = v;
    }

    /**
      Get Start at login
    */
    static
    bool autoStart()
    {
      return self()->mAutoStart;
    }

    /**
      Is Start at login Immutable
    */
    static
    bool isAutoStartImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AutoStart" ) );
    }

    /**
      Set Suppress autostart at login
    */
    static
    void setBase_NoAutoStart( bool v )
    {
      if (!self()->isBase_NoAutoStartImmutable())
        self()->mBase_NoAutoStart = v;
    }

    /**
      Get Suppress autostart at login
    */
    static
    bool base_NoAutoStart()
    {
      return self()->mBase_NoAutoStart;
    }

    /**
      Is Suppress autostart at login Immutable
    */
    static
    bool isBase_NoAutoStartImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_NoAutoStart" ) );
    }

    /**
      Set Default defer time interval
    */
    static
    void setDefaultDeferTime( int v )
    {
      if (!self()->isDefaultDeferTimeImmutable())
        self()->mDefaultDeferTime = v;
    }

    /**
      Get Default defer time interval
    */
    static
    int defaultDeferTime()
    {
      return self()->mDefaultDeferTime;
    }

    /**
      Is Default defer time interval Immutable
    */
    static
    bool isDefaultDeferTimeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultDeferTime" ) );
    }

    /**
      Set Prompt for which calendar to store in
    */
    static
    void setAskResource( bool v )
    {
      if (!self()->isAskResourceImmutable())
        self()->mAskResource = v;
    }

    /**
      Get Prompt for which calendar to store in
    */
    static
    bool askResource()
    {
      return self()->mAskResource;
    }

    /**
      Is Prompt for which calendar to store in Immutable
    */
    static
    bool isAskResourceImmutable()
    {
      return self()->isImmutable( QStringLiteral( "AskResource" ) );
    }

    /**
      Set Message windows have a title bar and take keyboard focus
    */
    static
    void setBase_ModalMessages( bool v )
    {
      if (!self()->isBase_ModalMessagesImmutable())
        self()->mBase_ModalMessages = v;
    }

    /**
      Get Message windows have a title bar and take keyboard focus
    */
    static
    bool base_ModalMessages()
    {
      return self()->mBase_ModalMessages;
    }

    /**
      Is Message windows have a title bar and take keyboard focus Immutable
    */
    static
    bool isBase_ModalMessagesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_ModalMessages" ) );
    }

    /**
      Set Delay before message window buttons are enabled
    */
    static
    void setBase_MessageButtonDelay( int v )
    {
      if (v < -1)
      {
        qCDebug(KALARM_LOG) << "setBase_MessageButtonDelay: value " << v << " is less than the minimum value of -1";
        v = -1;
      }

      if (v > 10)
      {
        qCDebug(KALARM_LOG) << "setBase_MessageButtonDelay: value " << v << " is greater than the maximum value of 10";
        v = 10;
      }

      if (!self()->isBase_MessageButtonDelayImmutable())
        self()->mBase_MessageButtonDelay = v;
    }

    /**
      Get Delay before message window buttons are enabled
    */
    static
    int base_MessageButtonDelay()
    {
      return self()->mBase_MessageButtonDelay;
    }

    /**
      Is Delay before message window buttons are enabled Immutable
    */
    static
    bool isBase_MessageButtonDelayImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_MessageButtonDelay" ) );
    }

    /**
      Set Number of alarms to show in system tray tooltip
    */
    static
    void setTooltipAlarmCount( int v )
    {
      if (v != self()->mTooltipAlarmCount && !self()->isTooltipAlarmCountImmutable()) {
        self()->mTooltipAlarmCount = v;
        self()->mSettingsChanged.insert(signalTooltipPreferencesChanged);
      }
    }

    /**
      Get Number of alarms to show in system tray tooltip
    */
    static
    int tooltipAlarmCount()
    {
      return self()->mTooltipAlarmCount;
    }

    /**
      Is Number of alarms to show in system tray tooltip Immutable
    */
    static
    bool isTooltipAlarmCountImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TooltipAlarmCount" ) );
    }

    /**
      Set Show alarm times in system tray tooltip
    */
    static
    void setShowTooltipAlarmTime( bool v )
    {
      if (v != self()->mShowTooltipAlarmTime && !self()->isShowTooltipAlarmTimeImmutable()) {
        self()->mShowTooltipAlarmTime = v;
        self()->mSettingsChanged.insert(signalTooltipPreferencesChanged);
      }
    }

    /**
      Get Show alarm times in system tray tooltip
    */
    static
    bool showTooltipAlarmTime()
    {
      return self()->mShowTooltipAlarmTime;
    }

    /**
      Is Show alarm times in system tray tooltip Immutable
    */
    static
    bool isShowTooltipAlarmTimeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowTooltipAlarmTime" ) );
    }

    /**
      Set Show time to alarms in system tray tooltip
    */
    static
    void setShowTooltipTimeToAlarm( bool v )
    {
      if (v != self()->mShowTooltipTimeToAlarm && !self()->isShowTooltipTimeToAlarmImmutable()) {
        self()->mShowTooltipTimeToAlarm = v;
        self()->mSettingsChanged.insert(signalTooltipPreferencesChanged);
      }
    }

    /**
      Get Show time to alarms in system tray tooltip
    */
    static
    bool showTooltipTimeToAlarm()
    {
      return self()->mShowTooltipTimeToAlarm;
    }

    /**
      Is Show time to alarms in system tray tooltip Immutable
    */
    static
    bool isShowTooltipTimeToAlarmImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowTooltipTimeToAlarm" ) );
    }

    /**
      Set Time-to-alarm prefix in system tray tooltip
    */
    static
    void setTooltipTimeToPrefix( const QString & v )
    {
      if (v != self()->mTooltipTimeToPrefix && !self()->isTooltipTimeToPrefixImmutable()) {
        self()->mTooltipTimeToPrefix = v;
        self()->mSettingsChanged.insert(signalTooltipPreferencesChanged);
      }
    }

    /**
      Get Time-to-alarm prefix in system tray tooltip
    */
    static
    QString tooltipTimeToPrefix()
    {
      return self()->mTooltipTimeToPrefix;
    }

    /**
      Is Time-to-alarm prefix in system tray tooltip Immutable
    */
    static
    bool isTooltipTimeToPrefixImmutable()
    {
      return self()->isImmutable( QStringLiteral( "TooltipTimeToPrefix" ) );
    }

    /**
      Set Email client
    */
    static
    void setBase_EmailClient( MailClient v )
    {
      if (!self()->isBase_EmailClientImmutable())
        self()->mBase_EmailClient = v;
    }

    /**
      Get Email client
    */
    static
    MailClient base_EmailClient()
    {
      return static_cast<MailClient>(self()->mBase_EmailClient);
    }

    /**
      Is Email client Immutable
    */
    static
    bool isBase_EmailClientImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_EmailClient" ) );
    }

    /**
      Set Whether to copy sent emails into KMail's Sent folder.
    */
    static
    void setBase_EmailCopyToKMail( bool v )
    {
      if (!self()->isBase_EmailCopyToKMailImmutable())
        self()->mBase_EmailCopyToKMail = v;
    }

    /**
      Get Whether to copy sent emails into KMail's Sent folder.
    */
    static
    bool base_EmailCopyToKMail()
    {
      return self()->mBase_EmailCopyToKMail;
    }

    /**
      Is Whether to copy sent emails into KMail's Sent folder. Immutable
    */
    static
    bool isBase_EmailCopyToKMailImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_EmailCopyToKMail" ) );
    }

    /**
      Set 'From' email address
    */
    static
    void setBase_EmailFrom( const QString & v )
    {
      if (!self()->isBase_EmailFromImmutable())
        self()->mBase_EmailFrom = v;
    }

    /**
      Get 'From' email address
    */
    static
    QString base_EmailFrom()
    {
      return self()->mBase_EmailFrom;
    }

    /**
      Is 'From' email address Immutable
    */
    static
    bool isBase_EmailFromImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_EmailFrom" ) );
    }

    /**
      Set 'Bcc' email address
    */
    static
    void setBase_EmailBccAddress( const QString & v )
    {
      if (!self()->isBase_EmailBccAddressImmutable())
        self()->mBase_EmailBccAddress = v;
    }

    /**
      Get 'Bcc' email address
    */
    static
    QString base_EmailBccAddress()
    {
      return self()->mBase_EmailBccAddress;
    }

    /**
      Is 'Bcc' email address Immutable
    */
    static
    bool isBase_EmailBccAddressImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_EmailBccAddress" ) );
    }

    /**
      Set Terminal for command alarms
    */
    static
    void setBase_CmdXTermCommand( const QString & v )
    {
      if (!self()->isBase_CmdXTermCommandImmutable())
        self()->mBase_CmdXTermCommand = v;
    }

    /**
      Get Terminal for command alarms
    */
    static
    QString base_CmdXTermCommand()
    {
      return self()->mBase_CmdXTermCommand;
    }

    /**
      Is Terminal for command alarms Immutable
    */
    static
    bool isBase_CmdXTermCommandImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_CmdXTermCommand" ) );
    }

    /**
      Set Start of day for date-only alarms
    */
    static
    void setBase_StartOfDay( const QDateTime & v )
    {
      if (v != self()->mBase_StartOfDay && !self()->isBase_StartOfDayImmutable()) {
        self()->mBase_StartOfDay = v;
        self()->mSettingsChanged.insert(signalBase_StartOfDayChanged);
      }
    }

    /**
      Get Start of day for date-only alarms
    */
    static
    QDateTime base_StartOfDay()
    {
      return self()->mBase_StartOfDay;
    }

    /**
      Is Start of day for date-only alarms Immutable
    */
    static
    bool isBase_StartOfDayImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_StartOfDay" ) );
    }

    /**
      Set Start time of working day
    */
    static
    void setBase_WorkDayStart( const QDateTime & v )
    {
      if (v != self()->mBase_WorkDayStart && !self()->isBase_WorkDayStartImmutable()) {
        self()->mBase_WorkDayStart = v;
        self()->mSettingsChanged.insert(signalBase_WorkTimeChanged);
      }
    }

    /**
      Get Start time of working day
    */
    static
    QDateTime base_WorkDayStart()
    {
      return self()->mBase_WorkDayStart;
    }

    /**
      Is Start time of working day Immutable
    */
    static
    bool isBase_WorkDayStartImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_WorkDayStart" ) );
    }

    /**
      Set End time of working day
    */
    static
    void setBase_WorkDayEnd( const QDateTime & v )
    {
      if (v != self()->mBase_WorkDayEnd && !self()->isBase_WorkDayEndImmutable()) {
        self()->mBase_WorkDayEnd = v;
        self()->mSettingsChanged.insert(signalBase_WorkTimeChanged);
      }
    }

    /**
      Get End time of working day
    */
    static
    QDateTime base_WorkDayEnd()
    {
      return self()->mBase_WorkDayEnd;
    }

    /**
      Is End time of working day Immutable
    */
    static
    bool isBase_WorkDayEndImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_WorkDayEnd" ) );
    }

    /**
      Set Working days
    */
    static
    void setBase_WorkDays( uint v )
    {
      if (v != self()->mBase_WorkDays && !self()->isBase_WorkDaysImmutable()) {
        self()->mBase_WorkDays = v;
        self()->mSettingsChanged.insert(signalBase_WorkTimeChanged);
      }
    }

    /**
      Get Working days
    */
    static
    uint base_WorkDays()
    {
      return self()->mBase_WorkDays;
    }

    /**
      Is Working days Immutable
    */
    static
    bool isBase_WorkDaysImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_WorkDays" ) );
    }

    /**
      Set Disabled alarm color
    */
    static
    void setDisabledColour( const QColor & v )
    {
      if (v != self()->mDisabledColour && !self()->isDisabledColourImmutable()) {
        self()->mDisabledColour = v;
        self()->mSettingsChanged.insert(signalDisabledColourChanged);
      }
    }

    /**
      Get Disabled alarm color
    */
    static
    QColor disabledColour()
    {
      return self()->mDisabledColour;
    }

    /**
      Is Disabled alarm color Immutable
    */
    static
    bool isDisabledColourImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DisabledColour" ) );
    }

    /**
      Set Archived alarm color
    */
    static
    void setArchivedColour( const QColor & v )
    {
      if (v != self()->mArchivedColour && !self()->isArchivedColourImmutable()) {
        self()->mArchivedColour = v;
        self()->mSettingsChanged.insert(signalArchivedColourChanged);
      }
    }

    /**
      Get Archived alarm color
    */
    static
    QColor archivedColour()
    {
      return self()->mArchivedColour;
    }

    /**
      Is Archived alarm color Immutable
    */
    static
    bool isArchivedColourImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ArchivedColour" ) );
    }

    /**
      Set Days to keep expired alarms
    */
    static
    void setArchivedKeepDays( int v )
    {
      if (v != self()->mArchivedKeepDays && !self()->isArchivedKeepDaysImmutable()) {
        self()->mArchivedKeepDays = v;
        self()->mSettingsChanged.insert(signalArchivedKeepDaysChanged);
      }
    }

    /**
      Get Days to keep expired alarms
    */
    static
    int archivedKeepDays()
    {
      return self()->mArchivedKeepDays;
    }

    /**
      Is Days to keep expired alarms Immutable
    */
    static
    bool isArchivedKeepDaysImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ArchivedKeepDays" ) );
    }

    /**
      Set KOrganizer event duration
    */
    static
    void setKOrgEventDuration( int v )
    {
      if (!self()->isKOrgEventDurationImmutable())
        self()->mKOrgEventDuration = v;
    }

    /**
      Get KOrganizer event duration
    */
    static
    int kOrgEventDuration()
    {
      return self()->mKOrgEventDuration;
    }

    /**
      Is KOrganizer event duration Immutable
    */
    static
    bool isKOrgEventDurationImmutable()
    {
      return self()->isImmutable( QStringLiteral( "KOrgEventDuration" ) );
    }

    /**
      Set Number of minutes before alarm to wake from suspend
    */
    static
    void setWakeFromSuspendAdvance( uint v )
    {
      if (v != self()->mWakeFromSuspendAdvance && !self()->isWakeFromSuspendAdvanceImmutable()) {
        self()->mWakeFromSuspendAdvance = v;
        self()->mSettingsChanged.insert(signalWakeFromSuspendAdvanceChanged);
      }
    }

    /**
      Get Number of minutes before alarm to wake from suspend
    */
    static
    uint wakeFromSuspendAdvance()
    {
      return self()->mWakeFromSuspendAdvance;
    }

    /**
      Is Number of minutes before alarm to wake from suspend Immutable
    */
    static
    bool isWakeFromSuspendAdvanceImmutable()
    {
      return self()->isImmutable( QStringLiteral( "WakeFromSuspendAdvance" ) );
    }

    /**
      Set ShowMenuBar
    */
    static
    void setShowMenuBar( bool v )
    {
      if (!self()->isShowMenuBarImmutable())
        self()->mShowMenuBar = v;
    }

    /**
      Get ShowMenuBar
    */
    static
    bool showMenuBar()
    {
      return self()->mShowMenuBar;
    }

    /**
      Is ShowMenuBar Immutable
    */
    static
    bool isShowMenuBarImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ShowMenuBar" ) );
    }

    /**
      Set Alarm message display method
    */
    static
    void setDefaultDisplayMethod( DisplayMethod v )
    {
      if (!self()->isDefaultDisplayMethodImmutable())
        self()->mDefaultDisplayMethod = v;
    }

    /**
      Get Alarm message display method
    */
    static
    DisplayMethod defaultDisplayMethod()
    {
      return static_cast<DisplayMethod>(self()->mDefaultDisplayMethod);
    }

    /**
      Is Alarm message display method Immutable
    */
    static
    bool isDefaultDisplayMethodImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultDisplayMethod" ) );
    }

    /**
      Set Cancel if late (minutes)
    */
    static
    void setDefaultLateCancel( int v )
    {
      if (v < 0)
      {
        qCDebug(KALARM_LOG) << "setDefaultLateCancel: value " << v << " is less than the minimum value of 0";
        v = 0;
      }
      if (!self()->isDefaultLateCancelImmutable())
        self()->mDefaultLateCancel = v;
    }

    /**
      Get Cancel if late (minutes)
    */
    static
    int defaultLateCancel()
    {
      return self()->mDefaultLateCancel;
    }

    /**
      Is Cancel if late (minutes) Immutable
    */
    static
    bool isDefaultLateCancelImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultLateCancel" ) );
    }

    /**
      Set Auto-close window after late-cancellation time
    */
    static
    void setDefaultAutoClose( bool v )
    {
      if (!self()->isDefaultAutoCloseImmutable())
        self()->mDefaultAutoClose = v;
    }

    /**
      Get Auto-close window after late-cancellation time
    */
    static
    bool defaultAutoClose()
    {
      return self()->mDefaultAutoClose;
    }

    /**
      Is Auto-close window after late-cancellation time Immutable
    */
    static
    bool isDefaultAutoCloseImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultAutoClose" ) );
    }

    /**
      Set Confirm acknowledgement
    */
    static
    void setDefaultConfirmAck( bool v )
    {
      if (!self()->isDefaultConfirmAckImmutable())
        self()->mDefaultConfirmAck = v;
    }

    /**
      Get Confirm acknowledgement
    */
    static
    bool defaultConfirmAck()
    {
      return self()->mDefaultConfirmAck;
    }

    /**
      Is Confirm acknowledgement Immutable
    */
    static
    bool isDefaultConfirmAckImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultConfirmAck" ) );
    }

    /**
      Set Show in KOrganizer
    */
    static
    void setDefaultCopyToKOrganizer( bool v )
    {
      if (!self()->isDefaultCopyToKOrganizerImmutable())
        self()->mDefaultCopyToKOrganizer = v;
    }

    /**
      Get Show in KOrganizer
    */
    static
    bool defaultCopyToKOrganizer()
    {
      return self()->mDefaultCopyToKOrganizer;
    }

    /**
      Is Show in KOrganizer Immutable
    */
    static
    bool isDefaultCopyToKOrganizerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultCopyToKOrganizer" ) );
    }

    /**
      Set Sound
    */
    static
    void setBase_DefaultSoundType( SoundType v )
    {
      if (!self()->isBase_DefaultSoundTypeImmutable())
        self()->mBase_DefaultSoundType = v;
    }

    /**
      Get Sound
    */
    static
    SoundType base_DefaultSoundType()
    {
      return static_cast<SoundType>(self()->mBase_DefaultSoundType);
    }

    /**
      Is Sound Immutable
    */
    static
    bool isBase_DefaultSoundTypeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_DefaultSoundType" ) );
    }

    /**
      Set Sound file
    */
    static
    void setDefaultSoundFile( const QString & v )
    {
      if (!self()->isDefaultSoundFileImmutable())
        self()->mDefaultSoundFile = v;
    }

    /**
      Get Sound file
    */
    static
    QString defaultSoundFile()
    {
      return self()->mDefaultSoundFile;
    }

    /**
      Is Sound file Immutable
    */
    static
    bool isDefaultSoundFileImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultSoundFile" ) );
    }

    /**
      Set Sound volume
    */
    static
    void setBase_DefaultSoundVolume( int v )
    {
      if (v < -1)
      {
        qCDebug(KALARM_LOG) << "setBase_DefaultSoundVolume: value " << v << " is less than the minimum value of -1";
        v = -1;
      }

      if (v > 100)
      {
        qCDebug(KALARM_LOG) << "setBase_DefaultSoundVolume: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (!self()->isBase_DefaultSoundVolumeImmutable())
        self()->mBase_DefaultSoundVolume = v;
    }

    /**
      Get Sound volume
    */
    static
    int base_DefaultSoundVolume()
    {
      return self()->mBase_DefaultSoundVolume;
    }

    /**
      Is Sound volume Immutable
    */
    static
    bool isBase_DefaultSoundVolumeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_DefaultSoundVolume" ) );
    }

    /**
      Set Repeat sound file
    */
    static
    void setDefaultSoundRepeat( bool v )
    {
      if (!self()->isDefaultSoundRepeatImmutable())
        self()->mDefaultSoundRepeat = v;
    }

    /**
      Get Repeat sound file
    */
    static
    bool defaultSoundRepeat()
    {
      return self()->mDefaultSoundRepeat;
    }

    /**
      Is Repeat sound file Immutable
    */
    static
    bool isDefaultSoundRepeatImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultSoundRepeat" ) );
    }

    /**
      Set Enter script
    */
    static
    void setDefaultCmdScript( bool v )
    {
      if (!self()->isDefaultCmdScriptImmutable())
        self()->mDefaultCmdScript = v;
    }

    /**
      Get Enter script
    */
    static
    bool defaultCmdScript()
    {
      return self()->mDefaultCmdScript;
    }

    /**
      Is Enter script Immutable
    */
    static
    bool isDefaultCmdScriptImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultCmdScript" ) );
    }

    /**
      Set Command output
    */
    static
    void setDefaultCmdLogType( CmdLogType v )
    {
      if (!self()->isDefaultCmdLogTypeImmutable())
        self()->mDefaultCmdLogType = v;
    }

    /**
      Get Command output
    */
    static
    CmdLogType defaultCmdLogType()
    {
      return static_cast<CmdLogType>(self()->mDefaultCmdLogType);
    }

    /**
      Is Command output Immutable
    */
    static
    bool isDefaultCmdLogTypeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultCmdLogType" ) );
    }

    /**
      Set Log file
    */
    static
    void setDefaultCmdLogFile( const QString & v )
    {
      if (!self()->isDefaultCmdLogFileImmutable())
        self()->mDefaultCmdLogFile = v;
    }

    /**
      Get Log file
    */
    static
    QString defaultCmdLogFile()
    {
      return self()->mDefaultCmdLogFile;
    }

    /**
      Is Log file Immutable
    */
    static
    bool isDefaultCmdLogFileImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultCmdLogFile" ) );
    }

    /**
      Set Copy email to self
    */
    static
    void setDefaultEmailBcc( bool v )
    {
      if (!self()->isDefaultEmailBccImmutable())
        self()->mDefaultEmailBcc = v;
    }

    /**
      Get Copy email to self
    */
    static
    bool defaultEmailBcc()
    {
      return self()->mDefaultEmailBcc;
    }

    /**
      Is Copy email to self Immutable
    */
    static
    bool isDefaultEmailBccImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultEmailBcc" ) );
    }

    /**
      Set Recurrence period
    */
    static
    void setDefaultRecurPeriod( RecurType v )
    {
      if (!self()->isDefaultRecurPeriodImmutable())
        self()->mDefaultRecurPeriod = v;
    }

    /**
      Get Recurrence period
    */
    static
    RecurType defaultRecurPeriod()
    {
      return static_cast<RecurType>(self()->mDefaultRecurPeriod);
    }

    /**
      Is Recurrence period Immutable
    */
    static
    bool isDefaultRecurPeriodImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultRecurPeriod" ) );
    }

    /**
      Set In non-leap years, repeat yearly February 29th alarms on:
    */
    static
    void setDefaultFeb29Type( Feb29Type v )
    {
      if (v != self()->mDefaultFeb29Type && !self()->isDefaultFeb29TypeImmutable()) {
        self()->mDefaultFeb29Type = v;
        self()->mSettingsChanged.insert(signalFeb29TypeChanged);
      }
    }

    /**
      Get In non-leap years, repeat yearly February 29th alarms on:
    */
    static
    Feb29Type defaultFeb29Type()
    {
      return static_cast<Feb29Type>(self()->mDefaultFeb29Type);
    }

    /**
      Is In non-leap years, repeat yearly February 29th alarms on: Immutable
    */
    static
    bool isDefaultFeb29TypeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultFeb29Type" ) );
    }

    /**
      Set Reminder units
    */
    static
    void setDefaultReminderUnits( TimePeriod::Units v )
    {
      if (!self()->isDefaultReminderUnitsImmutable())
        self()->mDefaultReminderUnits = v;
    }

    /**
      Get Reminder units
    */
    static
    TimePeriod::Units defaultReminderUnits()
    {
      return static_cast<TimePeriod::Units>(self()->mDefaultReminderUnits);
    }

    /**
      Is Reminder units Immutable
    */
    static
    bool isDefaultReminderUnitsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultReminderUnits" ) );
    }

    /**
      Set Pre-alarm action
    */
    static
    void setDefaultPreAction( const QString & v )
    {
      if (!self()->isDefaultPreActionImmutable())
        self()->mDefaultPreAction = v;
    }

    /**
      Get Pre-alarm action
    */
    static
    QString defaultPreAction()
    {
      return self()->mDefaultPreAction;
    }

    /**
      Is Pre-alarm action Immutable
    */
    static
    bool isDefaultPreActionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultPreAction" ) );
    }

    /**
      Set Execute pre-alarm action for deferred alarms
    */
    static
    void setDefaultExecPreActionOnDeferral( bool v )
    {
      if (!self()->isDefaultExecPreActionOnDeferralImmutable())
        self()->mDefaultExecPreActionOnDeferral = v;
    }

    /**
      Get Execute pre-alarm action for deferred alarms
    */
    static
    bool defaultExecPreActionOnDeferral()
    {
      return self()->mDefaultExecPreActionOnDeferral;
    }

    /**
      Is Execute pre-alarm action for deferred alarms Immutable
    */
    static
    bool isDefaultExecPreActionOnDeferralImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultExecPreActionOnDeferral" ) );
    }

    /**
      Set Cancel alarm on pre-alarm action error
    */
    static
    void setDefaultCancelOnPreActionError( bool v )
    {
      if (!self()->isDefaultCancelOnPreActionErrorImmutable())
        self()->mDefaultCancelOnPreActionError = v;
    }

    /**
      Get Cancel alarm on pre-alarm action error
    */
    static
    bool defaultCancelOnPreActionError()
    {
      return self()->mDefaultCancelOnPreActionError;
    }

    /**
      Is Cancel alarm on pre-alarm action error Immutable
    */
    static
    bool isDefaultCancelOnPreActionErrorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultCancelOnPreActionError" ) );
    }

    /**
      Set Do not notify pre-alarm action errors
    */
    static
    void setDefaultDontShowPreActionError( bool v )
    {
      if (!self()->isDefaultDontShowPreActionErrorImmutable())
        self()->mDefaultDontShowPreActionError = v;
    }

    /**
      Get Do not notify pre-alarm action errors
    */
    static
    bool defaultDontShowPreActionError()
    {
      return self()->mDefaultDontShowPreActionError;
    }

    /**
      Is Do not notify pre-alarm action errors Immutable
    */
    static
    bool isDefaultDontShowPreActionErrorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultDontShowPreActionError" ) );
    }

    /**
      Set Post-alarm action
    */
    static
    void setDefaultPostAction( const QString & v )
    {
      if (!self()->isDefaultPostActionImmutable())
        self()->mDefaultPostAction = v;
    }

    /**
      Get Post-alarm action
    */
    static
    QString defaultPostAction()
    {
      return self()->mDefaultPostAction;
    }

    /**
      Is Post-alarm action Immutable
    */
    static
    bool isDefaultPostActionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "DefaultPostAction" ) );
    }

    /**
      Set Warn before quitting
    */
    static
    void setBase_QuitWarn( bool v )
    {
      if (!self()->isBase_QuitWarnImmutable())
        self()->mBase_QuitWarn = v;
    }

    /**
      Get Warn before quitting
    */
    static
    bool base_QuitWarn()
    {
      return self()->mBase_QuitWarn;
    }

    /**
      Is Warn before quitting Immutable
    */
    static
    bool isBase_QuitWarnImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_QuitWarn" ) );
    }

    /**
      Set Confirm alarm deletions
    */
    static
    void setBase_ConfirmAlarmDeletion( bool v )
    {
      if (!self()->isBase_ConfirmAlarmDeletionImmutable())
        self()->mBase_ConfirmAlarmDeletion = v;
    }

    /**
      Get Confirm alarm deletions
    */
    static
    bool base_ConfirmAlarmDeletion()
    {
      return self()->mBase_ConfirmAlarmDeletion;
    }

    /**
      Is Confirm alarm deletions Immutable
    */
    static
    bool isBase_ConfirmAlarmDeletionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_ConfirmAlarmDeletion" ) );
    }

    /**
      Set Notify when remote emails are queued
    */
    static
    void setBase_EmailQueuedNotify( bool v )
    {
      if (!self()->isBase_EmailQueuedNotifyImmutable())
        self()->mBase_EmailQueuedNotify = v;
    }

    /**
      Get Notify when remote emails are queued
    */
    static
    bool base_EmailQueuedNotify()
    {
      return self()->mBase_EmailQueuedNotify;
    }

    /**
      Is Notify when remote emails are queued Immutable
    */
    static
    bool isBase_EmailQueuedNotifyImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Base_EmailQueuedNotify" ) );
    }


    enum {
      signalShowInSystemTrayChanged = 1,
      signalAutoHideSystemTrayChanged = 2,
      signalBase_TimeZoneChanged = 3,
      signalBase_HolidayRegionChanged = 4,
      signalBase_StartOfDayChanged = 5,
      signalBase_WorkTimeChanged = 6,
      signalUseAlarmNameChanged = 7,
      signalMessageFontChanged = 8,
      signalDisabledColourChanged = 9,
      signalArchivedColourChanged = 10,
      signalArchivedKeepDaysChanged = 11,
      signalWakeFromSuspendAdvanceChanged = 12,
      signalFeb29TypeChanged = 13,
      signalTooltipPreferencesChanged = 14
    };

  Q_SIGNALS:
    void showInSystemTrayChanged(bool ShowInSystemTray);

    void autoHideSystemTrayChanged(int Base_AutoHideSystemTray);

    void base_TimeZoneChanged(const QString & Base_TimeZone);

    void base_HolidayRegionChanged(const QString & Base_HolidayRegion);

    void base_StartOfDayChanged(const QDateTime & Base_StartOfDay);

    void base_WorkTimeChanged(const QDateTime & Base_WorkDayStart, const QDateTime & Base_WorkDayEnd, int Base_WorkDays);

    void useAlarmNameChanged(bool UseAlarmName);

    void messageFontChanged(const QFont & MessageFont);

    void disabledColourChanged(const QColor & DisabledColour);

    void archivedColourChanged(const QColor & ArchivedColour);

    void archivedKeepDaysChanged(int ArchivedKeepDays);

    void wakeFromSuspendAdvanceChanged(uint WakeFromSuspendAdvance);

    void feb29TypeChanged(Feb29Type DefaultFeb29Type);

    void tooltipPreferencesChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    PreferencesBase();
    friend class PreferencesBaseHelper;

    bool usrSave() override;
  protected:

    // General
    QString mVersion;
    int mBackend;
    bool mUseAkonadiIfAvailable;
    QString mBase_TimeZone;
    QString mBase_HolidayRegion;
    QColor mDefaultFgColour;
    QColor mDefaultBgColour;
    bool mUseAlarmName;
    QFont mMessageFont;
    bool mShowInSystemTray;
    int mBase_AutoHideSystemTray;
    QStringList mNoAutoHideSystemTrayDesktops;
    bool mAutoStart;
    bool mBase_NoAutoStart;
    int mDefaultDeferTime;
    bool mAskResource;
    bool mBase_ModalMessages;
    int mBase_MessageButtonDelay;
    int mTooltipAlarmCount;
    bool mShowTooltipAlarmTime;
    bool mShowTooltipTimeToAlarm;
    QString mTooltipTimeToPrefix;
    int mBase_EmailClient;
    bool mBase_EmailCopyToKMail;
    QString mBase_EmailFrom;
    QString mBase_EmailBccAddress;
    QString mBase_CmdXTermCommand;
    QDateTime mBase_StartOfDay;
    QDateTime mBase_WorkDayStart;
    QDateTime mBase_WorkDayEnd;
    uint mBase_WorkDays;
    QColor mDisabledColour;
    QColor mArchivedColour;
    int mArchivedKeepDays;
    int mKOrgEventDuration;
    uint mWakeFromSuspendAdvance;
    bool mShowMenuBar;

    // Defaults
    int mDefaultDisplayMethod;
    int mDefaultLateCancel;
    bool mDefaultAutoClose;
    bool mDefaultConfirmAck;
    bool mDefaultCopyToKOrganizer;
    int mBase_DefaultSoundType;
    QString mDefaultSoundFile;
    int mBase_DefaultSoundVolume;
    bool mDefaultSoundRepeat;
    bool mDefaultCmdScript;
    int mDefaultCmdLogType;
    QString mDefaultCmdLogFile;
    bool mDefaultEmailBcc;
    int mDefaultRecurPeriod;
    int mDefaultFeb29Type;
    int mDefaultReminderUnits;
    QString mDefaultPreAction;
    bool mDefaultExecPreActionOnDeferral;
    bool mDefaultCancelOnPreActionError;
    bool mDefaultDontShowPreActionError;
    QString mDefaultPostAction;

    // Notification Messages
    bool mBase_QuitWarn;
    bool mBase_ConfirmAlarmDeletion;
    bool mBase_EmailQueuedNotify;

  private:
    QSet<quint64> mSettingsChanged;
};

#endif

