/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_mtlgt3.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_mtlgt3.h"

static void
mtlgt3_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "1124d1b6-6182-4b5a-950b-27b38ef7c996";
    metric_set->counters = calloc(38, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__render_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__render_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__render_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__render_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__render_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__render_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__render_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__render_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = mtlgt3__render_basic__gti_read_throughput__read;
    counter->max_uint64 = mtlgt3__render_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = mtlgt3__render_basic__gti_write_throughput__read;
    counter->max_uint64 = mtlgt3__render_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__render_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__render_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__render_basic__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EM Pipe Active";
    counter->symbol_name = "PsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__ps_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS FPU Pipe Active";
    counter->symbol_name = "PsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__ps_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Send Pipe Active";
    counter->symbol_name = "PsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__ps_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__render_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__render_basic__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Bottleneck";
        counter->symbol_name = "SamplerBottleneck";
        counter->desc = "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__render_basic__sampler_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = mtlgt3__render_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = mtlgt3__render_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Input");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Busy";
        counter->symbol_name = "SamplersBusy";
        counter->desc = "The percentage of time in which samplers or L1 cache are not idle.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__render_basic__samplers_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__render_basic__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__render_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__render_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__render_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/Atomics");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__render_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Barrier");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__render_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmReads";
    counter->desc = "The total number of reads from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__render_basic__slm_reads__read;
    counter->max_uint64 = mtlgt3__render_basic__slm_reads__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Writes";
    counter->symbol_name = "SlmWrites";
    counter->desc = "The total number of writes into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__render_basic__slm_writes__read;
    counter->max_uint64 = mtlgt3__render_basic__slm_writes__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EM Pipe Active";
    counter->symbol_name = "VsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__vs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS FPU Pipe Active";
    counter->symbol_name = "VsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__vs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Send Pipe Active";
    counter->symbol_name = "VsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__vs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__render_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM And FPU Pipes Active";
    counter->symbol_name = "XveFpuEmActive";
    counter->desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__xve_fpu_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_basic__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    assert(metric_set->n_counters <= 38);
}

static void
mtlgt3_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "522743d7-4e01-461a-8600-7904e8ddc80c";
    metric_set->counters = calloc(39, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__compute_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__compute_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__compute_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__compute_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__compute_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM Pipe Active";
    counter->symbol_name = "EmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE FPU Pipe Active";
    counter->symbol_name = "FpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__compute_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__compute_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__compute_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = mtlgt3__compute_basic__gti_read_throughput__read;
    counter->max_uint64 = mtlgt3__compute_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = mtlgt3__compute_basic__gti_write_throughput__read;
    counter->max_uint64 = mtlgt3__compute_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__compute_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__compute_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__compute_basic__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__compute_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__compute_basic__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = mtlgt3__compute_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = mtlgt3__compute_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Input");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__compute_basic__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__compute_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = mtlgt3__compute_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Send Pipe Active";
    counter->symbol_name = "SendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__compute_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/Atomics");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__compute_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Barrier");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__compute_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmReads";
    counter->desc = "The total number of reads from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__compute_basic__slm_reads__read;
    counter->max_uint64 = mtlgt3__compute_basic__slm_reads__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Writes";
    counter->symbol_name = "SlmWrites";
    counter->desc = "The total number of writes into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = mtlgt3__compute_basic__slm_writes__read;
    counter->max_uint64 = mtlgt3__compute_basic__slm_writes__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__compute_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XMX Pipe Active";
    counter->symbol_name = "XmxActive";
    counter->desc = "The percentage of time in which XVE XMX pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xmx_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE AVG IPC Rate";
    counter->symbol_name = "XveAvgIpcRate";
    counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER;
    counter->read_float = mtlgt3__compute_basic__xve_avg_ipc_rate__read;
    counter->max_float = mtlgt3__compute_basic__xve_avg_ipc_rate__max;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM And FPU Pipes Active";
    counter->symbol_name = "XveFpuEmActive";
    counter->desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_fpu_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT16 Instruction";
    counter->symbol_name = "XveFpuFlt16";
    counter->desc = "The percentage of time in which FLT16 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_fpu_flt16__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT32 Instruction";
    counter->symbol_name = "XveFpuFlt32";
    counter->desc = "The percentage of time in which FLT32 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_fpu_flt32__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT64 Instruction";
    counter->symbol_name = "XveFpuFlt64";
    counter->desc = "The percentage of time in which FLT64 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_fpu_flt64__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XMX And FPU Pipes Active";
    counter->symbol_name = "XveFpuXmxActive";
    counter->desc = "The percentage of time in which XVE XMX and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_fpu_xmx_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__compute_basic__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    assert(metric_set->n_counters <= 39);
}

static void
mtlgt3_add_async_compute_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AsyncCompute";
    metric_set->symbol_name = "AsyncCompute";
    metric_set->hw_config_guid = "d9edd254-60e8-4ce0-82b1-7b3de3bc79a6";
    metric_set->counters = calloc(23, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_async_compute_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ASYNC CS EM Pipe Active";
    counter->symbol_name = "AsyncCsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__async_cs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ASYNC CS FPU Pipe Active";
    counter->symbol_name = "AsyncCsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__async_cs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__async_compute__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__async_compute__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EM Pipe Active";
    counter->symbol_name = "CsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__cs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS FPU Pipe Active";
    counter->symbol_name = "CsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__cs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__async_compute__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__async_compute__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM Pipe Active";
    counter->symbol_name = "EmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE FPU Pipe Active";
    counter->symbol_name = "FpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__async_compute__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__async_compute__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__async_compute__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__async_compute__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EM Pipe Active";
    counter->symbol_name = "PsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__ps_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS FPU Pipe Active";
    counter->symbol_name = "PsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__ps_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__async_compute__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EM Pipe Active";
    counter->symbol_name = "VsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__vs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS FPU Pipe Active";
    counter->symbol_name = "VsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__vs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__async_compute__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__async_compute__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    assert(metric_set->n_counters <= 23);
}

static void
mtlgt3_add_xve_activity_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "XveActivity";
    metric_set->symbol_name = "XveActivity";
    metric_set->hw_config_guid = "703a9693-1444-4e7c-a235-1c4d6ee01943";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_xve_activity_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__xve_activity__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__xve_activity__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Send Pipe Active";
    counter->symbol_name = "CsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__cs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__xve_activity__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS EM Pipe Active";
    counter->symbol_name = "DsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__ds_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS FPU Pipe Active";
    counter->symbol_name = "DsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__ds_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Send Pipe Active";
    counter->symbol_name = "DsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__ds_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__xve_activity__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__xve_activity__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__xve_activity__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EM Pipe Active";
    counter->symbol_name = "GsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__gs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS FPU Pipe Active";
    counter->symbol_name = "GsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__gs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Send Pipe Active";
    counter->symbol_name = "GsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__gs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__xve_activity__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS EM Pipe Active";
    counter->symbol_name = "HsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__hs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS FPU Pipe Active";
    counter->symbol_name = "HsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__hs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Send Pipe Active";
    counter->symbol_name = "HsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__xve_activity__hs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__xve_activity__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__xve_activity__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__xve_activity__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 20);
}

static void
mtlgt3_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "GpuBusyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "edae72d3-bb06-47af-87b4-7585274c6076";
    metric_set->counters = calloc(16, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__gpu_busyness__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__gpu_busyness__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Blitter Ring Busy";
    counter->symbol_name = "BlitterBusy";
    counter->desc = "The percentage of time when blitter command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__gpu_busyness__blitter_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ComputeEngine0 Ring Busy";
    counter->symbol_name = "ComputeEngine0Busy";
    counter->desc = "The percentage of time when compute command streamer 0 was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__gpu_busyness__compute_engine0_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__gpu_busyness__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__gpu_busyness__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__gpu_busyness__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__gpu_busyness__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__gpu_busyness__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__gpu_busyness__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__gpu_busyness__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__gpu_busyness__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__gpu_busyness__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = mtlgt3__gpu_busyness__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__gpu_busyness__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__gpu_busyness__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__gpu_busyness__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    assert(metric_set->n_counters <= 16);
}

static void
mtlgt3_add_hdc_and_sf1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF1";
    metric_set->symbol_name = "HDCAndSF1";
    metric_set->hw_config_guid = "e1a408d6-aece-4bde-8bbd-1c7fbfff02cf";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_hdc_and_sf1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__hdc_and_sf1__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__hdc_and_sf1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__hdc_and_sf1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__hdc_and_sf1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__hdc_and_sf1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader00AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf1__non_sampler_shader00_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader01AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf1__non_sampler_shader01_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader02AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf1__non_sampler_shader02_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader03AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf1__non_sampler_shader03_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice0) Data Ready";
    counter->symbol_name = "Poly0DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__hdc_and_sf1__poly0_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe/Strip-Fans");

    assert(metric_set->n_counters <= 9);
}

static void
mtlgt3_add_hdc_and_sf2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF2";
    metric_set->symbol_name = "HDCAndSF2";
    metric_set->hw_config_guid = "374e8aa3-09df-4d69-ad32-3133f6ad3c86";
    metric_set->counters = calloc(9, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_hdc_and_sf2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__hdc_and_sf2__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__hdc_and_sf2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__hdc_and_sf2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__hdc_and_sf2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__hdc_and_sf2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader10AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf2__non_sampler_shader10_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader11AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf2__non_sampler_shader11_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader12AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf2__non_sampler_shader12_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader13AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__hdc_and_sf2__non_sampler_shader13_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice1) Data Ready";
    counter->symbol_name = "Poly1DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__hdc_and_sf2__poly1_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe/Strip-Fans");

    assert(metric_set->n_counters <= 9);
}

static void
mtlgt3_add_l3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3";
    metric_set->symbol_name = "L3";
    metric_set->hw_config_guid = "580d5311-4e9d-4210-b419-37259ffcd3f2";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_l3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__l3__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__l3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__l3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__l3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__l3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK0";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK0";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK1";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK1";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK2";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK2";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK3";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK3";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK4";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK4";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK5";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK5";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK6";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK6";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK7";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK7";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_input_available_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK0";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK0";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK1";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK1";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK2";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK2";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK3";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK3";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK4";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK4";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK5";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK5";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK6";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK6";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK7";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK7";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__l3__l3_output_ready_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 20);
}

static void
mtlgt3_add_rasterizer_and_pixel_backend1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend1";
    metric_set->symbol_name = "RasterizerAndPixelBackend1";
    metric_set->hw_config_guid = "4286bd8f-f9db-45e5-aa37-51dd7067f751";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_rasterizer_and_pixel_backend1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__rasterizer_and_pixel_backend1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__rasterizer_and_pixel_backend1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData00Ready";
    counter->desc = "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend1__pixel_data00_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData01Ready";
    counter->desc = "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend1__pixel_data01_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice1 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData10Ready";
    counter->desc = "The percentage of time in which slice1  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend1__pixel_data10_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice1 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData11Ready";
    counter->desc = "The percentage of time in which slice1  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend1__pixel_data11_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer/Early Depth Test");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer0InputAvailable";
        counter->desc = "The percentage of time in which slice0 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__rasterizer_and_pixel_backend1__rasterizer0_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer1InputAvailable";
        counter->desc = "The percentage of time in which slice1 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__rasterizer_and_pixel_backend1__rasterizer1_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer");
    }

    assert(metric_set->n_counters <= 10);
}

static void
mtlgt3_add_rasterizer_and_pixel_backend2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend2";
    metric_set->symbol_name = "RasterizerAndPixelBackend2";
    metric_set->hw_config_guid = "ac90f98d-14a6-4dcc-b5d7-31ee157bb6e2";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_rasterizer_and_pixel_backend2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__rasterizer_and_pixel_backend2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__rasterizer_and_pixel_backend2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS00 Output Available";
    counter->symbol_name = "PSOutput00Available";
    counter->desc = "The percentage of time in which PS00 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend2__ps_output00_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS01 Output Available";
    counter->symbol_name = "PSOutput01Available";
    counter->desc = "The percentage of time in which PS01 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend2__ps_output01_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 00 Ready";
    counter->symbol_name = "PixelValues00Ready";
    counter->desc = "The percentage of time in which pixel values 00 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend2__pixel_values00_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 01 Ready";
    counter->symbol_name = "PixelValues01Ready";
    counter->desc = "The percentage of time in which pixel values 01 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__rasterizer_and_pixel_backend2__pixel_values01_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer0OutputReady";
        counter->desc = "The percentage of time in which slice0 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__rasterizer_and_pixel_backend2__rasterizer0_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer1OutputReady";
        counter->desc = "The percentage of time in which slice1 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__rasterizer_and_pixel_backend2__rasterizer1_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer");
    }

    assert(metric_set->n_counters <= 10);
}

static void
mtlgt3_add_render_pipe_profile1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile1";
    metric_set->hw_config_guid = "f15b97f6-eb1b-43a8-839c-7bd956c143c4";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_render_pipe_profile1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__render_pipe_profile1__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__render_pipe_profile1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC00 Bottleneck";
    counter->symbol_name = "Bc00Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__bc00_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Barycentric Calc");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper0 Bottleneck";
    counter->symbol_name = "Cl0Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__cl0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Clipper");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL0 Stall";
    counter->symbol_name = "Cl0Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__cl0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Clipper");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS0 Bottleneck";
    counter->symbol_name = "Ds0Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__ds0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS0 Stall";
    counter->symbol_name = "Ds0Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__ds0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__render_pipe_profile1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__render_pipe_profile1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS0 Bottleneck";
    counter->symbol_name = "Gs0Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__gs0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth00 Bottleneck";
    counter->symbol_name = "HiDepth00Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__hi_depth00_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth01 Bottleneck";
    counter->symbol_name = "HiDepth01Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__hi_depth01_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS0 Bottleneck";
    counter->symbol_name = "Hs0Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__hs0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS0 Stall";
    counter->symbol_name = "Hs0Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__hs0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF0 Bottleneck";
    counter->symbol_name = "Sf0Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__sf0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Strip-Fans");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF0 Stall";
    counter->symbol_name = "Sf0Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__sf0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Strip-Fans");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO0 Bottleneck";
    counter->symbol_name = "So0Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__so0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Stream Output");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO0 Stall";
    counter->symbol_name = "So0Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__so0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Stream Output");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF0 Bottleneck";
    counter->symbol_name = "Vf0Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__vf0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Input Assembler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS0 Bottleneck";
    counter->symbol_name = "Vs0Bottleneck";
    counter->desc = "The percentage of time in which VS0 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile1__vs0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Vertex Shader");

    assert(metric_set->n_counters <= 20);
}

static void
mtlgt3_add_render_pipe_profile2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile2";
    metric_set->hw_config_guid = "86b9199d-8a44-4694-bbde-6fd35bada236";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_render_pipe_profile2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__render_pipe_profile2__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__render_pipe_profile2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC10 Bottleneck";
    counter->symbol_name = "Bc10Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__bc10_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Barycentric Calc");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper1 Bottleneck";
    counter->symbol_name = "Cl1Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__cl1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Clipper");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL1 Stall";
    counter->symbol_name = "Cl1Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__cl1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Clipper");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS1 Bottleneck";
    counter->symbol_name = "Ds1Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__ds1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS1 Stall";
    counter->symbol_name = "Ds1Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__ds1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__render_pipe_profile2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__render_pipe_profile2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS1 Bottleneck";
    counter->symbol_name = "Gs1Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__gs1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth10 Bottleneck";
    counter->symbol_name = "HiDepth10Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__hi_depth10_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth11 Bottleneck";
    counter->symbol_name = "HiDepth11Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__hi_depth11_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS1 Bottleneck";
    counter->symbol_name = "Hs1Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__hs1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS1 Stall";
    counter->symbol_name = "Hs1Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__hs1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF1 Bottleneck";
    counter->symbol_name = "Sf1Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__sf1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Strip-Fans");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF1 Stall";
    counter->symbol_name = "Sf1Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__sf1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Strip-Fans");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO1 Bottleneck";
    counter->symbol_name = "So1Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__so1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Stream Output");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO1 Stall";
    counter->symbol_name = "So1Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__so1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Stream Output");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF1 Bottleneck";
    counter->symbol_name = "Vf1Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__vf1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Input Assembler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS1 Bottleneck";
    counter->symbol_name = "Vs1Bottleneck";
    counter->desc = "The percentage of time in which VS1 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__render_pipe_profile2__vs1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Vertex Shader");

    assert(metric_set->n_counters <= 20);
}

static void
mtlgt3_add_sampler_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_Slice0";
    metric_set->symbol_name = "Sampler";
    metric_set->hw_config_guid = "ae70a69c-341d-492a-b703-afa08a3497ba";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_sampler_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__sampler__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__sampler__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__sampler__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__sampler__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__sampler__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core0 Input Available";
        counter->symbol_name = "Sampler00InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler00_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler00OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler00_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core1 Input Available";
        counter->symbol_name = "Sampler01InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler01_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler01OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler01_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core2 Input Available";
        counter->symbol_name = "Sampler02InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler02_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler02OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler02_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core3 Input Available";
        counter->symbol_name = "Sampler03InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler03_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler03OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler03_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core0 Input Available";
        counter->symbol_name = "Sampler10InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler10_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler10OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler10_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core1 Input Available";
        counter->symbol_name = "Sampler11InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler11_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler11OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler11_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core2 Input Available";
        counter->symbol_name = "Sampler12InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler12_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler12OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler12_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core3 Input Available";
        counter->symbol_name = "Sampler13InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler13_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler13OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__sampler__sampler13_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    assert(metric_set->n_counters <= 20);
}

static void
mtlgt3_add_tdl1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL1";
    metric_set->symbol_name = "TDL1";
    metric_set->hw_config_guid = "cf27081a-d750-4c9d-8a19-154f976992ee";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_tdl1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__tdl1__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__tdl1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__tdl1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__tdl1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__tdl1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread00ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__non_ps_thread00_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread01ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__non_ps_thread01_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread00ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__ps_thread00_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread01ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__ps_thread01_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader00Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header00_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader00ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header00_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader00ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header00_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader00ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header00_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader00ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header00_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader01Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header01_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader01ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header01_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader01ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header01_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader01ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header01_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader01ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl1__thread_header01_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    assert(metric_set->n_counters <= 18);
}

static void
mtlgt3_add_tdl2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL2";
    metric_set->symbol_name = "TDL2";
    metric_set->hw_config_guid = "fa292653-8b18-448b-b57e-8e8ff92fac11";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_tdl2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__tdl2__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__tdl2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__tdl2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__tdl2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__tdl2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread02ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__non_ps_thread02_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread03ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__non_ps_thread03_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread02ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__ps_thread02_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread03ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__ps_thread03_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader02Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header02_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader02ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header02_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader02ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header02_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader02ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header02_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader02ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header02_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader03Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header03_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader03ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header03_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader03ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header03_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader03ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header03_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader03ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl2__thread_header03_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    assert(metric_set->n_counters <= 18);
}

static void
mtlgt3_add_tdl3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL3";
    metric_set->symbol_name = "TDL3";
    metric_set->hw_config_guid = "9604dfeb-2724-459c-a25b-5e5e06d93fd8";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_tdl3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__tdl3__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__tdl3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__tdl3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__tdl3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__tdl3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread10ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__non_ps_thread10_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread11ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__non_ps_thread11_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread10ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__ps_thread10_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread11ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__ps_thread11_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader10Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header10_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader10ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header10_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader10ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header10_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader10ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header10_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader10ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header10_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader11Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header11_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader11ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header11_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader11ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header11_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader11ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header11_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader11ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl3__thread_header11_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    assert(metric_set->n_counters <= 18);
}

static void
mtlgt3_add_tdl4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL4";
    metric_set->symbol_name = "TDL4";
    metric_set->hw_config_guid = "b5333a47-add0-46a5-82d9-e62dcee14e81";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_tdl4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__tdl4__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__tdl4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__tdl4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__tdl4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__tdl4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread12ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__non_ps_thread12_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread13ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__non_ps_thread13_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread12ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__ps_thread12_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread13ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__ps_thread13_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader12Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header12_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader12ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header12_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader12ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header12_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader12ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header12_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader12ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header12_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader13Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header13_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader13ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header13_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader13ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header13_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader13ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header13_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader13ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__tdl4__thread_header13_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    assert(metric_set->n_counters <= 18);
}

static void
mtlgt3_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "7272a7b8-6df2-4180-a95f-2ef7ad4412cc";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__test_oa__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__test_oa__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter0";
    counter->symbol_name = "Counter0";
    counter->desc = "HW test counter 0. Factor: 0.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter1";
    counter->symbol_name = "Counter1";
    counter->desc = "HW test counter 1. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter2";
    counter->symbol_name = "Counter2";
    counter->desc = "HW test counter 2. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter3";
    counter->symbol_name = "Counter3";
    counter->desc = "HW test counter 3. Factor: 0.5";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter4";
    counter->symbol_name = "Counter4";
    counter->desc = "HW test counter 4. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter5";
    counter->symbol_name = "Counter5";
    counter->desc = "HW test counter 5. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter6";
    counter->symbol_name = "Counter6";
    counter->desc = "HW test counter 6. Factor: 0.16666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter7";
    counter->symbol_name = "Counter7";
    counter->desc = "HW test counter 7. Factor: 0.6666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter8";
    counter->symbol_name = "Counter8";
    counter->desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter8__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter9 - OAR enable";
    counter->symbol_name = "Counter9";
    counter->desc = "HW test counter 9. Should be equal to 1 in query.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__test_oa__counter9__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__test_oa__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__test_oa__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 13);
}

static void
mtlgt3_add_ext1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext1";
    metric_set->symbol_name = "Ext1";
    metric_set->hw_config_guid = "682c3520-dffc-4a76-8e17-1d9effc01a1a";
    metric_set->counters = calloc(21, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext1__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI0";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__ext1__gpu_memory_active_sqidi0__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI1";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__ext1__gpu_memory_active_sqidi1__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI0";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = mtlgt3__ext1__gpu_memory_byte_read_bw_sqidi0__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI1";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = mtlgt3__ext1__gpu_memory_byte_read_bw_sqidi1__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_byte_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_byte_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI0";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = mtlgt3__ext1__gpu_memory_byte_write_bw_sqidi0__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI1";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = mtlgt3__ext1__gpu_memory_byte_write_bw_sqidi1__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_byte_write_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_byte_write_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ";
    counter->symbol_name = "GPU_MEMORY_READ";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_read__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI0";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI1";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI0";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI0";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__ext1__gpu_memory_request_queue_full_sqidi0__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI1";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI1";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = mtlgt3__ext1__gpu_memory_request_queue_full_sqidi1__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY WRITE";
    counter->symbol_name = "GPU_MEMORY_WRITE";
    counter->desc = "Number of GTI memory writes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_write__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY WRITE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_WRITE_SQIDI0";
    counter->desc = "Number of GTI memory writes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_write_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY WRITE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_WRITE_SQIDI1";
    counter->desc = "Number of GTI memory writes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext1__gpu_memory_write_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 21);
}

static void
mtlgt3_add_ext3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext3";
    metric_set->symbol_name = "Ext3";
    metric_set->hw_config_guid = "b24b7052-70a1-4ef7-b61d-7ee4d7e159ab";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext3__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_32_b_transaction_read__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_32_b_transaction_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_32_b_transaction_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_32_b_transaction_write__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_32_b_transaction_write_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_32_b_transaction_write_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_64_b_transaction_read__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_64_b_transaction_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_64_b_transaction_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_64_b_transaction_write__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_64_b_transaction_write_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = mtlgt3__ext3__gpu_memory_64_b_transaction_write_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 15);
}

static void
mtlgt3_add_ext4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext4";
    metric_set->symbol_name = "Ext4";
    metric_set->hw_config_guid = "205ab9ab-56fd-4fdc-b3b3-91dc57be0fd3";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext4__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK0";
        counter->symbol_name = "L3_READ_L3BANK0";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK1";
        counter->symbol_name = "L3_READ_L3BANK1";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK2";
        counter->symbol_name = "L3_READ_L3BANK2";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK3";
        counter->symbol_name = "L3_READ_L3BANK3";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK4";
        counter->symbol_name = "L3_READ_L3BANK4";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK5";
        counter->symbol_name = "L3_READ_L3BANK5";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK6";
        counter->symbol_name = "L3_READ_L3BANK6";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 READ L3BANK7";
        counter->symbol_name = "L3_READ_L3BANK7";
        counter->desc = "Number of L3 read requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_read_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK0";
        counter->symbol_name = "L3_WRITE_L3BANK0";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK1";
        counter->symbol_name = "L3_WRITE_L3BANK1";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK2";
        counter->symbol_name = "L3_WRITE_L3BANK2";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK3";
        counter->symbol_name = "L3_WRITE_L3BANK3";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK4";
        counter->symbol_name = "L3_WRITE_L3BANK4";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK5";
        counter->symbol_name = "L3_WRITE_L3BANK5";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK6";
        counter->symbol_name = "L3_WRITE_L3BANK6";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 WRITE L3BANK7";
        counter->symbol_name = "L3_WRITE_L3BANK7";
        counter->desc = "Number of L3 write requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext4__l3_write_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext5";
    metric_set->symbol_name = "Ext5";
    metric_set->hw_config_guid = "26cb7ee1-a26d-410a-9283-e07d6ced5fce";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext5__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK0";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK0";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK1";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK1";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK2";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK2";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK3";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK3";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK4";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK4";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK5";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK5";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK6";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK6";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 READ L3BANK7";
        counter->symbol_name = "DATAPORT_L3_READ_L3BANK7";
        counter->desc = "Number of L3 read requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_read_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK0";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK0";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK1";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK1";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK2";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK2";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK3";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK3";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK4";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK4";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK5";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK5";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK6";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK6";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 WRITE L3BANK7";
        counter->symbol_name = "DATAPORT_L3_WRITE_L3BANK7";
        counter->desc = "Number of L3 write requests coming from XVE via Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext5__dataport_l3_write_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext6";
    metric_set->symbol_name = "Ext6";
    metric_set->hw_config_guid = "e62c9cd7-ada7-487d-87aa-b1ad4ab9a2c5";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext6__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK0";
        counter->symbol_name = "L3_HIT_L3BANK0";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK1";
        counter->symbol_name = "L3_HIT_L3BANK1";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK2";
        counter->symbol_name = "L3_HIT_L3BANK2";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK3";
        counter->symbol_name = "L3_HIT_L3BANK3";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK4";
        counter->symbol_name = "L3_HIT_L3BANK4";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK5";
        counter->symbol_name = "L3_HIT_L3BANK5";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK6";
        counter->symbol_name = "L3_HIT_L3BANK6";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 HIT L3BANK7";
        counter->symbol_name = "L3_HIT_L3BANK7";
        counter->desc = "Number of L3 accesses which hits in the L3 cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext6__l3_hit_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE0";
        counter->symbol_name = "SAMPLER_BUSY_XECORE0";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE1";
        counter->symbol_name = "SAMPLER_BUSY_XECORE1";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE2";
        counter->symbol_name = "SAMPLER_BUSY_XECORE2";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE3";
        counter->symbol_name = "SAMPLER_BUSY_XECORE3";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE4";
        counter->symbol_name = "SAMPLER_BUSY_XECORE4";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE5";
        counter->symbol_name = "SAMPLER_BUSY_XECORE5";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE6";
        counter->symbol_name = "SAMPLER_BUSY_XECORE6";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER BUSY XECORE7";
        counter->symbol_name = "SAMPLER_BUSY_XECORE7";
        counter->desc = "Percentage of time in which Sampler pipeline active";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext6__sampler_busy_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext7";
    metric_set->symbol_name = "Ext7";
    metric_set->hw_config_guid = "714e9d80-e4e3-40e6-9e79-2ca6d1d0a5a5";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext7__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK0";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK0";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK1";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK1";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK2";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK2";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK3";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK3";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK4";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK4";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK5";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK5";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK6";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK6";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 HIT L3BANK7";
        counter->symbol_name = "SAMPLER_L3_HIT_L3BANK7";
        counter->desc = "Number of L3 hit requests resulting from Sampler local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_hit_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK0";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK0";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK1";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK1";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK2";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK2";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK3";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK3";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK4";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK4";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK5";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK5";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK6";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK6";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER L3 READ L3BANK7";
        counter->symbol_name = "SAMPLER_L3_READ_L3BANK7";
        counter->desc = "Number of L3 read requests resulting from Sampler local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext7__sampler_l3_read_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext8";
    metric_set->symbol_name = "Ext8";
    metric_set->hw_config_guid = "30499dfb-3977-4808-a34c-93e7b50e0454";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext8__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext8__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext8__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext8__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK0";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK0";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK1";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK1";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK2";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK2";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK3";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK3";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK4";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK4";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK5";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK5";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK6";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK6";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 HIT L3BANK7";
        counter->symbol_name = "ICACHE_L3_HIT_L3BANK7";
        counter->desc = "Number of XVE instruction cache requests that hit the L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_hit_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK0";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK0";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK1";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK1";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK2";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK2";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK3";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK3";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK4";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK4";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK5";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK5";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK6";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK6";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ICACHE L3 READ L3BANK7";
        counter->symbol_name = "ICACHE_L3_READ_L3BANK7";
        counter->desc = "Number of L3 read requests coming from XVE Instruction Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext8__icache_l3_read_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext9_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext9";
    metric_set->symbol_name = "Ext9";
    metric_set->hw_config_guid = "417618f2-7a87-4745-bccd-6ba14d17bfa4";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext9_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext9__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext9__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext9__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext9__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK0";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK0";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK1";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK1";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK2";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK2";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK3";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK3";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK4";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK4";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK5";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK5";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK6";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK6";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 ACCESS L3BANK7";
        counter->symbol_name = "Z_L3_ACCESS_L3BANK7";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext9__z_l3_access_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext10_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext10";
    metric_set->symbol_name = "Ext10";
    metric_set->hw_config_guid = "443c32c7-e5e4-43da-b4f2-77efe45a60ed";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext10_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext10__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext10__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK0";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK0";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK1";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK1";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK2";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK2";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK3";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK3";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK4";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK4";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK5";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK5";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK6";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK6";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 HIT L3BANK7";
        counter->symbol_name = "COLOR_L3_HIT_L3BANK7";
        counter->desc = "Number of L3 read requests resulting from color local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__color_l3_hit_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK0";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK0";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK1";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK1";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK2";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK2";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK3";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK3";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK4";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK4";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK5";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK5";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK6";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK6";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT L3 HIT L3BANK7";
        counter->symbol_name = "DATAPORT_L3_HIT_L3BANK7";
        counter->desc = "Number of L3 hits for requests coming from the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext10__dataport_l3_hit_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext10__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext10__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext11_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext11";
    metric_set->symbol_name = "Ext11";
    metric_set->hw_config_guid = "3833e442-880a-4746-9df1-6347b7e5a081";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext11_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext11__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext11__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext11__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext11__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK0";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK0";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK1";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK1";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK2";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK2";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK3";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK3";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK4";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK4";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK5";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK5";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK6";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK6";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 ATOMIC ACCESS L3BANK7";
        counter->symbol_name = "L3_ATOMIC_ACCESS_L3BANK7";
        counter->desc = "Number of atomic accesses to L3 Bank";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__l3_atomic_access_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK0";
        counter->symbol_name = "Z_L3_HIT_L3BANK0";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK1";
        counter->symbol_name = "Z_L3_HIT_L3BANK1";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK2";
        counter->symbol_name = "Z_L3_HIT_L3BANK2";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK3";
        counter->symbol_name = "Z_L3_HIT_L3BANK3";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK4";
        counter->symbol_name = "Z_L3_HIT_L3BANK4";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK5";
        counter->symbol_name = "Z_L3_HIT_L3BANK5";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK6";
        counter->symbol_name = "Z_L3_HIT_L3BANK6";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Z L3 HIT L3BANK7";
        counter->symbol_name = "Z_L3_HIT_L3BANK7";
        counter->desc = "Number of L3 read requests resulting from Z local cache miss which hits in L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext11__z_l3_hit_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext12_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext12";
    metric_set->symbol_name = "Ext12";
    metric_set->hw_config_guid = "931bb082-6f87-450e-8910-fd6a4ab206f7";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext12_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext12__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext12__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext12__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext12__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK0";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK0";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK1";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK1";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK2";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK2";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK3";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK3";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK4";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK4";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK5";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK5";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK6";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK6";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 INPUT AVAILABLE L3BANK7";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK7";
        counter->desc = "Percentage of time in which L3 Bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_input_available_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK0";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK0";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK1";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK1";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK2";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK2";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK3";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK3";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK4";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK4";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK5";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK5";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK6";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK6";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK7";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK7";
        counter->desc = "Percentage of time in which L3 Bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext12__l3_output_ready_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext13_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext13";
    metric_set->symbol_name = "Ext13";
    metric_set->hw_config_guid = "f7fdd159-e273-47ab-99bc-f4fc410c6053";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext13_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext13__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext13__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK0";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK0";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext13__color_l3_access_l3_bank0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK1";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK1";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext13__color_l3_access_l3_bank1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK2";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK2";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext13__color_l3_access_l3_bank2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK3";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK3";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext13__color_l3_access_l3_bank3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext13__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext13__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK0";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK0";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext13__l3_superq_full_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK1";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK1";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext13__l3_superq_full_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK2";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK2";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext13__l3_superq_full_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK3";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK3";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext13__l3_superq_full_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext14_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext14";
    metric_set->symbol_name = "Ext14";
    metric_set->hw_config_guid = "423732fb-f20a-4549-b632-53ac587668d9";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext14_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext14__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext14__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK4";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK4";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext14__color_l3_access_l3_bank4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK5";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK5";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext14__color_l3_access_l3_bank5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK6";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK6";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext14__color_l3_access_l3_bank6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR L3 ACCESS L3BANK7";
        counter->symbol_name = "COLOR_L3_ACCESS_L3BANK7";
        counter->desc = "Number of L3 request resulting from color local cache miss";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext14__color_l3_access_l3_bank7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext14__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext14__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK4";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK4";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext14__l3_superq_full_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK5";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK5";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext14__l3_superq_full_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK6";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK6";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext14__l3_superq_full_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 SUPERQ FULL L3BANK7";
        counter->symbol_name = "L3_SUPERQ_FULL_L3BANK7";
        counter->desc = "Percentage of time in which all slots in L3 request queue are waiting for data return / response";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext14__l3_superq_full_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext15_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext15";
    metric_set->symbol_name = "Ext15";
    metric_set->hw_config_guid = "0fa8f991-d412-4014-a7a7-be08ccf5fc4c";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext15_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext15__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext15__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext15__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext15__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK0";
        counter->symbol_name = "L3_BUSY_L3BANK0";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_busy_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK1";
        counter->symbol_name = "L3_BUSY_L3BANK1";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_busy_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK2";
        counter->symbol_name = "L3_BUSY_L3BANK2";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_busy_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK3";
        counter->symbol_name = "L3_BUSY_L3BANK3";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_busy_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK0";
        counter->symbol_name = "L3_STALL_L3BANK0";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_stall_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK1";
        counter->symbol_name = "L3_STALL_L3BANK1";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_stall_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK2";
        counter->symbol_name = "L3_STALL_L3BANK2";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_stall_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK3";
        counter->symbol_name = "L3_STALL_L3BANK3";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext15__l3_stall_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext16_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext16";
    metric_set->symbol_name = "Ext16";
    metric_set->hw_config_guid = "e37de2da-c16f-4b2a-82bc-e1062fabfa2a";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext16_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext16__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext16__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext16__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext16__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK4";
        counter->symbol_name = "L3_BUSY_L3BANK4";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_busy_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK5";
        counter->symbol_name = "L3_BUSY_L3BANK5";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_busy_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK6";
        counter->symbol_name = "L3_BUSY_L3BANK6";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_busy_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BUSY L3BANK7";
        counter->symbol_name = "L3_BUSY_L3BANK7";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_busy_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK4";
        counter->symbol_name = "L3_STALL_L3BANK4";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_stall_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK5";
        counter->symbol_name = "L3_STALL_L3BANK5";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_stall_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK6";
        counter->symbol_name = "L3_STALL_L3BANK6";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_stall_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 STALL L3BANK7";
        counter->symbol_name = "L3_STALL_L3BANK7";
        counter->desc = "Percentage of time in which L3 Bank Stalled";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext16__l3_stall_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext17_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext17";
    metric_set->symbol_name = "Ext17";
    metric_set->hw_config_guid = "e8a60701-f694-496d-95be-34cc80796a46";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext17_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext17__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext17__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext17__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext17__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE0";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE0";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_input_available_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE1";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE1";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_input_available_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE2";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE2";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_input_available_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE3";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE3";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_input_available_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE0";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE0";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_output_ready_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE1";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE1";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_output_ready_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE2";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE2";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_output_ready_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE3";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE3";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext17__load_store_cache_output_ready_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext18_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext18";
    metric_set->symbol_name = "Ext18";
    metric_set->hw_config_guid = "1c957158-09ff-4a89-aa5b-3c1b4e46f9ba";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext18_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext18__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext18__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext18__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext18__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE4";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE4";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_input_available_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE5";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE5";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_input_available_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE6";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE6";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_input_available_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE INPUT AVAILABLE XECORE7";
        counter->symbol_name = "LOAD_STORE_CACHE_INPUT_AVAILABLE_XECORE7";
        counter->desc = "Percentage of time in which the Load Store Cache has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_input_available_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE4";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE4";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_output_ready_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE5";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE5";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_output_ready_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE6";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE6";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_output_ready_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE OUTPUT READY XECORE7";
        counter->symbol_name = "LOAD_STORE_CACHE_OUTPUT_READY_XECORE7";
        counter->desc = "Percentage of time in which the Load Store Cache has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext18__load_store_cache_output_ready_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext21_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext21";
    metric_set->symbol_name = "Ext21";
    metric_set->hw_config_guid = "a0b46166-6078-4045-8321-6df39b8e8ced";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext21_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext21__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext21__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext21__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext21__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE0";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE0";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_access_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE1";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE1";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_access_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE2";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE2";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_access_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE3";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE3";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_access_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE0";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE0";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_l3_read_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE1";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE1";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_l3_read_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE2";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE2";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_l3_read_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE3";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE3";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext21__load_store_cache_l3_read_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext22_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext22";
    metric_set->symbol_name = "Ext22";
    metric_set->hw_config_guid = "92371114-aa03-46d8-ab34-6e843fc92123";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext22_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext22__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext22__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext22__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext22__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE4";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE4";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_access_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE5";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE5";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_access_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE6";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE6";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_access_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE ACCESS XECORE7";
        counter->symbol_name = "LOAD_STORE_CACHE_ACCESS_XECORE7";
        counter->desc = "Number of Load Store Cache accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_access_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE4";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE4";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_l3_read_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE5";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE5";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_l3_read_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE6";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE6";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_l3_read_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 READ XECORE7";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_READ_XECORE7";
        counter->desc = "Number of cacheline read requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext22__load_store_cache_l3_read_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext23";
    metric_set->symbol_name = "Ext23";
    metric_set->hw_config_guid = "c7cd47a5-39e8-4c58-9b4f-a9c6df869db8";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext23__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext23__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext23__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext23__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE0";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE0";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext23__load_store_cache_hit_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE1";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE1";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext23__load_store_cache_hit_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE2";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE2";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext23__load_store_cache_hit_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE3";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE3";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext23__load_store_cache_hit_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext24_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext24";
    metric_set->symbol_name = "Ext24";
    metric_set->hw_config_guid = "2adf2c05-e151-4fa7-9e77-2331bd94235e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext24_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext24__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext24__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext24__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext24__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE4";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE4";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext24__load_store_cache_hit_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE5";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE5";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext24__load_store_cache_hit_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE6";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE6";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext24__load_store_cache_hit_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE HIT XECORE7";
        counter->symbol_name = "LOAD_STORE_CACHE_HIT_XECORE7";
        counter->desc = "Number of Load Store Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext24__load_store_cache_hit_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext28_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext28";
    metric_set->symbol_name = "Ext28";
    metric_set->hw_config_guid = "1fcdcf0a-54da-4397-8832-c884d8d0b3ff";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext28_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext28__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext28__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext28__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext28__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE0";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE0";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_l3_write_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE1";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE1";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_l3_write_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE2";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE2";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_l3_write_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE3";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE3";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_l3_write_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE0";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE0";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_partial_write_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE1";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE1";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_partial_write_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE2";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE2";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_partial_write_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE3";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE3";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext28__load_store_cache_partial_write_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext29_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext29";
    metric_set->symbol_name = "Ext29";
    metric_set->hw_config_guid = "9701aca8-76a6-49ee-96c9-ff983f24d29e";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext29_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext29__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext29__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext29__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext29__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE4";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE4";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_l3_write_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE5";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE5";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_l3_write_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE6";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE6";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_l3_write_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE L3 WRITE XECORE7";
        counter->symbol_name = "LOAD_STORE_CACHE_L3_WRITE_XECORE7";
        counter->desc = "Number of cacheline write requests from the Load Store Cache to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_l3_write_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE4";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE4";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_partial_write_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE5";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE5";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_partial_write_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE6";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE6";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_partial_write_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LOAD STORE CACHE PARTIAL WRITE COUNT XECORE7";
        counter->symbol_name = "LOAD_STORE_CACHE_PARTIAL_WRITE_COUNT_XECORE7";
        counter->desc = "Number of writes to the Load Store Cache that don't fill a subsector";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext29__load_store_cache_partial_write_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext31_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext31";
    metric_set->symbol_name = "Ext31";
    metric_set->hw_config_guid = "f47e74cf-7966-43ea-bbac-46f9a0d1dc1f";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext31_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext31__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext31__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext31__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext31__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext31__xve_load_store_cache_read_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext31__xve_load_store_cache_read_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext31__xve_load_store_cache_read_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext31__xve_load_store_cache_read_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext32_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext32";
    metric_set->symbol_name = "Ext32";
    metric_set->hw_config_guid = "3e220edc-390e-4964-9e57-4d45f3e01de8";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext32_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext32__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext32__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext32__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext32__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext32__xve_load_store_cache_read_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext32__xve_load_store_cache_read_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext32__xve_load_store_cache_read_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE READ MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_READ_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of read messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext32__xve_load_store_cache_read_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext35_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext35";
    metric_set->symbol_name = "Ext35";
    metric_set->hw_config_guid = "d334294d-8dd2-4ae2-ae31-7d0d4acc2b6b";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext35_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext35__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext35__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext35__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext35__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext35__xve_load_store_cache_write_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext35__xve_load_store_cache_write_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext35__xve_load_store_cache_write_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext35__xve_load_store_cache_write_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext36_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext36";
    metric_set->symbol_name = "Ext36";
    metric_set->hw_config_guid = "b749495f-4fc4-4e54-965e-38990758473b";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext36_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext36__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext36__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext36__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext36__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext36__xve_load_store_cache_write_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext36__xve_load_store_cache_write_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext36__xve_load_store_cache_write_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE WRITE MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_WRITE_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of write messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext36__xve_load_store_cache_write_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext39_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext39";
    metric_set->symbol_name = "Ext39";
    metric_set->hw_config_guid = "09c0f842-3711-48f5-bf3e-74c1caa9f791";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext39_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext39__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext39__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext39__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext39__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext39__xve_load_store_cache_fence_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext39__xve_load_store_cache_fence_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext39__xve_load_store_cache_fence_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext39__xve_load_store_cache_fence_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext40_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext40";
    metric_set->symbol_name = "Ext40";
    metric_set->hw_config_guid = "be7c864e-0538-420d-916d-ce3aed7742ba";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext40_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext40__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext40__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext40__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext40__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext40__xve_load_store_cache_fence_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext40__xve_load_store_cache_fence_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext40__xve_load_store_cache_fence_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE FENCE MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_FENCE_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of fence messages sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext40__xve_load_store_cache_fence_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext43_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext43";
    metric_set->symbol_name = "Ext43";
    metric_set->hw_config_guid = "86cf3d13-947b-4f7f-9685-1ff59ec342dd";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext43_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext43__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext43__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext43__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext43__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext43__xve_load_store_cache_atomic_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext43__xve_load_store_cache_atomic_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE0";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE0";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext43__xve_load_store_cache_register_request_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE1";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE1";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext43__xve_load_store_cache_register_request_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext44_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext44";
    metric_set->symbol_name = "Ext44";
    metric_set->hw_config_guid = "7675136e-a91e-4bf8-b206-32591b878339";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext44_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext44__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext44__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext44__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext44__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext44__xve_load_store_cache_atomic_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext44__xve_load_store_cache_atomic_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE4";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE4";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext44__xve_load_store_cache_register_request_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE5";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE5";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext44__xve_load_store_cache_register_request_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext45_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext45";
    metric_set->symbol_name = "Ext45";
    metric_set->hw_config_guid = "e953dbdb-3451-4912-80ae-241ecc56a59e";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext45_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext45__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext45__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext45__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext45__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext45__xve_load_store_cache_atomic_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext45__xve_load_store_cache_atomic_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE2";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE2";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext45__xve_load_store_cache_register_request_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE3";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE3";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext45__xve_load_store_cache_register_request_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext46_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext46";
    metric_set->symbol_name = "Ext46";
    metric_set->hw_config_guid = "94219d74-6a23-4b93-bf62-88c9ad4ed4bd";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext46_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext46__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext46__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext46__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext46__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext46__xve_load_store_cache_atomic_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE ATOMIC MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_ATOMIC_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of atomic operations sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext46__xve_load_store_cache_atomic_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE6";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE6";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext46__xve_load_store_cache_register_request_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER REQUEST COUNT XECORE7";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_REQUEST_COUNT_XECORE7";
        counter->desc = "Number of message payload transactions sent by XVEs to the Load Store Cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext46__xve_load_store_cache_register_request_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext51_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext51";
    metric_set->symbol_name = "Ext51";
    metric_set->hw_config_guid = "cab52f96-c6bf-48ca-a34e-17e52cadc8a6";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext51_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext51__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext51__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext51__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext51__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE0";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE0";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE1";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE1";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE2";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE2";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE3";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE3";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE4";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE4";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE5";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE5";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE6";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE6";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE LOAD STORE CACHE REGISTER RESPONSE COUNT XECORE7";
        counter->symbol_name = "XVE_LOAD_STORE_CACHE_REGISTER_RESPONSE_COUNT_XECORE7";
        counter->desc = "Number of message payload transactions sent from the Load Store Cache back to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext51__xve_load_store_cache_register_response_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext53_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext53";
    metric_set->symbol_name = "Ext53";
    metric_set->hw_config_guid = "e4597eb9-ffa4-4da5-a180-5e12299f22cc";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext53_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext53__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext53__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext53__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext53__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext53__xve_slm_read_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext53__xve_slm_read_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext53__xve_slm_read_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext53__xve_slm_read_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext54_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext54";
    metric_set->symbol_name = "Ext54";
    metric_set->hw_config_guid = "0a11c113-298b-4f77-a085-1b7cac225015";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext54_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext54__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext54__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext54__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext54__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext54__xve_slm_read_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext54__xve_slm_read_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext54__xve_slm_read_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM READ MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_SLM_READ_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of SLM read messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext54__xve_slm_read_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext57_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext57";
    metric_set->symbol_name = "Ext57";
    metric_set->hw_config_guid = "6f983509-03f1-463a-be88-3e4a40de40b4";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext57_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext57__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext57__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext57__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext57__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext57__xve_slm_write_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext57__xve_slm_write_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext57__xve_slm_write_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext57__xve_slm_write_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext58_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext58";
    metric_set->symbol_name = "Ext58";
    metric_set->hw_config_guid = "75d3fdde-e74d-4ec2-a7f0-f88fe5971af3";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext58_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext58__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext58__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext58__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext58__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext58__xve_slm_write_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext58__xve_slm_write_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext58__xve_slm_write_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM WRITE MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_SLM_WRITE_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of SLM write messages sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext58__xve_slm_write_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext61_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext61";
    metric_set->symbol_name = "Ext61";
    metric_set->hw_config_guid = "98c25532-687f-489a-b070-667edd3c41f9";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext61_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext61__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext61__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext61__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext61__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext61__xve_slm_fence_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext61__xve_slm_fence_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext61__xve_slm_fence_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext61__xve_slm_fence_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext62_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext62";
    metric_set->symbol_name = "Ext62";
    metric_set->hw_config_guid = "6ee28b50-5390-4655-af96-9d99569aee82";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext62_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext62__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext62__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext62__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext62__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext62__xve_slm_fence_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext62__xve_slm_fence_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext62__xve_slm_fence_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM FENCE MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_SLM_FENCE_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of SLM fence operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext62__xve_slm_fence_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext65_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext65";
    metric_set->symbol_name = "Ext65";
    metric_set->hw_config_guid = "89a4a65b-cbfa-4c75-99fb-e5d7f0def495";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext65_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext65__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext65__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext65__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext65__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext65__xve_slm_atomic_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext65__xve_slm_atomic_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext66_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext66";
    metric_set->symbol_name = "Ext66";
    metric_set->hw_config_guid = "99e44f76-928f-4835-866f-663e25c69f66";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext66_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext66__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext66__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext66__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext66__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext66__xve_slm_atomic_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext66__xve_slm_atomic_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext67_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext67";
    metric_set->symbol_name = "Ext67";
    metric_set->hw_config_guid = "f45dfc0c-70ef-48bd-83a2-30cf4a6ba0d5";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext67_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext67__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext67__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext67__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext67__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext67__xve_slm_atomic_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext67__xve_slm_atomic_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext68_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext68";
    metric_set->symbol_name = "Ext68";
    metric_set->hw_config_guid = "eab0942c-5181-4caf-aeec-44d9a0b69ada";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext68_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext68__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext68__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext68__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext68__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext68__xve_slm_atomic_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE SLM ATOMIC MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_SLM_ATOMIC_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of SLM atomic operations sent by XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext68__xve_slm_atomic_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext73_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext73";
    metric_set->symbol_name = "Ext73";
    metric_set->hw_config_guid = "d9d0c398-6429-4ba8-bc08-6e8556a5880f";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext73_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext73__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext73__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE0";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE0";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext73__dataport_input_available_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE1";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE1";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext73__dataport_input_available_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext73__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext73__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext74_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext74";
    metric_set->symbol_name = "Ext74";
    metric_set->hw_config_guid = "d91bf24f-08af-4d1d-b957-c2293923c9a4";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext74_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext74__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext74__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE2";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE2";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext74__dataport_input_available_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE3";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE3";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext74__dataport_input_available_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext74__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext74__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext75_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext75";
    metric_set->symbol_name = "Ext75";
    metric_set->hw_config_guid = "b5c2eaef-cffa-490b-a80e-de2b37ca63d8";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext75_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext75__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext75__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE4";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE4";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext75__dataport_input_available_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE5";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE5";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext75__dataport_input_available_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext75__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext75__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext76_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext76";
    metric_set->symbol_name = "Ext76";
    metric_set->hw_config_guid = "d5cdafcf-483d-40f7-8dc9-feca73e94246";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext76_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext76__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext76__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE6";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE6";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext76__dataport_input_available_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE7";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE7";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext76__dataport_input_available_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext76__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext76__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext77_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext77";
    metric_set->symbol_name = "Ext77";
    metric_set->hw_config_guid = "240802cf-de55-472f-9e0a-710270ae9487";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext77_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext77__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext77__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE0";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE0";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext77__dataport_output_ready_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE1";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE1";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext77__dataport_output_ready_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE2";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE2";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext77__dataport_output_ready_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE3";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE3";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext77__dataport_output_ready_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext77__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext77__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext78_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext78";
    metric_set->symbol_name = "Ext78";
    metric_set->hw_config_guid = "3dd49211-aa69-4711-87c2-97289ff9cfff";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext78_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext78__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext78__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE4";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE4";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext78__dataport_output_ready_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE5";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE5";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext78__dataport_output_ready_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE6";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE6";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext78__dataport_output_ready_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE7";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE7";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext78__dataport_output_ready_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext78__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext78__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext79_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext79";
    metric_set->symbol_name = "Ext79";
    metric_set->hw_config_guid = "64aeba75-9dbe-4231-81f6-8c991b84c070";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext79_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext79__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext79__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE0";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE0";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext79__dataport_byte_read_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE1";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE1";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext79__dataport_byte_read_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext79__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext79__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext80_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext80";
    metric_set->symbol_name = "Ext80";
    metric_set->hw_config_guid = "3b293ce5-af38-4ae2-96f4-a542d3c68d5e";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext80_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext80__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext80__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE2";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE2";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext80__dataport_byte_read_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE3";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE3";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext80__dataport_byte_read_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext80__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext80__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext81_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext81";
    metric_set->symbol_name = "Ext81";
    metric_set->hw_config_guid = "09516dce-66a0-499f-8457-97f78bb921e6";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext81_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext81__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext81__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE4";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE4";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext81__dataport_byte_read_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE5";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE5";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext81__dataport_byte_read_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext81__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext81__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext82_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext82";
    metric_set->symbol_name = "Ext82";
    metric_set->hw_config_guid = "c0bdc35b-af55-4ac9-8078-f22578201756";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext82_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext82__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext82__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE6";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE6";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext82__dataport_byte_read_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE7";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE7";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext82__dataport_byte_read_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext82__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext82__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext83_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext83";
    metric_set->symbol_name = "Ext83";
    metric_set->hw_config_guid = "7f4b6bdf-4a28-4e6b-a67b-c9a0d320ddb8";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext83_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext83__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext83__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE0";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE0";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE1";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE1";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE2";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE2";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE3";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE3";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE4";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE4";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE5";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE5";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE6";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE6";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE7";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE7";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = mtlgt3__ext83__dataport_byte_write_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE0";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE1";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE2";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE3";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE4";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE4";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE5";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE5";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE6";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE6";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE7";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE7";
        counter->desc = "Number of cacheline requests from the Dataport to the Render Cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext83__dataport_texture_cache_access_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext83__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext83__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext85_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext85";
    metric_set->symbol_name = "Ext85";
    metric_set->hw_config_guid = "e19c5430-c632-43eb-b27f-eeb3d405bfd8";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext85_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext85__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext85__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE0";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE0";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__dataport_texture_cache_hit_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE1";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE1";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__dataport_texture_cache_hit_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE2";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE2";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__dataport_texture_cache_hit_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE3";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE3";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__dataport_texture_cache_hit_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext85__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext85__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__xve_dataport_read_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__xve_dataport_read_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__xve_dataport_read_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext85__xve_dataport_read_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext86_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext86";
    metric_set->symbol_name = "Ext86";
    metric_set->hw_config_guid = "d379e5f5-32f3-4a6b-957f-5ccf607dda00";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext86_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext86__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext86__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE4";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE4";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__dataport_texture_cache_hit_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE5";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE5";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__dataport_texture_cache_hit_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE6";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE6";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__dataport_texture_cache_hit_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE7";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE7";
        counter->desc = "Number of cache requests from the Dataport to the Render Cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__dataport_texture_cache_hit_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext86__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext86__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__xve_dataport_read_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__xve_dataport_read_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__xve_dataport_read_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext86__xve_dataport_read_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext87_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext87";
    metric_set->symbol_name = "Ext87";
    metric_set->hw_config_guid = "3e86ea71-8695-4815-ac18-0fd4510541a1";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext87_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext87__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext87__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext87__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext87__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext87__xve_dataport_write_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext87__xve_dataport_write_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext87__xve_dataport_write_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext87__xve_dataport_write_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext88_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext88";
    metric_set->symbol_name = "Ext88";
    metric_set->hw_config_guid = "31ad28aa-7425-4bb4-b1a3-423821d98d84";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext88_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext88__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext88__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext88__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext88__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext88__xve_dataport_write_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext88__xve_dataport_write_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext88__xve_dataport_write_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext88__xve_dataport_write_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext91_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext91";
    metric_set->symbol_name = "Ext91";
    metric_set->hw_config_guid = "a1963e82-2bad-44e2-9bb1-ee18657c09cd";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext91_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext91__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext91__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext91__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext91__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext91__xve_dataport_atomic_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext91__xve_dataport_atomic_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext91__xve_dataport_atomic_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext91__xve_dataport_atomic_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext92_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext92";
    metric_set->symbol_name = "Ext92";
    metric_set->hw_config_guid = "fdf0722d-cb2e-46bd-8c1f-a85c6fbca3ff";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext92_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext92__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext92__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext92__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext92__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext92__xve_dataport_atomic_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext92__xve_dataport_atomic_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext92__xve_dataport_atomic_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext92__xve_dataport_atomic_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext93_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext93";
    metric_set->symbol_name = "Ext93";
    metric_set->hw_config_guid = "e0810ece-3bb5-4786-871b-b504faa00ba7";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext93_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext93__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext93__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext93__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext93__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext93__xve_dataport_register_response_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = mtlgt3__ext93__xve_dataport_register_response_count_xecore1__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext94_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext94";
    metric_set->symbol_name = "Ext94";
    metric_set->hw_config_guid = "8697d9f7-3085-4ae7-b88d-e77697972732";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext94_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext94__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext94__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext94__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext94__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE2";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = mtlgt3__ext94__xve_dataport_register_response_count_xecore2__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE3";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = mtlgt3__ext94__xve_dataport_register_response_count_xecore3__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext95_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext95";
    metric_set->symbol_name = "Ext95";
    metric_set->hw_config_guid = "d059b804-fc25-4cbc-9682-ebc806a0d423";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext95_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext95__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext95__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext95__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext95__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE4";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = mtlgt3__ext95__xve_dataport_register_response_count_xecore4__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE5";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = mtlgt3__ext95__xve_dataport_register_response_count_xecore5__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext96_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext96";
    metric_set->symbol_name = "Ext96";
    metric_set->hw_config_guid = "ca3c5e8c-b83a-474f-85fa-af7572a1ce27";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext96_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext96__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext96__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext96__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext96__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE6";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = mtlgt3__ext96__xve_dataport_register_response_count_xecore6__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE7";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = mtlgt3__ext96__xve_dataport_register_response_count_xecore7__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 5);
}

static void
mtlgt3_add_ext97_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext97";
    metric_set->symbol_name = "Ext97";
    metric_set->hw_config_guid = "fbed5532-2b4f-4194-b856-0404c387b2e4";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext97_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext97__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext97__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext97__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext97__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE0";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE1";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE2";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE3";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE4";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE5";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE6";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE7";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext97__xve_dataport_register_request_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext98_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext98";
    metric_set->symbol_name = "Ext98";
    metric_set->hw_config_guid = "4c975484-c2f5-4f29-b8fa-8ec1068de77a";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext98_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext98__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext98__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext98__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext98__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE0";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE0";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext98__sampler_output_ready_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE1";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE1";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext98__sampler_output_ready_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE2";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE2";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext98__sampler_output_ready_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE3";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE3";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext98__sampler_output_ready_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext99_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext99";
    metric_set->symbol_name = "Ext99";
    metric_set->hw_config_guid = "13017c9d-9d3a-41d1-8f9c-2eafdcbefab4";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext99_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext99__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext99__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext99__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext99__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE4";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE4";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext99__sampler_output_ready_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE5";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE5";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext99__sampler_output_ready_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE6";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE6";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext99__sampler_output_ready_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER OUTPUT READY XECORE7";
        counter->symbol_name = "SAMPLER_OUTPUT_READY_XECORE7";
        counter->desc = "Percentage of time in which Sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext99__sampler_output_ready_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext100_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext100";
    metric_set->symbol_name = "Ext100";
    metric_set->hw_config_guid = "a7ef0e01-74c3-48c5-8d0f-00241111cf69";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext100_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext100__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext100__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext100__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext100__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE0";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE0";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_input_available_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE1";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE1";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_input_available_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE2";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE2";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_input_available_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE3";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE3";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_input_available_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE0";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE0";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_memory_latency_stall_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE1";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE1";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_memory_latency_stall_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE2";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE2";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_memory_latency_stall_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE3";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE3";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext100__sampler_memory_latency_stall_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext101_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext101";
    metric_set->symbol_name = "Ext101";
    metric_set->hw_config_guid = "7e86b43f-715e-419a-83eb-e8777fd7c77a";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext101_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext101__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext101__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext101__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext101__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE4";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE4";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_input_available_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE5";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE5";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_input_available_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE6";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE6";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_input_available_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER INPUT AVAILABLE XECORE7";
        counter->symbol_name = "SAMPLER_INPUT_AVAILABLE_XECORE7";
        counter->desc = "Percentage of time in which Sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_input_available_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE4";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE4";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_memory_latency_stall_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE5";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE5";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_memory_latency_stall_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE6";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE6";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_memory_latency_stall_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER MEMORY LATENCY STALL XECORE7";
        counter->symbol_name = "SAMPLER_MEMORY_LATENCY_STALL_XECORE7";
        counter->desc = "Percentage of time in which Sampler stalled due to latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext101__sampler_memory_latency_stall_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 11);
}

static void
mtlgt3_add_ext102_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext102";
    metric_set->symbol_name = "Ext102";
    metric_set->hw_config_guid = "1fb36f5f-04a3-412f-a6ca-80233bf408a0";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext102_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext102__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext102__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext102__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext102__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE0";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE0";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE1";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE1";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE2";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE2";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE3";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE3";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE4";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE4";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE5";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE5";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE6";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE6";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH INPUT AVAILABLE XECORE7";
        counter->symbol_name = "THREAD_DISPATCH_INPUT_AVAILABLE_XECORE7";
        counter->desc = "Percentage of time in which Thread Dispatch input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_input_available_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE0";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE0";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE1";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE1";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE2";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE2";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE3";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE3";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE4";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE4";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE5";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE5";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE6";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE6";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH STALL XECORE7";
        counter->symbol_name = "THREAD_DISPATCH_STALL_XECORE7";
        counter->desc = "Percentage of time in which Thread Dispatch is stalled waiting for threads to be available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext102__thread_dispatch_stall_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext103_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext103";
    metric_set->symbol_name = "Ext103";
    metric_set->hw_config_guid = "5228137b-8e8d-4d67-b195-d5f64a88f5f0";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext103_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext103__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext103__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext103__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext103__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE0";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE0";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE1";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE1";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE2";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE2";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE3";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE3";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE4";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE4";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE5";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE5";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE6";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE6";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE ACCESS XECORE7";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_ACCESS_XECORE7";
        counter->desc = "Number of Sampler L1 requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_access_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE0";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE0";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE1";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE1";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE2";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE2";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE3";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE3";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE4";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE4";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE5";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE5";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE6";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE6";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "SAMPLER TEXTURE CACHE MISS XECORE7";
        counter->symbol_name = "SAMPLER_TEXTURE_CACHE_MISS_XECORE7";
        counter->desc = "Number of Sampler L1 misses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext103__sampler_texture_cache_miss_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 19);
}

static void
mtlgt3_add_ext104_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext104";
    metric_set->symbol_name = "Ext104";
    metric_set->hw_config_guid = "5503160a-7b2a-4099-9ec6-0d3a551cb388";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext104_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE0";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE0";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext104__async_gpgpu_thread_exit_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext104__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext104__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE2";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE2";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext104__gpgpu_threadgroup_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext104__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext104__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE2";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE2";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext104__task_threadgroup_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE0";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE0";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext104__task_thread_exit_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext105_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext105";
    metric_set->symbol_name = "Ext105";
    metric_set->hw_config_guid = "418f87f0-b6d8-4684-883e-4f10a79c5070";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext105_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE1";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE1";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext105__async_gpgpu_thread_exit_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext105__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext105__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE3";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE3";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext105__gpgpu_threadgroup_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext105__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext105__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE3";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE3";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext105__task_threadgroup_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE1";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE1";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext105__task_thread_exit_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext106_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext106";
    metric_set->symbol_name = "Ext106";
    metric_set->hw_config_guid = "f5b7256f-9bf6-4c95-94c1-4044cfad0ea6";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext106_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE2";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE2";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext106__async_gpgpu_thread_exit_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext106__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext106__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE0";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE0";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext106__gpgpu_threadgroup_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext106__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext106__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE0";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE0";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext106__task_threadgroup_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE2";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE2";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext106__task_thread_exit_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext107_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext107";
    metric_set->symbol_name = "Ext107";
    metric_set->hw_config_guid = "28d75db6-0eb3-4651-b820-513a76013504";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext107_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE3";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE3";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext107__async_gpgpu_thread_exit_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext107__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext107__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE1";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE1";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext107__gpgpu_threadgroup_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext107__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext107__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE1";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE1";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext107__task_threadgroup_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE3";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE3";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext107__task_thread_exit_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext108_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext108";
    metric_set->symbol_name = "Ext108";
    metric_set->hw_config_guid = "080da0b6-29a4-416b-b20f-ece0e2527f60";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext108_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE4";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE4";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext108__async_gpgpu_thread_exit_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext108__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext108__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE6";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE6";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext108__gpgpu_threadgroup_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext108__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext108__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE6";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE6";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext108__task_threadgroup_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE4";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE4";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext108__task_thread_exit_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext109_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext109";
    metric_set->symbol_name = "Ext109";
    metric_set->hw_config_guid = "75a9e66d-9bbe-46d7-971e-71ca8ef680ff";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext109_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE5";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE5";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext109__async_gpgpu_thread_exit_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext109__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext109__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE7";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE7";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext109__gpgpu_threadgroup_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext109__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext109__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE7";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE7";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext109__task_threadgroup_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE5";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE5";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext109__task_thread_exit_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext110_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext110";
    metric_set->symbol_name = "Ext110";
    metric_set->hw_config_guid = "ae5589a9-7e09-4343-a611-3161977315d5";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext110_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE6";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE6";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext110__async_gpgpu_thread_exit_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext110__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext110__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE4";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE4";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext110__gpgpu_threadgroup_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext110__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext110__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE4";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE4";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext110__task_threadgroup_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE6";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE6";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext110__task_thread_exit_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext111_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext111";
    metric_set->symbol_name = "Ext111";
    metric_set->hw_config_guid = "a5e1e738-1338-4d76-a6a7-5517111cc852";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext111_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "ASYNC GPGPU THREAD EXIT COUNT XECORE7";
        counter->symbol_name = "ASYNC_GPGPU_THREAD_EXIT_COUNT_XECORE7";
        counter->desc = "Number of Async GPGPU EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext111__async_gpgpu_thread_exit_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext111__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext111__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "GPGPU THREADGROUP COUNT XECORE5";
        counter->symbol_name = "GPGPU_THREADGROUP_COUNT_XECORE5";
        counter->desc = "Number of GPGPU threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext111__gpgpu_threadgroup_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext111__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext111__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREADGROUP COUNT XECORE5";
        counter->symbol_name = "TASK_THREADGROUP_COUNT_XECORE5";
        counter->desc = "Number of Task Shader threadgroups dispatched";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext111__task_threadgroup_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "TASK THREAD EXIT COUNT XECORE7";
        counter->symbol_name = "TASK_THREAD_EXIT_COUNT_XECORE7";
        counter->desc = "Number of Task Shader EOT messages received";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext111__task_thread_exit_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext113_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext113";
    metric_set->symbol_name = "Ext113";
    metric_set->hw_config_guid = "1a24edc7-8187-43b6-86aa-fcf56c223893";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext113_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext113__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext113__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext113__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext113__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE0";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE0";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_ps_active_cycles_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE1";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE1";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_ps_active_cycles_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE2";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE2";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_ps_active_cycles_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE3";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE3";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_ps_active_cycles_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE0";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE0";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue0_active_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE1";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE1";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue0_active_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE2";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE2";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue0_active_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE3";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE3";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue0_active_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE0";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE0";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue1_active_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE1";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE1";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue1_active_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE2";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE2";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue1_active_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE3";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE3";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext113__thread_dispatch_queue1_active_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 15);
}

static void
mtlgt3_add_ext114_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext114";
    metric_set->symbol_name = "Ext114";
    metric_set->hw_config_guid = "32565d07-8ac7-41c3-89a3-66d0c1100616";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext114_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext114__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext114__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext114__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext114__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE4";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE4";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_ps_active_cycles_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE5";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE5";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_ps_active_cycles_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE6";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE6";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_ps_active_cycles_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH PS ACTIVE CYCLES XECORE7";
        counter->symbol_name = "THREAD_DISPATCH_PS_ACTIVE_CYCLES_XECORE7";
        counter->desc = "Percentage of time in which Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_ps_active_cycles_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE4";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE4";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue0_active_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE5";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE5";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue0_active_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE6";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE6";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue0_active_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE0 ACTIVE XECORE7";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE0_ACTIVE_XECORE7";
        counter->desc = "Percentage of time in which non-Pixel Shader threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue0_active_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE4";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE4";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue1_active_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE5";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE5";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue1_active_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE6";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE6";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue1_active_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREAD DISPATCH QUEUE1 ACTIVE XECORE7";
        counter->symbol_name = "THREAD_DISPATCH_QUEUE1_ACTIVE_XECORE7";
        counter->desc = "Percentage of time in which Async GPGPU threads are ready for dispatch in a particular Xe core";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext114__thread_dispatch_queue1_active_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 15);
}

static void
mtlgt3_add_ext116_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext116";
    metric_set->symbol_name = "Ext116";
    metric_set->hw_config_guid = "f725009a-c5e7-4418-9adf-ddb70cb2edde";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext116_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext116__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext116__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext116__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext116__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE0";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE0";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext116__threadgroup_dispatch_resource_stall_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE1";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE1";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext116__threadgroup_dispatch_resource_stall_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE2";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE2";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext116__threadgroup_dispatch_resource_stall_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE3";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE3";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext116__threadgroup_dispatch_resource_stall_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext117_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext117";
    metric_set->symbol_name = "Ext117";
    metric_set->hw_config_guid = "f633497f-c116-461f-a0e9-bb3fdcef7683";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext117_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext117__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext117__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext117__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext117__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE4";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE4";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext117__threadgroup_dispatch_resource_stall_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE5";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE5";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext117__threadgroup_dispatch_resource_stall_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE6";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE6";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext117__threadgroup_dispatch_resource_stall_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "THREADGROUP DISPATCH RESOURCE STALL XECORE7";
        counter->symbol_name = "THREADGROUP_DISPATCH_RESOURCE_STALL_XECORE7";
        counter->desc = "Percentage of time in which Thread Spawner is stalled waiting for resources to be available (SLM, Barrier, BTD stack)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext117__threadgroup_dispatch_resource_stall_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext118_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext118";
    metric_set->symbol_name = "Ext118";
    metric_set->hw_config_guid = "bae9e67e-4b5c-4fb9-b21d-21a6966bed46";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext118_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE HIT SLICE0";
        counter->symbol_name = "AMFS_CACHE_HIT_SLICE0";
        counter->desc = "Number of hits in the AMFS cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext118__amfs_cache_hit_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE MISS SLICE0";
        counter->symbol_name = "AMFS_CACHE_MISS_SLICE0";
        counter->desc = "Number of cache misses in AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext118__amfs_cache_miss_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ALL INPUT SLICE0";
        counter->symbol_name = "AMFS_STALL_ALL_INPUT_SLICE0";
        counter->desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext118__amfs_stall_all_input_slice0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ANY INPUT SLICE0";
        counter->symbol_name = "AMFS_STALL_ANY_INPUT_SLICE0";
        counter->desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext118__amfs_stall_any_input_slice0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext118__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext118__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext118__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext118__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE HIT L3NODE0";
        counter->symbol_name = "RENDER_CACHE_HIT_L3NODE0";
        counter->desc = "Number of Render Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext118__render_cache_hit_l3_node0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE INPUT AVAILABLE _L3NODE0";
        counter->symbol_name = "RENDER_CACHE_INPUT_AVAILABLE_L3NODE0";
        counter->desc = "Percentage of time when Render Cache input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext118__render_cache_input_available_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE OUTPUT READY _L3NODE0";
        counter->symbol_name = "RENDER_CACHE_OUTPUT_READY_L3NODE0";
        counter->desc = "Percentage of time when Render Cache output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext118__render_cache_output_ready_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE READ L3NODE0";
        counter->symbol_name = "RENDER_CACHE_READ_L3NODE0";
        counter->desc = "Number of Render Cache reads";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext118__render_cache_read_l3_node0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE WRITE L3NODE0";
        counter->symbol_name = "RENDER_CACHE_WRITE_L3NODE0";
        counter->desc = "Number of Render Cache writes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext118__render_cache_write_l3_node0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 12);
}

static void
mtlgt3_add_ext119_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext119";
    metric_set->symbol_name = "Ext119";
    metric_set->hw_config_guid = "95c08faf-813c-4b71-9062-09569c5ff432";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext119_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE HIT SLICE1";
        counter->symbol_name = "AMFS_CACHE_HIT_SLICE1";
        counter->desc = "Number of hits in the AMFS cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext119__amfs_cache_hit_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE MISS SLICE1";
        counter->symbol_name = "AMFS_CACHE_MISS_SLICE1";
        counter->desc = "Number of cache misses in AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext119__amfs_cache_miss_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ALL INPUT SLICE1";
        counter->symbol_name = "AMFS_STALL_ALL_INPUT_SLICE1";
        counter->desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext119__amfs_stall_all_input_slice1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ANY INPUT SLICE1";
        counter->symbol_name = "AMFS_STALL_ANY_INPUT_SLICE1";
        counter->desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext119__amfs_stall_any_input_slice1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext119__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext119__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext119__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext119__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE HIT L3NODE1";
        counter->symbol_name = "RENDER_CACHE_HIT_L3NODE1";
        counter->desc = "Number of Render Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext119__render_cache_hit_l3_node1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE INPUT AVAILABLE _L3NODE1";
        counter->symbol_name = "RENDER_CACHE_INPUT_AVAILABLE_L3NODE1";
        counter->desc = "Percentage of time when Render Cache input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext119__render_cache_input_available_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE OUTPUT READY _L3NODE1";
        counter->symbol_name = "RENDER_CACHE_OUTPUT_READY_L3NODE1";
        counter->desc = "Percentage of time when Render Cache output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext119__render_cache_output_ready_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE READ L3NODE1";
        counter->symbol_name = "RENDER_CACHE_READ_L3NODE1";
        counter->desc = "Number of Render Cache reads";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext119__render_cache_read_l3_node1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE WRITE L3NODE1";
        counter->symbol_name = "RENDER_CACHE_WRITE_L3NODE1";
        counter->desc = "Number of Render Cache writes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext119__render_cache_write_l3_node1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 12);
}

static void
mtlgt3_add_ext120_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext120";
    metric_set->symbol_name = "Ext120";
    metric_set->hw_config_guid = "045ee54e-4e02-4877-adb1-5bd14ba49100";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext120_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext120__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext120__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext120__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext120__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE0";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE0";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext120__pixel_post_process_input_available_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE1";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE1";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext120__pixel_post_process_input_available_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE2";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE2";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext120__pixel_post_process_input_available_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE3";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE3";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext120__pixel_post_process_input_available_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext121_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext121";
    metric_set->symbol_name = "Ext121";
    metric_set->hw_config_guid = "2e3894b5-2b6a-49c4-b2b6-0dde7375cb7b";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext121_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext121__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext121__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext121__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext121__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE4";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE4";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext121__pixel_post_process_input_available_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE5";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE5";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext121__pixel_post_process_input_available_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE6";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE6";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext121__pixel_post_process_input_available_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE XECORE7";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_XECORE7";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext121__pixel_post_process_input_available_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 7);
}

static void
mtlgt3_add_ext122_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext122";
    metric_set->symbol_name = "Ext122";
    metric_set->hw_config_guid = "25ca1237-2ed3-447a-9767-1a85da89daef";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext122_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS 4X4 SHADING REQUEST SLICE0";
        counter->symbol_name = "AMFS_4X4_SHADING_REQUEST_SLICE0";
        counter->desc = "Number of Shading Request (evaluate) messages processed by AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext122__amfs_4_x4_shading_request_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS 4X4 SHADING REQUEST SLICE1";
        counter->symbol_name = "AMFS_4X4_SHADING_REQUEST_SLICE1";
        counter->desc = "Number of Shading Request (evaluate) messages processed by AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext122__amfs_4_x4_shading_request_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext122__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext122__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE0";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE0";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__color_pipe_cache_latency1_stall_cpipe0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE1";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE1";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__color_pipe_cache_latency1_stall_cpipe1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE2";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE2";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__color_pipe_cache_latency1_stall_cpipe2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE3";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE3";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__color_pipe_cache_latency1_stall_cpipe3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext122__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext122__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE0";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE0";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__pixel_post_process_output_ready_cpipe0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE1";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE1";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__pixel_post_process_output_ready_cpipe1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE2";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE2";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__pixel_post_process_output_ready_cpipe2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE3";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE3";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext122__pixel_post_process_output_ready_cpipe3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 13);
}

static void
mtlgt3_add_ext123_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext123";
    metric_set->symbol_name = "Ext123";
    metric_set->hw_config_guid = "cf41fd07-c4c2-466c-9d85-774dcde02359";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext123_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ACCESS SLICE0";
        counter->symbol_name = "AMFS_L3_ACCESS_SLICE0";
        counter->desc = "Number of AMFS accesses to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext123__amfs_l3_access_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ACCESS SLICE1";
        counter->symbol_name = "AMFS_L3_ACCESS_SLICE1";
        counter->desc = "Number of AMFS accesses to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext123__amfs_l3_access_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ATOMIC SLICE0";
        counter->symbol_name = "AMFS_L3_ATOMIC_SLICE0";
        counter->desc = "Number of AMFS atomics to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext123__amfs_l3_atomic_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ATOMIC SLICE1";
        counter->symbol_name = "AMFS_L3_ATOMIC_SLICE1";
        counter->desc = "Number of AMFS atomics to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext123__amfs_l3_atomic_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext123__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext123__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "CLIPPER PRIMITIVE FAR NEAR CLIP SLICE0";
        counter->symbol_name = "CLIPPER_PRIMITIVE_FAR_NEAR_CLIP_SLICE0";
        counter->desc = "Number of primitives clipped by Clipper due to near/far planes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext123__clipper_primitive_far_near_clip_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "CLIPPER PRIMITIVE FAR NEAR CLIP SLICE1";
        counter->symbol_name = "CLIPPER_PRIMITIVE_FAR_NEAR_CLIP_SLICE1";
        counter->desc = "Number of primitives clipped by Clipper due to near/far planes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext123__clipper_primitive_far_near_clip_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY2 STALL L3NODE0";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE0";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext123__color_pipe_cache_latency2_stall_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY2 STALL L3NODE1";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE1";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext123__color_pipe_cache_latency2_stall_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext123__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext123__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL BACKEND INPUT AVAILABLE _L3NODE0";
        counter->symbol_name = "PIXEL_BACKEND_INPUT_AVAILABLE_L3NODE0";
        counter->desc = "Percentage of time when  the data is available at input of Pixel Backend";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext123__pixel_backend_input_available_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL BACKEND INPUT AVAILABLE _L3NODE1";
        counter->symbol_name = "PIXEL_BACKEND_INPUT_AVAILABLE_L3NODE1";
        counter->desc = "Percentage of time when  the data is available at input of Pixel Backend";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext123__pixel_backend_input_available_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL BACKEND OUTPUT READY _L3NODE0";
        counter->symbol_name = "PIXEL_BACKEND_OUTPUT_READY_L3NODE0";
        counter->desc = "Percentage of time when  the data at Pixel Backend output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext123__pixel_backend_output_ready_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL BACKEND OUTPUT READY _L3NODE1";
        counter->symbol_name = "PIXEL_BACKEND_OUTPUT_READY_L3NODE1";
        counter->desc = "Percentage of time when  the data at Pixel Backend output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext123__pixel_backend_output_ready_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    assert(metric_set->n_counters <= 15);
}

static void
mtlgt3_add_ext124_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext124";
    metric_set->symbol_name = "Ext124";
    metric_set->hw_config_guid = "2445e8f0-04c4-43f5-87ff-e2f99a2528ed";
    metric_set->counters = calloc(14, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    mtlgt3_ext124_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = mtlgt3__ext124__avg_gpu_core_frequency__read;
    counter->max_uint64 = mtlgt3__ext124__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "CLIPPER INPUT AVAILABLE SLICE0";
        counter->symbol_name = "CLIPPER_INPUT_AVAILABLE_SLICE0";
        counter->desc = "Percentage of time in which Clipper has input available (from Vertex Shader or SOL)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext124__clipper_input_available_slice0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "CLIPPER INPUT VERTEX SLICE0";
        counter->symbol_name = "CLIPPER_INPUT_VERTEX_SLICE0";
        counter->desc = "Number of Clipper input vertices";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext124__clipper_input_vertex_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "CLIPPER OUTPUT READY SLICE0";
        counter->symbol_name = "CLIPPER_OUTPUT_READY_SLICE0";
        counter->desc = "Percentage of time in which Clipper output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = mtlgt3__ext124__clipper_output_ready_slice0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "CLIPPER PRIMITIVE OUTPUT SLICE0";
        counter->symbol_name = "CLIPPER_PRIMITIVE_OUTPUT_SLICE0";
        counter->desc = "Number of primitives going out of Clipper, must clip plus the trivial accept";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = mtlgt3__ext124__clipper_primitive_output_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "GPU");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = mtlgt3__ext124__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = mtlgt3__ext124__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE0";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE0";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
      