/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_hsw.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_hsw.h"

static void
hsw_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic set";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "a490e9d2-55b3-4db0-8dab-53011032c5f3";
    metric_set->counters = calloc(70, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Alpha Test Fails";
    counter->symbol_name = "AlphaTestFails";
    counter->desc = "The total number of pixels dropped on post-FS alpha test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__alpha_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = hsw__render_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = hsw__render_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Duration";
    counter->symbol_name = "CsDuration";
    counter->desc = "Total Compute Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__render_basic__cs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Active";
    counter->symbol_name = "CsEuActive";
    counter->desc = "The percentage of time in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__cs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Active per Thread";
    counter->symbol_name = "CsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__cs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Stall";
    counter->symbol_name = "CsEuStall";
    counter->desc = "The percentage of time in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__cs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Stall per Thread";
    counter->symbol_name = "CsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__cs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__render_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES Duration";
    counter->symbol_name = "DsDuration";
    counter->desc = "Total Evaluation Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__render_basic__ds_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Active";
    counter->symbol_name = "DsEuActive";
    counter->desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__ds_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Active per Thread";
    counter->symbol_name = "DsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__ds_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Stall";
    counter->symbol_name = "DsEuStall";
    counter->desc = "The percentage of time in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__ds_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Stall per Thread";
    counter->symbol_name = "DsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__ds_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of evaluation shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__render_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Idle";
    counter->symbol_name = "EuIdle";
    counter->desc = "The percentage of time in which the Execution Units were idle.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__eu_idle__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has being processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = hsw__render_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Duration";
    counter->symbol_name = "GsDuration";
    counter->desc = "Total Geometry Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__render_basic__gs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Active";
    counter->symbol_name = "GsEuActive";
    counter->desc = "The percentage of time in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__gs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Active per Thread";
    counter->symbol_name = "GsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__gs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Stall";
    counter->symbol_name = "GsEuStall";
    counter->desc = "The percentage of time in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__gs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Stall per Thread";
    counter->symbol_name = "GsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__gs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__render_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Depth Throughput";
    counter->symbol_name = "GtiDepthThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between depth caches and GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__render_basic__gti_depth_throughput__read;
    counter->max_uint64 = hsw__render_basic__gti_depth_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI/Depth Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI L3 Throughput";
    counter->symbol_name = "GtiL3Throughput";
    counter->desc = "The total number of GPU memory bytes transferred between L3 caches and GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__render_basic__gti_l3_throughput__read;
    counter->max_uint64 = hsw__render_basic__gti_l3_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI/L3");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI RCC Throughput";
    counter->symbol_name = "GtiRccThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between render color caches and GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__render_basic__gti_rcc_throughput__read;
    counter->max_uint64 = hsw__render_basic__gti_rcc_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI/Color Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__render_basic__gti_read_throughput__read;
    counter->max_uint64 = hsw__render_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Fixed Pipe Throughput";
    counter->symbol_name = "GtiVfThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between 3D Pipeline (Command Dispatch, Input Assembly and Stream Output) and GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__render_basic__gti_vf_throughput__read;
    counter->max_uint64 = hsw__render_basic__gti_vf_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__render_basic__gti_write_throughput__read;
    counter->max_uint64 = hsw__render_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS Duration";
    counter->symbol_name = "HsDuration";
    counter->desc = "Total Control Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__render_basic__hs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Active";
    counter->symbol_name = "HsEuActive";
    counter->desc = "The percentage of time in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__hs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Active per Thread";
    counter->symbol_name = "HsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__hs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Stall";
    counter->symbol_name = "HsEuStall";
    counter->desc = "The percentage of time in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__hs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Stall per Thread";
    counter->symbol_name = "HsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__hs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of control shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__render_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 Sampler Throughput";
    counter->symbol_name = "L3SamplerThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between samplers and L3 caches.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__render_basic__l3_sampler_throughput__read;
    counter->max_uint64 = hsw__render_basic__l3_sampler_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Sampler");

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Accesses";
        counter->symbol_name = "LlcAccesses";
        counter->desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__render_basic__llc_accesses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Throughput";
        counter->symbol_name = "LlcGpuThroughput";
        counter->desc = "The total number of GPU memory bytes transferred between GPU and LLC.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = hsw__render_basic__llc_gpu_throughput__read;
        counter->max_uint64 = hsw__render_basic__llc_gpu_throughput__max;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Hits";
        counter->symbol_name = "LlcHits";
        counter->desc = "The total number of successful LLC cache lookups done from the GPU.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__render_basic__llc_hits__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Depth Test Fails";
    counter->symbol_name = "PostPsDepthTestFails";
    counter->desc = "The total number of pixels dropped on post-FS depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__post_ps_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Stencil Test Fails";
    counter->symbol_name = "PostPsStencilTestFails";
    counter->desc = "The total number of pixels dropped on post-FS stencil test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__post_ps_stencil_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Duration";
    counter->symbol_name = "PsDuration";
    counter->desc = "Total Fragment Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__render_basic__ps_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Active";
    counter->symbol_name = "PsEuActive";
    counter->desc = "The percentage of time in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__ps_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Active per Thread";
    counter->symbol_name = "PsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__ps_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Stall";
    counter->symbol_name = "PsEuStall";
    counter->desc = "The percentage of time in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__ps_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Stall per Thread";
    counter->symbol_name = "PsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__ps_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__render_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    if (perf->devinfo.subslice_mask & 0x1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler 0 Bottleneck";
        counter->symbol_name = "Sampler0Bottleneck";
        counter->desc = "The percentage of time in which sampler 0 was bottlenecks.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = hsw__render_basic__sampler0_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (perf->devinfo.subslice_mask & 0x1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler 0 Busy";
        counter->symbol_name = "Sampler0Busy";
        counter->desc = "The percentage of time in which sampler 0 was busy.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = hsw__render_basic__sampler0_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (perf->devinfo.subslice_mask & 0x1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler 0 Texels LOD0";
        counter->symbol_name = "Sampler0Texels";
        counter->desc = "The total number of texels lookups in LOD0 in sampler 0 unit.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
        counter->read_uint64 = hsw__render_basic__sampler0_texels__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (perf->devinfo.subslice_mask & 0x2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler 1 Bottleneck";
        counter->symbol_name = "Sampler1Bottleneck";
        counter->desc = "The percentage of time in which sampler 1 was bottlenecks.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = hsw__render_basic__sampler1_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (perf->devinfo.subslice_mask & 0x2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler 1 Busy";
        counter->symbol_name = "Sampler1Busy";
        counter->desc = "The percentage of time in which sampler 1 was busy.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = hsw__render_basic__sampler1_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (perf->devinfo.subslice_mask & 0x2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler 1 Texels LOD0";
        counter->symbol_name = "Sampler1Texels";
        counter->desc = "The total number of texels lookups in LOD0 in sampler 1 unit.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
        counter->read_uint64 = hsw__render_basic__sampler1_texels__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Bottleneck";
    counter->symbol_name = "SamplerBottleneck";
    counter->desc = "The percentage of time in which samplers were bottlenecks.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__sampler_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels LOD0";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels lookups in LOD0 in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = hsw__render_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samplers Busy";
    counter->symbol_name = "SamplersBusy";
    counter->desc = "The percentage of time in which samplers were busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__samplers_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__render_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Duration";
    counter->symbol_name = "VsDuration";
    counter->desc = "Total Vertex Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__render_basic__vs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Active";
    counter->symbol_name = "VsEuActive";
    counter->desc = "The percentage of time in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__vs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Active per Thread";
    counter->symbol_name = "VsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__vs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Stall";
    counter->symbol_name = "VsEuStall";
    counter->desc = "The percentage of time in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__render_basic__vs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Stall per Thread";
    counter->symbol_name = "VsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__render_basic__vs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__render_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 70);
}

static void
hsw_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic set";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "b344c8cb-a291-4cbf-aa9c-b40213bfc96f";
    metric_set->counters = calloc(52, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Alpha Test Fails";
    counter->symbol_name = "AlphaTestFails";
    counter->desc = "The total number of pixels dropped on post-FS alpha test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__compute_basic__alpha_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = hsw__compute_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = hsw__compute_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Active";
    counter->symbol_name = "CsEuActive";
    counter->desc = "The percentage of time in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__cs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Active per Thread";
    counter->symbol_name = "CsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__cs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Stall";
    counter->symbol_name = "CsEuStall";
    counter->desc = "The percentage of time in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__cs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Stall per Thread";
    counter->symbol_name = "CsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__cs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__compute_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Active";
    counter->symbol_name = "DsEuActive";
    counter->desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__ds_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Active per Thread";
    counter->symbol_name = "DsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__ds_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Stall";
    counter->symbol_name = "DsEuStall";
    counter->desc = "The percentage of time in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__ds_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Stall per Thread";
    counter->symbol_name = "DsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__ds_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of evaluation shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__compute_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__compute_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has being processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = hsw__compute_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Active";
    counter->symbol_name = "GsEuActive";
    counter->desc = "The percentage of time in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__gs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Active per Thread";
    counter->symbol_name = "GsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__gs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Stall";
    counter->symbol_name = "GsEuStall";
    counter->desc = "The percentage of time in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__gs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Stall per Thread";
    counter->symbol_name = "GsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__gs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__compute_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__compute_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Active";
    counter->symbol_name = "HsEuActive";
    counter->desc = "The percentage of time in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__hs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Active per Thread";
    counter->symbol_name = "HsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__hs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Stall";
    counter->symbol_name = "HsEuStall";
    counter->desc = "The percentage of time in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__hs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Stall per Thread";
    counter->symbol_name = "HsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__hs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of control shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__compute_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Accesses";
        counter->symbol_name = "LlcAccesses";
        counter->desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__compute_basic__llc_accesses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Hits";
        counter->symbol_name = "LlcHits";
        counter->desc = "The total number of successful LLC cache lookups done from the GPU.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__compute_basic__llc_hits__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Depth Test Fails";
    counter->symbol_name = "PostPsDepthTestFails";
    counter->desc = "The total number of pixels dropped on post-FS depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__compute_basic__post_ps_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Stencil Test Fails";
    counter->symbol_name = "PostPsStencilTestFails";
    counter->desc = "The total number of pixels dropped on post-FS stencil test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__compute_basic__post_ps_stencil_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Active";
    counter->symbol_name = "PsEuActive";
    counter->desc = "The percentage of time in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__ps_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Active per Thread";
    counter->symbol_name = "PsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__ps_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Stall";
    counter->symbol_name = "PsEuStall";
    counter->desc = "The percentage of time in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__ps_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Stall per Thread";
    counter->symbol_name = "PsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__ps_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__compute_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__compute_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__compute_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmBytesRead";
    counter->desc = "The total number of GPU memory bytes read from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__compute_basic__slm_bytes_read__read;
    counter->max_uint64 = hsw__compute_basic__slm_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Written";
    counter->symbol_name = "SlmBytesWritten";
    counter->desc = "The total number of byten written into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__compute_basic__slm_bytes_written__read;
    counter->max_uint64 = hsw__compute_basic__slm_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Typed Atomics";
    counter->symbol_name = "TypedAtomics";
    counter->desc = "The total number of typed atomics.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_basic__typed_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Typed Bytes Read";
    counter->symbol_name = "TypedBytesRead";
    counter->desc = "The total number of typed memory bytes read via Data Port.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__compute_basic__typed_bytes_read__read;
    counter->max_uint64 = hsw__compute_basic__typed_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Typed Bytes Written";
    counter->symbol_name = "TypedBytesWritten";
    counter->desc = "The total number of untyped memory bytes written via Data Port.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__compute_basic__typed_bytes_written__read;
    counter->max_uint64 = hsw__compute_basic__typed_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Untyped Bytes Read";
    counter->symbol_name = "UntypedBytesRead";
    counter->desc = "The total number of typed memory bytes read via Data Port.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__compute_basic__untyped_bytes_read__read;
    counter->max_uint64 = hsw__compute_basic__untyped_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Untyped Writes";
    counter->symbol_name = "UntypedBytesWritten";
    counter->desc = "The total number of untyped memory bytes written via Data Port.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = hsw__compute_basic__untyped_bytes_written__read;
    counter->max_uint64 = hsw__compute_basic__untyped_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Active";
    counter->symbol_name = "VsEuActive";
    counter->desc = "The percentage of time in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__vs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Active per Thread";
    counter->symbol_name = "VsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__vs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Stall";
    counter->symbol_name = "VsEuStall";
    counter->desc = "The percentage of time in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__compute_basic__vs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Stall per Thread";
    counter->symbol_name = "VsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_basic__vs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__compute_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 52);
}

static void
hsw_add_compute_extended_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Extended set";
    metric_set->symbol_name = "ComputeExtended";
    metric_set->hw_config_guid = "480f9795-cf6a-4204-a9e3-cd7015515f8d";
    metric_set->counters = calloc(22, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_compute_extended_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__compute_extended__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EuTypedAtomics0";
    counter->symbol_name = "EuTypedAtomics0";
    counter->desc = "The subslice 0 EU Typed Atomics subslice 0.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__eu_typed_atomics0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EuTypedReads0";
    counter->symbol_name = "EuTypedReads0";
    counter->desc = "The subslice 0 EU Typed Reads subslice 0.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__eu_typed_reads0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EuTypedWrites0";
    counter->symbol_name = "EuTypedWrites0";
    counter->desc = "The subslice 0 EU Typed Writes subslice 0.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__eu_typed_writes0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EuUntypedAtomics0";
    counter->symbol_name = "EuUntypedAtomics0";
    counter->desc = "The subslice 0 EU Untyped Atomics subslice 0.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__eu_untyped_atomics0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EuUntypedReads0";
    counter->symbol_name = "EuUntypedReads0";
    counter->desc = "The subslice 0 EU Untyped Reads subslice 0.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__eu_untyped_reads0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EuUntypedWrites0";
    counter->symbol_name = "EuUntypedWrites0";
    counter->desc = "The subslice 0 EU Untyped Writes subslice 0.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__eu_untyped_writes0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EuUrbAtomics0";
    counter->symbol_name = "EuUrbAtomics0";
    counter->desc = "The subslice 0 EU URB Atomics subslice 0.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__eu_urb_atomics0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__compute_extended__gpu_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = hsw__compute_extended__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Accesses";
        counter->symbol_name = "LlcAccesses";
        counter->desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__compute_extended__llc_accesses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Hits";
        counter->symbol_name = "LlcHits";
        counter->desc = "The total number of successful LLC cache lookups done from the GPU.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__compute_extended__llc_hits__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Typed Atomics 0";
    counter->symbol_name = "TypedAtomics0";
    counter->desc = "The subslice 0 typed atomics.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__typed_atomics0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TypedAtomicsPerCacheLine";
    counter->symbol_name = "TypedAtomicsPerCacheLine";
    counter->desc = "The ratio of EU typed atomics requests to L3 cache line writes.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES;
    counter->read_float = hsw__compute_extended__typed_atomics_per_cache_line__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Typed Reads 0";
    counter->symbol_name = "TypedReads0";
    counter->desc = "The subslice 0 typed reads.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__typed_reads0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TypedReadsPerCacheLine";
    counter->symbol_name = "TypedReadsPerCacheLine";
    counter->desc = "The ratio of EU typed read requests to L3 cache line reads.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES;
    counter->read_float = hsw__compute_extended__typed_reads_per_cache_line__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Typed Writes 0";
    counter->symbol_name = "TypedWrites0";
    counter->desc = "The subslice 0 typed writes.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__typed_writes0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TypedWritesPerCacheLine";
    counter->symbol_name = "TypedWritesPerCacheLine";
    counter->desc = "The ratio of EU typed write requests to L3 cache line writes.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES;
    counter->read_float = hsw__compute_extended__typed_writes_per_cache_line__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Untyped Reads 0";
    counter->symbol_name = "UntypedReads0";
    counter->desc = "The subslice 0 untyped reads (including SLM reads).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__untyped_reads0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "UntypedReadsPerCacheLine";
    counter->symbol_name = "UntypedReadsPerCacheLine";
    counter->desc = "The ratio of EU untyped read requests to L3 cache line reads.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES;
    counter->read_float = hsw__compute_extended__untyped_reads_per_cache_line__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Untyped Writes 0";
    counter->symbol_name = "UntypedWrites0";
    counter->desc = "The subslice 0 untyped writes (including SLM writes).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__compute_extended__untyped_writes0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "UntypedWritesPerCacheLine";
    counter->symbol_name = "UntypedWritesPerCacheLine";
    counter->desc = "The ratio of EU untyped write requests to L3 cache line writes.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EU_SENDS_TO_L3_CACHE_LINES;
    counter->read_float = hsw__compute_extended__untyped_writes_per_cache_line__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    assert(metric_set->n_counters <= 22);
}

static void
hsw_add_memory_reads_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Memory Reads Distribution set";
    metric_set->symbol_name = "MemoryReads";
    metric_set->hw_config_guid = "399d3001-97d6-4240-b065-4fb843138e17";
    metric_set->counters = calloc(56, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_memory_reads_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Alpha Test Fails";
    counter->symbol_name = "AlphaTestFails";
    counter->desc = "The total number of pixels dropped on post-FS alpha test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_reads__alpha_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = hsw__memory_reads__avg_gpu_core_frequency__read;
    counter->max_uint64 = hsw__memory_reads__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Active";
    counter->symbol_name = "CsEuActive";
    counter->desc = "The percentage of time in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__cs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Active per Thread";
    counter->symbol_name = "CsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__cs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Stall";
    counter->symbol_name = "CsEuStall";
    counter->desc = "The percentage of time in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__cs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Stall per Thread";
    counter->symbol_name = "CsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__cs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_reads__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Active";
    counter->symbol_name = "DsEuActive";
    counter->desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__ds_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Active per Thread";
    counter->symbol_name = "DsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__ds_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Stall";
    counter->symbol_name = "DsEuStall";
    counter->desc = "The percentage of time in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__ds_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Stall per Thread";
    counter->symbol_name = "DsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__ds_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of evaluation shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_reads__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_reads__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has being processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = hsw__memory_reads__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Active";
    counter->symbol_name = "GsEuActive";
    counter->desc = "The percentage of time in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__gs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Active per Thread";
    counter->symbol_name = "GsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__gs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Stall";
    counter->symbol_name = "GsEuStall";
    counter->desc = "The percentage of time in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__gs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Stall per Thread";
    counter->symbol_name = "GsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__gs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_reads__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiCmdStreamerMemoryReads";
    counter->symbol_name = "GtiCmdStreamerMemoryReads";
    counter->desc = "The total number of GTI memory reads from Command Streamer.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_cmd_streamer_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/3D Pipe/Command Streamer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiHiDepthMemoryReads";
    counter->symbol_name = "GtiHiDepthMemoryReads";
    counter->desc = "The total number of GTI memory reads from Hierarchical Depth Cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_hi_depth_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Depth Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiL3Reads";
    counter->symbol_name = "GtiL3Reads";
    counter->desc = "The total number of GTI memory reads from L3 (L3 misses).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_l3_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiMemoryReads";
    counter->symbol_name = "GtiMemoryReads";
    counter->desc = "The total number of GTI memory reads (64B each).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiMscMemoryReads";
    counter->symbol_name = "GtiMscMemoryReads";
    counter->desc = "The total number of GTI memory reads from Multisampling Color Cache (Multisampling Color Cache misses).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_msc_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Color Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiRccMemoryReads";
    counter->symbol_name = "GtiRccMemoryReads";
    counter->desc = "The total number of GTI memory reads from Render Color Cache (Render Color Cache misses).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_rcc_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Color Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiRczMemoryReads";
    counter->symbol_name = "GtiRczMemoryReads";
    counter->desc = "The total number of GTI memory reads from Render Depth Cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_rcz_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Depth Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiRsMemoryReads";
    counter->symbol_name = "GtiRsMemoryReads";
    counter->desc = "The total number of GTI memory reads from Resource Streamer.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_rs_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/3D Pipe/Resource Streamer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiStcMemoryReads";
    counter->symbol_name = "GtiStcMemoryReads";
    counter->desc = "The total number of GTI memory reads from Stencil Cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_stc_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Depth Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiVfMemoryReads";
    counter->symbol_name = "GtiVfMemoryReads";
    counter->desc = "The total number of GTI memory reads from Vertex Fetch.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__gti_vf_memory_reads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/3D Pipe/Vertex Fetch");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_reads__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Active";
    counter->symbol_name = "HsEuActive";
    counter->desc = "The percentage of time in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__hs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Active per Thread";
    counter->symbol_name = "HsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__hs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Stall";
    counter->symbol_name = "HsEuStall";
    counter->desc = "The percentage of time in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__hs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Stall per Thread";
    counter->symbol_name = "HsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__hs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of control shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_reads__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Accesses";
        counter->symbol_name = "LlcAccesses";
        counter->desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__memory_reads__llc_accesses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Hits";
        counter->symbol_name = "LlcHits";
        counter->desc = "The total number of successful LLC cache lookups done from the GPU.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__memory_reads__llc_hits__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "LLC GPU Read Accesses";
    counter->symbol_name = "LlcReadAccesses";
    counter->desc = "The total number of LLC cache lookups for reads done from the GPU.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_reads__llc_read_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "LLC");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Depth Test Fails";
    counter->symbol_name = "PostPsDepthTestFails";
    counter->desc = "The total number of pixels dropped on post-FS depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_reads__post_ps_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Stencil Test Fails";
    counter->symbol_name = "PostPsStencilTestFails";
    counter->desc = "The total number of pixels dropped on post-FS stencil test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_reads__post_ps_stencil_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Active";
    counter->symbol_name = "PsEuActive";
    counter->desc = "The percentage of time in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__ps_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Active per Thread";
    counter->symbol_name = "PsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__ps_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Stall";
    counter->symbol_name = "PsEuStall";
    counter->desc = "The percentage of time in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__ps_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Stall per Thread";
    counter->symbol_name = "PsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__ps_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_reads__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_reads__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_reads__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Active";
    counter->symbol_name = "VsEuActive";
    counter->desc = "The percentage of time in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__vs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Active per Thread";
    counter->symbol_name = "VsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__vs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Stall";
    counter->symbol_name = "VsEuStall";
    counter->desc = "The percentage of time in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_reads__vs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Stall per Thread";
    counter->symbol_name = "VsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_reads__vs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_reads__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 56);
}

static void
hsw_add_memory_writes_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Memory Writes Distribution set";
    metric_set->symbol_name = "MemoryWrites";
    metric_set->hw_config_guid = "f3c1ff4b-d0da-4ffa-8780-2c6b98f3f2d5";
    metric_set->counters = calloc(56, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_memory_writes_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Alpha Test Fails";
    counter->symbol_name = "AlphaTestFails";
    counter->desc = "The total number of pixels dropped on post-FS alpha test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_writes__alpha_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = hsw__memory_writes__avg_gpu_core_frequency__read;
    counter->max_uint64 = hsw__memory_writes__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Active";
    counter->symbol_name = "CsEuActive";
    counter->desc = "The percentage of time in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__cs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Active per Thread";
    counter->symbol_name = "CsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__cs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Stall";
    counter->symbol_name = "CsEuStall";
    counter->desc = "The percentage of time in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__cs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Stall per Thread";
    counter->symbol_name = "CsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__cs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_writes__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Active";
    counter->symbol_name = "DsEuActive";
    counter->desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__ds_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Active per Thread";
    counter->symbol_name = "DsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__ds_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Stall";
    counter->symbol_name = "DsEuStall";
    counter->desc = "The percentage of time in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__ds_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Stall per Thread";
    counter->symbol_name = "DsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__ds_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of evaluation shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_writes__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_writes__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has being processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = hsw__memory_writes__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Active";
    counter->symbol_name = "GsEuActive";
    counter->desc = "The percentage of time in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__gs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Active per Thread";
    counter->symbol_name = "GsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__gs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Stall";
    counter->symbol_name = "GsEuStall";
    counter->desc = "The percentage of time in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__gs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Stall per Thread";
    counter->symbol_name = "GsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__gs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_writes__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiCmdStreamerMemoryWrites";
    counter->symbol_name = "GtiCmdStreamerMemoryWrites";
    counter->desc = "The total number of GTI memory writes from Command Streamer.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_cmd_streamer_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/3D Pipe/Command Streamer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiHizMemoryWrites";
    counter->symbol_name = "GtiHizMemoryWrites";
    counter->desc = "The total number of GTI memory writes from Hierarchical Depth Cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_hiz_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Depth Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiL3Writes";
    counter->symbol_name = "GtiL3Writes";
    counter->desc = "The total number of GTI memory writes from L3 (L3 invalidations).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_l3_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/L3");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiMemoryWrites";
    counter->symbol_name = "GtiMemoryWrites";
    counter->desc = "The total number of GTI memory writes (64B each).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiMscMemoryWrites";
    counter->symbol_name = "GtiMscMemoryWrites";
    counter->desc = "The total number of GTI memory writes from Multisampling Color Cache (Multisampling Color Cache invalidations).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_msc_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Color Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiRccMemoryWrites";
    counter->symbol_name = "GtiRccMemoryWrites";
    counter->desc = "The total number of GTI memory writes from Render Color Cache (Render Color Cache invalidations).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_rcc_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Color Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiRczMemoryWrites";
    counter->symbol_name = "GtiRczMemoryWrites";
    counter->desc = "The total number of GTI memory writes from Render Depth Cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_rcz_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Depth Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiSoMemoryWrites";
    counter->symbol_name = "GtiSoMemoryWrites";
    counter->desc = "The total number of GTI memory writes from Stream Output.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_so_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/3D Pipe/Stream Output");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GtiStcMemoryWrites";
    counter->symbol_name = "GtiStcMemoryWrites";
    counter->desc = "The total number of GTI memory writes from Stencil Cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__gti_stc_memory_writes__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GTI/Depth Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_writes__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Active";
    counter->symbol_name = "HsEuActive";
    counter->desc = "The percentage of time in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__hs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Active per Thread";
    counter->symbol_name = "HsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__hs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Stall";
    counter->symbol_name = "HsEuStall";
    counter->desc = "The percentage of time in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__hs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Stall per Thread";
    counter->symbol_name = "HsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__hs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of control shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_writes__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Accesses";
        counter->symbol_name = "LlcAccesses";
        counter->desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__memory_writes__llc_accesses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Throughput";
        counter->symbol_name = "LlcGpuThroughput";
        counter->desc = "The total number of GPU memory bytes transferred between GPU and LLC.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = hsw__memory_writes__llc_gpu_throughput__read;
        counter->max_uint64 = hsw__memory_writes__llc_gpu_throughput__max;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Hits";
        counter->symbol_name = "LlcHits";
        counter->desc = "The total number of successful LLC cache lookups done from the GPU.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__memory_writes__llc_hits__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "LLC GPU Write Accesses";
    counter->symbol_name = "LlcWrAccesses";
    counter->desc = "The total number of LLC cache lookups for write done from the GPU (32B writes).";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__memory_writes__llc_wr_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "LLC");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Depth Test Fails";
    counter->symbol_name = "PostPsDepthTestFails";
    counter->desc = "The total number of pixels dropped on post-FS depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_writes__post_ps_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Stencil Test Fails";
    counter->symbol_name = "PostPsStencilTestFails";
    counter->desc = "The total number of pixels dropped on post-FS stencil test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_writes__post_ps_stencil_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Active";
    counter->symbol_name = "PsEuActive";
    counter->desc = "The percentage of time in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__ps_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Active per Thread";
    counter->symbol_name = "PsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__ps_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Stall";
    counter->symbol_name = "PsEuStall";
    counter->desc = "The percentage of time in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__ps_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Stall per Thread";
    counter->symbol_name = "PsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__ps_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_writes__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_writes__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__memory_writes__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Active";
    counter->symbol_name = "VsEuActive";
    counter->desc = "The percentage of time in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__vs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Active per Thread";
    counter->symbol_name = "VsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__vs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Stall";
    counter->symbol_name = "VsEuStall";
    counter->desc = "The percentage of time in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__memory_writes__vs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Stall per Thread";
    counter->symbol_name = "VsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__memory_writes__vs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__memory_writes__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 56);
}

static void
hsw_add_sampler_balance_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set SamplerBalance";
    metric_set->symbol_name = "SamplerBalance";
    metric_set->hw_config_guid = "e111cda4-19c3-41ee-b326-f99ac44ebf78";
    metric_set->counters = calloc(57, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A45_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->a_offset = 1;
    metric_set->b_offset = metric_set->a_offset + 45;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    hsw_sampler_balance_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Alpha Test Fails";
    counter->symbol_name = "AlphaTestFails";
    counter->desc = "The total number of pixels dropped on post-FS alpha test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__sampler_balance__alpha_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = hsw__sampler_balance__avg_gpu_core_frequency__read;
    counter->max_uint64 = hsw__sampler_balance__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Duration";
    counter->symbol_name = "CsDuration";
    counter->desc = "Total Compute Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__sampler_balance__cs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Active";
    counter->symbol_name = "CsEuActive";
    counter->desc = "The percentage of time in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__cs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Active per Thread";
    counter->symbol_name = "CsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__cs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EU Stall";
    counter->symbol_name = "CsEuStall";
    counter->desc = "The percentage of time in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__cs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS AVG Stall per Thread";
    counter->symbol_name = "CsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which compute shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__cs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__sampler_balance__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES Duration";
    counter->symbol_name = "DsDuration";
    counter->desc = "Total Evaluation Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__sampler_balance__ds_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Active";
    counter->symbol_name = "DsEuActive";
    counter->desc = "The percentage of time in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__ds_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Active per Thread";
    counter->symbol_name = "DsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__ds_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES EU Stall";
    counter->symbol_name = "DsEuStall";
    counter->desc = "The percentage of time in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__ds_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES AVG Stall per Thread";
    counter->symbol_name = "DsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which evaluation shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__ds_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TES Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of evaluation shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__sampler_balance__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Evaluation Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__sampler_balance__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Idle";
    counter->symbol_name = "EuIdle";
    counter->desc = "The percentage of time in which the Execution Units were idle.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__eu_idle__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has being processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = hsw__sampler_balance__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Duration";
    counter->symbol_name = "GsDuration";
    counter->desc = "Total Geometry Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__sampler_balance__gs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Active";
    counter->symbol_name = "GsEuActive";
    counter->desc = "The percentage of time in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__gs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Active per Thread";
    counter->symbol_name = "GsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__gs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EU Stall";
    counter->symbol_name = "GsEuStall";
    counter->desc = "The percentage of time in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__gs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS AVG Stall per Thread";
    counter->symbol_name = "GsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which geometry shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__gs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__sampler_balance__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__sampler_balance__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS Duration";
    counter->symbol_name = "HsDuration";
    counter->desc = "Total Control Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__sampler_balance__hs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Active";
    counter->symbol_name = "HsEuActive";
    counter->desc = "The percentage of time in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__hs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Active per Thread";
    counter->symbol_name = "HsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__hs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS EU Stall";
    counter->symbol_name = "HsEuStall";
    counter->desc = "The percentage of time in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__hs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS AVG Stall per Thread";
    counter->symbol_name = "HsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which control shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__hs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TCS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of control shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__sampler_balance__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Control Shader");

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Accesses";
        counter->symbol_name = "LlcAccesses";
        counter->desc = "The total number of LLC cache lookups done from the GPU (64b reads, 32B writes).";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__sampler_balance__llc_accesses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    if (true &&
        perf->devinfo.query_mode) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "LLC GPU Hits";
        counter->symbol_name = "LlcHits";
        counter->desc = "The total number of successful LLC cache lookups done from the GPU.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__sampler_balance__llc_hits__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "LLC");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Depth Test Fails";
    counter->symbol_name = "PostPsDepthTestFails";
    counter->desc = "The total number of pixels dropped on post-FS depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__sampler_balance__post_ps_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Late Stencil Test Fails";
    counter->symbol_name = "PostPsStencilTestFails";
    counter->desc = "The total number of pixels dropped on post-FS stencil test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__sampler_balance__post_ps_stencil_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Duration";
    counter->symbol_name = "PsDuration";
    counter->desc = "Total Fragment Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__sampler_balance__ps_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Active";
    counter->symbol_name = "PsEuActive";
    counter->desc = "The percentage of time in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__ps_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Active per Thread";
    counter->symbol_name = "PsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__ps_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EU Stall";
    counter->symbol_name = "PsEuStall";
    counter->desc = "The percentage of time in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__ps_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS AVG Stall per Thread";
    counter->symbol_name = "PsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which fragment shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__ps_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__sampler_balance__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    if (perf->devinfo.subslice_mask & 0x1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler L2 cache misses (ss0)";
        counter->symbol_name = "Sampler0L2CacheMisses";
        counter->desc = "Number of sampler L2 cache misses (ss0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__sampler_balance__sampler0_l2_cache_misses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");
    }

    if (perf->devinfo.subslice_mask & 0x2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler L2 cache misses (ss1)";
        counter->symbol_name = "Sampler1L2CacheMisses";
        counter->desc = "Number of sampler L2 cache misses (ss1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__sampler_balance__sampler1_l2_cache_misses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");
    }

    if (perf->devinfo.subslice_mask & 0x4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler L2 cache misses (ss2)";
        counter->symbol_name = "Sampler2L2CacheMisses";
        counter->desc = "Number of sampler L2 cache misses (ss2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__sampler_balance__sampler2_l2_cache_misses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");
    }

    if (perf->devinfo.subslice_mask & 0x8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler L2 cache misses (ss3)";
        counter->symbol_name = "Sampler3L2CacheMisses";
        counter->desc = "Number of sampler L2 cache misses (ss3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
        counter->read_uint64 = hsw__sampler_balance__sampler3_l2_cache_misses__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler L2 cache misses";
    counter->symbol_name = "SamplerL2CacheMisses";
    counter->desc = "Number of sampler L2 cache misses";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = hsw__sampler_balance__sampler_l2_cache_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__sampler_balance__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = hsw__sampler_balance__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Duration";
    counter->symbol_name = "VsDuration";
    counter->desc = "Total Vertex Shader GPU duration.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_US;
    counter->read_uint64 = hsw__sampler_balance__vs_duration__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Active";
    counter->symbol_name = "VsEuActive";
    counter->desc = "The percentage of time in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__vs_eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Active per Thread";
    counter->symbol_name = "VsEuActivePerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were processed actively on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__vs_eu_active_per_thread__read;
    counter->max_uint64 = percentage_max_callback_uint64;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EU Stall";
    counter->symbol_name = "VsEuStall";
    counter->desc = "The percentage of time in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = hsw__sampler_balance__vs_eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS AVG Stall per Thread";
    counter->symbol_name = "VsEuStallPerThread";
    counter->desc = "The average number of cycles per hardware thread run in which vertex shaders were stalled on the EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = hsw__sampler_balance__vs_eu_stall_per_thread__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = hsw__sampler_balance__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 57);
}

void
intel_perf_load_metrics_hsw(struct intel_perf *perf)
{
    hsw_add_render_basic_metric_set(perf);
    hsw_add_compute_basic_metric_set(perf);
    hsw_add_compute_extended_metric_set(perf);
    hsw_add_memory_reads_metric_set(perf);
    hsw_add_memory_writes_metric_set(perf);
    hsw_add_sampler_balance_metric_set(perf);
}
