/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_dg1.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_dg1.h"

static void
dg1_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic set";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "1caf6b6d-a1ef-40d3-9033-311e482b826e";
    metric_set->counters = calloc(34, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__render_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__render_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_basic__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_basic__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_basic__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__render_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__render_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_basic__gti_read_throughput__read;
    counter->max_uint64 = dg1__render_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_basic__gti_write_throughput__read;
    counter->max_uint64 = dg1__render_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 Shader Throughput";
    counter->symbol_name = "L3ShaderThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_basic__l3_shader_throughput__read;
    counter->max_uint64 = dg1__render_basic__l3_shader_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_basic__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_basic__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler Slice0 Dualsubslice0 is bottleneck";
        counter->symbol_name = "Sampler00Bottleneck";
        counter->desc = "The percentage of time when sampler slice0 dualsubslice0 is bottleneck";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__render_basic__sampler00_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler00 Busy";
        counter->symbol_name = "Sampler00Busy";
        counter->desc = "The percentage of time in which Slice0 Sampler0 has been processing EU requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__render_basic__sampler00_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Bottleneck";
        counter->symbol_name = "SamplerBottleneck";
        counter->desc = "The percentage of time in which samplers have been slowing down the pipe when processing EU requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__render_basic__sampler_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__render_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__render_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Input");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Busy";
        counter->symbol_name = "SamplersBusy";
        counter->desc = "The percentage of time in which samplers have been processing EU requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__render_basic__samplers_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_basic__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__render_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/Atomics");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__render_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Barrier");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__render_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmBytesRead";
    counter->desc = "The total number of GPU memory bytes read from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_basic__slm_bytes_read__read;
    counter->max_uint64 = dg1__render_basic__slm_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Written";
    counter->symbol_name = "SlmBytesWritten";
    counter->desc = "The total number of GPU memory bytes written into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_basic__slm_bytes_written__read;
    counter->max_uint64 = dg1__render_basic__slm_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 34);
}

static void
dg1_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic set";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "e347a2bd-079d-4a77-b546-c3c114c55bae";
    metric_set->counters = calloc(30, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__compute_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__compute_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__compute_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__compute_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__compute_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__compute_basic__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__compute_basic__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__compute_basic__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__compute_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__compute_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__compute_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__compute_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__compute_basic__gti_read_throughput__read;
    counter->max_uint64 = dg1__compute_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__compute_basic__gti_write_throughput__read;
    counter->max_uint64 = dg1__compute_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__compute_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__compute_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 Shader Throughput";
    counter->symbol_name = "L3ShaderThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__compute_basic__l3_shader_throughput__read;
    counter->max_uint64 = dg1__compute_basic__l3_shader_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__compute_basic__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__compute_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__compute_basic__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__compute_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__compute_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Input");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__compute_basic__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__compute_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__compute_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__compute_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/Atomics");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__compute_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Barrier");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__compute_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmBytesRead";
    counter->desc = "The total number of GPU memory bytes read from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__compute_basic__slm_bytes_read__read;
    counter->max_uint64 = dg1__compute_basic__slm_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Written";
    counter->symbol_name = "SlmBytesWritten";
    counter->desc = "The total number of GPU memory bytes written into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__compute_basic__slm_bytes_written__read;
    counter->max_uint64 = dg1__compute_basic__slm_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__compute_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 30);
}

static void
dg1_add_render_pipe_profile_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile";
    metric_set->hw_config_guid = "3b27f553-aebc-45ec-aa2f-926d81a91fd9";
    metric_set->counters = calloc(43, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_render_pipe_profile_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__render_pipe_profile__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__render_pipe_profile__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC Bottleneck";
    counter->symbol_name = "BcBottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__bc_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Barycentric Calc");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper Bottleneck";
    counter->symbol_name = "ClBottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__cl_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Clipper");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL Stall";
    counter->symbol_name = "ClStall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__cl_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Clipper");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_pipe_profile__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Bottleneck";
    counter->symbol_name = "DsBottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__ds_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Stall";
    counter->symbol_name = "DsStall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__ds_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_pipe_profile__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_pipe_profile__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__render_pipe_profile__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__render_pipe_profile__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Bottleneck";
    counter->symbol_name = "GsBottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__gs_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_pipe_profile__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth Bottleneck";
    counter->symbol_name = "HiDepthBottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__hi_depth_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_pipe_profile__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Bottleneck";
    counter->symbol_name = "HsBottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__hs_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Stall";
    counter->symbol_name = "HsStall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__hs_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_pipe_profile__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 Shader Throughput";
    counter->symbol_name = "L3ShaderThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_pipe_profile__l3_shader_throughput__read;
    counter->max_uint64 = dg1__render_pipe_profile__l3_shader_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_pipe_profile__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_pipe_profile__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_pipe_profile__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__render_pipe_profile__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__render_pipe_profile__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Input");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_pipe_profile__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_pipe_profile__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__render_pipe_profile__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Strip-Fans Bottleneck";
    counter->symbol_name = "SfBottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__sf_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Strip-Fans");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF Stall";
    counter->symbol_name = "SfStall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__sf_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Strip-Fans");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__render_pipe_profile__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/Atomics");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__render_pipe_profile__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Barrier");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__render_pipe_profile__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmBytesRead";
    counter->desc = "The total number of GPU memory bytes read from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_pipe_profile__slm_bytes_read__read;
    counter->max_uint64 = dg1__render_pipe_profile__slm_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Written";
    counter->symbol_name = "SlmBytesWritten";
    counter->desc = "The total number of GPU memory bytes written into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__render_pipe_profile__slm_bytes_written__read;
    counter->max_uint64 = dg1__render_pipe_profile__slm_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO Bottleneck";
    counter->symbol_name = "SoBottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__so_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Stream Output");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO Stall";
    counter->symbol_name = "SoStall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__so_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Stream Output");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF Bottleneck";
    counter->symbol_name = "VfBottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__vf_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Input Assembler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Bottleneck";
    counter->symbol_name = "VsBottleneck";
    counter->desc = "The percentage of time in which vertex shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__render_pipe_profile__vs_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__render_pipe_profile__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 43);
}

static void
dg1_add_hdc_and_sf_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF (DG1)";
    metric_set->symbol_name = "HDCAndSF";
    metric_set->hw_config_guid = "1fa73aed-3861-4c19-8105-e55986c8a4e5";
    metric_set->counters = calloc(38, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_hdc_and_sf_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__hdc_and_sf__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__hdc_and_sf__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__hdc_and_sf__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__hdc_and_sf__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__hdc_and_sf__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__hdc_and_sf__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__hdc_and_sf__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__hdc_and_sf__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__hdc_and_sf__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__hdc_and_sf__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 Shader Throughput";
    counter->symbol_name = "L3ShaderThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__hdc_and_sf__l3_shader_throughput__read;
    counter->max_uint64 = dg1__hdc_and_sf__l3_shader_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Dualsubslice0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader00AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__hdc_and_sf__non_sampler_shader00_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Dualsubslice1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader01AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__hdc_and_sf__non_sampler_shader01_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Dualsubslice2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader02AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__hdc_and_sf__non_sampler_shader02_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Dualsubslice3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader03AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__hdc_and_sf__non_sampler_shader03_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Dualsubslice4 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader04AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice4)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__hdc_and_sf__non_sampler_shader04_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Dualsubslice5 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader05AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Dualsubslice5)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__hdc_and_sf__non_sampler_shader05_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Data Port");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData00Ready";
    counter->desc = "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__pixel_data00_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData01Ready";
    counter->desc = "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__pixel_data01_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe2 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData02Ready";
    counter->desc = "The percentage of time in which slice0  pipe2 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__pixel_data02_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__hdc_and_sf__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon Data Ready";
    counter->symbol_name = "PolyDataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__hdc_and_sf__poly_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe/Strip-Fans");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__hdc_and_sf__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__hdc_and_sf__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__hdc_and_sf__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__hdc_and_sf__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Input");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__hdc_and_sf__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__hdc_and_sf__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__hdc_and_sf__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__hdc_and_sf__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/Atomics");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__hdc_and_sf__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Barrier");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__hdc_and_sf__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmBytesRead";
    counter->desc = "The total number of GPU memory bytes read from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__hdc_and_sf__slm_bytes_read__read;
    counter->max_uint64 = dg1__hdc_and_sf__slm_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Written";
    counter->symbol_name = "SlmBytesWritten";
    counter->desc = "The total number of GPU memory bytes written into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__hdc_and_sf__slm_bytes_written__read;
    counter->max_uint64 = dg1__hdc_and_sf__slm_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__hdc_and_sf__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 38);
}

static void
dg1_add_rasterizer_and_pixel_backend_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend";
    metric_set->symbol_name = "RasterizerAndPixelBackend";
    metric_set->hw_config_guid = "2bb016ee-a9b7-477e-8d5d-f7fd179a8f16";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_rasterizer_and_pixel_backend_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__rasterizer_and_pixel_backend__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Early Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ00 is full";
    counter->symbol_name = "GTRequestQueue00Full";
    counter->desc = "The percentage of time when IDI0 SQ0 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__gt_request_queue00_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ01 is full";
    counter->symbol_name = "GTRequestQueue01Full";
    counter->desc = "The percentage of time when IDI0 SQ1 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__gt_request_queue01_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ10 is full";
    counter->symbol_name = "GTRequestQueue10Full";
    counter->desc = "The percentage of time when IDI1 SQ0 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__gt_request_queue10_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ11 is full";
    counter->symbol_name = "GTRequestQueue11Full";
    counter->desc = "The percentage of time when IDI1 SQ1 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__gt_request_queue11_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer/Hi-Depth Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 Shader Throughput";
    counter->symbol_name = "L3ShaderThroughput";
    counter->desc = "The total number of GPU memory bytes transferred between shaders and L3 caches w/o URB.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__l3_shader_throughput__read;
    counter->max_uint64 = dg1__rasterizer_and_pixel_backend__l3_shader_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe0 PS Output Available";
    counter->symbol_name = "PSOutput00Available";
    counter->desc = "The percentage of time in which slice0 pipe0 PS output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__ps_output00_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe1 PS Output Available";
    counter->symbol_name = "PSOutput01Available";
    counter->desc = "The percentage of time in which slice0 pipe1 PS output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__ps_output01_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe2 PS Output Available";
    counter->symbol_name = "PSOutput02Available";
    counter->desc = "The percentage of time in which slice0 pipe2 PS output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__ps_output02_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe0 Pixel Values Ready";
    counter->symbol_name = "PixelValues00Ready";
    counter->desc = "The percentage of time in which slice0 pipe0 pixel values are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__pixel_values00_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe1 Pixel Values Ready";
    counter->symbol_name = "PixelValues01Ready";
    counter->desc = "The percentage of time in which slice0 pipe1 pixel values are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__pixel_values01_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe2 Pixel Values Ready";
    counter->symbol_name = "PixelValues02Ready";
    counter->desc = "The percentage of time in which slice0 pipe2 pixel values are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__rasterizer_and_pixel_backend__pixel_values02_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU/3D Pipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Rasterizer");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer0InputAvailable";
        counter->desc = "The percentage of time in which slice0 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__rasterizer_and_pixel_backend__rasterizer0_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer0OutputReady";
        counter->desc = "The percentage of time in which slice0 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__rasterizer_and_pixel_backend__rasterizer0_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Rasterizer");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler/Sampler Input");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "3D Pipe/Output Merger");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/Atomics");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Barrier");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmBytesRead";
    counter->desc = "The total number of GPU memory bytes read from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__slm_bytes_read__read;
    counter->max_uint64 = dg1__rasterizer_and_pixel_backend__slm_bytes_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Written";
    counter->symbol_name = "SlmBytesWritten";
    counter->desc = "The total number of GPU memory bytes written into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__slm_bytes_written__read;
    counter->max_uint64 = dg1__rasterizer_and_pixel_backend__slm_bytes_written__max;
    intel_perf_add_logical_counter(perf, counter, "L3/Data Port/SLM");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__rasterizer_and_pixel_backend__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 40);
}

static void
dg1_add_l3_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_1";
    metric_set->symbol_name = "L3_1";
    metric_set->hw_config_guid = "cdccda4b-c7c9-41a9-965f-fc2adf8cff0b";
    metric_set->counters = calloc(17, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_l3_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__l3_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__l3_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_1__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_1__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_1__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_1__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_1__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__l3_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__l3_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_1__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_1__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank0 Input Available";
        counter->symbol_name = "L30Bank0InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank0 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_1__l30_bank0_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank1 Input Available";
        counter->symbol_name = "L30Bank1InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank1 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_1__l30_bank1_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank4 Input Available";
        counter->symbol_name = "L30Bank4InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank4 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_1__l30_bank4_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank5 Input Available";
        counter->symbol_name = "L30Bank5InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank5 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_1__l30_bank5_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_1__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_1__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 17);
}

static void
dg1_add_l3_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_2";
    metric_set->symbol_name = "L3_2";
    metric_set->hw_config_guid = "3c44fb1b-f9b3-4d52-a507-e2b2a80ec8b7";
    metric_set->counters = calloc(17, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_l3_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__l3_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__l3_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_2__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_2__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_2__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_2__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_2__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__l3_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__l3_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_2__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_2__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank2 Input Available";
        counter->symbol_name = "L30Bank2InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank2 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_2__l30_bank2_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank3 Input Available";
        counter->symbol_name = "L30Bank3InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank3 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_2__l30_bank3_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank6 Input Available";
        counter->symbol_name = "L30Bank6InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank6 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_2__l30_bank6_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank7 Input Available";
        counter->symbol_name = "L30Bank7InputAvailable";
        counter->desc = "The percentage of time in which slice0 L3 bank7 has input available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_2__l30_bank7_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_2__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_2__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 17);
}

static void
dg1_add_l3_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_3";
    metric_set->symbol_name = "L3_3";
    metric_set->hw_config_guid = "ec911098-71bf-4432-9153-6143e3cfbe06";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_l3_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__l3_3__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__l3_3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_3__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_3__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_3__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_3__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_3__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__l3_3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__l3_3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_3__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_3__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank0 Output Ready";
        counter->symbol_name = "L30Bank0OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank0 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_3__l30_bank0_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank4 Output Ready";
        counter->symbol_name = "L30Bank4OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank4 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_3__l30_bank4_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_3__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_3__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 15);
}

static void
dg1_add_l3_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_4";
    metric_set->symbol_name = "L3_4";
    metric_set->hw_config_guid = "17d351db-7916-4eea-9817-29ca522daacd";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_l3_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__l3_4__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__l3_4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_4__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_4__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_4__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_4__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_4__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__l3_4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__l3_4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_4__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_4__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank1 Output Ready";
        counter->symbol_name = "L30Bank1OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank1 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_4__l30_bank1_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank5 Output Ready";
        counter->symbol_name = "L30Bank5OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank5 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_4__l30_bank5_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_4__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_4__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 15);
}

static void
dg1_add_l3_5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_5";
    metric_set->symbol_name = "L3_5";
    metric_set->hw_config_guid = "f2de5846-f330-4d26-ad41-824deb6b53f6";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_l3_5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__l3_5__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__l3_5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_5__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_5__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_5__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_5__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_5__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_5__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__l3_5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__l3_5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_5__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_5__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank2 Output Ready";
        counter->symbol_name = "L30Bank2OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank2 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_5__l30_bank2_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank6 Output Ready";
        counter->symbol_name = "L30Bank6OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank6 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_5__l30_bank6_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_5__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_5__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 15);
}

static void
dg1_add_l3_6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_6";
    metric_set->symbol_name = "L3_6";
    metric_set->hw_config_guid = "8f4ccb12-ee11-4741-93d4-d431b8ca58ef";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_l3_6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__l3_6__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__l3_6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_6__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_6__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_6__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_6__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_6__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__l3_6__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__l3_6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__l3_6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_6__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_6__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank3 Output Ready";
        counter->symbol_name = "L30Bank3OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank3 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_6__l30_bank3_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 L3 Bank7 Output Ready";
        counter->symbol_name = "L30Bank7OutputReady";
        counter->desc = "The percentage of time in which slice0 L3 bank7 output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__l3_6__l30_bank7_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GTI/L3");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_6__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__l3_6__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 15);
}

static void
dg1_add_sampler_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_1";
    metric_set->symbol_name = "Sampler_1";
    metric_set->hw_config_guid = "d336f948-7e5c-41a9-be57-e3b01b8c829a";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_sampler_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__sampler_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__sampler_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_1__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_1__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_1__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_1__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_1__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__sampler_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__sampler_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_1__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_1__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_1__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice0 Input Available";
        counter->symbol_name = "Sampler00InputAvailable";
        counter->desc = "The percentage of time in which slice0 dualsubslice0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_1__sampler00_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice1 Input Available";
        counter->symbol_name = "Sampler01InputAvailable";
        counter->desc = "The percentage of time in which slice0 dualsubslice1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_1__sampler01_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice2 Input Available";
        counter->symbol_name = "Sampler02InputAvailable";
        counter->desc = "The percentage of time in which slice0 dualsubslice2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_1__sampler02_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice3 Input Available";
        counter->symbol_name = "Sampler03InputAvailable";
        counter->desc = "The percentage of time in which slice0 dualsubslice3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_1__sampler03_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice4 Input Available";
        counter->symbol_name = "Sampler04InputAvailable";
        counter->desc = "The percentage of time in which slice0 dualsubslice4 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_1__sampler04_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice5 Input Available";
        counter->symbol_name = "Sampler05InputAvailable";
        counter->desc = "The percentage of time in which slice0 dualsubslice5 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_1__sampler05_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_1__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 19);
}

static void
dg1_add_sampler_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_2";
    metric_set->symbol_name = "Sampler_2";
    metric_set->hw_config_guid = "c2929b2d-4ce9-4161-a1ac-fff0a75436b9";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_sampler_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__sampler_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__sampler_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_2__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_2__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_2__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_2__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_2__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__sampler_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__sampler_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__sampler_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_2__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_2__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_2__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice0 Sampler Output Ready";
        counter->symbol_name = "Sampler00OutputReady";
        counter->desc = "The percentage of time in which slice0 dualsubslice0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_2__sampler00_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice1 Sampler Output Ready";
        counter->symbol_name = "Sampler01OutputReady";
        counter->desc = "The percentage of time in which slice0 dualsubslice1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_2__sampler01_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice2 Sampler Output Ready";
        counter->symbol_name = "Sampler02OutputReady";
        counter->desc = "The percentage of time in which slice0 dualsubslice2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_2__sampler02_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice3 Sampler Output Ready";
        counter->symbol_name = "Sampler03OutputReady";
        counter->desc = "The percentage of time in which slice0 dualsubslice3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_2__sampler03_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice4 Sampler Output Ready";
        counter->symbol_name = "Sampler04OutputReady";
        counter->desc = "The percentage of time in which slice0 dualsubslice4 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_2__sampler04_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 DualSubslice5 Sampler Output Ready";
        counter->symbol_name = "Sampler05OutputReady";
        counter->desc = "The percentage of time in which slice0 dualsubslice5 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__sampler_2__sampler05_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__sampler_2__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 19);
}

static void
dg1_add_tdl_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_1";
    metric_set->symbol_name = "TDL_1";
    metric_set->hw_config_guid = "a98b240c-71b7-4e72-b167-8538a581e26d";
    metric_set->counters = calloc(29, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_tdl_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__tdl_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__tdl_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_1__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_1__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_1__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_1__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_1__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__tdl_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__tdl_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_1__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_1__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread00ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__non_ps_thread00_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread01ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__non_ps_thread01_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread02ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__non_ps_thread02_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread03ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__non_ps_thread03_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice4 Thread Dispatcher";
        counter->symbol_name = "NonPSThread04ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice4 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__non_ps_thread04_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 DualSubslice5 Thread Dispatcher";
        counter->symbol_name = "NonPSThread05ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 dualsubslice5 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__non_ps_thread05_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_1__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader00Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header00_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader00ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header00_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader00ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header00_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader00ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header00_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader00ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header00_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader01Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header01_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader01ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header01_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader01ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header01_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader01ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header01_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader01ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_1__thread_header01_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_1__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 29);
}

static void
dg1_add_tdl_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_2";
    metric_set->symbol_name = "TDL_2";
    metric_set->hw_config_guid = "5e7aa748-e1a6-4282-b3ae-48dbfb06dcf8";
    metric_set->counters = calloc(24, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_tdl_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__tdl_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__tdl_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_2__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_2__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_2__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_2__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_2__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__tdl_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__tdl_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_2__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_2__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    if (perf->devinfo.subslice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice0 Thread Dispatcher";
        counter->symbol_name = "PSThread00ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__ps_thread00_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 2) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice1 Thread Dispatcher";
        counter->symbol_name = "PSThread01ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__ps_thread01_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice2 Thread Dispatcher";
        counter->symbol_name = "PSThread02ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__ps_thread02_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice3 Thread Dispatcher";
        counter->symbol_name = "PSThread03ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__ps_thread03_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice4 Thread Dispatcher";
        counter->symbol_name = "PSThread04ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice4 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__ps_thread04_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Dualsubslice5 Thread Dispatcher";
        counter->symbol_name = "PSThread05ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 dualsubslice5 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__ps_thread05_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_2__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice5 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader05Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice5 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__thread_header05_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice5 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader05ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice5 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__thread_header05_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice5 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader05ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice5 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__thread_header05_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice5 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader05ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice5 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__thread_header05_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 32) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice5 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader05ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice5 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_2__thread_header05_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_2__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 24);
}

static void
dg1_add_tdl_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_3";
    metric_set->symbol_name = "TDL_3";
    metric_set->hw_config_guid = "e12f8fc0-2eb9-4bf6-bf44-a13ceb42c9f7";
    metric_set->counters = calloc(28, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_tdl_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__tdl_3__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__tdl_3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_3__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_3__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_3__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_3__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_3__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__tdl_3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__tdl_3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__tdl_3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_3__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_3__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_3__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader02Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header02_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader02ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header02_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader02ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header02_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader02ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header02_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 4) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader02ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header02_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader03Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header03_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader03ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header03_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader03ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header03_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader03ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header03_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 8) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader03ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header03_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice4 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader04Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice4 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header04_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice4 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader04ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice4 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header04_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice4 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader04ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice4 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header04_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice4 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader04ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice4 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header04_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    if (perf->devinfo.subslice_mask & 16) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 DualSubslice4 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader04ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 dualsubslice4 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = dg1__tdl_3__thread_header04_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "GPU/Thread Dispatcher");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__tdl_3__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 28);
}

static void
dg1_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "GpuBusyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "81be185c-7ac7-4a17-85fc-4144ccba4a46";
    metric_set->counters = calloc(22, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Any Engine Busy";
    counter->symbol_name = "AnyEngineBusy";
    counter->desc = "The percentage of time when any command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__any_engine_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__gpu_busyness__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__gpu_busyness__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Blitter Ring Busy";
    counter->symbol_name = "BlitterBusy";
    counter->desc = "The percentage of time when blitter command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__blitter_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__gpu_busyness__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__gpu_busyness__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Active";
    counter->symbol_name = "EuActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__eu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Stall";
    counter->symbol_name = "EuStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__eu_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Thread Occupancy";
    counter->symbol_name = "EuThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied EUs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__eu_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__gpu_busyness__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__gpu_busyness__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__gpu_busyness__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__gpu_busyness__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Posh Ring Busy";
    counter->symbol_name = "PoshEngineBusy";
    counter->desc = "The percentage of time when posh command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__posh_engine_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__gpu_busyness__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vdbox0 Ring Busy";
    counter->symbol_name = "Vdbox0Busy";
    counter->desc = "The percentage of time when Vdbox0 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__vdbox0_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vdbox1 Ring Busy";
    counter->symbol_name = "Vdbox1Busy";
    counter->desc = "The percentage of time when Vdbox1 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__vdbox1_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vebox Ring Busy";
    counter->symbol_name = "VeboxBusy";
    counter->desc = "The percentage of time when vebox command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__gpu_busyness__vebox_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__gpu_busyness__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 22);
}

static void
dg1_add_eu_activity1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity1";
    metric_set->symbol_name = "EuActivity1";
    metric_set->hw_config_guid = "5354b8d9-12fd-44eb-8f7d-0a4dffae4409";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity1__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity1__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity1__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity1__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU Send Pipe Active";
    counter->symbol_name = "EuSendActive";
    counter->desc = "The percentage of time in which EU send pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity1__eu_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity1__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity1__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity1__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity1__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity1__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity1__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS FPU Pipe Active";
    counter->symbol_name = "PsFpuActive";
    counter->desc = "The percentage of time in which EU FPU pipeline was actively processing a pixel shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity1__ps_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pixel Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity1__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity1__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity1__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS FPU Pipe Active";
    counter->symbol_name = "VsFpuActive";
    counter->desc = "The percentage of time in which EU FPU pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity1__vs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity1__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 18);
}

static void
dg1_add_eu_activity2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity2";
    metric_set->symbol_name = "EuActivity2";
    metric_set->hw_config_guid = "3225b6c6-805a-4e93-aaa5-5f09d87b31f9";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity2__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity2__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EM Pipe Active";
    counter->symbol_name = "CsEmActive";
    counter->desc = "The percentage of time in which EU FPU1 pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity2__cs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS FPU Pipe Active";
    counter->symbol_name = "CsFpuActive";
    counter->desc = "The percentage of time in which EU FPU pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity2__cs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Send Pipeline Active";
    counter->symbol_name = "CsSendActive";
    counter->desc = "The percentage of time in which EU send pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity2__cs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity2__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity2__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity2__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity2__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity2__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity2__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity2__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity2__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity2__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity2__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity2__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity2__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 18);
}

static void
dg1_add_eu_activity3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity3";
    metric_set->symbol_name = "EuActivity3";
    metric_set->hw_config_guid = "c423d483-13da-4bae-9b61-c13ec19ee450";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity3__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity3__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity3__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity3__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity3__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity3__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity3__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity3__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity3__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity3__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS EM Pipe Active";
    counter->symbol_name = "PsEmActive";
    counter->desc = "The percentage of time in which EU EM pipeline was actively processing a pixel shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity3__ps_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pixel Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS Send Pipeline Active";
    counter->symbol_name = "PsSendActive";
    counter->desc = "The percentage of time in which EU send pipeline was actively processing a pixel shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity3__ps_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pixel Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity3__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity3__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity3__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EM Pipe Active";
    counter->symbol_name = "VsEmActive";
    counter->desc = "The percentage of time in which EU EM pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity3__vs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity3__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 18);
}

static void
dg1_add_eu_activity4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity4";
    metric_set->symbol_name = "EuActivity4";
    metric_set->hw_config_guid = "c7388ce3-9e3f-4804-a215-771791c4ea3c";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity4__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity4__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity4__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS FPU Pipe Active";
    counter->symbol_name = "DsFpuActive";
    counter->desc = "The percentage of time in which EU FPU pipeline was actively processing a domain shader instructions.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity4__ds_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity4__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity4__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity4__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity4__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity4__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity4__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS FPU Pipe Active";
    counter->symbol_name = "HsFpuActive";
    counter->desc = "The percentage of time in which EU FPU pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity4__hs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity4__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity4__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity4__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity4__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Send Pipe Active";
    counter->symbol_name = "VsSendActive";
    counter->desc = "The percentage of time in which EU send pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity4__vs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity4__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 18);
}

static void
dg1_add_eu_activity5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity5";
    metric_set->symbol_name = "EuActivity5";
    metric_set->hw_config_guid = "7ebc4a0a-5dc3-4de3-a8f8-2a6d1a95427f";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity5__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity5__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity5__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS EM Pipe Active";
    counter->symbol_name = "DsEmActive";
    counter->desc = "The percentage of time in which EU EM pipeline was actively processing a domain shader instructions.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity5__ds_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity5__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity5__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity5__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity5__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity5__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity5__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity5__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS EM Pipe Active";
    counter->symbol_name = "HsEmActive";
    counter->desc = "The percentage of time in which EU EM pipeline was actively processing a hull shader instructions.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity5__hs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Send Pipe Active";
    counter->symbol_name = "HsSendActive";
    counter->desc = "The percentage of time in which EU send pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity5__hs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity5__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity5__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity5__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity5__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity5__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 18);
}

static void
dg1_add_eu_activity6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity6";
    metric_set->symbol_name = "EuActivity6";
    metric_set->hw_config_guid = "811a34c7-87f3-4d4d-b366-d4b5f5dc5be1";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity6__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity6__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity6__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity6__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity6__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EM Pipe Active";
    counter->symbol_name = "GsEmActive";
    counter->desc = "The percentage of time in which EU EM pipeline was actively processing a geometry shader instructions.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity6__gs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS FPU Pipe Active";
    counter->symbol_name = "GsFpuActive";
    counter->desc = "The percentage of time in which EU FPU pipeline was actively processing a geometry shader instructions.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity6__gs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Send Pipe Active";
    counter->symbol_name = "GsSendActive";
    counter->desc = "The percentage of time in which EU send pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity6__gs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity6__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity6__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity6__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity6__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity6__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity6__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity6__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity6__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity6__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity6__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 18);
}

static void
dg1_add_eu_activity7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity7";
    metric_set->symbol_name = "EuActivity7";
    metric_set->hw_config_guid = "6ec13866-51c1-46c3-818b-c63cf38efcd5";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity7__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity7__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity7__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity7__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM Pipe Active";
    counter->symbol_name = "EmActive";
    counter->desc = "The percentage of time in which EU EM pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity7__em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU AVG IPC Rate";
    counter->symbol_name = "EuAvgIpcRate";
    counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER;
    counter->read_float = dg1__eu_activity7__eu_avg_ipc_rate__read;
    counter->max_float = dg1__eu_activity7__eu_avg_ipc_rate__max;
    intel_perf_add_logical_counter(perf, counter, "EU Array");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU FPU And EM Pipes Active";
    counter->symbol_name = "EuFpuEmActive";
    counter->desc = "The percentage of time in which EU FPU and EM pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity7__eu_fpu_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EU FPU Pipe Active";
    counter->symbol_name = "FpuActive";
    counter->desc = "The percentage of time in which EU FPU pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity7__fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Pipes");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity7__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity7__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity7__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity7__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity7__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity7__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity7__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity7__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity7__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity7__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity7__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 19);
}

static void
dg1_add_eu_activity8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "EuActivity8";
    metric_set->symbol_name = "EuActivity8";
    metric_set->hw_config_guid = "4bc9e67a-0ebd-4d65-86cd-2eb961ccac59";
    metric_set->counters = calloc(16, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_eu_activity8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__eu_activity8__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__eu_activity8__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Compute Ring Busy";
    counter->symbol_name = "ComputeBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity8__compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity8__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Compute Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Send Pipe Active";
    counter->symbol_name = "DsSendActive";
    counter->desc = "The percentage of time in which EU send pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity8__ds_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity8__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Domain Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity8__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__eu_activity8__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__eu_activity8__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity8__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Geometry Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity8__gti_read_throughput__read;
    counter->max_uint64 = dg1__eu_activity8__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = dg1__eu_activity8__gti_write_throughput__read;
    counter->max_uint64 = dg1__eu_activity8__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "GTI");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity8__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Hull Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity8__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Fragment Shader");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndComputeBusy";
    counter->desc = "The percentage of time when render and compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity8__render_and_compute_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = dg1__eu_activity8__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = dg1__eu_activity8__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "EU Array/Vertex Shader");

    assert(metric_set->n_counters <= 16);
}

static void
dg1_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "23f51139-6973-4b45-a211-778834ce2c9a";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A32u40_A4u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 36;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    dg1_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = dg1__test_oa__avg_gpu_core_frequency__read;
    counter->max_uint64 = dg1__test_oa__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter0";
    counter->symbol_name = "Counter0";
    counter->desc = "HW test counter 0. Factor: 0.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter1";
    counter->symbol_name = "Counter1";
    counter->desc = "HW test counter 1. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter2";
    counter->symbol_name = "Counter2";
    counter->desc = "HW test counter 2. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter3";
    counter->symbol_name = "Counter3";
    counter->desc = "HW test counter 3. Factor: 0.5";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter4";
    counter->symbol_name = "Counter4";
    counter->desc = "HW test counter 4. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter5";
    counter->symbol_name = "Counter5";
    counter->desc = "HW test counter 5. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter6";
    counter->symbol_name = "Counter6";
    counter->desc = "HW test counter 6. Factor: 0.16666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter7";
    counter->symbol_name = "Counter7";
    counter->desc = "HW test counter 7. Factor: 0.6666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter8";
    counter->symbol_name = "Counter8";
    counter->desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter8__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter9 - OAR enable";
    counter->symbol_name = "Counter9";
    counter->desc = "HW test counter 9. Should be equal to 1 in query.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = dg1__test_oa__counter9__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = dg1__test_oa__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = dg1__test_oa__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 13);
}

void
intel_perf_load_metrics_dg1(struct intel_perf *perf)
{
    dg1_add_render_basic_metric_set(perf);
    dg1_add_compute_basic_metric_set(perf);
    dg1_add_render_pipe_profile_metric_set(perf);
    dg1_add_hdc_and_sf_metric_set(perf);
    dg1_add_rasterizer_and_pixel_backend_metric_set(perf);
    dg1_add_l3_1_metric_set(perf);
    dg1_add_l3_2_metric_set(perf);
    dg1_add_l3_3_metric_set(perf);
    dg1_add_l3_4_metric_set(perf);
    dg1_add_l3_5_metric_set(perf);
    dg1_add_l3_6_metric_set(perf);
    dg1_add_sampler_1_metric_set(perf);
    dg1_add_sampler_2_metric_set(perf);
    dg1_add_tdl_1_metric_set(perf);
    dg1_add_tdl_2_metric_set(perf);
    dg1_add_tdl_3_metric_set(perf);
    dg1_add_gpu_busyness_metric_set(perf);
    dg1_add_eu_activity1_metric_set(perf);
    dg1_add_eu_activity2_metric_set(perf);
    dg1_add_eu_activity3_metric_set(perf);
    dg1_add_eu_activity4_metric_set(perf);
    dg1_add_eu_activity5_metric_set(perf);
    dg1_add_eu_activity6_metric_set(perf);
    dg1_add_eu_activity7_metric_set(perf);
    dg1_add_eu_activity8_metric_set(perf);
    dg1_add_test_oa_metric_set(perf);
}
