/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_acmgt3.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_acmgt3.h"

static void
acmgt3_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "47b237c5-ed48-465b-b869-0d7ef59a6982";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__render_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__render_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt3__render_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__render_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__render_basic__gti_read_throughput__read;
    counter->max_uint64 = acmgt3__render_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__render_basic__gti_write_throughput__read;
    counter->max_uint64 = acmgt3__render_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt3__render_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__render_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt3__render_basic__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EM Pipe Active";
    counter->symbol_name = "PsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__ps_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS FPU Pipe Active";
    counter->symbol_name = "PsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__ps_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Send Pipe Active";
    counter->symbol_name = "PsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__ps_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__render_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt3__render_basic__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Rasterizer");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler00 Bottleneck";
        counter->symbol_name = "Sampler00Bottleneck";
        counter->desc = "The percentage of time in which Slice0 Sampler0 has been slowing down the pipe when processing XVE requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__render_basic__sampler00_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler Slice0 Xe Core0 is busy";
        counter->symbol_name = "Sampler00Busy";
        counter->desc = "The percentage of time when sampler slice0 Xe core0 is busy";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__render_basic__sampler00_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Bottleneck";
        counter->symbol_name = "SamplerBottleneck";
        counter->desc = "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__render_basic__sampler_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt3__render_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt3__render_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    if (perf->devinfo.slice_mask & 1) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Busy";
        counter->symbol_name = "SamplersBusy";
        counter->desc = "The percentage of time in which samplers or L1 cache are not idle.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__render_basic__samplers_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt3__render_basic__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt3__render_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt3__render_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__render_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__render_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__render_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmReads";
    counter->desc = "The total number of reads from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__render_basic__slm_reads__read;
    counter->max_uint64 = acmgt3__render_basic__slm_reads__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Writes";
    counter->symbol_name = "SlmWrites";
    counter->desc = "The total number of writes into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__render_basic__slm_writes__read;
    counter->max_uint64 = acmgt3__render_basic__slm_writes__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EM Pipe Active";
    counter->symbol_name = "VsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__vs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS FPU Pipe Active";
    counter->symbol_name = "VsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__vs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Send Pipe Active";
    counter->symbol_name = "VsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__vs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__render_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM And FPU Pipes Active";
    counter->symbol_name = "XveFpuEmActive";
    counter->desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__xve_fpu_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_basic__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 40);
}

static void
acmgt3_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "1643fb69-a674-4438-8b44-840e988877bd";
    metric_set->counters = calloc(27, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__compute_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__compute_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__compute_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM Pipe Active";
    counter->symbol_name = "EmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE FPU Pipe Active";
    counter->symbol_name = "FpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__compute_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__compute_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__compute_basic__gti_read_throughput__read;
    counter->max_uint64 = acmgt3__compute_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__compute_basic__gti_write_throughput__read;
    counter->max_uint64 = acmgt3__compute_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt3__compute_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt3__compute_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Send Pipe Active";
    counter->symbol_name = "SendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__compute_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__compute_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__compute_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmReads";
    counter->desc = "The total number of reads from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__compute_basic__slm_reads__read;
    counter->max_uint64 = acmgt3__compute_basic__slm_reads__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Writes";
    counter->symbol_name = "SlmWrites";
    counter->desc = "The total number of writes into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__compute_basic__slm_writes__read;
    counter->max_uint64 = acmgt3__compute_basic__slm_writes__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XMX Pipe Active";
    counter->symbol_name = "XmxActive";
    counter->desc = "The percentage of time in which XVE XMX pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xmx_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE AVG IPC Rate";
    counter->symbol_name = "XveAvgIpcRate";
    counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER;
    counter->read_float = acmgt3__compute_basic__xve_avg_ipc_rate__read;
    counter->max_float = acmgt3__compute_basic__xve_avg_ipc_rate__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM And FPU Pipes Active";
    counter->symbol_name = "XveFpuEmActive";
    counter->desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_fpu_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT16 Instruction";
    counter->symbol_name = "XveFpuFlt16";
    counter->desc = "The percentage of time in which FLT16 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_fpu_flt16__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT32 Instruction";
    counter->symbol_name = "XveFpuFlt32";
    counter->desc = "The percentage of time in which FLT32 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_fpu_flt32__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT64 Instruction";
    counter->symbol_name = "XveFpuFlt64";
    counter->desc = "The percentage of time in which FLT64 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_fpu_flt64__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XMX And FPU Pipes Active";
    counter->symbol_name = "XveFpuXmxActive";
    counter->desc = "The percentage of time in which XVE XMX and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_fpu_xmx_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_basic__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 27);
}

static void
acmgt3_add_async_compute_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AsyncCompute";
    metric_set->symbol_name = "AsyncCompute";
    metric_set->hw_config_guid = "a4b6cfe0-e514-49d2-857c-38f3487ea62a";
    metric_set->counters = calloc(23, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_async_compute_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ASYNC CS EM Pipe Active";
    counter->symbol_name = "AsyncCsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__async_cs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ASYNC CS FPU Pipe Active";
    counter->symbol_name = "AsyncCsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__async_cs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__async_compute__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__async_compute__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EM Pipe Active";
    counter->symbol_name = "CsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__cs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS FPU Pipe Active";
    counter->symbol_name = "CsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__cs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__async_compute__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__async_compute__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM Pipe Active";
    counter->symbol_name = "EmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE FPU Pipe Active";
    counter->symbol_name = "FpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__async_compute__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__async_compute__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__async_compute__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__async_compute__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EM Pipe Active";
    counter->symbol_name = "PsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__ps_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS FPU Pipe Active";
    counter->symbol_name = "PsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__ps_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__async_compute__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EM Pipe Active";
    counter->symbol_name = "VsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__vs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS FPU Pipe Active";
    counter->symbol_name = "VsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__vs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__async_compute__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__async_compute__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 23);
}

static void
acmgt3_add_xve_activity1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "XveActivity1";
    metric_set->symbol_name = "XveActivity1";
    metric_set->hw_config_guid = "026653d5-37d2-4970-bffd-b1c64dc03dec";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_xve_activity1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__xve_activity1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__xve_activity1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Send Pipe Active";
    counter->symbol_name = "CsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__cs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__xve_activity1__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS EM Pipe Active";
    counter->symbol_name = "DsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__ds_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS FPU Pipe Active";
    counter->symbol_name = "DsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__ds_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Send Pipe Active";
    counter->symbol_name = "DsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__ds_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__xve_activity1__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__xve_activity1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__xve_activity1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EM Pipe Active";
    counter->symbol_name = "GsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__gs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS FPU Pipe Active";
    counter->symbol_name = "GsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__gs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Send Pipe Active";
    counter->symbol_name = "GsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__gs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__xve_activity1__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS EM Pipe Active";
    counter->symbol_name = "HsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__hs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS FPU Pipe Active";
    counter->symbol_name = "HsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__hs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Send Pipe Active";
    counter->symbol_name = "HsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__xve_activity1__hs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__xve_activity1__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__xve_activity1__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__xve_activity1__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "GpuBusyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "a20872dc-9d91-4ec5-966b-3ae75cb581b7";
    metric_set->counters = calloc(25, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Any compute engine busy";
    counter->symbol_name = "AnyComputeEngineBusy";
    counter->desc = "The percentage of time when any compute engine is busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__any_compute_engine_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__gpu_busyness__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__gpu_busyness__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Blitter Ring Busy";
    counter->symbol_name = "BlitterBusy";
    counter->desc = "The percentage of time when blitter command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__blitter_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ComputeEngine0 Ring Busy";
    counter->symbol_name = "ComputeEngine0Busy";
    counter->desc = "The percentage of time when compute command streamer 0 was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__compute_engine0_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ComputeEngine1 Ring Busy";
    counter->symbol_name = "ComputeEngine1Busy";
    counter->desc = "The percentage of time when compute command streamer 1 was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__compute_engine1_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ComputeEngine2 Ring Busy";
    counter->symbol_name = "ComputeEngine2Busy";
    counter->desc = "The percentage of time when compute command streamer 2 was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__compute_engine2_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ComputeEngine3 Ring Busy";
    counter->symbol_name = "ComputeEngine3Busy";
    counter->desc = "The percentage of time when compute command streamer 3 was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__compute_engine3_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__gpu_busyness__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__gpu_busyness__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__gpu_busyness__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__gpu_busyness__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__gpu_busyness__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__gpu_busyness__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__gpu_busyness__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and any compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndAnyComputeEngineBusy";
    counter->desc = "The percentage of time when render and any compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__render_and_any_compute_engine_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vdbox00 Ring Busy";
    counter->symbol_name = "Vdbox00Busy";
    counter->desc = "The percentage of time when vdbox00 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__vdbox00_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vdbox10 Ring Busy";
    counter->symbol_name = "Vdbox10Busy";
    counter->desc = "The percentage of time when vdbox10 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__vdbox10_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vebox0 Ring Busy";
    counter->symbol_name = "Vebox0Busy";
    counter->desc = "The percentage of time when vebox0 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__vebox0_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vebox1 Ring Busy";
    counter->symbol_name = "Vebox1Busy";
    counter->desc = "The percentage of time when vebox1 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__vebox1_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__gpu_busyness__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__gpu_busyness__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 25);
}

static void
acmgt3_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "7389b9c9-de73-468d-83a8-b27776215e6b";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__test_oa__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__test_oa__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter0";
    counter->symbol_name = "Counter0";
    counter->desc = "HW test counter 0. Factor: 0.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter1";
    counter->symbol_name = "Counter1";
    counter->desc = "HW test counter 1. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter2";
    counter->symbol_name = "Counter2";
    counter->desc = "HW test counter 2. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter3";
    counter->symbol_name = "Counter3";
    counter->desc = "HW test counter 3. Factor: 0.5";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter4";
    counter->symbol_name = "Counter4";
    counter->desc = "HW test counter 4. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter5";
    counter->symbol_name = "Counter5";
    counter->desc = "HW test counter 5. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter6";
    counter->symbol_name = "Counter6";
    counter->desc = "HW test counter 6. Factor: 0.16666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter7";
    counter->symbol_name = "Counter7";
    counter->desc = "HW test counter 7. Factor: 0.6666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter8";
    counter->symbol_name = "Counter8";
    counter->desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter8__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter9 - OAR enable";
    counter->symbol_name = "Counter9";
    counter->desc = "HW test counter 9. Should be equal to 1 in query.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__test_oa__counter9__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__test_oa__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__test_oa__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 13);
}

static void
acmgt3_add_hdc_and_sf__slice01_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF for Slice01";
    metric_set->symbol_name = "HDCAndSF_Slice01";
    metric_set->hw_config_guid = "ba8ef361-332f-42f2-9c66-f8531db5e511";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_hdc_and_sf__slice01_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice01__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__hdc_and_sf__slice01__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf__slice01__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice01__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice01__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader00AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader00_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader01AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader01_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader02AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader02_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader03AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice0 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader03_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader10AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader10_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader11AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader11_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader12AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader12_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader13AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice1 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice01__non_sampler_shader13_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_hdc_and_sf__slice23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF for Slice23";
    metric_set->symbol_name = "HDCAndSF_Slice23";
    metric_set->hw_config_guid = "a950a603-f683-4f26-a83d-a7ebbe218afb";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_hdc_and_sf__slice23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice23__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__hdc_and_sf__slice23__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf__slice23__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice23__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice23__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader20AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader20_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader21AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader21_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader22AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader22_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader23AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader23_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader30AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader30_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader31AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader31_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader32AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader32_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader33AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice23__non_sampler_shader33_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_hdc_and_sf__slice45_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF for Slice45";
    metric_set->symbol_name = "HDCAndSF_Slice45";
    metric_set->hw_config_guid = "60f4dc32-a7b6-4301-8d34-be04b1c94e38";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_hdc_and_sf__slice45_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice45__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__hdc_and_sf__slice45__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf__slice45__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice45__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice45__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader40AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader40_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader41AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader41_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader42AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader42_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader43AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader43_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader50AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader50_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader51AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader51_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader52AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader52_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader53AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice45__non_sampler_shader53_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_hdc_and_sf__slice67_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF for Slice67";
    metric_set->symbol_name = "HDCAndSF_Slice67";
    metric_set->hw_config_guid = "7666a6f3-801d-4082-ab47-f534b4dad494";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_hdc_and_sf__slice67_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice67__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__hdc_and_sf__slice67__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf__slice67__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice67__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__hdc_and_sf__slice67__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader60AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice6 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader60_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader61AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice6 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader61_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader62AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice6 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader62_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader63AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice6 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader63_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader70AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice7 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader70_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader71AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice7 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader71_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader72AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice7 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader72_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader73AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice7 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__hdc_and_sf__slice67__non_sampler_shader73_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_hdc_and_sf1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF1";
    metric_set->symbol_name = "HDCAndSF1";
    metric_set->hw_config_guid = "5357c0dc-c0cb-4ee0-bb6e-2d0882d357a6";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_hdc_and_sf1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__hdc_and_sf1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__hdc_and_sf1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ00 is full";
    counter->symbol_name = "GTRequestQueue00Full";
    counter->desc = "The percentage of time when IDI0 SQ00 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue00_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ10 is full";
    counter->symbol_name = "GTRequestQueue10Full";
    counter->desc = "The percentage of time when IDI0 SQ10 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue10_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ20 is full";
    counter->symbol_name = "GTRequestQueue20Full";
    counter->desc = "The percentage of time when IDI0 SQ20 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue20_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ30 is full";
    counter->symbol_name = "GTRequestQueue30Full";
    counter->desc = "The percentage of time when IDI0 SQ30 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue30_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ40 is full";
    counter->symbol_name = "GTRequestQueue40Full";
    counter->desc = "The percentage of time when IDI0 SQ40 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue40_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ50 is full";
    counter->symbol_name = "GTRequestQueue50Full";
    counter->desc = "The percentage of time when IDI0 SQ50 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue50_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ60 is full";
    counter->symbol_name = "GTRequestQueue60Full";
    counter->desc = "The percentage of time when IDI0 SQ60 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue60_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ70 is full";
    counter->symbol_name = "GTRequestQueue70Full";
    counter->desc = "The percentage of time when IDI0 SQ70 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gt_request_queue70_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__hdc_and_sf1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__hdc_and_sf1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice0) Data Ready";
    counter->symbol_name = "Poly0DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly0_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice1) Data Ready";
    counter->symbol_name = "Poly1DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly1_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice2) Data Ready";
    counter->symbol_name = "Poly2DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly2_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice3) Data Ready";
    counter->symbol_name = "Poly3DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly3_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice4) Data Ready";
    counter->symbol_name = "Poly4DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly4_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice5) Data Ready";
    counter->symbol_name = "Poly5DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly5_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice6) Data Ready";
    counter->symbol_name = "Poly6DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly6_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice7) Data Ready";
    counter->symbol_name = "Poly7DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__hdc_and_sf1__poly7_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_l3__slice01_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_Slice01";
    metric_set->symbol_name = "L3_Slice01";
    metric_set->hw_config_guid = "b0c45d01-03a9-46c2-a04f-2c6a7a5d73d7";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l3__slice01_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l3__slice01__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l3__slice01__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l3__slice01__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l3__slice01__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank0 Input Available";
    counter->symbol_name = "L30Bank0InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank0 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank0_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank0 Output Ready";
    counter->symbol_name = "L30Bank0OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank0 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank0_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank1 Input Available";
    counter->symbol_name = "L30Bank1InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank1 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank1_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank1 Output Ready";
    counter->symbol_name = "L30Bank1OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank1 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank1_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank2 Input Available";
    counter->symbol_name = "L30Bank2InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank2 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank2_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank2 Output Ready";
    counter->symbol_name = "L30Bank2OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank2 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank2_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank3 Input Available";
    counter->symbol_name = "L30Bank3InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank3 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank3_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank3 Output Ready";
    counter->symbol_name = "L30Bank3OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank3 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank3_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank4 Input Available";
    counter->symbol_name = "L30Bank4InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank4 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank4_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank4 Output Ready";
    counter->symbol_name = "L30Bank4OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank4 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank4_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank5 Input Available";
    counter->symbol_name = "L30Bank5InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank5 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank5_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank5 Output Ready";
    counter->symbol_name = "L30Bank5OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank5 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank5_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank6 Input Available";
    counter->symbol_name = "L30Bank6InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank6 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank6_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank6 Output Ready";
    counter->symbol_name = "L30Bank6OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank6 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank6_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank7 Input Available";
    counter->symbol_name = "L30Bank7InputAvailable";
    counter->desc = "The percentage of time in which Quad0 L3 bank7 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank7_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad0 L3 Bank7 Output Ready";
    counter->symbol_name = "L30Bank7OutputReady";
    counter->desc = "The percentage of time in which quad0 L3 bank7 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice01__l30_bank7_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_l3__slice23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_Slice23";
    metric_set->symbol_name = "L3_Slice23";
    metric_set->hw_config_guid = "0c42d17c-81b7-4058-9864-65db72b70e27";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l3__slice23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l3__slice23__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l3__slice23__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l3__slice23__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l3__slice23__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank0 Input Available";
    counter->symbol_name = "L31Bank0InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank0 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank0_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank0 Output Ready";
    counter->symbol_name = "L31Bank0OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank0 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank0_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank1 Input Available";
    counter->symbol_name = "L31Bank1InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank1 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank1_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank1 Output Ready";
    counter->symbol_name = "L31Bank1OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank1 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank1_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank2 Input Available";
    counter->symbol_name = "L31Bank2InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank2 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank2_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank2 Output Ready";
    counter->symbol_name = "L31Bank2OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank2 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank2_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank3 Input Available";
    counter->symbol_name = "L31Bank3InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank3 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank3_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank3 Output Ready";
    counter->symbol_name = "L31Bank3OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank3 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank3_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank4 Input Available";
    counter->symbol_name = "L31Bank4InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank4 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank4_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank4 Output Ready";
    counter->symbol_name = "L31Bank4OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank4 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank4_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank5 Input Available";
    counter->symbol_name = "L31Bank5InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank5 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank5_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank5 Output Ready";
    counter->symbol_name = "L31Bank5OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank5 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank5_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank6 Input Available";
    counter->symbol_name = "L31Bank6InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank6 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank6_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank6 Output Ready";
    counter->symbol_name = "L31Bank6OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank6 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank6_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank7 Input Available";
    counter->symbol_name = "L31Bank7InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank7 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank7_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank7 Output Ready";
    counter->symbol_name = "L31Bank7OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank7 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice23__l31_bank7_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_l3__slice45_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_Slice45";
    metric_set->symbol_name = "L3_Slice45";
    metric_set->hw_config_guid = "59ce881a-3c51-45e0-96b4-3b565220f3a7";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l3__slice45_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l3__slice45__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l3__slice45__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l3__slice45__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l3__slice45__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank0 Input Available";
    counter->symbol_name = "L32Bank0InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank0 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank0_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank0 Output Ready";
    counter->symbol_name = "L32Bank0OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank0 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank0_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank1 Input Available";
    counter->symbol_name = "L32Bank1InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank1 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank1_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank1 Output Ready";
    counter->symbol_name = "L32Bank1OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank1 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank1_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank2 Input Available";
    counter->symbol_name = "L32Bank2InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank2 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank2_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank2 Output Ready";
    counter->symbol_name = "L32Bank2OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank2 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank2_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank3 Input Available";
    counter->symbol_name = "L32Bank3InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank3 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank3_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank3 Output Ready";
    counter->symbol_name = "L32Bank3OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank3 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank3_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank4 Input Available";
    counter->symbol_name = "L32Bank4InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank4 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank4_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank4 Output Ready";
    counter->symbol_name = "L32Bank4OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank4 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank4_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank5 Input Available";
    counter->symbol_name = "L32Bank5InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank5 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank5_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank5 Output Ready";
    counter->symbol_name = "L32Bank5OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank5 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank5_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank6 Input Available";
    counter->symbol_name = "L32Bank6InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank6 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank6_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank6 Output Ready";
    counter->symbol_name = "L32Bank6OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank6 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank6_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank7 Input Available";
    counter->symbol_name = "L32Bank7InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank7 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank7_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank7 Output Ready";
    counter->symbol_name = "L32Bank7OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank7 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice45__l32_bank7_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_l3__slice67_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_Slice67";
    metric_set->symbol_name = "L3_Slice67";
    metric_set->hw_config_guid = "36b86585-1933-4c0f-9fd0-6dfe61480d8d";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l3__slice67_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l3__slice67__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l3__slice67__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l3__slice67__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l3__slice67__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank0 Input Available";
    counter->symbol_name = "L33Bank0InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank0 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank0_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank0 Output Ready";
    counter->symbol_name = "L33Bank0OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank0 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank0_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank1 Input Available";
    counter->symbol_name = "L33Bank1InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank1 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank1_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank1 Output Ready";
    counter->symbol_name = "L33Bank1OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank1 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank1_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank2 Input Available";
    counter->symbol_name = "L33Bank2InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank2 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank2_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank2 Output Ready";
    counter->symbol_name = "L33Bank2OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank2 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank2_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank3 Input Available";
    counter->symbol_name = "L33Bank3InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank3 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank3_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank3 Output Ready";
    counter->symbol_name = "L33Bank3OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank3 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank3_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank4 Input Available";
    counter->symbol_name = "L33Bank4InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank4 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank4_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank4 Output Ready";
    counter->symbol_name = "L33Bank4OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank4 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank4_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank5 Input Available";
    counter->symbol_name = "L33Bank5InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank5 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank5_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank5 Output Ready";
    counter->symbol_name = "L33Bank5OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank5 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank5_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank6 Input Available";
    counter->symbol_name = "L33Bank6InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank6 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank6_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank6 Output Ready";
    counter->symbol_name = "L33Bank6OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank6 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank6_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank7 Input Available";
    counter->symbol_name = "L33Bank7InputAvailable";
    counter->desc = "The percentage of time in which Quad3 L3 bank7 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank7_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad3 L3 Bank7 Output Ready";
    counter->symbol_name = "L33Bank7OutputReady";
    counter->desc = "The percentage of time in which quad3 L3 bank7 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l3__slice67__l33_bank7_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_rasterizer_and_pixel_backend1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend1";
    metric_set->symbol_name = "RasterizerAndPixelBackend1";
    metric_set->hw_config_guid = "99a4388a-a104-4bbb-b8b2-7b827644a16b";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_rasterizer_and_pixel_backend1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData00Ready";
    counter->desc = "The percentage of time in which slice0  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend1__pixel_data00_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice0 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData01Ready";
    counter->desc = "The percentage of time in which slice0  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend1__pixel_data01_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice2 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData20Ready";
    counter->desc = "The percentage of time in which slice2  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend1__pixel_data20_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice2 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData21Ready";
    counter->desc = "The percentage of time in which slice2  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend1__pixel_data21_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer0InputAvailable";
        counter->desc = "The percentage of time in which slice0 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend1__rasterizer0_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer1OutputReady";
        counter->desc = "The percentage of time in which slice1 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend1__rasterizer1_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer2InputAvailable";
        counter->desc = "The percentage of time in which slice2 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend1__rasterizer2_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer3OutputReady";
        counter->desc = "The percentage of time in which slice3 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend1__rasterizer3_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_rasterizer_and_pixel_backend2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend2";
    metric_set->symbol_name = "RasterizerAndPixelBackend2";
    metric_set->hw_config_guid = "c5db2948-d89c-468c-b52e-f2323a099c92";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_rasterizer_and_pixel_backend2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice1 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData10Ready";
    counter->desc = "The percentage of time in which slice1  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend2__pixel_data10_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice1 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData11Ready";
    counter->desc = "The percentage of time in which slice1  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend2__pixel_data11_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice3 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData30Ready";
    counter->desc = "The percentage of time in which slice3  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend2__pixel_data30_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice3 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData31Ready";
    counter->desc = "The percentage of time in which slice3  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend2__pixel_data31_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer0OutputReady";
        counter->desc = "The percentage of time in which slice0 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend2__rasterizer0_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer1InputAvailable";
        counter->desc = "The percentage of time in which slice1 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend2__rasterizer1_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer2OutputReady";
        counter->desc = "The percentage of time in which slice2 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend2__rasterizer2_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer3InputAvailable";
        counter->desc = "The percentage of time in which slice3 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend2__rasterizer3_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_rasterizer_and_pixel_backend3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend3";
    metric_set->symbol_name = "RasterizerAndPixelBackend3";
    metric_set->hw_config_guid = "d8d668a7-3468-4ff2-84ab-f285b2468295";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_rasterizer_and_pixel_backend3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__rasterizer_and_pixel_backend3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice4 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData40Ready";
    counter->desc = "The percentage of time in which slice4  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend3__pixel_data40_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice4 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData41Ready";
    counter->desc = "The percentage of time in which slice4  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend3__pixel_data41_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice6 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData60Ready";
    counter->desc = "The percentage of time in which slice6  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend3__pixel_data60_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice6 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData61Ready";
    counter->desc = "The percentage of time in which slice6  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend3__pixel_data61_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer4InputAvailable";
        counter->desc = "The percentage of time in which slice4 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend3__rasterizer4_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer5OutputReady";
        counter->desc = "The percentage of time in which slice5 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend3__rasterizer5_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 6)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer6InputAvailable";
        counter->desc = "The percentage of time in which slice6 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend3__rasterizer6_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 7)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer7OutputReady";
        counter->desc = "The percentage of time in which slice7 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend3__rasterizer7_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_rasterizer_and_pixel_backend4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend4";
    metric_set->symbol_name = "RasterizerAndPixelBackend4";
    metric_set->hw_config_guid = "0c4bf00d-3ee4-4804-9f61-5b78f9810d6b";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_rasterizer_and_pixel_backend4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__rasterizer_and_pixel_backend4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice5 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData50Ready";
    counter->desc = "The percentage of time in which slice5  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend4__pixel_data50_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice5 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData51Ready";
    counter->desc = "The percentage of time in which slice5  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend4__pixel_data51_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice7 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData70Ready";
    counter->desc = "The percentage of time in which slice7  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend4__pixel_data70_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice7 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData71Ready";
    counter->desc = "The percentage of time in which slice7  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend4__pixel_data71_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer4OutputReady";
        counter->desc = "The percentage of time in which slice4 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend4__rasterizer4_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer5InputAvailable";
        counter->desc = "The percentage of time in which slice5 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend4__rasterizer5_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 6)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer6OutputReady";
        counter->desc = "The percentage of time in which slice6 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend4__rasterizer6_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 7)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer7InputAvailable";
        counter->desc = "The percentage of time in which slice7 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__rasterizer_and_pixel_backend4__rasterizer7_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_rasterizer_and_pixel_backend5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "RasterizerAndPixelBackend5";
    metric_set->symbol_name = "RasterizerAndPixelBackend5";
    metric_set->hw_config_guid = "0eef4659-956d-4a4e-840c-dca20176165a";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_rasterizer_and_pixel_backend5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__rasterizer_and_pixel_backend5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__rasterizer_and_pixel_backend5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS00 Output Available";
    counter->symbol_name = "PSOutput00Available";
    counter->desc = "The percentage of time in which PS00 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output00_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS01 Output Available";
    counter->symbol_name = "PSOutput01Available";
    counter->desc = "The percentage of time in which PS01 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output01_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS10 Output Available";
    counter->symbol_name = "PSOutput10Available";
    counter->desc = "The percentage of time in which PS10 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output10_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS11 Output Available";
    counter->symbol_name = "PSOutput11Available";
    counter->desc = "The percentage of time in which PS11 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output11_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS20 Output Available";
    counter->symbol_name = "PSOutput20Available";
    counter->desc = "The percentage of time in which PS20 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output20_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS21 Output Available";
    counter->symbol_name = "PSOutput21Available";
    counter->desc = "The percentage of time in which PS21 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output21_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS30 Output Available";
    counter->symbol_name = "PSOutput30Available";
    counter->desc = "The percentage of time in which PS30 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output30_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS31 Output Available";
    counter->symbol_name = "PSOutput31Available";
    counter->desc = "The percentage of time in which PS31 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__ps_output31_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 00 Ready";
    counter->symbol_name = "PixelValues00Ready";
    counter->desc = "The percentage of time in which pixel values 00 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values00_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 01 Ready";
    counter->symbol_name = "PixelValues01Ready";
    counter->desc = "The percentage of time in which pixel values 01 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values01_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 10 Ready";
    counter->symbol_name = "PixelValues10Ready";
    counter->desc = "The percentage of time in which pixel values 10 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values10_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 11 Ready";
    counter->symbol_name = "PixelValues11Ready";
    counter->desc = "The percentage of time in which pixel values 11 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values11_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 20 Ready";
    counter->symbol_name = "PixelValues20Ready";
    counter->desc = "The percentage of time in which pixel values 20 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values20_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 21 Ready";
    counter->symbol_name = "PixelValues21Ready";
    counter->desc = "The percentage of time in which pixel values 21 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values21_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 30 Ready";
    counter->symbol_name = "PixelValues30Ready";
    counter->desc = "The percentage of time in which pixel values 30 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values30_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 31 Ready";
    counter->symbol_name = "PixelValues31Ready";
    counter->desc = "The percentage of time in which pixel values 31 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__rasterizer_and_pixel_backend5__pixel_values31_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_render_pipe_profile__slice0_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice0";
    metric_set->hw_config_guid = "ac9c3eb4-c49e-4297-8126-3d0a78a056f8";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice0_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice0__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice0__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC00 Bottleneck";
    counter->symbol_name = "Bc00Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__bc00_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper0 Bottleneck";
    counter->symbol_name = "Cl0Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__cl0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL0 Stall";
    counter->symbol_name = "Cl0Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__cl0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS0 Bottleneck";
    counter->symbol_name = "Ds0Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__ds0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS0 Stall";
    counter->symbol_name = "Ds0Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__ds0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice0__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice0__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS0 Bottleneck";
    counter->symbol_name = "Gs0Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__gs0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth00 Bottleneck";
    counter->symbol_name = "HiDepth00Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__hi_depth00_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS0 Bottleneck";
    counter->symbol_name = "Hs0Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__hs0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS0 Stall";
    counter->symbol_name = "Hs0Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__hs0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF0 Bottleneck";
    counter->symbol_name = "Sf0Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__sf0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF0 Stall";
    counter->symbol_name = "Sf0Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__sf0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO0 Bottleneck";
    counter->symbol_name = "So0Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__so0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO0 Stall";
    counter->symbol_name = "So0Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__so0_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF0 Bottleneck";
    counter->symbol_name = "Vf0Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__vf0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS0 Bottleneck";
    counter->symbol_name = "Vs0Bottleneck";
    counter->desc = "The percentage of time in which VS0 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice0__vs0_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_render_pipe_profile__slice1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice1";
    metric_set->hw_config_guid = "53434b4e-ae6b-457a-b337-c9ebefa86aeb";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC10 Bottleneck";
    counter->symbol_name = "Bc10Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__bc10_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper1 Bottleneck";
    counter->symbol_name = "Cl1Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__cl1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL1 Stall";
    counter->symbol_name = "Cl1Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__cl1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS1 Bottleneck";
    counter->symbol_name = "Ds1Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__ds1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS1 Stall";
    counter->symbol_name = "Ds1Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__ds1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS1 Bottleneck";
    counter->symbol_name = "Gs1Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__gs1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth10 Bottleneck";
    counter->symbol_name = "HiDepth10Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__hi_depth10_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS1 Bottleneck";
    counter->symbol_name = "Hs1Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__hs1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS1 Stall";
    counter->symbol_name = "Hs1Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__hs1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF1 Bottleneck";
    counter->symbol_name = "Sf1Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__sf1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF1 Stall";
    counter->symbol_name = "Sf1Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__sf1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO1 Bottleneck";
    counter->symbol_name = "So1Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__so1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO1 Stall";
    counter->symbol_name = "So1Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__so1_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF1 Bottleneck";
    counter->symbol_name = "Vf1Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__vf1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS1 Bottleneck";
    counter->symbol_name = "Vs1Bottleneck";
    counter->desc = "The percentage of time in which VS1 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice1__vs1_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_render_pipe_profile__slice2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice2";
    metric_set->hw_config_guid = "3921cb4b-32f1-4595-b51b-531651d6d89d";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC20 Bottleneck";
    counter->symbol_name = "Bc20Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__bc20_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper2 Bottleneck";
    counter->symbol_name = "Cl2Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__cl2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL2 Stall";
    counter->symbol_name = "Cl2Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__cl2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS2 Bottleneck";
    counter->symbol_name = "Ds2Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__ds2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS2 Stall";
    counter->symbol_name = "Ds2Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__ds2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS2 Bottleneck";
    counter->symbol_name = "Gs2Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__gs2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth20 Bottleneck";
    counter->symbol_name = "HiDepth20Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__hi_depth20_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS2 Bottleneck";
    counter->symbol_name = "Hs2Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__hs2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS2 Stall";
    counter->symbol_name = "Hs2Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__hs2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF2 Bottleneck";
    counter->symbol_name = "Sf2Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__sf2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF2 Stall";
    counter->symbol_name = "Sf2Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__sf2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO2 Bottleneck";
    counter->symbol_name = "So2Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__so2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO2 Stall";
    counter->symbol_name = "So2Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__so2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF2 Bottleneck";
    counter->symbol_name = "Vf2Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__vf2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS2 Bottleneck";
    counter->symbol_name = "Vs2Bottleneck";
    counter->desc = "The percentage of time in which VS2 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice2__vs2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_render_pipe_profile__slice3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice3";
    metric_set->hw_config_guid = "47924a4a-4cbb-4c9a-a186-efd3af8acf6a";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC30 Bottleneck";
    counter->symbol_name = "Bc30Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__bc30_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper3 Bottleneck";
    counter->symbol_name = "Cl3Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__cl3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL3 Stall";
    counter->symbol_name = "Cl3Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__cl3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS3 Bottleneck";
    counter->symbol_name = "Ds3Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__ds3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS3 Stall";
    counter->symbol_name = "Ds3Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__ds3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS3 Bottleneck";
    counter->symbol_name = "Gs3Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__gs3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth30 Bottleneck";
    counter->symbol_name = "HiDepth30Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__hi_depth30_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS3 Bottleneck";
    counter->symbol_name = "Hs3Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__hs3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS3 Stall";
    counter->symbol_name = "Hs3Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__hs3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF3 Bottleneck";
    counter->symbol_name = "Sf3Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__sf3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF3 Stall";
    counter->symbol_name = "Sf3Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__sf3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO3 Bottleneck";
    counter->symbol_name = "So3Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__so3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO3 Stall";
    counter->symbol_name = "So3Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__so3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF3 Bottleneck";
    counter->symbol_name = "Vf3Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__vf3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS3 Bottleneck";
    counter->symbol_name = "Vs3Bottleneck";
    counter->desc = "The percentage of time in which VS3 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice3__vs3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_render_pipe_profile__slice4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice4";
    metric_set->hw_config_guid = "ee1b4183-c89c-4bad-a11d-b91b60769895";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC40 Bottleneck";
    counter->symbol_name = "Bc40Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__bc40_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper4 Bottleneck";
    counter->symbol_name = "Cl4Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__cl4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL4 Stall";
    counter->symbol_name = "Cl4Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__cl4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS4 Bottleneck";
    counter->symbol_name = "Ds4Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__ds4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS4 Stall";
    counter->symbol_name = "Ds4Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__ds4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS4 Bottleneck";
    counter->symbol_name = "Gs4Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__gs4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth40 Bottleneck";
    counter->symbol_name = "HiDepth40Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__hi_depth40_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS4 Bottleneck";
    counter->symbol_name = "Hs4Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__hs4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS4 Stall";
    counter->symbol_name = "Hs4Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__hs4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF4 Bottleneck";
    counter->symbol_name = "Sf4Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__sf4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF4 Stall";
    counter->symbol_name = "Sf4Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__sf4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO4 Bottleneck";
    counter->symbol_name = "So4Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__so4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO4 Stall";
    counter->symbol_name = "So4Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__so4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF4 Bottleneck";
    counter->symbol_name = "Vf4Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__vf4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS4 Bottleneck";
    counter->symbol_name = "Vs4Bottleneck";
    counter->desc = "The percentage of time in which VS4 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice4__vs4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_render_pipe_profile__slice5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice5";
    metric_set->hw_config_guid = "a1534029-affd-453e-b8d9-2931505c5288";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC50 Bottleneck";
    counter->symbol_name = "Bc50Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__bc50_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper5 Bottleneck";
    counter->symbol_name = "Cl5Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__cl5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL5 Stall";
    counter->symbol_name = "Cl5Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__cl5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS5 Bottleneck";
    counter->symbol_name = "Ds5Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__ds5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS5 Stall";
    counter->symbol_name = "Ds5Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__ds5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS5 Bottleneck";
    counter->symbol_name = "Gs5Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__gs5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth50 Bottleneck";
    counter->symbol_name = "HiDepth50Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__hi_depth50_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS5 Bottleneck";
    counter->symbol_name = "Hs5Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__hs5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS5 Stall";
    counter->symbol_name = "Hs5Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__hs5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF5 Bottleneck";
    counter->symbol_name = "Sf5Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__sf5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF5 Stall";
    counter->symbol_name = "Sf5Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__sf5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO5 Bottleneck";
    counter->symbol_name = "So5Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__so5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO5 Stall";
    counter->symbol_name = "So5Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__so5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF5 Bottleneck";
    counter->symbol_name = "Vf5Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__vf5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS5 Bottleneck";
    counter->symbol_name = "Vs5Bottleneck";
    counter->desc = "The percentage of time in which VS5 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice5__vs5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_render_pipe_profile__slice6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice6";
    metric_set->hw_config_guid = "26a82035-dadd-4227-a1b4-f7808081f10c";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice6__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC60 Bottleneck";
    counter->symbol_name = "Bc60Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__bc60_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper6 Bottleneck";
    counter->symbol_name = "Cl6Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__cl6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL6 Stall";
    counter->symbol_name = "Cl6Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__cl6_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS6 Bottleneck";
    counter->symbol_name = "Ds6Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__ds6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS6 Stall";
    counter->symbol_name = "Ds6Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__ds6_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS6 Bottleneck";
    counter->symbol_name = "Gs6Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__gs6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth60 Bottleneck";
    counter->symbol_name = "HiDepth60Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__hi_depth60_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS6 Bottleneck";
    counter->symbol_name = "Hs6Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__hs6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS6 Stall";
    counter->symbol_name = "Hs6Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__hs6_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF6 Bottleneck";
    counter->symbol_name = "Sf6Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__sf6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF6 Stall";
    counter->symbol_name = "Sf6Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__sf6_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO6 Bottleneck";
    counter->symbol_name = "So6Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__so6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO6 Stall";
    counter->symbol_name = "So6Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__so6_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF6 Bottleneck";
    counter->symbol_name = "Vf6Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__vf6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS6 Bottleneck";
    counter->symbol_name = "Vs6Bottleneck";
    counter->desc = "The percentage of time in which VS6 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice6__vs6_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_render_pipe_profile__slice7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile_Slice7";
    metric_set->hw_config_guid = "71b5ebc0-874f-4ecd-b409-c387a5bb0543";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_render_pipe_profile__slice7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice7__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__render_pipe_profile__slice7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC70 Bottleneck";
    counter->symbol_name = "Bc70Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__bc70_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper7 Bottleneck";
    counter->symbol_name = "Cl7Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__cl7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL7 Stall";
    counter->symbol_name = "Cl7Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__cl7_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS7 Bottleneck";
    counter->symbol_name = "Ds7Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__ds7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS7 Stall";
    counter->symbol_name = "Ds7Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__ds7_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__render_pipe_profile__slice7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS7 Bottleneck";
    counter->symbol_name = "Gs7Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__gs7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth70 Bottleneck";
    counter->symbol_name = "HiDepth70Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__hi_depth70_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS7 Bottleneck";
    counter->symbol_name = "Hs7Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__hs7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS7 Stall";
    counter->symbol_name = "Hs7Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__hs7_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF7 Bottleneck";
    counter->symbol_name = "Sf7Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__sf7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF7 Stall";
    counter->symbol_name = "Sf7Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__sf7_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO7 Bottleneck";
    counter->symbol_name = "So7Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__so7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO7 Stall";
    counter->symbol_name = "So7Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__so7_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF7 Bottleneck";
    counter->symbol_name = "Vf7Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__vf7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS7 Bottleneck";
    counter->symbol_name = "Vs7Bottleneck";
    counter->desc = "The percentage of time in which VS7 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__render_pipe_profile__slice7__vs7_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_sampler__slice01_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_Slice01";
    metric_set->symbol_name = "Sampler_Slice01";
    metric_set->hw_config_guid = "1fa63cc6-c791-42ae-9db4-4170daefe666";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_sampler__slice01_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__sampler__slice01__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__sampler__slice01__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__sampler__slice01__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__sampler__slice01__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__sampler__slice01__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core0 Input Available";
        counter->symbol_name = "Sampler00InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler00_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler00OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler00_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core1 Input Available";
        counter->symbol_name = "Sampler01InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler01_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler01OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler01_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core2 Input Available";
        counter->symbol_name = "Sampler02InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler02_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler02OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler02_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core3 Input Available";
        counter->symbol_name = "Sampler03InputAvailable";
        counter->desc = "The percentage of time in which slice0 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler03_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice0 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler03OutputReady";
        counter->desc = "The percentage of time in which slice0 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler03_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core0 Input Available";
        counter->symbol_name = "Sampler10InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler10_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler10OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler10_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core1 Input Available";
        counter->symbol_name = "Sampler11InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler11_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler11OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler11_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core2 Input Available";
        counter->symbol_name = "Sampler12InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler12_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler12OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler12_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core3 Input Available";
        counter->symbol_name = "Sampler13InputAvailable";
        counter->desc = "The percentage of time in which slice1 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler13_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice1 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler13OutputReady";
        counter->desc = "The percentage of time in which slice1 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice01__sampler13_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_sampler__slice23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_Slice23";
    metric_set->symbol_name = "Sampler_Slice23";
    metric_set->hw_config_guid = "c22bbd17-c8bd-4f7e-bb2f-4b045e41f1cb";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_sampler__slice23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__sampler__slice23__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__sampler__slice23__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__sampler__slice23__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__sampler__slice23__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__sampler__slice23__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core0 Input Available";
        counter->symbol_name = "Sampler20InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler20_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler20OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler20_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core1 Input Available";
        counter->symbol_name = "Sampler21InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler21_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler21OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler21_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core2 Input Available";
        counter->symbol_name = "Sampler22InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler22_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler22OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler22_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core3 Input Available";
        counter->symbol_name = "Sampler23InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler23_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler23OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler23_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core0 Input Available";
        counter->symbol_name = "Sampler30InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler30_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler30OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler30_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core1 Input Available";
        counter->symbol_name = "Sampler31InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler31_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler31OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler31_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core2 Input Available";
        counter->symbol_name = "Sampler32InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler32_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler32OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler32_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core3 Input Available";
        counter->symbol_name = "Sampler33InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler33_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler33OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice23__sampler33_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_sampler__slice45_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_Slice45";
    metric_set->symbol_name = "Sampler_Slice45";
    metric_set->hw_config_guid = "3946ded6-dff6-461a-a9cd-5291d9dcce51";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_sampler__slice45_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__sampler__slice45__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__sampler__slice45__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__sampler__slice45__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__sampler__slice45__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__sampler__slice45__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core0 Input Available";
        counter->symbol_name = "Sampler40InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler40_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler40OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler40_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core1 Input Available";
        counter->symbol_name = "Sampler41InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler41_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler41OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler41_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core2 Input Available";
        counter->symbol_name = "Sampler42InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler42_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler42OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler42_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core3 Input Available";
        counter->symbol_name = "Sampler43InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler43_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler43OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler43_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core0 Input Available";
        counter->symbol_name = "Sampler50InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler50_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler50OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler50_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core1 Input Available";
        counter->symbol_name = "Sampler51InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler51_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler51OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler51_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core2 Input Available";
        counter->symbol_name = "Sampler52InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler52_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler52OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler52_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core3 Input Available";
        counter->symbol_name = "Sampler53InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler53_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler53OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice45__sampler53_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_sampler__slice67_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_Slice67";
    metric_set->symbol_name = "Sampler_Slice67";
    metric_set->hw_config_guid = "6ab037fb-065e-4f01-b24e-5f425077189c";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_sampler__slice67_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__sampler__slice67__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__sampler__slice67__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__sampler__slice67__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__sampler__slice67__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__sampler__slice67__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core0 Input Available";
        counter->symbol_name = "Sampler60InputAvailable";
        counter->desc = "The percentage of time in which slice6 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler60_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler60OutputReady";
        counter->desc = "The percentage of time in which slice6 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler60_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core1 Input Available";
        counter->symbol_name = "Sampler61InputAvailable";
        counter->desc = "The percentage of time in which slice6 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler61_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler61OutputReady";
        counter->desc = "The percentage of time in which slice6 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler61_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core2 Input Available";
        counter->symbol_name = "Sampler62InputAvailable";
        counter->desc = "The percentage of time in which slice6 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler62_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler62OutputReady";
        counter->desc = "The percentage of time in which slice6 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler62_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core3 Input Available";
        counter->symbol_name = "Sampler63InputAvailable";
        counter->desc = "The percentage of time in which slice6 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler63_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice6 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler63OutputReady";
        counter->desc = "The percentage of time in which slice6 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler63_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core0 Input Available";
        counter->symbol_name = "Sampler70InputAvailable";
        counter->desc = "The percentage of time in which slice7 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler70_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler70OutputReady";
        counter->desc = "The percentage of time in which slice7 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler70_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core1 Input Available";
        counter->symbol_name = "Sampler71InputAvailable";
        counter->desc = "The percentage of time in which slice7 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler71_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler71OutputReady";
        counter->desc = "The percentage of time in which slice7 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler71_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core2 Input Available";
        counter->symbol_name = "Sampler72InputAvailable";
        counter->desc = "The percentage of time in which slice7 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler72_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler72OutputReady";
        counter->desc = "The percentage of time in which slice7 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler72_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core3 Input Available";
        counter->symbol_name = "Sampler73InputAvailable";
        counter->desc = "The percentage of time in which slice7 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler73_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice7 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler73OutputReady";
        counter->desc = "The percentage of time in which slice7 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__sampler__slice67__sampler73_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice01_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice01_1";
    metric_set->symbol_name = "TDL_Slice01_1";
    metric_set->hw_config_guid = "f0294ed6-827a-44e0-9f79-1ddc22182899";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice01_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice01_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice01_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice01_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice01_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice01_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread00ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread00_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread01ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread01_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread02ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread02_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread03ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread03_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread10ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread10_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread11ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread11_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread12ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread12_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice1 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread13ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice1 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__non_ps_thread13_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader03ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header03_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader03ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header03_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader03ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header03_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader03ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header03_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader13ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header13_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader13ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header13_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader13ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header13_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader13ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_1__thread_header13_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice01_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice01_2";
    metric_set->symbol_name = "TDL_Slice01_2";
    metric_set->hw_config_guid = "14477b8c-ad25-4351-8c67-e6411cb77bab";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice01_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice01_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice01_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice01_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice01_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice01_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread00ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread00_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread01ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread01_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread02ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread02_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice0 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread03ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice0 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread03_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread10ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread10_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread11ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread11_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread12ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread12_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice1 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread13ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice1 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_2__ps_thread13_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_tdl__slice01_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice01_3";
    metric_set->symbol_name = "TDL_Slice01_3";
    metric_set->hw_config_guid = "6b48996e-1179-4955-bd28-d5aefeea1196";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice01_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice01_3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice01_3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice01_3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice01_3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice01_3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader00Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header00_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader00ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header00_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader00ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header00_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader00ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header00_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader00ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header00_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader01Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header01_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader01ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header01_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader01ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header01_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader01ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header01_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader01ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header01_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader02Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header02_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader02ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header02_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader02ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header02_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader02ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header02_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader02ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header02_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 0, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice0 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader03Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice0 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_3__thread_header03_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice01_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice01_4";
    metric_set->symbol_name = "TDL_Slice01_4";
    metric_set->hw_config_guid = "6403c3b2-e302-4c1a-a604-7817e846ab2c";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice01_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice01_4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice01_4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice01_4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice01_4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice01_4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader10Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header10_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader10ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header10_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader10ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header10_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader10ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header10_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader10ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header10_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader11Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header11_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader11ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header11_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader11ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header11_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader11ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header11_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader11ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header11_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader12Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header12_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader12ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header12_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader12ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header12_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader12ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header12_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader12ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header12_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 1, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice1 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader13Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice1 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice01_4__thread_header13_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice23_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice23_1";
    metric_set->symbol_name = "TDL_Slice23_1";
    metric_set->hw_config_guid = "51d2c1bd-7432-411f-9095-ac97d55dc285";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice23_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice23_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice23_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice23_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice23_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice23_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread20ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread20_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread21ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread21_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread22ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread22_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread23ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread23_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread30ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread30_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread31ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread31_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread32ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread32_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread33ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__non_ps_thread33_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader23ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header23_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader23ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header23_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader23ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header23_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader23ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header23_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader33ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header33_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader33ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header33_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader33ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header33_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader33ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_1__thread_header33_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice23_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice23_2";
    metric_set->symbol_name = "TDL_Slice23_2";
    metric_set->hw_config_guid = "32e32945-471f-4f17-bae1-9d96f9c54f8d";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice23_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice23_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice23_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice23_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice23_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice23_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread20ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread20_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread21ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread21_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread22ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread22_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread23ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread23_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread30ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread30_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread31ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread31_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread32ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread32_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread33ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_2__ps_thread33_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_tdl__slice23_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice23_3";
    metric_set->symbol_name = "TDL_Slice23_3";
    metric_set->hw_config_guid = "34804b9e-0d2b-4e97-ba78-5c2069bc9df9";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice23_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice23_3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice23_3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice23_3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice23_3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice23_3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader20Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header20_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader20ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header20_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader20ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header20_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader20ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header20_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader20ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header20_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader21Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header21_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader21ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header21_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader21ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header21_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader21ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header21_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader21ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header21_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader22Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header22_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader22ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header22_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader22ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header22_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader22ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header22_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader22ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header22_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader23Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_3__thread_header23_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice23_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice23_4";
    metric_set->symbol_name = "TDL_Slice23_4";
    metric_set->hw_config_guid = "97ca0de0-9d3b-4bdd-94f7-662113dfc905";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice23_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice23_4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice23_4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice23_4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice23_4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice23_4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader30Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header30_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader30ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header30_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader30ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header30_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader30ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header30_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader30ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header30_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader31Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header31_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader31ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header31_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader31ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header31_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader31ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header31_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader31ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header31_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader32Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header32_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader32ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header32_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader32ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header32_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader32ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header32_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader32ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header32_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader33Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice23_4__thread_header33_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice45_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice45_1";
    metric_set->symbol_name = "TDL_Slice45_1";
    metric_set->hw_config_guid = "f4ba49b6-37a1-4848-88d6-3c63cb8e1c12";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice45_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice45_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice45_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice45_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice45_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice45_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread40ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread40_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread41ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread41_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread42ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread42_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread43ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread43_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread50ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread50_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread51ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread51_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread52ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread52_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread53ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__non_ps_thread53_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader43ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header43_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader43ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header43_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader43ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header43_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader43ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header43_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader53ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header53_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader53ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header53_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader53ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header53_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader53ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_1__thread_header53_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice45_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice45_2";
    metric_set->symbol_name = "TDL_Slice45_2";
    metric_set->hw_config_guid = "a6969313-fe82-4f0b-9499-b90c98e9ede7";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice45_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice45_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice45_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice45_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice45_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice45_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread40ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread40_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread41ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread41_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread42ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread42_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread43ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread43_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread50ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread50_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread51ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread51_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread52ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread52_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread53ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_2__ps_thread53_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_tdl__slice45_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice45_3";
    metric_set->symbol_name = "TDL_Slice45_3";
    metric_set->hw_config_guid = "8dd20826-657e-43b7-9bba-a48ef4db2d14";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice45_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice45_3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice45_3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice45_3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice45_3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice45_3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader40Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header40_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader40ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header40_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader40ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header40_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader40ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header40_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader40ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header40_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader41Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header41_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader41ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header41_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader41ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header41_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader41ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header41_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader41ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header41_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader42Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header42_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader42ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header42_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader42ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header42_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader42ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header42_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader42ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header42_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader43Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_3__thread_header43_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice45_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice45_4";
    metric_set->symbol_name = "TDL_Slice45_4";
    metric_set->hw_config_guid = "e479a02f-fc83-438f-818d-3e11e769fbae";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice45_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice45_4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice45_4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice45_4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice45_4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice45_4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader50Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header50_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader50ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header50_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader50ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header50_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader50ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header50_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader50ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header50_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader51Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header51_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader51ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header51_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader51ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header51_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader51ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header51_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader51ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header51_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader52Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header52_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader52ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header52_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader52ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header52_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader52ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header52_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader52ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header52_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader53Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice45_4__thread_header53_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice67_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice67_1";
    metric_set->symbol_name = "TDL_Slice67_1";
    metric_set->hw_config_guid = "deb1e6dd-bddd-42a4-87f5-c4bd8438a884";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice67_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice67_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice67_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice67_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice67_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice67_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice6 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread60ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice6 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread60_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice6 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread61ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice6 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread61_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice6 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread62ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice6 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread62_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice6 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread63ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice6 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread63_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice7 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread70ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice7 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread70_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice7 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread71ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice7 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread71_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice7 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread72ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice7 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread72_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice7 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread73ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice7 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__non_ps_thread73_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader63ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header63_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader63ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header63_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader63ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header63_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader63ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header63_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader73ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header73_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader73ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header73_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader73ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header73_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader73ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_1__thread_header73_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice67_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice67_2";
    metric_set->symbol_name = "TDL_Slice67_2";
    metric_set->hw_config_guid = "0a6abc27-343e-4118-b17e-5c5121611b08";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice67_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice67_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice67_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice67_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice67_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice67_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice6 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread60ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice6 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread60_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice6 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread61ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice6 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread61_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice6 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread62ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice6 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread62_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice6 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread63ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice6 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread63_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice7 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread70ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice7 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread70_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice7 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread71ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice7 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread71_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice7 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread72ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice7 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread72_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice7 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread73ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice7 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_2__ps_thread73_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_tdl__slice67_3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice67_3";
    metric_set->symbol_name = "TDL_Slice67_3";
    metric_set->hw_config_guid = "67abb260-55fb-4c66-8469-db2f8700884a";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice67_3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice67_3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice67_3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice67_3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice67_3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice67_3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader60Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header60_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader60ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header60_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader60ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header60_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader60ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header60_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader60ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header60_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader61Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header61_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader61ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header61_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader61ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header61_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader61ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header61_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader61ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header61_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader62Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header62_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader62ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header62_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader62ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header62_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader62ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header62_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader62ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header62_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 6, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice6 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader63Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice6 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_3__thread_header63_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_tdl__slice67_4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL_Slice67_4";
    metric_set->symbol_name = "TDL_Slice67_4";
    metric_set->hw_config_guid = "7c064e0d-b3ee-4159-9361-8d1da3158d39";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_tdl__slice67_4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__tdl__slice67_4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__tdl__slice67_4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__tdl__slice67_4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__tdl__slice67_4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__tdl__slice67_4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader70Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header70_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader70ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header70_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader70ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header70_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader70ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header70_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader70ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header70_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader71Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header71_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader71ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header71_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader71ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header71_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader71ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header71_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader71ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header71_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader72Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header72_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader72ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header72_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader72ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header72_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader72ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header72_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader72ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header72_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 7, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice7 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader73Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice7 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__tdl__slice67_4__thread_header73_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt3_add_compute_overview_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ComputeOverview";
    metric_set->symbol_name = "ComputeOverview";
    metric_set->hw_config_guid = "5ae9db29-303b-4e74-8dc8-b9f2eb31aaa1";
    metric_set->counters = calloc(26, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_compute_overview_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__compute_overview__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__compute_overview__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__compute_overview__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__compute_overview__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__compute_overview__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__compute_overview__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__compute_overview__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__compute_overview__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 BYTE READ";
    counter->symbol_name = "L3_BYTE_READ";
    counter->desc = "Number of bytes read from L3";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__compute_overview__l3_byte_read__read;
    counter->max_uint64 = acmgt3__compute_overview__l3_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 BYTE WRITE";
    counter->symbol_name = "L3_BYTE_WRITE";
    counter->desc = "Number of bytes written to L3";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__compute_overview__l3_byte_write__read;
    counter->max_uint64 = acmgt3__compute_overview__l3_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ATOMIC ACCESS COUNT";
    counter->symbol_name = "XVE_ATOMIC_ACCESS_COUNT";
    counter->desc = "Number of shader atomic memory accesses";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__compute_overview__xve_atomic_access_count__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BARRIER MESSAGE COUNT";
    counter->symbol_name = "XVE_BARRIER_MESSAGE_COUNT";
    counter->desc = "Number of shader barrier messages";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt3__compute_overview__xve_barrier_message_count__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__compute_overview__xve_busy__read;
    counter->max_uint64 = acmgt3__compute_overview__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE COMPUTE THREAD COUNT";
    counter->symbol_name = "XVE_COMPUTE_THREAD_COUNT";
    counter->desc = "Number of compute shader hardware threads dispatched";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__compute_overview__xve_compute_thread_count__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED ALU0 ALL";
    counter->symbol_name = "XVE_INST_EXECUTED_ALU0_ALL";
    counter->desc = "Number of execution slots taken by instructions executed on ALU0 pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__compute_overview__xve_inst_executed_alu0_all__read;
    counter->max_uint64 = acmgt3__compute_overview__xve_inst_executed_alu0_all__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED ALU0 ALL UTILIZATION";
    counter->symbol_name = "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION";
    counter->desc = "Percentage of execution slots taken by instructions executed on ALU0 pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_inst_executed_alu0_all_utilization__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED ALU1 ALL";
    counter->symbol_name = "XVE_INST_EXECUTED_ALU1_ALL";
    counter->desc = "Number of execution slots taken by instructions executed on ALU1 pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__compute_overview__xve_inst_executed_alu1_all__read;
    counter->max_uint64 = acmgt3__compute_overview__xve_inst_executed_alu1_all__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED ALU1 ALL UTILIZATION";
    counter->symbol_name = "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION";
    counter->desc = "Percentage of execution slots taken by instructions executed on ALU1 pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_inst_executed_alu1_all_utilization__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED CONTROL ALL";
    counter->symbol_name = "XVE_INST_EXECUTED_CONTROL_ALL";
    counter->desc = "Number of instructions executed on Jump Pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__compute_overview__xve_inst_executed_control_all__read;
    counter->max_uint64 = acmgt3__compute_overview__xve_inst_executed_control_all__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED CONTROL ALL UTILIZATION";
    counter->symbol_name = "XVE_INST_EXECUTED_CONTROL_ALL_UTILIZATION";
    counter->desc = "Percentage of time taken by instructions executed on Jump Pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_inst_executed_control_all_utilization__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED SEND ALL";
    counter->symbol_name = "XVE_INST_EXECUTED_SEND_ALL";
    counter->desc = "Number of instructions executed on SEND pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__compute_overview__xve_inst_executed_send_all__read;
    counter->max_uint64 = acmgt3__compute_overview__xve_inst_executed_send_all__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED SEND ALL UTILIZATION";
    counter->symbol_name = "XVE_INST_EXECUTED_SEND_ALL_UTILIZATION";
    counter->desc = "Percentage of time taken by instructions executed on SEND pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_inst_executed_send_all_utilization__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED XMX ALL";
    counter->symbol_name = "XVE_INST_EXECUTED_XMX_ALL";
    counter->desc = "Number of execution slots taken by instructions executed in XMX pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__compute_overview__xve_inst_executed_xmx_all__read;
    counter->max_uint64 = acmgt3__compute_overview__xve_inst_executed_xmx_all__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE INST EXECUTED XMX ALL UTILIZATION";
    counter->symbol_name = "XVE_INST_EXECUTED_XMX_ALL_UTILIZATION";
    counter->desc = "Percentage of execution slots taken by instructions executed in XMX pipe";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_inst_executed_xmx_all_utilization__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE PIPE ALU0 AND ALU1 ACTIVE";
    counter->symbol_name = "XVE_PIPE_ALU0_AND_ALU1_ACTIVE";
    counter->desc = "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_pipe_alu0_and_alu1_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE PIPE ALU0 AND XMX ACTIVE";
    counter->symbol_name = "XVE_PIPE_ALU0_AND_XMX_ACTIVE";
    counter->desc = "Percentage of time in which ALU0 and XMX pipes are both actively executing a Gen ISA instruction";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_pipe_alu0_and_xmx_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__compute_overview__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 26);
}

static void
acmgt3_add_l1_profile_reads__xe_core0_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileReads";
    metric_set->symbol_name = "L1ProfileReads_XeCore0";
    metric_set->hw_config_guid = "16047ddf-5ee1-4948-81dc-edbe26576ac1";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l1_profile_reads__xe_core0_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core0__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core0__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core0__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "LOAD STORE CACHE BYTE READ";
    counter->symbol_name = "LOAD_STORE_CACHE_BYTE_READ";
    counter->desc = "Number of bytes read out of the Load Store Cache, excluding SLM accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__load_store_cache_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core0__load_store_cache_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM BYTE READ";
    counter->symbol_name = "SLM_BYTE_READ";
    counter->desc = "Number of bytes read from SLM";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__slm_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core0__slm_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_reads__xe_core0__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core0__xve_busy__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core0__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_reads__xe_core0__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_reads__xe_core0__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 11);
}

static void
acmgt3_add_l1_profile_reads__xe_core3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileReads";
    metric_set->symbol_name = "L1ProfileReads_XeCore3";
    metric_set->hw_config_guid = "224881aa-faa7-4d2d-8161-50dbb10026e8";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l1_profile_reads__xe_core3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core3__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core3__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "LOAD STORE CACHE BYTE READ";
    counter->symbol_name = "LOAD_STORE_CACHE_BYTE_READ";
    counter->desc = "Number of bytes read out of the Load Store Cache, excluding SLM accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__load_store_cache_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core3__load_store_cache_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM BYTE READ";
    counter->symbol_name = "SLM_BYTE_READ";
    counter->desc = "Number of bytes read from SLM";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__slm_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core3__slm_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_reads__xe_core3__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_reads__xe_core3__xve_busy__read;
    counter->max_uint64 = acmgt3__l1_profile_reads__xe_core3__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_reads__xe_core3__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_reads__xe_core3__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 11);
}

static void
acmgt3_add_l1_profile_slm_bank_conflicts__xe_core0_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileSlmBankConflicts";
    metric_set->symbol_name = "L1ProfileSlmBankConflicts_XeCore0";
    metric_set->hw_config_guid = "dc5ee653-2006-48de-8be2-e8b760a4369c";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l1_profile_slm_bank_conflicts__xe_core0_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM BANK CONFLICT COUNT";
    counter->symbol_name = "SLM_BANK_CONFLICT_COUNT";
    counter->desc = "Number of SLM accesses resulting in a bank conflict.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__slm_bank_conflict_count__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__xve_busy__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_slm_bank_conflicts__xe_core0__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 10);
}

static void
acmgt3_add_l1_profile_slm_bank_conflicts__xe_core3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileSlmBankConflicts";
    metric_set->symbol_name = "L1ProfileSlmBankConflicts_XeCore3";
    metric_set->hw_config_guid = "41302bd4-41dd-4c52-b250-569324d62f1a";
    metric_set->counters = calloc(10, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l1_profile_slm_bank_conflicts__xe_core3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM BANK CONFLICT COUNT";
    counter->symbol_name = "SLM_BANK_CONFLICT_COUNT";
    counter->desc = "Number of SLM accesses resulting in a bank conflict.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__slm_bank_conflict_count__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__xve_busy__read;
    counter->max_uint64 = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_slm_bank_conflicts__xe_core3__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 10);
}

static void
acmgt3_add_l1_profile_writes__xe_core0_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileWrites";
    metric_set->symbol_name = "L1ProfileWrites_XeCore0";
    metric_set->hw_config_guid = "a0369d50-1c37-4bf4-97a9-169c92b63483";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l1_profile_writes__xe_core0_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core0__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core0__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core0__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "LOAD STORE CACHE BYTE WRITE";
    counter->symbol_name = "LOAD_STORE_CACHE_BYTE_WRITE";
    counter->desc = "Number of bytes written to the Load Store Cache, excluding SLM accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__load_store_cache_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core0__load_store_cache_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM BYTE WRITE";
    counter->symbol_name = "SLM_BYTE_WRITE";
    counter->desc = "Number of bytes written to SLM";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__slm_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core0__slm_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_writes__xe_core0__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core0__xve_busy__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core0__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_writes__xe_core0__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_writes__xe_core0__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 11);
}

static void
acmgt3_add_l1_profile_writes__xe_core3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L1ProfileWrites";
    metric_set->symbol_name = "L1ProfileWrites_XeCore3";
    metric_set->hw_config_guid = "ff386ef9-604c-48a5-9fc9-e2281bbd7463";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_l1_profile_writes__xe_core3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core3__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core3__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "LOAD STORE CACHE BYTE WRITE";
    counter->symbol_name = "LOAD_STORE_CACHE_BYTE_WRITE";
    counter->desc = "Number of bytes written to the Load Store Cache, excluding SLM accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__load_store_cache_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core3__load_store_cache_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM BYTE WRITE";
    counter->symbol_name = "SLM_BYTE_WRITE";
    counter->desc = "Number of bytes written to SLM";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__slm_byte_write__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core3__slm_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_writes__xe_core3__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__l1_profile_writes__xe_core3__xve_busy__read;
    counter->max_uint64 = acmgt3__l1_profile_writes__xe_core3__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_writes__xe_core3__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__l1_profile_writes__xe_core3__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 11);
}

static void
acmgt3_add_dataport_reads_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DataportReads";
    metric_set->symbol_name = "DataportReads";
    metric_set->hw_config_guid = "c027d083-6448-4ec1-9415-8a1ff807562c";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_dataport_reads_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__dataport_reads__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__dataport_reads__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DATAPORT BYTE READ";
    counter->symbol_name = "DATAPORT_BYTE_READ";
    counter->desc = "Number of bytes read through the Dataport";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_reads__dataport_byte_read__read;
    counter->max_uint64 = acmgt3__dataport_reads__dataport_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Dataport");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_reads__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__dataport_reads__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_reads__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__dataport_reads__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__dataport_reads__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__dataport_reads__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HOST TO GPUMEM BYTE READ";
    counter->symbol_name = "HOST_TO_GPUMEM_BYTE_READ";
    counter->desc = "Number of bytes read by host from GPU local (HBM) memory (downstream)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_reads__host_to_gpumem_byte_read__read;
    counter->max_uint64 = acmgt3__dataport_reads__host_to_gpumem_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HOST TO GPUMEM BYTE WRITE";
    counter->symbol_name = "HOST_TO_GPUMEM_BYTE_WRITE";
    counter->desc = "Number of bytes written by host to GPU local (HBM) memory (downstream)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_reads__host_to_gpumem_byte_write__read;
    counter->max_uint64 = acmgt3__dataport_reads__host_to_gpumem_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__dataport_reads__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__dataport_reads__xve_busy__read;
    counter->max_uint64 = acmgt3__dataport_reads__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE COMPUTE THREAD COUNT";
    counter->symbol_name = "XVE_COMPUTE_THREAD_COUNT";
    counter->desc = "Number of compute shader hardware threads dispatched";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__dataport_reads__xve_compute_thread_count__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__dataport_reads__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__dataport_reads__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 13);
}

static void
acmgt3_add_dataport_writes_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DataportWrites";
    metric_set->symbol_name = "DataportWrites";
    metric_set->hw_config_guid = "57e2e261-2715-4b63-baec-527eba9e06cb";
    metric_set->counters = calloc(14, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_dataport_writes_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__dataport_writes__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__dataport_writes__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DATAPORT BYTE WRITE";
    counter->symbol_name = "DATAPORT_BYTE_WRITE";
    counter->desc = "Number of bytes written through the Dataport";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_writes__dataport_byte_write__read;
    counter->max_uint64 = acmgt3__dataport_writes__dataport_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Dataport");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_writes__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__dataport_writes__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_writes__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__dataport_writes__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__dataport_writes__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__dataport_writes__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SAMPLER L3 READ";
    counter->symbol_name = "SAMPLER_L3_READ";
    counter->desc = "Number of L3 read requests resulting from sampler local cache miss";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__dataport_writes__sampler_l3_read__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SYSMEM BYTE READ";
    counter->symbol_name = "SYSMEM_BYTE_READ";
    counter->desc = "Number of system memory bytes read (upstream)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_writes__sysmem_byte_read__read;
    counter->max_uint64 = acmgt3__dataport_writes__sysmem_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SYSMEM BYTE WRITE";
    counter->symbol_name = "SYSMEM_BYTE_WRITE";
    counter->desc = "Number of system memory bytes written (upstream)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__dataport_writes__sysmem_byte_write__read;
    counter->max_uint64 = acmgt3__dataport_writes__sysmem_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE ACTIVE";
    counter->symbol_name = "XVE_ACTIVE";
    counter->desc = "Percentage of time in which at least one pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__dataport_writes__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE BUSY";
    counter->symbol_name = "XVE_BUSY";
    counter->desc = "Any XVE thread loaded.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__dataport_writes__xve_busy__read;
    counter->max_uint64 = acmgt3__dataport_writes__xve_busy__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE COMPUTE THREAD COUNT";
    counter->symbol_name = "XVE_COMPUTE_THREAD_COUNT";
    counter->desc = "Number of compute shader hardware threads dispatched";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt3__dataport_writes__xve_compute_thread_count__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE STALL";
    counter->symbol_name = "XVE_STALL";
    counter->desc = "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__dataport_writes__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE THREADS OCCUPANCY ALL";
    counter->symbol_name = "XVE_THREADS_OCCUPANCY_ALL";
    counter->desc = "Percentage of thread slots occupied";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__dataport_writes__xve_threads_occupancy_all__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 14);
}

static void
acmgt3_add_ext1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext1";
    metric_set->symbol_name = "Ext1";
    metric_set->hw_config_guid = "9e92a393-69c4-46fd-b038-e6183364d8c5";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ";
    counter->symbol_name = "GPU_MEMORY_READ";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI0";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI1";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI2";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI2";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI3";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI3";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI4";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI4";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI5";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI5";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI6";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI6";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY READ SQIDI7";
    counter->symbol_name = "GPU_MEMORY_READ_SQIDI7";
    counter->desc = "Number of GTI memory reads";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext1__gpu_memory_read_sqidi7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 12);
}

static void
acmgt3_add_ext2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext2";
    metric_set->symbol_name = "Ext2";
    metric_set->hw_config_guid = "e8621f59-b8d2-4e00-86a9-472e3848973d";
    metric_set->counters = calloc(39, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read__read;
    counter->max_uint64 = acmgt3__ext2__gpu_memory_byte_read__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI0";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi0__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI1";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi1__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI2";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI2";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi2__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI3";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI3";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi3__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI4";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI4";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi4__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI5";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI5";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi5__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI6";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI6";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi6__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ BW SQIDI7";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_BW_SQIDI7";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) read bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_read_bw_sqidi7__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI2";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI2";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI3";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI3";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI4";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI4";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI5";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI5";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI6";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI6";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE READ SQIDI7";
    counter->symbol_name = "GPU_MEMORY_BYTE_READ_SQIDI7";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_read_sqidi7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write__read;
    counter->max_uint64 = acmgt3__ext2__gpu_memory_byte_write__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI0";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi0__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI1";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi1__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI2";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI2";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi2__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI3";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI3";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi3__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI4";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI4";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi4__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI5";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI5";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi5__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI6";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI6";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi6__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE BW SQIDI7";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_BW_SQIDI7";
    counter->desc = "Device local memory (HBM, GDDR, LPDDR, etc.) write bandwidth";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_GBPS;
    counter->read_float = acmgt3__ext2__gpu_memory_byte_write_bw_sqidi7__read;
    counter->max_float = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI2";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI2";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI3";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI3";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI4";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI4";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI5";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI5";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI6";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI6";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY BYTE WRITE SQIDI7";
    counter->symbol_name = "GPU_MEMORY_BYTE_WRITE_SQIDI7";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt3__ext2__gpu_memory_byte_write_sqidi7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 39);
}

static void
acmgt3_add_ext3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext3";
    metric_set->symbol_name = "Ext3";
    metric_set->hw_config_guid = "12eee9d0-7d4a-495c-a3b5-7d8ab1b0fe02";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI2";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI2";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI3";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI3";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI4";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI4";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI5";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI5";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI6";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI6";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION READ SQIDI7";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_READ_SQIDI7";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext3__gpu_memory_32_b_transaction_read_sqidi7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 11);
}

static void
acmgt3_add_ext4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext4";
    metric_set->symbol_name = "Ext4";
    metric_set->hw_config_guid = "59c0b126-b2dc-4a97-818e-741e6355059c";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI0";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI1";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI2";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI2";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI3";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI3";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI4";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI4";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI5";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI5";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI6";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI6";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION READ SQIDI7";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_READ_SQIDI7";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) reads (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext4__gpu_memory_64_b_transaction_read_sqidi7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 11);
}

static void
acmgt3_add_ext5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext5";
    metric_set->symbol_name = "Ext5";
    metric_set->hw_config_guid = "9da5cb85-6e23-4896-8d99-1b8a87dd8930";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI2";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI2";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI3";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI3";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI4";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI4";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI5";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI5";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI6";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI6";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 32B TRANSACTION WRITE SQIDI7";
    counter->symbol_name = "GPU_MEMORY_32B_TRANSACTION_WRITE_SQIDI7";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (32B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_32_b_transaction_write_sqidi7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI0";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI1";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI2";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI2";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI3";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI3";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI4";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI4";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI5";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI5";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI6";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI6";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY 64B TRANSACTION WRITE SQIDI7";
    counter->symbol_name = "GPU_MEMORY_64B_TRANSACTION_WRITE_SQIDI7";
    counter->desc = "Number of device local memory (HBM, GDDR, LPDDR, etc.) writes (64B)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext5__gpu_memory_64_b_transaction_write_sqidi7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext6";
    metric_set->symbol_name = "Ext6";
    metric_set->hw_config_guid = "4cd5fd6b-e82a-44fc-a068-4debac13114f";
    metric_set->counters = calloc(21, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext6__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE";
    counter->symbol_name = "GPU_MEMORY_ACTIVE";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI0";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI0";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi0__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI1";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI1";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi1__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI2";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI2";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi2__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI3";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI3";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi3__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI4";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI4";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi4__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI5";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI5";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi5__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI6";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI6";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi6__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY ACTIVE SQIDI7";
    counter->symbol_name = "GPU_MEMORY_ACTIVE_SQIDI7";
    counter->desc = "Percentage of time in which device local memory (HBM, GDDR, LPDDR, etc.) is active";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_active_sqidi7__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI0";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI0";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi0__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI1";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI1";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi1__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI2";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI2";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi2__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI3";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI3";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi3__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI4";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI4";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi4__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI5";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI5";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi5__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI6";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI6";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi6__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU MEMORY REQUEST QUEUE FULL SQIDI7";
    counter->symbol_name = "GPU_MEMORY_REQUEST_QUEUE_FULL_SQIDI7";
    counter->desc = "Percentage of time in which SQ is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt3__ext6__gpu_memory_request_queue_full_sqidi7__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 21);
}

static void
acmgt3_add_ext7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext7";
    metric_set->symbol_name = "Ext7";
    metric_set->hw_config_guid = "29eade65-5f7c-4b51-8006-66852e9f2181";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext7__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK0";
    counter->symbol_name = "L3_HIT_L3BANK0";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK1";
    counter->symbol_name = "L3_HIT_L3BANK1";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK10";
    counter->symbol_name = "L3_HIT_L3BANK10";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank10__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK11";
    counter->symbol_name = "L3_HIT_L3BANK11";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank11__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK12";
    counter->symbol_name = "L3_HIT_L3BANK12";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank12__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK13";
    counter->symbol_name = "L3_HIT_L3BANK13";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank13__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK14";
    counter->symbol_name = "L3_HIT_L3BANK14";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank14__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK15";
    counter->symbol_name = "L3_HIT_L3BANK15";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank15__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK2";
    counter->symbol_name = "L3_HIT_L3BANK2";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK3";
    counter->symbol_name = "L3_HIT_L3BANK3";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK4";
    counter->symbol_name = "L3_HIT_L3BANK4";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK5";
    counter->symbol_name = "L3_HIT_L3BANK5";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK6";
    counter->symbol_name = "L3_HIT_L3BANK6";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK7";
    counter->symbol_name = "L3_HIT_L3BANK7";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK8";
    counter->symbol_name = "L3_HIT_L3BANK8";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank8__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK9";
    counter->symbol_name = "L3_HIT_L3BANK9";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext7__l3_hit_l3_bank9__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext8";
    metric_set->symbol_name = "Ext8";
    metric_set->hw_config_guid = "859c2807-55de-47e0-aa30-320c23c9373d";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext8__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext8__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext8__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext8__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK16";
    counter->symbol_name = "L3_HIT_L3BANK16";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank16__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK17";
    counter->symbol_name = "L3_HIT_L3BANK17";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank17__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK18";
    counter->symbol_name = "L3_HIT_L3BANK18";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank18__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK19";
    counter->symbol_name = "L3_HIT_L3BANK19";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank19__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK20";
    counter->symbol_name = "L3_HIT_L3BANK20";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank20__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK21";
    counter->symbol_name = "L3_HIT_L3BANK21";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank21__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK22";
    counter->symbol_name = "L3_HIT_L3BANK22";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank22__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK23";
    counter->symbol_name = "L3_HIT_L3BANK23";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank23__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK24";
    counter->symbol_name = "L3_HIT_L3BANK24";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank24__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK25";
    counter->symbol_name = "L3_HIT_L3BANK25";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank25__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK26";
    counter->symbol_name = "L3_HIT_L3BANK26";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank26__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK27";
    counter->symbol_name = "L3_HIT_L3BANK27";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank27__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK28";
    counter->symbol_name = "L3_HIT_L3BANK28";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank28__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK29";
    counter->symbol_name = "L3_HIT_L3BANK29";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank29__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK30";
    counter->symbol_name = "L3_HIT_L3BANK30";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank30__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "L3 HIT L3BANK31";
    counter->symbol_name = "L3_HIT_L3BANK31";
    counter->desc = "Number of L3 accesses which hits in the L3 cache";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt3__ext8__l3_hit_l3_bank31__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext9_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext9";
    metric_set->symbol_name = "Ext9";
    metric_set->hw_config_guid = "c9c488d0-950c-4a0a-a079-b299cd33aa6b";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext9_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext9__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext9__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext9__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext9__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK0";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK0";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK1";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK1";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK10";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK10";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank10__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK11";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK11";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank11__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK12";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK12";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank12__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK13";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK13";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank13__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK14";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK14";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank14__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK15";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK15";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank15__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK2";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK2";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK3";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK3";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK4";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK4";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK5";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK5";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK6";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK6";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK7";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK7";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK8";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK8";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank8__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK9";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK9";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext9__l3_input_available_l3_bank9__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext10_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext10";
    metric_set->symbol_name = "Ext10";
    metric_set->hw_config_guid = "4599426b-4cfa-442a-8a59-9eda3dd742db";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext10_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext10__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext10__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext10__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext10__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK16";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK16";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank16__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK17";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK17";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank17__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK18";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK18";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank18__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK19";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK19";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank19__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK20";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK20";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank20__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK21";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK21";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank21__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK22";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK22";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank22__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK23";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK23";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank23__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK24";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK24";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank24__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK25";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK25";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank25__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK26";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK26";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank26__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK27";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK27";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank27__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK28";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK28";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank28__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK29";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK29";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank29__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK30";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK30";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank30__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK INPUT AVAILABLE L3BANK31";
        counter->symbol_name = "L3_INPUT_AVAILABLE_L3BANK31";
        counter->desc = "Percentage of time in which L3 bank has input requests";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext10__l3_input_available_l3_bank31__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext11_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext11";
    metric_set->symbol_name = "Ext11";
    metric_set->hw_config_guid = "42107330-c266-42b4-aef5-5c2ab410edc4";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext11_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext11__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext11__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext11__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext11__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK0";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK0";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK1";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK1";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK10";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK10";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank10__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK11";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK11";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank11__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK12";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK12";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank12__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK13";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK13";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank13__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK14";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK14";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank14__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK15";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK15";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank15__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK2";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK2";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK3";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK3";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK4";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK4";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK5";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK5";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK6";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK6";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK7";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK7";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK8";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK8";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank8__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK9";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK9";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext11__l3_output_ready_l3_bank9__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext12_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext12";
    metric_set->symbol_name = "Ext12";
    metric_set->hw_config_guid = "a0add3fe-f028-4e6c-b104-c369fabe2b09";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext12_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext12__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext12__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext12__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext12__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK16";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK16";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank16__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK17";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK17";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank17__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK18";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK18";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank18__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK19";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK19";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank19__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK20";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK20";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank20__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK21";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK21";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank21__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK22";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK22";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank22__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK23";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK23";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank23__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK24";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK24";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank24__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK25";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK25";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank25__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK26";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK26";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank26__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK27";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK27";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank27__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK28";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK28";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank28__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK29";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK29";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank29__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK30";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK30";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank30__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 OUTPUT READY L3BANK31";
        counter->symbol_name = "L3_OUTPUT_READY_L3BANK31";
        counter->desc = "Percentage of time in which L3 bank has output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext12__l3_output_ready_l3_bank31__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext13_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext13";
    metric_set->symbol_name = "Ext13";
    metric_set->hw_config_guid = "4aeacf49-91c2-41bf-8d9f-49233689e36a";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext13_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext13__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext13__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext13__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext13__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK0";
        counter->symbol_name = "L3_BUSY_L3BANK0";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK1";
        counter->symbol_name = "L3_BUSY_L3BANK1";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK10";
        counter->symbol_name = "L3_BUSY_L3BANK10";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank10__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK11";
        counter->symbol_name = "L3_BUSY_L3BANK11";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank11__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK12";
        counter->symbol_name = "L3_BUSY_L3BANK12";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank12__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK13";
        counter->symbol_name = "L3_BUSY_L3BANK13";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank13__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK14";
        counter->symbol_name = "L3_BUSY_L3BANK14";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank14__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK15";
        counter->symbol_name = "L3_BUSY_L3BANK15";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank15__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK2";
        counter->symbol_name = "L3_BUSY_L3BANK2";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK3";
        counter->symbol_name = "L3_BUSY_L3BANK3";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK4";
        counter->symbol_name = "L3_BUSY_L3BANK4";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK5";
        counter->symbol_name = "L3_BUSY_L3BANK5";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK6";
        counter->symbol_name = "L3_BUSY_L3BANK6";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (0 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK7";
        counter->symbol_name = "L3_BUSY_L3BANK7";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK8";
        counter->symbol_name = "L3_BUSY_L3BANK8";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank8__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK9";
        counter->symbol_name = "L3_BUSY_L3BANK9";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext13__l3_busy_l3_bank9__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext14_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext14";
    metric_set->symbol_name = "Ext14";
    metric_set->hw_config_guid = "60e3a9fa-b807-4a8d-8a83-88705d05e2c9";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext14_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt3__ext14__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt3__ext14__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt3__ext14__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt3__ext14__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK16";
        counter->symbol_name = "L3_BUSY_L3BANK16";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank16__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK17";
        counter->symbol_name = "L3_BUSY_L3BANK17";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank17__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK18";
        counter->symbol_name = "L3_BUSY_L3BANK18";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank18__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK19";
        counter->symbol_name = "L3_BUSY_L3BANK19";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank19__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK20";
        counter->symbol_name = "L3_BUSY_L3BANK20";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank20__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK21";
        counter->symbol_name = "L3_BUSY_L3BANK21";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank21__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK22";
        counter->symbol_name = "L3_BUSY_L3BANK22";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank22__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK23";
        counter->symbol_name = "L3_BUSY_L3BANK23";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank23__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK24";
        counter->symbol_name = "L3_BUSY_L3BANK24";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank24__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK25";
        counter->symbol_name = "L3_BUSY_L3BANK25";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank25__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK26";
        counter->symbol_name = "L3_BUSY_L3BANK26";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank26__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK27";
        counter->symbol_name = "L3_BUSY_L3BANK27";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank27__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK28";
        counter->symbol_name = "L3_BUSY_L3BANK28";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank28__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK29";
        counter->symbol_name = "L3_BUSY_L3BANK29";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank29__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK30";
        counter->symbol_name = "L3_BUSY_L3BANK30";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank30__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    if (perf->devinfo.slice_mask & ((3 << (3 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "L3 BANK ACTIVE L3BANK31";
        counter->symbol_name = "L3_BUSY_L3BANK31";
        counter->desc = "Percentage of time in which L3 request queue has one or more requests pending";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt3__ext14__l3_busy_l3_bank31__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "L3Cache");
    }

    assert(metric_set->n_counters <= 19);
}

static void
acmgt3_add_ext15_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Ext15";
    metric_set->symbol_name = "Ext15";
    metric_set->hw_config_guid = "0aab7745-1e24-42af-9c96-c640e4f45aa9";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt3_ext15_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.