/* Autogenerated file, DO NOT EDIT manually! generated by perf-metricset-codegen.py
 *
 * Copyright (c) 2018 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#include <stddef.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdbool.h>
#include <assert.h>

#include "i915_drm.h"

#include "i915_perf_metrics_acmgt2.h"
#include "i915_perf_equations.h"
#include "i915_perf_registers_acmgt2.h"

static void
acmgt2_add_render_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics Basic - aggregation approximation";
    metric_set->symbol_name = "RenderBasic";
    metric_set->hw_config_guid = "0692a728-614d-4d12-8c03-7b3ffe961ef8";
    metric_set->counters = calloc(40, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_render_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__render_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__render_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__render_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__render_basic__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Depth Test Fails";
    counter->symbol_name = "EarlyDepthTestFails";
    counter->desc = "The total number of pixels dropped on early depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt2__render_basic__early_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__render_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__render_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__render_basic__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt2__render_basic__gti_read_throughput__read;
    counter->max_uint64 = acmgt2__render_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt2__render_basic__gti_write_throughput__read;
    counter->max_uint64 = acmgt2__render_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Early Hi-Depth Test Fails";
    counter->symbol_name = "HiDepthTestFails";
    counter->desc = "The total number of pixels dropped on early hierarchical depth test.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt2__render_basic__hi_depth_test_fails__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__render_basic__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixels Failing Tests";
    counter->symbol_name = "PixelsFailingPostPsTests";
    counter->desc = "The total number of pixels dropped on post-FS alpha, stencil, or depth tests.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt2__render_basic__pixels_failing_post_ps_tests__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EM Pipe Active";
    counter->symbol_name = "PsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__ps_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS FPU Pipe Active";
    counter->symbol_name = "PsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__ps_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Send Pipe Active";
    counter->symbol_name = "PsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__ps_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__render_basic__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Rasterized Pixels";
    counter->symbol_name = "RasterizedPixels";
    counter->desc = "The total number of rasterized pixels.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt2__render_basic__rasterized_pixels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Rasterizer");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler20 Bottleneck";
        counter->symbol_name = "Sampler20Bottleneck";
        counter->desc = "The percentage of time in which Slice2 Sampler0 has been slowing down the pipe when processing XVE requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__render_basic__sampler20_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Sampler Slice2 Xe Core0 is busy";
        counter->symbol_name = "Sampler20Busy";
        counter->desc = "The percentage of time when sampler slice2 Xe core0 is busy";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__render_basic__sampler20_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Bottleneck";
        counter->symbol_name = "SamplerBottleneck";
        counter->desc = "The percentage of time in which samplers have been slowing down the pipe when processing XVE requests.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__render_basic__sampler_bottleneck__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt2__render_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt2__render_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Samplers Busy";
        counter->symbol_name = "SamplersBusy";
        counter->desc = "The percentage of time in which samplers or L1 cache are not idle.";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__render_basic__samplers_busy__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Blended";
    counter->symbol_name = "SamplesBlended";
    counter->desc = "The total number of blended samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt2__render_basic__samples_blended__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Killed in FS";
    counter->symbol_name = "SamplesKilledInPs";
    counter->desc = "The total number of samples or pixels dropped in fragment shaders.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt2__render_basic__samples_killed_in_ps__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Samples Written";
    counter->symbol_name = "SamplesWritten";
    counter->desc = "The total number of samples or pixels written to all render targets.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PIXELS;
    counter->read_uint64 = acmgt2__render_basic__samples_written__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Rasterizer");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__render_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__render_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__render_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmReads";
    counter->desc = "The total number of reads from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__render_basic__slm_reads__read;
    counter->max_uint64 = acmgt2__render_basic__slm_reads__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Writes";
    counter->symbol_name = "SlmWrites";
    counter->desc = "The total number of writes into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__render_basic__slm_writes__read;
    counter->max_uint64 = acmgt2__render_basic__slm_writes__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EM Pipe Active";
    counter->symbol_name = "VsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__vs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS FPU Pipe Active";
    counter->symbol_name = "VsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__vs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Send Pipe Active";
    counter->symbol_name = "VsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__vs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__render_basic__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM And FPU Pipes Active";
    counter->symbol_name = "XveFpuEmActive";
    counter->desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__xve_fpu_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_basic__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 40);
}

static void
acmgt2_add_compute_basic_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Compute Metrics Basic";
    metric_set->symbol_name = "ComputeBasic";
    metric_set->hw_config_guid = "ccde9a29-a5c5-4a9e-b7f5-ec1092387e2a";
    metric_set->counters = calloc(27, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_compute_basic_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__compute_basic__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__compute_basic__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__compute_basic__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM Pipe Active";
    counter->symbol_name = "EmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE FPU Pipe Active";
    counter->symbol_name = "FpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__compute_basic__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__compute_basic__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Read Throughput";
    counter->symbol_name = "GtiReadThroughput";
    counter->desc = "The total number of GPU memory bytes read from GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt2__compute_basic__gti_read_throughput__read;
    counter->max_uint64 = acmgt2__compute_basic__gti_read_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GTI Write Throughput";
    counter->symbol_name = "GtiWriteThroughput";
    counter->desc = "The total number of GPU memory bytes written to GTI.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
    counter->read_uint64 = acmgt2__compute_basic__gti_write_throughput__read;
    counter->max_uint64 = acmgt2__compute_basic__gti_write_throughput__max;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels Misses";
    counter->symbol_name = "SamplerTexelMisses";
    counter->desc = "The total number of texels lookups (with 2x2 accuracy) that missed L1 sampler cache.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt2__compute_basic__sampler_texel_misses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Sampler Texels";
    counter->symbol_name = "SamplerTexels";
    counter->desc = "The total number of texels seen on input (with 2x2 accuracy) in all sampler units.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_TEXELS;
    counter->read_uint64 = acmgt2__compute_basic__sampler_texels__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Sampler");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Send Pipe Active";
    counter->symbol_name = "SendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Atomic Memory Accesses";
    counter->symbol_name = "ShaderAtomics";
    counter->desc = "The total number of shader atomic memory accesses.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__compute_basic__shader_atomics__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Barrier Messages";
    counter->symbol_name = "ShaderBarriers";
    counter->desc = "The total number of shader barrier messages.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__compute_basic__shader_barriers__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Shader Memory Accesses";
    counter->symbol_name = "ShaderMemoryAccesses";
    counter->desc = "The total number of shader memory accesses to L3.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__compute_basic__shader_memory_accesses__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Bytes Read";
    counter->symbol_name = "SlmReads";
    counter->desc = "The total number of reads from shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__compute_basic__slm_reads__read;
    counter->max_uint64 = acmgt2__compute_basic__slm_reads__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SLM Writes";
    counter->symbol_name = "SlmWrites";
    counter->desc = "The total number of writes into shared local memory.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_MESSAGES;
    counter->read_uint64 = acmgt2__compute_basic__slm_writes__read;
    counter->max_uint64 = acmgt2__compute_basic__slm_writes__max;
    intel_perf_add_logical_counter(perf, counter, "L1Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XMX Pipe Active";
    counter->symbol_name = "XmxActive";
    counter->desc = "The percentage of time in which XVE XMX pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xmx_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE AVG IPC Rate";
    counter->symbol_name = "XveAvgIpcRate";
    counter->desc = "The average rate of IPC calculated for 2 FPU pipelines.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NUMBER;
    counter->read_float = acmgt2__compute_basic__xve_avg_ipc_rate__read;
    counter->max_float = acmgt2__compute_basic__xve_avg_ipc_rate__max;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM And FPU Pipes Active";
    counter->symbol_name = "XveFpuEmActive";
    counter->desc = "The percentage of time in which XVE EM INT and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_fpu_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT16 Instruction";
    counter->symbol_name = "XveFpuFlt16";
    counter->desc = "The percentage of time in which FLT16 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_fpu_flt16__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT32 Instruction";
    counter->symbol_name = "XveFpuFlt32";
    counter->desc = "The percentage of time in which FLT32 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_fpu_flt32__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FPU FLT64 Instruction";
    counter->symbol_name = "XveFpuFlt64";
    counter->desc = "The percentage of time in which FLT64 instruction were processed actively on FPU INT64 pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_fpu_flt64__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XMX And FPU Pipes Active";
    counter->symbol_name = "XveFpuXmxActive";
    counter->desc = "The percentage of time in which XVE XMX and FPU INT64 pipelines were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_fpu_xmx_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__compute_basic__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 27);
}

static void
acmgt2_add_async_compute_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AsyncCompute";
    metric_set->symbol_name = "AsyncCompute";
    metric_set->hw_config_guid = "e529d23d-d766-4391-84e2-68d43fd1f9b0";
    metric_set->counters = calloc(23, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_async_compute_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ASYNC CS EM Pipe Active";
    counter->symbol_name = "AsyncCsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__async_cs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ASYNC CS FPU Pipe Active";
    counter->symbol_name = "AsyncCsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__async_cs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__async_compute__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__async_compute__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS EM Pipe Active";
    counter->symbol_name = "CsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__cs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS FPU Pipe Active";
    counter->symbol_name = "CsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__cs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__async_compute__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__async_compute__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "EM Pipe Active";
    counter->symbol_name = "EmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE FPU Pipe Active";
    counter->symbol_name = "FpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__async_compute__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__async_compute__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__async_compute__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__async_compute__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS EM Pipe Active";
    counter->symbol_name = "PsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__ps_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS FPU Pipe Active";
    counter->symbol_name = "PsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a fragment shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__ps_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__async_compute__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS EM Pipe Active";
    counter->symbol_name = "VsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__vs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS FPU Pipe Active";
    counter->symbol_name = "VsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a vertex shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__vs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__async_compute__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__async_compute__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 23);
}

static void
acmgt2_add_xve_activity1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "XveActivity1";
    metric_set->symbol_name = "XveActivity1";
    metric_set->hw_config_guid = "0785f0af-8ae2-470c-bc7b-dd81154d4d24";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_xve_activity1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__xve_activity1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__xve_activity1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Send Pipe Active";
    counter->symbol_name = "CsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a compute shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__cs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__xve_activity1__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS EM Pipe Active";
    counter->symbol_name = "DsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__ds_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS FPU Pipe Active";
    counter->symbol_name = "DsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__ds_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Send Pipe Active";
    counter->symbol_name = "DsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a domain shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__ds_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__xve_activity1__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__xve_activity1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__xve_activity1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS EM Pipe Active";
    counter->symbol_name = "GsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__gs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS FPU Pipe Active";
    counter->symbol_name = "GsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__gs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Send Pipe Active";
    counter->symbol_name = "GsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a geometry shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__gs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__xve_activity1__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS EM Pipe Active";
    counter->symbol_name = "HsEmActive";
    counter->desc = "The percentage of time in which XVE EM INT pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__hs_em_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS FPU Pipe Active";
    counter->symbol_name = "HsFpuActive";
    counter->desc = "The percentage of time in which XVE FPU INT64 pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__hs_fpu_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Send Pipe Active";
    counter->symbol_name = "HsSendActive";
    counter->desc = "The percentage of time in which XVE send pipeline was actively processing a hull shader instruction.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__xve_activity1__hs_send_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__xve_activity1__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__xve_activity1__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__xve_activity1__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_gpu_busyness_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "GpuBusyness";
    metric_set->symbol_name = "GpuBusyness";
    metric_set->hw_config_guid = "1a01365e-7c8d-4816-b69a-edb89731dcf9";
    metric_set->counters = calloc(23, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_gpu_busyness_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Any compute engine busy";
    counter->symbol_name = "AnyComputeEngineBusy";
    counter->desc = "The percentage of time when any compute engine is busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__any_compute_engine_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__gpu_busyness__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__gpu_busyness__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Blitter Ring Busy";
    counter->symbol_name = "BlitterBusy";
    counter->desc = "The percentage of time when blitter command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__blitter_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ComputeEngine1 Ring Busy";
    counter->symbol_name = "ComputeEngine1Busy";
    counter->desc = "The percentage of time when compute command streamer 1 was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__compute_engine1_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "ComputeEngine2 Ring Busy";
    counter->symbol_name = "ComputeEngine2Busy";
    counter->desc = "The percentage of time when compute command streamer 2 was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__compute_engine2_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CS Threads Dispatched";
    counter->symbol_name = "CsThreads";
    counter->desc = "The total number of compute shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__gpu_busyness__cs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS Threads Dispatched";
    counter->symbol_name = "DsThreads";
    counter->desc = "The total number of domain shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__gpu_busyness__ds_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__gpu_busyness__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__gpu_busyness__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS Threads Dispatched";
    counter->symbol_name = "GsThreads";
    counter->desc = "The total number of geometry shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__gpu_busyness__gs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS Threads Dispatched";
    counter->symbol_name = "HsThreads";
    counter->desc = "The total number of hull shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__gpu_busyness__hs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "FS Threads Dispatched";
    counter->symbol_name = "PsThreads";
    counter->desc = "The total number of fragment shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__gpu_busyness__ps_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render and any compute engines are simultaneously busy";
    counter->symbol_name = "RenderAndAnyComputeEngineBusy";
    counter->desc = "The percentage of time when render and any compute engines are simultaneously busy";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__render_and_any_compute_engine_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Render Ring Busy";
    counter->symbol_name = "RenderBusy";
    counter->desc = "The percentage of time when render command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__render_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vdbox00 Ring Busy";
    counter->symbol_name = "Vdbox00Busy";
    counter->desc = "The percentage of time when vdbox00 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__vdbox00_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vdbox10 Ring Busy";
    counter->symbol_name = "Vdbox10Busy";
    counter->desc = "The percentage of time when vdbox10 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__vdbox10_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vebox0 Ring Busy";
    counter->symbol_name = "Vebox0Busy";
    counter->desc = "The percentage of time when vebox0 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__vebox0_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Vebox1 Ring Busy";
    counter->symbol_name = "Vebox1Busy";
    counter->desc = "The percentage of time when vebox1 command streamer was busy.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__vebox1_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Media");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS Threads Dispatched";
    counter->symbol_name = "VsThreads";
    counter->desc = "The total number of vertex shader hardware threads dispatched.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_THREADS;
    counter->read_uint64 = acmgt2__gpu_busyness__vs_threads__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Active";
    counter->symbol_name = "XveActive";
    counter->desc = "The percentage of time in which the Execution Units were actively processing.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__xve_active__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Stall";
    counter->symbol_name = "XveStall";
    counter->desc = "The percentage of time in which the Execution Units were stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__xve_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "XVE Thread Occupancy";
    counter->symbol_name = "XveThreadOccupancy";
    counter->desc = "The percentage of time in which hardware threads occupied XVEs.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__gpu_busyness__xve_thread_occupancy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "VectorEngine");

    assert(metric_set->n_counters <= 23);
}

static void
acmgt2_add_render_pipe_profile1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile1";
    metric_set->hw_config_guid = "9ca2b4be-4bd5-4873-9d59-9d6a5d9f8c29";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_render_pipe_profile1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__render_pipe_profile1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__render_pipe_profile1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC20 Bottleneck";
    counter->symbol_name = "Bc20Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__bc20_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper2 Bottleneck";
    counter->symbol_name = "Cl2Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__cl2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL2 Stall";
    counter->symbol_name = "Cl2Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__cl2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS2 Bottleneck";
    counter->symbol_name = "Ds2Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__ds2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS2 Stall";
    counter->symbol_name = "Ds2Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__ds2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__render_pipe_profile1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__render_pipe_profile1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS2 Bottleneck";
    counter->symbol_name = "Gs2Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__gs2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth20 Bottleneck";
    counter->symbol_name = "HiDepth20Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__hi_depth20_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS2 Bottleneck";
    counter->symbol_name = "Hs2Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__hs2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS2 Stall";
    counter->symbol_name = "Hs2Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__hs2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF2 Bottleneck";
    counter->symbol_name = "Sf2Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__sf2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF2 Stall";
    counter->symbol_name = "Sf2Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__sf2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO2 Bottleneck";
    counter->symbol_name = "So2Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__so2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO2 Stall";
    counter->symbol_name = "So2Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__so2_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF2 Bottleneck";
    counter->symbol_name = "Vf2Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__vf2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS2 Bottleneck";
    counter->symbol_name = "Vs2Bottleneck";
    counter->desc = "The percentage of time in which VS2 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile1__vs2_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_render_pipe_profile2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile2";
    metric_set->hw_config_guid = "901cbc75-aa84-496c-a07d-c5db62b8dadb";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_render_pipe_profile2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__render_pipe_profile2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__render_pipe_profile2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC30 Bottleneck";
    counter->symbol_name = "Bc30Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__bc30_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper3 Bottleneck";
    counter->symbol_name = "Cl3Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__cl3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL3 Stall";
    counter->symbol_name = "Cl3Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__cl3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS3 Bottleneck";
    counter->symbol_name = "Ds3Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__ds3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS3 Stall";
    counter->symbol_name = "Ds3Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__ds3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__render_pipe_profile2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__render_pipe_profile2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS3 Bottleneck";
    counter->symbol_name = "Gs3Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__gs3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth30 Bottleneck";
    counter->symbol_name = "HiDepth30Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__hi_depth30_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS3 Bottleneck";
    counter->symbol_name = "Hs3Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__hs3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS3 Stall";
    counter->symbol_name = "Hs3Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__hs3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF3 Bottleneck";
    counter->symbol_name = "Sf3Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__sf3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF3 Stall";
    counter->symbol_name = "Sf3Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__sf3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO3 Bottleneck";
    counter->symbol_name = "So3Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__so3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO3 Stall";
    counter->symbol_name = "So3Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__so3_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF3 Bottleneck";
    counter->symbol_name = "Vf3Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__vf3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS3 Bottleneck";
    counter->symbol_name = "Vs3Bottleneck";
    counter->desc = "The percentage of time in which VS3 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile2__vs3_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_render_pipe_profile3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile3";
    metric_set->hw_config_guid = "9afedc01-2ddf-46af-a5da-8310c1afed17";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_render_pipe_profile3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__render_pipe_profile3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__render_pipe_profile3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC40 Bottleneck";
    counter->symbol_name = "Bc40Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__bc40_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper4 Bottleneck";
    counter->symbol_name = "Cl4Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__cl4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL4 Stall";
    counter->symbol_name = "Cl4Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__cl4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS4 Bottleneck";
    counter->symbol_name = "Ds4Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__ds4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS4 Stall";
    counter->symbol_name = "Ds4Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__ds4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__render_pipe_profile3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__render_pipe_profile3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS4 Bottleneck";
    counter->symbol_name = "Gs4Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__gs4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth40 Bottleneck";
    counter->symbol_name = "HiDepth40Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__hi_depth40_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS4 Bottleneck";
    counter->symbol_name = "Hs4Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__hs4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS4 Stall";
    counter->symbol_name = "Hs4Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__hs4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF4 Bottleneck";
    counter->symbol_name = "Sf4Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__sf4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF4 Stall";
    counter->symbol_name = "Sf4Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__sf4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO4 Bottleneck";
    counter->symbol_name = "So4Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__so4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO4 Stall";
    counter->symbol_name = "So4Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__so4_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF4 Bottleneck";
    counter->symbol_name = "Vf4Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__vf4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS4 Bottleneck";
    counter->symbol_name = "Vs4Bottleneck";
    counter->desc = "The percentage of time in which VS4 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile3__vs4_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_render_pipe_profile4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Render Metrics for 3D Pipeline Profile";
    metric_set->symbol_name = "RenderPipeProfile4";
    metric_set->hw_config_guid = "89469a84-856d-4433-8962-773c68ce818b";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_render_pipe_profile4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__render_pipe_profile4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__render_pipe_profile4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "BC50 Bottleneck";
    counter->symbol_name = "Bc50Bottleneck";
    counter->desc = "The percentage of time in which barycentric coordinates calculation pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__bc50_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Clipper5 Bottleneck";
    counter->symbol_name = "Cl5Bottleneck";
    counter->desc = "The percentage of time in which clipper pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__cl5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "CL5 Stall";
    counter->symbol_name = "Cl5Stall";
    counter->desc = "The percentage of time in which clipper pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__cl5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS5 Bottleneck";
    counter->symbol_name = "Ds5Bottleneck";
    counter->desc = "The percentage of time in which domain shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__ds5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "DS5 Stall";
    counter->symbol_name = "Ds5Stall";
    counter->desc = "The percentage of time in which domain shader pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__ds5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__render_pipe_profile4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__render_pipe_profile4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GS5 Bottleneck";
    counter->symbol_name = "Gs5Bottleneck";
    counter->desc = "The percentage of time in which geometry shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__gs5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Hi-Depth50 Bottleneck";
    counter->symbol_name = "HiDepth50Bottleneck";
    counter->desc = "The percentage of time in which early hierarchical depth test pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__hi_depth50_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS5 Bottleneck";
    counter->symbol_name = "Hs5Bottleneck";
    counter->desc = "The percentage of time in which hull shader pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__hs5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "HS5 Stall";
    counter->symbol_name = "Hs5Stall";
    counter->desc = "The percentage of time in which hull stall pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__hs5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF5 Bottleneck";
    counter->symbol_name = "Sf5Bottleneck";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__sf5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SF5 Stall";
    counter->symbol_name = "Sf5Stall";
    counter->desc = "The percentage of time in which strip-fans pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__sf5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO5 Bottleneck";
    counter->symbol_name = "So5Bottleneck";
    counter->desc = "The percentage of time in which stream output pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__so5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SO5 Stall";
    counter->symbol_name = "So5Stall";
    counter->desc = "The percentage of time in which stream-output pipeline stage was stalled.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__so5_stall__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VF5 Bottleneck";
    counter->symbol_name = "Vf5Bottleneck";
    counter->desc = "The percentage of time in which vertex fetch pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__vf5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "VS5 Bottleneck";
    counter->symbol_name = "Vs5Bottleneck";
    counter->desc = "The percentage of time in which VS5 pipeline stage was slowing down the 3D pipeline.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__render_pipe_profile4__vs5_bottleneck__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_l3_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_1";
    metric_set->symbol_name = "L3_1";
    metric_set->hw_config_guid = "2128b792-e30e-49ec-a64b-8a636364f728";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_l3_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__l3_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__l3_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__l3_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__l3_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank0 Input Available";
    counter->symbol_name = "L31Bank0InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank0 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank0_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank0 Output Ready";
    counter->symbol_name = "L31Bank0OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank0 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank0_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank1 Input Available";
    counter->symbol_name = "L31Bank1InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank1 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank1_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank1 Output Ready";
    counter->symbol_name = "L31Bank1OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank1 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank1_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank2 Input Available";
    counter->symbol_name = "L31Bank2InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank2 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank2_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank2 Output Ready";
    counter->symbol_name = "L31Bank2OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank2 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank2_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank3 Input Available";
    counter->symbol_name = "L31Bank3InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank3 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank3_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank3 Output Ready";
    counter->symbol_name = "L31Bank3OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank3 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank3_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank4 Input Available";
    counter->symbol_name = "L31Bank4InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank4 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank4_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank4 Output Ready";
    counter->symbol_name = "L31Bank4OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank4 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank4_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank5 Input Available";
    counter->symbol_name = "L31Bank5InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank5 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank5_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank5 Output Ready";
    counter->symbol_name = "L31Bank5OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank5 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank5_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank6 Input Available";
    counter->symbol_name = "L31Bank6InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank6 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank6_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank6 Output Ready";
    counter->symbol_name = "L31Bank6OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank6 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank6_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank7 Input Available";
    counter->symbol_name = "L31Bank7InputAvailable";
    counter->desc = "The percentage of time in which Quad1 L3 bank7 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank7_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad1 L3 Bank7 Output Ready";
    counter->symbol_name = "L31Bank7OutputReady";
    counter->desc = "The percentage of time in which quad1 L3 bank7 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_1__l31_bank7_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_l3_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "L3_2";
    metric_set->symbol_name = "L3_2";
    metric_set->hw_config_guid = "a70724fd-5214-4325-b32c-61b37f409efa";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_l3_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__l3_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__l3_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__l3_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__l3_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank0 Input Available";
    counter->symbol_name = "L32Bank0InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank0 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank0_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank0 Output Ready";
    counter->symbol_name = "L32Bank0OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank0 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank0_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank1 Input Available";
    counter->symbol_name = "L32Bank1InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank1 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank1_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank1 Output Ready";
    counter->symbol_name = "L32Bank1OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank1 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank1_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank2 Input Available";
    counter->symbol_name = "L32Bank2InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank2 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank2_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank2 Output Ready";
    counter->symbol_name = "L32Bank2OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank2 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank2_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank3 Input Available";
    counter->symbol_name = "L32Bank3InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank3 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank3_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank3 Output Ready";
    counter->symbol_name = "L32Bank3OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank3 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank3_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank4 Input Available";
    counter->symbol_name = "L32Bank4InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank4 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank4_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank4 Output Ready";
    counter->symbol_name = "L32Bank4OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank4 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank4_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank5 Input Available";
    counter->symbol_name = "L32Bank5InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank5 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank5_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank5 Output Ready";
    counter->symbol_name = "L32Bank5OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank5 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank5_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank6 Input Available";
    counter->symbol_name = "L32Bank6InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank6 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank6_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank6 Output Ready";
    counter->symbol_name = "L32Bank6OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank6 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank6_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank7 Input Available";
    counter->symbol_name = "L32Bank7InputAvailable";
    counter->desc = "The percentage of time in which Quad2 L3 bank7 has input available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank7_input_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Quad2 L3 Bank7 Output Ready";
    counter->symbol_name = "L32Bank7OutputReady";
    counter->desc = "The percentage of time in which quad2 L3 bank7 output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__l3_2__l32_bank7_output_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "L3Cache");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_sampler_1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_1";
    metric_set->symbol_name = "Sampler_1";
    metric_set->hw_config_guid = "167e0c1d-8ef2-44d3-b4fa-407b9a23eb5a";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_sampler_1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__sampler_1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__sampler_1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__sampler_1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__sampler_1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__sampler_1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core0 Input Available";
        counter->symbol_name = "Sampler20InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler20_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler20OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler20_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core1 Input Available";
        counter->symbol_name = "Sampler21InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler21_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler21OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler21_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core2 Input Available";
        counter->symbol_name = "Sampler22InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler22_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler22OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler22_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core3 Input Available";
        counter->symbol_name = "Sampler23InputAvailable";
        counter->desc = "The percentage of time in which slice2 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler23_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler23OutputReady";
        counter->desc = "The percentage of time in which slice2 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler23_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core0 Input Available";
        counter->symbol_name = "Sampler30InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler30_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler30OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler30_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core1 Input Available";
        counter->symbol_name = "Sampler31InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler31_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler31OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler31_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core2 Input Available";
        counter->symbol_name = "Sampler32InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler32_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler32OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler32_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core3 Input Available";
        counter->symbol_name = "Sampler33InputAvailable";
        counter->desc = "The percentage of time in which slice3 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler33_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler33OutputReady";
        counter->desc = "The percentage of time in which slice3 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_1__sampler33_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_sampler_2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Sampler_2";
    metric_set->symbol_name = "Sampler_2";
    metric_set->hw_config_guid = "879e3747-17f6-40b8-9a7a-2c6752ff6d6c";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_sampler_2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__sampler_2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__sampler_2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__sampler_2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__sampler_2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__sampler_2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core0 Input Available";
        counter->symbol_name = "Sampler40InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler40_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler40OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler40_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core1 Input Available";
        counter->symbol_name = "Sampler41InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler41_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler41OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler41_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core2 Input Available";
        counter->symbol_name = "Sampler42InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler42_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler42OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler42_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core3 Input Available";
        counter->symbol_name = "Sampler43InputAvailable";
        counter->desc = "The percentage of time in which slice4 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler43_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler43OutputReady";
        counter->desc = "The percentage of time in which slice4 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler43_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core0 Input Available";
        counter->symbol_name = "Sampler50InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core0 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler50_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core0 Sampler Output Ready";
        counter->symbol_name = "Sampler50OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core0 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler50_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core1 Input Available";
        counter->symbol_name = "Sampler51InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core1 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler51_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core1 Sampler Output Ready";
        counter->symbol_name = "Sampler51OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core1 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler51_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core2 Input Available";
        counter->symbol_name = "Sampler52InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core2 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler52_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core2 Sampler Output Ready";
        counter->symbol_name = "Sampler52OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core2 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler52_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core3 Input Available";
        counter->symbol_name = "Sampler53InputAvailable";
        counter->desc = "The percentage of time in which slice5 Xe core3 sampler input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler53_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core3 Sampler Output Ready";
        counter->symbol_name = "Sampler53OutputReady";
        counter->desc = "The percentage of time in which slice5 Xe core3 sampler output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__sampler_2__sampler53_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Sampler");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_hdc_and_sf1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF1";
    metric_set->symbol_name = "HDCAndSF1";
    metric_set->hw_config_guid = "55aebe75-d0e0-4d07-aa50-4b1e672341a7";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_hdc_and_sf1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__hdc_and_sf1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__hdc_and_sf1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__hdc_and_sf1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__hdc_and_sf1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader20AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader20_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader21AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader21_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader22AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader22_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader23AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice2 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader23_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader30AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader30_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader31AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader31_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader32AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader32_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader33AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice3 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf1__non_sampler_shader33_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt2_add_hdc_and_sf2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set HDCAndSF2";
    metric_set->symbol_name = "HDCAndSF2";
    metric_set->hw_config_guid = "d9c30016-f7b6-4c66-81e1-cb75b68a2222";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_hdc_and_sf2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__hdc_and_sf2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__hdc_and_sf2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ20 is full";
    counter->symbol_name = "GTRequestQueue20Full";
    counter->desc = "The percentage of time when IDI0 SQ20 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__gt_request_queue20_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ30 is full";
    counter->symbol_name = "GTRequestQueue30Full";
    counter->desc = "The percentage of time when IDI0 SQ30 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__gt_request_queue30_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ40 is full";
    counter->symbol_name = "GTRequestQueue40Full";
    counter->desc = "The percentage of time when IDI0 SQ40 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__gt_request_queue40_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "SQ50 is full";
    counter->symbol_name = "GTRequestQueue50Full";
    counter->desc = "The percentage of time when IDI0 SQ50 is filled above a threshold (usually 48 entries)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__gt_request_queue50_full__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Memory");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__hdc_and_sf2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__hdc_and_sf2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice2) Data Ready";
    counter->symbol_name = "Poly2DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__poly2_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice3) Data Ready";
    counter->symbol_name = "Poly3DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__poly3_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice4) Data Ready";
    counter->symbol_name = "Poly4DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__poly4_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Polygon (Slice5) Data Ready";
    counter->symbol_name = "Poly5DataReady";
    counter->desc = "The percentage of time in which geometry pipeline output is ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf2__poly5_data_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "Geometry");

    assert(metric_set->n_counters <= 12);
}

static void
acmgt2_add_hdc_and_sf3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "HDCAndSF3";
    metric_set->symbol_name = "HDCAndSF3";
    metric_set->hw_config_guid = "6357cd3a-3553-4a60-8c86-7c59347c3916";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_hdc_and_sf3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__hdc_and_sf3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__hdc_and_sf3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__hdc_and_sf3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__hdc_and_sf3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__hdc_and_sf3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader40AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader40_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader41AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader41_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader42AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader42_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader43AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice4 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader43_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core0 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader50AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core0)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader50_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core1 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader51AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core1)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader51_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core2 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader52AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core2)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader52_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Xe Core3 Non-sampler Shader Access Stalled On L3";
        counter->symbol_name = "NonSamplerShader53AccessStalledOnL3";
        counter->desc = "Percentage of time when HDC has messages to L3, but it's stalled due to lack of credits (Slice5 Xe Core3)";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__hdc_and_sf3__non_sampler_shader53_access_stalled_on_l3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt2_add_rasterizer_and_pixel_backend1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend1";
    metric_set->symbol_name = "RasterizerAndPixelBackend1";
    metric_set->hw_config_guid = "031a7f13-0f25-4794-958d-38cea3050a32";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_rasterizer_and_pixel_backend1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__rasterizer_and_pixel_backend1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice2 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData20Ready";
    counter->desc = "The percentage of time in which slice2  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend1__pixel_data20_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice2 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData21Ready";
    counter->desc = "The percentage of time in which slice2  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend1__pixel_data21_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice3 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData30Ready";
    counter->desc = "The percentage of time in which slice3  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend1__pixel_data30_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice3 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData31Ready";
    counter->desc = "The percentage of time in which slice3  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend1__pixel_data31_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer2InputAvailable";
        counter->desc = "The percentage of time in which slice2 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend1__rasterizer2_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer3OutputReady";
        counter->desc = "The percentage of time in which slice3 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend1__rasterizer3_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer4InputAvailable";
        counter->desc = "The percentage of time in which slice4 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend1__rasterizer4_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer5OutputReady";
        counter->desc = "The percentage of time in which slice5 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend1__rasterizer5_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt2_add_rasterizer_and_pixel_backend2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set RasterizerAndPixelBackend2";
    metric_set->symbol_name = "RasterizerAndPixelBackend2";
    metric_set->hw_config_guid = "2032fb37-ebc9-4eb6-8916-4550474edd5d";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_rasterizer_and_pixel_backend2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__rasterizer_and_pixel_backend2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice4 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData40Ready";
    counter->desc = "The percentage of time in which slice4  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend2__pixel_data40_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice4 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData41Ready";
    counter->desc = "The percentage of time in which slice4  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend2__pixel_data41_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice5 Pipe0 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData50Ready";
    counter->desc = "The percentage of time in which slice5  pipe0 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend2__pixel_data50_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Slice5 Pipe1 Post-EarlyZ Pixel Data Ready";
    counter->symbol_name = "PixelData51Ready";
    counter->desc = "The percentage of time in which slice5  pipe1 post-EarlyZ pixel data is ready (after early Z tests have been applied)";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend2__pixel_data51_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "DepthPipe");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice2 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer2OutputReady";
        counter->desc = "The percentage of time in which slice2 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend2__rasterizer2_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice3 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer3InputAvailable";
        counter->desc = "The percentage of time in which slice3 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend2__rasterizer3_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice4 Rasterizer Output Ready";
        counter->symbol_name = "Rasterizer4OutputReady";
        counter->desc = "The percentage of time in which slice4 rasterizer output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend2__rasterizer4_output_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Slice5 Rasterizer Input Available";
        counter->symbol_name = "Rasterizer5InputAvailable";
        counter->desc = "The percentage of time in which slice5 rasterizer input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__rasterizer_and_pixel_backend2__rasterizer5_input_available__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Rasterizer");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt2_add_rasterizer_and_pixel_backend3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "RasterizerAndPixelBackend3";
    metric_set->symbol_name = "RasterizerAndPixelBackend3";
    metric_set->hw_config_guid = "51bc5454-ff6e-4033-b8b0-c9734975b3d4";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_rasterizer_and_pixel_backend3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__rasterizer_and_pixel_backend3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__rasterizer_and_pixel_backend3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS10 Output Available";
    counter->symbol_name = "PSOutput10Available";
    counter->desc = "The percentage of time in which PS10 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__ps_output10_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS11 Output Available";
    counter->symbol_name = "PSOutput11Available";
    counter->desc = "The percentage of time in which PS11 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__ps_output11_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS20 Output Available";
    counter->symbol_name = "PSOutput20Available";
    counter->desc = "The percentage of time in which PS20 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__ps_output20_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "PS21 Output Available";
    counter->symbol_name = "PSOutput21Available";
    counter->desc = "The percentage of time in which PS21 output is available";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__ps_output21_available__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 10 Ready";
    counter->symbol_name = "PixelValues10Ready";
    counter->desc = "The percentage of time in which pixel values 10 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__pixel_values10_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 11 Ready";
    counter->symbol_name = "PixelValues11Ready";
    counter->desc = "The percentage of time in which pixel values 11 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__pixel_values11_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 20 Ready";
    counter->symbol_name = "PixelValues20Ready";
    counter->desc = "The percentage of time in which pixel values 20 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__pixel_values20_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "Pixel Values 21 Ready";
    counter->symbol_name = "PixelValues21Ready";
    counter->desc = "The percentage of time in which pixel values 21 are ready";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__rasterizer_and_pixel_backend3__pixel_values21_ready__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "ColorPipe");

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_tdl1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL1";
    metric_set->symbol_name = "TDL1";
    metric_set->hw_config_guid = "5b08d0b8-c976-4d7b-b770-8f538bee394a";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl1__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread20ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread20_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread21ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread21_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread22ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread22_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice2 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread23ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice2 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread23_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread30ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread30_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread31ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread31_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread32ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread32_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice3 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread33ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice3 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__non_ps_thread33_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader23ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header23_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader23ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header23_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader23ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header23_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader23ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header23_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader33ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header33_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader33ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header33_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader33ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header33_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader33ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl1__thread_header33_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_tdl2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL2";
    metric_set->symbol_name = "TDL2";
    metric_set->hw_config_guid = "27ee6bcc-1378-4046-8922-124ea2115039";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl2__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread20ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread20_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread21ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread21_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread22ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread22_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice2 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread23ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice2 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread23_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread30ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread30_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread31ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread31_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread32ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread32_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice3 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread33ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice3 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl2__ps_thread33_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt2_add_tdl3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL3";
    metric_set->symbol_name = "TDL3";
    metric_set->hw_config_guid = "dd909127-caff-408f-994f-e0f64a672918";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl3__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader20Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header20_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader20ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header20_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader20ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header20_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader20ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header20_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader20ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header20_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader21Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header21_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader21ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header21_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader21ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header21_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader21ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header21_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader21ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header21_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader22Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header22_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader22ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header22_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader22ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header22_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader22ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header22_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader22ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header22_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice2 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader23Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice2 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl3__thread_header23_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_tdl4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL4";
    metric_set->symbol_name = "TDL4";
    metric_set->hw_config_guid = "64fae233-cafe-4594-ab7b-fcbf5b442933";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl4__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader30Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header30_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader30ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header30_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader30ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header30_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader30ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header30_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader30ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header30_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader31Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header31_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader31ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header31_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader31ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header31_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader31ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header31_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader31ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header31_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader32Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header32_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader32ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header32_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader32ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header32_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader32ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header32_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader32ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header32_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice3 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader33Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice3 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl4__thread_header33_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_tdl5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL5";
    metric_set->symbol_name = "TDL5";
    metric_set->hw_config_guid = "063f5cea-f9ba-4c93-b7e8-22dc5c05060e";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl5__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread40ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread40_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread41ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread41_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread42ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread42_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice4 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread43ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice4 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread43_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "NonPSThread50ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread50_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "NonPSThread51ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread51_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "NonPSThread52ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread52_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Non-PS Thread Ready For Dispatch on Slice5 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "NonPSThread53ReadyForDispatch";
        counter->desc = "The percentage of time in which non-PS thread is ready for dispatch on slice5 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__non_ps_thread53_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader43ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header43_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader43ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header43_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader43ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header43_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader43ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header43_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader53ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header53_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader53ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header53_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader53ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header53_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader53ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl5__thread_header53_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_tdl6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL6";
    metric_set->symbol_name = "TDL6";
    metric_set->hw_config_guid = "4cba20e7-78ea-4aaf-bd5d-42b8647cf778";
    metric_set->counters = calloc(12, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl6__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl6__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread40ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread40_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread41ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread41_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread42ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread42_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice4 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread43ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice4 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread43_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "PSThread50ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread50_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "PSThread51ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread51_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "PSThread52ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread52_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS Thread Ready For Dispatch on Slice5 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "PSThread53ReadyForDispatch";
        counter->desc = "The percentage of time in which PS thread is ready for dispatch on slice5 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl6__ps_thread53_ready_for_dispatch__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 12);
}

static void
acmgt2_add_tdl7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL7";
    metric_set->symbol_name = "TDL7";
    metric_set->hw_config_guid = "f76dee3e-b215-4780-9c83-7a1dfb1a6e63";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl7__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl7__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader40Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header40_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader40ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header40_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader40ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header40_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader40ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header40_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader40ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header40_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader41Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header41_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader41ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header41_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader41ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header41_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader41ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header41_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader41ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header41_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader42Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header42_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader42ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header42_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader42ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header42_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader42ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header42_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader42ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header42_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice4 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader43Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice4 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl7__thread_header43_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_tdl8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "TDL8";
    metric_set->symbol_name = "TDL8";
    metric_set->hw_config_guid = "70a8e39e-5244-43ea-b922-bd7024baf879";
    metric_set->counters = calloc(20, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_tdl8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__tdl8__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__tdl8__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Busy";
    counter->symbol_name = "GpuBusy";
    counter->desc = "The percentage of time in which the GPU has been processing GPU commands.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
    counter->read_float = acmgt2__tdl8__gpu_busy__read;
    counter->max_float = percentage_max_callback_float;
    intel_perf_add_logical_counter(perf, counter, "FrontEnd");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__tdl8__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__tdl8__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader50Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header50_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader50ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header50_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader50ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header50_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader50ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header50_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core0 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader50ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core0 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header50_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader51Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header51_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader51ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header51_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader51ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header51_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader51ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header51_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core1 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader51ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core1 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header51_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader52Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header52_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 0";
        counter->symbol_name = "ThreadHeader52ReadyPort0";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 0";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header52_ready_port0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 1";
        counter->symbol_name = "ThreadHeader52ReadyPort1";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 1";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header52_ready_port1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 2";
        counter->symbol_name = "ThreadHeader52ReadyPort2";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 2";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header52_ready_port2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core2 Thread Dispatcher Port 3";
        counter->symbol_name = "ThreadHeader52ReadyPort3";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core2 thread dispatcher port 3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header52_ready_port3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "Thread Header Ready on Slice5 Xe Core3 Thread Dispatcher";
        counter->symbol_name = "ThreadHeader53Ready";
        counter->desc = "The percentage of time in which thread header is ready on slice5 Xe core3 thread dispatcher";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__tdl8__thread_header53_ready__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ThreadDispatcher");
    }

    assert(metric_set->n_counters <= 20);
}

static void
acmgt2_add_test_oa_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Metric set TestOa";
    metric_set->symbol_name = "TestOa";
    metric_set->hw_config_guid = "cfac9130-4f6a-4a2a-aafc-9e88751ce983";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_test_oa_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__test_oa__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__test_oa__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter0";
    counter->symbol_name = "Counter0";
    counter->desc = "HW test counter 0. Factor: 0.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter0__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter1";
    counter->symbol_name = "Counter1";
    counter->desc = "HW test counter 1. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter1__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter2";
    counter->symbol_name = "Counter2";
    counter->desc = "HW test counter 2. Factor: 1.0";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter2__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter3";
    counter->symbol_name = "Counter3";
    counter->desc = "HW test counter 3. Factor: 0.5";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter3__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter4";
    counter->symbol_name = "Counter4";
    counter->desc = "HW test counter 4. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter4__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter5";
    counter->symbol_name = "Counter5";
    counter->desc = "HW test counter 5. Factor: 0.3333";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter5__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter6";
    counter->symbol_name = "Counter6";
    counter->desc = "HW test counter 6. Factor: 0.16666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter6__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter7";
    counter->symbol_name = "Counter7";
    counter->desc = "HW test counter 7. Factor: 0.6666";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter7__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter8";
    counter->symbol_name = "Counter8";
    counter->desc = "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter8__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "TestCounter9 - OAR enable";
    counter->symbol_name = "Counter9";
    counter->desc = "HW test counter 9. Should be equal to 1 in query.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
    counter->read_uint64 = acmgt2__test_oa__counter9__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "Test");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__test_oa__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__test_oa__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 13);
}

static void
acmgt2_add_amfs1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AMFS1";
    metric_set->symbol_name = "AMFS1";
    metric_set->hw_config_guid = "7bb51d65-bc5c-4e23-904c-e7ad932d162e";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_amfs1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS 4X4 SHADING REQUEST SLICE0";
        counter->symbol_name = "AMFS_4X4_SHADING_REQUEST_SLICE0";
        counter->desc = "Number of Shading Request (evaluate) messages processed by AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs1__amfs_4_x4_shading_request_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE HIT SLICE0";
        counter->symbol_name = "AMFS_CACHE_HIT_SLICE0";
        counter->desc = "Number of hits in the AMFS cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs1__amfs_cache_hit_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE MISS SLICE0";
        counter->symbol_name = "AMFS_CACHE_MISS_SLICE0";
        counter->desc = "Number of cache misses in AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs1__amfs_cache_miss_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ALL INPUT SLICE0";
        counter->symbol_name = "AMFS_STALL_ALL_INPUT_SLICE0";
        counter->desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs1__amfs_stall_all_input_slice0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ANY INPUT SLICE0";
        counter->symbol_name = "AMFS_STALL_ANY_INPUT_SLICE0";
        counter->desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs1__amfs_stall_any_input_slice0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__amfs1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__amfs1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__amfs1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__amfs1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 8);
}

static void
acmgt2_add_amfs2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AMFS2";
    metric_set->symbol_name = "AMFS2";
    metric_set->hw_config_guid = "b4899455-a030-400a-a66b-ea270f7722fd";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_amfs2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS 4X4 SHADING REQUEST SLICE1";
        counter->symbol_name = "AMFS_4X4_SHADING_REQUEST_SLICE1";
        counter->desc = "Number of Shading Request (evaluate) messages processed by AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs2__amfs_4_x4_shading_request_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE HIT SLICE1";
        counter->symbol_name = "AMFS_CACHE_HIT_SLICE1";
        counter->desc = "Number of hits in the AMFS cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs2__amfs_cache_hit_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE MISS SLICE1";
        counter->symbol_name = "AMFS_CACHE_MISS_SLICE1";
        counter->desc = "Number of cache misses in AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs2__amfs_cache_miss_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ALL INPUT SLICE1";
        counter->symbol_name = "AMFS_STALL_ALL_INPUT_SLICE1";
        counter->desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs2__amfs_stall_all_input_slice1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ANY INPUT SLICE1";
        counter->symbol_name = "AMFS_STALL_ANY_INPUT_SLICE1";
        counter->desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs2__amfs_stall_any_input_slice1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__amfs2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__amfs2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__amfs2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__amfs2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 8);
}

static void
acmgt2_add_amfs3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AMFS3";
    metric_set->symbol_name = "AMFS3";
    metric_set->hw_config_guid = "cb47ffdf-f1a9-45f2-8ee6-21e0fb8111dd";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_amfs3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS 4X4 SHADING REQUEST SLICE2";
        counter->symbol_name = "AMFS_4X4_SHADING_REQUEST_SLICE2";
        counter->desc = "Number of Shading Request (evaluate) messages processed by AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs3__amfs_4_x4_shading_request_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE HIT SLICE2";
        counter->symbol_name = "AMFS_CACHE_HIT_SLICE2";
        counter->desc = "Number of hits in the AMFS cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs3__amfs_cache_hit_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE MISS SLICE2";
        counter->symbol_name = "AMFS_CACHE_MISS_SLICE2";
        counter->desc = "Number of cache misses in AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs3__amfs_cache_miss_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ALL INPUT SLICE2";
        counter->symbol_name = "AMFS_STALL_ALL_INPUT_SLICE2";
        counter->desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs3__amfs_stall_all_input_slice2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ANY INPUT SLICE2";
        counter->symbol_name = "AMFS_STALL_ANY_INPUT_SLICE2";
        counter->desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs3__amfs_stall_any_input_slice2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__amfs3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__amfs3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__amfs3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__amfs3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 8);
}

static void
acmgt2_add_amfs4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AMFS4";
    metric_set->symbol_name = "AMFS4";
    metric_set->hw_config_guid = "2e296498-77db-42ad-8f34-9cda1ff4dcd8";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_amfs4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS 4X4 SHADING REQUEST SLICE3";
        counter->symbol_name = "AMFS_4X4_SHADING_REQUEST_SLICE3";
        counter->desc = "Number of Shading Request (evaluate) messages processed by AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs4__amfs_4_x4_shading_request_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE HIT SLICE3";
        counter->symbol_name = "AMFS_CACHE_HIT_SLICE3";
        counter->desc = "Number of hits in the AMFS cache";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs4__amfs_cache_hit_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS CACHE MISS SLICE3";
        counter->symbol_name = "AMFS_CACHE_MISS_SLICE3";
        counter->desc = "Number of cache misses in AMFS";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs4__amfs_cache_miss_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ALL INPUT SLICE3";
        counter->symbol_name = "AMFS_STALL_ALL_INPUT_SLICE3";
        counter->desc = "Percentage of time in which AMFS stalls at both of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs4__amfs_stall_all_input_slice3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS STALL ANY INPUT SLICE3";
        counter->symbol_name = "AMFS_STALL_ANY_INPUT_SLICE3";
        counter->desc = "Percentage of time in which AMFS stalls at any of the color pipe inputs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__amfs4__amfs_stall_any_input_slice3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__amfs4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__amfs4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__amfs4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__amfs4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 8);
}

static void
acmgt2_add_amfs5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "AMFS5";
    metric_set->symbol_name = "AMFS5";
    metric_set->hw_config_guid = "ef47f98a-fb5f-426d-922e-8ae13cedb198";
    metric_set->counters = calloc(15, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_amfs5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ACCESS SLICE0";
        counter->symbol_name = "AMFS_L3_ACCESS_SLICE0";
        counter->desc = "Number of AMFS accesses to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_access_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ACCESS SLICE1";
        counter->symbol_name = "AMFS_L3_ACCESS_SLICE1";
        counter->desc = "Number of AMFS accesses to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_access_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ACCESS SLICE2";
        counter->symbol_name = "AMFS_L3_ACCESS_SLICE2";
        counter->desc = "Number of AMFS accesses to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_access_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ACCESS SLICE3";
        counter->symbol_name = "AMFS_L3_ACCESS_SLICE3";
        counter->desc = "Number of AMFS accesses to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_access_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ATOMIC SLICE0";
        counter->symbol_name = "AMFS_L3_ATOMIC_SLICE0";
        counter->desc = "Number of AMFS atomics to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_atomic_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ATOMIC SLICE1";
        counter->symbol_name = "AMFS_L3_ATOMIC_SLICE1";
        counter->desc = "Number of AMFS atomics to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_atomic_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ATOMIC SLICE2";
        counter->symbol_name = "AMFS_L3_ATOMIC_SLICE2";
        counter->desc = "Number of AMFS atomics to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_atomic_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 ATOMIC SLICE3";
        counter->symbol_name = "AMFS_L3_ATOMIC_SLICE3";
        counter->desc = "Number of AMFS atomics to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_atomic_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 WRITE SLICE0";
        counter->symbol_name = "AMFS_L3_WRITE_SLICE0";
        counter->desc = "Number of AMFS writes to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_write_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 WRITE SLICE1";
        counter->symbol_name = "AMFS_L3_WRITE_SLICE1";
        counter->desc = "Number of AMFS writes to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_write_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 WRITE SLICE2";
        counter->symbol_name = "AMFS_L3_WRITE_SLICE2";
        counter->desc = "Number of AMFS writes to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_write_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "AMFS L3 WRITE SLICE3";
        counter->symbol_name = "AMFS_L3_WRITE_SLICE3";
        counter->desc = "Number of AMFS writes to L3";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__amfs5__amfs_l3_write_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "AMFS");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__amfs5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__amfs5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__amfs5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__amfs5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 15);
}

static void
acmgt2_add_color_pipe1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe1";
    metric_set->symbol_name = "ColorPipe1";
    metric_set->hw_config_guid = "ec2c2ae9-a41e-4ff4-99f1-118959c94bfb";
    metric_set->counters = calloc(18, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE HIT L3NODE0";
        counter->symbol_name = "RENDER_CACHE_HIT_L3NODE0";
        counter->desc = "Number of Render Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_hit_l3_node0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE HIT L3NODE1";
        counter->symbol_name = "RENDER_CACHE_HIT_L3NODE1";
        counter->desc = "Number of Render Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_hit_l3_node1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE HIT L3NODE2";
        counter->symbol_name = "RENDER_CACHE_HIT_L3NODE2";
        counter->desc = "Number of Render Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_hit_l3_node2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_INPUT_AVAILABLE _L3NODE0";
        counter->symbol_name = "RENDER_CACHE_INPUT_AVAILABLE_L3NODE0";
        counter->desc = "Percentage of time when render cache input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe1__render_cache_input_available_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_INPUT_AVAILABLE _L3NODE1";
        counter->symbol_name = "RENDER_CACHE_INPUT_AVAILABLE_L3NODE1";
        counter->desc = "Percentage of time when render cache input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe1__render_cache_input_available_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_INPUT_AVAILABLE _L3NODE2";
        counter->symbol_name = "RENDER_CACHE_INPUT_AVAILABLE_L3NODE2";
        counter->desc = "Percentage of time when render cache input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe1__render_cache_input_available_l3_node2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_OUTPUT_READY _L3NODE0";
        counter->symbol_name = "RENDER_CACHE_OUTPUT_READY_L3NODE0";
        counter->desc = "Percentage of time when render cache output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe1__render_cache_output_ready_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_OUTPUT_READY _L3NODE1";
        counter->symbol_name = "RENDER_CACHE_OUTPUT_READY_L3NODE1";
        counter->desc = "Percentage of time when render cache output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe1__render_cache_output_ready_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_OUTPUT_READY _L3NODE2";
        counter->symbol_name = "RENDER_CACHE_OUTPUT_READY_L3NODE2";
        counter->desc = "Percentage of time when render cache output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe1__render_cache_output_ready_l3_node2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE READ L3NODE0";
        counter->symbol_name = "RENDER_CACHE_READ_L3NODE0";
        counter->desc = "Number of Render Cache reads";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_read_l3_node0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE READ L3NODE1";
        counter->symbol_name = "RENDER_CACHE_READ_L3NODE1";
        counter->desc = "Number of Render Cache reads";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_read_l3_node1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE READ L3NODE2";
        counter->symbol_name = "RENDER_CACHE_READ_L3NODE2";
        counter->desc = "Number of Render Cache reads";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_read_l3_node2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE WRITE L3NODE0";
        counter->symbol_name = "RENDER_CACHE_WRITE_L3NODE0";
        counter->desc = "Number of Render Cache writes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_write_l3_node0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE WRITE L3NODE1";
        counter->symbol_name = "RENDER_CACHE_WRITE_L3NODE1";
        counter->desc = "Number of Render Cache writes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_write_l3_node1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE WRITE L3NODE2";
        counter->symbol_name = "RENDER_CACHE_WRITE_L3NODE2";
        counter->desc = "Number of Render Cache writes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe1__render_cache_write_l3_node2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 18);
}

static void
acmgt2_add_color_pipe2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe2";
    metric_set->symbol_name = "ColorPipe2";
    metric_set->hw_config_guid = "d7862a6d-902e-4d1f-9f39-e0f94aa4346e";
    metric_set->counters = calloc(8, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE HIT L3NODE3";
        counter->symbol_name = "RENDER_CACHE_HIT_L3NODE3";
        counter->desc = "Number of Render Cache hits";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe2__render_cache_hit_l3_node3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_INPUT_AVAILABLE _L3NODE3";
        counter->symbol_name = "RENDER_CACHE_INPUT_AVAILABLE_L3NODE3";
        counter->desc = "Percentage of time when render cache input is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe2__render_cache_input_available_l3_node3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER_CACHE_OUTPUT_READY _L3NODE3";
        counter->symbol_name = "RENDER_CACHE_OUTPUT_READY_L3NODE3";
        counter->desc = "Percentage of time when render cache output is ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe2__render_cache_output_ready_l3_node3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE READ L3NODE3";
        counter->symbol_name = "RENDER_CACHE_READ_L3NODE3";
        counter->desc = "Number of Render Cache reads";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe2__render_cache_read_l3_node3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE WRITE L3NODE3";
        counter->symbol_name = "RENDER_CACHE_WRITE_L3NODE3";
        counter->desc = "Number of Render Cache writes";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe2__render_cache_write_l3_node3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 8);
}

static void
acmgt2_add_color_pipe3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe3";
    metric_set->symbol_name = "ColorPipe3";
    metric_set->hw_config_guid = "f00094e7-2baa-4bb9-807b-d77bb1c72eba";
    metric_set->counters = calloc(17, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE0";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE0";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE1";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE1";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE2";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE2";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE3";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE3";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE4";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE4";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE5";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE5";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE6";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE6";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY1 STALL CPIPE7";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY1_STALL_CPIPE7";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to MultiSampling Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency1_stall_cpipe7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY2 STALL L3NODE0";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE0";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency2_stall_l3_node0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY2 STALL L3NODE1";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE1";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency2_stall_l3_node1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY2 STALL L3NODE2";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE2";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency2_stall_l3_node2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "COLOR PIPE CACHE LATENCY2 STALL L3NODE3";
        counter->symbol_name = "COLOR_PIPE_CACHE_LATENCY2_STALL_L3NODE3";
        counter->desc = "Percentage of time in which Color Pipeline stalled due to Render Cache latency hiding structure full";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__color_pipe_cache_latency2_stall_l3_node3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE0";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE0";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__ps_output_available_cpipe0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE1";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE1";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe3__ps_output_available_cpipe1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 17);
}

static void
acmgt2_add_color_pipe4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe4";
    metric_set->symbol_name = "ColorPipe4";
    metric_set->hw_config_guid = "341991a5-3457-4201-a48e-d368a979f01d";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE0";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE0";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe4__pixel_post_process_input_available_cpipe0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE1";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE1";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe4__pixel_post_process_input_available_cpipe1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_color_pipe5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe5";
    metric_set->symbol_name = "ColorPipe5";
    metric_set->hw_config_guid = "34664510-6687-48d0-adc5-b7a60069de8d";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE2";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE2";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe5__pixel_post_process_input_available_cpipe2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE3";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE3";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe5__pixel_post_process_input_available_cpipe3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_color_pipe6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe6";
    metric_set->symbol_name = "ColorPipe6";
    metric_set->hw_config_guid = "1c9a3218-c1ee-402f-b483-6263a0757515";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe6__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE4";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE4";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe6__pixel_post_process_input_available_cpipe4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE5";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE5";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe6__pixel_post_process_input_available_cpipe5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_color_pipe7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe7";
    metric_set->symbol_name = "ColorPipe7";
    metric_set->hw_config_guid = "d85dc73b-5121-44c8-87b2-df05b1eecdf3";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe7__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE6";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE6";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe7__pixel_post_process_input_available_cpipe6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS INPUT AVAILABLE CPIPE7";
        counter->symbol_name = "PIXEL_POST_PROCESS_INPUT_AVAILABLE_CPIPE7";
        counter->desc = "Percentage of time in which Color Pipeline input ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe7__pixel_post_process_input_available_cpipe7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_color_pipe8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe8";
    metric_set->symbol_name = "ColorPipe8";
    metric_set->hw_config_guid = "4695a23b-b2b0-48f5-8bf1-743255be3e2e";
    metric_set->counters = calloc(13, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe8__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe8__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe8__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe8__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE0";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE0";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__pixel_post_process_output_ready_cpipe0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE1";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE1";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__pixel_post_process_output_ready_cpipe1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE2";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE2";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__pixel_post_process_output_ready_cpipe2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE3";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE3";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__pixel_post_process_output_ready_cpipe3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE2";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE2";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__ps_output_available_cpipe2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE3";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE3";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__ps_output_available_cpipe3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE4";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE4";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__ps_output_available_cpipe4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE5";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE5";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__ps_output_available_cpipe5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE6";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE6";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__ps_output_available_cpipe6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PS OUTPUT AVAILABLE CPIPE7";
        counter->symbol_name = "PS_OUTPUT_AVAILABLE_CPIPE7";
        counter->desc = "Percentage of time in which Pixel Shader data is available";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe8__ps_output_available_cpipe7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 13);
}

static void
acmgt2_add_color_pipe9_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe9";
    metric_set->symbol_name = "ColorPipe9";
    metric_set->hw_config_guid = "73b4fa16-fd16-4c45-bb66-a733308a8b57";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe9_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe9__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe9__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe9__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe9__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE4";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE4";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe9__pixel_post_process_output_ready_cpipe4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE5";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE5";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe9__pixel_post_process_output_ready_cpipe5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE6";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE6";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe9__pixel_post_process_output_ready_cpipe6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL POST PROCESS OUTPUT READY CPIPE7";
        counter->symbol_name = "PIXEL_POST_PROCESS_OUTPUT_READY_CPIPE7";
        counter->desc = "Percentage of time in which Color Pipeline pixel output ready";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__color_pipe9__pixel_post_process_output_ready_cpipe7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE ALLOC L3NODE0";
        counter->symbol_name = "RENDER_CACHE_ALLOC_L3NODE0";
        counter->desc = "Number of Render Cache allocations";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe9__render_cache_alloc_l3_node0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (1 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE ALLOC L3NODE1";
        counter->symbol_name = "RENDER_CACHE_ALLOC_L3NODE1";
        counter->desc = "Number of Render Cache allocations";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe9__render_cache_alloc_l3_node1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE ALLOC L3NODE2";
        counter->symbol_name = "RENDER_CACHE_ALLOC_L3NODE2";
        counter->desc = "Number of Render Cache allocations";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe9__render_cache_alloc_l3_node2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    if (perf->devinfo.slice_mask & ((3 << (2 * 2)))) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "RENDER CACHE ALLOC L3NODE3";
        counter->symbol_name = "RENDER_CACHE_ALLOC_L3NODE3";
        counter->desc = "Number of Render Cache allocations";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe9__render_cache_alloc_l3_node3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_color_pipe10_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe10";
    metric_set->symbol_name = "ColorPipe10";
    metric_set->hw_config_guid = "41a973fd-a067-4760-be3a-ccac78e0eadb";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe10_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe10__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe10__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe10__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe10__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE0";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH_SLICE0";
        counter->desc = "Number of promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe10__pixel_2x2_lit_post_rasterizer_early_depth_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_color_pipe11_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe11";
    metric_set->symbol_name = "ColorPipe11";
    metric_set->hw_config_guid = "a42ec42b-53d5-40b2-8950-9aabe714601a";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe11_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe11__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe11__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe11__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe11__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE1";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH_SLICE1";
        counter->desc = "Number of promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe11__pixel_2x2_lit_post_rasterizer_early_depth_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_color_pipe12_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe12";
    metric_set->symbol_name = "ColorPipe12";
    metric_set->hw_config_guid = "4682628b-6cc3-4b22-b818-ca5347cd7bf3";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe12_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe12__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe12__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe12__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe12__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE2";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH_SLICE2";
        counter->desc = "Number of promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe12__pixel_2x2_lit_post_rasterizer_early_depth_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_color_pipe13_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe13";
    metric_set->symbol_name = "ColorPipe13";
    metric_set->hw_config_guid = "76fcf17c-a3ad-474c-a2fb-58a1517c28f4";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe13_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe13__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe13__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe13__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe13__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER EARLY DEPTH SLICE3";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_EARLY_DEPTH_SLICE3";
        counter->desc = "Number of promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe13__pixel_2x2_lit_post_rasterizer_early_depth_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_color_pipe14_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe14";
    metric_set->symbol_name = "ColorPipe14";
    metric_set->hw_config_guid = "6708cf0b-dd77-4fb7-aad1-909ffea99aea";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe14_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe14__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe14__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe14__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe14__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER LATE DEPTH SLICE0";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH_SLICE0";
        counter->desc = "Number of non-promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe14__pixel_2x2_lit_post_rasterizer_late_depth_slice0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_color_pipe15_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe15";
    metric_set->symbol_name = "ColorPipe15";
    metric_set->hw_config_guid = "cb36baf7-85bd-4ce3-a0d7-4d296c5932a7";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe15_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe15__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe15__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe15__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe15__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER LATE DEPTH SLICE1";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH_SLICE1";
        counter->desc = "Number of non-promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe15__pixel_2x2_lit_post_rasterizer_late_depth_slice1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_color_pipe16_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe16";
    metric_set->symbol_name = "ColorPipe16";
    metric_set->hw_config_guid = "f1e33629-b9d8-4033-a791-2afb70f5bf8d";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe16_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe16__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe16__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe16__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe16__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER LATE DEPTH SLICE2";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH_SLICE2";
        counter->desc = "Number of non-promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe16__pixel_2x2_lit_post_rasterizer_late_depth_slice2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_color_pipe17_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "ColorPipe17";
    metric_set->symbol_name = "ColorPipe17";
    metric_set->hw_config_guid = "fb67c9e2-4acb-4775-b715-ffc4b743d9e8";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_color_pipe17_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__color_pipe17__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__color_pipe17__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__color_pipe17__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__color_pipe17__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "PIXEL 2x2 LIT POST RASTERIZER LATE DEPTH SLICE3";
        counter->symbol_name = "PIXEL_2x2_LIT_POST_RASTERIZER_LATE_DEPTH_SLICE3";
        counter->desc = "Number of non-promoted 2x2 that are lit from Rasterizer";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__color_pipe17__pixel_2x2_lit_post_rasterizer_late_depth_slice3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "ColorPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_dataport1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport1";
    metric_set->symbol_name = "Dataport1";
    metric_set->hw_config_guid = "e0466349-b62f-474c-88f9-3a9b62a3274a";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_atomic_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_atomic_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_fence_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_fence_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_read_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_read_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE0";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_write_message_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE1";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport1__xve_dataport_write_message_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport2";
    metric_set->symbol_name = "Dataport2";
    metric_set->hw_config_guid = "28e63e4a-ae68-4913-9f28-ae9269aadf2b";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_atomic_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_atomic_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_fence_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_fence_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_read_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_read_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE2";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_write_message_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE3";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport2__xve_dataport_write_message_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport3";
    metric_set->symbol_name = "Dataport3";
    metric_set->hw_config_guid = "f9dd355a-29ce-4f78-9ea4-e2f0f799876d";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_atomic_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_atomic_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_fence_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_fence_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_read_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_read_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE4";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_write_message_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE5";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport3__xve_dataport_write_message_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport4";
    metric_set->symbol_name = "Dataport4";
    metric_set->hw_config_guid = "d79af0bc-b6e9-4057-8eb8-f61fad6efe55";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_atomic_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_atomic_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_fence_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_fence_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_read_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_read_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE6";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_write_message_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE7";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport4__xve_dataport_write_message_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport5";
    metric_set->symbol_name = "Dataport5";
    metric_set->hw_config_guid = "8890d6d6-bac2-4830-9abb-e38e1da08e0b";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE8";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE8";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_atomic_message_count_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE9";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE9";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_atomic_message_count_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE8";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE8";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_fence_message_count_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE9";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE9";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_fence_message_count_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE8";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE8";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_read_message_count_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE9";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE9";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_read_message_count_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE8";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE8";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_write_message_count_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE9";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE9";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport5__xve_dataport_write_message_count_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport6";
    metric_set->symbol_name = "Dataport6";
    metric_set->hw_config_guid = "c181f521-7c29-4ac6-a44e-d398043d1c41";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport6__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE10";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE10";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_atomic_message_count_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE11";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE11";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_atomic_message_count_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE10";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE10";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_fence_message_count_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE11";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE11";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_fence_message_count_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE10";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE10";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_read_message_count_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE11";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE11";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_read_message_count_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE10";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE10";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_write_message_count_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE11";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE11";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport6__xve_dataport_write_message_count_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport7";
    metric_set->symbol_name = "Dataport7";
    metric_set->hw_config_guid = "b83732c6-e9b4-4449-90df-3d3518bcc6a2";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport7__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE12";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE12";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_atomic_message_count_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE13";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE13";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_atomic_message_count_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE12";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE12";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_fence_message_count_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE13";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE13";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_fence_message_count_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE12";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE12";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_read_message_count_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE13";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE13";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_read_message_count_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE12";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE12";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_write_message_count_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE13";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE13";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport7__xve_dataport_write_message_count_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport8";
    metric_set->symbol_name = "Dataport8";
    metric_set->hw_config_guid = "a82addb0-e73f-43a4-9b0a-89df6b2ad267";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport8__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport8__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport8__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport8__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE14";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE14";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_atomic_message_count_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT ATOMIC MESSAGE COUNT XECORE15";
        counter->symbol_name = "XVE_DATAPORT_ATOMIC_MESSAGE_COUNT_XECORE15";
        counter->desc = "Number of atomic messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_atomic_message_count_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE14";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE14";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_fence_message_count_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT FENCE MESSAGE COUNT XECORE15";
        counter->symbol_name = "XVE_DATAPORT_FENCE_MESSAGE_COUNT_XECORE15";
        counter->desc = "Number of fence messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_fence_message_count_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE14";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE14";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_read_message_count_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT READ MESSAGE COUNT XECORE15";
        counter->symbol_name = "XVE_DATAPORT_READ_MESSAGE_COUNT_XECORE15";
        counter->desc = "Number of read messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_read_message_count_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE14";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE14";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_write_message_count_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT WRITE MESSAGE COUNT XECORE15";
        counter->symbol_name = "XVE_DATAPORT_WRITE_MESSAGE_COUNT_XECORE15";
        counter->desc = "Number of write messages sent by XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport8__xve_dataport_write_message_count_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport9_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport9";
    metric_set->symbol_name = "Dataport9";
    metric_set->hw_config_guid = "91d91417-69c7-458d-bb48-d1c83871d61a";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport9_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport9__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport9__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE0";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE0";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport9__dataport_input_available_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE1";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE1";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport9__dataport_input_available_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport9__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport9__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport10_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport10";
    metric_set->symbol_name = "Dataport10";
    metric_set->hw_config_guid = "7bb38598-cd33-4e49-957c-cbe7ab599120";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport10_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport10__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport10__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE2";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE2";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport10__dataport_input_available_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE3";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE3";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport10__dataport_input_available_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport10__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport10__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport11_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport11";
    metric_set->symbol_name = "Dataport11";
    metric_set->hw_config_guid = "8108a31f-3d5d-46f3-8cd0-6c9b2c3e0038";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport11_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport11__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport11__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE4";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE4";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport11__dataport_input_available_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE5";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE5";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport11__dataport_input_available_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport11__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport11__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport12_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport12";
    metric_set->symbol_name = "Dataport12";
    metric_set->hw_config_guid = "c7acfa27-136c-4527-8e81-517c6a2aa724";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport12_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport12__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport12__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE6";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE6";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport12__dataport_input_available_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE7";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE7";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport12__dataport_input_available_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport12__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport12__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport13_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport13";
    metric_set->symbol_name = "Dataport13";
    metric_set->hw_config_guid = "10c1bda5-f032-4e6e-8597-741046aa81c4";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport13_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport13__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport13__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE8";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE8";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport13__dataport_input_available_xecore8__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE9";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE9";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport13__dataport_input_available_xecore9__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport13__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport13__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport14_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport14";
    metric_set->symbol_name = "Dataport14";
    metric_set->hw_config_guid = "9e026386-432e-42ce-8bb8-c833127dbbe7";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport14_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport14__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport14__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE10";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE10";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport14__dataport_input_available_xecore10__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE11";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE11";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport14__dataport_input_available_xecore11__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport14__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport14__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport15_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport15";
    metric_set->symbol_name = "Dataport15";
    metric_set->hw_config_guid = "51c4a645-0ffe-4dc2-bc5c-30075c771f71";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport15_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport15__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport15__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE12";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE12";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport15__dataport_input_available_xecore12__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE13";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE13";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport15__dataport_input_available_xecore13__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport15__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport15__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport16_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport16";
    metric_set->symbol_name = "Dataport16";
    metric_set->hw_config_guid = "4699e9f0-8029-44dc-9f86-23ee43b2592e";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport16_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport16__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport16__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE14";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE14";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport16__dataport_input_available_xecore14__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT INPUT AVAILABLE XECORE15";
        counter->symbol_name = "DATAPORT_INPUT_AVAILABLE_XECORE15";
        counter->desc = "Percentage of time in which XVEs have requests to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport16__dataport_input_available_xecore15__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport16__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport16__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport17_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport17";
    metric_set->symbol_name = "Dataport17";
    metric_set->hw_config_guid = "eae3432b-6340-4d86-bae1-3d6da5d6f9c7";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport17_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport17__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport17__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE0";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE0";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport17__dataport_output_ready_xecore0__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE1";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE1";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport17__dataport_output_ready_xecore1__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE2";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE2";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport17__dataport_output_ready_xecore2__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE3";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE3";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport17__dataport_output_ready_xecore3__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport17__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport17__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 7);
}

static void
acmgt2_add_dataport18_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport18";
    metric_set->symbol_name = "Dataport18";
    metric_set->hw_config_guid = "fc5c5c04-55ea-4094-92fc-1d40f7f132b0";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport18_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport18__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport18__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE4";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE4";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport18__dataport_output_ready_xecore4__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE5";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE5";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport18__dataport_output_ready_xecore5__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE6";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE6";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport18__dataport_output_ready_xecore6__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE7";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE7";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport18__dataport_output_ready_xecore7__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport18__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport18__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 7);
}

static void
acmgt2_add_dataport19_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport19";
    metric_set->symbol_name = "Dataport19";
    metric_set->hw_config_guid = "66cc68bd-b460-42ec-b815-2531dc145a33";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport19_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport19__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport19__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE10";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE10";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport19__dataport_output_ready_xecore10__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE11";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE11";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport19__dataport_output_ready_xecore11__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE8";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE8";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport19__dataport_output_ready_xecore8__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE9";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE9";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport19__dataport_output_ready_xecore9__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport19__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport19__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 7);
}

static void
acmgt2_add_dataport20_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport20";
    metric_set->symbol_name = "Dataport20";
    metric_set->hw_config_guid = "c3f17ea7-bdba-4ce6-971e-9920ae779870";
    metric_set->counters = calloc(7, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport20_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport20__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport20__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE12";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE12";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport20__dataport_output_ready_xecore12__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE13";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE13";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport20__dataport_output_ready_xecore13__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE14";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE14";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport20__dataport_output_ready_xecore14__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT OUTPUT READY XECORE15";
        counter->symbol_name = "DATAPORT_OUTPUT_READY_XECORE15";
        counter->desc = "Percentage of time in which the Dataport has data to return to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_PERCENT;
        counter->read_float = acmgt2__dataport20__dataport_output_ready_xecore15__read;
        counter->max_float = percentage_max_callback_float;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport20__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport20__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 7);
}

static void
acmgt2_add_dataport21_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport21";
    metric_set->symbol_name = "Dataport21";
    metric_set->hw_config_guid = "fe3d6064-fb8d-4c1c-8375-65c1b2d23287";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport21_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport21__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport21__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE0";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE0";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport21__dataport_byte_read_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE1";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE1";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport21__dataport_byte_read_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport21__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport21__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport22_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport22";
    metric_set->symbol_name = "Dataport22";
    metric_set->hw_config_guid = "ca29a63a-9e93-4631-befe-cb0985365d3b";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport22_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport22__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport22__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE2";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE2";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport22__dataport_byte_read_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE3";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE3";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport22__dataport_byte_read_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport22__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport22__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport23";
    metric_set->symbol_name = "Dataport23";
    metric_set->hw_config_guid = "f194891f-8915-4c9d-978e-4ef91c44d5d1";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport23__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport23__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE4";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE4";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport23__dataport_byte_read_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE5";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE5";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport23__dataport_byte_read_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport23__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport23__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport24_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport24";
    metric_set->symbol_name = "Dataport24";
    metric_set->hw_config_guid = "62bac6fb-20ca-4fbf-b821-cd80ecdcb57b";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport24_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport24__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport24__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE6";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE6";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport24__dataport_byte_read_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE7";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE7";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport24__dataport_byte_read_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport24__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport24__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport25_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport25";
    metric_set->symbol_name = "Dataport25";
    metric_set->hw_config_guid = "7a2a2ce5-0e00-429b-9d96-ce5c030378e2";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport25_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport25__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport25__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE8";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE8";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport25__dataport_byte_read_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE9";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE9";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport25__dataport_byte_read_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport25__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport25__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport26_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport26";
    metric_set->symbol_name = "Dataport26";
    metric_set->hw_config_guid = "d6169119-c923-4d10-b16e-6439fa5e150d";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport26_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport26__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport26__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE10";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE10";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport26__dataport_byte_read_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE11";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE11";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport26__dataport_byte_read_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport26__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport26__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport27_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport27";
    metric_set->symbol_name = "Dataport27";
    metric_set->hw_config_guid = "703a8fb1-96b2-4c89-ad1b-f721efa0fade";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport27_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport27__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport27__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE12";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE12";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport27__dataport_byte_read_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE13";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE13";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport27__dataport_byte_read_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport27__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport27__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport28_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport28";
    metric_set->symbol_name = "Dataport28";
    metric_set->hw_config_guid = "7d3ea8fa-f0e2-4436-bfed-2cfd5d42e3fa";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport28_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport28__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport28__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE14";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE14";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport28__dataport_byte_read_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE READ XECORE15";
        counter->symbol_name = "DATAPORT_BYTE_READ_XECORE15";
        counter->desc = "Number of bytes read through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport28__dataport_byte_read_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport28__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport28__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport29_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport29";
    metric_set->symbol_name = "Dataport29";
    metric_set->hw_config_guid = "f42d9eaa-4a36-4b10-a96e-6794cbbdc43a";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport29_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport29__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport29__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE0";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE0";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE1";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE1";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE10";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE10";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE11";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE11";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE12";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE12";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE13";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE13";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE14";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE14";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE15";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE15";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE2";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE2";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE3";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE3";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE4";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE4";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE5";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE5";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE6";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE6";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE7";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE7";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE8";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE8";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT BYTE WRITE XECORE9";
        counter->symbol_name = "DATAPORT_BYTE_WRITE_XECORE9";
        counter->desc = "Number of bytes written through the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__dataport29__dataport_byte_write_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport29__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport29__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_dataport30_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport30";
    metric_set->symbol_name = "Dataport30";
    metric_set->hw_config_guid = "6805565e-e6aa-41a8-b486-4f1ca91c11c9";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport30_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport30__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport30__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport30__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport30__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE0";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE1";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE2";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE3";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE4";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE5";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE6";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE7";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport30__xve_dataport_register_request_count_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport31_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport31";
    metric_set->symbol_name = "Dataport31";
    metric_set->hw_config_guid = "c4d2235c-1d4b-44b7-b746-a11016520ffd";
    metric_set->counters = calloc(11, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport31_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport31__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport31__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport31__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport31__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE10";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE10";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE11";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE11";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE12";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE12";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE13";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE13";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE14";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE14";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE15";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE15";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE8";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE8";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER REQUEST COUNT XECORE9";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_REQUEST_COUNT_XECORE9";
        counter->desc = "Number of message payload transactions sent from XVEs to the Dataport";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport31__xve_dataport_register_request_count_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 11);
}

static void
acmgt2_add_dataport32_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport32";
    metric_set->symbol_name = "Dataport32";
    metric_set->hw_config_guid = "1f7d4994-5397-410c-98ed-5e1bc3d44ceb";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport32_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport32__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport32__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport32__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport32__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE0";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE0";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport32__xve_dataport_register_response_count_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE1";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE1";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport32__xve_dataport_register_response_count_xecore1__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport33_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport33";
    metric_set->symbol_name = "Dataport33";
    metric_set->hw_config_guid = "42d54580-601f-4dcb-9c91-c5bd37782f65";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport33_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport33__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport33__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport33__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport33__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE2";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE2";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport33__xve_dataport_register_response_count_xecore2__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE3";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE3";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport33__xve_dataport_register_response_count_xecore3__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport34_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport34";
    metric_set->symbol_name = "Dataport34";
    metric_set->hw_config_guid = "0ce98a1c-8516-4412-b1ce-b0eeaca989df";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport34_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport34__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport34__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport34__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport34__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE4";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE4";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport34__xve_dataport_register_response_count_xecore4__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE5";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE5";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport34__xve_dataport_register_response_count_xecore5__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport35_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport35";
    metric_set->symbol_name = "Dataport35";
    metric_set->hw_config_guid = "857f49c7-71b4-4fa0-86f0-55f817676cff";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport35_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport35__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport35__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport35__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport35__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE6";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE6";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport35__xve_dataport_register_response_count_xecore6__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE7";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE7";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport35__xve_dataport_register_response_count_xecore7__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport36_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport36";
    metric_set->symbol_name = "Dataport36";
    metric_set->hw_config_guid = "dde58e8e-e867-4144-9782-4464798e7c63";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport36_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport36__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport36__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport36__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport36__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE8";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE8";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport36__xve_dataport_register_response_count_xecore8__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE9";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE9";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport36__xve_dataport_register_response_count_xecore9__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport37_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport37";
    metric_set->symbol_name = "Dataport37";
    metric_set->hw_config_guid = "fd0e95c3-0a28-4911-80d7-dad9716739c3";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport37_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport37__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport37__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport37__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport37__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE10";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE10";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport37__xve_dataport_register_response_count_xecore10__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE11";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE11";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport37__xve_dataport_register_response_count_xecore11__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport38_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport38";
    metric_set->symbol_name = "Dataport38";
    metric_set->hw_config_guid = "ac3fa7ef-1963-4643-917f-9f9b6161ee62";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport38_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport38__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport38__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport38__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport38__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE12";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE12";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport38__xve_dataport_register_response_count_xecore12__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE13";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE13";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport38__xve_dataport_register_response_count_xecore13__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport39_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport39";
    metric_set->symbol_name = "Dataport39";
    metric_set->hw_config_guid = "ca4e1039-7322-4606-b3cc-7f33dcb93301";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport39_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport39__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport39__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport39__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport39__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE14";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE14";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport39__xve_dataport_register_response_count_xecore14__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "XVE DATAPORT REGISTER RESPONSE COUNT XECORE15";
        counter->symbol_name = "XVE_DATAPORT_REGISTER_RESPONSE_COUNT_XECORE15";
        counter->desc = "Number of return message payload transactions sent from the Dataport to XVEs";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_FLOAT;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_float = acmgt2__dataport39__xve_dataport_register_response_count_xecore15__read;
        counter->max_float = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_dataport40_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport40";
    metric_set->symbol_name = "Dataport40";
    metric_set->hw_config_guid = "3712af1f-03c7-48e3-b2a5-6d9ac64b3122";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport40_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport40__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport40__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE0";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE0";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE1";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE1";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE10";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE10";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE11";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE11";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE12";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE12";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE13";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE13";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE14";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE14";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE15";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE15";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE2";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE2";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE3";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE3";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE4";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE4";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE5";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE5";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE6";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE6";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE7";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE7";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE8";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE8";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE ACCESS XECORE9";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_ACCESS_XECORE9";
        counter->desc = "Number of cacheline requests from the Dataport to the texture cache not including uncached accesses";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport40__dataport_texture_cache_access_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport40__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport40__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_dataport41_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "Dataport41";
    metric_set->symbol_name = "Dataport41";
    metric_set->hw_config_guid = "3df5cfc4-865d-4314-a53a-379d76aac638";
    metric_set->counters = calloc(19, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_dataport41_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__dataport41__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__dataport41__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE0";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE0";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE1";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE1";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE10";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE10";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore10__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE11";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE11";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore11__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE12";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE12";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore12__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE13";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE13";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore13__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE14";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE14";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore14__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 5, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE15";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE15";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore15__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE2";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE2";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 2, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE3";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE3";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE4";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE4";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE5";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE5";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE6";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE6";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 3, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE7";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE7";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 0)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE8";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE8";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore8__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    if (intel_perf_devinfo_subslice_available(&perf->devinfo, 4, 1)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "DATAPORT TEXTURE CACHE HIT XECORE9";
        counter->symbol_name = "DATAPORT_TEXTURE_CACHE_HIT_XECORE9";
        counter->desc = "Number of cache requests from the Dataport to the texture cache that resulted in a cache hit";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__dataport41__dataport_texture_cache_hit_xecore9__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "Dataport");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__dataport41__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__dataport41__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 19);
}

static void
acmgt2_add_depth_pipe1_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe1";
    metric_set->symbol_name = "DepthPipe1";
    metric_set->hw_config_guid = "33168209-e5ab-4330-856c-0d4a1b95dce3";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe1_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe1__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe1__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE0";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE0";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe1__early_depth_stencil_test_fail_np_zpipe0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE0";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE0";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe1__early_depth_stencil_test_fail_p_zpipe0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe1__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe1__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe2_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe2";
    metric_set->symbol_name = "DepthPipe2";
    metric_set->hw_config_guid = "ada82722-0eaf-4903-96f0-3c8ed2227c7f";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe2_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe2__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe2__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE1";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE1";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe2__early_depth_stencil_test_fail_np_zpipe1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE1";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE1";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe2__early_depth_stencil_test_fail_p_zpipe1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe2__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe2__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe3_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe3";
    metric_set->symbol_name = "DepthPipe3";
    metric_set->hw_config_guid = "359bdac8-5929-4e54-a5e5-526b28a487ab";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe3_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe3__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe3__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE2";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE2";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe3__early_depth_stencil_test_fail_np_zpipe2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE2";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE2";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe3__early_depth_stencil_test_fail_p_zpipe2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe3__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe3__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe4_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe4";
    metric_set->symbol_name = "DepthPipe4";
    metric_set->hw_config_guid = "1b8e5aa0-be13-4c87-9ad0-f0d4f7d7f2a5";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe4_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe4__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe4__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE3";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE3";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe4__early_depth_stencil_test_fail_np_zpipe3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE3";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE3";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe4__early_depth_stencil_test_fail_p_zpipe3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe4__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe4__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe5_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe5";
    metric_set->symbol_name = "DepthPipe5";
    metric_set->hw_config_guid = "b192f113-23af-494e-82e7-b9a81810c75d";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe5_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe5__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe5__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE4";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE4";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe5__early_depth_stencil_test_fail_np_zpipe4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE4";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE4";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe5__early_depth_stencil_test_fail_p_zpipe4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe5__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe5__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe6_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe6";
    metric_set->symbol_name = "DepthPipe6";
    metric_set->hw_config_guid = "f617db06-51cc-447d-989c-0811dc7c7b38";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe6_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe6__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe6__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE5";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE5";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe6__early_depth_stencil_test_fail_np_zpipe5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE5";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE5";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe6__early_depth_stencil_test_fail_p_zpipe5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe6__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe6__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe7_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe7";
    metric_set->symbol_name = "DepthPipe7";
    metric_set->hw_config_guid = "bd2422a2-0a56-476d-a52d-b4aa15a5d842";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe7_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe7__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe7__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE6";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE6";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe7__early_depth_stencil_test_fail_np_zpipe6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE6";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE6";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe7__early_depth_stencil_test_fail_p_zpipe6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe7__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe7__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe8_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe8";
    metric_set->symbol_name = "DepthPipe8";
    metric_set->hw_config_guid = "7856d434-02e6-4a06-b585-e45e7616f1d5";
    metric_set->counters = calloc(5, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe8_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe8__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe8__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL NP ZPIPE7";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_NP_ZPIPE7";
        counter->desc = "Number of non-promoted 2x2 that failed Depth / Stencil before the Pixel Shader that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe8__early_depth_stencil_test_fail_np_zpipe7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "EARLY DEPTH STENCIL TEST FAIL P ZPIPE7";
        counter->symbol_name = "EARLY_DEPTH_STENCIL_TEST_FAIL_P_ZPIPE7";
        counter->desc = "Number of promoted 2x2 that failed Depth / Stencil that were previously ambiguous at HiZ";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_EVENTS;
        counter->read_uint64 = acmgt2__depth_pipe8__early_depth_stencil_test_fail_p_zpipe7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe8__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe8__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    assert(metric_set->n_counters <= 5);
}

static void
acmgt2_add_depth_pipe9_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe9";
    metric_set->symbol_name = "DepthPipe9";
    metric_set->hw_config_guid = "60b56817-8e14-488e-917d-29bffd9fefbb";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe9_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe9__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe9__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe9__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe9__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE0";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE0";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe9__hiz_depth_test_ambig_np_zpipe0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe10_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe10";
    metric_set->symbol_name = "DepthPipe10";
    metric_set->hw_config_guid = "8dff928f-699b-4f34-a297-cf46c9519662";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe10_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe10__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe10__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe10__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe10__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE1";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE1";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe10__hiz_depth_test_ambig_np_zpipe1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe11_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe11";
    metric_set->symbol_name = "DepthPipe11";
    metric_set->hw_config_guid = "fa8e2ae9-3507-4eed-9a02-b18c396a21b1";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe11_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe11__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe11__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe11__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe11__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE2";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE2";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe11__hiz_depth_test_ambig_np_zpipe2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe12_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe12";
    metric_set->symbol_name = "DepthPipe12";
    metric_set->hw_config_guid = "4736a783-c2f3-4f67-931f-eca0fdddf57f";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe12_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe12__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe12__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe12__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe12__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE3";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE3";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe12__hiz_depth_test_ambig_np_zpipe3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe13_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe13";
    metric_set->symbol_name = "DepthPipe13";
    metric_set->hw_config_guid = "a305b93f-dba5-4318-89ba-051192cbe1be";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe13_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe13__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe13__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe13__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe13__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE4";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE4";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe13__hiz_depth_test_ambig_np_zpipe4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe14_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe14";
    metric_set->symbol_name = "DepthPipe14";
    metric_set->hw_config_guid = "dcfc3d88-b9bd-424b-b3ca-854f2e2d4863";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe14_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe14__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe14__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe14__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe14__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE5";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE5";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe14__hiz_depth_test_ambig_np_zpipe5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe15_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe15";
    metric_set->symbol_name = "DepthPipe15";
    metric_set->hw_config_guid = "d706dc1e-e6c8-4fe0-b6ed-ea99cdc41673";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe15_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe15__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe15__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe15__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe15__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE6";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE6";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe15__hiz_depth_test_ambig_np_zpipe6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe16_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe16";
    metric_set->symbol_name = "DepthPipe16";
    metric_set->hw_config_guid = "de4874a3-6881-43a8-9243-6af156af44e5";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe16_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe16__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe16__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe16__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe16__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG NP ZPIPE7";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_NP_ZPIPE7";
        counter->desc = "Number of non-promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe16__hiz_depth_test_ambig_np_zpipe7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe17_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe17";
    metric_set->symbol_name = "DepthPipe17";
    metric_set->hw_config_guid = "c3d18c22-f267-4f8a-8b4e-b26abd1d1660";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe17_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe17__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe17__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe17__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe17__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE0";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE0";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe17__hiz_depth_test_ambig_p_zpipe0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe18_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe18";
    metric_set->symbol_name = "DepthPipe18";
    metric_set->hw_config_guid = "0fa14813-96d3-424b-8935-b70b4e24ea85";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe18_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe18__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe18__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe18__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe18__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE1";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE1";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe18__hiz_depth_test_ambig_p_zpipe1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe19_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe19";
    metric_set->symbol_name = "DepthPipe19";
    metric_set->hw_config_guid = "4e741dfb-12e7-4a31-8bed-1d587c0cafc5";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe19_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe19__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe19__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe19__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe19__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE2";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE2";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe19__hiz_depth_test_ambig_p_zpipe2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe20_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe20";
    metric_set->symbol_name = "DepthPipe20";
    metric_set->hw_config_guid = "66117e26-8834-4f72-b8f3-162bafb24232";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe20_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe20__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe20__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe20__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe20__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE3";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE3";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe20__hiz_depth_test_ambig_p_zpipe3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe21_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe21";
    metric_set->symbol_name = "DepthPipe21";
    metric_set->hw_config_guid = "4b9e649c-1392-4856-abe6-9e67bb06ac5e";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe21_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe21__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe21__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe21__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe21__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE4";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE4";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe21__hiz_depth_test_ambig_p_zpipe4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe22_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe22";
    metric_set->symbol_name = "DepthPipe22";
    metric_set->hw_config_guid = "ced7882f-f88d-431c-9dad-8f3016a64777";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe22_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe22__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe22__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe22__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe22__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE5";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE5";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe22__hiz_depth_test_ambig_p_zpipe5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe23_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe23";
    metric_set->symbol_name = "DepthPipe23";
    metric_set->hw_config_guid = "17ba725c-bcfb-444c-8725-fe9bc1a99c5b";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe23_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe23__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe23__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe23__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe23__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE6";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE6";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe23__hiz_depth_test_ambig_p_zpipe6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe24_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe24";
    metric_set->symbol_name = "DepthPipe24";
    metric_set->hw_config_guid = "efdfcd4f-8bc6-4251-b956-dfd351f8632e";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe24_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe24__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe24__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe24__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe24__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST AMBIG P ZPIPE7";
        counter->symbol_name = "HIZ_DEPTH_TEST_AMBIG_P_ZPIPE7";
        counter->desc = "Number of promoted 2x2 that are ambiguous by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe24__hiz_depth_test_ambig_p_zpipe7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe25_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe25";
    metric_set->symbol_name = "DepthPipe25";
    metric_set->hw_config_guid = "bad6c158-57f6-471f-a9e3-cad9e779d211";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe25_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe25__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe25__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe25__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe25__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE0";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE0";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe25__hiz_depth_test_fail_np_zpipe0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe26_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe26";
    metric_set->symbol_name = "DepthPipe26";
    metric_set->hw_config_guid = "4a7b11ce-2d9e-4905-99c4-ededa640b342";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe26_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe26__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe26__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe26__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe26__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE1";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE1";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe26__hiz_depth_test_fail_np_zpipe1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe27_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe27";
    metric_set->symbol_name = "DepthPipe27";
    metric_set->hw_config_guid = "8c0a8f9b-3e97-4b6d-adb1-fbecb395ec00";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe27_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe27__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe27__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe27__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe27__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE2";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE2";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe27__hiz_depth_test_fail_np_zpipe2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe28_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe28";
    metric_set->symbol_name = "DepthPipe28";
    metric_set->hw_config_guid = "b7471c18-89e6-4e6d-826c-5f0ca0791154";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe28_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe28__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe28__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe28__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe28__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE3";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE3";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe28__hiz_depth_test_fail_np_zpipe3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe29_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe29";
    metric_set->symbol_name = "DepthPipe29";
    metric_set->hw_config_guid = "36d7c5ca-28e3-41c8-8e2b-f67beba4b23f";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe29_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe29__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe29__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe29__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe29__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE4";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE4";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe29__hiz_depth_test_fail_np_zpipe4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe30_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe30";
    metric_set->symbol_name = "DepthPipe30";
    metric_set->hw_config_guid = "1bfbb150-1614-49a3-973b-7972bf7c9a91";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe30_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe30__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe30__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe30__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe30__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE5";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE5";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe30__hiz_depth_test_fail_np_zpipe5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe31_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe31";
    metric_set->symbol_name = "DepthPipe31";
    metric_set->hw_config_guid = "80d75f6a-6c5b-46c9-a3a7-1911e2cba86e";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe31_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe31__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe31__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe31__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe31__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE6";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE6";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe31__hiz_depth_test_fail_np_zpipe6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe32_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe32";
    metric_set->symbol_name = "DepthPipe32";
    metric_set->hw_config_guid = "3368bfa2-0680-4282-aaf1-9ec1a1713b82";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe32_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe32__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe32__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe32__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe32__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL NP ZPIPE7";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_NP_ZPIPE7";
        counter->desc = "Number of non-promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe32__hiz_depth_test_fail_np_zpipe7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe33_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe33";
    metric_set->symbol_name = "DepthPipe33";
    metric_set->hw_config_guid = "101b4d80-895b-4957-9f24-18456078793a";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe33_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe33__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe33__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe33__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe33__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE0";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE0";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe33__hiz_depth_test_fail_p_zpipe0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe34_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe34";
    metric_set->symbol_name = "DepthPipe34";
    metric_set->hw_config_guid = "342e501a-0038-412c-9e8a-a9ed02b7b9ef";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe34_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe34__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe34__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe34__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe34__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE1";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE1";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe34__hiz_depth_test_fail_p_zpipe1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe35_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe35";
    metric_set->symbol_name = "DepthPipe35";
    metric_set->hw_config_guid = "5c4a1a1c-3df5-43af-adb0-9cd78dd944f8";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe35_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe35__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe35__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe35__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe35__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE2";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE2";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe35__hiz_depth_test_fail_p_zpipe2__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe36_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe36";
    metric_set->symbol_name = "DepthPipe36";
    metric_set->hw_config_guid = "f19a51db-ff00-40c0-a13f-1c404e80652e";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe36_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe36__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe36__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe36__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe36__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 3)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE3";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE3";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe36__hiz_depth_test_fail_p_zpipe3__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe37_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe37";
    metric_set->symbol_name = "DepthPipe37";
    metric_set->hw_config_guid = "6f269feb-2743-4953-a8b4-7e4b000901bc";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe37_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe37__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe37__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe37__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe37__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE4";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE4";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe37__hiz_depth_test_fail_p_zpipe4__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe38_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe38";
    metric_set->symbol_name = "DepthPipe38";
    metric_set->hw_config_guid = "7b9d22cb-7c4e-4885-be22-833c310e7fd4";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe38_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe38__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe38__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe38__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe38__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 4)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE5";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE5";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe38__hiz_depth_test_fail_p_zpipe5__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe39_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe39";
    metric_set->symbol_name = "DepthPipe39";
    metric_set->hw_config_guid = "482c20b4-68c5-4656-8de2-039b2ca8a0f9";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe39_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe39__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe39__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe39__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe39__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE6";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE6";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe39__hiz_depth_test_fail_p_zpipe6__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe40_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe40";
    metric_set->symbol_name = "DepthPipe40";
    metric_set->hw_config_guid = "743ffcbc-c6d5-4b28-b58c-1d23d1ea8fff";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe40_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe40__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe40__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe40__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe40__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 5)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST FAIL P ZPIPE7";
        counter->symbol_name = "HIZ_DEPTH_TEST_FAIL_P_ZPIPE7";
        counter->desc = "Number of promoted 2x2 that failed the hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe40__hiz_depth_test_fail_p_zpipe7__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe41_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe41";
    metric_set->symbol_name = "DepthPipe41";
    metric_set->hw_config_guid = "f809a7a3-2248-480c-b851-1b23f3d6e7f2";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe41_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe41__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe41__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe41__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe41__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST PASS P ZPIPE0";
        counter->symbol_name = "HIZ_DEPTH_TEST_PASS_P_ZPIPE0";
        counter->desc = "Number of promoted 2x2 passed by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe41__hiz_depth_test_pass_p_zpipe0__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe42_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe42";
    metric_set->symbol_name = "DepthPipe42";
    metric_set->hw_config_guid = "effaccd8-6f1c-4a50-b39b-3a0f75eebf66";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe42_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe42__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe42__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe42__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    counter->read_uint64 = acmgt2__depth_pipe42__gpu_time__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    if (intel_perf_devinfo_slice_available(&perf->devinfo, 2)) {
        counter = &metric_set->counters[metric_set->n_counters++];
        counter->metric_set = metric_set;
        counter->name = "HIZ DEPTH TEST PASS P ZPIPE1";
        counter->symbol_name = "HIZ_DEPTH_TEST_PASS_P_ZPIPE1";
        counter->desc = "Number of promoted 2x2 passed by hierarchical depth test";
        counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_THROUGHPUT;
        counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
        counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_BYTES;
        counter->read_uint64 = acmgt2__depth_pipe42__hiz_depth_test_pass_p_zpipe1__read;
        counter->max_uint64 = NULL /* undefined */;
        intel_perf_add_logical_counter(perf, counter, "DepthPipe");
    }

    assert(metric_set->n_counters <= 4);
}

static void
acmgt2_add_depth_pipe43_metric_set(struct intel_perf *perf)
{
    struct intel_perf_metric_set *metric_set;
    struct intel_perf_logical_counter *counter;

    metric_set = calloc(1, sizeof(*metric_set));
    metric_set->name = "DepthPipe43";
    metric_set->symbol_name = "DepthPipe43";
    metric_set->hw_config_guid = "39b392ed-3513-4c3f-9b22-bde5a9ee725c";
    metric_set->counters = calloc(4, sizeof(struct intel_perf_logical_counter));
    metric_set->n_counters = 0;
    metric_set->perf_oa_metrics_set = 0; // determined at runtime
    metric_set->perf_oa_format = I915_OA_FORMAT_A24u40_A14u32_B8_C8;

    metric_set->perf_raw_size = 256;
    metric_set->gpu_time_offset = 0;
    metric_set->gpu_clock_offset = 1;
    metric_set->a_offset = 2;
    metric_set->b_offset = metric_set->a_offset + 38;
    metric_set->c_offset = metric_set->b_offset + 8;
    metric_set->perfcnt_offset = metric_set->c_offset + 8;

    acmgt2_depth_pipe43_add_registers(perf, metric_set);
    intel_perf_add_metric_set(perf, metric_set);


    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "AVG GPU Core Frequency";
    counter->symbol_name = "AvgGpuCoreFrequency";
    counter->desc = "Average GPU Core Frequency in the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_HZ;
    counter->read_uint64 = acmgt2__depth_pipe43__avg_gpu_core_frequency__read;
    counter->max_uint64 = acmgt2__depth_pipe43__avg_gpu_core_frequency__max;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Core Clocks";
    counter->symbol_name = "GpuCoreClocks";
    counter->desc = "The total number of GPU core clocks elapsed during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_EVENT;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_CYCLES;
    counter->read_uint64 = acmgt2__depth_pipe43__gpu_core_clocks__read;
    counter->max_uint64 = NULL /* undefined */;
    intel_perf_add_logical_counter(perf, counter, "GPU");

    counter = &metric_set->counters[metric_set->n_counters++];
    counter->metric_set = metric_set;
    counter->name = "GPU Time Elapsed";
    counter->symbol_name = "GpuTime";
    counter->desc = "Time elapsed on the GPU during the measurement.";
    counter->type = INTEL_PERF_LOGICAL_COUNTER_TYPE_RAW;
    counter->storage = INTEL_PERF_LOGICAL_COUNTER_STORAGE_UINT64;
    counter->unit = INTEL_PERF_LOGICAL_COUNTER_UNIT_NS;
    