#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 52
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 42
#define ALIAS_COUNT 0
#define TOKEN_COUNT 19
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 2
#define MAX_ALIAS_SEQUENCE_LENGTH 5
#define PRODUCTION_ID_COUNT 5

enum {
  sym__identifier = 1,
  sym_comment = 2,
  sym_one_or_more = 3,
  sym_zero_or_one = 4,
  sym_zero_or_more = 5,
  sym_capture = 6,
  anon_sym_LBRACK = 7,
  anon_sym_RBRACK = 8,
  anon_sym_DQUOTE = 9,
  aux_sym__string_token1 = 10,
  sym_escape_sequence = 11,
  anon_sym_LPAREN = 12,
  anon_sym_RPAREN = 13,
  sym_anchor = 14,
  anon_sym_COLON = 15,
  anon_sym_BANG = 16,
  sym_predicate_name = 17,
  anon_sym__ = 18,
  sym_query = 19,
  sym_pattern = 20,
  sym__pattern = 21,
  sym__quantifier = 22,
  sym_alternation = 23,
  sym_choice = 24,
  sym_anonymous_leaf = 25,
  sym__string = 26,
  sym_group = 27,
  sym_named_node = 28,
  sym_node_name = 29,
  sym_variable = 30,
  sym_child = 31,
  sym_field_name = 32,
  sym_negated_child = 33,
  sym_predicate = 34,
  sym_string = 35,
  sym_wildcard_node = 36,
  aux_sym_query_repeat1 = 37,
  aux_sym_alternation_repeat1 = 38,
  aux_sym__string_repeat1 = 39,
  aux_sym_named_node_repeat1 = 40,
  aux_sym_predicate_repeat1 = 41,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__identifier] = "_identifier",
  [sym_comment] = "comment",
  [sym_one_or_more] = "one_or_more",
  [sym_zero_or_one] = "zero_or_one",
  [sym_zero_or_more] = "zero_or_more",
  [sym_capture] = "capture",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__string_token1] = "_string_token1",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [sym_anchor] = "anchor",
  [anon_sym_COLON] = ":",
  [anon_sym_BANG] = "!",
  [sym_predicate_name] = "predicate_name",
  [anon_sym__] = "_",
  [sym_query] = "query",
  [sym_pattern] = "pattern",
  [sym__pattern] = "_pattern",
  [sym__quantifier] = "_quantifier",
  [sym_alternation] = "alternation",
  [sym_choice] = "choice",
  [sym_anonymous_leaf] = "anonymous_leaf",
  [sym__string] = "_string",
  [sym_group] = "group",
  [sym_named_node] = "named_node",
  [sym_node_name] = "node_name",
  [sym_variable] = "variable",
  [sym_child] = "child",
  [sym_field_name] = "field_name",
  [sym_negated_child] = "negated_child",
  [sym_predicate] = "predicate",
  [sym_string] = "string",
  [sym_wildcard_node] = "wildcard_node",
  [aux_sym_query_repeat1] = "query_repeat1",
  [aux_sym_alternation_repeat1] = "alternation_repeat1",
  [aux_sym__string_repeat1] = "_string_repeat1",
  [aux_sym_named_node_repeat1] = "named_node_repeat1",
  [aux_sym_predicate_repeat1] = "predicate_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__identifier] = sym__identifier,
  [sym_comment] = sym_comment,
  [sym_one_or_more] = sym_one_or_more,
  [sym_zero_or_one] = sym_zero_or_one,
  [sym_zero_or_more] = sym_zero_or_more,
  [sym_capture] = sym_capture,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__string_token1] = aux_sym__string_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [sym_anchor] = sym_anchor,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_BANG] = anon_sym_BANG,
  [sym_predicate_name] = sym_predicate_name,
  [anon_sym__] = anon_sym__,
  [sym_query] = sym_query,
  [sym_pattern] = sym_pattern,
  [sym__pattern] = sym__pattern,
  [sym__quantifier] = sym__quantifier,
  [sym_alternation] = sym_alternation,
  [sym_choice] = sym_choice,
  [sym_anonymous_leaf] = sym_anonymous_leaf,
  [sym__string] = sym__string,
  [sym_group] = sym_group,
  [sym_named_node] = sym_named_node,
  [sym_node_name] = sym_node_name,
  [sym_variable] = sym_variable,
  [sym_child] = sym_child,
  [sym_field_name] = sym_field_name,
  [sym_negated_child] = sym_negated_child,
  [sym_predicate] = sym_predicate,
  [sym_string] = sym_string,
  [sym_wildcard_node] = sym_wildcard_node,
  [aux_sym_query_repeat1] = aux_sym_query_repeat1,
  [aux_sym_alternation_repeat1] = aux_sym_alternation_repeat1,
  [aux_sym__string_repeat1] = aux_sym__string_repeat1,
  [aux_sym_named_node_repeat1] = aux_sym_named_node_repeat1,
  [aux_sym_predicate_repeat1] = aux_sym_predicate_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_one_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_zero_or_one] = {
    .visible = true,
    .named = true,
  },
  [sym_zero_or_more] = {
    .visible = true,
    .named = true,
  },
  [sym_capture] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__string_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [sym_anchor] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [sym_predicate_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [sym_query] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym__quantifier] = {
    .visible = false,
    .named = true,
  },
  [sym_alternation] = {
    .visible = true,
    .named = true,
  },
  [sym_choice] = {
    .visible = true,
    .named = true,
  },
  [sym_anonymous_leaf] = {
    .visible = true,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_group] = {
    .visible = true,
    .named = true,
  },
  [sym_named_node] = {
    .visible = true,
    .named = true,
  },
  [sym_node_name] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_child] = {
    .visible = true,
    .named = true,
  },
  [sym_field_name] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_child] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_wildcard_node] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_query_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_alternation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_node_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_predicate_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_pattern = 1,
  field_quantifier = 2,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_pattern] = "pattern",
  [field_quantifier] = "quantifier",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 2},
  [4] = {.index = 5, .length = 2},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_pattern, 0, .inherited = true},
    {field_quantifier, 0, .inherited = true},
  [2] =
    {field_pattern, 0},
  [3] =
    {field_pattern, 0},
    {field_quantifier, 1},
  [5] =
    {field_pattern, 2, .inherited = true},
    {field_quantifier, 2, .inherited = true},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(7);
      if (lookahead == '!') ADVANCE(24);
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == '#') ADVANCE(4);
      if (lookahead == '(') ADVANCE(20);
      if (lookahead == ')') ADVANCE(21);
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == ';') ADVANCE(8);
      if (lookahead == '?') ADVANCE(10);
      if (lookahead == '@') ADVANCE(5);
      if (lookahead == '[') ADVANCE(13);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == ']') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(19);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(2)
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '\\') ADVANCE(3);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(16);
      if (lookahead != 0) ADVANCE(17);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == ';') ADVANCE(8);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(2)
      END_STATE();
    case 3:
      if (lookahead == '"' ||
          lookahead == '0' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 'r' ||
          lookahead == 't') ADVANCE(18);
      END_STATE();
    case 4:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(12);
      END_STATE();
    case 6:
      if (eof) ADVANCE(7);
      if (lookahead == '!') ADVANCE(24);
      if (lookahead == '"') ADVANCE(15);
      if (lookahead == '#') ADVANCE(4);
      if (lookahead == '(') ADVANCE(20);
      if (lookahead == ')') ADVANCE(21);
      if (lookahead == '*') ADVANCE(11);
      if (lookahead == '+') ADVANCE(9);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == ':') ADVANCE(23);
      if (lookahead == ';') ADVANCE(8);
      if (lookahead == '?') ADVANCE(10);
      if (lookahead == '@') ADVANCE(5);
      if (lookahead == '[') ADVANCE(13);
      if (lookahead == ']') ADVANCE(14);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(19);
      END_STATE();
    case 7:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 8:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(8);
      END_STATE();
    case 9:
      ACCEPT_TOKEN(sym_one_or_more);
      END_STATE();
    case 10:
      ACCEPT_TOKEN(sym_zero_or_one);
      END_STATE();
    case 11:
      ACCEPT_TOKEN(sym_zero_or_more);
      END_STATE();
    case 12:
      ACCEPT_TOKEN(sym_capture);
      if (lookahead == '!' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(12);
      END_STATE();
    case 13:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead == ';') ADVANCE(17);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(16);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(17);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(aux_sym__string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(17);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '!' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(19);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(sym_anchor);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(sym_predicate_name);
      if (lookahead == '!' ||
          lookahead == '-' ||
          lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '?' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(25);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 0},
  [3] = {.lex_state = 0},
  [4] = {.lex_state = 0},
  [5] = {.lex_state = 0},
  [6] = {.lex_state = 0},
  [7] = {.lex_state = 0},
  [8] = {.lex_state = 0},
  [9] = {.lex_state = 0},
  [10] = {.lex_state = 0},
  [11] = {.lex_state = 0},
  [12] = {.lex_state = 0},
  [13] = {.lex_state = 0},
  [14] = {.lex_state = 0},
  [15] = {.lex_state = 0},
  [16] = {.lex_state = 0},
  [17] = {.lex_state = 0},
  [18] = {.lex_state = 0},
  [19] = {.lex_state = 0},
  [20] = {.lex_state = 0},
  [21] = {.lex_state = 0},
  [22] = {.lex_state = 0},
  [23] = {.lex_state = 0},
  [24] = {.lex_state = 0},
  [25] = {.lex_state = 0},
  [26] = {.lex_state = 0},
  [27] = {.lex_state = 0},
  [28] = {.lex_state = 0},
  [29] = {.lex_state = 0},
  [30] = {.lex_state = 0},
  [31] = {.lex_state = 0},
  [32] = {.lex_state = 0},
  [33] = {.lex_state = 0},
  [34] = {.lex_state = 0},
  [35] = {.lex_state = 0},
  [36] = {.lex_state = 0},
  [37] = {.lex_state = 0},
  [38] = {.lex_state = 0},
  [39] = {.lex_state = 0},
  [40] = {.lex_state = 0},
  [41] = {.lex_state = 0},
  [42] = {.lex_state = 0},
  [43] = {.lex_state = 0},
  [44] = {.lex_state = 1},
  [45] = {.lex_state = 0},
  [46] = {.lex_state = 0},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 0},
  [50] = {.lex_state = 0},
  [51] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_one_or_more] = ACTIONS(1),
    [sym_zero_or_one] = ACTIONS(1),
    [sym_zero_or_more] = ACTIONS(1),
    [sym_capture] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [sym_anchor] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_predicate_name] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
  },
  [1] = {
    [sym_query] = STATE(51),
    [sym_pattern] = STATE(12),
    [sym__pattern] = STATE(42),
    [sym_alternation] = STATE(11),
    [sym_anonymous_leaf] = STATE(11),
    [sym__string] = STATE(21),
    [sym_group] = STATE(11),
    [sym_named_node] = STATE(11),
    [sym_predicate] = STATE(12),
    [sym_wildcard_node] = STATE(11),
    [aux_sym_query_repeat1] = STATE(12),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_LBRACK] = ACTIONS(7),
    [anon_sym_DQUOTE] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym__] = ACTIONS(13),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      sym__identifier,
    ACTIONS(18), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_DQUOTE,
    ACTIONS(24), 1,
      anon_sym_LPAREN,
    ACTIONS(27), 1,
      anon_sym_RPAREN,
    ACTIONS(29), 1,
      sym_anchor,
    ACTIONS(32), 1,
      anon_sym_BANG,
    ACTIONS(35), 1,
      anon_sym__,
    STATE(21), 1,
      sym__string,
    STATE(34), 1,
      sym__pattern,
    STATE(50), 1,
      sym_field_name,
    STATE(2), 4,
      sym_child,
      sym_negated_child,
      sym_predicate,
      aux_sym_named_node_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [50] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(38), 1,
      sym__identifier,
    ACTIONS(40), 1,
      anon_sym_RPAREN,
    ACTIONS(42), 1,
      sym_anchor,
    ACTIONS(44), 1,
      anon_sym_BANG,
    ACTIONS(46), 1,
      anon_sym__,
    STATE(21), 1,
      sym__string,
    STATE(34), 1,
      sym__pattern,
    STATE(50), 1,
      sym_field_name,
    STATE(2), 4,
      sym_child,
      sym_negated_child,
      sym_predicate,
      aux_sym_named_node_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [100] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(38), 1,
      sym__identifier,
    ACTIONS(44), 1,
      anon_sym_BANG,
    ACTIONS(46), 1,
      anon_sym__,
    ACTIONS(48), 1,
      anon_sym_RPAREN,
    ACTIONS(50), 1,
      sym_anchor,
    STATE(21), 1,
      sym__string,
    STATE(34), 1,
      sym__pattern,
    STATE(50), 1,
      sym_field_name,
    STATE(3), 4,
      sym_child,
      sym_negated_child,
      sym_predicate,
      aux_sym_named_node_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [150] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(38), 1,
      sym__identifier,
    ACTIONS(44), 1,
      anon_sym_BANG,
    ACTIONS(46), 1,
      anon_sym__,
    ACTIONS(52), 1,
      anon_sym_RPAREN,
    STATE(21), 1,
      sym__string,
    STATE(34), 1,
      sym__pattern,
    STATE(50), 1,
      sym_field_name,
    STATE(37), 3,
      sym_child,
      sym_negated_child,
      sym_predicate,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [196] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(56), 1,
      sym_predicate_name,
    ACTIONS(58), 1,
      anon_sym__,
    STATE(4), 1,
      sym_node_name,
    STATE(21), 1,
      sym__string,
    STATE(42), 1,
      sym__pattern,
    STATE(10), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [239] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(38), 1,
      sym__identifier,
    ACTIONS(44), 1,
      anon_sym_BANG,
    ACTIONS(46), 1,
      anon_sym__,
    STATE(21), 1,
      sym__string,
    STATE(34), 1,
      sym__pattern,
    STATE(50), 1,
      sym_field_name,
    STATE(37), 3,
      sym_child,
      sym_negated_child,
      sym_predicate,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [282] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(54), 1,
      sym__identifier,
    ACTIONS(58), 1,
      anon_sym__,
    STATE(4), 1,
      sym_node_name,
    STATE(21), 1,
      sym__string,
    STATE(42), 1,
      sym__pattern,
    STATE(10), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [322] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(62), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_DQUOTE,
    ACTIONS(68), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym__,
    STATE(21), 1,
      sym__string,
    STATE(42), 1,
      sym__pattern,
    ACTIONS(60), 2,
      ts_builtin_sym_end,
      anon_sym_RPAREN,
    STATE(9), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [360] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(74), 1,
      anon_sym_RPAREN,
    STATE(21), 1,
      sym__string,
    STATE(42), 1,
      sym__pattern,
    STATE(9), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [397] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(82), 1,
      sym_capture,
    STATE(27), 1,
      sym__quantifier,
    ACTIONS(78), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(80), 3,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
    ACTIONS(76), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [426] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(84), 1,
      ts_builtin_sym_end,
    STATE(21), 1,
      sym__string,
    STATE(42), 1,
      sym__pattern,
    STATE(9), 3,
      sym_pattern,
      sym_predicate,
      aux_sym_query_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [463] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(86), 1,
      anon_sym_RBRACK,
    STATE(21), 1,
      sym__string,
    STATE(43), 1,
      sym__pattern,
    STATE(14), 3,
      sym_choice,
      sym_predicate,
      aux_sym_alternation_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [500] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(88), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_RBRACK,
    ACTIONS(93), 1,
      anon_sym_DQUOTE,
    ACTIONS(96), 1,
      anon_sym_LPAREN,
    ACTIONS(99), 1,
      anon_sym__,
    STATE(21), 1,
      sym__string,
    STATE(43), 1,
      sym__pattern,
    STATE(14), 3,
      sym_choice,
      sym_predicate,
      aux_sym_alternation_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(104), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(102), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [559] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym__,
    STATE(21), 1,
      sym__string,
    STATE(43), 1,
      sym__pattern,
    STATE(13), 3,
      sym_choice,
      sym_predicate,
      aux_sym_alternation_repeat1,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(108), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(106), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(112), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(110), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [637] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(116), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(114), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(118), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [681] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(122), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(128), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(126), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(132), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(130), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(136), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(134), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(140), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(138), 12,
      ts_builtin_sym_end,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [791] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_LBRACK,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(13), 1,
      anon_sym__,
    ACTIONS(142), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      sym__string,
    STATE(41), 1,
      sym__pattern,
    STATE(11), 5,
      sym_alternation,
      sym_anonymous_leaf,
      sym_group,
      sym_named_node,
      sym_wildcard_node,
  [820] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 1,
      sym_capture,
    ACTIONS(146), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(144), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(150), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(154), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(160), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(158), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(164), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(162), 8,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(166), 1,
      anon_sym_RPAREN,
    ACTIONS(114), 8,
      sym_one_or_more,
      sym_zero_or_one,
      sym_zero_or_more,
      sym_capture,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym__,
  [930] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(168), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(170), 7,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_COLON,
      anon_sym_BANG,
  [947] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(172), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(174), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [963] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(176), 1,
      sym__identifier,
    ACTIONS(178), 1,
      sym_capture,
    ACTIONS(180), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__string,
    STATE(36), 3,
      sym_variable,
      sym_string,
      aux_sym_predicate_repeat1,
  [987] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(182), 1,
      sym__identifier,
    ACTIONS(185), 1,
      sym_capture,
    ACTIONS(188), 1,
      anon_sym_DQUOTE,
    ACTIONS(191), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__string,
    STATE(36), 3,
      sym_variable,
      sym_string,
      aux_sym_predicate_repeat1,
  [1011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(193), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(27), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [1027] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(195), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(197), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [1043] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_DQUOTE,
    ACTIONS(176), 1,
      sym__identifier,
    ACTIONS(199), 1,
      sym_capture,
    ACTIONS(201), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      sym__string,
    STATE(35), 3,
      sym_variable,
      sym_string,
      aux_sym_predicate_repeat1,
  [1067] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(203), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(205), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [1083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(207), 2,
      sym__identifier,
      anon_sym__,
    ACTIONS(209), 6,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_anchor,
      anon_sym_BANG,
  [1099] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(211), 6,
      ts_builtin_sym_end,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym__,
  [1111] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(213), 5,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym__,
  [1122] = 4,
    ACTIONS(215), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_DQUOTE,
    STATE(44), 1,
      aux_sym__string_repeat1,
    ACTIONS(219), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [1136] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(222), 4,
      sym_capture,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1146] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(224), 4,
      sym_capture,
      anon_sym_DQUOTE,
      sym__identifier,
      anon_sym_RPAREN,
  [1156] = 4,
    ACTIONS(215), 1,
      sym_comment,
    ACTIONS(226), 1,
      anon_sym_DQUOTE,
    STATE(48), 1,
      aux_sym__string_repeat1,
    ACTIONS(228), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [1170] = 4,
    ACTIONS(215), 1,
      sym_comment,
    ACTIONS(230), 1,
      anon_sym_DQUOTE,
    STATE(44), 1,
      aux_sym__string_repeat1,
    ACTIONS(232), 2,
      aux_sym__string_token1,
      sym_escape_sequence,
  [1184] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(234), 1,
      sym__identifier,
    STATE(38), 1,
      sym_field_name,
  [1194] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(236), 1,
      anon_sym_COLON,
  [1201] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(238), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 50,
  [SMALL_STATE(4)] = 100,
  [SMALL_STATE(5)] = 150,
  [SMALL_STATE(6)] = 196,
  [SMALL_STATE(7)] = 239,
  [SMALL_STATE(8)] = 282,
  [SMALL_STATE(9)] = 322,
  [SMALL_STATE(10)] = 360,
  [SMALL_STATE(11)] = 397,
  [SMALL_STATE(12)] = 426,
  [SMALL_STATE(13)] = 463,
  [SMALL_STATE(14)] = 500,
  [SMALL_STATE(15)] = 537,
  [SMALL_STATE(16)] = 559,
  [SMALL_STATE(17)] = 593,
  [SMALL_STATE(18)] = 615,
  [SMALL_STATE(19)] = 637,
  [SMALL_STATE(20)] = 659,
  [SMALL_STATE(21)] = 681,
  [SMALL_STATE(22)] = 703,
  [SMALL_STATE(23)] = 725,
  [SMALL_STATE(24)] = 747,
  [SMALL_STATE(25)] = 769,
  [SMALL_STATE(26)] = 791,
  [SMALL_STATE(27)] = 820,
  [SMALL_STATE(28)] = 841,
  [SMALL_STATE(29)] = 859,
  [SMALL_STATE(30)] = 877,
  [SMALL_STATE(31)] = 895,
  [SMALL_STATE(32)] = 913,
  [SMALL_STATE(33)] = 930,
  [SMALL_STATE(34)] = 947,
  [SMALL_STATE(35)] = 963,
  [SMALL_STATE(36)] = 987,
  [SMALL_STATE(37)] = 1011,
  [SMALL_STATE(38)] = 1027,
  [SMALL_STATE(39)] = 1043,
  [SMALL_STATE(40)] = 1067,
  [SMALL_STATE(41)] = 1083,
  [SMALL_STATE(42)] = 1099,
  [SMALL_STATE(43)] = 1111,
  [SMALL_STATE(44)] = 1122,
  [SMALL_STATE(45)] = 1136,
  [SMALL_STATE(46)] = 1146,
  [SMALL_STATE(47)] = 1156,
  [SMALL_STATE(48)] = 1170,
  [SMALL_STATE(49)] = 1184,
  [SMALL_STATE(50)] = 1194,
  [SMALL_STATE(51)] = 1201,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [15] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(33),
  [18] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(16),
  [21] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(47),
  [24] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(6),
  [27] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2),
  [29] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(7),
  [32] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(49),
  [35] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2), SHIFT_REPEAT(19),
  [38] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [40] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [42] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [44] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [46] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [48] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [50] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [52] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [54] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [56] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [58] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [60] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2),
  [62] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(16),
  [65] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(47),
  [68] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(6),
  [71] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_query_repeat1, 2), SHIFT_REPEAT(19),
  [74] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [76] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 1, .production_id = 2),
  [78] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 1, .production_id = 2),
  [80] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [82] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [84] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_query, 1),
  [86] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [88] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(16),
  [91] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2),
  [93] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(47),
  [96] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(6),
  [99] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_alternation_repeat1, 2), SHIFT_REPEAT(19),
  [102] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_group, 3),
  [104] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_group, 3),
  [106] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string, 2),
  [108] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string, 2),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 5),
  [112] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 5),
  [114] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_wildcard_node, 1),
  [116] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_wildcard_node, 1),
  [118] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 4),
  [120] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 4),
  [122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_anonymous_leaf, 1),
  [124] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_anonymous_leaf, 1),
  [126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_node, 3),
  [128] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_node, 3),
  [130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_wildcard_node, 3),
  [132] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_wildcard_node, 3),
  [134] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_alternation, 3),
  [136] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_alternation, 3),
  [138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__string, 3),
  [140] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__string, 3),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 2, .production_id = 3),
  [146] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 2, .production_id = 3),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 2, .production_id = 2),
  [152] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 2, .production_id = 2),
  [154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 3),
  [156] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 3),
  [158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate, 4),
  [160] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate, 4),
  [162] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__pattern, 3, .production_id = 3),
  [164] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__pattern, 3, .production_id = 3),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [168] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field_name, 1),
  [170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_name, 1),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_child, 1, .production_id = 1),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_child, 1, .production_id = 1),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [182] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_predicate_repeat1, 2), SHIFT_REPEAT(45),
  [185] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_predicate_repeat1, 2), SHIFT_REPEAT(36),
  [188] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_predicate_repeat1, 2), SHIFT_REPEAT(47),
  [191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_predicate_repeat1, 2),
  [193] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_named_node_repeat1, 2),
  [195] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_negated_child, 2),
  [197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_negated_child, 2),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [203] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_node_name, 1),
  [205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_node_name, 1),
  [207] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_child, 3, .production_id = 4),
  [209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_child, 3, .production_id = 4),
  [211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern, 1, .production_id = 1),
  [213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_choice, 1, .production_id = 1),
  [215] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [217] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__string_repeat1, 2),
  [219] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__string_repeat1, 2), SHIFT_REPEAT(44),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [224] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1),
  [226] = {.entry = {.count = 1, .reusable = false}}, SHIFT(17),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [236] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [238] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_tsq(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym__identifier,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
