#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 566
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 99
#define ALIAS_COUNT 0
#define TOKEN_COUNT 53
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 3
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 24

enum {
  sym_identifier = 1,
  sym_comment = 2,
  sym_number = 3,
  sym_string_string = 4,
  sym_code_string = 5,
  sym_var = 6,
  anon_sym_include = 7,
  sym_preprocessor = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_class = 11,
  anon_sym_COLON = 12,
  anon_sym_LT = 13,
  anon_sym_COMMA = 14,
  anon_sym_GT = 15,
  anon_sym_EQ = 16,
  anon_sym_SEMI = 17,
  anon_sym_field = 18,
  anon_sym_code = 19,
  anon_sym_let = 20,
  anon_sym_defvar = 21,
  anon_sym_def = 22,
  anon_sym_in = 23,
  anon_sym_multiclass = 24,
  anon_sym_defm = 25,
  anon_sym_defset = 26,
  anon_sym_foreach = 27,
  anon_sym_if = 28,
  anon_sym_then = 29,
  anon_sym_else = 30,
  anon_sym_assert = 31,
  anon_sym_bit = 32,
  anon_sym_int = 33,
  anon_sym_string = 34,
  anon_sym_dag = 35,
  anon_sym_bits = 36,
  anon_sym_list = 37,
  anon_sym_POUND = 38,
  anon_sym_true = 39,
  anon_sym_false = 40,
  anon_sym_QMARK = 41,
  anon_sym_LBRACK = 42,
  anon_sym_RBRACK = 43,
  anon_sym_LPAREN = 44,
  anon_sym_RPAREN = 45,
  anon_sym_BANGcond = 46,
  anon_sym_DOT = 47,
  anon_sym_DOT_DOT_DOT = 48,
  anon_sym_DASH = 49,
  anon_sym_BANG = 50,
  aux_sym_operator_keyword_token1 = 51,
  sym_multiline_comment = 52,
  sym_file = 53,
  sym_include = 54,
  sym_statement = 55,
  sym_statement_or_block = 56,
  sym_class = 57,
  sym_parent_class_list = 58,
  sym_template_args = 59,
  sym_template_arg = 60,
  sym_record_body = 61,
  sym_body_item = 62,
  sym_instruction = 63,
  sym_let_inst = 64,
  sym_def_var = 65,
  sym_def = 66,
  sym_let = 67,
  sym_let_item = 68,
  sym_multiclass = 69,
  sym_multiclass_body = 70,
  sym_multiclass_statement = 71,
  sym_defm = 72,
  sym_defset = 73,
  sym_defvar = 74,
  sym_foreach = 75,
  sym_if = 76,
  sym_assert = 77,
  sym_type = 78,
  sym_value = 79,
  sym__value_concat = 80,
  sym__simple_value = 81,
  aux_sym__repeated_string = 82,
  sym_operator = 83,
  sym_dag_arg = 84,
  sym_value_suffix = 85,
  sym_operator_keyword = 86,
  aux_sym_file_repeat1 = 87,
  aux_sym_parent_class_list_repeat1 = 88,
  aux_sym_parent_class_list_repeat2 = 89,
  aux_sym_template_args_repeat1 = 90,
  aux_sym_record_body_repeat1 = 91,
  aux_sym_let_inst_repeat1 = 92,
  aux_sym_let_repeat1 = 93,
  aux_sym_multiclass_body_repeat1 = 94,
  aux_sym_value_repeat1 = 95,
  aux_sym__value_concat_repeat1 = 96,
  aux_sym__simple_value_repeat1 = 97,
  aux_sym_operator_repeat1 = 98,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [sym_comment] = "comment",
  [sym_number] = "number",
  [sym_string_string] = "string_string",
  [sym_code_string] = "code_string",
  [sym_var] = "var",
  [anon_sym_include] = "include",
  [sym_preprocessor] = "preprocessor",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_class] = "class",
  [anon_sym_COLON] = ":",
  [anon_sym_LT] = "<",
  [anon_sym_COMMA] = ",",
  [anon_sym_GT] = ">",
  [anon_sym_EQ] = "=",
  [anon_sym_SEMI] = ";",
  [anon_sym_field] = "field",
  [anon_sym_code] = "code",
  [anon_sym_let] = "let",
  [anon_sym_defvar] = "defvar",
  [anon_sym_def] = "def",
  [anon_sym_in] = "in",
  [anon_sym_multiclass] = "multiclass",
  [anon_sym_defm] = "defm",
  [anon_sym_defset] = "defset",
  [anon_sym_foreach] = "foreach",
  [anon_sym_if] = "if",
  [anon_sym_then] = "then",
  [anon_sym_else] = "else",
  [anon_sym_assert] = "assert",
  [anon_sym_bit] = "bit",
  [anon_sym_int] = "int",
  [anon_sym_string] = "string",
  [anon_sym_dag] = "dag",
  [anon_sym_bits] = "bits",
  [anon_sym_list] = "list",
  [anon_sym_POUND] = "#",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_QMARK] = "\?",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_BANGcond] = "!cond",
  [anon_sym_DOT] = ".",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [aux_sym_operator_keyword_token1] = "operator_keyword_token1",
  [sym_multiline_comment] = "multiline_comment",
  [sym_file] = "file",
  [sym_include] = "include",
  [sym_statement] = "statement",
  [sym_statement_or_block] = "statement_or_block",
  [sym_class] = "class",
  [sym_parent_class_list] = "parent_class_list",
  [sym_template_args] = "template_args",
  [sym_template_arg] = "template_arg",
  [sym_record_body] = "record_body",
  [sym_body_item] = "body_item",
  [sym_instruction] = "instruction",
  [sym_let_inst] = "let_inst",
  [sym_def_var] = "def_var",
  [sym_def] = "def",
  [sym_let] = "let",
  [sym_let_item] = "let_item",
  [sym_multiclass] = "multiclass",
  [sym_multiclass_body] = "multiclass_body",
  [sym_multiclass_statement] = "multiclass_statement",
  [sym_defm] = "defm",
  [sym_defset] = "defset",
  [sym_defvar] = "defvar",
  [sym_foreach] = "foreach",
  [sym_if] = "if",
  [sym_assert] = "assert",
  [sym_type] = "type",
  [sym_value] = "value",
  [sym__value_concat] = "_value_concat",
  [sym__simple_value] = "_simple_value",
  [aux_sym__repeated_string] = "_repeated_string",
  [sym_operator] = "operator",
  [sym_dag_arg] = "dag_arg",
  [sym_value_suffix] = "value_suffix",
  [sym_operator_keyword] = "operator_keyword",
  [aux_sym_file_repeat1] = "file_repeat1",
  [aux_sym_parent_class_list_repeat1] = "parent_class_list_repeat1",
  [aux_sym_parent_class_list_repeat2] = "parent_class_list_repeat2",
  [aux_sym_template_args_repeat1] = "template_args_repeat1",
  [aux_sym_record_body_repeat1] = "record_body_repeat1",
  [aux_sym_let_inst_repeat1] = "let_inst_repeat1",
  [aux_sym_let_repeat1] = "let_repeat1",
  [aux_sym_multiclass_body_repeat1] = "multiclass_body_repeat1",
  [aux_sym_value_repeat1] = "value_repeat1",
  [aux_sym__value_concat_repeat1] = "_value_concat_repeat1",
  [aux_sym__simple_value_repeat1] = "_simple_value_repeat1",
  [aux_sym_operator_repeat1] = "operator_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_comment] = sym_comment,
  [sym_number] = sym_number,
  [sym_string_string] = sym_string_string,
  [sym_code_string] = sym_code_string,
  [sym_var] = sym_var,
  [anon_sym_include] = anon_sym_include,
  [sym_preprocessor] = sym_preprocessor,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_field] = anon_sym_field,
  [anon_sym_code] = anon_sym_code,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_defvar] = anon_sym_defvar,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_multiclass] = anon_sym_multiclass,
  [anon_sym_defm] = anon_sym_defm,
  [anon_sym_defset] = anon_sym_defset,
  [anon_sym_foreach] = anon_sym_foreach,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_assert] = anon_sym_assert,
  [anon_sym_bit] = anon_sym_bit,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_dag] = anon_sym_dag,
  [anon_sym_bits] = anon_sym_bits,
  [anon_sym_list] = anon_sym_list,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_BANGcond] = anon_sym_BANGcond,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [aux_sym_operator_keyword_token1] = aux_sym_operator_keyword_token1,
  [sym_multiline_comment] = sym_multiline_comment,
  [sym_file] = sym_file,
  [sym_include] = sym_include,
  [sym_statement] = sym_statement,
  [sym_statement_or_block] = sym_statement_or_block,
  [sym_class] = sym_class,
  [sym_parent_class_list] = sym_parent_class_list,
  [sym_template_args] = sym_template_args,
  [sym_template_arg] = sym_template_arg,
  [sym_record_body] = sym_record_body,
  [sym_body_item] = sym_body_item,
  [sym_instruction] = sym_instruction,
  [sym_let_inst] = sym_let_inst,
  [sym_def_var] = sym_def_var,
  [sym_def] = sym_def,
  [sym_let] = sym_let,
  [sym_let_item] = sym_let_item,
  [sym_multiclass] = sym_multiclass,
  [sym_multiclass_body] = sym_multiclass_body,
  [sym_multiclass_statement] = sym_multiclass_statement,
  [sym_defm] = sym_defm,
  [sym_defset] = sym_defset,
  [sym_defvar] = sym_defvar,
  [sym_foreach] = sym_foreach,
  [sym_if] = sym_if,
  [sym_assert] = sym_assert,
  [sym_type] = sym_type,
  [sym_value] = sym_value,
  [sym__value_concat] = sym__value_concat,
  [sym__simple_value] = sym__simple_value,
  [aux_sym__repeated_string] = aux_sym__repeated_string,
  [sym_operator] = sym_operator,
  [sym_dag_arg] = sym_dag_arg,
  [sym_value_suffix] = sym_value_suffix,
  [sym_operator_keyword] = sym_operator_keyword,
  [aux_sym_file_repeat1] = aux_sym_file_repeat1,
  [aux_sym_parent_class_list_repeat1] = aux_sym_parent_class_list_repeat1,
  [aux_sym_parent_class_list_repeat2] = aux_sym_parent_class_list_repeat2,
  [aux_sym_template_args_repeat1] = aux_sym_template_args_repeat1,
  [aux_sym_record_body_repeat1] = aux_sym_record_body_repeat1,
  [aux_sym_let_inst_repeat1] = aux_sym_let_inst_repeat1,
  [aux_sym_let_repeat1] = aux_sym_let_repeat1,
  [aux_sym_multiclass_body_repeat1] = aux_sym_multiclass_body_repeat1,
  [aux_sym_value_repeat1] = aux_sym_value_repeat1,
  [aux_sym__value_concat_repeat1] = aux_sym__value_concat_repeat1,
  [aux_sym__simple_value_repeat1] = aux_sym__simple_value_repeat1,
  [aux_sym_operator_repeat1] = aux_sym_operator_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_string_string] = {
    .visible = true,
    .named = true,
  },
  [sym_code_string] = {
    .visible = true,
    .named = true,
  },
  [sym_var] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [sym_preprocessor] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_field] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_code] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defvar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_multiclass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defm] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_foreach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dag] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_list] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANGcond] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_operator_keyword_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_multiline_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_file] = {
    .visible = true,
    .named = true,
  },
  [sym_include] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_statement_or_block] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_parent_class_list] = {
    .visible = true,
    .named = true,
  },
  [sym_template_args] = {
    .visible = true,
    .named = true,
  },
  [sym_template_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_record_body] = {
    .visible = true,
    .named = true,
  },
  [sym_body_item] = {
    .visible = true,
    .named = true,
  },
  [sym_instruction] = {
    .visible = true,
    .named = true,
  },
  [sym_let_inst] = {
    .visible = true,
    .named = true,
  },
  [sym_def_var] = {
    .visible = true,
    .named = true,
  },
  [sym_def] = {
    .visible = true,
    .named = true,
  },
  [sym_let] = {
    .visible = true,
    .named = true,
  },
  [sym_let_item] = {
    .visible = true,
    .named = true,
  },
  [sym_multiclass] = {
    .visible = true,
    .named = true,
  },
  [sym_multiclass_body] = {
    .visible = true,
    .named = true,
  },
  [sym_multiclass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_defm] = {
    .visible = true,
    .named = true,
  },
  [sym_defset] = {
    .visible = true,
    .named = true,
  },
  [sym_defvar] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_assert] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym__value_concat] = {
    .visible = false,
    .named = true,
  },
  [sym__simple_value] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__repeated_string] = {
    .visible = false,
    .named = false,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_dag_arg] = {
    .visible = true,
    .named = true,
  },
  [sym_value_suffix] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_keyword] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parent_class_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parent_class_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_template_args_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_inst_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multiclass_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__value_concat_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum {
  field_argument = 1,
  field_body = 2,
  field_name = 3,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_body] = "body",
  [field_name] = "name",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 1},
  [7] = {.index = 8, .length = 1},
  [8] = {.index = 9, .length = 2},
  [9] = {.index = 11, .length = 1},
  [10] = {.index = 12, .length = 2},
  [11] = {.index = 14, .length = 1},
  [12] = {.index = 15, .length = 2},
  [13] = {.index = 17, .length = 2},
  [14] = {.index = 19, .length = 1},
  [15] = {.index = 20, .length = 1},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 23, .length = 2},
  [18] = {.index = 25, .length = 3},
  [19] = {.index = 28, .length = 3},
  [20] = {.index = 31, .length = 4},
  [21] = {.index = 35, .length = 1},
  [22] = {.index = 36, .length = 2},
  [23] = {.index = 38, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_argument, 0, .inherited = true},
  [1] =
    {field_body, 2},
    {field_name, 1},
  [3] =
    {field_body, 2},
  [4] =
    {field_body, 3},
    {field_name, 1},
  [6] =
    {field_argument, 2, .inherited = true},
  [7] =
    {field_body, 3},
  [8] =
    {field_argument, 1},
  [9] =
    {field_body, 4},
    {field_name, 1},
  [11] =
    {field_argument, 2},
  [12] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [14] =
    {field_body, 4},
  [15] =
    {field_argument, 1},
    {field_argument, 2, .inherited = true},
  [17] =
    {field_argument, 2},
    {field_argument, 3, .inherited = true},
  [19] =
    {field_argument, 4, .inherited = true},
  [20] =
    {field_argument, 3},
  [21] =
    {field_argument, 3},
    {field_argument, 5, .inherited = true},
  [23] =
    {field_argument, 3},
    {field_argument, 4, .inherited = true},
  [25] =
    {field_argument, 2},
    {field_argument, 3},
    {field_argument, 4},
  [28] =
    {field_argument, 3},
    {field_argument, 4, .inherited = true},
    {field_argument, 6, .inherited = true},
  [31] =
    {field_argument, 2},
    {field_argument, 3},
    {field_argument, 4},
    {field_argument, 5, .inherited = true},
  [35] =
    {field_argument, 5},
  [36] =
    {field_argument, 5},
    {field_argument, 6, .inherited = true},
  [38] =
    {field_argument, 1},
    {field_argument, 2},
    {field_argument, 3},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(103);
      if (lookahead == '!') ADVANCE(141);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '#') ADVANCE(129);
      if (lookahead == '$') ADVANCE(101);
      if (lookahead == '(') ADVANCE(134);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == '+') ADVANCE(98);
      if (lookahead == ',') ADVANCE(125);
      if (lookahead == '-') ADVANCE(140);
      if (lookahead == '.') ADVANCE(137);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '0') ADVANCE(105);
      if (lookahead == ':') ADVANCE(123);
      if (lookahead == ';') ADVANCE(128);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '=') ADVANCE(127);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '?') ADVANCE(130);
      if (lookahead == '[') ADVANCE(132);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(109);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(116);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead != 0) ADVANCE(1);
      END_STATE();
    case 2:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '0') ADVANCE(106);
      if (lookahead == 'a') ADVANCE(26);
      if (lookahead == 'c') ADVANCE(10);
      if (lookahead == 'd') ADVANCE(7);
      if (lookahead == 'e') ADVANCE(61);
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'g') ADVANCE(35);
      if (lookahead == 'h') ADVANCE(37);
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 'l') ADVANCE(93);
      if (lookahead == 'm') ADVANCE(86);
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 's') ADVANCE(39);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'x') ADVANCE(67);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(21);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == '0') ADVANCE(106);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(98);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 4:
      if (lookahead == '.') ADVANCE(138);
      END_STATE();
    case 5:
      if (lookahead == '/') ADVANCE(104);
      END_STATE();
    case 6:
      if (lookahead == ']') ADVANCE(117);
      if (lookahead == '}') ADVANCE(91);
      if (lookahead != 0) ADVANCE(90);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(48);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(142);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(87);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(77);
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(79);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(17);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(23);
      END_STATE();
    case 16:
      if (lookahead == 'b') ADVANCE(144);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(50);
      END_STATE();
    case 18:
      if (lookahead == 'c') ADVANCE(12);
      END_STATE();
    case 19:
      if (lookahead == 'c') ADVANCE(69);
      END_STATE();
    case 20:
      if (lookahead == 'c') ADVANCE(69);
      if (lookahead == 's') ADVANCE(71);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(36);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'i') ADVANCE(43);
      END_STATE();
    case 22:
      if (lookahead == 'd') ADVANCE(136);
      END_STATE();
    case 23:
      if (lookahead == 'd') ADVANCE(142);
      END_STATE();
    case 24:
      if (lookahead == 'd') ADVANCE(56);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(54);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(40);
      END_STATE();
    case 28:
      if (lookahead == 'd') ADVANCE(40);
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 29:
      if (lookahead == 'd') ADVANCE(11);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(142);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(142);
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(145);
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(15);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(84);
      if (lookahead == 'h') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(89);
      if (lookahead == 'r') ADVANCE(92);
      if (lookahead == 't') ADVANCE(74);
      if (lookahead == 'u') ADVANCE(16);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(13);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(9);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(28);
      END_STATE();
    case 44:
      if (lookahead == 'f') ADVANCE(53);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(119);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(95);
      END_STATE();
    case 47:
      if (lookahead == 'f') ADVANCE(142);
      if (lookahead == 'n') ADVANCE(83);
      if (lookahead == 's') ADVANCE(8);
      END_STATE();
    case 48:
      if (lookahead == 'g') ADVANCE(142);
      END_STATE();
    case 49:
      if (lookahead == 'g') ADVANCE(68);
      END_STATE();
    case 50:
      if (lookahead == 'h') ADVANCE(142);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(56);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(59);
      if (lookahead == 'o') ADVANCE(57);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(64);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(45);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(25);
      END_STATE();
    case 56:
      if (lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 57:
      if (lookahead == 'l') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 58:
      if (lookahead == 'l') ADVANCE(12);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 60:
      if (lookahead == 'l') ADVANCE(42);
      END_STATE();
    case 61:
      if (lookahead == 'm') ADVANCE(72);
      if (lookahead == 'q') ADVANCE(142);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(142);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 65:
      if (lookahead == 'n') ADVANCE(18);
      END_STATE();
    case 66:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 67:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(65);
      END_STATE();
    case 70:
      if (lookahead == 'p') ADVANCE(142);
      END_STATE();
    case 71:
      if (lookahead == 'p') ADVANCE(58);
      END_STATE();
    case 72:
      if (lookahead == 'p') ADVANCE(80);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(142);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 76:
      if (lookahead == 's') ADVANCE(30);
      END_STATE();
    case 77:
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 78:
      if (lookahead == 's') ADVANCE(81);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(143);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(38);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(32);
      END_STATE();
    case 86:
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 87:
      if (lookahead == 'v') ADVANCE(33);
      END_STATE();
    case 88:
      if (lookahead == 'y') ADVANCE(142);
      END_STATE();
    case 89:
      if (lookahead == 'z') ADVANCE(33);
      END_STATE();
    case 90:
      if (lookahead == '}') ADVANCE(6);
      if (lookahead != 0) ADVANCE(90);
      END_STATE();
    case 91:
      if (lookahead == '}') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != ']') ADVANCE(90);
      END_STATE();
    case 92:
      if (lookahead == 'a' ||
          lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 93:
      if (lookahead == 'e' ||
          lookahead == 't') ADVANCE(142);
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 94:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(108);
      END_STATE();
    case 95:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      END_STATE();
    case 96:
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(96);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 97:
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\' ||
          lookahead == 'n' ||
          lookahead == 't') ADVANCE(1);
      END_STATE();
    case 98:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 99:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 100:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 101:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 102:
      if (eof) ADVANCE(103);
      if (lookahead == '"') ADVANCE(1);
      if (lookahead == '#') ADVANCE(129);
      if (lookahead == ')') ADVANCE(135);
      if (lookahead == ',') ADVANCE(125);
      if (lookahead == '-') ADVANCE(139);
      if (lookahead == '.') ADVANCE(137);
      if (lookahead == '/') ADVANCE(5);
      if (lookahead == ':') ADVANCE(123);
      if (lookahead == ';') ADVANCE(128);
      if (lookahead == '<') ADVANCE(124);
      if (lookahead == '>') ADVANCE(126);
      if (lookahead == '[') ADVANCE(131);
      if (lookahead == ']') ADVANCE(133);
      if (lookahead == '{') ADVANCE(121);
      if (lookahead == '}') ADVANCE(122);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(102)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(99);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(104);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'b') ADVANCE(113);
      if (lookahead == 'x') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(109);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'b') ADVANCE(94);
      if (lookahead == 'x') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(107);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(114);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(109);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(107);
      if (('2' <= lookahead && lookahead <= '9')) ADVANCE(114);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(114);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(111);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_string_string);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_code_string);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_var);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(118);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_preprocessor);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_preprocessor);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(120);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == 'd') ADVANCE(36);
      if (lookahead == 'e') ADVANCE(55);
      if (lookahead == 'i') ADVANCE(43);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      if (lookahead == '{') ADVANCE(90);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_BANGcond);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(4);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(110);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == 'c') ADVANCE(66);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      if (lookahead == 'r') ADVANCE(142);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      if (lookahead == 's') ADVANCE(82);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym_operator_keyword_token1);
      if (lookahead == 't') ADVANCE(29);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'a') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'e') ADVANCE(5);
      if (lookahead == 'f') ADVANCE(6);
      if (lookahead == 'i') ADVANCE(7);
      if (lookahead == 'l') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 's') ADVANCE(10);
      if (lookahead == 't') ADVANCE(11);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 's') ADVANCE(12);
      END_STATE();
    case 2:
      if (lookahead == 'i') ADVANCE(13);
      END_STATE();
    case 3:
      if (lookahead == 'l') ADVANCE(14);
      if (lookahead == 'o') ADVANCE(15);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(16);
      if (lookahead == 'e') ADVANCE(17);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(18);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(19);
      if (lookahead == 'i') ADVANCE(20);
      if (lookahead == 'o') ADVANCE(21);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(24);
      if (lookahead == 'i') ADVANCE(25);
      END_STATE();
    case 9:
      if (lookahead == 'u') ADVANCE(26);
      END_STATE();
    case 10:
      if (lookahead == 't') ADVANCE(27);
      END_STATE();
    case 11:
      if (lookahead == 'h') ADVANCE(28);
      if (lookahead == 'r') ADVANCE(29);
      END_STATE();
    case 12:
      if (lookahead == 's') ADVANCE(30);
      END_STATE();
    case 13:
      if (lookahead == 't') ADVANCE(31);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 15:
      if (lookahead == 'd') ADVANCE(33);
      END_STATE();
    case 16:
      if (lookahead == 'g') ADVANCE(34);
      END_STATE();
    case 17:
      if (lookahead == 'f') ADVANCE(35);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 19:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 20:
      if (lookahead == 'e') ADVANCE(38);
      END_STATE();
    case 21:
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 'c') ADVANCE(40);
      if (lookahead == 't') ADVANCE(41);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 25:
      if (lookahead == 's') ADVANCE(43);
      END_STATE();
    case 26:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(46);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(47);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(48);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_bit);
      if (lookahead == 's') ADVANCE(49);
      END_STATE();
    case 32:
      if (lookahead == 's') ADVANCE(50);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(51);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_dag);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_def);
      if (lookahead == 'm') ADVANCE(52);
      if (lookahead == 's') ADVANCE(53);
      if (lookahead == 'v') ADVANCE(54);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 38:
      if (lookahead == 'l') ADVANCE(57);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(58);
      END_STATE();
    case 40:
      if (lookahead == 'l') ADVANCE(59);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_int);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 43:
      if (lookahead == 't') ADVANCE(60);
      END_STATE();
    case 44:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 45:
      if (lookahead == 'i') ADVANCE(62);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(63);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(64);
      END_STATE();
    case 48:
      if (lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_bits);
      END_STATE();
    case 50:
      if (lookahead == 's') ADVANCE(66);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_code);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_defm);
      END_STATE();
    case 53:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(68);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 57:
      if (lookahead == 'd') ADVANCE(70);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(71);
      END_STATE();
    case 59:
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_list);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(74);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_field);
      END_STATE();
    case 71:
      if (lookahead == 'c') ADVANCE(78);
      END_STATE();
    case 72:
      if (lookahead == 'd') ADVANCE(79);
      END_STATE();
    case 73:
      if (lookahead == 'c') ADVANCE(80);
      END_STATE();
    case 74:
      if (lookahead == 'g') ADVANCE(81);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_defset);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_defvar);
      END_STATE();
    case 78:
      if (lookahead == 'h') ADVANCE(82);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 80:
      if (lookahead == 'l') ADVANCE(84);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_foreach);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 84:
      if (lookahead == 'a') ADVANCE(85);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_multiclass);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 102, .external_lex_state = 1},
  [2] = {.lex_state = 0, .external_lex_state = 1},
  [3] = {.lex_state = 0, .external_lex_state = 1},
  [4] = {.lex_state = 0, .external_lex_state = 1},
  [5] = {.lex_state = 0, .external_lex_state = 1},
  [6] = {.lex_state = 0, .external_lex_state = 1},
  [7] = {.lex_state = 102, .external_lex_state = 1},
  [8] = {.lex_state = 102, .external_lex_state = 1},
  [9] = {.lex_state = 102, .external_lex_state = 1},
  [10] = {.lex_state = 102, .external_lex_state = 1},
  [11] = {.lex_state = 102, .external_lex_state = 1},
  [12] = {.lex_state = 102, .external_lex_state = 1},
  [13] = {.lex_state = 102, .external_lex_state = 1},
  [14] = {.lex_state = 102, .external_lex_state = 1},
  [15] = {.lex_state = 102, .external_lex_state = 1},
  [16] = {.lex_state = 102, .external_lex_state = 1},
  [17] = {.lex_state = 102, .external_lex_state = 1},
  [18] = {.lex_state = 102, .external_lex_state = 1},
  [19] = {.lex_state = 102, .external_lex_state = 1},
  [20] = {.lex_state = 102, .external_lex_state = 1},
  [21] = {.lex_state = 102, .external_lex_state = 1},
  [22] = {.lex_state = 102, .external_lex_state = 1},
  [23] = {.lex_state = 102, .external_lex_state = 1},
  [24] = {.lex_state = 102, .external_lex_state = 1},
  [25] = {.lex_state = 102, .external_lex_state = 1},
  [26] = {.lex_state = 102, .external_lex_state = 1},
  [27] = {.lex_state = 102, .external_lex_state = 1},
  [28] = {.lex_state = 0, .external_lex_state = 1},
  [29] = {.lex_state = 102, .external_lex_state = 1},
  [30] = {.lex_state = 102, .external_lex_state = 1},
  [31] = {.lex_state = 102, .external_lex_state = 1},
  [32] = {.lex_state = 102, .external_lex_state = 1},
  [33] = {.lex_state = 102, .external_lex_state = 1},
  [34] = {.lex_state = 102, .external_lex_state = 1},
  [35] = {.lex_state = 102, .external_lex_state = 1},
  [36] = {.lex_state = 102, .external_lex_state = 1},
  [37] = {.lex_state = 102, .external_lex_state = 1},
  [38] = {.lex_state = 102, .external_lex_state = 1},
  [39] = {.lex_state = 102, .external_lex_state = 1},
  [40] = {.lex_state = 102, .external_lex_state = 1},
  [41] = {.lex_state = 102, .external_lex_state = 1},
  [42] = {.lex_state = 102, .external_lex_state = 1},
  [43] = {.lex_state = 102, .external_lex_state = 1},
  [44] = {.lex_state = 102, .external_lex_state = 1},
  [45] = {.lex_state = 0, .external_lex_state = 1},
  [46] = {.lex_state = 0, .external_lex_state = 1},
  [47] = {.lex_state = 0, .external_lex_state = 1},
  [48] = {.lex_state = 102, .external_lex_state = 1},
  [49] = {.lex_state = 0, .external_lex_state = 1},
  [50] = {.lex_state = 0, .external_lex_state = 1},
  [51] = {.lex_state = 0, .external_lex_state = 1},
  [52] = {.lex_state = 0, .external_lex_state = 1},
  [53] = {.lex_state = 0, .external_lex_state = 1},
  [54] = {.lex_state = 0, .external_lex_state = 1},
  [55] = {.lex_state = 0, .external_lex_state = 1},
  [56] = {.lex_state = 0, .external_lex_state = 1},
  [57] = {.lex_state = 0, .external_lex_state = 1},
  [58] = {.lex_state = 0, .external_lex_state = 1},
  [59] = {.lex_state = 0, .external_lex_state = 1},
  [60] = {.lex_state = 0, .external_lex_state = 1},
  [61] = {.lex_state = 102, .external_lex_state = 1},
  [62] = {.lex_state = 0, .external_lex_state = 1},
  [63] = {.lex_state = 0, .external_lex_state = 1},
  [64] = {.lex_state = 0, .external_lex_state = 1},
  [65] = {.lex_state = 0, .external_lex_state = 1},
  [66] = {.lex_state = 102, .external_lex_state = 1},
  [67] = {.lex_state = 0, .external_lex_state = 1},
  [68] = {.lex_state = 0, .external_lex_state = 1},
  [69] = {.lex_state = 0, .external_lex_state = 1},
  [70] = {.lex_state = 0, .external_lex_state = 1},
  [71] = {.lex_state = 0, .external_lex_state = 1},
  [72] = {.lex_state = 0, .external_lex_state = 1},
  [73] = {.lex_state = 0, .external_lex_state = 1},
  [74] = {.lex_state = 0, .external_lex_state = 1},
  [75] = {.lex_state = 0, .external_lex_state = 1},
  [76] = {.lex_state = 0, .external_lex_state = 1},
  [77] = {.lex_state = 0, .external_lex_state = 1},
  [78] = {.lex_state = 102, .external_lex_state = 1},
  [79] = {.lex_state = 0, .external_lex_state = 1},
  [80] = {.lex_state = 102, .external_lex_state = 1},
  [81] = {.lex_state = 0, .external_lex_state = 1},
  [82] = {.lex_state = 0, .external_lex_state = 1},
  [83] = {.lex_state = 0, .external_lex_state = 1},
  [84] = {.lex_state = 0, .external_lex_state = 1},
  [85] = {.lex_state = 102, .external_lex_state = 1},
  [86] = {.lex_state = 0, .external_lex_state = 1},
  [87] = {.lex_state = 0, .external_lex_state = 1},
  [88] = {.lex_state = 0, .external_lex_state = 1},
  [89] = {.lex_state = 0, .external_lex_state = 1},
  [90] = {.lex_state = 0, .external_lex_state = 1},
  [91] = {.lex_state = 0, .external_lex_state = 1},
  [92] = {.lex_state = 0, .external_lex_state = 1},
  [93] = {.lex_state = 0, .external_lex_state = 1},
  [94] = {.lex_state = 0, .external_lex_state = 1},
  [95] = {.lex_state = 0, .external_lex_state = 1},
  [96] = {.lex_state = 0, .external_lex_state = 1},
  [97] = {.lex_state = 0, .external_lex_state = 1},
  [98] = {.lex_state = 0, .external_lex_state = 1},
  [99] = {.lex_state = 0, .external_lex_state = 1},
  [100] = {.lex_state = 0, .external_lex_state = 1},
  [101] = {.lex_state = 0, .external_lex_state = 1},
  [102] = {.lex_state = 0, .external_lex_state = 1},
  [103] = {.lex_state = 0, .external_lex_state = 1},
  [104] = {.lex_state = 0, .external_lex_state = 1},
  [105] = {.lex_state = 0, .external_lex_state = 1},
  [106] = {.lex_state = 0, .external_lex_state = 1},
  [107] = {.lex_state = 0, .external_lex_state = 1},
  [108] = {.lex_state = 0, .external_lex_state = 1},
  [109] = {.lex_state = 0, .external_lex_state = 1},
  [110] = {.lex_state = 0, .external_lex_state = 1},
  [111] = {.lex_state = 0, .external_lex_state = 1},
  [112] = {.lex_state = 0, .external_lex_state = 1},
  [113] = {.lex_state = 0, .external_lex_state = 1},
  [114] = {.lex_state = 0, .external_lex_state = 1},
  [115] = {.lex_state = 0, .external_lex_state = 1},
  [116] = {.lex_state = 0, .external_lex_state = 1},
  [117] = {.lex_state = 0, .external_lex_state = 1},
  [118] = {.lex_state = 0, .external_lex_state = 1},
  [119] = {.lex_state = 0, .external_lex_state = 1},
  [120] = {.lex_state = 0, .external_lex_state = 1},
  [121] = {.lex_state = 0, .external_lex_state = 1},
  [122] = {.lex_state = 0, .external_lex_state = 1},
  [123] = {.lex_state = 0, .external_lex_state = 1},
  [124] = {.lex_state = 0, .external_lex_state = 1},
  [125] = {.lex_state = 0, .external_lex_state = 1},
  [126] = {.lex_state = 0, .external_lex_state = 1},
  [127] = {.lex_state = 0, .external_lex_state = 1},
  [128] = {.lex_state = 0, .external_lex_state = 1},
  [129] = {.lex_state = 0, .external_lex_state = 1},
  [130] = {.lex_state = 0, .external_lex_state = 1},
  [131] = {.lex_state = 0, .external_lex_state = 1},
  [132] = {.lex_state = 0, .external_lex_state = 1},
  [133] = {.lex_state = 0, .external_lex_state = 1},
  [134] = {.lex_state = 0, .external_lex_state = 1},
  [135] = {.lex_state = 0, .external_lex_state = 1},
  [136] = {.lex_state = 0, .external_lex_state = 1},
  [137] = {.lex_state = 0, .external_lex_state = 1},
  [138] = {.lex_state = 0, .external_lex_state = 1},
  [139] = {.lex_state = 0, .external_lex_state = 1},
  [140] = {.lex_state = 0, .external_lex_state = 1},
  [141] = {.lex_state = 0, .external_lex_state = 1},
  [142] = {.lex_state = 0, .external_lex_state = 1},
  [143] = {.lex_state = 0, .external_lex_state = 1},
  [144] = {.lex_state = 0, .external_lex_state = 1},
  [145] = {.lex_state = 0, .external_lex_state = 1},
  [146] = {.lex_state = 0, .external_lex_state = 1},
  [147] = {.lex_state = 0, .external_lex_state = 1},
  [148] = {.lex_state = 0, .external_lex_state = 1},
  [149] = {.lex_state = 0, .external_lex_state = 1},
  [150] = {.lex_state = 0, .external_lex_state = 1},
  [151] = {.lex_state = 0, .external_lex_state = 1},
  [152] = {.lex_state = 0, .external_lex_state = 1},
  [153] = {.lex_state = 0, .external_lex_state = 1},
  [154] = {.lex_state = 0, .external_lex_state = 1},
  [155] = {.lex_state = 0, .external_lex_state = 1},
  [156] = {.lex_state = 0, .external_lex_state = 1},
  [157] = {.lex_state = 0, .external_lex_state = 1},
  [158] = {.lex_state = 0, .external_lex_state = 1},
  [159] = {.lex_state = 0, .external_lex_state = 1},
  [160] = {.lex_state = 0, .external_lex_state = 1},
  [161] = {.lex_state = 0, .external_lex_state = 1},
  [162] = {.lex_state = 0, .external_lex_state = 1},
  [163] = {.lex_state = 0, .external_lex_state = 1},
  [164] = {.lex_state = 0, .external_lex_state = 1},
  [165] = {.lex_state = 0, .external_lex_state = 1},
  [166] = {.lex_state = 0, .external_lex_state = 1},
  [167] = {.lex_state = 0, .external_lex_state = 1},
  [168] = {.lex_state = 0, .external_lex_state = 1},
  [169] = {.lex_state = 0, .external_lex_state = 1},
  [170] = {.lex_state = 0, .external_lex_state = 1},
  [171] = {.lex_state = 0, .external_lex_state = 1},
  [172] = {.lex_state = 0, .external_lex_state = 1},
  [173] = {.lex_state = 0, .external_lex_state = 1},
  [174] = {.lex_state = 0, .external_lex_state = 1},
  [175] = {.lex_state = 0, .external_lex_state = 1},
  [176] = {.lex_state = 0, .external_lex_state = 1},
  [177] = {.lex_state = 0, .external_lex_state = 1},
  [178] = {.lex_state = 0, .external_lex_state = 1},
  [179] = {.lex_state = 0, .external_lex_state = 1},
  [180] = {.lex_state = 0, .external_lex_state = 1},
  [181] = {.lex_state = 0, .external_lex_state = 1},
  [182] = {.lex_state = 102, .external_lex_state = 1},
  [183] = {.lex_state = 102, .external_lex_state = 1},
  [184] = {.lex_state = 102, .external_lex_state = 1},
  [185] = {.lex_state = 0, .external_lex_state = 1},
  [186] = {.lex_state = 102, .external_lex_state = 1},
  [187] = {.lex_state = 102, .external_lex_state = 1},
  [188] = {.lex_state = 102, .external_lex_state = 1},
  [189] = {.lex_state = 102, .external_lex_state = 1},
  [190] = {.lex_state = 102, .external_lex_state = 1},
  [191] = {.lex_state = 102, .external_lex_state = 1},
  [192] = {.lex_state = 102, .external_lex_state = 1},
  [193] = {.lex_state = 0, .external_lex_state = 1},
  [194] = {.lex_state = 102, .external_lex_state = 1},
  [195] = {.lex_state = 102, .external_lex_state = 1},
  [196] = {.lex_state = 102, .external_lex_state = 1},
  [197] = {.lex_state = 0, .external_lex_state = 1},
  [198] = {.lex_state = 102, .external_lex_state = 1},
  [199] = {.lex_state = 102, .external_lex_state = 1},
  [200] = {.lex_state = 102, .external_lex_state = 1},
  [201] = {.lex_state = 102, .external_lex_state = 1},
  [202] = {.lex_state = 102, .external_lex_state = 1},
  [203] = {.lex_state = 102, .external_lex_state = 1},
  [204] = {.lex_state = 102, .external_lex_state = 1},
  [205] = {.lex_state = 102, .external_lex_state = 1},
  [206] = {.lex_state = 102, .external_lex_state = 1},
  [207] = {.lex_state = 102, .external_lex_state = 1},
  [208] = {.lex_state = 102, .external_lex_state = 1},
  [209] = {.lex_state = 102, .external_lex_state = 1},
  [210] = {.lex_state = 102, .external_lex_state = 1},
  [211] = {.lex_state = 102, .external_lex_state = 1},
  [212] = {.lex_state = 102, .external_lex_state = 1},
  [213] = {.lex_state = 102, .external_lex_state = 1},
  [214] = {.lex_state = 102, .external_lex_state = 1},
  [215] = {.lex_state = 102, .external_lex_state = 1},
  [216] = {.lex_state = 102, .external_lex_state = 1},
  [217] = {.lex_state = 0, .external_lex_state = 1},
  [218] = {.lex_state = 102, .external_lex_state = 1},
  [219] = {.lex_state = 0, .external_lex_state = 1},
  [220] = {.lex_state = 102, .external_lex_state = 1},
  [221] = {.lex_state = 102, .external_lex_state = 1},
  [222] = {.lex_state = 102, .external_lex_state = 1},
  [223] = {.lex_state = 102, .external_lex_state = 1},
  [224] = {.lex_state = 102, .external_lex_state = 1},
  [225] = {.lex_state = 102, .external_lex_state = 1},
  [226] = {.lex_state = 102, .external_lex_state = 1},
  [227] = {.lex_state = 102, .external_lex_state = 1},
  [228] = {.lex_state = 102, .external_lex_state = 1},
  [229] = {.lex_state = 102, .external_lex_state = 1},
  [230] = {.lex_state = 102, .external_lex_state = 1},
  [231] = {.lex_state = 102, .external_lex_state = 1},
  [232] = {.lex_state = 102, .external_lex_state = 1},
  [233] = {.lex_state = 102, .external_lex_state = 1},
  [234] = {.lex_state = 102, .external_lex_state = 1},
  [235] = {.lex_state = 102, .external_lex_state = 1},
  [236] = {.lex_state = 102, .external_lex_state = 1},
  [237] = {.lex_state = 102, .external_lex_state = 1},
  [238] = {.lex_state = 102, .external_lex_state = 1},
  [239] = {.lex_state = 102, .external_lex_state = 1},
  [240] = {.lex_state = 102, .external_lex_state = 1},
  [241] = {.lex_state = 102, .external_lex_state = 1},
  [242] = {.lex_state = 102, .external_lex_state = 1},
  [243] = {.lex_state = 102, .external_lex_state = 1},
  [244] = {.lex_state = 102, .external_lex_state = 1},
  [245] = {.lex_state = 102, .external_lex_state = 1},
  [246] = {.lex_state = 102, .external_lex_state = 1},
  [247] = {.lex_state = 102, .external_lex_state = 1},
  [248] = {.lex_state = 102, .external_lex_state = 1},
  [249] = {.lex_state = 102, .external_lex_state = 1},
  [250] = {.lex_state = 102, .external_lex_state = 1},
  [251] = {.lex_state = 102, .external_lex_state = 1},
  [252] = {.lex_state = 102, .external_lex_state = 1},
  [253] = {.lex_state = 102, .external_lex_state = 1},
  [254] = {.lex_state = 102, .external_lex_state = 1},
  [255] = {.lex_state = 102, .external_lex_state = 1},
  [256] = {.lex_state = 102, .external_lex_state = 1},
  [257] = {.lex_state = 102, .external_lex_state = 1},
  [258] = {.lex_state = 102, .external_lex_state = 1},
  [259] = {.lex_state = 102, .external_lex_state = 1},
  [260] = {.lex_state = 102, .external_lex_state = 1},
  [261] = {.lex_state = 102, .external_lex_state = 1},
  [262] = {.lex_state = 102, .external_lex_state = 1},
  [263] = {.lex_state = 102, .external_lex_state = 1},
  [264] = {.lex_state = 102, .external_lex_state = 1},
  [265] = {.lex_state = 102, .external_lex_state = 1},
  [266] = {.lex_state = 102, .external_lex_state = 1},
  [267] = {.lex_state = 102, .external_lex_state = 1},
  [268] = {.lex_state = 102, .external_lex_state = 1},
  [269] = {.lex_state = 102, .external_lex_state = 1},
  [270] = {.lex_state = 102, .external_lex_state = 1},
  [271] = {.lex_state = 102, .external_lex_state = 1},
  [272] = {.lex_state = 102, .external_lex_state = 1},
  [273] = {.lex_state = 102, .external_lex_state = 1},
  [274] = {.lex_state = 102, .external_lex_state = 1},
  [275] = {.lex_state = 102, .external_lex_state = 1},
  [276] = {.lex_state = 102, .external_lex_state = 1},
  [277] = {.lex_state = 102, .external_lex_state = 1},
  [278] = {.lex_state = 102, .external_lex_state = 1},
  [279] = {.lex_state = 102, .external_lex_state = 1},
  [280] = {.lex_state = 102, .external_lex_state = 1},
  [281] = {.lex_state = 102, .external_lex_state = 1},
  [282] = {.lex_state = 102, .external_lex_state = 1},
  [283] = {.lex_state = 102, .external_lex_state = 1},
  [284] = {.lex_state = 102, .external_lex_state = 1},
  [285] = {.lex_state = 102, .external_lex_state = 1},
  [286] = {.lex_state = 102, .external_lex_state = 1},
  [287] = {.lex_state = 102, .external_lex_state = 1},
  [288] = {.lex_state = 102, .external_lex_state = 1},
  [289] = {.lex_state = 102, .external_lex_state = 1},
  [290] = {.lex_state = 102, .external_lex_state = 1},
  [291] = {.lex_state = 102, .external_lex_state = 1},
  [292] = {.lex_state = 102, .external_lex_state = 1},
  [293] = {.lex_state = 102, .external_lex_state = 1},
  [294] = {.lex_state = 102, .external_lex_state = 1},
  [295] = {.lex_state = 102, .external_lex_state = 1},
  [296] = {.lex_state = 102, .external_lex_state = 1},
  [297] = {.lex_state = 102, .external_lex_state = 1},
  [298] = {.lex_state = 102, .external_lex_state = 1},
  [299] = {.lex_state = 102, .external_lex_state = 1},
  [300] = {.lex_state = 102, .external_lex_state = 1},
  [301] = {.lex_state = 102, .external_lex_state = 1},
  [302] = {.lex_state = 102, .external_lex_state = 1},
  [303] = {.lex_state = 102, .external_lex_state = 1},
  [304] = {.lex_state = 102, .external_lex_state = 1},
  [305] = {.lex_state = 102, .external_lex_state = 1},
  [306] = {.lex_state = 102, .external_lex_state = 1},
  [307] = {.lex_state = 102, .external_lex_state = 1},
  [308] = {.lex_state = 102, .external_lex_state = 1},
  [309] = {.lex_state = 102, .external_lex_state = 1},
  [310] = {.lex_state = 102, .external_lex_state = 1},
  [311] = {.lex_state = 102, .external_lex_state = 1},
  [312] = {.lex_state = 102, .external_lex_state = 1},
  [313] = {.lex_state = 102, .external_lex_state = 1},
  [314] = {.lex_state = 102, .external_lex_state = 1},
  [315] = {.lex_state = 102, .external_lex_state = 1},
  [316] = {.lex_state = 102, .external_lex_state = 1},
  [317] = {.lex_state = 102, .external_lex_state = 1},
  [318] = {.lex_state = 102, .external_lex_state = 1},
  [319] = {.lex_state = 102, .external_lex_state = 1},
  [320] = {.lex_state = 102, .external_lex_state = 1},
  [321] = {.lex_state = 102, .external_lex_state = 1},
  [322] = {.lex_state = 102, .external_lex_state = 1},
  [323] = {.lex_state = 102, .external_lex_state = 1},
  [324] = {.lex_state = 102, .external_lex_state = 1},
  [325] = {.lex_state = 102, .external_lex_state = 1},
  [326] = {.lex_state = 102, .external_lex_state = 1},
  [327] = {.lex_state = 102, .external_lex_state = 1},
  [328] = {.lex_state = 102, .external_lex_state = 1},
  [329] = {.lex_state = 102, .external_lex_state = 1},
  [330] = {.lex_state = 102, .external_lex_state = 1},
  [331] = {.lex_state = 102, .external_lex_state = 1},
  [332] = {.lex_state = 102, .external_lex_state = 1},
  [333] = {.lex_state = 102, .external_lex_state = 1},
  [334] = {.lex_state = 102, .external_lex_state = 1},
  [335] = {.lex_state = 102, .external_lex_state = 1},
  [336] = {.lex_state = 102, .external_lex_state = 1},
  [337] = {.lex_state = 102, .external_lex_state = 1},
  [338] = {.lex_state = 102, .external_lex_state = 1},
  [339] = {.lex_state = 0, .external_lex_state = 1},
  [340] = {.lex_state = 0, .external_lex_state = 1},
  [341] = {.lex_state = 0, .external_lex_state = 1},
  [342] = {.lex_state = 0, .external_lex_state = 1},
  [343] = {.lex_state = 0, .external_lex_state = 1},
  [344] = {.lex_state = 0, .external_lex_state = 1},
  [345] = {.lex_state = 0, .external_lex_state = 1},
  [346] = {.lex_state = 0, .external_lex_state = 1},
  [347] = {.lex_state = 0, .external_lex_state = 1},
  [348] = {.lex_state = 0, .external_lex_state = 1},
  [349] = {.lex_state = 0, .external_lex_state = 1},
  [350] = {.lex_state = 0, .external_lex_state = 1},
  [351] = {.lex_state = 0, .external_lex_state = 1},
  [352] = {.lex_state = 0, .external_lex_state = 1},
  [353] = {.lex_state = 0, .external_lex_state = 1},
  [354] = {.lex_state = 0, .external_lex_state = 1},
  [355] = {.lex_state = 0, .external_lex_state = 1},
  [356] = {.lex_state = 0, .external_lex_state = 1},
  [357] = {.lex_state = 0, .external_lex_state = 1},
  [358] = {.lex_state = 0, .external_lex_state = 1},
  [359] = {.lex_state = 0, .external_lex_state = 1},
  [360] = {.lex_state = 0, .external_lex_state = 1},
  [361] = {.lex_state = 0, .external_lex_state = 1},
  [362] = {.lex_state = 0, .external_lex_state = 1},
  [363] = {.lex_state = 0, .external_lex_state = 1},
  [364] = {.lex_state = 0, .external_lex_state = 1},
  [365] = {.lex_state = 0, .external_lex_state = 1},
  [366] = {.lex_state = 0, .external_lex_state = 1},
  [367] = {.lex_state = 0, .external_lex_state = 1},
  [368] = {.lex_state = 0, .external_lex_state = 1},
  [369] = {.lex_state = 0, .external_lex_state = 1},
  [370] = {.lex_state = 0, .external_lex_state = 1},
  [371] = {.lex_state = 0, .external_lex_state = 1},
  [372] = {.lex_state = 0, .external_lex_state = 1},
  [373] = {.lex_state = 0, .external_lex_state = 1},
  [374] = {.lex_state = 0, .external_lex_state = 1},
  [375] = {.lex_state = 0, .external_lex_state = 1},
  [376] = {.lex_state = 0, .external_lex_state = 1},
  [377] = {.lex_state = 102, .external_lex_state = 1},
  [378] = {.lex_state = 0, .external_lex_state = 1},
  [379] = {.lex_state = 0, .external_lex_state = 1},
  [380] = {.lex_state = 0, .external_lex_state = 1},
  [381] = {.lex_state = 0, .external_lex_state = 1},
  [382] = {.lex_state = 0, .external_lex_state = 1},
  [383] = {.lex_state = 0, .external_lex_state = 1},
  [384] = {.lex_state = 0, .external_lex_state = 1},
  [385] = {.lex_state = 0, .external_lex_state = 1},
  [386] = {.lex_state = 102, .external_lex_state = 1},
  [387] = {.lex_state = 0, .external_lex_state = 1},
  [388] = {.lex_state = 102, .external_lex_state = 1},
  [389] = {.lex_state = 0, .external_lex_state = 1},
  [390] = {.lex_state = 0, .external_lex_state = 1},
  [391] = {.lex_state = 0, .external_lex_state = 1},
  [392] = {.lex_state = 0, .external_lex_state = 1},
  [393] = {.lex_state = 0, .external_lex_state = 1},
  [394] = {.lex_state = 102, .external_lex_state = 1},
  [395] = {.lex_state = 0, .external_lex_state = 1},
  [396] = {.lex_state = 0, .external_lex_state = 1},
  [397] = {.lex_state = 0, .external_lex_state = 1},
  [398] = {.lex_state = 0, .external_lex_state = 1},
  [399] = {.lex_state = 0, .external_lex_state = 1},
  [400] = {.lex_state = 0, .external_lex_state = 1},
  [401] = {.lex_state = 0, .external_lex_state = 1},
  [402] = {.lex_state = 0, .external_lex_state = 1},
  [403] = {.lex_state = 0, .external_lex_state = 1},
  [404] = {.lex_state = 0, .external_lex_state = 1},
  [405] = {.lex_state = 0, .external_lex_state = 1},
  [406] = {.lex_state = 0, .external_lex_state = 1},
  [407] = {.lex_state = 0, .external_lex_state = 1},
  [408] = {.lex_state = 0, .external_lex_state = 1},
  [409] = {.lex_state = 0, .external_lex_state = 1},
  [410] = {.lex_state = 0, .external_lex_state = 1},
  [411] = {.lex_state = 0, .external_lex_state = 1},
  [412] = {.lex_state = 0, .external_lex_state = 1},
  [413] = {.lex_state = 0, .external_lex_state = 1},
  [414] = {.lex_state = 0, .external_lex_state = 1},
  [415] = {.lex_state = 0, .external_lex_state = 1},
  [416] = {.lex_state = 102, .external_lex_state = 1},
  [417] = {.lex_state = 0, .external_lex_state = 1},
  [418] = {.lex_state = 0, .external_lex_state = 1},
  [419] = {.lex_state = 102, .external_lex_state = 1},
  [420] = {.lex_state = 0, .external_lex_state = 1},
  [421] = {.lex_state = 0, .external_lex_state = 1},
  [422] = {.lex_state = 0, .external_lex_state = 1},
  [423] = {.lex_state = 102, .external_lex_state = 1},
  [424] = {.lex_state = 0, .external_lex_state = 1},
  [425] = {.lex_state = 0, .external_lex_state = 1},
  [426] = {.lex_state = 102, .external_lex_state = 1},
  [427] = {.lex_state = 0, .external_lex_state = 1},
  [428] = {.lex_state = 0, .external_lex_state = 1},
  [429] = {.lex_state = 0, .external_lex_state = 1},
  [430] = {.lex_state = 102, .external_lex_state = 1},
  [431] = {.lex_state = 0, .external_lex_state = 1},
  [432] = {.lex_state = 0, .external_lex_state = 1},
  [433] = {.lex_state = 102, .external_lex_state = 1},
  [434] = {.lex_state = 0, .external_lex_state = 1},
  [435] = {.lex_state = 102, .external_lex_state = 1},
  [436] = {.lex_state = 0, .external_lex_state = 1},
  [437] = {.lex_state = 0, .external_lex_state = 1},
  [438] = {.lex_state = 0, .external_lex_state = 1},
  [439] = {.lex_state = 0, .external_lex_state = 1},
  [440] = {.lex_state = 0, .external_lex_state = 1},
  [441] = {.lex_state = 0, .external_lex_state = 1},
  [442] = {.lex_state = 0, .external_lex_state = 1},
  [443] = {.lex_state = 102, .external_lex_state = 1},
  [444] = {.lex_state = 102, .external_lex_state = 1},
  [445] = {.lex_state = 0, .external_lex_state = 1},
  [446] = {.lex_state = 0, .external_lex_state = 1},
  [447] = {.lex_state = 0, .external_lex_state = 1},
  [448] = {.lex_state = 0, .external_lex_state = 1},
  [449] = {.lex_state = 0, .external_lex_state = 1},
  [450] = {.lex_state = 102, .external_lex_state = 1},
  [451] = {.lex_state = 0, .external_lex_state = 1},
  [452] = {.lex_state = 0, .external_lex_state = 1},
  [453] = {.lex_state = 0, .external_lex_state = 1},
  [454] = {.lex_state = 0, .external_lex_state = 1},
  [455] = {.lex_state = 102, .external_lex_state = 1},
  [456] = {.lex_state = 102, .external_lex_state = 1},
  [457] = {.lex_state = 0, .external_lex_state = 1},
  [458] = {.lex_state = 0, .external_lex_state = 1},
  [459] = {.lex_state = 0, .external_lex_state = 1},
  [460] = {.lex_state = 0, .external_lex_state = 1},
  [461] = {.lex_state = 102, .external_lex_state = 1},
  [462] = {.lex_state = 0, .external_lex_state = 1},
  [463] = {.lex_state = 102, .external_lex_state = 1},
  [464] = {.lex_state = 0, .external_lex_state = 1},
  [465] = {.lex_state = 0, .external_lex_state = 1},
  [466] = {.lex_state = 102, .external_lex_state = 1},
  [467] = {.lex_state = 0, .external_lex_state = 1},
  [468] = {.lex_state = 102, .external_lex_state = 1},
  [469] = {.lex_state = 102, .external_lex_state = 1},
  [470] = {.lex_state = 0, .external_lex_state = 1},
  [471] = {.lex_state = 0, .external_lex_state = 1},
  [472] = {.lex_state = 0, .external_lex_state = 1},
  [473] = {.lex_state = 0, .external_lex_state = 1},
  [474] = {.lex_state = 0, .external_lex_state = 1},
  [475] = {.lex_state = 0, .external_lex_state = 1},
  [476] = {.lex_state = 0, .external_lex_state = 1},
  [477] = {.lex_state = 0, .external_lex_state = 1},
  [478] = {.lex_state = 0, .external_lex_state = 1},
  [479] = {.lex_state = 102, .external_lex_state = 1},
  [480] = {.lex_state = 102, .external_lex_state = 1},
  [481] = {.lex_state = 102, .external_lex_state = 1},
  [482] = {.lex_state = 0, .external_lex_state = 1},
  [483] = {.lex_state = 102, .external_lex_state = 1},
  [484] = {.lex_state = 0, .external_lex_state = 1},
  [485] = {.lex_state = 0, .external_lex_state = 1},
  [486] = {.lex_state = 0, .external_lex_state = 1},
  [487] = {.lex_state = 0, .external_lex_state = 1},
  [488] = {.lex_state = 102, .external_lex_state = 1},
  [489] = {.lex_state = 102, .external_lex_state = 1},
  [490] = {.lex_state = 102, .external_lex_state = 1},
  [491] = {.lex_state = 102, .external_lex_state = 1},
  [492] = {.lex_state = 0, .external_lex_state = 1},
  [493] = {.lex_state = 0, .external_lex_state = 1},
  [494] = {.lex_state = 2, .external_lex_state = 1},
  [495] = {.lex_state = 0, .external_lex_state = 1},
  [496] = {.lex_state = 0, .external_lex_state = 1},
  [497] = {.lex_state = 102, .external_lex_state = 1},
  [498] = {.lex_state = 0, .external_lex_state = 1},
  [499] = {.lex_state = 102, .external_lex_state = 1},
  [500] = {.lex_state = 0, .external_lex_state = 1},
  [501] = {.lex_state = 0, .external_lex_state = 1},
  [502] = {.lex_state = 0, .external_lex_state = 1},
  [503] = {.lex_state = 102, .external_lex_state = 1},
  [504] = {.lex_state = 102, .external_lex_state = 1},
  [505] = {.lex_state = 102, .external_lex_state = 1},
  [506] = {.lex_state = 0, .external_lex_state = 1},
  [507] = {.lex_state = 102, .external_lex_state = 1},
  [508] = {.lex_state = 102, .external_lex_state = 1},
  [509] = {.lex_state = 0, .external_lex_state = 1},
  [510] = {.lex_state = 0, .external_lex_state = 1},
  [511] = {.lex_state = 0, .external_lex_state = 1},
  [512] = {.lex_state = 0, .external_lex_state = 1},
  [513] = {.lex_state = 102, .external_lex_state = 1},
  [514] = {.lex_state = 0, .external_lex_state = 1},
  [515] = {.lex_state = 0, .external_lex_state = 1},
  [516] = {.lex_state = 0, .external_lex_state = 1},
  [517] = {.lex_state = 0, .external_lex_state = 1},
  [518] = {.lex_state = 0, .external_lex_state = 1},
  [519] = {.lex_state = 0, .external_lex_state = 1},
  [520] = {.lex_state = 0, .external_lex_state = 1},
  [521] = {.lex_state = 0, .external_lex_state = 1},
  [522] = {.lex_state = 102, .external_lex_state = 1},
  [523] = {.lex_state = 0, .external_lex_state = 1},
  [524] = {.lex_state = 0, .external_lex_state = 1},
  [525] = {.lex_state = 0, .external_lex_state = 1},
  [526] = {.lex_state = 0, .external_lex_state = 1},
  [527] = {.lex_state = 0, .external_lex_state = 1},
  [528] = {.lex_state = 0, .external_lex_state = 1},
  [529] = {.lex_state = 0, .external_lex_state = 1},
  [530] = {.lex_state = 0, .external_lex_state = 1},
  [531] = {.lex_state = 0, .external_lex_state = 1},
  [532] = {.lex_state = 0, .external_lex_state = 1},
  [533] = {.lex_state = 102, .external_lex_state = 1},
  [534] = {.lex_state = 0, .external_lex_state = 1},
  [535] = {.lex_state = 0, .external_lex_state = 1},
  [536] = {.lex_state = 2, .external_lex_state = 1},
  [537] = {.lex_state = 0, .external_lex_state = 1},
  [538] = {.lex_state = 0, .external_lex_state = 1},
  [539] = {.lex_state = 0, .external_lex_state = 1},
  [540] = {.lex_state = 102, .external_lex_state = 1},
  [541] = {.lex_state = 0, .external_lex_state = 1},
  [542] = {.lex_state = 102, .external_lex_state = 1},
  [543] = {.lex_state = 0, .external_lex_state = 1},
  [544] = {.lex_state = 102, .external_lex_state = 1},
  [545] = {.lex_state = 102, .external_lex_state = 1},
  [546] = {.lex_state = 0, .external_lex_state = 1},
  [547] = {.lex_state = 0, .external_lex_state = 1},
  [548] = {.lex_state = 0, .external_lex_state = 1},
  [549] = {.lex_state = 0, .external_lex_state = 1},
  [550] = {.lex_state = 0, .external_lex_state = 1},
  [551] = {.lex_state = 102, .external_lex_state = 1},
  [552] = {.lex_state = 102, .external_lex_state = 1},
  [553] = {.lex_state = 0, .external_lex_state = 1},
  [554] = {.lex_state = 0, .external_lex_state = 1},
  [555] = {.lex_state = 0, .external_lex_state = 1},
  [556] = {.lex_state = 0, .external_lex_state = 1},
  [557] = {.lex_state = 102, .external_lex_state = 1},
  [558] = {.lex_state = 0, .external_lex_state = 1},
  [559] = {.lex_state = 0, .external_lex_state = 1},
  [560] = {.lex_state = 0, .external_lex_state = 1},
  [561] = {.lex_state = 102, .external_lex_state = 1},
  [562] = {.lex_state = 102, .external_lex_state = 1},
  [563] = {.lex_state = 102, .external_lex_state = 1},
  [564] = {.lex_state = 0, .external_lex_state = 1},
  [565] = {.lex_state = 102, .external_lex_state = 1},
};

enum {
  ts_external_token_multiline_comment = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_multiline_comment] = sym_multiline_comment,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_multiline_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_number] = ACTIONS(1),
    [sym_string_string] = ACTIONS(1),
    [sym_code_string] = ACTIONS(1),
    [sym_var] = ACTIONS(1),
    [anon_sym_include] = ACTIONS(1),
    [sym_preprocessor] = ACTIONS(3),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_field] = ACTIONS(1),
    [anon_sym_code] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_defvar] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_multiclass] = ACTIONS(1),
    [anon_sym_defm] = ACTIONS(1),
    [anon_sym_defset] = ACTIONS(1),
    [anon_sym_foreach] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [anon_sym_bit] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_dag] = ACTIONS(1),
    [anon_sym_bits] = ACTIONS(1),
    [anon_sym_list] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_BANGcond] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [sym_multiline_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_file] = STATE(550),
    [sym_include] = STATE(249),
    [sym_statement] = STATE(16),
    [sym_class] = STATE(249),
    [sym_def] = STATE(249),
    [sym_let] = STATE(249),
    [sym_multiclass] = STATE(249),
    [sym_defm] = STATE(249),
    [sym_defset] = STATE(249),
    [sym_defvar] = STATE(249),
    [sym_foreach] = STATE(249),
    [sym_if] = STATE(249),
    [sym_assert] = STATE(249),
    [aux_sym_file_repeat1] = STATE(16),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_comment] = ACTIONS(3),
    [anon_sym_include] = ACTIONS(7),
    [sym_preprocessor] = ACTIONS(3),
    [anon_sym_class] = ACTIONS(9),
    [anon_sym_let] = ACTIONS(11),
    [anon_sym_defvar] = ACTIONS(13),
    [anon_sym_def] = ACTIONS(15),
    [anon_sym_multiclass] = ACTIONS(17),
    [anon_sym_defm] = ACTIONS(19),
    [anon_sym_defset] = ACTIONS(21),
    [anon_sym_foreach] = ACTIONS(23),
    [anon_sym_if] = ACTIONS(25),
    [anon_sym_assert] = ACTIONS(27),
    [sym_multiline_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 28,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(39), 1,
      anon_sym_RBRACE,
    ACTIONS(41), 1,
      anon_sym_COMMA,
    ACTIONS(43), 1,
      anon_sym_field,
    ACTIONS(45), 1,
      anon_sym_code,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(49), 1,
      anon_sym_defvar,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(351), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    STATE(505), 1,
      sym_type,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(78), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(53), 4,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(276), 4,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
  [98] = 28,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      anon_sym_COMMA,
    ACTIONS(43), 1,
      anon_sym_field,
    ACTIONS(45), 1,
      anon_sym_code,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(49), 1,
      anon_sym_defvar,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(67), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(351), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    STATE(505), 1,
      sym_type,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(80), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(53), 4,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
    STATE(276), 4,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
  [196] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(82), 1,
      anon_sym_LBRACK,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(199), 1,
      sym_value,
    STATE(220), 1,
      sym__value_concat,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(73), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(182), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(71), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(80), 5,
      anon_sym_in,
      anon_sym_then,
      anon_sym_POUND,
      anon_sym_DOT,
      anon_sym_DASH,
    ACTIONS(78), 8,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
  [265] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(284), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(80), 3,
      anon_sym_in,
      anon_sym_then,
      anon_sym_POUND,
    ACTIONS(78), 7,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [331] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(85), 11,
      sym_number,
      sym_identifier,
      anon_sym_in,
      anon_sym_then,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(87), 15,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_QMARK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [367] = 15,
    ACTIONS(91), 1,
      anon_sym_include,
    ACTIONS(94), 1,
      anon_sym_class,
    ACTIONS(97), 1,
      anon_sym_let,
    ACTIONS(100), 1,
      anon_sym_defvar,
    ACTIONS(103), 1,
      anon_sym_def,
    ACTIONS(106), 1,
      anon_sym_multiclass,
    ACTIONS(109), 1,
      anon_sym_defm,
    ACTIONS(112), 1,
      anon_sym_defset,
    ACTIONS(115), 1,
      anon_sym_foreach,
    ACTIONS(118), 1,
      anon_sym_if,
    ACTIONS(121), 1,
      anon_sym_assert,
    ACTIONS(89), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [427] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(124), 1,
      anon_sym_RBRACE,
    STATE(27), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [486] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(126), 1,
      anon_sym_RBRACE,
    STATE(32), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [545] = 16,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(128), 1,
      anon_sym_LBRACE,
    STATE(259), 1,
      sym_statement_or_block,
    STATE(264), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [606] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(130), 1,
      anon_sym_RBRACE,
    STATE(23), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [665] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(132), 1,
      anon_sym_RBRACE,
    STATE(35), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [724] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(132), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [783] = 16,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_foreach,
    ACTIONS(154), 1,
      anon_sym_if,
    ACTIONS(156), 1,
      anon_sym_assert,
    STATE(307), 1,
      sym_statement_or_block,
    STATE(308), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [844] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(158), 1,
      anon_sym_RBRACE,
    STATE(19), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [903] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(160), 1,
      ts_builtin_sym_end,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [962] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(162), 1,
      anon_sym_RBRACE,
    STATE(21), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1021] = 16,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    STATE(301), 1,
      sym_statement_or_block,
    STATE(308), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1082] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(170), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1141] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(170), 1,
      anon_sym_RBRACE,
    STATE(31), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1200] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(172), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1259] = 16,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    STATE(295), 1,
      sym_statement_or_block,
    STATE(308), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1320] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(174), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1379] = 16,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(128), 1,
      anon_sym_LBRACE,
    ACTIONS(176), 1,
      anon_sym_let,
    ACTIONS(178), 1,
      anon_sym_foreach,
    ACTIONS(180), 1,
      anon_sym_if,
    STATE(259), 1,
      sym_statement_or_block,
    STATE(264), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1440] = 16,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(128), 1,
      anon_sym_LBRACE,
    STATE(261), 1,
      sym_statement_or_block,
    STATE(264), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1501] = 16,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(128), 1,
      anon_sym_LBRACE,
    ACTIONS(176), 1,
      anon_sym_let,
    ACTIONS(178), 1,
      anon_sym_foreach,
    ACTIONS(180), 1,
      anon_sym_if,
    STATE(264), 1,
      sym_statement,
    STATE(266), 1,
      sym_statement_or_block,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1562] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(182), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1621] = 17,
    ACTIONS(184), 1,
      sym_identifier,
    ACTIONS(190), 1,
      sym_string_string,
    ACTIONS(196), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(202), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_BANGcond,
    ACTIONS(208), 1,
      anon_sym_BANG,
    STATE(6), 1,
      sym__value_concat,
    STATE(58), 1,
      aux_sym__repeated_string,
    STATE(72), 1,
      sym_value,
    STATE(477), 1,
      sym_operator_keyword,
    ACTIONS(193), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(53), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(80), 3,
      anon_sym_POUND,
      anon_sym_DOT,
      anon_sym_DASH,
    ACTIONS(187), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(78), 4,
      sym_var,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
  [1684] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(211), 1,
      anon_sym_RBRACE,
    STATE(13), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1743] = 16,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_foreach,
    ACTIONS(154), 1,
      anon_sym_if,
    ACTIONS(156), 1,
      anon_sym_assert,
    STATE(308), 1,
      sym_statement,
    STATE(314), 1,
      sym_statement_or_block,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1804] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(213), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1863] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(215), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1922] = 16,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(136), 1,
      anon_sym_LBRACE,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_foreach,
    ACTIONS(154), 1,
      anon_sym_if,
    ACTIONS(156), 1,
      anon_sym_assert,
    STATE(295), 1,
      sym_statement_or_block,
    STATE(308), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [1983] = 16,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(128), 1,
      anon_sym_LBRACE,
    ACTIONS(176), 1,
      anon_sym_let,
    ACTIONS(178), 1,
      anon_sym_foreach,
    ACTIONS(180), 1,
      anon_sym_if,
    STATE(264), 1,
      sym_statement,
    STATE(270), 1,
      sym_statement_or_block,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2044] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(217), 1,
      anon_sym_RBRACE,
    STATE(7), 2,
      sym_statement,
      aux_sym_file_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2103] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    STATE(240), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2161] = 15,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_foreach,
    ACTIONS(154), 1,
      anon_sym_if,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(221), 1,
      anon_sym_LBRACE,
    STATE(298), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2219] = 15,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    STATE(304), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2277] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(176), 1,
      anon_sym_let,
    ACTIONS(178), 1,
      anon_sym_foreach,
    ACTIONS(180), 1,
      anon_sym_if,
    ACTIONS(219), 1,
      anon_sym_LBRACE,
    STATE(240), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2335] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(176), 1,
      anon_sym_let,
    ACTIONS(178), 1,
      anon_sym_foreach,
    ACTIONS(180), 1,
      anon_sym_if,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    STATE(253), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2393] = 15,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    ACTIONS(221), 1,
      anon_sym_LBRACE,
    STATE(298), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2451] = 15,
    ACTIONS(7), 1,
      anon_sym_include,
    ACTIONS(9), 1,
      anon_sym_class,
    ACTIONS(11), 1,
      anon_sym_let,
    ACTIONS(13), 1,
      anon_sym_defvar,
    ACTIONS(15), 1,
      anon_sym_def,
    ACTIONS(17), 1,
      anon_sym_multiclass,
    ACTIONS(19), 1,
      anon_sym_defm,
    ACTIONS(21), 1,
      anon_sym_defset,
    ACTIONS(23), 1,
      anon_sym_foreach,
    ACTIONS(25), 1,
      anon_sym_if,
    ACTIONS(27), 1,
      anon_sym_assert,
    ACTIONS(225), 1,
      anon_sym_LBRACE,
    STATE(253), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(249), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2509] = 15,
    ACTIONS(134), 1,
      anon_sym_include,
    ACTIONS(138), 1,
      anon_sym_class,
    ACTIONS(140), 1,
      anon_sym_let,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(146), 1,
      anon_sym_multiclass,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(150), 1,
      anon_sym_defset,
    ACTIONS(152), 1,
      anon_sym_foreach,
    ACTIONS(154), 1,
      anon_sym_if,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(223), 1,
      anon_sym_LBRACE,
    STATE(304), 1,
      sym_statement,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(319), 11,
      sym_include,
      sym_class,
      sym_def,
      sym_let,
      sym_multiclass,
      sym_defm,
      sym_defset,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [2567] = 3,
    ACTIONS(227), 2,
      ts_builtin_sym_end,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(229), 21,
      sym_identifier,
      anon_sym_include,
      anon_sym_class,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_def,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [2600] = 19,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(235), 1,
      anon_sym_LBRACE,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(322), 1,
      sym_record_body,
    STATE(339), 1,
      sym_value,
    STATE(402), 1,
      sym_parent_class_list,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(233), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(285), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(231), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [2664] = 17,
    ACTIONS(80), 1,
      anon_sym_POUND,
    ACTIONS(184), 1,
      sym_identifier,
    ACTIONS(190), 1,
      sym_string_string,
    ACTIONS(196), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      anon_sym_LBRACK,
    ACTIONS(202), 1,
      anon_sym_LPAREN,
    ACTIONS(205), 1,
      anon_sym_BANGcond,
    ACTIONS(208), 1,
      anon_sym_BANG,
    STATE(6), 1,
      sym__value_concat,
    STATE(58), 1,
      aux_sym__repeated_string,
    STATE(197), 1,
      sym_value,
    STATE(477), 1,
      sym_operator_keyword,
    ACTIONS(244), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(49), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(78), 3,
      sym_var,
      anon_sym_COLON,
      anon_sym_RPAREN,
    ACTIONS(241), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [2724] = 19,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(247), 1,
      anon_sym_LBRACE,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(269), 1,
      sym_record_body,
    STATE(344), 1,
      sym_value,
    STATE(440), 1,
      sym_parent_class_list,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(233), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(285), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(231), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [2788] = 5,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 6,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    ACTIONS(251), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [2824] = 9,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(266), 1,
      anon_sym_LBRACK,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(273), 1,
      anon_sym_DASH,
    STATE(52), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(259), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(261), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [2867] = 9,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    ACTIONS(285), 1,
      anon_sym_DOT,
    ACTIONS(288), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(291), 1,
      anon_sym_DASH,
    STATE(56), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(275), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(277), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [2910] = 18,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(294), 1,
      sym_var,
    ACTIONS(296), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(373), 1,
      sym_value,
    STATE(460), 1,
      sym_dag_arg,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [2971] = 9,
    ACTIONS(269), 1,
      anon_sym_DOT,
    ACTIONS(271), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(273), 1,
      anon_sym_DASH,
    ACTIONS(279), 1,
      anon_sym_LBRACE,
    ACTIONS(282), 1,
      anon_sym_LBRACK,
    STATE(56), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(275), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(277), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3014] = 9,
    ACTIONS(263), 1,
      anon_sym_LBRACE,
    ACTIONS(266), 1,
      anon_sym_LBRACK,
    ACTIONS(298), 1,
      anon_sym_DOT,
    ACTIONS(301), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(304), 1,
      anon_sym_DASH,
    STATE(50), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(259), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(261), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3057] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(80), 1,
      anon_sym_POUND,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(364), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(78), 2,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(233), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(285), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(231), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3116] = 18,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(294), 1,
      sym_var,
    ACTIONS(307), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(373), 1,
      sym_value,
    STATE(465), 1,
      sym_dag_arg,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3177] = 9,
    ACTIONS(313), 1,
      anon_sym_LBRACE,
    ACTIONS(316), 1,
      anon_sym_LBRACK,
    ACTIONS(319), 1,
      anon_sym_DOT,
    ACTIONS(322), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(325), 1,
      anon_sym_DASH,
    STATE(56), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(309), 6,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_BANG,
    ACTIONS(311), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [3220] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(328), 1,
      anon_sym_COMMA,
    ACTIONS(330), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(438), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3278] = 5,
    ACTIONS(334), 1,
      sym_string_string,
    STATE(87), 1,
      aux_sym__repeated_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(332), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(337), 9,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3312] = 17,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(294), 1,
      sym_var,
    ACTIONS(339), 1,
      sym_identifier,
    ACTIONS(343), 1,
      sym_string_string,
    ACTIONS(347), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      anon_sym_LBRACK,
    ACTIONS(351), 1,
      anon_sym_LPAREN,
    ACTIONS(353), 1,
      anon_sym_BANGcond,
    STATE(6), 1,
      sym__value_concat,
    STATE(55), 1,
      sym_dag_arg,
    STATE(58), 1,
      aux_sym__repeated_string,
    STATE(193), 1,
      sym_value,
    STATE(477), 1,
      sym_operator_keyword,
    ACTIONS(345), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(49), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(341), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3370] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(355), 1,
      anon_sym_COMMA,
    ACTIONS(357), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(376), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3428] = 13,
    ACTIONS(362), 1,
      anon_sym_RBRACE,
    ACTIONS(364), 1,
      anon_sym_field,
    ACTIONS(367), 1,
      anon_sym_code,
    ACTIONS(370), 1,
      anon_sym_let,
    ACTIONS(373), 1,
      anon_sym_defvar,
    ACTIONS(376), 1,
      anon_sym_assert,
    ACTIONS(379), 1,
      anon_sym_bits,
    ACTIONS(382), 1,
      anon_sym_list,
    STATE(505), 1,
      sym_type,
    STATE(61), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(276), 4,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
    ACTIONS(359), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [3478] = 4,
    ACTIONS(389), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(385), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(387), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3510] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(328), 1,
      anon_sym_COMMA,
    ACTIONS(330), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(347), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3568] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(391), 1,
      anon_sym_RBRACE,
    ACTIONS(393), 1,
      anon_sym_COMMA,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(357), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3626] = 4,
    ACTIONS(399), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(395), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(397), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3658] = 13,
    ACTIONS(43), 1,
      anon_sym_field,
    ACTIONS(45), 1,
      anon_sym_code,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(49), 1,
      anon_sym_defvar,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(401), 1,
      anon_sym_RBRACE,
    STATE(505), 1,
      sym_type,
    STATE(80), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(276), 4,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [3708] = 4,
    ACTIONS(403), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(332), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(337), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3740] = 17,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(294), 1,
      sym_var,
    ACTIONS(339), 1,
      sym_identifier,
    ACTIONS(343), 1,
      sym_string_string,
    ACTIONS(347), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      anon_sym_LBRACK,
    ACTIONS(351), 1,
      anon_sym_LPAREN,
    ACTIONS(353), 1,
      anon_sym_BANGcond,
    STATE(6), 1,
      sym__value_concat,
    STATE(51), 1,
      sym_dag_arg,
    STATE(58), 1,
      aux_sym__repeated_string,
    STATE(193), 1,
      sym_value,
    STATE(477), 1,
      sym_operator_keyword,
    ACTIONS(345), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(49), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(341), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3798] = 4,
    STATE(82), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(405), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(407), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3830] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(409), 1,
      anon_sym_COMMA,
    ACTIONS(411), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(359), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3888] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(237), 1,
      anon_sym_COLON,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(393), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    STATE(547), 1,
      sym_parent_class_list,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [3946] = 4,
    STATE(82), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(413), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(415), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [3978] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(294), 1,
      sym_var,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(373), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    STATE(487), 1,
      sym_dag_arg,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4036] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(41), 1,
      anon_sym_COMMA,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(417), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(351), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4094] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(237), 1,
      anon_sym_COLON,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(379), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    STATE(530), 1,
      sym_parent_class_list,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4152] = 4,
    ACTIONS(419), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(257), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(253), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4184] = 5,
    ACTIONS(421), 1,
      anon_sym_POUND,
    STATE(77), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(413), 8,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(415), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4218] = 13,
    ACTIONS(43), 1,
      anon_sym_field,
    ACTIONS(45), 1,
      anon_sym_code,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(49), 1,
      anon_sym_defvar,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(424), 1,
      anon_sym_RBRACE,
    STATE(505), 1,
      sym_type,
    STATE(61), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(276), 4,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [4268] = 4,
    ACTIONS(430), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(426), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(428), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4300] = 13,
    ACTIONS(43), 1,
      anon_sym_field,
    ACTIONS(45), 1,
      anon_sym_code,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(49), 1,
      anon_sym_defvar,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(432), 1,
      anon_sym_RBRACE,
    STATE(505), 1,
      sym_type,
    STATE(61), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(276), 4,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [4350] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_COMMA,
    ACTIONS(436), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(370), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4408] = 5,
    ACTIONS(442), 1,
      anon_sym_POUND,
    STATE(77), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(438), 8,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(440), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4442] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(445), 1,
      anon_sym_COMMA,
    ACTIONS(447), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(374), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4500] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(449), 1,
      anon_sym_COMMA,
    ACTIONS(451), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(348), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4558] = 13,
    ACTIONS(43), 1,
      anon_sym_field,
    ACTIONS(45), 1,
      anon_sym_code,
    ACTIONS(47), 1,
      anon_sym_let,
    ACTIONS(49), 1,
      anon_sym_defvar,
    ACTIONS(51), 1,
      anon_sym_assert,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(453), 1,
      anon_sym_RBRACE,
    STATE(505), 1,
      sym_type,
    STATE(78), 2,
      sym_body_item,
      aux_sym_record_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(276), 4,
      sym_instruction,
      sym_let_inst,
      sym_def_var,
      sym_assert,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [4608] = 17,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_COMMA,
    ACTIONS(436), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(395), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4666] = 5,
    ACTIONS(457), 1,
      sym_string_string,
    STATE(87), 1,
      aux_sym__repeated_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(455), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(460), 9,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4700] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(462), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4755] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(464), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(466), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4784] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(468), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(470), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [4813] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(472), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(367), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4868] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(472), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(369), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4923] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(474), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [4978] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(257), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(253), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5007] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(476), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5062] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(296), 1,
      anon_sym_GT,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(371), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5117] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(426), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(428), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5146] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(478), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(480), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5175] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(482), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5230] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(484), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(408), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5285] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(405), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(407), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5314] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(486), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(488), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5343] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(307), 1,
      anon_sym_GT,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(360), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5398] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(490), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(492), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5427] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(494), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5482] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(496), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(408), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5537] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(395), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(397), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5566] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(498), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5621] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(408), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5676] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(502), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(505), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5705] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(508), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5760] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(510), 1,
      anon_sym_GT,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(354), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5815] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(512), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(514), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5844] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(516), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(368), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [5899] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(518), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(520), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5928] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(522), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(524), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [5957] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(526), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6012] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(528), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(530), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6041] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(532), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(534), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6070] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(536), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(538), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6099] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(540), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(363), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6154] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(540), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(362), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6209] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(542), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6264] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(544), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6319] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(546), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6374] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(548), 1,
      anon_sym_GT,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(361), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6429] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(550), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6484] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(552), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(554), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6513] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(556), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(558), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6542] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(560), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(562), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6571] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(564), 1,
      anon_sym_GT,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(346), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6626] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(566), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(568), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6655] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(570), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(572), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6684] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(574), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(576), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6713] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(578), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(580), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6742] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(582), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6797] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6852] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(586), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(588), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6881] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(385), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(387), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6910] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(590), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [6965] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(592), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(594), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [6994] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(596), 1,
      anon_sym_RPAREN,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(408), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7049] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(598), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(600), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [7078] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(602), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(604), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [7107] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(606), 9,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_DASH,
      anon_sym_BANG,
    ACTIONS(608), 10,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
      anon_sym_DOT_DOT_DOT,
  [7136] = 16,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    ACTIONS(610), 1,
      anon_sym_RBRACK,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7191] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(403), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7243] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(426), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7295] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(469), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7347] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(405), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7399] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(416), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7451] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(353), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7503] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(386), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7555] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(387), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7607] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(396), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7659] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(454), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7711] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(377), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7763] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(448), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7815] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(461), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7867] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(202), 1,
      sym_value,
    STATE(220), 1,
      sym__value_concat,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(73), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(182), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(71), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7919] = 15,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(339), 1,
      sym_identifier,
    ACTIONS(343), 1,
      sym_string_string,
    ACTIONS(347), 1,
      anon_sym_LBRACE,
    ACTIONS(349), 1,
      anon_sym_LBRACK,
    ACTIONS(351), 1,
      anon_sym_LPAREN,
    ACTIONS(353), 1,
      anon_sym_BANGcond,
    STATE(6), 1,
      sym__value_concat,
    STATE(58), 1,
      aux_sym__repeated_string,
    STATE(69), 1,
      sym_value,
    STATE(477), 1,
      sym_operator_keyword,
    ACTIONS(614), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(53), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(612), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [7971] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(372), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8023] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(397), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8075] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(385), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8127] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(450), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8179] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(388), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8231] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(463), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8283] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(413), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8335] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(456), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8387] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(447), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8439] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(394), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8491] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(345), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8543] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(425), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8595] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(408), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8647] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(429), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8699] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(453), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8751] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(464), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8803] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(455), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8855] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(358), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8907] = 15,
    ACTIONS(33), 1,
      sym_string_string,
    ACTIONS(37), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(61), 1,
      anon_sym_LPAREN,
    ACTIONS(63), 1,
      anon_sym_BANGcond,
    ACTIONS(65), 1,
      anon_sym_BANG,
    ACTIONS(69), 1,
      sym_identifier,
    STATE(6), 1,
      sym__value_concat,
    STATE(183), 1,
      aux_sym__repeated_string,
    STATE(427), 1,
      sym_value,
    STATE(484), 1,
      sym_operator_keyword,
    ACTIONS(35), 2,
      sym_code_string,
      anon_sym_QMARK,
    STATE(195), 2,
      sym__simple_value,
      sym_operator,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(31), 3,
      sym_number,
      anon_sym_true,
      anon_sym_false,
  [8959] = 5,
    ACTIONS(616), 1,
      anon_sym_POUND,
    STATE(181), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(413), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(415), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [8990] = 8,
    ACTIONS(259), 1,
      anon_sym_POUND,
    ACTIONS(619), 1,
      anon_sym_LBRACE,
    ACTIONS(622), 1,
      anon_sym_LBRACK,
    ACTIONS(625), 1,
      anon_sym_DOT,
    ACTIONS(628), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(188), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(261), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [9027] = 5,
    ACTIONS(631), 1,
      sym_string_string,
    STATE(184), 1,
      aux_sym__repeated_string,
    ACTIONS(332), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(337), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9058] = 5,
    ACTIONS(633), 1,
      sym_string_string,
    STATE(184), 1,
      aux_sym__repeated_string,
    ACTIONS(455), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(460), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9089] = 5,
    ACTIONS(636), 1,
      anon_sym_POUND,
    STATE(181), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(438), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(440), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [9120] = 8,
    ACTIONS(309), 1,
      anon_sym_POUND,
    ACTIONS(639), 1,
      anon_sym_LBRACE,
    ACTIONS(642), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_DOT,
    ACTIONS(648), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(186), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(311), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [9157] = 5,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 6,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    ACTIONS(251), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [9188] = 8,
    ACTIONS(275), 1,
      anon_sym_POUND,
    ACTIONS(651), 1,
      anon_sym_LBRACE,
    ACTIONS(654), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_DOT,
    ACTIONS(660), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(186), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(277), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [9225] = 11,
    ACTIONS(663), 1,
      anon_sym_RBRACE,
    ACTIONS(665), 1,
      anon_sym_let,
    ACTIONS(668), 1,
      anon_sym_defvar,
    ACTIONS(671), 1,
      anon_sym_def,
    ACTIONS(674), 1,
      anon_sym_defm,
    ACTIONS(677), 1,
      anon_sym_foreach,
    ACTIONS(680), 1,
      anon_sym_if,
    ACTIONS(683), 1,
      anon_sym_assert,
    STATE(189), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(335), 7,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [9268] = 8,
    ACTIONS(275), 1,
      anon_sym_POUND,
    ACTIONS(686), 1,
      anon_sym_LBRACE,
    ACTIONS(688), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(186), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(277), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [9305] = 11,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    ACTIONS(694), 1,
      anon_sym_RBRACE,
    STATE(189), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(335), 7,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [9348] = 11,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    ACTIONS(696), 1,
      anon_sym_RBRACE,
    STATE(189), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(335), 7,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [9391] = 6,
    ACTIONS(702), 1,
      anon_sym_COLON,
    ACTIONS(704), 1,
      anon_sym_POUND,
    STATE(185), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(698), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(700), 8,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [9424] = 11,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    ACTIONS(706), 1,
      anon_sym_RBRACE,
    STATE(191), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(335), 7,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [9467] = 8,
    ACTIONS(259), 1,
      anon_sym_POUND,
    ACTIONS(686), 1,
      anon_sym_LBRACE,
    ACTIONS(688), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(692), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(190), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(261), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [9504] = 11,
    ACTIONS(142), 1,
      anon_sym_defvar,
    ACTIONS(144), 1,
      anon_sym_def,
    ACTIONS(148), 1,
      anon_sym_defm,
    ACTIONS(156), 1,
      anon_sym_assert,
    ACTIONS(164), 1,
      anon_sym_let,
    ACTIONS(166), 1,
      anon_sym_foreach,
    ACTIONS(168), 1,
      anon_sym_if,
    ACTIONS(708), 1,
      anon_sym_RBRACE,
    STATE(192), 2,
      sym_multiclass_statement,
      aux_sym_multiclass_body_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    STATE(335), 7,
      sym_def,
      sym_let,
      sym_defm,
      sym_defvar,
      sym_foreach,
      sym_if,
      sym_assert,
  [9547] = 4,
    STATE(185), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(413), 7,
      sym_number,
      sym_identifier,
      anon_sym_POUND,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(415), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [9576] = 4,
    ACTIONS(710), 1,
      anon_sym_LT,
    ACTIONS(385), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(387), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9604] = 4,
    STATE(206), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(413), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(415), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9632] = 4,
    ACTIONS(712), 1,
      anon_sym_LT,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9660] = 4,
    ACTIONS(714), 1,
      anon_sym_LT,
    ACTIONS(332), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(337), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9688] = 4,
    STATE(206), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(405), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(407), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9716] = 5,
    ACTIONS(413), 1,
      anon_sym_DOT,
    ACTIONS(716), 1,
      anon_sym_POUND,
    STATE(203), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(415), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9746] = 4,
    ACTIONS(719), 1,
      anon_sym_LT,
    ACTIONS(395), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(397), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9774] = 4,
    ACTIONS(721), 1,
      anon_sym_LT,
    ACTIONS(426), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(428), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9802] = 5,
    ACTIONS(438), 1,
      anon_sym_DOT,
    ACTIONS(723), 1,
      anon_sym_POUND,
    STATE(203), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(440), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9832] = 4,
    ACTIONS(726), 1,
      sym_string_string,
    ACTIONS(502), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(505), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9860] = 3,
    ACTIONS(552), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(554), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9885] = 3,
    ACTIONS(405), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(407), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9910] = 3,
    ACTIONS(486), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(488), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9935] = 3,
    ACTIONS(426), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(428), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9960] = 3,
    ACTIONS(598), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(600), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [9985] = 3,
    ACTIONS(574), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(576), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10010] = 3,
    ACTIONS(566), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(568), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10035] = 3,
    ACTIONS(532), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(534), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10060] = 3,
    ACTIONS(560), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(562), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10085] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(698), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(700), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [10110] = 3,
    ACTIONS(257), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(253), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10135] = 3,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(728), 6,
      sym_number,
      sym_identifier,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LBRACK,
      anon_sym_BANG,
    ACTIONS(730), 9,
      sym_string_string,
      sym_code_string,
      sym_var,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_QMARK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_BANGcond,
  [10160] = 3,
    ACTIONS(85), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(87), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10185] = 3,
    ACTIONS(602), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(604), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10210] = 3,
    ACTIONS(490), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(492), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10235] = 3,
    ACTIONS(395), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(397), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10260] = 3,
    ACTIONS(478), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(480), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10285] = 3,
    ACTIONS(570), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(572), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10310] = 3,
    ACTIONS(578), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(580), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10335] = 3,
    ACTIONS(468), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(470), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10360] = 3,
    ACTIONS(528), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(530), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10385] = 3,
    ACTIONS(586), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(588), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10410] = 3,
    ACTIONS(464), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(466), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10435] = 3,
    ACTIONS(385), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(387), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10460] = 3,
    ACTIONS(522), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(524), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10485] = 3,
    ACTIONS(518), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(520), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10510] = 3,
    ACTIONS(592), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(594), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10535] = 3,
    ACTIONS(556), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(558), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10560] = 3,
    ACTIONS(606), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(608), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10585] = 3,
    ACTIONS(512), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(514), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10610] = 3,
    ACTIONS(536), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(538), 13,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [10635] = 3,
    ACTIONS(734), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(732), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10659] = 3,
    ACTIONS(738), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(736), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10683] = 3,
    ACTIONS(742), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(740), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10707] = 3,
    ACTIONS(746), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(744), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10731] = 3,
    ACTIONS(750), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(748), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10755] = 3,
    ACTIONS(754), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(752), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10779] = 3,
    ACTIONS(758), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(756), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10803] = 3,
    ACTIONS(762), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(760), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10827] = 3,
    ACTIONS(766), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(764), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10851] = 3,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(251), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10875] = 3,
    ACTIONS(770), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(768), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10899] = 3,
    ACTIONS(774), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(772), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10923] = 3,
    ACTIONS(778), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(776), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10947] = 3,
    ACTIONS(782), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(780), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10971] = 3,
    ACTIONS(786), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(784), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [10995] = 3,
    ACTIONS(790), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(788), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11019] = 3,
    ACTIONS(794), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(792), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11043] = 3,
    ACTIONS(798), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(796), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11067] = 3,
    ACTIONS(802), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(800), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11091] = 3,
    ACTIONS(806), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(804), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11115] = 3,
    ACTIONS(810), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(808), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11139] = 3,
    ACTIONS(814), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(812), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11163] = 3,
    ACTIONS(818), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(816), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11187] = 3,
    ACTIONS(822), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(820), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11211] = 3,
    ACTIONS(826), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(824), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11235] = 3,
    ACTIONS(830), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(828), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11259] = 3,
    ACTIONS(834), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(832), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11283] = 4,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(840), 1,
      anon_sym_else,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 12,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_assert,
  [11309] = 3,
    ACTIONS(844), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(842), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11333] = 3,
    ACTIONS(848), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(846), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11357] = 3,
    ACTIONS(852), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(850), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11381] = 3,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11405] = 3,
    ACTIONS(856), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(854), 13,
      ts_builtin_sym_end,
      anon_sym_include,
      anon_sym_RBRACE,
      anon_sym_class,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_multiclass,
      anon_sym_defm,
      anon_sym_defset,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11429] = 3,
    ACTIONS(860), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(858), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11452] = 3,
    ACTIONS(864), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(862), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11475] = 3,
    ACTIONS(868), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(866), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11498] = 3,
    ACTIONS(872), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(870), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11521] = 3,
    ACTIONS(876), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(874), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11544] = 3,
    ACTIONS(880), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(878), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11567] = 3,
    ACTIONS(884), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(882), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11590] = 3,
    ACTIONS(888), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(886), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11613] = 3,
    ACTIONS(892), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(890), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11636] = 3,
    ACTIONS(896), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(894), 12,
      sym_identifier,
      anon_sym_field,
      anon_sym_code,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_assert,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
      anon_sym_bits,
      anon_sym_list,
  [11659] = 4,
    ACTIONS(898), 1,
      anon_sym_POUND,
    STATE(282), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(415), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [11682] = 4,
    ACTIONS(901), 1,
      anon_sym_POUND,
    STATE(282), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(440), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [11705] = 4,
    ACTIONS(413), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(415), 9,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_SEMI,
      anon_sym_in,
      anon_sym_then,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
  [11728] = 8,
    ACTIONS(259), 1,
      anon_sym_POUND,
    ACTIONS(619), 1,
      anon_sym_LBRACE,
    ACTIONS(688), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(261), 2,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(692), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(286), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [11758] = 8,
    ACTIONS(275), 1,
      anon_sym_POUND,
    ACTIONS(651), 1,
      anon_sym_LBRACE,
    ACTIONS(688), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_DOT,
    ACTIONS(277), 2,
      anon_sym_COLON,
      anon_sym_SEMI,
    ACTIONS(692), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
    STATE(186), 2,
      sym_value_suffix,
      aux_sym_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [11788] = 5,
    ACTIONS(714), 1,
      anon_sym_LT,
    ACTIONS(904), 1,
      sym_identifier,
    ACTIONS(332), 2,
      anon_sym_POUND,
      anon_sym_DOT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(337), 6,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DASH,
  [11812] = 7,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(906), 1,
      anon_sym_GT,
    STATE(428), 1,
      sym_template_arg,
    STATE(497), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [11840] = 3,
    ACTIONS(826), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(824), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11859] = 3,
    ACTIONS(848), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(846), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11878] = 3,
    ACTIONS(750), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(748), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11897] = 3,
    ACTIONS(746), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(744), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11916] = 6,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(485), 1,
      sym_template_arg,
    STATE(497), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [11941] = 6,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    ACTIONS(908), 1,
      anon_sym_code,
    STATE(513), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [11966] = 3,
    ACTIONS(810), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(808), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [11985] = 3,
    ACTIONS(798), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(796), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12004] = 3,
    ACTIONS(794), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(792), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12023] = 3,
    ACTIONS(786), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(784), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12042] = 3,
    ACTIONS(814), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(812), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12061] = 3,
    ACTIONS(774), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(772), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12080] = 3,
    ACTIONS(818), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(816), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12099] = 3,
    ACTIONS(255), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(251), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12118] = 3,
    ACTIONS(856), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(854), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12137] = 3,
    ACTIONS(738), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(736), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12156] = 3,
    ACTIONS(834), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(832), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12175] = 3,
    ACTIONS(844), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(842), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12194] = 4,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(910), 1,
      anon_sym_else,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 7,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_assert,
  [12215] = 3,
    ACTIONS(830), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(828), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12234] = 3,
    ACTIONS(806), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(804), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12253] = 3,
    ACTIONS(734), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(732), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12272] = 3,
    ACTIONS(762), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(760), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12291] = 3,
    ACTIONS(758), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(756), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12310] = 3,
    ACTIONS(822), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(820), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12329] = 3,
    ACTIONS(838), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(836), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12348] = 3,
    ACTIONS(802), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(800), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12367] = 3,
    ACTIONS(754), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(752), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12386] = 3,
    ACTIONS(766), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(764), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12405] = 3,
    ACTIONS(742), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(740), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12424] = 3,
    ACTIONS(770), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(768), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12443] = 3,
    ACTIONS(782), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(780), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12462] = 3,
    ACTIONS(790), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(788), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12481] = 3,
    ACTIONS(852), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(850), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12500] = 3,
    ACTIONS(229), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(227), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12519] = 3,
    ACTIONS(778), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(776), 8,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_else,
      anon_sym_assert,
  [12538] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(510), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12560] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(527), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12582] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(522), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12604] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(538), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12626] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(521), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12648] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(495), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12670] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(556), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12692] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(545), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12714] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(535), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12736] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(514), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12758] = 3,
    ACTIONS(914), 1,
      anon_sym_def,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(912), 7,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_defvar,
      anon_sym_defm,
      anon_sym_foreach,
      anon_sym_if,
      anon_sym_assert,
  [12776] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(554), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12798] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(501), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12820] = 5,
    ACTIONS(55), 1,
      anon_sym_bits,
    ACTIONS(57), 1,
      anon_sym_list,
    STATE(498), 1,
      sym_type,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(53), 5,
      sym_identifier,
      anon_sym_bit,
      anon_sym_int,
      anon_sym_string,
      anon_sym_dag,
  [12842] = 8,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    ACTIONS(918), 1,
      anon_sym_POUND,
    STATE(318), 1,
      sym_record_body,
    STATE(356), 1,
      aux_sym__value_concat_repeat1,
    STATE(400), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [12869] = 8,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    ACTIONS(920), 1,
      anon_sym_LT,
    STATE(324), 1,
      sym_record_body,
    STATE(352), 1,
      sym_template_args,
    STATE(437), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [12896] = 8,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    ACTIONS(920), 1,
      anon_sym_LT,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(251), 1,
      sym_record_body,
    STATE(366), 1,
      sym_template_args,
    STATE(472), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [12923] = 8,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(920), 1,
      anon_sym_LT,
    ACTIONS(924), 1,
      anon_sym_LBRACE,
    ACTIONS(926), 1,
      anon_sym_SEMI,
    STATE(311), 1,
      sym_multiclass_body,
    STATE(349), 1,
      sym_template_args,
    STATE(399), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [12950] = 8,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(920), 1,
      anon_sym_LT,
    ACTIONS(928), 1,
      anon_sym_LBRACE,
    ACTIONS(930), 1,
      anon_sym_SEMI,
    STATE(246), 1,
      sym_multiclass_body,
    STATE(355), 1,
      sym_template_args,
    STATE(414), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [12977] = 8,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    ACTIONS(918), 1,
      anon_sym_POUND,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(241), 1,
      sym_record_body,
    STATE(356), 1,
      aux_sym__value_concat_repeat1,
    STATE(409), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13004] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(932), 4,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_RBRACK,
  [13022] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(938), 1,
      anon_sym_GT,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(424), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13043] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(940), 1,
      anon_sym_COMMA,
    ACTIONS(942), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(458), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13064] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(944), 1,
      anon_sym_COMMA,
    ACTIONS(946), 1,
      anon_sym_RBRACK,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(467), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13085] = 6,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(924), 1,
      anon_sym_LBRACE,
    ACTIONS(926), 1,
      anon_sym_SEMI,
    STATE(313), 1,
      sym_multiclass_body,
    STATE(404), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13106] = 5,
    ACTIONS(950), 1,
      anon_sym_LT,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(384), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(948), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13125] = 6,
    ACTIONS(307), 1,
      anon_sym_RBRACE,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(954), 1,
      anon_sym_COMMA,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(470), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13146] = 6,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(300), 1,
      sym_record_body,
    STATE(398), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13167] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(956), 1,
      anon_sym_COMMA,
    ACTIONS(958), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(420), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13188] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(962), 1,
      anon_sym_GT,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(446), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13209] = 6,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(928), 1,
      anon_sym_LBRACE,
    ACTIONS(930), 1,
      anon_sym_SEMI,
    STATE(262), 1,
      sym_multiclass_body,
    STATE(462), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13230] = 4,
    ACTIONS(964), 1,
      anon_sym_POUND,
    STATE(365), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(440), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [13247] = 6,
    ACTIONS(296), 1,
      anon_sym_RBRACE,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(967), 1,
      anon_sym_COMMA,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(457), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13268] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(969), 3,
      anon_sym_COMMA,
      anon_sym_GT,
      anon_sym_RPAREN,
  [13285] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(971), 1,
      anon_sym_COMMA,
    ACTIONS(973), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(412), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13306] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(975), 1,
      anon_sym_GT,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(445), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13327] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(977), 1,
      anon_sym_GT,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(410), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13348] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(979), 1,
      anon_sym_RBRACK,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(473), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13369] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(979), 1,
      anon_sym_RBRACE,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(474), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13390] = 4,
    ACTIONS(413), 1,
      anon_sym_POUND,
    STATE(356), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(415), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [13407] = 4,
    ACTIONS(981), 1,
      anon_sym_POUND,
    STATE(365), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(415), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [13424] = 6,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      sym_record_body,
    STATE(434), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13445] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(984), 1,
      anon_sym_RBRACE,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(441), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13466] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(986), 1,
      anon_sym_RBRACE,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(418), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13487] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(984), 1,
      anon_sym_RBRACK,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(439), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13508] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(988), 1,
      anon_sym_COMMA,
    ACTIONS(990), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(436), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13529] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(992), 1,
      anon_sym_GT,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(471), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13550] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(994), 1,
      anon_sym_COMMA,
    ACTIONS(996), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(415), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13571] = 5,
    ACTIONS(702), 1,
      anon_sym_COLON,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(700), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13590] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(998), 1,
      anon_sym_COMMA,
    ACTIONS(1000), 1,
      anon_sym_RPAREN,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(406), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13611] = 4,
    ACTIONS(1002), 1,
      anon_sym_COMMA,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(932), 3,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_RBRACK,
  [13628] = 6,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1005), 1,
      anon_sym_COMMA,
    ACTIONS(1007), 1,
      anon_sym_RBRACK,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(459), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13649] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1009), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13665] = 4,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(390), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1011), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13681] = 5,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(496), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13699] = 3,
    ACTIONS(1015), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1013), 3,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [13713] = 4,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(391), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1017), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13729] = 4,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(383), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1019), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13745] = 4,
    ACTIONS(1023), 1,
      anon_sym_COMMA,
    STATE(383), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1021), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13761] = 4,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(383), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1026), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13777] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1028), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13793] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1030), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13809] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1032), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13825] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1034), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13841] = 4,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(382), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1036), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13857] = 4,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(383), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1038), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13873] = 4,
    ACTIONS(952), 1,
      anon_sym_COMMA,
    STATE(383), 1,
      aux_sym_parent_class_list_repeat2,
    ACTIONS(1040), 2,
      anon_sym_LBRACE,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13889] = 4,
    ACTIONS(1042), 1,
      anon_sym_COMMA,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(1045), 2,
      anon_sym_GT,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13905] = 5,
    ACTIONS(237), 1,
      anon_sym_COLON,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    STATE(529), 1,
      sym_parent_class_list,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13923] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(1047), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13939] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1049), 1,
      anon_sym_COLON,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13954] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1051), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13969] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1053), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13984] = 4,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(290), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [13999] = 4,
    ACTIONS(924), 1,
      anon_sym_LBRACE,
    ACTIONS(926), 1,
      anon_sym_SEMI,
    STATE(313), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14014] = 4,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(296), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14029] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1055), 3,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [14040] = 4,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(318), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14055] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1057), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14070] = 4,
    ACTIONS(924), 1,
      anon_sym_LBRACE,
    ACTIONS(926), 1,
      anon_sym_SEMI,
    STATE(291), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14085] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1059), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14100] = 4,
    ACTIONS(1061), 1,
      anon_sym_COMMA,
    ACTIONS(1063), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14115] = 4,
    ACTIONS(1065), 1,
      anon_sym_COMMA,
    ACTIONS(1068), 1,
      anon_sym_RPAREN,
    STATE(407), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14130] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1070), 1,
      anon_sym_COLON,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14145] = 4,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(256), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14160] = 4,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(1072), 1,
      anon_sym_GT,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14175] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1074), 3,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [14186] = 4,
    ACTIONS(1076), 1,
      anon_sym_COMMA,
    ACTIONS(1078), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14201] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1080), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14216] = 4,
    ACTIONS(928), 1,
      anon_sym_LBRACE,
    ACTIONS(930), 1,
      anon_sym_SEMI,
    STATE(262), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14231] = 4,
    ACTIONS(1082), 1,
      anon_sym_COMMA,
    ACTIONS(1084), 1,
      anon_sym_RPAREN,
    STATE(407), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14246] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1086), 1,
      anon_sym_in,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14261] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1088), 3,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [14272] = 4,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(1090), 1,
      anon_sym_RBRACE,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14287] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1094), 1,
      anon_sym_in,
    STATE(444), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14302] = 4,
    ACTIONS(1096), 1,
      anon_sym_COMMA,
    ACTIONS(1098), 1,
      anon_sym_RPAREN,
    STATE(407), 1,
      aux_sym_operator_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14317] = 4,
    ACTIONS(1100), 1,
      anon_sym_COMMA,
    ACTIONS(1103), 1,
      anon_sym_RPAREN,
    STATE(421), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14332] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1105), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [14343] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1107), 1,
      anon_sym_in,
    STATE(419), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14358] = 4,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(1109), 1,
      anon_sym_GT,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14373] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1111), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14388] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1113), 1,
      anon_sym_in,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14403] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1115), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14418] = 4,
    ACTIONS(1117), 1,
      anon_sym_COMMA,
    ACTIONS(1119), 1,
      anon_sym_GT,
    STATE(451), 1,
      aux_sym_template_args_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14433] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1121), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14448] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1123), 1,
      anon_sym_in,
    STATE(444), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14463] = 4,
    ACTIONS(1125), 1,
      anon_sym_COMMA,
    ACTIONS(1128), 1,
      anon_sym_GT,
    STATE(431), 1,
      aux_sym_template_args_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14478] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1130), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [14489] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1132), 1,
      anon_sym_in,
    STATE(430), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14504] = 4,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(268), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14519] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1134), 1,
      anon_sym_in,
    STATE(468), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14534] = 4,
    ACTIONS(1136), 1,
      anon_sym_COMMA,
    ACTIONS(1138), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14549] = 4,
    ACTIONS(239), 1,
      anon_sym_SEMI,
    ACTIONS(916), 1,
      anon_sym_LBRACE,
    STATE(300), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14564] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1140), 1,
      anon_sym_COLON,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14579] = 4,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(1142), 1,
      anon_sym_RBRACK,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14594] = 4,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(241), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14609] = 4,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(1142), 1,
      anon_sym_RBRACE,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14624] = 4,
    ACTIONS(498), 1,
      anon_sym_RPAREN,
    ACTIONS(1144), 1,
      anon_sym_COMMA,
    STATE(421), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14639] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1146), 1,
      anon_sym_in,
    STATE(466), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14654] = 4,
    ACTIONS(1148), 1,
      anon_sym_COMMA,
    ACTIONS(1151), 1,
      anon_sym_in,
    STATE(444), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14669] = 4,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(1153), 1,
      anon_sym_GT,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14684] = 4,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(1155), 1,
      anon_sym_GT,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14699] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1157), 1,
      anon_sym_COMMA,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14714] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1159), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14729] = 3,
    ACTIONS(1163), 1,
      anon_sym_EQ,
    ACTIONS(1161), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14742] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1165), 1,
      anon_sym_then,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14757] = 4,
    ACTIONS(1117), 1,
      anon_sym_COMMA,
    ACTIONS(1167), 1,
      anon_sym_GT,
    STATE(431), 1,
      aux_sym_template_args_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14772] = 2,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
    ACTIONS(1169), 3,
      anon_sym_LBRACE,
      anon_sym_COLON,
      anon_sym_SEMI,
  [14783] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1171), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14798] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1173), 1,
      anon_sym_SEMI,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14813] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1175), 1,
      anon_sym_in,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14828] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1177), 1,
      anon_sym_then,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14843] = 4,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    ACTIONS(1179), 1,
      anon_sym_COMMA,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14858] = 4,
    ACTIONS(1181), 1,
      anon_sym_COMMA,
    ACTIONS(1183), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14873] = 4,
    ACTIONS(610), 1,
      anon_sym_RBRACK,
    ACTIONS(1185), 1,
      anon_sym_COMMA,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14888] = 4,
    ACTIONS(584), 1,
      anon_sym_RPAREN,
    ACTIONS(1144), 1,
      anon_sym_COMMA,
    STATE(475), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14903] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1187), 1,
      anon_sym_in,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14918] = 4,
    ACTIONS(928), 1,
      anon_sym_LBRACE,
    ACTIONS(930), 1,
      anon_sym_SEMI,
    STATE(243), 1,
      sym_multiclass_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14933] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1189), 1,
      anon_sym_then,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14948] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1191), 1,
      anon_sym_COMMA,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14963] = 4,
    ACTIONS(550), 1,
      anon_sym_RPAREN,
    ACTIONS(1144), 1,
      anon_sym_COMMA,
    STATE(442), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14978] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1193), 1,
      anon_sym_in,
    STATE(444), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [14993] = 4,
    ACTIONS(582), 1,
      anon_sym_RBRACK,
    ACTIONS(1195), 1,
      anon_sym_COMMA,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15008] = 4,
    ACTIONS(1092), 1,
      anon_sym_COMMA,
    ACTIONS(1197), 1,
      anon_sym_in,
    STATE(444), 1,
      aux_sym_let_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15023] = 4,
    ACTIONS(934), 1,
      anon_sym_POUND,
    ACTIONS(1199), 1,
      anon_sym_then,
    STATE(283), 1,
      aux_sym__value_concat_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15038] = 4,
    ACTIONS(550), 1,
      anon_sym_RBRACE,
    ACTIONS(1201), 1,
      anon_sym_COMMA,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15053] = 4,
    ACTIONS(936), 1,
      anon_sym_COMMA,
    ACTIONS(1203), 1,
      anon_sym_GT,
    STATE(392), 1,
      aux_sym_parent_class_list_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15068] = 4,
    ACTIONS(249), 1,
      anon_sym_SEMI,
    ACTIONS(922), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      sym_record_body,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15083] = 4,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(1205), 1,
      anon_sym_RBRACK,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15098] = 4,
    ACTIONS(960), 1,
      anon_sym_COMMA,
    ACTIONS(1205), 1,
      anon_sym_RBRACE,
    STATE(375), 1,
      aux_sym_let_inst_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15113] = 4,
    ACTIONS(546), 1,
      anon_sym_RPAREN,
    ACTIONS(1144), 1,
      anon_sym_COMMA,
    STATE(421), 1,
      aux_sym__simple_value_repeat1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15128] = 3,
    ACTIONS(1207), 1,
      anon_sym_LBRACE,
    ACTIONS(1209), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15140] = 3,
    ACTIONS(1211), 1,
      anon_sym_LT,
    ACTIONS(1213), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15152] = 3,
    ACTIONS(1215), 1,
      anon_sym_EQ,
    ACTIONS(1217), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15164] = 2,
    ACTIONS(904), 2,
      sym_identifier,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15174] = 3,
    ACTIONS(1219), 1,
      sym_identifier,
    STATE(483), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15186] = 3,
    ACTIONS(1219), 1,
      sym_identifier,
    STATE(443), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15198] = 3,
    ACTIONS(1221), 1,
      anon_sym_EQ,
    ACTIONS(1223), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15210] = 2,
    ACTIONS(1151), 2,
      anon_sym_COMMA,
      anon_sym_in,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15220] = 3,
    ACTIONS(1225), 1,
      anon_sym_LT,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15232] = 2,
    ACTIONS(1229), 2,
      anon_sym_COMMA,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15242] = 3,
    ACTIONS(1231), 1,
      anon_sym_LT,
    ACTIONS(1233), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15254] = 2,
    ACTIONS(1103), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15264] = 2,
    ACTIONS(1235), 2,
      sym_identifier,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15274] = 3,
    ACTIONS(1219), 1,
      sym_identifier,
    STATE(423), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15286] = 3,
    ACTIONS(1219), 1,
      sym_identifier,
    STATE(433), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15298] = 3,
    ACTIONS(1219), 1,
      sym_identifier,
    STATE(435), 1,
      sym_let_item,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15310] = 2,
    ACTIONS(1237), 2,
      anon_sym_LT,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15320] = 2,
    ACTIONS(296), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15329] = 2,
    ACTIONS(1239), 1,
      sym_number,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15338] = 2,
    ACTIONS(1241), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15347] = 2,
    ACTIONS(1243), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15356] = 2,
    ACTIONS(1245), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15365] = 2,
    ACTIONS(1247), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15374] = 2,
    ACTIONS(472), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15383] = 2,
    ACTIONS(1249), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15392] = 2,
    ACTIONS(1251), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15401] = 2,
    ACTIONS(946), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15410] = 2,
    ACTIONS(1253), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15419] = 2,
    ACTIONS(1255), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15428] = 2,
    ACTIONS(1257), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15437] = 2,
    ACTIONS(307), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15446] = 2,
    ACTIONS(1259), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15455] = 2,
    ACTIONS(1261), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15464] = 2,
    ACTIONS(1263), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15473] = 2,
    ACTIONS(1265), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15482] = 2,
    ACTIONS(1267), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15491] = 2,
    ACTIONS(1269), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15500] = 2,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15509] = 2,
    ACTIONS(546), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15518] = 2,
    ACTIONS(1273), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15527] = 2,
    ACTIONS(1275), 1,
      sym_string_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15536] = 2,
    ACTIONS(1277), 1,
      sym_var,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15545] = 2,
    ACTIONS(1279), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15554] = 2,
    ACTIONS(1281), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15563] = 2,
    ACTIONS(1283), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15572] = 2,
    ACTIONS(1285), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15581] = 2,
    ACTIONS(1287), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15590] = 2,
    ACTIONS(1289), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15599] = 2,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15608] = 2,
    ACTIONS(1293), 1,
      anon_sym_LT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15617] = 2,
    ACTIONS(1295), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15626] = 2,
    ACTIONS(1297), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15635] = 2,
    ACTIONS(1299), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15644] = 2,
    ACTIONS(1301), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15653] = 2,
    ACTIONS(1303), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15662] = 2,
    ACTIONS(1305), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15671] = 2,
    ACTIONS(1307), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15680] = 2,
    ACTIONS(540), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15689] = 2,
    ACTIONS(1309), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15698] = 2,
    ACTIONS(498), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15707] = 2,
    ACTIONS(1311), 1,
      aux_sym_operator_keyword_token1,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15716] = 2,
    ACTIONS(1007), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15725] = 2,
    ACTIONS(1313), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15734] = 2,
    ACTIONS(1315), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15743] = 2,
    ACTIONS(1317), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15752] = 2,
    ACTIONS(1319), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15761] = 2,
    ACTIONS(1321), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15770] = 2,
    ACTIONS(1323), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15779] = 2,
    ACTIONS(1325), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15788] = 2,
    ACTIONS(1327), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15797] = 2,
    ACTIONS(1329), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15806] = 2,
    ACTIONS(1331), 1,
      anon_sym_SEMI,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15815] = 2,
    ACTIONS(1333), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15824] = 2,
    ACTIONS(1335), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15833] = 2,
    ACTIONS(1337), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15842] = 2,
    ACTIONS(1339), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15851] = 2,
    ACTIONS(1341), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15860] = 2,
    ACTIONS(1343), 1,
      sym_string_string,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15869] = 2,
    ACTIONS(1345), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15878] = 2,
    ACTIONS(1347), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15887] = 2,
    ACTIONS(1349), 1,
      anon_sym_GT,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15896] = 2,
    ACTIONS(1351), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15905] = 2,
    ACTIONS(1353), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15914] = 2,
    ACTIONS(1355), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15923] = 2,
    ACTIONS(1357), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15932] = 2,
    ACTIONS(1359), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15941] = 2,
    ACTIONS(1361), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15950] = 2,
    ACTIONS(1363), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15959] = 2,
    ACTIONS(1365), 1,
      anon_sym_EQ,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
  [15968] = 2,
    ACTIONS(1367), 1,
      sym_identifier,
    ACTIONS(3), 3,
      sym_multiline_comment,
      sym_comment,
      sym_preprocessor,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 98,
  [SMALL_STATE(4)] = 196,
  [SMALL_STATE(5)] = 265,
  [SMALL_STATE(6)] = 331,
  [SMALL_STATE(7)] = 367,
  [SMALL_STATE(8)] = 427,
  [SMALL_STATE(9)] = 486,
  [SMALL_STATE(10)] = 545,
  [SMALL_STATE(11)] = 606,
  [SMALL_STATE(12)] = 665,
  [SMALL_STATE(13)] = 724,
  [SMALL_STATE(14)] = 783,
  [SMALL_STATE(15)] = 844,
  [SMALL_STATE(16)] = 903,
  [SMALL_STATE(17)] = 962,
  [SMALL_STATE(18)] = 1021,
  [SMALL_STATE(19)] = 1082,
  [SMALL_STATE(20)] = 1141,
  [SMALL_STATE(21)] = 1200,
  [SMALL_STATE(22)] = 1259,
  [SMALL_STATE(23)] = 1320,
  [SMALL_STATE(24)] = 1379,
  [SMALL_STATE(25)] = 1440,
  [SMALL_STATE(26)] = 1501,
  [SMALL_STATE(27)] = 1562,
  [SMALL_STATE(28)] = 1621,
  [SMALL_STATE(29)] = 1684,
  [SMALL_STATE(30)] = 1743,
  [SMALL_STATE(31)] = 1804,
  [SMALL_STATE(32)] = 1863,
  [SMALL_STATE(33)] = 1922,
  [SMALL_STATE(34)] = 1983,
  [SMALL_STATE(35)] = 2044,
  [SMALL_STATE(36)] = 2103,
  [SMALL_STATE(37)] = 2161,
  [SMALL_STATE(38)] = 2219,
  [SMALL_STATE(39)] = 2277,
  [SMALL_STATE(40)] = 2335,
  [SMALL_STATE(41)] = 2393,
  [SMALL_STATE(42)] = 2451,
  [SMALL_STATE(43)] = 2509,
  [SMALL_STATE(44)] = 2567,
  [SMALL_STATE(45)] = 2600,
  [SMALL_STATE(46)] = 2664,
  [SMALL_STATE(47)] = 2724,
  [SMALL_STATE(48)] = 2788,
  [SMALL_STATE(49)] = 2824,
  [SMALL_STATE(50)] = 2867,
  [SMALL_STATE(51)] = 2910,
  [SMALL_STATE(52)] = 2971,
  [SMALL_STATE(53)] = 3014,
  [SMALL_STATE(54)] = 3057,
  [SMALL_STATE(55)] = 3116,
  [SMALL_STATE(56)] = 3177,
  [SMALL_STATE(57)] = 3220,
  [SMALL_STATE(58)] = 3278,
  [SMALL_STATE(59)] = 3312,
  [SMALL_STATE(60)] = 3370,
  [SMALL_STATE(61)] = 3428,
  [SMALL_STATE(62)] = 3478,
  [SMALL_STATE(63)] = 3510,
  [SMALL_STATE(64)] = 3568,
  [SMALL_STATE(65)] = 3626,
  [SMALL_STATE(66)] = 3658,
  [SMALL_STATE(67)] = 3708,
  [SMALL_STATE(68)] = 3740,
  [SMALL_STATE(69)] = 3798,
  [SMALL_STATE(70)] = 3830,
  [SMALL_STATE(71)] = 3888,
  [SMALL_STATE(72)] = 3946,
  [SMALL_STATE(73)] = 3978,
  [SMALL_STATE(74)] = 4036,
  [SMALL_STATE(75)] = 4094,
  [SMALL_STATE(76)] = 4152,
  [SMALL_STATE(77)] = 4184,
  [SMALL_STATE(78)] = 4218,
  [SMALL_STATE(79)] = 4268,
  [SMALL_STATE(80)] = 4300,
  [SMALL_STATE(81)] = 4350,
  [SMALL_STATE(82)] = 4408,
  [SMALL_STATE(83)] = 4442,
  [SMALL_STATE(84)] = 4500,
  [SMALL_STATE(85)] = 4558,
  [SMALL_STATE(86)] = 4608,
  [SMALL_STATE(87)] = 4666,
  [SMALL_STATE(88)] = 4700,
  [SMALL_STATE(89)] = 4755,
  [SMALL_STATE(90)] = 4784,
  [SMALL_STATE(91)] = 4813,
  [SMALL_STATE(92)] = 4868,
  [SMALL_STATE(93)] = 4923,
  [SMALL_STATE(94)] = 4978,
  [SMALL_STATE(95)] = 5007,
  [SMALL_STATE(96)] = 5062,
  [SMALL_STATE(97)] = 5117,
  [SMALL_STATE(98)] = 5146,
  [SMALL_STATE(99)] = 5175,
  [SMALL_STATE(100)] = 5230,
  [SMALL_STATE(101)] = 5285,
  [SMALL_STATE(102)] = 5314,
  [SMALL_STATE(103)] = 5343,
  [SMALL_STATE(104)] = 5398,
  [SMALL_STATE(105)] = 5427,
  [SMALL_STATE(106)] = 5482,
  [SMALL_STATE(107)] = 5537,
  [SMALL_STATE(108)] = 5566,
  [SMALL_STATE(109)] = 5621,
  [SMALL_STATE(110)] = 5676,
  [SMALL_STATE(111)] = 5705,
  [SMALL_STATE(112)] = 5760,
  [SMALL_STATE(113)] = 5815,
  [SMALL_STATE(114)] = 5844,
  [SMALL_STATE(115)] = 5899,
  [SMALL_STATE(116)] = 5928,
  [SMALL_STATE(117)] = 5957,
  [SMALL_STATE(118)] = 6012,
  [SMALL_STATE(119)] = 6041,
  [SMALL_STATE(120)] = 6070,
  [SMALL_STATE(121)] = 6099,
  [SMALL_STATE(122)] = 6154,
  [SMALL_STATE(123)] = 6209,
  [SMALL_STATE(124)] = 6264,
  [SMALL_STATE(125)] = 6319,
  [SMALL_STATE(126)] = 6374,
  [SMALL_STATE(127)] = 6429,
  [SMALL_STATE(128)] = 6484,
  [SMALL_STATE(129)] = 6513,
  [SMALL_STATE(130)] = 6542,
  [SMALL_STATE(131)] = 6571,
  [SMALL_STATE(132)] = 6626,
  [SMALL_STATE(133)] = 6655,
  [SMALL_STATE(134)] = 6684,
  [SMALL_STATE(135)] = 6713,
  [SMALL_STATE(136)] = 6742,
  [SMALL_STATE(137)] = 6797,
  [SMALL_STATE(138)] = 6852,
  [SMALL_STATE(139)] = 6881,
  [SMALL_STATE(140)] = 6910,
  [SMALL_STATE(141)] = 6965,
  [SMALL_STATE(142)] = 6994,
  [SMALL_STATE(143)] = 7049,
  [SMALL_STATE(144)] = 7078,
  [SMALL_STATE(145)] = 7107,
  [SMALL_STATE(146)] = 7136,
  [SMALL_STATE(147)] = 7191,
  [SMALL_STATE(148)] = 7243,
  [SMALL_STATE(149)] = 7295,
  [SMALL_STATE(150)] = 7347,
  [SMALL_STATE(151)] = 7399,
  [SMALL_STATE(152)] = 7451,
  [SMALL_STATE(153)] = 7503,
  [SMALL_STATE(154)] = 7555,
  [SMALL_STATE(155)] = 7607,
  [SMALL_STATE(156)] = 7659,
  [SMALL_STATE(157)] = 7711,
  [SMALL_STATE(158)] = 7763,
  [SMALL_STATE(159)] = 7815,
  [SMALL_STATE(160)] = 7867,
  [SMALL_STATE(161)] = 7919,
  [SMALL_STATE(162)] = 7971,
  [SMALL_STATE(163)] = 8023,
  [SMALL_STATE(164)] = 8075,
  [SMALL_STATE(165)] = 8127,
  [SMALL_STATE(166)] = 8179,
  [SMALL_STATE(167)] = 8231,
  [SMALL_STATE(168)] = 8283,
  [SMALL_STATE(169)] = 8335,
  [SMALL_STATE(170)] = 8387,
  [SMALL_STATE(171)] = 8439,
  [SMALL_STATE(172)] = 8491,
  [SMALL_STATE(173)] = 8543,
  [SMALL_STATE(174)] = 8595,
  [SMALL_STATE(175)] = 8647,
  [SMALL_STATE(176)] = 8699,
  [SMALL_STATE(177)] = 8751,
  [SMALL_STATE(178)] = 8803,
  [SMALL_STATE(179)] = 8855,
  [SMALL_STATE(180)] = 8907,
  [SMALL_STATE(181)] = 8959,
  [SMALL_STATE(182)] = 8990,
  [SMALL_STATE(183)] = 9027,
  [SMALL_STATE(184)] = 9058,
  [SMALL_STATE(185)] = 9089,
  [SMALL_STATE(186)] = 9120,
  [SMALL_STATE(187)] = 9157,
  [SMALL_STATE(188)] = 9188,
  [SMALL_STATE(189)] = 9225,
  [SMALL_STATE(190)] = 9268,
  [SMALL_STATE(191)] = 9305,
  [SMALL_STATE(192)] = 9348,
  [SMALL_STATE(193)] = 9391,
  [SMALL_STATE(194)] = 9424,
  [SMALL_STATE(195)] = 9467,
  [SMALL_STATE(196)] = 9504,
  [SMALL_STATE(197)] = 9547,
  [SMALL_STATE(198)] = 9576,
  [SMALL_STATE(199)] = 9604,
  [SMALL_STATE(200)] = 9632,
  [SMALL_STATE(201)] = 9660,
  [SMALL_STATE(202)] = 9688,
  [SMALL_STATE(203)] = 9716,
  [SMALL_STATE(204)] = 9746,
  [SMALL_STATE(205)] = 9774,
  [SMALL_STATE(206)] = 9802,
  [SMALL_STATE(207)] = 9832,
  [SMALL_STATE(208)] = 9860,
  [SMALL_STATE(209)] = 9885,
  [SMALL_STATE(210)] = 9910,
  [SMALL_STATE(211)] = 9935,
  [SMALL_STATE(212)] = 9960,
  [SMALL_STATE(213)] = 9985,
  [SMALL_STATE(214)] = 10010,
  [SMALL_STATE(215)] = 10035,
  [SMALL_STATE(216)] = 10060,
  [SMALL_STATE(217)] = 10085,
  [SMALL_STATE(218)] = 10110,
  [SMALL_STATE(219)] = 10135,
  [SMALL_STATE(220)] = 10160,
  [SMALL_STATE(221)] = 10185,
  [SMALL_STATE(222)] = 10210,
  [SMALL_STATE(223)] = 10235,
  [SMALL_STATE(224)] = 10260,
  [SMALL_STATE(225)] = 10285,
  [SMALL_STATE(226)] = 10310,
  [SMALL_STATE(227)] = 10335,
  [SMALL_STATE(228)] = 10360,
  [SMALL_STATE(229)] = 10385,
  [SMALL_STATE(230)] = 10410,
  [SMALL_STATE(231)] = 10435,
  [SMALL_STATE(232)] = 10460,
  [SMALL_STATE(233)] = 10485,
  [SMALL_STATE(234)] = 10510,
  [SMALL_STATE(235)] = 10535,
  [SMALL_STATE(236)] = 10560,
  [SMALL_STATE(237)] = 10585,
  [SMALL_STATE(238)] = 10610,
  [SMALL_STATE(239)] = 10635,
  [SMALL_STATE(240)] = 10659,
  [SMALL_STATE(241)] = 10683,
  [SMALL_STATE(242)] = 10707,
  [SMALL_STATE(243)] = 10731,
  [SMALL_STATE(244)] = 10755,
  [SMALL_STATE(245)] = 10779,
  [SMALL_STATE(246)] = 10803,
  [SMALL_STATE(247)] = 10827,
  [SMALL_STATE(248)] = 10851,
  [SMALL_STATE(249)] = 10875,
  [SMALL_STATE(250)] = 10899,
  [SMALL_STATE(251)] = 10923,
  [SMALL_STATE(252)] = 10947,
  [SMALL_STATE(253)] = 10971,
  [SMALL_STATE(254)] = 10995,
  [SMALL_STATE(255)] = 11019,
  [SMALL_STATE(256)] = 11043,
  [SMALL_STATE(257)] = 11067,
  [SMALL_STATE(258)] = 11091,
  [SMALL_STATE(259)] = 11115,
  [SMALL_STATE(260)] = 11139,
  [SMALL_STATE(261)] = 11163,
  [SMALL_STATE(262)] = 11187,
  [SMALL_STATE(263)] = 11211,
  [SMALL_STATE(264)] = 11235,
  [SMALL_STATE(265)] = 11259,
  [SMALL_STATE(266)] = 11283,
  [SMALL_STATE(267)] = 11309,
  [SMALL_STATE(268)] = 11333,
  [SMALL_STATE(269)] = 11357,
  [SMALL_STATE(270)] = 11381,
  [SMALL_STATE(271)] = 11405,
  [SMALL_STATE(272)] = 11429,
  [SMALL_STATE(273)] = 11452,
  [SMALL_STATE(274)] = 11475,
  [SMALL_STATE(275)] = 11498,
  [SMALL_STATE(276)] = 11521,
  [SMALL_STATE(277)] = 11544,
  [SMALL_STATE(278)] = 11567,
  [SMALL_STATE(279)] = 11590,
  [SMALL_STATE(280)] = 11613,
  [SMALL_STATE(281)] = 11636,
  [SMALL_STATE(282)] = 11659,
  [SMALL_STATE(283)] = 11682,
  [SMALL_STATE(284)] = 11705,
  [SMALL_STATE(285)] = 11728,
  [SMALL_STATE(286)] = 11758,
  [SMALL_STATE(287)] = 11788,
  [SMALL_STATE(288)] = 11812,
  [SMALL_STATE(289)] = 11840,
  [SMALL_STATE(290)] = 11859,
  [SMALL_STATE(291)] = 11878,
  [SMALL_STATE(292)] = 11897,
  [SMALL_STATE(293)] = 11916,
  [SMALL_STATE(294)] = 11941,
  [SMALL_STATE(295)] = 11966,
  [SMALL_STATE(296)] = 11985,
  [SMALL_STATE(297)] = 12004,
  [SMALL_STATE(298)] = 12023,
  [SMALL_STATE(299)] = 12042,
  [SMALL_STATE(300)] = 12061,
  [SMALL_STATE(301)] = 12080,
  [SMALL_STATE(302)] = 12099,
  [SMALL_STATE(303)] = 12118,
  [SMALL_STATE(304)] = 12137,
  [SMALL_STATE(305)] = 12156,
  [SMALL_STATE(306)] = 12175,
  [SMALL_STATE(307)] = 12194,
  [SMALL_STATE(308)] = 12215,
  [SMALL_STATE(309)] = 12234,
  [SMALL_STATE(310)] = 12253,
  [SMALL_STATE(311)] = 12272,
  [SMALL_STATE(312)] = 12291,
  [SMALL_STATE(313)] = 12310,
  [SMALL_STATE(314)] = 12329,
  [SMALL_STATE(315)] = 12348,
  [SMALL_STATE(316)] = 12367,
  [SMALL_STATE(317)] = 12386,
  [SMALL_STATE(318)] = 12405,
  [SMALL_STATE(319)] = 12424,
  [SMALL_STATE(320)] = 12443,
  [SMALL_STATE(321)] = 12462,
  [SMALL_STATE(322)] = 12481,
  [SMALL_STATE(323)] = 12500,
  [SMALL_STATE(324)] = 12519,
  [SMALL_STATE(325)] = 12538,
  [SMALL_STATE(326)] = 12560,
  [SMALL_STATE(327)] = 12582,
  [SMALL_STATE(328)] = 12604,
  [SMALL_STATE(329)] = 12626,
  [SMALL_STATE(330)] = 12648,
  [SMALL_STATE(331)] = 12670,
  [SMALL_STATE(332)] = 12692,
  [SMALL_STATE(333)] = 12714,
  [SMALL_STATE(334)] = 12736,
  [SMALL_STATE(335)] = 12758,
  [SMALL_STATE(336)] = 12776,
  [SMALL_STATE(337)] = 12798,
  [SMALL_STATE(338)] = 12820,
  [SMALL_STATE(339)] = 12842,
  [SMALL_STATE(340)] = 12869,
  [SMALL_STATE(341)] = 12896,
  [SMALL_STATE(342)] = 12923,
  [SMALL_STATE(343)] = 12950,
  [SMALL_STATE(344)] = 12977,
  [SMALL_STATE(345)] = 13004,
  [SMALL_STATE(346)] = 13022,
  [SMALL_STATE(347)] = 13043,
  [SMALL_STATE(348)] = 13064,
  [SMALL_STATE(349)] = 13085,
  [SMALL_STATE(350)] = 13106,
  [SMALL_STATE(351)] = 13125,
  [SMALL_STATE(352)] = 13146,
  [SMALL_STATE(353)] = 13167,
  [SMALL_STATE(354)] = 13188,
  [SMALL_STATE(355)] = 13209,
  [SMALL_STATE(356)] = 13230,
  [SMALL_STATE(357)] = 13247,
  [SMALL_STATE(358)] = 13268,
  [SMALL_STATE(359)] = 13285,
  [SMALL_STATE(360)] = 13306,
  [SMALL_STATE(361)] = 13327,
  [SMALL_STATE(362)] = 13348,
  [SMALL_STATE(363)] = 13369,
  [SMALL_STATE(364)] = 13390,
  [SMALL_STATE(365)] = 13407,
  [SMALL_STATE(366)] = 13424,
  [SMALL_STATE(367)] = 13445,
  [SMALL_STATE(368)] = 13466,
  [SMALL_STATE(369)] = 13487,
  [SMALL_STATE(370)] = 13508,
  [SMALL_STATE(371)] = 13529,
  [SMALL_STATE(372)] = 13550,
  [SMALL_STATE(373)] = 13571,
  [SMALL_STATE(374)] = 13590,
  [SMALL_STATE(375)] = 13611,
  [SMALL_STATE(376)] = 13628,
  [SMALL_STATE(377)] = 13649,
  [SMALL_STATE(378)] = 13665,
  [SMALL_STATE(379)] = 13681,
  [SMALL_STATE(380)] = 13699,
  [SMALL_STATE(381)] = 13713,
  [SMALL_STATE(382)] = 13729,
  [SMALL_STATE(383)] = 13745,
  [SMALL_STATE(384)] = 13761,
  [SMALL_STATE(385)] = 13777,
  [SMALL_STATE(386)] = 13793,
  [SMALL_STATE(387)] = 13809,
  [SMALL_STATE(388)] = 13825,
  [SMALL_STATE(389)] = 13841,
  [SMALL_STATE(390)] = 13857,
  [SMALL_STATE(391)] = 13873,
  [SMALL_STATE(392)] = 13889,
  [SMALL_STATE(393)] = 13905,
  [SMALL_STATE(394)] = 13923,
  [SMALL_STATE(395)] = 13939,
  [SMALL_STATE(396)] = 13954,
  [SMALL_STATE(397)] = 13969,
  [SMALL_STATE(398)] = 13984,
  [SMALL_STATE(399)] = 13999,
  [SMALL_STATE(400)] = 14014,
  [SMALL_STATE(401)] = 14029,
  [SMALL_STATE(402)] = 14040,
  [SMALL_STATE(403)] = 14055,
  [SMALL_STATE(404)] = 14070,
  [SMALL_STATE(405)] = 14085,
  [SMALL_STATE(406)] = 14100,
  [SMALL_STATE(407)] = 14115,
  [SMALL_STATE(408)] = 14130,
  [SMALL_STATE(409)] = 14145,
  [SMALL_STATE(410)] = 14160,
  [SMALL_STATE(411)] = 14175,
  [SMALL_STATE(412)] = 14186,
  [SMALL_STATE(413)] = 14201,
  [SMALL_STATE(414)] = 14216,
  [SMALL_STATE(415)] = 14231,
  [SMALL_STATE(416)] = 14246,
  [SMALL_STATE(417)] = 14261,
  [SMALL_STATE(418)] = 14272,
  [SMALL_STATE(419)] = 14287,
  [SMALL_STATE(420)] = 14302,
  [SMALL_STATE(421)] = 14317,
  [SMALL_STATE(422)] = 14332,
  [SMALL_STATE(423)] = 14343,
  [SMALL_STATE(424)] = 14358,
  [SMALL_STATE(425)] = 14373,
  [SMALL_STATE(426)] = 14388,
  [SMALL_STATE(427)] = 14403,
  [SMALL_STATE(428)] = 14418,
  [SMALL_STATE(429)] = 14433,
  [SMALL_STATE(430)] = 14448,
  [SMALL_STATE(431)] = 14463,
  [SMALL_STATE(432)] = 14478,
  [SMALL_STATE(433)] = 14489,
  [SMALL_STATE(434)] = 14504,
  [SMALL_STATE(435)] = 14519,
  [SMALL_STATE(436)] = 14534,
  [SMALL_STATE(437)] = 14549,
  [SMALL_STATE(438)] = 14564,
  [SMALL_STATE(439)] = 14579,
  [SMALL_STATE(440)] = 14594,
  [SMALL_STATE(441)] = 14609,
  [SMALL_STATE(442)] = 14624,
  [SMALL_STATE(443)] = 14639,
  [SMALL_STATE(444)] = 14654,
  [SMALL_STATE(445)] = 14669,
  [SMALL_STATE(446)] = 14684,
  [SMALL_STATE(447)] = 14699,
  [SMALL_STATE(448)] = 14714,
  [SMALL_STATE(449)] = 14729,
  [SMALL_STATE(450)] = 14742,
  [SMALL_STATE(451)] = 14757,
  [SMALL_STATE(452)] = 14772,
  [SMALL_STATE(453)] = 14783,
  [SMALL_STATE(454)] = 14798,
  [SMALL_STATE(455)] = 14813,
  [SMALL_STATE(456)] = 14828,
  [SMALL_STATE(457)] = 14843,
  [SMALL_STATE(458)] = 14858,
  [SMALL_STATE(459)] = 14873,
  [SMALL_STATE(460)] = 14888,
  [SMALL_STATE(461)] = 14903,
  [SMALL_STATE(462)] = 14918,
  [SMALL_STATE(463)] = 14933,
  [SMALL_STATE(464)] = 14948,
  [SMALL_STATE(465)] = 14963,
  [SMALL_STATE(466)] = 14978,
  [SMALL_STATE(467)] = 14993,
  [SMALL_STATE(468)] = 15008,
  [SMALL_STATE(469)] = 15023,
  [SMALL_STATE(470)] = 15038,
  [SMALL_STATE(471)] = 15053,
  [SMALL_STATE(472)] = 15068,
  [SMALL_STATE(473)] = 15083,
  [SMALL_STATE(474)] = 15098,
  [SMALL_STATE(475)] = 15113,
  [SMALL_STATE(476)] = 15128,
  [SMALL_STATE(477)] = 15140,
  [SMALL_STATE(478)] = 15152,
  [SMALL_STATE(479)] = 15164,
  [SMALL_STATE(480)] = 15174,
  [SMALL_STATE(481)] = 15186,
  [SMALL_STATE(482)] = 15198,
  [SMALL_STATE(483)] = 15210,
  [SMALL_STATE(484)] = 15220,
  [SMALL_STATE(485)] = 15232,
  [SMALL_STATE(486)] = 15242,
  [SMALL_STATE(487)] = 15254,
  [SMALL_STATE(488)] = 15264,
  [SMALL_STATE(489)] = 15274,
  [SMALL_STATE(490)] = 15286,
  [SMALL_STATE(491)] = 15298,
  [SMALL_STATE(492)] = 15310,
  [SMALL_STATE(493)] = 15320,
  [SMALL_STATE(494)] = 15329,
  [SMALL_STATE(495)] = 15338,
  [SMALL_STATE(496)] = 15347,
  [SMALL_STATE(497)] = 15356,
  [SMALL_STATE(498)] = 15365,
  [SMALL_STATE(499)] = 15374,
  [SMALL_STATE(500)] = 15383,
  [SMALL_STATE(501)] = 15392,
  [SMALL_STATE(502)] = 15401,
  [SMALL_STATE(503)] = 15410,
  [SMALL_STATE(504)] = 15419,
  [SMALL_STATE(505)] = 15428,
  [SMALL_STATE(506)] = 15437,
  [SMALL_STATE(507)] = 15446,
  [SMALL_STATE(508)] = 15455,
  [SMALL_STATE(509)] = 15464,
  [SMALL_STATE(510)] = 15473,
  [SMALL_STATE(511)] = 15482,
  [SMALL_STATE(512)] = 15491,
  [SMALL_STATE(513)] = 15500,
  [SMALL_STATE(514)] = 15509,
  [SMALL_STATE(515)] = 15518,
  [SMALL_STATE(516)] = 15527,
  [SMALL_STATE(517)] = 15536,
  [SMALL_STATE(518)] = 15545,
  [SMALL_STATE(519)] = 15554,
  [SMALL_STATE(520)] = 15563,
  [SMALL_STATE(521)] = 15572,
  [SMALL_STATE(522)] = 15581,
  [SMALL_STATE(523)] = 15590,
  [SMALL_STATE(524)] = 15599,
  [SMALL_STATE(525)] = 15608,
  [SMALL_STATE(526)] = 15617,
  [SMALL_STATE(527)] = 15626,
  [SMALL_STATE(528)] = 15635,
  [SMALL_STATE(529)] = 15644,
  [SMALL_STATE(530)] = 15653,
  [SMALL_STATE(531)] = 15662,
  [SMALL_STATE(532)] = 15671,
  [SMALL_STATE(533)] = 15680,
  [SMALL_STATE(534)] = 15689,
  [SMALL_STATE(535)] = 15698,
  [SMALL_STATE(536)] = 15707,
  [SMALL_STATE(537)] = 15716,
  [SMALL_STATE(538)] = 15725,
  [SMALL_STATE(539)] = 15734,
  [SMALL_STATE(540)] = 15743,
  [SMALL_STATE(541)] = 15752,
  [SMALL_STATE(542)] = 15761,
  [SMALL_STATE(543)] = 15770,
  [SMALL_STATE(544)] = 15779,
  [SMALL_STATE(545)] = 15788,
  [SMALL_STATE(546)] = 15797,
  [SMALL_STATE(547)] = 15806,
  [SMALL_STATE(548)] = 15815,
  [SMALL_STATE(549)] = 15824,
  [SMALL_STATE(550)] = 15833,
  [SMALL_STATE(551)] = 15842,
  [SMALL_STATE(552)] = 15851,
  [SMALL_STATE(553)] = 15860,
  [SMALL_STATE(554)] = 15869,
  [SMALL_STATE(555)] = 15878,
  [SMALL_STATE(556)] = 15887,
  [SMALL_STATE(557)] = 15896,
  [SMALL_STATE(558)] = 15905,
  [SMALL_STATE(559)] = 15914,
  [SMALL_STATE(560)] = 15923,
  [SMALL_STATE(561)] = 15932,
  [SMALL_STATE(562)] = 15941,
  [SMALL_STATE(563)] = 15950,
  [SMALL_STATE(564)] = 15959,
  [SMALL_STATE(565)] = 15968,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(47),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(287),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(505),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(525),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(536),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [75] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(74),
  [78] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1),
  [80] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1),
  [82] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(84),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1),
  [87] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2),
  [91] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(516),
  [94] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(562),
  [97] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(491),
  [100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(557),
  [103] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(47),
  [106] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(552),
  [109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(75),
  [112] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(327),
  [115] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(551),
  [118] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(167),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_file_repeat1, 2), SHIFT_REPEAT(177),
  [124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [144] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [160] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_file, 1),
  [162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [184] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(67),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(53),
  [190] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(110),
  [193] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(53),
  [196] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(64),
  [199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(60),
  [202] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(68),
  [205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(512),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(536),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assert, 5),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assert, 5),
  [231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [241] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(49),
  [244] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 1), SHIFT_REPEAT(49),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [251] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 2),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 2),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 2),
  [257] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 2),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, .production_id = 1),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, .production_id = 1),
  [263] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(121),
  [266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(122),
  [269] = {.entry = {.count = 1, .reusable = false}}, SHIFT(533),
  [271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(161),
  [275] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 2, .production_id = 1),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 2, .production_id = 1),
  [279] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(121),
  [282] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(122),
  [285] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(533),
  [288] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(161),
  [291] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(161),
  [294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [298] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(533),
  [301] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(161),
  [304] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(161),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [309] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2),
  [313] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(121),
  [316] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(122),
  [319] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(533),
  [322] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(161),
  [325] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(161),
  [328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [332] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 1),
  [334] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 1), SHIFT(87),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 1),
  [339] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(49),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [349] = {.entry = {.count = 1, .reusable = false}}, SHIFT(60),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [359] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(479),
  [362] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_body_repeat1, 2),
  [364] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(294),
  [367] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(505),
  [370] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(504),
  [373] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(503),
  [376] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(177),
  [379] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(525),
  [382] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_record_body_repeat1, 2), SHIFT_REPEAT(523),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 4),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 4),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 5),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 5),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 2),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 2),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__value_concat_repeat1, 2),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [421] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2), SHIFT_REPEAT(28),
  [424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 3),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 3),
  [430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value_concat, 2),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value_concat, 2),
  [442] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2), SHIFT(28),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [455] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__repeated_string, 2),
  [457] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__repeated_string, 2), SHIFT_REPEAT(87),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__repeated_string, 2),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [464] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7, .production_id = 18),
  [466] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7, .production_id = 18),
  [468] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 7),
  [470] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 7),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 3),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 3),
  [482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 4, .production_id = 9),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 4, .production_id = 9),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7, .production_id = 20),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7, .production_id = 20),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [502] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__simple_value, 1), REDUCE(aux_sym__repeated_string, 1),
  [505] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym__simple_value, 1), REDUCE(aux_sym__repeated_string, 1),
  [508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [510] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [512] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 4, .production_id = 9),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 4, .production_id = 9),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 8, .production_id = 22),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 8, .production_id = 22),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 5, .production_id = 13),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 5, .production_id = 13),
  [526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [528] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7),
  [530] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7),
  [532] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 6, .production_id = 13),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 6, .production_id = 13),
  [536] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 4),
  [538] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 4),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [552] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 6),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 6),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 6, .production_id = 18),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 6, .production_id = 18),
  [560] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 4),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 4),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [566] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 5, .production_id = 9),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 5, .production_id = 9),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 6),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 6),
  [574] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_suffix, 3),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_suffix, 3),
  [578] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 9, .production_id = 22),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 9, .production_id = 22),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 5, .production_id = 13),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 5, .production_id = 13),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 7, .production_id = 21),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 7, .production_id = 21),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__simple_value, 8),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__simple_value, 8),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 8, .production_id = 20),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 8, .production_id = 20),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator, 8, .production_id = 21),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator, 8, .production_id = 21),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [612] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [616] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2), SHIFT_REPEAT(46),
  [619] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(91),
  [622] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(92),
  [625] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(499),
  [628] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 1, .production_id = 1), SHIFT(160),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [633] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__repeated_string, 2), SHIFT_REPEAT(184),
  [636] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2), SHIFT(46),
  [639] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(91),
  [642] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(92),
  [645] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(499),
  [648] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_value_repeat1, 2), SHIFT_REPEAT(160),
  [651] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(91),
  [654] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(92),
  [657] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(499),
  [660] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_value, 2, .production_id = 1), SHIFT(160),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2),
  [665] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2), SHIFT_REPEAT(481),
  [668] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2), SHIFT_REPEAT(542),
  [671] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_multiclass_body_repeat1, 2), SHIFT_REPEAT(45),
  [674] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2), SHIFT_REPEAT(71),
  [677] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2), SHIFT_REPEAT(561),
  [680] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2), SHIFT_REPEAT(149),
  [683] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_multiclass_body_repeat1, 2), SHIFT_REPEAT(170),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [690] = {.entry = {.count = 1, .reusable = false}}, SHIFT(499),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [696] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [698] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dag_arg, 1),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dag_arg, 1),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [704] = {.entry = {.count = 1, .reusable = false}}, SHIFT(46),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [716] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2), SHIFT_REPEAT(4),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [723] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2), SHIFT(4),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__repeated_string, 1),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dag_arg, 3),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dag_arg, 3),
  [732] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defm, 3),
  [734] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defm, 3),
  [736] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 5),
  [738] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 5),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def, 3),
  [742] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def, 3),
  [744] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_body, 3),
  [746] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_body, 3),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass, 5, .production_id = 11),
  [750] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass, 5, .production_id = 11),
  [752] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_or_block, 2),
  [754] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement_or_block, 2),
  [756] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_body, 1),
  [758] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_body, 1),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass, 3, .production_id = 3),
  [762] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass, 3, .production_id = 3),
  [764] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 6),
  [766] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 6),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [770] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 4, .production_id = 4),
  [774] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 4, .production_id = 4),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 3, .production_id = 2),
  [778] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 3, .production_id = 2),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include, 2),
  [782] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include, 2),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 4),
  [786] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 4),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 1),
  [790] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 1),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_body, 3),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_body, 3),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def, 4),
  [798] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def, 4),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_body, 2),
  [802] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_body, 2),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defset, 6),
  [806] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defset, 6),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach, 6),
  [810] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach, 6),
  [812] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_or_block, 3),
  [814] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement_or_block, 3),
  [816] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 6),
  [818] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 6),
  [820] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass, 4, .production_id = 6),
  [822] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass, 4, .production_id = 6),
  [824] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defm, 4),
  [826] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defm, 4),
  [828] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement_or_block, 1),
  [830] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement_or_block, 1),
  [832] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let, 7),
  [834] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let, 7),
  [836] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 4),
  [838] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 4),
  [840] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defset, 7),
  [844] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defset, 7),
  [846] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 5, .production_id = 8),
  [848] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 5, .production_id = 8),
  [850] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def, 2),
  [852] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def, 2),
  [854] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_defvar, 5),
  [856] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_defvar, 5),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 5),
  [860] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 5),
  [862] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 6),
  [864] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 6),
  [866] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 5),
  [868] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 5),
  [870] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_def_var, 5),
  [872] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_def_var, 5),
  [874] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_body_item, 1),
  [876] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_body_item, 1),
  [878] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 4),
  [880] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 4),
  [882] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 9),
  [884] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 9),
  [886] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 8),
  [888] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 8),
  [890] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_let_inst, 7),
  [892] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_inst, 7),
  [894] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instruction, 3),
  [896] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instruction, 3),
  [898] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2), SHIFT_REPEAT(5),
  [901] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2), SHIFT(5),
  [904] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1),
  [906] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [908] = {.entry = {.count = 1, .reusable = false}}, SHIFT(513),
  [910] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [912] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_multiclass_statement, 1),
  [914] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_multiclass_statement, 1),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [918] = {.entry = {.count = 1, .reusable = false}}, SHIFT(54),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [932] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_let_inst_repeat1, 2),
  [934] = {.entry = {.count = 1, .reusable = false}}, SHIFT(5),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [948] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 2),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [964] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__value_concat, 2), SHIFT(54),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat1, 2, .production_id = 7),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [981] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__value_concat_repeat1, 2), SHIFT_REPEAT(54),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1002] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_let_inst_repeat1, 2), SHIFT_REPEAT(172),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1009] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 3),
  [1011] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 4),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat2, 2),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1017] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 6, .production_id = 17),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 6, .production_id = 16),
  [1021] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat2, 2, .production_id = 10),
  [1023] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat2, 2, .production_id = 10), SHIFT_REPEAT(544),
  [1026] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 3, .production_id = 5),
  [1028] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operator_repeat1, 4, .production_id = 23),
  [1030] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 6),
  [1032] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_arg, 4),
  [1034] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 7),
  [1036] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 5, .production_id = 15),
  [1038] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 5, .production_id = 14),
  [1040] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parent_class_list, 7, .production_id = 19),
  [1042] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat1, 2, .production_id = 10), SHIFT_REPEAT(179),
  [1045] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat1, 2, .production_id = 10),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_let_item, 5),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1055] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat2, 6, .production_id = 17),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1065] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_operator_repeat1, 2, .production_id = 10), SHIFT_REPEAT(174),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operator_repeat1, 2, .production_id = 10),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1074] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat2, 5, .production_id = 15),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1088] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parent_class_list_repeat2, 4),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1100] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__simple_value_repeat1, 2), SHIFT_REPEAT(73),
  [1103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__simple_value_repeat1, 2),
  [1105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_args, 2),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1125] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_template_args_repeat1, 2, .production_id = 10), SHIFT_REPEAT(293),
  [1128] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_args_repeat1, 2, .production_id = 10),
  [1130] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_args, 4, .production_id = 12),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_let_repeat1, 2), SHIFT_REPEAT(480),
  [1151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_let_repeat1, 2),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_arg, 2),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_args, 3, .production_id = 7),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_template_args_repeat1, 2, .production_id = 7),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 4),
  [1237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_keyword, 2),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1337] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_tablegen_external_scanner_create(void);
void tree_sitter_tablegen_external_scanner_destroy(void *);
bool tree_sitter_tablegen_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_tablegen_external_scanner_serialize(void *, char *);
void tree_sitter_tablegen_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_tablegen(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_tablegen_external_scanner_create,
      tree_sitter_tablegen_external_scanner_destroy,
      tree_sitter_tablegen_external_scanner_scan,
      tree_sitter_tablegen_external_scanner_serialize,
      tree_sitter_tablegen_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
