#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 920
#define LARGE_STATE_COUNT 234
#define SYMBOL_COUNT 265
#define ALIAS_COUNT 0
#define TOKEN_COUNT 141
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 14
#define PRODUCTION_ID_COUNT 88

enum ts_symbol_identifiers {
  sym_export = 1,
  anon_sym_LBRACE = 2,
  anon_sym_COMMA = 3,
  anon_sym_RBRACE = 4,
  anon_sym_import = 5,
  anon_sym_from = 6,
  anon_sym_SEMI = 7,
  anon_sym_as = 8,
  anon_sym_COLON_EQ = 9,
  anon_sym_component = 10,
  anon_sym_inherits = 11,
  anon_sym_LT = 12,
  anon_sym_GT = 13,
  anon_sym_return = 14,
  anon_sym_property = 15,
  anon_sym_COLON = 16,
  anon_sym_LT_EQ_GT = 17,
  anon_sym_global = 18,
  anon_sym_struct = 19,
  anon_sym_enum = 20,
  anon_sym_in = 21,
  anon_sym_out = 22,
  anon_sym_transitions = 23,
  anon_sym_LBRACK = 24,
  anon_sym_RBRACK = 25,
  anon_sym_states = 26,
  anon_sym_when = 27,
  anon_sym_animate = 28,
  anon_sym_delay = 29,
  anon_sym_duration = 30,
  anon_sym_iteration_DASHcount = 31,
  anon_sym_easing = 32,
  anon_sym_if = 33,
  anon_sym_else = 34,
  anon_sym_for = 35,
  anon_sym_LPAREN = 36,
  anon_sym_RPAREN = 37,
  anon_sym_ATtr = 38,
  anon_sym_EQ_GT = 39,
  anon_sym_PIPE = 40,
  anon_sym_PERCENT = 41,
  anon_sym_DOT = 42,
  sym_logical_and = 43,
  sym_logical_or = 44,
  anon_sym_QMARK = 45,
  anon_sym_callback = 46,
  anon_sym_DASH_GT = 47,
  anon_sym_pure = 48,
  anon_sym_public = 49,
  anon_sym_private = 50,
  anon_sym_function = 51,
  anon_sym_ATimage_DASHurl = 52,
  anon_sym_9slice = 53,
  anon_sym_BANG = 54,
  anon_sym_DASH = 55,
  anon_sym_PLUS = 56,
  anon_sym_STAR = 57,
  anon_sym_SLASH = 58,
  anon_sym_GT_EQ = 59,
  anon_sym_LT_EQ = 60,
  anon_sym_EQ_EQ = 61,
  anon_sym_BANG_EQ = 62,
  anon_sym_EQ = 63,
  anon_sym_PLUS_EQ = 64,
  anon_sym_DASH_EQ = 65,
  anon_sym_STAR_EQ = 66,
  anon_sym_SLASH_EQ = 67,
  anon_sym_DQUOTE = 68,
  sym__unescaped_string_fragment = 69,
  anon_sym_BSLASH = 70,
  aux_sym_escape_sequence_token1 = 71,
  anon_sym_n = 72,
  anon_sym_in_DASHout = 73,
  sym__identifier = 74,
  anon_sym_int = 75,
  anon_sym_float = 76,
  anon_sym_bool = 77,
  anon_sym_string = 78,
  anon_sym_color = 79,
  anon_sym_brush = 80,
  anon_sym_physical_DASHlength = 81,
  anon_sym_length = 82,
  anon_sym_angle = 83,
  anon_sym_percent = 84,
  anon_sym_image = 85,
  anon_sym_relative_DASHfont_DASHsize = 86,
  anon_sym_linear = 87,
  anon_sym_ease_DASHin_DASHquad = 88,
  anon_sym_ease_DASHout_DASHquad = 89,
  anon_sym_ease_DASHin_DASHout_DASHquad = 90,
  anon_sym_ease = 91,
  anon_sym_ease_DASHin = 92,
  anon_sym_ease_DASHout = 93,
  anon_sym_ease_DASHin_DASHout = 94,
  anon_sym_ease_DASHin_DASHquart = 95,
  anon_sym_ease_DASHout_DASHquart = 96,
  anon_sym_ease_DASHin_DASHout_DASHquart = 97,
  anon_sym_ease_DASHin_DASHquint = 98,
  anon_sym_ease_DASHout_DASHquint = 99,
  anon_sym_ease_DASHin_DASHout_DASHquint = 100,
  anon_sym_ease_DASHin_DASHexpo = 101,
  anon_sym_ease_DASHout_DASHexpo = 102,
  anon_sym_ease_DASHin_DASHout_DASHexpo = 103,
  anon_sym_ease_DASHin_DASHsine = 104,
  anon_sym_ease_DASHout_DASHsine = 105,
  anon_sym_ease_DASHin_DASHout_DASHsine = 106,
  anon_sym_ease_DASHin_DASHback = 107,
  anon_sym_ease_DASHout_DASHback = 108,
  anon_sym_ease_DASHin_DASHout_DASHback = 109,
  anon_sym_ease_DASHin_DASHcirc = 110,
  anon_sym_ease_DASHout_DASHcirc = 111,
  anon_sym_ease_DASHin_DASHout_DASHcirc = 112,
  anon_sym_ease_DASHin_DASHelastic = 113,
  anon_sym_ease_DASHout_DASHelastic = 114,
  anon_sym_ease_DASHin_DASHout_DASHelastic = 115,
  anon_sym_ease_DASHin_DASHbounce = 116,
  anon_sym_ease_DASHout_DASHbounce = 117,
  anon_sym_ease_DASHin_DASHout_DASHbounce = 118,
  anon_sym_cubic_DASHbezier = 119,
  sym_children_identifier = 120,
  anon_sym_ATlinear_DASHgradient = 121,
  anon_sym_ATlinear_gradient = 122,
  anon_sym_ATradial_DASHgradient = 123,
  anon_sym_ATradial_gradient = 124,
  anon_sym_circle = 125,
  anon_sym_parent = 126,
  anon_sym_root = 127,
  anon_sym_self = 128,
  sym__int_number = 129,
  sym__float_number = 130,
  anon_sym_true = 131,
  anon_sym_false = 132,
  sym_color_value = 133,
  anon_sym_phx = 134,
  aux_sym_length_value_token1 = 135,
  aux_sym_duration_value_token1 = 136,
  aux_sym_angle_value_token1 = 137,
  anon_sym_PERCENT2 = 138,
  anon_sym_rem = 139,
  sym_comment = 140,
  sym_sourcefile = 141,
  sym__definition = 142,
  sym__local_type = 143,
  sym__exported_type = 144,
  sym_import_statement = 145,
  sym_export_type = 146,
  sym_import_type = 147,
  sym_component = 148,
  sym_component_definition = 149,
  sym__property_type = 150,
  sym_imperative_block = 151,
  sym__imperative_block_statement = 152,
  sym__binding = 153,
  sym_property = 154,
  sym_binding_alias = 155,
  sym_binding = 156,
  sym_global_block = 157,
  sym_global_definition = 158,
  sym_struct_block = 159,
  sym_struct_definition = 160,
  sym_enum_block = 161,
  sym_enum_definition = 162,
  sym_anon_struct_block = 163,
  sym_block = 164,
  sym__block_statement = 165,
  sym_property_assignment = 166,
  sym_in_out_transition = 167,
  sym_transitions_definition = 168,
  sym_states_definition = 169,
  sym_animate_statement = 170,
  sym_animate_option_identifier = 171,
  sym_animate_option = 172,
  sym_animate_body = 173,
  sym_if_expr = 174,
  sym_if_statement = 175,
  sym_for_loop = 176,
  sym_for_range = 177,
  sym_type_list = 178,
  sym_type = 179,
  sym__assignment_setup = 180,
  sym__assignment_value_block = 181,
  sym_assignment_block = 182,
  sym_assignment_expr = 183,
  sym_expression = 184,
  sym_parens_op = 185,
  sym_index_op = 186,
  sym_tr = 187,
  sym_member_access = 188,
  sym_unary_expression = 189,
  sym_binary_expression = 190,
  sym__add_binary_expression = 191,
  sym__comparison_binary_expression = 192,
  sym__logic_binary_expression = 193,
  sym__mult_binary_expression = 194,
  sym_ternary_expression = 195,
  sym_callback = 196,
  sym_purity = 197,
  sym_function_visibility = 198,
  sym_function_definition = 199,
  sym_callback_alias = 200,
  sym_callback_event = 201,
  sym_function_call = 202,
  sym_gradient_call = 203,
  sym_gradient_color = 204,
  sym_image_call = 205,
  sym_typed_identifier = 206,
  sym__function_signature = 207,
  sym__callback_signature = 208,
  sym_argument = 209,
  sym_arguments = 210,
  sym_unary_prec_operator = 211,
  sym_add_prec_operator = 212,
  sym_mult_prec_operator = 213,
  sym_comparison_operator = 214,
  sym_assignment_prec_operator = 215,
  sym__string = 216,
  sym_escape_sequence = 217,
  sym_property_visibility = 218,
  sym_simple_identifier = 219,
  sym_simple_indexed_identifier = 220,
  sym_builtin_type_identifier = 221,
  sym_easing_kind_identifier = 222,
  sym_user_type_identifier = 223,
  sym__type_identifier = 224,
  sym_value_list = 225,
  sym_value = 226,
  sym_linear_gradient_identifier = 227,
  sym_radial_gradient_identifier = 228,
  sym_radial_gradient_kind = 229,
  sym_reference_identifier = 230,
  sym__number = 231,
  sym_int_value = 232,
  sym_float_value = 233,
  sym_bool_value = 234,
  sym_string_value = 235,
  sym_physical_length_value = 236,
  sym_length_value = 237,
  sym_duration_value = 238,
  sym_angle_value = 239,
  sym_percent_value = 240,
  sym_relative_font_size_value = 241,
  sym__basic_value = 242,
  aux_sym_sourcefile_repeat1 = 243,
  aux_sym__exported_type_repeat1 = 244,
  aux_sym_import_statement_repeat1 = 245,
  aux_sym_imperative_block_repeat1 = 246,
  aux_sym_global_block_repeat1 = 247,
  aux_sym_struct_block_repeat1 = 248,
  aux_sym_enum_block_repeat1 = 249,
  aux_sym_anon_struct_block_repeat1 = 250,
  aux_sym_block_repeat1 = 251,
  aux_sym_in_out_transition_repeat1 = 252,
  aux_sym_transitions_definition_repeat1 = 253,
  aux_sym_states_definition_repeat1 = 254,
  aux_sym_states_definition_repeat2 = 255,
  aux_sym_animate_body_repeat1 = 256,
  aux_sym_type_list_repeat1 = 257,
  aux_sym_tr_repeat1 = 258,
  aux_sym_function_definition_repeat1 = 259,
  aux_sym_gradient_call_repeat1 = 260,
  aux_sym_image_call_repeat1 = 261,
  aux_sym__function_signature_repeat1 = 262,
  aux_sym_arguments_repeat1 = 263,
  aux_sym__string_repeat1 = 264,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_export] = "export",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_SEMI] = ";",
  [anon_sym_as] = "as",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_component] = "component",
  [anon_sym_inherits] = "inherits",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_return] = "return",
  [anon_sym_property] = "property",
  [anon_sym_COLON] = ":",
  [anon_sym_LT_EQ_GT] = "<=>",
  [anon_sym_global] = "global",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_in] = "in",
  [anon_sym_out] = "out",
  [anon_sym_transitions] = "transitions",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_states] = "states",
  [anon_sym_when] = "when",
  [anon_sym_animate] = "animate",
  [anon_sym_delay] = "delay",
  [anon_sym_duration] = "duration",
  [anon_sym_iteration_DASHcount] = "iteration-count",
  [anon_sym_easing] = "easing",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_ATtr] = "@tr",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_PIPE] = "|",
  [anon_sym_PERCENT] = "%",
  [anon_sym_DOT] = ".",
  [sym_logical_and] = "logical_and",
  [sym_logical_or] = "logical_or",
  [anon_sym_QMARK] = "\?",
  [anon_sym_callback] = "callback",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_pure] = "pure",
  [anon_sym_public] = "public",
  [anon_sym_private] = "private",
  [anon_sym_function] = "function",
  [anon_sym_ATimage_DASHurl] = "@image-url",
  [anon_sym_9slice] = "9slice",
  [anon_sym_BANG] = "!",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_EQ] = "=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_DQUOTE] = "\"",
  [sym__unescaped_string_fragment] = "_unescaped_string_fragment",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [anon_sym_n] = "n",
  [anon_sym_in_DASHout] = "in-out",
  [sym__identifier] = "_identifier",
  [anon_sym_int] = "int",
  [anon_sym_float] = "float",
  [anon_sym_bool] = "bool",
  [anon_sym_string] = "string",
  [anon_sym_color] = "color",
  [anon_sym_brush] = "brush",
  [anon_sym_physical_DASHlength] = "physical-length",
  [anon_sym_length] = "length",
  [anon_sym_angle] = "angle",
  [anon_sym_percent] = "percent",
  [anon_sym_image] = "image",
  [anon_sym_relative_DASHfont_DASHsize] = "relative-font-size",
  [anon_sym_linear] = "linear",
  [anon_sym_ease_DASHin_DASHquad] = "ease-in-quad",
  [anon_sym_ease_DASHout_DASHquad] = "ease-out-quad",
  [anon_sym_ease_DASHin_DASHout_DASHquad] = "ease-in-out-quad",
  [anon_sym_ease] = "ease",
  [anon_sym_ease_DASHin] = "ease-in",
  [anon_sym_ease_DASHout] = "ease-out",
  [anon_sym_ease_DASHin_DASHout] = "ease-in-out",
  [anon_sym_ease_DASHin_DASHquart] = "ease-in-quart",
  [anon_sym_ease_DASHout_DASHquart] = "ease-out-quart",
  [anon_sym_ease_DASHin_DASHout_DASHquart] = "ease-in-out-quart",
  [anon_sym_ease_DASHin_DASHquint] = "ease-in-quint",
  [anon_sym_ease_DASHout_DASHquint] = "ease-out-quint",
  [anon_sym_ease_DASHin_DASHout_DASHquint] = "ease-in-out-quint",
  [anon_sym_ease_DASHin_DASHexpo] = "ease-in-expo",
  [anon_sym_ease_DASHout_DASHexpo] = "ease-out-expo",
  [anon_sym_ease_DASHin_DASHout_DASHexpo] = "ease-in-out-expo",
  [anon_sym_ease_DASHin_DASHsine] = "ease-in-sine",
  [anon_sym_ease_DASHout_DASHsine] = "ease-out-sine",
  [anon_sym_ease_DASHin_DASHout_DASHsine] = "ease-in-out-sine",
  [anon_sym_ease_DASHin_DASHback] = "ease-in-back",
  [anon_sym_ease_DASHout_DASHback] = "ease-out-back",
  [anon_sym_ease_DASHin_DASHout_DASHback] = "ease-in-out-back",
  [anon_sym_ease_DASHin_DASHcirc] = "ease-in-circ",
  [anon_sym_ease_DASHout_DASHcirc] = "ease-out-circ",
  [anon_sym_ease_DASHin_DASHout_DASHcirc] = "ease-in-out-circ",
  [anon_sym_ease_DASHin_DASHelastic] = "ease-in-elastic",
  [anon_sym_ease_DASHout_DASHelastic] = "ease-out-elastic",
  [anon_sym_ease_DASHin_DASHout_DASHelastic] = "ease-in-out-elastic",
  [anon_sym_ease_DASHin_DASHbounce] = "ease-in-bounce",
  [anon_sym_ease_DASHout_DASHbounce] = "ease-out-bounce",
  [anon_sym_ease_DASHin_DASHout_DASHbounce] = "ease-in-out-bounce",
  [anon_sym_cubic_DASHbezier] = "cubic-bezier",
  [sym_children_identifier] = "children_identifier",
  [anon_sym_ATlinear_DASHgradient] = "@linear-gradient",
  [anon_sym_ATlinear_gradient] = "@linear_gradient",
  [anon_sym_ATradial_DASHgradient] = "@radial-gradient",
  [anon_sym_ATradial_gradient] = "@radial_gradient",
  [anon_sym_circle] = "circle",
  [anon_sym_parent] = "parent",
  [anon_sym_root] = "root",
  [anon_sym_self] = "self",
  [sym__int_number] = "_int_number",
  [sym__float_number] = "_float_number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_color_value] = "color_value",
  [anon_sym_phx] = "phx",
  [aux_sym_length_value_token1] = "length_value_token1",
  [aux_sym_duration_value_token1] = "duration_value_token1",
  [aux_sym_angle_value_token1] = "angle_value_token1",
  [anon_sym_PERCENT2] = "%",
  [anon_sym_rem] = "rem",
  [sym_comment] = "comment",
  [sym_sourcefile] = "sourcefile",
  [sym__definition] = "_definition",
  [sym__local_type] = "_local_type",
  [sym__exported_type] = "_exported_type",
  [sym_import_statement] = "import_statement",
  [sym_export_type] = "export_type",
  [sym_import_type] = "import_type",
  [sym_component] = "component",
  [sym_component_definition] = "component_definition",
  [sym__property_type] = "_property_type",
  [sym_imperative_block] = "imperative_block",
  [sym__imperative_block_statement] = "_imperative_block_statement",
  [sym__binding] = "_binding",
  [sym_property] = "property",
  [sym_binding_alias] = "binding_alias",
  [sym_binding] = "binding",
  [sym_global_block] = "global_block",
  [sym_global_definition] = "global_definition",
  [sym_struct_block] = "struct_block",
  [sym_struct_definition] = "struct_definition",
  [sym_enum_block] = "enum_block",
  [sym_enum_definition] = "enum_definition",
  [sym_anon_struct_block] = "anon_struct_block",
  [sym_block] = "block",
  [sym__block_statement] = "_block_statement",
  [sym_property_assignment] = "property_assignment",
  [sym_in_out_transition] = "in_out_transition",
  [sym_transitions_definition] = "transitions_definition",
  [sym_states_definition] = "states_definition",
  [sym_animate_statement] = "animate_statement",
  [sym_animate_option_identifier] = "animate_option_identifier",
  [sym_animate_option] = "animate_option",
  [sym_animate_body] = "animate_body",
  [sym_if_expr] = "if_expr",
  [sym_if_statement] = "if_statement",
  [sym_for_loop] = "for_loop",
  [sym_for_range] = "for_range",
  [sym_type_list] = "type_list",
  [sym_type] = "type",
  [sym__assignment_setup] = "_assignment_setup",
  [sym__assignment_value_block] = "_assignment_value_block",
  [sym_assignment_block] = "assignment_block",
  [sym_assignment_expr] = "assignment_expr",
  [sym_expression] = "expression",
  [sym_parens_op] = "parens_op",
  [sym_index_op] = "index_op",
  [sym_tr] = "tr",
  [sym_member_access] = "member_access",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__add_binary_expression] = "_add_binary_expression",
  [sym__comparison_binary_expression] = "_comparison_binary_expression",
  [sym__logic_binary_expression] = "_logic_binary_expression",
  [sym__mult_binary_expression] = "_mult_binary_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_callback] = "callback",
  [sym_purity] = "purity",
  [sym_function_visibility] = "function_visibility",
  [sym_function_definition] = "function_definition",
  [sym_callback_alias] = "callback_alias",
  [sym_callback_event] = "callback_event",
  [sym_function_call] = "function_call",
  [sym_gradient_call] = "gradient_call",
  [sym_gradient_color] = "gradient_color",
  [sym_image_call] = "image_call",
  [sym_typed_identifier] = "typed_identifier",
  [sym__function_signature] = "_function_signature",
  [sym__callback_signature] = "_callback_signature",
  [sym_argument] = "argument",
  [sym_arguments] = "arguments",
  [sym_unary_prec_operator] = "unary_prec_operator",
  [sym_add_prec_operator] = "add_prec_operator",
  [sym_mult_prec_operator] = "mult_prec_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_assignment_prec_operator] = "assignment_prec_operator",
  [sym__string] = "_string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_property_visibility] = "property_visibility",
  [sym_simple_identifier] = "simple_identifier",
  [sym_simple_indexed_identifier] = "simple_indexed_identifier",
  [sym_builtin_type_identifier] = "builtin_type_identifier",
  [sym_easing_kind_identifier] = "easing_kind_identifier",
  [sym_user_type_identifier] = "user_type_identifier",
  [sym__type_identifier] = "_type_identifier",
  [sym_value_list] = "value_list",
  [sym_value] = "value",
  [sym_linear_gradient_identifier] = "linear_gradient_identifier",
  [sym_radial_gradient_identifier] = "radial_gradient_identifier",
  [sym_radial_gradient_kind] = "radial_gradient_kind",
  [sym_reference_identifier] = "reference_identifier",
  [sym__number] = "_number",
  [sym_int_value] = "int_value",
  [sym_float_value] = "float_value",
  [sym_bool_value] = "bool_value",
  [sym_string_value] = "string_value",
  [sym_physical_length_value] = "physical_length_value",
  [sym_length_value] = "length_value",
  [sym_duration_value] = "duration_value",
  [sym_angle_value] = "angle_value",
  [sym_percent_value] = "percent_value",
  [sym_relative_font_size_value] = "relative_font_size_value",
  [sym__basic_value] = "_basic_value",
  [aux_sym_sourcefile_repeat1] = "sourcefile_repeat1",
  [aux_sym__exported_type_repeat1] = "_exported_type_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_imperative_block_repeat1] = "imperative_block_repeat1",
  [aux_sym_global_block_repeat1] = "global_block_repeat1",
  [aux_sym_struct_block_repeat1] = "struct_block_repeat1",
  [aux_sym_enum_block_repeat1] = "enum_block_repeat1",
  [aux_sym_anon_struct_block_repeat1] = "anon_struct_block_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_in_out_transition_repeat1] = "in_out_transition_repeat1",
  [aux_sym_transitions_definition_repeat1] = "transitions_definition_repeat1",
  [aux_sym_states_definition_repeat1] = "states_definition_repeat1",
  [aux_sym_states_definition_repeat2] = "states_definition_repeat2",
  [aux_sym_animate_body_repeat1] = "animate_body_repeat1",
  [aux_sym_type_list_repeat1] = "type_list_repeat1",
  [aux_sym_tr_repeat1] = "tr_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym_gradient_call_repeat1] = "gradient_call_repeat1",
  [aux_sym_image_call_repeat1] = "image_call_repeat1",
  [aux_sym__function_signature_repeat1] = "_function_signature_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym__string_repeat1] = "_string_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_export] = sym_export,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_component] = anon_sym_component,
  [anon_sym_inherits] = anon_sym_inherits,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LT_EQ_GT] = anon_sym_LT_EQ_GT,
  [anon_sym_global] = anon_sym_global,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_out] = anon_sym_out,
  [anon_sym_transitions] = anon_sym_transitions,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_states] = anon_sym_states,
  [anon_sym_when] = anon_sym_when,
  [anon_sym_animate] = anon_sym_animate,
  [anon_sym_delay] = anon_sym_delay,
  [anon_sym_duration] = anon_sym_duration,
  [anon_sym_iteration_DASHcount] = anon_sym_iteration_DASHcount,
  [anon_sym_easing] = anon_sym_easing,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_ATtr] = anon_sym_ATtr,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_logical_and] = sym_logical_and,
  [sym_logical_or] = sym_logical_or,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_callback] = anon_sym_callback,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_ATimage_DASHurl] = anon_sym_ATimage_DASHurl,
  [anon_sym_9slice] = anon_sym_9slice,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym__unescaped_string_fragment] = sym__unescaped_string_fragment,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [anon_sym_n] = anon_sym_n,
  [anon_sym_in_DASHout] = anon_sym_in_DASHout,
  [sym__identifier] = sym__identifier,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_color] = anon_sym_color,
  [anon_sym_brush] = anon_sym_brush,
  [anon_sym_physical_DASHlength] = anon_sym_physical_DASHlength,
  [anon_sym_length] = anon_sym_length,
  [anon_sym_angle] = anon_sym_angle,
  [anon_sym_percent] = anon_sym_percent,
  [anon_sym_image] = anon_sym_image,
  [anon_sym_relative_DASHfont_DASHsize] = anon_sym_relative_DASHfont_DASHsize,
  [anon_sym_linear] = anon_sym_linear,
  [anon_sym_ease_DASHin_DASHquad] = anon_sym_ease_DASHin_DASHquad,
  [anon_sym_ease_DASHout_DASHquad] = anon_sym_ease_DASHout_DASHquad,
  [anon_sym_ease_DASHin_DASHout_DASHquad] = anon_sym_ease_DASHin_DASHout_DASHquad,
  [anon_sym_ease] = anon_sym_ease,
  [anon_sym_ease_DASHin] = anon_sym_ease_DASHin,
  [anon_sym_ease_DASHout] = anon_sym_ease_DASHout,
  [anon_sym_ease_DASHin_DASHout] = anon_sym_ease_DASHin_DASHout,
  [anon_sym_ease_DASHin_DASHquart] = anon_sym_ease_DASHin_DASHquart,
  [anon_sym_ease_DASHout_DASHquart] = anon_sym_ease_DASHout_DASHquart,
  [anon_sym_ease_DASHin_DASHout_DASHquart] = anon_sym_ease_DASHin_DASHout_DASHquart,
  [anon_sym_ease_DASHin_DASHquint] = anon_sym_ease_DASHin_DASHquint,
  [anon_sym_ease_DASHout_DASHquint] = anon_sym_ease_DASHout_DASHquint,
  [anon_sym_ease_DASHin_DASHout_DASHquint] = anon_sym_ease_DASHin_DASHout_DASHquint,
  [anon_sym_ease_DASHin_DASHexpo] = anon_sym_ease_DASHin_DASHexpo,
  [anon_sym_ease_DASHout_DASHexpo] = anon_sym_ease_DASHout_DASHexpo,
  [anon_sym_ease_DASHin_DASHout_DASHexpo] = anon_sym_ease_DASHin_DASHout_DASHexpo,
  [anon_sym_ease_DASHin_DASHsine] = anon_sym_ease_DASHin_DASHsine,
  [anon_sym_ease_DASHout_DASHsine] = anon_sym_ease_DASHout_DASHsine,
  [anon_sym_ease_DASHin_DASHout_DASHsine] = anon_sym_ease_DASHin_DASHout_DASHsine,
  [anon_sym_ease_DASHin_DASHback] = anon_sym_ease_DASHin_DASHback,
  [anon_sym_ease_DASHout_DASHback] = anon_sym_ease_DASHout_DASHback,
  [anon_sym_ease_DASHin_DASHout_DASHback] = anon_sym_ease_DASHin_DASHout_DASHback,
  [anon_sym_ease_DASHin_DASHcirc] = anon_sym_ease_DASHin_DASHcirc,
  [anon_sym_ease_DASHout_DASHcirc] = anon_sym_ease_DASHout_DASHcirc,
  [anon_sym_ease_DASHin_DASHout_DASHcirc] = anon_sym_ease_DASHin_DASHout_DASHcirc,
  [anon_sym_ease_DASHin_DASHelastic] = anon_sym_ease_DASHin_DASHelastic,
  [anon_sym_ease_DASHout_DASHelastic] = anon_sym_ease_DASHout_DASHelastic,
  [anon_sym_ease_DASHin_DASHout_DASHelastic] = anon_sym_ease_DASHin_DASHout_DASHelastic,
  [anon_sym_ease_DASHin_DASHbounce] = anon_sym_ease_DASHin_DASHbounce,
  [anon_sym_ease_DASHout_DASHbounce] = anon_sym_ease_DASHout_DASHbounce,
  [anon_sym_ease_DASHin_DASHout_DASHbounce] = anon_sym_ease_DASHin_DASHout_DASHbounce,
  [anon_sym_cubic_DASHbezier] = anon_sym_cubic_DASHbezier,
  [sym_children_identifier] = sym_children_identifier,
  [anon_sym_ATlinear_DASHgradient] = anon_sym_ATlinear_DASHgradient,
  [anon_sym_ATlinear_gradient] = anon_sym_ATlinear_gradient,
  [anon_sym_ATradial_DASHgradient] = anon_sym_ATradial_DASHgradient,
  [anon_sym_ATradial_gradient] = anon_sym_ATradial_gradient,
  [anon_sym_circle] = anon_sym_circle,
  [anon_sym_parent] = anon_sym_parent,
  [anon_sym_root] = anon_sym_root,
  [anon_sym_self] = anon_sym_self,
  [sym__int_number] = sym__int_number,
  [sym__float_number] = sym__float_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_color_value] = sym_color_value,
  [anon_sym_phx] = anon_sym_phx,
  [aux_sym_length_value_token1] = aux_sym_length_value_token1,
  [aux_sym_duration_value_token1] = aux_sym_duration_value_token1,
  [aux_sym_angle_value_token1] = aux_sym_angle_value_token1,
  [anon_sym_PERCENT2] = anon_sym_PERCENT,
  [anon_sym_rem] = anon_sym_rem,
  [sym_comment] = sym_comment,
  [sym_sourcefile] = sym_sourcefile,
  [sym__definition] = sym__definition,
  [sym__local_type] = sym__local_type,
  [sym__exported_type] = sym__exported_type,
  [sym_import_statement] = sym_import_statement,
  [sym_export_type] = sym_export_type,
  [sym_import_type] = sym_import_type,
  [sym_component] = sym_component,
  [sym_component_definition] = sym_component_definition,
  [sym__property_type] = sym__property_type,
  [sym_imperative_block] = sym_imperative_block,
  [sym__imperative_block_statement] = sym__imperative_block_statement,
  [sym__binding] = sym__binding,
  [sym_property] = sym_property,
  [sym_binding_alias] = sym_binding_alias,
  [sym_binding] = sym_binding,
  [sym_global_block] = sym_global_block,
  [sym_global_definition] = sym_global_definition,
  [sym_struct_block] = sym_struct_block,
  [sym_struct_definition] = sym_struct_definition,
  [sym_enum_block] = sym_enum_block,
  [sym_enum_definition] = sym_enum_definition,
  [sym_anon_struct_block] = sym_anon_struct_block,
  [sym_block] = sym_block,
  [sym__block_statement] = sym__block_statement,
  [sym_property_assignment] = sym_property_assignment,
  [sym_in_out_transition] = sym_in_out_transition,
  [sym_transitions_definition] = sym_transitions_definition,
  [sym_states_definition] = sym_states_definition,
  [sym_animate_statement] = sym_animate_statement,
  [sym_animate_option_identifier] = sym_animate_option_identifier,
  [sym_animate_option] = sym_animate_option,
  [sym_animate_body] = sym_animate_body,
  [sym_if_expr] = sym_if_expr,
  [sym_if_statement] = sym_if_statement,
  [sym_for_loop] = sym_for_loop,
  [sym_for_range] = sym_for_range,
  [sym_type_list] = sym_type_list,
  [sym_type] = sym_type,
  [sym__assignment_setup] = sym__assignment_setup,
  [sym__assignment_value_block] = sym__assignment_value_block,
  [sym_assignment_block] = sym_assignment_block,
  [sym_assignment_expr] = sym_assignment_expr,
  [sym_expression] = sym_expression,
  [sym_parens_op] = sym_parens_op,
  [sym_index_op] = sym_index_op,
  [sym_tr] = sym_tr,
  [sym_member_access] = sym_member_access,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__add_binary_expression] = sym__add_binary_expression,
  [sym__comparison_binary_expression] = sym__comparison_binary_expression,
  [sym__logic_binary_expression] = sym__logic_binary_expression,
  [sym__mult_binary_expression] = sym__mult_binary_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_callback] = sym_callback,
  [sym_purity] = sym_purity,
  [sym_function_visibility] = sym_function_visibility,
  [sym_function_definition] = sym_function_definition,
  [sym_callback_alias] = sym_callback_alias,
  [sym_callback_event] = sym_callback_event,
  [sym_function_call] = sym_function_call,
  [sym_gradient_call] = sym_gradient_call,
  [sym_gradient_color] = sym_gradient_color,
  [sym_image_call] = sym_image_call,
  [sym_typed_identifier] = sym_typed_identifier,
  [sym__function_signature] = sym__function_signature,
  [sym__callback_signature] = sym__callback_signature,
  [sym_argument] = sym_argument,
  [sym_arguments] = sym_arguments,
  [sym_unary_prec_operator] = sym_unary_prec_operator,
  [sym_add_prec_operator] = sym_add_prec_operator,
  [sym_mult_prec_operator] = sym_mult_prec_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_assignment_prec_operator] = sym_assignment_prec_operator,
  [sym__string] = sym__string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_property_visibility] = sym_property_visibility,
  [sym_simple_identifier] = sym_simple_identifier,
  [sym_simple_indexed_identifier] = sym_simple_indexed_identifier,
  [sym_builtin_type_identifier] = sym_builtin_type_identifier,
  [sym_easing_kind_identifier] = sym_easing_kind_identifier,
  [sym_user_type_identifier] = sym_user_type_identifier,
  [sym__type_identifier] = sym__type_identifier,
  [sym_value_list] = sym_value_list,
  [sym_value] = sym_value,
  [sym_linear_gradient_identifier] = sym_linear_gradient_identifier,
  [sym_radial_gradient_identifier] = sym_radial_gradient_identifier,
  [sym_radial_gradient_kind] = sym_radial_gradient_kind,
  [sym_reference_identifier] = sym_reference_identifier,
  [sym__number] = sym__number,
  [sym_int_value] = sym_int_value,
  [sym_float_value] = sym_float_value,
  [sym_bool_value] = sym_bool_value,
  [sym_string_value] = sym_string_value,
  [sym_physical_length_value] = sym_physical_length_value,
  [sym_length_value] = sym_length_value,
  [sym_duration_value] = sym_duration_value,
  [sym_angle_value] = sym_angle_value,
  [sym_percent_value] = sym_percent_value,
  [sym_relative_font_size_value] = sym_relative_font_size_value,
  [sym__basic_value] = sym__basic_value,
  [aux_sym_sourcefile_repeat1] = aux_sym_sourcefile_repeat1,
  [aux_sym__exported_type_repeat1] = aux_sym__exported_type_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_imperative_block_repeat1] = aux_sym_imperative_block_repeat1,
  [aux_sym_global_block_repeat1] = aux_sym_global_block_repeat1,
  [aux_sym_struct_block_repeat1] = aux_sym_struct_block_repeat1,
  [aux_sym_enum_block_repeat1] = aux_sym_enum_block_repeat1,
  [aux_sym_anon_struct_block_repeat1] = aux_sym_anon_struct_block_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_in_out_transition_repeat1] = aux_sym_in_out_transition_repeat1,
  [aux_sym_transitions_definition_repeat1] = aux_sym_transitions_definition_repeat1,
  [aux_sym_states_definition_repeat1] = aux_sym_states_definition_repeat1,
  [aux_sym_states_definition_repeat2] = aux_sym_states_definition_repeat2,
  [aux_sym_animate_body_repeat1] = aux_sym_animate_body_repeat1,
  [aux_sym_type_list_repeat1] = aux_sym_type_list_repeat1,
  [aux_sym_tr_repeat1] = aux_sym_tr_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym_gradient_call_repeat1] = aux_sym_gradient_call_repeat1,
  [aux_sym_image_call_repeat1] = aux_sym_image_call_repeat1,
  [aux_sym__function_signature_repeat1] = aux_sym__function_signature_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym__string_repeat1] = aux_sym__string_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_export] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_component] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_inherits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_out] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transitions] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_states] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_animate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delay] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_duration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iteration_DASHcount] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_easing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATtr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_logical_and] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_or] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATimage_DASHurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_9slice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__unescaped_string_fragment] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_n] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in_DASHout] = {
    .visible = true,
    .named = false,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_color] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_brush] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_physical_DASHlength] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_length] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_angle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_percent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_image] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_relative_DASHfont_DASHsize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_linear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHquad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHquad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHquad] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHquart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHquart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHquart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHquint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHquint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHquint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHexpo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHexpo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHexpo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHsine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHsine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHsine] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHcirc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHelastic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHelastic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHelastic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHbounce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHout_DASHbounce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ease_DASHin_DASHout_DASHbounce] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_cubic_DASHbezier] = {
    .visible = true,
    .named = false,
  },
  [sym_children_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATlinear_DASHgradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATlinear_gradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATradial_DASHgradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATradial_gradient] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_circle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_root] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_self] = {
    .visible = true,
    .named = false,
  },
  [sym__int_number] = {
    .visible = false,
    .named = true,
  },
  [sym__float_number] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_color_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_phx] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_length_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_duration_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_angle_value_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PERCENT2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rem] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_sourcefile] = {
    .visible = true,
    .named = true,
  },
  [sym__definition] = {
    .visible = false,
    .named = true,
  },
  [sym__local_type] = {
    .visible = false,
    .named = true,
  },
  [sym__exported_type] = {
    .visible = false,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_type] = {
    .visible = true,
    .named = true,
  },
  [sym_import_type] = {
    .visible = true,
    .named = true,
  },
  [sym_component] = {
    .visible = true,
    .named = true,
  },
  [sym_component_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__property_type] = {
    .visible = false,
    .named = true,
  },
  [sym_imperative_block] = {
    .visible = true,
    .named = true,
  },
  [sym__imperative_block_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__binding] = {
    .visible = false,
    .named = true,
  },
  [sym_property] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_global_block] = {
    .visible = true,
    .named = true,
  },
  [sym_global_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_block] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_block] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_anon_struct_block] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__block_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_property_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_in_out_transition] = {
    .visible = true,
    .named = true,
  },
  [sym_transitions_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_states_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_option_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_option] = {
    .visible = true,
    .named = true,
  },
  [sym_animate_body] = {
    .visible = true,
    .named = true,
  },
  [sym_if_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_for_range] = {
    .visible = true,
    .named = true,
  },
  [sym_type_list] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym__assignment_setup] = {
    .visible = false,
    .named = true,
  },
  [sym__assignment_value_block] = {
    .visible = false,
    .named = true,
  },
  [sym_assignment_block] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parens_op] = {
    .visible = true,
    .named = true,
  },
  [sym_index_op] = {
    .visible = true,
    .named = true,
  },
  [sym_tr] = {
    .visible = true,
    .named = true,
  },
  [sym_member_access] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__add_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__comparison_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__logic_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__mult_binary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_callback] = {
    .visible = true,
    .named = true,
  },
  [sym_purity] = {
    .visible = true,
    .named = true,
  },
  [sym_function_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_callback_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_callback_event] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_gradient_call] = {
    .visible = true,
    .named = true,
  },
  [sym_gradient_color] = {
    .visible = true,
    .named = true,
  },
  [sym_image_call] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__function_signature] = {
    .visible = false,
    .named = true,
  },
  [sym__callback_signature] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_add_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_mult_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_prec_operator] = {
    .visible = true,
    .named = true,
  },
  [sym__string] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_property_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_indexed_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_easing_kind_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_user_type_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__type_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_value_list] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_linear_gradient_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_radial_gradient_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_radial_gradient_kind] = {
    .visible = true,
    .named = true,
  },
  [sym_reference_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__number] = {
    .visible = false,
    .named = true,
  },
  [sym_int_value] = {
    .visible = true,
    .named = true,
  },
  [sym_float_value] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_value] = {
    .visible = true,
    .named = true,
  },
  [sym_string_value] = {
    .visible = true,
    .named = true,
  },
  [sym_physical_length_value] = {
    .visible = true,
    .named = true,
  },
  [sym_length_value] = {
    .visible = true,
    .named = true,
  },
  [sym_duration_value] = {
    .visible = true,
    .named = true,
  },
  [sym_angle_value] = {
    .visible = true,
    .named = true,
  },
  [sym_percent_value] = {
    .visible = true,
    .named = true,
  },
  [sym_relative_font_size_value] = {
    .visible = true,
    .named = true,
  },
  [sym__basic_value] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_sourcefile_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__exported_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_imperative_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_global_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_anon_struct_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_in_out_transition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_transitions_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_states_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_states_definition_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_animate_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gradient_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_image_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__string_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_action = 1,
  field_alias = 2,
  field_angle = 3,
  field_arguments = 4,
  field_base = 5,
  field_base_type = 6,
  field_binding = 7,
  field_binding_op = 8,
  field_colors = 9,
  field_condition = 10,
  field_context = 11,
  field_export_name = 12,
  field_expression = 13,
  field_id = 14,
  field_identifier = 15,
  field_image = 16,
  field_import_name = 17,
  field_index = 18,
  field_index_var = 19,
  field_left = 20,
  field_local_name = 21,
  field_member = 22,
  field_message = 23,
  field_name = 24,
  field_op = 25,
  field_option = 26,
  field_percent = 27,
  field_pipe = 28,
  field_property = 29,
  field_range = 30,
  field_return_type = 31,
  field_right = 32,
  field_type = 33,
  field_value = 34,
  field_visibility = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_action] = "action",
  [field_alias] = "alias",
  [field_angle] = "angle",
  [field_arguments] = "arguments",
  [field_base] = "base",
  [field_base_type] = "base_type",
  [field_binding] = "binding",
  [field_binding_op] = "binding_op",
  [field_colors] = "colors",
  [field_condition] = "condition",
  [field_context] = "context",
  [field_export_name] = "export_name",
  [field_expression] = "expression",
  [field_id] = "id",
  [field_identifier] = "identifier",
  [field_image] = "image",
  [field_import_name] = "import_name",
  [field_index] = "index",
  [field_index_var] = "index_var",
  [field_left] = "left",
  [field_local_name] = "local_name",
  [field_member] = "member",
  [field_message] = "message",
  [field_name] = "name",
  [field_op] = "op",
  [field_option] = "option",
  [field_percent] = "percent",
  [field_pipe] = "pipe",
  [field_property] = "property",
  [field_range] = "range",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_type] = "type",
  [field_value] = "value",
  [field_visibility] = "visibility",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 1},
  [5] = {.index = 4, .length = 2},
  [6] = {.index = 6, .length = 2},
  [7] = {.index = 8, .length = 2},
  [8] = {.index = 10, .length = 3},
  [9] = {.index = 13, .length = 1},
  [10] = {.index = 14, .length = 2},
  [11] = {.index = 16, .length = 1},
  [12] = {.index = 17, .length = 2},
  [13] = {.index = 19, .length = 2},
  [14] = {.index = 21, .length = 2},
  [15] = {.index = 23, .length = 2},
  [16] = {.index = 25, .length = 2},
  [17] = {.index = 27, .length = 2},
  [18] = {.index = 29, .length = 1},
  [19] = {.index = 30, .length = 2},
  [20] = {.index = 32, .length = 3},
  [21] = {.index = 35, .length = 1},
  [22] = {.index = 36, .length = 2},
  [23] = {.index = 38, .length = 1},
  [24] = {.index = 39, .length = 1},
  [25] = {.index = 40, .length = 2},
  [26] = {.index = 42, .length = 1},
  [27] = {.index = 43, .length = 2},
  [28] = {.index = 45, .length = 3},
  [29] = {.index = 48, .length = 2},
  [30] = {.index = 50, .length = 2},
  [31] = {.index = 52, .length = 1},
  [32] = {.index = 53, .length = 2},
  [33] = {.index = 55, .length = 2},
  [34] = {.index = 57, .length = 1},
  [35] = {.index = 58, .length = 4},
  [36] = {.index = 62, .length = 2},
  [37] = {.index = 64, .length = 2},
  [38] = {.index = 66, .length = 1},
  [39] = {.index = 67, .length = 2},
  [40] = {.index = 69, .length = 3},
  [41] = {.index = 72, .length = 3},
  [42] = {.index = 75, .length = 2},
  [43] = {.index = 77, .length = 2},
  [44] = {.index = 79, .length = 3},
  [45] = {.index = 82, .length = 3},
  [46] = {.index = 85, .length = 4},
  [47] = {.index = 89, .length = 4},
  [48] = {.index = 93, .length = 3},
  [49] = {.index = 96, .length = 2},
  [50] = {.index = 98, .length = 3},
  [51] = {.index = 101, .length = 2},
  [52] = {.index = 103, .length = 2},
  [53] = {.index = 105, .length = 3},
  [54] = {.index = 108, .length = 2},
  [55] = {.index = 110, .length = 2},
  [56] = {.index = 112, .length = 2},
  [57] = {.index = 114, .length = 2},
  [58] = {.index = 116, .length = 2},
  [59] = {.index = 118, .length = 5},
  [60] = {.index = 123, .length = 3},
  [61] = {.index = 126, .length = 3},
  [62] = {.index = 129, .length = 3},
  [63] = {.index = 132, .length = 2},
  [64] = {.index = 134, .length = 3},
  [65] = {.index = 137, .length = 3},
  [66] = {.index = 140, .length = 4},
  [67] = {.index = 144, .length = 4},
  [68] = {.index = 148, .length = 5},
  [69] = {.index = 153, .length = 5},
  [70] = {.index = 158, .length = 3},
  [71] = {.index = 161, .length = 6},
  [72] = {.index = 167, .length = 6},
  [73] = {.index = 173, .length = 6},
  [74] = {.index = 179, .length = 7},
  [75] = {.index = 186, .length = 7},
  [76] = {.index = 193, .length = 7},
  [77] = {.index = 200, .length = 7},
  [78] = {.index = 207, .length = 7},
  [79] = {.index = 214, .length = 5},
  [80] = {.index = 219, .length = 5},
  [81] = {.index = 224, .length = 8},
  [82] = {.index = 232, .length = 8},
  [83] = {.index = 240, .length = 6},
  [84] = {.index = 246, .length = 7},
  [85] = {.index = 253, .length = 7},
  [86] = {.index = 260, .length = 8},
  [87] = {.index = 268, .length = 9},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_local_name, 0},
  [1] =
    {field_import_name, 0},
  [2] =
    {field_name, 1},
  [3] =
    {field_value, 0},
  [4] =
    {field_base_type, 2},
    {field_name, 0},
  [6] =
    {field_export_name, 2},
    {field_local_name, 0},
  [8] =
    {field_import_name, 0},
    {field_local_name, 2},
  [10] =
    {field_left, 0, .inherited = true},
    {field_op, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [13] =
    {field_name, 0},
  [14] =
    {field_arguments, 1},
    {field_name, 0},
  [16] =
    {field_type, 0},
  [17] =
    {field_base_type, 3},
    {field_name, 1},
  [19] =
    {field_left, 1},
    {field_op, 0},
  [21] =
    {field_action, 2},
    {field_name, 0},
  [23] =
    {field_property, 0},
    {field_value, 2},
  [25] =
    {field_name, 1},
    {field_name, 2, .inherited = true},
  [27] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [29] =
    {field_left, 1},
  [30] =
    {field_base, 0},
    {field_member, 2},
  [32] =
    {field_left, 0},
    {field_op, 1},
    {field_right, 2},
  [35] =
    {field_type, 1},
  [36] =
    {field_name, 2},
    {field_type, 1, .inherited = true},
  [38] =
    {field_name, 2, .inherited = true},
  [39] =
    {field_condition, 1},
  [40] =
    {field_arguments, 2, .inherited = true},
    {field_name, 1},
  [42] =
    {field_name, 2},
  [43] =
    {field_id, 0},
    {field_type, 2},
  [45] =
    {field_property, 0},
    {field_value, 2},
    {field_value, 3},
  [48] =
    {field_alias, 2},
    {field_name, 0},
  [50] =
    {field_name, 1},
    {field_type, 3},
  [52] =
    {field_message, 2},
  [53] =
    {field_image, 2},
    {field_name, 0},
  [55] =
    {field_index, 2},
    {field_left, 0},
  [57] =
    {field_binding, 0},
  [58] =
    {field_binding, 4, .inherited = true},
    {field_binding_op, 3},
    {field_name, 2},
    {field_type, 1, .inherited = true},
  [62] =
    {field_alias, 3},
    {field_name, 1},
  [64] =
    {field_index_var, 2},
    {field_name, 0},
  [66] =
    {field_arguments, 1},
  [67] =
    {field_name, 1},
    {field_return_type, 3},
  [69] =
    {field_name, 0, .inherited = true},
    {field_op, 0, .inherited = true},
    {field_value, 1, .inherited = true},
  [72] =
    {field_name, 0, .inherited = true},
    {field_op, 0, .inherited = true},
    {field_value, 1},
  [75] =
    {field_name, 0},
    {field_op, 1},
  [77] =
    {field_arguments, 3, .inherited = true},
    {field_name, 2},
  [79] =
    {field_name, 3},
    {field_type, 2, .inherited = true},
    {field_visibility, 0},
  [82] =
    {field_alias, 3},
    {field_name, 1},
    {field_visibility, 0},
  [85] =
    {field_name, 1},
    {field_name, 4, .inherited = true},
    {field_type, 3},
    {field_type, 4, .inherited = true},
  [89] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [93] =
    {field_condition, 0},
    {field_left, 2},
    {field_right, 4},
  [96] =
    {field_binding, 0},
    {field_binding, 1},
  [98] =
    {field_binding_op, 3},
    {field_name, 2},
    {field_type, 1, .inherited = true},
  [101] =
    {field_identifier, 1},
    {field_range, 3},
  [103] =
    {field_arguments, 1},
    {field_arguments, 2},
  [105] =
    {field_arguments, 2, .inherited = true},
    {field_name, 1},
    {field_return_type, 4},
  [108] =
    {field_value, 0},
    {field_value, 1},
  [110] =
    {field_binding, 2, .inherited = true},
    {field_name, 0},
  [112] =
    {field_name, 0},
    {field_type, 2},
  [114] =
    {field_alias, 4},
    {field_name, 2},
  [116] =
    {field_name, 2},
    {field_return_type, 4},
  [118] =
    {field_binding, 5, .inherited = true},
    {field_binding_op, 4},
    {field_name, 3},
    {field_type, 2, .inherited = true},
    {field_visibility, 0},
  [123] =
    {field_alias, 4},
    {field_name, 2},
    {field_visibility, 0},
  [126] =
    {field_arguments, 3},
    {field_arguments, 4},
    {field_message, 2},
  [129] =
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [132] =
    {field_expression, 2},
    {field_option, 0},
  [134] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_arguments, 3},
  [137] =
    {field_arguments, 3, .inherited = true},
    {field_name, 2},
    {field_return_type, 5},
  [140] =
    {field_binding_op, 4},
    {field_name, 3},
    {field_type, 2, .inherited = true},
    {field_visibility, 0},
  [144] =
    {field_arguments, 3},
    {field_arguments, 4},
    {field_arguments, 5},
    {field_message, 2},
  [148] =
    {field_arguments, 3},
    {field_arguments, 4},
    {field_arguments, 5},
    {field_arguments, 6},
    {field_message, 2},
  [153] =
    {field_arguments, 5},
    {field_arguments, 6},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [158] =
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [161] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
  [167] =
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
    {field_type, 2},
  [173] =
    {field_arguments, 5},
    {field_arguments, 6},
    {field_arguments, 7},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [179] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_arguments, 7},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
  [186] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
  [193] =
    {field_arguments, 3},
    {field_arguments, 7},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_name, 0},
    {field_type, 2},
  [200] =
    {field_arguments, 3},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
    {field_type, 2},
  [207] =
    {field_arguments, 5},
    {field_arguments, 6},
    {field_arguments, 7},
    {field_arguments, 8},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
  [214] =
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
  [219] =
    {field_arguments, 7},
    {field_arguments, 8},
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [224] =
    {field_angle, 2},
    {field_arguments, 3},
    {field_arguments, 8},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
  [232] =
    {field_arguments, 3},
    {field_arguments, 8},
    {field_colors, 4},
    {field_colors, 5},
    {field_colors, 6},
    {field_colors, 7},
    {field_name, 0},
    {field_type, 2},
  [240] =
    {field_arguments, 7},
    {field_arguments, 8},
    {field_arguments, 9},
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [246] =
    {field_arguments, 9},
    {field_arguments, 10},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
  [253] =
    {field_arguments, 7},
    {field_arguments, 8},
    {field_arguments, 9},
    {field_arguments, 10},
    {field_message, 2},
    {field_percent, 6},
    {field_pipe, 4},
  [260] =
    {field_arguments, 9},
    {field_arguments, 10},
    {field_arguments, 11},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
  [268] =
    {field_arguments, 9},
    {field_arguments, 10},
    {field_arguments, 11},
    {field_arguments, 12},
    {field_context, 2},
    {field_context, 3},
    {field_message, 4},
    {field_percent, 8},
    {field_pipe, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 2,
  [7] = 7,
  [8] = 7,
  [9] = 9,
  [10] = 9,
  [11] = 7,
  [12] = 9,
  [13] = 9,
  [14] = 14,
  [15] = 7,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 19,
  [22] = 22,
  [23] = 23,
  [24] = 22,
  [25] = 23,
  [26] = 20,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 31,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 33,
  [39] = 37,
  [40] = 40,
  [41] = 41,
  [42] = 27,
  [43] = 30,
  [44] = 40,
  [45] = 45,
  [46] = 40,
  [47] = 28,
  [48] = 36,
  [49] = 49,
  [50] = 35,
  [51] = 41,
  [52] = 29,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 55,
  [59] = 56,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 60,
  [66] = 61,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 57,
  [71] = 63,
  [72] = 72,
  [73] = 64,
  [74] = 62,
  [75] = 75,
  [76] = 53,
  [77] = 68,
  [78] = 72,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 85,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 96,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 98,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 79,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 89,
  [114] = 101,
  [115] = 88,
  [116] = 99,
  [117] = 105,
  [118] = 108,
  [119] = 87,
  [120] = 94,
  [121] = 121,
  [122] = 122,
  [123] = 96,
  [124] = 124,
  [125] = 107,
  [126] = 126,
  [127] = 124,
  [128] = 81,
  [129] = 124,
  [130] = 80,
  [131] = 131,
  [132] = 97,
  [133] = 110,
  [134] = 88,
  [135] = 106,
  [136] = 103,
  [137] = 95,
  [138] = 91,
  [139] = 83,
  [140] = 110,
  [141] = 93,
  [142] = 92,
  [143] = 82,
  [144] = 83,
  [145] = 91,
  [146] = 95,
  [147] = 103,
  [148] = 106,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 229,
  [231] = 229,
  [232] = 228,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 234,
  [243] = 243,
  [244] = 235,
  [245] = 245,
  [246] = 237,
  [247] = 236,
  [248] = 240,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 239,
  [257] = 238,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 267,
  [269] = 267,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 270,
  [274] = 270,
  [275] = 270,
  [276] = 271,
  [277] = 228,
  [278] = 150,
  [279] = 149,
  [280] = 228,
  [281] = 161,
  [282] = 152,
  [283] = 156,
  [284] = 192,
  [285] = 165,
  [286] = 163,
  [287] = 162,
  [288] = 158,
  [289] = 157,
  [290] = 224,
  [291] = 164,
  [292] = 208,
  [293] = 155,
  [294] = 159,
  [295] = 154,
  [296] = 166,
  [297] = 160,
  [298] = 153,
  [299] = 200,
  [300] = 190,
  [301] = 215,
  [302] = 184,
  [303] = 205,
  [304] = 204,
  [305] = 196,
  [306] = 228,
  [307] = 176,
  [308] = 189,
  [309] = 186,
  [310] = 183,
  [311] = 220,
  [312] = 181,
  [313] = 195,
  [314] = 187,
  [315] = 182,
  [316] = 221,
  [317] = 180,
  [318] = 217,
  [319] = 209,
  [320] = 179,
  [321] = 198,
  [322] = 199,
  [323] = 202,
  [324] = 178,
  [325] = 203,
  [326] = 167,
  [327] = 175,
  [328] = 174,
  [329] = 218,
  [330] = 219,
  [331] = 222,
  [332] = 223,
  [333] = 225,
  [334] = 210,
  [335] = 211,
  [336] = 172,
  [337] = 212,
  [338] = 188,
  [339] = 213,
  [340] = 171,
  [341] = 194,
  [342] = 177,
  [343] = 168,
  [344] = 193,
  [345] = 206,
  [346] = 197,
  [347] = 173,
  [348] = 201,
  [349] = 214,
  [350] = 169,
  [351] = 170,
  [352] = 207,
  [353] = 191,
  [354] = 150,
  [355] = 149,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 363,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 369,
  [374] = 374,
  [375] = 364,
  [376] = 376,
  [377] = 377,
  [378] = 370,
  [379] = 165,
  [380] = 163,
  [381] = 157,
  [382] = 162,
  [383] = 158,
  [384] = 152,
  [385] = 156,
  [386] = 164,
  [387] = 387,
  [388] = 387,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 394,
  [396] = 396,
  [397] = 392,
  [398] = 398,
  [399] = 391,
  [400] = 400,
  [401] = 398,
  [402] = 393,
  [403] = 396,
  [404] = 227,
  [405] = 405,
  [406] = 405,
  [407] = 390,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 408,
  [414] = 411,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 233,
  [423] = 415,
  [424] = 417,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 417,
  [430] = 430,
  [431] = 431,
  [432] = 426,
  [433] = 418,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 435,
  [440] = 440,
  [441] = 416,
  [442] = 437,
  [443] = 443,
  [444] = 440,
  [445] = 435,
  [446] = 431,
  [447] = 436,
  [448] = 421,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 451,
  [455] = 455,
  [456] = 453,
  [457] = 457,
  [458] = 457,
  [459] = 234,
  [460] = 460,
  [461] = 450,
  [462] = 245,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 254,
  [468] = 255,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 239,
  [490] = 490,
  [491] = 491,
  [492] = 235,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 234,
  [518] = 245,
  [519] = 480,
  [520] = 239,
  [521] = 469,
  [522] = 503,
  [523] = 255,
  [524] = 476,
  [525] = 479,
  [526] = 475,
  [527] = 483,
  [528] = 484,
  [529] = 495,
  [530] = 486,
  [531] = 505,
  [532] = 482,
  [533] = 473,
  [534] = 506,
  [535] = 488,
  [536] = 498,
  [537] = 507,
  [538] = 254,
  [539] = 465,
  [540] = 493,
  [541] = 471,
  [542] = 466,
  [543] = 491,
  [544] = 472,
  [545] = 487,
  [546] = 508,
  [547] = 496,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 235,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 557,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 559,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 501,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 583,
  [585] = 581,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 590,
  [597] = 597,
  [598] = 598,
  [599] = 597,
  [600] = 598,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 602,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 604,
  [617] = 617,
  [618] = 607,
  [619] = 609,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 624,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 626,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 632,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 620,
  [647] = 647,
  [648] = 648,
  [649] = 635,
  [650] = 644,
  [651] = 631,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 249,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 654,
  [661] = 661,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 655,
  [669] = 669,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 658,
  [680] = 680,
  [681] = 665,
  [682] = 682,
  [683] = 683,
  [684] = 258,
  [685] = 685,
  [686] = 686,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 682,
  [704] = 683,
  [705] = 664,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 670,
  [715] = 715,
  [716] = 693,
  [717] = 250,
  [718] = 718,
  [719] = 712,
  [720] = 698,
  [721] = 721,
  [722] = 706,
  [723] = 661,
  [724] = 678,
  [725] = 725,
  [726] = 726,
  [727] = 671,
  [728] = 728,
  [729] = 694,
  [730] = 725,
  [731] = 728,
  [732] = 732,
  [733] = 715,
  [734] = 734,
  [735] = 735,
  [736] = 699,
  [737] = 696,
  [738] = 707,
  [739] = 739,
  [740] = 740,
  [741] = 721,
  [742] = 742,
  [743] = 743,
  [744] = 697,
  [745] = 695,
  [746] = 746,
  [747] = 747,
  [748] = 680,
  [749] = 709,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 490,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 760,
  [761] = 761,
  [762] = 758,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 776,
  [781] = 781,
  [782] = 761,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 470,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 757,
  [794] = 794,
  [795] = 494,
  [796] = 794,
  [797] = 797,
  [798] = 775,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 752,
  [804] = 786,
  [805] = 805,
  [806] = 784,
  [807] = 807,
  [808] = 765,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 771,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 814,
  [824] = 824,
  [825] = 825,
  [826] = 781,
  [827] = 827,
  [828] = 828,
  [829] = 765,
  [830] = 830,
  [831] = 754,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 841,
  [853] = 853,
  [854] = 853,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 850,
  [878] = 878,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 857,
  [886] = 875,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 846,
  [892] = 849,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 881,
  [898] = 898,
  [899] = 855,
  [900] = 844,
  [901] = 834,
  [902] = 840,
  [903] = 872,
  [904] = 867,
  [905] = 862,
  [906] = 858,
  [907] = 833,
  [908] = 845,
  [909] = 909,
  [910] = 848,
  [911] = 895,
  [912] = 912,
  [913] = 874,
  [914] = 884,
  [915] = 871,
  [916] = 896,
  [917] = 917,
  [918] = 909,
  [919] = 876,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(429);
      if (lookahead == '!') ADVANCE(512);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '%') ADVANCE(988);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(515);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(454);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(445);
      if (lookahead == '=') ADVANCE(528);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(99);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == '\\') ADVANCE(540);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'a') ADVANCE(254);
      if (lookahead == 'b') ADVANCE(293);
      if (lookahead == 'c') ADVANCE(42);
      if (lookahead == 'd') ADVANCE(122);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'f') ADVANCE(50);
      if (lookahead == 'g') ADVANCE(231);
      if (lookahead == 'i') ADVANCE(165);
      if (lookahead == 'l') ADVANCE(143);
      if (lookahead == 'm') ADVANCE(248);
      if (lookahead == 'n') ADVANCE(542);
      if (lookahead == 'o') ADVANCE(397);
      if (lookahead == 'p') ADVANCE(58);
      if (lookahead == 'r') ADVANCE(46);
      if (lookahead == 's') ADVANCE(983);
      if (lookahead == 't') ADVANCE(319);
      if (lookahead == 'u') ADVANCE(421);
      if (lookahead == 'w') ADVANCE(185);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(491);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(427)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(512);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '%') ADVANCE(988);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(528);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(847);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == 'f') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(643);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'p') ADVANCE(561);
      if (lookahead == 'r') ADVANCE(631);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 't') ADVANCE(781);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(512);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '%') ADVANCE(988);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(527);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(704);
      if (lookahead == 'd') ADVANCE(619);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == 'f') ADVANCE(556);
      if (lookahead == 'g') ADVANCE(783);
      if (lookahead == 'i') ADVANCE(641);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'm') ADVANCE(703);
      if (lookahead == 'p') ADVANCE(560);
      if (lookahead == 'r') ADVANCE(551);
      if (lookahead == 's') ADVANCE(984);
      if (lookahead == 't') ADVANCE(780);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(512);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(528);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(847);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == 'f') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(643);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'p') ADVANCE(561);
      if (lookahead == 'r') ADVANCE(631);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 't') ADVANCE(781);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(512);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(527);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(847);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == 'f') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(643);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'p') ADVANCE(561);
      if (lookahead == 'r') ADVANCE(631);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 't') ADVANCE(781);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(512);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == '*') ADVANCE(518);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(520);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(37);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(847);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == 'f') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(714);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'o') ADVANCE(856);
      if (lookahead == 'p') ADVANCE(561);
      if (lookahead == 'r') ADVANCE(750);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 't') ADVANCE(781);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '%') ADVANCE(988);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(527);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'c') ADVANCE(247);
      if (lookahead == 'd') ADVANCE(147);
      if (lookahead == 'g') ADVANCE(339);
      if (lookahead == 'i') ADVANCE(255);
      if (lookahead == 'm') ADVANCE(248);
      if (lookahead == 'p') ADVANCE(183);
      if (lookahead == 'r') ADVANCE(47);
      if (lookahead == 's') ADVANCE(982);
      if (lookahead == 't') ADVANCE(401);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '%') ADVANCE(988);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(518);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(520);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(37);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(247);
      if (lookahead == 'd') ADVANCE(147);
      if (lookahead == 'g') ADVANCE(339);
      if (lookahead == 'i') ADVANCE(255);
      if (lookahead == 'm') ADVANCE(248);
      if (lookahead == 'p') ADVANCE(183);
      if (lookahead == 'r') ADVANCE(47);
      if (lookahead == 's') ADVANCE(982);
      if (lookahead == 't') ADVANCE(401);
      if (lookahead == '|') ADVANCE(422);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '%') ADVANCE(492);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(528);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'a') ADVANCE(719);
      if (lookahead == 'b') ADVANCE(756);
      if (lookahead == 'c') ADVANCE(759);
      if (lookahead == 'd') ADVANCE(855);
      if (lookahead == 'e') ADVANCE(574);
      if (lookahead == 'f') ADVANCE(692);
      if (lookahead == 'i') ADVANCE(706);
      if (lookahead == 'l') ADVANCE(634);
      if (lookahead == 'p') ADVANCE(638);
      if (lookahead == 'r') ADVANCE(632);
      if (lookahead == 's') ADVANCE(836);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(491);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(515);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(445);
      if (lookahead == '=') ADVANCE(528);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'i') ADVANCE(256);
      if (lookahead == 'o') ADVANCE(397);
      if (lookahead == 'w') ADVANCE(185);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9)
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(527);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10)
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(518);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(520);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(37);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == '|') ADVANCE(422);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '*') ADVANCE(518);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(520);
      if (lookahead == '9') ADVANCE(358);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(37);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(98);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'a') ADVANCE(727);
      if (lookahead == 'c') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(755);
      if (lookahead == 'i') ADVANCE(642);
      if (lookahead == 'o') ADVANCE(856);
      if (lookahead == 'p') ADVANCE(777);
      if (lookahead == 's') ADVANCE(833);
      if (lookahead == 't') ADVANCE(784);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '*') ADVANCE(518);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(520);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(37);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'i') ADVANCE(256);
      if (lookahead == 'o') ADVANCE(397);
      if (lookahead == '|') ADVANCE(422);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13)
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '*') ADVANCE(518);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(520);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(37);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(562);
      if (lookahead == 'f') ADVANCE(853);
      if (lookahead == 'i') ADVANCE(716);
      if (lookahead == 'o') ADVANCE(856);
      if (lookahead == 'p') ADVANCE(777);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(511);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(424);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == ':') ADVANCE(454);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '=') ADVANCE(40);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'c') ADVANCE(847);
      if (lookahead == 'e') ADVANCE(549);
      if (lookahead == 'f') ADVANCE(556);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'p') ADVANCE(561);
      if (lookahead == 'r') ADVANCE(750);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 't') ADVANCE(781);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(490);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(511);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == '+') ADVANCE(516);
      if (lookahead == '-') ADVANCE(513);
      if (lookahead == '.') ADVANCE(424);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '@') ADVANCE(187);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == 'c') ADVANCE(847);
      if (lookahead == 'e') ADVANCE(548);
      if (lookahead == 'f') ADVANCE(556);
      if (lookahead == 'i') ADVANCE(643);
      if (lookahead == 'l') ADVANCE(676);
      if (lookahead == 'p') ADVANCE(561);
      if (lookahead == 'r') ADVANCE(631);
      if (lookahead == 's') ADVANCE(629);
      if (lookahead == 't') ADVANCE(781);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '/') ADVANCE(534);
      if (lookahead == '\\') ADVANCE(540);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(537);
      if (lookahead != 0) ADVANCE(539);
      END_STATE();
    case 18:
      if (lookahead == '&') ADVANCE(495);
      END_STATE();
    case 19:
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(39);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == ':') ADVANCE(36);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '>') ADVANCE(447);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'a') ADVANCE(347);
      if (lookahead == 'i') ADVANCE(287);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19)
      END_STATE();
    case 20:
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == '<') ADVANCE(444);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 21:
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(992);
      END_STATE();
    case 22:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead == '/') ADVANCE(991);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 23:
      if (lookahead == '*') ADVANCE(22);
      if (lookahead != 0) ADVANCE(23);
      END_STATE();
    case 24:
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == 'a') ADVANCE(727);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(24)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 25:
      if (lookahead == '-') ADVANCE(167);
      END_STATE();
    case 26:
      if (lookahead == '-') ADVANCE(86);
      END_STATE();
    case 27:
      if (lookahead == '-') ADVANCE(175);
      if (lookahead == '_') ADVANCE(177);
      END_STATE();
    case 28:
      if (lookahead == '-') ADVANCE(103);
      END_STATE();
    case 29:
      if (lookahead == '-') ADVANCE(405);
      END_STATE();
    case 30:
      if (lookahead == '-') ADVANCE(355);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(237);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(178);
      if (lookahead == '_') ADVANCE(179);
      END_STATE();
    case 33:
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == 'f') ADVANCE(853);
      if (lookahead == 'p') ADVANCE(777);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 34:
      if (lookahead == '/') ADVANCE(21);
      if (lookahead == 'p') ADVANCE(789);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(34)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 35:
      if (lookahead == '=') ADVANCE(526);
      END_STATE();
    case 36:
      if (lookahead == '=') ADVANCE(440);
      END_STATE();
    case 37:
      if (lookahead == '=') ADVANCE(525);
      END_STATE();
    case 38:
      if (lookahead == '=') ADVANCE(41);
      END_STATE();
    case 39:
      if (lookahead == '>') ADVANCE(500);
      END_STATE();
    case 40:
      if (lookahead == '>') ADVANCE(489);
      END_STATE();
    case 41:
      if (lookahead == '>') ADVANCE(455);
      END_STATE();
    case 42:
      if (lookahead == 'a') ADVANCE(233);
      if (lookahead == 'i') ADVANCE(321);
      if (lookahead == 'm') ADVANCE(980);
      if (lookahead == 'o') ADVANCE(232);
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(233);
      if (lookahead == 'i') ADVANCE(321);
      if (lookahead == 'o') ADVANCE(232);
      if (lookahead == 'u') ADVANCE(82);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(350);
      if (lookahead == 'l') ADVANCE(352);
      if (lookahead == 'n') ADVANCE(399);
      if (lookahead == 'x') ADVANCE(317);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(112);
      if (lookahead == 'e') ADVANCE(240);
      if (lookahead == 'o') ADVANCE(298);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(112);
      if (lookahead == 'e') ADVANCE(249);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(173);
      if (lookahead == 'p') ADVANCE(306);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(113);
      if (lookahead == 'i') ADVANCE(275);
      END_STATE();
    case 50:
      if (lookahead == 'a') ADVANCE(239);
      if (lookahead == 'l') ADVANCE(300);
      if (lookahead == 'o') ADVANCE(322);
      if (lookahead == 'r') ADVANCE(299);
      if (lookahead == 'u') ADVANCE(264);
      END_STATE();
    case 51:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(416);
      END_STATE();
    case 53:
      if (lookahead == 'a') ADVANCE(114);
      if (lookahead == 'i') ADVANCE(279);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(385);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(115);
      if (lookahead == 'i') ADVANCE(286);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(267);
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 57:
      if (lookahead == 'a') ADVANCE(363);
      END_STATE();
    case 58:
      if (lookahead == 'a') ADVANCE(340);
      if (lookahead == 'e') ADVANCE(327);
      if (lookahead == 'h') ADVANCE(415);
      if (lookahead == 'r') ADVANCE(188);
      if (lookahead == 't' ||
          lookahead == 'x') ADVANCE(980);
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 59:
      if (lookahead == 'a') ADVANCE(340);
      if (lookahead == 'e') ADVANCE(327);
      if (lookahead == 'h') ADVANCE(418);
      if (lookahead == 'r') ADVANCE(188);
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 60:
      if (lookahead == 'a') ADVANCE(389);
      END_STATE();
    case 61:
      if (lookahead == 'a') ADVANCE(356);
      END_STATE();
    case 62:
      if (lookahead == 'a') ADVANCE(91);
      END_STATE();
    case 63:
      if (lookahead == 'a') ADVANCE(100);
      if (lookahead == 'o') ADVANCE(406);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(225);
      END_STATE();
    case 65:
      if (lookahead == 'a') ADVANCE(101);
      if (lookahead == 'o') ADVANCE(408);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(246);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(324);
      END_STATE();
    case 68:
      if (lookahead == 'a') ADVANCE(229);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(325);
      END_STATE();
    case 70:
      if (lookahead == 'a') ADVANCE(102);
      if (lookahead == 'o') ADVANCE(410);
      END_STATE();
    case 71:
      if (lookahead == 'a') ADVANCE(174);
      END_STATE();
    case 72:
      if (lookahead == 'a') ADVANCE(117);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(386);
      END_STATE();
    case 74:
      if (lookahead == 'a') ADVANCE(390);
      END_STATE();
    case 75:
      if (lookahead == 'a') ADVANCE(359);
      END_STATE();
    case 76:
      if (lookahead == 'a') ADVANCE(119);
      END_STATE();
    case 77:
      if (lookahead == 'a') ADVANCE(396);
      END_STATE();
    case 78:
      if (lookahead == 'a') ADVANCE(360);
      END_STATE();
    case 79:
      if (lookahead == 'a') ADVANCE(120);
      END_STATE();
    case 80:
      if (lookahead == 'a') ADVANCE(121);
      END_STATE();
    case 81:
      if (lookahead == 'b') ADVANCE(63);
      if (lookahead == 'c') ADVANCE(199);
      if (lookahead == 'e') ADVANCE(235);
      if (lookahead == 'o') ADVANCE(404);
      if (lookahead == 'q') ADVANCE(398);
      if (lookahead == 's') ADVANCE(204);
      END_STATE();
    case 82:
      if (lookahead == 'b') ADVANCE(191);
      END_STATE();
    case 83:
      if (lookahead == 'b') ADVANCE(64);
      END_STATE();
    case 84:
      if (lookahead == 'b') ADVANCE(242);
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 85:
      if (lookahead == 'b') ADVANCE(62);
      END_STATE();
    case 86:
      if (lookahead == 'b') ADVANCE(134);
      END_STATE();
    case 87:
      if (lookahead == 'b') ADVANCE(65);
      if (lookahead == 'c') ADVANCE(201);
      if (lookahead == 'e') ADVANCE(244);
      if (lookahead == 'q') ADVANCE(407);
      if (lookahead == 's') ADVANCE(208);
      END_STATE();
    case 88:
      if (lookahead == 'b') ADVANCE(70);
      if (lookahead == 'c') ADVANCE(202);
      if (lookahead == 'e') ADVANCE(245);
      if (lookahead == 'q') ADVANCE(409);
      if (lookahead == 's') ADVANCE(210);
      END_STATE();
    case 89:
      if (lookahead == 'c') ADVANCE(26);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(503);
      END_STATE();
    case 91:
      if (lookahead == 'c') ADVANCE(219);
      END_STATE();
    case 92:
      if (lookahead == 'c') ADVANCE(938);
      END_STATE();
    case 93:
      if (lookahead == 'c') ADVANCE(940);
      END_STATE();
    case 94:
      if (lookahead == 'c') ADVANCE(944);
      END_STATE();
    case 95:
      if (lookahead == 'c') ADVANCE(942);
      END_STATE();
    case 96:
      if (lookahead == 'c') ADVANCE(946);
      END_STATE();
    case 97:
      if (lookahead == 'c') ADVANCE(948);
      END_STATE();
    case 98:
      if (lookahead == 'c') ADVANCE(184);
      END_STATE();
    case 99:
      if (lookahead == 'c') ADVANCE(184);
      if (lookahead == 'i') ADVANCE(252);
      if (lookahead == 'l') ADVANCE(218);
      if (lookahead == 'r') ADVANCE(51);
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 100:
      if (lookahead == 'c') ADVANCE(220);
      END_STATE();
    case 101:
      if (lookahead == 'c') ADVANCE(221);
      END_STATE();
    case 102:
      if (lookahead == 'c') ADVANCE(222);
      END_STATE();
    case 103:
      if (lookahead == 'c') ADVANCE(302);
      END_STATE();
    case 104:
      if (lookahead == 'c') ADVANCE(137);
      END_STATE();
    case 105:
      if (lookahead == 'c') ADVANCE(138);
      END_STATE();
    case 106:
      if (lookahead == 'c') ADVANCE(140);
      END_STATE();
    case 107:
      if (lookahead == 'c') ADVANCE(142);
      END_STATE();
    case 108:
      if (lookahead == 'c') ADVANCE(236);
      END_STATE();
    case 109:
      if (lookahead == 'c') ADVANCE(156);
      END_STATE();
    case 110:
      if (lookahead == 'c') ADVANCE(68);
      END_STATE();
    case 111:
      if (lookahead == 'c') ADVANCE(395);
      END_STATE();
    case 112:
      if (lookahead == 'd') ADVANCE(986);
      END_STATE();
    case 113:
      if (lookahead == 'd') ADVANCE(894);
      if (lookahead == 'r') ADVANCE(371);
      END_STATE();
    case 114:
      if (lookahead == 'd') ADVANCE(896);
      if (lookahead == 'r') ADVANCE(373);
      END_STATE();
    case 115:
      if (lookahead == 'd') ADVANCE(898);
      if (lookahead == 'r') ADVANCE(380);
      END_STATE();
    case 116:
      if (lookahead == 'd') ADVANCE(205);
      END_STATE();
    case 117:
      if (lookahead == 'd') ADVANCE(213);
      END_STATE();
    case 118:
      if (lookahead == 'd') ADVANCE(341);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(215);
      END_STATE();
    case 120:
      if (lookahead == 'd') ADVANCE(216);
      END_STATE();
    case 121:
      if (lookahead == 'd') ADVANCE(217);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(169);
      if (lookahead == 'u') ADVANCE(328);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(241);
      if (lookahead == 'o') ADVANCE(298);
      END_STATE();
    case 124:
      if (lookahead == 'e') ADVANCE(901);
      if (lookahead == 'i') ADVANCE(266);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(482);
      END_STATE();
    case 126:
      if (lookahead == 'e') ADVANCE(501);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(973);
      END_STATE();
    case 128:
      if (lookahead == 'e') ADVANCE(884);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(975);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(888);
      END_STATE();
    case 131:
      if (lookahead == 'e') ADVANCE(963);
      END_STATE();
    case 132:
      if (lookahead == 'e') ADVANCE(472);
      END_STATE();
    case 133:
      if (lookahead == 'e') ADVANCE(505);
      END_STATE();
    case 134:
      if (lookahead == 'e') ADVANCE(419);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(926);
      END_STATE();
    case 136:
      if (lookahead == 'e') ADVANCE(928);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(950);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(952);
      END_STATE();
    case 139:
      if (lookahead == 'e') ADVANCE(930);
      END_STATE();
    case 140:
      if (lookahead == 'e') ADVANCE(954);
      END_STATE();
    case 141:
      if (lookahead == 'e') ADVANCE(890);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(510);
      END_STATE();
    case 143:
      if (lookahead == 'e') ADVANCE(265);
      if (lookahead == 'i') ADVANCE(268);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(29);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(223);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(25);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 148:
      if (lookahead == 'e') ADVANCE(258);
      END_STATE();
    case 149:
      if (lookahead == 'e') ADVANCE(271);
      END_STATE();
    case 150:
      if (lookahead == 'e') ADVANCE(67);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(227);
      if (lookahead == 'u') ADVANCE(328);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(263);
      END_STATE();
    case 153:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(326);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(335);
      END_STATE();
    case 156:
      if (lookahead == 'e') ADVANCE(272);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 158:
      if (lookahead == 'e') ADVANCE(274);
      END_STATE();
    case 159:
      if (lookahead == 'e') ADVANCE(282);
      END_STATE();
    case 160:
      if (lookahead == 'e') ADVANCE(283);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 162:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 163:
      if (lookahead == 'e') ADVANCE(288);
      END_STATE();
    case 164:
      if (lookahead == 'e') ADVANCE(343);
      END_STATE();
    case 165:
      if (lookahead == 'f') ADVANCE(480);
      if (lookahead == 'm') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(461);
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 166:
      if (lookahead == 'f') ADVANCE(968);
      END_STATE();
    case 167:
      if (lookahead == 'f') ADVANCE(311);
      END_STATE();
    case 168:
      if (lookahead == 'g') ADVANCE(986);
      END_STATE();
    case 169:
      if (lookahead == 'g') ADVANCE(986);
      if (lookahead == 'l') ADVANCE(52);
      END_STATE();
    case 170:
      if (lookahead == 'g') ADVANCE(478);
      END_STATE();
    case 171:
      if (lookahead == 'g') ADVANCE(234);
      if (lookahead == 'i') ADVANCE(253);
      END_STATE();
    case 172:
      if (lookahead == 'g') ADVANCE(383);
      END_STATE();
    case 173:
      if (lookahead == 'g') ADVANCE(130);
      END_STATE();
    case 174:
      if (lookahead == 'g') ADVANCE(144);
      END_STATE();
    case 175:
      if (lookahead == 'g') ADVANCE(342);
      END_STATE();
    case 176:
      if (lookahead == 'g') ADVANCE(384);
      END_STATE();
    case 177:
      if (lookahead == 'g') ADVANCE(344);
      END_STATE();
    case 178:
      if (lookahead == 'g') ADVANCE(345);
      END_STATE();
    case 179:
      if (lookahead == 'g') ADVANCE(346);
      END_STATE();
    case 180:
      if (lookahead == 'h') ADVANCE(878);
      END_STATE();
    case 181:
      if (lookahead == 'h') ADVANCE(882);
      END_STATE();
    case 182:
      if (lookahead == 'h') ADVANCE(880);
      END_STATE();
    case 183:
      if (lookahead == 'h') ADVANCE(414);
      if (lookahead == 't' ||
          lookahead == 'x') ADVANCE(980);
      END_STATE();
    case 184:
      if (lookahead == 'h') ADVANCE(195);
      END_STATE();
    case 185:
      if (lookahead == 'h') ADVANCE(148);
      END_STATE();
    case 186:
      if (lookahead == 'h') ADVANCE(155);
      END_STATE();
    case 187:
      if (lookahead == 'i') ADVANCE(252);
      if (lookahead == 'l') ADVANCE(218);
      if (lookahead == 'r') ADVANCE(51);
      if (lookahead == 't') ADVANCE(320);
      END_STATE();
    case 188:
      if (lookahead == 'i') ADVANCE(413);
      if (lookahead == 'o') ADVANCE(316);
      END_STATE();
    case 189:
      if (lookahead == 'i') ADVANCE(412);
      END_STATE();
    case 190:
      if (lookahead == 'i') ADVANCE(420);
      END_STATE();
    case 191:
      if (lookahead == 'i') ADVANCE(89);
      END_STATE();
    case 192:
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 193:
      if (lookahead == 'i') ADVANCE(90);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(310);
      END_STATE();
    case 195:
      if (lookahead == 'i') ADVANCE(228);
      END_STATE();
    case 196:
      if (lookahead == 'i') ADVANCE(260);
      if (lookahead == 'o') ADVANCE(403);
      END_STATE();
    case 197:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 198:
      if (lookahead == 'i') ADVANCE(96);
      END_STATE();
    case 199:
      if (lookahead == 'i') ADVANCE(333);
      END_STATE();
    case 200:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 201:
      if (lookahead == 'i') ADVANCE(336);
      END_STATE();
    case 202:
      if (lookahead == 'i') ADVANCE(338);
      END_STATE();
    case 203:
      if (lookahead == 'i') ADVANCE(388);
      END_STATE();
    case 204:
      if (lookahead == 'i') ADVANCE(276);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 206:
      if (lookahead == 'i') ADVANCE(307);
      END_STATE();
    case 207:
      if (lookahead == 'i') ADVANCE(154);
      END_STATE();
    case 208:
      if (lookahead == 'i') ADVANCE(278);
      END_STATE();
    case 209:
      if (lookahead == 'i') ADVANCE(308);
      END_STATE();
    case 210:
      if (lookahead == 'i') ADVANCE(280);
      END_STATE();
    case 211:
      if (lookahead == 'i') ADVANCE(309);
      END_STATE();
    case 212:
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 213:
      if (lookahead == 'i') ADVANCE(159);
      END_STATE();
    case 214:
      if (lookahead == 'i') ADVANCE(391);
      END_STATE();
    case 215:
      if (lookahead == 'i') ADVANCE(160);
      END_STATE();
    case 216:
      if (lookahead == 'i') ADVANCE(161);
      END_STATE();
    case 217:
      if (lookahead == 'i') ADVANCE(162);
      END_STATE();
    case 218:
      if (lookahead == 'i') ADVANCE(292);
      END_STATE();
    case 219:
      if (lookahead == 'k') ADVANCE(498);
      END_STATE();
    case 220:
      if (lookahead == 'k') ADVANCE(932);
      END_STATE();
    case 221:
      if (lookahead == 'k') ADVANCE(934);
      END_STATE();
    case 222:
      if (lookahead == 'k') ADVANCE(936);
      END_STATE();
    case 223:
      if (lookahead == 'l') ADVANCE(166);
      END_STATE();
    case 224:
      if (lookahead == 'l') ADVANCE(873);
      END_STATE();
    case 225:
      if (lookahead == 'l') ADVANCE(456);
      END_STATE();
    case 226:
      if (lookahead == 'l') ADVANCE(509);
      END_STATE();
    case 227:
      if (lookahead == 'l') ADVANCE(52);
      END_STATE();
    case 228:
      if (lookahead == 'l') ADVANCE(118);
      END_STATE();
    case 229:
      if (lookahead == 'l') ADVANCE(31);
      END_STATE();
    case 230:
      if (lookahead == 'l') ADVANCE(297);
      END_STATE();
    case 231:
      if (lookahead == 'l') ADVANCE(297);
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(304);
      if (lookahead == 'm') ADVANCE(312);
      END_STATE();
    case 233:
      if (lookahead == 'l') ADVANCE(238);
      END_STATE();
    case 234:
      if (lookahead == 'l') ADVANCE(128);
      END_STATE();
    case 235:
      if (lookahead == 'l') ADVANCE(61);
      if (lookahead == 'x') ADVANCE(313);
      END_STATE();
    case 236:
      if (lookahead == 'l') ADVANCE(131);
      END_STATE();
    case 237:
      if (lookahead == 'l') ADVANCE(163);
      END_STATE();
    case 238:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 239:
      if (lookahead == 'l') ADVANCE(354);
      END_STATE();
    case 240:
      if (lookahead == 'l') ADVANCE(73);
      if (lookahead == 'm') ADVANCE(989);
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 241:
      if (lookahead == 'l') ADVANCE(73);
      if (lookahead == 't') ADVANCE(402);
      END_STATE();
    case 242:
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 243:
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 244:
      if (lookahead == 'l') ADVANCE(75);
      if (lookahead == 'x') ADVANCE(314);
      END_STATE();
    case 245:
      if (lookahead == 'l') ADVANCE(78);
      if (lookahead == 'x') ADVANCE(315);
      END_STATE();
    case 246:
      if (lookahead == 'l') ADVANCE(32);
      END_STATE();
    case 247:
      if (lookahead == 'm') ADVANCE(980);
      END_STATE();
    case 248:
      if (lookahead == 'm') ADVANCE(980);
      if (lookahead == 's') ADVANCE(982);
      END_STATE();
    case 249:
      if (lookahead == 'm') ADVANCE(989);
      END_STATE();
    case 250:
      if (lookahead == 'm') ADVANCE(459);
      END_STATE();
    case 251:
      if (lookahead == 'm') ADVANCE(437);
      END_STATE();
    case 252:
      if (lookahead == 'm') ADVANCE(71);
      END_STATE();
    case 253:
      if (lookahead == 'm') ADVANCE(60);
      END_STATE();
    case 254:
      if (lookahead == 'n') ADVANCE(171);
      if (lookahead == 's') ADVANCE(439);
      END_STATE();
    case 255:
      if (lookahead == 'n') ADVANCE(980);
      END_STATE();
    case 256:
      if (lookahead == 'n') ADVANCE(461);
      END_STATE();
    case 257:
      if (lookahead == 'n') ADVANCE(986);
      END_STATE();
    case 258:
      if (lookahead == 'n') ADVANCE(471);
      END_STATE();
    case 259:
      if (lookahead == 'n') ADVANCE(449);
      END_STATE();
    case 260:
      if (lookahead == 'n') ADVANCE(902);
      END_STATE();
    case 261:
      if (lookahead == 'n') ADVANCE(475);
      END_STATE();
    case 262:
      if (lookahead == 'n') ADVANCE(507);
      END_STATE();
    case 263:
      if (lookahead == 'n') ADVANCE(958);
      END_STATE();
    case 264:
      if (lookahead == 'n') ADVANCE(111);
      END_STATE();
    case 265:
      if (lookahead == 'n') ADVANCE(172);
      END_STATE();
    case 266:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 267:
      if (lookahead == 'n') ADVANCE(353);
      END_STATE();
    case 268:
      if (lookahead == 'n') ADVANCE(150);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 270:
      if (lookahead == 'n') ADVANCE(348);
      END_STATE();
    case 271:
      if (lookahead == 'n') ADVANCE(366);
      END_STATE();
    case 272:
      if (lookahead == 'n') ADVANCE(367);
      END_STATE();
    case 273:
      if (lookahead == 'n') ADVANCE(104);
      END_STATE();
    case 274:
      if (lookahead == 'n') ADVANCE(369);
      END_STATE();
    case 275:
      if (lookahead == 'n') ADVANCE(372);
      END_STATE();
    case 276:
      if (lookahead == 'n') ADVANCE(135);
      END_STATE();
    case 277:
      if (lookahead == 'n') ADVANCE(387);
      END_STATE();
    case 278:
      if (lookahead == 'n') ADVANCE(136);
      END_STATE();
    case 279:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 280:
      if (lookahead == 'n') ADVANCE(139);
      END_STATE();
    case 281:
      if (lookahead == 'n') ADVANCE(375);
      END_STATE();
    case 282:
      if (lookahead == 'n') ADVANCE(376);
      END_STATE();
    case 283:
      if (lookahead == 'n') ADVANCE(377);
      END_STATE();
    case 284:
      if (lookahead == 'n') ADVANCE(378);
      END_STATE();
    case 285:
      if (lookahead == 'n') ADVANCE(379);
      END_STATE();
    case 286:
      if (lookahead == 'n') ADVANCE(381);
      END_STATE();
    case 287:
      if (lookahead == 'n') ADVANCE(186);
      END_STATE();
    case 288:
      if (lookahead == 'n') ADVANCE(176);
      END_STATE();
    case 289:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 290:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 291:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 292:
      if (lookahead == 'n') ADVANCE(157);
      END_STATE();
    case 293:
      if (lookahead == 'o') ADVANCE(301);
      if (lookahead == 'r') ADVANCE(400);
      END_STATE();
    case 294:
      if (lookahead == 'o') ADVANCE(920);
      END_STATE();
    case 295:
      if (lookahead == 'o') ADVANCE(922);
      END_STATE();
    case 296:
      if (lookahead == 'o') ADVANCE(924);
      END_STATE();
    case 297:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 298:
      if (lookahead == 'o') ADVANCE(362);
      END_STATE();
    case 299:
      if (lookahead == 'o') ADVANCE(251);
      END_STATE();
    case 300:
      if (lookahead == 'o') ADVANCE(57);
      END_STATE();
    case 301:
      if (lookahead == 'o') ADVANCE(224);
      END_STATE();
    case 302:
      if (lookahead == 'o') ADVANCE(411);
      END_STATE();
    case 303:
      if (lookahead == 'o') ADVANCE(291);
      END_STATE();
    case 304:
      if (lookahead == 'o') ADVANCE(323);
      END_STATE();
    case 305:
      if (lookahead == 'o') ADVANCE(330);
      END_STATE();
    case 306:
      if (lookahead == 'o') ADVANCE(331);
      END_STATE();
    case 307:
      if (lookahead == 'o') ADVANCE(261);
      END_STATE();
    case 308:
      if (lookahead == 'o') ADVANCE(262);
      END_STATE();
    case 309:
      if (lookahead == 'o') ADVANCE(269);
      END_STATE();
    case 310:
      if (lookahead == 'o') ADVANCE(270);
      END_STATE();
    case 311:
      if (lookahead == 'o') ADVANCE(277);
      END_STATE();
    case 312:
      if (lookahead == 'p') ADVANCE(303);
      END_STATE();
    case 313:
      if (lookahead == 'p') ADVANCE(294);
      END_STATE();
    case 314:
      if (lookahead == 'p') ADVANCE(295);
      END_STATE();
    case 315:
      if (lookahead == 'p') ADVANCE(296);
      END_STATE();
    case 316:
      if (lookahead == 'p') ADVANCE(153);
      END_STATE();
    case 317:
      if (lookahead == 'p') ADVANCE(305);
      END_STATE();
    case 318:
      if (lookahead == 'r') ADVANCE(56);
      END_STATE();
    case 319:
      if (lookahead == 'r') ADVANCE(56);
      if (lookahead == 'u') ADVANCE(329);
      END_STATE();
    case 320:
      if (lookahead == 'r') ADVANCE(488);
      END_STATE();
    case 321:
      if (lookahead == 'r') ADVANCE(108);
      END_STATE();
    case 322:
      if (lookahead == 'r') ADVANCE(484);
      END_STATE();
    case 323:
      if (lookahead == 'r') ADVANCE(876);
      END_STATE();
    case 324:
      if (lookahead == 'r') ADVANCE(892);
      END_STATE();
    case 325:
      if (lookahead == 'r') ADVANCE(27);
      END_STATE();
    case 326:
      if (lookahead == 'r') ADVANCE(956);
      END_STATE();
    case 327:
      if (lookahead == 'r') ADVANCE(109);
      END_STATE();
    case 328:
      if (lookahead == 'r') ADVANCE(54);
      END_STATE();
    case 329:
      if (lookahead == 'r') ADVANCE(257);
      END_STATE();
    case 330:
      if (lookahead == 'r') ADVANCE(364);
      END_STATE();
    case 331:
      if (lookahead == 'r') ADVANCE(365);
      END_STATE();
    case 332:
      if (lookahead == 'r') ADVANCE(259);
      END_STATE();
    case 333:
      if (lookahead == 'r') ADVANCE(92);
      END_STATE();
    case 334:
      if (lookahead == 'r') ADVANCE(382);
      END_STATE();
    case 335:
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 336:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 337:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 338:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 339:
      if (lookahead == 'r') ADVANCE(45);
      END_STATE();
    case 340:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 341:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 342:
      if (lookahead == 'r') ADVANCE(72);
      END_STATE();
    case 343:
      if (lookahead == 'r') ADVANCE(77);
      END_STATE();
    case 344:
      if (lookahead == 'r') ADVANCE(76);
      END_STATE();
    case 345:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 346:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 347:
      if (lookahead == 's') ADVANCE(439);
      END_STATE();
    case 348:
      if (lookahead == 's') ADVANCE(466);
      END_STATE();
    case 349:
      if (lookahead == 's') ADVANCE(443);
      END_STATE();
    case 350:
      if (lookahead == 's') ADVANCE(124);
      END_STATE();
    case 351:
      if (lookahead == 's') ADVANCE(180);
      END_STATE();
    case 352:
      if (lookahead == 's') ADVANCE(125);
      END_STATE();
    case 353:
      if (lookahead == 's') ADVANCE(214);
      END_STATE();
    case 354:
      if (lookahead == 's') ADVANCE(129);
      END_STATE();
    case 355:
      if (lookahead == 's') ADVANCE(190);
      END_STATE();
    case 356:
      if (lookahead == 's') ADVANCE(392);
      END_STATE();
    case 357:
      if (lookahead == 's') ADVANCE(192);
      END_STATE();
    case 358:
      if (lookahead == 's') ADVANCE(243);
      END_STATE();
    case 359:
      if (lookahead == 's') ADVANCE(393);
      END_STATE();
    case 360:
      if (lookahead == 's') ADVANCE(394);
      END_STATE();
    case 361:
      if (lookahead == 't') ADVANCE(464);
      END_STATE();
    case 362:
      if (lookahead == 't') ADVANCE(966);
      END_STATE();
    case 363:
      if (lookahead == 't') ADVANCE(871);
      END_STATE();
    case 364:
      if (lookahead == 't') ADVANCE(430);
      END_STATE();
    case 365:
      if (lookahead == 't') ADVANCE(435);
      END_STATE();
    case 366:
      if (lookahead == 't') ADVANCE(964);
      END_STATE();
    case 367:
      if (lookahead == 't') ADVANCE(886);
      END_STATE();
    case 368:
      if (lookahead == 't') ADVANCE(904);
      END_STATE();
    case 369:
      if (lookahead == 't') ADVANCE(441);
      END_STATE();
    case 370:
      if (lookahead == 't') ADVANCE(906);
      END_STATE();
    case 371:
      if (lookahead == 't') ADVANCE(908);
      END_STATE();
    case 372:
      if (lookahead == 't') ADVANCE(914);
      END_STATE();
    case 373:
      if (lookahead == 't') ADVANCE(910);
      END_STATE();
    case 374:
      if (lookahead == 't') ADVANCE(916);
      END_STATE();
    case 375:
      if (lookahead == 't') ADVANCE(477);
      END_STATE();
    case 376:
      if (lookahead == 't') ADVANCE(959);
      END_STATE();
    case 377:
      if (lookahead == 't') ADVANCE(960);
      END_STATE();
    case 378:
      if (lookahead == 't') ADVANCE(961);
      END_STATE();
    case 379:
      if (lookahead == 't') ADVANCE(962);
      END_STATE();
    case 380:
      if (lookahead == 't') ADVANCE(912);
      END_STATE();
    case 381:
      if (lookahead == 't') ADVANCE(918);
      END_STATE();
    case 382:
      if (lookahead == 't') ADVANCE(417);
      END_STATE();
    case 383:
      if (lookahead == 't') ADVANCE(181);
      END_STATE();
    case 384:
      if (lookahead == 't') ADVANCE(182);
      END_STATE();
    case 385:
      if (lookahead == 't') ADVANCE(206);
      END_STATE();
    case 386:
      if (lookahead == 't') ADVANCE(189);
      END_STATE();
    case 387:
      if (lookahead == 't') ADVANCE(30);
      END_STATE();
    case 388:
      if (lookahead == 't') ADVANCE(349);
      END_STATE();
    case 389:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 390:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 391:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 392:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 393:
      if (lookahead == 't') ADVANCE(198);
      END_STATE();
    case 394:
      if (lookahead == 't') ADVANCE(200);
      END_STATE();
    case 395:
      if (lookahead == 't') ADVANCE(209);
      END_STATE();
    case 396:
      if (lookahead == 't') ADVANCE(211);
      END_STATE();
    case 397:
      if (lookahead == 'u') ADVANCE(361);
      END_STATE();
    case 398:
      if (lookahead == 'u') ADVANCE(49);
      END_STATE();
    case 399:
      if (lookahead == 'u') ADVANCE(250);
      END_STATE();
    case 400:
      if (lookahead == 'u') ADVANCE(351);
      END_STATE();
    case 401:
      if (lookahead == 'u') ADVANCE(329);
      END_STATE();
    case 402:
      if (lookahead == 'u') ADVANCE(332);
      END_STATE();
    case 403:
      if (lookahead == 'u') ADVANCE(368);
      END_STATE();
    case 404:
      if (lookahead == 'u') ADVANCE(370);
      END_STATE();
    case 405:
      if (lookahead == 'u') ADVANCE(337);
      END_STATE();
    case 406:
      if (lookahead == 'u') ADVANCE(273);
      END_STATE();
    case 407:
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 408:
      if (lookahead == 'u') ADVANCE(289);
      END_STATE();
    case 409:
      if (lookahead == 'u') ADVANCE(55);
      END_STATE();
    case 410:
      if (lookahead == 'u') ADVANCE(290);
      END_STATE();
    case 411:
      if (lookahead == 'u') ADVANCE(281);
      END_STATE();
    case 412:
      if (lookahead == 'v') ADVANCE(146);
      END_STATE();
    case 413:
      if (lookahead == 'v') ADVANCE(74);
      END_STATE();
    case 414:
      if (lookahead == 'x') ADVANCE(978);
      END_STATE();
    case 415:
      if (lookahead == 'x') ADVANCE(978);
      if (lookahead == 'y') ADVANCE(357);
      END_STATE();
    case 416:
      if (lookahead == 'y') ADVANCE(474);
      END_STATE();
    case 417:
      if (lookahead == 'y') ADVANCE(451);
      END_STATE();
    case 418:
      if (lookahead == 'y') ADVANCE(357);
      END_STATE();
    case 419:
      if (lookahead == 'z') ADVANCE(207);
      END_STATE();
    case 420:
      if (lookahead == 'z') ADVANCE(141);
      END_STATE();
    case 421:
      if (lookahead == '{') ADVANCE(426);
      END_STATE();
    case 422:
      if (lookahead == '|') ADVANCE(496);
      END_STATE();
    case 423:
      if (lookahead == '}') ADVANCE(541);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(423);
      END_STATE();
    case 424:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(972);
      END_STATE();
    case 425:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(977);
      END_STATE();
    case 426:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(423);
      END_STATE();
    case 427:
      if (eof) ADVANCE(429);
      if (lookahead == '!') ADVANCE(512);
      if (lookahead == '"') ADVANCE(533);
      if (lookahead == '#') ADVANCE(425);
      if (lookahead == '%') ADVANCE(492);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(515);
      if (lookahead == '.') ADVANCE(494);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(454);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(445);
      if (lookahead == '=') ADVANCE(528);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '@') ADVANCE(99);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == '\\') ADVANCE(540);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'a') ADVANCE(254);
      if (lookahead == 'b') ADVANCE(293);
      if (lookahead == 'c') ADVANCE(43);
      if (lookahead == 'd') ADVANCE(151);
      if (lookahead == 'e') ADVANCE(44);
      if (lookahead == 'f') ADVANCE(50);
      if (lookahead == 'g') ADVANCE(230);
      if (lookahead == 'i') ADVANCE(165);
      if (lookahead == 'l') ADVANCE(143);
      if (lookahead == 'n') ADVANCE(542);
      if (lookahead == 'o') ADVANCE(397);
      if (lookahead == 'p') ADVANCE(59);
      if (lookahead == 'r') ADVANCE(123);
      if (lookahead == 's') ADVANCE(145);
      if (lookahead == 't') ADVANCE(318);
      if (lookahead == 'u') ADVANCE(421);
      if (lookahead == 'w') ADVANCE(185);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(491);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(427)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      END_STATE();
    case 428:
      if (eof) ADVANCE(429);
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '%') ADVANCE(492);
      if (lookahead == '&') ADVANCE(18);
      if (lookahead == '(') ADVANCE(486);
      if (lookahead == ')') ADVANCE(487);
      if (lookahead == '*') ADVANCE(519);
      if (lookahead == '+') ADVANCE(517);
      if (lookahead == ',') ADVANCE(433);
      if (lookahead == '-') ADVANCE(514);
      if (lookahead == '.') ADVANCE(493);
      if (lookahead == '/') ADVANCE(521);
      if (lookahead == ':') ADVANCE(453);
      if (lookahead == ';') ADVANCE(438);
      if (lookahead == '<') ADVANCE(446);
      if (lookahead == '=') ADVANCE(528);
      if (lookahead == '>') ADVANCE(448);
      if (lookahead == '?') ADVANCE(497);
      if (lookahead == '[') ADVANCE(468);
      if (lookahead == ']') ADVANCE(469);
      if (lookahead == 'c') ADVANCE(763);
      if (lookahead == 'e') ADVANCE(710);
      if (lookahead == 'g') ADVANCE(687);
      if (lookahead == 'i') ADVANCE(707);
      if (lookahead == 's') ADVANCE(807);
      if (lookahead == '{') ADVANCE(432);
      if (lookahead == '|') ADVANCE(422);
      if (lookahead == '}') ADVANCE(434);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(428)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(971);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_export);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_export);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(anon_sym_import);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_component);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_component);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(anon_sym_inherits);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(524);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(523);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(522);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_property);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(440);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_LT_EQ_GT);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(anon_sym_global);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_struct);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_enum);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '-') ADVANCE(760);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(anon_sym_out);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(anon_sym_out);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_transitions);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_transitions);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_states);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(anon_sym_animate);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_animate);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_delay);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(anon_sym_duration);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_duration);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(anon_sym_iteration_DASHcount);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(anon_sym_easing);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(anon_sym_easing);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_else);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_ATtr);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(496);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(972);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_logical_and);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_logical_or);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(anon_sym_callback);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(anon_sym_callback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(anon_sym_pure);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_public);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(anon_sym_private);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(anon_sym_function);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_ATimage_DASHurl);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(anon_sym_9slice);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(526);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(530);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(530);
      if (lookahead == '>') ADVANCE(500);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(529);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(531);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(992);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(23);
      if (lookahead == '/') ADVANCE(992);
      if (lookahead == '=') ADVANCE(532);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '>') ADVANCE(455);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(525);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(525);
      if (lookahead == '>') ADVANCE(489);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '*') ADVANCE(536);
      if (lookahead == '/') ADVANCE(538);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(539);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '*') ADVANCE(535);
      if (lookahead == '/') ADVANCE(539);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(536);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '*') ADVANCE(535);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(536);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '/') ADVANCE(534);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(537);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(539);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(539);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(538);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym__unescaped_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(539);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_n);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(anon_sym_in_DASHout);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(582);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(645);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(697);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-') ADVANCE(802);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(797);
      if (lookahead == 'l') ADVANCE(803);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(797);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(605);
      if (lookahead == 'i') ADVANCE(732);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(608);
      if (lookahead == 'e') ADVANCE(705);
      if (lookahead == 'o') ADVANCE(751);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(608);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(685);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(801);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(606);
      if (lookahead == 'i') ADVANCE(734);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(696);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(587);
      if (lookahead == 'o') ADVANCE(849);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(607);
      if (lookahead == 'i') ADVANCE(735);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(650);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(793);
      if (lookahead == 'h') ADVANCE(864);
      if (lookahead == 't' ||
          lookahead == 'x') ADVANCE(981);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(793);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(691);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(595);
      if (lookahead == 'o') ADVANCE(860);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(771);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(596);
      if (lookahead == 'o') ADVANCE(861);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(720);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(689);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(598);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(837);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(838);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(839);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(826);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(835);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(800);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(843);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(804);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'a') ADVANCE(805);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(553);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(557);
      if (lookahead == 'c') ADVANCE(662);
      if (lookahead == 'e') ADVANCE(690);
      if (lookahead == 'o') ADVANCE(854);
      if (lookahead == 'q') ADVANCE(845);
      if (lookahead == 's') ADVANCE(678);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(657);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(698);
      if (lookahead == 'r') ADVANCE(621);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(612);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(568);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(563);
      if (lookahead == 'c') ADVANCE(665);
      if (lookahead == 'e') ADVANCE(700);
      if (lookahead == 'q') ADVANCE(858);
      if (lookahead == 's') ADVANCE(679);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'b') ADVANCE(565);
      if (lookahead == 'c') ADVANCE(666);
      if (lookahead == 'e') ADVANCE(701);
      if (lookahead == 'q') ADVANCE(859);
      if (lookahead == 's') ADVANCE(680);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(544);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(681);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(939);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(941);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(945);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(943);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(947);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(949);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(504);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(682);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(683);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(810);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(684);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(615);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(616);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(618);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(834);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(567);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'c') ADVANCE(640);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(895);
      if (lookahead == 'r') ADVANCE(816);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(897);
      if (lookahead == 'r') ADVANCE(818);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(899);
      if (lookahead == 'r') ADVANCE(820);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'd') ADVANCE(987);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(974);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(976);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(867);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(927);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(929);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(951);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(953);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(931);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(955);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(646);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(483);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(502);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(473);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(506);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(885);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(889);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(891);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(723);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(545);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(688);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(794);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(831);
      if (lookahead == 'o') ADVANCE(751);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(699);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(772);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(722);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(790);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(729);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(564);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(788);
      if (lookahead == 'h') ADVANCE(866);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(739);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'e') ADVANCE(736);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(481);
      if (lookahead == 'n') ADVANCE(981);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(481);
      if (lookahead == 'n') ADVANCE(462);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(481);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(969);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'f') ADVANCE(762);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(987);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(479);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(875);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(694);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(625);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(828);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'g') ADVANCE(829);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'h') ADVANCE(879);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'h') ADVANCE(883);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'h') ADVANCE(881);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(863);
      if (lookahead == 'o') ADVANCE(770);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(586);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(868);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(862);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(708);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(713);
      if (lookahead == 'o') ADVANCE(852);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(782);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(590);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(633);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(785);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(787);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(592);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(753);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(593);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(754);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(594);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(725);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(603);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(728);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(757);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(721);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(841);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(730);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(731);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'i') ADVANCE(733);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(933);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(935);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(937);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'k') ADVANCE(499);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(457);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(874);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(742);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(644);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(546);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(554);
      if (lookahead == 'x') ADVANCE(767);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(695);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(761);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(758);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(624);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(583);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(798);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(639);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(671);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(573);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(576);
      if (lookahead == 'x') ADVANCE(768);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'l') ADVANCE(577);
      if (lookahead == 'x') ADVANCE(769);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(460);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(981);
      if (lookahead == 's') ADVANCE(985);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(981);
      if (lookahead == 'u') ADVANCE(580);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(990);
      if (lookahead == 't') ADVANCE(848);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(559);
      if (lookahead == 'n') ADVANCE(825);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(765);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(570);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'm') ADVANCE(766);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(846);
      if (lookahead == 'x') ADVANCE(764);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(627);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(450);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(903);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(463);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(987);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(462);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(508);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(476);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(649);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(799);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(637);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(651);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(811);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(795);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(647);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(599);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(660);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(648);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(813);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(613);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(614);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(817);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(617);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(819);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(821);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(827);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(830);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(602);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(652);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(600);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'n') ADVANCE(601);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(578);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(711);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(921);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(923);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(925);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(770);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(775);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(778);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(751);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(812);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(686);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(717);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(724);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(773);
      if (lookahead == 'u') ADVANCE(738);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(752);
      if (lookahead == 'r') ADVANCE(851);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(718);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(774);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(693);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(857);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(572);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(737);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'o') ADVANCE(709);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(748);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(749);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(743);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(744);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(745);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(746);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'p') ADVANCE(635);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(893);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(957);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(485);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(877);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(808);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(844);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(656);
      if (lookahead == 'u') ADVANCE(581);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(809);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(712);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(850);
      if (lookahead == 'u') ADVANCE(786);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(850);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(588);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(552);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(566);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(589);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(715);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(591);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(604);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(747);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(824);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(674);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(575);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'r') ADVANCE(636);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(470);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(467);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(653);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(609);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(611);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(677);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(672);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(832);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(658);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(620);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(840);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(842);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 's') ADVANCE(673);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(776);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(431);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(436);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(458);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(442);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(967);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(965);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(905);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(907);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(909);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(915);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(911);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(917);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(913);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(919);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(465);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(543);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(865);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(870);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(872);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(887);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(654);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(655);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(547);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(848);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(663);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(569);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(668);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(659);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(791);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(630);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(622);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(623);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(667);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(670);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(669);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 't') ADVANCE(675);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(597);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(550);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(702);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(580);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(779);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(726);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(610);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(796);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(814);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(738);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(815);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(792);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(822);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(823);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(555);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(558);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(740);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'u') ADVANCE(741);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'v') ADVANCE(628);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'v') ADVANCE(571);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'x') ADVANCE(979);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'y') ADVANCE(452);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'y') ADVANCE(806);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'z') ADVANCE(664);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(869);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == 'z') ADVANCE(626);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(869);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym__identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(anon_sym_float);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(anon_sym_bool);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(anon_sym_string);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(anon_sym_color);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(anon_sym_color);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(anon_sym_brush);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(anon_sym_brush);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(anon_sym_physical_DASHlength);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(anon_sym_physical_DASHlength);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(anon_sym_length);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(anon_sym_length);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(anon_sym_angle);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(anon_sym_angle);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(anon_sym_percent);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(anon_sym_percent);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(anon_sym_image);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(anon_sym_image);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(anon_sym_relative_DASHfont_DASHsize);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(anon_sym_relative_DASHfont_DASHsize);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(anon_sym_linear);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(anon_sym_linear);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquad);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquad);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquad);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquad);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquad);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquad);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(anon_sym_ease);
      if (lookahead == '-') ADVANCE(661);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(anon_sym_ease);
      if (lookahead == '-') ADVANCE(196);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(anon_sym_ease_DASHin);
      if (lookahead == '-') ADVANCE(81);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(anon_sym_ease_DASHin);
      if (lookahead == '-') ADVANCE(579);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(anon_sym_ease_DASHout);
      if (lookahead == '-') ADVANCE(87);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(anon_sym_ease_DASHout);
      if (lookahead == '-') ADVANCE(584);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout);
      if (lookahead == '-') ADVANCE(88);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout);
      if (lookahead == '-') ADVANCE(585);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquart);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquart);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquart);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquart);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquart);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquart);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquint);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHquint);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquint);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHquint);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquint);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHquint);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHexpo);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHexpo);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHexpo);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHexpo);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHexpo);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHexpo);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHsine);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHsine);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHsine);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHsine);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHsine);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHsine);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHback);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHback);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHback);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHback);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHcirc);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHcirc);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHcirc);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHcirc);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHcirc);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHcirc);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHelastic);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHelastic);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHelastic);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHelastic);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHelastic);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHelastic);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHbounce);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHbounce);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHbounce);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(anon_sym_ease_DASHout_DASHbounce);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHbounce);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(anon_sym_ease_DASHin_DASHout_DASHbounce);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(anon_sym_cubic_DASHbezier);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(anon_sym_cubic_DASHbezier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(sym_children_identifier);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(anon_sym_ATlinear_DASHgradient);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(anon_sym_ATlinear_gradient);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(anon_sym_ATradial_DASHgradient);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(anon_sym_ATradial_gradient);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(anon_sym_circle);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(anon_sym_parent);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(anon_sym_parent);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(anon_sym_root);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(anon_sym_root);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(anon_sym_self);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(anon_sym_self);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(sym__int_number);
      if (lookahead == '.') ADVANCE(972);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(970);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(sym__int_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(971);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym__float_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(972);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(anon_sym_true);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(anon_sym_false);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym_color_value);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(977);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(anon_sym_phx);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(anon_sym_phx);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(aux_sym_length_value_token1);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(aux_sym_length_value_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      if (lookahead == 'e') ADVANCE(223);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      if (lookahead == 'e') ADVANCE(688);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(aux_sym_duration_value_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(aux_sym_angle_value_token1);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(aux_sym_angle_value_token1);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(anon_sym_PERCENT2);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(anon_sym_rem);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(anon_sym_rem);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(869);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(992);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 428},
  [2] = {.lex_state = 1},
  [3] = {.lex_state = 1},
  [4] = {.lex_state = 1},
  [5] = {.lex_state = 1},
  [6] = {.lex_state = 1},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 1},
  [9] = {.lex_state = 1},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 1},
  [13] = {.lex_state = 1},
  [14] = {.lex_state = 1},
  [15] = {.lex_state = 1},
  [16] = {.lex_state = 5},
  [17] = {.lex_state = 5},
  [18] = {.lex_state = 5},
  [19] = {.lex_state = 15},
  [20] = {.lex_state = 15},
  [21] = {.lex_state = 15},
  [22] = {.lex_state = 15},
  [23] = {.lex_state = 15},
  [24] = {.lex_state = 15},
  [25] = {.lex_state = 15},
  [26] = {.lex_state = 15},
  [27] = {.lex_state = 15},
  [28] = {.lex_state = 15},
  [29] = {.lex_state = 15},
  [30] = {.lex_state = 15},
  [31] = {.lex_state = 15},
  [32] = {.lex_state = 15},
  [33] = {.lex_state = 15},
  [34] = {.lex_state = 15},
  [35] = {.lex_state = 15},
  [36] = {.lex_state = 15},
  [37] = {.lex_state = 15},
  [38] = {.lex_state = 15},
  [39] = {.lex_state = 15},
  [40] = {.lex_state = 15},
  [41] = {.lex_state = 15},
  [42] = {.lex_state = 15},
  [43] = {.lex_state = 15},
  [44] = {.lex_state = 15},
  [45] = {.lex_state = 15},
  [46] = {.lex_state = 15},
  [47] = {.lex_state = 15},
  [48] = {.lex_state = 15},
  [49] = {.lex_state = 15},
  [50] = {.lex_state = 15},
  [51] = {.lex_state = 15},
  [52] = {.lex_state = 15},
  [53] = {.lex_state = 15},
  [54] = {.lex_state = 15},
  [55] = {.lex_state = 15},
  [56] = {.lex_state = 15},
  [57] = {.lex_state = 15},
  [58] = {.lex_state = 15},
  [59] = {.lex_state = 15},
  [60] = {.lex_state = 15},
  [61] = {.lex_state = 15},
  [62] = {.lex_state = 15},
  [63] = {.lex_state = 15},
  [64] = {.lex_state = 15},
  [65] = {.lex_state = 15},
  [66] = {.lex_state = 15},
  [67] = {.lex_state = 15},
  [68] = {.lex_state = 15},
  [69] = {.lex_state = 15},
  [70] = {.lex_state = 15},
  [71] = {.lex_state = 15},
  [72] = {.lex_state = 15},
  [73] = {.lex_state = 15},
  [74] = {.lex_state = 15},
  [75] = {.lex_state = 15},
  [76] = {.lex_state = 15},
  [77] = {.lex_state = 15},
  [78] = {.lex_state = 15},
  [79] = {.lex_state = 15},
  [80] = {.lex_state = 15},
  [81] = {.lex_state = 15},
  [82] = {.lex_state = 15},
  [83] = {.lex_state = 15},
  [84] = {.lex_state = 15},
  [85] = {.lex_state = 15},
  [86] = {.lex_state = 15},
  [87] = {.lex_state = 15},
  [88] = {.lex_state = 15},
  [89] = {.lex_state = 15},
  [90] = {.lex_state = 15},
  [91] = {.lex_state = 15},
  [92] = {.lex_state = 15},
  [93] = {.lex_state = 15},
  [94] = {.lex_state = 15},
  [95] = {.lex_state = 15},
  [96] = {.lex_state = 15},
  [97] = {.lex_state = 15},
  [98] = {.lex_state = 15},
  [99] = {.lex_state = 15},
  [100] = {.lex_state = 15},
  [101] = {.lex_state = 15},
  [102] = {.lex_state = 15},
  [103] = {.lex_state = 15},
  [104] = {.lex_state = 15},
  [105] = {.lex_state = 15},
  [106] = {.lex_state = 15},
  [107] = {.lex_state = 15},
  [108] = {.lex_state = 15},
  [109] = {.lex_state = 15},
  [110] = {.lex_state = 15},
  [111] = {.lex_state = 15},
  [112] = {.lex_state = 15},
  [113] = {.lex_state = 15},
  [114] = {.lex_state = 15},
  [115] = {.lex_state = 15},
  [116] = {.lex_state = 15},
  [117] = {.lex_state = 15},
  [118] = {.lex_state = 15},
  [119] = {.lex_state = 15},
  [120] = {.lex_state = 15},
  [121] = {.lex_state = 15},
  [122] = {.lex_state = 15},
  [123] = {.lex_state = 15},
  [124] = {.lex_state = 15},
  [125] = {.lex_state = 15},
  [126] = {.lex_state = 15},
  [127] = {.lex_state = 15},
  [128] = {.lex_state = 15},
  [129] = {.lex_state = 15},
  [130] = {.lex_state = 15},
  [131] = {.lex_state = 15},
  [132] = {.lex_state = 15},
  [133] = {.lex_state = 15},
  [134] = {.lex_state = 15},
  [135] = {.lex_state = 15},
  [136] = {.lex_state = 15},
  [137] = {.lex_state = 15},
  [138] = {.lex_state = 15},
  [139] = {.lex_state = 15},
  [140] = {.lex_state = 15},
  [141] = {.lex_state = 15},
  [142] = {.lex_state = 15},
  [143] = {.lex_state = 15},
  [144] = {.lex_state = 15},
  [145] = {.lex_state = 15},
  [146] = {.lex_state = 15},
  [147] = {.lex_state = 15},
  [148] = {.lex_state = 15},
  [149] = {.lex_state = 2},
  [150] = {.lex_state = 2},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 1},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 1},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 1},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 1},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 1},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 5},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 5},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 5},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 5},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 16},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 16},
  [242] = {.lex_state = 16},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 5},
  [247] = {.lex_state = 5},
  [248] = {.lex_state = 5},
  [249] = {.lex_state = 5},
  [250] = {.lex_state = 5},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 5},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 5},
  [258] = {.lex_state = 5},
  [259] = {.lex_state = 1},
  [260] = {.lex_state = 1},
  [261] = {.lex_state = 15},
  [262] = {.lex_state = 15},
  [263] = {.lex_state = 15},
  [264] = {.lex_state = 15},
  [265] = {.lex_state = 15},
  [266] = {.lex_state = 15},
  [267] = {.lex_state = 12},
  [268] = {.lex_state = 12},
  [269] = {.lex_state = 12},
  [270] = {.lex_state = 12},
  [271] = {.lex_state = 12},
  [272] = {.lex_state = 12},
  [273] = {.lex_state = 12},
  [274] = {.lex_state = 12},
  [275] = {.lex_state = 12},
  [276] = {.lex_state = 12},
  [277] = {.lex_state = 12},
  [278] = {.lex_state = 6},
  [279] = {.lex_state = 6},
  [280] = {.lex_state = 12},
  [281] = {.lex_state = 9},
  [282] = {.lex_state = 428},
  [283] = {.lex_state = 428},
  [284] = {.lex_state = 8},
  [285] = {.lex_state = 428},
  [286] = {.lex_state = 428},
  [287] = {.lex_state = 428},
  [288] = {.lex_state = 428},
  [289] = {.lex_state = 428},
  [290] = {.lex_state = 8},
  [291] = {.lex_state = 428},
  [292] = {.lex_state = 8},
  [293] = {.lex_state = 428},
  [294] = {.lex_state = 428},
  [295] = {.lex_state = 428},
  [296] = {.lex_state = 428},
  [297] = {.lex_state = 428},
  [298] = {.lex_state = 428},
  [299] = {.lex_state = 428},
  [300] = {.lex_state = 428},
  [301] = {.lex_state = 428},
  [302] = {.lex_state = 428},
  [303] = {.lex_state = 428},
  [304] = {.lex_state = 428},
  [305] = {.lex_state = 428},
  [306] = {.lex_state = 14},
  [307] = {.lex_state = 428},
  [308] = {.lex_state = 428},
  [309] = {.lex_state = 428},
  [310] = {.lex_state = 428},
  [311] = {.lex_state = 428},
  [312] = {.lex_state = 428},
  [313] = {.lex_state = 428},
  [314] = {.lex_state = 428},
  [315] = {.lex_state = 428},
  [316] = {.lex_state = 428},
  [317] = {.lex_state = 428},
  [318] = {.lex_state = 428},
  [319] = {.lex_state = 428},
  [320] = {.lex_state = 428},
  [321] = {.lex_state = 428},
  [322] = {.lex_state = 428},
  [323] = {.lex_state = 428},
  [324] = {.lex_state = 428},
  [325] = {.lex_state = 428},
  [326] = {.lex_state = 428},
  [327] = {.lex_state = 428},
  [328] = {.lex_state = 428},
  [329] = {.lex_state = 428},
  [330] = {.lex_state = 428},
  [331] = {.lex_state = 428},
  [332] = {.lex_state = 428},
  [333] = {.lex_state = 428},
  [334] = {.lex_state = 428},
  [335] = {.lex_state = 428},
  [336] = {.lex_state = 428},
  [337] = {.lex_state = 428},
  [338] = {.lex_state = 428},
  [339] = {.lex_state = 428},
  [340] = {.lex_state = 428},
  [341] = {.lex_state = 428},
  [342] = {.lex_state = 428},
  [343] = {.lex_state = 428},
  [344] = {.lex_state = 428},
  [345] = {.lex_state = 428},
  [346] = {.lex_state = 428},
  [347] = {.lex_state = 428},
  [348] = {.lex_state = 428},
  [349] = {.lex_state = 428},
  [350] = {.lex_state = 428},
  [351] = {.lex_state = 428},
  [352] = {.lex_state = 428},
  [353] = {.lex_state = 428},
  [354] = {.lex_state = 7},
  [355] = {.lex_state = 7},
  [356] = {.lex_state = 8},
  [357] = {.lex_state = 428},
  [358] = {.lex_state = 8},
  [359] = {.lex_state = 8},
  [360] = {.lex_state = 8},
  [361] = {.lex_state = 8},
  [362] = {.lex_state = 8},
  [363] = {.lex_state = 8},
  [364] = {.lex_state = 8},
  [365] = {.lex_state = 8},
  [366] = {.lex_state = 14},
  [367] = {.lex_state = 8},
  [368] = {.lex_state = 8},
  [369] = {.lex_state = 8},
  [370] = {.lex_state = 8},
  [371] = {.lex_state = 8},
  [372] = {.lex_state = 8},
  [373] = {.lex_state = 8},
  [374] = {.lex_state = 8},
  [375] = {.lex_state = 8},
  [376] = {.lex_state = 14},
  [377] = {.lex_state = 14},
  [378] = {.lex_state = 8},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 1},
  [381] = {.lex_state = 1},
  [382] = {.lex_state = 1},
  [383] = {.lex_state = 1},
  [384] = {.lex_state = 1},
  [385] = {.lex_state = 1},
  [386] = {.lex_state = 1},
  [387] = {.lex_state = 428},
  [388] = {.lex_state = 428},
  [389] = {.lex_state = 428},
  [390] = {.lex_state = 1},
  [391] = {.lex_state = 428},
  [392] = {.lex_state = 428},
  [393] = {.lex_state = 428},
  [394] = {.lex_state = 428},
  [395] = {.lex_state = 428},
  [396] = {.lex_state = 428},
  [397] = {.lex_state = 428},
  [398] = {.lex_state = 428},
  [399] = {.lex_state = 428},
  [400] = {.lex_state = 428},
  [401] = {.lex_state = 428},
  [402] = {.lex_state = 428},
  [403] = {.lex_state = 428},
  [404] = {.lex_state = 428},
  [405] = {.lex_state = 428},
  [406] = {.lex_state = 428},
  [407] = {.lex_state = 428},
  [408] = {.lex_state = 428},
  [409] = {.lex_state = 428},
  [410] = {.lex_state = 428},
  [411] = {.lex_state = 428},
  [412] = {.lex_state = 8},
  [413] = {.lex_state = 428},
  [414] = {.lex_state = 428},
  [415] = {.lex_state = 428},
  [416] = {.lex_state = 428},
  [417] = {.lex_state = 428},
  [418] = {.lex_state = 428},
  [419] = {.lex_state = 8},
  [420] = {.lex_state = 428},
  [421] = {.lex_state = 428},
  [422] = {.lex_state = 13},
  [423] = {.lex_state = 428},
  [424] = {.lex_state = 428},
  [425] = {.lex_state = 428},
  [426] = {.lex_state = 428},
  [427] = {.lex_state = 428},
  [428] = {.lex_state = 428},
  [429] = {.lex_state = 428},
  [430] = {.lex_state = 428},
  [431] = {.lex_state = 428},
  [432] = {.lex_state = 428},
  [433] = {.lex_state = 428},
  [434] = {.lex_state = 428},
  [435] = {.lex_state = 428},
  [436] = {.lex_state = 428},
  [437] = {.lex_state = 428},
  [438] = {.lex_state = 428},
  [439] = {.lex_state = 428},
  [440] = {.lex_state = 428},
  [441] = {.lex_state = 428},
  [442] = {.lex_state = 428},
  [443] = {.lex_state = 428},
  [444] = {.lex_state = 428},
  [445] = {.lex_state = 428},
  [446] = {.lex_state = 428},
  [447] = {.lex_state = 428},
  [448] = {.lex_state = 428},
  [449] = {.lex_state = 428},
  [450] = {.lex_state = 8},
  [451] = {.lex_state = 8},
  [452] = {.lex_state = 428},
  [453] = {.lex_state = 8},
  [454] = {.lex_state = 8},
  [455] = {.lex_state = 8},
  [456] = {.lex_state = 8},
  [457] = {.lex_state = 8},
  [458] = {.lex_state = 8},
  [459] = {.lex_state = 12},
  [460] = {.lex_state = 12},
  [461] = {.lex_state = 8},
  [462] = {.lex_state = 12},
  [463] = {.lex_state = 428},
  [464] = {.lex_state = 12},
  [465] = {.lex_state = 12},
  [466] = {.lex_state = 12},
  [467] = {.lex_state = 12},
  [468] = {.lex_state = 12},
  [469] = {.lex_state = 12},
  [470] = {.lex_state = 12},
  [471] = {.lex_state = 12},
  [472] = {.lex_state = 12},
  [473] = {.lex_state = 12},
  [474] = {.lex_state = 12},
  [475] = {.lex_state = 12},
  [476] = {.lex_state = 12},
  [477] = {.lex_state = 12},
  [478] = {.lex_state = 12},
  [479] = {.lex_state = 12},
  [480] = {.lex_state = 12},
  [481] = {.lex_state = 12},
  [482] = {.lex_state = 12},
  [483] = {.lex_state = 12},
  [484] = {.lex_state = 12},
  [485] = {.lex_state = 12},
  [486] = {.lex_state = 12},
  [487] = {.lex_state = 12},
  [488] = {.lex_state = 12},
  [489] = {.lex_state = 12},
  [490] = {.lex_state = 12},
  [491] = {.lex_state = 12},
  [492] = {.lex_state = 12},
  [493] = {.lex_state = 12},
  [494] = {.lex_state = 12},
  [495] = {.lex_state = 12},
  [496] = {.lex_state = 12},
  [497] = {.lex_state = 12},
  [498] = {.lex_state = 12},
  [499] = {.lex_state = 12},
  [500] = {.lex_state = 12},
  [501] = {.lex_state = 12},
  [502] = {.lex_state = 12},
  [503] = {.lex_state = 12},
  [504] = {.lex_state = 12},
  [505] = {.lex_state = 12},
  [506] = {.lex_state = 12},
  [507] = {.lex_state = 12},
  [508] = {.lex_state = 12},
  [509] = {.lex_state = 428},
  [510] = {.lex_state = 428},
  [511] = {.lex_state = 428},
  [512] = {.lex_state = 428},
  [513] = {.lex_state = 428},
  [514] = {.lex_state = 428},
  [515] = {.lex_state = 428},
  [516] = {.lex_state = 428},
  [517] = {.lex_state = 14},
  [518] = {.lex_state = 14},
  [519] = {.lex_state = 14},
  [520] = {.lex_state = 14},
  [521] = {.lex_state = 14},
  [522] = {.lex_state = 14},
  [523] = {.lex_state = 14},
  [524] = {.lex_state = 14},
  [525] = {.lex_state = 14},
  [526] = {.lex_state = 14},
  [527] = {.lex_state = 14},
  [528] = {.lex_state = 14},
  [529] = {.lex_state = 14},
  [530] = {.lex_state = 14},
  [531] = {.lex_state = 14},
  [532] = {.lex_state = 14},
  [533] = {.lex_state = 14},
  [534] = {.lex_state = 14},
  [535] = {.lex_state = 14},
  [536] = {.lex_state = 14},
  [537] = {.lex_state = 14},
  [538] = {.lex_state = 14},
  [539] = {.lex_state = 14},
  [540] = {.lex_state = 14},
  [541] = {.lex_state = 14},
  [542] = {.lex_state = 14},
  [543] = {.lex_state = 14},
  [544] = {.lex_state = 14},
  [545] = {.lex_state = 14},
  [546] = {.lex_state = 14},
  [547] = {.lex_state = 14},
  [548] = {.lex_state = 19},
  [549] = {.lex_state = 428},
  [550] = {.lex_state = 428},
  [551] = {.lex_state = 428},
  [552] = {.lex_state = 428},
  [553] = {.lex_state = 428},
  [554] = {.lex_state = 428},
  [555] = {.lex_state = 428},
  [556] = {.lex_state = 428},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 428},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 428},
  [562] = {.lex_state = 428},
  [563] = {.lex_state = 428},
  [564] = {.lex_state = 428},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 428},
  [567] = {.lex_state = 428},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 428},
  [570] = {.lex_state = 428},
  [571] = {.lex_state = 428},
  [572] = {.lex_state = 428},
  [573] = {.lex_state = 428},
  [574] = {.lex_state = 428},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 428},
  [577] = {.lex_state = 428},
  [578] = {.lex_state = 428},
  [579] = {.lex_state = 428},
  [580] = {.lex_state = 428},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 24},
  [584] = {.lex_state = 24},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 0},
  [587] = {.lex_state = 15},
  [588] = {.lex_state = 33},
  [589] = {.lex_state = 15},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 0},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 15},
  [598] = {.lex_state = 6},
  [599] = {.lex_state = 15},
  [600] = {.lex_state = 6},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 19},
  [603] = {.lex_state = 19},
  [604] = {.lex_state = 19},
  [605] = {.lex_state = 19},
  [606] = {.lex_state = 9},
  [607] = {.lex_state = 17},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 17},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 19},
  [612] = {.lex_state = 17},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 9},
  [616] = {.lex_state = 19},
  [617] = {.lex_state = 9},
  [618] = {.lex_state = 17},
  [619] = {.lex_state = 17},
  [620] = {.lex_state = 0},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 20},
  [623] = {.lex_state = 20},
  [624] = {.lex_state = 20},
  [625] = {.lex_state = 20},
  [626] = {.lex_state = 15},
  [627] = {.lex_state = 20},
  [628] = {.lex_state = 20},
  [629] = {.lex_state = 15},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 0},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 19},
  [634] = {.lex_state = 0},
  [635] = {.lex_state = 20},
  [636] = {.lex_state = 20},
  [637] = {.lex_state = 15},
  [638] = {.lex_state = 20},
  [639] = {.lex_state = 20},
  [640] = {.lex_state = 19},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 20},
  [643] = {.lex_state = 20},
  [644] = {.lex_state = 20},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 20},
  [648] = {.lex_state = 20},
  [649] = {.lex_state = 20},
  [650] = {.lex_state = 20},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 9},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 20},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 34},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 428},
  [665] = {.lex_state = 428},
  [666] = {.lex_state = 19},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 0},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 20},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 19},
  [681] = {.lex_state = 428},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 9},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 20},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 20},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 17},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 15},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 15},
  [698] = {.lex_state = 0},
  [699] = {.lex_state = 19},
  [700] = {.lex_state = 20},
  [701] = {.lex_state = 20},
  [702] = {.lex_state = 17},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 428},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 20},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 9},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 34},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 20},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 20},
  [728] = {.lex_state = 15},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 20},
  [731] = {.lex_state = 15},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 19},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 428},
  [744] = {.lex_state = 15},
  [745] = {.lex_state = 15},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 19},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 20},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 20},
  [753] = {.lex_state = 34},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 20},
  [761] = {.lex_state = 19},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 20},
  [768] = {.lex_state = 19},
  [769] = {.lex_state = 19},
  [770] = {.lex_state = 20},
  [771] = {.lex_state = 19},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 20},
  [779] = {.lex_state = 20},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 19},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 19},
  [786] = {.lex_state = 20},
  [787] = {.lex_state = 20},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 20},
  [792] = {.lex_state = 9},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 20},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 20},
  [797] = {.lex_state = 20},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 20},
  [800] = {.lex_state = 20},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 19},
  [803] = {.lex_state = 20},
  [804] = {.lex_state = 20},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 20},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 0},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 20},
  [813] = {.lex_state = 20},
  [814] = {.lex_state = 20},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 19},
  [817] = {.lex_state = 19},
  [818] = {.lex_state = 19},
  [819] = {.lex_state = 20},
  [820] = {.lex_state = 19},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 20},
  [823] = {.lex_state = 20},
  [824] = {.lex_state = 20},
  [825] = {.lex_state = 19},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 20},
  [828] = {.lex_state = 20},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 20},
  [833] = {.lex_state = 428},
  [834] = {.lex_state = 15},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 12},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 9},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 15},
  [856] = {.lex_state = 1},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 9},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 20},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 428},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 15},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 15},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 15},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 15},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 428},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 428},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 12},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_export] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_component] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LT_EQ_GT] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_out] = ACTIONS(1),
    [anon_sym_transitions] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [anon_sym_animate] = ACTIONS(1),
    [anon_sym_delay] = ACTIONS(1),
    [anon_sym_duration] = ACTIONS(1),
    [anon_sym_iteration_DASHcount] = ACTIONS(1),
    [anon_sym_easing] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_ATtr] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_logical_and] = ACTIONS(1),
    [sym_logical_or] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_callback] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_ATimage_DASHurl] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [aux_sym_escape_sequence_token1] = ACTIONS(1),
    [anon_sym_n] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_color] = ACTIONS(1),
    [anon_sym_brush] = ACTIONS(1),
    [anon_sym_physical_DASHlength] = ACTIONS(1),
    [anon_sym_length] = ACTIONS(1),
    [anon_sym_angle] = ACTIONS(1),
    [anon_sym_percent] = ACTIONS(1),
    [anon_sym_image] = ACTIONS(1),
    [anon_sym_relative_DASHfont_DASHsize] = ACTIONS(1),
    [anon_sym_linear] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(1),
    [anon_sym_ease] = ACTIONS(1),
    [anon_sym_ease_DASHin] = ACTIONS(1),
    [anon_sym_ease_DASHout] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(1),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(1),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(1),
    [anon_sym_cubic_DASHbezier] = ACTIONS(1),
    [sym_children_identifier] = ACTIONS(1),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(1),
    [anon_sym_ATlinear_gradient] = ACTIONS(1),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(1),
    [anon_sym_ATradial_gradient] = ACTIONS(1),
    [anon_sym_circle] = ACTIONS(1),
    [anon_sym_parent] = ACTIONS(1),
    [anon_sym_root] = ACTIONS(1),
    [anon_sym_self] = ACTIONS(1),
    [sym__int_number] = ACTIONS(1),
    [sym__float_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_color_value] = ACTIONS(1),
    [anon_sym_phx] = ACTIONS(1),
    [aux_sym_length_value_token1] = ACTIONS(1),
    [aux_sym_duration_value_token1] = ACTIONS(1),
    [aux_sym_angle_value_token1] = ACTIONS(1),
    [anon_sym_PERCENT2] = ACTIONS(1),
    [anon_sym_rem] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_sourcefile] = STATE(889),
    [sym__definition] = STATE(463),
    [sym__local_type] = STATE(463),
    [sym__exported_type] = STATE(463),
    [sym_import_statement] = STATE(463),
    [sym_component_definition] = STATE(463),
    [sym_global_definition] = STATE(463),
    [sym_struct_definition] = STATE(463),
    [sym_enum_definition] = STATE(463),
    [sym_user_type_identifier] = STATE(888),
    [aux_sym_sourcefile_repeat1] = STATE(463),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_export] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_component] = ACTIONS(11),
    [anon_sym_global] = ACTIONS(13),
    [anon_sym_struct] = ACTIONS(15),
    [anon_sym_enum] = ACTIONS(17),
    [sym__identifier] = ACTIONS(19),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__imperative_block_statement] = STATE(9),
    [sym_binding] = STATE(9),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(9),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(9),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(216),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(25),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__imperative_block_statement] = STATE(9),
    [sym_binding] = STATE(9),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(9),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(9),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(216),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(63),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym__imperative_block_statement] = STATE(12),
    [sym_binding] = STATE(12),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(12),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(12),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(216),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(65),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__imperative_block_statement] = STATE(10),
    [sym_binding] = STATE(10),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(10),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(10),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(216),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(10),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(67),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__imperative_block_statement] = STATE(10),
    [sym_binding] = STATE(10),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(10),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(10),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(216),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(10),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_COMMA] = ACTIONS(23),
    [anon_sym_RBRACE] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__imperative_block_statement] = STATE(9),
    [sym_binding] = STATE(9),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(9),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(9),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(9),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__imperative_block_statement] = STATE(10),
    [sym_binding] = STATE(10),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(10),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(10),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(10),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(73),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__imperative_block_statement] = STATE(14),
    [sym_binding] = STATE(14),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(14),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(14),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(75),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__imperative_block_statement] = STATE(14),
    [sym_binding] = STATE(14),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(14),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(14),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(77),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__imperative_block_statement] = STATE(13),
    [sym_binding] = STATE(13),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(13),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(13),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(13),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(79),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__imperative_block_statement] = STATE(14),
    [sym_binding] = STATE(14),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(14),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(14),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(81),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__imperative_block_statement] = STATE(14),
    [sym_binding] = STATE(14),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(14),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(14),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(83),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__imperative_block_statement] = STATE(14),
    [sym_binding] = STATE(14),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(14),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(14),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(14),
    [anon_sym_LBRACE] = ACTIONS(85),
    [anon_sym_RBRACE] = ACTIONS(88),
    [anon_sym_return] = ACTIONS(90),
    [anon_sym_LBRACK] = ACTIONS(93),
    [anon_sym_if] = ACTIONS(96),
    [anon_sym_LPAREN] = ACTIONS(99),
    [anon_sym_ATtr] = ACTIONS(102),
    [anon_sym_ATimage_DASHurl] = ACTIONS(105),
    [anon_sym_BANG] = ACTIONS(108),
    [anon_sym_DASH] = ACTIONS(108),
    [anon_sym_PLUS] = ACTIONS(108),
    [anon_sym_DQUOTE] = ACTIONS(111),
    [sym__identifier] = ACTIONS(114),
    [anon_sym_linear] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(117),
    [anon_sym_ease] = ACTIONS(117),
    [anon_sym_ease_DASHin] = ACTIONS(117),
    [anon_sym_ease_DASHout] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(117),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(117),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(117),
    [anon_sym_cubic_DASHbezier] = ACTIONS(120),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(123),
    [anon_sym_ATlinear_gradient] = ACTIONS(123),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(126),
    [anon_sym_ATradial_gradient] = ACTIONS(126),
    [anon_sym_parent] = ACTIONS(129),
    [anon_sym_root] = ACTIONS(129),
    [anon_sym_self] = ACTIONS(129),
    [sym__int_number] = ACTIONS(132),
    [sym__float_number] = ACTIONS(135),
    [anon_sym_true] = ACTIONS(138),
    [anon_sym_false] = ACTIONS(138),
    [sym_color_value] = ACTIONS(141),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__imperative_block_statement] = STATE(12),
    [sym_binding] = STATE(12),
    [sym_anon_struct_block] = STATE(218),
    [sym_if_expr] = STATE(12),
    [sym__assignment_setup] = STATE(44),
    [sym_assignment_block] = STATE(243),
    [sym_assignment_expr] = STATE(243),
    [sym_expression] = STATE(151),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_callback_event] = STATE(12),
    [sym_function_call] = STATE(226),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(185),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [aux_sym_imperative_block_repeat1] = STATE(12),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_RBRACE] = ACTIONS(144),
    [anon_sym_return] = ACTIONS(27),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_if] = ACTIONS(31),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_in_out_transition] = STATE(17),
    [sym__assignment_setup] = STATE(40),
    [sym_assignment_block] = STATE(17),
    [sym_assignment_expr] = STATE(810),
    [sym_expression] = STATE(357),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [aux_sym_states_definition_repeat1] = STATE(17),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_RBRACE] = ACTIONS(148),
    [anon_sym_in] = ACTIONS(150),
    [anon_sym_out] = ACTIONS(150),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_in_out_transition] = STATE(18),
    [sym__assignment_setup] = STATE(40),
    [sym_assignment_block] = STATE(18),
    [sym_assignment_expr] = STATE(764),
    [sym_expression] = STATE(357),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [aux_sym_states_definition_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_RBRACE] = ACTIONS(178),
    [anon_sym_in] = ACTIONS(150),
    [anon_sym_out] = ACTIONS(150),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_in_out_transition] = STATE(18),
    [sym__assignment_setup] = STATE(46),
    [sym_assignment_block] = STATE(18),
    [sym_assignment_expr] = STATE(860),
    [sym_expression] = STATE(357),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [aux_sym_states_definition_repeat1] = STATE(18),
    [anon_sym_LBRACE] = ACTIONS(180),
    [anon_sym_RBRACE] = ACTIONS(183),
    [anon_sym_in] = ACTIONS(185),
    [anon_sym_out] = ACTIONS(185),
    [anon_sym_LBRACK] = ACTIONS(188),
    [anon_sym_LPAREN] = ACTIONS(191),
    [anon_sym_ATtr] = ACTIONS(194),
    [anon_sym_ATimage_DASHurl] = ACTIONS(197),
    [anon_sym_BANG] = ACTIONS(200),
    [anon_sym_DASH] = ACTIONS(200),
    [anon_sym_PLUS] = ACTIONS(200),
    [anon_sym_DQUOTE] = ACTIONS(203),
    [sym__identifier] = ACTIONS(206),
    [anon_sym_linear] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(209),
    [anon_sym_ease] = ACTIONS(209),
    [anon_sym_ease_DASHin] = ACTIONS(209),
    [anon_sym_ease_DASHout] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(209),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(209),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(209),
    [anon_sym_cubic_DASHbezier] = ACTIONS(212),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(215),
    [anon_sym_ATlinear_gradient] = ACTIONS(215),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(218),
    [anon_sym_ATradial_gradient] = ACTIONS(218),
    [anon_sym_parent] = ACTIONS(221),
    [anon_sym_root] = ACTIONS(221),
    [anon_sym_self] = ACTIONS(221),
    [sym__int_number] = ACTIONS(224),
    [sym__float_number] = ACTIONS(227),
    [anon_sym_true] = ACTIONS(230),
    [anon_sym_false] = ACTIONS(230),
    [sym_color_value] = ACTIONS(233),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(236),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(242),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(244),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(246),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(248),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(250),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(252),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_RPAREN] = ACTIONS(254),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(706),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(407),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_argument] = STATE(655),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(256),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(906),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(712),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(403),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_COMMA] = ACTIONS(258),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(260),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(396),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_COMMA] = ACTIONS(262),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(264),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(407),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_argument] = STATE(763),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(266),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_imperative_block] = STATE(245),
    [sym__binding] = STATE(260),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(417),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(268),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_imperative_block] = STATE(518),
    [sym__binding] = STATE(536),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(429),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(407),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_argument] = STATE(763),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(272),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_imperative_block] = STATE(518),
    [sym__binding] = STATE(530),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(429),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(407),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_argument] = STATE(763),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(274),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_imperative_block] = STATE(462),
    [sym__binding] = STATE(486),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(424),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_block] = STATE(247),
    [sym__assignment_value_block] = STATE(246),
    [sym_expression] = STATE(404),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(862),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(722),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(719),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_block] = STATE(236),
    [sym__assignment_value_block] = STATE(237),
    [sym_expression] = STATE(227),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(756),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_block] = STATE(247),
    [sym__assignment_value_block] = STATE(246),
    [sym_expression] = STATE(404),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(407),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_argument] = STATE(668),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(284),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(407),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_argument] = STATE(763),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(286),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_imperative_block] = STATE(245),
    [sym__binding] = STATE(260),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(389),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(288),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_imperative_block] = STATE(462),
    [sym__binding] = STATE(498),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(424),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(905),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(390),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_gradient_color] = STATE(858),
    [sym_image_call] = STATE(167),
    [sym_argument] = STATE(594),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(290),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_imperative_block] = STATE(460),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(430),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(292),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(294),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(296),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(298),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(300),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(302),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(304),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(306),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(308),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(310),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(312),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(314),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(407),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_argument] = STATE(763),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_imperative_block] = STATE(460),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(387),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_for_range] = STATE(859),
    [sym_expression] = STATE(425),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(509),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(318),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(320),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(322),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(324),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_RBRACK] = ACTIONS(326),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(434),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(330),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_imperative_block] = STATE(460),
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(388),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(316),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(440),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(398),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(411),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(402),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(283),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(438),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(406),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(449),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(433),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(291),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(395),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(405),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(285),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(437),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(397),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(436),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(286),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(435),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(408),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(446),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(432),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(439),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(441),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(334),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(400),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(287),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(431),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(399),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(288),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(415),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(421),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(444),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(289),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(410),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [112] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(428),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [113] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(394),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [114] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(416),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(336),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [115] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(164),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [116] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(426),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [117] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(391),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [118] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(448),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [119] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(418),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [120] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(447),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [121] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(427),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [122] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(443),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [123] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(445),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [124] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(152),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [125] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(423),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [126] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(420),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [127] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(282),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [128] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(414),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [129] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(384),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [130] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(401),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [131] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(409),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [132] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(413),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [133] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(157),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [134] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(386),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [135] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(158),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [136] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(162),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [137] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(163),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [138] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(165),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [139] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(156),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(124),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(55),
    [sym__float_number] = ACTIONS(57),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [140] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(381),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [141] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(392),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [142] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(442),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [143] = {
    [sym_anon_struct_block] = STATE(329),
    [sym_expression] = STATE(393),
    [sym_parens_op] = STATE(326),
    [sym_index_op] = STATE(326),
    [sym_tr] = STATE(326),
    [sym_member_access] = STATE(326),
    [sym_unary_expression] = STATE(326),
    [sym_binary_expression] = STATE(326),
    [sym__add_binary_expression] = STATE(325),
    [sym__comparison_binary_expression] = STATE(323),
    [sym__logic_binary_expression] = STATE(322),
    [sym__mult_binary_expression] = STATE(321),
    [sym_ternary_expression] = STATE(326),
    [sym_function_call] = STATE(326),
    [sym_gradient_call] = STATE(326),
    [sym_image_call] = STATE(326),
    [sym_unary_prec_operator] = STATE(127),
    [sym__string] = STATE(284),
    [sym_simple_identifier] = STATE(293),
    [sym_easing_kind_identifier] = STATE(329),
    [sym_value_list] = STATE(329),
    [sym_value] = STATE(326),
    [sym_linear_gradient_identifier] = STATE(909),
    [sym_radial_gradient_identifier] = STATE(876),
    [sym_reference_identifier] = STATE(326),
    [sym__number] = STATE(598),
    [sym_int_value] = STATE(329),
    [sym_float_value] = STATE(329),
    [sym_bool_value] = STATE(329),
    [sym_string_value] = STATE(329),
    [sym_physical_length_value] = STATE(329),
    [sym_length_value] = STATE(329),
    [sym_duration_value] = STATE(329),
    [sym_angle_value] = STATE(329),
    [sym_percent_value] = STATE(329),
    [sym_relative_font_size_value] = STATE(329),
    [sym__basic_value] = STATE(329),
    [anon_sym_LBRACE] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(152),
    [anon_sym_LPAREN] = ACTIONS(154),
    [anon_sym_ATtr] = ACTIONS(156),
    [anon_sym_ATimage_DASHurl] = ACTIONS(158),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(160),
    [sym__identifier] = ACTIONS(162),
    [anon_sym_linear] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(164),
    [anon_sym_ease] = ACTIONS(164),
    [anon_sym_ease_DASHin] = ACTIONS(164),
    [anon_sym_ease_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(164),
    [anon_sym_cubic_DASHbezier] = ACTIONS(166),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(168),
    [anon_sym_root] = ACTIONS(168),
    [anon_sym_self] = ACTIONS(168),
    [sym__int_number] = ACTIONS(170),
    [sym__float_number] = ACTIONS(172),
    [anon_sym_true] = ACTIONS(174),
    [anon_sym_false] = ACTIONS(174),
    [sym_color_value] = ACTIONS(176),
    [sym_comment] = ACTIONS(3),
  },
  [144] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(385),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [145] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(379),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [146] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(380),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [147] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(382),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [148] = {
    [sym_anon_struct_block] = STATE(218),
    [sym_expression] = STATE(383),
    [sym_parens_op] = STATE(167),
    [sym_index_op] = STATE(167),
    [sym_tr] = STATE(167),
    [sym_member_access] = STATE(167),
    [sym_unary_expression] = STATE(167),
    [sym_binary_expression] = STATE(167),
    [sym__add_binary_expression] = STATE(203),
    [sym__comparison_binary_expression] = STATE(202),
    [sym__logic_binary_expression] = STATE(199),
    [sym__mult_binary_expression] = STATE(198),
    [sym_ternary_expression] = STATE(167),
    [sym_function_call] = STATE(167),
    [sym_gradient_call] = STATE(167),
    [sym_image_call] = STATE(167),
    [sym_unary_prec_operator] = STATE(129),
    [sym__string] = STATE(192),
    [sym_simple_identifier] = STATE(155),
    [sym_easing_kind_identifier] = STATE(218),
    [sym_value_list] = STATE(218),
    [sym_value] = STATE(167),
    [sym_linear_gradient_identifier] = STATE(918),
    [sym_radial_gradient_identifier] = STATE(919),
    [sym_reference_identifier] = STATE(167),
    [sym__number] = STATE(600),
    [sym_int_value] = STATE(218),
    [sym_float_value] = STATE(218),
    [sym_bool_value] = STATE(218),
    [sym_string_value] = STATE(218),
    [sym_physical_length_value] = STATE(218),
    [sym_length_value] = STATE(218),
    [sym_duration_value] = STATE(218),
    [sym_angle_value] = STATE(218),
    [sym_percent_value] = STATE(218),
    [sym_relative_font_size_value] = STATE(218),
    [sym__basic_value] = STATE(218),
    [anon_sym_LBRACE] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(29),
    [anon_sym_LPAREN] = ACTIONS(33),
    [anon_sym_ATtr] = ACTIONS(35),
    [anon_sym_ATimage_DASHurl] = ACTIONS(37),
    [anon_sym_BANG] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(39),
    [anon_sym_PLUS] = ACTIONS(39),
    [anon_sym_DQUOTE] = ACTIONS(41),
    [sym__identifier] = ACTIONS(43),
    [anon_sym_linear] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(45),
    [anon_sym_ease] = ACTIONS(45),
    [anon_sym_ease_DASHin] = ACTIONS(45),
    [anon_sym_ease_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(45),
    [anon_sym_cubic_DASHbezier] = ACTIONS(47),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(49),
    [anon_sym_ATlinear_gradient] = ACTIONS(49),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(51),
    [anon_sym_ATradial_gradient] = ACTIONS(51),
    [anon_sym_parent] = ACTIONS(53),
    [anon_sym_root] = ACTIONS(53),
    [anon_sym_self] = ACTIONS(53),
    [sym__int_number] = ACTIONS(238),
    [sym__float_number] = ACTIONS(240),
    [anon_sym_true] = ACTIONS(59),
    [anon_sym_false] = ACTIONS(59),
    [sym_color_value] = ACTIONS(61),
    [sym_comment] = ACTIONS(3),
  },
  [149] = {
    [anon_sym_LBRACE] = ACTIONS(338),
    [anon_sym_RBRACE] = ACTIONS(338),
    [anon_sym_SEMI] = ACTIONS(338),
    [anon_sym_LT] = ACTIONS(340),
    [anon_sym_GT] = ACTIONS(340),
    [anon_sym_return] = ACTIONS(340),
    [anon_sym_COLON] = ACTIONS(338),
    [anon_sym_LBRACK] = ACTIONS(338),
    [anon_sym_if] = ACTIONS(340),
    [anon_sym_LPAREN] = ACTIONS(338),
    [anon_sym_ATtr] = ACTIONS(338),
    [anon_sym_DOT] = ACTIONS(340),
    [sym_logical_and] = ACTIONS(338),
    [sym_logical_or] = ACTIONS(338),
    [anon_sym_QMARK] = ACTIONS(338),
    [anon_sym_ATimage_DASHurl] = ACTIONS(338),
    [anon_sym_BANG] = ACTIONS(340),
    [anon_sym_DASH] = ACTIONS(340),
    [anon_sym_PLUS] = ACTIONS(340),
    [anon_sym_STAR] = ACTIONS(340),
    [anon_sym_SLASH] = ACTIONS(340),
    [anon_sym_GT_EQ] = ACTIONS(338),
    [anon_sym_LT_EQ] = ACTIONS(338),
    [anon_sym_EQ_EQ] = ACTIONS(338),
    [anon_sym_BANG_EQ] = ACTIONS(338),
    [anon_sym_EQ] = ACTIONS(340),
    [anon_sym_PLUS_EQ] = ACTIONS(338),
    [anon_sym_DASH_EQ] = ACTIONS(338),
    [anon_sym_STAR_EQ] = ACTIONS(338),
    [anon_sym_SLASH_EQ] = ACTIONS(338),
    [anon_sym_DQUOTE] = ACTIONS(338),
    [sym__identifier] = ACTIONS(340),
    [anon_sym_linear] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(340),
    [anon_sym_ease] = ACTIONS(340),
    [anon_sym_ease_DASHin] = ACTIONS(340),
    [anon_sym_ease_DASHout] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(340),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(340),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(340),
    [anon_sym_cubic_DASHbezier] = ACTIONS(340),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(338),
    [anon_sym_ATlinear_gradient] = ACTIONS(338),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(338),
    [anon_sym_ATradial_gradient] = ACTIONS(338),
    [anon_sym_parent] = ACTIONS(340),
    [anon_sym_root] = ACTIONS(340),
    [anon_sym_self] = ACTIONS(340),
    [sym__int_number] = ACTIONS(340),
    [sym__float_number] = ACTIONS(338),
    [anon_sym_true] = ACTIONS(340),
    [anon_sym_false] = ACTIONS(340),
    [sym_color_value] = ACTIONS(338),
    [anon_sym_phx] = ACTIONS(342),
    [aux_sym_length_value_token1] = ACTIONS(342),
    [aux_sym_duration_value_token1] = ACTIONS(342),
    [aux_sym_angle_value_token1] = ACTIONS(342),
    [anon_sym_PERCENT2] = ACTIONS(344),
    [anon_sym_rem] = ACTIONS(342),
    [sym_comment] = ACTIONS(3),
  },
  [150] = {
    [anon_sym_LBRACE] = ACTIONS(346),
    [anon_sym_RBRACE] = ACTIONS(346),
    [anon_sym_SEMI] = ACTIONS(346),
    [anon_sym_LT] = ACTIONS(348),
    [anon_sym_GT] = ACTIONS(348),
    [anon_sym_return] = ACTIONS(348),
    [anon_sym_COLON] = ACTIONS(346),
    [anon_sym_LBRACK] = ACTIONS(346),
    [anon_sym_if] = ACTIONS(348),
    [anon_sym_LPAREN] = ACTIONS(346),
    [anon_sym_ATtr] = ACTIONS(346),
    [anon_sym_DOT] = ACTIONS(348),
    [sym_logical_and] = ACTIONS(346),
    [sym_logical_or] = ACTIONS(346),
    [anon_sym_QMARK] = ACTIONS(346),
    [anon_sym_ATimage_DASHurl] = ACTIONS(346),
    [anon_sym_BANG] = ACTIONS(348),
    [anon_sym_DASH] = ACTIONS(348),
    [anon_sym_PLUS] = ACTIONS(348),
    [anon_sym_STAR] = ACTIONS(348),
    [anon_sym_SLASH] = ACTIONS(348),
    [anon_sym_GT_EQ] = ACTIONS(346),
    [anon_sym_LT_EQ] = ACTIONS(346),
    [anon_sym_EQ_EQ] = ACTIONS(346),
    [anon_sym_BANG_EQ] = ACTIONS(346),
    [anon_sym_EQ] = ACTIONS(348),
    [anon_sym_PLUS_EQ] = ACTIONS(346),
    [anon_sym_DASH_EQ] = ACTIONS(346),
    [anon_sym_STAR_EQ] = ACTIONS(346),
    [anon_sym_SLASH_EQ] = ACTIONS(346),
    [anon_sym_DQUOTE] = ACTIONS(346),
    [sym__identifier] = ACTIONS(348),
    [anon_sym_linear] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(348),
    [anon_sym_ease] = ACTIONS(348),
    [anon_sym_ease_DASHin] = ACTIONS(348),
    [anon_sym_ease_DASHout] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(348),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(348),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(348),
    [anon_sym_cubic_DASHbezier] = ACTIONS(348),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(346),
    [anon_sym_ATlinear_gradient] = ACTIONS(346),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(346),
    [anon_sym_ATradial_gradient] = ACTIONS(346),
    [anon_sym_parent] = ACTIONS(348),
    [anon_sym_root] = ACTIONS(348),
    [anon_sym_self] = ACTIONS(348),
    [sym__int_number] = ACTIONS(348),
    [sym__float_number] = ACTIONS(346),
    [anon_sym_true] = ACTIONS(348),
    [anon_sym_false] = ACTIONS(348),
    [sym_color_value] = ACTIONS(346),
    [anon_sym_phx] = ACTIONS(342),
    [aux_sym_length_value_token1] = ACTIONS(342),
    [aux_sym_duration_value_token1] = ACTIONS(342),
    [aux_sym_angle_value_token1] = ACTIONS(342),
    [anon_sym_PERCENT2] = ACTIONS(344),
    [anon_sym_rem] = ACTIONS(342),
    [sym_comment] = ACTIONS(3),
  },
  [151] = {
    [sym_add_prec_operator] = STATE(137),
    [sym_mult_prec_operator] = STATE(138),
    [sym_comparison_operator] = STATE(139),
    [sym_assignment_prec_operator] = STATE(263),
    [anon_sym_LBRACE] = ACTIONS(350),
    [anon_sym_RBRACE] = ACTIONS(350),
    [anon_sym_SEMI] = ACTIONS(328),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(354),
    [anon_sym_COLON] = ACTIONS(356),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(354),
    [anon_sym_LPAREN] = ACTIONS(350),
    [anon_sym_ATtr] = ACTIONS(350),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(362),
    [sym_logical_or] = ACTIONS(364),
    [anon_sym_QMARK] = ACTIONS(366),
    [anon_sym_ATimage_DASHurl] = ACTIONS(350),
    [anon_sym_BANG] = ACTIONS(354),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(372),
    [anon_sym_LT_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_EQ] = ACTIONS(374),
    [anon_sym_PLUS_EQ] = ACTIONS(356),
    [anon_sym_DASH_EQ] = ACTIONS(356),
    [anon_sym_STAR_EQ] = ACTIONS(356),
    [anon_sym_SLASH_EQ] = ACTIONS(356),
    [anon_sym_DQUOTE] = ACTIONS(350),
    [sym__identifier] = ACTIONS(354),
    [anon_sym_linear] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(354),
    [anon_sym_ease] = ACTIONS(354),
    [anon_sym_ease_DASHin] = ACTIONS(354),
    [anon_sym_ease_DASHout] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(354),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(354),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(354),
    [anon_sym_cubic_DASHbezier] = ACTIONS(354),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(350),
    [anon_sym_ATlinear_gradient] = ACTIONS(350),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(350),
    [anon_sym_ATradial_gradient] = ACTIONS(350),
    [anon_sym_parent] = ACTIONS(354),
    [anon_sym_root] = ACTIONS(354),
    [anon_sym_self] = ACTIONS(354),
    [sym__int_number] = ACTIONS(354),
    [sym__float_number] = ACTIONS(350),
    [anon_sym_true] = ACTIONS(354),
    [anon_sym_false] = ACTIONS(354),
    [sym_color_value] = ACTIONS(350),
    [sym_comment] = ACTIONS(3),
  },
  [152] = {
    [sym_add_prec_operator] = STATE(137),
    [sym_mult_prec_operator] = STATE(138),
    [sym_comparison_operator] = STATE(139),
    [anon_sym_LBRACE] = ACTIONS(376),
    [anon_sym_RBRACE] = ACTIONS(376),
    [anon_sym_SEMI] = ACTIONS(376),
    [anon_sym_LT] = ACTIONS(378),
    [anon_sym_GT] = ACTIONS(378),
    [anon_sym_return] = ACTIONS(378),
    [anon_sym_COLON] = ACTIONS(376),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(376),
    [anon_sym_ATtr] = ACTIONS(376),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(376),
    [sym_logical_or] = ACTIONS(376),
    [anon_sym_QMARK] = ACTIONS(376),
    [anon_sym_ATimage_DASHurl] = ACTIONS(376),
    [anon_sym_BANG] = ACTIONS(378),
    [anon_sym_DASH] = ACTIONS(378),
    [anon_sym_PLUS] = ACTIONS(378),
    [anon_sym_STAR] = ACTIONS(378),
    [anon_sym_SLASH] = ACTIONS(378),
    [anon_sym_GT_EQ] = ACTIONS(376),
    [anon_sym_LT_EQ] = ACTIONS(376),
    [anon_sym_EQ_EQ] = ACTIONS(376),
    [anon_sym_BANG_EQ] = ACTIONS(376),
    [anon_sym_EQ] = ACTIONS(378),
    [anon_sym_PLUS_EQ] = ACTIONS(376),
    [anon_sym_DASH_EQ] = ACTIONS(376),
    [anon_sym_STAR_EQ] = ACTIONS(376),
    [anon_sym_SLASH_EQ] = ACTIONS(376),
    [anon_sym_DQUOTE] = ACTIONS(376),
    [sym__identifier] = ACTIONS(378),
    [anon_sym_linear] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(378),
    [anon_sym_ease] = ACTIONS(378),
    [anon_sym_ease_DASHin] = ACTIONS(378),
    [anon_sym_ease_DASHout] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(378),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(378),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(378),
    [anon_sym_cubic_DASHbezier] = ACTIONS(378),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(376),
    [anon_sym_ATlinear_gradient] = ACTIONS(376),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(376),
    [anon_sym_ATradial_gradient] = ACTIONS(376),
    [anon_sym_parent] = ACTIONS(378),
    [anon_sym_root] = ACTIONS(378),
    [anon_sym_self] = ACTIONS(378),
    [sym__int_number] = ACTIONS(378),
    [sym__float_number] = ACTIONS(376),
    [anon_sym_true] = ACTIONS(378),
    [anon_sym_false] = ACTIONS(378),
    [sym_color_value] = ACTIONS(376),
    [sym_comment] = ACTIONS(3),
  },
  [153] = {
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_COMMA] = ACTIONS(380),
    [anon_sym_RBRACE] = ACTIONS(380),
    [anon_sym_SEMI] = ACTIONS(380),
    [anon_sym_LT] = ACTIONS(382),
    [anon_sym_GT] = ACTIONS(382),
    [anon_sym_return] = ACTIONS(382),
    [anon_sym_COLON] = ACTIONS(380),
    [anon_sym_LBRACK] = ACTIONS(380),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_LPAREN] = ACTIONS(380),
    [anon_sym_RPAREN] = ACTIONS(380),
    [anon_sym_ATtr] = ACTIONS(380),
    [anon_sym_EQ_GT] = ACTIONS(380),
    [anon_sym_DOT] = ACTIONS(382),
    [sym_logical_and] = ACTIONS(380),
    [sym_logical_or] = ACTIONS(380),
    [anon_sym_QMARK] = ACTIONS(380),
    [anon_sym_ATimage_DASHurl] = ACTIONS(380),
    [anon_sym_BANG] = ACTIONS(382),
    [anon_sym_DASH] = ACTIONS(382),
    [anon_sym_PLUS] = ACTIONS(382),
    [anon_sym_STAR] = ACTIONS(382),
    [anon_sym_SLASH] = ACTIONS(382),
    [anon_sym_GT_EQ] = ACTIONS(380),
    [anon_sym_LT_EQ] = ACTIONS(380),
    [anon_sym_EQ_EQ] = ACTIONS(380),
    [anon_sym_BANG_EQ] = ACTIONS(380),
    [anon_sym_EQ] = ACTIONS(382),
    [anon_sym_PLUS_EQ] = ACTIONS(380),
    [anon_sym_DASH_EQ] = ACTIONS(380),
    [anon_sym_STAR_EQ] = ACTIONS(380),
    [anon_sym_SLASH_EQ] = ACTIONS(380),
    [anon_sym_DQUOTE] = ACTIONS(380),
    [sym__identifier] = ACTIONS(382),
    [anon_sym_linear] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(382),
    [anon_sym_ease] = ACTIONS(382),
    [anon_sym_ease_DASHin] = ACTIONS(382),
    [anon_sym_ease_DASHout] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(382),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(382),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(382),
    [anon_sym_cubic_DASHbezier] = ACTIONS(382),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(380),
    [anon_sym_ATlinear_gradient] = ACTIONS(380),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(380),
    [anon_sym_ATradial_gradient] = ACTIONS(380),
    [anon_sym_parent] = ACTIONS(382),
    [anon_sym_root] = ACTIONS(382),
    [anon_sym_self] = ACTIONS(382),
    [sym__int_number] = ACTIONS(382),
    [sym__float_number] = ACTIONS(380),
    [anon_sym_true] = ACTIONS(382),
    [anon_sym_false] = ACTIONS(382),
    [sym_color_value] = ACTIONS(380),
    [sym_comment] = ACTIONS(3),
  },
  [154] = {
    [anon_sym_LBRACE] = ACTIONS(384),
    [anon_sym_COMMA] = ACTIONS(384),
    [anon_sym_RBRACE] = ACTIONS(384),
    [anon_sym_SEMI] = ACTIONS(384),
    [anon_sym_LT] = ACTIONS(386),
    [anon_sym_GT] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(386),
    [anon_sym_COLON] = ACTIONS(384),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_if] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(384),
    [anon_sym_RPAREN] = ACTIONS(384),
    [anon_sym_ATtr] = ACTIONS(384),
    [anon_sym_EQ_GT] = ACTIONS(384),
    [anon_sym_DOT] = ACTIONS(386),
    [sym_logical_and] = ACTIONS(384),
    [sym_logical_or] = ACTIONS(384),
    [anon_sym_QMARK] = ACTIONS(384),
    [anon_sym_ATimage_DASHurl] = ACTIONS(384),
    [anon_sym_BANG] = ACTIONS(386),
    [anon_sym_DASH] = ACTIONS(386),
    [anon_sym_PLUS] = ACTIONS(386),
    [anon_sym_STAR] = ACTIONS(386),
    [anon_sym_SLASH] = ACTIONS(386),
    [anon_sym_GT_EQ] = ACTIONS(384),
    [anon_sym_LT_EQ] = ACTIONS(384),
    [anon_sym_EQ_EQ] = ACTIONS(384),
    [anon_sym_BANG_EQ] = ACTIONS(384),
    [anon_sym_EQ] = ACTIONS(386),
    [anon_sym_PLUS_EQ] = ACTIONS(384),
    [anon_sym_DASH_EQ] = ACTIONS(384),
    [anon_sym_STAR_EQ] = ACTIONS(384),
    [anon_sym_SLASH_EQ] = ACTIONS(384),
    [anon_sym_DQUOTE] = ACTIONS(384),
    [sym__identifier] = ACTIONS(386),
    [anon_sym_linear] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(386),
    [anon_sym_ease] = ACTIONS(386),
    [anon_sym_ease_DASHin] = ACTIONS(386),
    [anon_sym_ease_DASHout] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(386),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(386),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(386),
    [anon_sym_cubic_DASHbezier] = ACTIONS(386),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(384),
    [anon_sym_ATlinear_gradient] = ACTIONS(384),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(384),
    [anon_sym_ATradial_gradient] = ACTIONS(384),
    [anon_sym_parent] = ACTIONS(386),
    [anon_sym_root] = ACTIONS(386),
    [anon_sym_self] = ACTIONS(386),
    [sym__int_number] = ACTIONS(386),
    [sym__float_number] = ACTIONS(384),
    [anon_sym_true] = ACTIONS(386),
    [anon_sym_false] = ACTIONS(386),
    [sym_color_value] = ACTIONS(384),
    [sym_comment] = ACTIONS(3),
  },
  [155] = {
    [sym_arguments] = STATE(154),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_COMMA] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(388),
    [anon_sym_SEMI] = ACTIONS(388),
    [anon_sym_LT] = ACTIONS(390),
    [anon_sym_GT] = ACTIONS(390),
    [anon_sym_return] = ACTIONS(390),
    [anon_sym_COLON] = ACTIONS(388),
    [anon_sym_LBRACK] = ACTIONS(388),
    [anon_sym_if] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(392),
    [anon_sym_RPAREN] = ACTIONS(388),
    [anon_sym_ATtr] = ACTIONS(388),
    [anon_sym_DOT] = ACTIONS(390),
    [sym_logical_and] = ACTIONS(388),
    [sym_logical_or] = ACTIONS(388),
    [anon_sym_QMARK] = ACTIONS(388),
    [anon_sym_ATimage_DASHurl] = ACTIONS(388),
    [anon_sym_BANG] = ACTIONS(390),
    [anon_sym_DASH] = ACTIONS(390),
    [anon_sym_PLUS] = ACTIONS(390),
    [anon_sym_STAR] = ACTIONS(390),
    [anon_sym_SLASH] = ACTIONS(390),
    [anon_sym_GT_EQ] = ACTIONS(388),
    [anon_sym_LT_EQ] = ACTIONS(388),
    [anon_sym_EQ_EQ] = ACTIONS(388),
    [anon_sym_BANG_EQ] = ACTIONS(388),
    [anon_sym_EQ] = ACTIONS(390),
    [anon_sym_PLUS_EQ] = ACTIONS(388),
    [anon_sym_DASH_EQ] = ACTIONS(388),
    [anon_sym_STAR_EQ] = ACTIONS(388),
    [anon_sym_SLASH_EQ] = ACTIONS(388),
    [anon_sym_DQUOTE] = ACTIONS(388),
    [sym__identifier] = ACTIONS(390),
    [anon_sym_linear] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(390),
    [anon_sym_ease] = ACTIONS(390),
    [anon_sym_ease_DASHin] = ACTIONS(390),
    [anon_sym_ease_DASHout] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(390),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(390),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(390),
    [anon_sym_cubic_DASHbezier] = ACTIONS(390),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(388),
    [anon_sym_ATlinear_gradient] = ACTIONS(388),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(388),
    [anon_sym_ATradial_gradient] = ACTIONS(388),
    [anon_sym_parent] = ACTIONS(390),
    [anon_sym_root] = ACTIONS(390),
    [anon_sym_self] = ACTIONS(390),
    [sym__int_number] = ACTIONS(390),
    [sym__float_number] = ACTIONS(388),
    [anon_sym_true] = ACTIONS(390),
    [anon_sym_false] = ACTIONS(390),
    [sym_color_value] = ACTIONS(388),
    [sym_comment] = ACTIONS(3),
  },
  [156] = {
    [sym_add_prec_operator] = STATE(137),
    [sym_mult_prec_operator] = STATE(138),
    [sym_comparison_operator] = STATE(139),
    [anon_sym_LBRACE] = ACTIONS(394),
    [anon_sym_RBRACE] = ACTIONS(394),
    [anon_sym_SEMI] = ACTIONS(394),
    [anon_sym_LT] = ACTIONS(396),
    [anon_sym_GT] = ACTIONS(396),
    [anon_sym_return] = ACTIONS(396),
    [anon_sym_COLON] = ACTIONS(394),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(396),
    [anon_sym_LPAREN] = ACTIONS(394),
    [anon_sym_ATtr] = ACTIONS(394),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(394),
    [sym_logical_or] = ACTIONS(394),
    [anon_sym_QMARK] = ACTIONS(394),
    [anon_sym_ATimage_DASHurl] = ACTIONS(394),
    [anon_sym_BANG] = ACTIONS(396),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(394),
    [anon_sym_LT_EQ] = ACTIONS(394),
    [anon_sym_EQ_EQ] = ACTIONS(394),
    [anon_sym_BANG_EQ] = ACTIONS(394),
    [anon_sym_EQ] = ACTIONS(396),
    [anon_sym_PLUS_EQ] = ACTIONS(394),
    [anon_sym_DASH_EQ] = ACTIONS(394),
    [anon_sym_STAR_EQ] = ACTIONS(394),
    [anon_sym_SLASH_EQ] = ACTIONS(394),
    [anon_sym_DQUOTE] = ACTIONS(394),
    [sym__identifier] = ACTIONS(396),
    [anon_sym_linear] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(396),
    [anon_sym_ease] = ACTIONS(396),
    [anon_sym_ease_DASHin] = ACTIONS(396),
    [anon_sym_ease_DASHout] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(396),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(396),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(396),
    [anon_sym_cubic_DASHbezier] = ACTIONS(396),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(394),
    [anon_sym_ATlinear_gradient] = ACTIONS(394),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(394),
    [anon_sym_ATradial_gradient] = ACTIONS(394),
    [anon_sym_parent] = ACTIONS(396),
    [anon_sym_root] = ACTIONS(396),
    [anon_sym_self] = ACTIONS(396),
    [sym__int_number] = ACTIONS(396),
    [sym__float_number] = ACTIONS(394),
    [anon_sym_true] = ACTIONS(396),
    [anon_sym_false] = ACTIONS(396),
    [sym_color_value] = ACTIONS(394),
    [sym_comment] = ACTIONS(3),
  },
  [157] = {
    [sym_add_prec_operator] = STATE(137),
    [sym_mult_prec_operator] = STATE(138),
    [sym_comparison_operator] = STATE(139),
    [anon_sym_LBRACE] = ACTIONS(398),
    [anon_sym_RBRACE] = ACTIONS(398),
    [anon_sym_SEMI] = ACTIONS(398),
    [anon_sym_LT] = ACTIONS(400),
    [anon_sym_GT] = ACTIONS(400),
    [anon_sym_return] = ACTIONS(400),
    [anon_sym_COLON] = ACTIONS(398),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(400),
    [anon_sym_LPAREN] = ACTIONS(398),
    [anon_sym_ATtr] = ACTIONS(398),
    [anon_sym_DOT] = ACTIONS(400),
    [sym_logical_and] = ACTIONS(398),
    [sym_logical_or] = ACTIONS(398),
    [anon_sym_QMARK] = ACTIONS(398),
    [anon_sym_ATimage_DASHurl] = ACTIONS(398),
    [anon_sym_BANG] = ACTIONS(400),
    [anon_sym_DASH] = ACTIONS(400),
    [anon_sym_PLUS] = ACTIONS(400),
    [anon_sym_STAR] = ACTIONS(400),
    [anon_sym_SLASH] = ACTIONS(400),
    [anon_sym_GT_EQ] = ACTIONS(398),
    [anon_sym_LT_EQ] = ACTIONS(398),
    [anon_sym_EQ_EQ] = ACTIONS(398),
    [anon_sym_BANG_EQ] = ACTIONS(398),
    [anon_sym_EQ] = ACTIONS(400),
    [anon_sym_PLUS_EQ] = ACTIONS(398),
    [anon_sym_DASH_EQ] = ACTIONS(398),
    [anon_sym_STAR_EQ] = ACTIONS(398),
    [anon_sym_SLASH_EQ] = ACTIONS(398),
    [anon_sym_DQUOTE] = ACTIONS(398),
    [sym__identifier] = ACTIONS(400),
    [anon_sym_linear] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(400),
    [anon_sym_ease] = ACTIONS(400),
    [anon_sym_ease_DASHin] = ACTIONS(400),
    [anon_sym_ease_DASHout] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(400),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(400),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(400),
    [anon_sym_cubic_DASHbezier] = ACTIONS(400),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(398),
    [anon_sym_ATlinear_gradient] = ACTIONS(398),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(398),
    [anon_sym_ATradial_gradient] = ACTIONS(398),
    [anon_sym_parent] = ACTIONS(400),
    [anon_sym_root] = ACTIONS(400),
    [anon_sym_self] = ACTIONS(400),
    [sym__int_number] = ACTIONS(400),
    [sym__float_number] = ACTIONS(398),
    [anon_sym_true] = ACTIONS(400),
    [anon_sym_false] = ACTIONS(400),
    [sym_color_value] = ACTIONS(398),
    [sym_comment] = ACTIONS(3),
  },
  [158] = {
    [sym_add_prec_operator] = STATE(137),
    [sym_mult_prec_operator] = STATE(138),
    [sym_comparison_operator] = STATE(139),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_RBRACE] = ACTIONS(402),
    [anon_sym_SEMI] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(404),
    [anon_sym_COLON] = ACTIONS(402),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(404),
    [anon_sym_LPAREN] = ACTIONS(402),
    [anon_sym_ATtr] = ACTIONS(402),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(402),
    [sym_logical_or] = ACTIONS(402),
    [anon_sym_QMARK] = ACTIONS(402),
    [anon_sym_ATimage_DASHurl] = ACTIONS(402),
    [anon_sym_BANG] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(372),
    [anon_sym_LT_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_EQ] = ACTIONS(404),
    [anon_sym_PLUS_EQ] = ACTIONS(402),
    [anon_sym_DASH_EQ] = ACTIONS(402),
    [anon_sym_STAR_EQ] = ACTIONS(402),
    [anon_sym_SLASH_EQ] = ACTIONS(402),
    [anon_sym_DQUOTE] = ACTIONS(402),
    [sym__identifier] = ACTIONS(404),
    [anon_sym_linear] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(404),
    [anon_sym_ease] = ACTIONS(404),
    [anon_sym_ease_DASHin] = ACTIONS(404),
    [anon_sym_ease_DASHout] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(404),
    [anon_sym_cubic_DASHbezier] = ACTIONS(404),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(402),
    [anon_sym_ATlinear_gradient] = ACTIONS(402),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(402),
    [anon_sym_ATradial_gradient] = ACTIONS(402),
    [anon_sym_parent] = ACTIONS(404),
    [anon_sym_root] = ACTIONS(404),
    [anon_sym_self] = ACTIONS(404),
    [sym__int_number] = ACTIONS(404),
    [sym__float_number] = ACTIONS(402),
    [anon_sym_true] = ACTIONS(404),
    [anon_sym_false] = ACTIONS(404),
    [sym_color_value] = ACTIONS(402),
    [sym_comment] = ACTIONS(3),
  },
  [159] = {
    [anon_sym_LBRACE] = ACTIONS(406),
    [anon_sym_COMMA] = ACTIONS(406),
    [anon_sym_RBRACE] = ACTIONS(406),
    [anon_sym_SEMI] = ACTIONS(406),
    [anon_sym_LT] = ACTIONS(408),
    [anon_sym_GT] = ACTIONS(408),
    [anon_sym_return] = ACTIONS(408),
    [anon_sym_COLON] = ACTIONS(406),
    [anon_sym_LBRACK] = ACTIONS(406),
    [anon_sym_if] = ACTIONS(408),
    [anon_sym_LPAREN] = ACTIONS(406),
    [anon_sym_RPAREN] = ACTIONS(406),
    [anon_sym_ATtr] = ACTIONS(406),
    [anon_sym_EQ_GT] = ACTIONS(406),
    [anon_sym_DOT] = ACTIONS(408),
    [sym_logical_and] = ACTIONS(406),
    [sym_logical_or] = ACTIONS(406),
    [anon_sym_QMARK] = ACTIONS(406),
    [anon_sym_ATimage_DASHurl] = ACTIONS(406),
    [anon_sym_BANG] = ACTIONS(408),
    [anon_sym_DASH] = ACTIONS(408),
    [anon_sym_PLUS] = ACTIONS(408),
    [anon_sym_STAR] = ACTIONS(408),
    [anon_sym_SLASH] = ACTIONS(408),
    [anon_sym_GT_EQ] = ACTIONS(406),
    [anon_sym_LT_EQ] = ACTIONS(406),
    [anon_sym_EQ_EQ] = ACTIONS(406),
    [anon_sym_BANG_EQ] = ACTIONS(406),
    [anon_sym_EQ] = ACTIONS(408),
    [anon_sym_PLUS_EQ] = ACTIONS(406),
    [anon_sym_DASH_EQ] = ACTIONS(406),
    [anon_sym_STAR_EQ] = ACTIONS(406),
    [anon_sym_SLASH_EQ] = ACTIONS(406),
    [anon_sym_DQUOTE] = ACTIONS(406),
    [sym__identifier] = ACTIONS(408),
    [anon_sym_linear] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(408),
    [anon_sym_ease] = ACTIONS(408),
    [anon_sym_ease_DASHin] = ACTIONS(408),
    [anon_sym_ease_DASHout] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(408),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(408),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(408),
    [anon_sym_cubic_DASHbezier] = ACTIONS(408),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(406),
    [anon_sym_ATlinear_gradient] = ACTIONS(406),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(406),
    [anon_sym_ATradial_gradient] = ACTIONS(406),
    [anon_sym_parent] = ACTIONS(408),
    [anon_sym_root] = ACTIONS(408),
    [anon_sym_self] = ACTIONS(408),
    [sym__int_number] = ACTIONS(408),
    [sym__float_number] = ACTIONS(406),
    [anon_sym_true] = ACTIONS(408),
    [anon_sym_false] = ACTIONS(408),
    [sym_color_value] = ACTIONS(406),
    [sym_comment] = ACTIONS(3),
  },
  [160] = {
    [anon_sym_LBRACE] = ACTIONS(410),
    [anon_sym_COMMA] = ACTIONS(410),
    [anon_sym_RBRACE] = ACTIONS(410),
    [anon_sym_SEMI] = ACTIONS(410),
    [anon_sym_LT] = ACTIONS(412),
    [anon_sym_GT] = ACTIONS(412),
    [anon_sym_return] = ACTIONS(412),
    [anon_sym_COLON] = ACTIONS(410),
    [anon_sym_LBRACK] = ACTIONS(410),
    [anon_sym_if] = ACTIONS(412),
    [anon_sym_LPAREN] = ACTIONS(410),
    [anon_sym_RPAREN] = ACTIONS(410),
    [anon_sym_ATtr] = ACTIONS(410),
    [anon_sym_EQ_GT] = ACTIONS(410),
    [anon_sym_DOT] = ACTIONS(412),
    [sym_logical_and] = ACTIONS(410),
    [sym_logical_or] = ACTIONS(410),
    [anon_sym_QMARK] = ACTIONS(410),
    [anon_sym_ATimage_DASHurl] = ACTIONS(410),
    [anon_sym_BANG] = ACTIONS(412),
    [anon_sym_DASH] = ACTIONS(412),
    [anon_sym_PLUS] = ACTIONS(412),
    [anon_sym_STAR] = ACTIONS(412),
    [anon_sym_SLASH] = ACTIONS(412),
    [anon_sym_GT_EQ] = ACTIONS(410),
    [anon_sym_LT_EQ] = ACTIONS(410),
    [anon_sym_EQ_EQ] = ACTIONS(410),
    [anon_sym_BANG_EQ] = ACTIONS(410),
    [anon_sym_EQ] = ACTIONS(412),
    [anon_sym_PLUS_EQ] = ACTIONS(410),
    [anon_sym_DASH_EQ] = ACTIONS(410),
    [anon_sym_STAR_EQ] = ACTIONS(410),
    [anon_sym_SLASH_EQ] = ACTIONS(410),
    [anon_sym_DQUOTE] = ACTIONS(410),
    [sym__identifier] = ACTIONS(412),
    [anon_sym_linear] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(412),
    [anon_sym_ease] = ACTIONS(412),
    [anon_sym_ease_DASHin] = ACTIONS(412),
    [anon_sym_ease_DASHout] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(412),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(412),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(412),
    [anon_sym_cubic_DASHbezier] = ACTIONS(412),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(410),
    [anon_sym_ATlinear_gradient] = ACTIONS(410),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(410),
    [anon_sym_ATradial_gradient] = ACTIONS(410),
    [anon_sym_parent] = ACTIONS(412),
    [anon_sym_root] = ACTIONS(412),
    [anon_sym_self] = ACTIONS(412),
    [sym__int_number] = ACTIONS(412),
    [sym__float_number] = ACTIONS(410),
    [anon_sym_true] = ACTIONS(412),
    [anon_sym_false] = ACTIONS(412),
    [sym_color_value] = ACTIONS(410),
    [sym_comment] = ACTIONS(3),
  },
  [161] = {
    [anon_sym_LBRACE] = ACTIONS(414),
    [anon_sym_COMMA] = ACTIONS(414),
    [anon_sym_RBRACE] = ACTIONS(414),
    [anon_sym_SEMI] = ACTIONS(414),
    [anon_sym_LT] = ACTIONS(416),
    [anon_sym_GT] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_COLON] = ACTIONS(414),
    [anon_sym_LBRACK] = ACTIONS(414),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_LPAREN] = ACTIONS(414),
    [anon_sym_RPAREN] = ACTIONS(414),
    [anon_sym_ATtr] = ACTIONS(414),
    [anon_sym_EQ_GT] = ACTIONS(414),
    [anon_sym_DOT] = ACTIONS(416),
    [sym_logical_and] = ACTIONS(414),
    [sym_logical_or] = ACTIONS(414),
    [anon_sym_QMARK] = ACTIONS(414),
    [anon_sym_ATimage_DASHurl] = ACTIONS(414),
    [anon_sym_BANG] = ACTIONS(416),
    [anon_sym_DASH] = ACTIONS(416),
    [anon_sym_PLUS] = ACTIONS(416),
    [anon_sym_STAR] = ACTIONS(416),
    [anon_sym_SLASH] = ACTIONS(416),
    [anon_sym_GT_EQ] = ACTIONS(414),
    [anon_sym_LT_EQ] = ACTIONS(414),
    [anon_sym_EQ_EQ] = ACTIONS(414),
    [anon_sym_BANG_EQ] = ACTIONS(414),
    [anon_sym_EQ] = ACTIONS(416),
    [anon_sym_PLUS_EQ] = ACTIONS(414),
    [anon_sym_DASH_EQ] = ACTIONS(414),
    [anon_sym_STAR_EQ] = ACTIONS(414),
    [anon_sym_SLASH_EQ] = ACTIONS(414),
    [anon_sym_DQUOTE] = ACTIONS(414),
    [sym__identifier] = ACTIONS(416),
    [anon_sym_linear] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(416),
    [anon_sym_ease] = ACTIONS(416),
    [anon_sym_ease_DASHin] = ACTIONS(416),
    [anon_sym_ease_DASHout] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHcirc] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHcirc] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHelastic] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHelastic] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHelastic] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHbounce] = ACTIONS(416),
    [anon_sym_ease_DASHout_DASHbounce] = ACTIONS(416),
    [anon_sym_ease_DASHin_DASHout_DASHbounce] = ACTIONS(416),
    [anon_sym_cubic_DASHbezier] = ACTIONS(416),
    [anon_sym_ATlinear_DASHgradient] = ACTIONS(414),
    [anon_sym_ATlinear_gradient] = ACTIONS(414),
    [anon_sym_ATradial_DASHgradient] = ACTIONS(414),
    [anon_sym_ATradial_gradient] = ACTIONS(414),
    [anon_sym_parent] = ACTIONS(416),
    [anon_sym_root] = ACTIONS(416),
    [anon_sym_self] = ACTIONS(416),
    [sym__int_number] = ACTIONS(416),
    [sym__float_number] = ACTIONS(414),
    [anon_sym_true] = ACTIONS(416),
    [anon_sym_false] = ACTIONS(416),
    [sym_color_value] = ACTIONS(414),
    [sym_comment] = ACTIONS(3),
  },
  [162] = {
    [sym_add_prec_operator] = STATE(137),
    [sym_mult_prec_operator] = STATE(138),
    [sym_comparison_operator] = STATE(139),
    [anon_sym_LBRACE] = ACTIONS(402),
    [anon_sym_RBRACE] = ACTIONS(402),
    [anon_sym_SEMI] = ACTIONS(402),
    [anon_sym_LT] = ACTIONS(352),
    [anon_sym_GT] = ACTIONS(352),
    [anon_sym_return] = ACTIONS(404),
    [anon_sym_COLON] = ACTIONS(402),
    [anon_sym_LBRACK] = ACTIONS(358),
    [anon_sym_if] = ACTIONS(404),
    [anon_sym_LPAREN] = ACTIONS(402),
    [anon_sym_ATtr] = ACTIONS(402),
    [anon_sym_DOT] = ACTIONS(360),
    [sym_logical_and] = ACTIONS(362),
    [sym_logical_or] = ACTIONS(402),
    [anon_sym_QMARK] = ACTIONS(402),
    [anon_sym_ATimage_DASHurl] = ACTIONS(402),
    [anon_sym_BANG] = ACTIONS(404),
    [anon_sym_DASH] = ACTIONS(368),
    [anon_sym_PLUS] = ACTIONS(368),
    [anon_sym_STAR] = ACTIONS(370),
    [anon_sym_SLASH] = ACTIONS(370),
    [anon_sym_GT_EQ] = ACTIONS(372),
    [anon_sym_LT_EQ] = ACTIONS(372),
    [anon_sym_EQ_EQ] = ACTIONS(372),
    [anon_sym_BANG_EQ] = ACTIONS(372),
    [anon_sym_EQ] = ACTIONS(404),
    [anon_sym_PLUS_EQ] = ACTIONS(402),
    [anon_sym_DASH_EQ] = ACTIONS(402),
    [anon_sym_STAR_EQ] = ACTIONS(402),
    [anon_sym_SLASH_EQ] = ACTIONS(402),
    [anon_sym_DQUOTE] = ACTIONS(402),
    [sym__identifier] = ACTIONS(404),
    [anon_sym_linear] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquad] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquad] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquad] = ACTIONS(404),
    [anon_sym_ease] = ACTIONS(404),
    [anon_sym_ease_DASHin] = ACTIONS(404),
    [anon_sym_ease_DASHout] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquart] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHquint] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHexpo] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHsine] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHout_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHout_DASHback] = ACTIONS(404),
    [anon_sym_ease_DASHin_DASHcirc] = ACTIO