#include "main.h"
#include "sysdeps.h"
#include "hatari-glue.h"
#include "maccess.h"
#include "memory.h"
#include "custom.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#include "debugmem.h"
#include "cpummu030.h"
#define SET_ALWAYS_CFLG(x) SET_CFLG(x)
#define SET_ALWAYS_NFLG(x) SET_NFLG(x)
/* OR.B #<data>.B,Dn */
void REGPARAM2 op_0000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An) */
void REGPARAM2 op_0010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An)+ */
void REGPARAM2 op_0018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,-(An) */
void REGPARAM2 op_0020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,(d16,An) */
void REGPARAM2 op_0028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* OR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* OR.B #<data>.B,(xxx).W */
void REGPARAM2 op_0038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* OR.B #<data>.B,(xxx).L */
void REGPARAM2 op_0039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* ORSR.B #<data>.W */
void REGPARAM2 op_003c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	MakeSR();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,Dn */
void REGPARAM2 op_0040_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An) */
void REGPARAM2 op_0050_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An)+ */
void REGPARAM2 op_0058_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,-(An) */
void REGPARAM2 op_0060_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,(d16,An) */
void REGPARAM2 op_0068_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* OR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0070_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* OR.W #<data>.W,(xxx).W */
void REGPARAM2 op_0078_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* OR.W #<data>.W,(xxx).L */
void REGPARAM2 op_0079_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* ORSR.W #<data>.W */
void REGPARAM2 op_007c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if(regs.t0) check_t0_trace();
	regs.sr |= src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* OR.L #<data>.L,Dn */
void REGPARAM2 op_0080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An) */
void REGPARAM2 op_0090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An)+ */
void REGPARAM2 op_0098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,-(An) */
void REGPARAM2 op_00a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,(d16,An) */
void REGPARAM2 op_00a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* OR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_00b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 2,0   */

/* OR.L #<data>.L,(xxx).W */
void REGPARAM2 op_00b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* OR.L #<data>.L,(xxx).L */
void REGPARAM2 op_00b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 10 0,0   */

/* CHK2.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* CHK2.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 8 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s8)get_byte_mmu030c_state(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* BTST.L Dn,Dn */
void REGPARAM2 op_0100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPMR.W (d16,An),Dn */
void REGPARAM2 op_0108_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* OP zero */
	uae_u16 val  = (get_byte_mmu030c_state(mempa) & 0xff) << 8;
	val |= (get_byte_mmu030c_state(mempa + 2) & 0xff);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(An) */
void REGPARAM2 op_0110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BTST.B Dn,(An)+ */
void REGPARAM2 op_0118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BTST.B Dn,-(An) */
void REGPARAM2 op_0120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BTST.B Dn,(d16,An) */
void REGPARAM2 op_0128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,An,Xn) */
void REGPARAM2 op_0130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 2 2,0   */

/* BTST.B Dn,(xxx).W */
void REGPARAM2 op_0138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(xxx).L */
void REGPARAM2 op_0139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B Dn,(d16,PC) */
void REGPARAM2 op_013a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_getpci() + 2;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,PC,Xn) */
void REGPARAM2 op_013b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 2 2,0   */

/* BTST.B Dn,#<data>.B */
void REGPARAM2 op_013c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = (uae_u8)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.L Dn,Dn */
void REGPARAM2 op_0140_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPMR.L (d16,An),Dn */
void REGPARAM2 op_0148_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* OP zero */
	uae_u32 val  = (get_byte_mmu030c_state(mempa) & 0xff) << 24;
	val |= (get_byte_mmu030c_state(mempa + 2) & 0xff) << 16;
	val |= (get_byte_mmu030c_state(mempa + 4) & 0xff) << 8;
	val |= (get_byte_mmu030c_state(mempa + 6) & 0xff);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B Dn,(An) */
void REGPARAM2 op_0150_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 2 0,0   */

/* BCHG.B Dn,(An)+ */
void REGPARAM2 op_0158_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BCHG.B Dn,-(An) */
void REGPARAM2 op_0160_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BCHG.B Dn,(d16,An) */
void REGPARAM2 op_0168_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BCHG.B Dn,(d8,An,Xn) */
void REGPARAM2 op_0170_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 2 2,0   */

/* BCHG.B Dn,(xxx).W */
void REGPARAM2 op_0178_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BCHG.B Dn,(xxx).L */
void REGPARAM2 op_0179_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BCLR.L Dn,Dn */
void REGPARAM2 op_0180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPRM.W Dn,(d16,An) */
void REGPARAM2 op_0188_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	put_byte_mmu030c_state(mempa, src >> 8);
	put_byte_mmu030c_state(mempa + 2, src); 
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B Dn,(An) */
void REGPARAM2 op_0190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 2 0,0   */

/* BCLR.B Dn,(An)+ */
void REGPARAM2 op_0198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BCLR.B Dn,-(An) */
void REGPARAM2 op_01a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BCLR.B Dn,(d16,An) */
void REGPARAM2 op_01a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BCLR.B Dn,(d8,An,Xn) */
void REGPARAM2 op_01b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 2 2,0   */

/* BCLR.B Dn,(xxx).W */
void REGPARAM2 op_01b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BCLR.B Dn,(xxx).L */
void REGPARAM2 op_01b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BSET.L Dn,Dn */
void REGPARAM2 op_01c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPRM.L Dn,(d16,An) */
void REGPARAM2 op_01c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	put_byte_mmu030c_state(mempa, src >> 24);
	put_byte_mmu030c_state(mempa + 2, src >> 16);
	put_byte_mmu030c_state(mempa + 4, src >> 8);
	put_byte_mmu030c_state(mempa + 6, src); 
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B Dn,(An) */
void REGPARAM2 op_01d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 2 0,0   */

/* BSET.B Dn,(An)+ */
void REGPARAM2 op_01d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BSET.B Dn,-(An) */
void REGPARAM2 op_01e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* BSET.B Dn,(d16,An) */
void REGPARAM2 op_01e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BSET.B Dn,(d8,An,Xn) */
void REGPARAM2 op_01f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 2 2,0   */

/* BSET.B Dn,(xxx).W */
void REGPARAM2 op_01f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BSET.B Dn,(xxx).L */
void REGPARAM2 op_01f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* AND.B #<data>.B,Dn */
void REGPARAM2 op_0200_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An) */
void REGPARAM2 op_0210_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An)+ */
void REGPARAM2 op_0218_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,-(An) */
void REGPARAM2 op_0220_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,(d16,An) */
void REGPARAM2 op_0228_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* AND.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0230_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* AND.B #<data>.B,(xxx).W */
void REGPARAM2 op_0238_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* AND.B #<data>.B,(xxx).L */
void REGPARAM2 op_0239_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* ANDSR.B #<data>.W */
void REGPARAM2 op_023c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	MakeSR();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	src &= 0xFF;
	src |= 0xff00;
	regs.sr &= src;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,Dn */
void REGPARAM2 op_0240_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An) */
void REGPARAM2 op_0250_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An)+ */
void REGPARAM2 op_0258_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,-(An) */
void REGPARAM2 op_0260_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,(d16,An) */
void REGPARAM2 op_0268_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* AND.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0270_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* AND.W #<data>.W,(xxx).W */
void REGPARAM2 op_0278_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* AND.W #<data>.W,(xxx).L */
void REGPARAM2 op_0279_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* ANDSR.W #<data>.W */
void REGPARAM2 op_027c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if(regs.t0) check_t0_trace();
	regs.sr &= src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* AND.L #<data>.L,Dn */
void REGPARAM2 op_0280_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An) */
void REGPARAM2 op_0290_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An)+ */
void REGPARAM2 op_0298_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,-(An) */
void REGPARAM2 op_02a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,(d16,An) */
void REGPARAM2 op_02a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* AND.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_02b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 2,0   */

/* AND.L #<data>.L,(xxx).W */
void REGPARAM2 op_02b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* AND.L #<data>.L,(xxx).L */
void REGPARAM2 op_02b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 10 0,0   */

/* CHK2.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* CHK2.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 8 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta);
	upper = (uae_s32)(uae_s16)get_word_mmu030c_state(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* SUB.B #<data>.B,Dn */
void REGPARAM2 op_0400_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An) */
void REGPARAM2 op_0410_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An)+ */
void REGPARAM2 op_0418_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,-(An) */
void REGPARAM2 op_0420_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(d16,An) */
void REGPARAM2 op_0428_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0430_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 2,0   */

/* SUB.B #<data>.B,(xxx).W */
void REGPARAM2 op_0438_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(xxx).L */
void REGPARAM2 op_0439_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* SUB.W #<data>.W,Dn */
void REGPARAM2 op_0440_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An) */
void REGPARAM2 op_0450_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An)+ */
void REGPARAM2 op_0458_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,-(An) */
void REGPARAM2 op_0460_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(d16,An) */
void REGPARAM2 op_0468_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0470_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 2,0   */

/* SUB.W #<data>.W,(xxx).W */
void REGPARAM2 op_0478_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(xxx).L */
void REGPARAM2 op_0479_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* SUB.L #<data>.L,Dn */
void REGPARAM2 op_0480_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An) */
void REGPARAM2 op_0490_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An)+ */
void REGPARAM2 op_0498_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,-(An) */
void REGPARAM2 op_04a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(d16,An) */
void REGPARAM2 op_04a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_04b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 6 2,0   */

/* SUB.L #<data>.L,(xxx).W */
void REGPARAM2 op_04b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(xxx).L */
void REGPARAM2 op_04b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 10 0,0   */

/* CHK2.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu030c_state(dsta); upper = get_long_mmu030c_state(dsta + 4);
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu030c_state(dsta); upper = get_long_mmu030c_state(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu030c_state(dsta); upper = get_long_mmu030c_state(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* CHK2.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu030c_state(dsta); upper = get_long_mmu030c_state(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu030c_state(dsta); upper = get_long_mmu030c_state(dsta + 4);
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 8 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu030c_state(dsta); upper = get_long_mmu030c_state(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = get_long_mmu030c_state(dsta); upper = get_long_mmu030c_state(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* ADD.B #<data>.B,Dn */
void REGPARAM2 op_0600_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An) */
void REGPARAM2 op_0610_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An)+ */
void REGPARAM2 op_0618_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,-(An) */
void REGPARAM2 op_0620_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(d16,An) */
void REGPARAM2 op_0628_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0630_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 2,0   */

/* ADD.B #<data>.B,(xxx).W */
void REGPARAM2 op_0638_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(xxx).L */
void REGPARAM2 op_0639_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* ADD.W #<data>.W,Dn */
void REGPARAM2 op_0640_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An) */
void REGPARAM2 op_0650_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An)+ */
void REGPARAM2 op_0658_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,-(An) */
void REGPARAM2 op_0660_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(d16,An) */
void REGPARAM2 op_0668_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0670_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 2,0   */

/* ADD.W #<data>.W,(xxx).W */
void REGPARAM2 op_0678_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(xxx).L */
void REGPARAM2 op_0679_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* ADD.L #<data>.L,Dn */
void REGPARAM2 op_0680_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An) */
void REGPARAM2 op_0690_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An)+ */
void REGPARAM2 op_0698_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,-(An) */
void REGPARAM2 op_06a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(d16,An) */
void REGPARAM2 op_06a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_06b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 6 2,0   */

/* ADD.L #<data>.L,(xxx).W */
void REGPARAM2 op_06b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(xxx).L */
void REGPARAM2 op_06b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 10 0,0   */

/* RTM.L Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* RTM.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* BTST.L #<data>.W,Dn */
void REGPARAM2 op_0800_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* No EA */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An) */
void REGPARAM2 op_0810_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An)+ */
void REGPARAM2 op_0818_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,-(An) */
void REGPARAM2 op_0820_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(d16,An) */
void REGPARAM2 op_0828_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0830_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 4 2,0   */

/* BTST.B #<data>.W,(xxx).W */
void REGPARAM2 op_0838_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(xxx).L */
void REGPARAM2 op_0839_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* BTST.B #<data>.W,(d16,PC) */
void REGPARAM2 op_083a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 op_083b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 4 2,0   */

/* BCHG.L #<data>.W,Dn */
void REGPARAM2 op_0840_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* No EA */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An) */
void REGPARAM2 op_0850_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An)+ */
void REGPARAM2 op_0858_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,-(An) */
void REGPARAM2 op_0860_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(d16,An) */
void REGPARAM2 op_0868_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0870_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 2,0   */

/* BCHG.B #<data>.W,(xxx).W */
void REGPARAM2 op_0878_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(xxx).L */
void REGPARAM2 op_0879_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 8 0,0   */

/* BCLR.L #<data>.W,Dn */
void REGPARAM2 op_0880_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* No EA */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An) */
void REGPARAM2 op_0890_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An)+ */
void REGPARAM2 op_0898_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,-(An) */
void REGPARAM2 op_08a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(d16,An) */
void REGPARAM2 op_08a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_08b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 2,0   */

/* BCLR.B #<data>.W,(xxx).W */
void REGPARAM2 op_08b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(xxx).L */
void REGPARAM2 op_08b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 8 0,0   */

/* BSET.L #<data>.W,Dn */
void REGPARAM2 op_08c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* No EA */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An) */
void REGPARAM2 op_08d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An)+ */
void REGPARAM2 op_08d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,-(An) */
void REGPARAM2 op_08e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(d16,An) */
void REGPARAM2 op_08e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_08f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 4 2,0   */

/* BSET.B #<data>.W,(xxx).W */
void REGPARAM2 op_08f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(xxx).L */
void REGPARAM2 op_08f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, dst);
	return;
}
/* 8 0,0   */

/* EOR.B #<data>.B,Dn */
void REGPARAM2 op_0a00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An) */
void REGPARAM2 op_0a10_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An)+ */
void REGPARAM2 op_0a18_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,-(An) */
void REGPARAM2 op_0a20_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(d16,An) */
void REGPARAM2 op_0a28_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0a30_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* EOR.B #<data>.B,(xxx).W */
void REGPARAM2 op_0a38_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(xxx).L */
void REGPARAM2 op_0a39_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* EORSR.B #<data>.W */
void REGPARAM2 op_0a3c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	MakeSR();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,Dn */
void REGPARAM2 op_0a40_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An) */
void REGPARAM2 op_0a50_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An)+ */
void REGPARAM2 op_0a58_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,-(An) */
void REGPARAM2 op_0a60_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(d16,An) */
void REGPARAM2 op_0a68_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0a70_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* EOR.W #<data>.W,(xxx).W */
void REGPARAM2 op_0a78_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(xxx).L */
void REGPARAM2 op_0a79_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* EORSR.W #<data>.W */
void REGPARAM2 op_0a7c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if(regs.t0) check_t0_trace();
	regs.sr ^= src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* EOR.L #<data>.L,Dn */
void REGPARAM2 op_0a80_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An) */
void REGPARAM2 op_0a90_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An)+ */
void REGPARAM2 op_0a98_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,-(An) */
void REGPARAM2 op_0aa0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(d16,An) */
void REGPARAM2 op_0aa8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_0ab0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 2,0   */

/* EOR.L #<data>.L,(xxx).W */
void REGPARAM2 op_0ab8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(xxx).L */
void REGPARAM2 op_0ab9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 10 0,0   */

/* CAS.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ad0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_lrmw_byte_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ad8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_lrmw_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ae0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_lrmw_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ae8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_lrmw_byte_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(6);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0af0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_lrmw_byte_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(0);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	return;
}
/* 4 2,0   */

#endif
/* CAS.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0af8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_lrmw_byte_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(6);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0af9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_lrmw_byte_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_byte_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(8);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CMP.B #<data>.B,Dn */
void REGPARAM2 op_0c00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An) */
void REGPARAM2 op_0c10_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An)+ */
void REGPARAM2 op_0c18_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,-(An) */
void REGPARAM2 op_0c20_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(d16,An) */
void REGPARAM2 op_0c28_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0c30_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

/* CMP.B #<data>.B,(xxx).W */
void REGPARAM2 op_0c38_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(xxx).L */
void REGPARAM2 op_0c39_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.B #<data>.B,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c3a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CMP.B #<data>.B,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c3b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

#endif
/* CMP.W #<data>.W,Dn */
void REGPARAM2 op_0c40_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An) */
void REGPARAM2 op_0c50_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An)+ */
void REGPARAM2 op_0c58_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,-(An) */
void REGPARAM2 op_0c60_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(d16,An) */
void REGPARAM2 op_0c68_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0c70_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

/* CMP.W #<data>.W,(xxx).W */
void REGPARAM2 op_0c78_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(xxx).L */
void REGPARAM2 op_0c79_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c7a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CMP.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c7b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

#endif
/* CMP.L #<data>.L,Dn */
void REGPARAM2 op_0c80_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An) */
void REGPARAM2 op_0c90_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An)+ */
void REGPARAM2 op_0c98_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,-(An) */
void REGPARAM2 op_0ca0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(d16,An) */
void REGPARAM2 op_0ca8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_0cb0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 6 2,0   */

/* CMP.L #<data>.L,(xxx).W */
void REGPARAM2 op_0cb8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(xxx).L */
void REGPARAM2 op_0cb9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* CMP.L #<data>.L,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 6;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CMP.L #<data>.L,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cbb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 6 2,0   */

#endif
/* CAS.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cd0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = get_lrmw_word_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cd8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_lrmw_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ce0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_lrmw_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ce8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_lrmw_word_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(6);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cf0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = get_lrmw_word_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(0);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	return;
}
/* 4 2,0   */

#endif
/* CAS.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cf8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s16 dst = get_lrmw_word_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(6);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cf9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s16 dst = get_lrmw_word_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_word_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(8);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CAS2.W #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cfc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	uae_s32 extra;
	extra = get_ilong_mmu030c_state(2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u16 dst1 = get_lrmw_word_mmu030c_state(rn1), dst2 = get_lrmw_word_mmu030c_state(rn2);
	uae_u32 newv = ((uae_u16)(dst1)) - ((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s16)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s16)(dst1)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u16)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u16)(dst2)) - ((uae_u16)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s16)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s16)(dst2)) < 0;
		int flgn = ((uae_s16)(newv)) < 0;
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u16)(m68k_dreg(regs, extra & 7))) > ((uae_u16)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			put_lrmw_word_mmu030c_state(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			put_lrmw_word_mmu030c_state(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 0) & 7) = (m68k_dreg(regs, (extra >> 0) & 7) & ~0xffff) | (dst2 & 0xffff);
		m68k_dreg(regs, (extra >> 16) & 7) = (m68k_dreg(regs, (extra >> 16) & 7) & ~0xffff) | (dst1 & 0xffff);
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e10_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_byte(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc030c_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e18_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		mmufixup[0].reg = dstreg | 0x100;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		src = regs.regs[(extra >> 12) & 15];
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_byte(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		mmufixup[1].reg = dstreg | 0x100;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s8 src = sfc030c_get_byte(srca);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e20_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		mmufixup[0].reg = dstreg | 0x200;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) = dsta;
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		src = regs.regs[(extra >> 12) & 15];
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_byte(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		mmufixup[1].reg = dstreg | 0x200;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s8 src = sfc030c_get_byte(srca);
		m68k_areg(regs, dstreg) = srca;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e28_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_byte(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		uae_s8 src = sfc030c_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e30_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(0);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_byte(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
		uae_s8 src = sfc030c_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 2,2   */

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e38_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_byte(dsta, src);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		uae_s8 src = sfc030c_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e39_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_ilong_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_incpci(8);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_byte(dsta, src);
	} else {
		uaecptr srca;
		srca = get_ilong_mmu030c_state(4);
		uae_s8 src = sfc030c_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(8);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 8 0,0   */

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e50_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_word(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s16 src = sfc030c_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e58_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		mmufixup[0].reg = dstreg | 0x500;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 2;
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		src = regs.regs[(extra >> 12) & 15];
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_word(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		mmufixup[1].reg = dstreg | 0x500;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s16 src = sfc030c_get_word(srca);
		m68k_areg(regs, dstreg) += 2;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e60_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 2;
		mmufixup[0].reg = dstreg | 0x600;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) = dsta;
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		src = regs.regs[(extra >> 12) & 15];
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_word(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 2;
		mmufixup[1].reg = dstreg | 0x600;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s16 src = sfc030c_get_word(srca);
		m68k_areg(regs, dstreg) = srca;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e68_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_word(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		uae_s16 src = sfc030c_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e70_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(0);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_word(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
		uae_s16 src = sfc030c_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 2,2   */

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e78_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_word(dsta, src);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		uae_s16 src = sfc030c_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e79_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_ilong_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_incpci(8);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_word(dsta, src);
	} else {
		uaecptr srca;
		srca = get_ilong_mmu030c_state(4);
		uae_s16 src = sfc030c_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(8);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 8 0,0   */

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e90_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_long(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s32 src = sfc030c_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e98_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		mmufixup[0].reg = dstreg | 0x900;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 4;
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		src = regs.regs[(extra >> 12) & 15];
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_long(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		mmufixup[1].reg = dstreg | 0x900;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s32 src = sfc030c_get_long(srca);
		m68k_areg(regs, dstreg) += 4;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ea0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 4;
		mmufixup[0].reg = dstreg | 0xa00;
		mmufixup[0].value = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) = dsta;
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(4);
		src = regs.regs[(extra >> 12) & 15];
		m68k_incpci(4);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_long(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 4;
		mmufixup[1].reg = dstreg | 0xa00;
		mmufixup[1].value = m68k_areg(regs, dstreg);
		uae_s32 src = sfc030c_get_long(srca);
		m68k_areg(regs, dstreg) = srca;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ea8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_long(dsta, src);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		uae_s32 src = sfc030c_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(0);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_long(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
		uae_s32 src = sfc030c_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 2,2   */

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_long(dsta, src);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
		uae_s32 src = sfc030c_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_ilong_mmu030c_state(4);
		/* OP zero */
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_incpci(8);
		regs.instruction_pc = m68k_getpci();
		mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
		dfc030c_put_long(dsta, src);
	} else {
		uaecptr srca;
		srca = get_ilong_mmu030c_state(4);
		uae_s32 src = sfc030c_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(8);
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 8 0,0   */

#endif
/* CAS.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ed0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_lrmw_long_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ed8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_lrmw_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ee0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_lrmw_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(4);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ee8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_lrmw_long_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(6);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ef0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_lrmw_long_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(0);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(0);
		m68k_dreg(regs, rc) = dst;
	}
	return;
}
/* 4 2,0   */

#endif
/* CAS.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ef8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_lrmw_long_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(6);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ef9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s32 dst = get_lrmw_long_mmu030c_state(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		put_lrmw_long_mmu030c_state(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_iword_mmu030c_opcode_state(8);
	} else {
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CAS2.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0efc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	uae_s32 extra;
	extra = get_ilong_mmu030c_state(2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u32 dst1 = get_lrmw_long_mmu030c_state(rn1), dst2 = get_lrmw_long_mmu030c_state(rn2);
	uae_u32 newv = ((uae_u32)(dst1)) - ((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s32)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s32)(dst1)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u32)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u32)(dst2)) - ((uae_u32)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s32)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s32)(dst2)) < 0;
		int flgn = ((uae_s32)(newv)) < 0;
		SET_ZFLG(((uae_s32)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u32)(m68k_dreg(regs, extra & 7))) > ((uae_u32)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			put_lrmw_long_mmu030c_state(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			put_lrmw_long_mmu030c_state(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 0) & 7) = dst2;
		m68k_dreg(regs, (extra >> 16) & 7) = dst1;
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* MOVE.B Dn,Dn */
void REGPARAM2 op_1000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An),Dn */
void REGPARAM2 op_1010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,Dn */
void REGPARAM2 op_1018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),Dn */
void REGPARAM2 op_1020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),Dn */
void REGPARAM2 op_1028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),Dn */
void REGPARAM2 op_1030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,Dn */
void REGPARAM2 op_1038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,Dn */
void REGPARAM2 op_1039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),Dn */
void REGPARAM2 op_103a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),Dn */
void REGPARAM2 op_103b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,Dn */
void REGPARAM2 op_103c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,(An) */
void REGPARAM2 op_1080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.B (An),(An) */
void REGPARAM2 op_1090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An) */
void REGPARAM2 op_1098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),(An) */
void REGPARAM2 op_10a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An) */
void REGPARAM2 op_10a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An) */
void REGPARAM2 op_10b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An) */
void REGPARAM2 op_10b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An) */
void REGPARAM2 op_10b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An) */
void REGPARAM2 op_10ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An) */
void REGPARAM2 op_10bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An) */
void REGPARAM2 op_10bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,(An)+ */
void REGPARAM2 op_10c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (An),(An)+ */
void REGPARAM2 op_10d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An)+ */
void REGPARAM2 op_10d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x100;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),(An)+ */
void REGPARAM2 op_10e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x100;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An)+ */
void REGPARAM2 op_10e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An)+ */
void REGPARAM2 op_10f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An)+ */
void REGPARAM2 op_10f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An)+ */
void REGPARAM2 op_10f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An)+ */
void REGPARAM2 op_10fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An)+ */
void REGPARAM2 op_10fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An)+ */
void REGPARAM2 op_10fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,-(An) */
void REGPARAM2 op_1100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (An),-(An) */
void REGPARAM2 op_1110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,-(An) */
void REGPARAM2 op_1118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x200;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),-(An) */
void REGPARAM2 op_1120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x200;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),-(An) */
void REGPARAM2 op_1128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),-(An) */
void REGPARAM2 op_1130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,-(An) */
void REGPARAM2 op_1138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,-(An) */
void REGPARAM2 op_1139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),-(An) */
void REGPARAM2 op_113a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),-(An) */
void REGPARAM2 op_113b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,-(An) */
void REGPARAM2 op_113c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,(d16,An) */
void REGPARAM2 op_1140_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B (An),(d16,An) */
void REGPARAM2 op_1150_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B (An)+,(d16,An) */
void REGPARAM2 op_1158_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B -(An),(d16,An) */
void REGPARAM2 op_1160_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(d16,An) */
void REGPARAM2 op_1168_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(d16,An) */
void REGPARAM2 op_1170_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(d16,An) */
void REGPARAM2 op_1178_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(d16,An) */
void REGPARAM2 op_1179_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(d16,An) */
void REGPARAM2 op_117a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_117b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(d16,An) */
void REGPARAM2 op_117c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B Dn,(d8,An,Xn) */
void REGPARAM2 op_1180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (An),(d8,An,Xn) */
void REGPARAM2 op_1190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (An)+,(d8,An,Xn) */
void REGPARAM2 op_1198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.B -(An),(d8,An,Xn) */
void REGPARAM2 op_11a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.B (d16,An),(d8,An,Xn) */
void REGPARAM2 op_11a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_11b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.B (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_11b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_11b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.B (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_11ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_11bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_11bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B Dn,(xxx).W */
void REGPARAM2 op_11c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B (An),(xxx).W */
void REGPARAM2 op_11d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.B (An)+,(xxx).W */
void REGPARAM2 op_11d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B -(An),(xxx).W */
void REGPARAM2 op_11e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(xxx).W */
void REGPARAM2 op_11e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).W */
void REGPARAM2 op_11f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(xxx).W */
void REGPARAM2 op_11f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(xxx).W */
void REGPARAM2 op_11f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(xxx).W */
void REGPARAM2 op_11fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_11fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(xxx).W */
void REGPARAM2 op_11fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B Dn,(xxx).L */
void REGPARAM2 op_13c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (An),(xxx).L */
void REGPARAM2 op_13d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.B (An)+,(xxx).L */
void REGPARAM2 op_13d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.B -(An),(xxx).L */
void REGPARAM2 op_13e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,An),(xxx).L */
void REGPARAM2 op_13e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).L */
void REGPARAM2 op_13f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 6,0   */

/* MOVE.B (xxx).W,(xxx).L */
void REGPARAM2 op_13f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.B (xxx).L,(xxx).L */
void REGPARAM2 op_13f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 10 0,0   */

/* MOVE.B (d16,PC),(xxx).L */
void REGPARAM2 op_13fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_13fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 6,0   */

/* MOVE.B #<data>.B,(xxx).L */
void REGPARAM2 op_13fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L Dn,Dn */
void REGPARAM2 op_2000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L An,Dn */
void REGPARAM2 op_2008_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An),Dn */
void REGPARAM2 op_2010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,Dn */
void REGPARAM2 op_2018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),Dn */
void REGPARAM2 op_2020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),Dn */
void REGPARAM2 op_2028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),Dn */
void REGPARAM2 op_2030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,Dn */
void REGPARAM2 op_2038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,Dn */
void REGPARAM2 op_2039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),Dn */
void REGPARAM2 op_203a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),Dn */
void REGPARAM2 op_203b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,Dn */
void REGPARAM2 op_203c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVEA.L Dn,An */
void REGPARAM2 op_2040_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L An,An */
void REGPARAM2 op_2048_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s32 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L (An),An */
void REGPARAM2 op_2050_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L (An)+,An */
void REGPARAM2 op_2058_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVEA.L -(An),An */
void REGPARAM2 op_2060_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVEA.L (d16,An),An */
void REGPARAM2 op_2068_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.L (d8,An,Xn),An */
void REGPARAM2 op_2070_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVEA.L (xxx).W,An */
void REGPARAM2 op_2078_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.L (xxx).L,An */
void REGPARAM2 op_2079_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVEA.L (d16,PC),An */
void REGPARAM2 op_207a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.L (d8,PC,Xn),An */
void REGPARAM2 op_207b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVEA.L #<data>.L,An */
void REGPARAM2 op_207c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,(An) */
void REGPARAM2 op_2080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.L An,(An) */
void REGPARAM2 op_2088_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.L (An),(An) */
void REGPARAM2 op_2090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An) */
void REGPARAM2 op_2098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),(An) */
void REGPARAM2 op_20a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An) */
void REGPARAM2 op_20a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An) */
void REGPARAM2 op_20b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An) */
void REGPARAM2 op_20b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An) */
void REGPARAM2 op_20b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An) */
void REGPARAM2 op_20ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An) */
void REGPARAM2 op_20bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An) */
void REGPARAM2 op_20bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,(An)+ */
void REGPARAM2 op_20c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L An,(An)+ */
void REGPARAM2 op_20c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (An),(An)+ */
void REGPARAM2 op_20d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An)+ */
void REGPARAM2 op_20d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x900;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),(An)+ */
void REGPARAM2 op_20e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x900;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An)+ */
void REGPARAM2 op_20e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An)+ */
void REGPARAM2 op_20f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An)+ */
void REGPARAM2 op_20f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An)+ */
void REGPARAM2 op_20f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An)+ */
void REGPARAM2 op_20fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An)+ */
void REGPARAM2 op_20fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An)+ */
void REGPARAM2 op_20fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,-(An) */
void REGPARAM2 op_2100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L An,-(An) */
void REGPARAM2 op_2108_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (An),-(An) */
void REGPARAM2 op_2110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,-(An) */
void REGPARAM2 op_2118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[1].reg = dstreg | 0xa00;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),-(An) */
void REGPARAM2 op_2120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[1].reg = dstreg | 0xa00;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),-(An) */
void REGPARAM2 op_2128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),-(An) */
void REGPARAM2 op_2130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,-(An) */
void REGPARAM2 op_2138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,-(An) */
void REGPARAM2 op_2139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),-(An) */
void REGPARAM2 op_213a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),-(An) */
void REGPARAM2 op_213b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,-(An) */
void REGPARAM2 op_213c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,(d16,An) */
void REGPARAM2 op_2140_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L An,(d16,An) */
void REGPARAM2 op_2148_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L (An),(d16,An) */
void REGPARAM2 op_2150_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L (An)+,(d16,An) */
void REGPARAM2 op_2158_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L -(An),(d16,An) */
void REGPARAM2 op_2160_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(d16,An) */
void REGPARAM2 op_2168_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(d16,An) */
void REGPARAM2 op_2170_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(d16,An) */
void REGPARAM2 op_2178_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(d16,An) */
void REGPARAM2 op_2179_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(d16,An) */
void REGPARAM2 op_217a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_217b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(d16,An) */
void REGPARAM2 op_217c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L Dn,(d8,An,Xn) */
void REGPARAM2 op_2180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L An,(d8,An,Xn) */
void REGPARAM2 op_2188_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (An),(d8,An,Xn) */
void REGPARAM2 op_2190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (An)+,(d8,An,Xn) */
void REGPARAM2 op_2198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.L -(An),(d8,An,Xn) */
void REGPARAM2 op_21a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.L (d16,An),(d8,An,Xn) */
void REGPARAM2 op_21a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_21b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.L (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_21b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.L (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_21b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.L (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_21ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_21bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_21bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.L Dn,(xxx).W */
void REGPARAM2 op_21c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L An,(xxx).W */
void REGPARAM2 op_21c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L (An),(xxx).W */
void REGPARAM2 op_21d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.L (An)+,(xxx).W */
void REGPARAM2 op_21d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L -(An),(xxx).W */
void REGPARAM2 op_21e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(xxx).W */
void REGPARAM2 op_21e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).W */
void REGPARAM2 op_21f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(xxx).W */
void REGPARAM2 op_21f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(xxx).W */
void REGPARAM2 op_21f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(xxx).W */
void REGPARAM2 op_21fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_21fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(xxx).W */
void REGPARAM2 op_21fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L Dn,(xxx).L */
void REGPARAM2 op_23c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L An,(xxx).L */
void REGPARAM2 op_23c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (An),(xxx).L */
void REGPARAM2 op_23d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.L (An)+,(xxx).L */
void REGPARAM2 op_23d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.L -(An),(xxx).L */
void REGPARAM2 op_23e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,An),(xxx).L */
void REGPARAM2 op_23e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).L */
void REGPARAM2 op_23f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 6,0   */

/* MOVE.L (xxx).W,(xxx).L */
void REGPARAM2 op_23f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L (xxx).L,(xxx).L */
void REGPARAM2 op_23f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 10 0,0   */

/* MOVE.L (d16,PC),(xxx).L */
void REGPARAM2 op_23fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_23fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 6,0   */

/* MOVE.L #<data>.L,(xxx).L */
void REGPARAM2 op_23fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 10 0,0   */

/* MOVE.W Dn,Dn */
void REGPARAM2 op_3000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W An,Dn */
void REGPARAM2 op_3008_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An),Dn */
void REGPARAM2 op_3010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,Dn */
void REGPARAM2 op_3018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),Dn */
void REGPARAM2 op_3020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),Dn */
void REGPARAM2 op_3028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),Dn */
void REGPARAM2 op_3030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,Dn */
void REGPARAM2 op_3038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,Dn */
void REGPARAM2 op_3039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),Dn */
void REGPARAM2 op_303a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),Dn */
void REGPARAM2 op_303b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,Dn */
void REGPARAM2 op_303c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W Dn,An */
void REGPARAM2 op_3040_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W An,An */
void REGPARAM2 op_3048_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s16 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W (An),An */
void REGPARAM2 op_3050_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W (An)+,An */
void REGPARAM2 op_3058_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVEA.W -(An),An */
void REGPARAM2 op_3060_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVEA.W (d16,An),An */
void REGPARAM2 op_3068_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W (d8,An,Xn),An */
void REGPARAM2 op_3070_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return;
}
/* 2 2,0   */

/* MOVEA.W (xxx).W,An */
void REGPARAM2 op_3078_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W (xxx).L,An */
void REGPARAM2 op_3079_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVEA.W (d16,PC),An */
void REGPARAM2 op_307a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W (d8,PC,Xn),An */
void REGPARAM2 op_307b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return;
}
/* 2 2,0   */

/* MOVEA.W #<data>.W,An */
void REGPARAM2 op_307c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,(An) */
void REGPARAM2 op_3080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.W An,(An) */
void REGPARAM2 op_3088_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.W (An),(An) */
void REGPARAM2 op_3090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An) */
void REGPARAM2 op_3098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),(An) */
void REGPARAM2 op_30a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An) */
void REGPARAM2 op_30a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An) */
void REGPARAM2 op_30b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An) */
void REGPARAM2 op_30b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An) */
void REGPARAM2 op_30b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An) */
void REGPARAM2 op_30ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An) */
void REGPARAM2 op_30bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An) */
void REGPARAM2 op_30bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,(An)+ */
void REGPARAM2 op_30c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W An,(An)+ */
void REGPARAM2 op_30c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (An),(An)+ */
void REGPARAM2 op_30d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An)+ */
void REGPARAM2 op_30d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x500;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),(An)+ */
void REGPARAM2 op_30e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[1].reg = dstreg | 0x500;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An)+ */
void REGPARAM2 op_30e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An)+ */
void REGPARAM2 op_30f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An)+ */
void REGPARAM2 op_30f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An)+ */
void REGPARAM2 op_30f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An)+ */
void REGPARAM2 op_30fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An)+ */
void REGPARAM2 op_30fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An)+ */
void REGPARAM2 op_30fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,-(An) */
void REGPARAM2 op_3100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W An,-(An) */
void REGPARAM2 op_3108_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (An),-(An) */
void REGPARAM2 op_3110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,-(An) */
void REGPARAM2 op_3118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[1].reg = dstreg | 0x600;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),-(An) */
void REGPARAM2 op_3120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[1].reg = dstreg | 0x600;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),-(An) */
void REGPARAM2 op_3128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),-(An) */
void REGPARAM2 op_3130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,-(An) */
void REGPARAM2 op_3138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,-(An) */
void REGPARAM2 op_3139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),-(An) */
void REGPARAM2 op_313a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),-(An) */
void REGPARAM2 op_313b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,-(An) */
void REGPARAM2 op_313c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,(d16,An) */
void REGPARAM2 op_3140_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W An,(d16,An) */
void REGPARAM2 op_3148_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W (An),(d16,An) */
void REGPARAM2 op_3150_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W (An)+,(d16,An) */
void REGPARAM2 op_3158_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W -(An),(d16,An) */
void REGPARAM2 op_3160_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(d16,An) */
void REGPARAM2 op_3168_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(d16,An) */
void REGPARAM2 op_3170_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(d16,An) */
void REGPARAM2 op_3178_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(d16,An) */
void REGPARAM2 op_3179_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(d16,An) */
void REGPARAM2 op_317a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_317b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(d16,An) */
void REGPARAM2 op_317c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W Dn,(d8,An,Xn) */
void REGPARAM2 op_3180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W An,(d8,An,Xn) */
void REGPARAM2 op_3188_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (An),(d8,An,Xn) */
void REGPARAM2 op_3190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (An)+,(d8,An,Xn) */
void REGPARAM2 op_3198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.W -(An),(d8,An,Xn) */
void REGPARAM2 op_31a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* MOVE.W (d16,An),(d8,An,Xn) */
void REGPARAM2 op_31a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_31b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.W (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_31b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_31b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.W (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_31ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_31bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_31bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W Dn,(xxx).W */
void REGPARAM2 op_31c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W An,(xxx).W */
void REGPARAM2 op_31c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W (An),(xxx).W */
void REGPARAM2 op_31d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* MOVE.W (An)+,(xxx).W */
void REGPARAM2 op_31d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W -(An),(xxx).W */
void REGPARAM2 op_31e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(xxx).W */
void REGPARAM2 op_31e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).W */
void REGPARAM2 op_31f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(xxx).W */
void REGPARAM2 op_31f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(xxx).W */
void REGPARAM2 op_31f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(xxx).W */
void REGPARAM2 op_31fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_31fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(xxx).W */
void REGPARAM2 op_31fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W Dn,(xxx).L */
void REGPARAM2 op_33c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W An,(xxx).L */
void REGPARAM2 op_33c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (An),(xxx).L */
void REGPARAM2 op_33d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* MOVE.W (An)+,(xxx).L */
void REGPARAM2 op_33d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.W -(An),(xxx).L */
void REGPARAM2 op_33e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,An),(xxx).L */
void REGPARAM2 op_33e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).L */
void REGPARAM2 op_33f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 6,0   */

/* MOVE.W (xxx).W,(xxx).L */
void REGPARAM2 op_33f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.W (xxx).L,(xxx).L */
void REGPARAM2 op_33f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(6);
	regs.irc = get_iword_mmu030c_opcode_state(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(10);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 10 0,0   */

/* MOVE.W (d16,PC),(xxx).L */
void REGPARAM2 op_33fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_33fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 6,0   */

/* MOVE.W #<data>.W,(xxx).L */
void REGPARAM2 op_33fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	regs.irc = get_iword_mmu030c_opcode_state(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(8);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 8 0,0   */

/* NEGX.B Dn */
void REGPARAM2 op_4000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.B (An) */
void REGPARAM2 op_4010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 2 0,0   */

/* NEGX.B (An)+ */
void REGPARAM2 op_4018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEGX.B -(An) */
void REGPARAM2 op_4020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEGX.B (d16,An) */
void REGPARAM2 op_4028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NEGX.B (d8,An,Xn) */
void REGPARAM2 op_4030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 2 2,0   */

/* NEGX.B (xxx).W */
void REGPARAM2 op_4038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NEGX.B (xxx).L */
void REGPARAM2 op_4039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 6 0,0   */

/* NEGX.W Dn */
void REGPARAM2 op_4040_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.W (An) */
void REGPARAM2 op_4050_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, newv);
	return;
}
/* 2 0,0   */

/* NEGX.W (An)+ */
void REGPARAM2 op_4058_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEGX.W -(An) */
void REGPARAM2 op_4060_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEGX.W (d16,An) */
void REGPARAM2 op_4068_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NEGX.W (d8,An,Xn) */
void REGPARAM2 op_4070_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, newv);
	return;
}
/* 2 2,0   */

/* NEGX.W (xxx).W */
void REGPARAM2 op_4078_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NEGX.W (xxx).L */
void REGPARAM2 op_4079_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, newv);
	return;
}
/* 6 0,0   */

/* NEGX.L Dn */
void REGPARAM2 op_4080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.L (An) */
void REGPARAM2 op_4090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, newv);
	return;
}
/* 2 0,0   */

/* NEGX.L (An)+ */
void REGPARAM2 op_4098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEGX.L -(An) */
void REGPARAM2 op_40a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEGX.L (d16,An) */
void REGPARAM2 op_40a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NEGX.L (d8,An,Xn) */
void REGPARAM2 op_40b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, newv);
	return;
}
/* 2 2,0   */

/* NEGX.L (xxx).W */
void REGPARAM2 op_40b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NEGX.L (xxx).L */
void REGPARAM2 op_40b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, newv);
	return;
}
/* 6 0,0   */

/* MVSR2.W Dn */
void REGPARAM2 op_40c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* op H:2,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVSR2.W (An) */
void REGPARAM2 op_40d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr);
	return;
}
/* 2 0,0   */

/* MVSR2.W (An)+ */
void REGPARAM2 op_40d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	MakeSR();
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MVSR2.W -(An) */
void REGPARAM2 op_40e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MVSR2.W (d16,An) */
void REGPARAM2 op_40e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr);
	return;
}
/* 4 0,0   */

/* MVSR2.W (d8,An,Xn) */
void REGPARAM2 op_40f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr);
	return;
}
/* 2 2,0   */

/* MVSR2.W (xxx).W */
void REGPARAM2 op_40f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr);
	return;
}
/* 4 0,0   */

/* MVSR2.W (xxx).L */
void REGPARAM2 op_40f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr);
	return;
}
/* 6 0,0   */

/* CHK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* CHK.L (An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* CHK.L (An)+,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

#endif
/* CHK.L -(An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

#endif
/* CHK.L (d16,An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,An,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 2,0   */

#endif
/* CHK.L (xxx).W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK.L (xxx).L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK.L (d16,PC),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_413a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,PC,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_413b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 2,0   */

#endif
/* CHK.L #<data>.L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_413c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK.W Dn,Dn */
void REGPARAM2 op_4180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

/* CHK.W (An),Dn */
void REGPARAM2 op_4190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

/* CHK.W (An)+,Dn */
void REGPARAM2 op_4198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CHK.W -(An),Dn */
void REGPARAM2 op_41a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		mmufixup[0].reg = -1;
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CHK.W (d16,An),Dn */
void REGPARAM2 op_41a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* CHK.W (d8,An,Xn),Dn */
void REGPARAM2 op_41b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 2,0   */

/* CHK.W (xxx).W,Dn */
void REGPARAM2 op_41b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* CHK.W (xxx).L,Dn */
void REGPARAM2 op_41b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

/* CHK.W (d16,PC),Dn */
void REGPARAM2 op_41ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* CHK.W (d8,PC,Xn),Dn */
void REGPARAM2 op_41bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 2,0   */

/* CHK.W #<data>.W,Dn */
void REGPARAM2 op_41bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* LEA.L (An),An */
void REGPARAM2 op_41d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* LEA.L (d16,An),An */
void REGPARAM2 op_41e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* LEA.L (d8,An,Xn),An */
void REGPARAM2 op_41f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(0);
	m68k_areg(regs, dstreg) = (srca);
	return;
}
/* 2 2,0   */

/* LEA.L (xxx).W,An */
void REGPARAM2 op_41f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* LEA.L (xxx).L,An */
void REGPARAM2 op_41f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* LEA.L (d16,PC),An */
void REGPARAM2 op_41fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* LEA.L (d8,PC,Xn),An */
void REGPARAM2 op_41fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_iword_mmu030c_opcode_state(0);
	m68k_areg(regs, dstreg) = (srca);
	return;
}
/* 2 2,0   */

/* CLR.B Dn */
void REGPARAM2 op_4200_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.B (An) */
void REGPARAM2 op_4210_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, 0);
	return;
}
/* 2 0,0   */

/* CLR.B (An)+ */
void REGPARAM2 op_4218_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, 0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CLR.B -(An) */
void REGPARAM2 op_4220_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, 0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CLR.B (d16,An) */
void REGPARAM2 op_4228_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, 0);
	return;
}
/* 4 0,0   */

/* CLR.B (d8,An,Xn) */
void REGPARAM2 op_4230_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, 0);
	return;
}
/* 2 2,0   */

/* CLR.B (xxx).W */
void REGPARAM2 op_4238_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, 0);
	return;
}
/* 4 0,0   */

/* CLR.B (xxx).L */
void REGPARAM2 op_4239_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, 0);
	return;
}
/* 6 0,0   */

/* CLR.W Dn */
void REGPARAM2 op_4240_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.W (An) */
void REGPARAM2 op_4250_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, 0);
	return;
}
/* 2 0,0   */

/* CLR.W (An)+ */
void REGPARAM2 op_4258_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, 0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CLR.W -(An) */
void REGPARAM2 op_4260_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, 0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CLR.W (d16,An) */
void REGPARAM2 op_4268_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, 0);
	return;
}
/* 4 0,0   */

/* CLR.W (d8,An,Xn) */
void REGPARAM2 op_4270_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, 0);
	return;
}
/* 2 2,0   */

/* CLR.W (xxx).W */
void REGPARAM2 op_4278_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, 0);
	return;
}
/* 4 0,0   */

/* CLR.W (xxx).L */
void REGPARAM2 op_4279_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, 0);
	return;
}
/* 6 0,0   */

/* CLR.L Dn */
void REGPARAM2 op_4280_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.L (An) */
void REGPARAM2 op_4290_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, 0);
	return;
}
/* 2 0,0   */

/* CLR.L (An)+ */
void REGPARAM2 op_4298_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, 0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CLR.L -(An) */
void REGPARAM2 op_42a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, 0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CLR.L (d16,An) */
void REGPARAM2 op_42a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, 0);
	return;
}
/* 4 0,0   */

/* CLR.L (d8,An,Xn) */
void REGPARAM2 op_42b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, 0);
	return;
}
/* 2 2,0   */

/* CLR.L (xxx).W */
void REGPARAM2 op_42b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, 0);
	return;
}
/* 4 0,0   */

/* CLR.L (xxx).L */
void REGPARAM2 op_42b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, 0);
	return;
}
/* 6 0,0   */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* op H:2,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr & 0xff);
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:2,T:0,C:-2 */
	MakeSR();
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr & 0xff);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr & 0xff);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr & 0xff);
	return;
}
/* 4 0,0   */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr & 0xff);
	return;
}
/* 2 2,0   */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr & 0xff);
	return;
}
/* 4 0,0   */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, regs.sr & 0xff);
	return;
}
/* 6 0,0   */

#endif
/* NEG.B Dn */
void REGPARAM2 op_4400_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.B (An) */
void REGPARAM2 op_4410_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 2 0,0   */

/* NEG.B (An)+ */
void REGPARAM2 op_4418_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEG.B -(An) */
void REGPARAM2 op_4420_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEG.B (d16,An) */
void REGPARAM2 op_4428_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NEG.B (d8,An,Xn) */
void REGPARAM2 op_4430_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 2 2,0   */

/* NEG.B (xxx).W */
void REGPARAM2 op_4438_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NEG.B (xxx).L */
void REGPARAM2 op_4439_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 6 0,0   */

/* NEG.W Dn */
void REGPARAM2 op_4440_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.W (An) */
void REGPARAM2 op_4450_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 2 0,0   */

/* NEG.W (An)+ */
void REGPARAM2 op_4458_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEG.W -(An) */
void REGPARAM2 op_4460_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEG.W (d16,An) */
void REGPARAM2 op_4468_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NEG.W (d8,An,Xn) */
void REGPARAM2 op_4470_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 2 2,0   */

/* NEG.W (xxx).W */
void REGPARAM2 op_4478_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NEG.W (xxx).L */
void REGPARAM2 op_4479_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 6 0,0   */

/* NEG.L Dn */
void REGPARAM2 op_4480_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.L (An) */
void REGPARAM2 op_4490_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 2 0,0   */

/* NEG.L (An)+ */
void REGPARAM2 op_4498_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEG.L -(An) */
void REGPARAM2 op_44a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NEG.L (d16,An) */
void REGPARAM2 op_44a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NEG.L (d8,An,Xn) */
void REGPARAM2 op_44b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 2 2,0   */

/* NEG.L (xxx).W */
void REGPARAM2 op_44b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NEG.L (xxx).L */
void REGPARAM2 op_44b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 6 0,0   */

/* MV2SR.B Dn */
void REGPARAM2 op_44c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MV2SR.B (An) */
void REGPARAM2 op_44d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MV2SR.B (An)+ */
void REGPARAM2 op_44d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MV2SR.B -(An) */
void REGPARAM2 op_44e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MV2SR.B (d16,An) */
void REGPARAM2 op_44e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MV2SR.B (d8,An,Xn) */
void REGPARAM2 op_44f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	return;
}
/* 2 2,0   */

/* MV2SR.B (xxx).W */
void REGPARAM2 op_44f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MV2SR.B (xxx).L */
void REGPARAM2 op_44f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MV2SR.B (d16,PC) */
void REGPARAM2 op_44fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MV2SR.B (d8,PC,Xn) */
void REGPARAM2 op_44fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	return;
}
/* 2 2,0   */

/* MV2SR.B #<data>.B */
void REGPARAM2 op_44fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.B Dn */
void REGPARAM2 op_4600_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.B (An) */
void REGPARAM2 op_4610_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 2 0,0   */

/* NOT.B (An)+ */
void REGPARAM2 op_4618_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NOT.B -(An) */
void REGPARAM2 op_4620_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NOT.B (d16,An) */
void REGPARAM2 op_4628_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NOT.B (d8,An,Xn) */
void REGPARAM2 op_4630_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 2 2,0   */

/* NOT.B (xxx).W */
void REGPARAM2 op_4638_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NOT.B (xxx).L */
void REGPARAM2 op_4639_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, dst);
	return;
}
/* 6 0,0   */

/* NOT.W Dn */
void REGPARAM2 op_4640_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.W (An) */
void REGPARAM2 op_4650_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 2 0,0   */

/* NOT.W (An)+ */
void REGPARAM2 op_4658_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NOT.W -(An) */
void REGPARAM2 op_4660_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NOT.W (d16,An) */
void REGPARAM2 op_4668_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NOT.W (d8,An,Xn) */
void REGPARAM2 op_4670_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 2 2,0   */

/* NOT.W (xxx).W */
void REGPARAM2 op_4678_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NOT.W (xxx).L */
void REGPARAM2 op_4679_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(srca, dst);
	return;
}
/* 6 0,0   */

/* NOT.L Dn */
void REGPARAM2 op_4680_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.L (An) */
void REGPARAM2 op_4690_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 2 0,0   */

/* NOT.L (An)+ */
void REGPARAM2 op_4698_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NOT.L -(An) */
void REGPARAM2 op_46a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NOT.L (d16,An) */
void REGPARAM2 op_46a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NOT.L (d8,An,Xn) */
void REGPARAM2 op_46b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 2 2,0   */

/* NOT.L (xxx).W */
void REGPARAM2 op_46b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 4 0,0   */

/* NOT.L (xxx).L */
void REGPARAM2 op_46b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(srca, dst);
	return;
}
/* 6 0,0   */

/* MV2SR.W Dn */
void REGPARAM2 op_46c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0   */

/* MV2SR.W (An) */
void REGPARAM2 op_46d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0   */

/* MV2SR.W (An)+ */
void REGPARAM2 op_46d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MV2SR.W -(An) */
void REGPARAM2 op_46e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* MV2SR.W (d16,An) */
void REGPARAM2 op_46e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* MV2SR.W (d8,An,Xn) */
void REGPARAM2 op_46f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	fill_prefetch_030_ntx();
	return;
}
/* 2 2,0   */

/* MV2SR.W (xxx).W */
void REGPARAM2 op_46f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* MV2SR.W (xxx).L */
void REGPARAM2 op_46f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(6);
	fill_prefetch_030_ntx();
	return;
}
/* 6 0,0   */

/* MV2SR.W (d16,PC) */
void REGPARAM2 op_46fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* MV2SR.W (d8,PC,Xn) */
void REGPARAM2 op_46fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	fill_prefetch_030_ntx();
	return;
}
/* 2 2,0   */

/* MV2SR.W #<data>.W */
void REGPARAM2 op_46fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* NBCD.B Dn */
void REGPARAM2 op_4800_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* LINK.L An,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4808_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	uae_s32 offs;
	offs = get_ilong_mmu030c_state(2);
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = olda;
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(olda, src);
	return;
}
/* 6 0,0   */

#endif
/* NBCD.B (An) */
void REGPARAM2 op_4810_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 2 0,0   */

/* NBCD.B (An)+ */
void REGPARAM2 op_4818_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NBCD.B -(An) */
void REGPARAM2 op_4820_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* NBCD.B (d16,An) */
void REGPARAM2 op_4828_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NBCD.B (d8,An,Xn) */
void REGPARAM2 op_4830_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 2 2,0   */

/* NBCD.B (xxx).W */
void REGPARAM2 op_4838_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 4 0,0   */

/* NBCD.B (xxx).L */
void REGPARAM2 op_4839_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, newv);
	return;
}
/* 6 0,0   */

/* SWAP.W Dn */
void REGPARAM2 op_4840_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 34;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BKPTQ.L #<data> */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4848_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 99;
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* PEA.L (An) */
void REGPARAM2 op_4850_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0xa00;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, srca);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* PEA.L (d16,An) */
void REGPARAM2 op_4868_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0xa00;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, srca);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* PEA.L (d8,An,Xn) */
void REGPARAM2 op_4870_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0xa00;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, srca);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* PEA.L (xxx).W */
void REGPARAM2 op_4878_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0xa00;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, srca);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* PEA.L (xxx).L */
void REGPARAM2 op_4879_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0xa00;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, srca);
	mmufixup[0].reg = -1;
	return;
}
/* 6 0,0   */

/* PEA.L (d16,PC) */
void REGPARAM2 op_487a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0xa00;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, srca);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

/* PEA.L (d8,PC,Xn) */
void REGPARAM2 op_487b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	mmufixup[0].reg = 7 | 0xa00;
	mmufixup[0].value = m68k_areg(regs, 7);
	m68k_areg(regs, 7) = dsta;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, srca);
	mmufixup[0].reg = -1;
	return;
}
/* 2 2,0   */

/* EXT.W Dn */
void REGPARAM2 op_4880_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVMLE.W #<data>.W,(An) */
void REGPARAM2 op_4890_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_incpci(4);
	}
	return;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,-(An) */
void REGPARAM2 op_48a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		srca -= 2;
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = movem_index2[amask] != dstreg ? 0 : 2;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index2[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
					m68k_areg(regs, dstreg) = srca;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		movem_cnt++;
		amask = nextmask;
	}
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		srca -= 2;
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index2[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
					m68k_areg(regs, dstreg) = srca;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		movem_cnt++;
		dmask = nextmask;
	}
	m68k_areg(regs, dstreg) = srca;
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_incpci(4);
	}
	return;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,(d16,An) */
void REGPARAM2 op_48a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
	}
	return;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_48b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(0);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(0);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 2,0   */

/* MVMLE.W #<data>.W,(xxx).W */
void REGPARAM2 op_48b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
	}
	return;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(xxx).L */
void REGPARAM2 op_48b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = get_ilong_mmu030c_state(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(8);
					m68k_incpci(8);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(8);
					m68k_incpci(8);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_word_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_incpci(8);
	}
	return;
}
/* 8 0,0   */

/* EXT.L Dn */
void REGPARAM2 op_48c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVMLE.L #<data>.W,(An) */
void REGPARAM2 op_48d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_incpci(4);
	}
	return;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,-(An) */
void REGPARAM2 op_48e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		srca -= 4;
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = movem_index2[amask] != dstreg ? 0 : 4;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index2[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
					m68k_areg(regs, dstreg) = srca;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		movem_cnt++;
		amask = nextmask;
	}
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		srca -= 4;
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index2[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(4);
					m68k_incpci(4);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
					m68k_areg(regs, dstreg) = srca;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		movem_cnt++;
		dmask = nextmask;
	}
	m68k_areg(regs, dstreg) = srca;
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(4);
		m68k_incpci(4);
	}
	return;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,(d16,An) */
void REGPARAM2 op_48e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
	}
	return;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_48f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(0);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(0);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(0);
	}
	return;
}
/* 4 2,0   */

/* MVMLE.L #<data>.W,(xxx).W */
void REGPARAM2 op_48f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(6);
					m68k_incpci(6);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(6);
		m68k_incpci(6);
	}
	return;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(xxx).L */
void REGPARAM2 op_48f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uaecptr srca;
	srca = get_ilong_mmu030c_state(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	int prefetch = 0;
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_dreg(regs, movem_index1[dmask]) - predec;
				if(!amask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(8);
					m68k_incpci(8);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
			} else {
				int predec = 0;
				mmu030_data_buffer_out = m68k_areg(regs, movem_index1[amask]) - predec;
				if(!dmask && !nextmask) {
					regs.irc = get_iword_mmu030c_opcode_state(8);
					m68k_incpci(8);
					regs.instruction_pc = m68k_getpci();
					mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
					mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM1;
					prefetch = 1;
				}
				put_long_mmu030c(srca, mmu030_data_buffer_out);
			}
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	if(prefetch == 0) {
		regs.irc = get_iword_mmu030c_opcode_state(8);
		m68k_incpci(8);
	}
	return;
}
/* 8 0,0   */

/* EXT.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_49c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* TST.B Dn */
void REGPARAM2 op_4a00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.B (An) */
void REGPARAM2 op_4a10_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.B (An)+ */
void REGPARAM2 op_4a18_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TST.B -(An) */
void REGPARAM2 op_4a20_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TST.B (d16,An) */
void REGPARAM2 op_4a28_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.B (d8,An,Xn) */
void REGPARAM2 op_4a30_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	return;
}
/* 2 2,0   */

/* TST.B (xxx).W */
void REGPARAM2 op_4a38_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.B (xxx).L */
void REGPARAM2 op_4a39_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TST.B (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a3a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.B (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a3b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	return;
}
/* 2 2,0   */

#endif
/* TST.B #<data>.B */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a3c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.W Dn */
void REGPARAM2 op_4a40_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.W An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a48_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* TST.W (An) */
void REGPARAM2 op_4a50_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.W (An)+ */
void REGPARAM2 op_4a58_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TST.W -(An) */
void REGPARAM2 op_4a60_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TST.W (d16,An) */
void REGPARAM2 op_4a68_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.W (d8,An,Xn) */
void REGPARAM2 op_4a70_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	return;
}
/* 2 2,0   */

/* TST.W (xxx).W */
void REGPARAM2 op_4a78_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.W (xxx).L */
void REGPARAM2 op_4a79_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TST.W (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a7a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.W (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a7b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	return;
}
/* 2 2,0   */

#endif
/* TST.W #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a7c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.L Dn */
void REGPARAM2 op_4a80_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a88_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* TST.L (An) */
void REGPARAM2 op_4a90_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.L (An)+ */
void REGPARAM2 op_4a98_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TST.L -(An) */
void REGPARAM2 op_4aa0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TST.L (d16,An) */
void REGPARAM2 op_4aa8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.L (d8,An,Xn) */
void REGPARAM2 op_4ab0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	return;
}
/* 2 2,0   */

/* TST.L (xxx).W */
void REGPARAM2 op_4ab8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.L (xxx).L */
void REGPARAM2 op_4ab9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TST.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4aba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4abb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	return;
}
/* 2 2,0   */

#endif
/* TST.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4abc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* TAS.B Dn */
void REGPARAM2 op_4ac0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((src) & 0xff);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TAS.B (An) */
void REGPARAM2 op_4ad0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_lrmw_byte_mmu030c_state(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_lrmw_byte_mmu030c_state(srca, src);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

/* TAS.B (An)+ */
void REGPARAM2 op_4ad8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_lrmw_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_lrmw_byte_mmu030c_state(srca, src);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TAS.B -(An) */
void REGPARAM2 op_4ae0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_lrmw_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_lrmw_byte_mmu030c_state(srca, src);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* TAS.B (d16,An) */
void REGPARAM2 op_4ae8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_lrmw_byte_mmu030c_state(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_lrmw_byte_mmu030c_state(srca, src);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* TAS.B (d8,An,Xn) */
void REGPARAM2 op_4af0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_lrmw_byte_mmu030c_state(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_lrmw_byte_mmu030c_state(srca, src);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 2,0   */

/* TAS.B (xxx).W */
void REGPARAM2 op_4af8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_lrmw_byte_mmu030c_state(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_lrmw_byte_mmu030c_state(srca, src);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

/* TAS.B (xxx).L */
void REGPARAM2 op_4af9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_lrmw_byte_mmu030c_state(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_lrmw_byte_mmu030c_state(srca, src);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

/* MULL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c10_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c18_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c20_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c28_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c30_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:2,T:0,C:28 */
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c38_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c39_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 8 0,0   */

#endif
/* MULL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c3a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c3b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:2,T:0,C:28 */
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c3c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:28 */
	uae_s32 dst;
	dst = get_ilong_mmu030c_state(4);
	/* op H:2,T:0,C:28 */
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c40_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c50_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c58_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c60_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			cpu_restore_fixup();
		}
		if (e < 0) {
			op_unimpl(opcode);
		}
		mmufixup[0].reg = -1;
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c68_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c70_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:0,T:0,C:50 */
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c78_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c79_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c7a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c7b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	/* op H:0,T:0,C:50 */
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c7c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_iword_mmu030c_state(2);
	/* op H:0,T:0,C:50 */
	uae_s32 dst;
	dst = get_ilong_mmu030c_state(4);
	/* op H:0,T:0,C:50 */
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 8 0,0   */

#endif
/* MVMEL.W #<data>.W,(An) */
void REGPARAM2 op_4c90_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(An)+ */
void REGPARAM2 op_4c98_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(d16,An) */
void REGPARAM2 op_4ca8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_4cb0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

/* MVMEL.W #<data>.W,(xxx).W */
void REGPARAM2 op_4cb8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(xxx).L */
void REGPARAM2 op_4cb9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_ilong_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(8);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MVMEL.W #<data>.W,(d16,PC) */
void REGPARAM2 op_4cba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
void REGPARAM2 op_4cbb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = (uae_s32)(uae_s16)mmu030_data_buffer_out;
			} else {
				val = (uae_s32)(uae_s16)get_word_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 2;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(An) */
void REGPARAM2 op_4cd0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(An)+ */
void REGPARAM2 op_4cd8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(d16,An) */
void REGPARAM2 op_4ce8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_4cf0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(xxx).W */
void REGPARAM2 op_4cf8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(xxx).L */
void REGPARAM2 op_4cf9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_ilong_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(8);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MVMEL.L #<data>.W,(d16,PC) */
void REGPARAM2 op_4cfa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(4);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
void REGPARAM2 op_4cfb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	uae_u16 mask = get_iword_mmu030c_state(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	mmu030_state[1] |= MMU030_STATEFLAG1_MOVEM1;
	int movem_cnt = 0;
	uae_u32 val;
	srca = state_store_mmu030(srca);
	while (dmask) {
		uae_u16 nextmask = movem_next[dmask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_dreg(regs, movem_index1[dmask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		dmask = nextmask;
	}
	while (amask) {
		uae_u16 nextmask = movem_next[amask];
		if (mmu030_state[0] == movem_cnt) {
			if (mmu030_state[1] & MMU030_STATEFLAG1_MOVEM2) {
				mmu030_state[1] &= ~MMU030_STATEFLAG1_MOVEM2;
				val = mmu030_data_buffer_out;
			} else {
				val = get_long_mmu030c(srca);
			}
			m68k_areg(regs, movem_index1[amask]) = val;
			mmu030_state[0]++;
		}
		srca += 4;
		movem_cnt++;
		amask = nextmask;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 2,0   */

/* TRAPQ.L #<data> */
void REGPARAM2 op_4e40_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 15);
	OpcodeFamily = 39;
	uae_u32 src = srcreg;
	/* OP zero */
	m68k_incpci(2);
	Exception_cpu(src + 32);
	return;
	return;
}
/* 2 0,0   */

/* LINK.W An,#<data>.W */
void REGPARAM2 op_4e50_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	uae_s16 offs = get_iword_mmu030c_state(2);
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = olda;
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(olda, src);
	return;
}
/* 4 0,0   */

/* UNLK.L An */
void REGPARAM2 op_4e58_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 48;
	uae_s32 src = m68k_areg(regs, srcreg);
	/* OP zero */
	uae_s32 old = get_long_mmu030c_state(src);
	m68k_areg(regs, 7) = src + 4;
	m68k_areg(regs, srcreg) = old;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVR2USP.L An */
void REGPARAM2 op_4e60_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 40;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s32 src = m68k_areg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	regs.usp = src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVUSP2R.L An */
void REGPARAM2 op_4e68_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 41;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* op H:4,T:0,C:-4 */
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, srcreg) = (regs.usp);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* RESET.L  */
void REGPARAM2 op_4e70_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 42;
	if (!regs.s) {
		Exception(8);
		return;
	}
	bool r = cpureset();
	if (r) {
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOP.L  */
void REGPARAM2 op_4e71_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 43;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* STOP.L #<data>.W */
void REGPARAM2 op_4e72_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 44;
	if (!regs.s) {
		Exception(8);
		return;
	}
	if (!regs.stopped) {
		uae_s16 src = get_iword_mmu030c_state(2);
		/* op H:0,T:0,C:8 */
		regs.ir = src;
	}
	uae_u16 sr = regs.ir;
	ipl_fetch_next();
	regs.sr = sr;
	checkint();
	MakeFromSR_STOP();
	do_cycles_stop(4);
	m68k_setstopped(1);
	return;
}

/* RTE.L  */
void REGPARAM2 op_4e73_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 45;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* op H:1,T:9,C:8 */
	uaecptr oldpc = m68k_getpci();
	uae_u16 oldsr = regs.sr, newsr;
	uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg(regs, 7);
		uae_u16 sr = get_word_mmu030c_state(a);
		uae_u32 pc = get_long_mmu030c_state(a + 2);
		uae_u16 format = get_word_mmu030c_state(a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
		if (frame == 0x0) {
		m68k_areg(regs, 7) += offset; break; }
		else if (frame == 0x1) {
		m68k_areg(regs, 7) += offset; }
		else if (frame == 0x2) {
		m68k_areg(regs, 7) += offset + 4; break; }
		else if (frame == 0x9) {
		m68k_areg(regs, 7) += offset + 12; break; }
		else if (frame == 0xa) {
			m68k_do_rte_mmu030c(a);
			return;
		} else if (frame == 0xb) {
			m68k_do_rte_mmu030c(a);
			return;
		}
		else {
			regs.t1 = regs.t0 = 0;
			Exception_cpu(14);
			return;
		}
		regs.sr = newsr;
		oldsr = newsr;
		intlev_load();
		ipl_fetch_now();
		MakeFromSR_T0();
	}
	regs.sr = newsr;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	if (newpc & 1) {
		exception3_read_prefetch(opcode, newpc);
		return;
	}
	m68k_setpci(newpc);
	#ifdef DEBUGGER
	branch_stack_pop_rte(oldpc);
	#endif
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0 B */

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4e74_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 46;
	uaecptr oldpc = m68k_getpci();
	/* op H:2,T:0,C:8 */
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:8 */
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	uae_s32 pc = get_long_mmu030c_state(pca);
	m68k_areg(regs, 7) += 4;
	m68k_areg(regs, 7) += offs;
	if (pc & 1) {
		exception3_read_prefetch_only(opcode, pc);
		return;
	}
	m68k_setpci(pc);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

#endif
/* RTS.L  */
void REGPARAM2 op_4e75_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 49;
	/* op H:1,T:0,C:8 */
	uaecptr oldpc = m68k_getpci();
	m68k_do_rts_mmu030c();
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_pop_rts(oldpc);
	}
	#endif
	if (m68k_getpci() & 1) {
		uaecptr faultpc = m68k_getpci();
		m68k_setpci(oldpc);
		exception3_read_prefetch_only(opcode, faultpc);
		return;
	}
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* TRAPV.L  */
void REGPARAM2 op_4e76_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 50;
	m68k_incpci(2);
	if (GET_VFLG()) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

/* RTR.L  */
void REGPARAM2 op_4e77_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 51;
	uaecptr oldpc = m68k_getpci();
	MakeSR();
	uaecptr sra;
	sra = m68k_areg(regs, 7);
	uae_s16 sr = get_word_mmu030c_state(sra);
	m68k_areg(regs, 7) += 2;
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	uae_s32 pc = get_long_mmu030c_state(pca);
	m68k_areg(regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	MakeFromSR();
	intlev_load(); 
	m68k_setpci(pc);
	if (m68k_getpci() & 1) {
		uaecptr faultpc = m68k_getpci();
		m68k_setpci(oldpc + 2);
		exception3_read_prefetch_only(opcode, faultpc);
		return;
	}
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4e7a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 82;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* op H:6,T:0,C:-6 */
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_movec2(src & 0xFFF, regp)) {
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4e7b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 83;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* op H:6,T:0,C:-6 */
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_move2c(src & 0xFFF, regp)) {
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* JSR.L (An) */
void REGPARAM2 op_4e90_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	/* ea H:2,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	put_long_mmu030c_state(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* JSR.L (d16,An) */
void REGPARAM2 op_4ea8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	/* ea H:4,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	put_long_mmu030c_state(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JSR.L (d8,An,Xn) */
void REGPARAM2 op_4eb0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	put_long_mmu030c_state(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* JSR.L (xxx).W */
void REGPARAM2 op_4eb8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:2,T:0,C:0 jea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	put_long_mmu030c_state(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JSR.L (xxx).L */
void REGPARAM2 op_4eb9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:2,T:0,C:0 jea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	put_long_mmu030c_state(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 6 0,0 B */

/* JSR.L (d16,PC) */
void REGPARAM2 op_4eba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:4,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	put_long_mmu030c_state(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JSR.L (d8,PC,Xn) */
void REGPARAM2 op_4ebb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	put_long_mmu030c_state(m68k_areg(regs, 7) - 4, nextpc);
	m68k_areg(regs, 7) -= 4;
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* JMP.L (An) */
void REGPARAM2 op_4ed0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	/* ea H:2+4=6,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* JMP.L (d16,An) */
void REGPARAM2 op_4ee8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	/* ea H:4+4=8,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JMP.L (d8,An,Xn) */
void REGPARAM2 op_4ef0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	/* op H:4,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* JMP.L (xxx).W */
void REGPARAM2 op_4ef8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:2+4=6,T:0,C:0 jea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JMP.L (xxx).L */
void REGPARAM2 op_4ef9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:2+4=6,T:0,C:0 jea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 6 0,0 B */

/* JMP.L (d16,PC) */
void REGPARAM2 op_4efa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:4+4=8,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JMP.L (d8,PC,Xn) */
void REGPARAM2 op_4efb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	/* op H:4,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci(srca);
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* ADDQ.B #<data>,Dn */
void REGPARAM2 op_5000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An) */
void REGPARAM2 op_5010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An)+ */
void REGPARAM2 op_5018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,-(An) */
void REGPARAM2 op_5020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(d16,An) */
void REGPARAM2 op_5028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 op_5030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* ADDQ.B #<data>,(xxx).W */
void REGPARAM2 op_5038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(xxx).L */
void REGPARAM2 op_5039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* ADDQ.W #<data>,Dn */
void REGPARAM2 op_5040_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDAQ.W #<data>,An */
void REGPARAM2 op_5048_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst + src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An) */
void REGPARAM2 op_5050_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An)+ */
void REGPARAM2 op_5058_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,-(An) */
void REGPARAM2 op_5060_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(d16,An) */
void REGPARAM2 op_5068_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 op_5070_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* ADDQ.W #<data>,(xxx).W */
void REGPARAM2 op_5078_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(xxx).L */
void REGPARAM2 op_5079_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* ADDQ.L #<data>,Dn */
void REGPARAM2 op_5080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDAQ.L #<data>,An */
void REGPARAM2 op_5088_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst + src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An) */
void REGPARAM2 op_5090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An)+ */
void REGPARAM2 op_5098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,-(An) */
void REGPARAM2 op_50a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(d16,An) */
void REGPARAM2 op_50a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 op_50b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* ADDQ.L #<data>,(xxx).W */
void REGPARAM2 op_50b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(xxx).L */
void REGPARAM2 op_50b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* Scc.B Dn (T) */
void REGPARAM2 op_50c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (T) */
void REGPARAM2 op_50c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(0)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (T) */
void REGPARAM2 op_50d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (T) */
void REGPARAM2 op_50d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (T) */
void REGPARAM2 op_50e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (T) */
void REGPARAM2 op_50e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (T) */
void REGPARAM2 op_50f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (T) */
void REGPARAM2 op_50f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (T) */
void REGPARAM2 op_50f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_50fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(0)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_50fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(0)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_50fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(0)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* SUBQ.B #<data>,Dn */
void REGPARAM2 op_5100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An) */
void REGPARAM2 op_5110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An)+ */
void REGPARAM2 op_5118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,-(An) */
void REGPARAM2 op_5120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(d16,An) */
void REGPARAM2 op_5128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 op_5130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUBQ.B #<data>,(xxx).W */
void REGPARAM2 op_5138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(xxx).L */
void REGPARAM2 op_5139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUBQ.W #<data>,Dn */
void REGPARAM2 op_5140_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBAQ.W #<data>,An */
void REGPARAM2 op_5148_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An) */
void REGPARAM2 op_5150_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An)+ */
void REGPARAM2 op_5158_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,-(An) */
void REGPARAM2 op_5160_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(d16,An) */
void REGPARAM2 op_5168_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 op_5170_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUBQ.W #<data>,(xxx).W */
void REGPARAM2 op_5178_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(xxx).L */
void REGPARAM2 op_5179_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUBQ.L #<data>,Dn */
void REGPARAM2 op_5180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBAQ.L #<data>,An */
void REGPARAM2 op_5188_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An) */
void REGPARAM2 op_5190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An)+ */
void REGPARAM2 op_5198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,-(An) */
void REGPARAM2 op_51a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(d16,An) */
void REGPARAM2 op_51a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 op_51b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUBQ.L #<data>,(xxx).W */
void REGPARAM2 op_51b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(xxx).L */
void REGPARAM2 op_51b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* Scc.B Dn (F) */
void REGPARAM2 op_51c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (F) */
void REGPARAM2 op_51c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(1)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (F) */
void REGPARAM2 op_51d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (F) */
void REGPARAM2 op_51d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (F) */
void REGPARAM2 op_51e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (F) */
void REGPARAM2 op_51e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (F) */
void REGPARAM2 op_51f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (F) */
void REGPARAM2 op_51f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (F) */
void REGPARAM2 op_51f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_51fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(1)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_51fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(1)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_51fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(1)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (HI) */
void REGPARAM2 op_52c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (HI) */
void REGPARAM2 op_52c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(2)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (HI) */
void REGPARAM2 op_52d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (HI) */
void REGPARAM2 op_52d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (HI) */
void REGPARAM2 op_52e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (HI) */
void REGPARAM2 op_52e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (HI) */
void REGPARAM2 op_52f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (HI) */
void REGPARAM2 op_52f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (HI) */
void REGPARAM2 op_52f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_52fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(2)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_52fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(2)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_52fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(2)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LS) */
void REGPARAM2 op_53c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LS) */
void REGPARAM2 op_53c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(3)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (LS) */
void REGPARAM2 op_53d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (LS) */
void REGPARAM2 op_53d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (LS) */
void REGPARAM2 op_53e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LS) */
void REGPARAM2 op_53e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LS) */
void REGPARAM2 op_53f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LS) */
void REGPARAM2 op_53f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LS) */
void REGPARAM2 op_53f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_53fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(3)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_53fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(3)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_53fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(3)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CC) */
void REGPARAM2 op_54c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CC) */
void REGPARAM2 op_54c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(4)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (CC) */
void REGPARAM2 op_54d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (CC) */
void REGPARAM2 op_54d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (CC) */
void REGPARAM2 op_54e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CC) */
void REGPARAM2 op_54e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CC) */
void REGPARAM2 op_54f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CC) */
void REGPARAM2 op_54f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CC) */
void REGPARAM2 op_54f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_54fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(4)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_54fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(4)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_54fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(4)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CS) */
void REGPARAM2 op_55c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CS) */
void REGPARAM2 op_55c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(5)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (CS) */
void REGPARAM2 op_55d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (CS) */
void REGPARAM2 op_55d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (CS) */
void REGPARAM2 op_55e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CS) */
void REGPARAM2 op_55e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CS) */
void REGPARAM2 op_55f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CS) */
void REGPARAM2 op_55f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CS) */
void REGPARAM2 op_55f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_55fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(5)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_55fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(5)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_55fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(5)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (NE) */
void REGPARAM2 op_56c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (NE) */
void REGPARAM2 op_56c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(6)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (NE) */
void REGPARAM2 op_56d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (NE) */
void REGPARAM2 op_56d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (NE) */
void REGPARAM2 op_56e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (NE) */
void REGPARAM2 op_56e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (NE) */
void REGPARAM2 op_56f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (NE) */
void REGPARAM2 op_56f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (NE) */
void REGPARAM2 op_56f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_56fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(6)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_56fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(6)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_56fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(6)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (EQ) */
void REGPARAM2 op_57c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (EQ) */
void REGPARAM2 op_57c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(7)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (EQ) */
void REGPARAM2 op_57d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (EQ) */
void REGPARAM2 op_57d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (EQ) */
void REGPARAM2 op_57e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (EQ) */
void REGPARAM2 op_57e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (EQ) */
void REGPARAM2 op_57f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (EQ) */
void REGPARAM2 op_57f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (EQ) */
void REGPARAM2 op_57f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_57fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(7)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_57fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(7)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_57fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(7)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VC) */
void REGPARAM2 op_58c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VC) */
void REGPARAM2 op_58c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(8)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (VC) */
void REGPARAM2 op_58d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (VC) */
void REGPARAM2 op_58d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (VC) */
void REGPARAM2 op_58e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VC) */
void REGPARAM2 op_58e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VC) */
void REGPARAM2 op_58f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VC) */
void REGPARAM2 op_58f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VC) */
void REGPARAM2 op_58f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_58fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(8)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_58fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(8)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_58fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(8)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VS) */
void REGPARAM2 op_59c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VS) */
void REGPARAM2 op_59c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(9)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (VS) */
void REGPARAM2 op_59d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (VS) */
void REGPARAM2 op_59d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (VS) */
void REGPARAM2 op_59e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VS) */
void REGPARAM2 op_59e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VS) */
void REGPARAM2 op_59f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VS) */
void REGPARAM2 op_59f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VS) */
void REGPARAM2 op_59f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_59fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(9)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_59fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(9)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_59fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(9)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (PL) */
void REGPARAM2 op_5ac0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (PL) */
void REGPARAM2 op_5ac8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(10)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (PL) */
void REGPARAM2 op_5ad0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (PL) */
void REGPARAM2 op_5ad8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (PL) */
void REGPARAM2 op_5ae0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (PL) */
void REGPARAM2 op_5ae8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (PL) */
void REGPARAM2 op_5af0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (PL) */
void REGPARAM2 op_5af8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (PL) */
void REGPARAM2 op_5af9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5afa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(10)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5afb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(10)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5afc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(10)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (MI) */
void REGPARAM2 op_5bc0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (MI) */
void REGPARAM2 op_5bc8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(11)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (MI) */
void REGPARAM2 op_5bd0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (MI) */
void REGPARAM2 op_5bd8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (MI) */
void REGPARAM2 op_5be0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (MI) */
void REGPARAM2 op_5be8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (MI) */
void REGPARAM2 op_5bf0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (MI) */
void REGPARAM2 op_5bf8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (MI) */
void REGPARAM2 op_5bf9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5bfa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(11)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5bfb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(11)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5bfc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(11)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GE) */
void REGPARAM2 op_5cc0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GE) */
void REGPARAM2 op_5cc8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(12)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (GE) */
void REGPARAM2 op_5cd0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (GE) */
void REGPARAM2 op_5cd8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (GE) */
void REGPARAM2 op_5ce0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GE) */
void REGPARAM2 op_5ce8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GE) */
void REGPARAM2 op_5cf0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GE) */
void REGPARAM2 op_5cf8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GE) */
void REGPARAM2 op_5cf9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5cfa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(12)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5cfb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(12)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5cfc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(12)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LT) */
void REGPARAM2 op_5dc0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LT) */
void REGPARAM2 op_5dc8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(13)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (LT) */
void REGPARAM2 op_5dd0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (LT) */
void REGPARAM2 op_5dd8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (LT) */
void REGPARAM2 op_5de0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LT) */
void REGPARAM2 op_5de8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LT) */
void REGPARAM2 op_5df0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LT) */
void REGPARAM2 op_5df8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LT) */
void REGPARAM2 op_5df9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5dfa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(13)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5dfb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(13)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5dfc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(13)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GT) */
void REGPARAM2 op_5ec0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GT) */
void REGPARAM2 op_5ec8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(14)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (GT) */
void REGPARAM2 op_5ed0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (GT) */
void REGPARAM2 op_5ed8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (GT) */
void REGPARAM2 op_5ee0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GT) */
void REGPARAM2 op_5ee8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GT) */
void REGPARAM2 op_5ef0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GT) */
void REGPARAM2 op_5ef8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GT) */
void REGPARAM2 op_5ef9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5efa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(14)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5efb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(14)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5efc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(14)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LE) */
void REGPARAM2 op_5fc0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LE) */
void REGPARAM2 op_5fc8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_iword_mmu030c_state(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(15)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci(oldpc + 4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (LE) */
void REGPARAM2 op_5fd0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (LE) */
void REGPARAM2 op_5fd8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (LE) */
void REGPARAM2 op_5fe0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LE) */
void REGPARAM2 op_5fe8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LE) */
void REGPARAM2 op_5ff0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LE) */
void REGPARAM2 op_5ff8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LE) */
void REGPARAM2 op_5ff9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(srca, val);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5ffa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_iword_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(15)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5ffb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_ilong_mmu030c_state(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(15)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5ffc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(15)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

#endif
/* Bcc.W #<data>.W (T) */
void REGPARAM2 op_6000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (T) */
void REGPARAM2 op_6001_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (T) */
void REGPARAM2 op_60ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* BSR.W #<data>.W */
void REGPARAM2 op_6100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	uae_s32 s;
	uae_s16 src = get_iword_mmu030c_state(2);
	/* op H:2,T:0,C:-2 */
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return;
	}
	m68k_do_bsr_mmu030c(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* BSRQ.B #<data> */
void REGPARAM2 op_6101_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 54;
	uae_s32 s;
	uae_u32 src = srcreg;
	/* op H:2,T:0,C:-2 */
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return;
	}
	m68k_do_bsr_mmu030c(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* BSR.L #<data>.L */
void REGPARAM2 op_61ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	uae_s32 s;
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* op H:2,T:0,C:-2 */
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return;
	}
	m68k_do_bsr_mmu030c(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (HI) */
void REGPARAM2 op_6200_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (HI) */
void REGPARAM2 op_6201_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (HI) */
void REGPARAM2 op_62ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LS) */
void REGPARAM2 op_6300_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LS) */
void REGPARAM2 op_6301_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LS) */
void REGPARAM2 op_63ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CC) */
void REGPARAM2 op_6400_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CC) */
void REGPARAM2 op_6401_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CC) */
void REGPARAM2 op_64ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CS) */
void REGPARAM2 op_6500_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CS) */
void REGPARAM2 op_6501_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CS) */
void REGPARAM2 op_65ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (NE) */
void REGPARAM2 op_6600_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (NE) */
void REGPARAM2 op_6601_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (NE) */
void REGPARAM2 op_66ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (EQ) */
void REGPARAM2 op_6700_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (EQ) */
void REGPARAM2 op_6701_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (EQ) */
void REGPARAM2 op_67ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VC) */
void REGPARAM2 op_6800_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VC) */
void REGPARAM2 op_6801_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VC) */
void REGPARAM2 op_68ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VS) */
void REGPARAM2 op_6900_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VS) */
void REGPARAM2 op_6901_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VS) */
void REGPARAM2 op_69ff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (PL) */
void REGPARAM2 op_6a00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (PL) */
void REGPARAM2 op_6a01_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (PL) */
void REGPARAM2 op_6aff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (MI) */
void REGPARAM2 op_6b00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (MI) */
void REGPARAM2 op_6b01_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (MI) */
void REGPARAM2 op_6bff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GE) */
void REGPARAM2 op_6c00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GE) */
void REGPARAM2 op_6c01_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GE) */
void REGPARAM2 op_6cff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LT) */
void REGPARAM2 op_6d00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LT) */
void REGPARAM2 op_6d01_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LT) */
void REGPARAM2 op_6dff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GT) */
void REGPARAM2 op_6e00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GT) */
void REGPARAM2 op_6e01_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GT) */
void REGPARAM2 op_6eff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LE) */
void REGPARAM2 op_6f00_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_iword_mmu030c_state(2);
	/* OP zero */
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LE) */
void REGPARAM2 op_6f01_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LE) */
void REGPARAM2 op_6fff_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	/* OP zero */
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 6 0,0 B */

/* MOVEQ.L #<data>,Dn */
void REGPARAM2 op_7000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_u32 src = srcreg;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B Dn,Dn */
void REGPARAM2 op_8000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B (An),Dn */
void REGPARAM2 op_8010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B (An)+,Dn */
void REGPARAM2 op_8018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.B -(An),Dn */
void REGPARAM2 op_8020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.B (d16,An),Dn */
void REGPARAM2 op_8028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B (d8,An,Xn),Dn */
void REGPARAM2 op_8030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* OR.B (xxx).W,Dn */
void REGPARAM2 op_8038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B (xxx).L,Dn */
void REGPARAM2 op_8039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.B (d16,PC),Dn */
void REGPARAM2 op_803a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B (d8,PC,Xn),Dn */
void REGPARAM2 op_803b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* OR.B #<data>.B,Dn */
void REGPARAM2 op_803c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W Dn,Dn */
void REGPARAM2 op_8040_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W (An),Dn */
void REGPARAM2 op_8050_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W (An)+,Dn */
void REGPARAM2 op_8058_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.W -(An),Dn */
void REGPARAM2 op_8060_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.W (d16,An),Dn */
void REGPARAM2 op_8068_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W (d8,An,Xn),Dn */
void REGPARAM2 op_8070_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* OR.W (xxx).W,Dn */
void REGPARAM2 op_8078_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W (xxx).L,Dn */
void REGPARAM2 op_8079_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.W (d16,PC),Dn */
void REGPARAM2 op_807a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W (d8,PC,Xn),Dn */
void REGPARAM2 op_807b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* OR.W #<data>.W,Dn */
void REGPARAM2 op_807c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L Dn,Dn */
void REGPARAM2 op_8080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L (An),Dn */
void REGPARAM2 op_8090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L (An)+,Dn */
void REGPARAM2 op_8098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.L -(An),Dn */
void REGPARAM2 op_80a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.L (d16,An),Dn */
void REGPARAM2 op_80a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L (d8,An,Xn),Dn */
void REGPARAM2 op_80b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* OR.L (xxx).W,Dn */
void REGPARAM2 op_80b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L (xxx).L,Dn */
void REGPARAM2 op_80b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.L (d16,PC),Dn */
void REGPARAM2 op_80ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L (d8,PC,Xn),Dn */
void REGPARAM2 op_80bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* OR.L #<data>.L,Dn */
void REGPARAM2 op_80bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* DIVU.W Dn,Dn */
void REGPARAM2 op_80c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:18 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles(34);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

/* DIVU.W (An),Dn */
void REGPARAM2 op_80d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles(34);
	return;
}
/* 2 0,0   */

/* DIVU.W (An)+,Dn */
void REGPARAM2 op_80d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles(34);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* DIVU.W -(An),Dn */
void REGPARAM2 op_80e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles(34);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* DIVU.W (d16,An),Dn */
void REGPARAM2 op_80e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles(34);
	return;
}
/* 4 0,0   */

/* DIVU.W (d8,An,Xn),Dn */
void REGPARAM2 op_80f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	do_cycles(34);
	return;
}
/* 2 2,0   */

/* DIVU.W (xxx).W,Dn */
void REGPARAM2 op_80f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles(34);
	return;
}
/* 4 0,0   */

/* DIVU.W (xxx).L,Dn */
void REGPARAM2 op_80f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(6);
	do_cycles(34);
	return;
}
/* 6 0,0   */

/* DIVU.W (d16,PC),Dn */
void REGPARAM2 op_80fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles(34);
	return;
}
/* 4 0,0   */

/* DIVU.W (d8,PC,Xn),Dn */
void REGPARAM2 op_80fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	do_cycles(34);
	return;
}
/* 2 2,0   */

/* DIVU.W #<data>.W,Dn */
void REGPARAM2 op_80fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles(34);
	return;
}
/* 4 0,0   */

/* SBCD.B Dn,Dn */
void REGPARAM2 op_8100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SBCD.B -(An),-(An) */
void REGPARAM2 op_8108_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:10 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x200;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:10 */
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.B Dn,(An) */
void REGPARAM2 op_8110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* OR.B Dn,(An)+ */
void REGPARAM2 op_8118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.B Dn,-(An) */
void REGPARAM2 op_8120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.B Dn,(d16,An) */
void REGPARAM2 op_8128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.B Dn,(d8,An,Xn) */
void REGPARAM2 op_8130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* OR.B Dn,(xxx).W */
void REGPARAM2 op_8138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.B Dn,(xxx).L */
void REGPARAM2 op_8139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* PACK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8140_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	uae_u16 val = m68k_dreg(regs, srcreg) + get_iword_mmu030c_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* PACK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8148_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	uae_u16 val;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) -= 2;
	val = (uae_u16)(get_word_mmu030c_state(m68k_areg(regs, srcreg)));
	val += get_iword_mmu030c_state(2);
	mmufixup[1].reg = dstreg | 0xa00;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(m68k_areg(regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* OR.W Dn,(An) */
void REGPARAM2 op_8150_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* OR.W Dn,(An)+ */
void REGPARAM2 op_8158_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.W Dn,-(An) */
void REGPARAM2 op_8160_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.W Dn,(d16,An) */
void REGPARAM2 op_8168_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.W Dn,(d8,An,Xn) */
void REGPARAM2 op_8170_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* OR.W Dn,(xxx).W */
void REGPARAM2 op_8178_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.W Dn,(xxx).L */
void REGPARAM2 op_8179_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* UNPK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	uae_u16 val = m68k_dreg(regs, srcreg);
	val = ((val << 4) & 0xf00) | (val & 0xf);
	val += get_iword_mmu030c_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffff0000) | (val & 0xffff);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* UNPK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8188_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	uae_u16 val;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(get_byte_mmu030c_state(m68k_areg(regs, srcreg)) & 0xff);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_iword_mmu030c_state(2);
	mmufixup[1].reg = dstreg | 0xa00;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) -= 2;
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(m68k_areg(regs, dstreg), val);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 4 0,0   */

#endif
/* OR.L Dn,(An) */
void REGPARAM2 op_8190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 0,0   */

/* OR.L Dn,(An)+ */
void REGPARAM2 op_8198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.L Dn,-(An) */
void REGPARAM2 op_81a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* OR.L Dn,(d16,An) */
void REGPARAM2 op_81a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.L Dn,(d8,An,Xn) */
void REGPARAM2 op_81b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 2 2,0   */

/* OR.L Dn,(xxx).W */
void REGPARAM2 op_81b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 4 0,0   */

/* OR.L Dn,(xxx).L */
void REGPARAM2 op_81b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, src);
	return;
}
/* 6 0,0   */

/* DIVS.W Dn,Dn */
void REGPARAM2 op_81c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:18 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles(48);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	return;
}
/* 2 0,0   */

/* DIVS.W (An),Dn */
void REGPARAM2 op_81d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles(48);
	return;
}
/* 2 0,0   */

/* DIVS.W (An)+,Dn */
void REGPARAM2 op_81d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles(48);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* DIVS.W -(An),Dn */
void REGPARAM2 op_81e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		mmufixup[0].reg = -1;
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles(48);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* DIVS.W (d16,An),Dn */
void REGPARAM2 op_81e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles(48);
	return;
}
/* 4 0,0   */

/* DIVS.W (d8,An,Xn),Dn */
void REGPARAM2 op_81f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	do_cycles(48);
	return;
}
/* 2 2,0   */

/* DIVS.W (xxx).W,Dn */
void REGPARAM2 op_81f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles(48);
	return;
}
/* 4 0,0   */

/* DIVS.W (xxx).L,Dn */
void REGPARAM2 op_81f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(6);
	do_cycles(48);
	return;
}
/* 6 0,0   */

/* DIVS.W (d16,PC),Dn */
void REGPARAM2 op_81fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles(48);
	return;
}
/* 4 0,0   */

/* DIVS.W (d8,PC,Xn),Dn */
void REGPARAM2 op_81fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	do_cycles(48);
	return;
}
/* 2 2,0   */

/* DIVS.W #<data>.W,Dn */
void REGPARAM2 op_81fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles(48);
	return;
}
/* 4 0,0   */

/* SUB.B Dn,Dn */
void REGPARAM2 op_9000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B (An),Dn */
void REGPARAM2 op_9010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B (An)+,Dn */
void REGPARAM2 op_9018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.B -(An),Dn */
void REGPARAM2 op_9020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.B (d16,An),Dn */
void REGPARAM2 op_9028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B (d8,An,Xn),Dn */
void REGPARAM2 op_9030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return;
}
/* 2 2,0   */

/* SUB.B (xxx).W,Dn */
void REGPARAM2 op_9038_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B (xxx).L,Dn */
void REGPARAM2 op_9039_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.B (d16,PC),Dn */
void REGPARAM2 op_903a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B (d8,PC,Xn),Dn */
void REGPARAM2 op_903b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return;
}
/* 2 2,0   */

/* SUB.B #<data>.B,Dn */
void REGPARAM2 op_903c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_iword_mmu030c_state(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W Dn,Dn */
void REGPARAM2 op_9040_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W An,Dn */
void REGPARAM2 op_9048_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W (An),Dn */
void REGPARAM2 op_9050_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W (An)+,Dn */
void REGPARAM2 op_9058_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.W -(An),Dn */
void REGPARAM2 op_9060_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.W (d16,An),Dn */
void REGPARAM2 op_9068_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W (d8,An,Xn),Dn */
void REGPARAM2 op_9070_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return;
}
/* 2 2,0   */

/* SUB.W (xxx).W,Dn */
void REGPARAM2 op_9078_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W (xxx).L,Dn */
void REGPARAM2 op_9079_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.W (d16,PC),Dn */
void REGPARAM2 op_907a_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W (d8,PC,Xn),Dn */
void REGPARAM2 op_907b_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return;
}
/* 2 2,0   */

/* SUB.W #<data>.W,Dn */
void REGPARAM2 op_907c_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L Dn,Dn */
void REGPARAM2 op_9080_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L An,Dn */
void REGPARAM2 op_9088_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L (An),Dn */
void REGPARAM2 op_9090_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L (An)+,Dn */
void REGPARAM2 op_9098_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.L -(An),Dn */
void REGPARAM2 op_90a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.L (d16,An),Dn */
void REGPARAM2 op_90a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L (d8,An,Xn),Dn */
void REGPARAM2 op_90b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUB.L (xxx).W,Dn */
void REGPARAM2 op_90b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L (xxx).L,Dn */
void REGPARAM2 op_90b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.L (d16,PC),Dn */
void REGPARAM2 op_90ba_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L (d8,PC,Xn),Dn */
void REGPARAM2 op_90bb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUB.L #<data>.L,Dn */
void REGPARAM2 op_90bc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBA.W Dn,An */
void REGPARAM2 op_90c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = dst - src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W An,An */
void REGPARAM2 op_90c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = dst - src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W (An),An */
void REGPARAM2 op_90d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W (An)+,An */
void REGPARAM2 op_90d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBA.W -(An),An */
void REGPARAM2 op_90e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBA.W (d16,An),An */
void REGPARAM2 op_90e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.W (d8,An,Xn),An */
void REGPARAM2 op_90f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.W (xxx).W,An */
void REGPARAM2 op_90f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.W (xxx).L,An */
void REGPARAM2 op_90f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBA.W (d16,PC),An */
void REGPARAM2 op_90fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.W (d8,PC,Xn),An */
void REGPARAM2 op_90fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s16 src = get_word_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.W #<data>.W,An */
void REGPARAM2 op_90fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_iword_mmu030c_state(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBX.B Dn,Dn */
void REGPARAM2 op_9100_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBX.B -(An),-(An) */
void REGPARAM2 op_9108_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	mmufixup[1].reg = dstreg | 0x200;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.B Dn,(An) */
void REGPARAM2 op_9110_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* SUB.B Dn,(An)+ */
void REGPARAM2 op_9118_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.B Dn,-(An) */
void REGPARAM2 op_9120_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.B Dn,(d16,An) */
void REGPARAM2 op_9128_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.B Dn,(d8,An,Xn) */
void REGPARAM2 op_9130_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUB.B Dn,(xxx).W */
void REGPARAM2 op_9138_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.B Dn,(xxx).L */
void REGPARAM2 op_9139_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = get_byte_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_byte_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUBX.W Dn,Dn */
void REGPARAM2 op_9140_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBX.W -(An),-(An) */
void REGPARAM2 op_9148_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	mmufixup[0].reg = srcreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s16 src = get_word_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	mmufixup[1].reg = dstreg | 0x600;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.W Dn,(An) */
void REGPARAM2 op_9150_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* SUB.W Dn,(An)+ */
void REGPARAM2 op_9158_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x500;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.W Dn,-(An) */
void REGPARAM2 op_9160_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x600;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s16 dst = get_word_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.W Dn,(d16,An) */
void REGPARAM2 op_9168_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.W Dn,(d8,An,Xn) */
void REGPARAM2 op_9170_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUB.W Dn,(xxx).W */
void REGPARAM2 op_9178_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.W Dn,(xxx).L */
void REGPARAM2 op_9179_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = get_word_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_word_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUBX.L Dn,Dn */
void REGPARAM2 op_9180_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBX.L -(An),-(An) */
void REGPARAM2 op_9188_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	mmufixup[1].reg = dstreg | 0xa00;
	mmufixup[1].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	mmufixup[1].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.L Dn,(An) */
void REGPARAM2 op_9190_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 2 0,0   */

/* SUB.L Dn,(An)+ */
void REGPARAM2 op_9198_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.L Dn,-(An) */
void REGPARAM2 op_91a0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* op H:0,T:1,C:-1 */
	mmufixup[0].reg = dstreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, dstreg);
	uae_s32 dst = get_long_mmu030c_state(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUB.L Dn,(d16,An) */
void REGPARAM2 op_91a8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.L Dn,(d8,An,Xn) */
void REGPARAM2 op_91b0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = get_disp_ea_020_mmu030c(m68k_areg(regs, dstreg), 0);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUB.L Dn,(xxx).W */
void REGPARAM2 op_91b8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 4 0,0   */

/* SUB.L Dn,(xxx).L */
void REGPARAM2 op_91b9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_ilong_mmu030c_state(2);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = get_long_mmu030c_state(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	regs.instruction_pc = m68k_getpci();
	mmu030_state[1] |= MMU030_STATEFLAG1_LASTWRITE;
	put_long_mmu030c_state(dsta, newv);
	return;
}
/* 6 0,0   */

/* SUBA.L Dn,An */
void REGPARAM2 op_91c0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L An,An */
void REGPARAM2 op_91c8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L (An),An */
void REGPARAM2 op_91d0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L (An)+,An */
void REGPARAM2 op_91d8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x900;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBA.L -(An),An */
void REGPARAM2 op_91e0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	mmufixup[0].reg = srcreg | 0xa00;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s32 src = get_long_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* SUBA.L (d16,An),An */
void REGPARAM2 op_91e8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.L (d8,An,Xn),An */
void REGPARAM2 op_91f0_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = get_disp_ea_020_mmu030c(m68k_areg(regs, srcreg), 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.L (xxx).W,An */
void REGPARAM2 op_91f8_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.L (xxx).L,An */
void REGPARAM2 op_91f9_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_ilong_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBA.L (d16,PC),An */
void REGPARAM2 op_91fa_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.L (d8,PC,Xn),An */
void REGPARAM2 op_91fb_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = get_disp_ea_020_mmu030c(tmppc, 0);
	uae_s32 src = get_long_mmu030c_state(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.L #<data>.L,An */
void REGPARAM2 op_91fc_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_ilong_mmu030c_state(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(6);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.B Dn,Dn */
void REGPARAM2 op_b000_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.B (An),Dn */
void REGPARAM2 op_b010_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.B (An)+,Dn */
void REGPARAM2 op_b018_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	mmufixup[0].reg = srcreg | 0x100;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CMP.B -(An),Dn */
void REGPARAM2 op_b020_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	mmufixup[0].reg = srcreg | 0x200;
	mmufixup[0].value = m68k_areg(regs, srcreg);
	uae_s8 src = get_byte_mmu030c_state(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	mmufixup[0].reg = -1;
	return;
}
/* 2 0,0   */

/* CMP.B (d16,An),Dn */
void REGPARAM2 op_b028_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_iword_mmu030c_state(2);
	uae_s8 src = get_byte_mmu030c_state(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_iword_mmu030c_opcode_state(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B (d8,An,Xn),Dn */
void REGPARAM2 op_b030_35_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fea */
	uaecp