#include "main.h"
#include "sysdeps.h"
#include "hatari-glue.h"
#include "maccess.h"
#include "memory.h"
#include "custom.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#include "debugmem.h"
#define SET_ALWAYS_CFLG(x) SET_CFLG(x)
#define SET_ALWAYS_NFLG(x) SET_NFLG(x)
/* OR.B #<data>.B,Dn */
void REGPARAM2 op_0000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An) */
void REGPARAM2 op_0010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An)+ */
void REGPARAM2 op_0018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,-(An) */
void REGPARAM2 op_0020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B #<data>.B,(d16,An) */
void REGPARAM2 op_0028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 4 2,0   */

/* OR.B #<data>.B,(xxx).W */
void REGPARAM2 op_0038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.B #<data>.B,(xxx).L */
void REGPARAM2 op_0039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ORSR.B #<data>.W */
void REGPARAM2 op_003c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	MakeSR();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,Dn */
void REGPARAM2 op_0040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An) */
void REGPARAM2 op_0050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An)+ */
void REGPARAM2 op_0058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,-(An) */
void REGPARAM2 op_0060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W #<data>.W,(d16,An) */
void REGPARAM2 op_0068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 4 2,0   */

/* OR.W #<data>.W,(xxx).W */
void REGPARAM2 op_0078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.W #<data>.W,(xxx).L */
void REGPARAM2 op_0079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ORSR.W #<data>.W */
void REGPARAM2 op_007c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if(regs.t0) check_t0_trace();
	regs.sr |= src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* OR.L #<data>.L,Dn */
void REGPARAM2 op_0080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An) */
void REGPARAM2 op_0090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An)+ */
void REGPARAM2 op_0098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,-(An) */
void REGPARAM2 op_00a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.L #<data>.L,(d16,An) */
void REGPARAM2 op_00a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* OR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_00b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 6 2,0   */

/* OR.L #<data>.L,(xxx).W */
void REGPARAM2 op_00b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* OR.L #<data>.L,(xxx).L */
void REGPARAM2 op_00b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* op H:0,T:1,C:-1 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* CHK2.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* CHK2.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 8 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_00fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* BTST.L Dn,Dn */
void REGPARAM2 op_0100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPMR.W (d16,An),Dn */
void REGPARAM2 op_0108_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* OP zero */
	uae_u16 val  = (x_get_byte(mempa) & 0xff) << 8;
	val |= (x_get_byte(mempa + 2) & 0xff);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(An) */
void REGPARAM2 op_0110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BTST.B Dn,(An)+ */
void REGPARAM2 op_0118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BTST.B Dn,-(An) */
void REGPARAM2 op_0120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BTST.B Dn,(d16,An) */
void REGPARAM2 op_0128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,An,Xn) */
void REGPARAM2 op_0130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 2 2,0   */

/* BTST.B Dn,(xxx).W */
void REGPARAM2 op_0138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(xxx).L */
void REGPARAM2 op_0139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B Dn,(d16,PC) */
void REGPARAM2 op_013a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_getpci() + 2;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,PC,Xn) */
void REGPARAM2 op_013b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 2 2,0   */

/* BTST.B Dn,#<data>.B */
void REGPARAM2 op_013c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = (uae_u8)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.L Dn,Dn */
void REGPARAM2 op_0140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPMR.L (d16,An),Dn */
void REGPARAM2 op_0148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* OP zero */
	uae_u32 val  = (x_get_byte(mempa) & 0xff) << 24;
	val |= (x_get_byte(mempa + 2) & 0xff) << 16;
	val |= (x_get_byte(mempa + 4) & 0xff) << 8;
	val |= (x_get_byte(mempa + 6) & 0xff);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B Dn,(An) */
void REGPARAM2 op_0150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BCHG.B Dn,(An)+ */
void REGPARAM2 op_0158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BCHG.B Dn,-(An) */
void REGPARAM2 op_0160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BCHG.B Dn,(d16,An) */
void REGPARAM2 op_0168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B Dn,(d8,An,Xn) */
void REGPARAM2 op_0170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	return;
}
/* 2 2,0   */

/* BCHG.B Dn,(xxx).W */
void REGPARAM2 op_0178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B Dn,(xxx).L */
void REGPARAM2 op_0179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BCLR.L Dn,Dn */
void REGPARAM2 op_0180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPRM.W Dn,(d16,An) */
void REGPARAM2 op_0188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	x_put_byte(mempa, src >> 8);
	x_put_byte(mempa + 2, src); 
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B Dn,(An) */
void REGPARAM2 op_0190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BCLR.B Dn,(An)+ */
void REGPARAM2 op_0198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BCLR.B Dn,-(An) */
void REGPARAM2 op_01a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BCLR.B Dn,(d16,An) */
void REGPARAM2 op_01a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B Dn,(d8,An,Xn) */
void REGPARAM2 op_01b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	return;
}
/* 2 2,0   */

/* BCLR.B Dn,(xxx).W */
void REGPARAM2 op_01b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B Dn,(xxx).L */
void REGPARAM2 op_01b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BSET.L Dn,Dn */
void REGPARAM2 op_01c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVPRM.L Dn,(d16,An) */
void REGPARAM2 op_01c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	x_put_byte(mempa, src >> 24);
	x_put_byte(mempa + 2, src >> 16);
	x_put_byte(mempa + 4, src >> 8);
	x_put_byte(mempa + 6, src); 
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B Dn,(An) */
void REGPARAM2 op_01d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BSET.B Dn,(An)+ */
void REGPARAM2 op_01d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BSET.B Dn,-(An) */
void REGPARAM2 op_01e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BSET.B Dn,(d16,An) */
void REGPARAM2 op_01e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B Dn,(d8,An,Xn) */
void REGPARAM2 op_01f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	return;
}
/* 2 2,0   */

/* BSET.B Dn,(xxx).W */
void REGPARAM2 op_01f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B Dn,(xxx).L */
void REGPARAM2 op_01f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.B #<data>.B,Dn */
void REGPARAM2 op_0200_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An) */
void REGPARAM2 op_0210_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An)+ */
void REGPARAM2 op_0218_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,-(An) */
void REGPARAM2 op_0220_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B #<data>.B,(d16,An) */
void REGPARAM2 op_0228_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0230_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 4 2,0   */

/* AND.B #<data>.B,(xxx).W */
void REGPARAM2 op_0238_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.B #<data>.B,(xxx).L */
void REGPARAM2 op_0239_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ANDSR.B #<data>.W */
void REGPARAM2 op_023c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	MakeSR();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	src &= 0xFF;
	src |= 0xff00;
	regs.sr &= src;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,Dn */
void REGPARAM2 op_0240_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An) */
void REGPARAM2 op_0250_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An)+ */
void REGPARAM2 op_0258_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,-(An) */
void REGPARAM2 op_0260_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W #<data>.W,(d16,An) */
void REGPARAM2 op_0268_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0270_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 4 2,0   */

/* AND.W #<data>.W,(xxx).W */
void REGPARAM2 op_0278_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.W #<data>.W,(xxx).L */
void REGPARAM2 op_0279_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ANDSR.W #<data>.W */
void REGPARAM2 op_027c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if(regs.t0) check_t0_trace();
	regs.sr &= src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* AND.L #<data>.L,Dn */
void REGPARAM2 op_0280_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An) */
void REGPARAM2 op_0290_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An)+ */
void REGPARAM2 op_0298_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,-(An) */
void REGPARAM2 op_02a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.L #<data>.L,(d16,An) */
void REGPARAM2 op_02a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* AND.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_02b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 6 2,0   */

/* AND.L #<data>.L,(xxx).W */
void REGPARAM2 op_02b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* AND.L #<data>.L,(xxx).L */
void REGPARAM2 op_02b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* CHK2.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* CHK2.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 8 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_02fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* SUB.B #<data>.B,Dn */
void REGPARAM2 op_0400_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An) */
void REGPARAM2 op_0410_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An)+ */
void REGPARAM2 op_0418_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,-(An) */
void REGPARAM2 op_0420_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(d16,An) */
void REGPARAM2 op_0428_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0430_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	return;
}
/* 4 2,0   */

/* SUB.B #<data>.B,(xxx).W */
void REGPARAM2 op_0438_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(xxx).L */
void REGPARAM2 op_0439_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* SUB.W #<data>.W,Dn */
void REGPARAM2 op_0440_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An) */
void REGPARAM2 op_0450_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An)+ */
void REGPARAM2 op_0458_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,-(An) */
void REGPARAM2 op_0460_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(d16,An) */
void REGPARAM2 op_0468_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0470_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	return;
}
/* 4 2,0   */

/* SUB.W #<data>.W,(xxx).W */
void REGPARAM2 op_0478_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(xxx).L */
void REGPARAM2 op_0479_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* SUB.L #<data>.L,Dn */
void REGPARAM2 op_0480_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An) */
void REGPARAM2 op_0490_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An)+ */
void REGPARAM2 op_0498_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,-(An) */
void REGPARAM2 op_04a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(d16,An) */
void REGPARAM2 op_04a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_04b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	return;
}
/* 6 2,0   */

/* SUB.L #<data>.L,(xxx).W */
void REGPARAM2 op_04b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(xxx).L */
void REGPARAM2 op_04b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* CHK2.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* CHK2.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 8 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_04fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	/* OP zero */
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* ADD.B #<data>.B,Dn */
void REGPARAM2 op_0600_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An) */
void REGPARAM2 op_0610_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An)+ */
void REGPARAM2 op_0618_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,-(An) */
void REGPARAM2 op_0620_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(d16,An) */
void REGPARAM2 op_0628_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0630_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	return;
}
/* 4 2,0   */

/* ADD.B #<data>.B,(xxx).W */
void REGPARAM2 op_0638_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(xxx).L */
void REGPARAM2 op_0639_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ADD.W #<data>.W,Dn */
void REGPARAM2 op_0640_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An) */
void REGPARAM2 op_0650_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An)+ */
void REGPARAM2 op_0658_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,-(An) */
void REGPARAM2 op_0660_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(d16,An) */
void REGPARAM2 op_0668_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0670_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	return;
}
/* 4 2,0   */

/* ADD.W #<data>.W,(xxx).W */
void REGPARAM2 op_0678_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(xxx).L */
void REGPARAM2 op_0679_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ADD.L #<data>.L,Dn */
void REGPARAM2 op_0680_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An) */
void REGPARAM2 op_0690_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An)+ */
void REGPARAM2 op_0698_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,-(An) */
void REGPARAM2 op_06a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(d16,An) */
void REGPARAM2 op_06a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_06b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	return;
}
/* 6 2,0   */

/* ADD.L #<data>.L,(xxx).W */
void REGPARAM2 op_06b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(xxx).L */
void REGPARAM2 op_06b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* RTM.L Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* RTM.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_06fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	m68k_incpci(2);
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* BTST.L #<data>.W,Dn */
void REGPARAM2 op_0800_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* No EA */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An) */
void REGPARAM2 op_0810_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An)+ */
void REGPARAM2 op_0818_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,-(An) */
void REGPARAM2 op_0820_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(d16,An) */
void REGPARAM2 op_0828_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0830_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 4 2,0   */

/* BTST.B #<data>.W,(xxx).W */
void REGPARAM2 op_0838_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(xxx).L */
void REGPARAM2 op_0839_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* BTST.B #<data>.W,(d16,PC) */
void REGPARAM2 op_083a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,PC,Xn) */
void REGPARAM2 op_083b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	return;
}
/* 4 2,0   */

/* BCHG.L #<data>.W,Dn */
void REGPARAM2 op_0840_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* No EA */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An) */
void REGPARAM2 op_0850_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An)+ */
void REGPARAM2 op_0858_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,-(An) */
void REGPARAM2 op_0860_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(d16,An) */
void REGPARAM2 op_0868_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0870_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	return;
}
/* 4 2,0   */

/* BCHG.B #<data>.W,(xxx).W */
void REGPARAM2 op_0878_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(xxx).L */
void REGPARAM2 op_0879_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	x_put_byte(dsta, dst);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* BCLR.L #<data>.W,Dn */
void REGPARAM2 op_0880_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* No EA */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An) */
void REGPARAM2 op_0890_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An)+ */
void REGPARAM2 op_0898_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,-(An) */
void REGPARAM2 op_08a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(d16,An) */
void REGPARAM2 op_08a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_08b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	return;
}
/* 4 2,0   */

/* BCLR.B #<data>.W,(xxx).W */
void REGPARAM2 op_08b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(xxx).L */
void REGPARAM2 op_08b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* BSET.L #<data>.W,Dn */
void REGPARAM2 op_08c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* No EA */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:6,T:0,C:-6 */
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An) */
void REGPARAM2 op_08d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An)+ */
void REGPARAM2 op_08d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,-(An) */
void REGPARAM2 op_08e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(d16,An) */
void REGPARAM2 op_08e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_08f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	return;
}
/* 4 2,0   */

/* BSET.B #<data>.W,(xxx).W */
void REGPARAM2 op_08f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(xxx).L */
void REGPARAM2 op_08f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	x_put_byte(dsta, dst);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* EOR.B #<data>.B,Dn */
void REGPARAM2 op_0a00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An) */
void REGPARAM2 op_0a10_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An)+ */
void REGPARAM2 op_0a18_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,-(An) */
void REGPARAM2 op_0a20_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(d16,An) */
void REGPARAM2 op_0a28_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0a30_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 4 2,0   */

/* EOR.B #<data>.B,(xxx).W */
void REGPARAM2 op_0a38_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(xxx).L */
void REGPARAM2 op_0a39_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* EORSR.B #<data>.W */
void REGPARAM2 op_0a3c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	MakeSR();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,Dn */
void REGPARAM2 op_0a40_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An) */
void REGPARAM2 op_0a50_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An)+ */
void REGPARAM2 op_0a58_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,-(An) */
void REGPARAM2 op_0a60_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(d16,An) */
void REGPARAM2 op_0a68_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0a70_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 4 2,0   */

/* EOR.W #<data>.W,(xxx).W */
void REGPARAM2 op_0a78_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(xxx).L */
void REGPARAM2 op_0a79_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* EORSR.W #<data>.W */
void REGPARAM2 op_0a7c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	if (!regs.s) {
		Exception(8);
		return;
	}
	MakeSR();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if(regs.t0) check_t0_trace();
	regs.sr ^= src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* EOR.L #<data>.L,Dn */
void REGPARAM2 op_0a80_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An) */
void REGPARAM2 op_0a90_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An)+ */
void REGPARAM2 op_0a98_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,-(An) */
void REGPARAM2 op_0aa0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(d16,An) */
void REGPARAM2 op_0aa8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_0ab0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 6 2,0   */

/* EOR.L #<data>.L,(xxx).W */
void REGPARAM2 op_0ab8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(xxx).L */
void REGPARAM2 op_0ab9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* op H:0,T:1,C:-1 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* CAS.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ad0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ad8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ae0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ae8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(6);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0af0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(0);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	return;
}
/* 4 2,0   */

#endif
/* CAS.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0af8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(6);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0af9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(8);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CMP.B #<data>.B,Dn */
void REGPARAM2 op_0c00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An) */
void REGPARAM2 op_0c10_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An)+ */
void REGPARAM2 op_0c18_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:1,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,-(An) */
void REGPARAM2 op_0c20_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(d16,An) */
void REGPARAM2 op_0c28_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_0c30_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

/* CMP.B #<data>.B,(xxx).W */
void REGPARAM2 op_0c38_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(xxx).L */
void REGPARAM2 op_0c39_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:3,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.B #<data>.B,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c3a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CMP.B #<data>.B,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c3b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 dst = x_get_byte(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

#endif
/* CMP.W #<data>.W,Dn */
void REGPARAM2 op_0c40_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2+2=4,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An) */
void REGPARAM2 op_0c50_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An)+ */
void REGPARAM2 op_0c58_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:1,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,-(An) */
void REGPARAM2 op_0c60_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(d16,An) */
void REGPARAM2 op_0c68_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_0c70_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

/* CMP.W #<data>.W,(xxx).W */
void REGPARAM2 op_0c78_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(xxx).L */
void REGPARAM2 op_0c79_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:3,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c7a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CMP.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0c7b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 dst = x_get_word(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 4 2,0   */

#endif
/* CMP.L #<data>.L,Dn */
void REGPARAM2 op_0c80_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:4+2=6,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2-,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An) */
void REGPARAM2 op_0c90_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An)+ */
void REGPARAM2 op_0c98_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:1,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,-(An) */
void REGPARAM2 op_0ca0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(d16,An) */
void REGPARAM2 op_0ca8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_0cb0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 6 2,0   */

/* CMP.L #<data>.L,(xxx).W */
void REGPARAM2 op_0cb8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:6,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(xxx).L */
void REGPARAM2 op_0cb9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	/* ea H:5,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* CMP.L #<data>.L,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 6;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CMP.L #<data>.L,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cbb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	/* ea H:8,T:2,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 dst = x_get_long(dsta);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 6 2,0   */

#endif
/* CAS.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cd0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cd8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ce0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ce8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(6);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cf0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(0);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	return;
}
/* 4 2,0   */

#endif
/* CAS.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cf8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(6);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cf9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(8);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CAS2.W #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0cfc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	uae_s32 extra;
	extra = get_long_ce030_prefetch(2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u16 dst1 = x_get_word(rn1), dst2 = x_get_word(rn2);
	uae_u32 newv = ((uae_u16)(dst1)) - ((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s16)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s16)(dst1)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u16)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u16)(dst2)) - ((uae_u16)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s16)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s16)(dst2)) < 0;
		int flgn = ((uae_s16)(newv)) < 0;
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u16)(m68k_dreg(regs, extra & 7))) > ((uae_u16)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			x_put_word(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			x_put_word(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 0) & 7) = (m68k_dreg(regs, (extra >> 0) & 7) & ~0xffff) | (dst2 & 0xffff);
		m68k_dreg(regs, (extra >> 16) & 7) = (m68k_dreg(regs, (extra >> 16) & 7) & ~0xffff) | (dst1 & 0xffff);
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e10_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc_nommu_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e18_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc_nommu_get_byte(srca);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e20_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		m68k_areg(regs, dstreg) = dsta;
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		uae_s8 src = sfc_nommu_get_byte(srca);
		m68k_areg(regs, dstreg) = srca;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e28_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(6);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		uae_s8 src = sfc_nommu_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e30_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(0);
		dfc_nommu_put_byte(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
		uae_s8 src = sfc_nommu_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 2,2   */

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e38_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(6);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		uae_s8 src = sfc_nommu_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e39_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_long_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(8);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_long_ce030_prefetch(4);
		uae_s8 src = sfc_nommu_get_byte(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(8);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 8 0,0   */

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e50_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s16 src = sfc_nommu_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e58_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 2;
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s16 src = sfc_nommu_get_word(srca);
		m68k_areg(regs, dstreg) += 2;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e60_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 2;
		m68k_areg(regs, dstreg) = dsta;
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 2;
		uae_s16 src = sfc_nommu_get_word(srca);
		m68k_areg(regs, dstreg) = srca;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e68_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(6);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		uae_s16 src = sfc_nommu_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e70_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(0);
		dfc_nommu_put_word(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
		uae_s16 src = sfc_nommu_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 2,2   */

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e78_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(6);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		uae_s16 src = sfc_nommu_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e79_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_long_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(8);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_long_ce030_prefetch(4);
		uae_s16 src = sfc_nommu_get_word(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(8);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 8 0,0   */

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e90_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s32 src = sfc_nommu_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0e98_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 4;
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s32 src = sfc_nommu_get_long(srca);
		m68k_areg(regs, dstreg) += 4;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ea0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 4;
		m68k_areg(regs, dstreg) = dsta;
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 4;
		uae_s32 src = sfc_nommu_get_long(srca);
		m68k_areg(regs, dstreg) = srca;
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ea8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(6);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		uae_s32 src = sfc_nommu_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(0);
		dfc_nommu_put_long(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
		uae_s32 src = sfc_nommu_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 4 2,2   */

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(6);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
		uae_s32 src = sfc_nommu_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0eb9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* OP zero */
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_long_ce030_prefetch(4);
		/* OP zero */
		regs.irc = get_word_ce030_prefetch_opcode(8);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_long_ce030_prefetch(4);
		uae_s32 src = sfc_nommu_get_long(srca);
		/* OP zero */
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(8);
		regs.irc = get_word_ce030_prefetch_opcode(0);
	}
	return;
}
/* 8 0,0   */

#endif
/* CAS.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ed0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ed8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ee0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(4);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ee8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(6);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(6);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ef0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(0);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(0);
		m68k_dreg(regs, rc) = dst;
	}
	return;
}
/* 4 2,0   */

#endif
/* CAS.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ef8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(6);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(6);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* CAS.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0ef9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* OP zero */
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_ce030_prefetch_opcode(8);
	} else {
		regs.irc = get_word_ce030_prefetch_opcode(8);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

#endif
/* CAS2.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_0efc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	uae_s32 extra;
	extra = get_long_ce030_prefetch(2);
	/* OP zero */
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u32 dst1 = x_get_long(rn1), dst2 = x_get_long(rn2);
	uae_u32 newv = ((uae_u32)(dst1)) - ((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s32)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s32)(dst1)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u32)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u32)(dst2)) - ((uae_u32)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s32)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s32)(dst2)) < 0;
		int flgn = ((uae_s32)(newv)) < 0;
		SET_ZFLG(((uae_s32)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u32)(m68k_dreg(regs, extra & 7))) > ((uae_u32)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			x_put_long(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			x_put_long(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 0) & 7) = dst2;
		m68k_dreg(regs, (extra >> 16) & 7) = dst1;
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* MOVE.B Dn,Dn */
void REGPARAM2 op_1000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An),Dn */
void REGPARAM2 op_1010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,Dn */
void REGPARAM2 op_1018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),Dn */
void REGPARAM2 op_1020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),Dn */
void REGPARAM2 op_1028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),Dn */
void REGPARAM2 op_1030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,Dn */
void REGPARAM2 op_1038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,Dn */
void REGPARAM2 op_1039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),Dn */
void REGPARAM2 op_103a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),Dn */
void REGPARAM2 op_103b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,Dn */
void REGPARAM2 op_103c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,(An) */
void REGPARAM2 op_1080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An),(An) */
void REGPARAM2 op_1090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An) */
void REGPARAM2 op_1098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),(An) */
void REGPARAM2 op_10a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An) */
void REGPARAM2 op_10a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An) */
void REGPARAM2 op_10b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An) */
void REGPARAM2 op_10b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An) */
void REGPARAM2 op_10b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An) */
void REGPARAM2 op_10ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An) */
void REGPARAM2 op_10bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An) */
void REGPARAM2 op_10bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,(An)+ */
void REGPARAM2 op_10c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An),(An)+ */
void REGPARAM2 op_10d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An)+ */
void REGPARAM2 op_10d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),(An)+ */
void REGPARAM2 op_10e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An)+ */
void REGPARAM2 op_10e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An)+ */
void REGPARAM2 op_10f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An)+ */
void REGPARAM2 op_10f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An)+ */
void REGPARAM2 op_10f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An)+ */
void REGPARAM2 op_10fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An)+ */
void REGPARAM2 op_10fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An)+ */
void REGPARAM2 op_10fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,-(An) */
void REGPARAM2 op_1100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An),-(An) */
void REGPARAM2 op_1110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (An)+,-(An) */
void REGPARAM2 op_1118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B -(An),-(An) */
void REGPARAM2 op_1120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.B (d16,An),-(An) */
void REGPARAM2 op_1128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),-(An) */
void REGPARAM2 op_1130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,-(An) */
void REGPARAM2 op_1138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,-(An) */
void REGPARAM2 op_1139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),-(An) */
void REGPARAM2 op_113a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),-(An) */
void REGPARAM2 op_113b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,-(An) */
void REGPARAM2 op_113c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B Dn,(d16,An) */
void REGPARAM2 op_1140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (An),(d16,An) */
void REGPARAM2 op_1150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (An)+,(d16,An) */
void REGPARAM2 op_1158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B -(An),(d16,An) */
void REGPARAM2 op_1160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(d16,An) */
void REGPARAM2 op_1168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(d16,An) */
void REGPARAM2 op_1170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(d16,An) */
void REGPARAM2 op_1178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(d16,An) */
void REGPARAM2 op_1179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(d16,An) */
void REGPARAM2 op_117a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_117b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(d16,An) */
void REGPARAM2 op_117c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B Dn,(d8,An,Xn) */
void REGPARAM2 op_1180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (An),(d8,An,Xn) */
void REGPARAM2 op_1190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (An)+,(d8,An,Xn) */
void REGPARAM2 op_1198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B -(An),(d8,An,Xn) */
void REGPARAM2 op_11a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.B (d16,An),(d8,An,Xn) */
void REGPARAM2 op_11a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_11b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.B (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_11b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_11b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.B (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_11ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_11bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.B #<data>.B,(d8,An,Xn) */
void REGPARAM2 op_11bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.B Dn,(xxx).W */
void REGPARAM2 op_11c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (An),(xxx).W */
void REGPARAM2 op_11d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (An)+,(xxx).W */
void REGPARAM2 op_11d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B -(An),(xxx).W */
void REGPARAM2 op_11e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(xxx).W */
void REGPARAM2 op_11e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).W */
void REGPARAM2 op_11f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(xxx).W */
void REGPARAM2 op_11f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(xxx).W */
void REGPARAM2 op_11f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(xxx).W */
void REGPARAM2 op_11fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_11fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(xxx).W */
void REGPARAM2 op_11fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B Dn,(xxx).L */
void REGPARAM2 op_13c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (An),(xxx).L */
void REGPARAM2 op_13d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (An)+,(xxx).L */
void REGPARAM2 op_13d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B -(An),(xxx).L */
void REGPARAM2 op_13e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.B (d16,An),(xxx).L */
void REGPARAM2 op_13e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).L */
void REGPARAM2 op_13f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 6 6,0   */

/* MOVE.B (xxx).W,(xxx).L */
void REGPARAM2 op_13f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.B (xxx).L,(xxx).L */
void REGPARAM2 op_13f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* MOVE.B (d16,PC),(xxx).L */
void REGPARAM2 op_13fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_13fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 6 6,0   */

/* MOVE.B #<data>.B,(xxx).L */
void REGPARAM2 op_13fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L Dn,Dn */
void REGPARAM2 op_2000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L An,Dn */
void REGPARAM2 op_2008_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An),Dn */
void REGPARAM2 op_2010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,Dn */
void REGPARAM2 op_2018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),Dn */
void REGPARAM2 op_2020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),Dn */
void REGPARAM2 op_2028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),Dn */
void REGPARAM2 op_2030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,Dn */
void REGPARAM2 op_2038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,Dn */
void REGPARAM2 op_2039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),Dn */
void REGPARAM2 op_203a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),Dn */
void REGPARAM2 op_203b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,Dn */
void REGPARAM2 op_203c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVEA.L Dn,An */
void REGPARAM2 op_2040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L An,An */
void REGPARAM2 op_2048_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s32 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L (An),An */
void REGPARAM2 op_2050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L (An)+,An */
void REGPARAM2 op_2058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L -(An),An */
void REGPARAM2 op_2060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.L (d16,An),An */
void REGPARAM2 op_2068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.L (d8,An,Xn),An */
void REGPARAM2 op_2070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVEA.L (xxx).W,An */
void REGPARAM2 op_2078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.L (xxx).L,An */
void REGPARAM2 op_2079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVEA.L (d16,PC),An */
void REGPARAM2 op_207a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.L (d8,PC,Xn),An */
void REGPARAM2 op_207b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* MOVEA.L #<data>.L,An */
void REGPARAM2 op_207c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,(An) */
void REGPARAM2 op_2080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L An,(An) */
void REGPARAM2 op_2088_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An),(An) */
void REGPARAM2 op_2090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An) */
void REGPARAM2 op_2098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),(An) */
void REGPARAM2 op_20a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An) */
void REGPARAM2 op_20a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An) */
void REGPARAM2 op_20b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An) */
void REGPARAM2 op_20b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An) */
void REGPARAM2 op_20b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An) */
void REGPARAM2 op_20ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An) */
void REGPARAM2 op_20bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An) */
void REGPARAM2 op_20bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,(An)+ */
void REGPARAM2 op_20c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L An,(An)+ */
void REGPARAM2 op_20c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An),(An)+ */
void REGPARAM2 op_20d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An)+ */
void REGPARAM2 op_20d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),(An)+ */
void REGPARAM2 op_20e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An)+ */
void REGPARAM2 op_20e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An)+ */
void REGPARAM2 op_20f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An)+ */
void REGPARAM2 op_20f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An)+ */
void REGPARAM2 op_20f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An)+ */
void REGPARAM2 op_20fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An)+ */
void REGPARAM2 op_20fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An)+ */
void REGPARAM2 op_20fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,-(An) */
void REGPARAM2 op_2100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L An,-(An) */
void REGPARAM2 op_2108_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An),-(An) */
void REGPARAM2 op_2110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (An)+,-(An) */
void REGPARAM2 op_2118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L -(An),-(An) */
void REGPARAM2 op_2120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.L (d16,An),-(An) */
void REGPARAM2 op_2128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),-(An) */
void REGPARAM2 op_2130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,-(An) */
void REGPARAM2 op_2138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,-(An) */
void REGPARAM2 op_2139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),-(An) */
void REGPARAM2 op_213a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),-(An) */
void REGPARAM2 op_213b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,-(An) */
void REGPARAM2 op_213c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L Dn,(d16,An) */
void REGPARAM2 op_2140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L An,(d16,An) */
void REGPARAM2 op_2148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (An),(d16,An) */
void REGPARAM2 op_2150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (An)+,(d16,An) */
void REGPARAM2 op_2158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L -(An),(d16,An) */
void REGPARAM2 op_2160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(d16,An) */
void REGPARAM2 op_2168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(d16,An) */
void REGPARAM2 op_2170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(d16,An) */
void REGPARAM2 op_2178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(d16,An) */
void REGPARAM2 op_2179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(d16,An) */
void REGPARAM2 op_217a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_217b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(d16,An) */
void REGPARAM2 op_217c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L Dn,(d8,An,Xn) */
void REGPARAM2 op_2180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L An,(d8,An,Xn) */
void REGPARAM2 op_2188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (An),(d8,An,Xn) */
void REGPARAM2 op_2190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (An)+,(d8,An,Xn) */
void REGPARAM2 op_2198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L -(An),(d8,An,Xn) */
void REGPARAM2 op_21a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.L (d16,An),(d8,An,Xn) */
void REGPARAM2 op_21a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_21b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.L (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_21b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.L (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_21b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.L (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_21ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_21bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.L #<data>.L,(d8,An,Xn) */
void REGPARAM2 op_21bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.L Dn,(xxx).W */
void REGPARAM2 op_21c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L An,(xxx).W */
void REGPARAM2 op_21c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (An),(xxx).W */
void REGPARAM2 op_21d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (An)+,(xxx).W */
void REGPARAM2 op_21d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L -(An),(xxx).W */
void REGPARAM2 op_21e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(xxx).W */
void REGPARAM2 op_21e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).W */
void REGPARAM2 op_21f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(xxx).W */
void REGPARAM2 op_21f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(xxx).W */
void REGPARAM2 op_21f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(xxx).W */
void REGPARAM2 op_21fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_21fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(xxx).W */
void REGPARAM2 op_21fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L Dn,(xxx).L */
void REGPARAM2 op_23c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L An,(xxx).L */
void REGPARAM2 op_23c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (An),(xxx).L */
void REGPARAM2 op_23d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (An)+,(xxx).L */
void REGPARAM2 op_23d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L -(An),(xxx).L */
void REGPARAM2 op_23e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.L (d16,An),(xxx).L */
void REGPARAM2 op_23e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).L */
void REGPARAM2 op_23f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 6 6,0   */

/* MOVE.L (xxx).W,(xxx).L */
void REGPARAM2 op_23f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L (xxx).L,(xxx).L */
void REGPARAM2 op_23f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* MOVE.L (d16,PC),(xxx).L */
void REGPARAM2 op_23fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_23fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 6 6,0   */

/* MOVE.L #<data>.L,(xxx).L */
void REGPARAM2 op_23fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:0,C:0 fiea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* MOVE.W Dn,Dn */
void REGPARAM2 op_3000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W An,Dn */
void REGPARAM2 op_3008_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An),Dn */
void REGPARAM2 op_3010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,Dn */
void REGPARAM2 op_3018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),Dn */
void REGPARAM2 op_3020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),Dn */
void REGPARAM2 op_3028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),Dn */
void REGPARAM2 op_3030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,Dn */
void REGPARAM2 op_3038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,Dn */
void REGPARAM2 op_3039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),Dn */
void REGPARAM2 op_303a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),Dn */
void REGPARAM2 op_303b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,Dn */
void REGPARAM2 op_303c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W Dn,An */
void REGPARAM2 op_3040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W An,An */
void REGPARAM2 op_3048_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	uae_s16 src = m68k_areg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W (An),An */
void REGPARAM2 op_3050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W (An)+,An */
void REGPARAM2 op_3058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W -(An),An */
void REGPARAM2 op_3060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVEA.W (d16,An),An */
void REGPARAM2 op_3068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W (d8,An,Xn),An */
void REGPARAM2 op_3070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return;
}
/* 2 2,0   */

/* MOVEA.W (xxx).W,An */
void REGPARAM2 op_3078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W (xxx).L,An */
void REGPARAM2 op_3079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVEA.W (d16,PC),An */
void REGPARAM2 op_307a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVEA.W (d8,PC,Xn),An */
void REGPARAM2 op_307b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return;
}
/* 2 2,0   */

/* MOVEA.W #<data>.W,An */
void REGPARAM2 op_307c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src = (uae_s32)(uae_s16)src;
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,(An) */
void REGPARAM2 op_3080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W An,(An) */
void REGPARAM2 op_3088_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An),(An) */
void REGPARAM2 op_3090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An) */
void REGPARAM2 op_3098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),(An) */
void REGPARAM2 op_30a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An) */
void REGPARAM2 op_30a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An) */
void REGPARAM2 op_30b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An) */
void REGPARAM2 op_30b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An) */
void REGPARAM2 op_30b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An) */
void REGPARAM2 op_30ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An) */
void REGPARAM2 op_30bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An) */
void REGPARAM2 op_30bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,(An)+ */
void REGPARAM2 op_30c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W An,(An)+ */
void REGPARAM2 op_30c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An),(An)+ */
void REGPARAM2 op_30d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An)+ */
void REGPARAM2 op_30d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),(An)+ */
void REGPARAM2 op_30e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An)+ */
void REGPARAM2 op_30e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An)+ */
void REGPARAM2 op_30f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An)+ */
void REGPARAM2 op_30f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An)+ */
void REGPARAM2 op_30f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An)+ */
void REGPARAM2 op_30fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An)+ */
void REGPARAM2 op_30fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An)+ */
void REGPARAM2 op_30fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,-(An) */
void REGPARAM2 op_3100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W An,-(An) */
void REGPARAM2 op_3108_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:2,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An),-(An) */
void REGPARAM2 op_3110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (An)+,-(An) */
void REGPARAM2 op_3118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W -(An),-(An) */
void REGPARAM2 op_3120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MOVE.W (d16,An),-(An) */
void REGPARAM2 op_3128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),-(An) */
void REGPARAM2 op_3130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,-(An) */
void REGPARAM2 op_3138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,-(An) */
void REGPARAM2 op_3139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),-(An) */
void REGPARAM2 op_313a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),-(An) */
void REGPARAM2 op_313b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,-(An) */
void REGPARAM2 op_313c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W Dn,(d16,An) */
void REGPARAM2 op_3140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W An,(d16,An) */
void REGPARAM2 op_3148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (An),(d16,An) */
void REGPARAM2 op_3150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (An)+,(d16,An) */
void REGPARAM2 op_3158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W -(An),(d16,An) */
void REGPARAM2 op_3160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(d16,An) */
void REGPARAM2 op_3168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(d16,An) */
void REGPARAM2 op_3170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(d16,An) */
void REGPARAM2 op_3178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(d16,An) */
void REGPARAM2 op_3179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(d16,An) */
void REGPARAM2 op_317a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(d16,An) */
void REGPARAM2 op_317b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(d16,An) */
void REGPARAM2 op_317c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W Dn,(d8,An,Xn) */
void REGPARAM2 op_3180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W An,(d8,An,Xn) */
void REGPARAM2 op_3188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (An),(d8,An,Xn) */
void REGPARAM2 op_3190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (An)+,(d8,An,Xn) */
void REGPARAM2 op_3198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W -(An),(d8,An,Xn) */
void REGPARAM2 op_31a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* MOVE.W (d16,An),(d8,An,Xn) */
void REGPARAM2 op_31a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
void REGPARAM2 op_31b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.W (xxx).W,(d8,An,Xn) */
void REGPARAM2 op_31b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W (xxx).L,(d8,An,Xn) */
void REGPARAM2 op_31b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 6 2,0   */

/* MOVE.W (d16,PC),(d8,An,Xn) */
void REGPARAM2 op_31ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
void REGPARAM2 op_31bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,2   */

/* MOVE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_31bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:4,T:0,C:-4 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 4 2,0   */

/* MOVE.W Dn,(xxx).W */
void REGPARAM2 op_31c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W An,(xxx).W */
void REGPARAM2 op_31c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (An),(xxx).W */
void REGPARAM2 op_31d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (An)+,(xxx).W */
void REGPARAM2 op_31d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W -(An),(xxx).W */
void REGPARAM2 op_31e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(xxx).W */
void REGPARAM2 op_31e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).W */
void REGPARAM2 op_31f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(xxx).W */
void REGPARAM2 op_31f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(xxx).W */
void REGPARAM2 op_31f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(xxx).W */
void REGPARAM2 op_31fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).W */
void REGPARAM2 op_31fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(xxx).W */
void REGPARAM2 op_31fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W Dn,(xxx).L */
void REGPARAM2 op_33c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W An,(xxx).L */
void REGPARAM2 op_33c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (An),(xxx).L */
void REGPARAM2 op_33d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (An)+,(xxx).L */
void REGPARAM2 op_33d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W -(An),(xxx).L */
void REGPARAM2 op_33e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MOVE.W (d16,An),(xxx).L */
void REGPARAM2 op_33e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).L */
void REGPARAM2 op_33f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 6 6,0   */

/* MOVE.W (xxx).W,(xxx).L */
void REGPARAM2 op_33f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.W (xxx).L,(xxx).L */
void REGPARAM2 op_33f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(6);
	regs.irc = get_word_ce030_prefetch_opcode(10);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(10);
	return;
}
/* 10 0,0   */

/* MOVE.W (d16,PC),(xxx).L */
void REGPARAM2 op_33fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).L */
void REGPARAM2 op_33fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 6 6,0   */

/* MOVE.W #<data>.W,(xxx).L */
void REGPARAM2 op_33fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	/* ea H:2,T:0,C:0 fiea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	regs.irc = get_word_ce030_prefetch_opcode(8);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* NEGX.B Dn */
void REGPARAM2 op_4000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.B (An) */
void REGPARAM2 op_4010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.B (An)+ */
void REGPARAM2 op_4018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.B -(An) */
void REGPARAM2 op_4020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.B (d16,An) */
void REGPARAM2 op_4028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEGX.B (d8,An,Xn) */
void REGPARAM2 op_4030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	x_put_byte(srca, newv);
	return;
}
/* 2 2,0   */

/* NEGX.B (xxx).W */
void REGPARAM2 op_4038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEGX.B (xxx).L */
void REGPARAM2 op_4039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	x_put_byte(srca, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* NEGX.W Dn */
void REGPARAM2 op_4040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.W (An) */
void REGPARAM2 op_4050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	x_put_word(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.W (An)+ */
void REGPARAM2 op_4058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	x_put_word(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.W -(An) */
void REGPARAM2 op_4060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	x_put_word(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.W (d16,An) */
void REGPARAM2 op_4068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	x_put_word(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEGX.W (d8,An,Xn) */
void REGPARAM2 op_4070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	x_put_word(srca, newv);
	return;
}
/* 2 2,0   */

/* NEGX.W (xxx).W */
void REGPARAM2 op_4078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	x_put_word(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEGX.W (xxx).L */
void REGPARAM2 op_4079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	x_put_word(srca, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* NEGX.L Dn */
void REGPARAM2 op_4080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.L (An) */
void REGPARAM2 op_4090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	x_put_long(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.L (An)+ */
void REGPARAM2 op_4098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	x_put_long(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.L -(An) */
void REGPARAM2 op_40a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	x_put_long(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEGX.L (d16,An) */
void REGPARAM2 op_40a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	x_put_long(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEGX.L (d8,An,Xn) */
void REGPARAM2 op_40b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	x_put_long(srca, newv);
	return;
}
/* 2 2,0   */

/* NEGX.L (xxx).W */
void REGPARAM2 op_40b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	x_put_long(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEGX.L (xxx).L */
void REGPARAM2 op_40b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	x_put_long(srca, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVSR2.W Dn */
void REGPARAM2 op_40c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* op H:2,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVSR2.W (An) */
void REGPARAM2 op_40d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(srca, regs.sr);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVSR2.W (An)+ */
void REGPARAM2 op_40d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	MakeSR();
	x_put_word(srca, regs.sr);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVSR2.W -(An) */
void REGPARAM2 op_40e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(srca, regs.sr);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVSR2.W (d16,An) */
void REGPARAM2 op_40e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(4);
	x_put_word(srca, regs.sr);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVSR2.W (d8,An,Xn) */
void REGPARAM2 op_40f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(0);
	x_put_word(srca, regs.sr);
	return;
}
/* 2 2,0   */

/* MVSR2.W (xxx).W */
void REGPARAM2 op_40f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(4);
	x_put_word(srca, regs.sr);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVSR2.W (xxx).L */
void REGPARAM2 op_40f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(6);
	x_put_word(srca, regs.sr);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CHK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* CHK.L (An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* CHK.L (An)+,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* CHK.L -(An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* CHK.L (d16,An),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,An,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 2,0   */

#endif
/* CHK.L (xxx).W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK.L (xxx).L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK.L (d16,PC),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_413a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,PC,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_413b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 2,0   */

#endif
/* CHK.L #<data>.L,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_413c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* CHK.W Dn,Dn */
void REGPARAM2 op_4180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

/* CHK.W (An),Dn */
void REGPARAM2 op_4190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

/* CHK.W (An)+,Dn */
void REGPARAM2 op_4198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

/* CHK.W -(An),Dn */
void REGPARAM2 op_41a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

/* CHK.W (d16,An),Dn */
void REGPARAM2 op_41a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

/* CHK.W (d8,An,Xn),Dn */
void REGPARAM2 op_41b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 2,0   */

/* CHK.W (xxx).W,Dn */
void REGPARAM2 op_41b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

/* CHK.W (xxx).L,Dn */
void REGPARAM2 op_41b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

/* CHK.W (d16,PC),Dn */
void REGPARAM2 op_41ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

/* CHK.W (d8,PC,Xn),Dn */
void REGPARAM2 op_41bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 2,0   */

/* CHK.W #<data>.W,Dn */
void REGPARAM2 op_41bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

/* LEA.L (An),An */
void REGPARAM2 op_41d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* LEA.L (d16,An),An */
void REGPARAM2 op_41e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* LEA.L (d8,An,Xn),An */
void REGPARAM2 op_41f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(0);
	m68k_areg(regs, dstreg) = (srca);
	return;
}
/* 2 2,0   */

/* LEA.L (xxx).W,An */
void REGPARAM2 op_41f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* LEA.L (xxx).L,An */
void REGPARAM2 op_41f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* LEA.L (d16,PC),An */
void REGPARAM2 op_41fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* LEA.L (d8,PC,Xn),An */
void REGPARAM2 op_41fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	/* op H:2-,T:0,C:-2 */
	regs.irc = get_word_ce030_prefetch_opcode(0);
	m68k_areg(regs, dstreg) = (srca);
	return;
}
/* 2 2,0   */

/* CLR.B Dn */
void REGPARAM2 op_4200_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.B (An) */
void REGPARAM2 op_4210_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.B (An)+ */
void REGPARAM2 op_4218_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.B -(An) */
void REGPARAM2 op_4220_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.B (d16,An) */
void REGPARAM2 op_4228_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CLR.B (d8,An,Xn) */
void REGPARAM2 op_4230_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	return;
}
/* 2 2,0   */

/* CLR.B (xxx).W */
void REGPARAM2 op_4238_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CLR.B (xxx).L */
void REGPARAM2 op_4239_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	x_put_byte(srca, 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CLR.W Dn */
void REGPARAM2 op_4240_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.W (An) */
void REGPARAM2 op_4250_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.W (An)+ */
void REGPARAM2 op_4258_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.W -(An) */
void REGPARAM2 op_4260_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.W (d16,An) */
void REGPARAM2 op_4268_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CLR.W (d8,An,Xn) */
void REGPARAM2 op_4270_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	return;
}
/* 2 2,0   */

/* CLR.W (xxx).W */
void REGPARAM2 op_4278_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CLR.W (xxx).L */
void REGPARAM2 op_4279_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	x_put_word(srca, 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CLR.L Dn */
void REGPARAM2 op_4280_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.L (An) */
void REGPARAM2 op_4290_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_long(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.L (An)+ */
void REGPARAM2 op_4298_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_long(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.L -(An) */
void REGPARAM2 op_42a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_long(srca, 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CLR.L (d16,An) */
void REGPARAM2 op_42a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_long(srca, 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CLR.L (d8,An,Xn) */
void REGPARAM2 op_42b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_long(srca, 0);
	return;
}
/* 2 2,0   */

/* CLR.L (xxx).W */
void REGPARAM2 op_42b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_long(srca, 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CLR.L (xxx).L */
void REGPARAM2 op_42b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	x_put_long(srca, 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* op H:2,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	MakeSR();
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(4);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(0);
	x_put_word(srca, regs.sr & 0xff);
	return;
}
/* 2 2,0   */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	/* ea H:2+2=4,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(4);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_42f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	/* ea H:4+2=6,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	/* op H:2-,T:0,C:-2 */
	MakeSR();
	regs.irc = get_word_ce030_prefetch_opcode(6);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* NEG.B Dn */
void REGPARAM2 op_4400_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.B (An) */
void REGPARAM2 op_4410_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.B (An)+ */
void REGPARAM2 op_4418_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.B -(An) */
void REGPARAM2 op_4420_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.B (d16,An) */
void REGPARAM2 op_4428_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEG.B (d8,An,Xn) */
void REGPARAM2 op_4430_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(srca, dst);
	return;
}
/* 2 2,0   */

/* NEG.B (xxx).W */
void REGPARAM2 op_4438_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEG.B (xxx).L */
void REGPARAM2 op_4439_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(srca, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* NEG.W Dn */
void REGPARAM2 op_4440_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.W (An) */
void REGPARAM2 op_4450_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.W (An)+ */
void REGPARAM2 op_4458_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.W -(An) */
void REGPARAM2 op_4460_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.W (d16,An) */
void REGPARAM2 op_4468_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEG.W (d8,An,Xn) */
void REGPARAM2 op_4470_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(srca, dst);
	return;
}
/* 2 2,0   */

/* NEG.W (xxx).W */
void REGPARAM2 op_4478_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEG.W (xxx).L */
void REGPARAM2 op_4479_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(srca, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* NEG.L Dn */
void REGPARAM2 op_4480_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.L (An) */
void REGPARAM2 op_4490_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.L (An)+ */
void REGPARAM2 op_4498_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.L -(An) */
void REGPARAM2 op_44a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NEG.L (d16,An) */
void REGPARAM2 op_44a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEG.L (d8,An,Xn) */
void REGPARAM2 op_44b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(srca, dst);
	return;
}
/* 2 2,0   */

/* NEG.L (xxx).W */
void REGPARAM2 op_44b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NEG.L (xxx).L */
void REGPARAM2 op_44b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(srca, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MV2SR.B Dn */
void REGPARAM2 op_44c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MV2SR.B (An) */
void REGPARAM2 op_44d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MV2SR.B (An)+ */
void REGPARAM2 op_44d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MV2SR.B -(An) */
void REGPARAM2 op_44e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MV2SR.B (d16,An) */
void REGPARAM2 op_44e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MV2SR.B (d8,An,Xn) */
void REGPARAM2 op_44f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	return;
}
/* 2 2,0   */

/* MV2SR.B (xxx).W */
void REGPARAM2 op_44f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MV2SR.B (xxx).L */
void REGPARAM2 op_44f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MV2SR.B (d16,PC) */
void REGPARAM2 op_44fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MV2SR.B (d8,PC,Xn) */
void REGPARAM2 op_44fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	return;
}
/* 2 2,0   */

/* MV2SR.B #<data>.B */
void REGPARAM2 op_44fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	intlev_load(); 
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.B Dn */
void REGPARAM2 op_4600_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.B (An) */
void REGPARAM2 op_4610_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.B (An)+ */
void REGPARAM2 op_4618_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.B -(An) */
void REGPARAM2 op_4620_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.B (d16,An) */
void REGPARAM2 op_4628_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.B (d8,An,Xn) */
void REGPARAM2 op_4630_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	x_put_byte(srca, dst);
	return;
}
/* 2 2,0   */

/* NOT.B (xxx).W */
void REGPARAM2 op_4638_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.B (xxx).L */
void REGPARAM2 op_4639_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	x_put_byte(srca, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* NOT.W Dn */
void REGPARAM2 op_4640_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.W (An) */
void REGPARAM2 op_4650_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.W (An)+ */
void REGPARAM2 op_4658_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.W -(An) */
void REGPARAM2 op_4660_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.W (d16,An) */
void REGPARAM2 op_4668_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.W (d8,An,Xn) */
void REGPARAM2 op_4670_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	x_put_word(srca, dst);
	return;
}
/* 2 2,0   */

/* NOT.W (xxx).W */
void REGPARAM2 op_4678_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.W (xxx).L */
void REGPARAM2 op_4679_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	x_put_word(srca, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* NOT.L Dn */
void REGPARAM2 op_4680_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.L (An) */
void REGPARAM2 op_4690_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.L (An)+ */
void REGPARAM2 op_4698_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.L -(An) */
void REGPARAM2 op_46a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOT.L (d16,An) */
void REGPARAM2 op_46a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.L (d8,An,Xn) */
void REGPARAM2 op_46b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	x_put_long(srca, dst);
	return;
}
/* 2 2,0   */

/* NOT.L (xxx).W */
void REGPARAM2 op_46b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NOT.L (xxx).L */
void REGPARAM2 op_46b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	x_put_long(srca, dst);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MV2SR.W Dn */
void REGPARAM2 op_46c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0   */

/* MV2SR.W (An) */
void REGPARAM2 op_46d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0   */

/* MV2SR.W (An)+ */
void REGPARAM2 op_46d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0   */

/* MV2SR.W -(An) */
void REGPARAM2 op_46e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0   */

/* MV2SR.W (d16,An) */
void REGPARAM2 op_46e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* MV2SR.W (d8,An,Xn) */
void REGPARAM2 op_46f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	fill_prefetch_030_ntx();
	return;
}
/* 2 2,0   */

/* MV2SR.W (xxx).W */
void REGPARAM2 op_46f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* MV2SR.W (xxx).L */
void REGPARAM2 op_46f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(6);
	fill_prefetch_030_ntx();
	return;
}
/* 6 0,0   */

/* MV2SR.W (d16,PC) */
void REGPARAM2 op_46fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* MV2SR.W (d8,PC,Xn) */
void REGPARAM2 op_46fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	fill_prefetch_030_ntx();
	return;
}
/* 2 2,0   */

/* MV2SR.W #<data>.W */
void REGPARAM2 op_46fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:8 */
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_030_ntx();
	return;
}
/* 4 0,0   */

/* NBCD.B Dn */
void REGPARAM2 op_4800_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* LINK.L An,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4808_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	/* op H:2,T:0,C:-2 */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = olda;
	uae_s32 offs;
	offs = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	x_put_long(olda, src);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* NBCD.B (An) */
void REGPARAM2 op_4810_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NBCD.B (An)+ */
void REGPARAM2 op_4818_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NBCD.B -(An) */
void REGPARAM2 op_4820_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NBCD.B (d16,An) */
void REGPARAM2 op_4828_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NBCD.B (d8,An,Xn) */
void REGPARAM2 op_4830_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	x_put_byte(srca, newv);
	return;
}
/* 2 2,0   */

/* NBCD.B (xxx).W */
void REGPARAM2 op_4838_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* NBCD.B (xxx).L */
void REGPARAM2 op_4839_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	x_put_byte(srca, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SWAP.W Dn */
void REGPARAM2 op_4840_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 34;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* BKPTQ.L #<data> */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4848_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 99;
	op_illg_noret(opcode);
	return;
}
/* 2 0,0   */

#endif
/* PEA.L (An) */
void REGPARAM2 op_4850_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	x_put_long(dsta, srca);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* PEA.L (d16,An) */
void REGPARAM2 op_4868_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	x_put_long(dsta, srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* PEA.L (d8,An,Xn) */
void REGPARAM2 op_4870_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	x_put_long(dsta, srca);
	return;
}
/* 2 2,0   */

/* PEA.L (xxx).W */
void REGPARAM2 op_4878_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	x_put_long(dsta, srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* PEA.L (xxx).L */
void REGPARAM2 op_4879_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	x_put_long(dsta, srca);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* PEA.L (d16,PC) */
void REGPARAM2 op_487a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	x_put_long(dsta, srca);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* PEA.L (d8,PC,Xn) */
void REGPARAM2 op_487b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:2,C:-2 */
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	x_put_long(dsta, srca);
	return;
}
/* 2 2,0   */

/* EXT.W Dn */
void REGPARAM2 op_4880_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVMLE.W #<data>.W,(An) */
void REGPARAM2 op_4890_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,-(An) */
void REGPARAM2 op_48a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = 1;
	while (amask) {
		srca -= 2;
		if (!type || movem_index2[amask] != dstreg) {
			x_put_word(srca, m68k_areg(regs, movem_index2[amask]));
			count_cycles += 4 * CYCLE_UNIT / 2;
		} else {
			x_put_word(srca, m68k_areg(regs, movem_index2[amask]) - 2);
			count_cycles += 4 * CYCLE_UNIT / 2;
		}
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 2;
		x_put_word(srca, m68k_dreg(regs, movem_index2[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,(d16,An) */
void REGPARAM2 op_48a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_48b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

/* MVMLE.W #<data>.W,(xxx).W */
void REGPARAM2 op_48b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(xxx).L */
void REGPARAM2 op_48b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = get_long_ce030_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(8);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* EXT.L Dn */
void REGPARAM2 op_48c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVMLE.L #<data>.W,(An) */
void REGPARAM2 op_48d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,-(An) */
void REGPARAM2 op_48e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = 1;
	while (amask) {
		srca -= 4;
		if (!type || movem_index2[amask] != dstreg) {
			x_put_long(srca, m68k_areg(regs, movem_index2[amask]));
			count_cycles += 4 * CYCLE_UNIT / 2;
		} else {
			x_put_long(srca, m68k_areg(regs, movem_index2[amask]) - 4);
			count_cycles += 4 * CYCLE_UNIT / 2;
		}
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 4;
		x_put_long(srca, m68k_dreg(regs, movem_index2[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,(d16,An) */
void REGPARAM2 op_48e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_48f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

/* MVMLE.L #<data>.W,(xxx).W */
void REGPARAM2 op_48f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(xxx).L */
void REGPARAM2 op_48f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uaecptr srca;
	srca = get_long_ce030_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(8);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* EXT.B Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_49c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* TST.B Dn */
void REGPARAM2 op_4a00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.B (An) */
void REGPARAM2 op_4a10_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.B (An)+ */
void REGPARAM2 op_4a18_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.B -(An) */
void REGPARAM2 op_4a20_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.B (d16,An) */
void REGPARAM2 op_4a28_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.B (d8,An,Xn) */
void REGPARAM2 op_4a30_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	return;
}
/* 2 2,0   */

/* TST.B (xxx).W */
void REGPARAM2 op_4a38_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.B (xxx).L */
void REGPARAM2 op_4a39_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TST.B (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a3a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.B (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a3b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	return;
}
/* 2 2,0   */

#endif
/* TST.B #<data>.B */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a3c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.W Dn */
void REGPARAM2 op_4a40_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.W An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a48_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* TST.W (An) */
void REGPARAM2 op_4a50_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.W (An)+ */
void REGPARAM2 op_4a58_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.W -(An) */
void REGPARAM2 op_4a60_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.W (d16,An) */
void REGPARAM2 op_4a68_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.W (d8,An,Xn) */
void REGPARAM2 op_4a70_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	return;
}
/* 2 2,0   */

/* TST.W (xxx).W */
void REGPARAM2 op_4a78_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.W (xxx).L */
void REGPARAM2 op_4a79_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TST.W (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a7a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.W (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a7b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	return;
}
/* 2 2,0   */

#endif
/* TST.W #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a7c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.L Dn */
void REGPARAM2 op_4a80_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.L An */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4a88_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

#endif
/* TST.L (An) */
void REGPARAM2 op_4a90_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.L (An)+ */
void REGPARAM2 op_4a98_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.L -(An) */
void REGPARAM2 op_4aa0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TST.L (d16,An) */
void REGPARAM2 op_4aa8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.L (d8,An,Xn) */
void REGPARAM2 op_4ab0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	return;
}
/* 2 2,0   */

/* TST.L (xxx).W */
void REGPARAM2 op_4ab8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TST.L (xxx).L */
void REGPARAM2 op_4ab9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TST.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4aba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* TST.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4abb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	return;
}
/* 2 2,0   */

#endif
/* TST.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4abc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

#endif
/* TAS.B Dn */
void REGPARAM2 op_4ac0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((src) & 0xff);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TAS.B (An) */
void REGPARAM2 op_4ad0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TAS.B (An)+ */
void REGPARAM2 op_4ad8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TAS.B -(An) */
void REGPARAM2 op_4ae0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* TAS.B (d16,An) */
void REGPARAM2 op_4ae8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TAS.B (d8,An,Xn) */
void REGPARAM2 op_4af0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 2,0   */

/* TAS.B (xxx).W */
void REGPARAM2 op_4af8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* TAS.B (xxx).L */
void REGPARAM2 op_4af9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	/* OP zero */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MULL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c10_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c18_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c20_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:0,C:28 */
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c28_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c30_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	/* op H:2,T:0,C:28 */
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c38_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c39_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 8 0,0   */

#endif
/* MULL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c3a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:2,T:0,C:28 */
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c3b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 dst = x_get_long(dsta);
	/* op H:2,T:0,C:28 */
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c3c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:28 */
	uae_s32 dst;
	dst = get_long_ce030_prefetch(4);
	/* op H:2,T:0,C:28 */
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c40_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c50_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c58_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c60_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:0,T:0,C:50 */
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c68_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c70_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	/* op H:0,T:0,C:50 */
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c78_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c79_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c7a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	/* op H:0,T:0,C:50 */
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c7b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 dst = x_get_long(dsta);
	/* op H:0,T:0,C:50 */
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4c7c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_ce030_prefetch(2);
	/* op H:0,T:0,C:50 */
	uae_s32 dst;
	dst = get_long_ce030_prefetch(4);
	/* op H:0,T:0,C:50 */
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 8 0,0   */

#endif
/* MVMEL.W #<data>.W,(An) */
void REGPARAM2 op_4c90_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(An)+ */
void REGPARAM2 op_4c98_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(d16,An) */
void REGPARAM2 op_4ca8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_4cb0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

/* MVMEL.W #<data>.W,(xxx).W */
void REGPARAM2 op_4cb8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(xxx).L */
void REGPARAM2 op_4cb9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_long_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(8);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MVMEL.W #<data>.W,(d16,PC) */
void REGPARAM2 op_4cba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
void REGPARAM2 op_4cbb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(An) */
void REGPARAM2 op_4cd0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(An)+ */
void REGPARAM2 op_4cd8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(d16,An) */
void REGPARAM2 op_4ce8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,An,Xn) */
void REGPARAM2 op_4cf0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(xxx).W */
void REGPARAM2 op_4cf8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(xxx).L */
void REGPARAM2 op_4cf9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_long_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(8);
	m68k_incpci(8);
	return;
}
/* 8 0,0   */

/* MVMEL.L #<data>.W,(d16,PC) */
void REGPARAM2 op_4cfa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(6);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
void REGPARAM2 op_4cfb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	uae_u16 mask = get_word_ce030_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 2,0   */

/* TRAPQ.L #<data> */
void REGPARAM2 op_4e40_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 15);
	OpcodeFamily = 39;
	uae_u32 src = srcreg;
	/* OP zero */
	m68k_incpci(2);
	Exception_cpu(src + 32);
	return;
	return;
}
/* 2 0,0   */

/* LINK.W An,#<data>.W */
void REGPARAM2 op_4e50_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	/* OP zero */
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = olda;
	uae_s16 offs = get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	x_put_long(olda, src);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* UNLK.L An */
void REGPARAM2 op_4e58_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 48;
	uae_s32 src = m68k_areg(regs, srcreg);
	/* OP zero */
	uae_u32 olda = src;
	uae_s32 old = x_get_long(olda);
	m68k_areg(regs, 7) = src + 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, srcreg) = (old);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVR2USP.L An */
void REGPARAM2 op_4e60_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 40;
	if (!regs.s) {
		Exception(8);
		return;
	}
	uae_s32 src = m68k_areg(regs, srcreg);
	/* op H:4,T:0,C:-4 */
	regs.usp = src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MVUSP2R.L An */
void REGPARAM2 op_4e68_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 41;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* op H:4,T:0,C:-4 */
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, srcreg) = (regs.usp);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* RESET.L  */
void REGPARAM2 op_4e70_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 42;
	if (!regs.s) {
		Exception(8);
		return;
	}
	bool r = cpureset();
	if (r) {
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* NOP.L  */
void REGPARAM2 op_4e71_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 43;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* STOP.L #<data>.W */
void REGPARAM2 op_4e72_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 44;
	if (!regs.s) {
		Exception(8);
		return;
	}
	if (!regs.stopped) {
		uae_s16 src = get_word_ce030_prefetch(2);
		/* op H:0,T:0,C:8 */
		regs.ir = src;
	}
	uae_u16 sr = regs.ir;
	ipl_fetch_next();
	regs.sr = sr;
	checkint();
	MakeFromSR_STOP();
	do_cycles_stop(4);
	m68k_setstopped(1);
	return;
}

/* RTE.L  */
void REGPARAM2 op_4e73_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 45;
	if (!regs.s) {
		Exception(8);
		return;
	}
	/* op H:1,T:9,C:8 */
	uaecptr oldpc = m68k_getpci();
	uae_u16 oldsr = regs.sr, newsr;
	uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg(regs, 7);
		uae_u16 sr = x_get_word(a);
		uae_u32 pc = x_get_long(a + 2);
		uae_u16 format = x_get_word(a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
		if (frame == 0x0) {
		m68k_areg(regs, 7) += offset; break; }
		else if (frame == 0x1) {
		m68k_areg(regs, 7) += offset; }
		else if (frame == 0x2) {
		m68k_areg(regs, 7) += offset + 4; break; }
		else if (frame == 0x9) {
		m68k_areg(regs, 7) += offset + 12; break; }
		else if (frame == 0xa) {
		m68k_areg(regs, 7) += offset + 24; break; }
		else if (frame == 0xb) {
		m68k_areg(regs, 7) += offset + 84; break; }
		else {
			regs.t1 = regs.t0 = 0;
			Exception_cpu(14);
			return;
		}
		regs.sr = newsr;
		oldsr = newsr;
		intlev_load();
		ipl_fetch_now();
		MakeFromSR_T0();
	}
	regs.sr = newsr;
	intlev_load();
	ipl_fetch_now();
	MakeFromSR_T0();
	if (newpc & 1) {
		exception3_read_prefetch(opcode, newpc);
		return;
	}
	m68k_setpci_j(newpc);
	#ifdef DEBUGGER
	branch_stack_pop_rte(oldpc);
	#endif
	fill_prefetch_030_ntx();
	return;
}
/* 2 0,0 B */

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4e74_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 46;
	uaecptr oldpc = m68k_getpci();
	/* op H:2,T:0,C:8 */
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	uae_s32 pc = x_get_long(pca);
	m68k_areg(regs, 7) += 4;
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:8 */
	m68k_areg(regs, 7) += offs;
	if (pc & 1) {
		exception3_read_prefetch_only(opcode, pc);
		return;
	}
	m68k_setpci_j(pc);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

#endif
/* RTS.L  */
void REGPARAM2 op_4e75_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 49;
	/* op H:1,T:0,C:8 */
	uaecptr oldpc = m68k_getpci();
	m68k_do_rts_ce030();
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_pop_rts(oldpc);
	}
	#endif
	if (m68k_getpci() & 1) {
		uaecptr faultpc = m68k_getpci();
		m68k_setpci_j(oldpc);
		exception3_read_prefetch_only(opcode, faultpc);
		return;
	}
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* TRAPV.L  */
void REGPARAM2 op_4e76_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 50;
	m68k_incpci(2);
	if (GET_VFLG()) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

/* RTR.L  */
void REGPARAM2 op_4e77_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 51;
	uaecptr oldpc = m68k_getpci();
	MakeSR();
	uaecptr sra;
	sra = m68k_areg(regs, 7);
	uae_s16 sr = x_get_word(sra);
	m68k_areg(regs, 7) += 2;
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	uae_s32 pc = x_get_long(pca);
	m68k_areg(regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	MakeFromSR();
	intlev_load(); 
	m68k_setpci_j(pc);
	if (m68k_getpci() & 1) {
		uaecptr faultpc = m68k_getpci();
		m68k_setpci_j(oldpc + 2);
		exception3_read_prefetch_only(opcode, faultpc);
		return;
	}
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4e7a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 82;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* op H:6,T:0,C:-6 */
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_movec2(src & 0xFFF, regp)) {
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_4e7b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 83;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* op H:6,T:0,C:-6 */
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_move2c(src & 0xFFF, regp)) {
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* JSR.L (An) */
void REGPARAM2 op_4e90_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	/* ea H:2,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* JSR.L (d16,An) */
void REGPARAM2 op_4ea8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	/* ea H:4,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JSR.L (d8,An,Xn) */
void REGPARAM2 op_4eb0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* JSR.L (xxx).W */
void REGPARAM2 op_4eb8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:2,T:0,C:0 jea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JSR.L (xxx).L */
void REGPARAM2 op_4eb9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:2,T:0,C:0 jea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 6 0,0 B */

/* JSR.L (d16,PC) */
void REGPARAM2 op_4eba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:4,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JSR.L (d8,PC,Xn) */
void REGPARAM2 op_4ebb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* JMP.L (An) */
void REGPARAM2 op_4ed0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	/* ea H:2+4=6,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci_j(srca);
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* JMP.L (d16,An) */
void REGPARAM2 op_4ee8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	/* ea H:4+4=8,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci_j(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JMP.L (d8,An,Xn) */
void REGPARAM2 op_4ef0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	/* op H:4,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci_j(srca);
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* JMP.L (xxx).W */
void REGPARAM2 op_4ef8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:2+4=6,T:0,C:0 jea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci_j(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JMP.L (xxx).L */
void REGPARAM2 op_4ef9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:2+4=6,T:0,C:0 jea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci_j(srca);
	fill_prefetch_030();
	return;
}
/* 6 0,0 B */

/* JMP.L (d16,PC) */
void REGPARAM2 op_4efa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:4+4=8,T:0,C:0 jea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	/* op H:4-,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci_j(srca);
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* JMP.L (d8,PC,Xn) */
void REGPARAM2 op_4efb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	/* ea H:0,T:0,C:0 jea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	/* op H:4,T:0,C:-4 */
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return;
	}
	m68k_setpci_j(srca);
	fill_prefetch_030();
	return;
}
/* 2 2,0 B */

/* ADDQ.B #<data>,Dn */
void REGPARAM2 op_5000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An) */
void REGPARAM2 op_5010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An)+ */
void REGPARAM2 op_5018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,-(An) */
void REGPARAM2 op_5020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(d16,An) */
void REGPARAM2 op_5028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 op_5030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	return;
}
/* 2 2,0   */

/* ADDQ.B #<data>,(xxx).W */
void REGPARAM2 op_5038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(xxx).L */
void REGPARAM2 op_5039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADDQ.W #<data>,Dn */
void REGPARAM2 op_5040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDAQ.W #<data>,An */
void REGPARAM2 op_5048_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst + src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An) */
void REGPARAM2 op_5050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An)+ */
void REGPARAM2 op_5058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,-(An) */
void REGPARAM2 op_5060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(d16,An) */
void REGPARAM2 op_5068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 op_5070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	return;
}
/* 2 2,0   */

/* ADDQ.W #<data>,(xxx).W */
void REGPARAM2 op_5078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(xxx).L */
void REGPARAM2 op_5079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADDQ.L #<data>,Dn */
void REGPARAM2 op_5080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDAQ.L #<data>,An */
void REGPARAM2 op_5088_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst + src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An) */
void REGPARAM2 op_5090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An)+ */
void REGPARAM2 op_5098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,-(An) */
void REGPARAM2 op_50a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(d16,An) */
void REGPARAM2 op_50a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 op_50b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	return;
}
/* 2 2,0   */

/* ADDQ.L #<data>,(xxx).W */
void REGPARAM2 op_50b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(xxx).L */
void REGPARAM2 op_50b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* Scc.B Dn (T) */
void REGPARAM2 op_50c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (T) */
void REGPARAM2 op_50c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(0)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (T) */
void REGPARAM2 op_50d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (T) */
void REGPARAM2 op_50d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (T) */
void REGPARAM2 op_50e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (T) */
void REGPARAM2 op_50e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (T) */
void REGPARAM2 op_50f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (T) */
void REGPARAM2 op_50f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (T) */
void REGPARAM2 op_50f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(0) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_50fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(0)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_50fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(0)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (T) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_50fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(0)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* SUBQ.B #<data>,Dn */
void REGPARAM2 op_5100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An) */
void REGPARAM2 op_5110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An)+ */
void REGPARAM2 op_5118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,-(An) */
void REGPARAM2 op_5120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(d16,An) */
void REGPARAM2 op_5128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(d8,An,Xn) */
void REGPARAM2 op_5130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUBQ.B #<data>,(xxx).W */
void REGPARAM2 op_5138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(xxx).L */
void REGPARAM2 op_5139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBQ.W #<data>,Dn */
void REGPARAM2 op_5140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBAQ.W #<data>,An */
void REGPARAM2 op_5148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An) */
void REGPARAM2 op_5150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An)+ */
void REGPARAM2 op_5158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,-(An) */
void REGPARAM2 op_5160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(d16,An) */
void REGPARAM2 op_5168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(d8,An,Xn) */
void REGPARAM2 op_5170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUBQ.W #<data>,(xxx).W */
void REGPARAM2 op_5178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(xxx).L */
void REGPARAM2 op_5179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBQ.L #<data>,Dn */
void REGPARAM2 op_5180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBAQ.L #<data>,An */
void REGPARAM2 op_5188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An) */
void REGPARAM2 op_5190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An)+ */
void REGPARAM2 op_5198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,-(An) */
void REGPARAM2 op_51a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(d16,An) */
void REGPARAM2 op_51a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(d8,An,Xn) */
void REGPARAM2 op_51b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUBQ.L #<data>,(xxx).W */
void REGPARAM2 op_51b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(xxx).L */
void REGPARAM2 op_51b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* Scc.B Dn (F) */
void REGPARAM2 op_51c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (F) */
void REGPARAM2 op_51c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(1)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (F) */
void REGPARAM2 op_51d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (F) */
void REGPARAM2 op_51d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (F) */
void REGPARAM2 op_51e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (F) */
void REGPARAM2 op_51e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (F) */
void REGPARAM2 op_51f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (F) */
void REGPARAM2 op_51f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (F) */
void REGPARAM2 op_51f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(1) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_51fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(1)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_51fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(1)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (F) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_51fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(1)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (HI) */
void REGPARAM2 op_52c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (HI) */
void REGPARAM2 op_52c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(2)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (HI) */
void REGPARAM2 op_52d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (HI) */
void REGPARAM2 op_52d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (HI) */
void REGPARAM2 op_52e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (HI) */
void REGPARAM2 op_52e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (HI) */
void REGPARAM2 op_52f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (HI) */
void REGPARAM2 op_52f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (HI) */
void REGPARAM2 op_52f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(2) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_52fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(2)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_52fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(2)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (HI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_52fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(2)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LS) */
void REGPARAM2 op_53c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LS) */
void REGPARAM2 op_53c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(3)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (LS) */
void REGPARAM2 op_53d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (LS) */
void REGPARAM2 op_53d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (LS) */
void REGPARAM2 op_53e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LS) */
void REGPARAM2 op_53e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LS) */
void REGPARAM2 op_53f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LS) */
void REGPARAM2 op_53f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LS) */
void REGPARAM2 op_53f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(3) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_53fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(3)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_53fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(3)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_53fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(3)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CC) */
void REGPARAM2 op_54c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CC) */
void REGPARAM2 op_54c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(4)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (CC) */
void REGPARAM2 op_54d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (CC) */
void REGPARAM2 op_54d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (CC) */
void REGPARAM2 op_54e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CC) */
void REGPARAM2 op_54e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CC) */
void REGPARAM2 op_54f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CC) */
void REGPARAM2 op_54f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CC) */
void REGPARAM2 op_54f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(4) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_54fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(4)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_54fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(4)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_54fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(4)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CS) */
void REGPARAM2 op_55c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CS) */
void REGPARAM2 op_55c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(5)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (CS) */
void REGPARAM2 op_55d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (CS) */
void REGPARAM2 op_55d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (CS) */
void REGPARAM2 op_55e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CS) */
void REGPARAM2 op_55e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CS) */
void REGPARAM2 op_55f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CS) */
void REGPARAM2 op_55f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CS) */
void REGPARAM2 op_55f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(5) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_55fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(5)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_55fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(5)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_55fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(5)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (NE) */
void REGPARAM2 op_56c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (NE) */
void REGPARAM2 op_56c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(6)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (NE) */
void REGPARAM2 op_56d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (NE) */
void REGPARAM2 op_56d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (NE) */
void REGPARAM2 op_56e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (NE) */
void REGPARAM2 op_56e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (NE) */
void REGPARAM2 op_56f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (NE) */
void REGPARAM2 op_56f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (NE) */
void REGPARAM2 op_56f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(6) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_56fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(6)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_56fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(6)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (NE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_56fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(6)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (EQ) */
void REGPARAM2 op_57c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (EQ) */
void REGPARAM2 op_57c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(7)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (EQ) */
void REGPARAM2 op_57d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (EQ) */
void REGPARAM2 op_57d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (EQ) */
void REGPARAM2 op_57e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (EQ) */
void REGPARAM2 op_57e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (EQ) */
void REGPARAM2 op_57f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (EQ) */
void REGPARAM2 op_57f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (EQ) */
void REGPARAM2 op_57f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(7) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_57fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(7)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_57fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(7)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (EQ) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_57fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(7)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VC) */
void REGPARAM2 op_58c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VC) */
void REGPARAM2 op_58c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(8)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (VC) */
void REGPARAM2 op_58d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (VC) */
void REGPARAM2 op_58d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (VC) */
void REGPARAM2 op_58e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VC) */
void REGPARAM2 op_58e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VC) */
void REGPARAM2 op_58f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VC) */
void REGPARAM2 op_58f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VC) */
void REGPARAM2 op_58f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(8) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_58fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(8)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_58fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(8)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VC) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_58fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(8)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VS) */
void REGPARAM2 op_59c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VS) */
void REGPARAM2 op_59c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(9)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (VS) */
void REGPARAM2 op_59d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (VS) */
void REGPARAM2 op_59d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (VS) */
void REGPARAM2 op_59e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VS) */
void REGPARAM2 op_59e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VS) */
void REGPARAM2 op_59f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VS) */
void REGPARAM2 op_59f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VS) */
void REGPARAM2 op_59f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(9) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_59fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(9)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_59fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(9)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VS) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_59fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(9)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (PL) */
void REGPARAM2 op_5ac0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (PL) */
void REGPARAM2 op_5ac8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(10)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (PL) */
void REGPARAM2 op_5ad0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (PL) */
void REGPARAM2 op_5ad8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (PL) */
void REGPARAM2 op_5ae0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (PL) */
void REGPARAM2 op_5ae8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (PL) */
void REGPARAM2 op_5af0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (PL) */
void REGPARAM2 op_5af8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (PL) */
void REGPARAM2 op_5af9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(10) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5afa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(10)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5afb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(10)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (PL) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5afc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(10)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (MI) */
void REGPARAM2 op_5bc0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (MI) */
void REGPARAM2 op_5bc8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(11)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (MI) */
void REGPARAM2 op_5bd0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (MI) */
void REGPARAM2 op_5bd8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (MI) */
void REGPARAM2 op_5be0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (MI) */
void REGPARAM2 op_5be8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (MI) */
void REGPARAM2 op_5bf0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (MI) */
void REGPARAM2 op_5bf8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (MI) */
void REGPARAM2 op_5bf9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(11) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5bfa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(11)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5bfb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(11)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (MI) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5bfc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(11)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GE) */
void REGPARAM2 op_5cc0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GE) */
void REGPARAM2 op_5cc8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(12)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (GE) */
void REGPARAM2 op_5cd0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (GE) */
void REGPARAM2 op_5cd8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (GE) */
void REGPARAM2 op_5ce0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GE) */
void REGPARAM2 op_5ce8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GE) */
void REGPARAM2 op_5cf0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GE) */
void REGPARAM2 op_5cf8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GE) */
void REGPARAM2 op_5cf9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(12) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5cfa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(12)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5cfb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(12)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5cfc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(12)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LT) */
void REGPARAM2 op_5dc0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LT) */
void REGPARAM2 op_5dc8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(13)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (LT) */
void REGPARAM2 op_5dd0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (LT) */
void REGPARAM2 op_5dd8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (LT) */
void REGPARAM2 op_5de0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LT) */
void REGPARAM2 op_5de8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LT) */
void REGPARAM2 op_5df0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LT) */
void REGPARAM2 op_5df8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LT) */
void REGPARAM2 op_5df9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(13) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5dfa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(13)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5dfb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(13)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5dfc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(13)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GT) */
void REGPARAM2 op_5ec0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GT) */
void REGPARAM2 op_5ec8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(14)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (GT) */
void REGPARAM2 op_5ed0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (GT) */
void REGPARAM2 op_5ed8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (GT) */
void REGPARAM2 op_5ee0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GT) */
void REGPARAM2 op_5ee8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GT) */
void REGPARAM2 op_5ef0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GT) */
void REGPARAM2 op_5ef8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GT) */
void REGPARAM2 op_5ef9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(14) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5efa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(14)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5efb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(14)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GT) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5efc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(14)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LE) */
void REGPARAM2 op_5fc0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LE) */
void REGPARAM2 op_5fc8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_ce030_prefetch(2);
	/* OP zero */
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(15)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return;
		}
		if (src) {
			fill_prefetch_030();
			return;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* Scc.B (An) (LE) */
void REGPARAM2 op_5fd0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (An)+ (LE) */
void REGPARAM2 op_5fd8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:0,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B -(An) (LE) */
void REGPARAM2 op_5fe0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LE) */
void REGPARAM2 op_5fe8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LE) */
void REGPARAM2 op_5ff0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	x_put_byte(srca, val);
	return;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LE) */
void REGPARAM2 op_5ff8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:2,T:0,C:0 cea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LE) */
void REGPARAM2 op_5ff9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	/* ea H:4,T:0,C:0 cea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	int val = cctrue(15) ? 0xff : 0x00;
	x_put_byte(srca, val);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5ffa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s16 dummy = get_word_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(4);
	if (cctrue(15)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5ffb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	uae_s32 dummy;
	dummy = get_long_ce030_prefetch(2);
	/* OP zero */
	m68k_incpci(6);
	if (cctrue(15)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LE) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_5ffc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	m68k_incpci(2);
	if (cctrue(15)) {
		Exception_cpu(7);
		return;
	}
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

#endif
/* Bcc.W #<data>.W (T) */
void REGPARAM2 op_6000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (T) */
void REGPARAM2 op_6001_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (T) */
void REGPARAM2 op_60ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* BSR.W #<data>.W */
void REGPARAM2 op_6100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	uae_s32 s;
	uae_s16 src = get_word_ce030_prefetch(2);
	/* op H:2,T:0,C:-2 */
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return;
	}
	m68k_do_bsr_ce030(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 4 0,0 B */

/* BSRQ.B #<data> */
void REGPARAM2 op_6101_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 54;
	uae_s32 s;
	uae_u32 src = srcreg;
	/* op H:2,T:0,C:-2 */
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return;
	}
	m68k_do_bsr_ce030(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 2 0,0 B */

/* BSR.L #<data>.L */
void REGPARAM2 op_61ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	uae_s32 s;
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* op H:2,T:0,C:-2 */
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return;
	}
	m68k_do_bsr_ce030(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_030();
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (HI) */
void REGPARAM2 op_6200_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (HI) */
void REGPARAM2 op_6201_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (HI) */
void REGPARAM2 op_62ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LS) */
void REGPARAM2 op_6300_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LS) */
void REGPARAM2 op_6301_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LS) */
void REGPARAM2 op_63ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CC) */
void REGPARAM2 op_6400_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CC) */
void REGPARAM2 op_6401_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CC) */
void REGPARAM2 op_64ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CS) */
void REGPARAM2 op_6500_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CS) */
void REGPARAM2 op_6501_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CS) */
void REGPARAM2 op_65ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (NE) */
void REGPARAM2 op_6600_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (NE) */
void REGPARAM2 op_6601_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (NE) */
void REGPARAM2 op_66ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (EQ) */
void REGPARAM2 op_6700_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (EQ) */
void REGPARAM2 op_6701_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (EQ) */
void REGPARAM2 op_67ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VC) */
void REGPARAM2 op_6800_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VC) */
void REGPARAM2 op_6801_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VC) */
void REGPARAM2 op_68ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VS) */
void REGPARAM2 op_6900_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VS) */
void REGPARAM2 op_6901_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VS) */
void REGPARAM2 op_69ff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (PL) */
void REGPARAM2 op_6a00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (PL) */
void REGPARAM2 op_6a01_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (PL) */
void REGPARAM2 op_6aff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (MI) */
void REGPARAM2 op_6b00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (MI) */
void REGPARAM2 op_6b01_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (MI) */
void REGPARAM2 op_6bff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GE) */
void REGPARAM2 op_6c00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GE) */
void REGPARAM2 op_6c01_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GE) */
void REGPARAM2 op_6cff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LT) */
void REGPARAM2 op_6d00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LT) */
void REGPARAM2 op_6d01_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LT) */
void REGPARAM2 op_6dff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GT) */
void REGPARAM2 op_6e00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GT) */
void REGPARAM2 op_6e01_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GT) */
void REGPARAM2 op_6eff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LE) */
void REGPARAM2 op_6f00_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(4);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LE) */
void REGPARAM2 op_6f01_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	/* OP zero */
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(2);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LE) */
void REGPARAM2 op_6fff_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	/* OP zero */
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_030();
		return;
	}
	m68k_incpci(6);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 6 0,0 B */

/* MOVEQ.L #<data>,Dn */
void REGPARAM2 op_7000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	uae_u32 src = srcreg;
	/* op H:2,T:0,C:-2 */
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B Dn,Dn */
void REGPARAM2 op_8000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B (An),Dn */
void REGPARAM2 op_8010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B (An)+,Dn */
void REGPARAM2 op_8018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B -(An),Dn */
void REGPARAM2 op_8020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B (d16,An),Dn */
void REGPARAM2 op_8028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B (d8,An,Xn),Dn */
void REGPARAM2 op_8030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* OR.B (xxx).W,Dn */
void REGPARAM2 op_8038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B (xxx).L,Dn */
void REGPARAM2 op_8039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.B (d16,PC),Dn */
void REGPARAM2 op_803a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B (d8,PC,Xn),Dn */
void REGPARAM2 op_803b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* OR.B #<data>.B,Dn */
void REGPARAM2 op_803c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W Dn,Dn */
void REGPARAM2 op_8040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W (An),Dn */
void REGPARAM2 op_8050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W (An)+,Dn */
void REGPARAM2 op_8058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W -(An),Dn */
void REGPARAM2 op_8060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W (d16,An),Dn */
void REGPARAM2 op_8068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W (d8,An,Xn),Dn */
void REGPARAM2 op_8070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* OR.W (xxx).W,Dn */
void REGPARAM2 op_8078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W (xxx).L,Dn */
void REGPARAM2 op_8079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.W (d16,PC),Dn */
void REGPARAM2 op_807a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W (d8,PC,Xn),Dn */
void REGPARAM2 op_807b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* OR.W #<data>.W,Dn */
void REGPARAM2 op_807c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L Dn,Dn */
void REGPARAM2 op_8080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L (An),Dn */
void REGPARAM2 op_8090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L (An)+,Dn */
void REGPARAM2 op_8098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L -(An),Dn */
void REGPARAM2 op_80a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L (d16,An),Dn */
void REGPARAM2 op_80a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L (d8,An,Xn),Dn */
void REGPARAM2 op_80b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* OR.L (xxx).W,Dn */
void REGPARAM2 op_80b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L (xxx).L,Dn */
void REGPARAM2 op_80b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* OR.L (d16,PC),Dn */
void REGPARAM2 op_80ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L (d8,PC,Xn),Dn */
void REGPARAM2 op_80bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* OR.L #<data>.L,Dn */
void REGPARAM2 op_80bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* DIVU.W Dn,Dn */
void REGPARAM2 op_80c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:18 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles_020_internal(34);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

/* DIVU.W (An),Dn */
void REGPARAM2 op_80d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles_020_internal(34);
	return;
}
/* 2 0,0   */

/* DIVU.W (An)+,Dn */
void REGPARAM2 op_80d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles_020_internal(34);
	return;
}
/* 2 0,0   */

/* DIVU.W -(An),Dn */
void REGPARAM2 op_80e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	do_cycles_020_internal(34);
	return;
}
/* 2 0,0   */

/* DIVU.W (d16,An),Dn */
void REGPARAM2 op_80e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles_020_internal(34);
	return;
}
/* 4 0,0   */

/* DIVU.W (d8,An,Xn),Dn */
void REGPARAM2 op_80f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	do_cycles_020_internal(34);
	return;
}
/* 2 2,0   */

/* DIVU.W (xxx).W,Dn */
void REGPARAM2 op_80f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles_020_internal(34);
	return;
}
/* 4 0,0   */

/* DIVU.W (xxx).L,Dn */
void REGPARAM2 op_80f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(6);
	do_cycles_020_internal(34);
	return;
}
/* 6 0,0   */

/* DIVU.W (d16,PC),Dn */
void REGPARAM2 op_80fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles_020_internal(34);
	return;
}
/* 4 0,0   */

/* DIVU.W (d8,PC,Xn),Dn */
void REGPARAM2 op_80fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	do_cycles_020_internal(34);
	return;
}
/* 2 2,0   */

/* DIVU.W #<data>.W,Dn */
void REGPARAM2 op_80fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	do_cycles_020_internal(34);
	return;
}
/* 4 0,0   */

/* SBCD.B Dn,Dn */
void REGPARAM2 op_8100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SBCD.B -(An),-(An) */
void REGPARAM2 op_8108_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:10 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:10 */
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B Dn,(An) */
void REGPARAM2 op_8110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B Dn,(An)+ */
void REGPARAM2 op_8118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B Dn,-(An) */
void REGPARAM2 op_8120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.B Dn,(d16,An) */
void REGPARAM2 op_8128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B Dn,(d8,An,Xn) */
void REGPARAM2 op_8130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* OR.B Dn,(xxx).W */
void REGPARAM2 op_8138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.B Dn,(xxx).L */
void REGPARAM2 op_8139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* PACK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	uae_u16 val = m68k_dreg(regs, srcreg) + get_word_ce030_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* PACK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	uae_u16 val;
	m68k_areg(regs, srcreg) -= 2;
	val = (uae_u16)(x_get_word(m68k_areg(regs, srcreg)));
	val += get_word_ce030_prefetch(2);
	m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
	x_put_byte(m68k_areg(regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* OR.W Dn,(An) */
void REGPARAM2 op_8150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W Dn,(An)+ */
void REGPARAM2 op_8158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W Dn,-(An) */
void REGPARAM2 op_8160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.W Dn,(d16,An) */
void REGPARAM2 op_8168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W Dn,(d8,An,Xn) */
void REGPARAM2 op_8170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* OR.W Dn,(xxx).W */
void REGPARAM2 op_8178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.W Dn,(xxx).L */
void REGPARAM2 op_8179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* UNPK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	uae_u16 val = m68k_dreg(regs, srcreg);
	val = ((val << 4) & 0xf00) | (val & 0xf);
	val += get_word_ce030_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffff0000) | (val & 0xffff);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* UNPK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
void REGPARAM2 op_8188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	uae_u16 val;
	m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(x_get_byte(m68k_areg(regs, srcreg)) & 0xff);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_word_ce030_prefetch(2);
	m68k_areg(regs, dstreg) -= 2;
	x_put_word(m68k_areg(regs, dstreg), val);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

#endif
/* OR.L Dn,(An) */
void REGPARAM2 op_8190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:1,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L Dn,(An)+ */
void REGPARAM2 op_8198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:0,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L Dn,-(An) */
void REGPARAM2 op_81a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* OR.L Dn,(d16,An) */
void REGPARAM2 op_81a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L Dn,(d8,An,Xn) */
void REGPARAM2 op_81b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	/* ea H:4,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* OR.L Dn,(xxx).W */
void REGPARAM2 op_81b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* OR.L Dn,(xxx).L */
void REGPARAM2 op_81b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	/* ea H:1,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* DIVS.W Dn,Dn */
void REGPARAM2 op_81c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:18 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles_020_internal(48);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	return;
}
/* 2 0,0   */

/* DIVS.W (An),Dn */
void REGPARAM2 op_81d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles_020_internal(48);
	return;
}
/* 2 0,0   */

/* DIVS.W (An)+,Dn */
void REGPARAM2 op_81d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles_020_internal(48);
	return;
}
/* 2 0,0   */

/* DIVS.W -(An),Dn */
void REGPARAM2 op_81e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	do_cycles_020_internal(48);
	return;
}
/* 2 0,0   */

/* DIVS.W (d16,An),Dn */
void REGPARAM2 op_81e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles_020_internal(48);
	return;
}
/* 4 0,0   */

/* DIVS.W (d8,An,Xn),Dn */
void REGPARAM2 op_81f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	do_cycles_020_internal(48);
	return;
}
/* 2 2,0   */

/* DIVS.W (xxx).W,Dn */
void REGPARAM2 op_81f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles_020_internal(48);
	return;
}
/* 4 0,0   */

/* DIVS.W (xxx).L,Dn */
void REGPARAM2 op_81f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(6);
	do_cycles_020_internal(48);
	return;
}
/* 6 0,0   */

/* DIVS.W (d16,PC),Dn */
void REGPARAM2 op_81fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles_020_internal(48);
	return;
}
/* 4 0,0   */

/* DIVS.W (d8,PC,Xn),Dn */
void REGPARAM2 op_81fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	do_cycles_020_internal(48);
	return;
}
/* 2 2,0   */

/* DIVS.W #<data>.W,Dn */
void REGPARAM2 op_81fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:0,C:20 */
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	do_cycles_020_internal(48);
	return;
}
/* 4 0,0   */

/* SUB.B Dn,Dn */
void REGPARAM2 op_9000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B (An),Dn */
void REGPARAM2 op_9010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B (An)+,Dn */
void REGPARAM2 op_9018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B -(An),Dn */
void REGPARAM2 op_9020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B (d16,An),Dn */
void REGPARAM2 op_9028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B (d8,An,Xn),Dn */
void REGPARAM2 op_9030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return;
}
/* 2 2,0   */

/* SUB.B (xxx).W,Dn */
void REGPARAM2 op_9038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B (xxx).L,Dn */
void REGPARAM2 op_9039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.B (d16,PC),Dn */
void REGPARAM2 op_903a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B (d8,PC,Xn),Dn */
void REGPARAM2 op_903b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return;
}
/* 2 2,0   */

/* SUB.B #<data>.B,Dn */
void REGPARAM2 op_903c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W Dn,Dn */
void REGPARAM2 op_9040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W An,Dn */
void REGPARAM2 op_9048_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W (An),Dn */
void REGPARAM2 op_9050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W (An)+,Dn */
void REGPARAM2 op_9058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W -(An),Dn */
void REGPARAM2 op_9060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W (d16,An),Dn */
void REGPARAM2 op_9068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W (d8,An,Xn),Dn */
void REGPARAM2 op_9070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return;
}
/* 2 2,0   */

/* SUB.W (xxx).W,Dn */
void REGPARAM2 op_9078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W (xxx).L,Dn */
void REGPARAM2 op_9079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.W (d16,PC),Dn */
void REGPARAM2 op_907a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W (d8,PC,Xn),Dn */
void REGPARAM2 op_907b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return;
}
/* 2 2,0   */

/* SUB.W #<data>.W,Dn */
void REGPARAM2 op_907c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L Dn,Dn */
void REGPARAM2 op_9080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L An,Dn */
void REGPARAM2 op_9088_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L (An),Dn */
void REGPARAM2 op_9090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L (An)+,Dn */
void REGPARAM2 op_9098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L -(An),Dn */
void REGPARAM2 op_90a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L (d16,An),Dn */
void REGPARAM2 op_90a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L (d8,An,Xn),Dn */
void REGPARAM2 op_90b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUB.L (xxx).W,Dn */
void REGPARAM2 op_90b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L (xxx).L,Dn */
void REGPARAM2 op_90b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUB.L (d16,PC),Dn */
void REGPARAM2 op_90ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L (d8,PC,Xn),Dn */
void REGPARAM2 op_90bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUB.L #<data>.L,Dn */
void REGPARAM2 op_90bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBA.W Dn,An */
void REGPARAM2 op_90c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W An,An */
void REGPARAM2 op_90c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W (An),An */
void REGPARAM2 op_90d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W (An)+,An */
void REGPARAM2 op_90d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W -(An),An */
void REGPARAM2 op_90e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.W (d16,An),An */
void REGPARAM2 op_90e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.W (d8,An,Xn),An */
void REGPARAM2 op_90f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.W (xxx).W,An */
void REGPARAM2 op_90f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.W (xxx).L,An */
void REGPARAM2 op_90f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBA.W (d16,PC),An */
void REGPARAM2 op_90fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.W (d8,PC,Xn),An */
void REGPARAM2 op_90fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.W #<data>.W,An */
void REGPARAM2 op_90fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBX.B Dn,Dn */
void REGPARAM2 op_9100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBX.B -(An),-(An) */
void REGPARAM2 op_9108_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B Dn,(An) */
void REGPARAM2 op_9110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B Dn,(An)+ */
void REGPARAM2 op_9118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B Dn,-(An) */
void REGPARAM2 op_9120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.B Dn,(d16,An) */
void REGPARAM2 op_9128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B Dn,(d8,An,Xn) */
void REGPARAM2 op_9130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUB.B Dn,(xxx).W */
void REGPARAM2 op_9138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.B Dn,(xxx).L */
void REGPARAM2 op_9139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBX.W Dn,Dn */
void REGPARAM2 op_9140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uae_s16 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBX.W -(An),-(An) */
void REGPARAM2 op_9148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W Dn,(An) */
void REGPARAM2 op_9150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W Dn,(An)+ */
void REGPARAM2 op_9158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W Dn,-(An) */
void REGPARAM2 op_9160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.W Dn,(d16,An) */
void REGPARAM2 op_9168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W Dn,(d8,An,Xn) */
void REGPARAM2 op_9170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUB.W Dn,(xxx).W */
void REGPARAM2 op_9178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.W Dn,(xxx).L */
void REGPARAM2 op_9179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBX.L Dn,Dn */
void REGPARAM2 op_9180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uae_s32 src = m68k_dreg(regs, srcreg);
	/* op H:2,T:0,C:-2 */
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBX.L -(An),-(An) */
void REGPARAM2 op_9188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:6 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:6 */
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L Dn,(An) */
void REGPARAM2 op_9190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:1,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L Dn,(An)+ */
void REGPARAM2 op_9198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:0,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L Dn,-(An) */
void REGPARAM2 op_91a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUB.L Dn,(d16,An) */
void REGPARAM2 op_91a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L Dn,(d8,An,Xn) */
void REGPARAM2 op_91b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	/* ea H:4,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	return;
}
/* 2 2,0   */

/* SUB.L Dn,(xxx).W */
void REGPARAM2 op_91b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUB.L Dn,(xxx).L */
void REGPARAM2 op_91b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	/* ea H:1,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBA.L Dn,An */
void REGPARAM2 op_91c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L An,An */
void REGPARAM2 op_91c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = dst - src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L (An),An */
void REGPARAM2 op_91d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L (An)+,An */
void REGPARAM2 op_91d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L -(An),An */
void REGPARAM2 op_91e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* SUBA.L (d16,An),An */
void REGPARAM2 op_91e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.L (d8,An,Xn),An */
void REGPARAM2 op_91f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.L (xxx).W,An */
void REGPARAM2 op_91f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.L (xxx).L,An */
void REGPARAM2 op_91f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* SUBA.L (d16,PC),An */
void REGPARAM2 op_91fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* SUBA.L (d8,PC,Xn),An */
void REGPARAM2 op_91fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* SUBA.L #<data>.L,An */
void REGPARAM2 op_91fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = dst - src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.B Dn,Dn */
void REGPARAM2 op_b000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.B (An),Dn */
void REGPARAM2 op_b010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.B (An)+,Dn */
void REGPARAM2 op_b018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.B -(An),Dn */
void REGPARAM2 op_b020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.B (d16,An),Dn */
void REGPARAM2 op_b028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B (d8,An,Xn),Dn */
void REGPARAM2 op_b030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMP.B (xxx).W,Dn */
void REGPARAM2 op_b038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B (xxx).L,Dn */
void REGPARAM2 op_b039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.B (d16,PC),Dn */
void REGPARAM2 op_b03a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.B (d8,PC,Xn),Dn */
void REGPARAM2 op_b03b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMP.B #<data>.B,Dn */
void REGPARAM2 op_b03c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W Dn,Dn */
void REGPARAM2 op_b040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.W An,Dn */
void REGPARAM2 op_b048_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.W (An),Dn */
void REGPARAM2 op_b050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.W (An)+,Dn */
void REGPARAM2 op_b058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.W -(An),Dn */
void REGPARAM2 op_b060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.W (d16,An),Dn */
void REGPARAM2 op_b068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W (d8,An,Xn),Dn */
void REGPARAM2 op_b070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMP.W (xxx).W,Dn */
void REGPARAM2 op_b078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W (xxx).L,Dn */
void REGPARAM2 op_b079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.W (d16,PC),Dn */
void REGPARAM2 op_b07a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.W (d8,PC,Xn),Dn */
void REGPARAM2 op_b07b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMP.W #<data>.W,Dn */
void REGPARAM2 op_b07c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.L Dn,Dn */
void REGPARAM2 op_b080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.L An,Dn */
void REGPARAM2 op_b088_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.L (An),Dn */
void REGPARAM2 op_b090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.L (An)+,Dn */
void REGPARAM2 op_b098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.L -(An),Dn */
void REGPARAM2 op_b0a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMP.L (d16,An),Dn */
void REGPARAM2 op_b0a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.L (d8,An,Xn),Dn */
void REGPARAM2 op_b0b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMP.L (xxx).W,Dn */
void REGPARAM2 op_b0b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.L (xxx).L,Dn */
void REGPARAM2 op_b0b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMP.L (d16,PC),Dn */
void REGPARAM2 op_b0ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMP.L (d8,PC,Xn),Dn */
void REGPARAM2 op_b0bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMP.L #<data>.L,Dn */
void REGPARAM2 op_b0bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMPA.W Dn,An */
void REGPARAM2 op_b0c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.W An,An */
void REGPARAM2 op_b0c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.W (An),An */
void REGPARAM2 op_b0d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.W (An)+,An */
void REGPARAM2 op_b0d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.W -(An),An */
void REGPARAM2 op_b0e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.W (d16,An),An */
void REGPARAM2 op_b0e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMPA.W (d8,An,Xn),An */
void REGPARAM2 op_b0f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMPA.W (xxx).W,An */
void REGPARAM2 op_b0f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMPA.W (xxx).L,An */
void REGPARAM2 op_b0f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMPA.W (d16,PC),An */
void REGPARAM2 op_b0fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMPA.W (d8,PC,Xn),An */
void REGPARAM2 op_b0fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMPA.W #<data>.W,An */
void REGPARAM2 op_b0fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B Dn,Dn */
void REGPARAM2 op_b100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPM.B (An)+,(An)+ */
void REGPARAM2 op_b108_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	/* No EA */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	/* op H:0,T:0,C:8 */
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.B Dn,(An) */
void REGPARAM2 op_b110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.B Dn,(An)+ */
void REGPARAM2 op_b118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.B Dn,-(An) */
void REGPARAM2 op_b120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.B Dn,(d16,An) */
void REGPARAM2 op_b128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B Dn,(d8,An,Xn) */
void REGPARAM2 op_b130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* EOR.B Dn,(xxx).W */
void REGPARAM2 op_b138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.B Dn,(xxx).L */
void REGPARAM2 op_b139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.W Dn,Dn */
void REGPARAM2 op_b140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPM.W (An)+,(An)+ */
void REGPARAM2 op_b148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	/* No EA */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	/* op H:0,T:0,C:8 */
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.W Dn,(An) */
void REGPARAM2 op_b150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.W Dn,(An)+ */
void REGPARAM2 op_b158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:0,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.W Dn,-(An) */
void REGPARAM2 op_b160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.W Dn,(d16,An) */
void REGPARAM2 op_b168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.W Dn,(d8,An,Xn) */
void REGPARAM2 op_b170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* EOR.W Dn,(xxx).W */
void REGPARAM2 op_b178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.W Dn,(xxx).L */
void REGPARAM2 op_b179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	/* ea H:1,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EOR.L Dn,Dn */
void REGPARAM2 op_b180_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPM.L (An)+,(An)+ */
void REGPARAM2 op_b188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	/* No EA */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	/* op H:0,T:0,C:8 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.L Dn,(An) */
void REGPARAM2 op_b190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:1,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.L Dn,(An)+ */
void REGPARAM2 op_b198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:0,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.L Dn,-(An) */
void REGPARAM2 op_b1a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EOR.L Dn,(d16,An) */
void REGPARAM2 op_b1a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.L Dn,(d8,An,Xn) */
void REGPARAM2 op_b1b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	/* ea H:4,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* EOR.L Dn,(xxx).W */
void REGPARAM2 op_b1b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* EOR.L Dn,(xxx).L */
void REGPARAM2 op_b1b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	/* ea H:1,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMPA.L Dn,An */
void REGPARAM2 op_b1c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.L An,An */
void REGPARAM2 op_b1c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.L (An),An */
void REGPARAM2 op_b1d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.L (An)+,An */
void REGPARAM2 op_b1d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.L -(An),An */
void REGPARAM2 op_b1e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* CMPA.L (d16,An),An */
void REGPARAM2 op_b1e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMPA.L (d8,An,Xn),An */
void REGPARAM2 op_b1f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMPA.L (xxx).W,An */
void REGPARAM2 op_b1f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMPA.L (xxx).L,An */
void REGPARAM2 op_b1f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* CMPA.L (d16,PC),An */
void REGPARAM2 op_b1fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* CMPA.L (d8,PC,Xn),An */
void REGPARAM2 op_b1fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	return;
}
/* 2 2,0   */

/* CMPA.L #<data>.L,An */
void REGPARAM2 op_b1fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.B Dn,Dn */
void REGPARAM2 op_c000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B (An),Dn */
void REGPARAM2 op_c010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B (An)+,Dn */
void REGPARAM2 op_c018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B -(An),Dn */
void REGPARAM2 op_c020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B (d16,An),Dn */
void REGPARAM2 op_c028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B (d8,An,Xn),Dn */
void REGPARAM2 op_c030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* AND.B (xxx).W,Dn */
void REGPARAM2 op_c038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B (xxx).L,Dn */
void REGPARAM2 op_c039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.B (d16,PC),Dn */
void REGPARAM2 op_c03a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B (d8,PC,Xn),Dn */
void REGPARAM2 op_c03b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return;
}
/* 2 2,0   */

/* AND.B #<data>.B,Dn */
void REGPARAM2 op_c03c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W Dn,Dn */
void REGPARAM2 op_c040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W (An),Dn */
void REGPARAM2 op_c050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W (An)+,Dn */
void REGPARAM2 op_c058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W -(An),Dn */
void REGPARAM2 op_c060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W (d16,An),Dn */
void REGPARAM2 op_c068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W (d8,An,Xn),Dn */
void REGPARAM2 op_c070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* AND.W (xxx).W,Dn */
void REGPARAM2 op_c078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W (xxx).L,Dn */
void REGPARAM2 op_c079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.W (d16,PC),Dn */
void REGPARAM2 op_c07a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W (d8,PC,Xn),Dn */
void REGPARAM2 op_c07b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return;
}
/* 2 2,0   */

/* AND.W #<data>.W,Dn */
void REGPARAM2 op_c07c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.L Dn,Dn */
void REGPARAM2 op_c080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:-2 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L (An),Dn */
void REGPARAM2 op_c090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L (An)+,Dn */
void REGPARAM2 op_c098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L -(An),Dn */
void REGPARAM2 op_c0a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L (d16,An),Dn */
void REGPARAM2 op_c0a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.L (d8,An,Xn),Dn */
void REGPARAM2 op_c0b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* AND.L (xxx).W,Dn */
void REGPARAM2 op_c0b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.L (xxx).L,Dn */
void REGPARAM2 op_c0b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* AND.L (d16,PC),Dn */
void REGPARAM2 op_c0ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.L (d8,PC,Xn),Dn */
void REGPARAM2 op_c0bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	return;
}
/* 2 2,0   */

/* AND.L #<data>.L,Dn */
void REGPARAM2 op_c0bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MULU.W Dn,Dn */
void REGPARAM2 op_c0c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULU.W (An),Dn */
void REGPARAM2 op_c0d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULU.W (An)+,Dn */
void REGPARAM2 op_c0d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULU.W -(An),Dn */
void REGPARAM2 op_c0e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULU.W (d16,An),Dn */
void REGPARAM2 op_c0e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MULU.W (d8,An,Xn),Dn */
void REGPARAM2 op_c0f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* MULU.W (xxx).W,Dn */
void REGPARAM2 op_c0f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MULU.W (xxx).L,Dn */
void REGPARAM2 op_c0f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MULU.W (d16,PC),Dn */
void REGPARAM2 op_c0fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MULU.W (d8,PC,Xn),Dn */
void REGPARAM2 op_c0fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* MULU.W #<data>.W,Dn */
void REGPARAM2 op_c0fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ABCD.B Dn,Dn */
void REGPARAM2 op_c100_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 14;
	uae_s8 src = m68k_dreg(regs, srcreg);
	/* OP zero */
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* OP zero */
	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ABCD.B -(An),-(An) */
void REGPARAM2 op_c108_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 14;
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	/* op H:2,T:1,C:10 */
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	/* op H:2,T:1,C:10 */
	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B Dn,(An) */
void REGPARAM2 op_c110_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B Dn,(An)+ */
void REGPARAM2 op_c118_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:1,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B Dn,-(An) */
void REGPARAM2 op_c120_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.B Dn,(d16,An) */
void REGPARAM2 op_c128_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B Dn,(d8,An,Xn) */
void REGPARAM2 op_c130_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	return;
}
/* 2 2,0   */

/* AND.B Dn,(xxx).W */
void REGPARAM2 op_c138_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.B Dn,(xxx).L */
void REGPARAM2 op_c139_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fea */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EXG.L Dn,Dn */
void REGPARAM2 op_c140_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* EXG.L An,An */
void REGPARAM2 op_c148_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W Dn,(An) */
void REGPARAM2 op_c150_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W Dn,(An)+ */
void REGPARAM2 op_c158_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:1,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W Dn,-(An) */
void REGPARAM2 op_c160_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.W Dn,(d16,An) */
void REGPARAM2 op_c168_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W Dn,(d8,An,Xn) */
void REGPARAM2 op_c170_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	return;
}
/* 2 2,0   */

/* AND.W Dn,(xxx).W */
void REGPARAM2 op_c178_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.W Dn,(xxx).L */
void REGPARAM2 op_c179_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* EXG.L Dn,An */
void REGPARAM2 op_c188_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* op H:4,T:0,C:-4 */
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L Dn,(An) */
void REGPARAM2 op_c190_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:1,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L Dn,(An)+ */
void REGPARAM2 op_c198_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:0,T:1,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L Dn,-(An) */
void REGPARAM2 op_c1a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* AND.L Dn,(d16,An) */
void REGPARAM2 op_c1a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.L Dn,(d8,An,Xn) */
void REGPARAM2 op_c1b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	/* ea H:4,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_ce030(m68k_areg(regs, dstreg), 0);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	return;
}
/* 2 2,0   */

/* AND.L Dn,(xxx).W */
void REGPARAM2 op_c1b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	/* ea H:2,T:2,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* AND.L Dn,(xxx).L */
void REGPARAM2 op_c1b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	/* ea H:1,T:0,C:0 fea */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_ce030_prefetch(2);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:0,T:1,C:-1 */
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MULS.W Dn,Dn */
void REGPARAM2 op_c1c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULS.W (An),Dn */
void REGPARAM2 op_c1d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULS.W (An)+,Dn */
void REGPARAM2 op_c1d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULS.W -(An),Dn */
void REGPARAM2 op_c1e0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* MULS.W (d16,An),Dn */
void REGPARAM2 op_c1e8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MULS.W (d8,An,Xn),Dn */
void REGPARAM2 op_c1f0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* MULS.W (xxx).W,Dn */
void REGPARAM2 op_c1f8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MULS.W (xxx).L,Dn */
void REGPARAM2 op_c1f9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* MULS.W (d16,PC),Dn */
void REGPARAM2 op_c1fa_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* MULS.W (d8,PC,Xn),Dn */
void REGPARAM2 op_c1fb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* MULS.W #<data>.W,Dn */
void REGPARAM2 op_c1fc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 63;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* op H:2,T:0,C:10 */
	uae_u32 newv = (uae_s32)(uae_s16)dst * (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	do_cycles_020_internal(20);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B Dn,Dn */
void REGPARAM2 op_d000_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.B (An),Dn */
void REGPARAM2 op_d010_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.B (An)+,Dn */
void REGPARAM2 op_d018_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.B -(An),Dn */
void REGPARAM2 op_d020_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.B (d16,An),Dn */
void REGPARAM2 op_d028_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B (d8,An,Xn),Dn */
void REGPARAM2 op_d030_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return;
}
/* 2 2,0   */

/* ADD.B (xxx).W,Dn */
void REGPARAM2 op_d038_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B (xxx).L,Dn */
void REGPARAM2 op_d039_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.B (d16,PC),Dn */
void REGPARAM2 op_d03a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.B (d8,PC,Xn),Dn */
void REGPARAM2 op_d03b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return;
}
/* 2 2,0   */

/* ADD.B #<data>.B,Dn */
void REGPARAM2 op_d03c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:0,C:0 fea */
	uae_s8 src = (uae_u8)get_word_ce030_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W Dn,Dn */
void REGPARAM2 op_d040_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.W An,Dn */
void REGPARAM2 op_d048_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.W (An),Dn */
void REGPARAM2 op_d050_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.W (An)+,Dn */
void REGPARAM2 op_d058_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.W -(An),Dn */
void REGPARAM2 op_d060_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.W (d16,An),Dn */
void REGPARAM2 op_d068_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W (d8,An,Xn),Dn */
void REGPARAM2 op_d070_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return;
}
/* 2 2,0   */

/* ADD.W (xxx).W,Dn */
void REGPARAM2 op_d078_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W (xxx).L,Dn */
void REGPARAM2 op_d079_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.W (d16,PC),Dn */
void REGPARAM2 op_d07a_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.W (d8,PC,Xn),Dn */
void REGPARAM2 op_d07b_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return;
}
/* 2 2,0   */

/* ADD.W #<data>.W,Dn */
void REGPARAM2 op_d07c_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:0,C:0 fea */
	uae_s16 src = get_word_ce030_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.L Dn,Dn */
void REGPARAM2 op_d080_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.L An,Dn */
void REGPARAM2 op_d088_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* No EA */
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	/* op H:2,T:0,C:-2 */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.L (An),Dn */
void REGPARAM2 op_d090_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.L (An)+,Dn */
void REGPARAM2 op_d098_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.L -(An),Dn */
void REGPARAM2 op_d0a0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADD.L (d16,An),Dn */
void REGPARAM2 op_d0a8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.L (d8,An,Xn),Dn */
void REGPARAM2 op_d0b0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_ce030(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* ADD.L (xxx).W,Dn */
void REGPARAM2 op_d0b8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.L (xxx).L,Dn */
void REGPARAM2 op_d0b9_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:1,T:0,C:0 fea */
	uaecptr srca;
	srca = get_long_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADD.L (d16,PC),Dn */
void REGPARAM2 op_d0ba_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:2,T:2,C:0 fea */
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_ce030_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(4);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return;
}
/* 4 0,0   */

/* ADD.L (d8,PC,Xn),Dn */
void REGPARAM2 op_d0bb_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:4,T:2,C:0 fea */
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_ce030(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(0);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	return;
}
/* 2 2,0   */

/* ADD.L #<data>.L,Dn */
void REGPARAM2 op_d0bc_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 11;
	/* ea H:0,T:0,C:0 fea */
	uae_s32 src;
	src = get_long_ce030_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(6);
	/* OP zero */
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return;
}
/* 6 0,0   */

/* ADDA.W Dn,An */
void REGPARAM2 op_d0c0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 12;
	/* No EA */
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_u32 newv = dst + src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDA.W An,An */
void REGPARAM2 op_d0c8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 12;
	/* No EA */
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	/* OP zero */
	uae_u32 newv = dst + src;
	regs.irc = get_word_ce030_prefetch_opcode(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDA.W (An),An */
void REGPARAM2 op_d0d0_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 12;
	/* ea H:1,T:1,C:0 fea */
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_ce030_prefetch_opcode(2);
	/* op H:4,T:0,C:-4 */
	uae_u32 newv = dst + src;
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return;
}
/* 2 0,0   */

/* ADDA.W (An)+,An */
void REGPARAM2 op_d0d8_23_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32