#include "main.h"
#include "sysdeps.h"
#include "hatari-glue.h"
#include "maccess.h"
#include "memory.h"
#include "custom.h"
#include "newcpu.h"
#include "cpu_prefetch.h"
#include "cputbl.h"
#include "debugmem.h"
#define SET_ALWAYS_CFLG(x) SET_CFLG(x)
#define SET_ALWAYS_NFLG(x) SET_NFLG(x)
/* OR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* OR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ORSR.B #<data>.W */
uae_u32 REGPARAM2 op_003c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	CurrentInstrCycles = 8;  
	MakeSR();
	uae_s16 src = get_word_020_prefetch(2);
	src &= 0xFF;
	regs.sr |= src;
	MakeFromSR();
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* OR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ORSR.W #<data>.W */
uae_u32 REGPARAM2 op_007c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 4;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = get_word_020_prefetch(2);
	if(regs.t0) check_t0_trace();
	regs.sr |= src;
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_00a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_00a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* OR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_00b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* OR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_00b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* OR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_00b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 1;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CHK2.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CHK2.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CHK2.B #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.B #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_00fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s8)x_get_byte(dsta);
	upper = (uae_s32)(uae_s8)x_get_byte(dsta + 1);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s8)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 0);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* BTST.L Dn,Dn */
uae_u32 REGPARAM2 op_0100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPMR.W (d16,An),Dn */
uae_u32 REGPARAM2 op_0108_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 16; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_u16 val  = (x_get_byte(mempa) & 0xff) << 8;
	val |= (x_get_byte(mempa + 2) & 0xff);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((val) & 0xffff);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(An) */
uae_u32 REGPARAM2 op_0110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BTST.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BTST.B Dn,-(An) */
uae_u32 REGPARAM2 op_0120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BTST.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_0128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BTST.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_0138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_0139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B Dn,(d16,PC) */
uae_u32 REGPARAM2 op_013a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_getpci() + 2;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B Dn,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_013b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BTST.B Dn,#<data>.B */
uae_u32 REGPARAM2 op_013c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = (uae_u8)get_word_020_prefetch(2);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.L Dn,Dn */
uae_u32 REGPARAM2 op_0140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPMR.L (d16,An),Dn */
uae_u32 REGPARAM2 op_0148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 29;
	CurrentInstrCycles = 24; 
	uaecptr mempa = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_u32 val  = (x_get_byte(mempa) & 0xff) << 24;
	val |= (x_get_byte(mempa + 2) & 0xff) << 16;
	val |= (x_get_byte(mempa + 4) & 0xff) << 8;
	val |= (x_get_byte(mempa + 6) & 0xff);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (val);
	m68k_incpci(4);
	return (4 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B Dn,(An) */
uae_u32 REGPARAM2 op_0150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCHG.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCHG.B Dn,-(An) */
uae_u32 REGPARAM2 op_0160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCHG.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_0168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BCHG.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_0178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_0179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 22;
	CurrentInstrCycles = 22; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCLR.L Dn,Dn */
uae_u32 REGPARAM2 op_0180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPRM.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_0188_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	x_put_byte(mempa, src >> 8);
	x_put_byte(mempa + 2, src); 
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B Dn,(An) */
uae_u32 REGPARAM2 op_0190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCLR.B Dn,(An)+ */
uae_u32 REGPARAM2 op_0198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCLR.B Dn,-(An) */
uae_u32 REGPARAM2 op_01a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BCLR.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_01a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_01b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BCLR.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_01b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_01b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BSET.L Dn,Dn */
uae_u32 REGPARAM2 op_01c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 6;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVPRM.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_01c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 28;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr mempa = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	x_put_byte(mempa, src >> 24);
	x_put_byte(mempa + 2, src >> 16);
	x_put_byte(mempa + 4, src >> 8);
	x_put_byte(mempa + 6, src); 
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (4 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B Dn,(An) */
uae_u32 REGPARAM2 op_01d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BSET.B Dn,(An)+ */
uae_u32 REGPARAM2 op_01d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BSET.B Dn,-(An) */
uae_u32 REGPARAM2 op_01e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BSET.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_01e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_01f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 14; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* BSET.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_01f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_01f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 24;
	CurrentInstrCycles = 22; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0200_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0210_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0218_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0220_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0228_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0230_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* AND.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0238_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0239_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ANDSR.B #<data>.W */
uae_u32 REGPARAM2 op_023c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	CurrentInstrCycles = 8;  
	MakeSR();
	uae_s16 src = get_word_020_prefetch(2);
	src &= 0xFF;
	src |= 0xff00;
	regs.sr &= src;
	MakeFromSR();
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0240_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0250_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0258_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0260_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0268_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0270_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* AND.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0278_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0279_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ANDSR.W #<data>.W */
uae_u32 REGPARAM2 op_027c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 5;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = get_word_020_prefetch(2);
	if(regs.t0) check_t0_trace();
	regs.sr &= src;
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0280_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0290_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0298_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_02a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_02a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* AND.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_02b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* AND.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_02b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* AND.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_02b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 2;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CHK2.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CHK2.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CHK2.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_02fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = (uae_s32)(uae_s16)x_get_word(dsta);
	upper = (uae_s32)(uae_s16)x_get_word(dsta + 2);
	if ((extra & 0x8000) == 0) reg = (uae_s32)(uae_s16)reg;
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 1);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* SUB.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0400_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0410_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0418_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0420_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0428_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0430_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, newv);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* SUB.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0438_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0439_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, newv);
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0440_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0450_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0458_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0460_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0468_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0470_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* SUB.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0478_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0479_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0480_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0490_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0498_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_04a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_04a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_04b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* SUB.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_04b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* SUB.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_04b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 7;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_long(dsta, newv);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CHK2.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CHK2.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 81;
	CurrentInstrCycles = 16; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(8);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CHK2.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 81;
	CurrentInstrCycles = 12; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	m68k_incpci(6);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK2.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_04fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 81;
	CurrentInstrCycles = 8;  
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 upper,lower,reg = regs.regs[(extra >> 12) & 15];
	lower = x_get_long(dsta); upper = x_get_long(dsta + 4);
	SET_CFLG(0);
	SET_ZFLG(0);
	setchk2undefinedflags(lower, upper, reg, (extra & 0x8000) ? 2 : 2);
	if(upper == reg || lower == reg) {
		SET_ZFLG(1);
	}else{
		if (lower <= upper && (reg < lower || reg > upper)) SET_ALWAYS_CFLG(1);
		if (lower > upper && reg > upper && reg < lower) SET_ALWAYS_CFLG(1);
	}
	if ((extra & 0x800) && GET_CFLG()) {
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* ADD.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0600_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0610_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0618_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0620_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0628_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0630_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, newv);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* ADD.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0638_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0639_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, newv);
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0640_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0650_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0658_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0660_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADD.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0668_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0670_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* ADD.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0678_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0679_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0680_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0690_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0698_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_06a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADD.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_06a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_06b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* ADD.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_06b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, newv);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* ADD.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_06b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 11;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_long(dsta, newv);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* RTM.L Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* RTM.L An */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 101;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 100;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CALLM.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_06fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 100;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* BTST.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0800_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0810_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0818_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0820_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BTST.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0828_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0830_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BTST.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0838_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0839_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 21;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* BTST.B #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 op_083a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 21;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BTST.B #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_083b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 21;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BCHG.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0840_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0850_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0858_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0860_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCHG.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0868_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0870_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 22;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BCHG.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0878_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCHG.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0879_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 22;
	CurrentInstrCycles = 26; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	dst ^= (1 << src);
	SET_ZFLG(((uae_u32)dst & (1 << src)) >> src);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, dst);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* BCLR.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_0880_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_0890_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0898_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_08a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BCLR.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_08a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_08b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 23;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BCLR.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_08b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BCLR.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_08b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 23;
	CurrentInstrCycles = 26; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst &= ~(1 << src);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, dst);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* BSET.L #<data>.W,Dn */
uae_u32 REGPARAM2 op_08c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= 31;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (dst);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An) */
uae_u32 REGPARAM2 op_08d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_08d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,-(An) */
uae_u32 REGPARAM2 op_08e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* BSET.B #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_08e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_08f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 24;
	CurrentInstrCycles = 18; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* BSET.B #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_08f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	CurrentInstrCycles = 22; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* BSET.B #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_08f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 24;
	CurrentInstrCycles = 26; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src &= 7;
	SET_ZFLG(1 ^ ((dst >> src) & 1));
	dst |= (1 << src);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, dst);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EOR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0a00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0a10_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0a18_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0a20_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0a28_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0a30_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* EOR.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0a38_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0a39_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EORSR.B #<data>.W */
uae_u32 REGPARAM2 op_0a3c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	CurrentInstrCycles = 8;  
	MakeSR();
	uae_s16 src = get_word_020_prefetch(2);
	src &= 0xFF;
	regs.sr ^= src;
	MakeFromSR();
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0a40_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0a50_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0a58_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0a60_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0a68_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0a70_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* EOR.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0a78_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0a79_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EORSR.W #<data>.W */
uae_u32 REGPARAM2 op_0a7c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 6;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	uae_s16 src = get_word_020_prefetch(2);
	if(regs.t0) check_t0_trace();
	regs.sr ^= src;
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0a80_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0a90_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0a98_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_0aa0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_0aa8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0ab0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* EOR.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_0ab8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 32; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EOR.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_0ab9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 3;
	CurrentInstrCycles = 36; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CAS.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ad0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ad8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ae0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ae8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(6);
	} else {
		regs.irc = get_word_020_prefetch(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0af0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(0);
	} else {
		regs.irc = get_word_020_prefetch(0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CAS.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0af8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(6);
	} else {
		regs.irc = get_word_020_prefetch(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0af9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s8)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(m68k_dreg(regs, rc))) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_byte(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(8);
	} else {
		regs.irc = get_word_020_prefetch(8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xff) | (dst & 0xff);
	}
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CMP.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_0c00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_0c10_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_0c18_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_0c20_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_0c28_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0c30_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* CMP.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_0c38_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_0c39_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.B #<data>.B,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c3a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CMP.B #<data>.B,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c3b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CMP.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_0c40_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_0c50_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_0c58_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_0c60_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_0c68_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0c70_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* CMP.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_0c78_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_0c79_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.W #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c7a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CMP.W #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0c7b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CMP.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_0c80_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_0c90_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_0c98_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_0ca0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_0ca8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_0cb0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* CMP.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_0cb8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* CMP.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_0cb9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 25;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(10);
	m68k_incpci(10);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* CMP.L #<data>.L,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 25;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 6;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(6);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CMP.L #<data>.L,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cbb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

#endif
/* CAS.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cd0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cd8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ce0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ce8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(6);
	} else {
		regs.irc = get_word_020_prefetch(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cf0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(0);
	} else {
		regs.irc = get_word_020_prefetch(0);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CAS.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cf8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(6);
	} else {
		regs.irc = get_word_020_prefetch(6);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cf9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s16 dst = x_get_word(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s16)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, rc))) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_word(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(8);
	} else {
		regs.irc = get_word_020_prefetch(8);
		m68k_dreg(regs, rc) = (m68k_dreg(regs, rc) & ~0xffff) | (dst & 0xffff);
	}
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS2.W #<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0cfc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	CurrentInstrCycles = 12; 
	uae_s32 extra;
	extra = get_long_020_prefetch(2);
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u16 dst1 = x_get_word(rn1), dst2 = x_get_word(rn2);
	uae_u32 newv = ((uae_u16)(dst1)) - ((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s16)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s16)(dst1)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u16)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u16)(dst2)) - ((uae_u16)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s16)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s16)(dst2)) < 0;
		int flgn = ((uae_s16)(newv)) < 0;
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u16)(m68k_dreg(regs, extra & 7))) > ((uae_u16)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			x_put_word(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			x_put_word(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 0) & 7) = (m68k_dreg(regs, (extra >> 0) & 7) & ~0xffff) | (dst2 & 0xffff);
		m68k_dreg(regs, (extra >> 16) & 7) = (m68k_dreg(regs, (extra >> 16) & 7) & ~0xffff) | (dst1 & 0xffff);
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e10_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		regs.irc = get_word_020_prefetch(4);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc_nommu_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e18_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		regs.irc = get_word_020_prefetch(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s8 src = sfc_nommu_get_byte(srca);
		m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e20_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		m68k_areg(regs, dstreg) = dsta;
		regs.irc = get_word_020_prefetch(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
		uae_s8 src = sfc_nommu_get_byte(srca);
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.B #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e28_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
		regs.irc = get_word_020_prefetch(6);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
		uae_s8 src = sfc_nommu_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e30_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
		regs.irc = get_word_020_prefetch(0);
		dfc_nommu_put_byte(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
		uae_s8 src = sfc_nommu_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,2   */

#endif
/* MOVES.B #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e38_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
		regs.irc = get_word_020_prefetch(6);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_020_prefetch(4);
		uae_s8 src = sfc_nommu_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(6);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.B #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e39_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_long_020_prefetch(4);
		regs.irc = get_word_020_prefetch(8);
		dfc_nommu_put_byte(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_long_020_prefetch(4);
		uae_s8 src = sfc_nommu_get_byte(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s8)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xff) | ((src) & 0xff);
		}
		m68k_incpci(8);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MOVES.W #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e50_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		regs.irc = get_word_020_prefetch(4);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s16 src = sfc_nommu_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e58_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 2;
		regs.irc = get_word_020_prefetch(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s16 src = sfc_nommu_get_word(srca);
		m68k_areg(regs, dstreg) += 2;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e60_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 2;
		m68k_areg(regs, dstreg) = dsta;
		regs.irc = get_word_020_prefetch(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 2;
		uae_s16 src = sfc_nommu_get_word(srca);
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.W #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e68_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
		regs.irc = get_word_020_prefetch(6);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
		uae_s16 src = sfc_nommu_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e70_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
		regs.irc = get_word_020_prefetch(0);
		dfc_nommu_put_word(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
		uae_s16 src = sfc_nommu_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,2   */

#endif
/* MOVES.W #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e78_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
		regs.irc = get_word_020_prefetch(6);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_020_prefetch(4);
		uae_s16 src = sfc_nommu_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(6);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.W #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e79_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_long_020_prefetch(4);
		regs.irc = get_word_020_prefetch(8);
		dfc_nommu_put_word(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_long_020_prefetch(4);
		uae_s16 src = sfc_nommu_get_word(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = (uae_s32)(uae_s16)src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (m68k_dreg(regs, (extra >> 12) & 7) & ~0xffff) | ((src) & 0xffff);
		}
		m68k_incpci(8);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MOVES.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e90_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		regs.irc = get_word_020_prefetch(4);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s32 src = sfc_nommu_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0e98_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg);
		m68k_areg(regs, dstreg) += 4;
		regs.irc = get_word_020_prefetch(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg);
		uae_s32 src = sfc_nommu_get_long(srca);
		m68k_areg(regs, dstreg) += 4;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ea0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) - 4;
		m68k_areg(regs, dstreg) = dsta;
		regs.irc = get_word_020_prefetch(4);
		src = regs.regs[(extra >> 12) & 15];
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(4);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) - 4;
		uae_s32 src = sfc_nommu_get_long(srca);
		m68k_areg(regs, dstreg) = srca;
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(4);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVES.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ea8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
		regs.irc = get_word_020_prefetch(6);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
		uae_s32 src = sfc_nommu_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 103;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		m68k_incpci(4);
		dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
		regs.irc = get_word_020_prefetch(0);
		dfc_nommu_put_long(dsta, src);
	} else {
		uaecptr srca;
		m68k_incpci(4);
		srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
		uae_s32 src = sfc_nommu_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,2   */

#endif
/* MOVES.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
		regs.irc = get_word_020_prefetch(6);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(6);
	} else {
		uaecptr srca;
		srca = (uae_s32)(uae_s16)get_word_020_prefetch(4);
		uae_s32 src = sfc_nommu_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(6);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVES.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0eb9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 103;
	CurrentInstrCycles = 24; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 extra = get_word_020_prefetch(2);
	if (extra & 0x800) {
		uae_u32 src = regs.regs[(extra >> 12) & 15];
		uaecptr dsta;
		dsta = get_long_020_prefetch(4);
		regs.irc = get_word_020_prefetch(8);
		dfc_nommu_put_long(dsta, src);
		m68k_incpci(8);
	} else {
		uaecptr srca;
		srca = get_long_020_prefetch(4);
		uae_s32 src = sfc_nommu_get_long(srca);
		if (extra & 0x8000) {
			m68k_areg(regs, (extra >> 12) & 7) = src;
		} else {
			m68k_dreg(regs, (extra >> 12) & 7) = (src);
		}
		m68k_incpci(8);
		regs.irc = get_word_020_prefetch(0);
	}
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ed0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ed8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ee0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(4);
	} else {
		regs.irc = get_word_020_prefetch(4);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CAS.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ee8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 28; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(6);
	} else {
		regs.irc = get_word_020_prefetch(6);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ef0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 84;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(0);
	} else {
		regs.irc = get_word_020_prefetch(0);
		m68k_dreg(regs, rc) = dst;
	}
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* CAS.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ef8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 28; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(6);
	} else {
		regs.irc = get_word_020_prefetch(6);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CAS.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0ef9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 84;
	CurrentInstrCycles = 32; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	int ru = (src >> 6) & 7;
	int rc = src & 7;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(m68k_dreg(regs, rc)));
	int flgs = ((uae_s32)(m68k_dreg(regs, rc))) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, rc))) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		x_put_long(dsta, (m68k_dreg(regs, ru)));
		regs.irc = get_word_020_prefetch(8);
	} else {
		regs.irc = get_word_020_prefetch(8);
		m68k_dreg(regs, rc) = dst;
	}
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* CAS2.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_0efc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 85;
	CurrentInstrCycles = 12; 
	uae_s32 extra;
	extra = get_long_020_prefetch(2);
	uae_u32 rn1 = regs.regs[(extra >> 28) & 15];
	uae_u32 rn2 = regs.regs[(extra >> 12) & 15];
	uae_u32 dst1 = x_get_long(rn1), dst2 = x_get_long(rn2);
	uae_u32 newv = ((uae_u32)(dst1)) - ((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7)));
	int flgs = ((uae_s32)(m68k_dreg(regs, (extra >> 16) & 7))) < 0;
	int flgo = ((uae_s32)(dst1)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(m68k_dreg(regs, (extra >> 16) & 7))) > ((uae_u32)(dst1)));
	SET_NFLG(flgn != 0);
	if (GET_ZFLG()) {
		uae_u32 newv = ((uae_u32)(dst2)) - ((uae_u32)(m68k_dreg(regs, extra & 7)));
		int flgs = ((uae_s32)(m68k_dreg(regs, extra & 7))) < 0;
		int flgo = ((uae_s32)(dst2)) < 0;
		int flgn = ((uae_s32)(newv)) < 0;
		SET_ZFLG(((uae_s32)(newv)) == 0);
		SET_VFLG((flgs != flgo) && (flgn != flgo));
		SET_CFLG(((uae_u32)(m68k_dreg(regs, extra & 7))) > ((uae_u32)(dst2)));
		SET_NFLG(flgn != 0);
		if (GET_ZFLG()) {
			x_put_long(rn2, m68k_dreg(regs, (extra >> 6) & 7));
			x_put_long(rn1, m68k_dreg(regs, (extra >> 22) & 7));
		}
	}
	if (!GET_ZFLG()) {
		m68k_dreg(regs, (extra >> 0) & 7) = dst2;
		m68k_dreg(regs, (extra >> 16) & 7) = dst1;
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MOVE.B Dn,Dn */
uae_u32 REGPARAM2 op_1000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),Dn */
uae_u32 REGPARAM2 op_1010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,Dn */
uae_u32 REGPARAM2 op_1018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),Dn */
uae_u32 REGPARAM2 op_1020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),Dn */
uae_u32 REGPARAM2 op_1028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_1030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_1038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_1039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_103a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_103b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_103c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,(An) */
uae_u32 REGPARAM2 op_1080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),(An) */
uae_u32 REGPARAM2 op_1090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An) */
uae_u32 REGPARAM2 op_1098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),(An) */
uae_u32 REGPARAM2 op_10a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An) */
uae_u32 REGPARAM2 op_10a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_10b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An) */
uae_u32 REGPARAM2 op_10b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An) */
uae_u32 REGPARAM2 op_10b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An) */
uae_u32 REGPARAM2 op_10ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_10bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An) */
uae_u32 REGPARAM2 op_10bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,(An)+ */
uae_u32 REGPARAM2 op_10c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),(An)+ */
uae_u32 REGPARAM2 op_10d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,(An)+ */
uae_u32 REGPARAM2 op_10d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),(An)+ */
uae_u32 REGPARAM2 op_10e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),(An)+ */
uae_u32 REGPARAM2 op_10e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_10f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_10f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_10f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_10fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_10fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,(An)+ */
uae_u32 REGPARAM2 op_10fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,-(An) */
uae_u32 REGPARAM2 op_1100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An),-(An) */
uae_u32 REGPARAM2 op_1110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (An)+,-(An) */
uae_u32 REGPARAM2 op_1118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B -(An),-(An) */
uae_u32 REGPARAM2 op_1120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.B (d16,An),-(An) */
uae_u32 REGPARAM2 op_1128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_1130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (xxx).W,-(An) */
uae_u32 REGPARAM2 op_1138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (xxx).L,-(An) */
uae_u32 REGPARAM2 op_1139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,PC),-(An) */
uae_u32 REGPARAM2 op_113a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_113b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B #<data>.B,-(An) */
uae_u32 REGPARAM2 op_113c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_1140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An),(d16,An) */
uae_u32 REGPARAM2 op_1150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An)+,(d16,An) */
uae_u32 REGPARAM2 op_1158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B -(An),(d16,An) */
uae_u32 REGPARAM2 op_1160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_1168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_1170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_1178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_1179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_117a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_117b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(d16,An) */
uae_u32 REGPARAM2 op_117c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_1180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_1190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_1198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.B (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.B (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.B (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_11bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.B #<data>.B,(d8,An,Xn) */
uae_u32 REGPARAM2 op_11bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_11c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An),(xxx).W */
uae_u32 REGPARAM2 op_11d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (An)+,(xxx).W */
uae_u32 REGPARAM2 op_11d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B -(An),(xxx).W */
uae_u32 REGPARAM2 op_11e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.B (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_11e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_11f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_11f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_11f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_11fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_11fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.B #<data>.B,(xxx).W */
uae_u32 REGPARAM2 op_11fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_13c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (An),(xxx).L */
uae_u32 REGPARAM2 op_13d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (An)+,(xxx).L */
uae_u32 REGPARAM2 op_13d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B -(An),(xxx).L */
uae_u32 REGPARAM2 op_13e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.B (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_13e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_13f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.B (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_13f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_13f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_byte(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.B (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_13fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.B (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_13fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.B #<data>.B,(xxx).L */
uae_u32 REGPARAM2 op_13fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_byte(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L Dn,Dn */
uae_u32 REGPARAM2 op_2000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,Dn */
uae_u32 REGPARAM2 op_2008_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),Dn */
uae_u32 REGPARAM2 op_2010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,Dn */
uae_u32 REGPARAM2 op_2018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),Dn */
uae_u32 REGPARAM2 op_2020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),Dn */
uae_u32 REGPARAM2 op_2028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_2030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_2038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_2039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_203a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_203b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_203c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVEA.L Dn,An */
uae_u32 REGPARAM2 op_2040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L An,An */
uae_u32 REGPARAM2 op_2048_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L (An),An */
uae_u32 REGPARAM2 op_2050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L (An)+,An */
uae_u32 REGPARAM2 op_2058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L -(An),An */
uae_u32 REGPARAM2 op_2060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.L (d16,An),An */
uae_u32 REGPARAM2 op_2068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_2070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.L (xxx).W,An */
uae_u32 REGPARAM2 op_2078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.L (xxx).L,An */
uae_u32 REGPARAM2 op_2079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_020_prefetch(6);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVEA.L (d16,PC),An */
uae_u32 REGPARAM2 op_207a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_207b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.L #<data>.L,An */
uae_u32 REGPARAM2 op_207c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	regs.irc = get_word_020_prefetch(6);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,(An) */
uae_u32 REGPARAM2 op_2080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,(An) */
uae_u32 REGPARAM2 op_2088_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),(An) */
uae_u32 REGPARAM2 op_2090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An) */
uae_u32 REGPARAM2 op_2098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),(An) */
uae_u32 REGPARAM2 op_20a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An) */
uae_u32 REGPARAM2 op_20a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_20b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An) */
uae_u32 REGPARAM2 op_20b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An) */
uae_u32 REGPARAM2 op_20b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An) */
uae_u32 REGPARAM2 op_20ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_20bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An) */
uae_u32 REGPARAM2 op_20bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,(An)+ */
uae_u32 REGPARAM2 op_20c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,(An)+ */
uae_u32 REGPARAM2 op_20c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),(An)+ */
uae_u32 REGPARAM2 op_20d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,(An)+ */
uae_u32 REGPARAM2 op_20d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),(An)+ */
uae_u32 REGPARAM2 op_20e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),(An)+ */
uae_u32 REGPARAM2 op_20e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_20f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_20f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_20f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_20fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_20fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,(An)+ */
uae_u32 REGPARAM2 op_20fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,-(An) */
uae_u32 REGPARAM2 op_2100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L An,-(An) */
uae_u32 REGPARAM2 op_2108_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An),-(An) */
uae_u32 REGPARAM2 op_2110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (An)+,-(An) */
uae_u32 REGPARAM2 op_2118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L -(An),-(An) */
uae_u32 REGPARAM2 op_2120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.L (d16,An),-(An) */
uae_u32 REGPARAM2 op_2128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_2130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (xxx).W,-(An) */
uae_u32 REGPARAM2 op_2138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (xxx).L,-(An) */
uae_u32 REGPARAM2 op_2139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,PC),-(An) */
uae_u32 REGPARAM2 op_213a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_213b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L #<data>.L,-(An) */
uae_u32 REGPARAM2 op_213c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_2140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L An,(d16,An) */
uae_u32 REGPARAM2 op_2148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An),(d16,An) */
uae_u32 REGPARAM2 op_2150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An)+,(d16,An) */
uae_u32 REGPARAM2 op_2158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L -(An),(d16,An) */
uae_u32 REGPARAM2 op_2160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_2168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_2170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_2178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_2179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_217a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_217b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(d16,An) */
uae_u32 REGPARAM2 op_217c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L An,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2188_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_2190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_2198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.L (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.L (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.L (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.L (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.L (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.L (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_21bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.L #<data>.L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_21bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_21c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L An,(xxx).W */
uae_u32 REGPARAM2 op_21c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An),(xxx).W */
uae_u32 REGPARAM2 op_21d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (An)+,(xxx).W */
uae_u32 REGPARAM2 op_21d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L -(An),(xxx).W */
uae_u32 REGPARAM2 op_21e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.L (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_21e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_21f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_21f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_21f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_21fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_21fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.L #<data>.L,(xxx).W */
uae_u32 REGPARAM2 op_21fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_23c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L An,(xxx).L */
uae_u32 REGPARAM2 op_23c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (An),(xxx).L */
uae_u32 REGPARAM2 op_23d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (An)+,(xxx).L */
uae_u32 REGPARAM2 op_23d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L -(An),(xxx).L */
uae_u32 REGPARAM2 op_23e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.L (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_23e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_23f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.L (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_23f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_23f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 36; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.L (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_23fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_long(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.L (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_23fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.L #<data>.L,(xxx).L */
uae_u32 REGPARAM2 op_23fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_long(dsta, src);
	m68k_incpci(10);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.W Dn,Dn */
uae_u32 REGPARAM2 op_3000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,Dn */
uae_u32 REGPARAM2 op_3008_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),Dn */
uae_u32 REGPARAM2 op_3010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,Dn */
uae_u32 REGPARAM2 op_3018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),Dn */
uae_u32 REGPARAM2 op_3020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),Dn */
uae_u32 REGPARAM2 op_3028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_3030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_3038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_3039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_303a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_303b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_303c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W Dn,An */
uae_u32 REGPARAM2 op_3040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W An,An */
uae_u32 REGPARAM2 op_3048_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W (An),An */
uae_u32 REGPARAM2 op_3050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W (An)+,An */
uae_u32 REGPARAM2 op_3058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W -(An),An */
uae_u32 REGPARAM2 op_3060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVEA.W (d16,An),An */
uae_u32 REGPARAM2 op_3068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 op_3070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.W (xxx).W,An */
uae_u32 REGPARAM2 op_3078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W (xxx).L,An */
uae_u32 REGPARAM2 op_3079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(6);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVEA.W (d16,PC),An */
uae_u32 REGPARAM2 op_307a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVEA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_307b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVEA.W #<data>.W,An */
uae_u32 REGPARAM2 op_307c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 31;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	src = (uae_s32)(uae_s16)src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (uae_s32)(uae_s16)(src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,(An) */
uae_u32 REGPARAM2 op_3080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,(An) */
uae_u32 REGPARAM2 op_3088_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),(An) */
uae_u32 REGPARAM2 op_3090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An) */
uae_u32 REGPARAM2 op_3098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),(An) */
uae_u32 REGPARAM2 op_30a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An) */
uae_u32 REGPARAM2 op_30a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An) */
uae_u32 REGPARAM2 op_30b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An) */
uae_u32 REGPARAM2 op_30b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An) */
uae_u32 REGPARAM2 op_30b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An) */
uae_u32 REGPARAM2 op_30ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An) */
uae_u32 REGPARAM2 op_30bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_30bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,(An)+ */
uae_u32 REGPARAM2 op_30c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,(An)+ */
uae_u32 REGPARAM2 op_30c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),(An)+ */
uae_u32 REGPARAM2 op_30d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,(An)+ */
uae_u32 REGPARAM2 op_30d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),(An)+ */
uae_u32 REGPARAM2 op_30e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),(An)+ */
uae_u32 REGPARAM2 op_30e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),(An)+ */
uae_u32 REGPARAM2 op_30f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,(An)+ */
uae_u32 REGPARAM2 op_30f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,(An)+ */
uae_u32 REGPARAM2 op_30f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),(An)+ */
uae_u32 REGPARAM2 op_30fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),(An)+ */
uae_u32 REGPARAM2 op_30fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_30fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	m68k_areg(regs, dstreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,-(An) */
uae_u32 REGPARAM2 op_3100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W An,-(An) */
uae_u32 REGPARAM2 op_3108_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An),-(An) */
uae_u32 REGPARAM2 op_3110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (An)+,-(An) */
uae_u32 REGPARAM2 op_3118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W -(An),-(An) */
uae_u32 REGPARAM2 op_3120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MOVE.W (d16,An),-(An) */
uae_u32 REGPARAM2 op_3128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,An,Xn),-(An) */
uae_u32 REGPARAM2 op_3130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (xxx).W,-(An) */
uae_u32 REGPARAM2 op_3138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (xxx).L,-(An) */
uae_u32 REGPARAM2 op_3139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,PC),-(An) */
uae_u32 REGPARAM2 op_313a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d8,PC,Xn),-(An) */
uae_u32 REGPARAM2 op_313b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_313c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	m68k_areg(regs, dstreg) = dsta;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_3140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W An,(d16,An) */
uae_u32 REGPARAM2 op_3148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An),(d16,An) */
uae_u32 REGPARAM2 op_3150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An)+,(d16,An) */
uae_u32 REGPARAM2 op_3158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W -(An),(d16,An) */
uae_u32 REGPARAM2 op_3160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(d16,An) */
uae_u32 REGPARAM2 op_3168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(d16,An) */
uae_u32 REGPARAM2 op_3170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(d16,An) */
uae_u32 REGPARAM2 op_3178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(d16,An) */
uae_u32 REGPARAM2 op_3179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(d16,An) */
uae_u32 REGPARAM2 op_317a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(d16,An) */
uae_u32 REGPARAM2 op_317b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_317c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W An,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3188_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_3190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (An)+,(d8,An,Xn) */
uae_u32 REGPARAM2 op_3198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W -(An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MOVE.W (d16,An),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W (d8,An,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.W (xxx).W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W (xxx).L,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(6);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 2,0   */

/* MOVE.W (d16,PC),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W (d8,PC,Xn),(d8,An,Xn) */
uae_u32 REGPARAM2 op_31bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 1);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,2   */

/* MOVE.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_31bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MOVE.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_31c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W An,(xxx).W */
uae_u32 REGPARAM2 op_31c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An),(xxx).W */
uae_u32 REGPARAM2 op_31d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (An)+,(xxx).W */
uae_u32 REGPARAM2 op_31d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W -(An),(xxx).W */
uae_u32 REGPARAM2 op_31e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MOVE.W (d16,An),(xxx).W */
uae_u32 REGPARAM2 op_31e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).W */
uae_u32 REGPARAM2 op_31f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W (xxx).W,(xxx).W */
uae_u32 REGPARAM2 op_31f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (xxx).L,(xxx).W */
uae_u32 REGPARAM2 op_31f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d16,PC),(xxx).W */
uae_u32 REGPARAM2 op_31fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).W */
uae_u32 REGPARAM2 op_31fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 4,0   */

/* MOVE.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_31fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_33c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W An,(xxx).L */
uae_u32 REGPARAM2 op_33c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (An),(xxx).L */
uae_u32 REGPARAM2 op_33d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (An)+,(xxx).L */
uae_u32 REGPARAM2 op_33d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W -(An),(xxx).L */
uae_u32 REGPARAM2 op_33e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MOVE.W (d16,An),(xxx).L */
uae_u32 REGPARAM2 op_33e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d8,An,Xn),(xxx).L */
uae_u32 REGPARAM2 op_33f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.W (xxx).W,(xxx).L */
uae_u32 REGPARAM2 op_33f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (xxx).L,(xxx).L */
uae_u32 REGPARAM2 op_33f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(6);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(10);
	x_put_word(dsta, src);
	m68k_incpci(10);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 10 0,0   */

/* MOVE.W (d16,PC),(xxx).L */
uae_u32 REGPARAM2 op_33fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MOVE.W (d8,PC,Xn),(xxx).L */
uae_u32 REGPARAM2 op_33fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uaecptr dsta;
	dsta = get_long_020_prefetch(0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 6,0   */

/* MOVE.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_33fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 30;
	CurrentInstrCycles = 20; 
	uae_s16 src = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(8);
	x_put_word(dsta, src);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* NEGX.B Dn */
uae_u32 REGPARAM2 op_4000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B (An) */
uae_u32 REGPARAM2 op_4010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B (An)+ */
uae_u32 REGPARAM2 op_4018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B -(An) */
uae_u32 REGPARAM2 op_4020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.B (d16,An) */
uae_u32 REGPARAM2 op_4028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEGX.B (xxx).W */
uae_u32 REGPARAM2 op_4038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.B (xxx).L */
uae_u32 REGPARAM2 op_4039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEGX.W Dn */
uae_u32 REGPARAM2 op_4040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W (An) */
uae_u32 REGPARAM2 op_4050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W (An)+ */
uae_u32 REGPARAM2 op_4058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W -(An) */
uae_u32 REGPARAM2 op_4060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.W (d16,An) */
uae_u32 REGPARAM2 op_4068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEGX.W (xxx).W */
uae_u32 REGPARAM2 op_4078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.W (xxx).L */
uae_u32 REGPARAM2 op_4079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEGX.L Dn */
uae_u32 REGPARAM2 op_4080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L (An) */
uae_u32 REGPARAM2 op_4090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L (An)+ */
uae_u32 REGPARAM2 op_4098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L -(An) */
uae_u32 REGPARAM2 op_40a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEGX.L (d16,An) */
uae_u32 REGPARAM2 op_40a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_40b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 16;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEGX.L (xxx).W */
uae_u32 REGPARAM2 op_40b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEGX.L (xxx).L */
uae_u32 REGPARAM2 op_40b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 16;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 newv = 0 - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVSR2.W Dn */
uae_u32 REGPARAM2 op_40c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W (An) */
uae_u32 REGPARAM2 op_40d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, regs.sr);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W (An)+ */
uae_u32 REGPARAM2 op_40d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, regs.sr);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W -(An) */
uae_u32 REGPARAM2 op_40e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, regs.sr);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVSR2.W (d16,An) */
uae_u32 REGPARAM2 op_40e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	MakeSR();
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, regs.sr);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVSR2.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_40f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	MakeSR();
	regs.irc = get_word_020_prefetch(0);
	x_put_word(srca, regs.sr);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MVSR2.W (xxx).W */
uae_u32 REGPARAM2 op_40f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	MakeSR();
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, regs.sr);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVSR2.W (xxx).L */
uae_u32 REGPARAM2 op_40f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	MakeSR();
	regs.irc = get_word_020_prefetch(6);
	x_put_word(srca, regs.sr);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CHK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L (An),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L (An)+,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L -(An),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* CHK.L (d16,An),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,An,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* CHK.L (xxx).W,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK.L (xxx).L,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK.L (d16,PC),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_413a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* CHK.L (d8,PC,Xn),Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_413b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* CHK.L #<data>.L,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_413c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 2);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* CHK.W Dn,Dn */
uae_u32 REGPARAM2 op_4180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W (An),Dn */
uae_u32 REGPARAM2 op_4190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W (An)+,Dn */
uae_u32 REGPARAM2 op_4198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W -(An),Dn */
uae_u32 REGPARAM2 op_41a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(2);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CHK.W (d16,An),Dn */
uae_u32 REGPARAM2 op_41a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CHK.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_41b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CHK.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_41b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CHK.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_41b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(6);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CHK.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_41ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CHK.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_41bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CHK.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_41bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 80;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	if (dst > src) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if ((uae_s32)dst < 0) {
		setchkundefinedflags(src, dst, 1);
		Exception_cpu(6);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	setchkundefinedflags(src, dst, 1);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (An),An */
uae_u32 REGPARAM2 op_41d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* LEA.L (d16,An),An */
uae_u32 REGPARAM2 op_41e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_41f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (srca);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* LEA.L (xxx).W,An */
uae_u32 REGPARAM2 op_41f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (xxx).L,An */
uae_u32 REGPARAM2 op_41f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	regs.irc = get_word_020_prefetch(6);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* LEA.L (d16,PC),An */
uae_u32 REGPARAM2 op_41fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* LEA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_41fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 56;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (srca);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.B Dn */
uae_u32 REGPARAM2 op_4200_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((0) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B (An) */
uae_u32 REGPARAM2 op_4210_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B (An)+ */
uae_u32 REGPARAM2 op_4218_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B -(An) */
uae_u32 REGPARAM2 op_4220_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.B (d16,An) */
uae_u32 REGPARAM2 op_4228_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4230_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.B (xxx).W */
uae_u32 REGPARAM2 op_4238_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.B (xxx).L */
uae_u32 REGPARAM2 op_4239_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(0)) == 0);
	SET_NFLG(((uae_s8)(0)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CLR.W Dn */
uae_u32 REGPARAM2 op_4240_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((0) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W (An) */
uae_u32 REGPARAM2 op_4250_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W (An)+ */
uae_u32 REGPARAM2 op_4258_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W -(An) */
uae_u32 REGPARAM2 op_4260_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.W (d16,An) */
uae_u32 REGPARAM2 op_4268_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4270_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(srca, 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.W (xxx).W */
uae_u32 REGPARAM2 op_4278_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.W (xxx).L */
uae_u32 REGPARAM2 op_4279_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(0)) == 0);
	SET_NFLG(((uae_s16)(0)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(srca, 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CLR.L Dn */
uae_u32 REGPARAM2 op_4280_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 4;  
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L (An) */
uae_u32 REGPARAM2 op_4290_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L (An)+ */
uae_u32 REGPARAM2 op_4298_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L -(An) */
uae_u32 REGPARAM2 op_42a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, 0);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CLR.L (d16,An) */
uae_u32 REGPARAM2 op_42a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_42b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 18;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(srca, 0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CLR.L (xxx).W */
uae_u32 REGPARAM2 op_42b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, 0);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CLR.L (xxx).L */
uae_u32 REGPARAM2 op_42b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 18;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(0)) == 0);
	SET_NFLG(((uae_s32)(0)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(srca, 0);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVSR2.B Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 4;  
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((regs.sr & 0xff) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B (An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B -(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* MVSR2.B (d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	MakeSR();
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MVSR2.B (d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 32;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	MakeSR();
	regs.irc = get_word_020_prefetch(0);
	x_put_word(srca, regs.sr & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* MVSR2.B (xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	MakeSR();
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MVSR2.B (xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_42f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 32;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	MakeSR();
	regs.irc = get_word_020_prefetch(6);
	x_put_word(srca, regs.sr & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* NEG.B Dn */
uae_u32 REGPARAM2 op_4400_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B (An) */
uae_u32 REGPARAM2 op_4410_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B (An)+ */
uae_u32 REGPARAM2 op_4418_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B -(An) */
uae_u32 REGPARAM2 op_4420_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.B (d16,An) */
uae_u32 REGPARAM2 op_4428_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4430_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEG.B (xxx).W */
uae_u32 REGPARAM2 op_4438_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.B (xxx).L */
uae_u32 REGPARAM2 op_4439_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ((uae_u8)(0)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(0)) < 0;
	int flgn = ((uae_s8)(dst)) < 0;
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEG.W Dn */
uae_u32 REGPARAM2 op_4440_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W (An) */
uae_u32 REGPARAM2 op_4450_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W (An)+ */
uae_u32 REGPARAM2 op_4458_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W -(An) */
uae_u32 REGPARAM2 op_4460_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.W (d16,An) */
uae_u32 REGPARAM2 op_4468_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4470_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEG.W (xxx).W */
uae_u32 REGPARAM2 op_4478_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.W (xxx).L */
uae_u32 REGPARAM2 op_4479_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ((uae_u16)(0)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(0)) < 0;
	int flgn = ((uae_s16)(dst)) < 0;
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NEG.L Dn */
uae_u32 REGPARAM2 op_4480_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L (An) */
uae_u32 REGPARAM2 op_4490_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L (An)+ */
uae_u32 REGPARAM2 op_4498_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L -(An) */
uae_u32 REGPARAM2 op_44a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NEG.L (d16,An) */
uae_u32 REGPARAM2 op_44a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_44b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 15;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NEG.L (xxx).W */
uae_u32 REGPARAM2 op_44b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NEG.L (xxx).L */
uae_u32 REGPARAM2 op_44b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 15;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ((uae_u32)(0)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(0)) < 0;
	int flgn = ((uae_s32)(dst)) < 0;
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(0)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.B Dn */
uae_u32 REGPARAM2 op_44c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B (An) */
uae_u32 REGPARAM2 op_44d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B (An)+ */
uae_u32 REGPARAM2 op_44d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B -(An) */
uae_u32 REGPARAM2 op_44e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.B (d16,An) */
uae_u32 REGPARAM2 op_44e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_44f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.B (xxx).W */
uae_u32 REGPARAM2 op_44f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.B (xxx).L */
uae_u32 REGPARAM2 op_44f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.B (d16,PC) */
uae_u32 REGPARAM2 op_44fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.B (d8,PC,Xn) */
uae_u32 REGPARAM2 op_44fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.B #<data>.B */
uae_u32 REGPARAM2 op_44fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	MakeSR();
	regs.sr &= 0xFF00;
	regs.sr |= src & 0xFF;
	MakeFromSR();
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.B Dn */
uae_u32 REGPARAM2 op_4600_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((dst) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B (An) */
uae_u32 REGPARAM2 op_4610_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B (An)+ */
uae_u32 REGPARAM2 op_4618_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B -(An) */
uae_u32 REGPARAM2 op_4620_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.B (d16,An) */
uae_u32 REGPARAM2 op_4628_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4630_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NOT.B (xxx).W */
uae_u32 REGPARAM2 op_4638_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.B (xxx).L */
uae_u32 REGPARAM2 op_4639_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(dst)) == 0);
	SET_NFLG(((uae_s8)(dst)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NOT.W Dn */
uae_u32 REGPARAM2 op_4640_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W (An) */
uae_u32 REGPARAM2 op_4650_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W (An)+ */
uae_u32 REGPARAM2 op_4658_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W -(An) */
uae_u32 REGPARAM2 op_4660_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.W (d16,An) */
uae_u32 REGPARAM2 op_4668_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4670_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NOT.W (xxx).W */
uae_u32 REGPARAM2 op_4678_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.W (xxx).L */
uae_u32 REGPARAM2 op_4679_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* NOT.L Dn */
uae_u32 REGPARAM2 op_4680_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L (An) */
uae_u32 REGPARAM2 op_4690_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L (An)+ */
uae_u32 REGPARAM2 op_4698_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L -(An) */
uae_u32 REGPARAM2 op_46a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(srca, dst);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOT.L (d16,An) */
uae_u32 REGPARAM2 op_46a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_46b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 19;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(srca, dst);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NOT.L (xxx).W */
uae_u32 REGPARAM2 op_46b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(srca, dst);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NOT.L (xxx).L */
uae_u32 REGPARAM2 op_46b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 19;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_u32 dst = ~src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(srca, dst);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.W Dn */
uae_u32 REGPARAM2 op_46c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 8;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 src = m68k_dreg(regs, srcreg);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W (An) */
uae_u32 REGPARAM2 op_46d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W (An)+ */
uae_u32 REGPARAM2 op_46d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W -(An) */
uae_u32 REGPARAM2 op_46e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(2);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MV2SR.W (d16,An) */
uae_u32 REGPARAM2 op_46e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_46f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.W (xxx).W */
uae_u32 REGPARAM2 op_46f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.W (xxx).L */
uae_u32 REGPARAM2 op_46f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 20; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(6);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MV2SR.W (d16,PC) */
uae_u32 REGPARAM2 op_46fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 16; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MV2SR.W (d8,PC,Xn) */
uae_u32 REGPARAM2 op_46fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MV2SR.W #<data>.W */
uae_u32 REGPARAM2 op_46fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 33;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s16 src = get_word_020_prefetch(2);
	if(regs.t0) check_t0_trace();
	regs.sr = src;
	MakeFromSR_T0();
	m68k_incpci(4);
	fill_prefetch_020_ntx();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NBCD.B Dn */
uae_u32 REGPARAM2 op_4800_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 6;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* LINK.L An,#<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4808_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	CurrentInstrCycles = 22; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = olda;
	uae_s32 offs;
	offs = get_long_020_prefetch(2);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(olda, src);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* NBCD.B (An) */
uae_u32 REGPARAM2 op_4810_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NBCD.B (An)+ */
uae_u32 REGPARAM2 op_4818_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NBCD.B -(An) */
uae_u32 REGPARAM2 op_4820_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NBCD.B (d16,An) */
uae_u32 REGPARAM2 op_4828_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NBCD.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4830_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 17;
	CurrentInstrCycles = 14; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* NBCD.B (xxx).W */
uae_u32 REGPARAM2 op_4838_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	CurrentInstrCycles = 18; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* NBCD.B (xxx).L */
uae_u32 REGPARAM2 op_4839_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 17;
	CurrentInstrCycles = 22; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_u16 newv_lo = - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = - (src & 0xF0);
	uae_u16 newv;
	int cflg, tmp_newv;
	tmp_newv = newv_hi + newv_lo;
	if (newv_lo > 9) newv_lo -= 6;
	newv = newv_hi + newv_lo;
	cflg = (newv & 0x1F0) > 0x90;
	if (cflg) newv -= 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SWAP.W Dn */
uae_u32 REGPARAM2 op_4840_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 34;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = ((src >> 16)&0xFFFF) | ((src&0xFFFF)<<16);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* BKPTQ.L #<data> */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4848_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 99;
	CurrentInstrCycles = 4;  
	op_illg(opcode);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* PEA.L (An) */
uae_u32 REGPARAM2 op_4850_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, srca);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* PEA.L (d16,An) */
uae_u32 REGPARAM2 op_4868_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* PEA.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4870_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 57;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, srca);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* PEA.L (xxx).W */
uae_u32 REGPARAM2 op_4878_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* PEA.L (xxx).L */
uae_u32 REGPARAM2 op_4879_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, srca);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* PEA.L (d16,PC) */
uae_u32 REGPARAM2 op_487a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, srca);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* PEA.L (d8,PC,Xn) */
uae_u32 REGPARAM2 op_487b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 57;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uaecptr dsta;
	dsta = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = dsta;
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, srca);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EXT.W Dn */
uae_u32 REGPARAM2 op_4880_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u16 dst = (uae_s16)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(dst)) == 0);
	SET_NFLG(((uae_s16)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | ((dst) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVMLE.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_4890_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,-(An) */
uae_u32 REGPARAM2 op_48a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = 1;
	while (amask) {
		srca -= 2;
		if (!type || movem_index2[amask] != dstreg) {
			x_put_word(srca, m68k_areg(regs, movem_index2[amask]));
			count_cycles += 4 * CYCLE_UNIT / 2;
		} else {
			x_put_word(srca, m68k_areg(regs, movem_index2[amask]) - 2);
			count_cycles += 4 * CYCLE_UNIT / 2;
		}
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 2;
		x_put_word(srca, m68k_dreg(regs, movem_index2[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_48a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_48b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMLE.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_48b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_48b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = get_long_020_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_word(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_word(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EXT.L Dn */
uae_u32 REGPARAM2 op_48c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = (uae_s32)(uae_s16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVMLE.L #<data>.W,(An) */
uae_u32 REGPARAM2 op_48d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,-(An) */
uae_u32 REGPARAM2 op_48e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) - 0;
	uae_u16 amask = mask & 0xff, dmask = (mask >> 8) & 0xff;
	int type = 1;
	while (amask) {
		srca -= 4;
		if (!type || movem_index2[amask] != dstreg) {
			x_put_long(srca, m68k_areg(regs, movem_index2[amask]));
			count_cycles += 4 * CYCLE_UNIT / 2;
		} else {
			x_put_long(srca, m68k_areg(regs, movem_index2[amask]) - 4);
			count_cycles += 4 * CYCLE_UNIT / 2;
		}
		amask = movem_next[amask];
	}
	while (dmask) {
		srca -= 4;
		x_put_long(srca, m68k_dreg(regs, movem_index2[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		dmask = movem_next[dmask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMLE.L #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_48e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_48f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 38;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMLE.L #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_48f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMLE.L #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_48f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 38;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_word_020_prefetch(2);
	uaecptr srca;
	srca = get_long_020_prefetch(4);
	uae_u16 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	while (dmask) {
		x_put_long(srca, m68k_dreg(regs, movem_index1[dmask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		x_put_long(srca, m68k_areg(regs, movem_index1[amask]));
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* EXT.B Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_49c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 36;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_u32 dst = (uae_s32)(uae_s8)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(dst)) == 0);
	SET_NFLG(((uae_s32)(dst)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* TST.B Dn */
uae_u32 REGPARAM2 op_4a00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B (An) */
uae_u32 REGPARAM2 op_4a10_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B (An)+ */
uae_u32 REGPARAM2 op_4a18_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B -(An) */
uae_u32 REGPARAM2 op_4a20_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.B (d16,An) */
uae_u32 REGPARAM2 op_4a28_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4a30_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TST.B (xxx).W */
uae_u32 REGPARAM2 op_4a38_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.B (xxx).L */
uae_u32 REGPARAM2 op_4a39_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TST.B (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a3a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.B (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a3b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* TST.B #<data>.B */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a3c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.W Dn */
uae_u32 REGPARAM2 op_4a40_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W An */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a48_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* TST.W (An) */
uae_u32 REGPARAM2 op_4a50_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W (An)+ */
uae_u32 REGPARAM2 op_4a58_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W -(An) */
uae_u32 REGPARAM2 op_4a60_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.W (d16,An) */
uae_u32 REGPARAM2 op_4a68_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.W (d8,An,Xn) */
uae_u32 REGPARAM2 op_4a70_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TST.W (xxx).W */
uae_u32 REGPARAM2 op_4a78_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.W (xxx).L */
uae_u32 REGPARAM2 op_4a79_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TST.W (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a7a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.W (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a7b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* TST.W #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a7c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.L Dn */
uae_u32 REGPARAM2 op_4a80_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L An */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4a88_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* TST.L (An) */
uae_u32 REGPARAM2 op_4a90_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L (An)+ */
uae_u32 REGPARAM2 op_4a98_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L -(An) */
uae_u32 REGPARAM2 op_4aa0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TST.L (d16,An) */
uae_u32 REGPARAM2 op_4aa8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4ab0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TST.L (xxx).W */
uae_u32 REGPARAM2 op_4ab8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TST.L (xxx).L */
uae_u32 REGPARAM2 op_4ab9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TST.L (d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4aba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TST.L (d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4abb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

#endif
/* TST.L #<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4abc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 20;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TAS.B Dn */
uae_u32 REGPARAM2 op_4ac0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((src) & 0xff);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TAS.B (An) */
uae_u32 REGPARAM2 op_4ad0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TAS.B (An)+ */
uae_u32 REGPARAM2 op_4ad8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TAS.B -(An) */
uae_u32 REGPARAM2 op_4ae0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* TAS.B (d16,An) */
uae_u32 REGPARAM2 op_4ae8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TAS.B (d8,An,Xn) */
uae_u32 REGPARAM2 op_4af0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 98;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_020_prefetch(0);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* TAS.B (xxx).W */
uae_u32 REGPARAM2 op_4af8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* TAS.B (xxx).L */
uae_u32 REGPARAM2 op_4af9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 98;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	src |= 0x80;
	x_put_byte(srca, src);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MULL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 34; 
	uae_s16 extra = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c10_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 42; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c18_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 42; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c20_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 42; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	m68k_incpci(4);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MULL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c28_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 46; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c30_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 87;
	CurrentInstrCycles = 42; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c38_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	CurrentInstrCycles = 46; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c39_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	CurrentInstrCycles = 50; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MULL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c3a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 87;
	CurrentInstrCycles = 46; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(6);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* MULL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c3b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 87;
	CurrentInstrCycles = 42; 
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 dst = x_get_long(dsta);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* MULL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c3c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 87;
	CurrentInstrCycles = 42; 
	uae_s16 extra = get_word_020_prefetch(2);
	uae_s32 dst;
	dst = get_long_020_prefetch(4);
	m68k_incpci(8);
	int e = m68k_mull(opcode, dst, extra);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c40_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 54; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c50_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 62; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(An)+ */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c58_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 62; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c60_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 62; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	m68k_incpci(4);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c68_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 66; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,An,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c70_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 86;
	CurrentInstrCycles = 62; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,(xxx).W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c78_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	CurrentInstrCycles = 66; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(xxx).L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c79_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	CurrentInstrCycles = 70; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = get_long_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* DIVL.L #<data>.W,(d16,PC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c7a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 86;
	CurrentInstrCycles = 66; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	dsta = m68k_getpci() + 4;
	dsta += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	uae_s32 dst = x_get_long(dsta);
	m68k_incpci(6);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* DIVL.L #<data>.W,(d8,PC,Xn) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c7b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 86;
	CurrentInstrCycles = 62; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uaecptr dsta;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	dsta = x_get_disp_ea_020(tmppc, 0);
	uae_s32 dst = x_get_long(dsta);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

#endif
/* DIVL.L #<data>.W,#<data>.L */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4c7c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 86;
	CurrentInstrCycles = 62; 
	uaecptr oldpc = m68k_getpci();
	uae_s16 extra = get_word_020_prefetch(2);
	uae_s32 dst;
	dst = get_long_020_prefetch(4);
	m68k_incpci(8);
	int e = m68k_divl(opcode, dst, extra, oldpc);
	if (e <= 0) {
		if (e < 0) {
			op_unimpl(opcode);
		}
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

#endif
/* MVMEL.W #<data>.W,(An) */
uae_u32 REGPARAM2 op_4c90_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_4c98_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.W #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_4ca8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_4cb0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMEL.W #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_4cb8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_4cb9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_long_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MVMEL.W #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 op_4cba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.W #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_4cbb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = (uae_s32)(uae_s16)x_get_word(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 2;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(An) */
uae_u32 REGPARAM2 op_4cd0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(An)+ */
uae_u32 REGPARAM2 op_4cd8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	m68k_areg(regs, dstreg) = srca;
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MVMEL.L #<data>.W,(d16,An) */
uae_u32 REGPARAM2 op_4ce8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,An,Xn) */
uae_u32 REGPARAM2 op_4cf0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	srca = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* MVMEL.L #<data>.W,(xxx).W */
uae_u32 REGPARAM2 op_4cf8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(xxx).L */
uae_u32 REGPARAM2 op_4cf9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 37;
	CurrentInstrCycles = 16; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = get_long_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(8);
	m68k_incpci(8);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 8 0,0   */

/* MVMEL.L #<data>.W,(d16,PC) */
uae_u32 REGPARAM2 op_4cfa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 2;
	OpcodeFamily = 37;
	CurrentInstrCycles = 12; 
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	srca = m68k_getpci() + 4;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(4);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MVMEL.L #<data>.W,(d8,PC,Xn) */
uae_u32 REGPARAM2 op_4cfb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 dstreg = 3;
	OpcodeFamily = 37;
	CurrentInstrCycles = 8;  
	uae_u16 mask = get_word_020_prefetch(2);
	uae_u32 dmask = mask & 0xff, amask = (mask >> 8) & 0xff;
	uaecptr srca;
	m68k_incpci(4);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	while (dmask) {
		m68k_dreg(regs, movem_index1[dmask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		dmask = movem_next[dmask];
	}
	while (amask) {
		m68k_areg(regs, movem_index1[amask]) = x_get_long(srca);
		count_cycles += 4 * CYCLE_UNIT / 2;
		srca += 4;
		amask = movem_next[amask];
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 2,0   */

/* TRAPQ.L #<data> */
uae_u32 REGPARAM2 op_4e40_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 15);
	OpcodeFamily = 39;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	m68k_incpci(2);
	Exception_cpu(src + 32);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* LINK.W An,#<data>.W */
uae_u32 REGPARAM2 op_4e50_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 47;
	CurrentInstrCycles = 16; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uaecptr olda;
	olda = m68k_areg(regs, 7) - 4;
	m68k_areg(regs, 7) = olda;
	uae_s16 offs = get_word_020_prefetch(2);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(olda, src);
	m68k_areg(regs, srcreg) = (m68k_areg(regs, 7));
	m68k_areg(regs, 7) += offs;
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* UNLK.L An */
uae_u32 REGPARAM2 op_4e58_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 48;
	CurrentInstrCycles = 13; 
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_u32 olda = src;
	uae_s32 old = x_get_long(olda);
	m68k_areg(regs, 7) = src + 4;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, srcreg) = (old);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVR2USP.L An */
uae_u32 REGPARAM2 op_4e60_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 40;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uae_s32 src = m68k_areg(regs, srcreg);
	regs.usp = src;
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MVUSP2R.L An */
uae_u32 REGPARAM2 op_4e68_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 41;
	CurrentInstrCycles = 4;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, srcreg) = (regs.usp);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* RESET.L  */
uae_u32 REGPARAM2 op_4e70_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 42;
	CurrentInstrCycles = 6;  
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	bool r = cpureset();
	if (r) {
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* NOP.L  */
uae_u32 REGPARAM2 op_4e71_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 43;
	CurrentInstrCycles = 4;  
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* STOP.L #<data>.W */
uae_u32 REGPARAM2 op_4e72_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 44;
	CurrentInstrCycles = 12; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	if (!regs.stopped) {
		uae_s16 src = get_word_020_prefetch(2);
		regs.ir = src;
	}
	uae_u16 sr = regs.ir;
	regs.sr = sr;
	checkint();
	MakeFromSR_STOP();
	do_cycles_stop(4);
	m68k_setstopped(1);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}

/* RTE.L  */
uae_u32 REGPARAM2 op_4e73_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 45;
	CurrentInstrCycles = 34; 
	if (!regs.s) {
		Exception(8);
		return 0;
	}
	uaecptr oldpc = m68k_getpci();
	uae_u16 oldsr = regs.sr, newsr;
	uae_u32 newpc;
	for (;;) {
		uaecptr a = m68k_areg(regs, 7);
		uae_u16 sr = x_get_word(a);
		uae_u32 pc = x_get_long(a + 2);
		uae_u16 format = x_get_word(a + 2 + 4);
		int frame = format >> 12;
		int offset = 8;
		newsr = sr; newpc = pc;
		if (frame == 0x0) {
		m68k_areg(regs, 7) += offset; break; }
		else if (frame == 0x1) {
		m68k_areg(regs, 7) += offset; }
		else if (frame == 0x2) {
		m68k_areg(regs, 7) += offset + 4; break; }
		else if (frame == 0x9) {
		m68k_areg(regs, 7) += offset + 12; break; }
		else if (frame == 0xa) {
		m68k_areg(regs, 7) += offset + 24; break; }
		else if (frame == 0xb) {
		m68k_areg(regs, 7) += offset + 84; break; }
		else {
			Exception_cpu(14);
			return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		regs.sr = newsr;
		oldsr = newsr;
		MakeFromSR_T0();
	}
	regs.sr = newsr;
	MakeFromSR_T0();
	if (newpc & 1) {
		exception3_read_prefetch(opcode, newpc);
		return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(newpc);
	#ifdef DEBUGGER
	branch_stack_pop_rte(oldpc);
	#endif
	fill_prefetch_020_ntx();
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* RTD.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4e74_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 46;
	CurrentInstrCycles = 18; 
	uaecptr oldpc = m68k_getpci();
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	uae_s32 pc = x_get_long(pca);
	m68k_areg(regs, 7) += 4;
	uae_s16 offs = get_word_020_prefetch(2);
	m68k_areg(regs, 7) += offs;
	if (pc & 1) {
		exception3_read_prefetch_only(opcode, pc);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(pc);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

#endif
/* RTS.L  */
uae_u32 REGPARAM2 op_4e75_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 49;
	CurrentInstrCycles = 17; 
	uaecptr oldpc = m68k_getpci();
	m68k_do_rtsi();
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_pop_rts(oldpc);
	}
	#endif
	if (m68k_getpci() & 1) {
		uaecptr faultpc = m68k_getpci();
		m68k_setpci_j(oldpc);
		exception3_read_prefetch_only(opcode, faultpc);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* TRAPV.L  */
uae_u32 REGPARAM2 op_4e76_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 50;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (GET_VFLG()) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* RTR.L  */
uae_u32 REGPARAM2 op_4e77_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 51;
	CurrentInstrCycles = 24; 
	uaecptr oldpc = m68k_getpci();
	MakeSR();
	uaecptr sra;
	sra = m68k_areg(regs, 7);
	uae_s16 sr = x_get_word(sra);
	m68k_areg(regs, 7) += 2;
	uaecptr pca;
	pca = m68k_areg(regs, 7);
	uae_s32 pc = x_get_long(pca);
	m68k_areg(regs, 7) += 4;
	regs.sr &= 0xFF00; sr &= 0xFF;
	regs.sr |= sr;
	MakeFromSR();
	m68k_setpci_j(pc);
	if (m68k_getpci() & 1) {
		uaecptr faultpc = m68k_getpci();
		m68k_setpci_j(oldpc + 2);
		exception3_read_prefetch_only(opcode, faultpc);
		return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	fill_prefetch_020();
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* MOVEC2.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4e7a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 82;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_020_prefetch(2);
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_movec2(src & 0xFFF, regp)) {
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* MOVE2C.L #<data>.W */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_4e7b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 83;
	CurrentInstrCycles = 10; 
	uae_s16 src = get_word_020_prefetch(2);
	int regno = (src >> 12) & 15;
	uae_u32 *regp = regs.regs + regno;
	if (!m68k_move2c(src & 0xFFF, regp)) {
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* JSR.L (An) */
uae_u32 REGPARAM2 op_4e90_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* JSR.L (d16,An) */
uae_u32 REGPARAM2 op_4ea8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JSR.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4eb0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 52;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* JSR.L (xxx).W */
uae_u32 REGPARAM2 op_4eb8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JSR.L (xxx).L */
uae_u32 REGPARAM2 op_4eb9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* JSR.L (d16,PC) */
uae_u32 REGPARAM2 op_4eba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JSR.L (d8,PC,Xn) */
uae_u32 REGPARAM2 op_4ebb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 52;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 0;
	m68k_setpci_j(srca);
	m68k_areg(regs, 7) -= 4;
	if (m68k_getpci() & 1) {
		exception3_read_prefetch(opcode, m68k_getpci());
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	x_put_long(m68k_areg(regs, 7), nextpc);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* JMP.L (An) */
uae_u32 REGPARAM2 op_4ed0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(srca);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* JMP.L (d16,An) */
uae_u32 REGPARAM2 op_4ee8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(srca);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JMP.L (d8,An,Xn) */
uae_u32 REGPARAM2 op_4ef0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 53;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(srca);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* JMP.L (xxx).W */
uae_u32 REGPARAM2 op_4ef8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(srca);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JMP.L (xxx).L */
uae_u32 REGPARAM2 op_4ef9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(srca);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* JMP.L (d16,PC) */
uae_u32 REGPARAM2 op_4efa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 2 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(srca);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* JMP.L (d8,PC,Xn) */
uae_u32 REGPARAM2 op_4efb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 53;
	CurrentInstrCycles = 4;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uaecptr oldpc = m68k_getpci();
	if (srca & 1) {
		count_cycles += 6 * CYCLE_UNIT / 2;
		m68k_incpci(2);
		exception3_read_prefetch_only(opcode, srca);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_setpci_j(srca);
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0 B */

/* ADDQ.B #<data>,Dn */
uae_u32 REGPARAM2 op_5000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An) */
uae_u32 REGPARAM2 op_5010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(An)+ */
uae_u32 REGPARAM2 op_5018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,-(An) */
uae_u32 REGPARAM2 op_5020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.B #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* ADDQ.B #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.B #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) + ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u8)(~dst)) < ((uae_u8)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADDQ.W #<data>,Dn */
uae_u32 REGPARAM2 op_5040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDAQ.W #<data>,An */
uae_u32 REGPARAM2 op_5048_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst + src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An) */
uae_u32 REGPARAM2 op_5050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(An)+ */
uae_u32 REGPARAM2 op_5058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,-(An) */
uae_u32 REGPARAM2 op_5060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.W #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* ADDQ.W #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.W #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) + ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u16)(~dst)) < ((uae_u16)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* ADDQ.L #<data>,Dn */
uae_u32 REGPARAM2 op_5080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDAQ.L #<data>,An */
uae_u32 REGPARAM2 op_5088_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 12;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst + src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An) */
uae_u32 REGPARAM2 op_5090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(An)+ */
uae_u32 REGPARAM2 op_5098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,-(An) */
uae_u32 REGPARAM2 op_50a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ADDQ.L #<data>,(d16,An) */
uae_u32 REGPARAM2 op_50a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_50b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 11;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* ADDQ.L #<data>,(xxx).W */
uae_u32 REGPARAM2 op_50b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ADDQ.L #<data>,(xxx).L */
uae_u32 REGPARAM2 op_50b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 11;
	CurrentInstrCycles = 28; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) + ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgn) & (flgo ^ flgn));
	SET_CFLG(((uae_u32)(~dst)) < ((uae_u32)(src)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* Scc.B Dn (T) */
uae_u32 REGPARAM2 op_50c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (T) */
uae_u32 REGPARAM2 op_50c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(0)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (T) */
uae_u32 REGPARAM2 op_50d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (T) */
uae_u32 REGPARAM2 op_50d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (T) */
uae_u32 REGPARAM2 op_50e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (T) */
uae_u32 REGPARAM2 op_50e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (T) */
uae_u32 REGPARAM2 op_50f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (T) */
uae_u32 REGPARAM2 op_50f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (T) */
uae_u32 REGPARAM2 op_50f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(0) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (T) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_50fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(0)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (T) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_50fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(0)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (T) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_50fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(0)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* SUBQ.B #<data>,Dn */
uae_u32 REGPARAM2 op_5100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An) */
uae_u32 REGPARAM2 op_5110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(An)+ */
uae_u32 REGPARAM2 op_5118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,-(An) */
uae_u32 REGPARAM2 op_5120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.B #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBQ.B #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.B #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBQ.W #<data>,Dn */
uae_u32 REGPARAM2 op_5140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBAQ.W #<data>,An */
uae_u32 REGPARAM2 op_5148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An) */
uae_u32 REGPARAM2 op_5150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(An)+ */
uae_u32 REGPARAM2 op_5158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,-(An) */
uae_u32 REGPARAM2 op_5160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.W #<data>,(d16,An) */
uae_u32 REGPARAM2 op_5168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_5170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBQ.W #<data>,(xxx).W */
uae_u32 REGPARAM2 op_5178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.W #<data>,(xxx).L */
uae_u32 REGPARAM2 op_5179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBQ.L #<data>,Dn */
uae_u32 REGPARAM2 op_5180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBAQ.L #<data>,An */
uae_u32 REGPARAM2 op_5188_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An) */
uae_u32 REGPARAM2 op_5190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(An)+ */
uae_u32 REGPARAM2 op_5198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,-(An) */
uae_u32 REGPARAM2 op_51a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBQ.L #<data>,(d16,An) */
uae_u32 REGPARAM2 op_51a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(d8,An,Xn) */
uae_u32 REGPARAM2 op_51b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBQ.L #<data>,(xxx).W */
uae_u32 REGPARAM2 op_51b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBQ.L #<data>,(xxx).L */
uae_u32 REGPARAM2 op_51b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = imm8_table[((real_opcode >> 9) & 7)];
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_u32 src = srcreg;
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* Scc.B Dn (F) */
uae_u32 REGPARAM2 op_51c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (F) */
uae_u32 REGPARAM2 op_51c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(1)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (F) */
uae_u32 REGPARAM2 op_51d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (F) */
uae_u32 REGPARAM2 op_51d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (F) */
uae_u32 REGPARAM2 op_51e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (F) */
uae_u32 REGPARAM2 op_51e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (F) */
uae_u32 REGPARAM2 op_51f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (F) */
uae_u32 REGPARAM2 op_51f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (F) */
uae_u32 REGPARAM2 op_51f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(1) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (F) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_51fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(1)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (F) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_51fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(1)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (F) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_51fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(1)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (HI) */
uae_u32 REGPARAM2 op_52c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (HI) */
uae_u32 REGPARAM2 op_52c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(2)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (HI) */
uae_u32 REGPARAM2 op_52d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (HI) */
uae_u32 REGPARAM2 op_52d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (HI) */
uae_u32 REGPARAM2 op_52e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (HI) */
uae_u32 REGPARAM2 op_52e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (HI) */
uae_u32 REGPARAM2 op_52f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (HI) */
uae_u32 REGPARAM2 op_52f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (HI) */
uae_u32 REGPARAM2 op_52f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(2) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (HI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_52fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(2)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (HI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_52fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(2)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (HI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_52fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(2)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LS) */
uae_u32 REGPARAM2 op_53c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LS) */
uae_u32 REGPARAM2 op_53c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(3)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (LS) */
uae_u32 REGPARAM2 op_53d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (LS) */
uae_u32 REGPARAM2 op_53d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (LS) */
uae_u32 REGPARAM2 op_53e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LS) */
uae_u32 REGPARAM2 op_53e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LS) */
uae_u32 REGPARAM2 op_53f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LS) */
uae_u32 REGPARAM2 op_53f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LS) */
uae_u32 REGPARAM2 op_53f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(3) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_53fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(3)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_53fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(3)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_53fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(3)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CC) */
uae_u32 REGPARAM2 op_54c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CC) */
uae_u32 REGPARAM2 op_54c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(4)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (CC) */
uae_u32 REGPARAM2 op_54d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (CC) */
uae_u32 REGPARAM2 op_54d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (CC) */
uae_u32 REGPARAM2 op_54e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CC) */
uae_u32 REGPARAM2 op_54e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CC) */
uae_u32 REGPARAM2 op_54f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CC) */
uae_u32 REGPARAM2 op_54f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CC) */
uae_u32 REGPARAM2 op_54f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(4) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_54fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(4)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_54fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(4)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_54fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(4)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (CS) */
uae_u32 REGPARAM2 op_55c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (CS) */
uae_u32 REGPARAM2 op_55c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(5)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (CS) */
uae_u32 REGPARAM2 op_55d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (CS) */
uae_u32 REGPARAM2 op_55d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (CS) */
uae_u32 REGPARAM2 op_55e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (CS) */
uae_u32 REGPARAM2 op_55e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (CS) */
uae_u32 REGPARAM2 op_55f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (CS) */
uae_u32 REGPARAM2 op_55f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (CS) */
uae_u32 REGPARAM2 op_55f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(5) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (CS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_55fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(5)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (CS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_55fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(5)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (CS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_55fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(5)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (NE) */
uae_u32 REGPARAM2 op_56c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (NE) */
uae_u32 REGPARAM2 op_56c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(6)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (NE) */
uae_u32 REGPARAM2 op_56d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (NE) */
uae_u32 REGPARAM2 op_56d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (NE) */
uae_u32 REGPARAM2 op_56e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (NE) */
uae_u32 REGPARAM2 op_56e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (NE) */
uae_u32 REGPARAM2 op_56f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (NE) */
uae_u32 REGPARAM2 op_56f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (NE) */
uae_u32 REGPARAM2 op_56f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(6) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (NE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_56fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(6)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (NE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_56fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(6)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (NE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_56fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(6)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (EQ) */
uae_u32 REGPARAM2 op_57c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (EQ) */
uae_u32 REGPARAM2 op_57c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(7)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (EQ) */
uae_u32 REGPARAM2 op_57d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (EQ) */
uae_u32 REGPARAM2 op_57d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (EQ) */
uae_u32 REGPARAM2 op_57e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (EQ) */
uae_u32 REGPARAM2 op_57e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (EQ) */
uae_u32 REGPARAM2 op_57f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (EQ) */
uae_u32 REGPARAM2 op_57f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (EQ) */
uae_u32 REGPARAM2 op_57f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(7) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (EQ) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_57fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(7)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (EQ) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_57fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(7)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (EQ) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_57fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(7)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VC) */
uae_u32 REGPARAM2 op_58c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VC) */
uae_u32 REGPARAM2 op_58c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(8)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (VC) */
uae_u32 REGPARAM2 op_58d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (VC) */
uae_u32 REGPARAM2 op_58d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (VC) */
uae_u32 REGPARAM2 op_58e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VC) */
uae_u32 REGPARAM2 op_58e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VC) */
uae_u32 REGPARAM2 op_58f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VC) */
uae_u32 REGPARAM2 op_58f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VC) */
uae_u32 REGPARAM2 op_58f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(8) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_58fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(8)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_58fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(8)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VC) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_58fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(8)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (VS) */
uae_u32 REGPARAM2 op_59c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (VS) */
uae_u32 REGPARAM2 op_59c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(9)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (VS) */
uae_u32 REGPARAM2 op_59d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (VS) */
uae_u32 REGPARAM2 op_59d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (VS) */
uae_u32 REGPARAM2 op_59e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (VS) */
uae_u32 REGPARAM2 op_59e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (VS) */
uae_u32 REGPARAM2 op_59f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (VS) */
uae_u32 REGPARAM2 op_59f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (VS) */
uae_u32 REGPARAM2 op_59f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(9) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (VS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_59fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(9)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (VS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_59fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(9)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (VS) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_59fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(9)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (PL) */
uae_u32 REGPARAM2 op_5ac0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (PL) */
uae_u32 REGPARAM2 op_5ac8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(10)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (PL) */
uae_u32 REGPARAM2 op_5ad0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (PL) */
uae_u32 REGPARAM2 op_5ad8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (PL) */
uae_u32 REGPARAM2 op_5ae0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (PL) */
uae_u32 REGPARAM2 op_5ae8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (PL) */
uae_u32 REGPARAM2 op_5af0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (PL) */
uae_u32 REGPARAM2 op_5af8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (PL) */
uae_u32 REGPARAM2 op_5af9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(10) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (PL) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5afa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(10)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (PL) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5afb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(10)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (PL) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5afc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(10)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (MI) */
uae_u32 REGPARAM2 op_5bc0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (MI) */
uae_u32 REGPARAM2 op_5bc8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(11)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (MI) */
uae_u32 REGPARAM2 op_5bd0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (MI) */
uae_u32 REGPARAM2 op_5bd8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (MI) */
uae_u32 REGPARAM2 op_5be0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (MI) */
uae_u32 REGPARAM2 op_5be8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (MI) */
uae_u32 REGPARAM2 op_5bf0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (MI) */
uae_u32 REGPARAM2 op_5bf8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (MI) */
uae_u32 REGPARAM2 op_5bf9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(11) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (MI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5bfa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(11)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (MI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5bfb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(11)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (MI) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5bfc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(11)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GE) */
uae_u32 REGPARAM2 op_5cc0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GE) */
uae_u32 REGPARAM2 op_5cc8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(12)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (GE) */
uae_u32 REGPARAM2 op_5cd0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (GE) */
uae_u32 REGPARAM2 op_5cd8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (GE) */
uae_u32 REGPARAM2 op_5ce0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GE) */
uae_u32 REGPARAM2 op_5ce8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GE) */
uae_u32 REGPARAM2 op_5cf0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GE) */
uae_u32 REGPARAM2 op_5cf8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GE) */
uae_u32 REGPARAM2 op_5cf9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(12) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5cfa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(12)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5cfb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(12)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5cfc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(12)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LT) */
uae_u32 REGPARAM2 op_5dc0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LT) */
uae_u32 REGPARAM2 op_5dc8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(13)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (LT) */
uae_u32 REGPARAM2 op_5dd0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (LT) */
uae_u32 REGPARAM2 op_5dd8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (LT) */
uae_u32 REGPARAM2 op_5de0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LT) */
uae_u32 REGPARAM2 op_5de8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LT) */
uae_u32 REGPARAM2 op_5df0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LT) */
uae_u32 REGPARAM2 op_5df8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LT) */
uae_u32 REGPARAM2 op_5df9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(13) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5dfa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(13)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5dfb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(13)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5dfc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(13)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (GT) */
uae_u32 REGPARAM2 op_5ec0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (GT) */
uae_u32 REGPARAM2 op_5ec8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(14)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (GT) */
uae_u32 REGPARAM2 op_5ed0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (GT) */
uae_u32 REGPARAM2 op_5ed8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (GT) */
uae_u32 REGPARAM2 op_5ee0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (GT) */
uae_u32 REGPARAM2 op_5ee8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (GT) */
uae_u32 REGPARAM2 op_5ef0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (GT) */
uae_u32 REGPARAM2 op_5ef8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (GT) */
uae_u32 REGPARAM2 op_5ef9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(14) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (GT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5efa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(14)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (GT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5efb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(14)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (GT) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5efc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(14)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Scc.B Dn (LE) */
uae_u32 REGPARAM2 op_5fc0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 4;  
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xff) | ((val) & 0xff);
	count_cycles += ((val ? 2 : 0)) * CYCLE_UNIT / 2;
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DBcc.W Dn,#<data>.W (LE) */
uae_u32 REGPARAM2 op_5fc8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 58;
	CurrentInstrCycles = 8;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 offs = get_word_020_prefetch(2);
	uaecptr oldpc = m68k_getpci();
	if (!cctrue(15)) {
		m68k_incpci((uae_s32)offs + 2);
		m68k_dreg(regs, srcreg) = (m68k_dreg(regs, srcreg) & ~0xffff) | (((src - 1)) & 0xffff);
		if (offs & 1) {
			exception3_read_prefetch(opcode, m68k_getpci());
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		if (src) {
			fill_prefetch_020();
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		count_cycles += 6 * CYCLE_UNIT / 2;
	}
	m68k_setpci_j(oldpc + 4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* Scc.B (An) (LE) */
uae_u32 REGPARAM2 op_5fd0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (An)+ (LE) */
uae_u32 REGPARAM2 op_5fd8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B -(An) (LE) */
uae_u32 REGPARAM2 op_5fe0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	m68k_areg(regs, srcreg) = srca;
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(srca, val);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* Scc.B (d16,An) (LE) */
uae_u32 REGPARAM2 op_5fe8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (d8,An,Xn) (LE) */
uae_u32 REGPARAM2 op_5ff0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	OpcodeFamily = 59;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(srca, val);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* Scc.B (xxx).W (LE) */
uae_u32 REGPARAM2 op_5ff8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(srca, val);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* Scc.B (xxx).L (LE) */
uae_u32 REGPARAM2 op_5ff9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 59;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	int val = cctrue(15) ? 0xff : 0x00;
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(srca, val);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* TRAPcc.L #<data>.W (LE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5ffa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 8;  
	uae_s16 dummy = get_word_020_prefetch(2);
	m68k_incpci(4);
	if (cctrue(15)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* TRAPcc.L #<data>.L (LE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5ffb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 12; 
	uae_s32 dummy;
	dummy = get_long_020_prefetch(2);
	m68k_incpci(6);
	if (cctrue(15)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

#endif
/* TRAPcc.L  (LE) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_5ffc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 102;
	CurrentInstrCycles = 4;  
	m68k_incpci(2);
	if (cctrue(15)) {
		Exception_cpu(7);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

#endif
/* Bcc.W #<data>.W (T) */
uae_u32 REGPARAM2 op_6000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (T) */
uae_u32 REGPARAM2 op_6001_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (T) */
uae_u32 REGPARAM2 op_60ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(0)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* BSR.W #<data>.W */
uae_u32 REGPARAM2 op_6100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	CurrentInstrCycles = 14; 
	uae_s32 s;
	uae_s16 src = get_word_020_prefetch(2);
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 4;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_do_bsri(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BSRQ.B #<data> */
uae_u32 REGPARAM2 op_6101_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 54;
	CurrentInstrCycles = 14; 
	uae_s32 s;
	uae_u32 src = srcreg;
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 2;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_do_bsri(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* BSR.L #<data>.L */
uae_u32 REGPARAM2 op_61ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 54;
	CurrentInstrCycles = 18; 
	uae_s32 s;
	uae_s32 src;
	src = get_long_020_prefetch(2);
	s = (uae_s32)src + 2;
	uaecptr oldpc = m68k_getpci();
	uaecptr nextpc = oldpc + 6;
	if (s & 1) {
		m68k_areg(regs, 7) -= 4;
		exception3_read_prefetch(opcode, oldpc + s);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_do_bsri(nextpc, s);
	#ifdef DEBUGGER
	if (debugmem_trace) {
		branch_stack_push(oldpc, nextpc);
	}
	#endif
	fill_prefetch_020();
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (HI) */
uae_u32 REGPARAM2 op_6200_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (HI) */
uae_u32 REGPARAM2 op_6201_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (HI) */
uae_u32 REGPARAM2 op_62ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(2)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LS) */
uae_u32 REGPARAM2 op_6300_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LS) */
uae_u32 REGPARAM2 op_6301_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LS) */
uae_u32 REGPARAM2 op_63ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(3)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CC) */
uae_u32 REGPARAM2 op_6400_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CC) */
uae_u32 REGPARAM2 op_6401_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CC) */
uae_u32 REGPARAM2 op_64ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(4)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (CS) */
uae_u32 REGPARAM2 op_6500_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (CS) */
uae_u32 REGPARAM2 op_6501_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (CS) */
uae_u32 REGPARAM2 op_65ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(5)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (NE) */
uae_u32 REGPARAM2 op_6600_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (NE) */
uae_u32 REGPARAM2 op_6601_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (NE) */
uae_u32 REGPARAM2 op_66ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(6)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (EQ) */
uae_u32 REGPARAM2 op_6700_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (EQ) */
uae_u32 REGPARAM2 op_6701_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (EQ) */
uae_u32 REGPARAM2 op_67ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(7)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VC) */
uae_u32 REGPARAM2 op_6800_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VC) */
uae_u32 REGPARAM2 op_6801_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VC) */
uae_u32 REGPARAM2 op_68ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(8)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (VS) */
uae_u32 REGPARAM2 op_6900_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (VS) */
uae_u32 REGPARAM2 op_6901_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (VS) */
uae_u32 REGPARAM2 op_69ff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(9)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (PL) */
uae_u32 REGPARAM2 op_6a00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (PL) */
uae_u32 REGPARAM2 op_6a01_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (PL) */
uae_u32 REGPARAM2 op_6aff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(10)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (MI) */
uae_u32 REGPARAM2 op_6b00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (MI) */
uae_u32 REGPARAM2 op_6b01_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (MI) */
uae_u32 REGPARAM2 op_6bff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(11)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GE) */
uae_u32 REGPARAM2 op_6c00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GE) */
uae_u32 REGPARAM2 op_6c01_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GE) */
uae_u32 REGPARAM2 op_6cff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(12)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LT) */
uae_u32 REGPARAM2 op_6d00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LT) */
uae_u32 REGPARAM2 op_6d01_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LT) */
uae_u32 REGPARAM2 op_6dff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(13)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (GT) */
uae_u32 REGPARAM2 op_6e00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (GT) */
uae_u32 REGPARAM2 op_6e01_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (GT) */
uae_u32 REGPARAM2 op_6eff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(14)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* Bcc.W #<data>.W (LE) */
uae_u32 REGPARAM2 op_6f00_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 8;  
	uaecptr oldpc = m68k_getpci();
	uae_s16 src = get_word_020_prefetch(2);
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(4);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0 B */

/* BccQ.B #<data> (LE) */
uae_u32 REGPARAM2 op_6f01_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	OpcodeFamily = 55;
	CurrentInstrCycles = 4;  
	uaecptr oldpc = m68k_getpci();
	uae_u32 src = srcreg;
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(2);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0 B */

/* Bcc.L #<data>.L (LE) */
uae_u32 REGPARAM2 op_6fff_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	OpcodeFamily = 55;
	CurrentInstrCycles = 12; 
	uaecptr oldpc = m68k_getpci();
	uae_s32 src;
	src = get_long_020_prefetch(2);
	if (cctrue(15)) {
		if (src & 1) {
			uaecptr addr = m68k_getpci() + (uae_s32)src + 2;
			exception3_read_prefetch(opcode, addr);
			return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
		}
		m68k_incpci((uae_s32)src + 2);
		fill_prefetch_020();
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	m68k_incpci(6);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0 B */

/* MOVEQ.L #<data>,Dn */
uae_u32 REGPARAM2 op_7000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (uae_s32)(uae_s8)(real_opcode & 255);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 30;
	CurrentInstrCycles = 4;  
	uae_u32 src = srcreg;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,Dn */
uae_u32 REGPARAM2 op_8000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B (An),Dn */
uae_u32 REGPARAM2 op_8010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B (An)+,Dn */
uae_u32 REGPARAM2 op_8018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B -(An),Dn */
uae_u32 REGPARAM2 op_8020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B (d16,An),Dn */
uae_u32 REGPARAM2 op_8028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_8030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_8038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_8039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_803a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_803b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_803c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W Dn,Dn */
uae_u32 REGPARAM2 op_8040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W (An),Dn */
uae_u32 REGPARAM2 op_8050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W (An)+,Dn */
uae_u32 REGPARAM2 op_8058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W -(An),Dn */
uae_u32 REGPARAM2 op_8060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W (d16,An),Dn */
uae_u32 REGPARAM2 op_8068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_8070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_8078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_8079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_807a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_807b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_807c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L Dn,Dn */
uae_u32 REGPARAM2 op_8080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L (An),Dn */
uae_u32 REGPARAM2 op_8090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L (An)+,Dn */
uae_u32 REGPARAM2 op_8098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L -(An),Dn */
uae_u32 REGPARAM2 op_80a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L (d16,An),Dn */
uae_u32 REGPARAM2 op_80a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_80b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_80b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_80b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* OR.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_80ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_80bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_80bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVU.W Dn,Dn */
uae_u32 REGPARAM2 op_80c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W (An),Dn */
uae_u32 REGPARAM2 op_80d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W (An)+,Dn */
uae_u32 REGPARAM2 op_80d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W -(An),Dn */
uae_u32 REGPARAM2 op_80e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(2);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVU.W (d16,An),Dn */
uae_u32 REGPARAM2 op_80e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVU.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_80f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVU.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_80f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVU.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_80f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(6);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVU.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_80fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVU.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_80fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVU.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_80fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 60;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(0, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	uae_u32 newv = (uae_u32)dst / (uae_u32)(uae_u16)src;
	uae_u32 rem = (uae_u32)dst % (uae_u32)(uae_u16)src;
	if (newv > 0xffff) {
		setdivuflags((uae_u32)dst, (uae_u16)src);
	} else {
		CLEAR_CZNV();
		SET_ZFLG(((uae_s16)(newv)) == 0);
		SET_NFLG(((uae_s16)(newv)) < 0);
		newv = (newv & 0xffff) | ((uae_u32)rem << 16);
		m68k_dreg(regs, dstreg) = (newv);
	}
	m68k_incpci(4);
	count_cycles += 34;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SBCD.B Dn,Dn */
uae_u32 REGPARAM2 op_8100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SBCD.B -(An),-(An) */
uae_u32 REGPARAM2 op_8108_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 10;
	CurrentInstrCycles = 25; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u16 newv_lo = (dst & 0xF) - (src & 0xF) - (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (dst & 0xF0) - (src & 0xF0);
	uae_u16 newv, tmp_newv;
	int bcd = 0;
	newv = tmp_newv = newv_hi + newv_lo;
if (newv_lo & 0xF0) { newv -= 6; bcd = 6; };
if ((((dst & 0xFF) - (src & 0xFF) - (GET_XFLG() ? 1 : 0)) & 0x100) > 0xFF) { newv -= 0x60; }
	SET_CFLG((((dst & 0xFF) - (src & 0xFF) - bcd - (GET_XFLG() ? 1 : 0)) & 0x300) > 0xFF);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,(An) */
uae_u32 REGPARAM2 op_8110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,(An)+ */
uae_u32 REGPARAM2 op_8118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,-(An) */
uae_u32 REGPARAM2 op_8120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_8128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_8130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_8138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_8139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* PACK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	CurrentInstrCycles = 10; 
	uae_u16 val = m68k_dreg(regs, srcreg) + get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffffff00) | ((val >> 4) & 0xf0) | (val & 0xf);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* PACK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 96;
	CurrentInstrCycles = 15; 
	uae_u16 val;
	m68k_areg(regs, srcreg) -= 2;
	val = (uae_u16)(x_get_word(m68k_areg(regs, srcreg)));
	val += get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) -= areg_byteinc[dstreg];
	x_put_byte(m68k_areg(regs, dstreg),((val >> 4) & 0xf0) | (val & 0xf));
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* OR.W Dn,(An) */
uae_u32 REGPARAM2 op_8150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W Dn,(An)+ */
uae_u32 REGPARAM2 op_8158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W Dn,-(An) */
uae_u32 REGPARAM2 op_8160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_8168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_8170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_8178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_8179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* UNPK.L Dn,Dn */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	CurrentInstrCycles = 12; 
	uae_u16 val = m68k_dreg(regs, srcreg);
	val = ((val << 4) & 0xf00) | (val & 0xf);
	val += get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & 0xffff0000) | (val & 0xffff);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* UNPK.L -(An),-(An) */
#ifndef CPUEMU_68000_ONLY
uae_u32 REGPARAM2 op_8188_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 97;
	CurrentInstrCycles = 15; 
	uae_u16 val;
	m68k_areg(regs, srcreg) -= areg_byteinc[srcreg];
	val = (uae_u16)(x_get_byte(m68k_areg(regs, srcreg)) & 0xff);
	val = (((val << 4) & 0xf00) | (val & 0xf)) + get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) -= 2;
	x_put_word(m68k_areg(regs, dstreg), val);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

#endif
/* OR.L Dn,(An) */
uae_u32 REGPARAM2 op_8190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L Dn,(An)+ */
uae_u32 REGPARAM2 op_8198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L Dn,-(An) */
uae_u32 REGPARAM2 op_81a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* OR.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_81a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_81b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 1;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* OR.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_81b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* OR.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_81b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 1;
	CurrentInstrCycles = 28; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	src |= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVS.W Dn,Dn */
uae_u32 REGPARAM2 op_81c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W (An),Dn */
uae_u32 REGPARAM2 op_81d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W (An)+,Dn */
uae_u32 REGPARAM2 op_81d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W -(An),Dn */
uae_u32 REGPARAM2 op_81e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(2);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(2);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* DIVS.W (d16,An),Dn */
uae_u32 REGPARAM2 op_81e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVS.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_81f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVS.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_81f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVS.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_81f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 32; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(6);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(6);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* DIVS.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_81fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 28; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* DIVS.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_81fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(0);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* DIVS.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_81fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 61;
	CurrentInstrCycles = 24; 
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	if (src == 0) {
		divbyzero_special(1, dst);
		m68k_incpci(4);
		Exception_cpu(5);
		return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
	}
	if (dst == 0x80000000 && src == -1) {
		setdivsflags((uae_s32)dst, (uae_s16)src);
	} else {
		uae_s32 newv = (uae_s32)dst / (uae_s32)(uae_s16)src;
		uae_u16 rem = (uae_s32)dst % (uae_s32)(uae_s16)src;
		if ((newv & 0xffff8000) != 0 && (newv & 0xffff8000) != 0xffff8000) {
			setdivsflags((uae_s32)dst, (uae_s16)src);
		} else {
			if (((uae_s16)rem < 0) != ((uae_s32)dst < 0)) rem = -rem;
			CLEAR_CZNV();
			SET_ZFLG(((uae_s16)(newv)) == 0);
			SET_NFLG(((uae_s16)(newv)) < 0);
			newv = (newv & 0xffff) | ((uae_u32)rem << 16);
			m68k_dreg(regs, dstreg) = (newv);
		}
	}
	m68k_incpci(4);
	count_cycles += 48;
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B Dn,Dn */
uae_u32 REGPARAM2 op_9000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B (An),Dn */
uae_u32 REGPARAM2 op_9010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B (An)+,Dn */
uae_u32 REGPARAM2 op_9018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B -(An),Dn */
uae_u32 REGPARAM2 op_9020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B (d16,An),Dn */
uae_u32 REGPARAM2 op_9028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_9030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_9038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_9039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_903a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_903b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_903c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W Dn,Dn */
uae_u32 REGPARAM2 op_9040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W An,Dn */
uae_u32 REGPARAM2 op_9048_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W (An),Dn */
uae_u32 REGPARAM2 op_9050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W (An)+,Dn */
uae_u32 REGPARAM2 op_9058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W -(An),Dn */
uae_u32 REGPARAM2 op_9060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W (d16,An),Dn */
uae_u32 REGPARAM2 op_9068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_9070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_9078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_9079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_907a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_907b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_907c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L Dn,Dn */
uae_u32 REGPARAM2 op_9080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L An,Dn */
uae_u32 REGPARAM2 op_9088_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L (An),Dn */
uae_u32 REGPARAM2 op_9090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L (An)+,Dn */
uae_u32 REGPARAM2 op_9098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L -(An),Dn */
uae_u32 REGPARAM2 op_90a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L (d16,An),Dn */
uae_u32 REGPARAM2 op_90a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_90b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_90b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_90b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUB.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_90ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_90bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_90bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.W Dn,An */
uae_u32 REGPARAM2 op_90c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W An,An */
uae_u32 REGPARAM2 op_90c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W (An),An */
uae_u32 REGPARAM2 op_90d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W (An)+,An */
uae_u32 REGPARAM2 op_90d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W -(An),An */
uae_u32 REGPARAM2 op_90e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.W (d16,An),An */
uae_u32 REGPARAM2 op_90e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 op_90f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.W (xxx).W,An */
uae_u32 REGPARAM2 op_90f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.W (xxx).L,An */
uae_u32 REGPARAM2 op_90f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(6);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.W (d16,PC),An */
uae_u32 REGPARAM2 op_90fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_90fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.W #<data>.W,An */
uae_u32 REGPARAM2 op_90fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBX.B Dn,Dn */
uae_u32 REGPARAM2 op_9100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBX.B -(An),-(An) */
uae_u32 REGPARAM2 op_9108_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 21; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,(An) */
uae_u32 REGPARAM2 op_9110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,(An)+ */
uae_u32 REGPARAM2 op_9118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,-(An) */
uae_u32 REGPARAM2 op_9120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_9128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_9130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_9138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_9139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBX.W Dn,Dn */
uae_u32 REGPARAM2 op_9140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((newv) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBX.W -(An),-(An) */
uae_u32 REGPARAM2 op_9148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 21; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s16)(newv)) == 0));
	SET_NFLG(((uae_s16)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,(An) */
uae_u32 REGPARAM2 op_9150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,(An)+ */
uae_u32 REGPARAM2 op_9158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,-(An) */
uae_u32 REGPARAM2 op_9160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_9168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_9170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_9178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_9179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBX.L Dn,Dn */
uae_u32 REGPARAM2 op_9180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBX.L -(An),-(An) */
uae_u32 REGPARAM2 op_9188_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 9;
	CurrentInstrCycles = 33; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = dst - src - (GET_XFLG() ? 1 : 0);
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_VFLG((flgs ^ flgo) & (flgo ^ flgn));
	SET_CFLG(flgs ^ ((flgs ^ flgn) & (flgo ^ flgn)));
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s32)(newv)) == 0));
	SET_NFLG(((uae_s32)(newv)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,(An) */
uae_u32 REGPARAM2 op_9190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,(An)+ */
uae_u32 REGPARAM2 op_9198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,-(An) */
uae_u32 REGPARAM2 op_91a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, newv);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUB.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_91a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_91b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 7;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, newv);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUB.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_91b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, newv);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUB.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_91b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 7;
	CurrentInstrCycles = 28; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs ^ flgo) & (flgn ^ flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	COPY_CARRY();
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, newv);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.L Dn,An */
uae_u32 REGPARAM2 op_91c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L An,An */
uae_u32 REGPARAM2 op_91c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L (An),An */
uae_u32 REGPARAM2 op_91d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L (An)+,An */
uae_u32 REGPARAM2 op_91d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L -(An),An */
uae_u32 REGPARAM2 op_91e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* SUBA.L (d16,An),An */
uae_u32 REGPARAM2 op_91e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_91f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.L (xxx).W,An */
uae_u32 REGPARAM2 op_91f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.L (xxx).L,An */
uae_u32 REGPARAM2 op_91f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(6);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* SUBA.L (d16,PC),An */
uae_u32 REGPARAM2 op_91fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(4);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* SUBA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_91fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(0);
	m68k_areg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* SUBA.L #<data>.L,An */
uae_u32 REGPARAM2 op_91fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 8;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = dst - src;
	regs.irc = get_word_020_prefetch(6);
	m68k_areg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B Dn,Dn */
uae_u32 REGPARAM2 op_b000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B (An),Dn */
uae_u32 REGPARAM2 op_b010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B (An)+,Dn */
uae_u32 REGPARAM2 op_b018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B -(An),Dn */
uae_u32 REGPARAM2 op_b020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.B (d16,An),Dn */
uae_u32 REGPARAM2 op_b028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_b030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_b038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_b039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_b03a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_b03b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_b03c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W Dn,Dn */
uae_u32 REGPARAM2 op_b040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W An,Dn */
uae_u32 REGPARAM2 op_b048_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W (An),Dn */
uae_u32 REGPARAM2 op_b050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W (An)+,Dn */
uae_u32 REGPARAM2 op_b058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W -(An),Dn */
uae_u32 REGPARAM2 op_b060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.W (d16,An),Dn */
uae_u32 REGPARAM2 op_b068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_b070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_b078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_b079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_b07a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_b07b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_b07c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L Dn,Dn */
uae_u32 REGPARAM2 op_b080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L An,Dn */
uae_u32 REGPARAM2 op_b088_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L (An),Dn */
uae_u32 REGPARAM2 op_b090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L (An)+,Dn */
uae_u32 REGPARAM2 op_b098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L -(An),Dn */
uae_u32 REGPARAM2 op_b0a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMP.L (d16,An),Dn */
uae_u32 REGPARAM2 op_b0a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_b0b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_b0b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_b0b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMP.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_b0ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMP.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_b0bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMP.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_b0bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 25;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.W Dn,An */
uae_u32 REGPARAM2 op_b0c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W An,An */
uae_u32 REGPARAM2 op_b0c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W (An),An */
uae_u32 REGPARAM2 op_b0d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W (An)+,An */
uae_u32 REGPARAM2 op_b0d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W -(An),An */
uae_u32 REGPARAM2 op_b0e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.W (d16,An),An */
uae_u32 REGPARAM2 op_b0e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.W (d8,An,Xn),An */
uae_u32 REGPARAM2 op_b0f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.W (xxx).W,An */
uae_u32 REGPARAM2 op_b0f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.W (xxx).L,An */
uae_u32 REGPARAM2 op_b0f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.W (d16,PC),An */
uae_u32 REGPARAM2 op_b0fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.W (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_b0fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.W #<data>.W,An */
uae_u32 REGPARAM2 op_b0fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B Dn,Dn */
uae_u32 REGPARAM2 op_b100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPM.B (An)+,(An)+ */
uae_u32 REGPARAM2 op_b108_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	uae_u32 newv = ((uae_u8)(dst)) - ((uae_u8)(src));
	int flgs = ((uae_s8)(src)) < 0;
	int flgo = ((uae_s8)(dst)) < 0;
	int flgn = ((uae_s8)(newv)) < 0;
	SET_ZFLG(((uae_s8)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u8)(src)) > ((uae_u8)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,(An) */
uae_u32 REGPARAM2 op_b110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,(An)+ */
uae_u32 REGPARAM2 op_b118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,-(An) */
uae_u32 REGPARAM2 op_b120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_b128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_b130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EOR.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_b138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_b139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.W Dn,Dn */
uae_u32 REGPARAM2 op_b140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPM.W (An)+,(An)+ */
uae_u32 REGPARAM2 op_b148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	uae_u32 newv = ((uae_u16)(dst)) - ((uae_u16)(src));
	int flgs = ((uae_s16)(src)) < 0;
	int flgo = ((uae_s16)(dst)) < 0;
	int flgn = ((uae_s16)(newv)) < 0;
	SET_ZFLG(((uae_s16)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u16)(src)) > ((uae_u16)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,(An) */
uae_u32 REGPARAM2 op_b150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,(An)+ */
uae_u32 REGPARAM2 op_b158_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) += 2;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,-(An) */
uae_u32 REGPARAM2 op_b160_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 2;
	uae_s16 dst = x_get_word(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_word(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.W Dn,(d16,An) */
uae_u32 REGPARAM2 op_b168_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_b170_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_word(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EOR.W Dn,(xxx).W */
uae_u32 REGPARAM2 op_b178_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 16; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_word(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.W Dn,(xxx).L */
uae_u32 REGPARAM2 op_b179_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s16 dst = x_get_word(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_word(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EOR.L Dn,Dn */
uae_u32 REGPARAM2 op_b180_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPM.L (An)+,(An)+ */
uae_u32 REGPARAM2 op_b188_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 26;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,(An) */
uae_u32 REGPARAM2 op_b190_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,(An)+ */
uae_u32 REGPARAM2 op_b198_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) += 4;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,-(An) */
uae_u32 REGPARAM2 op_b1a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - 4;
	uae_s32 dst = x_get_long(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_long(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EOR.L Dn,(d16,An) */
uae_u32 REGPARAM2 op_b1a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.L Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_b1b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 3;
	CurrentInstrCycles = 20; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_long(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* EOR.L Dn,(xxx).W */
uae_u32 REGPARAM2 op_b1b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 24; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_long(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* EOR.L Dn,(xxx).L */
uae_u32 REGPARAM2 op_b1b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 3;
	CurrentInstrCycles = 28; 
	uae_s32 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s32 dst = x_get_long(dsta);
	src ^= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_long(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.L Dn,An */
uae_u32 REGPARAM2 op_b1c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L An,An */
uae_u32 REGPARAM2 op_b1c8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L (An),An */
uae_u32 REGPARAM2 op_b1d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L (An)+,An */
uae_u32 REGPARAM2 op_b1d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L -(An),An */
uae_u32 REGPARAM2 op_b1e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* CMPA.L (d16,An),An */
uae_u32 REGPARAM2 op_b1e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.L (d8,An,Xn),An */
uae_u32 REGPARAM2 op_b1f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.L (xxx).W,An */
uae_u32 REGPARAM2 op_b1f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.L (xxx).L,An */
uae_u32 REGPARAM2 op_b1f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* CMPA.L (d16,PC),An */
uae_u32 REGPARAM2 op_b1fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* CMPA.L (d8,PC,Xn),An */
uae_u32 REGPARAM2 op_b1fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(0);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* CMPA.L #<data>.L,An */
uae_u32 REGPARAM2 op_b1fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 27;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_areg(regs, dstreg);
	uae_u32 newv = ((uae_u32)(dst)) - ((uae_u32)(src));
	int flgs = ((uae_s32)(src)) < 0;
	int flgo = ((uae_s32)(dst)) < 0;
	int flgn = ((uae_s32)(newv)) < 0;
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_VFLG((flgs != flgo) && (flgn != flgo));
	SET_CFLG(((uae_u32)(src)) > ((uae_u32)(dst)));
	SET_NFLG(flgn != 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B Dn,Dn */
uae_u32 REGPARAM2 op_c000_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B (An),Dn */
uae_u32 REGPARAM2 op_c010_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B (An)+,Dn */
uae_u32 REGPARAM2 op_c018_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) += areg_byteinc[srcreg];
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B -(An),Dn */
uae_u32 REGPARAM2 op_c020_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B (d16,An),Dn */
uae_u32 REGPARAM2 op_c028_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c030_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.B (xxx).W,Dn */
uae_u32 REGPARAM2 op_c038_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B (xxx).L,Dn */
uae_u32 REGPARAM2 op_c039_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.B (d16,PC),Dn */
uae_u32 REGPARAM2 op_c03a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c03b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s8 src = x_get_byte(srca);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.B #<data>.B,Dn */
uae_u32 REGPARAM2 op_c03c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s8 src = (uae_u8)get_word_020_prefetch(2);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((src) & 0xff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W Dn,Dn */
uae_u32 REGPARAM2 op_c040_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 4;  
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W (An),Dn */
uae_u32 REGPARAM2 op_c050_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W (An)+,Dn */
uae_u32 REGPARAM2 op_c058_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W -(An),Dn */
uae_u32 REGPARAM2 op_c060_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W (d16,An),Dn */
uae_u32 REGPARAM2 op_c068_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c070_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_c078_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_c079_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_c07a_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c07b_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_c07c_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 8;  
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(((uae_s16)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xffff) | ((src) & 0xffff);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L Dn,Dn */
uae_u32 REGPARAM2 op_c080_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L (An),Dn */
uae_u32 REGPARAM2 op_c090_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L (An)+,Dn */
uae_u32 REGPARAM2 op_c098_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) += 4;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L -(An),Dn */
uae_u32 REGPARAM2 op_c0a0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 4;
	uae_s32 src = x_get_long(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.L (d16,An),Dn */
uae_u32 REGPARAM2 op_c0a8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c0b0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.L (xxx).W,Dn */
uae_u32 REGPARAM2 op_c0b8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L (xxx).L,Dn */
uae_u32 REGPARAM2 op_c0b9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* AND.L (d16,PC),Dn */
uae_u32 REGPARAM2 op_c0ba_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.L (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c0bb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s32 src = x_get_long(srca);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (src);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.L #<data>.L,Dn */
uae_u32 REGPARAM2 op_c0bc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s32 src;
	src = get_long_020_prefetch(2);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(src)) == 0);
	SET_NFLG(((uae_s32)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MULU.W Dn,Dn */
uae_u32 REGPARAM2 op_c0c0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W (An),Dn */
uae_u32 REGPARAM2 op_c0d0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W (An)+,Dn */
uae_u32 REGPARAM2 op_c0d8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg);
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) += 2;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W -(An),Dn */
uae_u32 REGPARAM2 op_c0e0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - 2;
	uae_s16 src = x_get_word(srca);
	m68k_areg(regs, srcreg) = srca;
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* MULU.W (d16,An),Dn */
uae_u32 REGPARAM2 op_c0e8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MULU.W (d8,An,Xn),Dn */
uae_u32 REGPARAM2 op_c0f0_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	srca = x_get_disp_ea_020(m68k_areg(regs, srcreg), 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MULU.W (xxx).W,Dn */
uae_u32 REGPARAM2 op_c0f8_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MULU.W (xxx).L,Dn */
uae_u32 REGPARAM2 op_c0f9_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 24; 
	uaecptr srca;
	srca = get_long_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(6);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(6);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* MULU.W (d16,PC),Dn */
uae_u32 REGPARAM2 op_c0fa_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 20; 
	uaecptr srca;
	srca = m68k_getpci() + 2;
	srca += (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* MULU.W (d8,PC,Xn),Dn */
uae_u32 REGPARAM2 op_c0fb_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 16; 
	uaecptr srca;
	m68k_incpci(2);
	uaecptr tmppc = m68k_getpci();
	srca = x_get_disp_ea_020(tmppc, 0);
	uae_s16 src = x_get_word(srca);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(0);
	m68k_dreg(regs, dstreg) = (newv);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* MULU.W #<data>.W,Dn */
uae_u32 REGPARAM2 op_c0fc_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 62;
	CurrentInstrCycles = 16; 
	uae_s16 src = get_word_020_prefetch(2);
	uae_s16 dst = m68k_dreg(regs, dstreg);
	uae_u32 newv = (uae_u32)(uae_u16)dst * (uae_u32)(uae_u16)src;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s32)(newv)) == 0);
	SET_NFLG(((uae_s32)(newv)) < 0);
	count_cycles += 20;
	regs.irc = get_word_020_prefetch(4);
	m68k_dreg(regs, dstreg) = (newv);
	m68k_incpci(4);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* ABCD.B Dn,Dn */
uae_u32 REGPARAM2 op_c100_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 14;
	CurrentInstrCycles = 4;  
	uae_s8 src = m68k_dreg(regs, srcreg);
	uae_s8 dst = m68k_dreg(regs, dstreg);
	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, dstreg) = (m68k_dreg(regs, dstreg) & ~0xff) | ((newv) & 0xff);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* ABCD.B -(An),-(An) */
uae_u32 REGPARAM2 op_c108_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = (real_opcode & 7);
	uae_u32 dstreg = (real_opcode >> 9) & 7;
	OpcodeFamily = 14;
	CurrentInstrCycles = 25; 
	uaecptr srca;
	srca = m68k_areg(regs, srcreg) - areg_byteinc[srcreg];
	uae_s8 src = x_get_byte(srca);
	m68k_areg(regs, srcreg) = srca;
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	uae_u16 newv_lo = (src & 0xF) + (dst & 0xF) + (GET_XFLG() ? 1 : 0);
	uae_u16 newv_hi = (src & 0xF0) + (dst & 0xF0);
	uae_u16 newv, tmp_newv;
	int cflg;
	newv = tmp_newv = newv_hi + newv_lo;if (newv_lo > 9) { newv += 6; }
	cflg = (newv & 0x3F0) > 0x90;
	if (cflg) newv += 0x60;
	SET_CFLG(cflg);
	COPY_CARRY();
	SET_ZFLG(GET_ZFLG() & (((uae_s8)(newv)) == 0));
	SET_NFLG(((uae_s8)(newv)) < 0);
	SET_VFLG(0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, newv);
	m68k_incpci(2);
	return (3 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,(An) */
uae_u32 REGPARAM2 op_c110_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,(An)+ */
uae_u32 REGPARAM2 op_c118_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) += areg_byteinc[dstreg];
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,-(An) */
uae_u32 REGPARAM2 op_c120_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) - areg_byteinc[dstreg];
	uae_s8 dst = x_get_byte(dsta);
	m68k_areg(regs, dstreg) = dsta;
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(2);
	x_put_byte(dsta, src);
	m68k_incpci(2);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.B Dn,(d16,An) */
uae_u32 REGPARAM2 op_c128_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg) + (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B Dn,(d8,An,Xn) */
uae_u32 REGPARAM2 op_c130_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	m68k_incpci(2);
	dsta = x_get_disp_ea_020(m68k_areg(regs, dstreg), 0);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(0);
	x_put_byte(dsta, src);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 2,0   */

/* AND.B Dn,(xxx).W */
uae_u32 REGPARAM2 op_c138_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 16; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = (uae_s32)(uae_s16)get_word_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(4);
	x_put_byte(dsta, src);
	m68k_incpci(4);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 4 0,0   */

/* AND.B Dn,(xxx).L */
uae_u32 REGPARAM2 op_c139_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	OpcodeFamily = 2;
	CurrentInstrCycles = 20; 
	uae_s8 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = get_long_020_prefetch(2);
	uae_s8 dst = x_get_byte(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s8)(src)) == 0);
	SET_NFLG(((uae_s8)(src)) < 0);
	regs.irc = get_word_020_prefetch(6);
	x_put_byte(dsta, src);
	m68k_incpci(6);
	return (2 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 6 0,0   */

/* EXG.L Dn,Dn */
uae_u32 REGPARAM2 op_c140_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_dreg(regs, srcreg);
	uae_s32 dst = m68k_dreg(regs, dstreg);
	regs.irc = get_word_020_prefetch(2);
	m68k_dreg(regs, srcreg) = (dst);
	m68k_dreg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* EXG.L An,An */
uae_u32 REGPARAM2 op_c148_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 35;
	CurrentInstrCycles = 4;  
	uae_s32 src = m68k_areg(regs, srcreg);
	uae_s32 dst = m68k_areg(regs, dstreg);
	regs.irc = get_word_020_prefetch(2);
	m68k_areg(regs, srcreg) = (dst);
	m68k_areg(regs, dstreg) = (src);
	m68k_incpci(2);
	return (1 * 4 * CYCLE_UNIT / 2 + count_cycles) * 4;
}
/* 2 0,0   */

/* AND.W Dn,(An) */
uae_u32 REGPARAM2 op_c150_20_ff(uae_u32 opcode)
{
	int count_cycles = 0;
	uae_u32 real_opcode = opcode;
	uae_u32 srcreg = ((real_opcode >> 9) & 7);
	uae_u32 dstreg = real_opcode & 7;
	OpcodeFamily = 2;
	CurrentInstrCycles = 12; 
	uae_s16 src = m68k_dreg(regs, srcreg);
	uaecptr dsta;
	dsta = m68k_areg(regs, dstreg);
	uae_s16 dst = x_get_word(dsta);
	src &= dst;
	CLEAR_CZNV();
	SET_ZFLG(((uae_s16)(src)) == 0);
	SET_NFLG(