/* Placeholder.c generated by valac 0.56.17, the Vala compiler
 * generated from Placeholder.vala, do not modify */

/*
 * Copyright 2022 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite-7.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_PLACEHOLDER_0_PROPERTY,
	GRANITE_PLACEHOLDER_TITLE_PROPERTY,
	GRANITE_PLACEHOLDER_DESCRIPTION_PROPERTY,
	GRANITE_PLACEHOLDER_ICON_PROPERTY,
	GRANITE_PLACEHOLDER_NUM_PROPERTIES
};
static GParamSpec* granite_placeholder_properties[GRANITE_PLACEHOLDER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GranitePlaceholderPrivate {
	gchar* _title;
	gchar* _description;
	GIcon* _icon;
	GtkBox* buttonbox;
};

static gint GranitePlaceholder_private_offset;
static gpointer granite_placeholder_parent_class = NULL;

static GObject * granite_placeholder_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static gboolean _granite_placeholder___lambda21_ (GranitePlaceholder* self,
                                           GBinding* binding,
                                           GValue* srcval,
                                           GValue* targetval);
static gboolean __granite_placeholder___lambda21__gbinding_transform_func (GBinding* binding,
                                                                    GValue* from_value,
                                                                    GValue* to_value,
                                                                    gpointer self);
static gboolean _granite_placeholder___lambda22_ (GranitePlaceholder* self,
                                           GBinding* binding,
                                           GValue* srcval,
                                           GValue* targetval);
static gboolean __granite_placeholder___lambda22__gbinding_transform_func (GBinding* binding,
                                                                    GValue* from_value,
                                                                    GValue* to_value,
                                                                    gpointer self);
static void granite_placeholder_finalize (GObject * obj);
static GType granite_placeholder_get_type_once (void);
static void _vala_granite_placeholder_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_granite_placeholder_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
granite_placeholder_get_instance_private (GranitePlaceholder* self)
{
	return G_STRUCT_MEMBER_P (self, GranitePlaceholder_private_offset);
}

const gchar*
granite_placeholder_get_title (GranitePlaceholder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}

void
granite_placeholder_set_title (GranitePlaceholder* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_placeholder_get_title (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_placeholder_properties[GRANITE_PLACEHOLDER_TITLE_PROPERTY]);
	}
}

const gchar*
granite_placeholder_get_description (GranitePlaceholder* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_description;
	result = _tmp0_;
	return result;
}

void
granite_placeholder_set_description (GranitePlaceholder* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_placeholder_get_description (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_description);
		self->priv->_description = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_placeholder_properties[GRANITE_PLACEHOLDER_DESCRIPTION_PROPERTY]);
	}
}

GIcon*
granite_placeholder_get_icon (GranitePlaceholder* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
granite_placeholder_set_icon (GranitePlaceholder* self,
                              GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_placeholder_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_placeholder_properties[GRANITE_PLACEHOLDER_ICON_PROPERTY]);
	}
}

/**
     * Constructs a new {@link Granite.Placeholder} with title text only.
     *
     * @param title The {@link string} to use for the primary text
     */
GranitePlaceholder*
granite_placeholder_construct (GType object_type,
                               const gchar* title)
{
	GranitePlaceholder * self = NULL;
	g_return_val_if_fail (title != NULL, NULL);
	self = (GranitePlaceholder*) g_object_new (object_type, "title", title, NULL);
	return self;
}

GranitePlaceholder*
granite_placeholder_new (const gchar* title)
{
	return granite_placeholder_construct (GRANITE_TYPE_PLACEHOLDER, title);
}

/**
     * Appends new {@link Gtk.Button} to the placeholder's action area
     *
     * @param icon the {@link GLib.Icon} that describes this action
     * @param label a {@link string} to use as the title for this action. It should use Title Case.
     * @param description a {@link string} to use as a description for this action. It should use sentence case.
     * @return a {@link Gtk.Button} representing this action
     */
GtkButton*
granite_placeholder_append_button (GranitePlaceholder* self,
                                   GIcon* icon,
                                   const gchar* label,
                                   const gchar* description)
{
	GtkImage* image = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkLabel* label_widget = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* description_widget = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp3_;
	GtkButton* button = NULL;
	GtkWidget* _tmp4_;
	GtkButton* _tmp5_ = NULL;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_gicon (icon);
	gtk_image_set_icon_size (_tmp0_, GTK_ICON_SIZE_LARGE);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (label);
	gtk_label_set_wrap (_tmp1_, TRUE);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	label_widget = _tmp1_;
	gtk_widget_add_css_class ((GtkWidget*) label_widget, GRANITE_STYLE_CLASS_H3_LABEL);
	_tmp2_ = (GtkLabel*) gtk_label_new (description);
	gtk_label_set_wrap (_tmp2_, TRUE);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	g_object_ref_sink (_tmp2_);
	description_widget = _tmp2_;
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	grid = _tmp3_;
	gtk_grid_attach (grid, (GtkWidget*) image, 0, 0, 1, 2);
	gtk_grid_attach (grid, (GtkWidget*) label_widget, 1, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) description_widget, 1, 1, 1, 1);
	_tmp4_ = _g_object_ref0 ((GtkWidget*) grid);
	_tmp5_ = (GtkButton*) gtk_button_new ();
	gtk_button_set_child (_tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	button = _tmp5_;
	gtk_widget_add_css_class ((GtkWidget*) button, GRANITE_STYLE_CLASS_FLAT);
	_tmp6_ = self->priv->buttonbox;
	gtk_box_append (_tmp6_, (GtkWidget*) button);
	_tmp7_ = self->priv->buttonbox;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	result = button;
	_g_object_unref0 (grid);
	_g_object_unref0 (description_widget);
	_g_object_unref0 (label_widget);
	_g_object_unref0 (image);
	return result;
}

static gboolean
_granite_placeholder___lambda21_ (GranitePlaceholder* self,
                                  GBinding* binding,
                                  GValue* srcval,
                                  GValue* targetval)
{
	gboolean _tmp0_ = FALSE;
	GValue _tmp1_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (srcval != NULL, FALSE);
	g_return_val_if_fail (targetval != NULL, FALSE);
	_tmp1_ = *srcval;
	if (g_value_get_string (&_tmp1_) != NULL) {
		GValue _tmp2_;
		_tmp2_ = *srcval;
		_tmp0_ = g_strcmp0 (g_value_get_string (&_tmp2_), "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	g_value_set_boolean (targetval, _tmp0_);
	result = TRUE;
	return result;
}

static gboolean
__granite_placeholder___lambda21__gbinding_transform_func (GBinding* binding,
                                                           GValue* from_value,
                                                           GValue* to_value,
                                                           gpointer self)
{
	gboolean result;
	result = _granite_placeholder___lambda21_ ((GranitePlaceholder*) self, binding, from_value, to_value);
	return result;
}

static gboolean
_granite_placeholder___lambda22_ (GranitePlaceholder* self,
                                  GBinding* binding,
                                  GValue* srcval,
                                  GValue* targetval)
{
	GValue _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	g_return_val_if_fail (srcval != NULL, FALSE);
	g_return_val_if_fail (targetval != NULL, FALSE);
	_tmp0_ = *srcval;
	g_value_set_boolean (targetval, g_value_get_object (&_tmp0_) != NULL);
	result = TRUE;
	return result;
}

static gboolean
__granite_placeholder___lambda22__gbinding_transform_func (GBinding* binding,
                                                           GValue* from_value,
                                                           GValue* to_value,
                                                           gpointer self)
{
	gboolean result;
	result = _granite_placeholder___lambda22_ ((GranitePlaceholder*) self, binding, from_value, to_value);
	return result;
}

static GObject *
granite_placeholder_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GranitePlaceholder * self;
	GtkImage* image = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkLabel* title_label = NULL;
	const gchar* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* description_label = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_;
	GtkBox* _tmp6_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkImage* _tmp9_;
	GtkGrid* _tmp10_;
	GtkLabel* _tmp11_;
	GtkGrid* _tmp12_;
	GtkLabel* _tmp13_;
	GtkGrid* _tmp14_;
	GtkBox* _tmp15_;
	GtkGrid* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkImage* _tmp20_;
	GtkImage* _tmp21_;
	parent_class = G_OBJECT_CLASS (granite_placeholder_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_PLACEHOLDER, GranitePlaceholder);
	_tmp0_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_icon_size (_tmp0_, GTK_ICON_SIZE_LARGE);
	gtk_widget_set_valign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	_tmp1_ = self->priv->_title;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	gtk_label_set_max_width_chars (_tmp2_, 30);
	gtk_label_set_wrap (_tmp2_, TRUE);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	g_object_ref_sink (_tmp2_);
	title_label = _tmp2_;
	_tmp3_ = title_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, GRANITE_STYLE_CLASS_H1_LABEL);
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	gtk_label_set_max_width_chars (_tmp4_, 45);
	gtk_label_set_wrap (_tmp4_, TRUE);
	gtk_label_set_use_markup (_tmp4_, TRUE);
	gtk_label_set_xalign (_tmp4_, (gfloat) 0);
	g_object_ref_sink (_tmp4_);
	description_label = _tmp4_;
	_tmp5_ = description_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->buttonbox);
	self->priv->buttonbox = _tmp6_;
	_tmp7_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp7_);
	grid = _tmp7_;
	_tmp8_ = grid;
	_tmp9_ = image;
	gtk_grid_attach (_tmp8_, (GtkWidget*) _tmp9_, 0, 0, 1, 2);
	_tmp10_ = grid;
	_tmp11_ = title_label;
	gtk_grid_attach (_tmp10_, (GtkWidget*) _tmp11_, 1, 0, 1, 1);
	_tmp12_ = grid;
	_tmp13_ = description_label;
	gtk_grid_attach (_tmp12_, (GtkWidget*) _tmp13_, 1, 1, 1, 1);
	_tmp14_ = grid;
	_tmp15_ = self->priv->buttonbox;
	gtk_grid_attach (_tmp14_, (GtkWidget*) _tmp15_, 1, 2, 1, 1);
	_tmp16_ = grid;
	gtk_widget_set_parent ((GtkWidget*) _tmp16_, (GtkWidget*) self);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand ((GtkWidget*) self, TRUE);
	_tmp17_ = title_label;
	g_object_bind_property_with_closures ((GObject*) self, "title", (GObject*) _tmp17_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp18_ = description_label;
	g_object_bind_property_with_closures ((GObject*) self, "description", (GObject*) _tmp18_, "label", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp19_ = description_label;
	g_object_bind_property_with_closures ((GObject*) self, "description", (GObject*) _tmp19_, "visible", G_BINDING_SYNC_CREATE | G_BINDING_DEFAULT, (GClosure*) ((__granite_placeholder___lambda21__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __granite_placeholder___lambda21__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp20_ = image;
	g_object_bind_property_with_closures ((GObject*) self, "icon", (GObject*) _tmp20_, "gicon", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp21_ = image;
	g_object_bind_property_with_closures ((GObject*) self, "icon", (GObject*) _tmp21_, "visible", G_BINDING_SYNC_CREATE | G_BINDING_DEFAULT, (GClosure*) ((__granite_placeholder___lambda22__gbinding_transform_func == NULL) ? NULL : g_cclosure_new ((GCallback) __granite_placeholder___lambda22__gbinding_transform_func, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (grid);
	_g_object_unref0 (description_label);
	_g_object_unref0 (title_label);
	_g_object_unref0 (image);
	return obj;
}

static void
granite_placeholder_base_init (GranitePlaceholderClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "placeholder");
	gtk_widget_class_set_layout_manager_type (GTK_WIDGET_CLASS (klass), gtk_bin_layout_get_type ());
}

static void
granite_placeholder_class_init (GranitePlaceholderClass * klass,
                                gpointer klass_data)
{
	granite_placeholder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GranitePlaceholder_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_placeholder_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_placeholder_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_placeholder_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_placeholder_finalize;
	/**
	     * The {@link string} to use for the primary text
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_PLACEHOLDER_TITLE_PROPERTY, granite_placeholder_properties[GRANITE_PLACEHOLDER_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The {@link string} to use for description text
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_PLACEHOLDER_DESCRIPTION_PROPERTY, granite_placeholder_properties[GRANITE_PLACEHOLDER_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The {@link GLib.Icon} to use as the primary icon
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_PLACEHOLDER_ICON_PROPERTY, granite_placeholder_properties[GRANITE_PLACEHOLDER_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
granite_placeholder_instance_init (GranitePlaceholder * self,
                                   gpointer klass)
{
	self->priv = granite_placeholder_get_instance_private (self);
}

static void
granite_placeholder_finalize (GObject * obj)
{
	GranitePlaceholder * self;
	GtkWidget* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_PLACEHOLDER, GranitePlaceholder);
	_tmp0_ = gtk_widget_get_first_child ((GtkWidget*) self);
	gtk_widget_unparent (_tmp0_);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_description);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->buttonbox);
	G_OBJECT_CLASS (granite_placeholder_parent_class)->finalize (obj);
}

/**
 * Placeholder is used to provide further information in an empty view such as a {@link Gtk.ListBox} or when onboarding.
 *
 * ''Example''<<BR>>
 * {{{
 *   var alert = new Granite.Placeholder ("Panic! At the Button") {
 *       description = "Maybe you can <b>do something</b> to hide it but <i>otherwise</i> it will stay here",
 *       icon = new ThemedIcon ("dialog-warning")
 *   };
 *
 *   var alert_action = alert.append_button (
 *       new ThemedIcon ("edit-delete"),
 *       "Hide This Button",
 *       "Click here to hide this"
 *   );
 * }}}
 */
static GType
granite_placeholder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GranitePlaceholderClass), (GBaseInitFunc) granite_placeholder_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_placeholder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GranitePlaceholder), 0, (GInstanceInitFunc) granite_placeholder_instance_init, NULL };
	GType granite_placeholder_type_id;
	granite_placeholder_type_id = g_type_register_static (gtk_widget_get_type (), "GranitePlaceholder", &g_define_type_info, 0);
	GranitePlaceholder_private_offset = g_type_add_instance_private (granite_placeholder_type_id, sizeof (GranitePlaceholderPrivate));
	return granite_placeholder_type_id;
}

GType
granite_placeholder_get_type (void)
{
	static volatile gsize granite_placeholder_type_id__once = 0;
	if (g_once_init_enter (&granite_placeholder_type_id__once)) {
		GType granite_placeholder_type_id;
		granite_placeholder_type_id = granite_placeholder_get_type_once ();
		g_once_init_leave (&granite_placeholder_type_id__once, granite_placeholder_type_id);
	}
	return granite_placeholder_type_id__once;
}

static void
_vala_granite_placeholder_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GranitePlaceholder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_PLACEHOLDER, GranitePlaceholder);
	switch (property_id) {
		case GRANITE_PLACEHOLDER_TITLE_PROPERTY:
		g_value_set_string (value, granite_placeholder_get_title (self));
		break;
		case GRANITE_PLACEHOLDER_DESCRIPTION_PROPERTY:
		g_value_set_string (value, granite_placeholder_get_description (self));
		break;
		case GRANITE_PLACEHOLDER_ICON_PROPERTY:
		g_value_set_object (value, granite_placeholder_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_placeholder_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GranitePlaceholder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_PLACEHOLDER, GranitePlaceholder);
	switch (property_id) {
		case GRANITE_PLACEHOLDER_TITLE_PROPERTY:
		granite_placeholder_set_title (self, g_value_get_string (value));
		break;
		case GRANITE_PLACEHOLDER_DESCRIPTION_PROPERTY:
		granite_placeholder_set_description (self, g_value_get_string (value));
		break;
		case GRANITE_PLACEHOLDER_ICON_PROPERTY:
		granite_placeholder_set_icon (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

