// Code generated by astool. DO NOT EDIT.

package propertyvalue

import (
	"fmt"
	string1 "github.com/superseriousbusiness/activity/streams/values/string"
	vocab "github.com/superseriousbusiness/activity/streams/vocab"
	"net/url"
)

// SchemaValueProperty is the functional property "value". It is permitted to be a
// single default-valued value type.
type SchemaValueProperty struct {
	xmlschemaStringMember string
	hasStringMember       bool
	unknown               interface{}
	iri                   *url.URL
	alias                 string
}

// DeserializeValueProperty creates a "value" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeValueProperty(m map[string]interface{}, aliasMap map[string]string) (*SchemaValueProperty, error) {
	alias := ""
	if a, ok := aliasMap["http://schema.org"]; ok {
		alias = a
	}
	propName := "value"
	if len(alias) > 0 {
		// Use alias both to find the property, and set within the property.
		propName = fmt.Sprintf("%s:%s", alias, "value")
	}
	i, ok := m[propName]

	if ok {
		if s, ok := i.(string); ok {
			u, err := url.Parse(s)
			// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
			// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
			if err == nil && len(u.Scheme) > 0 {
				this := &SchemaValueProperty{
					alias: alias,
					iri:   u,
				}
				return this, nil
			}
		}
		if v, err := string1.DeserializeString(i); err == nil {
			this := &SchemaValueProperty{
				alias:                 alias,
				hasStringMember:       true,
				xmlschemaStringMember: v,
			}
			return this, nil
		}
		this := &SchemaValueProperty{
			alias:   alias,
			unknown: i,
		}
		return this, nil
	}
	return nil, nil
}

// NewSchemaValueProperty creates a new value property.
func NewSchemaValueProperty() *SchemaValueProperty {
	return &SchemaValueProperty{alias: ""}
}

// Clear ensures no value of this property is set. Calling IsXMLSchemaString
// afterwards will return false.
func (this *SchemaValueProperty) Clear() {
	this.unknown = nil
	this.iri = nil
	this.hasStringMember = false
}

// Get returns the value of this property. When IsXMLSchemaString returns false,
// Get will return any arbitrary value.
func (this SchemaValueProperty) Get() string {
	return this.xmlschemaStringMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return any arbitrary value.
func (this SchemaValueProperty) GetIRI() *url.URL {
	return this.iri
}

// HasAny returns true if the value or IRI is set.
func (this SchemaValueProperty) HasAny() bool {
	return this.IsXMLSchemaString() || this.iri != nil
}

// IsIRI returns true if this property is an IRI.
func (this SchemaValueProperty) IsIRI() bool {
	return this.iri != nil
}

// IsXMLSchemaString returns true if this property is set and not an IRI.
func (this SchemaValueProperty) IsXMLSchemaString() bool {
	return this.hasStringMember
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this SchemaValueProperty) JSONLDContext() map[string]string {
	m := map[string]string{"http://schema.org": this.alias}
	var child map[string]string

	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this SchemaValueProperty) KindIndex() int {
	if this.IsXMLSchemaString() {
		return 0
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this SchemaValueProperty) LessThan(o vocab.SchemaValueProperty) bool {
	// LessThan comparison for if either or both are IRIs.
	if this.IsIRI() && o.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	} else if this.IsIRI() {
		// IRIs are always less than other values, none, or unknowns
		return true
	} else if o.IsIRI() {
		// This other, none, or unknown value is always greater than IRIs
		return false
	}
	// LessThan comparison for the single value or unknown value.
	if !this.IsXMLSchemaString() && !o.IsXMLSchemaString() {
		// Both are unknowns.
		return false
	} else if this.IsXMLSchemaString() && !o.IsXMLSchemaString() {
		// Values are always greater than unknown values.
		return false
	} else if !this.IsXMLSchemaString() && o.IsXMLSchemaString() {
		// Unknowns are always less than known values.
		return true
	} else {
		// Actual comparison.
		return string1.LessString(this.Get(), o.Get())
	}
}

// Name returns the name of this property: "value".
func (this SchemaValueProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "value"
	} else {
		return "value"
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this SchemaValueProperty) Serialize() (interface{}, error) {
	if this.IsXMLSchemaString() {
		return string1.SerializeString(this.Get())
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// Set sets the value of this property. Calling IsXMLSchemaString afterwards will
// return true.
func (this *SchemaValueProperty) Set(v string) {
	this.Clear()
	this.xmlschemaStringMember = v
	this.hasStringMember = true
}

// SetIRI sets the value of this property. Calling IsIRI afterwards will return
// true.
func (this *SchemaValueProperty) SetIRI(v *url.URL) {
	this.Clear()
	this.iri = v
}
