// GoToSocial
// Copyright (C) GoToSocial Authors admin@gotosocial.org
// SPDX-License-Identifier: AGPL-3.0-or-later
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

package config

import (
	"net/netip"

	"github.com/superseriousbusiness/gotosocial/internal/log"
)

func MustParseIPPrefixes(in []string) []netip.Prefix {
	prefs := make([]netip.Prefix, 0, len(in))

	for _, i := range in {
		pref, err := netip.ParsePrefix(i)
		if err != nil {
			log.Panicf(nil, "error parsing ip prefix from %q: %v", i, err)
		}

		prefs = append(prefs, pref)
	}

	return prefs
}
