/* window.c generated by valac 0.56.16, the Vala compiler
 * generated from window.vala, do not modify */

/* window.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 * Copyright (C) 2020 Adrien Plazas <kekun.plazas@laposte.net>
 * Copyright (C) 2024 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_WINDOW (usage_window_get_type ())
#define USAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_WINDOW, UsageWindow))
#define USAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_WINDOW, UsageWindowClass))
#define USAGE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_WINDOW))
#define USAGE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_WINDOW))
#define USAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_WINDOW, UsageWindowClass))

typedef struct _UsageWindow UsageWindow;
typedef struct _UsageWindowClass UsageWindowClass;
typedef struct _UsageWindowPrivate UsageWindowPrivate;

#define USAGE_TYPE_VIEW (usage_view_get_type ())
#define USAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_VIEW, UsageView))
#define USAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_VIEW, UsageViewClass))
#define USAGE_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_VIEW))
#define USAGE_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_VIEW))
#define USAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_VIEW, UsageViewClass))

typedef struct _UsageView UsageView;
typedef struct _UsageViewClass UsageViewClass;
enum  {
	USAGE_WINDOW_0_PROPERTY,
	USAGE_WINDOW_NUM_PROPERTIES
};
static GParamSpec* usage_window_properties[USAGE_WINDOW_NUM_PROPERTIES];

#define USAGE_TYPE_CPU_VIEW (usage_cpu_view_get_type ())
#define USAGE_CPU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_CPU_VIEW, UsageCpuView))
#define USAGE_CPU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_CPU_VIEW, UsageCpuViewClass))
#define USAGE_IS_CPU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_CPU_VIEW))
#define USAGE_IS_CPU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_CPU_VIEW))
#define USAGE_CPU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_CPU_VIEW, UsageCpuViewClass))

typedef struct _UsageCpuView UsageCpuView;
typedef struct _UsageCpuViewClass UsageCpuViewClass;

#define USAGE_TYPE_MEMORY_VIEW (usage_memory_view_get_type ())
#define USAGE_MEMORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_VIEW, UsageMemoryView))
#define USAGE_MEMORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_VIEW, UsageMemoryViewClass))
#define USAGE_IS_MEMORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_VIEW))
#define USAGE_IS_MEMORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_VIEW))
#define USAGE_MEMORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_VIEW, UsageMemoryViewClass))

typedef struct _UsageMemoryView UsageMemoryView;
typedef struct _UsageMemoryViewClass UsageMemoryViewClass;

#define USAGE_TYPE_STORAGE_VIEW (usage_storage_view_get_type ())
#define USAGE_STORAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW, UsageStorageView))
#define USAGE_STORAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW, UsageStorageViewClass))
#define USAGE_IS_STORAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW))
#define USAGE_IS_STORAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW))
#define USAGE_STORAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW, UsageStorageViewClass))

typedef struct _UsageStorageView UsageStorageView;
typedef struct _UsageStorageViewClass UsageStorageViewClass;
typedef struct _UsageViewPrivate UsageViewPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _UsageWindow {
	AdwApplicationWindow parent_instance;
	UsageWindowPrivate * priv;
};

struct _UsageWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _UsageWindowPrivate {
	AdwViewStack* stack;
	GtkRevealer* performance_search_revealer;
	GtkToggleButton* performance_search_button;
	GtkSearchEntry* search_entry;
	AdwToolbarView* content_area;
	UsageView** views;
	gint views_length1;
	gint _views_size_;
};

struct _UsageView {
	AdwBreakpointBin parent_instance;
	UsageViewPrivate * priv;
	gchar* title;
	gchar* icon_name;
	GtkWidget* switcher_widget;
	gboolean search_available;
};

struct _UsageViewClass {
	AdwBreakpointBinClass parent_class;
	void (*set_search_text) (UsageView* self, const gchar* query);
};

static gint UsageWindow_private_offset;
static gpointer usage_window_parent_class = NULL;

VALA_EXTERN GType usage_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageWindow, g_object_unref)
VALA_EXTERN GType usage_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageView, g_object_unref)
VALA_EXTERN UsageWindow* usage_window_new (GtkApplication* application);
VALA_EXTERN UsageWindow* usage_window_construct (GType object_type,
                                     GtkApplication* application);
VALA_EXTERN UsageCpuView* usage_cpu_view_new (void);
VALA_EXTERN UsageCpuView* usage_cpu_view_construct (GType object_type);
VALA_EXTERN GType usage_cpu_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageCpuView, g_object_unref)
VALA_EXTERN UsageMemoryView* usage_memory_view_new (void);
VALA_EXTERN UsageMemoryView* usage_memory_view_construct (GType object_type);
VALA_EXTERN GType usage_memory_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemoryView, g_object_unref)
VALA_EXTERN UsageStorageView* usage_storage_view_new (void);
VALA_EXTERN UsageStorageView* usage_storage_view_construct (GType object_type);
VALA_EXTERN GType usage_storage_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageView, g_object_unref)
VALA_EXTERN void usage_window_action_on_search (UsageWindow* self);
static void usage_window_on_performance_search_button_toggled (UsageWindow* self);
static void _usage_window_on_performance_search_button_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                   gpointer self);
static void usage_window_on_search_entry_changed (UsageWindow* self);
VALA_EXTERN void usage_view_set_search_text (UsageView* self,
                                 const gchar* query);
static void _usage_window_on_search_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                            gpointer self);
static gboolean usage_window_on_search_entry_key_pressed (UsageWindow* self,
                                                   guint keyvalue,
                                                   guint keycode,
                                                   GdkModifierType state);
static gboolean _usage_window_on_search_entry_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                         guint keyval,
                                                                                         guint keycode,
                                                                                         GdkModifierType state,
                                                                                         gpointer self);
static void usage_window_on_visible_child_changed (UsageWindow* self);
static void _usage_window_on_visible_child_changed_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static gchar* usage_window_get_title_for_usage_view (UsageWindow* self,
                                              UsageView* view);
static GtkWidget* usage_window_get_switcher_widget_for_usage_view (UsageWindow* self,
                                                            UsageView* view);
static void usage_window_finalize (GObject * obj);
static GType usage_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_window_get_instance_private (UsageWindow* self)
{
	return G_STRUCT_MEMBER_P (self, UsageWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

UsageWindow*
usage_window_construct (GType object_type,
                        GtkApplication* application)
{
	UsageWindow * self = NULL;
	UsageCpuView* _tmp0_;
	UsageMemoryView* _tmp1_;
	UsageStorageView* _tmp2_;
	UsageView** _tmp3_;
	UsageView** _tmp4_;
	gint _tmp4__length1;
	GtkSearchEntry* _tmp15_;
	AdwToolbarView* _tmp16_;
	g_return_val_if_fail (application != NULL, NULL);
	self = (UsageWindow*) g_object_new (object_type, "application", application, NULL);
	if (g_strcmp0 (PROFILE, "Devel") == 0) {
		gtk_widget_add_css_class ((GtkWidget*) self, "devel");
	}
	_tmp0_ = usage_cpu_view_new ();
	g_object_ref_sink (_tmp0_);
	_tmp1_ = usage_memory_view_new ();
	g_object_ref_sink (_tmp1_);
	_tmp2_ = usage_storage_view_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = g_new0 (UsageView*, 3 + 1);
	_tmp3_[0] = (UsageView*) _tmp0_;
	_tmp3_[1] = (UsageView*) _tmp1_;
	_tmp3_[2] = (UsageView*) _tmp2_;
	self->priv->views = (_vala_array_free (self->priv->views, self->priv->views_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->views = _tmp3_;
	self->priv->views_length1 = 3;
	self->priv->_views_size_ = self->priv->views_length1;
	_tmp4_ = self->priv->views;
	_tmp4__length1 = self->priv->views_length1;
	{
		UsageView** view_collection = NULL;
		gint view_collection_length1 = 0;
		gint _view_collection_size_ = 0;
		gint view_it = 0;
		view_collection = _tmp4_;
		view_collection_length1 = _tmp4__length1;
		for (view_it = 0; view_it < view_collection_length1; view_it = view_it + 1) {
			UsageView* _tmp5_;
			UsageView* view = NULL;
			_tmp5_ = _g_object_ref0 (view_collection[view_it]);
			view = _tmp5_;
			{
				AdwViewStack* _tmp6_;
				UsageView* _tmp7_;
				UsageView* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				UsageView* _tmp11_;
				const gchar* _tmp12_;
				UsageView* _tmp13_;
				const gchar* _tmp14_;
				_tmp6_ = self->priv->stack;
				_tmp7_ = view;
				_tmp8_ = view;
				_tmp9_ = gtk_widget_get_name ((GtkWidget*) _tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = view;
				_tmp12_ = _tmp11_->title;
				_tmp13_ = view;
				_tmp14_ = _tmp13_->icon_name;
				adw_view_stack_add_titled_with_icon (_tmp6_, (GtkWidget*) _tmp7_, _tmp10_, _tmp12_, _tmp14_);
				_g_object_unref0 (view);
			}
		}
	}
	_tmp15_ = self->priv->search_entry;
	_tmp16_ = self->priv->content_area;
	gtk_search_entry_set_key_capture_widget (_tmp15_, (GtkWidget*) _tmp16_);
	return self;
}

UsageWindow*
usage_window_new (GtkApplication* application)
{
	return usage_window_construct (USAGE_TYPE_WINDOW, application);
}

void
usage_window_action_on_search (UsageWindow* self)
{
	AdwViewStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, USAGE_TYPE_VIEW, UsageView)->search_available) {
		GtkToggleButton* _tmp3_;
		GtkToggleButton* _tmp4_;
		_tmp3_ = self->priv->performance_search_button;
		_tmp4_ = self->priv->performance_search_button;
		gtk_toggle_button_set_active (_tmp3_, !gtk_toggle_button_get_active (_tmp4_));
	}
}

static void
usage_window_on_performance_search_button_toggled (UsageWindow* self)
{
	GtkToggleButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->performance_search_button;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GtkSearchEntry* _tmp3_;
		_tmp3_ = self->priv->search_entry;
		gtk_editable_set_text ((GtkEditable*) _tmp3_, "");
	} else {
		GtkSearchEntry* _tmp4_;
		_tmp4_ = self->priv->search_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	}
}

static void
_usage_window_on_performance_search_button_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                              gpointer self)
{
	usage_window_on_performance_search_button_toggled ((UsageWindow*) self);
}

static void
usage_window_on_search_entry_changed (UsageWindow* self)
{
	UsageView** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->views;
	_tmp0__length1 = self->priv->views_length1;
	{
		UsageView** view_collection = NULL;
		gint view_collection_length1 = 0;
		gint _view_collection_size_ = 0;
		gint view_it = 0;
		view_collection = _tmp0_;
		view_collection_length1 = _tmp0__length1;
		for (view_it = 0; view_it < view_collection_length1; view_it = view_it + 1) {
			UsageView* _tmp1_;
			UsageView* view = NULL;
			_tmp1_ = _g_object_ref0 (view_collection[view_it]);
			view = _tmp1_;
			{
				UsageView* _tmp2_;
				GtkSearchEntry* _tmp3_;
				const gchar* _tmp4_;
				_tmp2_ = view;
				_tmp3_ = self->priv->search_entry;
				_tmp4_ = gtk_editable_get_text ((GtkEditable*) _tmp3_);
				usage_view_set_search_text (_tmp2_, _tmp4_);
				_g_object_unref0 (view);
			}
		}
	}
}

static void
_usage_window_on_search_entry_changed_gtk_search_entry_search_changed (GtkSearchEntry* _sender,
                                                                       gpointer self)
{
	usage_window_on_search_entry_changed ((UsageWindow*) self);
}

static gboolean
usage_window_on_search_entry_key_pressed (UsageWindow* self,
                                          guint keyvalue,
                                          guint keycode,
                                          GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (keyvalue == GDK_KEY_Down) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyvalue == GDK_KEY_KP_Down;
	}
	if (_tmp0_) {
		result = gtk_widget_child_focus ((GtkWidget*) self, GTK_DIR_TAB_FORWARD);
		return result;
	}
	if (keyvalue == GDK_KEY_Escape) {
		GtkToggleButton* _tmp1_;
		_tmp1_ = self->priv->performance_search_button;
		gtk_toggle_button_set_active (_tmp1_, FALSE);
	}
	result = FALSE;
	return result;
}

static gboolean
_usage_window_on_search_entry_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                guint keyval,
                                                                                guint keycode,
                                                                                GdkModifierType state,
                                                                                gpointer self)
{
	gboolean result;
	result = usage_window_on_search_entry_key_pressed ((UsageWindow*) self, keyval, keycode, state);
	return result;
}

static void
usage_window_on_visible_child_changed (UsageWindow* self)
{
	gboolean search_available = FALSE;
	AdwViewStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkToggleButton* _tmp3_;
	GtkToggleButton* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkRevealer* _tmp7_;
	GSimpleAction* performance_action = NULL;
	GtkApplication* _tmp8_;
	GAction* _tmp9_;
	GSimpleAction* _tmp10_;
	GSimpleAction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = adw_view_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	search_available = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, USAGE_TYPE_VIEW, UsageView)->search_available;
	_tmp3_ = self->priv->performance_search_button;
	_tmp4_ = self->priv->performance_search_button;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	gtk_toggle_button_set_active (_tmp4_, _tmp6_ & search_available);
	_tmp7_ = self->priv->performance_search_revealer;
	gtk_revealer_set_reveal_child (_tmp7_, search_available);
	_tmp8_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp9_ = g_action_map_lookup_action ((GActionMap*) _tmp8_, "filter-processes");
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp9_) : NULL);
	performance_action = _tmp10_;
	_tmp11_ = performance_action;
	if (_tmp11_ != NULL) {
		GSimpleAction* _tmp12_;
		_tmp12_ = performance_action;
		g_simple_action_set_enabled (_tmp12_, search_available);
	}
	_g_object_unref0 (performance_action);
}

static void
_usage_window_on_visible_child_changed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	usage_window_on_visible_child_changed ((UsageWindow*) self);
}

static gchar*
usage_window_get_title_for_usage_view (UsageWindow* self,
                                       UsageView* view)
{
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (view != NULL) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = view->title;
		_tmp1_ = g_strdup (_tmp0_);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_strdup ("");
	result = _tmp2_;
	return result;
}

static GtkWidget*
usage_window_get_switcher_widget_for_usage_view (UsageWindow* self,
                                                 UsageView* view)
{
	GtkWidget* switcher_widget = NULL;
	gchar* fallback_icon_name = NULL;
	gchar* _tmp0_;
	GtkWidget* _tmp5_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	switcher_widget = NULL;
	_tmp0_ = g_strdup ("speedometer-symbolic");
	fallback_icon_name = _tmp0_;
	if (view != NULL) {
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = view->switcher_widget;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_g_object_unref0 (switcher_widget);
		switcher_widget = _tmp2_;
		_tmp3_ = view->icon_name;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (fallback_icon_name);
		fallback_icon_name = _tmp4_;
	}
	_tmp5_ = switcher_widget;
	if (_tmp5_ == NULL) {
		GtkImage* fallback_icon = NULL;
		const gchar* _tmp6_;
		GtkImage* _tmp7_;
		GtkImage* _tmp8_;
		GtkImage* _tmp9_;
		GtkWidget* _tmp10_;
		_tmp6_ = fallback_icon_name;
		_tmp7_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp6_);
		g_object_ref_sink (_tmp7_);
		fallback_icon = _tmp7_;
		_tmp8_ = fallback_icon;
		gtk_image_set_icon_size (_tmp8_, GTK_ICON_SIZE_LARGE);
		_tmp9_ = fallback_icon;
		_tmp10_ = _g_object_ref0 ((GtkWidget*) _tmp9_);
		_g_object_unref0 (switcher_widget);
		switcher_widget = _tmp10_;
		_g_object_unref0 (fallback_icon);
	}
	result = switcher_widget;
	_g_free0 (fallback_icon_name);
	return result;
}

static void
usage_window_class_init (UsageWindowClass * klass,
                         gpointer klass_data)
{
	usage_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageWindow_private_offset);
	G_OBJECT_CLASS (klass)->finalize = usage_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, UsageWindow_private_offset + G_STRUCT_OFFSET (UsageWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "performance_search_revealer", FALSE, UsageWindow_private_offset + G_STRUCT_OFFSET (UsageWindowPrivate, performance_search_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "performance_search_button", FALSE, UsageWindow_private_offset + G_STRUCT_OFFSET (UsageWindowPrivate, performance_search_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "search_entry", FALSE, UsageWindow_private_offset + G_STRUCT_OFFSET (UsageWindowPrivate, search_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_area", FALSE, UsageWindow_private_offset + G_STRUCT_OFFSET (UsageWindowPrivate, content_area));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_performance_search_button_toggled", G_CALLBACK(_usage_window_on_performance_search_button_toggled_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_entry_changed", G_CALLBACK(_usage_window_on_search_entry_changed_gtk_search_entry_search_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_search_entry_key_pressed", G_CALLBACK(_usage_window_on_search_entry_key_pressed_gtk_event_controller_key_key_pressed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_visible_child_changed", G_CALLBACK(_usage_window_on_visible_child_changed_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "get_title_for_usage_view", G_CALLBACK(usage_window_get_title_for_usage_view));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "get_switcher_widget_for_usage_view", (GCallback) usage_window_get_switcher_widget_for_usage_view);
}

static void
usage_window_instance_init (UsageWindow * self,
                            gpointer klass)
{
	self->priv = usage_window_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_window_finalize (GObject * obj)
{
	UsageWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_WINDOW, UsageWindow);
	self->priv->views = (_vala_array_free (self->priv->views, self->priv->views_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (usage_window_parent_class)->finalize (obj);
}

static GType
usage_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageWindow), 0, (GInstanceInitFunc) usage_window_instance_init, NULL };
	GType usage_window_type_id;
	usage_window_type_id = g_type_register_static (adw_application_window_get_type (), "UsageWindow", &g_define_type_info, 0);
	UsageWindow_private_offset = g_type_add_instance_private (usage_window_type_id, sizeof (UsageWindowPrivate));
	return usage_window_type_id;
}

GType
usage_window_get_type (void)
{
	static volatile gsize usage_window_type_id__once = 0;
	if (g_once_init_enter (&usage_window_type_id__once)) {
		GType usage_window_type_id;
		usage_window_type_id = usage_window_get_type_once ();
		g_once_init_leave (&usage_window_type_id__once, usage_window_type_id);
	}
	return usage_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

