/* storage-view.c generated by valac 0.56.16, the Vala compiler
 * generated from storage-view.vala, do not modify */

/* storage-view.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Felipe Borges <felipeborges@gnome.org>
 *          Petr Štětka <pstetka@redhat.com>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>
#include <glibtop/mountlist.h>
#include <glibtop.h>
#include <glibtop/fsusage.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>

#define USAGE_STORAGE_VIEW_MIN_PERCENTAGE_SHOWN_FILES ((guint) 2)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_VIEW (usage_view_get_type ())
#define USAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_VIEW, UsageView))
#define USAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_VIEW, UsageViewClass))
#define USAGE_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_VIEW))
#define USAGE_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_VIEW))
#define USAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_VIEW, UsageViewClass))

typedef struct _UsageView UsageView;
typedef struct _UsageViewClass UsageViewClass;
typedef struct _UsageViewPrivate UsageViewPrivate;

#define USAGE_TYPE_STORAGE_VIEW (usage_storage_view_get_type ())
#define USAGE_STORAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW, UsageStorageView))
#define USAGE_STORAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW, UsageStorageViewClass))
#define USAGE_IS_STORAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW))
#define USAGE_IS_STORAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW))
#define USAGE_STORAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW, UsageStorageViewClass))

typedef struct _UsageStorageView UsageStorageView;
typedef struct _UsageStorageViewClass UsageStorageViewClass;
typedef struct _UsageStorageViewPrivate UsageStorageViewPrivate;

#define USAGE_TYPE_STORAGE_VIEW_ROW (usage_storage_view_row_get_type ())
#define USAGE_STORAGE_VIEW_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRow))
#define USAGE_STORAGE_VIEW_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRowClass))
#define USAGE_IS_STORAGE_VIEW_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ROW))
#define USAGE_IS_STORAGE_VIEW_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ROW))
#define USAGE_STORAGE_VIEW_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ROW, UsageStorageViewRowClass))

typedef struct _UsageStorageViewRow UsageStorageViewRow;
typedef struct _UsageStorageViewRowClass UsageStorageViewRowClass;

#define USAGE_TYPE_STACK_LIST (usage_stack_list_get_type ())
#define USAGE_STACK_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STACK_LIST, UsageStackList))
#define USAGE_STACK_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STACK_LIST, UsageStackListClass))
#define USAGE_IS_STACK_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STACK_LIST))
#define USAGE_IS_STACK_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STACK_LIST))
#define USAGE_STACK_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STACK_LIST, UsageStackListClass))

typedef struct _UsageStackList UsageStackList;
typedef struct _UsageStackListClass UsageStackListClass;

#define USAGE_TYPE_STORAGE_GRAPH (usage_storage_graph_get_type ())
#define USAGE_STORAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraph))
#define USAGE_STORAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraphClass))
#define USAGE_IS_STORAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_GRAPH))
#define USAGE_IS_STORAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_GRAPH))
#define USAGE_STORAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraphClass))

typedef struct _UsageStorageGraph UsageStorageGraph;
typedef struct _UsageStorageGraphClass UsageStorageGraphClass;

#define USAGE_TYPE_STORAGE_ACTION_BAR (usage_storage_action_bar_get_type ())
#define USAGE_STORAGE_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_ACTION_BAR, UsageStorageActionBar))
#define USAGE_STORAGE_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_ACTION_BAR, UsageStorageActionBarClass))
#define USAGE_IS_STORAGE_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_ACTION_BAR))
#define USAGE_IS_STORAGE_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_ACTION_BAR))
#define USAGE_STORAGE_ACTION_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_ACTION_BAR, UsageStorageActionBarClass))

typedef struct _UsageStorageActionBar UsageStorageActionBar;
typedef struct _UsageStorageActionBarClass UsageStorageActionBarClass;

#define USAGE_TYPE_STORAGE_ROW_POPOVER (usage_storage_row_popover_get_type ())
#define USAGE_STORAGE_ROW_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_ROW_POPOVER, UsageStorageRowPopover))
#define USAGE_STORAGE_ROW_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_ROW_POPOVER, UsageStorageRowPopoverClass))
#define USAGE_IS_STORAGE_ROW_POPOVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_ROW_POPOVER))
#define USAGE_IS_STORAGE_ROW_POPOVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_ROW_POPOVER))
#define USAGE_STORAGE_ROW_POPOVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_ROW_POPOVER, UsageStorageRowPopoverClass))

typedef struct _UsageStorageRowPopover UsageStorageRowPopover;
typedef struct _UsageStorageRowPopoverClass UsageStorageRowPopoverClass;

#define USAGE_TYPE_TRACKER_CONTROLLER (usage_tracker_controller_get_type ())
#define USAGE_TRACKER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerController))
#define USAGE_TRACKER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerControllerClass))
#define USAGE_IS_TRACKER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_TRACKER_CONTROLLER))
#define USAGE_IS_TRACKER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_TRACKER_CONTROLLER))
#define USAGE_TRACKER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_TRACKER_CONTROLLER, UsageTrackerControllerClass))

typedef struct _UsageTrackerController UsageTrackerController;
typedef struct _UsageTrackerControllerClass UsageTrackerControllerClass;

#define USAGE_TYPE_STORAGE_QUERY_BUILDER (usage_storage_query_builder_get_type ())
#define USAGE_STORAGE_QUERY_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_QUERY_BUILDER, UsageStorageQueryBuilder))
#define USAGE_STORAGE_QUERY_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_QUERY_BUILDER, UsageStorageQueryBuilderClass))
#define USAGE_IS_STORAGE_QUERY_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_QUERY_BUILDER))
#define USAGE_IS_STORAGE_QUERY_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_QUERY_BUILDER))
#define USAGE_STORAGE_QUERY_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_QUERY_BUILDER, UsageStorageQueryBuilderClass))

typedef struct _UsageStorageQueryBuilder UsageStorageQueryBuilder;
typedef struct _UsageStorageQueryBuilderClass UsageStorageQueryBuilderClass;

#define USAGE_TYPE_STORAGE_VIEW_ITEM (usage_storage_view_item_get_type ())
#define USAGE_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem))
#define USAGE_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))
#define USAGE_IS_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_IS_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_STORAGE_VIEW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))

typedef struct _UsageStorageViewItem UsageStorageViewItem;
typedef struct _UsageStorageViewItemClass UsageStorageViewItemClass;
enum  {
	USAGE_STORAGE_VIEW_0_PROPERTY,
	USAGE_STORAGE_VIEW_NUM_PROPERTIES
};
static GParamSpec* usage_storage_view_properties[USAGE_STORAGE_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _usage_storage_query_builder_unref0(var) ((var == NULL) ? NULL : (var = (usage_storage_query_builder_unref (var), NULL)))
typedef struct _UsageStorageViewRowPrivate UsageStorageViewRowPrivate;
typedef struct _UsageStorageViewItemPrivate UsageStorageViewItemPrivate;
typedef enum  {
	USAGE_STORAGE_VIEW_TYPE_NONE,
	USAGE_STORAGE_VIEW_TYPE_OS,
	USAGE_STORAGE_VIEW_TYPE_UP_FOLDER,
	USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH,
	USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM
} UsageStorageViewType;

#define USAGE_TYPE_STORAGE_VIEW_TYPE (usage_storage_view_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
typedef struct _UsageStorageViewPresentDirData UsageStorageViewPresentDirData;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
typedef struct _UsageStorageViewPopulateViewData UsageStorageViewPopulateViewData;

struct _UsageView {
	AdwBreakpointBin parent_instance;
	UsageViewPrivate * priv;
	gchar* title;
	gchar* icon_name;
	GtkWidget* switcher_widget;
	gboolean search_available;
};

struct _UsageViewClass {
	AdwBreakpointBinClass parent_class;
	void (*set_search_text) (UsageView* self, const gchar* query);
};

struct _UsageStorageView {
	UsageView parent_instance;
	UsageStorageViewPrivate * priv;
};

struct _UsageStorageViewClass {
	UsageViewClass parent_class;
};

struct _UsageStorageViewPrivate {
	GtkLabel* header_label;
	UsageStorageViewRow* used_row;
	UsageStorageViewRow* available_row;
	UsageStackList* listbox;
	UsageStorageGraph* graph;
	UsageStorageActionBar* actionbar;
	GtkProgressBar* directory_loading_bar;
	UsageStorageRowPopover* row_popover;
	TrackerSparqlConnection* connection;
	UsageTrackerController* controller;
	UsageStorageQueryBuilder* query_builder;
	UsageStorageViewItem* os_item;
	GCancellable* cancellable;
	guint64 total_used_size;
	guint64 total_free_size;
	guint64 total_size;
	GtkLevelBar* switcher_level;
	GtkLabel* switcher_label;
	GUserDirectory* xdg_folders;
	gint xdg_folders_length1;
	gint _xdg_folders_size_;
	GList* selected_items;
	GQueue* selected_items_stack;
};

struct _UsageStorageViewRow {
	GtkListBoxRow parent_instance;
	UsageStorageViewRowPrivate * priv;
	GtkCheckButton* check_button;
	GtkLabel* size_label;
	GtkSpinner* spinner;
	GtkBox* tag;
	UsageStorageViewItem* item;
};

struct _UsageStorageViewRowClass {
	GtkListBoxRowClass parent_class;
};

struct _UsageStorageViewItem {
	GObject parent_instance;
	UsageStorageViewItemPrivate * priv;
	gchar* uri;
	gchar* name;
	guint64 size;
	GFileType type;
	GUserDirectory* dir;
	gchar* ontology;
	UsageStorageViewType custom_type;
};

struct _UsageStorageViewItemClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	UsageStorageView* self;
	GtkListBoxRow* hidden_row;
};

struct _Block8Data {
	int _ref_count_;
	UsageStorageView* self;
	GListStore* model;
	GCancellable* cancellable;
	gpointer _async_data_;
};

struct _UsageStorageViewPresentDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UsageStorageView* self;
	gchar* uri;
	GUserDirectory* dir;
	GCancellable* cancellable;
	Block8Data* _data8_;
	gboolean _tmp0_;
	TrackerSparqlConnection* _tmp1_;
	GListStore* _tmp2_;
	GFile* file;
	GFile* _tmp3_;
	UsageStorageViewItem* item;
	GFile* _tmp4_;
	UsageStorageViewItem* _tmp5_;
	UsageStorageViewItem* _tmp6_;
	UsageStorageViewItem* _tmp7_;
	GUserDirectory* _tmp8_;
	GListStore* _tmp9_;
	UsageStorageViewItem* _tmp10_;
	UsageTrackerController* _tmp11_;
	GListStore* _tmp12_;
	UsageTrackerController* _tmp13_;
	UsageStackList* _tmp14_;
	GListStore* _tmp15_;
};

struct _Block9Data {
	int _ref_count_;
	UsageStorageView* self;
	GListStore* model;
	gint items_loaded;
	gpointer _async_data_;
};

struct _Block10Data {
	int _ref_count_;
	Block9Data * _data9_;
	UsageStorageViewItem* item;
};

struct _UsageStorageViewPopulateViewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UsageStorageView* self;
	Block9Data* _data9_;
	TrackerSparqlConnection* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	UsageStorageViewItem* _tmp3_;
	GUserDirectory* _tmp4_;
	gint _tmp4__length1;
	GUserDirectory* dir_collection;
	gint dir_collection_length1;
	gint _dir_collection_size_;
	gint dir_it;
	GUserDirectory dir;
	Block10Data* _data10_;
	GFile* file;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	UsageStorageViewItem* _tmp10_;
	UsageStorageViewItem* _tmp11_;
	GUserDirectory* _tmp12_;
	UsageTrackerController* _tmp13_;
	UsageStorageViewItem* _tmp14_;
	const gchar* _tmp15_;
	UsageStackList* _tmp16_;
	GListStore* _tmp17_;
	UsageStorageViewItem* available_graph_item;
	UsageStorageViewItem* _tmp18_;
	UsageStorageViewItem* _tmp19_;
	UsageStorageViewItem* _tmp20_;
	UsageStorageViewItem* _tmp21_;
	UsageStorageViewItem* _tmp22_;
	GListStore* _tmp23_;
	UsageStorageViewItem* _tmp24_;
};

static gint UsageStorageView_private_offset;
static gpointer usage_storage_view_parent_class = NULL;

VALA_EXTERN GType usage_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageView, g_object_unref)
VALA_EXTERN GType usage_storage_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageView, g_object_unref)
VALA_EXTERN GType usage_storage_view_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewRow, g_object_unref)
VALA_EXTERN GType usage_stack_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStackList, g_object_unref)
VALA_EXTERN GType usage_storage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageGraph, g_object_unref)
VALA_EXTERN GType usage_storage_action_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageActionBar, g_object_unref)
VALA_EXTERN GType usage_storage_row_popover_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageRowPopover, g_object_unref)
VALA_EXTERN GType usage_tracker_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageTrackerController, g_object_unref)
VALA_EXTERN gpointer usage_storage_query_builder_ref (gpointer instance);
VALA_EXTERN void usage_storage_query_builder_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_storage_query_builder (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_storage_query_builder (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void usage_value_take_storage_query_builder (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_storage_query_builder (const GValue* value);
VALA_EXTERN GType usage_storage_query_builder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageQueryBuilder, usage_storage_query_builder_unref)
VALA_EXTERN GType usage_storage_view_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewItem, g_object_unref)
VALA_EXTERN UsageStorageViewItem* usage_storage_view_item_new (void);
VALA_EXTERN UsageStorageViewItem* usage_storage_view_item_construct (GType object_type);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_list_free0_ (gpointer var);
static inline void _g_queue_free__g_list_free0_ (GQueue* self);
VALA_EXTERN UsageStorageView* usage_storage_view_new (void);
VALA_EXTERN UsageStorageView* usage_storage_view_construct (GType object_type);
VALA_EXTERN UsageView* usage_view_construct (GType object_type);
VALA_EXTERN void usage_storage_graph_set_min_percentage_shown_files (UsageStorageGraph* self,
                                                         guint value);
static void usage_storage_view_setup_header_label (UsageStorageView* self);
static void usage_storage_view_setup_mount_sizes (UsageStorageView* self);
static void usage_storage_view_populate_view (UsageStorageView* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void usage_storage_view_populate_view_finish (UsageStorageView* self,
                                              GAsyncResult* _res_);
static void usage_storage_view_on_row_activated (UsageStorageView* self,
                                          GtkListBoxRow* row);
VALA_EXTERN GType usage_storage_view_type_get_type (void) G_GNUC_CONST ;
static void usage_storage_view_stack_listbox_up (UsageStorageView* self);
static void usage_storage_view_clear_selected_items (UsageStorageView* self);
static void usage_storage_view_present_dir (UsageStorageView* self,
                                     const gchar* uri,
                                     GUserDirectory* dir,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void usage_storage_view_present_dir_finish (UsageStorageView* self,
                                            GAsyncResult* _res_);
VALA_EXTERN void usage_storage_row_popover_popup_on_row (UsageStorageRowPopover* self,
                                             UsageStorageViewRow* row);
static void _usage_storage_view_on_row_activated_usage_stack_list_row_activated (UsageStackList* _sender,
                                                                          GtkListBoxRow* row,
                                                                          gpointer self);
static void usage_storage_view_refresh_actionbar (UsageStorageView* self);
VALA_EXTERN gboolean usage_stack_list_layer_up (UsageStackList* self);
VALA_EXTERN GListStore* usage_stack_list_get_model (UsageStackList* self);
VALA_EXTERN gint usage_stack_list_get_depth (UsageStackList* self);
VALA_EXTERN gboolean usage_storage_view_item_get_loaded (UsageStorageViewItem* self);
static void usage_storage_view_refresh_current_dir (UsageStorageView* self);
static gchar* usage_storage_view_get_user_special_dir_path (UsageStorageView* self,
                                                     GUserDirectory dir);
static GtkWidget* usage_storage_view_create_file_row (UsageStorageView* self,
                                               GObject* obj);
VALA_EXTERN UsageStorageViewRow* usage_storage_view_row_new_from_item (UsageStorageViewItem* item);
VALA_EXTERN UsageStorageViewRow* usage_storage_view_row_construct_from_item (GType object_type,
                                                                 UsageStorageViewItem* item);
static void __lambda41_ (UsageStorageView* self,
                  UsageStorageViewRow* row);
VALA_EXTERN gboolean usage_storage_view_row_get_selected (UsageStorageViewRow* self);
static void ___lambda41__usage_storage_view_row_check_button_toggled (UsageStorageViewRow* _sender,
                                                               gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void ___lambda42_ (Block7Data* _data7_);
static void ____lambda42__g_object_notify (GObject* _sender,
                                    GParamSpec* pspec,
                                    gpointer self);
static void usage_storage_view_present_dir_data_free (gpointer _data);
static GUserDirectory* _g_user_directory_dup (GUserDirectory* self);
static gboolean usage_storage_view_present_dir_co (UsageStorageViewPresentDirData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN UsageStorageViewItem* usage_storage_view_item_from_file (GFile* file);
static void usage_storage_view_is_directory_loading (UsageStorageView* self,
                                              gboolean loading);
VALA_EXTERN void usage_tracker_controller_set_model (UsageTrackerController* self,
                                         GListStore* model);
VALA_EXTERN void usage_tracker_controller_enumerate_children (UsageTrackerController* self,
                                                  const gchar* uri,
                                                  GUserDirectory* dir,
                                                  GCancellable* cancellable,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN guint64 usage_tracker_controller_enumerate_children_finish (UsageTrackerController* self,
                                                            GAsyncResult* _res_);
static void __lambda40_ (Block8Data* _data8_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN void usage_storage_view_item_set_loaded (UsageStorageViewItem* self,
                                         gboolean value);
static void ___lambda40__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void usage_stack_list_push_layer (UsageStackList* self,
                                  GListStore* model);
VALA_EXTERN void usage_storage_view_item_set_percentage (UsageStorageViewItem* self,
                                             gdouble value);
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
static void _vala_glibtop_mountentry_array_free (glibtop_mountentry * array,
                                          gssize array_length);
static void usage_storage_view_populate_view_data_free (gpointer _data);
static gboolean usage_storage_view_populate_view_co (UsageStorageViewPopulateViewData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
VALA_EXTERN void usage_tracker_controller_get_file_size (UsageTrackerController* self,
                                             const gchar* uri,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN guint64 usage_tracker_controller_get_file_size_finish (UsageTrackerController* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void ____lambda39_ (Block10Data* _data10_,
                    GObject* obj,
                    GAsyncResult* res);
static void _____lambda39__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
VALA_EXTERN void usage_storage_action_bar_update_selected_items (UsageStorageActionBar* self,
                                                     GList* selected_items);
VALA_EXTERN void usage_storage_graph_update_selected_items (UsageStorageGraph* self,
                                                GList* selected_items);
static gboolean ___lambda38_ (UsageStorageView* self,
                       GtkWidget* widget,
                       GdkFrameClock* frame_clock);
static gboolean ____lambda38__gtk_tick_callback (GtkWidget* widget,
                                          GdkFrameClock* frame_clock,
                                          gpointer self);
static GObject * usage_storage_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN UsageStorageQueryBuilder* usage_storage_query_builder_new (void);
VALA_EXTERN UsageStorageQueryBuilder* usage_storage_query_builder_construct (GType object_type);
VALA_EXTERN UsageTrackerController* usage_tracker_controller_new (TrackerSparqlConnection* connection);
VALA_EXTERN UsageTrackerController* usage_tracker_controller_construct (GType object_type,
                                                            TrackerSparqlConnection* connection);
VALA_EXTERN void usage_stack_list_init (UsageStackList* self,
                            GtkListBoxCreateWidgetFunc row_function,
                            gpointer row_function_target);
static GtkWidget* _usage_storage_view_create_file_row_gtk_list_box_create_widget_func (GObject* item,
                                                                                gpointer self);
static void _usage_storage_view___lambda43_ (UsageStorageView* self,
                                      GListStore* model);
VALA_EXTERN void usage_storage_graph_set_model (UsageStorageGraph* self,
                                    GListStore* value);
static void __usage_storage_view___lambda43__usage_stack_list_model_changed (UsageStackList* _sender,
                                                                      GListStore* model,
                                                                      gpointer self);
static void _usage_storage_view_refresh_current_dir_usage_storage_action_bar_refresh_listbox (UsageStorageActionBar* _sender,
                                                                                       gpointer self);
static void usage_storage_view_finalize (GObject * obj);
static GType usage_storage_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_storage_view_get_instance_private (UsageStorageView* self)
{
	return G_STRUCT_MEMBER_P (self, UsageStorageView_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_g_list_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_list_free (var), NULL));
}

static inline void
_g_queue_free__g_list_free0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_list_free0_);
}

UsageStorageView*
usage_storage_view_construct (GType object_type)
{
	UsageStorageView * self = NULL;
	UsageStorageGraph* _tmp0_;
	self = (UsageStorageView*) usage_view_construct (object_type);
	_tmp0_ = self->priv->graph;
	usage_storage_graph_set_min_percentage_shown_files (_tmp0_, USAGE_STORAGE_VIEW_MIN_PERCENTAGE_SHOWN_FILES);
	usage_storage_view_setup_header_label (self);
	usage_storage_view_setup_mount_sizes (self);
	usage_storage_view_populate_view (self, NULL, NULL);
	return self;
}

UsageStorageView*
usage_storage_view_new (void)
{
	return usage_storage_view_construct (USAGE_TYPE_STORAGE_VIEW);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
usage_storage_view_on_row_activated (UsageStorageView* self,
                                     GtkListBoxRow* row)
{
	UsageStorageViewRow* storage_row = NULL;
	UsageStorageViewRow* _tmp0_;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	UsageStorageViewRow* _tmp3_;
	UsageStorageViewItem* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (USAGE_IS_STORAGE_VIEW_ROW (row) ? ((UsageStorageViewRow*) row) : NULL);
	storage_row = _tmp0_;
	_tmp1_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp1_);
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	_tmp3_ = storage_row;
	_tmp4_ = _tmp3_->item;
	if (_tmp4_->custom_type == USAGE_STORAGE_VIEW_TYPE_UP_FOLDER) {
		usage_storage_view_stack_listbox_up (self);
	} else {
		UsageStorageViewRow* _tmp5_;
		UsageStorageViewItem* _tmp6_;
		_tmp5_ = storage_row;
		_tmp6_ = _tmp5_->item;
		if (_tmp6_->type == G_FILE_TYPE_DIRECTORY) {
			GQueue* _tmp7_;
			GList* _tmp8_;
			UsageStorageViewRow* _tmp9_;
			UsageStorageViewItem* _tmp10_;
			const gchar* _tmp11_;
			UsageStorageViewRow* _tmp12_;
			UsageStorageViewItem* _tmp13_;
			GUserDirectory* _tmp14_;
			GCancellable* _tmp15_;
			_tmp7_ = self->priv->selected_items_stack;
			_tmp8_ = self->priv->selected_items;
			self->priv->selected_items = NULL;
			g_queue_push_head (_tmp7_, _tmp8_);
			usage_storage_view_clear_selected_items (self);
			_tmp9_ = storage_row;
			_tmp10_ = _tmp9_->item;
			_tmp11_ = _tmp10_->uri;
			_tmp12_ = storage_row;
			_tmp13_ = _tmp12_->item;
			_tmp14_ = _tmp13_->dir;
			_tmp15_ = self->priv->cancellable;
			usage_storage_view_present_dir (self, _tmp11_, _tmp14_, _tmp15_, NULL, NULL);
		} else {
			UsageStorageViewRow* _tmp16_;
			UsageStorageViewItem* _tmp17_;
			_tmp16_ = storage_row;
			_tmp17_ = _tmp16_->item;
			if (_tmp17_->custom_type != USAGE_STORAGE_VIEW_TYPE_NONE) {
				UsageStorageRowPopover* _tmp18_;
				UsageStorageViewRow* _tmp19_;
				_tmp18_ = self->priv->row_popover;
				_tmp19_ = storage_row;
				usage_storage_row_popover_popup_on_row (_tmp18_, _tmp19_);
			} else {
				{
					UsageStorageViewRow* _tmp20_;
					UsageStorageViewItem* _tmp21_;
					const gchar* _tmp22_;
					_tmp20_ = storage_row;
					_tmp21_ = _tmp20_->item;
					_tmp22_ = _tmp21_->uri;
					g_app_info_launch_default_for_uri (_tmp22_, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* _error_ = NULL;
					GError* _tmp23_;
					const gchar* _tmp24_;
					_error_ = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp23_ = _error_;
					_tmp24_ = _tmp23_->message;
					g_warning ("storage-view.vala:130: %s", _tmp24_);
					_g_error_free0 (_error_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (storage_row);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
	_g_object_unref0 (storage_row);
}

static void
_usage_storage_view_on_row_activated_usage_stack_list_row_activated (UsageStackList* _sender,
                                                                     GtkListBoxRow* row,
                                                                     gpointer self)
{
	usage_storage_view_on_row_activated ((UsageStorageView*) self, row);
}

static void
usage_storage_view_stack_listbox_up (UsageStorageView* self)
{
	GQueue* _tmp0_;
	gpointer _tmp1_;
	UsageStackList* _tmp2_;
	UsageStorageViewItem* first_item = NULL;
	UsageStackList* _tmp3_;
	GListStore* _tmp4_;
	GListStore* _tmp5_;
	GObject* _tmp6_;
	UsageStorageViewItem* _tmp7_;
	UsageStorageViewItem* _tmp8_;
	gboolean _tmp9_ = FALSE;
	UsageStackList* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_items_stack;
	_tmp1_ = g_queue_pop_head (_tmp0_);
	(self->priv->selected_items == NULL) ? NULL : (self->priv->selected_items = (_g_list_free__g_object_unref0_ (self->priv->selected_items), NULL));
	self->priv->selected_items = (GList*) _tmp1_;
	usage_storage_view_refresh_actionbar (self);
	_tmp2_ = self->priv->listbox;
	usage_stack_list_layer_up (_tmp2_);
	_tmp3_ = self->priv->listbox;
	_tmp4_ = usage_stack_list_get_model (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, (guint) 0);
	_tmp7_ = USAGE_IS_STORAGE_VIEW_ITEM (_tmp6_) ? ((UsageStorageViewItem*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_tmp6_);
	}
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp5_);
	first_item = _tmp8_;
	_tmp10_ = self->priv->listbox;
	if (usage_stack_list_get_depth (_tmp10_) > 1) {
		UsageStorageViewItem* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		_tmp11_ = first_item;
		_tmp12_ = usage_storage_view_item_get_loaded (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp9_ = _tmp13_ == FALSE;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		usage_storage_view_refresh_current_dir (self);
	}
	_g_object_unref0 (first_item);
}

static gchar*
usage_storage_view_get_user_special_dir_path (UsageStorageView* self,
                                              GUserDirectory dir)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_special_dir (dir);
	_tmp1_ = g_strconcat ("file://", _tmp0_, NULL);
	result = _tmp1_;
	return result;
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
__lambda41_ (UsageStorageView* self,
             UsageStorageViewRow* row)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (row != NULL);
	_tmp0_ = usage_storage_view_row_get_selected (row);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		UsageStorageViewItem* _tmp2_;
		UsageStorageViewItem* _tmp3_;
		_tmp2_ = row->item;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		self->priv->selected_items = g_list_append (self->priv->selected_items, _tmp3_);
	} else {
		UsageStorageViewItem* _tmp4_;
		_tmp4_ = row->item;
		self->priv->selected_items = vala_g_list_remove_full (self->priv->selected_items, _tmp4_, _g_object_unref0_);
	}
	usage_storage_view_refresh_actionbar (self);
}

static void
___lambda41__usage_storage_view_row_check_button_toggled (UsageStorageViewRow* _sender,
                                                          gpointer self)
{
	__lambda41_ ((UsageStorageView*) self, _sender);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		UsageStorageView* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->hidden_row);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
___lambda42_ (Block7Data* _data7_)
{
	UsageStorageView* self;
	GtkListBoxRow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = _data7_->self;
	_tmp0_ = _data7_->hidden_row;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkListBoxRow* _tmp3_;
		_tmp3_ = _data7_->hidden_row;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	}
}

static void
____lambda42__g_object_notify (GObject* _sender,
                               GParamSpec* pspec,
                               gpointer self)
{
	___lambda42_ (self);
}

static GtkWidget*
usage_storage_view_create_file_row (UsageStorageView* self,
                                    GObject* obj)
{
	UsageStorageViewItem* item = NULL;
	UsageStorageViewItem* _tmp0_;
	UsageStorageViewRow* row = NULL;
	UsageStorageViewItem* _tmp1_;
	UsageStorageViewRow* _tmp2_;
	GList* _tmp3_;
	UsageStorageViewItem* _tmp4_;
	GList* _tmp5_;
	UsageStorageViewRow* _tmp8_;
	UsageStorageViewItem* _tmp9_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (obj != NULL, NULL);
	_tmp0_ = _g_object_ref0 (USAGE_IS_STORAGE_VIEW_ITEM (obj) ? ((UsageStorageViewItem*) obj) : NULL);
	item = _tmp0_;
	_tmp1_ = item;
	_tmp2_ = usage_storage_view_row_new_from_item (_tmp1_);
	g_object_ref_sink (_tmp2_);
	row = _tmp2_;
	_tmp3_ = self->priv->selected_items;
	_tmp4_ = item;
	_tmp5_ = g_list_find (_tmp3_, _tmp4_);
	if (_tmp5_ != NULL) {
		UsageStorageViewRow* _tmp6_;
		GtkCheckButton* _tmp7_;
		_tmp6_ = row;
		_tmp7_ = _tmp6_->check_button;
		gtk_check_button_set_active (_tmp7_, TRUE);
	}
	_tmp8_ = row;
	g_signal_connect_object (_tmp8_, "check-button-toggled", (GCallback) ___lambda41__usage_storage_view_row_check_button_toggled, self, 0);
	_tmp9_ = item;
	if (_tmp9_->custom_type == USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH) {
		Block7Data* _data7_;
		GtkListBoxRow* _tmp10_;
		GtkListBoxRow* _tmp11_;
		GtkListBoxRow* _tmp12_;
		GtkWidget* _tmp13_;
		_data7_ = g_slice_new0 (Block7Data);
		_data7_->_ref_count_ = 1;
		_data7_->self = g_object_ref (self);
		_tmp10_ = (GtkListBoxRow*) gtk_list_box_row_new ();
		g_object_ref_sink (_tmp10_);
		_data7_->hidden_row = _tmp10_;
		_tmp11_ = _data7_->hidden_row;
		g_signal_connect_data ((GObject*) _tmp11_, "notify::visible", (GCallback) ____lambda42__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
		_tmp12_ = _data7_->hidden_row;
		_tmp13_ = _g_object_ref0 ((GtkWidget*) _tmp12_);
		result = _tmp13_;
		block7_data_unref (_data7_);
		_data7_ = NULL;
		_g_object_unref0 (row);
		_g_object_unref0 (item);
		return result;
	}
	result = (GtkWidget*) row;
	_g_object_unref0 (item);
	return result;
}

static void
usage_storage_view_refresh_current_dir (UsageStorageView* self)
{
	UsageStorageViewItem* item = NULL;
	UsageStackList* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	GObject* _tmp3_;
	UsageStorageViewItem* _tmp4_;
	UsageStorageViewItem* _tmp5_;
	UsageStackList* _tmp6_;
	UsageStackList* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = usage_stack_list_get_model (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_model_get_item ((GListModel*) _tmp2_, (guint) 0);
	_tmp4_ = USAGE_IS_STORAGE_VIEW_ITEM (_tmp3_) ? ((UsageStorageViewItem*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (_tmp3_);
	}
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	item = _tmp5_;
	usage_storage_view_clear_selected_items (self);
	_tmp6_ = self->priv->listbox;
	usage_stack_list_layer_up (_tmp6_);
	_tmp7_ = self->priv->listbox;
	if (usage_stack_list_get_depth (_tmp7_) == 0) {
		usage_storage_view_populate_view (self, NULL, NULL);
	} else {
		UsageStorageViewItem* _tmp8_;
		const gchar* _tmp9_;
		UsageStorageViewItem* _tmp10_;
		GUserDirectory* _tmp11_;
		GCancellable* _tmp12_;
		_tmp8_ = item;
		_tmp9_ = _tmp8_->uri;
		_tmp10_ = item;
		_tmp11_ = _tmp10_->dir;
		_tmp12_ = self->priv->cancellable;
		usage_storage_view_present_dir (self, _tmp9_, _tmp11_, _tmp12_, NULL, NULL);
	}
	_g_object_unref0 (item);
}

static void
usage_storage_view_present_dir_data_free (gpointer _data)
{
	UsageStorageViewPresentDirData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->dir);
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageStorageViewPresentDirData, _data_);
}

static GUserDirectory*
_g_user_directory_dup (GUserDirectory* self)
{
	GUserDirectory* dup;
	dup = g_new0 (GUserDirectory, 1);
	memcpy (dup, self, sizeof (GUserDirectory));
	return dup;
}

static gpointer
__g_user_directory_dup0 (gpointer self)
{
	return self ? _g_user_directory_dup (self) : NULL;
}

static void
usage_storage_view_present_dir (UsageStorageView* self,
                                const gchar* uri,
                                GUserDirectory* dir,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	UsageStorageViewPresentDirData* _data_;
	UsageStorageView* _tmp0_;
	gchar* _tmp1_;
	GUserDirectory* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	g_return_if_fail (cancellable != NULL);
	_data_ = g_slice_new0 (UsageStorageViewPresentDirData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, usage_storage_view_present_dir_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	_tmp2_ = __g_user_directory_dup0 (dir);
	_g_free0 (_data_->dir);
	_data_->dir = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	usage_storage_view_present_dir_co (_data_);
}

static void
usage_storage_view_present_dir_finish (UsageStorageView* self,
                                       GAsyncResult* _res_)
{
	UsageStorageViewPresentDirData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return;
	}
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		UsageStorageView* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->model);
		_g_object_unref0 (_data8_->cancellable);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda40_ (Block8Data* _data8_,
             GObject* obj,
             GAsyncResult* res)
{
	UsageStorageView* self;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	if (!g_cancellable_is_cancelled (_data8_->cancellable)) {
		UsageStorageViewItem* up_folder_item = NULL;
		GListStore* _tmp0_;
		GObject* _tmp1_;
		UsageStorageViewItem* _tmp2_;
		UsageStorageViewItem* _tmp3_;
		UsageTrackerController* _tmp4_;
		UsageStorageViewItem* _tmp5_;
		_tmp0_ = _data8_->model;
		_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, (guint) 0);
		_tmp2_ = USAGE_IS_STORAGE_VIEW_ITEM (_tmp1_) ? ((UsageStorageViewItem*) _tmp1_) : NULL;
		if (_tmp2_ == NULL) {
			_g_object_unref0 (_tmp1_);
		}
		up_folder_item = _tmp2_;
		_tmp3_ = up_folder_item;
		_tmp4_ = self->priv->controller;
		_tmp3_->size = usage_tracker_controller_enumerate_children_finish (_tmp4_, res);
		_tmp5_ = up_folder_item;
		usage_storage_view_item_set_loaded (_tmp5_, TRUE);
		_g_object_unref0 (up_folder_item);
	}
	usage_storage_view_is_directory_loading (self, FALSE);
}

static void
___lambda40__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda40_ (self, source_object, res);
	block8_data_unref (self);
}

static gboolean
usage_storage_view_present_dir_co (UsageStorageViewPresentDirData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data8_->cancellable);
	_data_->_data8_->cancellable = _data_->cancellable;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->priv->connection;
	if (_data_->_tmp1_ == NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp0_ = g_cancellable_is_cancelled (_data_->_data8_->cancellable);
	}
	if (_data_->_tmp0_) {
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = g_list_store_new (USAGE_TYPE_STORAGE_VIEW_ITEM);
	_data_->_data8_->model = _data_->_tmp2_;
	_data_->_tmp3_ = g_file_new_for_uri (_data_->uri);
	_data_->file = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->file;
	_data_->_tmp5_ = usage_storage_view_item_from_file (_data_->_tmp4_);
	_data_->item = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->item;
	_data_->_tmp6_->custom_type = USAGE_STORAGE_VIEW_TYPE_UP_FOLDER;
	_data_->_tmp7_ = _data_->item;
	_data_->_tmp8_ = __g_user_directory_dup0 (_data_->dir);
	_g_free0 (_data_->_tmp7_->dir);
	_data_->_tmp7_->dir = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->_data8_->model;
	_data_->_tmp10_ = _data_->item;
	g_list_store_insert (_data_->_tmp9_, (guint) 0, (GObject*) _data_->_tmp10_);
	usage_storage_view_is_directory_loading (_data_->self, TRUE);
	_data_->_tmp11_ = _data_->self->priv->controller;
	_data_->_tmp12_ = _data_->_data8_->model;
	usage_tracker_controller_set_model (_data_->_tmp11_, _data_->_tmp12_);
	_data_->_tmp13_ = _data_->self->priv->controller;
	usage_tracker_controller_enumerate_children (_data_->_tmp13_, _data_->uri, _data_->dir, _data_->_data8_->cancellable, ___lambda40__gasync_ready_callback, block8_data_ref (_data_->_data8_));
	_data_->_tmp14_ = _data_->self->priv->listbox;
	_data_->_tmp15_ = _data_->_data8_->model;
	usage_stack_list_push_layer (_data_->_tmp14_, _data_->_tmp15_);
	_g_object_unref0 (_data_->item);
	_g_object_unref0 (_data_->file);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
usage_storage_view_setup_header_label (UsageStorageView* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->header_label;
	_tmp1_ = g_get_host_name ();
	gtk_label_set_label (_tmp0_, _tmp1_);
}

static void
_vala_glibtop_mountentry_array_free (glibtop_mountentry * array,
                                     gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_free (&array[i]);
		}
	}
	g_free (array);
}

static void
usage_storage_view_setup_mount_sizes (UsageStorageView* self)
{
	glibtop_mountlist mount_list = {0};
	glibtop_mountentry* entries = NULL;
	glibtop_mountlist _tmp0_ = {0};
	glibtop_mountentry* _tmp1_;
	gint entries_length1;
	gint _entries_size_;
	UsageStorageViewItem* _tmp19_;
	UsageStorageViewItem* _tmp20_;
	gdouble total_used_percentage = 0.0;
	gdouble total_free_percentage = 0.0;
	UsageStorageViewRow* _tmp21_;
	GtkLabel* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	UsageStorageViewRow* _tmp29_;
	GtkBox* _tmp30_;
	UsageStorageViewRow* _tmp31_;
	GtkLabel* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	UsageStorageViewRow* _tmp39_;
	GtkBox* _tmp40_;
	gulong total_free_size_most_significant = 0UL;
	gchar* total_free_size_formatted = NULL;
	gulong* _tmp41_ = NULL;
	gchar* _tmp42_;
	gulong* _tmp43_;
	gchar* _tmp44_;
	GtkLevelBar* _tmp45_;
	GtkLevelBar* _tmp46_;
	GtkLabel* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	g_return_if_fail (self != NULL);
	self->priv->total_used_size = (guint64) 0;
	self->priv->total_free_size = (guint64) 0;
	_tmp1_ = glibtop_get_mountlist (&_tmp0_, FALSE);
	mount_list = _tmp0_;
	entries = _tmp1_;
	entries_length1 = -1;
	_entries_size_ = entries_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				glibtop_mountlist _tmp4_;
				gchar* dir = NULL;
				glibtop_mountentry* _tmp5_;
				gint _tmp5__length1;
				glibtop_mountentry _tmp6_;
				gchar* _tmp7_;
				glibtop_fsusage mount = {0};
				const gchar* _tmp8_;
				glibtop_fsusage _tmp9_ = {0};
				guint64 total = 0ULL;
				glibtop_fsusage _tmp10_;
				glibtop_fsusage _tmp11_;
				guint64 free = 0ULL;
				glibtop_fsusage _tmp12_;
				glibtop_fsusage _tmp13_;
				guint64 used = 0ULL;
				const gchar* _tmp14_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = mount_list;
				if (!(((guint64) i) < _tmp4_.number)) {
					break;
				}
				_tmp5_ = entries;
				_tmp5__length1 = entries_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = g_strdup ((const gchar*) _tmp6_.mountdir);
				dir = _tmp7_;
				_tmp8_ = dir;
				glibtop_get_fsusage (&_tmp9_, _tmp8_);
				mount = _tmp9_;
				_tmp10_ = mount;
				_tmp11_ = mount;
				total = _tmp10_.blocks * _tmp11_.block_size;
				_tmp12_ = mount;
				_tmp13_ = mount;
				free = _tmp12_.bfree * _tmp13_.block_size;
				used = total - free;
				_tmp14_ = dir;
				if (g_strcmp0 (_tmp14_, "/") == 0) {
					UsageStorageViewItem* _tmp15_;
					gchar* _tmp16_;
					UsageStorageViewItem* _tmp17_;
					UsageStorageViewItem* _tmp18_;
					_tmp15_ = self->priv->os_item;
					_tmp16_ = g_strdup (_ ("Operating System"));
					_g_free0 (_tmp15_->name);
					_tmp15_->name = _tmp16_;
					_tmp17_ = self->priv->os_item;
					_tmp17_->size = used;
					_tmp18_ = self->priv->os_item;
					_tmp18_->custom_type = USAGE_STORAGE_VIEW_TYPE_OS;
				}
				self->priv->total_used_size = self->priv->total_used_size + used;
				self->priv->total_free_size = self->priv->total_free_size + free;
				_g_free0 (dir);
			}
		}
	}
	_tmp19_ = self->priv->os_item;
	_tmp20_ = self->priv->os_item;
	usage_storage_view_item_set_percentage (_tmp19_, (_tmp20_->size * 100) / ((gdouble) self->priv->total_used_size));
	self->priv->total_size = self->priv->total_used_size + self->priv->total_free_size;
	total_used_percentage = (((gdouble) self->priv->total_used_size) / self->priv->total_size) * 100;
	total_free_percentage = (((gdouble) self->priv->total_free_size) / self->priv->total_size) * 100;
	total_used_percentage = round (total_used_percentage);
	total_free_percentage = round (total_free_percentage);
	_tmp21_ = self->priv->used_row;
	_tmp22_ = _tmp21_->size_label;
	_tmp23_ = usage_utils_format_size_values (self->priv->total_used_size, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf (" (%d%)", (gint) total_used_percentage);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat (_tmp24_, _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	gtk_label_set_label (_tmp22_, _tmp28_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_tmp29_ = self->priv->used_row;
	_tmp30_ = _tmp29_->tag;
	gtk_widget_add_css_class ((GtkWidget*) _tmp30_, "used-tag");
	_tmp31_ = self->priv->available_row;
	_tmp32_ = _tmp31_->size_label;
	_tmp33_ = usage_utils_format_size_values (self->priv->total_free_size, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = g_strdup_printf (" (%d%)", (gint) total_free_percentage);
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strconcat (_tmp34_, _tmp36_, NULL);
	_tmp38_ = _tmp37_;
	gtk_label_set_label (_tmp32_, _tmp38_);
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp34_);
	_tmp39_ = self->priv->available_row;
	_tmp40_ = _tmp39_->tag;
	gtk_widget_add_css_class ((GtkWidget*) _tmp40_, "available-tag");
	_tmp42_ = usage_utils_format_size_values (self->priv->total_free_size, &_tmp41_);
	_tmp43_ = _tmp41_;
	total_free_size_most_significant = *_tmp43_;
	_tmp44_ = _tmp42_;
	_g_free0 (_tmp43_);
	total_free_size_formatted = _tmp44_;
	_tmp45_ = self->priv->switcher_level;
	gtk_level_bar_set_max_value (_tmp45_, (gdouble) self->priv->total_size);
	_tmp46_ = self->priv->switcher_level;
	gtk_level_bar_set_value (_tmp46_, (gdouble) self->priv->total_used_size);
	_tmp47_ = self->priv->switcher_label;
	_tmp48_ = g_strdup_printf (ngettext ("%s available", "%s available", total_free_size_most_significant), total_free_size_formatted);
	_tmp49_ = _tmp48_;
	gtk_label_set_label (_tmp47_, _tmp49_);
	_g_free0 (_tmp49_);
	_g_free0 (total_free_size_formatted);
	entries = (_vala_glibtop_mountentry_array_free (entries, entries_length1), NULL);
}

static void
usage_storage_view_populate_view_data_free (gpointer _data)
{
	UsageStorageViewPopulateViewData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageStorageViewPopulateViewData, _data_);
}

static void
usage_storage_view_populate_view (UsageStorageView* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	UsageStorageViewPopulateViewData* _data_;
	UsageStorageView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (UsageStorageViewPopulateViewData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, usage_storage_view_populate_view_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_storage_view_populate_view_co (_data_);
}

static void
usage_storage_view_populate_view_finish (UsageStorageView* self,
                                         GAsyncResult* _res_)
{
	UsageStorageViewPopulateViewData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		UsageStorageView* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->model);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		UsageStorageView* self;
		self = _data10_->_data9_->self;
		_g_object_unref0 (_data10_->item);
		block9_data_unref (_data10_->_data9_);
		_data10_->_data9_ = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}

static void
____lambda39_ (Block10Data* _data10_,
               GObject* obj,
               GAsyncResult* res)
{
	Block9Data* _data9_;
	UsageStorageView* self;
	GError* _inner_error0_ = NULL;
	_data9_ = _data10_->_data9_;
	self = _data9_->self;
	g_return_if_fail (res != NULL);
	{
		guint64 _tmp0_ = 0ULL;
		UsageTrackerController* _tmp1_;
		UsageStorageViewItem* _tmp2_;
		UsageStorageViewItem* _tmp3_;
		UsageStorageViewItem* _tmp4_;
		UsageStorageViewItem* _tmp5_;
		GListStore* _tmp6_;
		UsageStorageViewItem* _tmp7_;
		gint _tmp8_;
		GUserDirectory* _tmp9_;
		gint _tmp9__length1;
		_tmp1_ = self->priv->controller;
		_tmp0_ = usage_tracker_controller_get_file_size_finish (_tmp1_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _data10_->item;
		_tmp2_->size = _tmp0_;
		_tmp3_ = _data10_->item;
		_tmp4_ = _data10_->item;
		usage_storage_view_item_set_percentage (_tmp3_, (_tmp4_->size * 100) / ((gdouble) self->priv->total_size));
		_tmp5_ = _data10_->item;
		_tmp5_->custom_type = USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM;
		_tmp6_ = _data9_->model;
		_tmp7_ = _data10_->item;
		g_list_store_insert (_tmp6_, (guint) 1, (GObject*) _tmp7_);
		_tmp8_ = _data9_->items_loaded;
		_data9_->items_loaded = _tmp8_ + 1;
		_tmp9_ = self->priv->xdg_folders;
		_tmp9__length1 = self->priv->xdg_folders_length1;
		if (_data9_->items_loaded == _tmp9__length1) {
			usage_storage_view_is_directory_loading (self, FALSE);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_warning ("storage-view.vala:298: %s", _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_____lambda39__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	____lambda39_ (self, source_object, res);
	block10_data_unref (self);
}

static gboolean
usage_storage_view_populate_view_co (UsageStorageViewPopulateViewData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->connection;
	if (_data_->_tmp0_ == NULL) {
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = g_list_store_new (USAGE_TYPE_STORAGE_VIEW_ITEM);
	_data_->_data9_->model = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->_data9_->model;
	_data_->_tmp3_ = _data_->self->priv->os_item;
	g_list_store_append (_data_->_tmp2_, (GObject*) _data_->_tmp3_);
	usage_storage_view_is_directory_loading (_data_->self, TRUE);
	_data_->_data9_->items_loaded = 0;
	_data_->_tmp4_ = _data_->self->priv->xdg_folders;
	_data_->_tmp4__length1 = _data_->self->priv->xdg_folders_length1;
	{
		_data_->dir_collection_length1 = 0;
		_data_->_dir_collection_size_ = 0;
		_data_->dir_collection = _data_->_tmp4_;
		_data_->dir_collection_length1 = _data_->_tmp4__length1;
		for (_data_->dir_it = 0; _data_->dir_it < _data_->dir_collection_length1; _data_->dir_it = _data_->dir_it + 1) {
			_data_->dir = _data_->dir_collection[_data_->dir_it];
			{
				_data_->_data10_ = g_slice_new0 (Block10Data);
				_data_->_data10_->_ref_count_ = 1;
				_data_->_data10_->_data9_ = block9_data_ref (_data_->_data9_);
				_data_->_tmp5_ = usage_storage_view_get_user_special_dir_path (_data_->self, _data_->dir);
				_data_->_tmp6_ = _data_->_tmp5_;
				_data_->_tmp7_ = g_file_new_for_uri (_data_->_tmp6_);
				_data_->_tmp8_ = _data_->_tmp7_;
				_g_free0 (_data_->_tmp6_);
				_data_->file = _data_->_tmp8_;
				_data_->_tmp9_ = _data_->file;
				_data_->_tmp10_ = usage_storage_view_item_from_file (_data_->_tmp9_);
				_data_->_data10_->item = _data_->_tmp10_;
				_data_->_tmp11_ = _data_->_data10_->item;
				_data_->_tmp12_ = __g_user_directory_dup0 (&_data_->dir);
				_g_free0 (_data_->_tmp11_->dir);
				_data_->_tmp11_->dir = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->self->priv->controller;
				_data_->_tmp14_ = _data_->_data10_->item;
				_data_->_tmp15_ = _data_->_tmp14_->uri;
				usage_tracker_controller_get_file_size (_data_->_tmp13_, _data_->_tmp15_, _____lambda39__gasync_ready_callback, block10_data_ref (_data_->_data10_));
				_g_object_unref0 (_data_->file);
				block10_data_unref (_data_->_data10_);
				_data_->_data10_ = NULL;
			}
		}
	}
	_data_->_tmp16_ = _data_->self->priv->listbox;
	_data_->_tmp17_ = _data_->_data9_->model;
	usage_stack_list_push_layer (_data_->_tmp16_, _data_->_tmp17_);
	_data_->_tmp18_ = usage_storage_view_item_new ();
	_data_->available_graph_item = _data_->_tmp18_;
	_data_->_tmp19_ = _data_->available_graph_item;
	_data_->_tmp19_->size = _data_->self->priv->total_free_size;
	_data_->_tmp20_ = _data_->available_graph_item;
	_data_->_tmp20_->custom_type = USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH;
	_data_->_tmp21_ = _data_->available_graph_item;
	_data_->_tmp22_ = _data_->available_graph_item;
	usage_storage_view_item_set_percentage (_data_->_tmp21_, (_data_->_tmp22_->size * 100) / ((gdouble) _data_->self->priv->total_size));
	_data_->_tmp23_ = _data_->_data9_->model;
	_data_->_tmp24_ = _data_->available_graph_item;
	g_list_store_append (_data_->_tmp23_, (GObject*) _data_->_tmp24_);
	_g_object_unref0 (_data_->available_graph_item);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
usage_storage_view_refresh_actionbar (UsageStorageView* self)
{
	UsageStorageActionBar* _tmp0_;
	GList* _tmp1_;
	UsageStorageGraph* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->actionbar;
	_tmp1_ = self->priv->selected_items;
	usage_storage_action_bar_update_selected_items (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->graph;
	_tmp3_ = self->priv->selected_items;
	usage_storage_graph_update_selected_items (_tmp2_, _tmp3_);
	_tmp4_ = self->priv->selected_items;
	if (g_list_length (_tmp4_) == ((guint) 0)) {
		UsageStorageActionBar* _tmp5_;
		_tmp5_ = self->priv->actionbar;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	} else {
		UsageStorageActionBar* _tmp6_;
		_tmp6_ = self->priv->actionbar;
		gtk_widget_show ((GtkWidget*) _tmp6_);
	}
}

static void
usage_storage_view_clear_selected_items (UsageStorageView* self)
{
	g_return_if_fail (self != NULL);
	(self->priv->selected_items == NULL) ? NULL : (self->priv->selected_items = (_g_list_free__g_object_unref0_ (self->priv->selected_items), NULL));
	self->priv->selected_items = NULL;
	usage_storage_view_refresh_actionbar (self);
}

static gboolean
___lambda38_ (UsageStorageView* self,
              GtkWidget* widget,
              GdkFrameClock* frame_clock)
{
	GtkProgressBar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkProgressBar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	_tmp0_ = self->priv->directory_loading_bar;
	gtk_progress_bar_pulse (_tmp0_);
	_tmp2_ = self->priv->directory_loading_bar;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = G_SOURCE_CONTINUE;
	} else {
		_tmp1_ = G_SOURCE_REMOVE;
	}
	result = _tmp1_;
	return result;
}

static gboolean
____lambda38__gtk_tick_callback (GtkWidget* widget,
                                 GdkFrameClock* frame_clock,
                                 gpointer self)
{
	gboolean result;
	result = ___lambda38_ ((UsageStorageView*) self, widget, frame_clock);
	return result;
}

static void
usage_storage_view_is_directory_loading (UsageStorageView* self,
                                         gboolean loading)
{
	GtkProgressBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->directory_loading_bar;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, loading);
	if (loading) {
		GtkProgressBar* _tmp1_;
		_tmp1_ = self->priv->directory_loading_bar;
		gtk_progress_bar_set_fraction (_tmp1_, (gdouble) 0);
		gtk_widget_add_tick_callback ((GtkWidget*) self, ____lambda38__gtk_tick_callback, g_object_ref (self), g_object_unref);
	}
}

static GtkWidget*
_usage_storage_view_create_file_row_gtk_list_box_create_widget_func (GObject* item,
                                                                     gpointer self)
{
	GtkWidget* result;
	result = usage_storage_view_create_file_row ((UsageStorageView*) self, item);
	return result;
}

static void
_usage_storage_view___lambda43_ (UsageStorageView* self,
                                 GListStore* model)
{
	UsageStorageGraph* _tmp0_;
	g_return_if_fail (model != NULL);
	_tmp0_ = self->priv->graph;
	usage_storage_graph_set_model (_tmp0_, model);
}

static void
__usage_storage_view___lambda43__usage_stack_list_model_changed (UsageStackList* _sender,
                                                                 GListStore* model,
                                                                 gpointer self)
{
	_usage_storage_view___lambda43_ ((UsageStorageView*) self, model);
}

static void
_usage_storage_view_refresh_current_dir_usage_storage_action_bar_refresh_listbox (UsageStorageActionBar* _sender,
                                                                                  gpointer self)
{
	usage_storage_view_refresh_current_dir ((UsageStorageView*) self);
}

static GObject *
usage_storage_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageStorageView * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkBox* _tmp2_;
	GtkWidget* _tmp3_;
	GtkLevelBar* _tmp4_;
	GtkWidget* _tmp5_;
	GtkLabel* _tmp6_;
	UsageStorageQueryBuilder* _tmp12_;
	TrackerSparqlConnection* _tmp13_;
	UsageTrackerController* _tmp14_;
	UsageStackList* _tmp15_;
	UsageStackList* _tmp16_;
	UsageStorageActionBar* _tmp17_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (usage_storage_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_STORAGE_VIEW, UsageStorageView);
	gtk_widget_set_name ((GtkWidget*) self, "STORAGE");
	_tmp0_ = g_strdup (_ ("Storage"));
	_g_free0 (((UsageView*) self)->title);
	((UsageView*) self)->title = _tmp0_;
	_tmp1_ = g_strdup ("drive-harddisk-symbolic");
	_g_free0 (((UsageView*) self)->icon_name);
	((UsageView*) self)->icon_name = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (((UsageView*) self)->switcher_widget);
	((UsageView*) self)->switcher_widget = (GtkWidget*) _tmp2_;
	_tmp3_ = ((UsageView*) self)->switcher_widget;
	_tmp4_ = self->priv->switcher_level;
	gtk_box_append (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp4_);
	_tmp5_ = ((UsageView*) self)->switcher_widget;
	_tmp6_ = self->priv->switcher_label;
	gtk_box_append (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_box_get_type (), GtkBox), (GtkWidget*) _tmp6_);
	{
		TrackerSparqlConnection* _tmp7_ = NULL;
		TrackerSparqlConnection* _tmp8_;
		TrackerSparqlConnection* _tmp9_;
		_tmp8_ = tracker_sparql_connection_bus_new ("org.freedesktop.Tracker3.Miner.Files", NULL, NULL, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (self->priv->connection);
		self->priv->connection = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = _error_;
		_tmp11_ = _tmp10_->message;
		g_critical ("storage-view.vala:89: Failed to connect to Tracker Miner FS: %s", _tmp11_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp12_ = usage_storage_query_builder_new ();
	_usage_storage_query_builder_unref0 (self->priv->query_builder);
	self->priv->query_builder = _tmp12_;
	_tmp13_ = self->priv->connection;
	_tmp14_ = usage_tracker_controller_new (_tmp13_);
	_g_object_unref0 (self->priv->controller);
	self->priv->controller = _tmp14_;
	_tmp15_ = self->priv->listbox;
	usage_stack_list_init (_tmp15_, _usage_storage_view_create_file_row_gtk_list_box_create_widget_func, self);
	_tmp16_ = self->priv->listbox;
	g_signal_connect_object (_tmp16_, "model-changed", (GCallback) __usage_storage_view___lambda43__usage_stack_list_model_changed, self, 0);
	_tmp17_ = self->priv->actionbar;
	g_signal_connect_object (_tmp17_, "refresh-listbox", (GCallback) _usage_storage_view_refresh_current_dir_usage_storage_action_bar_refresh_listbox, self, 0);
	return obj;
}

static void
usage_storage_view_class_init (UsageStorageViewClass * klass,
                               gpointer klass_data)
{
	usage_storage_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageStorageView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = usage_storage_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_storage_view_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/storage-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "header_label", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, header_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "used_row", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, used_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "available_row", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, available_row));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, listbox));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "graph", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, graph));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "actionbar", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, actionbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "directory_loading_bar", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, directory_loading_bar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "row_popover", FALSE, UsageStorageView_private_offset + G_STRUCT_OFFSET (UsageStorageViewPrivate, row_popover));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_row_activated", G_CALLBACK(_usage_storage_view_on_row_activated_usage_stack_list_row_activated));
}

static void
usage_storage_view_instance_init (UsageStorageView * self,
                                  gpointer klass)
{
	UsageStorageViewItem* _tmp0_;
	GCancellable* _tmp1_;
	GtkLevelBar* _tmp2_;
	GtkLabel* _tmp3_;
	GUserDirectory* _tmp4_;
	GQueue* _tmp5_;
	self->priv = usage_storage_view_get_instance_private (self);
	_tmp0_ = usage_storage_view_item_new ();
	self->priv->os_item = _tmp0_;
	_tmp1_ = g_cancellable_new ();
	self->priv->cancellable = _tmp1_;
	self->priv->total_used_size = (guint64) 0;
	self->priv->total_free_size = (guint64) 0;
	self->priv->total_size = (guint64) 0;
	_tmp2_ = (GtkLevelBar*) gtk_level_bar_new ();
	g_object_ref_sink (_tmp2_);
	self->priv->switcher_level = _tmp2_;
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	self->priv->switcher_label = _tmp3_;
	_tmp4_ = g_new0 (GUserDirectory, 5);
	_tmp4_[0] = G_USER_DIRECTORY_DOCUMENTS;
	_tmp4_[1] = G_USER_DIRECTORY_DOWNLOAD;
	_tmp4_[2] = G_USER_DIRECTORY_MUSIC;
	_tmp4_[3] = G_USER_DIRECTORY_PICTURES;
	_tmp4_[4] = G_USER_DIRECTORY_VIDEOS;
	self->priv->xdg_folders = _tmp4_;
	self->priv->xdg_folders_length1 = 5;
	self->priv->_xdg_folders_size_ = self->priv->xdg_folders_length1;
	self->priv->selected_items = NULL;
	_tmp5_ = g_queue_new ();
	self->priv->selected_items_stack = _tmp5_;
	g_type_ensure (USAGE_TYPE_STORAGE_VIEW_ROW);
	g_type_ensure (USAGE_TYPE_STORAGE_VIEW_ROW);
	g_type_ensure (USAGE_TYPE_STACK_LIST);
	g_type_ensure (USAGE_TYPE_STORAGE_GRAPH);
	g_type_ensure (USAGE_TYPE_STORAGE_ACTION_BAR);
	g_type_ensure (USAGE_TYPE_STORAGE_ROW_POPOVER);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_storage_view_finalize (GObject * obj)
{
	UsageStorageView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_STORAGE_VIEW, UsageStorageView);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->controller);
	_usage_storage_query_builder_unref0 (self->priv->query_builder);
	_g_object_unref0 (self->priv->os_item);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->switcher_level);
	_g_object_unref0 (self->priv->switcher_label);
	self->priv->xdg_folders = (g_free (self->priv->xdg_folders), NULL);
	(self->priv->selected_items == NULL) ? NULL : (self->priv->selected_items = (_g_list_free__g_object_unref0_ (self->priv->selected_items), NULL));
	(self->priv->selected_items_stack == NULL) ? NULL : (self->priv->selected_items_stack = (_g_queue_free__g_list_free0_ (self->priv->selected_items_stack), NULL));
	G_OBJECT_CLASS (usage_storage_view_parent_class)->finalize (obj);
}

static GType
usage_storage_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageStorageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_storage_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageStorageView), 0, (GInstanceInitFunc) usage_storage_view_instance_init, NULL };
	GType usage_storage_view_type_id;
	usage_storage_view_type_id = g_type_register_static (USAGE_TYPE_VIEW, "UsageStorageView", &g_define_type_info, 0);
	UsageStorageView_private_offset = g_type_add_instance_private (usage_storage_view_type_id, sizeof (UsageStorageViewPrivate));
	return usage_storage_view_type_id;
}

GType
usage_storage_view_get_type (void)
{
	static volatile gsize usage_storage_view_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_view_type_id__once)) {
		GType usage_storage_view_type_id;
		usage_storage_view_type_id = usage_storage_view_get_type_once ();
		g_once_init_leave (&usage_storage_view_type_id__once, usage_storage_view_type_id);
	}
	return usage_storage_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

