/* storage-graph.c generated by valac 0.56.16, the Vala compiler
 * generated from storage-graph.vala, do not modify */

/* storage-graph.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_STORAGE_GRAPH (usage_storage_graph_get_type ())
#define USAGE_STORAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraph))
#define USAGE_STORAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraphClass))
#define USAGE_IS_STORAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_GRAPH))
#define USAGE_IS_STORAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_GRAPH))
#define USAGE_STORAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraphClass))

typedef struct _UsageStorageGraph UsageStorageGraph;
typedef struct _UsageStorageGraphClass UsageStorageGraphClass;
typedef struct _UsageStorageGraphPrivate UsageStorageGraphPrivate;

#define USAGE_TYPE_STORAGE_VIEW_ITEM (usage_storage_view_item_get_type ())
#define USAGE_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItem))
#define USAGE_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))
#define USAGE_IS_STORAGE_VIEW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_IS_STORAGE_VIEW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_STORAGE_VIEW_ITEM))
#define USAGE_STORAGE_VIEW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_STORAGE_VIEW_ITEM, UsageStorageViewItemClass))

typedef struct _UsageStorageViewItem UsageStorageViewItem;
typedef struct _UsageStorageViewItemClass UsageStorageViewItemClass;
enum  {
	USAGE_STORAGE_GRAPH_0_PROPERTY,
	USAGE_STORAGE_GRAPH_MODEL_PROPERTY,
	USAGE_STORAGE_GRAPH_MIN_PERCENTAGE_SHOWN_FILES_PROPERTY,
	USAGE_STORAGE_GRAPH_NUM_PROPERTIES
};
static GParamSpec* usage_storage_graph_properties[USAGE_STORAGE_GRAPH_NUM_PROPERTIES];
typedef enum  {
	USAGE_STORAGE_GRAPH_CIRCLE_HOME,
	USAGE_STORAGE_GRAPH_CIRCLE_ROOT,
	USAGE_STORAGE_GRAPH_CIRCLE_BASE
} UsageStorageGraphCircle;

#define USAGE_STORAGE_GRAPH_TYPE_CIRCLE (usage_storage_graph_circle_get_type ())
typedef struct _UsageStorageViewItemPrivate UsageStorageViewItemPrivate;
typedef enum  {
	USAGE_STORAGE_VIEW_TYPE_NONE,
	USAGE_STORAGE_VIEW_TYPE_OS,
	USAGE_STORAGE_VIEW_TYPE_UP_FOLDER,
	USAGE_STORAGE_VIEW_TYPE_AVAILABLE_GRAPH,
	USAGE_STORAGE_VIEW_TYPE_ROOT_ITEM
} UsageStorageViewType;

#define USAGE_TYPE_STORAGE_VIEW_TYPE (usage_storage_view_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _UsageStorageGraph {
	GtkDrawingArea parent_instance;
	UsageStorageGraphPrivate * priv;
};

struct _UsageStorageGraphClass {
	GtkDrawingAreaClass parent_class;
	GListStore* (*get_model) (UsageStorageGraph* self);
	void (*set_model) (UsageStorageGraph* self, GListStore* value);
};

struct _UsageStorageGraphPrivate {
	GList* selected_items;
	GListStore* _model;
	guint64 selected_size;
	gboolean _is_root;
	guint _min_percentage_shown_files;
};

struct _UsageStorageViewItem {
	GObject parent_instance;
	UsageStorageViewItemPrivate * priv;
	gchar* uri;
	gchar* name;
	guint64 size;
	GFileType type;
	GUserDirectory* dir;
	gchar* ontology;
	UsageStorageViewType custom_type;
};

struct _UsageStorageViewItemClass {
	GObjectClass parent_class;
};

static gint UsageStorageGraph_private_offset;
static gpointer usage_storage_graph_parent_class = NULL;

VALA_EXTERN GType usage_storage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageGraph, g_object_unref)
VALA_EXTERN GType usage_storage_view_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageStorageViewItem, g_object_unref)
VALA_EXTERN GListStore* usage_storage_graph_get_model (UsageStorageGraph* self);
VALA_EXTERN void usage_storage_graph_set_model (UsageStorageGraph* self,
                                    GListStore* value);
VALA_EXTERN GType usage_storage_graph_circle_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void usage_storage_graph_update_selected_items (UsageStorageGraph* self,
                                                GList* selected_items);
VALA_EXTERN GType usage_storage_view_type_get_type (void) G_GNUC_CONST ;
static void usage_storage_graph_draw_circle (UsageStorageGraph* self,
                                      cairo_t* context,
                                      gdouble x,
                                      gdouble y,
                                      gdouble radius,
                                      gint section,
                                      UsageStorageGraphCircle circle);
VALA_EXTERN gdouble usage_storage_view_item_get_percentage (UsageStorageViewItem* self);
VALA_EXTERN guint usage_storage_graph_get_min_percentage_shown_files (UsageStorageGraph* self);
VALA_EXTERN void usage_storage_view_item_get_base_color (UsageStorageViewItem* self,
                                             GdkRGBA* result);
static gboolean usage_storage_graph_get_is_root (UsageStorageGraph* self);
VALA_EXTERN void usage_utils_generate_color (GdkRGBA* default_color,
                                 guint order,
                                 guint all_count,
                                 gboolean reverse,
                                 GdkRGBA* result);
VALA_EXTERN void usage_storage_view_item_set_color (UsageStorageViewItem* self,
                                        GdkRGBA * value);
static void usage_storage_graph_draw_storage_graph (UsageStorageGraph* self,
                                             GtkDrawingArea* drawing_area,
                                             cairo_t* context,
                                             gint width,
                                             gint height);
static void usage_storage_graph_draw_selected_size_text (UsageStorageGraph* self,
                                                  cairo_t* context);
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
VALA_EXTERN UsageStorageGraph* usage_storage_graph_new (void);
VALA_EXTERN UsageStorageGraph* usage_storage_graph_construct (GType object_type);
static void usage_storage_graph_set_is_root (UsageStorageGraph* self,
                                      gboolean value);
static void _gtk_widget_queue_draw_g_list_model_items_changed (GListModel* _sender,
                                                        guint position,
                                                        guint removed,
                                                        guint added,
                                                        gpointer self);
VALA_EXTERN void usage_storage_graph_set_min_percentage_shown_files (UsageStorageGraph* self,
                                                         guint value);
static GObject * usage_storage_graph_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _usage_storage_graph_draw_storage_graph_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                         cairo_t* cr,
                                                                         gint width,
                                                                         gint height,
                                                                         gpointer self);
static void usage_storage_graph_finalize (GObject * obj);
static GType usage_storage_graph_get_type_once (void);
static void _vala_usage_storage_graph_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_usage_storage_graph_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_storage_graph_get_instance_private (UsageStorageGraph* self)
{
	return G_STRUCT_MEMBER_P (self, UsageStorageGraph_private_offset);
}

static GType
usage_storage_graph_circle_get_type_once (void)
{
	static const GEnumValue values[] = {{USAGE_STORAGE_GRAPH_CIRCLE_HOME, "USAGE_STORAGE_GRAPH_CIRCLE_HOME", "home"}, {USAGE_STORAGE_GRAPH_CIRCLE_ROOT, "USAGE_STORAGE_GRAPH_CIRCLE_ROOT", "root"}, {USAGE_STORAGE_GRAPH_CIRCLE_BASE, "USAGE_STORAGE_GRAPH_CIRCLE_BASE", "base"}, {0, NULL, NULL}};
	GType usage_storage_graph_circle_type_id;
	usage_storage_graph_circle_type_id = g_enum_register_static ("UsageStorageGraphCircle", values);
	return usage_storage_graph_circle_type_id;
}

GType
usage_storage_graph_circle_get_type (void)
{
	static volatile gsize usage_storage_graph_circle_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_graph_circle_type_id__once)) {
		GType usage_storage_graph_circle_type_id;
		usage_storage_graph_circle_type_id = usage_storage_graph_circle_get_type_once ();
		g_once_init_leave (&usage_storage_graph_circle_type_id__once, usage_storage_graph_circle_type_id);
	}
	return usage_storage_graph_circle_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
usage_storage_graph_update_selected_items (UsageStorageGraph* self,
                                           GList* selected_items)
{
	guint64 size = 0ULL;
	g_return_if_fail (self != NULL);
	self->priv->selected_items = selected_items;
	size = (guint64) 0;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = selected_items;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			UsageStorageViewItem* _tmp0_;
			UsageStorageViewItem* item = NULL;
			_tmp0_ = _g_object_ref0 ((UsageStorageViewItem*) item_it->data);
			item = _tmp0_;
			{
				UsageStorageViewItem* _tmp1_;
				_tmp1_ = item;
				size += _tmp1_->size;
				_g_object_unref0 (item);
			}
		}
	}
	self->priv->selected_size = size;
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
usage_storage_graph_draw_circle (UsageStorageGraph* self,
                                 cairo_t* context,
                                 gdouble x,
                                 gdouble y,
                                 gdouble radius,
                                 gint section,
                                 UsageStorageGraphCircle circle)
{
	gdouble start_angle = 0.0;
	gdouble final_angle = 0.0;
	gdouble ratio = 0.0;
	guint shown_items_number = 0U;
	GdkRGBA background_color = {0};
	GtkStyleContext* _tmp0_;
	GdkRGBA _tmp1_ = {0};
	GdkRGBA foreground_color = {0};
	GdkRGBA _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	start_angle = (gdouble) 0;
	final_angle = (-G_PI) / 2.0;
	ratio = (gdouble) 0;
	shown_items_number = (guint) 1;
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_lookup_color (_tmp0_, "window_bg_color", &_tmp1_);
	background_color = _tmp1_;
	gtk_widget_get_color ((GtkWidget*) self, &_tmp2_);
	foreground_color = _tmp2_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GListStore* _tmp5_;
				GListStore* _tmp6_;
				UsageStorageViewItem* item = NULL;
				GListStore* _tmp7_;
				GListStore* _tmp8_;
				GObject* _tmp9_;
				UsageStorageViewItem* _tmp10_;
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				UsageStorageViewItem* _tmp19_;
				gdouble _tmp20_;
				gdouble _tmp21_;
				guint _tmp22_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = usage_storage_graph_get_model (self);
				_tmp6_ = _tmp5_;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp6_))) {
					break;
				}
				_tmp7_ = usage_storage_graph_get_model (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, (guint) i);
				_tmp10_ = USAGE_IS_STORAGE_VIEW_ITEM (_tmp9_) ? ((UsageStorageViewItem*) _tmp9_) : NULL;
				if (_tmp10_ == NULL) {
					_g_object_unref0 (_tmp9_);
				}
				item = _tmp10_;
				if (i > 0) {
					_tmp12_ = i < 3;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					UsageStorageViewItem* _tmp13_;
					gdouble _tmp14_;
					gdouble _tmp15_;
					guint _tmp16_;
					_tmp13_ = item;
					_tmp14_ = usage_storage_view_item_get_percentage (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = self->priv->_min_percentage_shown_files;
					_tmp11_ = _tmp15_ < ((gdouble) _tmp16_);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GListStore* _tmp17_;
					GListStore* _tmp18_;
					_tmp17_ = usage_storage_graph_get_model (self);
					_tmp18_ = _tmp17_;
					shown_items_number = g_list_model_get_n_items ((GListModel*) _tmp18_);
					_g_object_unref0 (item);
					continue;
				}
				_tmp19_ = item;
				_tmp20_ = usage_storage_view_item_get_percentage (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = self->priv->_min_percentage_shown_files;
				if (_tmp21_ > ((gdouble) _tmp22_)) {
					shown_items_number = shown_items_number + 1;
				}
				_g_object_unref0 (item);
			}
		}
	}
	if (shown_items_number > ((guint) 1)) {
		GdkRGBA _tmp53_;
		GdkRGBA _tmp54_;
		if (shown_items_number < ((guint) 3)) {
			shown_items_number = (guint) 3;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp23_ = FALSE;
				_tmp23_ = TRUE;
				while (TRUE) {
					GListStore* _tmp25_;
					GListStore* _tmp26_;
					UsageStorageViewItem* item = NULL;
					GListStore* _tmp27_;
					GListStore* _tmp28_;
					GObject* _tmp29_;
					UsageStorageViewItem* _tmp30_;
					gdouble item_radius = 0.0;
					gboolean _tmp31_ = FALSE;
					UsageStorageViewItem* _tmp32_;
					GdkRGBA base_color = {0};
					UsageStorageViewItem* _tmp34_;
					GdkRGBA _tmp35_ = {0};
					GdkRGBA fill_color = {0};
					GdkRGBA _tmp36_;
					gboolean _tmp37_;
					GList* _tmp42_;
					UsageStorageViewItem* _tmp43_;
					GList* _tmp44_;
					UsageStorageViewItem* _tmp45_;
					gdouble _tmp46_;
					gdouble _tmp47_;
					GdkRGBA _tmp51_;
					GdkRGBA _tmp52_;
					if (!_tmp23_) {
						gint _tmp24_;
						_tmp24_ = i;
						i = _tmp24_ + 1;
					}
					_tmp23_ = FALSE;
					_tmp25_ = usage_storage_graph_get_model (self);
					_tmp26_ = _tmp25_;
					if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp26_))) {
						break;
					}
					_tmp27_ = usage_storage_graph_get_model (self);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_list_model_get_item ((GListModel*) _tmp28_, (guint) i);
					_tmp30_ = USAGE_IS_STORAGE_VIEW_ITEM (_tmp29_) ? ((UsageStorageViewItem*) _tmp29_) : NULL;
					if (_tmp30_ == NULL) {
						_g_object_unref0 (_tmp29_);
					}
					item = _tmp30_;
					item_radius = radius;
					_tmp32_ = item;
					if (_tmp32_->custom_type == USAGE_STORAGE_VIEW_TYPE_UP_FOLDER) {
						_tmp31_ = TRUE;
					} else {
						UsageStorageViewItem* _tmp33_;
						_tmp33_ = item;
						_tmp31_ = _tmp33_->size == ((guint64) 0);
					}
					if (_tmp31_) {
						_g_object_unref0 (item);
						continue;
					}
					_tmp34_ = item;
					usage_storage_view_item_get_base_color (_tmp34_, &_tmp35_);
					base_color = _tmp35_;
					_tmp36_ = base_color;
					fill_color = _tmp36_;
					_tmp37_ = self->priv->_is_root;
					if (!_tmp37_) {
						GdkRGBA _tmp38_;
						GdkRGBA _tmp39_ = {0};
						UsageStorageViewItem* _tmp40_;
						GdkRGBA _tmp41_;
						_tmp38_ = base_color;
						usage_utils_generate_color (&_tmp38_, (guint) i, shown_items_number, TRUE, &_tmp39_);
						fill_color = _tmp39_;
						_tmp40_ = item;
						_tmp41_ = fill_color;
						usage_storage_view_item_set_color (_tmp40_, &_tmp41_);
					}
					_tmp42_ = self->priv->selected_items;
					_tmp43_ = item;
					_tmp44_ = g_list_find (_tmp42_, _tmp43_);
					if (_tmp44_ != NULL) {
						item_radius += radius / 6;
					}
					cairo_set_line_width (context, 2.0);
					start_angle = final_angle;
					_tmp45_ = item;
					_tmp46_ = usage_storage_view_item_get_percentage (_tmp45_);
					_tmp47_ = _tmp46_;
					if (_tmp47_ < 0.3) {
						ratio = ratio + (((gdouble) 0.3) / 100);
					} else {
						UsageStorageViewItem* _tmp48_;
						gdouble _tmp49_;
						gdouble _tmp50_;
						_tmp48_ = item;
						_tmp49_ = usage_storage_view_item_get_percentage (_tmp48_);
						_tmp50_ = _tmp49_;
						ratio = ratio + (((gdouble) _tmp50_) / 100);
					}
					final_angle = ((ratio * 2) * G_PI) - (G_PI / 2.0);
					if (final_angle >= ((2 * G_PI) - (G_PI / 2.0))) {
						final_angle = (2 * G_PI) - (G_PI / 2.0);
					}
					cairo_move_to (context, x, y);
					_tmp51_ = fill_color;
					gdk_cairo_set_source_rgba (context, &_tmp51_);
					cairo_arc (context, x, y, item_radius, start_angle, final_angle);
					cairo_line_to (context, x, y);
					cairo_fill_preserve (context);
					_tmp52_ = foreground_color;
					gdk_cairo_set_source_rgba (context, &_tmp52_);
					cairo_stroke (context);
					if (start_angle >= ((2 * G_PI) - (G_PI / 2.0))) {
						_g_object_unref0 (item);
						break;
					}
					_g_object_unref0 (item);
				}
			}
		}
		cairo_move_to (context, x, y);
		cairo_line_to (context, x, y - radius);
		cairo_stroke (context);
		cairo_arc (context, x, y, radius / 1.8, (gdouble) 0, 2 * G_PI);
		_tmp53_ = background_color;
		gdk_cairo_set_source_rgba (context, &_tmp53_);
		cairo_fill_preserve (context);
		_tmp54_ = foreground_color;
		gdk_cairo_set_source_rgba (context, &_tmp54_);
		cairo_stroke (context);
	}
}

static void
usage_storage_graph_draw_storage_graph (UsageStorageGraph* self,
                                        GtkDrawingArea* drawing_area,
                                        cairo_t* context,
                                        gint width,
                                        gint height)
{
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble radius = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (context != NULL);
	x = (gdouble) 0;
	y = (gdouble) 0;
	radius = (gdouble) 0;
	radius = MIN (width, height) / 2.0;
	radius -= radius / 4;
	x = width / 2.0;
	y = height / 2.0;
	usage_storage_graph_draw_circle (self, context, x, y, radius, 0, USAGE_STORAGE_GRAPH_CIRCLE_BASE);
	usage_storage_graph_draw_selected_size_text (self, context);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static void
usage_storage_graph_draw_selected_size_text (UsageStorageGraph* self,
                                             cairo_t* context)
{
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	gchar* text = NULL;
	gchar* _tmp1_;
	gint height = 0;
	gint width = 0;
	gdouble radius = 0.0;
	GdkRGBA text_color = {0};
	GtkRoot* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	gchar* text_color_string = NULL;
	GdkRGBA _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* markup = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	PangoLayout* _tmp27_;
	const gchar* _tmp28_;
	PangoRectangle layout_rect = {0};
	PangoLayout* _tmp29_;
	PangoRectangle _tmp30_ = {0};
	PangoLayout* _tmp31_;
	gint x = 0;
	PangoRectangle _tmp32_;
	gint y = 0;
	PangoRectangle _tmp33_;
	GtkStyleContext* _tmp34_;
	PangoLayout* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	if (self->priv->selected_size == ((guint64) 0)) {
		return;
	}
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
	layout = _tmp0_;
	_tmp1_ = usage_utils_format_size_values (self->priv->selected_size, NULL);
	text = _tmp1_;
	height = gtk_widget_get_height ((GtkWidget*) self);
	width = gtk_widget_get_width ((GtkWidget*) self);
	radius = (gdouble) (MIN (width, height) / 22);
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) self);
	gtk_widget_get_color ((GtkWidget*) _tmp2_, &_tmp3_);
	text_color = _tmp3_;
	_tmp4_ = text_color;
	_tmp5_ = text_color;
	_tmp6_ = text_color;
	_tmp7_ = g_strdup_printf ("#%02x%02x%02x", (guint) round ((gdouble) (_tmp4_.red * 255)), (guint) round ((gdouble) (_tmp5_.green * 255)), (guint) round ((gdouble) (_tmp6_.blue * 255)));
	_tmp8_ = _tmp7_;
	_tmp9_ = g_utf8_strup (_tmp8_, (gssize) -1);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	text_color_string = _tmp10_;
	_tmp11_ = text_color_string;
	_tmp12_ = g_strconcat ("<span foreground='", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "' font='", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = double_to_string (radius);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp15_, _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "'><b>", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = text;
	_tmp23_ = g_strconcat (_tmp21_, _tmp22_, NULL);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat (_tmp24_, "</b></span>", NULL);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	markup = _tmp26_;
	_tmp27_ = layout;
	_tmp28_ = markup;
	pango_layout_set_markup (_tmp27_, _tmp28_, -1);
	_tmp29_ = layout;
	pango_layout_get_pixel_extents (_tmp29_, NULL, &_tmp30_);
	layout_rect = _tmp30_;
	_tmp31_ = layout;
	pango_layout_set_alignment (_tmp31_, PANGO_ALIGN_CENTER);
	_tmp32_ = layout_rect;
	x = (width - _tmp32_.width) / 2;
	_tmp33_ = layout_rect;
	y = (height - _tmp33_.height) / 2;
	_tmp34_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp35_ = layout;
	gtk_render_layout (_tmp34_, context, (gdouble) x, (gdouble) y, _tmp35_);
	_g_free0 (markup);
	_g_free0 (text_color_string);
	_g_free0 (text);
	_g_object_unref0 (layout);
}

UsageStorageGraph*
usage_storage_graph_construct (GType object_type)
{
	UsageStorageGraph * self = NULL;
	self = (UsageStorageGraph*) g_object_new (object_type, NULL);
	return self;
}

UsageStorageGraph*
usage_storage_graph_new (void)
{
	return usage_storage_graph_construct (USAGE_TYPE_STORAGE_GRAPH);
}

static gboolean
usage_storage_graph_get_is_root (UsageStorageGraph* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_root;
	return result;
}

static void
usage_storage_graph_set_is_root (UsageStorageGraph* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_root = value;
}

GListStore*
usage_storage_graph_get_model (UsageStorageGraph* self)
{
	UsageStorageGraphClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = USAGE_STORAGE_GRAPH_GET_CLASS (self);
	if (_klass_->get_model) {
		return _klass_->get_model (self);
	}
	return NULL;
}

static GListStore*
usage_storage_graph_real_get_model (UsageStorageGraph* base)
{
	GListStore* result;
	UsageStorageGraph* self;
	GListStore* _tmp0_;
	self = base;
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

void
usage_storage_graph_set_model (UsageStorageGraph* self,
                               GListStore* value)
{
	UsageStorageGraphClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = USAGE_STORAGE_GRAPH_GET_CLASS (self);
	if (_klass_->set_model) {
		_klass_->set_model (self, value);
	}
}

static void
_gtk_widget_queue_draw_g_list_model_items_changed (GListModel* _sender,
                                                   guint position,
                                                   guint removed,
                                                   guint added,
                                                   gpointer self)
{
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
usage_storage_graph_real_set_model (UsageStorageGraph* base,
                                    GListStore* value)
{
	UsageStorageGraph* self;
	self = base;
	self->priv->_model = value;
	g_signal_connect_object ((GListModel*) value, "items-changed", (GCallback) _gtk_widget_queue_draw_g_list_model_items_changed, (GtkWidget*) self, 0);
	gtk_widget_queue_draw ((GtkWidget*) self);
	usage_storage_graph_set_is_root (self, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				UsageStorageViewItem* item = NULL;
				GListStore* _tmp2_;
				GListStore* _tmp3_;
				GObject* _tmp4_;
				UsageStorageViewItem* _tmp5_;
				UsageStorageViewItem* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) value))) {
					break;
				}
				_tmp2_ = usage_storage_graph_get_model (self);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_list_model_get_item ((GListModel*) _tmp3_, (guint) i);
				_tmp5_ = USAGE_IS_STORAGE_VIEW_ITEM (_tmp4_) ? ((UsageStorageViewItem*) _tmp4_) : NULL;
				if (_tmp5_ == NULL) {
					_g_object_unref0 (_tmp4_);
				}
				item = _tmp5_;
				_tmp6_ = item;
				if (_tmp6_->custom_type == USAGE_STORAGE_VIEW_TYPE_OS) {
					usage_storage_graph_set_is_root (self, TRUE);
					_g_object_unref0 (item);
					break;
				}
				_g_object_unref0 (item);
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, usage_storage_graph_properties[USAGE_STORAGE_GRAPH_MODEL_PROPERTY]);
}

guint
usage_storage_graph_get_min_percentage_shown_files (UsageStorageGraph* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_min_percentage_shown_files;
	return result;
}

void
usage_storage_graph_set_min_percentage_shown_files (UsageStorageGraph* self,
                                                    guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_storage_graph_get_min_percentage_shown_files (self);
	if (old_value != value) {
		self->priv->_min_percentage_shown_files = value;
		g_object_notify_by_pspec ((GObject *) self, usage_storage_graph_properties[USAGE_STORAGE_GRAPH_MIN_PERCENTAGE_SHOWN_FILES_PROPERTY]);
	}
}

static void
_usage_storage_graph_draw_storage_graph_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                    cairo_t* cr,
                                                                    gint width,
                                                                    gint height,
                                                                    gpointer self)
{
	usage_storage_graph_draw_storage_graph ((UsageStorageGraph*) self, drawing_area, cr, width, height);
}

static GObject *
usage_storage_graph_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageStorageGraph * self;
	parent_class = G_OBJECT_CLASS (usage_storage_graph_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraph);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _usage_storage_graph_draw_storage_graph_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
usage_storage_graph_base_init (UsageStorageGraphClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "StorageGraph");
}

static void
usage_storage_graph_class_init (UsageStorageGraphClass * klass,
                                gpointer klass_data)
{
	usage_storage_graph_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageStorageGraph_private_offset);
	USAGE_STORAGE_GRAPH_CLASS (klass)->get_model = (GListStore* (*) (UsageStorageGraph*)) usage_storage_graph_real_get_model;
	USAGE_STORAGE_GRAPH_CLASS (klass)->set_model = (void (*) (UsageStorageGraph*, GListStore*)) usage_storage_graph_real_set_model;
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_storage_graph_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_storage_graph_set_property;
	G_OBJECT_CLASS (klass)->constructor = usage_storage_graph_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_storage_graph_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_GRAPH_MODEL_PROPERTY, usage_storage_graph_properties[USAGE_STORAGE_GRAPH_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_STORAGE_GRAPH_MIN_PERCENTAGE_SHOWN_FILES_PROPERTY, usage_storage_graph_properties[USAGE_STORAGE_GRAPH_MIN_PERCENTAGE_SHOWN_FILES_PROPERTY] = g_param_spec_uint ("min-percentage-shown-files", "min-percentage-shown-files", "min-percentage-shown-files", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
usage_storage_graph_instance_init (UsageStorageGraph * self,
                                   gpointer klass)
{
	self->priv = usage_storage_graph_get_instance_private (self);
	self->priv->selected_size = (guint64) 0;
}

static void
usage_storage_graph_finalize (GObject * obj)
{
	UsageStorageGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraph);
	G_OBJECT_CLASS (usage_storage_graph_parent_class)->finalize (obj);
}

static GType
usage_storage_graph_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageStorageGraphClass), (GBaseInitFunc) usage_storage_graph_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_storage_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageStorageGraph), 0, (GInstanceInitFunc) usage_storage_graph_instance_init, NULL };
	GType usage_storage_graph_type_id;
	usage_storage_graph_type_id = g_type_register_static (gtk_drawing_area_get_type (), "UsageStorageGraph", &g_define_type_info, 0);
	UsageStorageGraph_private_offset = g_type_add_instance_private (usage_storage_graph_type_id, sizeof (UsageStorageGraphPrivate));
	return usage_storage_graph_type_id;
}

GType
usage_storage_graph_get_type (void)
{
	static volatile gsize usage_storage_graph_type_id__once = 0;
	if (g_once_init_enter (&usage_storage_graph_type_id__once)) {
		GType usage_storage_graph_type_id;
		usage_storage_graph_type_id = usage_storage_graph_get_type_once ();
		g_once_init_leave (&usage_storage_graph_type_id__once, usage_storage_graph_type_id);
	}
	return usage_storage_graph_type_id__once;
}

static void
_vala_usage_storage_graph_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	UsageStorageGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraph);
	switch (property_id) {
		case USAGE_STORAGE_GRAPH_MODEL_PROPERTY:
		g_value_set_object (value, usage_storage_graph_get_model (self));
		break;
		case USAGE_STORAGE_GRAPH_MIN_PERCENTAGE_SHOWN_FILES_PROPERTY:
		g_value_set_uint (value, usage_storage_graph_get_min_percentage_shown_files (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_storage_graph_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	UsageStorageGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_STORAGE_GRAPH, UsageStorageGraph);
	switch (property_id) {
		case USAGE_STORAGE_GRAPH_MODEL_PROPERTY:
		usage_storage_graph_set_model (self, g_value_get_object (value));
		break;
		case USAGE_STORAGE_GRAPH_MIN_PERCENTAGE_SHOWN_FILES_PROPERTY:
		usage_storage_graph_set_min_percentage_shown_files (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

