/* speedometer.c generated by valac 0.56.16, the Vala compiler
 * generated from speedometer.vala, do not modify */

/* speedometer.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Felipe Borges <felipeborges@gnome.org>
 */

#include <adwaita.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_SPEEDOMETER (usage_speedometer_get_type ())
#define USAGE_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SPEEDOMETER, UsageSpeedometer))
#define USAGE_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SPEEDOMETER, UsageSpeedometerClass))
#define USAGE_IS_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SPEEDOMETER))
#define USAGE_IS_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SPEEDOMETER))
#define USAGE_SPEEDOMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SPEEDOMETER, UsageSpeedometerClass))

typedef struct _UsageSpeedometer UsageSpeedometer;
typedef struct _UsageSpeedometerClass UsageSpeedometerClass;
typedef struct _UsageSpeedometerPrivate UsageSpeedometerPrivate;
enum  {
	USAGE_SPEEDOMETER_0_PROPERTY,
	USAGE_SPEEDOMETER_PERCENTAGE_PROPERTY,
	USAGE_SPEEDOMETER_NUM_PROPERTIES
};
static GParamSpec* usage_speedometer_properties[USAGE_SPEEDOMETER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _UsageSpeedometer {
	AdwBin parent_instance;
	UsageSpeedometerPrivate * priv;
};

struct _UsageSpeedometerClass {
	AdwBinClass parent_class;
};

struct _UsageSpeedometerPrivate {
	GtkBox* inner;
	GtkBox* content_area;
	GtkCssProvider* css_provider;
	gint _percentage;
};

static gint UsageSpeedometer_private_offset;
static gpointer usage_speedometer_parent_class = NULL;
static GtkBuildableIface * usage_speedometer_gtk_buildable_parent_iface = NULL;

VALA_EXTERN GType usage_speedometer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSpeedometer, g_object_unref)
static void usage_speedometer_on_percentage_changed (UsageSpeedometer* self,
                                              gint new_value);
static void usage_speedometer_real_add_child (GtkBuildable* base,
                                       GtkBuilder* builder,
                                       GObject* child,
                                       const gchar* type);
VALA_EXTERN UsageSpeedometer* usage_speedometer_new (void);
VALA_EXTERN UsageSpeedometer* usage_speedometer_construct (GType object_type);
VALA_EXTERN gint usage_speedometer_get_percentage (UsageSpeedometer* self);
VALA_EXTERN void usage_speedometer_set_percentage (UsageSpeedometer* self,
                                       gint value);
static GObject * usage_speedometer_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void usage_speedometer_finalize (GObject * obj);
static GType usage_speedometer_get_type_once (void);
static void _vala_usage_speedometer_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_usage_speedometer_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_speedometer_get_instance_private (UsageSpeedometer* self)
{
	return G_STRUCT_MEMBER_P (self, UsageSpeedometer_private_offset);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
usage_speedometer_on_percentage_changed (UsageSpeedometer* self,
                                         gint new_value)
{
	gboolean _tmp0_ = FALSE;
	gdouble new_angle = 0.0;
	gchar* filling_color = NULL;
	gchar* _tmp1_;
	gchar* css = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkCssProvider* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	if (new_value <= 0) {
		_tmp0_ = new_value >= 100;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	new_angle = 90 + (360 * (new_value / 100.0));
	_tmp1_ = g_strdup ("@view_bg_color");
	filling_color = _tmp1_;
	if (new_value > 50) {
		gchar* _tmp2_;
		new_angle -= (gdouble) 180;
		_tmp2_ = g_strdup ("@accent_bg_color");
		_g_free0 (filling_color);
		filling_color = _tmp2_;
	}
	_tmp3_ = double_to_string (new_angle);
	_tmp4_ = _tmp3_;
	_tmp5_ = filling_color;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat (".speedometer-inner {\n            background: linear-gradient(", _tmp4_, "deg, transparent 50%, ", _tmp6_, " 50%),\n" \
"                        linear-gradient(90deg, @view_bg_color 50%, tra" \
"nsparent 50%);\n" \
"        }", NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp4_);
	css = _tmp8_;
	_tmp9_ = self->priv->css_provider;
	_tmp10_ = css;
	gtk_css_provider_load_from_string (_tmp9_, _tmp10_);
	_g_free0 (css);
	_g_free0 (filling_color);
}

static void
usage_speedometer_real_add_child (GtkBuildable* base,
                                  GtkBuilder* builder,
                                  GObject* child,
                                  const gchar* type)
{
	UsageSpeedometer * self;
	self = (UsageSpeedometer*) base;
	g_return_if_fail (builder != NULL);
	g_return_if_fail (child != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_label_get_type ())) {
		GtkBox* _tmp0_;
		_tmp0_ = self->priv->content_area;
		gtk_box_append (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()) ? ((GtkWidget*) child) : NULL);
		return;
	}
	usage_speedometer_gtk_buildable_parent_iface->add_child ((GtkBuildable*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin), builder, child, type);
}

UsageSpeedometer*
usage_speedometer_construct (GType object_type)
{
	UsageSpeedometer * self = NULL;
	self = (UsageSpeedometer*) g_object_new (object_type, NULL);
	return self;
}

UsageSpeedometer*
usage_speedometer_new (void)
{
	return usage_speedometer_construct (USAGE_TYPE_SPEEDOMETER);
}

gint
usage_speedometer_get_percentage (UsageSpeedometer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_percentage;
	return result;
}

void
usage_speedometer_set_percentage (UsageSpeedometer* self,
                                  gint value)
{
	g_return_if_fail (self != NULL);
	usage_speedometer_on_percentage_changed (self, value);
	self->priv->_percentage = value;
	g_object_notify_by_pspec ((GObject *) self, usage_speedometer_properties[USAGE_SPEEDOMETER_PERCENTAGE_PROPERTY]);
}

static GObject *
usage_speedometer_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageSpeedometer * self;
	GtkCssProvider* _tmp0_;
	GtkBox* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkCssProvider* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	parent_class = G_OBJECT_CLASS (usage_speedometer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_SPEEDOMETER, UsageSpeedometer);
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->css_provider);
	self->priv->css_provider = _tmp0_;
	_tmp1_ = self->priv->inner;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	_tmp3_ = self->priv->css_provider;
	gtk_style_context_add_provider (_tmp2_, (GtkStyleProvider*) _tmp3_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp4_ = self->priv->content_area;
	g_object_bind_property_with_closures ((GObject*) self, "width-request", (GObject*) _tmp4_, "width-request", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = self->priv->content_area;
	g_object_bind_property_with_closures ((GObject*) self, "height-request", (GObject*) _tmp5_, "height-request", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return obj;
}

static void
usage_speedometer_base_init (UsageSpeedometerClass * klass)
{
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "Speedometer");
}

static void
usage_speedometer_class_init (UsageSpeedometerClass * klass,
                              gpointer klass_data)
{
	usage_speedometer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageSpeedometer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_speedometer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_speedometer_set_property;
	G_OBJECT_CLASS (klass)->constructor = usage_speedometer_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_speedometer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SPEEDOMETER_PERCENTAGE_PROPERTY, usage_speedometer_properties[USAGE_SPEEDOMETER_PERCENTAGE_PROPERTY] = g_param_spec_int ("percentage", "percentage", "percentage", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/speedometer.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "inner", FALSE, UsageSpeedometer_private_offset + G_STRUCT_OFFSET (UsageSpeedometerPrivate, inner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_area", FALSE, UsageSpeedometer_private_offset + G_STRUCT_OFFSET (UsageSpeedometerPrivate, content_area));
}

static void
usage_speedometer_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                gpointer iface_data)
{
	usage_speedometer_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_child = (void (*) (GtkBuildable*, GtkBuilder*, GObject*, const gchar*)) usage_speedometer_real_add_child;
}

static void
usage_speedometer_instance_init (UsageSpeedometer * self,
                                 gpointer klass)
{
	self->priv = usage_speedometer_get_instance_private (self);
	self->priv->_percentage = 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_speedometer_finalize (GObject * obj)
{
	UsageSpeedometer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_SPEEDOMETER, UsageSpeedometer);
	_g_object_unref0 (self->priv->css_provider);
	G_OBJECT_CLASS (usage_speedometer_parent_class)->finalize (obj);
}

static GType
usage_speedometer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageSpeedometerClass), (GBaseInitFunc) usage_speedometer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_speedometer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageSpeedometer), 0, (GInstanceInitFunc) usage_speedometer_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) usage_speedometer_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType usage_speedometer_type_id;
	usage_speedometer_type_id = g_type_register_static (adw_bin_get_type (), "UsageSpeedometer", &g_define_type_info, 0);
	g_type_add_interface_static (usage_speedometer_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	UsageSpeedometer_private_offset = g_type_add_instance_private (usage_speedometer_type_id, sizeof (UsageSpeedometerPrivate));
	return usage_speedometer_type_id;
}

GType
usage_speedometer_get_type (void)
{
	static volatile gsize usage_speedometer_type_id__once = 0;
	if (g_once_init_enter (&usage_speedometer_type_id__once)) {
		GType usage_speedometer_type_id;
		usage_speedometer_type_id = usage_speedometer_get_type_once ();
		g_once_init_leave (&usage_speedometer_type_id__once, usage_speedometer_type_id);
	}
	return usage_speedometer_type_id__once;
}

static void
_vala_usage_speedometer_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	UsageSpeedometer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_SPEEDOMETER, UsageSpeedometer);
	switch (property_id) {
		case USAGE_SPEEDOMETER_PERCENTAGE_PROPERTY:
		g_value_set_int (value, usage_speedometer_get_percentage (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_speedometer_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	UsageSpeedometer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_SPEEDOMETER, UsageSpeedometer);
	switch (property_id) {
		case USAGE_SPEEDOMETER_PERCENTAGE_PROPERTY:
		usage_speedometer_set_percentage (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

