/* settings.c generated by valac 0.56.16, the Vala compiler
 * generated from settings.vala, do not modify */

/* settings.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <gio/gio.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <math.h>
#include <float.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_SETTINGS (usage_settings_get_type ())
#define USAGE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SETTINGS, UsageSettings))
#define USAGE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SETTINGS, UsageSettingsClass))
#define USAGE_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SETTINGS))
#define USAGE_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SETTINGS))
#define USAGE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SETTINGS, UsageSettingsClass))

typedef struct _UsageSettings UsageSettings;
typedef struct _UsageSettingsClass UsageSettingsClass;
typedef struct _UsageSettingsPrivate UsageSettingsPrivate;
enum  {
	USAGE_SETTINGS_0_PROPERTY,
	USAGE_SETTINGS_GRAPH_TIMESPAN_PROPERTY,
	USAGE_SETTINGS_GRAPH_UPDATE_INTERVAL_PROPERTY,
	USAGE_SETTINGS_LIST_UPDATE_INTERVAL_UI_PROPERTY,
	USAGE_SETTINGS_LIST_UPDATE_PIE_CHARTS_UI_PROPERTY,
	USAGE_SETTINGS_DATA_UPDATE_INTERVAL_PROPERTY,
	USAGE_SETTINGS_APP_MINIMUM_LOAD_PROPERTY,
	USAGE_SETTINGS_APP_MINIMUM_MEMORY_PROPERTY,
	USAGE_SETTINGS_ENABLE_SCROLLING_GRAPH_PROPERTY,
	USAGE_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* usage_settings_properties[USAGE_SETTINGS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _UsageSettings {
	GSettings parent_instance;
	UsageSettingsPrivate * priv;
};

struct _UsageSettingsClass {
	GSettingsClass parent_class;
};

struct _UsageSettingsPrivate {
	GtkSettings* gtk_settings;
	GPowerProfileMonitor* power_profile_monitor;
};

static gint UsageSettings_private_offset;
static gpointer usage_settings_parent_class = NULL;
static UsageSettings* usage_settings_settings;
static UsageSettings* usage_settings_settings = NULL;

VALA_EXTERN GType usage_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSettings, g_object_unref)
VALA_EXTERN UsageSettings* usage_settings_get_default (void);
VALA_EXTERN UsageSettings* usage_settings_new (void);
VALA_EXTERN UsageSettings* usage_settings_construct (GType object_type);
VALA_EXTERN guint usage_settings_get_graph_timespan (UsageSettings* self);
VALA_EXTERN guint usage_settings_get_graph_update_interval (UsageSettings* self);
VALA_EXTERN guint usage_settings_get_list_update_interval_UI (UsageSettings* self);
VALA_EXTERN guint usage_settings_get_list_update_pie_charts_UI (UsageSettings* self);
VALA_EXTERN guint usage_settings_get_data_update_interval (UsageSettings* self);
VALA_EXTERN gdouble usage_settings_get_app_minimum_load (UsageSettings* self);
VALA_EXTERN gdouble usage_settings_get_app_minimum_memory (UsageSettings* self);
VALA_EXTERN gboolean usage_settings_get_enable_scrolling_graph (UsageSettings* self);
static void usage_settings_finalize (GObject * obj);
static GType usage_settings_get_type_once (void);
static void _vala_usage_settings_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_settings_get_instance_private (UsageSettings* self)
{
	return G_STRUCT_MEMBER_P (self, UsageSettings_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

UsageSettings*
usage_settings_get_default (void)
{
	UsageSettings* _tmp0_;
	UsageSettings* _tmp2_;
	UsageSettings* _tmp3_;
	UsageSettings* result;
	_tmp0_ = usage_settings_settings;
	if (_tmp0_ == NULL) {
		UsageSettings* _tmp1_;
		_tmp1_ = usage_settings_new ();
		_g_object_unref0 (usage_settings_settings);
		usage_settings_settings = _tmp1_;
	}
	_tmp2_ = usage_settings_settings;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

UsageSettings*
usage_settings_construct (GType object_type)
{
	UsageSettings * self = NULL;
	self = (UsageSettings*) g_object_new (object_type, "schema-id", APPLICATION_ID, NULL);
	return self;
}

UsageSettings*
usage_settings_new (void)
{
	return usage_settings_construct (USAGE_TYPE_SETTINGS);
}

guint
usage_settings_get_graph_timespan (UsageSettings* self)
{
	guint result;
	UsageSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = usage_settings_settings;
	result = g_settings_get_uint ((GSettings*) _tmp0_, "performance-graphs-timespan");
	return result;
}

guint
usage_settings_get_graph_update_interval (UsageSettings* self)
{
	guint result;
	UsageSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = usage_settings_settings;
	result = g_settings_get_uint ((GSettings*) _tmp0_, "performance-update-interval");
	return result;
}

guint
usage_settings_get_list_update_interval_UI (UsageSettings* self)
{
	guint result;
	guint performance_interval = 0U;
	UsageSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = usage_settings_settings;
	performance_interval = g_settings_get_uint ((GSettings*) _tmp0_, "performance-update-interval");
	if (performance_interval >= ((guint) 5000)) {
		result = performance_interval;
		return result;
	}
	result = ((gint) ceil (5000.0 / performance_interval)) * performance_interval;
	return result;
}

guint
usage_settings_get_list_update_pie_charts_UI (UsageSettings* self)
{
	guint result;
	UsageSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = usage_settings_settings;
	result = g_settings_get_uint ((GSettings*) _tmp0_, "performance-update-interval");
	return result;
}

guint
usage_settings_get_data_update_interval (UsageSettings* self)
{
	guint result;
	UsageSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = usage_settings_settings;
	result = g_settings_get_uint ((GSettings*) _tmp0_, "performance-update-interval");
	return result;
}

gdouble
usage_settings_get_app_minimum_load (UsageSettings* self)
{
	gdouble result;
	UsageSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = usage_settings_settings;
	result = g_settings_get_double ((GSettings*) _tmp0_, "app-minimum-load");
	return result;
}

gdouble
usage_settings_get_app_minimum_memory (UsageSettings* self)
{
	gdouble result;
	UsageSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = usage_settings_settings;
	result = g_settings_get_double ((GSettings*) _tmp0_, "app-minimum-memory");
	return result;
}

gboolean
usage_settings_get_enable_scrolling_graph (UsageSettings* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkSettings* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->gtk_settings;
	g_object_get (_tmp2_, "gtk-enable-animations", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GPowerProfileMonitor* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->power_profile_monitor;
		_tmp6_ = g_power_profile_monitor_get_power_saver_enabled (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = !_tmp7_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		UsageSettings* _tmp8_;
		_tmp8_ = usage_settings_settings;
		_tmp0_ = !g_settings_get_boolean ((GSettings*) _tmp8_, "disable-scrolling-graphs");
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
usage_settings_class_init (UsageSettingsClass * klass,
                           gpointer klass_data)
{
	usage_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_settings_get_property;
	G_OBJECT_CLASS (klass)->finalize = usage_settings_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_GRAPH_TIMESPAN_PROPERTY, usage_settings_properties[USAGE_SETTINGS_GRAPH_TIMESPAN_PROPERTY] = g_param_spec_uint ("graph-timespan", "graph-timespan", "graph-timespan", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_GRAPH_UPDATE_INTERVAL_PROPERTY, usage_settings_properties[USAGE_SETTINGS_GRAPH_UPDATE_INTERVAL_PROPERTY] = g_param_spec_uint ("graph-update-interval", "graph-update-interval", "graph-update-interval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_LIST_UPDATE_INTERVAL_UI_PROPERTY, usage_settings_properties[USAGE_SETTINGS_LIST_UPDATE_INTERVAL_UI_PROPERTY] = g_param_spec_uint ("list-update-interval-UI", "list-update-interval-UI", "list-update-interval-UI", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_LIST_UPDATE_PIE_CHARTS_UI_PROPERTY, usage_settings_properties[USAGE_SETTINGS_LIST_UPDATE_PIE_CHARTS_UI_PROPERTY] = g_param_spec_uint ("list-update-pie-charts-UI", "list-update-pie-charts-UI", "list-update-pie-charts-UI", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_DATA_UPDATE_INTERVAL_PROPERTY, usage_settings_properties[USAGE_SETTINGS_DATA_UPDATE_INTERVAL_PROPERTY] = g_param_spec_uint ("data-update-interval", "data-update-interval", "data-update-interval", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_APP_MINIMUM_LOAD_PROPERTY, usage_settings_properties[USAGE_SETTINGS_APP_MINIMUM_LOAD_PROPERTY] = g_param_spec_double ("app-minimum-load", "app-minimum-load", "app-minimum-load", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_APP_MINIMUM_MEMORY_PROPERTY, usage_settings_properties[USAGE_SETTINGS_APP_MINIMUM_MEMORY_PROPERTY] = g_param_spec_double ("app-minimum-memory", "app-minimum-memory", "app-minimum-memory", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_SETTINGS_ENABLE_SCROLLING_GRAPH_PROPERTY, usage_settings_properties[USAGE_SETTINGS_ENABLE_SCROLLING_GRAPH_PROPERTY] = g_param_spec_boolean ("enable-scrolling-graph", "enable-scrolling-graph", "enable-scrolling-graph", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
usage_settings_instance_init (UsageSettings * self,
                              gpointer klass)
{
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GPowerProfileMonitor* _tmp2_;
	self->priv = usage_settings_get_instance_private (self);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	self->priv->gtk_settings = _tmp1_;
	_tmp2_ = g_power_profile_monitor_dup_default ();
	self->priv->power_profile_monitor = _tmp2_;
}

static void
usage_settings_finalize (GObject * obj)
{
	UsageSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_SETTINGS, UsageSettings);
	_g_object_unref0 (self->priv->gtk_settings);
	_g_object_unref0 (self->priv->power_profile_monitor);
	G_OBJECT_CLASS (usage_settings_parent_class)->finalize (obj);
}

static GType
usage_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageSettings), 0, (GInstanceInitFunc) usage_settings_instance_init, NULL };
	GType usage_settings_type_id;
	usage_settings_type_id = g_type_register_static (g_settings_get_type (), "UsageSettings", &g_define_type_info, 0);
	UsageSettings_private_offset = g_type_add_instance_private (usage_settings_type_id, sizeof (UsageSettingsPrivate));
	return usage_settings_type_id;
}

GType
usage_settings_get_type (void)
{
	static volatile gsize usage_settings_type_id__once = 0;
	if (g_once_init_enter (&usage_settings_type_id__once)) {
		GType usage_settings_type_id;
		usage_settings_type_id = usage_settings_get_type_once ();
		g_once_init_leave (&usage_settings_type_id__once, usage_settings_type_id);
	}
	return usage_settings_type_id__once;
}

static void
_vala_usage_settings_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	UsageSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_SETTINGS, UsageSettings);
	switch (property_id) {
		case USAGE_SETTINGS_GRAPH_TIMESPAN_PROPERTY:
		g_value_set_uint (value, usage_settings_get_graph_timespan (self));
		break;
		case USAGE_SETTINGS_GRAPH_UPDATE_INTERVAL_PROPERTY:
		g_value_set_uint (value, usage_settings_get_graph_update_interval (self));
		break;
		case USAGE_SETTINGS_LIST_UPDATE_INTERVAL_UI_PROPERTY:
		g_value_set_uint (value, usage_settings_get_list_update_interval_UI (self));
		break;
		case USAGE_SETTINGS_LIST_UPDATE_PIE_CHARTS_UI_PROPERTY:
		g_value_set_uint (value, usage_settings_get_list_update_pie_charts_UI (self));
		break;
		case USAGE_SETTINGS_DATA_UPDATE_INTERVAL_PROPERTY:
		g_value_set_uint (value, usage_settings_get_data_update_interval (self));
		break;
		case USAGE_SETTINGS_APP_MINIMUM_LOAD_PROPERTY:
		g_value_set_double (value, usage_settings_get_app_minimum_load (self));
		break;
		case USAGE_SETTINGS_APP_MINIMUM_MEMORY_PROPERTY:
		g_value_set_double (value, usage_settings_get_app_minimum_memory (self));
		break;
		case USAGE_SETTINGS_ENABLE_SCROLLING_GRAPH_PROPERTY:
		g_value_set_boolean (value, usage_settings_get_enable_scrolling_graph (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

