/* process.c generated by valac 0.56.16, the Vala compiler
 * generated from process.vala, do not modify */

/* process.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 */

#define _GNU_SOURCE

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glibtop/procstate.h>
#include <glibtop.h>
#include <glibtop/procuid.h>
#include <glibtop/procargs.h>
#include <fcntl.h>
#include <sys/types.h>
#include <unistd.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_PROCESS (usage_process_get_type ())
#define USAGE_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS, UsageProcess))
#define USAGE_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS, UsageProcessClass))
#define USAGE_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS))
#define USAGE_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS))
#define USAGE_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS, UsageProcessClass))

typedef struct _UsageProcess UsageProcess;
typedef struct _UsageProcessClass UsageProcessClass;
typedef struct _UsageProcessPrivate UsageProcessPrivate;
typedef enum  {
	USAGE_PROCESS_STATUS_RUNNING,
	USAGE_PROCESS_STATUS_SLEEPING,
	USAGE_PROCESS_STATUS_DEAD
} UsageProcessStatus;

#define USAGE_TYPE_PROCESS_STATUS (usage_process_status_get_type ())
enum  {
	USAGE_PROCESS_0_PROPERTY,
	USAGE_PROCESS_PID_PROPERTY,
	USAGE_PROCESS_CMDLINE_PROPERTY,
	USAGE_PROCESS_UID_PROPERTY,
	USAGE_PROCESS_START_TIME_PROPERTY,
	USAGE_PROCESS_CPU_LOAD_PROPERTY,
	USAGE_PROCESS_X_CPU_LOAD_PROPERTY,
	USAGE_PROCESS_CPU_LAST_USED_PROPERTY,
	USAGE_PROCESS_X_CPU_LAST_USED_PROPERTY,
	USAGE_PROCESS_LAST_PROCESSOR_PROPERTY,
	USAGE_PROCESS_MEM_USAGE_PROPERTY,
	USAGE_PROCESS_GAMEMODE_PROPERTY,
	USAGE_PROCESS_MARK_AS_UPDATED_PROPERTY,
	USAGE_PROCESS_STATUS_PROPERTY,
	USAGE_PROCESS_APP_ID_PROPERTY,
	USAGE_PROCESS_NUM_PROPERTIES
};
static GParamSpec* usage_process_properties[USAGE_PROCESS_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UsageProcess {
	GObject parent_instance;
	UsageProcessPrivate * priv;
};

struct _UsageProcessClass {
	GObjectClass parent_class;
};

struct _UsageProcessPrivate {
	GPid _pid;
	gchar* _cmdline;
	guint _uid;
	guint64 _start_time;
	gdouble _cpu_load;
	gdouble _x_cpu_load;
	guint64 _cpu_last_used;
	guint64 _x_cpu_last_used;
	guint _last_processor;
	guint64 _mem_usage;
	gboolean _gamemode;
	gboolean _mark_as_updated;
	UsageProcessStatus _status;
	gchar* _app_id;
	gboolean _app_id_checked;
};

static gint UsageProcess_private_offset;
static gpointer usage_process_parent_class = NULL;

VALA_EXTERN GType usage_process_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcess, g_object_unref)
VALA_EXTERN GType usage_process_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageProcess* usage_process_new (GPid pid);
VALA_EXTERN UsageProcess* usage_process_construct (GType object_type,
                                       GPid pid);
static void usage_process_set_pid (UsageProcess* self,
                            GPid value);
VALA_EXTERN gchar* usage_process_get_full_process_cmd (GPid pid);
static void usage_process_set_cmdline (UsageProcess* self,
                                const gchar* value);
static guint _usage_process_get_uid (UsageProcess* self);
static void usage_process_set_uid (UsageProcess* self,
                            guint value);
VALA_EXTERN void usage_process_update_status (UsageProcess* self);
VALA_EXTERN GPid usage_process_get_pid (UsageProcess* self);
static void usage_process_set_status (UsageProcess* self,
                               UsageProcessStatus value);
VALA_EXTERN gdouble usage_process_get_cpu_load (UsageProcess* self);
VALA_EXTERN void usage_process_set_mark_as_updated (UsageProcess* self,
                                        gboolean value);
VALA_EXTERN gchar* usage_process_first_component (const gchar* str);
VALA_EXTERN gchar* usage_process_sanitize_name (const gchar* name);
VALA_EXTERN gchar* usage_process_read_cgroup (GPid pid);
VALA_EXTERN gchar* usage_process_read_app_id (GPid pid);
VALA_EXTERN GKeyFile* usage_process_read_flatpak_info (GPid pid);
VALA_EXTERN const gchar* usage_process_get_cmdline (UsageProcess* self);
VALA_EXTERN guint usage_process_get_uid (UsageProcess* self);
VALA_EXTERN guint64 usage_process_get_start_time (UsageProcess* self);
VALA_EXTERN void usage_process_set_start_time (UsageProcess* self,
                                   guint64 value);
VALA_EXTERN void usage_process_set_cpu_load (UsageProcess* self,
                                 gdouble value);
VALA_EXTERN gdouble usage_process_get_x_cpu_load (UsageProcess* self);
VALA_EXTERN void usage_process_set_x_cpu_load (UsageProcess* self,
                                   gdouble value);
VALA_EXTERN guint64 usage_process_get_cpu_last_used (UsageProcess* self);
VALA_EXTERN void usage_process_set_cpu_last_used (UsageProcess* self,
                                      guint64 value);
VALA_EXTERN guint64 usage_process_get_x_cpu_last_used (UsageProcess* self);
VALA_EXTERN void usage_process_set_x_cpu_last_used (UsageProcess* self,
                                        guint64 value);
VALA_EXTERN guint usage_process_get_last_processor (UsageProcess* self);
VALA_EXTERN void usage_process_set_last_processor (UsageProcess* self,
                                       guint value);
VALA_EXTERN guint64 usage_process_get_mem_usage (UsageProcess* self);
VALA_EXTERN void usage_process_set_mem_usage (UsageProcess* self,
                                  guint64 value);
VALA_EXTERN gboolean usage_process_get_gamemode (UsageProcess* self);
VALA_EXTERN void usage_process_set_gamemode (UsageProcess* self,
                                 gboolean value);
VALA_EXTERN gboolean usage_process_get_mark_as_updated (UsageProcess* self);
VALA_EXTERN UsageProcessStatus usage_process_get_status (UsageProcess* self);
VALA_EXTERN const gchar* usage_process_get_app_id (UsageProcess* self);
static void usage_process_finalize (GObject * obj);
static GType usage_process_get_type_once (void);
static void _vala_usage_process_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_usage_process_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_process_get_instance_private (UsageProcess* self)
{
	return G_STRUCT_MEMBER_P (self, UsageProcess_private_offset);
}

UsageProcess*
usage_process_construct (GType object_type,
                         GPid pid)
{
	UsageProcess * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (UsageProcess*) g_object_new (object_type, NULL);
	usage_process_set_pid (self, pid);
	_tmp0_ = usage_process_get_full_process_cmd (pid);
	_tmp1_ = _tmp0_;
	usage_process_set_cmdline (self, _tmp1_);
	_g_free0 (_tmp1_);
	usage_process_set_uid (self, _usage_process_get_uid (self));
	return self;
}

UsageProcess*
usage_process_new (GPid pid)
{
	return usage_process_construct (USAGE_TYPE_PROCESS, pid);
}

void
usage_process_update_status (UsageProcess* self)
{
	glibtop_proc_state proc_state = {0};
	GPid _tmp0_;
	glibtop_proc_state _tmp1_ = {0};
	glibtop_proc_state _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_pid;
	glibtop_get_proc_state (&_tmp1_, _tmp0_);
	proc_state = _tmp1_;
	_tmp2_ = proc_state;
	switch (_tmp2_.state) {
		case GLIBTOP_PROCESS_RUNNING:
		case GLIBTOP_PROCESS_UNINTERRUPTIBLE:
		{
			usage_process_set_status (self, USAGE_PROCESS_STATUS_RUNNING);
			break;
		}
		case GLIBTOP_PROCESS_SWAPPING:
		case GLIBTOP_PROCESS_INTERRUPTIBLE:
		case GLIBTOP_PROCESS_STOPPED:
		{
			usage_process_set_status (self, USAGE_PROCESS_STATUS_SLEEPING);
			break;
		}
		default:
		case GLIBTOP_PROCESS_DEAD:
		case GLIBTOP_PROCESS_ZOMBIE:
		{
			usage_process_set_status (self, USAGE_PROCESS_STATUS_DEAD);
			break;
		}
	}
	_tmp3_ = self->priv->_cpu_load;
	if (_tmp3_ > ((gdouble) 0)) {
		usage_process_set_status (self, USAGE_PROCESS_STATUS_RUNNING);
	}
	usage_process_set_mark_as_updated (self, TRUE);
}

static guint
_usage_process_get_uid (UsageProcess* self)
{
	glibtop_proc_uid procUid = {0};
	GPid _tmp0_;
	glibtop_proc_uid _tmp1_ = {0};
	glibtop_proc_uid _tmp2_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_pid;
	glibtop_get_proc_uid (&_tmp1_, _tmp0_);
	procUid = _tmp1_;
	_tmp2_ = procUid;
	result = (guint) _tmp2_.uid;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
usage_process_get_full_process_cmd (GPid pid)
{
	glibtop_proc_args proc_args = {0};
	glibtop_proc_state proc_state = {0};
	gchar** args = NULL;
	glibtop_proc_args _tmp0_ = {0};
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint args_length1;
	gint _args_size_;
	glibtop_proc_state _tmp3_ = {0};
	gchar* cmd = NULL;
	glibtop_proc_state _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* result;
	_tmp2_ = _tmp1_ = glibtop_get_proc_argv (&_tmp0_, pid, (guint) 0);
	proc_args = _tmp0_;
	args = _tmp2_;
	args_length1 = _vala_array_length (_tmp1_);
	_args_size_ = args_length1;
	glibtop_get_proc_state (&_tmp3_, pid);
	proc_state = _tmp3_;
	_tmp4_ = proc_state;
	_tmp5_ = g_strdup ((const gchar*) _tmp4_.cmd);
	cmd = _tmp5_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				gchar* name = NULL;
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = args;
				_tmp8__length1 = args_length1;
				if (!(((guint) i) < MIN ((guint) _tmp8__length1, (guint) 2))) {
					break;
				}
				_tmp9_ = args;
				_tmp9__length1 = args_length1;
				_tmp10_ = _tmp9_[i];
				if (_tmp10_ == NULL) {
					continue;
				}
				_tmp11_ = args;
				_tmp11__length1 = args_length1;
				_tmp12_ = _tmp11_[i];
				_tmp13_ = g_path_get_basename (_tmp12_);
				name = _tmp13_;
				_tmp14_ = name;
				_tmp15_ = cmd;
				if (!string_contains (_tmp14_, _tmp15_)) {
					_g_free0 (name);
					continue;
				}
				_tmp16_ = name;
				_tmp17_ = usage_process_first_component (_tmp16_);
				_g_free0 (name);
				name = _tmp17_;
				_tmp18_ = name;
				_tmp19_ = usage_process_sanitize_name (_tmp18_);
				result = _tmp19_;
				_g_free0 (name);
				_g_free0 (cmd);
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
		}
	}
	_tmp20_ = cmd;
	_tmp21_ = usage_process_sanitize_name (_tmp20_);
	result = _tmp21_;
	_g_free0 (cmd);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
usage_process_read_cgroup (GPid pid)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gint flags = 0;
	gint fd = 0;
	const gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_strdup_printf ("/proc/%u/cgroup", (guint) pid);
	path = _tmp0_;
	flags = (O_RDONLY | O_CLOEXEC) | O_NOCTTY;
	_tmp1_ = path;
	fd = openat (AT_FDCWD, _tmp1_, flags, (mode_t) 0);
	if (fd == -1) {
		result = NULL;
		_g_free0 (path);
		return result;
	}
	{
		gchar* data = NULL;
		gchar** lines = NULL;
		gint lines_length1 = 0;
		gint _lines_size_ = 0;
		gchar* cgroup = NULL;
		gsize len = 0UL;
		GIOChannel* ch = NULL;
		GIOChannel* _tmp2_;
		GIOChannel* _tmp3_;
		GIOStatus status = 0;
		GIOChannel* _tmp4_;
		gchar* _tmp5_ = NULL;
		gsize _tmp6_ = 0UL;
		GIOStatus _tmp7_;
		const gchar* _tmp8_;
		gchar** _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		const gchar* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		data = NULL;
		cgroup = NULL;
		_tmp2_ = g_io_channel_unix_new (fd);
		ch = _tmp2_;
		_tmp3_ = ch;
		g_io_channel_set_close_on_unref (_tmp3_, TRUE);
		_tmp4_ = ch;
		_tmp7_ = g_io_channel_read_to_end (_tmp4_, &_tmp5_, &_tmp6_, &_inner_error0_);
		_g_free0 (data);
		data = _tmp5_;
		len = _tmp6_;
		status = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_io_channel_unref0 (ch);
			_g_free0 (cgroup);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data);
			goto __catch0_g_error;
		}
		if (status != G_IO_STATUS_NORMAL) {
			result = NULL;
			_g_io_channel_unref0 (ch);
			_g_free0 (cgroup);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data);
			_g_free0 (path);
			return result;
		}
		_tmp8_ = data;
		_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		lines = _tmp10_;
		lines_length1 = _vala_array_length (_tmp9_);
		_lines_size_ = lines_length1;
		_tmp11_ = lines;
		_tmp11__length1 = lines_length1;
		_tmp12_ = _tmp11_[0];
		if (!g_str_has_prefix (_tmp12_, "0::")) {
			result = NULL;
			_g_io_channel_unref0 (ch);
			_g_free0 (cgroup);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data);
			_g_free0 (path);
			return result;
		}
		_tmp13_ = lines;
		_tmp13__length1 = lines_length1;
		_tmp14_ = _tmp13_[0];
		_tmp15_ = lines;
		_tmp15__length1 = lines_length1;
		_tmp16_ = _tmp15_[0];
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_slice (_tmp14_, (glong) 3, (glong) _tmp18_);
		_g_free0 (cgroup);
		cgroup = _tmp19_;
		result = cgroup;
		_g_io_channel_unref0 (ch);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (data);
		_g_free0 (path);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (path);
		return result;
	}
	__finally0:
	_g_free0 (path);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
usage_process_read_app_id (GPid pid)
{
	GKeyFile* kf = NULL;
	GKeyFile* _tmp0_;
	GKeyFile* _tmp1_;
	gchar* name = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = usage_process_read_flatpak_info (pid);
	kf = _tmp0_;
	_tmp1_ = kf;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_key_file_unref0 (kf);
		return result;
	}
	name = NULL;
	{
		gboolean _tmp2_ = FALSE;
		GKeyFile* _tmp3_;
		_tmp3_ = kf;
		_tmp2_ = g_key_file_has_key (_tmp3_, "Application", "name", &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp2_) {
			gchar* _tmp4_ = NULL;
			GKeyFile* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = kf;
			_tmp6_ = g_key_file_get_string (_tmp5_, "Application", "name", &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = _tmp4_;
			_tmp4_ = NULL;
			_g_free0 (name);
			name = _tmp7_;
			_g_free0 (_tmp4_);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		g_clear_error (&_inner_error0_);
		_tmp8_ = g_strdup_printf ("%i", (gint) pid);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("Failed to parse faltpak info for: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		g_warning ("process.vala:168: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (name);
		_g_key_file_unref0 (kf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = name;
	_g_key_file_unref0 (kf);
	return result;
}

GKeyFile*
usage_process_read_flatpak_info (GPid pid)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gint flags = 0;
	gint root = 0;
	const gchar* _tmp1_;
	gint fd = 0;
	GKeyFile* kf = NULL;
	GKeyFile* _tmp2_;
	GError* _inner_error0_ = NULL;
	GKeyFile* result;
	_tmp0_ = g_strdup_printf ("/proc/%u/root", (guint) pid);
	path = _tmp0_;
	flags = (O_RDONLY | O_CLOEXEC) | O_NOCTTY;
	_tmp1_ = path;
	root = openat (AT_FDCWD, _tmp1_, (flags | O_NONBLOCK) | O_DIRECTORY, (mode_t) 0);
	if (root == -1) {
		result = NULL;
		_g_free0 (path);
		return result;
	}
	fd = openat (root, ".flatpak-info", flags, (mode_t) 0);
	close (root);
	if (fd == -1) {
		result = NULL;
		_g_free0 (path);
		return result;
	}
	_tmp2_ = g_key_file_new ();
	kf = _tmp2_;
	{
		gchar* data = NULL;
		gsize len = 0UL;
		GIOChannel* ch = NULL;
		GIOChannel* _tmp3_;
		GIOChannel* _tmp4_;
		GIOStatus status = 0;
		GIOChannel* _tmp5_;
		gchar* _tmp6_ = NULL;
		gsize _tmp7_ = 0UL;
		GIOStatus _tmp8_;
		GKeyFile* _tmp9_;
		const gchar* _tmp10_;
		data = NULL;
		_tmp3_ = g_io_channel_unix_new (fd);
		ch = _tmp3_;
		_tmp4_ = ch;
		g_io_channel_set_close_on_unref (_tmp4_, TRUE);
		_tmp5_ = ch;
		_tmp8_ = g_io_channel_read_to_end (_tmp5_, &_tmp6_, &_tmp7_, &_inner_error0_);
		_g_free0 (data);
		data = _tmp6_;
		len = _tmp7_;
		status = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_io_channel_unref0 (ch);
			_g_free0 (data);
			goto __catch0_g_error;
		}
		if (status != G_IO_STATUS_NORMAL) {
			result = NULL;
			_g_io_channel_unref0 (ch);
			_g_free0 (data);
			_g_key_file_unref0 (kf);
			_g_free0 (path);
			return result;
		}
		_tmp9_ = kf;
		_tmp10_ = data;
		g_key_file_load_from_data (_tmp9_, _tmp10_, len, 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_io_channel_unref0 (ch);
			_g_free0 (data);
			goto __catch0_g_error;
		}
		_g_io_channel_unref0 (ch);
		_g_free0 (data);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_key_file_unref0 (kf);
		_g_free0 (path);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_key_file_unref0 (kf);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = kf;
	_g_free0 (path);
	return result;
}

gchar*
usage_process_sanitize_name (const gchar* name)
{
	gchar* _result_ = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_result_ = NULL;
	if (name == NULL) {
		result = NULL;
		_g_free0 (_result_);
		return result;
	}
	{
		GRegex* rgx = NULL;
		GRegex* _tmp0_;
		gchar* _tmp1_ = NULL;
		GRegex* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp0_ = g_regex_new ("[^a-zA-Z0-9._-]", 0, 0, &_inner_error0_);
		rgx = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_free0 (_result_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = rgx;
		_tmp3_ = strlen (name);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_replace (_tmp2_, name, (gssize) _tmp4_, 0, "", 0, &_inner_error0_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (rgx);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_free0 (_result_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (_result_);
		_result_ = _tmp6_;
		_g_free0 (_tmp1_);
		_g_regex_unref0 (rgx);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("process.vala:223: Unable to sanitize name: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (_result_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = _result_;
	return result;
}

gchar*
usage_process_first_component (const gchar* str)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (str, " ", 2);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = _tmp2_[0];
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp5_;
	return result;
}

GPid
usage_process_get_pid (UsageProcess* self)
{
	GPid result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_pid;
	return result;
}

static void
usage_process_set_pid (UsageProcess* self,
                       GPid value)
{
	GPid old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_pid (self);
	if (old_value != value) {
		self->priv->_pid = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_PID_PROPERTY]);
	}
}

const gchar*
usage_process_get_cmdline (UsageProcess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cmdline;
	result = _tmp0_;
	return result;
}

static void
usage_process_set_cmdline (UsageProcess* self,
                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_cmdline (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_cmdline);
		self->priv->_cmdline = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_CMDLINE_PROPERTY]);
	}
}

guint
usage_process_get_uid (UsageProcess* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_uid;
	return result;
}

static void
usage_process_set_uid (UsageProcess* self,
                       guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_uid (self);
	if (old_value != value) {
		self->priv->_uid = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_UID_PROPERTY]);
	}
}

guint64
usage_process_get_start_time (UsageProcess* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_start_time;
	return result;
}

void
usage_process_set_start_time (UsageProcess* self,
                              guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_start_time (self);
	if (old_value != value) {
		self->priv->_start_time = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_START_TIME_PROPERTY]);
	}
}

gdouble
usage_process_get_cpu_load (UsageProcess* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cpu_load;
	return result;
}

void
usage_process_set_cpu_load (UsageProcess* self,
                            gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_cpu_load (self);
	if (old_value != value) {
		self->priv->_cpu_load = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_CPU_LOAD_PROPERTY]);
	}
}

gdouble
usage_process_get_x_cpu_load (UsageProcess* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_x_cpu_load;
	return result;
}

void
usage_process_set_x_cpu_load (UsageProcess* self,
                              gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_x_cpu_load (self);
	if (old_value != value) {
		self->priv->_x_cpu_load = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_X_CPU_LOAD_PROPERTY]);
	}
}

guint64
usage_process_get_cpu_last_used (UsageProcess* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_cpu_last_used;
	return result;
}

void
usage_process_set_cpu_last_used (UsageProcess* self,
                                 guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_cpu_last_used (self);
	if (old_value != value) {
		self->priv->_cpu_last_used = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_CPU_LAST_USED_PROPERTY]);
	}
}

guint64
usage_process_get_x_cpu_last_used (UsageProcess* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_x_cpu_last_used;
	return result;
}

void
usage_process_set_x_cpu_last_used (UsageProcess* self,
                                   guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_x_cpu_last_used (self);
	if (old_value != value) {
		self->priv->_x_cpu_last_used = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_X_CPU_LAST_USED_PROPERTY]);
	}
}

guint
usage_process_get_last_processor (UsageProcess* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_last_processor;
	return result;
}

void
usage_process_set_last_processor (UsageProcess* self,
                                  guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_last_processor (self);
	if (old_value != value) {
		self->priv->_last_processor = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_LAST_PROCESSOR_PROPERTY]);
	}
}

guint64
usage_process_get_mem_usage (UsageProcess* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_mem_usage;
	return result;
}

void
usage_process_set_mem_usage (UsageProcess* self,
                             guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_mem_usage (self);
	if (old_value != value) {
		self->priv->_mem_usage = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_MEM_USAGE_PROPERTY]);
	}
}

gboolean
usage_process_get_gamemode (UsageProcess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_gamemode;
	return result;
}

void
usage_process_set_gamemode (UsageProcess* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_gamemode (self);
	if (old_value != value) {
		self->priv->_gamemode = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_GAMEMODE_PROPERTY]);
	}
}

gboolean
usage_process_get_mark_as_updated (UsageProcess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_mark_as_updated;
	return result;
}

void
usage_process_set_mark_as_updated (UsageProcess* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_mark_as_updated (self);
	if (old_value != value) {
		self->priv->_mark_as_updated = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_MARK_AS_UPDATED_PROPERTY]);
	}
}

UsageProcessStatus
usage_process_get_status (UsageProcess* self)
{
	UsageProcessStatus result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_status;
	return result;
}

static void
usage_process_set_status (UsageProcess* self,
                          UsageProcessStatus value)
{
	UsageProcessStatus old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_get_status (self);
	if (old_value != value) {
		self->priv->_status = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_properties[USAGE_PROCESS_STATUS_PROPERTY]);
	}
}

const gchar*
usage_process_get_app_id (UsageProcess* self)
{
	const gchar* result;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!self->priv->_app_id_checked) {
		GPid _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->priv->_pid;
		_tmp1_ = usage_process_read_app_id (_tmp0_);
		_g_free0 (self->priv->_app_id);
		self->priv->_app_id = _tmp1_;
	}
	_tmp2_ = self->priv->_app_id;
	result = _tmp2_;
	return result;
}

static void
usage_process_class_init (UsageProcessClass * klass,
                          gpointer klass_data)
{
	usage_process_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageProcess_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_process_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_process_set_property;
	G_OBJECT_CLASS (klass)->finalize = usage_process_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_PID_PROPERTY, usage_process_properties[USAGE_PROCESS_PID_PROPERTY] = g_param_spec_int ("pid", "pid", "pid", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_CMDLINE_PROPERTY, usage_process_properties[USAGE_PROCESS_CMDLINE_PROPERTY] = g_param_spec_string ("cmdline", "cmdline", "cmdline", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_UID_PROPERTY, usage_process_properties[USAGE_PROCESS_UID_PROPERTY] = g_param_spec_uint ("uid", "uid", "uid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_START_TIME_PROPERTY, usage_process_properties[USAGE_PROCESS_START_TIME_PROPERTY] = g_param_spec_uint64 ("start-time", "start-time", "start-time", 0, G_MAXUINT64, (guint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_CPU_LOAD_PROPERTY, usage_process_properties[USAGE_PROCESS_CPU_LOAD_PROPERTY] = g_param_spec_double ("cpu-load", "cpu-load", "cpu-load", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_X_CPU_LOAD_PROPERTY, usage_process_properties[USAGE_PROCESS_X_CPU_LOAD_PROPERTY] = g_param_spec_double ("x-cpu-load", "x-cpu-load", "x-cpu-load", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_CPU_LAST_USED_PROPERTY, usage_process_properties[USAGE_PROCESS_CPU_LAST_USED_PROPERTY] = g_param_spec_uint64 ("cpu-last-used", "cpu-last-used", "cpu-last-used", 0, G_MAXUINT64, (guint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_X_CPU_LAST_USED_PROPERTY, usage_process_properties[USAGE_PROCESS_X_CPU_LAST_USED_PROPERTY] = g_param_spec_uint64 ("x-cpu-last-used", "x-cpu-last-used", "x-cpu-last-used", 0, G_MAXUINT64, (guint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_LAST_PROCESSOR_PROPERTY, usage_process_properties[USAGE_PROCESS_LAST_PROCESSOR_PROPERTY] = g_param_spec_uint ("last-processor", "last-processor", "last-processor", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_MEM_USAGE_PROPERTY, usage_process_properties[USAGE_PROCESS_MEM_USAGE_PROPERTY] = g_param_spec_uint64 ("mem-usage", "mem-usage", "mem-usage", 0, G_MAXUINT64, (guint64) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_GAMEMODE_PROPERTY, usage_process_properties[USAGE_PROCESS_GAMEMODE_PROPERTY] = g_param_spec_boolean ("gamemode", "gamemode", "gamemode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_MARK_AS_UPDATED_PROPERTY, usage_process_properties[USAGE_PROCESS_MARK_AS_UPDATED_PROPERTY] = g_param_spec_boolean ("mark-as-updated", "mark-as-updated", "mark-as-updated", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_STATUS_PROPERTY, usage_process_properties[USAGE_PROCESS_STATUS_PROPERTY] = g_param_spec_enum ("status", "status", "status", USAGE_TYPE_PROCESS_STATUS, USAGE_PROCESS_STATUS_SLEEPING, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_APP_ID_PROPERTY, usage_process_properties[USAGE_PROCESS_APP_ID_PROPERTY] = g_param_spec_string ("app-id", "app-id", "app-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
usage_process_instance_init (UsageProcess * self,
                             gpointer klass)
{
	self->priv = usage_process_get_instance_private (self);
	self->priv->_start_time = (guint64) 0;
	self->priv->_cpu_load = (gdouble) 0;
	self->priv->_x_cpu_load = (gdouble) 0;
	self->priv->_cpu_last_used = (guint64) 0;
	self->priv->_x_cpu_last_used = (guint64) 0;
	self->priv->_last_processor = (guint) 0;
	self->priv->_mem_usage = (guint64) 0;
	self->priv->_mark_as_updated = TRUE;
	self->priv->_status = USAGE_PROCESS_STATUS_SLEEPING;
	self->priv->_app_id = NULL;
	self->priv->_app_id_checked = FALSE;
}

static void
usage_process_finalize (GObject * obj)
{
	UsageProcess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_PROCESS, UsageProcess);
	_g_free0 (self->priv->_cmdline);
	_g_free0 (self->priv->_app_id);
	G_OBJECT_CLASS (usage_process_parent_class)->finalize (obj);
}

static GType
usage_process_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageProcessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_process_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageProcess), 0, (GInstanceInitFunc) usage_process_instance_init, NULL };
	GType usage_process_type_id;
	usage_process_type_id = g_type_register_static (G_TYPE_OBJECT, "UsageProcess", &g_define_type_info, 0);
	UsageProcess_private_offset = g_type_add_instance_private (usage_process_type_id, sizeof (UsageProcessPrivate));
	return usage_process_type_id;
}

GType
usage_process_get_type (void)
{
	static volatile gsize usage_process_type_id__once = 0;
	if (g_once_init_enter (&usage_process_type_id__once)) {
		GType usage_process_type_id;
		usage_process_type_id = usage_process_get_type_once ();
		g_once_init_leave (&usage_process_type_id__once, usage_process_type_id);
	}
	return usage_process_type_id__once;
}

static void
_vala_usage_process_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	UsageProcess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_PROCESS, UsageProcess);
	switch (property_id) {
		case USAGE_PROCESS_PID_PROPERTY:
		g_value_set_int (value, usage_process_get_pid (self));
		break;
		case USAGE_PROCESS_CMDLINE_PROPERTY:
		g_value_set_string (value, usage_process_get_cmdline (self));
		break;
		case USAGE_PROCESS_UID_PROPERTY:
		g_value_set_uint (value, usage_process_get_uid (self));
		break;
		case USAGE_PROCESS_START_TIME_PROPERTY:
		g_value_set_uint64 (value, usage_process_get_start_time (self));
		break;
		case USAGE_PROCESS_CPU_LOAD_PROPERTY:
		g_value_set_double (value, usage_process_get_cpu_load (self));
		break;
		case USAGE_PROCESS_X_CPU_LOAD_PROPERTY:
		g_value_set_double (value, usage_process_get_x_cpu_load (self));
		break;
		case USAGE_PROCESS_CPU_LAST_USED_PROPERTY:
		g_value_set_uint64 (value, usage_process_get_cpu_last_used (self));
		break;
		case USAGE_PROCESS_X_CPU_LAST_USED_PROPERTY:
		g_value_set_uint64 (value, usage_process_get_x_cpu_last_used (self));
		break;
		case USAGE_PROCESS_LAST_PROCESSOR_PROPERTY:
		g_value_set_uint (value, usage_process_get_last_processor (self));
		break;
		case USAGE_PROCESS_MEM_USAGE_PROPERTY:
		g_value_set_uint64 (value, usage_process_get_mem_usage (self));
		break;
		case USAGE_PROCESS_GAMEMODE_PROPERTY:
		g_value_set_boolean (value, usage_process_get_gamemode (self));
		break;
		case USAGE_PROCESS_MARK_AS_UPDATED_PROPERTY:
		g_value_set_boolean (value, usage_process_get_mark_as_updated (self));
		break;
		case USAGE_PROCESS_STATUS_PROPERTY:
		g_value_set_enum (value, usage_process_get_status (self));
		break;
		case USAGE_PROCESS_APP_ID_PROPERTY:
		g_value_set_string (value, usage_process_get_app_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_process_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	UsageProcess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_PROCESS, UsageProcess);
	switch (property_id) {
		case USAGE_PROCESS_PID_PROPERTY:
		usage_process_set_pid (self, g_value_get_int (value));
		break;
		case USAGE_PROCESS_CMDLINE_PROPERTY:
		usage_process_set_cmdline (self, g_value_get_string (value));
		break;
		case USAGE_PROCESS_UID_PROPERTY:
		usage_process_set_uid (self, g_value_get_uint (value));
		break;
		case USAGE_PROCESS_START_TIME_PROPERTY:
		usage_process_set_start_time (self, g_value_get_uint64 (value));
		break;
		case USAGE_PROCESS_CPU_LOAD_PROPERTY:
		usage_process_set_cpu_load (self, g_value_get_double (value));
		break;
		case USAGE_PROCESS_X_CPU_LOAD_PROPERTY:
		usage_process_set_x_cpu_load (self, g_value_get_double (value));
		break;
		case USAGE_PROCESS_CPU_LAST_USED_PROPERTY:
		usage_process_set_cpu_last_used (self, g_value_get_uint64 (value));
		break;
		case USAGE_PROCESS_X_CPU_LAST_USED_PROPERTY:
		usage_process_set_x_cpu_last_used (self, g_value_get_uint64 (value));
		break;
		case USAGE_PROCESS_LAST_PROCESSOR_PROPERTY:
		usage_process_set_last_processor (self, g_value_get_uint (value));
		break;
		case USAGE_PROCESS_MEM_USAGE_PROPERTY:
		usage_process_set_mem_usage (self, g_value_get_uint64 (value));
		break;
		case USAGE_PROCESS_GAMEMODE_PROPERTY:
		usage_process_set_gamemode (self, g_value_get_boolean (value));
		break;
		case USAGE_PROCESS_MARK_AS_UPDATED_PROPERTY:
		usage_process_set_mark_as_updated (self, g_value_get_boolean (value));
		break;
		case USAGE_PROCESS_STATUS_PROPERTY:
		usage_process_set_status (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
usage_process_status_get_type_once (void)
{
	static const GEnumValue values[] = {{USAGE_PROCESS_STATUS_RUNNING, "USAGE_PROCESS_STATUS_RUNNING", "running"}, {USAGE_PROCESS_STATUS_SLEEPING, "USAGE_PROCESS_STATUS_SLEEPING", "sleeping"}, {USAGE_PROCESS_STATUS_DEAD, "USAGE_PROCESS_STATUS_DEAD", "dead"}, {0, NULL, NULL}};
	GType usage_process_status_type_id;
	usage_process_status_type_id = g_enum_register_static ("UsageProcessStatus", values);
	return usage_process_status_type_id;
}

GType
usage_process_status_get_type (void)
{
	static volatile gsize usage_process_status_type_id__once = 0;
	if (g_once_init_enter (&usage_process_status_type_id__once)) {
		GType usage_process_status_type_id;
		usage_process_status_type_id = usage_process_status_get_type_once ();
		g_once_init_leave (&usage_process_status_type_id__once, usage_process_status_type_id);
	}
	return usage_process_status_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

