/* process-list-box.c generated by valac 0.56.16, the Vala compiler
 * generated from process-list-box.vala, do not modify */

/* process-list-box.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 * Copyright (C) 2023-2024 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <string.h>
#include <adwaita.h>
#include <stdlib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef gboolean (*UsageFilterFunc) (gconstpointer object, gpointer user_data);
typedef GtkWidget* (*UsageWidgetFactoryFunc) (gconstpointer object, gpointer user_data);

#define USAGE_TYPE_PROCESS_LIST_BOX_TYPE (usage_process_list_box_type_get_type ())
typedef struct _UsageProcessListBoxType UsageProcessListBoxType;

#define USAGE_TYPE_APP_ITEM (usage_app_item_get_type ())
#define USAGE_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_APP_ITEM, UsageAppItem))
#define USAGE_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_APP_ITEM, UsageAppItemClass))
#define USAGE_IS_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_APP_ITEM))
#define USAGE_IS_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_APP_ITEM))
#define USAGE_APP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_APP_ITEM, UsageAppItemClass))

typedef struct _UsageAppItem UsageAppItem;
typedef struct _UsageAppItemClass UsageAppItemClass;

#define USAGE_TYPE_PROCESS_LIST_BOX (usage_process_list_box_get_type ())
#define USAGE_PROCESS_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBox))
#define USAGE_PROCESS_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBoxClass))
#define USAGE_IS_PROCESS_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS_LIST_BOX))
#define USAGE_IS_PROCESS_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS_LIST_BOX))
#define USAGE_PROCESS_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBoxClass))

typedef struct _UsageProcessListBox UsageProcessListBox;
typedef struct _UsageProcessListBoxClass UsageProcessListBoxClass;
typedef struct _UsageProcessListBoxPrivate UsageProcessListBoxPrivate;

#define USAGE_TYPE_PROCESS_ROW_ITEM (usage_process_row_item_get_type ())
#define USAGE_PROCESS_ROW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItem))
#define USAGE_PROCESS_ROW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItemClass))
#define USAGE_IS_PROCESS_ROW_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS_ROW_ITEM))
#define USAGE_IS_PROCESS_ROW_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS_ROW_ITEM))
#define USAGE_PROCESS_ROW_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItemClass))

typedef struct _UsageProcessRowItem UsageProcessRowItem;
typedef struct _UsageProcessRowItemClass UsageProcessRowItemClass;
enum  {
	USAGE_PROCESS_LIST_BOX_0_PROPERTY,
	USAGE_PROCESS_LIST_BOX_LIST_VIEW_PROPERTY,
	USAGE_PROCESS_LIST_BOX_EMPTY_PROPERTY,
	USAGE_PROCESS_LIST_BOX_SEARCH_TEXT_PROPERTY,
	USAGE_PROCESS_LIST_BOX_NUM_PROPERTIES
};
static GParamSpec* usage_process_list_box_properties[USAGE_PROCESS_LIST_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define USAGE_TYPE_SYSTEM_MONITOR (usage_system_monitor_get_type ())
#define USAGE_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor))
#define USAGE_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))
#define USAGE_IS_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_IS_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_SYSTEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))

typedef struct _UsageSystemMonitor UsageSystemMonitor;
typedef struct _UsageSystemMonitorClass UsageSystemMonitorClass;
typedef struct _Block5Data Block5Data;

#define USAGE_TYPE_PROCESS_USER_TAG (usage_process_user_tag_get_type ())
#define USAGE_PROCESS_USER_TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS_USER_TAG, UsageProcessUserTag))
#define USAGE_PROCESS_USER_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS_USER_TAG, UsageProcessUserTagClass))
#define USAGE_IS_PROCESS_USER_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS_USER_TAG))
#define USAGE_IS_PROCESS_USER_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS_USER_TAG))
#define USAGE_PROCESS_USER_TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS_USER_TAG, UsageProcessUserTagClass))

typedef struct _UsageProcessUserTag UsageProcessUserTag;
typedef struct _UsageProcessUserTagClass UsageProcessUserTagClass;

#define USAGE_TYPE_APP_DIALOG (usage_app_dialog_get_type ())
#define USAGE_APP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_APP_DIALOG, UsageAppDialog))
#define USAGE_APP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_APP_DIALOG, UsageAppDialogClass))
#define USAGE_IS_APP_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_APP_DIALOG))
#define USAGE_IS_APP_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_APP_DIALOG))
#define USAGE_APP_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_APP_DIALOG, UsageAppDialogClass))

typedef struct _UsageAppDialog UsageAppDialog;
typedef struct _UsageAppDialogClass UsageAppDialogClass;

#define USAGE_TYPE_SETTINGS (usage_settings_get_type ())
#define USAGE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SETTINGS, UsageSettings))
#define USAGE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SETTINGS, UsageSettingsClass))
#define USAGE_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SETTINGS))
#define USAGE_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SETTINGS))
#define USAGE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SETTINGS, UsageSettingsClass))

typedef struct _UsageSettings UsageSettings;
typedef struct _UsageSettingsClass UsageSettingsClass;

struct _UsageProcessListBoxType {
	GCompareDataFunc comparator;
	gpointer comparator_target;
	UsageFilterFunc filter;
	gpointer filter_target;
	UsageWidgetFactoryFunc load_widget_factory;
	gpointer load_widget_factory_target;
};

struct _UsageProcessListBox {
	AdwBin parent_instance;
	UsageProcessListBoxPrivate * priv;
};

struct _UsageProcessListBoxClass {
	AdwBinClass parent_class;
};

struct _UsageProcessListBoxPrivate {
	GtkListView* _list_view;
	gboolean _empty;
	gchar* _search_text;
	GListStore* model;
	GtkFilter* filter;
	GtkSorter* sorter;
	UsageProcessListBoxType type;
	GHashTable* item_for_app;
};

struct _Block5Data {
	int _ref_count_;
	UsageProcessListBox* self;
	UsageSystemMonitor* system_monitor;
};

static gint UsageProcessListBox_private_offset;
static gpointer usage_process_list_box_parent_class = NULL;

VALA_EXTERN GType usage_process_list_box_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType usage_app_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageAppItem, g_object_unref)
VALA_EXTERN UsageProcessListBoxType* usage_process_list_box_type_dup (const UsageProcessListBoxType* self);
VALA_EXTERN void usage_process_list_box_type_free (UsageProcessListBoxType* self);
VALA_EXTERN GType usage_process_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcessListBox, g_object_unref)
VALA_EXTERN GType usage_process_row_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcessRowItem, g_object_unref)
VALA_EXTERN UsageProcessListBox* usage_process_list_box_new (UsageProcessListBoxType* type);
VALA_EXTERN UsageProcessListBox* usage_process_list_box_construct (GType object_type,
                                                       UsageProcessListBoxType* type);
VALA_EXTERN GType usage_system_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSystemMonitor, g_object_unref)
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _g_object_unref0_ (gpointer var);
static gboolean __lambda9_ (UsageProcessListBox* self,
                     GObject* item);
VALA_EXTERN UsageAppItem* usage_process_row_item_get_app (UsageProcessRowItem* self);
VALA_EXTERN const gchar* usage_process_list_box_get_search_text (UsageProcessListBox* self);
VALA_EXTERN const gchar* usage_app_item_get_display_name (UsageAppItem* self);
VALA_EXTERN const gchar* usage_app_item_get_representative_cmdline (UsageAppItem* self);
VALA_EXTERN const gchar* usage_app_item_get_container (UsageAppItem* self);
static gboolean* _bool_dup (gboolean* self);
static gboolean ___lambda9__gtk_custom_filter_func (GObject* item,
                                             gpointer self);
static gint __lambda10_ (UsageProcessListBox* self,
                  gconstpointer a,
                  gconstpointer b);
static gint ___lambda10__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN GType usage_process_user_tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcessUserTag, g_object_unref)
static void usage_process_list_box_set_list_view (UsageProcessListBox* self,
                                           GtkListView* value);
VALA_EXTERN GtkListView* usage_process_list_box_get_list_view (UsageProcessListBox* self);
static void __lambda11_ (UsageProcessListBox* self,
                  GtkListView* list_view,
                  guint position);
VALA_EXTERN GType usage_app_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageAppDialog, g_object_unref)
VALA_EXTERN UsageAppDialog* usage_app_dialog_new (UsageAppItem* app);
VALA_EXTERN UsageAppDialog* usage_app_dialog_construct (GType object_type,
                                            UsageAppItem* app);
static void ___lambda11__gtk_list_view_activate (GtkListView* _sender,
                                          guint position,
                                          gpointer self);
static void __lambda12_ (UsageProcessListBox* self,
                  GObject* sender,
                  GParamSpec* property);
static gboolean usage_process_list_box_update (UsageProcessListBox* self);
static void ___lambda12__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_get_default (void);
static void __lambda17_ (Block5Data* _data5_);
VALA_EXTERN gboolean usage_system_monitor_get_process_list_ready (UsageSystemMonitor* self);
static void ___lambda17__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN GType usage_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSettings, g_object_unref)
VALA_EXTERN UsageSettings* usage_settings_get_default (void);
VALA_EXTERN guint usage_settings_get_list_update_interval_UI (UsageSettings* self);
static gboolean _usage_process_list_box_update_gsource_func (gpointer self);
VALA_EXTERN GList* usage_system_monitor_get_apps (UsageSystemMonitor* self);
VALA_EXTERN gboolean usage_app_item_is_running (UsageAppItem* self);
VALA_EXTERN UsageProcessRowItem* usage_process_row_item_new (UsageAppItem* app,
                                                 UsageProcessListBoxType* type);
VALA_EXTERN UsageProcessRowItem* usage_process_row_item_construct (GType object_type,
                                                       UsageAppItem* app,
                                                       UsageProcessListBoxType* type);
VALA_EXTERN void usage_process_list_box_set_empty (UsageProcessListBox* self,
                                       gboolean value);
VALA_EXTERN gboolean usage_process_list_box_get_empty (UsageProcessListBox* self);
VALA_EXTERN void usage_process_list_box_set_search_text (UsageProcessListBox* self,
                                             const gchar* value);
static void usage_process_list_box_finalize (GObject * obj);
static GType usage_process_list_box_get_type_once (void);
static void _vala_usage_process_list_box_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_usage_process_list_box_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

UsageProcessListBoxType*
usage_process_list_box_type_dup (const UsageProcessListBoxType* self)
{
	UsageProcessListBoxType* dup;
	dup = g_new0 (UsageProcessListBoxType, 1);
	memcpy (dup, self, sizeof (UsageProcessListBoxType));
	return dup;
}

void
usage_process_list_box_type_free (UsageProcessListBoxType* self)
{
	g_free (self);
}

static GType
usage_process_list_box_type_get_type_once (void)
{
	GType usage_process_list_box_type_type_id;
	usage_process_list_box_type_type_id = g_boxed_type_register_static ("UsageProcessListBoxType", (GBoxedCopyFunc) usage_process_list_box_type_dup, (GBoxedFreeFunc) usage_process_list_box_type_free);
	return usage_process_list_box_type_type_id;
}

GType
usage_process_list_box_type_get_type (void)
{
	static volatile gsize usage_process_list_box_type_type_id__once = 0;
	if (g_once_init_enter (&usage_process_list_box_type_type_id__once)) {
		GType usage_process_list_box_type_type_id;
		usage_process_list_box_type_type_id = usage_process_list_box_type_get_type_once ();
		g_once_init_leave (&usage_process_list_box_type_type_id__once, usage_process_list_box_type_type_id);
	}
	return usage_process_list_box_type_type_id__once;
}

static inline gpointer
usage_process_list_box_get_instance_private (UsageProcessListBox* self)
{
	return G_STRUCT_MEMBER_P (self, UsageProcessListBox_private_offset);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		UsageProcessListBox* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->system_monitor);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gboolean
__lambda9_ (UsageProcessListBox* self,
            GObject* item)
{
	UsageAppItem* app = NULL;
	UsageAppItem* _tmp0_;
	UsageAppItem* _tmp1_;
	UsageAppItem* _tmp2_;
	const gchar* _tmp3_;
	UsageProcessListBoxType _tmp40_;
	UsageFilterFunc _tmp41_;
	gpointer _tmp41__target;
	UsageAppItem* _tmp42_;
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = usage_process_row_item_get_app (G_TYPE_CHECK_INSTANCE_CAST (item, USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItem));
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	app = _tmp2_;
	_tmp3_ = self->priv->_search_text;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		UsageAppItem* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp6_ = app;
		_tmp7_ = usage_app_item_get_display_name (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->_search_text;
		_tmp12_ = g_utf8_strdown (_tmp11_, (gssize) -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_contains (_tmp10_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		if (_tmp14_) {
			_tmp5_ = TRUE;
		} else {
			UsageAppItem* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp15_ = app;
			_tmp16_ = usage_app_item_get_representative_cmdline (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = g_utf8_strdown (_tmp17_, (gssize) -1);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->_search_text;
			_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) -1);
			_tmp22_ = _tmp21_;
			_tmp5_ = string_contains (_tmp19_, _tmp22_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp19_);
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp23_ = NULL;
			UsageAppItem* _tmp24_;
			const gchar* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_ = NULL;
			const gchar* _tmp29_ = NULL;
			gboolean* _tmp30_ = NULL;
			gboolean* _tmp36_ = NULL;
			gboolean* _tmp37_;
			_tmp24_ = app;
			_tmp25_ = usage_app_item_get_container (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp23_ = _tmp26_;
			_tmp27_ = NULL;
			if (_tmp23_ != NULL) {
				gchar* _tmp28_;
				_tmp28_ = g_utf8_strdown (_tmp23_, (gssize) -1);
				_g_free0 (_tmp27_);
				_tmp27_ = _tmp28_;
			}
			_tmp29_ = _tmp27_;
			_tmp30_ = NULL;
			if (_tmp29_ != NULL) {
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gboolean _tmp34_;
				gboolean* _tmp35_;
				_tmp31_ = self->priv->_search_text;
				_tmp32_ = g_utf8_strdown (_tmp31_, (gssize) -1);
				_tmp33_ = _tmp32_;
				_tmp34_ = string_contains (_tmp29_, _tmp33_);
				_tmp35_ = __bool_dup0 (&_tmp34_);
				_g_free0 (_tmp30_);
				_tmp30_ = _tmp35_;
				_g_free0 (_tmp33_);
			}
			_tmp37_ = __bool_dup0 (_tmp30_);
			_tmp36_ = _tmp37_;
			if (_tmp36_ == NULL) {
				gboolean _tmp38_;
				gboolean* _tmp39_;
				_tmp38_ = FALSE;
				_tmp39_ = __bool_dup0 (&_tmp38_);
				_g_free0 (_tmp36_);
				_tmp36_ = _tmp39_;
			}
			_tmp4_ = *_tmp36_;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp27_);
		}
		result = _tmp4_;
		_g_object_unref0 (app);
		return result;
	}
	_tmp40_ = self->priv->type;
	_tmp41_ = _tmp40_.filter;
	_tmp41__target = _tmp40_.filter_target;
	_tmp42_ = app;
	result = _tmp41_ (_tmp42_, _tmp41__target);
	_g_object_unref0 (app);
	return result;
}

static gboolean
___lambda9__gtk_custom_filter_func (GObject* item,
                                    gpointer self)
{
	gboolean result;
	result = __lambda9_ ((UsageProcessListBox*) self, item);
	return result;
}

static gint
__lambda10_ (UsageProcessListBox* self,
             gconstpointer a,
             gconstpointer b)
{
	UsageProcessListBoxType _tmp0_;
	GCompareDataFunc _tmp1_;
	gpointer _tmp1__target;
	UsageAppItem* _tmp2_;
	UsageAppItem* _tmp3_;
	UsageAppItem* _tmp4_;
	UsageAppItem* _tmp5_;
	gint result;
	_tmp0_ = self->priv->type;
	_tmp1_ = _tmp0_.comparator;
	_tmp1__target = _tmp0_.comparator_target;
	_tmp2_ = usage_process_row_item_get_app (G_TYPE_CHECK_INSTANCE_CAST (a, USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItem));
	_tmp3_ = _tmp2_;
	_tmp4_ = usage_process_row_item_get_app (G_TYPE_CHECK_INSTANCE_CAST (b, USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItem));
	_tmp5_ = _tmp4_;
	result = _tmp1_ (_tmp3_, _tmp5_, _tmp1__target);
	return result;
}

static gint
___lambda10__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda10_ ((UsageProcessListBox*) self, a, b);
	return result;
}

static void
__lambda11_ (UsageProcessListBox* self,
             GtkListView* list_view,
             guint position)
{
	UsageAppItem* app = NULL;
	GtkSelectionModel* _tmp0_;
	GObject* _tmp1_;
	UsageProcessRowItem* _tmp2_;
	UsageAppItem* _tmp3_;
	UsageAppItem* _tmp4_;
	UsageAppItem* _tmp5_;
	UsageAppItem* _tmp6_;
	UsageAppItem* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (list_view != NULL);
	_tmp0_ = gtk_list_view_get_model (list_view);
	_tmp1_ = g_list_model_get_item ((GListModel*) _tmp0_, position);
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItem);
	_tmp3_ = usage_process_row_item_get_app (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	app = _tmp6_;
	_tmp7_ = app;
	_tmp8_ = usage_app_item_get_representative_cmdline (_tmp7_);
	_tmp9_ = _tmp8_;
	if (g_strcmp0 (_tmp9_, "system") != 0) {
		UsageAppDialog* dialog = NULL;
		UsageAppItem* _tmp10_;
		UsageAppDialog* _tmp11_;
		UsageAppDialog* _tmp12_;
		GtkRoot* _tmp13_;
		_tmp10_ = app;
		_tmp11_ = usage_app_dialog_new (_tmp10_);
		g_object_ref_sink (_tmp11_);
		dialog = _tmp11_;
		_tmp12_ = dialog;
		_tmp13_ = gtk_widget_get_root ((GtkWidget*) self);
		adw_dialog_present ((AdwDialog*) _tmp12_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_window_get_type (), GtkWindow));
		_g_object_unref0 (dialog);
	}
	_g_object_unref0 (app);
}

static void
___lambda11__gtk_list_view_activate (GtkListView* _sender,
                                     guint position,
                                     gpointer self)
{
	__lambda11_ ((UsageProcessListBox*) self, _sender, position);
}

static void
__lambda12_ (UsageProcessListBox* self,
             GObject* sender,
             GParamSpec* property)
{
	g_return_if_fail (sender != NULL);
	g_return_if_fail (property != NULL);
	usage_process_list_box_update (self);
}

static void
___lambda12__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda12_ ((UsageProcessListBox*) self, _sender, pspec);
}

static void
__lambda17_ (Block5Data* _data5_)
{
	UsageProcessListBox* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data5_->self;
	_tmp0_ = usage_system_monitor_get_process_list_ready (_data5_->system_monitor);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		usage_process_list_box_update (self);
	}
}

static void
___lambda17__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda17_ (self);
}

static gboolean
_usage_process_list_box_update_gsource_func (gpointer self)
{
	gboolean result;
	result = usage_process_list_box_update ((UsageProcessListBox*) self);
	return result;
}

UsageProcessListBox*
usage_process_list_box_construct (GType object_type,
                                  UsageProcessListBoxType* type)
{
	UsageProcessListBox * self = NULL;
	Block5Data* _data5_;
	UsageProcessListBoxType _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GListStore* _tmp4_;
	GtkCustomFilter* _tmp5_;
	GtkCustomSorter* _tmp6_;
	GtkFilterListModel* filter_model = NULL;
	GListStore* _tmp7_;
	GListModel* _tmp8_;
	GtkFilter* _tmp9_;
	GtkFilter* _tmp10_;
	GtkFilterListModel* _tmp11_;
	GtkSortListModel* sort_model = NULL;
	GListModel* _tmp12_;
	GtkSorter* _tmp13_;
	GtkSorter* _tmp14_;
	GtkSortListModel* _tmp15_;
	GtkSelectionModel* selection_model = NULL;
	GListModel* _tmp16_;
	GtkNoSelection* _tmp17_;
	GtkBuilderListItemFactory* factory = NULL;
	GtkBuilderListItemFactory* _tmp18_;
	GtkSelectionModel* _tmp19_;
	GtkListItemFactory* _tmp20_;
	GtkListView* _tmp21_;
	GtkListView* _tmp22_;
	GtkListView* _tmp23_;
	GtkListView* _tmp24_;
	GtkListView* _tmp25_;
	GtkListView* _tmp26_;
	GtkListView* _tmp27_;
	UsageSystemMonitor* _tmp28_;
	UsageSettings* settings = NULL;
	UsageSettings* _tmp29_;
	guint _tmp30_;
	guint _tmp31_;
	g_return_val_if_fail (type != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	self = (UsageProcessListBox*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	_tmp0_ = *type;
	self->priv->type = _tmp0_;
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->item_for_app);
	self->priv->item_for_app = _tmp3_;
	_tmp4_ = g_list_store_new (USAGE_TYPE_PROCESS_ROW_ITEM);
	_g_object_unref0 (self->priv->model);
	self->priv->model = _tmp4_;
	_tmp5_ = gtk_custom_filter_new (___lambda9__gtk_custom_filter_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->filter);
	self->priv->filter = (GtkFilter*) _tmp5_;
	_tmp6_ = gtk_custom_sorter_new (___lambda10__gcompare_data_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (self->priv->sorter);
	self->priv->sorter = (GtkSorter*) _tmp6_;
	_tmp7_ = self->priv->model;
	_tmp8_ = _g_object_ref0 ((GListModel*) _tmp7_);
	_tmp9_ = self->priv->filter;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_tmp11_ = gtk_filter_list_model_new (_tmp8_, _tmp10_);
	filter_model = _tmp11_;
	_tmp12_ = _g_object_ref0 ((GListModel*) filter_model);
	_tmp13_ = self->priv->sorter;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_tmp15_ = gtk_sort_list_model_new (_tmp12_, _tmp14_);
	sort_model = _tmp15_;
	_tmp16_ = _g_object_ref0 ((GListModel*) sort_model);
	_tmp17_ = gtk_no_selection_new (_tmp16_);
	selection_model = (GtkSelectionModel*) _tmp17_;
	g_type_ensure (USAGE_TYPE_PROCESS_USER_TAG);
	_tmp18_ = (GtkBuilderListItemFactory*) gtk_builder_list_item_factory_new_from_resource (NULL, "/org/gnome/Usage/ui/process-row.ui");
	factory = _tmp18_;
	_tmp19_ = _g_object_ref0 (selection_model);
	_tmp20_ = _g_object_ref0 ((GtkListItemFactory*) factory);
	_tmp21_ = (GtkListView*) gtk_list_view_new (_tmp19_, _tmp20_);
	g_object_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	usage_process_list_box_set_list_view (self, _tmp22_);
	_g_object_unref0 (_tmp22_);
	_tmp23_ = self->priv->_list_view;
	gtk_widget_add_css_class ((GtkWidget*) _tmp23_, "card");
	_tmp24_ = self->priv->_list_view;
	gtk_list_view_set_show_separators (_tmp24_, TRUE);
	_tmp25_ = self->priv->_list_view;
	gtk_list_view_set_single_click_activate (_tmp25_, TRUE);
	_tmp26_ = self->priv->_list_view;
	g_signal_connect_object (_tmp26_, "activate", (GCallback) ___lambda11__gtk_list_view_activate, self, 0);
	_tmp27_ = self->priv->_list_view;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp27_);
	g_signal_connect_object ((GObject*) self, "notify::search-text", (GCallback) ___lambda12__g_object_notify, self, 0);
	_tmp28_ = usage_system_monitor_get_default ();
	_data5_->system_monitor = _tmp28_;
	g_signal_connect_data ((GObject*) _data5_->system_monitor, "notify::process-list-ready", (GCallback) ___lambda17__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp29_ = usage_settings_get_default ();
	settings = _tmp29_;
	_tmp30_ = usage_settings_get_list_update_interval_UI (settings);
	_tmp31_ = _tmp30_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp31_, _usage_process_list_box_update_gsource_func, g_object_ref (self), g_object_unref);
	g_object_bind_property_with_closures ((GObject*) self, "empty", (GObject*) self, "visible", G_BINDING_INVERT_BOOLEAN | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (settings);
	_g_object_unref0 (factory);
	_g_object_unref0 (selection_model);
	_g_object_unref0 (sort_model);
	_g_object_unref0 (filter_model);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}

UsageProcessListBox*
usage_process_list_box_new (UsageProcessListBoxType* type)
{
	return usage_process_list_box_construct (USAGE_TYPE_PROCESS_LIST_BOX, type);
}

static gboolean
usage_process_list_box_update (UsageProcessListBox* self)
{
	UsageSystemMonitor* system_monitor = NULL;
	UsageSystemMonitor* _tmp0_;
	GList* apps = NULL;
	UsageSystemMonitor* _tmp1_;
	GList* _tmp2_;
	guint inserted = 0U;
	guint removed = 0U;
	UsageSystemMonitor* _tmp23_;
	GList* _tmp24_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	GtkFilter* _tmp58_;
	GtkSorter* _tmp59_;
	GtkListView* _tmp60_;
	GtkSelectionModel* _tmp61_;
	GtkSelectionModel* _tmp62_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = usage_system_monitor_get_default ();
	system_monitor = _tmp0_;
	_tmp1_ = system_monitor;
	_tmp2_ = usage_system_monitor_get_apps (_tmp1_);
	apps = _tmp2_;
	inserted = (guint) 0;
	removed = (guint) 0;
	{
		guint position = 0U;
		position = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GListStore* _tmp5_;
				guint _tmp6_;
				guint _tmp7_;
				UsageAppItem* app = NULL;
				GListStore* _tmp8_;
				GObject* _tmp9_;
				UsageProcessRowItem* _tmp10_;
				UsageAppItem* _tmp11_;
				UsageAppItem* _tmp12_;
				UsageAppItem* _tmp13_;
				UsageAppItem* _tmp14_;
				gboolean _tmp15_ = FALSE;
				GList* _tmp16_;
				UsageAppItem* _tmp17_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = position;
					position = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->model;
				g_object_get (_tmp5_, "n-items", &_tmp6_, NULL);
				_tmp7_ = _tmp6_;
				if (!(position < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->model;
				_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, position);
				_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItem);
				_tmp11_ = usage_process_row_item_get_app (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp10_);
				app = _tmp14_;
				_tmp16_ = apps;
				_tmp17_ = app;
				if (g_list_index (_tmp16_, _tmp17_) < 0) {
					_tmp15_ = TRUE;
				} else {
					UsageAppItem* _tmp18_;
					_tmp18_ = app;
					_tmp15_ = !usage_app_item_is_running (_tmp18_);
				}
				if (_tmp15_) {
					GListStore* _tmp19_;
					GHashTable* _tmp20_;
					UsageAppItem* _tmp21_;
					guint _tmp22_;
					_tmp19_ = self->priv->model;
					g_list_store_remove (_tmp19_, position);
					_tmp20_ = self->priv->item_for_app;
					_tmp21_ = app;
					g_hash_table_remove (_tmp20_, _tmp21_);
					_tmp22_ = removed;
					removed = _tmp22_ + 1;
				}
				_g_object_unref0 (app);
			}
		}
	}
	_tmp23_ = system_monitor;
	_tmp24_ = usage_system_monitor_get_apps (_tmp23_);
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp24_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			UsageAppItem* app = NULL;
			app = (UsageAppItem*) app_it->data;
			{
				guint index = 0U;
				gboolean _tmp25_ = FALSE;
				GListStore* _tmp26_;
				GHashTable* _tmp27_;
				UsageAppItem* _tmp28_;
				gconstpointer _tmp29_;
				guint _tmp30_ = 0U;
				gboolean _tmp31_;
				_tmp26_ = self->priv->model;
				_tmp27_ = self->priv->item_for_app;
				_tmp28_ = app;
				_tmp29_ = g_hash_table_lookup (_tmp27_, _tmp28_);
				_tmp31_ = g_list_store_find (_tmp26_, (GObject*) ((UsageProcessRowItem*) _tmp29_), &_tmp30_);
				index = _tmp30_;
				if (!_tmp31_) {
					UsageAppItem* _tmp32_;
					_tmp32_ = app;
					_tmp25_ = usage_app_item_is_running (_tmp32_);
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					UsageProcessRowItem* item = NULL;
					UsageAppItem* _tmp33_;
					UsageProcessListBoxType _tmp34_;
					UsageProcessRowItem* _tmp35_;
					GListStore* _tmp36_;
					UsageProcessRowItem* _tmp37_;
					GHashTable* _tmp38_;
					UsageAppItem* _tmp39_;
					UsageAppItem* _tmp40_;
					UsageProcessRowItem* _tmp41_;
					UsageProcessRowItem* _tmp42_;
					guint _tmp43_;
					_tmp33_ = app;
					_tmp34_ = self->priv->type;
					_tmp35_ = usage_process_row_item_new (_tmp33_, &_tmp34_);
					item = _tmp35_;
					_tmp36_ = self->priv->model;
					_tmp37_ = item;
					g_list_store_append (_tmp36_, (GObject*) _tmp37_);
					_tmp38_ = self->priv->item_for_app;
					_tmp39_ = app;
					_tmp40_ = _g_object_ref0 (_tmp39_);
					_tmp41_ = item;
					_tmp42_ = _g_object_ref0 (_tmp41_);
					g_hash_table_insert (_tmp38_, _tmp40_, _tmp42_);
					_tmp43_ = inserted;
					inserted = _tmp43_ + 1;
					_g_object_unref0 (item);
				}
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (g_list_free (app_collection), NULL));
	}
	_tmp44_ = g_strdup_printf ("%u", inserted);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf ("%u", removed);
	_tmp47_ = _tmp46_;
	_tmp48_ = g_strconcat (_tmp45_, " started; ", _tmp47_, " stopped", NULL);
	_tmp49_ = _tmp48_;
	g_debug ("process-list-box.vala:126: %s", _tmp49_);
	_g_free0 (_tmp49_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	{
		guint position = 0U;
		position = (guint) 0;
		{
			gboolean _tmp50_ = FALSE;
			_tmp50_ = TRUE;
			while (TRUE) {
				GListStore* _tmp52_;
				guint _tmp53_;
				guint _tmp54_;
				UsageProcessRowItem* item = NULL;
				GListStore* _tmp55_;
				GObject* _tmp56_;
				UsageProcessRowItem* _tmp57_;
				if (!_tmp50_) {
					guint _tmp51_;
					_tmp51_ = position;
					position = _tmp51_ + 1;
				}
				_tmp50_ = FALSE;
				_tmp52_ = self->priv->model;
				g_object_get (_tmp52_, "n-items", &_tmp53_, NULL);
				_tmp54_ = _tmp53_;
				if (!(position < _tmp54_)) {
					break;
				}
				_tmp55_ = self->priv->model;
				_tmp56_ = g_list_model_get_item ((GListModel*) _tmp55_, position);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, USAGE_TYPE_PROCESS_ROW_ITEM, UsageProcessRowItem);
				_tmp57_ = item;
				g_object_notify ((GObject*) _tmp57_, "load_widget");
				_g_object_unref0 (item);
			}
		}
	}
	_tmp58_ = self->priv->filter;
	gtk_filter_changed (_tmp58_, GTK_FILTER_CHANGE_DIFFERENT);
	_tmp59_ = self->priv->sorter;
	gtk_sorter_changed (_tmp59_, GTK_SORTER_CHANGE_DIFFERENT);
	_tmp60_ = self->priv->_list_view;
	_tmp61_ = gtk_list_view_get_model (_tmp60_);
	_tmp62_ = _tmp61_;
	usage_process_list_box_set_empty (self, g_list_model_get_n_items ((GListModel*) _tmp62_) == ((guint) 0));
	result = TRUE;
	(apps == NULL) ? NULL : (apps = (g_list_free (apps), NULL));
	_g_object_unref0 (system_monitor);
	return result;
}

GtkListView*
usage_process_list_box_get_list_view (UsageProcessListBox* self)
{
	GtkListView* result;
	GtkListView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_list_view;
	result = _tmp0_;
	return result;
}

static void
usage_process_list_box_set_list_view (UsageProcessListBox* self,
                                      GtkListView* value)
{
	GtkListView* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_list_box_get_list_view (self);
	if (old_value != value) {
		GtkListView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list_view);
		self->priv->_list_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_process_list_box_properties[USAGE_PROCESS_LIST_BOX_LIST_VIEW_PROPERTY]);
	}
}

gboolean
usage_process_list_box_get_empty (UsageProcessListBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_empty;
	return result;
}

void
usage_process_list_box_set_empty (UsageProcessListBox* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_list_box_get_empty (self);
	if (old_value != value) {
		self->priv->_empty = value;
		g_object_notify_by_pspec ((GObject *) self, usage_process_list_box_properties[USAGE_PROCESS_LIST_BOX_EMPTY_PROPERTY]);
	}
}

const gchar*
usage_process_list_box_get_search_text (UsageProcessListBox* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_search_text;
	result = _tmp0_;
	return result;
}

void
usage_process_list_box_set_search_text (UsageProcessListBox* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_process_list_box_get_search_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_search_text);
		self->priv->_search_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_process_list_box_properties[USAGE_PROCESS_LIST_BOX_SEARCH_TEXT_PROPERTY]);
	}
}

static void
usage_process_list_box_class_init (UsageProcessListBoxClass * klass,
                                   gpointer klass_data)
{
	usage_process_list_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageProcessListBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_process_list_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_process_list_box_set_property;
	G_OBJECT_CLASS (klass)->finalize = usage_process_list_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_LIST_BOX_LIST_VIEW_PROPERTY, usage_process_list_box_properties[USAGE_PROCESS_LIST_BOX_LIST_VIEW_PROPERTY] = g_param_spec_object ("list-view", "list-view", "list-view", gtk_list_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_LIST_BOX_EMPTY_PROPERTY, usage_process_list_box_properties[USAGE_PROCESS_LIST_BOX_EMPTY_PROPERTY] = g_param_spec_boolean ("empty", "empty", "empty", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_PROCESS_LIST_BOX_SEARCH_TEXT_PROPERTY, usage_process_list_box_properties[USAGE_PROCESS_LIST_BOX_SEARCH_TEXT_PROPERTY] = g_param_spec_string ("search-text", "search-text", "search-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
usage_process_list_box_instance_init (UsageProcessListBox * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	self->priv = usage_process_list_box_get_instance_private (self);
	self->priv->_empty = TRUE;
	_tmp0_ = g_strdup ("");
	self->priv->_search_text = _tmp0_;
}

static void
usage_process_list_box_finalize (GObject * obj)
{
	UsageProcessListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBox);
	_g_object_unref0 (self->priv->_list_view);
	_g_free0 (self->priv->_search_text);
	_g_object_unref0 (self->priv->model);
	_g_object_unref0 (self->priv->filter);
	_g_object_unref0 (self->priv->sorter);
	_g_hash_table_unref0 (self->priv->item_for_app);
	G_OBJECT_CLASS (usage_process_list_box_parent_class)->finalize (obj);
}

static GType
usage_process_list_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageProcessListBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_process_list_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageProcessListBox), 0, (GInstanceInitFunc) usage_process_list_box_instance_init, NULL };
	GType usage_process_list_box_type_id;
	usage_process_list_box_type_id = g_type_register_static (adw_bin_get_type (), "UsageProcessListBox", &g_define_type_info, 0);
	UsageProcessListBox_private_offset = g_type_add_instance_private (usage_process_list_box_type_id, sizeof (UsageProcessListBoxPrivate));
	return usage_process_list_box_type_id;
}

GType
usage_process_list_box_get_type (void)
{
	static volatile gsize usage_process_list_box_type_id__once = 0;
	if (g_once_init_enter (&usage_process_list_box_type_id__once)) {
		GType usage_process_list_box_type_id;
		usage_process_list_box_type_id = usage_process_list_box_get_type_once ();
		g_once_init_leave (&usage_process_list_box_type_id__once, usage_process_list_box_type_id);
	}
	return usage_process_list_box_type_id__once;
}

static void
_vala_usage_process_list_box_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	UsageProcessListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBox);
	switch (property_id) {
		case USAGE_PROCESS_LIST_BOX_LIST_VIEW_PROPERTY:
		g_value_set_object (value, usage_process_list_box_get_list_view (self));
		break;
		case USAGE_PROCESS_LIST_BOX_EMPTY_PROPERTY:
		g_value_set_boolean (value, usage_process_list_box_get_empty (self));
		break;
		case USAGE_PROCESS_LIST_BOX_SEARCH_TEXT_PROPERTY:
		g_value_set_string (value, usage_process_list_box_get_search_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_process_list_box_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	UsageProcessListBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBox);
	switch (property_id) {
		case USAGE_PROCESS_LIST_BOX_LIST_VIEW_PROPERTY:
		usage_process_list_box_set_list_view (self, g_value_get_object (value));
		break;
		case USAGE_PROCESS_LIST_BOX_EMPTY_PROPERTY:
		usage_process_list_box_set_empty (self, g_value_get_boolean (value));
		break;
		case USAGE_PROCESS_LIST_BOX_SEARCH_TEXT_PROPERTY:
		usage_process_list_box_set_search_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

