/* performance-graph-view.c generated by valac 0.56.16, the Vala compiler
 * generated from performance-graph-view.vala, do not modify */

/* performance-graph-view.vala
 *
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <math.h>
#include <float.h>
#include <gsk/gsk.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_GRAPH_VIEW (usage_graph_view_get_type ())
#define USAGE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphView))
#define USAGE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))
#define USAGE_IS_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_IS_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))

typedef struct _UsageGraphView UsageGraphView;
typedef struct _UsageGraphViewClass UsageGraphViewClass;
typedef struct _UsageGraphViewPrivate UsageGraphViewPrivate;

#define USAGE_TYPE_PERFORMANCE_GRAPH_VIEW (usage_performance_graph_view_get_type ())
#define USAGE_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphView))
#define USAGE_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_PERFORMANCE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))

typedef struct _UsagePerformanceGraphView UsagePerformanceGraphView;
typedef struct _UsagePerformanceGraphViewClass UsagePerformanceGraphViewClass;
typedef struct _UsagePerformanceGraphViewPrivate UsagePerformanceGraphViewPrivate;

#define USAGE_TYPE_SETTINGS (usage_settings_get_type ())
#define USAGE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SETTINGS, UsageSettings))
#define USAGE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SETTINGS, UsageSettingsClass))
#define USAGE_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SETTINGS))
#define USAGE_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SETTINGS))
#define USAGE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SETTINGS, UsageSettingsClass))

typedef struct _UsageSettings UsageSettings;
typedef struct _UsageSettingsClass UsageSettingsClass;
enum  {
	USAGE_PERFORMANCE_GRAPH_VIEW_0_PROPERTY,
	USAGE_PERFORMANCE_GRAPH_VIEW_NUM_PROPERTIES
};
static GParamSpec* usage_performance_graph_view_properties[USAGE_PERFORMANCE_GRAPH_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define USAGE_TYPE_GRAPH (usage_graph_get_type ())
#define USAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH, UsageGraph))
#define USAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH, UsageGraphClass))
#define USAGE_IS_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH))
#define USAGE_IS_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH))
#define USAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH, UsageGraphClass))

typedef struct _UsageGraph UsageGraph;
typedef struct _UsageGraphClass UsageGraphClass;
typedef struct _UsageGraphPrivate UsageGraphPrivate;

#define USAGE_TYPE_GRAPH_POINT (usage_graph_point_get_type ())
typedef struct _UsageGraphPoint UsageGraphPoint;

struct _UsageGraphView {
	GtkWidget parent_instance;
	UsageGraphViewPrivate * priv;
	gint64 _offset_x;
	gint64 _range_x;
	gint64 _offset_y;
	gint64 _range_y;
};

struct _UsageGraphViewClass {
	GtkWidgetClass parent_class;
	gint64 (*get_offset_x) (UsageGraphView* self);
	void (*set_offset_x) (UsageGraphView* self, gint64 value);
};

struct _UsagePerformanceGraphView {
	UsageGraphView parent_instance;
	UsagePerformanceGraphViewPrivate * priv;
};

struct _UsagePerformanceGraphViewClass {
	UsageGraphViewClass parent_class;
	void (*update_graphs) (UsagePerformanceGraphView* self);
};

struct _UsagePerformanceGraphViewPrivate {
	UsageSettings* settings;
	gboolean constant_redraw;
};

struct _UsageGraphPoint {
	gint64 timestamp;
	gdouble level;
};

struct _UsageGraph {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UsageGraphPrivate * priv;
	GskRenderNode* render_node;
	GQueue* values;
	guint maximal_queue_length;
};

struct _UsageGraphClass {
	GTypeClass parent_class;
	void (*finalize) (UsageGraph *self);
};

static gint UsagePerformanceGraphView_private_offset;
static gpointer usage_performance_graph_view_parent_class = NULL;

VALA_EXTERN GType usage_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphView, g_object_unref)
VALA_EXTERN GType usage_performance_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsagePerformanceGraphView, g_object_unref)
VALA_EXTERN GType usage_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSettings, g_object_unref)
VALA_EXTERN void usage_performance_graph_view_update_graphs (UsagePerformanceGraphView* self);
VALA_EXTERN UsageSettings* usage_settings_get_default (void);
static void usage_performance_graph_view_reevaluate_constant_redraw (UsagePerformanceGraphView* self);
VALA_EXTERN gboolean usage_settings_get_enable_scrolling_graph (UsageSettings* self);
static gboolean ___lambda18_ (UsagePerformanceGraphView* self);
VALA_EXTERN void usage_performance_graph_view_update_x_offset (UsagePerformanceGraphView* self);
static gboolean ____lambda18__gtk_tick_callback (GtkWidget* widget,
                                          GdkFrameClock* frame_clock,
                                          gpointer self);
VALA_EXTERN gpointer usage_graph_ref (gpointer instance);
VALA_EXTERN void usage_graph_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_graph (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_graph (GValue* value,
                            gpointer v_object);
VALA_EXTERN void usage_value_take_graph (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_graph (const GValue* value);
VALA_EXTERN GType usage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraph, usage_graph_unref)
VALA_EXTERN void usage_performance_graph_view_add_graph (UsagePerformanceGraphView* self,
                                             UsageGraph* graph);
VALA_EXTERN guint usage_settings_get_graph_timespan (UsageSettings* self);
VALA_EXTERN guint usage_settings_get_graph_update_interval (UsageSettings* self);
VALA_EXTERN GType usage_graph_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageGraphPoint* usage_graph_point_dup (const UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_free (UsageGraphPoint* self);
VALA_EXTERN void usage_graph_view_add_graph (UsageGraphView* self,
                                 UsageGraph* graph);
VALA_EXTERN void usage_graph_view_set_offset_x (UsageGraphView* self,
                                    gint64 value);
static void usage_performance_graph_view_real_update_graphs (UsagePerformanceGraphView* self);
VALA_EXTERN UsagePerformanceGraphView* usage_performance_graph_view_construct (GType object_type);
VALA_EXTERN UsageGraphView* usage_graph_view_new (void);
VALA_EXTERN UsageGraphView* usage_graph_view_construct (GType object_type);
static GObject * usage_performance_graph_view_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
VALA_EXTERN void usage_graph_view_set_range_y (UsageGraphView* self,
                                   gint64 value);
VALA_EXTERN void usage_graph_view_set_offset_y (UsageGraphView* self,
                                    gint64 value);
VALA_EXTERN void usage_graph_view_set_range_x (UsageGraphView* self,
                                   gint64 value);
static gboolean _usage_performance_graph_view___lambda19_ (UsagePerformanceGraphView* self);
static gboolean __usage_performance_graph_view___lambda19__gsource_func (gpointer self);
static void usage_performance_graph_view_finalize (GObject * obj);
static GType usage_performance_graph_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_performance_graph_view_get_instance_private (UsagePerformanceGraphView* self)
{
	return G_STRUCT_MEMBER_P (self, UsagePerformanceGraphView_private_offset);
}

static gboolean
___lambda18_ (UsagePerformanceGraphView* self)
{
	gboolean result;
	usage_performance_graph_view_update_x_offset (self);
	result = self->priv->constant_redraw;
	return result;
}

static gboolean
____lambda18__gtk_tick_callback (GtkWidget* widget,
                                 GdkFrameClock* frame_clock,
                                 gpointer self)
{
	gboolean result;
	result = ___lambda18_ ((UsagePerformanceGraphView*) self);
	return result;
}

static void
usage_performance_graph_view_reevaluate_constant_redraw (UsagePerformanceGraphView* self)
{
	UsageSettings* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = usage_settings_get_enable_scrolling_graph (_tmp0_);
	_tmp2_ = _tmp1_;
	self->priv->constant_redraw = _tmp2_;
	if (self->priv->constant_redraw) {
		gtk_widget_add_tick_callback ((GtkWidget*) self, ____lambda18__gtk_tick_callback, g_object_ref (self), g_object_unref);
	}
}

void
usage_performance_graph_view_add_graph (UsagePerformanceGraphView* self,
                                        UsageGraph* graph)
{
	UsageSettings* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	UsageSettings* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (graph != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = usage_settings_get_graph_timespan (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->settings;
	_tmp4_ = usage_settings_get_graph_update_interval (_tmp3_);
	_tmp5_ = _tmp4_;
	graph->maximal_queue_length = (guint) (((gint) ceilf (((gfloat) _tmp2_) / _tmp5_)) + 2);
	usage_graph_view_add_graph (G_TYPE_CHECK_INSTANCE_CAST (self, USAGE_TYPE_GRAPH_VIEW, UsageGraphView), graph);
}

void
usage_performance_graph_view_update_x_offset (UsagePerformanceGraphView* self)
{
	gint64 timestamp = 0LL;
	gint64 offset = 0LL;
	UsageSettings* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	timestamp = g_get_monotonic_time ();
	_tmp0_ = self->priv->settings;
	_tmp1_ = usage_settings_get_graph_timespan (_tmp0_);
	_tmp2_ = _tmp1_;
	offset = timestamp - (1000 * _tmp2_);
	if (self->priv->constant_redraw) {
		UsageSettings* _tmp3_;
		guint _tmp4_;
		guint _tmp5_;
		_tmp3_ = self->priv->settings;
		_tmp4_ = usage_settings_get_graph_update_interval (_tmp3_);
		_tmp5_ = _tmp4_;
		offset -= (gint64) (1000 * _tmp5_);
	}
	usage_graph_view_set_offset_x ((UsageGraphView*) self, offset);
}

static void
usage_performance_graph_view_real_update_graphs (UsagePerformanceGraphView* self)
{
	g_critical ("Type `%s' does not implement abstract method `usage_performance_graph_view_update_graphs'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
usage_performance_graph_view_update_graphs (UsagePerformanceGraphView* self)
{
	UsagePerformanceGraphViewClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = USAGE_PERFORMANCE_GRAPH_VIEW_GET_CLASS (self);
	if (_klass_->update_graphs) {
		_klass_->update_graphs (self);
	}
}

UsagePerformanceGraphView*
usage_performance_graph_view_construct (GType object_type)
{
	UsagePerformanceGraphView * self = NULL;
	self = (UsagePerformanceGraphView*) usage_graph_view_construct (object_type);
	return self;
}

static gboolean
_usage_performance_graph_view___lambda19_ (UsagePerformanceGraphView* self)
{
	gboolean result;
	usage_performance_graph_view_update_graphs (self);
	usage_performance_graph_view_reevaluate_constant_redraw (self);
	if (!self->priv->constant_redraw) {
		usage_performance_graph_view_update_x_offset (self);
	}
	result = TRUE;
	return result;
}

static gboolean
__usage_performance_graph_view___lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = _usage_performance_graph_view___lambda19_ ((UsagePerformanceGraphView*) self);
	return result;
}

static GObject *
usage_performance_graph_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsagePerformanceGraphView * self;
	UsageSettings* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	UsageSettings* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	parent_class = G_OBJECT_CLASS (usage_performance_graph_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphView);
	usage_graph_view_set_range_y ((UsageGraphView*) self, (gint64) 100);
	usage_graph_view_set_offset_y ((UsageGraphView*) self, (gint64) 0);
	_tmp0_ = self->priv->settings;
	_tmp1_ = usage_settings_get_graph_timespan (_tmp0_);
	_tmp2_ = _tmp1_;
	usage_graph_view_set_range_x ((UsageGraphView*) self, (gint64) (1000 * _tmp2_));
	usage_performance_graph_view_update_x_offset (self);
	usage_performance_graph_view_reevaluate_constant_redraw (self);
	_tmp3_ = self->priv->settings;
	_tmp4_ = usage_settings_get_graph_update_interval (_tmp3_);
	_tmp5_ = _tmp4_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp5_, __usage_performance_graph_view___lambda19__gsource_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
usage_performance_graph_view_class_init (UsagePerformanceGraphViewClass * klass,
                                         gpointer klass_data)
{
	usage_performance_graph_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsagePerformanceGraphView_private_offset);
	((UsagePerformanceGraphViewClass *) klass)->update_graphs = (void (*) (UsagePerformanceGraphView*)) usage_performance_graph_view_real_update_graphs;
	G_OBJECT_CLASS (klass)->constructor = usage_performance_graph_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_performance_graph_view_finalize;
}

static void
usage_performance_graph_view_instance_init (UsagePerformanceGraphView * self,
                                            gpointer klass)
{
	UsageSettings* _tmp0_;
	self->priv = usage_performance_graph_view_get_instance_private (self);
	_tmp0_ = usage_settings_get_default ();
	self->priv->settings = _tmp0_;
}

static void
usage_performance_graph_view_finalize (GObject * obj)
{
	UsagePerformanceGraphView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphView);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (usage_performance_graph_view_parent_class)->finalize (obj);
}

static GType
usage_performance_graph_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsagePerformanceGraphViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_performance_graph_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsagePerformanceGraphView), 0, (GInstanceInitFunc) usage_performance_graph_view_instance_init, NULL };
	GType usage_performance_graph_view_type_id;
	usage_performance_graph_view_type_id = g_type_register_static (USAGE_TYPE_GRAPH_VIEW, "UsagePerformanceGraphView", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	UsagePerformanceGraphView_private_offset = g_type_add_instance_private (usage_performance_graph_view_type_id, sizeof (UsagePerformanceGraphViewPrivate));
	return usage_performance_graph_view_type_id;
}

GType
usage_performance_graph_view_get_type (void)
{
	static volatile gsize usage_performance_graph_view_type_id__once = 0;
	if (g_once_init_enter (&usage_performance_graph_view_type_id__once)) {
		GType usage_performance_graph_view_type_id;
		usage_performance_graph_view_type_id = usage_performance_graph_view_get_type_once ();
		g_once_init_leave (&usage_performance_graph_view_type_id__once, usage_performance_graph_view_type_id);
	}
	return usage_performance_graph_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

