/* memory-view.c generated by valac 0.56.16, the Vala compiler
 * generated from memory-view.vala, do not modify */

/* memory-view.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 * Copyright (C) 2024 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_VIEW (usage_view_get_type ())
#define USAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_VIEW, UsageView))
#define USAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_VIEW, UsageViewClass))
#define USAGE_IS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_VIEW))
#define USAGE_IS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_VIEW))
#define USAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_VIEW, UsageViewClass))

typedef struct _UsageView UsageView;
typedef struct _UsageViewClass UsageViewClass;
typedef struct _UsageViewPrivate UsageViewPrivate;

#define USAGE_TYPE_MEMORY_VIEW (usage_memory_view_get_type ())
#define USAGE_MEMORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_VIEW, UsageMemoryView))
#define USAGE_MEMORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_VIEW, UsageMemoryViewClass))
#define USAGE_IS_MEMORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_VIEW))
#define USAGE_IS_MEMORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_VIEW))
#define USAGE_MEMORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_VIEW, UsageMemoryViewClass))

typedef struct _UsageMemoryView UsageMemoryView;
typedef struct _UsageMemoryViewClass UsageMemoryViewClass;
typedef struct _UsageMemoryViewPrivate UsageMemoryViewPrivate;

#define USAGE_TYPE_PROCESS_LIST_BOX (usage_process_list_box_get_type ())
#define USAGE_PROCESS_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBox))
#define USAGE_PROCESS_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBoxClass))
#define USAGE_IS_PROCESS_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS_LIST_BOX))
#define USAGE_IS_PROCESS_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS_LIST_BOX))
#define USAGE_PROCESS_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS_LIST_BOX, UsageProcessListBoxClass))

typedef struct _UsageProcessListBox UsageProcessListBox;
typedef struct _UsageProcessListBoxClass UsageProcessListBoxClass;

#define USAGE_TYPE_NO_RESULTS_FOUND_VIEW (usage_no_results_found_view_get_type ())
#define USAGE_NO_RESULTS_FOUND_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_NO_RESULTS_FOUND_VIEW, UsageNoResultsFoundView))
#define USAGE_NO_RESULTS_FOUND_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_NO_RESULTS_FOUND_VIEW, UsageNoResultsFoundViewClass))
#define USAGE_IS_NO_RESULTS_FOUND_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_NO_RESULTS_FOUND_VIEW))
#define USAGE_IS_NO_RESULTS_FOUND_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_NO_RESULTS_FOUND_VIEW))
#define USAGE_NO_RESULTS_FOUND_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_NO_RESULTS_FOUND_VIEW, UsageNoResultsFoundViewClass))

typedef struct _UsageNoResultsFoundView UsageNoResultsFoundView;
typedef struct _UsageNoResultsFoundViewClass UsageNoResultsFoundViewClass;
enum  {
	USAGE_MEMORY_VIEW_0_PROPERTY,
	USAGE_MEMORY_VIEW_NUM_PROPERTIES
};
static GParamSpec* usage_memory_view_properties[USAGE_MEMORY_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define USAGE_TYPE_SYSTEM_MONITOR (usage_system_monitor_get_type ())
#define USAGE_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor))
#define USAGE_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))
#define USAGE_IS_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_IS_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_SYSTEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))

typedef struct _UsageSystemMonitor UsageSystemMonitor;
typedef struct _UsageSystemMonitorClass UsageSystemMonitorClass;
typedef struct _Block4Data Block4Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define USAGE_TYPE_GRAPH_VIEW (usage_graph_view_get_type ())
#define USAGE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphView))
#define USAGE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))
#define USAGE_IS_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_IS_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))

typedef struct _UsageGraphView UsageGraphView;
typedef struct _UsageGraphViewClass UsageGraphViewClass;

#define USAGE_TYPE_PERFORMANCE_GRAPH_VIEW (usage_performance_graph_view_get_type ())
#define USAGE_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphView))
#define USAGE_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_PERFORMANCE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))

typedef struct _UsagePerformanceGraphView UsagePerformanceGraphView;
typedef struct _UsagePerformanceGraphViewClass UsagePerformanceGraphViewClass;

#define USAGE_TYPE_MEMORY_GRAPH (usage_memory_graph_get_type ())
#define USAGE_MEMORY_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_GRAPH, UsageMemoryGraph))
#define USAGE_MEMORY_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_GRAPH, UsageMemoryGraphClass))
#define USAGE_IS_MEMORY_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_GRAPH))
#define USAGE_IS_MEMORY_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_GRAPH))
#define USAGE_MEMORY_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_GRAPH, UsageMemoryGraphClass))

typedef struct _UsageMemoryGraph UsageMemoryGraph;
typedef struct _UsageMemoryGraphClass UsageMemoryGraphClass;

#define USAGE_TYPE_GRAPH_BOX (usage_graph_box_get_type ())
#define USAGE_GRAPH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_BOX, UsageGraphBox))
#define USAGE_GRAPH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_BOX, UsageGraphBoxClass))
#define USAGE_IS_GRAPH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_BOX))
#define USAGE_IS_GRAPH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_BOX))
#define USAGE_GRAPH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_BOX, UsageGraphBoxClass))

typedef struct _UsageGraphBox UsageGraphBox;
typedef struct _UsageGraphBoxClass UsageGraphBoxClass;

#define USAGE_TYPE_APP_ITEM (usage_app_item_get_type ())
#define USAGE_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_APP_ITEM, UsageAppItem))
#define USAGE_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_APP_ITEM, UsageAppItemClass))
#define USAGE_IS_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_APP_ITEM))
#define USAGE_IS_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_APP_ITEM))
#define USAGE_APP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_APP_ITEM, UsageAppItemClass))

typedef struct _UsageAppItem UsageAppItem;
typedef struct _UsageAppItemClass UsageAppItemClass;

#define USAGE_TYPE_SETTINGS (usage_settings_get_type ())
#define USAGE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SETTINGS, UsageSettings))
#define USAGE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SETTINGS, UsageSettingsClass))
#define USAGE_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SETTINGS))
#define USAGE_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SETTINGS))
#define USAGE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SETTINGS, UsageSettingsClass))

typedef struct _UsageSettings UsageSettings;
typedef struct _UsageSettingsClass UsageSettingsClass;

#define USAGE_TYPE_PROCESS_LIST_BOX_TYPE (usage_process_list_box_type_get_type ())
typedef struct _UsageProcessListBoxType UsageProcessListBoxType;
typedef gboolean (*UsageFilterFunc) (gconstpointer object, gpointer user_data);
typedef GtkWidget* (*UsageWidgetFactoryFunc) (gconstpointer object, gpointer user_data);

#define USAGE_TYPE_MEMORY_SPEEDOMETER (usage_memory_speedometer_get_type ())
#define USAGE_MEMORY_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometer))
#define USAGE_MEMORY_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometerClass))
#define USAGE_IS_MEMORY_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_SPEEDOMETER))
#define USAGE_IS_MEMORY_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_SPEEDOMETER))
#define USAGE_MEMORY_SPEEDOMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometerClass))

typedef struct _UsageMemorySpeedometer UsageMemorySpeedometer;
typedef struct _UsageMemorySpeedometerClass UsageMemorySpeedometerClass;

#define USAGE_TYPE_SWAP_SPEEDOMETER (usage_swap_speedometer_get_type ())
#define USAGE_SWAP_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SWAP_SPEEDOMETER, UsageSwapSpeedometer))
#define USAGE_SWAP_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SWAP_SPEEDOMETER, UsageSwapSpeedometerClass))
#define USAGE_IS_SWAP_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SWAP_SPEEDOMETER))
#define USAGE_IS_SWAP_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SWAP_SPEEDOMETER))
#define USAGE_SWAP_SPEEDOMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SWAP_SPEEDOMETER, UsageSwapSpeedometerClass))

typedef struct _UsageSwapSpeedometer UsageSwapSpeedometer;
typedef struct _UsageSwapSpeedometerClass UsageSwapSpeedometerClass;

struct _UsageView {
	AdwBreakpointBin parent_instance;
	UsageViewPrivate * priv;
	gchar* title;
	gchar* icon_name;
	GtkWidget* switcher_widget;
	gboolean search_available;
};

struct _UsageViewClass {
	AdwBreakpointBinClass parent_class;
	void (*set_search_text) (UsageView* self, const gchar* query);
};

struct _UsageMemoryView {
	UsageView parent_instance;
	UsageMemoryViewPrivate * priv;
};

struct _UsageMemoryViewClass {
	UsageViewClass parent_class;
};

struct _UsageMemoryViewPrivate {
	UsageProcessListBox* process_list_box;
	UsageNoResultsFoundView* no_process_view;
	GtkBox* memory_box;
};

struct _Block4Data {
	int _ref_count_;
	UsageMemoryView* self;
	GtkSpinner* spinner;
	UsageSystemMonitor* system_monitor;
};

struct _UsageProcessListBoxType {
	GCompareDataFunc comparator;
	gpointer comparator_target;
	UsageFilterFunc filter;
	gpointer filter_target;
	UsageWidgetFactoryFunc load_widget_factory;
	gpointer load_widget_factory_target;
};

static gint UsageMemoryView_private_offset;
static gpointer usage_memory_view_parent_class = NULL;

VALA_EXTERN GType usage_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageView, g_object_unref)
VALA_EXTERN GType usage_memory_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemoryView, g_object_unref)
VALA_EXTERN GType usage_process_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcessListBox, g_object_unref)
VALA_EXTERN GType usage_no_results_found_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageNoResultsFoundView, g_object_unref)
VALA_EXTERN void usage_view_set_search_text (UsageView* self,
                                 const gchar* query);
VALA_EXTERN UsageMemoryView* usage_memory_view_new (void);
VALA_EXTERN UsageMemoryView* usage_memory_view_construct (GType object_type);
VALA_EXTERN GType usage_system_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSystemMonitor, g_object_unref)
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN UsageView* usage_view_construct (GType object_type);
VALA_EXTERN UsageMemoryGraph* usage_memory_graph_new (void);
VALA_EXTERN UsageMemoryGraph* usage_memory_graph_construct (GType object_type);
VALA_EXTERN GType usage_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphView, g_object_unref)
VALA_EXTERN GType usage_performance_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsagePerformanceGraphView, g_object_unref)
VALA_EXTERN GType usage_memory_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemoryGraph, g_object_unref)
VALA_EXTERN UsageGraphBox* usage_graph_box_new (UsageGraphView* graph);
VALA_EXTERN UsageGraphBox* usage_graph_box_construct (GType object_type,
                                          UsageGraphView* graph);
VALA_EXTERN GType usage_graph_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphBox, g_object_unref)
VALA_EXTERN GType usage_app_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageAppItem, g_object_unref)
static gint __lambda24_ (UsageMemoryView* self,
                  UsageAppItem* a,
                  UsageAppItem* b);
VALA_EXTERN guint64 usage_app_item_get_mem_usage (UsageAppItem* self);
static gint ___lambda24__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gboolean __lambda25_ (UsageMemoryView* self,
                      UsageAppItem* item);
VALA_EXTERN GType usage_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSettings, g_object_unref)
VALA_EXTERN UsageSettings* usage_settings_get_default (void);
VALA_EXTERN gdouble usage_settings_get_app_minimum_memory (UsageSettings* self);
static gboolean ___lambda25__usage_filter_func (gconstpointer object,
                                         gpointer self);
static GtkWidget* __lambda26_ (UsageMemoryView* self,
                        UsageAppItem* item);
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
static GtkWidget* ___lambda26__usage_widget_factory_func (gconstpointer object,
                                                   gpointer self);
VALA_EXTERN GType usage_process_list_box_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageProcessListBoxType* usage_process_list_box_type_dup (const UsageProcessListBoxType* self);
VALA_EXTERN void usage_process_list_box_type_free (UsageProcessListBoxType* self);
VALA_EXTERN UsageProcessListBox* usage_process_list_box_new (UsageProcessListBoxType* type);
VALA_EXTERN UsageProcessListBox* usage_process_list_box_construct (GType object_type,
                                                       UsageProcessListBoxType* type);
static void _gtk_spinner_start_gtk_widget_map (GtkWidget* _sender,
                                        gpointer self);
static void _gtk_spinner_stop_gtk_widget_unmap (GtkWidget* _sender,
                                         gpointer self);
VALA_EXTERN UsageNoResultsFoundView* usage_no_results_found_view_new (void);
VALA_EXTERN UsageNoResultsFoundView* usage_no_results_found_view_construct (GType object_type);
VALA_EXTERN GType usage_memory_speedometer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemorySpeedometer, g_object_unref)
VALA_EXTERN UsageMemorySpeedometer* usage_memory_speedometer_new (void);
VALA_EXTERN UsageMemorySpeedometer* usage_memory_speedometer_construct (GType object_type);
VALA_EXTERN GType usage_swap_speedometer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSwapSpeedometer, g_object_unref)
VALA_EXTERN UsageSwapSpeedometer* usage_swap_speedometer_new (void);
VALA_EXTERN UsageSwapSpeedometer* usage_swap_speedometer_construct (GType object_type);
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_get_default (void);
static void __lambda29_ (Block4Data* _data4_,
                  GObject* sender,
                  GParamSpec* property);
VALA_EXTERN gboolean usage_system_monitor_get_process_list_ready (UsageSystemMonitor* self);
static void ___lambda29__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void usage_memory_view_real_set_search_text (UsageView* base,
                                             const gchar* query);
VALA_EXTERN void usage_process_list_box_set_search_text (UsageProcessListBox* self,
                                             const gchar* value);
static void usage_memory_view_finalize (GObject * obj);
static GType usage_memory_view_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_memory_view_get_instance_private (UsageMemoryView* self)
{
	return G_STRUCT_MEMBER_P (self, UsageMemoryView_private_offset);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		UsageMemoryView* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->system_monitor);
		_g_object_unref0 (_data4_->spinner);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gint
__lambda24_ (UsageMemoryView* self,
             UsageAppItem* a,
             UsageAppItem* b)
{
	guint64 _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
	guint64 _tmp4_;
	guint64 _tmp5_;
	guint64 _tmp6_;
	guint64 _tmp7_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = usage_app_item_get_mem_usage (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = usage_app_item_get_mem_usage (b);
	_tmp3_ = _tmp2_;
	_tmp4_ = usage_app_item_get_mem_usage (a);
	_tmp5_ = _tmp4_;
	_tmp6_ = usage_app_item_get_mem_usage (b);
	_tmp7_ = _tmp6_;
	result = (gint) (((guint64) (_tmp1_ < _tmp3_)) - ((guint64) (_tmp5_ > _tmp7_)));
	return result;
}

static gint
___lambda24__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda24_ ((UsageMemoryView*) self, (UsageAppItem*) a, (UsageAppItem*) b);
	return result;
}

static gboolean
__lambda25_ (UsageMemoryView* self,
             UsageAppItem* item)
{
	guint64 _tmp0_;
	guint64 _tmp1_;
	UsageSettings* _tmp2_;
	UsageSettings* _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gboolean _tmp6_;
	gboolean result;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = usage_app_item_get_mem_usage (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = usage_settings_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = usage_settings_get_app_minimum_memory (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = ((gdouble) _tmp1_) > _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

static gboolean
___lambda25__usage_filter_func (gconstpointer object,
                                gpointer self)
{
	gboolean result;
	result = __lambda25_ ((UsageMemoryView*) self, (UsageAppItem*) object);
	return result;
}

static GtkWidget*
__lambda26_ (UsageMemoryView* self,
             UsageAppItem* item)
{
	GtkLabel* load_label = NULL;
	guint64 _tmp0_;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkWidget* result;
	g_return_val_if_fail (item != NULL, NULL);
	_tmp0_ = usage_app_item_get_mem_usage (item);
	_tmp1_ = _tmp0_;
	_tmp2_ = usage_utils_format_size_values (_tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	load_label = _tmp5_;
	gtk_label_set_ellipsize (load_label, PANGO_ELLIPSIZE_END);
	gtk_label_set_max_width_chars (load_label, 30);
	result = (GtkWidget*) load_label;
	return result;
}

static GtkWidget*
___lambda26__usage_widget_factory_func (gconstpointer object,
                                        gpointer self)
{
	GtkWidget* result;
	result = __lambda26_ ((UsageMemoryView*) self, (UsageAppItem*) object);
	return result;
}

static void
_gtk_spinner_start_gtk_widget_map (GtkWidget* _sender,
                                   gpointer self)
{
	gtk_spinner_start ((GtkSpinner*) self);
}

static void
_gtk_spinner_stop_gtk_widget_unmap (GtkWidget* _sender,
                                    gpointer self)
{
	gtk_spinner_stop ((GtkSpinner*) self);
}

static void
__lambda29_ (Block4Data* _data4_,
             GObject* sender,
             GParamSpec* property)
{
	UsageMemoryView* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data4_->self;
	g_return_if_fail (sender != NULL);
	g_return_if_fail (property != NULL);
	_tmp0_ = usage_system_monitor_get_process_list_ready (_data4_->system_monitor);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkBox* _tmp2_;
		UsageProcessListBox* _tmp3_;
		GtkBox* _tmp4_;
		_tmp2_ = self->priv->memory_box;
		_tmp3_ = self->priv->process_list_box;
		gtk_box_append (_tmp2_, (GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->memory_box;
		gtk_box_remove (_tmp4_, (GtkWidget*) _data4_->spinner);
	} else {
		GtkBox* _tmp5_;
		GtkBox* _tmp6_;
		UsageProcessListBox* _tmp7_;
		_tmp5_ = self->priv->memory_box;
		gtk_box_append (_tmp5_, (GtkWidget*) _data4_->spinner);
		_tmp6_ = self->priv->memory_box;
		_tmp7_ = self->priv->process_list_box;
		gtk_box_remove (_tmp6_, (GtkWidget*) _tmp7_);
	}
}

static void
___lambda29__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda29_ (self, _sender, pspec);
}

UsageMemoryView*
usage_memory_view_construct (GType object_type)
{
	UsageMemoryView * self = NULL;
	Block4Data* _data4_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	UsageMemoryGraph* _tmp2_;
	UsageMemoryGraph* _tmp3_;
	UsageGraphBox* _tmp4_;
	GtkWidget* _tmp5_;
	UsageProcessListBoxType _tmp6_ = {0};
	UsageProcessListBox* _tmp7_;
	GtkSpinner* _tmp8_;
	UsageNoResultsFoundView* _tmp9_;
	UsageMemorySpeedometer* memory_graph = NULL;
	UsageMemorySpeedometer* _tmp10_;
	UsageSwapSpeedometer* swap_graph = NULL;
	UsageSwapSpeedometer* _tmp11_;
	GtkBox* speedometers = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkBox* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	UsageNoResultsFoundView* _tmp16_;
	UsageSystemMonitor* _tmp17_;
	UsageProcessListBox* _tmp18_;
	UsageNoResultsFoundView* _tmp19_;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	self = (UsageMemoryView*) usage_view_construct (object_type);
	_data4_->self = g_object_ref (self);
	gtk_widget_set_name ((GtkWidget*) self, "MEMORY");
	_tmp0_ = g_strdup (_ ("Memory"));
	_g_free0 (((UsageView*) self)->title);
	((UsageView*) self)->title = _tmp0_;
	_tmp1_ = g_strdup ("memory-symbolic");
	_g_free0 (((UsageView*) self)->icon_name);
	((UsageView*) self)->icon_name = _tmp1_;
	((UsageView*) self)->search_available = TRUE;
	_tmp2_ = usage_memory_graph_new ();
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = usage_graph_box_new ((UsageGraphView*) _tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (((UsageView*) self)->switcher_widget);
	((UsageView*) self)->switcher_widget = (GtkWidget*) _tmp4_;
	_g_object_unref0 (_tmp3_);
	_tmp5_ = ((UsageView*) self)->switcher_widget;
	g_object_set (_tmp5_, "height-request", 80, NULL);
	memset (&_tmp6_, 0, sizeof (UsageProcessListBoxType));
	_tmp6_.comparator = ___lambda24__gcompare_data_func;
	_tmp6_.comparator_target = self;
	_tmp6_.filter = ___lambda25__usage_filter_func;
	_tmp6_.filter_target = self;
	_tmp6_.load_widget_factory = ___lambda26__usage_widget_factory_func;
	_tmp6_.load_widget_factory_target = self;
	_tmp7_ = usage_process_list_box_new (&_tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->process_list_box);
	self->priv->process_list_box = _tmp7_;
	_tmp8_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp8_);
	_data4_->spinner = _tmp8_;
	g_signal_connect_object ((GtkWidget*) _data4_->spinner, "map", (GCallback) _gtk_spinner_start_gtk_widget_map, _data4_->spinner, 0);
	g_signal_connect_object ((GtkWidget*) _data4_->spinner, "unmap", (GCallback) _gtk_spinner_stop_gtk_widget_unmap, _data4_->spinner, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _data4_->spinner, 30);
	g_object_set ((GtkWidget*) _data4_->spinner, "height-request", 250, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _data4_->spinner, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _data4_->spinner, GTK_ALIGN_CENTER);
	_tmp9_ = usage_no_results_found_view_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->no_process_view);
	self->priv->no_process_view = _tmp9_;
	_tmp10_ = usage_memory_speedometer_new ();
	g_object_ref_sink (_tmp10_);
	memory_graph = _tmp10_;
	_tmp11_ = usage_swap_speedometer_new ();
	g_object_ref_sink (_tmp11_);
	swap_graph = _tmp11_;
	gtk_widget_set_valign ((GtkWidget*) swap_graph, GTK_ALIGN_END);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp12_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp12_, 6);
	g_object_ref_sink (_tmp12_);
	speedometers = _tmp12_;
	gtk_box_append (speedometers, (GtkWidget*) memory_graph);
	gtk_box_append (speedometers, (GtkWidget*) swap_graph);
	_tmp13_ = self->priv->memory_box;
	gtk_box_append (_tmp13_, (GtkWidget*) speedometers);
	_tmp14_ = self->priv->memory_box;
	gtk_box_append (_tmp14_, (GtkWidget*) _data4_->spinner);
	_tmp15_ = self->priv->memory_box;
	_tmp16_ = self->priv->no_process_view;
	gtk_box_append (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = usage_system_monitor_get_default ();
	_data4_->system_monitor = _tmp17_;
	g_signal_connect_data ((GObject*) _data4_->system_monitor, "notify::process-list-ready", (GCallback) ___lambda29__g_object_notify, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp18_ = self->priv->process_list_box;
	_tmp19_ = self->priv->no_process_view;
	g_object_bind_property_with_closures ((GObject*) _tmp18_, "empty", (GObject*) _tmp19_, "visible", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (speedometers);
	_g_object_unref0 (swap_graph);
	_g_object_unref0 (memory_graph);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

UsageMemoryView*
usage_memory_view_new (void)
{
	return usage_memory_view_construct (USAGE_TYPE_MEMORY_VIEW);
}

static void
usage_memory_view_real_set_search_text (UsageView* base,
                                        const gchar* query)
{
	UsageMemoryView * self;
	UsageProcessListBox* _tmp0_;
	self = (UsageMemoryView*) base;
	g_return_if_fail (query != NULL);
	_tmp0_ = self->priv->process_list_box;
	usage_process_list_box_set_search_text (_tmp0_, query);
}

static void
usage_memory_view_class_init (UsageMemoryViewClass * klass,
                              gpointer klass_data)
{
	usage_memory_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageMemoryView_private_offset);
	((UsageViewClass *) klass)->set_search_text = (void (*) (UsageView*, const gchar*)) usage_memory_view_real_set_search_text;
	G_OBJECT_CLASS (klass)->finalize = usage_memory_view_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/memory-view.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "memory_box", FALSE, UsageMemoryView_private_offset + G_STRUCT_OFFSET (UsageMemoryViewPrivate, memory_box));
}

static void
usage_memory_view_instance_init (UsageMemoryView * self,
                                 gpointer klass)
{
	self->priv = usage_memory_view_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_memory_view_finalize (GObject * obj)
{
	UsageMemoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_MEMORY_VIEW, UsageMemoryView);
	_g_object_unref0 (self->priv->process_list_box);
	_g_object_unref0 (self->priv->no_process_view);
	G_OBJECT_CLASS (usage_memory_view_parent_class)->finalize (obj);
}

static GType
usage_memory_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageMemoryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_memory_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMemoryView), 0, (GInstanceInitFunc) usage_memory_view_instance_init, NULL };
	GType usage_memory_view_type_id;
	usage_memory_view_type_id = g_type_register_static (USAGE_TYPE_VIEW, "UsageMemoryView", &g_define_type_info, 0);
	UsageMemoryView_private_offset = g_type_add_instance_private (usage_memory_view_type_id, sizeof (UsageMemoryViewPrivate));
	return usage_memory_view_type_id;
}

GType
usage_memory_view_get_type (void)
{
	static volatile gsize usage_memory_view_type_id__once = 0;
	if (g_once_init_enter (&usage_memory_view_type_id__once)) {
		GType usage_memory_view_type_id;
		usage_memory_view_type_id = usage_memory_view_get_type_once ();
		g_once_init_leave (&usage_memory_view_type_id__once, usage_memory_view_type_id);
	}
	return usage_memory_view_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

