/* memory-speedometer.c generated by valac 0.56.16, the Vala compiler
 * generated from memory-speedometer.vala, do not modify */

/* memory-speedometer.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Felipe Borges <felipeborges@gnome.org>
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_MEMORY_SPEEDOMETER (usage_memory_speedometer_get_type ())
#define USAGE_MEMORY_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometer))
#define USAGE_MEMORY_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometerClass))
#define USAGE_IS_MEMORY_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_SPEEDOMETER))
#define USAGE_IS_MEMORY_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_SPEEDOMETER))
#define USAGE_MEMORY_SPEEDOMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometerClass))

typedef struct _UsageMemorySpeedometer UsageMemorySpeedometer;
typedef struct _UsageMemorySpeedometerClass UsageMemorySpeedometerClass;
typedef struct _UsageMemorySpeedometerPrivate UsageMemorySpeedometerPrivate;

#define USAGE_TYPE_SPEEDOMETER (usage_speedometer_get_type ())
#define USAGE_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SPEEDOMETER, UsageSpeedometer))
#define USAGE_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SPEEDOMETER, UsageSpeedometerClass))
#define USAGE_IS_SPEEDOMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SPEEDOMETER))
#define USAGE_IS_SPEEDOMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SPEEDOMETER))
#define USAGE_SPEEDOMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SPEEDOMETER, UsageSpeedometerClass))

typedef struct _UsageSpeedometer UsageSpeedometer;
typedef struct _UsageSpeedometerClass UsageSpeedometerClass;
enum  {
	USAGE_MEMORY_SPEEDOMETER_0_PROPERTY,
	USAGE_MEMORY_SPEEDOMETER_NUM_PROPERTIES
};
static GParamSpec* usage_memory_speedometer_properties[USAGE_MEMORY_SPEEDOMETER_NUM_PROPERTIES];

#define USAGE_TYPE_SYSTEM_MONITOR (usage_system_monitor_get_type ())
#define USAGE_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor))
#define USAGE_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))
#define USAGE_IS_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_IS_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_SYSTEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))

typedef struct _UsageSystemMonitor UsageSystemMonitor;
typedef struct _UsageSystemMonitorClass UsageSystemMonitorClass;
typedef struct _Block3Data Block3Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _UsageMemorySpeedometer {
	AdwBin parent_instance;
	UsageMemorySpeedometerPrivate * priv;
};

struct _UsageMemorySpeedometerClass {
	AdwBinClass parent_class;
};

struct _UsageMemorySpeedometerPrivate {
	UsageSpeedometer* speedometer;
	GtkLabel* label;
	GtkLabel* ram_used;
	GtkLabel* ram_available;
	gdouble _ram_usage;
};

struct _Block3Data {
	int _ref_count_;
	UsageMemorySpeedometer* self;
	UsageSystemMonitor* monitor;
};

static gint UsageMemorySpeedometer_private_offset;
static gpointer usage_memory_speedometer_parent_class = NULL;

VALA_EXTERN GType usage_memory_speedometer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemorySpeedometer, g_object_unref)
VALA_EXTERN GType usage_speedometer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSpeedometer, g_object_unref)
VALA_EXTERN UsageMemorySpeedometer* usage_memory_speedometer_new (void);
VALA_EXTERN UsageMemorySpeedometer* usage_memory_speedometer_construct (GType object_type);
static gdouble usage_memory_speedometer_get_ram_usage (UsageMemorySpeedometer* self);
static void usage_memory_speedometer_set_ram_usage (UsageMemorySpeedometer* self,
                                             gdouble value);
static GObject * usage_memory_speedometer_constructor (GType type,
                                                guint n_construct_properties,
                                                GObjectConstructParam * construct_properties);
VALA_EXTERN GType usage_system_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSystemMonitor, g_object_unref)
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_get_default (void);
static gboolean _usage_memory_speedometer___lambda27_ (Block3Data* _data3_);
VALA_EXTERN guint64 usage_system_monitor_get_ram_usage (UsageSystemMonitor* self);
VALA_EXTERN guint64 usage_system_monitor_get_ram_total (UsageSystemMonitor* self);
VALA_EXTERN void usage_speedometer_set_percentage (UsageSpeedometer* self,
                                       gint value);
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
static gboolean __usage_memory_speedometer___lambda27__gsource_func (gpointer self);
static void usage_memory_speedometer_finalize (GObject * obj);
static GType usage_memory_speedometer_get_type_once (void);
static void _vala_usage_memory_speedometer_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_usage_memory_speedometer_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_memory_speedometer_get_instance_private (UsageMemorySpeedometer* self)
{
	return G_STRUCT_MEMBER_P (self, UsageMemorySpeedometer_private_offset);
}

UsageMemorySpeedometer*
usage_memory_speedometer_construct (GType object_type)
{
	UsageMemorySpeedometer * self = NULL;
	self = (UsageMemorySpeedometer*) g_object_new (object_type, NULL);
	return self;
}

UsageMemorySpeedometer*
usage_memory_speedometer_new (void)
{
	return usage_memory_speedometer_construct (USAGE_TYPE_MEMORY_SPEEDOMETER);
}

static gdouble
usage_memory_speedometer_get_ram_usage (UsageMemorySpeedometer* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_ram_usage;
	return result;
}

static void
usage_memory_speedometer_set_ram_usage (UsageMemorySpeedometer* self,
                                        gdouble value)
{
	g_return_if_fail (self != NULL);
	self->priv->_ram_usage = value;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		UsageMemorySpeedometer* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->monitor);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
_usage_memory_speedometer___lambda27_ (Block3Data* _data3_)
{
	UsageMemorySpeedometer* self;
	gdouble percentage = 0.0;
	UsageSystemMonitor* _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	UsageSystemMonitor* _tmp3_;
	guint64 _tmp4_;
	guint64 _tmp5_;
	UsageSpeedometer* _tmp6_;
	GtkLabel* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	guint64 available = 0ULL;
	UsageSystemMonitor* _tmp12_;
	guint64 _tmp13_;
	guint64 _tmp14_;
	UsageSystemMonitor* _tmp15_;
	guint64 _tmp16_;
	guint64 _tmp17_;
	GtkLabel* _tmp18_;
	UsageSystemMonitor* _tmp19_;
	guint64 _tmp20_;
	guint64 _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GtkLabel* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = _data3_->monitor;
	_tmp1_ = usage_system_monitor_get_ram_usage (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data3_->monitor;
	_tmp4_ = usage_system_monitor_get_ram_total (_tmp3_);
	_tmp5_ = _tmp4_;
	percentage = (((gdouble) _tmp2_) / _tmp5_) * 100;
	_tmp6_ = self->priv->speedometer;
	usage_speedometer_set_percentage (_tmp6_, (gint) percentage);
	_tmp7_ = self->priv->label;
	_tmp8_ = g_strdup_printf ("%d", (gint) percentage);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "%", NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_label (_tmp7_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = _data3_->monitor;
	_tmp13_ = usage_system_monitor_get_ram_total (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _data3_->monitor;
	_tmp16_ = usage_system_monitor_get_ram_usage (_tmp15_);
	_tmp17_ = _tmp16_;
	available = _tmp14_ - _tmp17_;
	_tmp18_ = self->priv->ram_used;
	_tmp19_ = _data3_->monitor;
	_tmp20_ = usage_system_monitor_get_ram_usage (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = usage_utils_format_size_values (_tmp21_, NULL);
	_tmp23_ = _tmp22_;
	gtk_label_set_label (_tmp18_, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = self->priv->ram_available;
	_tmp25_ = usage_utils_format_size_values (available, NULL);
	_tmp26_ = _tmp25_;
	gtk_label_set_label (_tmp24_, _tmp26_);
	_g_free0 (_tmp26_);
	result = TRUE;
	return result;
}

static gboolean
__usage_memory_speedometer___lambda27__gsource_func (gpointer self)
{
	gboolean result;
	result = _usage_memory_speedometer___lambda27_ (self);
	return result;
}

static GObject *
usage_memory_speedometer_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageMemorySpeedometer * self;
	Block3Data* _data3_;
	UsageSystemMonitor* _tmp0_;
	parent_class = G_OBJECT_CLASS (usage_memory_speedometer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometer);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = usage_system_monitor_get_default ();
	_data3_->monitor = _tmp0_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, __usage_memory_speedometer___lambda27__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return obj;
}

static void
usage_memory_speedometer_class_init (UsageMemorySpeedometerClass * klass,
                                     gpointer klass_data)
{
	usage_memory_speedometer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageMemorySpeedometer_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_memory_speedometer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_memory_speedometer_set_property;
	G_OBJECT_CLASS (klass)->constructor = usage_memory_speedometer_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_memory_speedometer_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Usage/ui/memory-speedometer.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "speedometer", FALSE, UsageMemorySpeedometer_private_offset + G_STRUCT_OFFSET (UsageMemorySpeedometerPrivate, speedometer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, UsageMemorySpeedometer_private_offset + G_STRUCT_OFFSET (UsageMemorySpeedometerPrivate, label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ram_used", FALSE, UsageMemorySpeedometer_private_offset + G_STRUCT_OFFSET (UsageMemorySpeedometerPrivate, ram_used));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "ram_available", FALSE, UsageMemorySpeedometer_private_offset + G_STRUCT_OFFSET (UsageMemorySpeedometerPrivate, ram_available));
}

static void
usage_memory_speedometer_instance_init (UsageMemorySpeedometer * self,
                                        gpointer klass)
{
	self->priv = usage_memory_speedometer_get_instance_private (self);
	g_type_ensure (USAGE_TYPE_SPEEDOMETER);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
usage_memory_speedometer_finalize (GObject * obj)
{
	UsageMemorySpeedometer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometer);
	G_OBJECT_CLASS (usage_memory_speedometer_parent_class)->finalize (obj);
}

static GType
usage_memory_speedometer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageMemorySpeedometerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_memory_speedometer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMemorySpeedometer), 0, (GInstanceInitFunc) usage_memory_speedometer_instance_init, NULL };
	GType usage_memory_speedometer_type_id;
	usage_memory_speedometer_type_id = g_type_register_static (adw_bin_get_type (), "UsageMemorySpeedometer", &g_define_type_info, 0);
	UsageMemorySpeedometer_private_offset = g_type_add_instance_private (usage_memory_speedometer_type_id, sizeof (UsageMemorySpeedometerPrivate));
	return usage_memory_speedometer_type_id;
}

GType
usage_memory_speedometer_get_type (void)
{
	static volatile gsize usage_memory_speedometer_type_id__once = 0;
	if (g_once_init_enter (&usage_memory_speedometer_type_id__once)) {
		GType usage_memory_speedometer_type_id;
		usage_memory_speedometer_type_id = usage_memory_speedometer_get_type_once ();
		g_once_init_leave (&usage_memory_speedometer_type_id__once, usage_memory_speedometer_type_id);
	}
	return usage_memory_speedometer_type_id__once;
}

static void
_vala_usage_memory_speedometer_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	UsageMemorySpeedometer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometer);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_memory_speedometer_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	UsageMemorySpeedometer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_MEMORY_SPEEDOMETER, UsageMemorySpeedometer);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

