/* memory-monitor.c generated by valac 0.56.16, the Vala compiler
 * generated from memory-monitor.vala, do not modify */

/* memory-monitor.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <glibtop/mem.h>
#include <glibtop.h>
#include <glibtop/swap.h>
#include <glibtop/procmem.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_MONITOR (usage_monitor_get_type ())
#define USAGE_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MONITOR, UsageMonitor))
#define USAGE_IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MONITOR))
#define USAGE_MONITOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_TYPE_MONITOR, UsageMonitorIface))

typedef struct _UsageMonitor UsageMonitor;
typedef struct _UsageMonitorIface UsageMonitorIface;

#define USAGE_TYPE_PROCESS (usage_process_get_type ())
#define USAGE_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS, UsageProcess))
#define USAGE_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS, UsageProcessClass))
#define USAGE_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS))
#define USAGE_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS))
#define USAGE_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS, UsageProcessClass))

typedef struct _UsageProcess UsageProcess;
typedef struct _UsageProcessClass UsageProcessClass;

#define USAGE_TYPE_MEMORY_MONITOR (usage_memory_monitor_get_type ())
#define USAGE_MEMORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_MONITOR, UsageMemoryMonitor))
#define USAGE_MEMORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_MONITOR, UsageMemoryMonitorClass))
#define USAGE_IS_MEMORY_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_MONITOR))
#define USAGE_IS_MEMORY_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_MONITOR))
#define USAGE_MEMORY_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_MONITOR, UsageMemoryMonitorClass))

typedef struct _UsageMemoryMonitor UsageMemoryMonitor;
typedef struct _UsageMemoryMonitorClass UsageMemoryMonitorClass;
typedef struct _UsageMemoryMonitorPrivate UsageMemoryMonitorPrivate;
typedef struct _UsageParamSpecMemoryMonitor UsageParamSpecMemoryMonitor;

struct _UsageMonitorIface {
	GTypeInterface parent_iface;
	void (*update) (UsageMonitor* self);
	void (*update_process) (UsageMonitor* self, UsageProcess** process);
};

struct _UsageMemoryMonitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UsageMemoryMonitorPrivate * priv;
};

struct _UsageMemoryMonitorClass {
	GTypeClass parent_class;
	void (*finalize) (UsageMemoryMonitor *self);
};

struct _UsageMemoryMonitorPrivate {
	guint64 ram_usage;
	guint64 ram_total;
	guint64 swap_usage;
	guint64 swap_total;
};

struct _UsageParamSpecMemoryMonitor {
	GParamSpec parent_instance;
};

static gint UsageMemoryMonitor_private_offset;
static gpointer usage_memory_monitor_parent_class = NULL;
static UsageMonitorIface * usage_memory_monitor_usage_monitor_parent_iface = NULL;

VALA_EXTERN GType usage_process_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcess, g_object_unref)
VALA_EXTERN GType usage_monitor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer usage_memory_monitor_ref (gpointer instance);
VALA_EXTERN void usage_memory_monitor_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_memory_monitor (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void usage_value_set_memory_monitor (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void usage_value_take_memory_monitor (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer usage_value_get_memory_monitor (const GValue* value);
VALA_EXTERN GType usage_memory_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemoryMonitor, usage_memory_monitor_unref)
static void usage_memory_monitor_real_update (UsageMonitor* base);
VALA_EXTERN guint64 usage_memory_monitor_get_ram_usage (UsageMemoryMonitor* self);
VALA_EXTERN guint64 usage_memory_monitor_get_swap_usage (UsageMemoryMonitor* self);
VALA_EXTERN guint64 usage_memory_monitor_get_ram_total (UsageMemoryMonitor* self);
VALA_EXTERN guint64 usage_memory_monitor_get_swap_total (UsageMemoryMonitor* self);
static void usage_memory_monitor_real_update_process (UsageMonitor* base,
                                               UsageProcess** process);
VALA_EXTERN GPid usage_process_get_pid (UsageProcess* self);
VALA_EXTERN void usage_process_set_mem_usage (UsageProcess* self,
                                  guint64 value);
VALA_EXTERN UsageMemoryMonitor* usage_memory_monitor_new (void);
VALA_EXTERN UsageMemoryMonitor* usage_memory_monitor_construct (GType object_type);
VALA_EXTERN void usage_monitor_update (UsageMonitor* self);
VALA_EXTERN void usage_monitor_update_process (UsageMonitor* self,
                                   UsageProcess** process);
static void usage_memory_monitor_finalize (UsageMemoryMonitor * obj);
static GType usage_memory_monitor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_memory_monitor_get_instance_private (UsageMemoryMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, UsageMemoryMonitor_private_offset);
}

static void
usage_memory_monitor_real_update (UsageMonitor* base)
{
	UsageMemoryMonitor * self;
	glibtop_mem mem = {0};
	glibtop_mem _tmp0_ = {0};
	glibtop_mem _tmp1_;
	glibtop_mem _tmp2_;
	glibtop_swap swap = {0};
	glibtop_swap _tmp3_ = {0};
	glibtop_swap _tmp4_;
	glibtop_swap _tmp5_;
	self = (UsageMemoryMonitor*) base;
	glibtop_get_mem (&_tmp0_);
	mem = _tmp0_;
	_tmp1_ = mem;
	self->priv->ram_usage = _tmp1_.user;
	_tmp2_ = mem;
	self->priv->ram_total = _tmp2_.total;
	glibtop_get_swap (&_tmp3_);
	swap = _tmp3_;
	_tmp4_ = swap;
	self->priv->swap_usage = _tmp4_.used;
	_tmp5_ = swap;
	self->priv->swap_total = _tmp5_.total;
}

guint64
usage_memory_monitor_get_ram_usage (UsageMemoryMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->ram_usage;
	return result;
}

guint64
usage_memory_monitor_get_swap_usage (UsageMemoryMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->swap_usage;
	return result;
}

guint64
usage_memory_monitor_get_ram_total (UsageMemoryMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->ram_total;
	return result;
}

guint64
usage_memory_monitor_get_swap_total (UsageMemoryMonitor* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->swap_total;
	return result;
}

static void
usage_memory_monitor_real_update_process (UsageMonitor* base,
                                          UsageProcess** process)
{
	UsageMemoryMonitor * self;
	glibtop_mem mem = {0};
	glibtop_proc_mem proc_mem = {0};
	glibtop_mem _tmp0_ = {0};
	GPid _tmp1_;
	GPid _tmp2_;
	glibtop_proc_mem _tmp3_ = {0};
	glibtop_proc_mem _tmp4_;
	glibtop_proc_mem _tmp5_;
	self = (UsageMemoryMonitor*) base;
	g_return_if_fail (*process != NULL);
	glibtop_get_mem (&_tmp0_);
	mem = _tmp0_;
	_tmp1_ = usage_process_get_pid (*process);
	_tmp2_ = _tmp1_;
	glibtop_get_proc_mem (&_tmp3_, _tmp2_);
	proc_mem = _tmp3_;
	_tmp4_ = proc_mem;
	_tmp5_ = proc_mem;
	usage_process_set_mem_usage (*process, _tmp4_.resident - _tmp5_.share);
}

UsageMemoryMonitor*
usage_memory_monitor_construct (GType object_type)
{
	UsageMemoryMonitor* self = NULL;
	self = (UsageMemoryMonitor*) g_type_create_instance (object_type);
	return self;
}

UsageMemoryMonitor*
usage_memory_monitor_new (void)
{
	return usage_memory_monitor_construct (USAGE_TYPE_MEMORY_MONITOR);
}

static void
usage_value_memory_monitor_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
usage_value_memory_monitor_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		usage_memory_monitor_unref (value->data[0].v_pointer);
	}
}

static void
usage_value_memory_monitor_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = usage_memory_monitor_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
usage_value_memory_monitor_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
usage_value_memory_monitor_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UsageMemoryMonitor * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = usage_memory_monitor_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
usage_value_memory_monitor_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	UsageMemoryMonitor ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = usage_memory_monitor_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
usage_param_spec_memory_monitor (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	UsageParamSpecMemoryMonitor* spec;
	g_return_val_if_fail (g_type_is_a (object_type, USAGE_TYPE_MEMORY_MONITOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
usage_value_get_memory_monitor (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_MEMORY_MONITOR), NULL);
	return value->data[0].v_pointer;
}

void
usage_value_set_memory_monitor (GValue* value,
                                gpointer v_object)
{
	UsageMemoryMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_MEMORY_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_MEMORY_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		usage_memory_monitor_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_memory_monitor_unref (old);
	}
}

void
usage_value_take_memory_monitor (GValue* value,
                                 gpointer v_object)
{
	UsageMemoryMonitor * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_MEMORY_MONITOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_MEMORY_MONITOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_memory_monitor_unref (old);
	}
}

static void
usage_memory_monitor_class_init (UsageMemoryMonitorClass * klass,
                                 gpointer klass_data)
{
	usage_memory_monitor_parent_class = g_type_class_peek_parent (klass);
	((UsageMemoryMonitorClass *) klass)->finalize = usage_memory_monitor_finalize;
	g_type_class_adjust_private_offset (klass, &UsageMemoryMonitor_private_offset);
}

static void
usage_memory_monitor_usage_monitor_interface_init (UsageMonitorIface * iface,
                                                   gpointer iface_data)
{
	usage_memory_monitor_usage_monitor_parent_iface = g_type_interface_peek_parent (iface);
	iface->update = (void (*) (UsageMonitor*)) usage_memory_monitor_real_update;
	iface->update_process = (void (*) (UsageMonitor*, UsageProcess**)) usage_memory_monitor_real_update_process;
}

static void
usage_memory_monitor_instance_init (UsageMemoryMonitor * self,
                                    gpointer klass)
{
	self->priv = usage_memory_monitor_get_instance_private (self);
	self->ref_count = 1;
}

static void
usage_memory_monitor_finalize (UsageMemoryMonitor * obj)
{
	UsageMemoryMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_MEMORY_MONITOR, UsageMemoryMonitor);
	g_signal_handlers_destroy (self);
}

static GType
usage_memory_monitor_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { usage_value_memory_monitor_init, usage_value_memory_monitor_free_value, usage_value_memory_monitor_copy_value, usage_value_memory_monitor_peek_pointer, "p", usage_value_memory_monitor_collect_value, "p", usage_value_memory_monitor_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UsageMemoryMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_memory_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMemoryMonitor), 0, (GInstanceInitFunc) usage_memory_monitor_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	static const GInterfaceInfo usage_monitor_info = { (GInterfaceInitFunc) usage_memory_monitor_usage_monitor_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType usage_memory_monitor_type_id;
	usage_memory_monitor_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UsageMemoryMonitor", &g_define_type_info, &g_define_type_fundamental_info, 0);
	g_type_add_interface_static (usage_memory_monitor_type_id, USAGE_TYPE_MONITOR, &usage_monitor_info);
	UsageMemoryMonitor_private_offset = g_type_add_instance_private (usage_memory_monitor_type_id, sizeof (UsageMemoryMonitorPrivate));
	return usage_memory_monitor_type_id;
}

GType
usage_memory_monitor_get_type (void)
{
	static volatile gsize usage_memory_monitor_type_id__once = 0;
	if (g_once_init_enter (&usage_memory_monitor_type_id__once)) {
		GType usage_memory_monitor_type_id;
		usage_memory_monitor_type_id = usage_memory_monitor_get_type_once ();
		g_once_init_leave (&usage_memory_monitor_type_id__once, usage_memory_monitor_type_id);
	}
	return usage_memory_monitor_type_id__once;
}

gpointer
usage_memory_monitor_ref (gpointer instance)
{
	UsageMemoryMonitor * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
usage_memory_monitor_unref (gpointer instance)
{
	UsageMemoryMonitor * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		USAGE_MEMORY_MONITOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

