/* memory-graph.c generated by valac 0.56.16, the Vala compiler
 * generated from memory-graph.vala, do not modify */

/* memory-graph.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_GRAPH_VIEW (usage_graph_view_get_type ())
#define USAGE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphView))
#define USAGE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))
#define USAGE_IS_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_IS_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH_VIEW))
#define USAGE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH_VIEW, UsageGraphViewClass))

typedef struct _UsageGraphView UsageGraphView;
typedef struct _UsageGraphViewClass UsageGraphViewClass;
typedef struct _UsageGraphViewPrivate UsageGraphViewPrivate;

#define USAGE_TYPE_PERFORMANCE_GRAPH_VIEW (usage_performance_graph_view_get_type ())
#define USAGE_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphView))
#define USAGE_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_IS_PERFORMANCE_GRAPH_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW))
#define USAGE_PERFORMANCE_GRAPH_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, UsagePerformanceGraphViewClass))

typedef struct _UsagePerformanceGraphView UsagePerformanceGraphView;
typedef struct _UsagePerformanceGraphViewClass UsagePerformanceGraphViewClass;
typedef struct _UsagePerformanceGraphViewPrivate UsagePerformanceGraphViewPrivate;

#define USAGE_TYPE_MEMORY_GRAPH (usage_memory_graph_get_type ())
#define USAGE_MEMORY_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_MEMORY_GRAPH, UsageMemoryGraph))
#define USAGE_MEMORY_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_MEMORY_GRAPH, UsageMemoryGraphClass))
#define USAGE_IS_MEMORY_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_MEMORY_GRAPH))
#define USAGE_IS_MEMORY_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_MEMORY_GRAPH))
#define USAGE_MEMORY_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_MEMORY_GRAPH, UsageMemoryGraphClass))

typedef struct _UsageMemoryGraph UsageMemoryGraph;
typedef struct _UsageMemoryGraphClass UsageMemoryGraphClass;
typedef struct _UsageMemoryGraphPrivate UsageMemoryGraphPrivate;

#define USAGE_TYPE_GRAPH (usage_graph_get_type ())
#define USAGE_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_GRAPH, UsageGraph))
#define USAGE_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_GRAPH, UsageGraphClass))
#define USAGE_IS_GRAPH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_GRAPH))
#define USAGE_IS_GRAPH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_GRAPH))
#define USAGE_GRAPH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_GRAPH, UsageGraphClass))

typedef struct _UsageGraph UsageGraph;
typedef struct _UsageGraphClass UsageGraphClass;
enum  {
	USAGE_MEMORY_GRAPH_0_PROPERTY,
	USAGE_MEMORY_GRAPH_NUM_PROPERTIES
};
static GParamSpec* usage_memory_graph_properties[USAGE_MEMORY_GRAPH_NUM_PROPERTIES];
#define _usage_graph_unref0(var) ((var == NULL) ? NULL : (var = (usage_graph_unref (var), NULL)))

#define USAGE_TYPE_SYSTEM_MONITOR (usage_system_monitor_get_type ())
#define USAGE_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitor))
#define USAGE_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))
#define USAGE_IS_SYSTEM_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_IS_SYSTEM_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SYSTEM_MONITOR))
#define USAGE_SYSTEM_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SYSTEM_MONITOR, UsageSystemMonitorClass))

typedef struct _UsageSystemMonitor UsageSystemMonitor;
typedef struct _UsageSystemMonitorClass UsageSystemMonitorClass;

#define USAGE_TYPE_GRAPH_POINT (usage_graph_point_get_type ())
typedef struct _UsageGraphPoint UsageGraphPoint;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _UsageGraphView {
	GtkWidget parent_instance;
	UsageGraphViewPrivate * priv;
	gint64 _offset_x;
	gint64 _range_x;
	gint64 _offset_y;
	gint64 _range_y;
};

struct _UsageGraphViewClass {
	GtkWidgetClass parent_class;
	gint64 (*get_offset_x) (UsageGraphView* self);
	void (*set_offset_x) (UsageGraphView* self, gint64 value);
};

struct _UsagePerformanceGraphView {
	UsageGraphView parent_instance;
	UsagePerformanceGraphViewPrivate * priv;
};

struct _UsagePerformanceGraphViewClass {
	UsageGraphViewClass parent_class;
	void (*update_graphs) (UsagePerformanceGraphView* self);
};

struct _UsageMemoryGraph {
	UsagePerformanceGraphView parent_instance;
	UsageMemoryGraphPrivate * priv;
};

struct _UsageMemoryGraphClass {
	UsagePerformanceGraphViewClass parent_class;
};

struct _UsageMemoryGraphPrivate {
	UsageGraph* mem_graph;
	UsageGraph* swap_graph;
};

struct _UsageGraphPoint {
	gint64 timestamp;
	gdouble level;
};

static gint UsageMemoryGraph_private_offset;
static gpointer usage_memory_graph_parent_class = NULL;

VALA_EXTERN GType usage_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraphView, g_object_unref)
VALA_EXTERN GType usage_performance_graph_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsagePerformanceGraphView, g_object_unref)
VALA_EXTERN GType usage_memory_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageMemoryGraph, g_object_unref)
VALA_EXTERN gpointer usage_graph_ref (gpointer instance);
VALA_EXTERN void usage_graph_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_graph (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_graph (GValue* value,
                            gpointer v_object);
VALA_EXTERN void usage_value_take_graph (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_graph (const GValue* value);
VALA_EXTERN GType usage_graph_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageGraph, usage_graph_unref)
VALA_EXTERN void usage_performance_graph_view_update_graphs (UsagePerformanceGraphView* self);
VALA_EXTERN UsageGraph* usage_graph_new (void);
VALA_EXTERN UsageGraph* usage_graph_construct (GType object_type);
VALA_EXTERN UsageMemoryGraph* usage_memory_graph_new (void);
VALA_EXTERN UsageMemoryGraph* usage_memory_graph_construct (GType object_type);
VALA_EXTERN UsagePerformanceGraphView* usage_performance_graph_view_construct (GType object_type);
VALA_EXTERN void usage_performance_graph_view_add_graph (UsagePerformanceGraphView* self,
                                             UsageGraph* graph);
static void usage_memory_graph_real_update_graphs (UsagePerformanceGraphView* base);
VALA_EXTERN GType usage_system_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSystemMonitor, g_object_unref)
VALA_EXTERN UsageSystemMonitor* usage_system_monitor_get_default (void);
VALA_EXTERN guint64 usage_system_monitor_get_ram_total (UsageSystemMonitor* self);
VALA_EXTERN guint64 usage_system_monitor_get_ram_usage (UsageSystemMonitor* self);
VALA_EXTERN GType usage_graph_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UsageGraphPoint* usage_graph_point_dup (const UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_free (UsageGraphPoint* self);
VALA_EXTERN void usage_graph_point_init (UsageGraphPoint *self,
                             gint64 timestamp,
                             gdouble level);
VALA_EXTERN void usage_graph_push_point (UsageGraph* self,
                             UsageGraphPoint* point);
VALA_EXTERN guint64 usage_system_monitor_get_swap_total (UsageSystemMonitor* self);
VALA_EXTERN guint64 usage_system_monitor_get_swap_usage (UsageSystemMonitor* self);
static void usage_memory_graph_finalize (GObject * obj);
static GType usage_memory_graph_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
usage_memory_graph_get_instance_private (UsageMemoryGraph* self)
{
	return G_STRUCT_MEMBER_P (self, UsageMemoryGraph_private_offset);
}

UsageMemoryGraph*
usage_memory_graph_construct (GType object_type)
{
	UsageMemoryGraph * self = NULL;
	UsageGraph* _tmp0_;
	UsageGraph* _tmp1_;
	self = (UsageMemoryGraph*) usage_performance_graph_view_construct (object_type);
	_tmp0_ = self->priv->mem_graph;
	usage_performance_graph_view_add_graph ((UsagePerformanceGraphView*) self, _tmp0_);
	_tmp1_ = self->priv->swap_graph;
	usage_performance_graph_view_add_graph ((UsagePerformanceGraphView*) self, _tmp1_);
	return self;
}

UsageMemoryGraph*
usage_memory_graph_new (void)
{
	return usage_memory_graph_construct (USAGE_TYPE_MEMORY_GRAPH);
}

static void
usage_memory_graph_real_update_graphs (UsagePerformanceGraphView* base)
{
	UsageMemoryGraph * self;
	UsageSystemMonitor* monitor = NULL;
	UsageSystemMonitor* _tmp0_;
	gint64 timestamp = 0LL;
	gdouble ram_usage = 0.0;
	UsageSystemMonitor* _tmp1_;
	guint64 _tmp2_;
	guint64 _tmp3_;
	UsageGraphPoint mem_point = {0};
	UsageGraph* _tmp10_;
	UsageGraphPoint _tmp11_;
	UsageSystemMonitor* _tmp12_;
	guint64 _tmp13_;
	guint64 _tmp14_;
	self = (UsageMemoryGraph*) base;
	_tmp0_ = usage_system_monitor_get_default ();
	monitor = _tmp0_;
	timestamp = g_get_monotonic_time ();
	ram_usage = (gdouble) 0;
	_tmp1_ = monitor;
	_tmp2_ = usage_system_monitor_get_ram_total (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != ((guint64) 0)) {
		UsageSystemMonitor* _tmp4_;
		guint64 _tmp5_;
		guint64 _tmp6_;
		UsageSystemMonitor* _tmp7_;
		guint64 _tmp8_;
		guint64 _tmp9_;
		_tmp4_ = monitor;
		_tmp5_ = usage_system_monitor_get_ram_usage (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = monitor;
		_tmp8_ = usage_system_monitor_get_ram_total (_tmp7_);
		_tmp9_ = _tmp8_;
		ram_usage = (((gdouble) _tmp6_) / _tmp9_) * 100;
	}
	usage_graph_point_init (&mem_point, timestamp, ram_usage);
	_tmp10_ = self->priv->mem_graph;
	_tmp11_ = mem_point;
	usage_graph_push_point (_tmp10_, &_tmp11_);
	_tmp12_ = monitor;
	_tmp13_ = usage_system_monitor_get_swap_total (_tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != ((guint64) 0)) {
		gdouble swap_usage = 0.0;
		UsageSystemMonitor* _tmp15_;
		guint64 _tmp16_;
		guint64 _tmp17_;
		UsageSystemMonitor* _tmp18_;
		guint64 _tmp19_;
		guint64 _tmp20_;
		UsageGraphPoint swap_point = {0};
		UsageGraph* _tmp21_;
		UsageGraphPoint _tmp22_;
		_tmp15_ = monitor;
		_tmp16_ = usage_system_monitor_get_swap_usage (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = monitor;
		_tmp19_ = usage_system_monitor_get_swap_total (_tmp18_);
		_tmp20_ = _tmp19_;
		swap_usage = (((gdouble) _tmp17_) / _tmp20_) * 100;
		usage_graph_point_init (&swap_point, timestamp, swap_usage);
		_tmp21_ = self->priv->swap_graph;
		_tmp22_ = swap_point;
		usage_graph_push_point (_tmp21_, &_tmp22_);
	}
	_g_object_unref0 (monitor);
}

static void
usage_memory_graph_class_init (UsageMemoryGraphClass * klass,
                               gpointer klass_data)
{
	usage_memory_graph_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageMemoryGraph_private_offset);
	((UsagePerformanceGraphViewClass *) klass)->update_graphs = (void (*) (UsagePerformanceGraphView*)) usage_memory_graph_real_update_graphs;
	G_OBJECT_CLASS (klass)->finalize = usage_memory_graph_finalize;
}

static void
usage_memory_graph_instance_init (UsageMemoryGraph * self,
                                  gpointer klass)
{
	UsageGraph* _tmp0_;
	UsageGraph* _tmp1_;
	self->priv = usage_memory_graph_get_instance_private (self);
	_tmp0_ = usage_graph_new ();
	self->priv->mem_graph = _tmp0_;
	_tmp1_ = usage_graph_new ();
	self->priv->swap_graph = _tmp1_;
}

static void
usage_memory_graph_finalize (GObject * obj)
{
	UsageMemoryGraph * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_MEMORY_GRAPH, UsageMemoryGraph);
	_usage_graph_unref0 (self->priv->mem_graph);
	_usage_graph_unref0 (self->priv->swap_graph);
	G_OBJECT_CLASS (usage_memory_graph_parent_class)->finalize (obj);
}

static GType
usage_memory_graph_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageMemoryGraphClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_memory_graph_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageMemoryGraph), 0, (GInstanceInitFunc) usage_memory_graph_instance_init, NULL };
	GType usage_memory_graph_type_id;
	usage_memory_graph_type_id = g_type_register_static (USAGE_TYPE_PERFORMANCE_GRAPH_VIEW, "UsageMemoryGraph", &g_define_type_info, 0);
	UsageMemoryGraph_private_offset = g_type_add_instance_private (usage_memory_graph_type_id, sizeof (UsageMemoryGraphPrivate));
	return usage_memory_graph_type_id;
}

GType
usage_memory_graph_get_type (void)
{
	static volatile gsize usage_memory_graph_type_id__once = 0;
	if (g_once_init_enter (&usage_memory_graph_type_id__once)) {
		GType usage_memory_graph_type_id;
		usage_memory_graph_type_id = usage_memory_graph_get_type_once ();
		g_once_init_leave (&usage_memory_graph_type_id__once, usage_memory_graph_type_id);
	}
	return usage_memory_graph_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

