/* app-item.c generated by valac 0.56.16, the Vala compiler
 * generated from app-item.vala, do not modify */

/* app-item.vala
 *
 * Copyright (C) 2018 Red Hat, Inc.
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <glib/gi18n-lib.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_APP_ITEM (usage_app_item_get_type ())
#define USAGE_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_APP_ITEM, UsageAppItem))
#define USAGE_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_APP_ITEM, UsageAppItemClass))
#define USAGE_IS_APP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_APP_ITEM))
#define USAGE_IS_APP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_APP_ITEM))
#define USAGE_APP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_APP_ITEM, UsageAppItemClass))

typedef struct _UsageAppItem UsageAppItem;
typedef struct _UsageAppItemClass UsageAppItemClass;
typedef struct _UsageAppItemPrivate UsageAppItemPrivate;

#define USAGE_TYPE_PROCESS (usage_process_get_type ())
#define USAGE_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_PROCESS, UsageProcess))
#define USAGE_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_PROCESS, UsageProcessClass))
#define USAGE_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_PROCESS))
#define USAGE_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_PROCESS))
#define USAGE_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_PROCESS, UsageProcessClass))

typedef struct _UsageProcess UsageProcess;
typedef struct _UsageProcessClass UsageProcessClass;

#define USAGE_FDO_TYPE_ACCOUNTS_USER (usage_fdo_accounts_user_get_type ())
#define USAGE_FDO_ACCOUNTS_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_FDO_TYPE_ACCOUNTS_USER, UsageFdoAccountsUser))
#define USAGE_FDO_IS_ACCOUNTS_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_FDO_TYPE_ACCOUNTS_USER))
#define USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_FDO_TYPE_ACCOUNTS_USER, UsageFdoAccountsUserIface))

typedef struct _UsageFdoAccountsUser UsageFdoAccountsUser;
typedef struct _UsageFdoAccountsUserIface UsageFdoAccountsUserIface;

#define USAGE_FDO_TYPE_ACCOUNTS_USER_PROXY (usage_fdo_accounts_user_proxy_get_type ())
enum  {
	USAGE_APP_ITEM_0_PROPERTY,
	USAGE_APP_ITEM_PROCESSES_PROPERTY,
	USAGE_APP_ITEM_DISPLAY_NAME_PROPERTY,
	USAGE_APP_ITEM_REPRESENTATIVE_CMDLINE_PROPERTY,
	USAGE_APP_ITEM_REPRESENTATIVE_UID_PROPERTY,
	USAGE_APP_ITEM_CPU_LOAD_PROPERTY,
	USAGE_APP_ITEM_MEM_USAGE_PROPERTY,
	USAGE_APP_ITEM_USER_PROPERTY,
	USAGE_APP_ITEM_GAMEMODE_PROPERTY,
	USAGE_APP_ITEM_IS_BACKGROUND_PROPERTY,
	USAGE_APP_ITEM_RUNNING_PROPERTY,
	USAGE_APP_ITEM_ICON_PROPERTY,
	USAGE_APP_ITEM_CONTAINER_PROPERTY,
	USAGE_APP_ITEM_NUM_PROPERTIES
};
static GParamSpec* usage_app_item_properties[USAGE_APP_ITEM_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define USAGE_TYPE_SETTINGS (usage_settings_get_type ())
#define USAGE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_SETTINGS, UsageSettings))
#define USAGE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_SETTINGS, UsageSettingsClass))
#define USAGE_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_SETTINGS))
#define USAGE_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_SETTINGS))
#define USAGE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_SETTINGS, UsageSettingsClass))

typedef struct _UsageSettings UsageSettings;
typedef struct _UsageSettingsClass UsageSettingsClass;

#define USAGE_FDO_TYPE_ACCOUNTS (usage_fdo_accounts_get_type ())
#define USAGE_FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_FDO_TYPE_ACCOUNTS, UsageFdoAccounts))
#define USAGE_FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_FDO_TYPE_ACCOUNTS))
#define USAGE_FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_FDO_TYPE_ACCOUNTS, UsageFdoAccountsIface))

typedef struct _UsageFdoAccounts UsageFdoAccounts;
typedef struct _UsageFdoAccountsIface UsageFdoAccountsIface;

#define USAGE_FDO_TYPE_ACCOUNTS_PROXY (usage_fdo_accounts_proxy_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UsageAppItemLoadUserAccountData UsageAppItemLoadUserAccountData;

struct _UsageAppItem {
	GObject parent_instance;
	UsageAppItemPrivate * priv;
};

struct _UsageAppItemClass {
	GObjectClass parent_class;
	gboolean (*get_running) (UsageAppItem* self);
	GIcon* (*get_icon) (UsageAppItem* self);
	const gchar* (*get_container) (UsageAppItem* self);
};

struct _UsageFdoAccountsUserIface {
	GTypeInterface parent_iface;
	gboolean (*get_SystemAccount) (UsageFdoAccountsUser* self);
	gboolean (*get_LocalAccount) (UsageFdoAccountsUser* self);
	gint32 (*get_AccountType) (UsageFdoAccountsUser* self);
	gchar* (*get_RealName) (UsageFdoAccountsUser* self);
	gchar* (*get_UserName) (UsageFdoAccountsUser* self);
	guint64 (*get_Uid) (UsageFdoAccountsUser* self);
};

struct _UsageAppItemPrivate {
	GHashTable* _processes;
	gchar* _display_name;
	gchar* _representative_cmdline;
	guint _representative_uid;
	gdouble _cpu_load;
	guint64 _mem_usage;
	UsageFdoAccountsUser* _user;
	gboolean _gamemode;
	gboolean _is_background;
	GAppInfo* app_info;
};

struct _UsageFdoAccountsIface {
	GTypeInterface parent_iface;
	void (*FindUserById) (UsageFdoAccounts* self, gint64 id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*FindUserById_finish) (UsageFdoAccounts* self, GAsyncResult* _res_, GError** error);
};

struct _UsageAppItemLoadUserAccountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UsageAppItem* self;
	UsageFdoAccounts* accounts;
	UsageFdoAccounts* _tmp0_;
	gchar* user_account_path;
	UsageFdoAccounts* _tmp1_;
	guint _tmp2_;
	gchar* _tmp3_;
	UsageFdoAccountsUser* _tmp4_;
	const gchar* _tmp5_;
	UsageFdoAccountsUser* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_;
};

static gint UsageAppItem_private_offset;
static gpointer usage_app_item_parent_class = NULL;
static GIcon* usage_app_item_default_icon;
static GIcon* usage_app_item_default_icon = NULL;
static GHashTable* usage_app_item_apps_info;
static GHashTable* usage_app_item_apps_info = NULL;
static GHashTable* usage_app_item_appid_map;
static GHashTable* usage_app_item_appid_map = NULL;

VALA_EXTERN GType usage_app_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageAppItem, g_object_unref)
VALA_EXTERN GType usage_process_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageProcess, g_object_unref)
VALA_EXTERN GType usage_fdo_accounts_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageFdoAccountsUser, g_object_unref)
VALA_EXTERN GType usage_fdo_accounts_user_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint usage_fdo_accounts_user_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN gboolean usage_app_item_get_running (UsageAppItem* self);
VALA_EXTERN GIcon* usage_app_item_get_icon (UsageAppItem* self);
VALA_EXTERN const gchar* usage_app_item_get_container (UsageAppItem* self);
VALA_EXTERN void usage_app_item_init (void);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static gboolean* _bool_dup (gboolean* self);
static gint* _int_dup (gint* self);
static void usage_app_item_sanitize_cmd (gchar** commandline);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN gchar* usage_app_item_appid_from_unit (const gchar* systemd_unit);
VALA_EXTERN gchar* usage_utils_unescape (const gchar* escaped);
VALA_EXTERN GAppInfo* usage_app_item_app_info_for_process (UsageProcess* p);
VALA_EXTERN gchar* usage_process_read_cgroup (GPid pid);
VALA_EXTERN GPid usage_process_get_pid (UsageProcess* self);
VALA_EXTERN const gchar* usage_process_get_cmdline (UsageProcess* self);
VALA_EXTERN const gchar* usage_process_get_app_id (UsageProcess* self);
VALA_EXTERN gboolean usage_app_item_have_app_info (UsageProcess* p);
VALA_EXTERN UsageAppItem* usage_app_item_new (UsageProcess* process);
VALA_EXTERN UsageAppItem* usage_app_item_construct (GType object_type,
                                        UsageProcess* process);
static void usage_app_item_set_representative_cmdline (UsageAppItem* self,
                                                const gchar* value);
VALA_EXTERN guint usage_process_get_uid (UsageProcess* self);
static void usage_app_item_set_representative_uid (UsageAppItem* self,
                                            guint value);
static gchar* usage_app_item_find_display_name (UsageAppItem* self);
static void usage_app_item_set_display_name (UsageAppItem* self,
                                      const gchar* value);
VALA_EXTERN void usage_app_item_insert_process (UsageAppItem* self,
                                    UsageProcess* process);
static void usage_app_item_load_user_account (UsageAppItem* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void usage_app_item_load_user_account_finish (UsageAppItem* self,
                                              GAsyncResult* _res_);
VALA_EXTERN gboolean usage_process_get_gamemode (UsageProcess* self);
static void usage_app_item_set_gamemode (UsageAppItem* self,
                                  gboolean value);
VALA_EXTERN UsageAppItem* usage_app_item_new_system (void);
VALA_EXTERN UsageAppItem* usage_app_item_construct_system (GType object_type);
VALA_EXTERN gboolean usage_app_item_is_running (UsageAppItem* self);
VALA_EXTERN gboolean usage_app_item_contains_process (UsageAppItem* self,
                                          GPid pid);
VALA_EXTERN GHashTable* usage_app_item_get_processes (UsageAppItem* self);
VALA_EXTERN UsageProcess* usage_app_item_get_process_by_pid (UsageAppItem* self,
                                                 GPid pid);
static GPid* _g_pid_dup (GPid* self);
VALA_EXTERN gboolean usage_app_item_is_killable (UsageAppItem* self);
VALA_EXTERN const gchar* usage_app_item_get_representative_cmdline (UsageAppItem* self);
VALA_EXTERN GType usage_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageSettings, g_object_unref)
VALA_EXTERN UsageSettings* usage_settings_get_default (void);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN UsageFdoAccountsUser* usage_app_item_get_user (UsageAppItem* self);
VALA_EXTERN guint64 usage_fdo_accounts_user_get_Uid (UsageFdoAccountsUser* self);
static guint64* _uint64_dup (guint64* self);
static gboolean _uint64_equal (const guint64 * s1,
                        const guint64 * s2);
VALA_EXTERN void usage_app_item_kill (UsageAppItem* self,
                          int* sig);
static int* _signal_dup (int* self);
VALA_EXTERN void usage_app_item_mark_as_not_updated (UsageAppItem* self);
VALA_EXTERN void usage_process_set_mark_as_updated (UsageProcess* self,
                                        gboolean value);
VALA_EXTERN void usage_app_item_remove_processes (UsageAppItem* self);
static void usage_app_item_set_cpu_load (UsageAppItem* self,
                                  gdouble value);
static void usage_app_item_set_mem_usage (UsageAppItem* self,
                                   guint64 value);
VALA_EXTERN gboolean usage_process_get_mark_as_updated (UsageProcess* self);
VALA_EXTERN void usage_app_item_remove_process (UsageAppItem* self,
                                    UsageProcess* process);
VALA_EXTERN gdouble usage_app_item_get_cpu_load (UsageAppItem* self);
VALA_EXTERN gdouble usage_process_get_cpu_load (UsageProcess* self);
VALA_EXTERN guint64 usage_app_item_get_mem_usage (UsageAppItem* self);
VALA_EXTERN guint64 usage_process_get_mem_usage (UsageProcess* self);
VALA_EXTERN void usage_app_item_replace_process (UsageAppItem* self,
                                     UsageProcess* process);
static void usage_app_item_load_user_account_data_free (gpointer _data);
static gboolean usage_app_item_load_user_account_co (UsageAppItemLoadUserAccountData* _data_);
VALA_EXTERN GType usage_fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint usage_fdo_accounts_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType usage_fdo_accounts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageFdoAccounts, g_object_unref)
static void usage_app_item_load_user_account_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN void usage_fdo_accounts_FindUserById (UsageFdoAccounts* self,
                                      gint64 id,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN gchar* usage_fdo_accounts_FindUserById_finish (UsageFdoAccounts* self,
                                               GAsyncResult* _res_,
                                               GError** error);
VALA_EXTERN guint usage_app_item_get_representative_uid (UsageAppItem* self);
static void usage_app_item_set_user (UsageAppItem* self,
                              UsageFdoAccountsUser* value);
VALA_EXTERN gchar* usage_process_first_component (const gchar* str);
VALA_EXTERN gchar* usage_process_sanitize_name (const gchar* name);
VALA_EXTERN void usage_app_item_set_processes (UsageAppItem* self,
                                   GHashTable* value);
VALA_EXTERN const gchar* usage_app_item_get_display_name (UsageAppItem* self);
VALA_EXTERN gboolean usage_app_item_get_gamemode (UsageAppItem* self);
VALA_EXTERN gboolean usage_app_item_get_is_background (UsageAppItem* self);
VALA_EXTERN void usage_app_item_set_is_background (UsageAppItem* self,
                                       gboolean value);
static GObject * usage_app_item_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void usage_app_item_finalize (GObject * obj);
static GType usage_app_item_get_type_once (void);
static void _vala_usage_app_item_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_usage_app_item_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
usage_app_item_get_instance_private (UsageAppItem* self)
{
	return G_STRUCT_MEMBER_P (self, UsageAppItem_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
usage_app_item_init (void)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GList* _apps_info = NULL;
	GList* _tmp6_;
	GList* _tmp7_;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (usage_app_item_apps_info);
	usage_app_item_apps_info = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (usage_app_item_appid_map);
	usage_app_item_appid_map = _tmp5_;
	_tmp6_ = g_app_info_get_all ();
	_apps_info = _tmp6_;
	_tmp7_ = _apps_info;
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp7_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			GAppInfo* _tmp8_;
			GAppInfo* info = NULL;
			_tmp8_ = _g_object_ref0 ((GAppInfo*) info_it->data);
			info = _tmp8_;
			{
				GDesktopAppInfo* dai = NULL;
				GAppInfo* _tmp9_;
				GDesktopAppInfo* _tmp10_;
				gchar* id = NULL;
				GDesktopAppInfo* _tmp11_;
				const gchar* _tmp23_;
				gchar* cmd = NULL;
				GAppInfo* _tmp68_;
				const gchar* _tmp69_;
				gchar* _tmp70_;
				const gchar* _tmp71_;
				GHashTable* _tmp72_;
				const gchar* _tmp73_;
				gconstpointer _tmp74_;
				_tmp9_ = info;
				_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp9_) : NULL);
				dai = _tmp10_;
				id = NULL;
				_tmp11_ = dai;
				if (_tmp11_ != NULL) {
					GDesktopAppInfo* _tmp12_ = NULL;
					GDesktopAppInfo* _tmp13_;
					gchar* _tmp14_ = NULL;
					gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp13_ = dai;
					_tmp12_ = _tmp13_;
					_tmp14_ = NULL;
					if (_tmp12_ != NULL) {
						gchar* _tmp15_;
						_tmp15_ = g_desktop_app_info_get_string (_tmp12_, "X-Flatpak");
						_g_free0 (_tmp14_);
						_tmp14_ = _tmp15_;
					}
					_tmp16_ = _tmp14_;
					_tmp14_ = NULL;
					_g_free0 (id);
					id = _tmp16_;
					_tmp17_ = id;
					if (_tmp17_ != NULL) {
						GHashTable* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						GAppInfo* _tmp21_;
						GAppInfo* _tmp22_;
						_tmp18_ = usage_app_item_appid_map;
						_tmp19_ = id;
						_tmp20_ = g_strdup ((const gchar*) _tmp19_);
						_tmp21_ = info;
						_tmp22_ = _g_object_ref0 (_tmp21_);
						g_hash_table_insert (_tmp18_, _tmp20_, _tmp22_);
					}
					_g_free0 (_tmp14_);
				}
				_tmp23_ = id;
				if (_tmp23_ == NULL) {
					GAppInfo* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_;
					gboolean* _tmp29_ = NULL;
					gboolean* _tmp32_ = NULL;
					gboolean* _tmp33_;
					GDesktopAppInfo* _tmp47_ = NULL;
					GDesktopAppInfo* _tmp48_;
					const gchar* _tmp49_ = NULL;
					const gchar* _tmp62_;
					_tmp24_ = info;
					_tmp25_ = g_app_info_get_id (_tmp24_);
					_tmp26_ = g_strdup (_tmp25_);
					_g_free0 (id);
					id = _tmp26_;
					_tmp28_ = id;
					_tmp27_ = _tmp28_;
					_tmp29_ = NULL;
					if (_tmp27_ != NULL) {
						gboolean _tmp30_;
						gboolean* _tmp31_;
						_tmp30_ = g_str_has_suffix (_tmp27_, ".desktop");
						_tmp31_ = __bool_dup0 (&_tmp30_);
						_g_free0 (_tmp29_);
						_tmp29_ = _tmp31_;
					}
					_tmp33_ = __bool_dup0 (_tmp29_);
					_tmp32_ = _tmp33_;
					if (_tmp32_ == NULL) {
						gboolean _tmp34_;
						gboolean* _tmp35_;
						_tmp34_ = FALSE;
						_tmp35_ = __bool_dup0 (&_tmp34_);
						_g_free0 (_tmp32_);
						_tmp32_ = _tmp35_;
					}
					if (*_tmp32_) {
						const gchar* _tmp36_ = NULL;
						const gchar* _tmp37_;
						gchar* _tmp38_ = NULL;
						gchar* _tmp46_;
						_tmp37_ = id;
						_tmp36_ = _tmp37_;
						_tmp38_ = NULL;
						if (_tmp36_ != NULL) {
							const gchar* _tmp39_ = NULL;
							const gchar* _tmp40_;
							gint* _tmp41_ = NULL;
							gchar* _tmp45_;
							_tmp40_ = id;
							_tmp39_ = _tmp40_;
							_tmp41_ = NULL;
							if (_tmp39_ != NULL) {
								gint _tmp42_;
								gint _tmp43_;
								gint* _tmp44_;
								_tmp42_ = strlen (_tmp39_);
								_tmp43_ = _tmp42_;
								_tmp44_ = __int_dup0 (&_tmp43_);
								_g_free0 (_tmp41_);
								_tmp41_ = _tmp44_;
							}
							_tmp45_ = string_substring (_tmp36_, (glong) 0, (glong) ((*_tmp41_) - 8));
							_g_free0 (_tmp38_);
							_tmp38_ = _tmp45_;
							_g_free0 (_tmp41_);
						}
						_tmp46_ = _tmp38_;
						_tmp38_ = NULL;
						_g_free0 (id);
						id = _tmp46_;
						_g_free0 (_tmp38_);
					}
					_tmp48_ = dai;
					_tmp47_ = _tmp48_;
					_tmp49_ = NULL;
					if (_tmp47_ != NULL) {
						const gchar* _tmp50_;
						_tmp50_ = g_desktop_app_info_get_categories (_tmp47_);
						_tmp49_ = _tmp50_;
					}
					if (g_strcmp0 (_tmp49_, "X-WayDroid-App;") == 0) {
						const gchar* _tmp51_;
						_tmp51_ = id;
						if (g_strcmp0 (_tmp51_, "Waydroid") == 0) {
							GHashTable* _tmp52_;
							gchar* _tmp53_;
							GAppInfo* _tmp54_;
							GAppInfo* _tmp55_;
							gchar* _tmp56_;
							_tmp52_ = usage_app_item_apps_info;
							_tmp53_ = g_strdup ("waydroid");
							_tmp54_ = info;
							_tmp55_ = _g_object_ref0 (_tmp54_);
							g_hash_table_insert (_tmp52_, _tmp53_, _tmp55_);
							_tmp56_ = g_strdup ("system_waydroid");
							_g_free0 (id);
							id = _tmp56_;
						} else {
							const gchar* _tmp57_ = NULL;
							const gchar* _tmp58_;
							gchar* _tmp59_ = NULL;
							gchar* _tmp61_;
							_tmp58_ = id;
							_tmp57_ = _tmp58_;
							_tmp59_ = NULL;
							if (_tmp57_ != NULL) {
								gchar* _tmp60_;
								_tmp60_ = string_substring (_tmp57_, (glong) 9, (glong) -1);
								_g_free0 (_tmp59_);
								_tmp59_ = _tmp60_;
							}
							_tmp61_ = _tmp59_;
							_tmp59_ = NULL;
							_g_free0 (id);
							id = _tmp61_;
							_g_free0 (_tmp59_);
						}
					}
					_tmp62_ = id;
					if (_tmp62_ != NULL) {
						GHashTable* _tmp63_;
						const gchar* _tmp64_;
						gchar* _tmp65_;
						GAppInfo* _tmp66_;
						GAppInfo* _tmp67_;
						_tmp63_ = usage_app_item_appid_map;
						_tmp64_ = id;
						_tmp65_ = g_strdup ((const gchar*) _tmp64_);
						_tmp66_ = info;
						_tmp67_ = _g_object_ref0 (_tmp66_);
						g_hash_table_insert (_tmp63_, _tmp65_, _tmp67_);
					}
					_g_free0 (_tmp32_);
					_g_free0 (_tmp29_);
				}
				_tmp68_ = info;
				_tmp69_ = g_app_info_get_commandline (_tmp68_);
				_tmp70_ = g_strdup (_tmp69_);
				cmd = _tmp70_;
				_tmp71_ = cmd;
				if (_tmp71_ == NULL) {
					_g_free0 (cmd);
					_g_free0 (id);
					_g_object_unref0 (dai);
					_g_object_unref0 (info);
					continue;
				}
				usage_app_item_sanitize_cmd (&cmd);
				_tmp72_ = usage_app_item_apps_info;
				_tmp73_ = cmd;
				_tmp74_ = g_hash_table_lookup (_tmp72_, (const gchar*) _tmp73_);
				if (((GAppInfo*) _tmp74_) == NULL) {
					GHashTable* _tmp75_;
					const gchar* _tmp76_;
					gchar* _tmp77_;
					GAppInfo* _tmp78_;
					GAppInfo* _tmp79_;
					_tmp75_ = usage_app_item_apps_info;
					_tmp76_ = cmd;
					_tmp77_ = g_strdup ((const gchar*) _tmp76_);
					_tmp78_ = info;
					_tmp79_ = _g_object_ref0 (_tmp78_);
					g_hash_table_insert (_tmp75_, _tmp77_, _tmp79_);
				}
				_g_free0 (cmd);
				_g_free0 (id);
				_g_object_unref0 (dai);
				_g_object_unref0 (info);
			}
		}
	}
	(_apps_info == NULL) ? NULL : (_apps_info = (_g_list_free__g_object_unref0_ (_apps_info), NULL));
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

gchar*
usage_app_item_appid_from_unit (const gchar* systemd_unit)
{
	gchar* escaped_id = NULL;
	gchar* id = NULL;
	gchar** segments = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint segments_length1;
	gint _segments_size_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* result;
	escaped_id = NULL;
	id = NULL;
	if (systemd_unit == NULL) {
		result = NULL;
		_g_free0 (id);
		_g_free0 (escaped_id);
		return result;
	}
	if (g_str_has_prefix (systemd_unit, "gnome-launched-")) {
		gint index = 0;
		gchar* _tmp0_;
		index = -1;
		index = string_index_of (systemd_unit, ".desktop-", 0);
		if (index == -1) {
			result = NULL;
			_g_free0 (id);
			_g_free0 (escaped_id);
			return result;
		}
		_tmp0_ = string_slice (systemd_unit, (glong) 15, (glong) index);
		result = _tmp0_;
		_g_free0 (id);
		_g_free0 (escaped_id);
		return result;
	}
	_tmp2_ = _tmp1_ = g_strsplit (systemd_unit, "-", 0);
	segments = _tmp2_;
	segments_length1 = _vala_array_length (_tmp1_);
	_segments_size_ = segments_length1;
	if (g_str_has_suffix (systemd_unit, ".scope")) {
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = segments;
		_tmp4__length1 = segments_length1;
		_tmp3_ = _tmp4__length1 >= 2;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = segments;
		_tmp5__length1 = segments_length1;
		_tmp6_ = segments;
		_tmp6__length1 = segments_length1;
		_tmp7_ = _tmp5_[_tmp6__length1 - 2];
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (escaped_id);
		escaped_id = _tmp8_;
	} else {
		gboolean _tmp9_ = FALSE;
		if (g_str_has_suffix (systemd_unit, ".service")) {
			gchar** _tmp10_;
			gint _tmp10__length1;
			_tmp10_ = segments;
			_tmp10__length1 = segments_length1;
			_tmp9_ = _tmp10__length1 >= 1;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gchar* tmp = NULL;
			gchar** _tmp11_;
			gint _tmp11__length1;
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar** _tmp21_;
			gchar** _tmp22_;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp11_ = segments;
			_tmp11__length1 = segments_length1;
			_tmp12_ = segments;
			_tmp12__length1 = segments_length1;
			_tmp13_ = _tmp11_[_tmp12__length1 - 1];
			_tmp14_ = g_strdup (_tmp13_);
			tmp = _tmp14_;
			_tmp15_ = tmp;
			_tmp16_ = tmp;
			_tmp17_ = strlen (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = string_slice (_tmp15_, (glong) 0, (glong) (_tmp18_ - 8));
			_g_free0 (tmp);
			tmp = _tmp19_;
			_tmp20_ = tmp;
			_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, "@", 2);
			_tmp23_ = _tmp22_;
			_tmp23__length1 = _vala_array_length (_tmp21_);
			_tmp24_ = _tmp23_[0];
			_tmp25_ = g_strdup (_tmp24_);
			_g_free0 (escaped_id);
			escaped_id = _tmp25_;
			_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (tmp);
		}
	}
	_tmp26_ = escaped_id;
	if (_tmp26_ == NULL) {
		result = NULL;
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (id);
		_g_free0 (escaped_id);
		return result;
	}
	_tmp27_ = escaped_id;
	_tmp28_ = usage_utils_unescape (_tmp27_);
	_g_free0 (id);
	id = _tmp28_;
	_tmp29_ = id;
	if (_tmp29_ == NULL) {
		result = NULL;
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (id);
		_g_free0 (escaped_id);
		return result;
	}
	result = id;
	segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (escaped_id);
	return result;
}

GAppInfo*
usage_app_item_app_info_for_process (UsageProcess* p)
{
	GAppInfo* info = NULL;
	gchar* cgroup = NULL;
	GPid _tmp0_;
	GPid _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp12_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	gboolean _tmp35_ = FALSE;
	GAppInfo* _tmp36_;
	GAppInfo* result;
	g_return_val_if_fail (p != NULL, NULL);
	info = NULL;
	cgroup = NULL;
	_tmp0_ = usage_process_get_pid (p);
	_tmp1_ = _tmp0_;
	_tmp2_ = usage_process_read_cgroup (_tmp1_);
	_g_free0 (cgroup);
	cgroup = _tmp2_;
	_tmp3_ = cgroup;
	if (g_strcmp0 (_tmp3_, "/lxc.payload.waydroid") == 0) {
		GAppInfo* _tmp4_ = NULL;
		GHashTable* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gconstpointer _tmp8_;
		GAppInfo* _tmp11_;
		_tmp5_ = usage_app_item_appid_map;
		_tmp6_ = usage_process_get_cmdline (p);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_hash_table_lookup (_tmp5_, _tmp7_);
		_tmp4_ = (GAppInfo*) _tmp8_;
		if (_tmp4_ == NULL) {
			GHashTable* _tmp9_;
			gconstpointer _tmp10_;
			_tmp9_ = usage_app_item_appid_map;
			_tmp10_ = g_hash_table_lookup (_tmp9_, "system_waydroid");
			_tmp4_ = (GAppInfo*) _tmp10_;
		}
		_tmp11_ = _g_object_ref0 (_tmp4_);
		result = _tmp11_;
		_g_free0 (cgroup);
		_g_object_unref0 (info);
		return result;
	}
	_tmp12_ = cgroup;
	if (_tmp12_ != NULL) {
		gchar* systemd_unit = NULL;
		gchar* appid = NULL;
		gchar** components = NULL;
		gint components_length1 = 0;
		gint _components_size_ = 0;
		const gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		GAppInfo* _tmp27_;
		systemd_unit = NULL;
		appid = NULL;
		_tmp13_ = cgroup;
		_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 0);
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
		components = _tmp15_;
		components_length1 = _vala_array_length (_tmp14_);
		_components_size_ = components_length1;
		_tmp16_ = components;
		_tmp16__length1 = components_length1;
		_tmp17_ = components;
		_tmp17__length1 = components_length1;
		_tmp18_ = _tmp16_[_tmp17__length1 - 1];
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (systemd_unit);
		systemd_unit = _tmp19_;
		_tmp20_ = systemd_unit;
		_tmp21_ = usage_app_item_appid_from_unit (_tmp20_);
		_g_free0 (appid);
		appid = _tmp21_;
		_tmp22_ = appid;
		if (_tmp22_ != NULL) {
			GHashTable* _tmp23_;
			const gchar* _tmp24_;
			gconstpointer _tmp25_;
			GAppInfo* _tmp26_;
			_tmp23_ = usage_app_item_appid_map;
			_tmp24_ = appid;
			_tmp25_ = g_hash_table_lookup (_tmp23_, _tmp24_);
			_tmp26_ = _g_object_ref0 ((GAppInfo*) _tmp25_);
			_g_object_unref0 (info);
			info = _tmp26_;
		}
		_tmp27_ = info;
		if (_tmp27_ != NULL) {
			result = info;
			components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (appid);
			_g_free0 (systemd_unit);
			_g_free0 (cgroup);
			return result;
		}
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (appid);
		_g_free0 (systemd_unit);
	}
	_tmp28_ = usage_process_get_cmdline (p);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		GHashTable* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gconstpointer _tmp33_;
		GAppInfo* _tmp34_;
		_tmp30_ = usage_app_item_apps_info;
		_tmp31_ = usage_process_get_cmdline (p);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_hash_table_lookup (_tmp30_, _tmp32_);
		_tmp34_ = _g_object_ref0 ((GAppInfo*) _tmp33_);
		_g_object_unref0 (info);
		info = _tmp34_;
	}
	_tmp36_ = info;
	if (_tmp36_ == NULL) {
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp37_ = usage_process_get_app_id (p);
		_tmp38_ = _tmp37_;
		_tmp35_ = _tmp38_ != NULL;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GHashTable* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		gconstpointer _tmp42_;
		GAppInfo* _tmp43_;
		_tmp39_ = usage_app_item_appid_map;
		_tmp40_ = usage_process_get_app_id (p);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_hash_table_lookup (_tmp39_, _tmp41_);
		_tmp43_ = _g_object_ref0 ((GAppInfo*) _tmp42_);
		_g_object_unref0 (info);
		info = _tmp43_;
	}
	result = info;
	_g_free0 (cgroup);
	return result;
}

gboolean
usage_app_item_have_app_info (UsageProcess* p)
{
	GAppInfo* info = NULL;
	GAppInfo* _tmp0_;
	gboolean result;
	g_return_val_if_fail (p != NULL, FALSE);
	_tmp0_ = usage_app_item_app_info_for_process (p);
	info = _tmp0_;
	result = info != NULL;
	_g_object_unref0 (info);
	return result;
}

UsageAppItem*
usage_app_item_construct (GType object_type,
                          UsageProcess* process)
{
	UsageAppItem * self = NULL;
	GAppInfo* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (process != NULL, NULL);
	self = (UsageAppItem*) g_object_new (object_type, NULL);
	_tmp0_ = usage_app_item_app_info_for_process (process);
	_g_object_unref0 (self->priv->app_info);
	self->priv->app_info = _tmp0_;
	_tmp1_ = usage_process_get_cmdline (process);
	_tmp2_ = _tmp1_;
	usage_app_item_set_representative_cmdline (self, _tmp2_);
	_tmp3_ = usage_process_get_uid (process);
	_tmp4_ = _tmp3_;
	usage_app_item_set_representative_uid (self, _tmp4_);
	_tmp5_ = usage_app_item_find_display_name (self);
	_tmp6_ = _tmp5_;
	usage_app_item_set_display_name (self, _tmp6_);
	_g_free0 (_tmp6_);
	usage_app_item_insert_process (self, process);
	usage_app_item_load_user_account (self, NULL, NULL);
	_tmp7_ = usage_process_get_gamemode (process);
	_tmp8_ = _tmp7_;
	usage_app_item_set_gamemode (self, _tmp8_);
	return self;
}

UsageAppItem*
usage_app_item_new (UsageProcess* process)
{
	return usage_app_item_construct (USAGE_TYPE_APP_ITEM, process);
}

UsageAppItem*
usage_app_item_construct_system (GType object_type)
{
	UsageAppItem * self = NULL;
	self = (UsageAppItem*) g_object_new (object_type, NULL);
	usage_app_item_set_display_name (self, _ ("System"));
	usage_app_item_set_representative_cmdline (self, "system");
	return self;
}

UsageAppItem*
usage_app_item_new_system (void)
{
	return usage_app_item_construct_system (USAGE_TYPE_APP_ITEM);
}

gboolean
usage_app_item_is_running (UsageAppItem* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = usage_app_item_get_running (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

gboolean
usage_app_item_contains_process (UsageAppItem* self,
                                 GPid pid)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_processes;
	result = g_hash_table_contains (_tmp0_, &pid);
	return result;
}

UsageProcess*
usage_app_item_get_process_by_pid (UsageAppItem* self,
                                   GPid pid)
{
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	UsageProcess* _tmp2_;
	UsageProcess* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_processes;
	_tmp1_ = g_hash_table_lookup (_tmp0_, &pid);
	_tmp2_ = _g_object_ref0 ((UsageProcess*) _tmp1_);
	result = _tmp2_;
	return result;
}

static GPid*
_g_pid_dup (GPid* self)
{
	GPid* dup;
	dup = g_new0 (GPid, 1);
	memcpy (dup, self, sizeof (GPid));
	return dup;
}

static gpointer
__g_pid_dup0 (gpointer self)
{
	return self ? _g_pid_dup (self) : NULL;
}

void
usage_app_item_insert_process (UsageAppItem* self,
                               UsageProcess* process)
{
	GHashTable* _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	GPid* _tmp3_;
	UsageProcess* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (process != NULL);
	_tmp0_ = self->priv->_processes;
	_tmp1_ = usage_process_get_pid (process);
	_tmp2_ = _tmp1_;
	_tmp3_ = __g_pid_dup0 (&_tmp2_);
	_tmp4_ = _g_object_ref0 (process);
	g_hash_table_insert (_tmp0_, _tmp3_, _tmp4_);
	g_object_notify ((GObject*) self, "running");
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static guint64*
_uint64_dup (guint64* self)
{
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}

static gpointer
__uint64_dup0 (gpointer self)
{
	return self ? _uint64_dup (self) : NULL;
}

static gboolean
_uint64_equal (const guint64 * s1,
               const guint64 * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

gboolean
usage_app_item_is_killable (UsageAppItem* self)
{
	gboolean blocked = FALSE;
	const gchar* _tmp0_;
	UsageSettings* _tmp1_;
	UsageSettings* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp6_;
	UsageFdoAccountsUser* _tmp7_ = NULL;
	UsageFdoAccountsUser* _tmp8_;
	guint64* _tmp9_ = NULL;
	gboolean by_current_user = FALSE;
	guint64 _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_representative_cmdline;
	_tmp1_ = usage_settings_get_default ();
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_settings_get_strv ((GSettings*) _tmp2_, "unkillable-processes");
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_tmp6_ = _vala_string_array_contains (_tmp5_, _vala_array_length (_tmp3_), _tmp0_);
	_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_tmp2_);
	blocked = _tmp6_;
	_tmp8_ = self->priv->_user;
	_tmp7_ = _tmp8_;
	_tmp9_ = NULL;
	if (_tmp7_ != NULL) {
		guint64 _tmp10_;
		guint64 _tmp11_;
		guint64* _tmp12_;
		_tmp10_ = usage_fdo_accounts_user_get_Uid (_tmp7_);
		_tmp11_ = _tmp10_;
		_tmp12_ = __uint64_dup0 (&_tmp11_);
		_g_free0 (_tmp9_);
		_tmp9_ = _tmp12_;
	}
	_tmp13_ = (guint64) geteuid ();
	by_current_user = _uint64_equal (_tmp9_, &_tmp13_) == TRUE;
	if (!blocked) {
		_tmp14_ = by_current_user;
	} else {
		_tmp14_ = FALSE;
	}
	result = _tmp14_;
	_g_free0 (_tmp9_);
	return result;
}

static int*
_signal_dup (int* self)
{
	int* dup;
	dup = g_new0 (int, 1);
	memcpy (dup, self, sizeof (int));
	return dup;
}

static gpointer
__signal_dup0 (gpointer self)
{
	return self ? _signal_dup (self) : NULL;
}

void
usage_app_item_kill (UsageAppItem* self,
                     int* sig)
{
	g_return_if_fail (self != NULL);
	if (usage_app_item_is_killable (self)) {
		GHashTable* _tmp0_;
		GList* _tmp1_;
		_tmp0_ = self->priv->_processes;
		_tmp1_ = g_hash_table_get_values (_tmp0_);
		{
			GList* process_collection = NULL;
			GList* process_it = NULL;
			process_collection = _tmp1_;
			for (process_it = process_collection; process_it != NULL; process_it = process_it->next) {
				UsageProcess* process = NULL;
				process = (UsageProcess*) process_it->data;
				{
					UsageProcess* _tmp2_;
					GPid _tmp3_;
					GPid _tmp4_;
					int* _tmp5_ = NULL;
					int* _tmp6_;
					UsageProcess* _tmp9_;
					GPid _tmp10_;
					GPid _tmp11_;
					_tmp2_ = process;
					_tmp3_ = usage_process_get_pid (_tmp2_);
					_tmp4_ = _tmp3_;
					g_debug ("app-item.vala:248: Terminating %d", (gint) _tmp4_);
					_tmp6_ = __signal_dup0 (sig);
					_tmp5_ = _tmp6_;
					if (_tmp5_ == NULL) {
						int _tmp7_;
						int* _tmp8_;
						_tmp7_ = SIGTERM;
						_tmp8_ = __signal_dup0 (&_tmp7_);
						_g_free0 (_tmp5_);
						_tmp5_ = _tmp8_;
					}
					_tmp9_ = process;
					_tmp10_ = usage_process_get_pid (_tmp9_);
					_tmp11_ = _tmp10_;
					kill ((pid_t) _tmp11_, *_tmp5_);
					_g_free0 (_tmp5_);
				}
			}
			(process_collection == NULL) ? NULL : (process_collection = (g_list_free (process_collection), NULL));
		}
	}
}

void
usage_app_item_mark_as_not_updated (UsageAppItem* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_processes;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* process_collection = NULL;
		GList* process_it = NULL;
		process_collection = _tmp1_;
		for (process_it = process_collection; process_it != NULL; process_it = process_it->next) {
			UsageProcess* process = NULL;
			process = (UsageProcess*) process_it->data;
			{
				UsageProcess* _tmp2_;
				_tmp2_ = process;
				usage_process_set_mark_as_updated (_tmp2_, FALSE);
			}
		}
		(process_collection == NULL) ? NULL : (process_collection = (g_list_free (process_collection), NULL));
	}
}

void
usage_app_item_remove_processes (UsageAppItem* self)
{
	gint games = 0;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	gdouble _tmp18_;
	g_return_if_fail (self != NULL);
	usage_app_item_set_cpu_load (self, (gdouble) 0);
	usage_app_item_set_mem_usage (self, (guint64) 0);
	games = 0;
	_tmp0_ = self->priv->_processes;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* process_collection = NULL;
		GList* process_it = NULL;
		process_collection = _tmp1_;
		for (process_it = process_collection; process_it != NULL; process_it = process_it->next) {
			UsageProcess* process = NULL;
			process = (UsageProcess*) process_it->data;
			{
				UsageProcess* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				UsageProcess* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp2_ = process;
				_tmp3_ = usage_process_get_mark_as_updated (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					UsageProcess* _tmp5_;
					_tmp5_ = process;
					usage_app_item_remove_process (self, _tmp5_);
				} else {
					gdouble _tmp6_;
					UsageProcess* _tmp7_;
					gdouble _tmp8_;
					gdouble _tmp9_;
					guint64 _tmp10_;
					UsageProcess* _tmp11_;
					guint64 _tmp12_;
					guint64 _tmp13_;
					_tmp6_ = self->priv->_cpu_load;
					_tmp7_ = process;
					_tmp8_ = usage_process_get_cpu_load (_tmp7_);
					_tmp9_ = _tmp8_;
					usage_app_item_set_cpu_load (self, _tmp6_ + _tmp9_);
					_tmp10_ = self->priv->_mem_usage;
					_tmp11_ = process;
					_tmp12_ = usage_process_get_mem_usage (_tmp11_);
					_tmp13_ = _tmp12_;
					usage_app_item_set_mem_usage (self, _tmp10_ + _tmp13_);
				}
				_tmp14_ = process;
				_tmp15_ = usage_process_get_gamemode (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					gint _tmp17_;
					_tmp17_ = games;
					games = _tmp17_ + 1;
				}
			}
		}
		(process_collection == NULL) ? NULL : (process_collection = (g_list_free (process_collection), NULL));
	}
	usage_app_item_set_gamemode (self, games > 0);
	_tmp18_ = self->priv->_cpu_load;
	usage_app_item_set_cpu_load (self, _tmp18_ / g_get_num_processors ());
}

void
usage_app_item_remove_process (UsageAppItem* self,
                               UsageProcess* process)
{
	GHashTable* _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (process != NULL);
	_tmp0_ = self->priv->_processes;
	_tmp1_ = usage_process_get_pid (process);
	_tmp2_ = _tmp1_;
	g_hash_table_remove (_tmp0_, &_tmp2_);
	g_object_notify ((GObject*) self, "running");
}

void
usage_app_item_replace_process (UsageAppItem* self,
                                UsageProcess* process)
{
	GHashTable* _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	GPid* _tmp3_;
	UsageProcess* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (process != NULL);
	_tmp0_ = self->priv->_processes;
	_tmp1_ = usage_process_get_pid (process);
	_tmp2_ = _tmp1_;
	_tmp3_ = __g_pid_dup0 (&_tmp2_);
	_tmp4_ = _g_object_ref0 (process);
	g_hash_table_replace (_tmp0_, _tmp3_, _tmp4_);
	g_object_notify ((GObject*) self, "running");
}

static gchar*
usage_app_item_find_display_name (UsageAppItem* self)
{
	GAppInfo* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->app_info;
	if (_tmp0_ != NULL) {
		GAppInfo* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->app_info;
		_tmp2_ = g_app_info_get_display_name (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->_representative_cmdline;
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		return result;
	}
}

static void
usage_app_item_load_user_account_data_free (gpointer _data)
{
	UsageAppItemLoadUserAccountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UsageAppItemLoadUserAccountData, _data_);
}

static void
usage_app_item_load_user_account (UsageAppItem* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	UsageAppItemLoadUserAccountData* _data_;
	UsageAppItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (UsageAppItemLoadUserAccountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, usage_app_item_load_user_account_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	usage_app_item_load_user_account_co (_data_);
}

static void
usage_app_item_load_user_account_finish (UsageAppItem* self,
                                         GAsyncResult* _res_)
{
	UsageAppItemLoadUserAccountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
usage_app_item_load_user_account_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	UsageAppItemLoadUserAccountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	usage_app_item_load_user_account_co (_data_);
}

static gboolean
usage_app_item_load_user_account_co (UsageAppItemLoadUserAccountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (USAGE_FDO_TYPE_ACCOUNTS_PROXY, 0, NULL, usage_app_item_load_user_account_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = (UsageFdoAccounts*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->accounts = (UsageFdoAccounts*) _data_->_tmp0_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp1_ = _data_->accounts;
		_data_->_tmp2_ = _data_->self->priv->_representative_uid;
		_data_->_state_ = 2;
		usage_fdo_accounts_FindUserById (_data_->_tmp1_, (gint64) _data_->_tmp2_, usage_app_item_load_user_account_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp3_ = usage_fdo_accounts_FindUserById_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
		_data_->user_account_path = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->accounts);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->user_account_path;
		_data_->_state_ = 3;
		g_async_initable_new_async (USAGE_FDO_TYPE_ACCOUNTS_USER_PROXY, 0, NULL, usage_app_item_load_user_account_ready, _data_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _data_->_tmp5_, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
		return FALSE;
		_state_3:
		_data_->_tmp6_ = (UsageFdoAccountsUser*) g_async_initable_new_finish ((GAsyncInitable *) _data_->_source_object_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = (UsageFdoAccountsUser*) _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->user_account_path);
			_g_object_unref0 (_data_->accounts);
			goto __catch0_g_error;
		}
		usage_app_item_set_user (_data_->self, _data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp4_);
		_g_free0 (_data_->user_account_path);
		_g_object_unref0 (_data_->accounts);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning ("app-item.vala:306: Unable to obtain user account: %s", _data_->_tmp8_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
usage_app_item_sanitize_cmd (gchar** commandline)
{
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	if ((*commandline) == NULL) {
		return;
	}
	if (string_contains (*commandline, "flatpak run")) {
		gint index = 0;
		gchar* _tmp0_;
		index = string_index_of (*commandline, "--command=", 0) + 10;
		_tmp0_ = string_substring (*commandline, (glong) index, (glong) -1);
		_g_free0 (*commandline);
		*commandline = _tmp0_;
	}
	if (string_contains (*commandline, "waydroid app launch ")) {
		gchar* _tmp1_;
		_tmp1_ = string_substring (*commandline, (glong) 20, (glong) -1);
		_g_free0 (*commandline);
		*commandline = _tmp1_;
	}
	_tmp2_ = usage_process_first_component (*commandline);
	_g_free0 (*commandline);
	*commandline = _tmp2_;
	_tmp3_ = g_path_get_basename (*commandline);
	_g_free0 (*commandline);
	*commandline = _tmp3_;
	_tmp4_ = usage_process_sanitize_name (*commandline);
	_g_free0 (*commandline);
	*commandline = _tmp4_;
	if (string_contains (*commandline, "google-chrome-stable")) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("chrome");
		_g_free0 (*commandline);
		*commandline = _tmp5_;
	}
}

GHashTable*
usage_app_item_get_processes (UsageAppItem* self)
{
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_processes;
	result = _tmp0_;
	return result;
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

void
usage_app_item_set_processes (UsageAppItem* self,
                              GHashTable* value)
{
	GHashTable* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_processes (self);
	if (old_value != value) {
		GHashTable* _tmp0_;
		_tmp0_ = _g_hash_table_ref0 (value);
		_g_hash_table_unref0 (self->priv->_processes);
		self->priv->_processes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_PROCESSES_PROPERTY]);
	}
}

const gchar*
usage_app_item_get_display_name (UsageAppItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

static void
usage_app_item_set_display_name (UsageAppItem* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_DISPLAY_NAME_PROPERTY]);
	}
}

const gchar*
usage_app_item_get_representative_cmdline (UsageAppItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_representative_cmdline;
	result = _tmp0_;
	return result;
}

static void
usage_app_item_set_representative_cmdline (UsageAppItem* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_representative_cmdline (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_representative_cmdline);
		self->priv->_representative_cmdline = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_REPRESENTATIVE_CMDLINE_PROPERTY]);
	}
}

guint
usage_app_item_get_representative_uid (UsageAppItem* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_representative_uid;
	return result;
}

static void
usage_app_item_set_representative_uid (UsageAppItem* self,
                                       guint value)
{
	guint old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_representative_uid (self);
	if (old_value != value) {
		self->priv->_representative_uid = value;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_REPRESENTATIVE_UID_PROPERTY]);
	}
}

gdouble
usage_app_item_get_cpu_load (UsageAppItem* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cpu_load;
	return result;
}

static void
usage_app_item_set_cpu_load (UsageAppItem* self,
                             gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_cpu_load (self);
	if (old_value != value) {
		self->priv->_cpu_load = value;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_CPU_LOAD_PROPERTY]);
	}
}

guint64
usage_app_item_get_mem_usage (UsageAppItem* self)
{
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	result = self->priv->_mem_usage;
	return result;
}

static void
usage_app_item_set_mem_usage (UsageAppItem* self,
                              guint64 value)
{
	guint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_mem_usage (self);
	if (old_value != value) {
		self->priv->_mem_usage = value;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_MEM_USAGE_PROPERTY]);
	}
}

UsageFdoAccountsUser*
usage_app_item_get_user (UsageAppItem* self)
{
	UsageFdoAccountsUser* result;
	UsageFdoAccountsUser* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user;
	result = _tmp0_;
	return result;
}

static void
usage_app_item_set_user (UsageAppItem* self,
                         UsageFdoAccountsUser* value)
{
	UsageFdoAccountsUser* old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_user (self);
	if (old_value != value) {
		UsageFdoAccountsUser* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_user);
		self->priv->_user = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_USER_PROPERTY]);
	}
}

gboolean
usage_app_item_get_gamemode (UsageAppItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_gamemode;
	return result;
}

static void
usage_app_item_set_gamemode (UsageAppItem* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_gamemode (self);
	if (old_value != value) {
		self->priv->_gamemode = value;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_GAMEMODE_PROPERTY]);
	}
}

gboolean
usage_app_item_get_is_background (UsageAppItem* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_background;
	return result;
}

void
usage_app_item_set_is_background (UsageAppItem* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = usage_app_item_get_is_background (self);
	if (old_value != value) {
		self->priv->_is_background = value;
		g_object_notify_by_pspec ((GObject *) self, usage_app_item_properties[USAGE_APP_ITEM_IS_BACKGROUND_PROPERTY]);
	}
}

gboolean
usage_app_item_get_running (UsageAppItem* self)
{
	UsageAppItemClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = USAGE_APP_ITEM_GET_CLASS (self);
	if (_klass_->get_running) {
		return _klass_->get_running (self);
	}
	return FALSE;
}

static gboolean
usage_app_item_real_get_running (UsageAppItem* base)
{
	gboolean result;
	UsageAppItem* self;
	GHashTable* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = base;
	_tmp0_ = self->priv->_processes;
	_tmp1_ = g_hash_table_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > ((guint) 0);
	return result;
}

GIcon*
usage_app_item_get_icon (UsageAppItem* self)
{
	UsageAppItemClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = USAGE_APP_ITEM_GET_CLASS (self);
	if (_klass_->get_icon) {
		return _klass_->get_icon (self);
	}
	return NULL;
}

static GIcon*
usage_app_item_real_get_icon (UsageAppItem* base)
{
	GIcon* result;
	UsageAppItem* self;
	gboolean _tmp0_ = FALSE;
	GAppInfo* _tmp1_;
	GAppInfo* _tmp5_;
	GIcon* _tmp6_;
	self = base;
	_tmp1_ = self->priv->app_info;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GAppInfo* _tmp2_;
		GIcon* _tmp3_;
		_tmp2_ = self->priv->app_info;
		_tmp3_ = g_app_info_get_icon (_tmp2_);
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		GIcon* _tmp4_;
		_tmp4_ = usage_app_item_default_icon;
		result = _tmp4_;
		return result;
	}
	_tmp5_ = self->priv->app_info;
	_tmp6_ = g_app_info_get_icon (_tmp5_);
	result = _tmp6_;
	return result;
}

const gchar*
usage_app_item_get_container (UsageAppItem* self)
{
	UsageAppItemClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = USAGE_APP_ITEM_GET_CLASS (self);
	if (_klass_->get_container) {
		return _klass_->get_container (self);
	}
	return NULL;
}

static const gchar*
usage_app_item_real_get_container (UsageAppItem* base)
{
	const gchar* result;
	UsageAppItem* self;
	GDesktopAppInfo* _tmp0_ = NULL;
	GAppInfo* _tmp1_;
	const gchar* _tmp2_ = NULL;
	self = base;
	_tmp1_ = self->priv->app_info;
	_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp1_) : NULL;
	_tmp2_ = NULL;
	if (_tmp0_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = g_desktop_app_info_get_categories (_tmp0_);
		_tmp2_ = _tmp3_;
	}
	if (g_strcmp0 (_tmp2_, "X-WayDroid-App;") == 0) {
		result = "Waydroid";
		return result;
	}
	result = NULL;
	return result;
}

static GObject *
usage_app_item_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	UsageAppItem * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	parent_class = G_OBJECT_CLASS (usage_app_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_APP_ITEM, UsageAppItem);
	_tmp0_ = g_int_hash;
	_tmp1_ = g_int_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_tmp3_ = _tmp2_;
	usage_app_item_set_processes (self, _tmp3_);
	_g_hash_table_unref0 (_tmp3_);
	return obj;
}

static void
usage_app_item_class_init (UsageAppItemClass * klass,
                           gpointer klass_data)
{
	GThemedIcon* _tmp0_;
	usage_app_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UsageAppItem_private_offset);
	USAGE_APP_ITEM_CLASS (klass)->get_running = (gboolean (*) (UsageAppItem*)) usage_app_item_real_get_running;
	USAGE_APP_ITEM_CLASS (klass)->get_icon = (GIcon* (*) (UsageAppItem*)) usage_app_item_real_get_icon;
	USAGE_APP_ITEM_CLASS (klass)->get_container = (const gchar* (*) (UsageAppItem*)) usage_app_item_real_get_container;
	G_OBJECT_CLASS (klass)->get_property = _vala_usage_app_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_usage_app_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = usage_app_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = usage_app_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_PROCESSES_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_PROCESSES_PROPERTY] = g_param_spec_boxed ("processes", "processes", "processes", G_TYPE_HASH_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_DISPLAY_NAME_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_REPRESENTATIVE_CMDLINE_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_REPRESENTATIVE_CMDLINE_PROPERTY] = g_param_spec_string ("representative-cmdline", "representative-cmdline", "representative-cmdline", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_REPRESENTATIVE_UID_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_REPRESENTATIVE_UID_PROPERTY] = g_param_spec_uint ("representative-uid", "representative-uid", "representative-uid", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_CPU_LOAD_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_CPU_LOAD_PROPERTY] = g_param_spec_double ("cpu-load", "cpu-load", "cpu-load", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_MEM_USAGE_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_MEM_USAGE_PROPERTY] = g_param_spec_uint64 ("mem-usage", "mem-usage", "mem-usage", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_USER_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_USER_PROPERTY] = g_param_spec_object ("user", "user", "user", USAGE_FDO_TYPE_ACCOUNTS_USER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_GAMEMODE_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_GAMEMODE_PROPERTY] = g_param_spec_boolean ("gamemode", "gamemode", "gamemode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_IS_BACKGROUND_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_IS_BACKGROUND_PROPERTY] = g_param_spec_boolean ("is-background", "is-background", "is-background", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_RUNNING_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_RUNNING_PROPERTY] = g_param_spec_boolean ("running", "running", "running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_ICON_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USAGE_APP_ITEM_CONTAINER_PROPERTY, usage_app_item_properties[USAGE_APP_ITEM_CONTAINER_PROPERTY] = g_param_spec_string ("container", "container", "container", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("system-run-symbolic");
	usage_app_item_default_icon = (GIcon*) _tmp0_;
}

static void
usage_app_item_instance_init (UsageAppItem * self,
                              gpointer klass)
{
	self->priv = usage_app_item_get_instance_private (self);
	self->priv->_user = NULL;
	self->priv->app_info = NULL;
}

static void
usage_app_item_finalize (GObject * obj)
{
	UsageAppItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_APP_ITEM, UsageAppItem);
	_g_hash_table_unref0 (self->priv->_processes);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_representative_cmdline);
	_g_object_unref0 (self->priv->_user);
	_g_object_unref0 (self->priv->app_info);
	G_OBJECT_CLASS (usage_app_item_parent_class)->finalize (obj);
}

static GType
usage_app_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageAppItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_app_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageAppItem), 0, (GInstanceInitFunc) usage_app_item_instance_init, NULL };
	GType usage_app_item_type_id;
	usage_app_item_type_id = g_type_register_static (G_TYPE_OBJECT, "UsageAppItem", &g_define_type_info, 0);
	UsageAppItem_private_offset = g_type_add_instance_private (usage_app_item_type_id, sizeof (UsageAppItemPrivate));
	return usage_app_item_type_id;
}

GType
usage_app_item_get_type (void)
{
	static volatile gsize usage_app_item_type_id__once = 0;
	if (g_once_init_enter (&usage_app_item_type_id__once)) {
		GType usage_app_item_type_id;
		usage_app_item_type_id = usage_app_item_get_type_once ();
		g_once_init_leave (&usage_app_item_type_id__once, usage_app_item_type_id);
	}
	return usage_app_item_type_id__once;
}

static void
_vala_usage_app_item_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	UsageAppItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_APP_ITEM, UsageAppItem);
	switch (property_id) {
		case USAGE_APP_ITEM_PROCESSES_PROPERTY:
		g_value_set_boxed (value, usage_app_item_get_processes (self));
		break;
		case USAGE_APP_ITEM_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, usage_app_item_get_display_name (self));
		break;
		case USAGE_APP_ITEM_REPRESENTATIVE_CMDLINE_PROPERTY:
		g_value_set_string (value, usage_app_item_get_representative_cmdline (self));
		break;
		case USAGE_APP_ITEM_REPRESENTATIVE_UID_PROPERTY:
		g_value_set_uint (value, usage_app_item_get_representative_uid (self));
		break;
		case USAGE_APP_ITEM_CPU_LOAD_PROPERTY:
		g_value_set_double (value, usage_app_item_get_cpu_load (self));
		break;
		case USAGE_APP_ITEM_MEM_USAGE_PROPERTY:
		g_value_set_uint64 (value, usage_app_item_get_mem_usage (self));
		break;
		case USAGE_APP_ITEM_USER_PROPERTY:
		g_value_set_object (value, usage_app_item_get_user (self));
		break;
		case USAGE_APP_ITEM_GAMEMODE_PROPERTY:
		g_value_set_boolean (value, usage_app_item_get_gamemode (self));
		break;
		case USAGE_APP_ITEM_IS_BACKGROUND_PROPERTY:
		g_value_set_boolean (value, usage_app_item_get_is_background (self));
		break;
		case USAGE_APP_ITEM_RUNNING_PROPERTY:
		g_value_set_boolean (value, usage_app_item_get_running (self));
		break;
		case USAGE_APP_ITEM_ICON_PROPERTY:
		g_value_set_object (value, usage_app_item_get_icon (self));
		break;
		case USAGE_APP_ITEM_CONTAINER_PROPERTY:
		g_value_set_string (value, usage_app_item_get_container (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_usage_app_item_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	UsageAppItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, USAGE_TYPE_APP_ITEM, UsageAppItem);
	switch (property_id) {
		case USAGE_APP_ITEM_PROCESSES_PROPERTY:
		usage_app_item_set_processes (self, g_value_get_boxed (value));
		break;
		case USAGE_APP_ITEM_DISPLAY_NAME_PROPERTY:
		usage_app_item_set_display_name (self, g_value_get_string (value));
		break;
		case USAGE_APP_ITEM_REPRESENTATIVE_CMDLINE_PROPERTY:
		usage_app_item_set_representative_cmdline (self, g_value_get_string (value));
		break;
		case USAGE_APP_ITEM_REPRESENTATIVE_UID_PROPERTY:
		usage_app_item_set_representative_uid (self, g_value_get_uint (value));
		break;
		case USAGE_APP_ITEM_CPU_LOAD_PROPERTY:
		usage_app_item_set_cpu_load (self, g_value_get_double (value));
		break;
		case USAGE_APP_ITEM_MEM_USAGE_PROPERTY:
		usage_app_item_set_mem_usage (self, g_value_get_uint64 (value));
		break;
		case USAGE_APP_ITEM_USER_PROPERTY:
		usage_app_item_set_user (self, g_value_get_object (value));
		break;
		case USAGE_APP_ITEM_GAMEMODE_PROPERTY:
		usage_app_item_set_gamemode (self, g_value_get_boolean (value));
		break;
		case USAGE_APP_ITEM_IS_BACKGROUND_PROPERTY:
		usage_app_item_set_is_background (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

