/* taquin-game.c generated by valac 0.56.3, the Vala compiler
 * generated from taquin-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of GNOME Taquin.

   Copyright (C) 2014-2016 – Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME Taquin is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Taquin is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Taquin.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GAME_TYPE_FIFTEEN,
	GAME_TYPE_SIXTEEN
} GameType;

#define TYPE_GAME_TYPE (game_type_get_type ())

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define GAME_TYPE_UNDO_ITEM (game_undo_item_get_type ())
typedef struct _GameUndoItem GameUndoItem;
enum  {
	GAME_0_PROPERTY,
	GAME_SIZE_PROPERTY,
	GAME_GAME_TYPE_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
typedef enum  {
	GAME_BAD_CLICK_EMPTY_TILE,
	GAME_BAD_CLICK_NOT_MOVING,
	GAME_BAD_CLICK_IS_OUTSIDE,
	GAME_BAD_CLICK_USE_ARROWS
} GameBadClick;

#define GAME_TYPE_BAD_CLICK (game_bad_click_get_type ())
#define _game_undo_item_free0(var) ((var == NULL) ? NULL : (var = (game_undo_item_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
enum  {
	GAME_COMPLETE_SIGNAL,
	GAME_MOVE_SIGNAL,
	GAME_BAD_CLICK_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GameUndoItem {
	gint8 x;
	gint8 y;
	GameUndoItem* next;
	GameUndoItem* previous;
};

struct _GamePrivate {
	gint8 _size;
	GameType _game_type;
	gint8* tiles;
	gint tiles_length1;
	gint tiles_length2;
	GameUndoItem* state;
	GameUndoItem* previous_state;
	guint moves_count;
	gint8 x_gap;
	gint8 y_gap;
};

static gint Game_private_offset;
static gpointer game_parent_class = NULL;

VALA_EXTERN GType game_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* game_type_to_string (GameType self);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
static GType game_undo_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GameUndoItem* game_undo_item_dup (const GameUndoItem* self);
static void game_undo_item_free (GameUndoItem* self);
static void game_undo_item_copy (const GameUndoItem* self,
                          GameUndoItem* dest);
static void game_undo_item_destroy (GameUndoItem* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (GameUndoItem, game_undo_item_destroy)
VALA_EXTERN GType game_bad_click_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gint8 game_get_tile_value (Game* self,
                           gint8 x,
                           gint8 y);
VALA_EXTERN Game* game_new (GameType game_type,
                gint8 size);
VALA_EXTERN Game* game_construct (GType object_type,
                      GameType game_type,
                      gint8 size);
static void game_generate_game (GameType game_type,
                         gint8 size,
                         gint8** tiles,
                         gint* tiles_length1,
                         gint* tiles_length2);
static gint8* _int8_dup (gint8* self);
VALA_EXTERN gchar* game_to_string (Game* self);
VALA_EXTERN gint8 game_get_size (Game* self);
VALA_EXTERN void game_request_move (Game* self,
                        gint8 x,
                        gint8 y,
                        gboolean keyboard_call);
VALA_EXTERN GameType game_get_game_type (Game* self);
static void game_fifteen_move (Game* self,
                        gint8 x,
                        gint8 y,
                        gboolean undoing,
                        gboolean restarting);
static void game_sixteen_move (Game* self,
                        gint8 x,
                        gint8 y,
                        gboolean undoing,
                        gboolean restarting);
static gboolean game_check_complete (gint8** tiles,
                              gint* tiles_length1,
                              gint* tiles_length2);
static void game_add_move (Game* self,
                    gint8 x_gap,
                    gint8 y_gap);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_restart (Game* self);
static void game_set_size (Game* self,
                    gint8 value);
static void game_set_game_type (Game* self,
                         GameType value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_CHAR_CHAR_CHAR_UINT_BOOLEAN (GClosure * closure,
                                                                        GValue * return_value,
                                                                        guint n_param_values,
                                                                        const GValue * param_values,
                                                                        gpointer invocation_hint,
                                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__ENUM_BOOLEAN (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static GObject * game_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties);
static void game_finalize (GObject * obj);
static GType game_get_type_once (void);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
game_type_to_string (GameType self)
{
	gchar* result;
	switch (self) {
		case GAME_TYPE_FIFTEEN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("fifteen");
			result = _tmp0_;
			return result;
		}
		case GAME_TYPE_SIXTEEN:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("sixteen");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
game_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_TYPE_FIFTEEN, "GAME_TYPE_FIFTEEN", "fifteen"}, {GAME_TYPE_SIXTEEN, "GAME_TYPE_SIXTEEN", "sixteen"}, {0, NULL, NULL}};
	GType game_type_type_id;
	game_type_type_id = g_enum_register_static ("GameType", values);
	return game_type_type_id;
}

GType
game_type_get_type (void)
{
	static volatile gsize game_type_type_id__once = 0;
	if (g_once_init_enter (&game_type_type_id__once)) {
		GType game_type_type_id;
		game_type_type_id = game_type_get_type_once ();
		g_once_init_leave (&game_type_type_id__once, game_type_type_id);
	}
	return game_type_type_id__once;
}

static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}

static GType
game_bad_click_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_BAD_CLICK_EMPTY_TILE, "GAME_BAD_CLICK_EMPTY_TILE", "empty-tile"}, {GAME_BAD_CLICK_NOT_MOVING, "GAME_BAD_CLICK_NOT_MOVING", "not-moving"}, {GAME_BAD_CLICK_IS_OUTSIDE, "GAME_BAD_CLICK_IS_OUTSIDE", "is-outside"}, {GAME_BAD_CLICK_USE_ARROWS, "GAME_BAD_CLICK_USE_ARROWS", "use-arrows"}, {0, NULL, NULL}};
	GType game_bad_click_type_id;
	game_bad_click_type_id = g_enum_register_static ("GameBadClick", values);
	return game_bad_click_type_id;
}

GType
game_bad_click_get_type (void)
{
	static volatile gsize game_bad_click_type_id__once = 0;
	if (g_once_init_enter (&game_bad_click_type_id__once)) {
		GType game_bad_click_type_id;
		game_bad_click_type_id = game_bad_click_get_type_once ();
		g_once_init_leave (&game_bad_click_type_id__once, game_bad_click_type_id);
	}
	return game_bad_click_type_id__once;
}

gint8
game_get_tile_value (Game* self,
                     gint8 x,
                     gint8 y)
{
	gint8* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint8 _tmp1_;
	gint8 result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->tiles;
	_tmp0__length1 = self->priv->tiles_length1;
	_tmp0__length2 = self->priv->tiles_length2;
	_tmp1_ = _tmp0_[(x * _tmp0__length2) + y];
	result = _tmp1_;
	return result;
}

Game*
game_construct (GType object_type,
                GameType game_type,
                gint8 size)
{
	Game * self = NULL;
	_vala_return_val_if_fail (((gint) size) >= 2, "size >= 2", NULL);
	_vala_return_val_if_fail (((gint) size) <= 9, "size <= 9", NULL);
	self = (Game*) g_object_new (object_type, "game-type", game_type, "size", size, NULL);
	return self;
}

Game*
game_new (GameType game_type,
          gint8 size)
{
	return game_construct (TYPE_GAME, game_type, size);
}

static gint8*
_int8_dup (gint8* self)
{
	gint8* dup;
	dup = g_new0 (gint8, 1);
	memcpy (dup, self, sizeof (gint8));
	return dup;
}

static gpointer
__int8_dup0 (gpointer self)
{
	return self ? _int8_dup (self) : NULL;
}

static void
game_generate_game (GameType game_type,
                    gint8 size,
                    gint8** tiles,
                    gint* tiles_length1,
                    gint* tiles_length2)
{
	gint8* _vala_tiles = NULL;
	gint _vala_tiles_length1 = 0;
	gint _vala_tiles_length2 = 0;
	gint8 ntiles = 0;
	gint8** line = NULL;
	gint8** _tmp0_;
	gint line_length1;
	gint _line_size_;
	gint i = 0;
	gboolean parity_grid = FALSE;
	gboolean parity_game = FALSE;
	gint8* _tmp33_;
	ntiles = size * size;
	_tmp0_ = g_new0 (gint8*, ntiles);
	line = _tmp0_;
	line_length1 = ntiles;
	_line_size_ = line_length1;
	i = 0;
	{
		gint8 n = 0;
		n = (gint8) (ntiles - 1);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint8** _tmp6_;
				gint _tmp6__length1;
				gint8* _tmp7_;
				if (!_tmp1_) {
					gint8 _tmp2_;
					_tmp2_ = n;
					n = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(((gint) n) >= 0)) {
					break;
				}
				{
					gboolean _tmp3_ = FALSE;
					_tmp3_ = TRUE;
					while (TRUE) {
						if (!_tmp3_) {
							gint8** _tmp4_;
							gint _tmp4__length1;
							gint8* _tmp5_;
							_tmp4_ = line;
							_tmp4__length1 = line_length1;
							_tmp5_ = _tmp4_[i];
							if (!(_tmp5_ != NULL)) {
								break;
							}
						}
						_tmp3_ = FALSE;
						i = (gint) g_random_int_range ((gint32) 0, (gint32) ((gint) ntiles));
					}
				}
				_tmp6_ = line;
				_tmp6__length1 = line_length1;
				_tmp7_ = __int8_dup0 (&n);
				_g_free0 (_tmp6_[i]);
				_tmp6_[i] = _tmp7_;
			}
		}
	}
	if (game_type == GAME_TYPE_FIFTEEN) {
		gint8** _tmp8_;
		gint _tmp8__length1;
		gint8** _tmp9_;
		gint _tmp9__length1;
		gint8* _tmp10_;
		gint8* _tmp11_;
		gint8** _tmp12_;
		gint _tmp12__length1;
		gint8 _tmp13_;
		gint8* _tmp14_;
		_tmp8_ = line;
		_tmp8__length1 = line_length1;
		_tmp9_ = line;
		_tmp9__length1 = line_length1;
		_tmp10_ = _tmp9_[0];
		_tmp11_ = __int8_dup0 (_tmp10_);
		_g_free0 (_tmp8_[i]);
		_tmp8_[i] = _tmp11_;
		_tmp12_ = line;
		_tmp12__length1 = line_length1;
		_tmp13_ = (gint8) -1;
		_tmp14_ = __int8_dup0 (&_tmp13_);
		_g_free0 (_tmp12_[0]);
		_tmp12_[0] = _tmp14_;
	}
	parity_grid = ((gboolean) ((size % 2) ^ (size % 2))) & (1 == 0);
	parity_game = FALSE;
	{
		guint8 j = 0U;
		j = (guint8) 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				if (!_tmp15_) {
					guint8 _tmp16_;
					_tmp16_ = j;
					j = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				if (!(((gint) j) < (ntiles - 1))) {
					break;
				}
				{
					guint8 k = 0U;
					k = (guint8) (j + 1);
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint8** _tmp19_;
							gint _tmp19__length1;
							gint8* _tmp20_;
							gint8** _tmp21_;
							gint _tmp21__length1;
							gint8* _tmp22_;
							if (!_tmp17_) {
								guint8 _tmp18_;
								_tmp18_ = k;
								k = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							if (!(k < ((guint8) ntiles))) {
								break;
							}
							_tmp19_ = line;
							_tmp19__length1 = line_length1;
							_tmp20_ = _tmp19_[j];
							_tmp21_ = line;
							_tmp21__length1 = line_length1;
							_tmp22_ = _tmp21_[k];
							if ((*_tmp20_) > (*_tmp22_)) {
								parity_game = !parity_game;
							}
						}
					}
				}
			}
		}
	}
	if (parity_game != parity_grid) {
		gint8* save = NULL;
		gint8** _tmp23_;
		gint _tmp23__length1;
		gint8* _tmp24_;
		gint8* _tmp25_;
		gint8** _tmp26_;
		gint _tmp26__length1;
		gint8** _tmp27_;
		gint _tmp27__length1;
		gint8* _tmp28_;
		gint8* _tmp29_;
		gint8** _tmp30_;
		gint _tmp30__length1;
		gint8* _tmp31_;
		gint8* _tmp32_;
		_tmp23_ = line;
		_tmp23__length1 = line_length1;
		_tmp24_ = _tmp23_[1];
		_tmp25_ = __int8_dup0 (_tmp24_);
		save = _tmp25_;
		_tmp26_ = line;
		_tmp26__length1 = line_length1;
		_tmp27_ = line;
		_tmp27__length1 = line_length1;
		_tmp28_ = _tmp27_[size + 1];
		_tmp29_ = __int8_dup0 (_tmp28_);
		_g_free0 (_tmp26_[1]);
		_tmp26_[1] = _tmp29_;
		_tmp30_ = line;
		_tmp30__length1 = line_length1;
		_tmp31_ = save;
		_tmp32_ = __int8_dup0 (_tmp31_);
		_g_free0 (_tmp30_[size + 1]);
		_tmp30_[size + 1] = _tmp32_;
		_g_free0 (save);
	}
	_tmp33_ = g_new0 (gint8, size * size);
	_vala_tiles = (g_free (_vala_tiles), NULL);
	_vala_tiles = _tmp33_;
	_vala_tiles_length1 = size;
	_vala_tiles_length2 = size;
	{
		guint8 j = 0U;
		j = (guint8) 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint8* line_j = NULL;
				gint8** _tmp36_;
				gint _tmp36__length1;
				gint8* _tmp37_;
				gint8* _tmp38_;
				gint8* _tmp39_;
				gint8* _tmp40_;
				gint _tmp40__length1;
				gint _tmp40__length2;
				gint8* _tmp41_;
				if (!_tmp34_) {
					guint8 _tmp35_;
					_tmp35_ = j;
					j = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				if (!(j < ((guint8) ntiles))) {
					break;
				}
				_tmp36_ = line;
				_tmp36__length1 = line_length1;
				_tmp37_ = _tmp36_[j];
				_tmp38_ = __int8_dup0 (_tmp37_);
				line_j = _tmp38_;
				_tmp39_ = line_j;
				if (_tmp39_ == NULL) {
					g_assert_not_reached ();
				}
				_tmp40_ = _vala_tiles;
				_tmp40__length1 = _vala_tiles_length1;
				_tmp40__length2 = _vala_tiles_length2;
				_tmp41_ = line_j;
				_tmp40_[((j % size) * _tmp40__length2) + (j / size)] = (gint8) (*_tmp41_);
				_g_free0 (line_j);
			}
		}
	}
	line = (_vala_array_free (line, line_length1, (GDestroyNotify) g_free), NULL);
	if (tiles) {
		*tiles = _vala_tiles;
	} else {
		_vala_tiles = (g_free (_vala_tiles), NULL);
	}
	if (tiles_length1) {
		*tiles_length1 = _vala_tiles_length1;
	}
	if (tiles_length2) {
		*tiles_length2 = _vala_tiles_length2;
	}
}

gchar*
game_to_string (Game* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	s = _tmp0_;
	{
		guint8 x = 0U;
		x = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint8 _tmp3_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_size;
				if (!(x < ((guint8) _tmp3_))) {
					break;
				}
				{
					guint8 y = 0U;
					y = (guint8) 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint8 _tmp6_;
							const gchar* _tmp7_;
							gint8* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint8 _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							if (!_tmp4_) {
								guint8 _tmp5_;
								_tmp5_ = y;
								y = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->_size;
							if (!(y < ((guint8) _tmp6_))) {
								break;
							}
							_tmp7_ = s;
							_tmp8_ = self->priv->tiles;
							_tmp8__length1 = self->priv->tiles_length1;
							_tmp8__length2 = self->priv->tiles_length2;
							_tmp9_ = _tmp8_[(y * _tmp8__length2) + x];
							_tmp10_ = g_strdup_printf ("%i", _tmp9_ + 1);
							_tmp11_ = _tmp10_;
							_tmp12_ = g_strconcat (" ", _tmp11_, NULL);
							_tmp13_ = _tmp12_;
							_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
							_g_free0 (s);
							s = _tmp14_;
							_g_free0 (_tmp13_);
							_g_free0 (_tmp11_);
						}
					}
				}
				_tmp15_ = s;
				_tmp16_ = g_strconcat (_tmp15_, "\n", NULL);
				_g_free0 (s);
				s = _tmp16_;
			}
		}
	}
	result = s;
	return result;
}

void
game_request_move (Game* self,
                   gint8 x,
                   gint8 y,
                   gboolean keyboard_call)
{
	GameType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_type;
	if (_tmp0_ == GAME_TYPE_FIFTEEN) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		if (((gint) x) < 0) {
			_tmp3_ = TRUE;
		} else {
			gint8 _tmp4_;
			_tmp4_ = self->priv->_size;
			_tmp3_ = x >= _tmp4_;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = ((gint) y) < 0;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			gint8 _tmp5_;
			_tmp5_ = self->priv->_size;
			_tmp1_ = y >= _tmp5_;
		}
		if (_tmp1_) {
			g_signal_emit (self, game_signals[GAME_BAD_CLICK_SIGNAL], 0, GAME_BAD_CLICK_IS_OUTSIDE, keyboard_call);
			return;
		}
		if (x == self->priv->x_gap) {
			_tmp6_ = y == self->priv->y_gap;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			g_signal_emit (self, game_signals[GAME_BAD_CLICK_SIGNAL], 0, GAME_BAD_CLICK_EMPTY_TILE, keyboard_call);
			return;
		}
		if (x != self->priv->x_gap) {
			_tmp7_ = y != self->priv->y_gap;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			g_signal_emit (self, game_signals[GAME_BAD_CLICK_SIGNAL], 0, GAME_BAD_CLICK_NOT_MOVING, keyboard_call);
			return;
		}
		game_fifteen_move (self, x, y, FALSE, FALSE);
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		if (((gint) x) >= 0) {
			gint8 _tmp11_;
			_tmp11_ = self->priv->_size;
			_tmp10_ = x < _tmp11_;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			_tmp9_ = ((gint) y) >= 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gint8 _tmp12_;
			_tmp12_ = self->priv->_size;
			_tmp8_ = y < _tmp12_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			g_signal_emit (self, game_signals[GAME_BAD_CLICK_SIGNAL], 0, GAME_BAD_CLICK_USE_ARROWS, keyboard_call);
			return;
		}
		game_sixteen_move (self, x, y, FALSE, FALSE);
	}
}

static void
game_fifteen_move (Game* self,
                   gint8 x,
                   gint8 y,
                   gboolean undoing,
                   gboolean restarting)
{
	gint8 _tmp0_;
	gint8 _tmp1_;
	gboolean was_complete = FALSE;
	gboolean _tmp2_;
	gboolean move_x_axis = FALSE;
	gint8 _tmp3_ = 0;
	gint8 move_number = 0;
	gint8* _tmp26_;
	gint _tmp26__length1;
	gint _tmp26__length2;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail ((!restarting) || undoing, "!restarting || undoing");
	_tmp0_ = self->priv->_size;
	_vala_return_if_fail ((((gint) x) >= 0) && (x < _tmp0_), "(x >= 0) && (x < size)");
	_tmp1_ = self->priv->_size;
	_vala_return_if_fail ((((gint) y) >= 0) && (y < _tmp1_), "(y >= 0) && (y < size)");
	_tmp2_ = game_check_complete (&self->priv->tiles, (gint*) (&self->priv->tiles_length1), (gint*) (&self->priv->tiles_length2));
	was_complete = _tmp2_;
	move_x_axis = x != self->priv->x_gap;
	if (move_x_axis) {
		_tmp3_ = self->priv->x_gap - x;
	} else {
		_tmp3_ = self->priv->y_gap - y;
	}
	move_number = _tmp3_;
	if (undoing) {
		if (self->priv->moves_count == ((guint) 0)) {
			g_assert_not_reached ();
		}
		if (self->priv->moves_count != G_MAXUINT) {
			guint _tmp4_;
			_tmp4_ = self->priv->moves_count;
			self->priv->moves_count = _tmp4_ - 1;
		}
	} else {
		game_add_move (self, self->priv->x_gap, self->priv->y_gap);
		if (self->priv->moves_count != G_MAXUINT) {
			guint _tmp5_;
			_tmp5_ = self->priv->moves_count;
			self->priv->moves_count = _tmp5_ + 1;
		}
	}
	if (move_x_axis) {
		if (x < self->priv->x_gap) {
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gint8* _tmp7_;
					gint _tmp7__length1;
					gint _tmp7__length2;
					gint8* _tmp8_;
					gint _tmp8__length1;
					gint _tmp8__length2;
					gint8 _tmp9_;
					gint8 _tmp10_;
					if (!_tmp6_) {
						if (!(self->priv->x_gap != x)) {
							break;
						}
					}
					_tmp6_ = FALSE;
					_tmp7_ = self->priv->tiles;
					_tmp7__length1 = self->priv->tiles_length1;
					_tmp7__length2 = self->priv->tiles_length2;
					_tmp8_ = self->priv->tiles;
					_tmp8__length1 = self->priv->tiles_length1;
					_tmp8__length2 = self->priv->tiles_length2;
					_tmp9_ = _tmp8_[((self->priv->x_gap - 1) * _tmp8__length2) + y];
					_tmp7_[(self->priv->x_gap * _tmp7__length2) + y] = _tmp9_;
					_tmp10_ = self->priv->x_gap;
					self->priv->x_gap = _tmp10_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp11_ = FALSE;
				_tmp11_ = TRUE;
				while (TRUE) {
					gint8* _tmp12_;
					gint _tmp12__length1;
					gint _tmp12__length2;
					gint8* _tmp13_;
					gint _tmp13__length1;
					gint _tmp13__length2;
					gint8 _tmp14_;
					gint8 _tmp15_;
					if (!_tmp11_) {
						if (!(self->priv->x_gap != x)) {
							break;
						}
					}
					_tmp11_ = FALSE;
					_tmp12_ = self->priv->tiles;
					_tmp12__length1 = self->priv->tiles_length1;
					_tmp12__length2 = self->priv->tiles_length2;
					_tmp13_ = self->priv->tiles;
					_tmp13__length1 = self->priv->tiles_length1;
					_tmp13__length2 = self->priv->tiles_length2;
					_tmp14_ = _tmp13_[((self->priv->x_gap + 1) * _tmp13__length2) + y];
					_tmp12_[(self->priv->x_gap * _tmp12__length2) + y] = _tmp14_;
					_tmp15_ = self->priv->x_gap;
					self->priv->x_gap = _tmp15_ + 1;
				}
			}
		}
	} else {
		if (y < self->priv->y_gap) {
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					gint8* _tmp17_;
					gint _tmp17__length1;
					gint _tmp17__length2;
					gint8* _tmp18_;
					gint _tmp18__length1;
					gint _tmp18__length2;
					gint8 _tmp19_;
					gint8 _tmp20_;
					if (!_tmp16_) {
						if (!(self->priv->y_gap != y)) {
							break;
						}
					}
					_tmp16_ = FALSE;
					_tmp17_ = self->priv->tiles;
					_tmp17__length1 = self->priv->tiles_length1;
					_tmp17__length2 = self->priv->tiles_length2;
					_tmp18_ = self->priv->tiles;
					_tmp18__length1 = self->priv->tiles_length1;
					_tmp18__length2 = self->priv->tiles_length2;
					_tmp19_ = _tmp18_[(x * _tmp18__length2) + (self->priv->y_gap - 1)];
					_tmp17_[(x * _tmp17__length2) + self->priv->y_gap] = _tmp19_;
					_tmp20_ = self->priv->y_gap;
					self->priv->y_gap = _tmp20_ - 1;
				}
			}
		} else {
			{
				gboolean _tmp21_ = FALSE;
				_tmp21_ = TRUE;
				while (TRUE) {
					gint8* _tmp22_;
					gint _tmp22__length1;
					gint _tmp22__length2;
					gint8* _tmp23_;
					gint _tmp23__length1;
					gint _tmp23__length2;
					gint8 _tmp24_;
					gint8 _tmp25_;
					if (!_tmp21_) {
						if (!(self->priv->y_gap != y)) {
							break;
						}
					}
					_tmp21_ = FALSE;
					_tmp22_ = self->priv->tiles;
					_tmp22__length1 = self->priv->tiles_length1;
					_tmp22__length2 = self->priv->tiles_length2;
					_tmp23_ = self->priv->tiles;
					_tmp23__length1 = self->priv->tiles_length1;
					_tmp23__length2 = self->priv->tiles_length2;
					_tmp24_ = _tmp23_[(x * _tmp23__length2) + (self->priv->y_gap + 1)];
					_tmp22_[(x * _tmp22__length2) + self->priv->y_gap] = _tmp24_;
					_tmp25_ = self->priv->y_gap;
					self->priv->y_gap = _tmp25_ + 1;
				}
			}
		}
	}
	_tmp26_ = self->priv->tiles;
	_tmp26__length1 = self->priv->tiles_length1;
	_tmp26__length2 = self->priv->tiles_length2;
	_tmp26_[(self->priv->x_gap * _tmp26__length2) + self->priv->y_gap] = (gint8) -1;
	if (restarting) {
		_tmp27_ = TRUE;
	} else {
		gboolean _tmp28_ = FALSE;
		if (was_complete) {
			_tmp28_ = undoing;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp27_ = _tmp28_;
	}
	g_signal_emit (self, game_signals[GAME_MOVE_SIGNAL], 0, move_x_axis, move_number, self->priv->x_gap, self->priv->y_gap, self->priv->moves_count, _tmp27_);
	_tmp29_ = game_check_complete (&self->priv->tiles, (gint*) (&self->priv->tiles_length1), (gint*) (&self->priv->tiles_length2));
	if (_tmp29_) {
		g_signal_emit (self, game_signals[GAME_COMPLETE_SIGNAL], 0);
	}
}

static void
game_sixteen_move (Game* self,
                   gint8 x,
                   gint8 y,
                   gboolean undoing,
                   gboolean restarting)
{
	gint8 _tmp0_;
	gint8 _tmp1_;
	gboolean move_x_axis = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean was_complete = FALSE;
	gboolean _tmp8_;
	gint8 new_coord = 0;
	gint _tmp59_ = 0;
	gint8 _tmp62_ = 0;
	gint8 _tmp63_ = 0;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp66_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail ((!restarting) || undoing, "!restarting || undoing");
	_tmp0_ = self->priv->_size;
	_tmp1_ = self->priv->_size;
	_vala_return_if_fail ((((((gint) x) < 0) || (x >= _tmp0_)) || (((gint) y) < 0)) || (y >= _tmp1_), "(x < 0) || (x >= size) || (y < 0) || (y >= size)");
	if (((gint) x) < 0) {
		_tmp2_ = TRUE;
	} else {
		gint8 _tmp3_;
		_tmp3_ = self->priv->_size;
		_tmp2_ = x >= _tmp3_;
	}
	if (_tmp2_) {
		gboolean _tmp4_ = FALSE;
		if (((gint) y) < 0) {
			_tmp4_ = TRUE;
		} else {
			gint8 _tmp5_;
			_tmp5_ = self->priv->_size;
			_tmp4_ = y >= _tmp5_;
		}
		if (_tmp4_) {
			return;
		}
		move_x_axis = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		if (((gint) y) >= 0) {
			gint8 _tmp7_;
			_tmp7_ = self->priv->_size;
			_tmp6_ = y < _tmp7_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			return;
		}
		move_x_axis = FALSE;
	}
	_tmp8_ = game_check_complete (&self->priv->tiles, (gint*) (&self->priv->tiles_length1), (gint*) (&self->priv->tiles_length2));
	was_complete = _tmp8_;
	new_coord = (gint8) 0;
	if (move_x_axis) {
		if (((gint) x) < 0) {
			gint8 tmp = 0;
			gint8* _tmp9_;
			gint _tmp9__length1;
			gint _tmp9__length2;
			gint8 _tmp10_;
			gint8* _tmp17_;
			gint _tmp17__length1;
			gint _tmp17__length2;
			gint8 _tmp18_;
			gint8 _tmp19_;
			_tmp9_ = self->priv->tiles;
			_tmp9__length1 = self->priv->tiles_length1;
			_tmp9__length2 = self->priv->tiles_length2;
			_tmp10_ = _tmp9_[(0 * _tmp9__length2) + y];
			tmp = _tmp10_;
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp11_ = FALSE;
					_tmp11_ = TRUE;
					while (TRUE) {
						gint8 _tmp13_;
						gint8* _tmp14_;
						gint _tmp14__length1;
						gint _tmp14__length2;
						gint8* _tmp15_;
						gint _tmp15__length1;
						gint _tmp15__length2;
						gint8 _tmp16_;
						if (!_tmp11_) {
							guint8 _tmp12_;
							_tmp12_ = i;
							i = _tmp12_ + 1;
						}
						_tmp11_ = FALSE;
						_tmp13_ = self->priv->_size;
						if (!(((gint) i) < (_tmp13_ - 1))) {
							break;
						}
						_tmp14_ = self->priv->tiles;
						_tmp14__length1 = self->priv->tiles_length1;
						_tmp14__length2 = self->priv->tiles_length2;
						_tmp15_ = self->priv->tiles;
						_tmp15__length1 = self->priv->tiles_length1;
						_tmp15__length2 = self->priv->tiles_length2;
						_tmp16_ = _tmp15_[((i + 1) * _tmp15__length2) + y];
						_tmp14_[(i * _tmp14__length2) + y] = _tmp16_;
					}
				}
			}
			_tmp17_ = self->priv->tiles;
			_tmp17__length1 = self->priv->tiles_length1;
			_tmp17__length2 = self->priv->tiles_length2;
			_tmp18_ = self->priv->_size;
			_tmp17_[((_tmp18_ - 1) * _tmp17__length2) + y] = tmp;
			_tmp19_ = self->priv->_size;
			new_coord = (gint8) (_tmp19_ - 1);
		} else {
			gint8 tmp = 0;
			gint8* _tmp20_;
			gint _tmp20__length1;
			gint _tmp20__length2;
			gint8 _tmp21_;
			gint8 _tmp22_;
			gint8* _tmp29_;
			gint _tmp29__length1;
			gint _tmp29__length2;
			_tmp20_ = self->priv->tiles;
			_tmp20__length1 = self->priv->tiles_length1;
			_tmp20__length2 = self->priv->tiles_length2;
			_tmp21_ = self->priv->_size;
			_tmp22_ = _tmp20_[((_tmp21_ - 1) * _tmp20__length2) + y];
			tmp = _tmp22_;
			{
				guint8 i = 0U;
				gint8 _tmp23_;
				_tmp23_ = self->priv->_size;
				i = (guint8) (_tmp23_ - 1);
				{
					gboolean _tmp24_ = FALSE;
					_tmp24_ = TRUE;
					while (TRUE) {
						gint8* _tmp26_;
						gint _tmp26__length1;
						gint _tmp26__length2;
						gint8* _tmp27_;
						gint _tmp27__length1;
						gint _tmp27__length2;
						gint8 _tmp28_;
						if (!_tmp24_) {
							guint8 _tmp25_;
							_tmp25_ = i;
							i = _tmp25_ - 1;
						}
						_tmp24_ = FALSE;
						if (!(((gint) i) > 0)) {
							break;
						}
						_tmp26_ = self->priv->tiles;
						_tmp26__length1 = self->priv->tiles_length1;
						_tmp26__length2 = self->priv->tiles_length2;
						_tmp27_ = self->priv->tiles;
						_tmp27__length1 = self->priv->tiles_length1;
						_tmp27__length2 = self->priv->tiles_length2;
						_tmp28_ = _tmp27_[((i - 1) * _tmp27__length2) + y];
						_tmp26_[(i * _tmp26__length2) + y] = _tmp28_;
					}
				}
			}
			_tmp29_ = self->priv->tiles;
			_tmp29__length1 = self->priv->tiles_length1;
			_tmp29__length2 = self->priv->tiles_length2;
			_tmp29_[(0 * _tmp29__length2) + y] = tmp;
			new_coord = (gint8) 0;
		}
	} else {
		if (((gint) y) < 0) {
			gint8 tmp = 0;
			gint8* _tmp30_;
			gint _tmp30__length1;
			gint _tmp30__length2;
			gint8 _tmp31_;
			gint8* _tmp38_;
			gint _tmp38__length1;
			gint _tmp38__length2;
			gint8 _tmp39_;
			gint8 _tmp40_;
			_tmp30_ = self->priv->tiles;
			_tmp30__length1 = self->priv->tiles_length1;
			_tmp30__length2 = self->priv->tiles_length2;
			_tmp31_ = _tmp30_[(x * _tmp30__length2) + 0];
			tmp = _tmp31_;
			{
				guint8 i = 0U;
				i = (guint8) 0;
				{
					gboolean _tmp32_ = FALSE;
					_tmp32_ = TRUE;
					while (TRUE) {
						gint8 _tmp34_;
						gint8* _tmp35_;
						gint _tmp35__length1;
						gint _tmp35__length2;
						gint8* _tmp36_;
						gint _tmp36__length1;
						gint _tmp36__length2;
						gint8 _tmp37_;
						if (!_tmp32_) {
							guint8 _tmp33_;
							_tmp33_ = i;
							i = _tmp33_ + 1;
						}
						_tmp32_ = FALSE;
						_tmp34_ = self->priv->_size;
						if (!(((gint) i) < (_tmp34_ - 1))) {
							break;
						}
						_tmp35_ = self->priv->tiles;
						_tmp35__length1 = self->priv->tiles_length1;
						_tmp35__length2 = self->priv->tiles_length2;
						_tmp36_ = self->priv->tiles;
						_tmp36__length1 = self->priv->tiles_length1;
						_tmp36__length2 = self->priv->tiles_length2;
						_tmp37_ = _tmp36_[(x * _tmp36__length2) + (i + 1)];
						_tmp35_[(x * _tmp35__length2) + i] = _tmp37_;
					}
				}
			}
			_tmp38_ = self->priv->tiles;
			_tmp38__length1 = self->priv->tiles_length1;
			_tmp38__length2 = self->priv->tiles_length2;
			_tmp39_ = self->priv->_size;
			_tmp38_[(x * _tmp38__length2) + (_tmp39_ - 1)] = tmp;
			_tmp40_ = self->priv->_size;
			new_coord = (gint8) (_tmp40_ - 1);
		} else {
			gint8 tmp = 0;
			gint8* _tmp41_;
			gint _tmp41__length1;
			gint _tmp41__length2;
			gint8 _tmp42_;
			gint8 _tmp43_;
			gint8* _tmp50_;
			gint _tmp50__length1;
			gint _tmp50__length2;
			_tmp41_ = self->priv->tiles;
			_tmp41__length1 = self->priv->tiles_length1;
			_tmp41__length2 = self->priv->tiles_length2;
			_tmp42_ = self->priv->_size;
			_tmp43_ = _tmp41_[(x * _tmp41__length2) + (_tmp42_ - 1)];
			tmp = _tmp43_;
			{
				guint8 i = 0U;
				gint8 _tmp44_;
				_tmp44_ = self->priv->_size;
				i = (guint8) (_tmp44_ - 1);
				{
					gboolean _tmp45_ = FALSE;
					_tmp45_ = TRUE;
					while (TRUE) {
						gint8* _tmp47_;
						gint _tmp47__length1;
						gint _tmp47__length2;
						gint8* _tmp48_;
						gint _tmp48__length1;
						gint _tmp48__length2;
						gint8 _tmp49_;
						if (!_tmp45_) {
							guint8 _tmp46_;
							_tmp46_ = i;
							i = _tmp46_ - 1;
						}
						_tmp45_ = FALSE;
						if (!(((gint) i) > 0)) {
							break;
						}
						_tmp47_ = self->priv->tiles;
						_tmp47__length1 = self->priv->tiles_length1;
						_tmp47__length2 = self->priv->tiles_length2;
						_tmp48_ = self->priv->tiles;
						_tmp48__length1 = self->priv->tiles_length1;
						_tmp48__length2 = self->priv->tiles_length2;
						_tmp49_ = _tmp48_[(x * _tmp48__length2) + (i - 1)];
						_tmp47_[(x * _tmp47__length2) + i] = _tmp49_;
					}
				}
			}
			_tmp50_ = self->priv->tiles;
			_tmp50__length1 = self->priv->tiles_length1;
			_tmp50__length2 = self->priv->tiles_length2;
			_tmp50_[(x * _tmp50__length2) + 0] = tmp;
			new_coord = (gint8) 0;
		}
	}
	if (undoing) {
		if (self->priv->moves_count == ((guint) 0)) {
			g_assert_not_reached ();
		}
		if (self->priv->moves_count != G_MAXUINT) {
			guint _tmp51_;
			_tmp51_ = self->priv->moves_count;
			self->priv->moves_count = _tmp51_ - 1;
		}
	} else {
		gint _tmp52_ = 0;
		gint8 _tmp55_ = 0;
		if (move_x_axis) {
			gint _tmp53_ = 0;
			if (((gint) new_coord) == 0) {
				_tmp53_ = -1;
			} else {
				gint8 _tmp54_;
				_tmp54_ = self->priv->_size;
				_tmp53_ = (gint) _tmp54_;
			}
			_tmp52_ = _tmp53_;
		} else {
			_tmp52_ = (gint) x;
		}
		if (move_x_axis) {
			_tmp55_ = y;
		} else {
			gint _tmp56_ = 0;
			if (((gint) new_coord) == 0) {
				_tmp56_ = -1;
			} else {
				gint8 _tmp57_;
				_tmp57_ = self->priv->_size;
				_tmp56_ = (gint) _tmp57_;
			}
			_tmp55_ = (gint8) _tmp56_;
		}
		game_add_move (self, (gint8) _tmp52_, _tmp55_);
		if (self->priv->moves_count != G_MAXUINT) {
			guint _tmp58_;
			_tmp58_ = self->priv->moves_count;
			self->priv->moves_count = _tmp58_ + 1;
		}
	}
	if (((gint) new_coord) == 0) {
		gint8 _tmp60_;
		_tmp60_ = self->priv->_size;
		_tmp59_ = _tmp60_ - 1;
	} else {
		gint8 _tmp61_;
		_tmp61_ = self->priv->_size;
		_tmp59_ = 1 - _tmp61_;
	}
	if (move_x_axis) {
		_tmp62_ = new_coord;
	} else {
		_tmp62_ = x;
	}
	if (move_x_axis) {
		_tmp63_ = y;
	} else {
		_tmp63_ = new_coord;
	}
	if (restarting) {
		_tmp64_ = TRUE;
	} else {
		gboolean _tmp65_ = FALSE;
		if (was_complete) {
			_tmp65_ = undoing;
		} else {
			_tmp65_ = FALSE;
		}
		_tmp64_ = _tmp65_;
	}
	g_signal_emit (self, game_signals[GAME_MOVE_SIGNAL], 0, move_x_axis, (gint8) _tmp59_, _tmp62_, _tmp63_, self->priv->moves_count, _tmp64_);
	_tmp66_ = game_check_complete (&self->priv->tiles, (gint*) (&self->priv->tiles_length1), (gint*) (&self->priv->tiles_length2));
	if (_tmp66_) {
		g_signal_emit (self, game_signals[GAME_COMPLETE_SIGNAL], 0);
	}
}

static gboolean
game_check_complete (gint8** tiles,
                     gint* tiles_length1,
                     gint* tiles_length2)
{
	guint8 size = 0U;
	gint _tmp0_;
	gboolean result;
	_tmp0_ = *tiles_length1;
	size = (guint8) _tmp0_;
	{
		guint8 i = 0U;
		i = (guint8) 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint8 _tmp3_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < (size * size))) {
					break;
				}
				_tmp3_ = (*tiles)[((i % size) * (*tiles_length2)) + (i / size)];
				if (i != ((guint8) _tmp3_)) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gpointer
_game_undo_item_dup0 (gpointer self)
{
	return self ? game_undo_item_dup (self) : NULL;
}

void
game_undo (Game* self)
{
	GameUndoItem* _tmp0_;
	GameType _tmp1_;
	GameUndoItem* _tmp6_;
	GameUndoItem* _tmp7_;
	GameUndoItem* _tmp8_ = NULL;
	GameUndoItem* _tmp9_;
	GameUndoItem* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_game_type;
	if (_tmp1_ == GAME_TYPE_FIFTEEN) {
		GameUndoItem* _tmp2_;
		GameUndoItem* _tmp3_;
		_tmp2_ = self->priv->state;
		_tmp3_ = self->priv->state;
		game_fifteen_move (self, ((GameUndoItem) (*_tmp2_)).x, ((GameUndoItem) (*_tmp3_)).y, TRUE, FALSE);
	} else {
		GameUndoItem* _tmp4_;
		GameUndoItem* _tmp5_;
		_tmp4_ = self->priv->state;
		_tmp5_ = self->priv->state;
		game_sixteen_move (self, ((GameUndoItem) (*_tmp4_)).x, ((GameUndoItem) (*_tmp5_)).y, TRUE, FALSE);
	}
	_tmp6_ = self->priv->previous_state;
	_tmp7_ = _game_undo_item_dup0 (_tmp6_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp7_;
	_tmp9_ = self->priv->state;
	if (_tmp9_ == NULL) {
		_tmp8_ = NULL;
	} else {
		GameUndoItem* _tmp10_;
		GameUndoItem* _tmp11_;
		_tmp10_ = self->priv->state;
		_tmp11_ = ((GameUndoItem) (*_tmp10_)).previous;
		_tmp8_ = _tmp11_;
	}
	_tmp12_ = _game_undo_item_dup0 (_tmp8_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp12_;
}

void
game_restart (Game* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		GameUndoItem* _tmp0_;
		GameType _tmp1_;
		GameUndoItem* _tmp6_;
		GameUndoItem* _tmp7_;
		GameUndoItem* _tmp8_ = NULL;
		GameUndoItem* _tmp9_;
		GameUndoItem* _tmp12_;
		_tmp0_ = self->priv->state;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = self->priv->_game_type;
		if (_tmp1_ == GAME_TYPE_FIFTEEN) {
			GameUndoItem* _tmp2_;
			GameUndoItem* _tmp3_;
			_tmp2_ = self->priv->state;
			_tmp3_ = self->priv->state;
			game_fifteen_move (self, ((GameUndoItem) (*_tmp2_)).x, ((GameUndoItem) (*_tmp3_)).y, TRUE, TRUE);
		} else {
			GameUndoItem* _tmp4_;
			GameUndoItem* _tmp5_;
			_tmp4_ = self->priv->state;
			_tmp5_ = self->priv->state;
			game_sixteen_move (self, ((GameUndoItem) (*_tmp4_)).x, ((GameUndoItem) (*_tmp5_)).y, TRUE, TRUE);
		}
		_tmp6_ = self->priv->previous_state;
		_tmp7_ = _game_undo_item_dup0 (_tmp6_);
		_game_undo_item_free0 (self->priv->state);
		self->priv->state = _tmp7_;
		_tmp9_ = self->priv->state;
		if (_tmp9_ == NULL) {
			_tmp8_ = NULL;
		} else {
			GameUndoItem* _tmp10_;
			GameUndoItem* _tmp11_;
			_tmp10_ = self->priv->state;
			_tmp11_ = ((GameUndoItem) (*_tmp10_)).previous;
			_tmp8_ = _tmp11_;
		}
		_tmp12_ = _game_undo_item_dup0 (_tmp8_);
		_game_undo_item_free0 (self->priv->previous_state);
		self->priv->previous_state = _tmp12_;
	}
}

static void
game_add_move (Game* self,
               gint8 x_gap,
               gint8 y_gap)
{
	GameUndoItem* _tmp0_ = NULL;
	GameUndoItem* _tmp1_;
	GameUndoItem* _tmp3_;
	GameUndoItem* _tmp4_;
	GameUndoItem* _tmp5_;
	GameUndoItem _tmp6_ = {0};
	GameUndoItem _tmp7_;
	GameUndoItem* _tmp8_;
	GameUndoItem* _tmp9_;
	GameUndoItem* _tmp10_;
	GameUndoItem* _tmp11_;
	GameUndoItem* _tmp12_;
	GameUndoItem* _tmp13_;
	GameUndoItem* _tmp14_;
	GameUndoItem* _tmp15_;
	GameUndoItem* _tmp16_;
	GameUndoItem _tmp17_ = {0};
	GameUndoItem _tmp18_;
	GameUndoItem* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->state;
	if (_tmp1_ == NULL) {
		_tmp0_ = NULL;
	} else {
		GameUndoItem* _tmp2_;
		_tmp2_ = self->priv->state;
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _game_undo_item_dup0 (_tmp0_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp3_;
	_tmp4_ = self->priv->previous_state;
	_tmp5_ = _game_undo_item_dup0 (_tmp4_);
	memset (&_tmp6_, 0, sizeof (GameUndoItem));
	_tmp6_.x = x_gap;
	_tmp6_.y = y_gap;
	_game_undo_item_free0 (_tmp6_.next);
	_tmp6_.next = NULL;
	_game_undo_item_free0 (_tmp6_.previous);
	_tmp6_.previous = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = _game_undo_item_dup0 (&_tmp7_);
	_game_undo_item_free0 (self->priv->state);
	self->priv->state = _tmp8_;
	game_undo_item_destroy (&_tmp7_);
	_tmp9_ = self->priv->previous_state;
	if (_tmp9_ == NULL) {
		return;
	}
	_tmp10_ = self->priv->previous_state;
	_tmp11_ = self->priv->previous_state;
	_tmp12_ = self->priv->state;
	_tmp13_ = _game_undo_item_dup0 (_tmp12_);
	_tmp14_ = self->priv->previous_state;
	_tmp15_ = ((GameUndoItem) (*_tmp14_)).previous;
	_tmp16_ = _game_undo_item_dup0 (_tmp15_);
	memset (&_tmp17_, 0, sizeof (GameUndoItem));
	_tmp17_.x = ((GameUndoItem) (*_tmp10_)).x;
	_tmp17_.y = ((GameUndoItem) (*_tmp11_)).y;
	_game_undo_item_free0 (_tmp17_.next);
	_tmp17_.next = _tmp13_;
	_game_undo_item_free0 (_tmp17_.previous);
	_tmp17_.previous = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp19_ = _game_undo_item_dup0 (&_tmp18_);
	_game_undo_item_free0 (self->priv->previous_state);
	self->priv->previous_state = _tmp19_;
	game_undo_item_destroy (&_tmp18_);
}

gint8
game_get_size (Game* self)
{
	gint8 result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size;
	return result;
}

static void
game_set_size (Game* self,
               gint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_size = value;
}

GameType
game_get_game_type (Game* self)
{
	GameType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_game_type;
	return result;
}

static void
game_set_game_type (Game* self,
                    GameType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_game_type = value;
}

static void
g_cclosure_user_marshal_VOID__BOOLEAN_CHAR_CHAR_CHAR_UINT_BOOLEAN (GClosure * closure,
                                                                   GValue * return_value,
                                                                   guint n_param_values,
                                                                   const GValue * param_values,
                                                                   gpointer invocation_hint,
                                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOOLEAN_CHAR_CHAR_CHAR_UINT_BOOLEAN) (gpointer data1, gboolean arg_1, gint8 arg_2, gint8 arg_3, gint8 arg_4, guint arg_5, gboolean arg_6, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_CHAR_CHAR_CHAR_UINT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 7);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_CHAR_CHAR_CHAR_UINT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_char (param_values + 2), g_value_get_char (param_values + 3), g_value_get_char (param_values + 4), g_value_get_uint (param_values + 5), g_value_get_boolean (param_values + 6), data2);
}

static void
g_cclosure_user_marshal_VOID__ENUM_BOOLEAN (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_BOOLEAN) (gpointer data1, gint arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
game_undo_item_copy (const GameUndoItem* self,
                     GameUndoItem* dest)
{
	GameUndoItem* _tmp0_;
	GameUndoItem* _tmp1_;
	GameUndoItem* _tmp2_;
	GameUndoItem* _tmp3_;
	(*dest).x = (*self).x;
	(*dest).y = (*self).y;
	_tmp0_ = (*self).next;
	_tmp1_ = _game_undo_item_dup0 (_tmp0_);
	_game_undo_item_free0 ((*dest).next);
	(*dest).next = _tmp1_;
	_tmp2_ = (*self).previous;
	_tmp3_ = _game_undo_item_dup0 (_tmp2_);
	_game_undo_item_free0 ((*dest).previous);
	(*dest).previous = _tmp3_;
}

static void
game_undo_item_destroy (GameUndoItem* self)
{
	_game_undo_item_free0 ((*self).next);
	_game_undo_item_free0 ((*self).previous);
}

static GameUndoItem*
game_undo_item_dup (const GameUndoItem* self)
{
	GameUndoItem* dup;
	dup = g_new0 (GameUndoItem, 1);
	game_undo_item_copy (self, dup);
	return dup;
}

static void
game_undo_item_free (GameUndoItem* self)
{
	game_undo_item_destroy (self);
	g_free (self);
}

static GType
game_undo_item_get_type_once (void)
{
	GType game_undo_item_type_id;
	game_undo_item_type_id = g_boxed_type_register_static ("GameUndoItem", (GBoxedCopyFunc) game_undo_item_dup, (GBoxedFreeFunc) game_undo_item_free);
	return game_undo_item_type_id;
}

static GType
game_undo_item_get_type (void)
{
	static volatile gsize game_undo_item_type_id__once = 0;
	if (g_once_init_enter (&game_undo_item_type_id__once)) {
		GType game_undo_item_type_id;
		game_undo_item_type_id = game_undo_item_get_type_once ();
		g_once_init_leave (&game_undo_item_type_id__once, game_undo_item_type_id);
	}
	return game_undo_item_type_id__once;
}

static GObject *
game_constructor (GType type,
                  guint n_construct_properties,
                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Game * self;
	parent_class = G_OBJECT_CLASS (game_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			GameType _tmp2_;
			gint8 _tmp3_;
			gint8* _tmp4_ = NULL;
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			if (!_tmp0_) {
				gboolean _tmp1_;
				_tmp1_ = game_check_complete (&self->priv->tiles, (gint*) (&self->priv->tiles_length1), (gint*) (&self->priv->tiles_length2));
				if (!_tmp1_) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->_game_type;
			_tmp3_ = self->priv->_size;
			game_generate_game (_tmp2_, _tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
			self->priv->tiles = (g_free (self->priv->tiles), NULL);
			self->priv->tiles = _tmp4_;
			self->priv->tiles_length1 = _tmp5_;
			self->priv->tiles_length2 = _tmp6_;
		}
	}
	return obj;
}

static void
game_class_init (GameClass * klass,
                 gpointer klass_data)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SIZE_PROPERTY, game_properties[GAME_SIZE_PROPERTY] = g_param_spec_char ("size", "size", "size", G_MININT8, G_MAXINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_GAME_TYPE_PROPERTY, game_properties[GAME_GAME_TYPE_PROPERTY] = g_param_spec_enum ("game-type", "game-type", "game-type", TYPE_GAME_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	game_signals[GAME_COMPLETE_SIGNAL] = g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_MOVE_SIGNAL] = g_signal_new ("move", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_CHAR_CHAR_CHAR_UINT_BOOLEAN, G_TYPE_NONE, 6, G_TYPE_BOOLEAN, G_TYPE_CHAR, G_TYPE_CHAR, G_TYPE_CHAR, G_TYPE_UINT, G_TYPE_BOOLEAN);
	game_signals[GAME_BAD_CLICK_SIGNAL] = g_signal_new ("bad-click", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_BOOLEAN, G_TYPE_NONE, 2, GAME_TYPE_BAD_CLICK, G_TYPE_BOOLEAN);
}

static void
game_instance_init (Game * self,
                    gpointer klass)
{
	self->priv = game_get_instance_private (self);
	self->priv->state = NULL;
	self->priv->previous_state = NULL;
	self->priv->moves_count = (guint) 0;
	self->priv->x_gap = (gint8) 0;
	self->priv->y_gap = (gint8) 0;
}

static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	self->priv->tiles = (g_free (self->priv->tiles), NULL);
	_game_undo_item_free0 (self->priv->state);
	_game_undo_item_free0 (self->priv->previous_state);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}

static GType
game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
	GType game_type_id;
	game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
	Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
	return game_type_id;
}

GType
game_get_type (void)
{
	static volatile gsize game_type_id__once = 0;
	if (g_once_init_enter (&game_type_id__once)) {
		GType game_type_id;
		game_type_id = game_get_type_once ();
		g_once_init_leave (&game_type_id__once, game_type_id);
	}
	return game_type_id__once;
}

static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		g_value_set_char (value, game_get_size (self));
		break;
		case GAME_GAME_TYPE_PROPERTY:
		g_value_set_enum (value, game_get_game_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_SIZE_PROPERTY:
		game_set_size (self, g_value_get_char (value));
		break;
		case GAME_GAME_TYPE_PROPERTY:
		game_set_game_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

