/* new-game-screen.c generated by valac 0.56.3, the Vala compiler
 * generated from new-game-screen.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of a GNOME game

   Copyright (C) 2015-2016 – Arnaud Bonatti <arnaud.bonatti@gmail.com>

   This application is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this application.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_NEW_GAME_SCREEN (new_game_screen_get_type ())
#define NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreen))
#define NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))
#define IS_NEW_GAME_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_GAME_SCREEN))
#define IS_NEW_GAME_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_GAME_SCREEN))
#define NEW_GAME_SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_GAME_SCREEN, NewGameScreenClass))

typedef struct _NewGameScreen NewGameScreen;
typedef struct _NewGameScreenClass NewGameScreenClass;
typedef struct _NewGameScreenPrivate NewGameScreenPrivate;
enum  {
	NEW_GAME_SCREEN_0_PROPERTY,
	NEW_GAME_SCREEN_NUM_PROPERTIES
};
static GParamSpec* new_game_screen_properties[NEW_GAME_SCREEN_NUM_PROPERTIES];
typedef enum  {
	NEW_GAME_SCREEN_MENU_BUTTON_ONE,
	NEW_GAME_SCREEN_MENU_BUTTON_TWO
} NewGameScreenMenuButton;

#define NEW_GAME_SCREEN_TYPE_MENU_BUTTON (new_game_screen_menu_button_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _NewGameScreen {
	GtkBox parent_instance;
	NewGameScreenPrivate * priv;
};

struct _NewGameScreenClass {
	GtkBoxClass parent_class;
};

struct _NewGameScreenPrivate {
	GtkModelButton* modelbutton_one;
	GtkModelButton* modelbutton_two;
	GtkMenuButton* menubutton_one;
	GtkMenuButton* menubutton_two;
	GtkBox* games_box;
	GtkBox* options_box;
	GtkLabel* games_label;
	GtkLabel* options_label;
	GtkSeparator* options_separator;
	gboolean phone_size;
	gboolean extra_thin;
	gboolean extra_flat;
};

static gint NewGameScreen_private_offset;
static gpointer new_game_screen_parent_class = NULL;
static AdaptativeWidgetIface * new_game_screen_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType new_game_screen_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NewGameScreen, g_object_unref)
VALA_EXTERN GType new_game_screen_menu_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NewGameScreen* new_game_screen_new (const gchar* modelbutton_one_label,
                                    const gchar* modelbutton_one_action,
                                    const gchar* modelbutton_two_label,
                                    const gchar* modelbutton_two_action);
VALA_EXTERN NewGameScreen* new_game_screen_construct (GType object_type,
                                          const gchar* modelbutton_one_label,
                                          const gchar* modelbutton_one_action,
                                          const gchar* modelbutton_two_label,
                                          const gchar* modelbutton_two_action);
VALA_EXTERN void new_game_screen_update_menubutton_label (NewGameScreen* self,
                                              NewGameScreenMenuButton button,
                                              const gchar* label);
VALA_EXTERN void new_game_screen_update_menubutton_menu (NewGameScreen* self,
                                             NewGameScreenMenuButton button,
                                             GMenu* menu);
VALA_EXTERN void new_game_screen_update_menubutton_sensitivity (NewGameScreen* self,
                                                    NewGameScreenMenuButton button,
                                                    gboolean new_sensitivity);
VALA_EXTERN gchar* new_game_screen_get_size_button_label (gint size);
static void new_game_screen_fix_race (NewGameScreen* self);
static void __lambda14_ (NewGameScreen* self);
static void ___lambda14__gtk_widget_size_allocate (GtkWidget* _sender,
                                            GtkAllocation* allocation,
                                            gpointer self);
static void __lambda15_ (NewGameScreen* self);
static void ___lambda15__gtk_widget_map (GtkWidget* _sender,
                                  gpointer self);
static void new_game_screen_real_set_window_size (AdaptativeWidget* base,
                                           AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_flat (AdaptativeWidgetWindowSize window_size);
static GObject * new_game_screen_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void new_game_screen_finalize (GObject * obj);
static GType new_game_screen_get_type_once (void);

static inline gpointer
new_game_screen_get_instance_private (NewGameScreen* self)
{
	return G_STRUCT_MEMBER_P (self, NewGameScreen_private_offset);
}

static GType
new_game_screen_menu_button_get_type_once (void)
{
	static const GEnumValue values[] = {{NEW_GAME_SCREEN_MENU_BUTTON_ONE, "NEW_GAME_SCREEN_MENU_BUTTON_ONE", "one"}, {NEW_GAME_SCREEN_MENU_BUTTON_TWO, "NEW_GAME_SCREEN_MENU_BUTTON_TWO", "two"}, {0, NULL, NULL}};
	GType new_game_screen_menu_button_type_id;
	new_game_screen_menu_button_type_id = g_enum_register_static ("NewGameScreenMenuButton", values);
	return new_game_screen_menu_button_type_id;
}

GType
new_game_screen_menu_button_get_type (void)
{
	static volatile gsize new_game_screen_menu_button_type_id__once = 0;
	if (g_once_init_enter (&new_game_screen_menu_button_type_id__once)) {
		GType new_game_screen_menu_button_type_id;
		new_game_screen_menu_button_type_id = new_game_screen_menu_button_get_type_once ();
		g_once_init_leave (&new_game_screen_menu_button_type_id__once, new_game_screen_menu_button_type_id);
	}
	return new_game_screen_menu_button_type_id__once;
}

NewGameScreen*
new_game_screen_construct (GType object_type,
                           const gchar* modelbutton_one_label,
                           const gchar* modelbutton_one_action,
                           const gchar* modelbutton_two_label,
                           const gchar* modelbutton_two_action)
{
	NewGameScreen * self = NULL;
	GtkModelButton* _tmp0_;
	GtkModelButton* _tmp1_;
	GtkModelButton* _tmp2_;
	GtkModelButton* _tmp3_;
	g_return_val_if_fail (modelbutton_one_label != NULL, NULL);
	g_return_val_if_fail (modelbutton_one_action != NULL, NULL);
	g_return_val_if_fail (modelbutton_two_label != NULL, NULL);
	g_return_val_if_fail (modelbutton_two_action != NULL, NULL);
	self = (NewGameScreen*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->modelbutton_one;
	g_object_set (_tmp0_, "text", modelbutton_one_label, NULL);
	_tmp1_ = self->priv->modelbutton_two;
	g_object_set (_tmp1_, "text", modelbutton_two_label, NULL);
	_tmp2_ = self->priv->modelbutton_one;
	gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp2_, modelbutton_one_action);
	_tmp3_ = self->priv->modelbutton_two;
	gtk_actionable_set_detailed_action_name ((GtkActionable*) _tmp3_, modelbutton_two_action);
	return self;
}

NewGameScreen*
new_game_screen_new (const gchar* modelbutton_one_label,
                     const gchar* modelbutton_one_action,
                     const gchar* modelbutton_two_label,
                     const gchar* modelbutton_two_action)
{
	return new_game_screen_construct (TYPE_NEW_GAME_SCREEN, modelbutton_one_label, modelbutton_one_action, modelbutton_two_label, modelbutton_two_action);
}

inline void
new_game_screen_update_menubutton_label (NewGameScreen* self,
                                         NewGameScreenMenuButton button,
                                         const gchar* label)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	switch (button) {
		case NEW_GAME_SCREEN_MENU_BUTTON_ONE:
		{
			GtkMenuButton* _tmp0_;
			_tmp0_ = self->priv->menubutton_one;
			gtk_button_set_label ((GtkButton*) _tmp0_, label);
			return;
		}
		case NEW_GAME_SCREEN_MENU_BUTTON_TWO:
		{
			GtkMenuButton* _tmp1_;
			_tmp1_ = self->priv->menubutton_two;
			gtk_button_set_label ((GtkButton*) _tmp1_, label);
			return;
		}
		default:
		break;
	}
}

inline void
new_game_screen_update_menubutton_menu (NewGameScreen* self,
                                        NewGameScreenMenuButton button,
                                        GMenu* menu)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	switch (button) {
		case NEW_GAME_SCREEN_MENU_BUTTON_ONE:
		{
			GtkMenuButton* _tmp0_;
			_tmp0_ = self->priv->menubutton_one;
			gtk_menu_button_set_menu_model (_tmp0_, (GMenuModel*) menu);
			return;
		}
		case NEW_GAME_SCREEN_MENU_BUTTON_TWO:
		{
			GtkMenuButton* _tmp1_;
			_tmp1_ = self->priv->menubutton_two;
			gtk_menu_button_set_menu_model (_tmp1_, (GMenuModel*) menu);
			return;
		}
		default:
		break;
	}
}

inline void
new_game_screen_update_menubutton_sensitivity (NewGameScreen* self,
                                               NewGameScreenMenuButton button,
                                               gboolean new_sensitivity)
{
	g_return_if_fail (self != NULL);
	switch (button) {
		case NEW_GAME_SCREEN_MENU_BUTTON_ONE:
		{
			GtkMenuButton* _tmp0_;
			_tmp0_ = self->priv->menubutton_one;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, new_sensitivity);
			return;
		}
		case NEW_GAME_SCREEN_MENU_BUTTON_TWO:
		{
			GtkMenuButton* _tmp1_;
			_tmp1_ = self->priv->menubutton_two;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, new_sensitivity);
			return;
		}
		default:
		break;
	}
}

inline gchar*
new_game_screen_get_size_button_label (gint size)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf (_ ("Size: %d × %d ▾"), size, size);
	result = _tmp0_;
	return result;
}

static void
__lambda14_ (NewGameScreen* self)
{
	GtkBox* _tmp0_;
	_tmp0_ = self->priv->games_box;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

static void
___lambda14__gtk_widget_size_allocate (GtkWidget* _sender,
                                       GtkAllocation* allocation,
                                       gpointer self)
{
	__lambda14_ ((NewGameScreen*) self);
}

static void
__lambda15_ (NewGameScreen* self)
{
	GtkBox* _tmp0_;
	_tmp0_ = self->priv->games_box;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

static void
___lambda15__gtk_widget_map (GtkWidget* _sender,
                             gpointer self)
{
	__lambda15_ ((NewGameScreen*) self);
}

static void
new_game_screen_fix_race (NewGameScreen* self)
{
	g_return_if_fail (self != NULL);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) ___lambda14__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) ___lambda15__gtk_widget_map, self, 0);
}

static void
new_game_screen_real_set_window_size (AdaptativeWidget* base,
                                      AdaptativeWidgetWindowSize new_size)
{
	NewGameScreen * self;
	gboolean _extra_flat = FALSE;
	gboolean _extra_thin = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _phone_size = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = (NewGameScreen*) base;
	_extra_flat = adaptative_widget_window_size_is_extra_flat (new_size);
	_extra_thin = new_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN;
	if (new_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = new_size == ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT;
	}
	_phone_size = _tmp0_;
	if (_extra_thin == self->priv->extra_thin) {
		_tmp2_ = _phone_size == self->priv->phone_size;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = _extra_flat == self->priv->extra_flat;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	self->priv->extra_thin = _extra_thin;
	self->priv->phone_size = _phone_size;
	self->priv->extra_flat = _extra_flat;
	if (!_extra_thin) {
		_tmp3_ = !_phone_size;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		if (self->priv->extra_flat) {
			GtkLabel* _tmp4_;
			GtkLabel* _tmp5_;
			GtkBox* _tmp6_;
			GtkBox* _tmp7_;
			GtkSeparator* _tmp8_;
			GtkSeparator* _tmp9_;
			_tmp4_ = self->priv->games_label;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->options_label;
			gtk_widget_hide ((GtkWidget*) _tmp5_);
			gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
			_tmp6_ = self->priv->games_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp6_, GTK_ORIENTATION_VERTICAL);
			_tmp7_ = self->priv->options_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp7_, GTK_ORIENTATION_VERTICAL);
			_tmp8_ = self->priv->options_separator;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp8_, GTK_ORIENTATION_VERTICAL);
			_tmp9_ = self->priv->options_separator;
			gtk_widget_show ((GtkWidget*) _tmp9_);
		} else {
			GtkLabel* _tmp10_;
			GtkLabel* _tmp11_;
			GtkSeparator* _tmp12_;
			GtkBox* _tmp13_;
			GtkBox* _tmp14_;
			GtkBox* _tmp15_;
			_tmp10_ = self->priv->games_label;
			gtk_widget_hide ((GtkWidget*) _tmp10_);
			_tmp11_ = self->priv->options_label;
			gtk_widget_hide ((GtkWidget*) _tmp11_);
			_tmp12_ = self->priv->options_separator;
			gtk_widget_hide ((GtkWidget*) _tmp12_);
			gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
			_tmp13_ = self->priv->games_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp13_, GTK_ORIENTATION_HORIZONTAL);
			_tmp14_ = self->priv->options_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp14_, GTK_ORIENTATION_HORIZONTAL);
			_tmp15_ = self->priv->games_box;
			gtk_widget_hide ((GtkWidget*) _tmp15_);
		}
	} else {
		if (_phone_size) {
			GtkLabel* _tmp16_;
			GtkLabel* _tmp17_;
			GtkBox* _tmp18_;
			GtkBox* _tmp19_;
			GtkSeparator* _tmp20_;
			GtkSeparator* _tmp21_;
			_tmp16_ = self->priv->games_label;
			gtk_widget_hide ((GtkWidget*) _tmp16_);
			_tmp17_ = self->priv->options_label;
			gtk_widget_hide ((GtkWidget*) _tmp17_);
			gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
			_tmp18_ = self->priv->games_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp18_, GTK_ORIENTATION_VERTICAL);
			_tmp19_ = self->priv->options_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp19_, GTK_ORIENTATION_VERTICAL);
			_tmp20_ = self->priv->options_separator;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp20_, GTK_ORIENTATION_HORIZONTAL);
			_tmp21_ = self->priv->options_separator;
			gtk_widget_show ((GtkWidget*) _tmp21_);
		} else {
			GtkSeparator* _tmp22_;
			GtkBox* _tmp23_;
			GtkBox* _tmp24_;
			GtkLabel* _tmp25_;
			GtkLabel* _tmp26_;
			_tmp22_ = self->priv->options_separator;
			gtk_widget_hide ((GtkWidget*) _tmp22_);
			gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
			_tmp23_ = self->priv->games_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp23_, GTK_ORIENTATION_VERTICAL);
			_tmp24_ = self->priv->options_box;
			gtk_orientable_set_orientation ((GtkOrientable*) _tmp24_, GTK_ORIENTATION_VERTICAL);
			_tmp25_ = self->priv->games_label;
			gtk_widget_show ((GtkWidget*) _tmp25_);
			_tmp26_ = self->priv->options_label;
			gtk_widget_show ((GtkWidget*) _tmp26_);
		}
	}
	gtk_widget_queue_allocate ((GtkWidget*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
new_game_screen_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NewGameScreen * self;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* gdk_screen = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GdkScreen* _tmp4_;
	parent_class = G_OBJECT_CLASS (new_game_screen_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEW_GAME_SCREEN, NewGameScreen);
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	_tmp1_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/Taquin/ui/new-game-screen.css");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	gdk_screen = _tmp3_;
	_tmp4_ = gdk_screen;
	if (_tmp4_ != NULL) {
		GdkScreen* _tmp5_;
		GtkCssProvider* _tmp6_;
		_tmp5_ = gdk_screen;
		_tmp6_ = css_provider;
		gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	new_game_screen_fix_race (self);
	_g_object_unref0 (gdk_screen);
	_g_object_unref0 (css_provider);
	return obj;
}

static void
new_game_screen_class_init (NewGameScreenClass * klass,
                            gpointer klass_data)
{
	new_game_screen_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NewGameScreen_private_offset);
	G_OBJECT_CLASS (klass)->constructor = new_game_screen_constructor;
	G_OBJECT_CLASS (klass)->finalize = new_game_screen_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Taquin/ui/new-game-screen.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "modelbutton_one", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, modelbutton_one));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "modelbutton_two", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, modelbutton_two));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menubutton_one", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, menubutton_one));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "menubutton_two", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, menubutton_two));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "games_box", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, games_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "options_box", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, options_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "games_label", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, games_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "options_label", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, options_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "options_separator", FALSE, NewGameScreen_private_offset + G_STRUCT_OFFSET (NewGameScreenPrivate, options_separator));
}

static void
new_game_screen_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                  gpointer iface_data)
{
	new_game_screen_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) new_game_screen_real_set_window_size;
}

static void
new_game_screen_instance_init (NewGameScreen * self,
                               gpointer klass)
{
	self->priv = new_game_screen_get_instance_private (self);
	self->priv->phone_size = FALSE;
	self->priv->extra_thin = FALSE;
	self->priv->extra_flat = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
new_game_screen_finalize (GObject * obj)
{
	NewGameScreen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NEW_GAME_SCREEN, NewGameScreen);
	G_OBJECT_CLASS (new_game_screen_parent_class)->finalize (obj);
}

static GType
new_game_screen_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NewGameScreenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) new_game_screen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NewGameScreen), 0, (GInstanceInitFunc) new_game_screen_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) new_game_screen_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType new_game_screen_type_id;
	new_game_screen_type_id = g_type_register_static (gtk_box_get_type (), "NewGameScreen", &g_define_type_info, 0);
	g_type_add_interface_static (new_game_screen_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	NewGameScreen_private_offset = g_type_add_instance_private (new_game_screen_type_id, sizeof (NewGameScreenPrivate));
	return new_game_screen_type_id;
}

GType
new_game_screen_get_type (void)
{
	static volatile gsize new_game_screen_type_id__once = 0;
	if (g_once_init_enter (&new_game_screen_type_id__once)) {
		GType new_game_screen_type_id;
		new_game_screen_type_id = new_game_screen_get_type_once ();
		g_once_init_leave (&new_game_screen_type_id__once, new_game_screen_type_id);
	}
	return new_game_screen_type_id__once;
}

